/**
 * Interactive setup wizard for creating a new i18next-cli configuration file.
 *
 * This function provides a guided setup experience that:
 * 1. Asks the user for their preferred configuration file type (TypeScript or JavaScript)
 * 2. Collects basic project settings (locales, input patterns, output paths)
 * 3. Detects the project module system (ESM vs CommonJS) for JavaScript files
 * 4. Generates an appropriate configuration file with proper syntax
 * 5. Provides helpful defaults for common use cases
 *
 * The generated configuration includes:
 * - Locale specification
 * - Input file patterns for source scanning
 * - Output path templates with placeholders
 * - Proper imports and exports for the detected module system
 * - JSDoc type annotations for JavaScript files
 *
 * @example
 * ```typescript
 * // Run the interactive setup
 * await runInit()
 *
 * // This will create either:
 * // - i18next.config.ts (TypeScript)
 * // - i18next.config.js (JavaScript ESM/CommonJS)
 * ```
 */
export declare function runInit(): Promise<void>;
//# sourceMappingURL=init.d.ts.map