const require_utils = require('./utils-UEfUEvtH.cjs');
const node_path = require_utils.__toESM(require("node:path"));
const node_url = require_utils.__toESM(require("node:url"));
const node_worker_threads = require_utils.__toESM(require("node:worker_threads"));
const debug = require_utils.__toESM(require("debug"));

//#region src/index.ts
const debug$1 = (0, debug.default)(require_utils.PLUGIN_NAME);
const __filename$1 = (0, node_url.fileURLToPath)(require("url").pathToFileURL(__filename).href);
const __dirname$1 = (0, node_path.dirname)(__filename$1);
const ext = (0, node_path.extname)(__filename$1);
function ESLintPlugin(userOptions = {}) {
	const options = require_utils.getOptions(userOptions);
	let worker;
	const filter = require_utils.getFilter(options);
	let eslintInstance;
	let formatter;
	let outputFixes;
	return {
		name: require_utils.PLUGIN_NAME,
		apply(config, { command }) {
			debug$1("==== apply hook ====");
			if (config.mode === "test" || process.env.VITEST) return options.test;
			const shouldApply = command === "serve" && options.dev || command === "build" && options.build;
			debug$1(`should apply this plugin: ${shouldApply}`);
			return shouldApply;
		},
		async buildStart() {
			debug$1("==== buildStart hook ====");
			if (options.lintInWorker) {
				if (worker) return;
				debug$1("Initialize worker");
				worker = new node_worker_threads.Worker((0, node_path.resolve)(__dirname$1, `worker${ext}`), { workerData: { options } });
				return;
			}
			debug$1("Initial ESLint");
			const result = await require_utils.initializeESLint(options);
			eslintInstance = result.eslintInstance;
			formatter = result.formatter;
			outputFixes = result.outputFixes;
			if (options.lintOnStart) {
				debug$1("Lint on start");
				await require_utils.lintFiles({
					files: options.include,
					eslintInstance,
					formatter,
					outputFixes,
					options
				}, this);
			}
		},
		async transform(_, id) {
			debug$1("==== transform hook ====");
			if (worker) return worker.postMessage(id);
			debug$1(`id: ${id}`);
			const shouldIgnore = await require_utils.shouldIgnoreModule(id, filter, eslintInstance);
			debug$1(`should ignore: ${shouldIgnore}`);
			if (shouldIgnore) return;
			const filePath = require_utils.getFilePath(id);
			debug$1(`filePath: ${filePath}`);
			return await require_utils.lintFiles({
				files: options.lintDirtyOnly ? filePath : options.include,
				eslintInstance,
				formatter,
				outputFixes,
				options
			}, this);
		},
		async buildEnd() {
			debug$1("==== buildEnd hook ====");
			if (worker) await worker.terminate();
		}
	};
}

//#endregion
module.exports = ESLintPlugin;