const selectorsToWarn = [':first-child', ':nth-child'];
const hasWarned = {};
const warn = (str, ...args) => console.error(`
 ██████╗ ██████╗ ███╗   ███╗██████╗ ██╗██╗     ███████╗██████╗
██╔════╝██╔═══██╗████╗ ████║██╔══██╗██║██║     ██╔════╝██╔══██╗
██║     ██║   ██║██╔████╔██║██████╔╝██║██║     █████╗  ██║  ██║
██║     ██║   ██║██║╚██╔╝██║██╔═══╝ ██║██║     ██╔══╝  ██║  ██║
╚██████╗╚██████╔╝██║ ╚═╝ ██║██║     ██║███████╗███████╗██████╔╝
 ╚═════╝ ╚═════╝ ╚═╝     ╚═╝╚═╝     ╚═╝╚══════╝╚══════╝╚═════╝

  @compiled/react/runtime - DEV WARNING

  ${str}
`, ...args);
export const analyzeCssInDev = (sheet) => {
    if (hasWarned[sheet]) {
        return;
    }
    const shouldWarnAboutSelectors = selectorsToWarn.map((selector) => sheet.includes(selector)).filter(Boolean).length > 0;
    if (shouldWarnAboutSelectors) {
        warn(`Selectors "${selectorsToWarn.join(', ')}" are dangerous to use when server side rendering.
  Alternatively try and use ":nth-of-type", or placing data attributes and targetting those instead.
  Read https://compiledcssinjs.com/docs/server-side-rendering for more advice.`);
    }
    hasWarned[sheet] = true;
};
//# sourceMappingURL=dev-warnings.js.map