//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

extern "C" {
    /// kCTFontSymbolicTrait
    ///
    /// Dictionary key to access the symbolic traits value.
    ///
    /// Use this key to access the symbolic traits value from the font traits dictionary. The value is returned as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontsymbolictrait?language=objc)
    pub static kCTFontSymbolicTrait: &'static CFString;
}

extern "C" {
    /// kCTFontWeightTrait
    ///
    /// Dictionary key to access the weight trait value.
    ///
    /// Use this key to access the normalized weight trait from the font traits dictionary. The value returned is a CFNumberRef representing a float value between -1.0 and 1.0 for normalized weight. The value of 0.0 corresponds to the regular or medium font weight.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontweighttrait?language=objc)
    pub static kCTFontWeightTrait: &'static CFString;
}

extern "C" {
    /// kCTFontWidthTrait
    ///
    /// Dictionary key to access the width (condense/expand) trait value.
    ///
    /// Use this key to access the normalized proportion trait from the font traits dictionary. This value corresponds to the relative inter-glyph spacing for a given font. The value returned is a CFNumberRef representing a float between -1.0 and 1.0. The value of 0.0 corresponds to regular glyph spacing while negative values represent condensed glyph spacing.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontwidthtrait?language=objc)
    pub static kCTFontWidthTrait: &'static CFString;
}

extern "C" {
    /// kCTFontSlantTrait
    ///
    /// Dictionary key to access the slant trait value.
    ///
    /// Use this key to access the normalized slant angle from the font traits dictionary. The value returned is a CFNumberRef representing a float value between -1.0 and 1.0 for normalized slant angle. The value or 0.0 corresponds to 0 degree clockwise rotation from the vertical and 1.0 corresponds to 30 degrees clockwise rotation.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontslanttrait?language=objc)
    pub static kCTFontSlantTrait: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontclassmaskshift?language=objc)
pub const kCTFontClassMaskShift: c_uint = 28;

/// Symbolic representation of stylistic font attributes.
///
/// CTFontSymbolicTraits symbolically describes stylistic aspects of a font. The top 4 bits is used to describe appearance of the font while the lower 28 bits for typeface. The font appearance information represented by the upper 4 bits can be used for stylistic font matching.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontsymbolictraits?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontSymbolicTraits(pub u32);
bitflags::bitflags! {
    impl CTFontSymbolicTraits: u32 {
        #[doc(alias = "kCTFontTraitItalic")]
        const TraitItalic = 1<<0;
        #[doc(alias = "kCTFontTraitBold")]
        const TraitBold = 1<<1;
        #[doc(alias = "kCTFontTraitExpanded")]
        const TraitExpanded = 1<<5;
        #[doc(alias = "kCTFontTraitCondensed")]
        const TraitCondensed = 1<<6;
        #[doc(alias = "kCTFontTraitMonoSpace")]
        const TraitMonoSpace = 1<<10;
        #[doc(alias = "kCTFontTraitVertical")]
        const TraitVertical = 1<<11;
        #[doc(alias = "kCTFontTraitUIOptimized")]
        const TraitUIOptimized = 1<<12;
        #[doc(alias = "kCTFontTraitColorGlyphs")]
        const TraitColorGlyphs = 1<<13;
        #[doc(alias = "kCTFontTraitComposite")]
        const TraitComposite = 1<<14;
        #[doc(alias = "kCTFontTraitClassMask")]
        const TraitClassMask = 15<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontItalicTrait")]
        const ItalicTrait = CTFontSymbolicTraits::TraitItalic.0;
        #[doc(alias = "kCTFontBoldTrait")]
        const BoldTrait = CTFontSymbolicTraits::TraitBold.0;
        #[doc(alias = "kCTFontExpandedTrait")]
        const ExpandedTrait = CTFontSymbolicTraits::TraitExpanded.0;
        #[doc(alias = "kCTFontCondensedTrait")]
        const CondensedTrait = CTFontSymbolicTraits::TraitCondensed.0;
        #[doc(alias = "kCTFontMonoSpaceTrait")]
        const MonoSpaceTrait = CTFontSymbolicTraits::TraitMonoSpace.0;
        #[doc(alias = "kCTFontVerticalTrait")]
        const VerticalTrait = CTFontSymbolicTraits::TraitVertical.0;
        #[doc(alias = "kCTFontUIOptimizedTrait")]
        const UIOptimizedTrait = CTFontSymbolicTraits::TraitUIOptimized.0;
        #[doc(alias = "kCTFontColorGlyphsTrait")]
        const ColorGlyphsTrait = CTFontSymbolicTraits::TraitColorGlyphs.0;
        #[doc(alias = "kCTFontCompositeTrait")]
        const CompositeTrait = CTFontSymbolicTraits::TraitComposite.0;
        #[doc(alias = "kCTFontClassMaskTrait")]
        const ClassMaskTrait = CTFontSymbolicTraits::TraitClassMask.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontSymbolicTraits {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontSymbolicTraits {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Stylistic class values.
///
/// CTFontStylisticClass classifies certain stylistic qualities of the font. These values correspond closely to the font class values in the OpenType 'OS/2' table. The class values are bundled in the upper four bits of the CTFontSymbolicTraits and can be obtained via the kCTFontTraitClassMask.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontstylisticclass?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontStylisticClass(pub u32);
bitflags::bitflags! {
    impl CTFontStylisticClass: u32 {
        #[doc(alias = "kCTFontClassUnknown")]
        const ClassUnknown = 0<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassOldStyleSerifs")]
        const ClassOldStyleSerifs = 1<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassTransitionalSerifs")]
        const ClassTransitionalSerifs = 2<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassModernSerifs")]
        const ClassModernSerifs = 3<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassClarendonSerifs")]
        const ClassClarendonSerifs = 4<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassSlabSerifs")]
        const ClassSlabSerifs = 5<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassFreeformSerifs")]
        const ClassFreeformSerifs = 7<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassSansSerif")]
        const ClassSansSerif = 8<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassOrnamentals")]
        const ClassOrnamentals = 9<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassScripts")]
        const ClassScripts = 10<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontClassSymbolic")]
        const ClassSymbolic = 12<<kCTFontClassMaskShift;
        #[doc(alias = "kCTFontUnknownClass")]
        const UnknownClass = CTFontStylisticClass::ClassUnknown.0;
        #[doc(alias = "kCTFontOldStyleSerifsClass")]
        const OldStyleSerifsClass = CTFontStylisticClass::ClassOldStyleSerifs.0;
        #[doc(alias = "kCTFontTransitionalSerifsClass")]
        const TransitionalSerifsClass = CTFontStylisticClass::ClassTransitionalSerifs.0;
        #[doc(alias = "kCTFontModernSerifsClass")]
        const ModernSerifsClass = CTFontStylisticClass::ClassModernSerifs.0;
        #[doc(alias = "kCTFontClarendonSerifsClass")]
        const ClarendonSerifsClass = CTFontStylisticClass::ClassClarendonSerifs.0;
        #[doc(alias = "kCTFontSlabSerifsClass")]
        const SlabSerifsClass = CTFontStylisticClass::ClassSlabSerifs.0;
        #[doc(alias = "kCTFontFreeformSerifsClass")]
        const FreeformSerifsClass = CTFontStylisticClass::ClassFreeformSerifs.0;
        #[doc(alias = "kCTFontSansSerifClass")]
        const SansSerifClass = CTFontStylisticClass::ClassSansSerif.0;
        #[doc(alias = "kCTFontOrnamentalsClass")]
        const OrnamentalsClass = CTFontStylisticClass::ClassOrnamentals.0;
        #[doc(alias = "kCTFontScriptsClass")]
        const ScriptsClass = CTFontStylisticClass::ClassScripts.0;
        #[doc(alias = "kCTFontSymbolicClass")]
        const SymbolicClass = CTFontStylisticClass::ClassSymbolic.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontStylisticClass {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontStylisticClass {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
