/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.WriteFinishedEvent;

class UndefLengthOutputStream
extends FilterOutputStream {
    private boolean closed = false;
    ExchangeImpl t;

    UndefLengthOutputStream(ExchangeImpl exchangeImpl, OutputStream outputStream) {
        super(outputStream);
        this.t = exchangeImpl;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        this.out.write(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        LeftOverInputStream leftOverInputStream = this.t.getOriginalInputStream();
        if (!leftOverInputStream.isClosed()) {
            try {
                leftOverInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WriteFinishedEvent writeFinishedEvent = new WriteFinishedEvent(this.t);
        this.t.getHttpContext().getServerImpl().addEvent(writeFinishedEvent);
    }
}

