/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.io.IOException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializer;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

@Deprecated
class DBVModelSerializerLegacy
implements DBVModelSerializer {
    private static final Log log = Log.getLog(DBVModelSerializerLegacy.class);

    DBVModelSerializerLegacy() {
    }

    static void serializeContainer(@NotNull XMLBuilder xml, @NotNull DBVContainer object) throws IOException {
        if (!object.hasValuableData()) {
            return;
        }
        try (XMLBuilder.Element ignored = xml.startElement("container");){
            xml.addAttribute("name", object.getName());
            for (DBVContainer container : object.getContainers()) {
                DBVModelSerializerLegacy.serializeContainer(xml, container);
            }
            for (DBVEntity entity : object.getEntities()) {
                if (!entity.hasValuableData()) continue;
                DBVModelSerializerLegacy.serializeEntity(xml, entity);
            }
        }
    }

    private static void serializeEntity(@NotNull XMLBuilder xml, @NotNull DBVEntity entity) throws IOException {
        block105: {
            try (XMLBuilder.Element ignored0 = xml.startElement("entity");){
                XMLBuilder.Element ignored;
                xml.addAttribute("name", entity.getName());
                if (!CommonUtils.isEmpty((String)entity.getDescriptionColumnNames())) {
                    xml.addAttribute("description", entity.getDescriptionColumnNames());
                }
                if (!CommonUtils.isEmpty(entity.getProperties())) {
                    for (Map.Entry<String, Object> prop : entity.getProperties().entrySet()) {
                        try (XMLBuilder.Element ignored2 = xml.startElement("property");){
                            xml.addAttribute("name", prop.getKey());
                            xml.addAttribute("value", CommonUtils.toString((Object)prop.getValue()));
                        }
                    }
                }
                for (DBVEntityAttribute attr : CommonUtils.safeCollection(entity.getEntityAttributes())) {
                    if (!attr.hasValuableData()) continue;
                    XMLBuilder.Element ignored3 = xml.startElement("attribute");
                    try {
                        block104: {
                            xml.addAttribute("name", attr.getName());
                            DBVTransformSettings transformSettings = attr.getTransformSettings();
                            if (transformSettings != null && transformSettings.hasValuableData()) {
                                try (XMLBuilder.Element ignored4 = xml.startElement("transform");){
                                    Object id2;
                                    XMLBuilder.Element ignored5;
                                    if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())) {
                                        xml.addAttribute("custom", transformSettings.getCustomTransformer());
                                    }
                                    for (String id2 : CommonUtils.safeCollection(transformSettings.getIncludedTransformers())) {
                                        ignored5 = xml.startElement("include");
                                        try {
                                            xml.addAttribute("id", id2);
                                        }
                                        finally {
                                            if (ignored5 == null) continue;
                                            ignored5.close();
                                        }
                                    }
                                    for (Object id2 : CommonUtils.safeCollection(transformSettings.getExcludedTransformers())) {
                                        ignored5 = xml.startElement("exclude");
                                        try {
                                            xml.addAttribute("id", (String)id2);
                                        }
                                        finally {
                                            if (ignored5 == null) continue;
                                            ignored5.close();
                                        }
                                    }
                                    Map<String, Object> map = transformSettings.getTransformOptions();
                                    if (map == null) break block104;
                                    id2 = map.entrySet().iterator();
                                    while (id2.hasNext()) {
                                        Map.Entry prop = (Map.Entry)id2.next();
                                        XMLBuilder.Element ignored52 = xml.startElement("property");
                                        try {
                                            if (prop.getValue() == null) continue;
                                            xml.addAttribute("name", (String)prop.getKey());
                                            xml.addAttribute("value", CommonUtils.toString(prop.getValue()));
                                        }
                                        finally {
                                            if (ignored52 == null) continue;
                                            ignored52.close();
                                        }
                                    }
                                }
                            }
                        }
                        if (CommonUtils.isEmpty(attr.getProperties())) continue;
                        for (Map.Entry entry : attr.getProperties().entrySet()) {
                            XMLBuilder.Element ignored2 = xml.startElement("property");
                            try {
                                xml.addAttribute("name", (String)entry.getKey());
                                xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                            }
                            finally {
                                if (ignored2 == null) continue;
                                ignored2.close();
                            }
                        }
                    }
                    finally {
                        if (ignored3 == null) continue;
                        ignored3.close();
                    }
                }
                for (DBVEntityConstraint c : CommonUtils.safeCollection(entity.getConstraints())) {
                    if (!c.hasAttributes()) continue;
                    ignored = xml.startElement("constraint");
                    try {
                        xml.addAttribute("name", c.getName());
                        xml.addAttribute("type", c.getConstraintType().getName());
                        for (DBVEntityConstraintColumn cc : CommonUtils.safeCollection(c.getAttributeReferences(null))) {
                            XMLBuilder.Element element = xml.startElement("attribute");
                            try {
                                xml.addAttribute("name", cc.getAttributeName());
                            }
                            finally {
                                if (element == null) continue;
                                element.close();
                            }
                        }
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                for (DBVEntityForeignKey fk : CommonUtils.safeCollection(entity.getForeignKeys())) {
                    ignored = xml.startElement("association");
                    try {
                        DBSEntityConstraint refConstraint;
                        DBSEntity refEntity = fk.getAssociatedEntity();
                        if (refEntity != null) {
                            xml.addAttribute("entity", DBUtils.getObjectFullId(refEntity));
                        }
                        if ((refConstraint = fk.getReferencedConstraint()) != null) {
                            xml.addAttribute("constraint", refConstraint.getName());
                        }
                        for (DBVEntityForeignKeyColumn cc : CommonUtils.safeCollection(fk.getAttributes())) {
                            XMLBuilder.Element ignored2 = xml.startElement("attribute");
                            try {
                                xml.addAttribute("name", cc.getAttributeName());
                            }
                            finally {
                                if (ignored2 == null) continue;
                                ignored2.close();
                            }
                        }
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                if (CommonUtils.isEmpty(entity.getColorOverrides())) break block105;
                try (XMLBuilder.Element ignored3 = xml.startElement("colors");){
                    for (DBVColorOverride color : entity.getColorOverrides()) {
                        XMLBuilder.Element ignored2 = xml.startElement("color");
                        try {
                            xml.addAttribute("name", color.getAttributeName());
                            xml.addAttribute("operator", color.getOperator().name());
                            if (color.isRange()) {
                                xml.addAttribute("range", true);
                            }
                            if (color.isSingleColumn()) {
                                xml.addAttribute("singleColumn", true);
                            }
                            if (color.getColorForeground() != null) {
                                xml.addAttribute("foreground", color.getColorForeground());
                            }
                            if (color.getColorForeground2() != null) {
                                xml.addAttribute("foreground2", color.getColorForeground2());
                            }
                            if (color.getColorBackground() != null) {
                                xml.addAttribute("background", color.getColorBackground());
                            }
                            if (color.getColorBackground2() != null) {
                                xml.addAttribute("background2", color.getColorBackground2());
                            }
                            if (ArrayUtils.isEmpty((Object[])color.getAttributeValues())) continue;
                            for (Object value : color.getAttributeValues()) {
                                if (value == null) continue;
                                try (XMLBuilder.Element ignored32 = xml.startElement("value");){
                                    xml.addText((CharSequence)GeneralUtils.serializeObject(value));
                                }
                            }
                        }
                        finally {
                            if (ignored2 == null) continue;
                            ignored2.close();
                        }
                    }
                }
            }
        }
    }

    static class ModelParser
    implements SAXListener {
        private final DBVContainer rootContainer;
        private DBVContainer curContainer = null;
        private DBVEntity curEntity = null;
        private DBVEntityAttribute curAttribute = null;
        private DBVTransformSettings curTransformSettings = null;
        private DBVEntityConstraint curConstraint;
        private DBVColorOverride curColor;
        private boolean colorValue = false;

        public ModelParser(@NotNull DBVContainer rootContainer) {
            this.rootContainer = rootContainer;
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) throws XMLException {
            switch (localName) {
                case "container": {
                    if (this.curContainer == null) {
                        this.curContainer = this.rootContainer;
                        break;
                    }
                    DBVContainer container = new DBVContainer(this.curContainer, attributes.getValue("name"));
                    this.curContainer.addContainer(container);
                    this.curContainer = container;
                    break;
                }
                case "entity": {
                    this.curEntity = new DBVEntity(this.curContainer, attributes.getValue("name"), attributes.getValue("description"));
                    this.curContainer.addEntity(this.curEntity);
                    break;
                }
                case "property": {
                    if (this.curTransformSettings != null) {
                        this.curTransformSettings.setTransformOption(attributes.getValue("name"), attributes.getValue("value"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        this.curAttribute.setProperty(attributes.getValue("name"), attributes.getValue("value"));
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setProperty(attributes.getValue("name"), attributes.getValue("value"));
                    break;
                }
                case "constraint": {
                    if (this.curEntity == null) break;
                    this.curConstraint = new DBVEntityConstraint(this.curEntity, DBSEntityConstraintType.VIRTUAL_KEY, attributes.getValue("name"));
                    this.curEntity.addConstraint(this.curConstraint, false);
                    break;
                }
                case "attribute": {
                    if (this.curConstraint != null) {
                        this.curConstraint.addAttribute(attributes.getValue("name"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        DBVEntityAttribute childAttribute = new DBVEntityAttribute(this.curEntity, this.curAttribute, attributes.getValue("name"));
                        this.curAttribute.addChild(childAttribute);
                        this.curAttribute = childAttribute;
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curAttribute = new DBVEntityAttribute(this.curEntity, null, attributes.getValue("name"));
                    this.curEntity.addVirtualAttribute(this.curAttribute, false);
                    break;
                }
                case "transform": {
                    this.curTransformSettings = new DBVTransformSettings();
                    this.curTransformSettings.setCustomTransformer(attributes.getValue("custom"));
                    if (this.curAttribute != null) {
                        this.curAttribute.setTransformSettings(this.curTransformSettings);
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setTransformSettings(this.curTransformSettings);
                    break;
                }
                case "include": 
                case "exclude": {
                    String transformerId = attributes.getValue("id");
                    if (this.curTransformSettings == null || CommonUtils.isEmpty((String)transformerId)) break;
                    DBDAttributeTransformerDescriptor transformer = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformerId);
                    if (transformer == null) {
                        log.warn("Transformer '" + transformerId + "' not found");
                        break;
                    }
                    this.curTransformSettings.enableTransformer(transformer, "include".equals(localName));
                    break;
                }
                case "color": {
                    if (this.curEntity == null) break;
                    try {
                        this.curColor = new DBVColorOverride(attributes.getValue("name"), DBCLogicalOperator.valueOf(attributes.getValue("operator")), null, attributes.getValue("foreground"), attributes.getValue("background"));
                        this.curColor.setRange(CommonUtils.getBoolean((String)attributes.getValue("range"), (boolean)false));
                        this.curColor.setSingleColumn(CommonUtils.getBoolean((String)attributes.getValue("singleColumn"), (boolean)false));
                        this.curColor.setColorForeground2(attributes.getValue("foreground2"));
                        this.curColor.setColorBackground2(attributes.getValue("background2"));
                        this.curEntity.addColorOverride(this.curColor);
                    }
                    catch (Throwable e) {
                        log.warn("Error reading color settings", e);
                    }
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = true;
                }
            }
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
            if (this.colorValue) {
                this.curColor.addAttributeValue(GeneralUtils.deserializeObject(data));
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) {
            switch (localName) {
                case "container": {
                    this.curContainer = this.curContainer.getParentObject();
                    break;
                }
                case "entity": {
                    this.curEntity = null;
                    break;
                }
                case "constraint": {
                    this.curConstraint = null;
                    break;
                }
                case "attribute": {
                    if (this.curAttribute == null) break;
                    this.curAttribute = this.curAttribute.getParent();
                    break;
                }
                case "transform": {
                    this.curTransformSettings = null;
                }
                case "color": {
                    this.curColor = null;
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = false;
                }
            }
        }
    }
}

