/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServer;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServerOption;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;

public class DB2RemoteServerOptionCache
extends JDBCObjectCache<DB2RemoteServer, DB2RemoteServerOption> {
    private static String SQL;

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DB2RemoteServer remoteServer) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement(SQL);
        dbStat.setString(1, remoteServer.getName());
        return dbStat;
    }

    protected DB2RemoteServerOption fetchObject(@NotNull JDBCSession session, @NotNull DB2RemoteServer remoteServer, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        return new DB2RemoteServerOption(remoteServer, (ResultSet)resultSet);
    }

    static {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT *");
        sb.append("  FROM SYSCAT.SERVEROPTIONS");
        sb.append(" WHERE SERVERNAME = ?");
        sb.append(" ORDER BY OPTION");
        sb.append(" WITH UR");
        SQL = sb.toString();
    }
}

