/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions.links;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.ui.navigator.actions.links.CreateLinkHandler;
import org.jkiss.dbeaver.ui.navigator.actions.links.CreateLinkedFilesRunnable;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class LinkFileHandler
extends CreateLinkHandler {
    private static final String COMMAND_PARAMETER_LINK_FILE_CONTENTTYPE = "org.jkiss.dbeaver.core.resource.link.file.contenttype";

    @Override
    protected Path[] selectTargets(ExecutionEvent event) {
        String file;
        IContentType contentType;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(shell, 2);
        String contentTypeId = event.getParameter(COMMAND_PARAMETER_LINK_FILE_CONTENTTYPE);
        if (contentTypeId != null && (contentType = Platform.getContentTypeManager().getContentType(contentTypeId)) != null) {
            String[] fileSpecs;
            StringBuilder sb = new StringBuilder();
            for (String extension : fileSpecs = contentType.getFileSpecs(8)) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append('*').append('.').append(extension);
            }
            if (sb.length() > 0) {
                String[] names = new String[]{contentType.getName()};
                String[] extensions = new String[]{sb.toString()};
                dialog.setFilterNames(names);
                dialog.setFilterExtensions(extensions);
            }
        }
        if ((file = dialog.open()) == null) {
            return NO_TARGETS;
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        String filterPath = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            Path filePath = Paths.get(filterPath, fileName);
            paths.add(filePath);
        }
        return paths.toArray(new Path[paths.size()]);
    }

    @Override
    protected IStatus createLink(IContainer container, IProgressMonitor monitor, Path ... targets) {
        return LinkFileHandler.createLinkedFiles(container, monitor, targets);
    }

    public static IStatus createLinkedFiles(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFilesRunnable action = new CreateLinkedFilesRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            return GeneralUtils.makeErrorStatus((String)action.composeErrorMessage((IResource)container, paths), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

