/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.text.WordUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class WordUtilsTest
extends AbstractLangTest {
    @Test
    public void testCapitalize_String() {
        Assertions.assertNull((Object)WordUtils.capitalize(null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.capitalize((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  "));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I"));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"i am here 123"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"I Am Here 123"));
        Assertions.assertEquals((Object)"I Am HERE 123", (Object)WordUtils.capitalize((String)"i am HERE 123"));
        Assertions.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.capitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeFully_String() {
        Assertions.assertNull((Object)WordUtils.capitalizeFully(null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  "));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I"));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am here 123"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I Am Here 123"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am HERE 123"));
        Assertions.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeFullyWithDelimiters_String() {
        Assertions.assertNull((Object)WordUtils.capitalizeFully(null, null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  "));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I", (char[])chars));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i", (char[])chars));
        Assertions.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"i-am here+123", (char[])chars));
        Assertions.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalizeFully((String)"I Am+Here-123", (char[])chars));
        Assertions.assertEquals((Object)"I+Am-Here 123", (Object)WordUtils.capitalizeFully((String)"i+am-HERE 123", (char[])chars));
        Assertions.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assertions.assertEquals((Object)"I am.Fine", (Object)WordUtils.capitalizeFully((String)"i aM.fine", (char[])chars));
        Assertions.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalizeFully((String)"i am.fine", null));
    }

    @Test
    public void testCapitalizeWithDelimiters_String() {
        Assertions.assertNull((Object)WordUtils.capitalize(null, null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.capitalize((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  "));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I", (char[])chars));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i", (char[])chars));
        Assertions.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalize((String)"i-am here+123", (char[])chars));
        Assertions.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalize((String)"I Am+Here-123", (char[])chars));
        Assertions.assertEquals((Object)"I+Am-HERE 123", (Object)WordUtils.capitalize((String)"i+am-HERE 123", (char[])chars));
        Assertions.assertEquals((Object)"I-AM HERE+123", (Object)WordUtils.capitalize((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assertions.assertEquals((Object)"I aM.Fine", (Object)WordUtils.capitalize((String)"i aM.fine", (char[])chars));
        Assertions.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalize((String)"i am.fine", null));
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new WordUtils());
        Constructor<?>[] cons = WordUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(WordUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(WordUtils.class.getModifiers()));
    }

    @Test
    public void testContainsAllWords_StringString() {
        Assertions.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{""}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords(null, (CharSequence[])new CharSequence[]{"ab"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{""}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"", (CharSequence[])new CharSequence[]{"ab"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"foo", (CharSequence[])new CharSequence[]{null}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"bar", (CharSequence[])new CharSequence[]{""}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"zzabyycdxx", (CharSequence[])new CharSequence[]{"by"}));
        Assertions.assertTrue((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", "lorem", "dolor"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"lorem ipsum null dolor sit amet", (CharSequence[])new CharSequence[]{"ipsum", null, "lorem", "dolor"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"b"}));
        Assertions.assertFalse((boolean)WordUtils.containsAllWords((CharSequence)"ab", (CharSequence[])new CharSequence[]{"z"}));
    }

    @Test
    public void testInitials_String() {
        Assertions.assertNull((Object)WordUtils.initials(null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)""));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  "));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I"));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i"));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee"));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t"));
        Assertions.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee"));
        Assertions.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee"));
        Assertions.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123"));
    }

    @Test
    public void testInitials_String_charArray() {
        char[] array = null;
        Assertions.assertNull((Object)WordUtils.initials(null, array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", array));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", array));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", array));
        Assertions.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", array));
        Assertions.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", array));
        Assertions.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", array));
        Assertions.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", array));
        Assertions.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", array));
        array = new char[]{};
        Assertions.assertNull((Object)WordUtils.initials(null, (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"i", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " ".toCharArray();
        Assertions.assertNull((Object)WordUtils.initials(null, (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assertions.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assertions.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assertions.assertEquals((Object)"B\nJ", (Object)WordUtils.initials((String)"   Ben \n   John\tLee\t", (char[])array));
        Assertions.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assertions.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assertions.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .".toCharArray();
        Assertions.assertNull((Object)WordUtils.initials(null, (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assertions.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assertions.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assertions.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .'".toCharArray();
        Assertions.assertNull((Object)WordUtils.initials(null, (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assertions.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assertions.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assertions.assertEquals((Object)"KOM", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assertions.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = "SIJo1".toCharArray();
        Assertions.assertNull((Object)WordUtils.initials(null, (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assertions.assertEquals((Object)" ", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assertions.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assertions.assertEquals((Object)"C", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assertions.assertEquals((Object)"Bh", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assertions.assertEquals((Object)"B.", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assertions.assertEquals((Object)" h", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assertions.assertEquals((Object)"K", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assertions.assertEquals((Object)"i2", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
    }

    @Test
    public void testLANG1292() {
        WordUtils.wrap((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (int)70);
    }

    @Test
    public void testLANG1397() {
        WordUtils.wrap((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (int)Integer.MAX_VALUE);
    }

    @Test
    public void testSwapCase_String() {
        Assertions.assertNull((Object)WordUtils.swapCase(null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.swapCase((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.swapCase((String)"  "));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.swapCase((String)"I"));
        Assertions.assertEquals((Object)"I", (Object)WordUtils.swapCase((String)"i"));
        Assertions.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.swapCase((String)"i am here 123"));
        Assertions.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.swapCase((String)"I Am Here 123"));
        Assertions.assertEquals((Object)"I AM here 123", (Object)WordUtils.swapCase((String)"i am HERE 123"));
        Assertions.assertEquals((Object)"i am here 123", (Object)WordUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assertions.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
    }

    @Test
    public void testUncapitalize_String() {
        Assertions.assertNull((Object)WordUtils.uncapitalize(null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  "));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I"));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i"));
        Assertions.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"i am here 123"));
        Assertions.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"I Am Here 123"));
        Assertions.assertEquals((Object)"i am hERE 123", (Object)WordUtils.uncapitalize((String)"i am HERE 123"));
        Assertions.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.uncapitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testUncapitalizeWithDelimiters_String() {
        Assertions.assertNull((Object)WordUtils.uncapitalize(null, null));
        Assertions.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)""));
        Assertions.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  "));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assertions.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I", (char[])chars));
        Assertions.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i", (char[])chars));
        Assertions.assertEquals((Object)"i am-here+123", (Object)WordUtils.uncapitalize((String)"i am-here+123", (char[])chars));
        Assertions.assertEquals((Object)"i+am here-123", (Object)WordUtils.uncapitalize((String)"I+Am Here-123", (char[])chars));
        Assertions.assertEquals((Object)"i-am+hERE 123", (Object)WordUtils.uncapitalize((String)"i-am+HERE 123", (char[])chars));
        Assertions.assertEquals((Object)"i aM-hERE+123", (Object)WordUtils.uncapitalize((String)"I AM-HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assertions.assertEquals((Object)"i AM.fINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", (char[])chars));
        Assertions.assertEquals((Object)"i aM.FINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", null));
    }

    @Test
    public void testWrap_StringInt() {
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)20));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)-1));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1));
        String systemNewLine = System.lineSeparator();
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here to jump to the commons website - https://commons.apache.org";
        expected = "Click here to jump" + systemNewLine + "to the commons" + systemNewLine + "website -" + systemNewLine + "https://commons.apache.org";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here, https://commons.apache.org, to jump to the commons website";
        expected = "Click here," + systemNewLine + "https://commons.apache.org," + systemNewLine + "to jump to the" + systemNewLine + "commons website";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "word1             word2                        word3";
        expected = "word1  " + systemNewLine + "word2  " + systemNewLine + "word3";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)7));
    }

    @Test
    public void testWrap_StringIntStringBoolean() {
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)false));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)true));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)20, null, (boolean)true));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)20, null, (boolean)false));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)-1, null, (boolean)true));
        Assertions.assertNull((Object)WordUtils.wrap(null, (int)-1, null, (boolean)false));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)true));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)false));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)true));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)false));
        Assertions.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)true));
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of<br />text that is going<br />to be wrapped after<br />20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)true));
        input = "Here is one line";
        expected = "Here\nis one\nline";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)6, (String)"\n", (boolean)false));
        expected = "Here\nis\none\nline";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)-1, (String)"\n", (boolean)false));
        String systemNewLine = System.lineSeparator();
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)true));
        input = " Here:  is  one  line  of  text  that  is  going  to  be  wrapped  after  20  columns.";
        expected = "Here:  is  one  line\nof  text  that  is \ngoing  to  be \nwrapped  after  20 \ncolumns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is\tone line of text that is going to be wrapped after 20 columns.";
        expected = "Here is\tone line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of\ttext that is going to be wrapped after 20 columns.";
        expected = "Here is one line\nof\ttext that is\ngoing to be wrapped\nafter 20 columns.";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here to jump to the commons website - https://commons.apache.org";
        expected = "Click here to jump\nto the commons\nwebsite -\nhttps://commons.apache.org";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here to jump\nto the commons\nwebsite -\nhttps://commons.apac\nhe.org";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here, https://commons.apache.org, to jump to the commons website";
        expected = "Click here,\nhttps://commons.apache.org,\nto jump to the\ncommons website";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here,\nhttps://commons.apac\nhe.org, to jump to\nthe commons website";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
    }

    @Test
    public void testWrap_StringIntStringBooleanString() {
        String input = "flammable/inflammable";
        String expected = "flammable/inflammable";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)30, (String)"\n", (boolean)false, (String)"/"));
        expected = "flammable\ninflammable";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false, (String)"/"));
        expected = "flammable\ninflammab\nle";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)9, (String)"\n", (boolean)true, (String)"/"));
        expected = "flammable\ninflammable";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/"));
        input = "flammableinflammable";
        expected = "flammableinflam\nmable";
        Assertions.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)15, (String)"\n", (boolean)true, (String)"/"));
    }
}

