/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt.internal.client;

import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttBrokerConnection;
import org.openhab.core.io.transport.mqtt.MqttWillAndTestament;
import org.openhab.core.io.transport.mqtt.internal.Subscription;
import org.openhab.core.io.transport.mqtt.internal.client.MqttAsyncClientWrapper;

@NonNullByDefault
public class Mqtt3AsyncClientWrapper
extends MqttAsyncClientWrapper {
    private final Mqtt3AsyncClient client;

    public Mqtt3AsyncClientWrapper(String host, int port, String clientId, MqttBrokerConnection.Protocol protocol, boolean secure, boolean hostnameValidated, MqttBrokerConnection.ConnectionCallback connectionCallback, @Nullable TrustManagerFactory trustManagerFactory) {
        Mqtt3ClientBuilder clientBuilder = (Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().serverHost(host)).serverPort(port)).identifier(clientId)).addConnectedListener((MqttClientConnectedListener)connectionCallback)).addDisconnectedListener((MqttClientDisconnectedListener)connectionCallback);
        if (protocol == MqttBrokerConnection.Protocol.WEBSOCKETS) {
            clientBuilder.webSocketWithDefaultConfig();
        }
        if (secure) {
            if (hostnameValidated) {
                ((MqttClientSslConfigBuilder.Nested)((Mqtt3ClientBuilder)clientBuilder.sslWithDefaultConfig()).sslConfig().trustManagerFactory(trustManagerFactory)).applySslConfig();
            } else {
                ((MqttClientSslConfigBuilder.Nested)((MqttClientSslConfigBuilder.Nested)((Mqtt3ClientBuilder)clientBuilder.sslWithDefaultConfig()).sslConfig().trustManagerFactory(trustManagerFactory)).hostnameVerifier((HostnameVerifier)this)).applySslConfig();
            }
        }
        this.client = clientBuilder.buildAsync();
    }

    @Override
    public MqttClientState getState() {
        return this.client.getState();
    }

    @Override
    public CompletableFuture<?> subscribe(String topic, int qos, Subscription subscription) {
        Mqtt3Subscribe subscribeMessage = ((Mqtt3SubscribeBuilder.Start.Complete)((Mqtt3SubscribeBuilder.Start.Complete)Mqtt3Subscribe.builder().topicFilter(topic)).qos(this.getMqttQosFromInt(qos))).build();
        return this.client.subscribe(subscribeMessage, subscription::messageArrived);
    }

    @Override
    public CompletableFuture<?> unsubscribe(String topic) {
        Mqtt3Unsubscribe unsubscribeMessage = ((Mqtt3UnsubscribeBuilder.Complete)Mqtt3Unsubscribe.builder().topicFilter(topic)).build();
        return this.client.unsubscribe(unsubscribeMessage);
    }

    public CompletableFuture<Mqtt3Publish> publish(String topic, byte[] payload, boolean retain, int qos) {
        Mqtt3Publish publishMessage = ((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)Mqtt3Publish.builder().topic(topic)).qos(this.getMqttQosFromInt(qos))).payload(payload)).retain(retain)).build();
        return this.client.publish(publishMessage);
    }

    @Override
    public CompletableFuture<?> connect(@Nullable MqttWillAndTestament lwt, int keepAliveInterval, @Nullable String username, @Nullable String password) {
        Mqtt3ConnectBuilder connectMessageBuilder = (Mqtt3ConnectBuilder)Mqtt3Connect.builder().keepAlive(keepAliveInterval);
        if (lwt != null) {
            Mqtt3Publish willPublish = ((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)((Mqtt3PublishBuilder.Complete)Mqtt3Publish.builder().topic(lwt.getTopic())).payload(lwt.getPayload())).retain(lwt.isRetain())).qos(this.getMqttQosFromInt(lwt.getQos()))).build();
            connectMessageBuilder.willPublish(willPublish);
        }
        if (username != null && !username.isBlank() && password != null && !password.isBlank()) {
            ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)connectMessageBuilder.simpleAuth().username(username)).password(password.getBytes())).applySimpleAuth();
        }
        return this.client.connect(connectMessageBuilder.build());
    }

    @Override
    public CompletableFuture<Void> disconnect() {
        return this.client.disconnect();
    }
}

