/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Objects;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;

public class Recipient {
    private final RecipientId recipientId;
    private final RecipientAddress address;
    private final Contact contact;
    private final ProfileKey profileKey;
    private final ExpiringProfileKeyCredential expiringProfileKeyCredential;
    private final Profile profile;
    private final Boolean discoverable;

    public Recipient(RecipientId recipientId, RecipientAddress address, Contact contact, ProfileKey profileKey, ExpiringProfileKeyCredential expiringProfileKeyCredential, Profile profile, Boolean discoverable) {
        this.recipientId = recipientId;
        this.address = address;
        this.contact = contact;
        this.profileKey = profileKey;
        this.expiringProfileKeyCredential = expiringProfileKeyCredential;
        this.profile = profile;
        this.discoverable = discoverable;
    }

    private Recipient(Builder builder) {
        this.recipientId = builder.recipientId;
        this.address = builder.address;
        this.contact = builder.contact;
        this.profileKey = builder.profileKey;
        this.expiringProfileKeyCredential = builder.expiringProfileKeyCredential;
        this.profile = builder.profile;
        this.discoverable = builder.discoverable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Recipient copy) {
        Builder builder = new Builder();
        builder.recipientId = copy.getRecipientId();
        builder.address = copy.getAddress();
        builder.contact = copy.getContact();
        builder.profileKey = copy.getProfileKey();
        builder.expiringProfileKeyCredential = copy.getExpiringProfileKeyCredential();
        builder.profile = copy.getProfile();
        return builder;
    }

    public RecipientId getRecipientId() {
        return this.recipientId;
    }

    public RecipientAddress getAddress() {
        return this.address;
    }

    public Contact getContact() {
        return this.contact;
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public ExpiringProfileKeyCredential getExpiringProfileKeyCredential() {
        return this.expiringProfileKeyCredential;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public Boolean getDiscoverable() {
        return this.discoverable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.recipientId, recipient.recipientId) && Objects.equals(this.address, recipient.address) && Objects.equals(this.contact, recipient.contact) && Objects.equals(this.profileKey, recipient.profileKey) && Objects.equals(this.expiringProfileKeyCredential, recipient.expiringProfileKeyCredential) && Objects.equals(this.profile, recipient.profile);
    }

    public int hashCode() {
        return Objects.hash(this.recipientId, this.address, this.contact, this.profileKey, this.expiringProfileKeyCredential, this.profile);
    }

    public static final class Builder {
        private RecipientId recipientId;
        private RecipientAddress address;
        private Contact contact;
        private ProfileKey profileKey;
        private ExpiringProfileKeyCredential expiringProfileKeyCredential;
        private Profile profile;
        private Boolean discoverable;

        private Builder() {
        }

        public Builder withRecipientId(RecipientId val) {
            this.recipientId = val;
            return this;
        }

        public Builder withAddress(RecipientAddress val) {
            this.address = val;
            return this;
        }

        public Builder withContact(Contact val) {
            this.contact = val;
            return this;
        }

        public Builder withProfileKey(ProfileKey val) {
            this.profileKey = val;
            return this;
        }

        public Builder withExpiringProfileKeyCredential(ExpiringProfileKeyCredential val) {
            this.expiringProfileKeyCredential = val;
            return this;
        }

        public Builder withProfile(Profile val) {
            this.profile = val;
            return this;
        }

        public Builder withDiscoverable(Boolean val) {
            this.discoverable = val;
            return this;
        }

        public Recipient build() {
            return new Recipient(this);
        }
    }
}

