/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.asamk.signal.json.JsonSyncDataMessage;
import org.asamk.signal.json.JsonSyncMessageType;
import org.asamk.signal.json.JsonSyncReadMessage;
import org.asamk.signal.json.JsonSyncStoryMessage;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientAddress;

record JsonSyncMessage(@JsonInclude(value=JsonInclude.Include.NON_NULL) JsonSyncDataMessage sentMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonSyncStoryMessage sentStoryMessage, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<String> blockedNumbers, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<String> blockedGroupIds, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonSyncReadMessage> readMessages, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonSyncMessageType type) {
    static JsonSyncMessage from(MessageEnvelope.Sync syncMessage, Manager m) {
        List<JsonSyncReadMessage> readMessages;
        List<String> blockedGroupIds;
        List<String> blockedNumbers;
        JsonSyncStoryMessage sentStoryMessage;
        JsonSyncDataMessage sentMessage = syncMessage.sent().isPresent() && ((MessageEnvelope.Sync.Sent)syncMessage.sent().get()).story().isEmpty() ? JsonSyncDataMessage.from((MessageEnvelope.Sync.Sent)syncMessage.sent().get(), m) : null;
        JsonSyncStoryMessage jsonSyncStoryMessage = sentStoryMessage = syncMessage.sent().isPresent() && ((MessageEnvelope.Sync.Sent)syncMessage.sent().get()).story().isPresent() ? JsonSyncStoryMessage.from((MessageEnvelope.Sync.Sent)syncMessage.sent().get()) : null;
        if (syncMessage.blocked().isPresent()) {
            blockedNumbers = ((MessageEnvelope.Sync.Blocked)syncMessage.blocked().get()).recipients().stream().map(RecipientAddress::getLegacyIdentifier).toList();
            blockedGroupIds = ((MessageEnvelope.Sync.Blocked)syncMessage.blocked().get()).groupIds().stream().map(GroupId::toBase64).toList();
        } else {
            blockedNumbers = null;
            blockedGroupIds = null;
        }
        List<JsonSyncReadMessage> list = readMessages = !syncMessage.read().isEmpty() ? syncMessage.read().stream().map(JsonSyncReadMessage::from).toList() : null;
        JsonSyncMessageType type = syncMessage.contacts().isPresent() ? JsonSyncMessageType.CONTACTS_SYNC : (syncMessage.groups().isPresent() ? JsonSyncMessageType.GROUPS_SYNC : null);
        return new JsonSyncMessage(sentMessage, sentStoryMessage, blockedNumbers, blockedGroupIds, readMessages, type);
    }
}

