/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonSendMessageResult;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupLinkState;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UpdateGroup;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateGroupCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(UpdateGroupCommand.class);

    @Override
    public String getName() {
        return "updateGroup";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Create or update a group.");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the group ID.");
        subparser.addArgument(new String[]{"-n", "--name"}).help("Specify the new group name.");
        subparser.addArgument(new String[]{"-d", "--description"}).help("Specify the new group description.");
        subparser.addArgument(new String[]{"-a", "--avatar"}).help("Specify a new group avatar image file");
        subparser.addArgument(new String[]{"-m", "--member"}).nargs("*").help("Specify one or more members to add to the group");
        subparser.addArgument(new String[]{"-r", "--remove-member"}).nargs("*").help("Specify one or more members to remove from the group");
        subparser.addArgument(new String[]{"--admin"}).nargs("*").help("Specify one or more members to make a group admin");
        subparser.addArgument(new String[]{"--remove-admin"}).nargs("*").help("Specify one or more members to remove group admin privileges");
        subparser.addArgument(new String[]{"--ban"}).nargs("*").help("Specify one or more members to ban from joining the group");
        subparser.addArgument(new String[]{"--unban"}).nargs("*").help("Specify one or more members to remove from the ban list");
        subparser.addArgument(new String[]{"--reset-link"}).action((ArgumentAction)Arguments.storeTrue()).help("Reset group link and create new link password");
        subparser.addArgument(new String[]{"--link"}).help("Set group link state, with or without admin approval").choices((Object[])new String[]{"enabled", "enabled-with-approval", "disabled"});
        subparser.addArgument(new String[]{"--set-permission-add-member"}).help("Set permission to add new group members").choices((Object[])new String[]{"every-member", "only-admins"});
        subparser.addArgument(new String[]{"--set-permission-edit-details"}).help("Set permission to edit group details").choices((Object[])new String[]{"every-member", "only-admins"});
        subparser.addArgument(new String[]{"--set-permission-send-messages"}).help("Set permission to send messages").choices((Object[])new String[]{"every-member", "only-admins"});
        subparser.addArgument(new String[]{"-e", "--expiration"}).type(Integer.TYPE).help("Set expiration time of messages (seconds)");
    }

    GroupLinkState getGroupLinkState(String value) throws UserErrorException {
        if (value == null) {
            return null;
        }
        return switch (value) {
            case "enabled" -> GroupLinkState.ENABLED;
            case "enabled-with-approval", "enabledWithApproval" -> GroupLinkState.ENABLED_WITH_APPROVAL;
            case "disabled" -> GroupLinkState.DISABLED;
            default -> throw new UserErrorException("Invalid group link state: " + value);
        };
    }

    GroupPermission getGroupPermission(String value) throws UserErrorException {
        if (value == null) {
            return null;
        }
        return switch (value) {
            case "every-member", "everyMember" -> GroupPermission.EVERY_MEMBER;
            case "only-admins", "onlyAdmins" -> GroupPermission.ONLY_ADMINS;
            default -> throw new UserErrorException("Invalid group permission: " + value);
        };
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String groupIdString = ns.getString("group-id");
        GroupId groupId = CommandUtil.getGroupId(groupIdString);
        String localNumber = m.getSelfNumber();
        String groupName = ns.getString("name");
        String groupDescription = ns.getString("description");
        Set<RecipientIdentifier.Single> groupMembers = CommandUtil.getSingleRecipientIdentifiers(ns.getList("member"), localNumber);
        Set<RecipientIdentifier.Single> groupRemoveMembers = CommandUtil.getSingleRecipientIdentifiers(ns.getList("remove-member"), localNumber);
        Set<RecipientIdentifier.Single> groupAdmins = CommandUtil.getSingleRecipientIdentifiers(ns.getList("admin"), localNumber);
        Set<RecipientIdentifier.Single> groupRemoveAdmins = CommandUtil.getSingleRecipientIdentifiers(ns.getList("remove-admin"), localNumber);
        Set<RecipientIdentifier.Single> groupBan = CommandUtil.getSingleRecipientIdentifiers(ns.getList("ban"), localNumber);
        Set<RecipientIdentifier.Single> groupUnban = CommandUtil.getSingleRecipientIdentifiers(ns.getList("unban"), localNumber);
        String groupAvatar = ns.getString("avatar");
        boolean groupResetLink = Boolean.TRUE.equals(ns.getBoolean("reset-link"));
        GroupLinkState groupLinkState = this.getGroupLinkState(ns.getString("link"));
        Integer groupExpiration = ns.getInt("expiration");
        GroupPermission groupAddMemberPermission = this.getGroupPermission(ns.getString("set-permission-add-member"));
        GroupPermission groupEditDetailsPermission = this.getGroupPermission(ns.getString("set-permission-edit-details"));
        GroupPermission groupSendMessagesPermission = this.getGroupPermission(ns.getString("set-permission-send-messages"));
        try {
            Pair results;
            boolean isNewGroup = false;
            Object groupMessageResults = null;
            if (groupId == null) {
                isNewGroup = true;
                results = m.createGroup(groupName, groupMembers, groupAvatar);
                groupMessageResults = (SendGroupMessageResults)results.second();
                groupId = (GroupId)results.first();
                groupName = null;
                groupMembers = null;
                groupAvatar = null;
            }
            if ((results = m.updateGroup(groupId, UpdateGroup.newBuilder().withName(groupName).withDescription(groupDescription).withMembers(groupMembers).withRemoveMembers(groupRemoveMembers).withAdmins(groupAdmins).withRemoveAdmins(groupRemoveAdmins).withBanMembers(groupBan).withUnbanMembers(groupUnban).withResetGroupLink(groupResetLink).withGroupLinkState(groupLinkState).withAddMemberPermission(groupAddMemberPermission).withEditDetailsPermission(groupEditDetailsPermission).withAvatarFile(groupAvatar).withExpirationTimer(groupExpiration).withIsAnnouncementGroup(groupSendMessagesPermission == null ? null : Boolean.valueOf(groupSendMessagesPermission == GroupPermission.ONLY_ADMINS)).build())) != null) {
                groupMessageResults = groupMessageResults == null ? results : new SendGroupMessageResults(results.timestamp(), Stream.concat(groupMessageResults.results().stream(), results.results().stream()).toList());
            }
            this.outputResult(outputWriter, (SendGroupMessageResults)groupMessageResults, (GroupId)(isNewGroup ? groupId : null));
        }
        catch (AttachmentInvalidException e) {
            throw new UserErrorException("Failed to add avatar attachment for group\": " + e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new UserErrorException(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new UserErrorException("The user " + e.getSender().getIdentifier() + " is not registered.");
        }
        catch (IOException e) {
            throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
    }

    private void outputResult(OutputWriter outputWriter, SendGroupMessageResults results, GroupId groupId) {
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                if (groupId != null) {
                    writer.println("Created new group: \"{}\"", groupId.toBase64());
                }
                if (results == null) break;
                List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(results.results());
                SendMessageResultUtils.printSendMessageResultErrors(writer, errors);
                writer.println("{}", results.timestamp());
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                HashMap<String, Object> response = new HashMap<String, Object>();
                if (results != null) {
                    response.put("timestamp", results.timestamp());
                    List<JsonSendMessageResult> jsonResults = SendMessageResultUtils.getJsonSendMessageResults(results.results());
                    response.put("results", jsonResults);
                }
                if (groupId != null) {
                    response.put("groupId", groupId.toBase64());
                }
                writer.write(response);
            }
        }
    }
}

