/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.InvalidUsernameException;
import org.asamk.signal.manager.api.UsernameLinkUrl;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;

public class UpdateAccountCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "updateAccount";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Update the account attributes on the signal server.");
        subparser.addArgument(new String[]{"-n", "--device-name"}).help("Specify a name to describe this device.");
        subparser.addArgument(new String[]{"--unrestricted-unidentified-sender"}).type(Boolean.class).help("Enable if anyone should be able to send you unidentified sender messages.");
        subparser.addArgument(new String[]{"--discoverable-by-number"}).type(Boolean.class).help("Enable/disable if the account should be discoverable by phone number");
        subparser.addArgument(new String[]{"--number-sharing"}).type(Boolean.class).help("Indicates if Signal should share its phone number when sending a message.");
        MutuallyExclusiveGroup mut = subparser.addMutuallyExclusiveGroup();
        mut.addArgument(new String[]{"-u", "--username"}).help("Specify a username that can then be used to contact this account.");
        mut.addArgument(new String[]{"--delete-username"}).action((ArgumentAction)Arguments.storeTrue()).help("Delete the username associated with this account.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        boolean deleteUsername;
        String deviceName = ns.getString("device-name");
        Boolean unrestrictedUnidentifiedSender = ns.getBoolean("unrestricted-unidentified-sender");
        Boolean discoverableByNumber = ns.getBoolean("discoverable-by-number");
        Boolean numberSharing = ns.getBoolean("number-sharing");
        try {
            m.updateAccountAttributes(deviceName, unrestrictedUnidentifiedSender, discoverableByNumber, numberSharing);
        }
        catch (IOException e) {
            throw new IOErrorException("UpdateAccount error: " + e.getMessage(), e);
        }
        String username = ns.getString("username");
        if (username != null) {
            try {
                m.setUsername(username);
                String newUsername = m.getUsername();
                UsernameLinkUrl newUsernameLink = m.getUsernameLink();
                OutputWriter outputWriter2 = outputWriter;
                Objects.requireNonNull(outputWriter2);
                OutputWriter outputWriter3 = outputWriter2;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        PlainTextWriter w = (PlainTextWriter)outputWriter3;
                        w.println("Your new username: {} ({})", newUsername, newUsernameLink == null ? "-" : newUsernameLink.getUrl());
                        break;
                    }
                    case 1: {
                        JsonWriter w = (JsonWriter)outputWriter3;
                        w.write(new JsonAccountResponse(newUsername, newUsernameLink == null ? null : newUsernameLink.getUrl()));
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new IOErrorException("Failed to set username: " + e.getMessage(), e);
            }
            catch (InvalidUsernameException e) {
                throw new UserErrorException("Invalid username: " + e.getMessage(), e);
            }
        }
        if (deleteUsername = Boolean.TRUE.equals(ns.getBoolean("delete-username"))) {
            try {
                m.deleteUsername();
            }
            catch (IOException e) {
                throw new IOErrorException("Failed to delete username: " + e.getMessage(), e);
            }
        }
    }

    private record JsonAccountResponse(@JsonInclude(value=JsonInclude.Include.NON_NULL) String username, @JsonInclude(value=JsonInclude.Include.NON_NULL) String usernameLink) {
    }
}

