/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.output.OutputWriter;

public class SetPinCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "setPin";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Set a registration lock pin, to prevent others from registering this number.");
        subparser.addArgument(new String[]{"pin"}).help("The registration lock PIN, that will be required for new registrations (resets after 7 days of inactivity)");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        try {
            String registrationLockPin = ns.getString("pin");
            m.setRegistrationLockPin(Optional.of(registrationLockPin));
        }
        catch (IOException e) {
            throw new IOErrorException("Set pin error: " + e.getMessage(), e);
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
    }
}

