/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;

public class RemoveContactCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "removeContact";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Remove the details of a given contact");
        subparser.addArgument(new String[]{"recipient"}).help("Contact number");
        MutuallyExclusiveGroup mut = subparser.addMutuallyExclusiveGroup();
        mut.addArgument(new String[]{"--hide"}).action((ArgumentAction)Arguments.storeTrue()).help("Hide the contact in the contact list, but keep the data.");
        mut.addArgument(new String[]{"--forget"}).action((ArgumentAction)Arguments.storeTrue()).help("Delete all data associated with this contact, including identity keys and sessions.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        boolean forget;
        String recipientString = ns.getString("recipient");
        RecipientIdentifier.Single recipient = CommandUtil.getSingleRecipientIdentifier(recipientString, m.getSelfNumber());
        boolean hide = Boolean.TRUE == ns.getBoolean("hide");
        boolean bl = forget = Boolean.TRUE == ns.getBoolean("forget");
        if (hide) {
            m.hideRecipient(recipient);
        } else if (forget) {
            m.deleteRecipient(recipient);
        } else {
            m.deleteContact(recipient);
        }
    }
}

