/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.OutputType;
import org.asamk.signal.commands.JsonRpcRegistrationCommand;
import org.asamk.signal.commands.RegistrationCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.util.CommandUtil;

public class RegisterCommand
implements RegistrationCommand,
JsonRpcRegistrationCommand<RegistrationParams> {
    @Override
    public String getName() {
        return "register";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Register a phone number with SMS or voice verification.");
        subparser.addArgument(new String[]{"-v", "--voice"}).help("The verification should be done over voice, not SMS.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--captcha"}).help("The captcha token, required if registration failed with a captcha required error.");
        subparser.addArgument(new String[]{"--reregister"}).action((ArgumentAction)Arguments.storeTrue()).help("Register even if account is already registered");
    }

    @Override
    public void handleCommand(Namespace ns, RegistrationManager m) throws CommandException {
        boolean voiceVerification = Boolean.TRUE.equals(ns.getBoolean("voice"));
        String captcha = ns.getString("captcha");
        boolean reregister = Boolean.TRUE.equals(ns.getBoolean("reregister"));
        this.register(m, voiceVerification, captcha, reregister);
    }

    @Override
    public TypeReference<RegistrationParams> getRequestType() {
        return new TypeReference<RegistrationParams>(this){};
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.PLAIN_TEXT, OutputType.JSON);
    }

    @Override
    public void handleCommand(RegistrationParams request, RegistrationManager m, JsonWriter jsonWriter) throws CommandException {
        this.register(m, Boolean.TRUE.equals(request.voice()), request.captcha(), Boolean.TRUE.equals(request.reregister()));
    }

    private void register(RegistrationManager m, boolean voiceVerification, String captcha, boolean reregister) throws CommandException {
        try {
            m.register(voiceVerification, captcha, reregister);
        }
        catch (RateLimitException e) {
            String message = CommandUtil.getRateLimitMessage(e);
            throw new RateLimitErrorException(message, e);
        }
        catch (CaptchaRequiredException e) {
            String message = CommandUtil.getCaptchaRequiredMessage(e, captcha != null);
            throw new UserErrorException(message);
        }
        catch (NonNormalizedPhoneNumberException e) {
            throw new UserErrorException("Failed to register: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to register: %s (%s)".formatted(e.getMessage(), e.getClass().getSimpleName()), e);
        }
        catch (VerificationMethodNotAvailableException e) {
            throw new UserErrorException("Failed to register: " + e.getMessage() + (voiceVerification ? ": Before requesting voice verification you need to request SMS verification and wait a minute." : ""), e);
        }
    }

    public record RegistrationParams(Boolean voice, String captcha, Boolean reregister) {
    }
}

