/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;

public class SubscriptionsConfiguration {
    public static final String PAYPAL = "PAYPAL";
    public static final String CARD = "CARD";
    public static final String SEPA_DEBIT = "SEPA_DEBIT";
    public static final String IDEAL = "IDEAL";
    public static final int BOOST_LEVEL = 1;
    public static final int GIFT_LEVEL = 100;
    public static final int BACKUPS_LEVEL = 201;
    public static final HashSet<Integer> SUBSCRIPTION_LEVELS = new HashSet<Integer>(Arrays.asList(500, 1000, 2000));
    @JsonProperty(value="currencies")
    private Map<String, CurrencyConfiguration> currencies;
    @JsonProperty(value="levels")
    private Map<Integer, LevelConfiguration> levels;
    @JsonProperty(value="sepaMaximumEuros")
    private BigDecimal sepaMaximumEuros;
    @JsonProperty(value="backup")
    private BackupConfiguration backupConfiguration;

    public Map<String, CurrencyConfiguration> getCurrencies() {
        return this.currencies;
    }

    public Map<Integer, LevelConfiguration> getLevels() {
        return this.levels;
    }

    public BigDecimal getSepaMaximumEuros() {
        return this.sepaMaximumEuros;
    }

    public BackupConfiguration getBackupConfiguration() {
        return this.backupConfiguration;
    }

    public static class BackupConfiguration {
        @JsonProperty(value="levels")
        private Map<Integer, BackupLevelConfiguration> backupLevelConfigurationMap;
        @JsonProperty(value="freeTierMediaDays")
        private int freeTierMediaDays;

        public Map<Integer, BackupLevelConfiguration> getBackupLevelConfigurationMap() {
            return this.backupLevelConfigurationMap;
        }

        public int getFreeTierMediaDays() {
            return this.freeTierMediaDays;
        }
    }

    public static class BackupLevelConfiguration {
        @JsonProperty(value="storageAllowanceBytes")
        private long storageAllowanceBytes;
        @JsonProperty(value="playProductId")
        private String playProductId;
        @JsonProperty(value="mediaTtlDays")
        private long mediaTtlDays;

        public long getStorageAllowanceBytes() {
            return this.storageAllowanceBytes;
        }

        public String getPlayProductId() {
            return this.playProductId;
        }

        public long getMediaTtlDays() {
            return this.mediaTtlDays;
        }
    }

    public static class LevelConfiguration {
        @JsonProperty(value="badge")
        private SignalServiceProfile.Badge badge;

        public SignalServiceProfile.Badge getBadge() {
            return this.badge;
        }
    }

    public static class CurrencyConfiguration {
        @JsonProperty(value="minimum")
        private BigDecimal minimum;
        @JsonProperty(value="oneTime")
        private Map<Integer, List<BigDecimal>> oneTime;
        @JsonProperty(value="subscription")
        private Map<Integer, BigDecimal> subscription;
        @JsonProperty(value="backupSubscription")
        private Map<Integer, BigDecimal> backupSubscription;
        @JsonProperty(value="supportedPaymentMethods")
        private Set<String> supportedPaymentMethods;

        public BigDecimal getMinimum() {
            return this.minimum;
        }

        public Map<Integer, List<BigDecimal>> getOneTime() {
            return this.oneTime;
        }

        public Map<Integer, BigDecimal> getSubscription() {
            return this.subscription;
        }

        public Map<Integer, BigDecimal> getBackupSubscription() {
            return this.backupSubscription;
        }

        public Set<String> getSupportedPaymentMethods() {
            return this.supportedPaymentMethods;
        }
    }
}

