/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.ProtoUtil;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.signal.registration.proto.RegistrationProvisionEnvelope;
import org.signal.registration.proto.RegistrationProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisionEnvelope;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\r\u001a\u00020\u0010J\"\u0010\n\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher;", "", "secondaryIdentityKeyPair", "Lorg/signal/libsignal/protocol/IdentityKeyPair;", "<init>", "(Lorg/signal/libsignal/protocol/IdentityKeyPair;)V", "secondaryDevicePublicKey", "Lorg/signal/libsignal/protocol/IdentityKey;", "getSecondaryDevicePublicKey", "()Lorg/signal/libsignal/protocol/IdentityKey;", "decrypt", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult;", "Lorg/whispersystems/signalservice/internal/push/ProvisionMessage;", "envelope", "Lorg/whispersystems/signalservice/internal/push/ProvisionEnvelope;", "Lorg/signal/registration/proto/RegistrationProvisionMessage;", "Lorg/signal/registration/proto/RegistrationProvisionEnvelope;", "", "expectedVersion", "", "primaryEphemeralPublicKey", "body", "getMac", "key", "message", "getPlaintext", "iv", "Companion", "ProvisioningDecryptResult", "signal-service-java"})
public final class SecondaryProvisioningCipher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentityKeyPair secondaryIdentityKeyPair;
    @NotNull
    private final IdentityKey secondaryDevicePublicKey;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(SecondaryProvisioningCipher.class));
    private static final int VERSION_LENGTH = 1;
    private static final int IV_LENGTH = 16;
    private static final int MAC_LENGTH = 32;

    public SecondaryProvisioningCipher(@NotNull IdentityKeyPair secondaryIdentityKeyPair) {
        Intrinsics.checkNotNullParameter((Object)secondaryIdentityKeyPair, (String)"secondaryIdentityKeyPair");
        this.secondaryIdentityKeyPair = secondaryIdentityKeyPair;
        IdentityKey identityKey = this.secondaryIdentityKeyPair.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)identityKey, (String)"getPublicKey(...)");
        this.secondaryDevicePublicKey = identityKey;
    }

    @NotNull
    public final IdentityKey getSecondaryDevicePublicKey() {
        return this.secondaryDevicePublicKey;
    }

    @NotNull
    public final ProvisioningDecryptResult<ProvisionMessage> decrypt(@NotNull ProvisionEnvelope envelope) {
        Intrinsics.checkNotNullParameter((Object)((Object)envelope), (String)"envelope");
        if (envelope.publicKey == null || envelope.body == null || ProtoUtil.isEmpty((ByteString)envelope.publicKey) || ProtoUtil.isEmpty((ByteString)envelope.body)) {
            Log.w((String)TAG, (String)"Public key or body is null or empty");
            return new ProvisioningDecryptResult.Error();
        }
        byte[] plaintext = this.decrypt(1, envelope.publicKey.toByteArray(), envelope.body.toByteArray());
        if (plaintext == null) {
            Log.w((String)TAG, (String)"Plaintext is null");
            return new ProvisioningDecryptResult.Error();
        }
        ProvisionMessage provisioningMessage = (ProvisionMessage)((Object)ProvisionMessage.ADAPTER.decode(plaintext));
        return new ProvisioningDecryptResult.Success<ProvisionMessage>(provisioningMessage);
    }

    @NotNull
    public final ProvisioningDecryptResult<RegistrationProvisionMessage> decrypt(@NotNull RegistrationProvisionEnvelope envelope) {
        Intrinsics.checkNotNullParameter((Object)((Object)envelope), (String)"envelope");
        if (ProtoUtil.isEmpty((ByteString)envelope.publicKey) || ProtoUtil.isEmpty((ByteString)envelope.body)) {
            Log.w((String)TAG, (String)"Public key or body is empty");
            return new ProvisioningDecryptResult.Error();
        }
        byte[] plaintext = this.decrypt(1, envelope.publicKey.toByteArray(), envelope.body.toByteArray());
        if (plaintext == null) {
            Log.w((String)TAG, (String)"Plaintext is null");
            return new ProvisioningDecryptResult.Error();
        }
        RegistrationProvisionMessage provisioningMessage = (RegistrationProvisionMessage)((Object)RegistrationProvisionMessage.ADAPTER.decode(plaintext));
        return new ProvisioningDecryptResult.Success<RegistrationProvisionMessage>(provisioningMessage);
    }

    private final byte[] decrypt(int expectedVersion, byte[] primaryEphemeralPublicKey, byte[] body) {
        byte[] byArray;
        int provisionMessageLength = body.length - 1 - 16 - 32;
        if (provisionMessageLength <= 0) {
            Log.w((String)TAG, (String)"Provisioning message length invalid");
            return null;
        }
        byte version = body[0];
        if (version != expectedVersion) {
            Log.w((String)TAG, (String)("Version does not match expected, expected " + expectedVersion + " but was " + version));
            return null;
        }
        byte[] iv = ArraysKt.sliceArray((byte[])body, (IntRange)RangesKt.until((int)1, (int)17));
        byte[] theirMac = ArraysKt.sliceArray((byte[])body, (IntRange)RangesKt.until((int)(body.length - 32), (int)body.length));
        byte[] message = ArraysKt.sliceArray((byte[])body, (IntRange)RangesKt.until((int)0, (int)(body.length - 32)));
        byte[] cipherText = ArraysKt.sliceArray((byte[])body, (IntRange)RangesKt.until((int)17, (int)(body.length - 32)));
        byte[] sharedSecret = this.secondaryIdentityKeyPair.getPrivateKey().calculateAgreement(new ECPublicKey(primaryEphemeralPublicKey));
        String string = "TextSecure Provisioning Message";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] derivedSecret = HKDF.deriveSecrets((byte[])sharedSecret, (byte[])byArray2, (int)64);
        byte[] cipherKey = ArraysKt.sliceArray((byte[])derivedSecret, (IntRange)RangesKt.until((int)0, (int)32));
        byte[] macKey = ArraysKt.sliceArray((byte[])derivedSecret, (IntRange)RangesKt.until((int)32, (int)64));
        byte[] ourHmac = this.getMac(macKey, message);
        if (!MessageDigest.isEqual(theirMac, ourHmac)) {
            Log.w((String)TAG, (String)"Macs do not match");
            return null;
        }
        try {
            byArray = this.getPlaintext(cipherKey, iv, cipherText);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Unable to get plaintext", (Throwable)e);
            return null;
        }
        return byArray;
    }

    private final byte[] getMac(byte[] key, byte[] message) {
        byte[] byArray;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            byArray = mac.doFinal(message);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        return byArray;
    }

    private final byte[] getPlaintext(byte[] key, byte[] iv, byte[] message) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        byte[] byArray = cipher.doFinal(message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$Companion;", "", "<init>", "()V", "TAG", "", "VERSION_LENGTH", "", "IV_LENGTH", "MAC_LENGTH", "generate", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher;", "identityKeyPair", "Lorg/signal/libsignal/protocol/IdentityKeyPair;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecondaryProvisioningCipher generate(@NotNull IdentityKeyPair identityKeyPair) {
            Intrinsics.checkNotNullParameter((Object)identityKeyPair, (String)"identityKeyPair");
            return new SecondaryProvisioningCipher(identityKeyPair);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0003\u0004\u0082\u0001\u0002\u0005\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult;", "T", "", "Success", "Error", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult$Error;", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult$Success;", "signal-service-java"})
    public static interface ProvisioningDecryptResult<T> {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult$Error;", "T", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult;", "<init>", "()V", "signal-service-java"})
        public static final class Error<T>
        implements ProvisioningDecryptResult<T> {
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult$Success;", "T", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult;", "message", "<init>", "(Ljava/lang/Object;)V", "getMessage", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult$Success;", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success<T>
        implements ProvisioningDecryptResult<T> {
            private final T message;

            public Success(T message) {
                this.message = message;
            }

            public final T getMessage() {
                return this.message;
            }

            public final T component1() {
                return this.message;
            }

            @NotNull
            public final Success<T> copy(T message) {
                return new Success<T>(message);
            }

            public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = success.message;
                }
                return success.copy(object);
            }

            @NotNull
            public String toString() {
                return "Success(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message == null ? 0 : this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.message, success.message);
            }
        }
    }
}

