/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.username;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;
import org.signal.libsignal.usernames.Username;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.GetAciByUsernameResponse;
import org.whispersystems.signalservice.internal.push.GetUsernameFromLinkResponseBody;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/whispersystems/signalservice/api/username/UsernameApi;", "", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "getAciByUsername", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "username", "Lorg/signal/libsignal/usernames/Username;", "getEncryptedUsernameFromLinkServerId", "", "serverId", "Ljava/util/UUID;", "signal-service-java"})
public final class UsernameApi {
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;

    public UsernameApi(@NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final NetworkResult<ServiceId.ACI> getAciByUsername(@NotNull Username username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        byte[] byArray = username.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getHash(...)");
        String usernameHash = Base64.encodeUrlSafeWithoutPadding((byte[])byArray);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_hash/" + usernameHash, null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(GetAciByUsernameResponse.class), 0L, 8, null).map(UsernameApi::getAciByUsername$lambda$0);
    }

    @NotNull
    public final NetworkResult<byte[]> getEncryptedUsernameFromLinkServerId(@NotNull UUID serverId) {
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_link/" + serverId, null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(GetUsernameFromLinkResponseBody.class), 0L, 8, null).map(UsernameApi::getEncryptedUsernameFromLinkServerId$lambda$1);
    }

    private static final ServiceId.ACI getAciByUsername$lambda$0(GetAciByUsernameResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UUID uUID = UUID.fromString(it.getUuid());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return ServiceId.ACI.Companion.from(uUID);
    }

    private static final byte[] getEncryptedUsernameFromLinkServerId$lambda$1(GetUsernameFromLinkResponseBody it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Base64.decode((String)it.getUsernameLinkEncryptedValue());
    }
}

