/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.crypto.Crypto;
import org.whispersystems.signalservice.api.storage.StorageItemKey;
import org.whispersystems.signalservice.internal.util.Util;
import org.whispersystems.util.StringUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/RecordIkm;", "", "value", "", "<init>", "([B)V", "getValue", "()[B", "deriveStorageItemKey", "Lorg/whispersystems/signalservice/api/storage/StorageItemKey;", "rawId", "Companion", "signal-service-java"})
public final class RecordIkm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] value;

    public RecordIkm(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final byte[] getValue() {
        return this.value;
    }

    @NotNull
    public final StorageItemKey deriveStorageItemKey(@NotNull byte[] rawId) {
        Intrinsics.checkNotNullParameter((Object)rawId, (String)"rawId");
        byte[] byArray = StringUtil.utf8("20240801_SIGNAL_STORAGE_SERVICE_ITEM_");
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"utf8(...)");
        byte[] key = Crypto.hkdf$default(Crypto.INSTANCE, this.value, ArraysKt.plus((byte[])byArray, (byte[])rawId), 32, null, 8, null);
        return new StorageItemKey(key);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/api/storage/RecordIkm$Companion;", "", "<init>", "()V", "generate", "Lorg/whispersystems/signalservice/api/storage/RecordIkm;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecordIkm generate() {
            byte[] byArray = Util.getSecretBytes(32);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSecretBytes(...)");
            return new RecordIkm(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

