/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.List;
import java.util.Optional;
import org.signal.libsignal.protocol.IdentityKey;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.internal.push.Content;

public class SendMessageResult {
    private final SignalServiceAddress address;
    private final Success success;
    private final boolean networkFailure;
    private final boolean unregisteredFailure;
    private final IdentityFailure identityFailure;
    private final ProofRequiredException proofRequiredFailure;
    private final RateLimitException rateLimitFailure;
    private final boolean invalidPreKeyFailure;

    public static SendMessageResult success(SignalServiceAddress address, List<Integer> devices, boolean unidentified, boolean needsSync, long duration, Optional<Content> content) {
        return new SendMessageResult(address, new Success(unidentified, needsSync, duration, content, devices), false, false, null, null, null, false);
    }

    public static SendMessageResult networkFailure(SignalServiceAddress address) {
        return new SendMessageResult(address, null, true, false, null, null, null, false);
    }

    public static SendMessageResult unregisteredFailure(SignalServiceAddress address) {
        return new SendMessageResult(address, null, false, true, null, null, null, false);
    }

    public static SendMessageResult identityFailure(SignalServiceAddress address, IdentityKey identityKey) {
        return new SendMessageResult(address, null, false, false, new IdentityFailure(identityKey), null, null, false);
    }

    public static SendMessageResult proofRequiredFailure(SignalServiceAddress address, ProofRequiredException proofRequiredException) {
        return new SendMessageResult(address, null, false, false, null, proofRequiredException, null, false);
    }

    public static SendMessageResult rateLimitFailure(SignalServiceAddress address, RateLimitException rateLimitException) {
        return new SendMessageResult(address, null, false, false, null, null, rateLimitException, false);
    }

    public static SendMessageResult invalidPreKeyFailure(SignalServiceAddress address) {
        return new SendMessageResult(address, null, false, false, null, null, null, true);
    }

    public SignalServiceAddress getAddress() {
        return this.address;
    }

    public Success getSuccess() {
        return this.success;
    }

    public boolean isSuccess() {
        return this.success != null;
    }

    public boolean isNetworkFailure() {
        return this.networkFailure || this.proofRequiredFailure != null || this.rateLimitFailure != null;
    }

    public boolean isUnregisteredFailure() {
        return this.unregisteredFailure;
    }

    public IdentityFailure getIdentityFailure() {
        return this.identityFailure;
    }

    public ProofRequiredException getProofRequiredFailure() {
        return this.proofRequiredFailure;
    }

    public RateLimitException getRateLimitFailure() {
        return this.rateLimitFailure;
    }

    public boolean isInvalidPreKeyFailure() {
        return this.invalidPreKeyFailure;
    }

    private SendMessageResult(SignalServiceAddress address, Success success, boolean networkFailure, boolean unregisteredFailure, IdentityFailure identityFailure, ProofRequiredException proofRequiredFailure, RateLimitException rateLimitFailure, boolean invalidPreKeyFailure) {
        this.address = address;
        this.success = success;
        this.networkFailure = networkFailure;
        this.unregisteredFailure = unregisteredFailure;
        this.identityFailure = identityFailure;
        this.proofRequiredFailure = proofRequiredFailure;
        this.rateLimitFailure = rateLimitFailure;
        this.invalidPreKeyFailure = invalidPreKeyFailure;
    }

    public static class Success {
        private final boolean unidentified;
        private final boolean needsSync;
        private final long duration;
        private final Optional<Content> content;
        private final List<Integer> devices;

        private Success(boolean unidentified, boolean needsSync, long duration, Optional<Content> content, List<Integer> devices) {
            this.unidentified = unidentified;
            this.needsSync = needsSync;
            this.duration = duration;
            this.content = content;
            this.devices = devices;
        }

        public boolean isUnidentified() {
            return this.unidentified;
        }

        public boolean isNeedsSync() {
            return this.needsSync;
        }

        public long getDuration() {
            return this.duration;
        }

        public Optional<Content> getContent() {
            return this.content;
        }

        public List<Integer> getDevices() {
            return this.devices;
        }
    }

    public static class IdentityFailure {
        private final IdentityKey identityKey;

        private IdentityFailure(IdentityKey identityKey) {
            this.identityKey = identityKey;
        }

        public IdentityKey getIdentityKey() {
            return this.identityKey;
        }
    }
}

