/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groupsend.GroupSendEndorsement;
import org.signal.libsignal.zkgroup.groupsend.GroupSendFullToken;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000bH\u00c6\u0003J=\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001b\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lorg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements;", "", "expirationMs", "", "endorsements", "", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "Lorg/signal/libsignal/zkgroup/groupsend/GroupSendEndorsement;", "sealedSenderCertificate", "Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "groupSecretParams", "Lorg/signal/libsignal/zkgroup/groups/GroupSecretParams;", "<init>", "(JLjava/util/Map;Lorg/signal/libsignal/metadata/certificate/SenderCertificate;Lorg/signal/libsignal/zkgroup/groups/GroupSecretParams;)V", "getExpirationMs", "()J", "getEndorsements", "()Ljava/util/Map;", "getSealedSenderCertificate", "()Lorg/signal/libsignal/metadata/certificate/SenderCertificate;", "getGroupSecretParams", "()Lorg/signal/libsignal/zkgroup/groups/GroupSecretParams;", "expiration", "Ljava/time/Instant;", "getExpiration", "()Ljava/time/Instant;", "expiration$delegate", "Lkotlin/Lazy;", "combinedEndorsement", "getCombinedEndorsement", "()Lorg/signal/libsignal/zkgroup/groupsend/GroupSendEndorsement;", "combinedEndorsement$delegate", "serialize", "", "forIndividuals", "", "Lorg/signal/libsignal/zkgroup/groupsend/GroupSendFullToken;", "addresses", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nGroupSendEndorsements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupSendEndorsements.kt\norg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1563#2:40\n1634#2,3:41\n1563#2:44\n1634#2,3:45\n*S KotlinDebug\n*F\n+ 1 GroupSendEndorsements.kt\norg/whispersystems/signalservice/api/groupsv2/GroupSendEndorsements\n*L\n35#1:40\n35#1:41,3\n36#1:44\n36#1:45,3\n*E\n"})
public final class GroupSendEndorsements {
    private final long expirationMs;
    @NotNull
    private final Map<ServiceId.ACI, GroupSendEndorsement> endorsements;
    @NotNull
    private final SenderCertificate sealedSenderCertificate;
    @NotNull
    private final GroupSecretParams groupSecretParams;
    @NotNull
    private final Lazy expiration$delegate;
    @NotNull
    private final Lazy combinedEndorsement$delegate;

    public GroupSendEndorsements(long expirationMs, @NotNull Map<ServiceId.ACI, GroupSendEndorsement> endorsements, @NotNull SenderCertificate sealedSenderCertificate, @NotNull GroupSecretParams groupSecretParams) {
        Intrinsics.checkNotNullParameter(endorsements, (String)"endorsements");
        Intrinsics.checkNotNullParameter((Object)sealedSenderCertificate, (String)"sealedSenderCertificate");
        Intrinsics.checkNotNullParameter((Object)groupSecretParams, (String)"groupSecretParams");
        this.expirationMs = expirationMs;
        this.endorsements = endorsements;
        this.sealedSenderCertificate = sealedSenderCertificate;
        this.groupSecretParams = groupSecretParams;
        this.expiration$delegate = LazyKt.lazy(() -> GroupSendEndorsements.expiration_delegate$lambda$0(this));
        this.combinedEndorsement$delegate = LazyKt.lazy(() -> GroupSendEndorsements.combinedEndorsement_delegate$lambda$1(this));
    }

    public final long getExpirationMs() {
        return this.expirationMs;
    }

    @NotNull
    public final Map<ServiceId.ACI, GroupSendEndorsement> getEndorsements() {
        return this.endorsements;
    }

    @NotNull
    public final SenderCertificate getSealedSenderCertificate() {
        return this.sealedSenderCertificate;
    }

    @NotNull
    public final GroupSecretParams getGroupSecretParams() {
        return this.groupSecretParams;
    }

    private final Instant getExpiration() {
        Lazy lazy = this.expiration$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Instant)object;
    }

    private final GroupSendEndorsement getCombinedEndorsement() {
        Lazy lazy = this.combinedEndorsement$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (GroupSendEndorsement)object;
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.getCombinedEndorsement().toFullToken(this.groupSecretParams, this.getExpiration()).serialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GroupSendFullToken> forIndividuals(@NotNull List<? extends SignalServiceAddress> addresses) {
        GroupSendEndorsement a;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Iterable $this$map$iv = addresses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SignalServiceAddress signalServiceAddress = (SignalServiceAddress)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.endorsements.get(a.getServiceId()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void e;
            a = (GroupSendEndorsement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = e;
            collection.add(v0 != null ? v0.toFullToken(this.groupSecretParams, this.getExpiration()) : null);
        }
        return (List)destination$iv$iv;
    }

    public final long component1() {
        return this.expirationMs;
    }

    @NotNull
    public final Map<ServiceId.ACI, GroupSendEndorsement> component2() {
        return this.endorsements;
    }

    @NotNull
    public final SenderCertificate component3() {
        return this.sealedSenderCertificate;
    }

    @NotNull
    public final GroupSecretParams component4() {
        return this.groupSecretParams;
    }

    @NotNull
    public final GroupSendEndorsements copy(long expirationMs, @NotNull Map<ServiceId.ACI, GroupSendEndorsement> endorsements, @NotNull SenderCertificate sealedSenderCertificate, @NotNull GroupSecretParams groupSecretParams) {
        Intrinsics.checkNotNullParameter(endorsements, (String)"endorsements");
        Intrinsics.checkNotNullParameter((Object)sealedSenderCertificate, (String)"sealedSenderCertificate");
        Intrinsics.checkNotNullParameter((Object)groupSecretParams, (String)"groupSecretParams");
        return new GroupSendEndorsements(expirationMs, endorsements, sealedSenderCertificate, groupSecretParams);
    }

    public static /* synthetic */ GroupSendEndorsements copy$default(GroupSendEndorsements groupSendEndorsements, long l, Map map, SenderCertificate senderCertificate, GroupSecretParams groupSecretParams, int n, Object object) {
        if ((n & 1) != 0) {
            l = groupSendEndorsements.expirationMs;
        }
        if ((n & 2) != 0) {
            map = groupSendEndorsements.endorsements;
        }
        if ((n & 4) != 0) {
            senderCertificate = groupSendEndorsements.sealedSenderCertificate;
        }
        if ((n & 8) != 0) {
            groupSecretParams = groupSendEndorsements.groupSecretParams;
        }
        return groupSendEndorsements.copy(l, map, senderCertificate, groupSecretParams);
    }

    @NotNull
    public String toString() {
        return "GroupSendEndorsements(expirationMs=" + this.expirationMs + ", endorsements=" + this.endorsements + ", sealedSenderCertificate=" + this.sealedSenderCertificate + ", groupSecretParams=" + this.groupSecretParams + ")";
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.expirationMs);
        result2 = result2 * 31 + ((Object)this.endorsements).hashCode();
        result2 = result2 * 31 + this.sealedSenderCertificate.hashCode();
        result2 = result2 * 31 + this.groupSecretParams.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupSendEndorsements)) {
            return false;
        }
        GroupSendEndorsements groupSendEndorsements = (GroupSendEndorsements)other;
        if (this.expirationMs != groupSendEndorsements.expirationMs) {
            return false;
        }
        if (!Intrinsics.areEqual(this.endorsements, groupSendEndorsements.endorsements)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sealedSenderCertificate, (Object)groupSendEndorsements.sealedSenderCertificate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.groupSecretParams, (Object)groupSendEndorsements.groupSecretParams);
    }

    private static final Instant expiration_delegate$lambda$0(GroupSendEndorsements this$0) {
        return Instant.ofEpochMilli(this$0.expirationMs);
    }

    private static final GroupSendEndorsement combinedEndorsement_delegate$lambda$1(GroupSendEndorsements this$0) {
        return GroupSendEndorsement.combine(this$0.endorsements.values());
    }
}

