/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.concurrent;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.signal.core.util.concurrent.ListenableFuture;

public class SettableFuture<T>
implements ListenableFuture<T> {
    private final List<ListenableFuture.Listener<T>> listeners = new LinkedList<ListenableFuture.Listener<T>>();
    private boolean completed;
    private boolean canceled;
    private volatile T result;
    private volatile Throwable exception;

    public SettableFuture() {
    }

    public SettableFuture(T value) {
        this.result = value;
        this.completed = true;
    }

    public SettableFuture(Throwable throwable) {
        this.exception = throwable;
        this.completed = true;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.completed && !this.canceled) {
            this.canceled = true;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(T result) {
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            if (this.completed || this.canceled) {
                return false;
            }
            this.result = result;
            this.completed = true;
            this.notifyAll();
        }
        this.notifyAllListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setException(Throwable throwable) {
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            if (this.completed || this.canceled) {
                return false;
            }
            this.exception = throwable;
            this.completed = true;
            this.notifyAll();
        }
        this.notifyAllListeners();
        return true;
    }

    public void deferTo(ListenableFuture<T> other) {
        other.addListener(new ListenableFuture.Listener<T>(){

            @Override
            public void onSuccess(T result) {
                SettableFuture.this.set(result);
            }

            @Override
            public void onFailure(ExecutionException e) {
                SettableFuture.this.setException(e.getCause());
            }
        });
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long startTime = System.currentTimeMillis();
        while (!this.completed && System.currentTimeMillis() - startTime < unit.toMillis(timeout)) {
            this.wait(unit.toMillis(timeout));
        }
        if (!this.completed) {
            throw new TimeoutException();
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ListenableFuture.Listener<T> listener) {
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            this.listeners.add(listener);
            if (!this.completed) {
                return;
            }
        }
        this.notifyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners() {
        LinkedList<ListenableFuture.Listener<T>> localListeners;
        SettableFuture settableFuture = this;
        synchronized (settableFuture) {
            localListeners = new LinkedList<ListenableFuture.Listener<T>>(this.listeners);
        }
        for (ListenableFuture.Listener listener : localListeners) {
            this.notifyListener(listener);
        }
    }

    private void notifyListener(ListenableFuture.Listener<T> listener) {
        if (this.exception != null) {
            listener.onFailure(new ExecutionException(this.exception));
        } else {
            listener.onSuccess(this.result);
        }
    }
}

