/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.receipts;

import java.security.SecureRandom;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.ServerSecretParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialRequest;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialResponse;

public class ServerZkReceiptOperations {
    private final ServerSecretParams serverSecretParams;

    public ServerZkReceiptOperations(ServerSecretParams serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }

    public ReceiptCredentialResponse issueReceiptCredential(ReceiptCredentialRequest receiptCredentialRequest, long receiptExpirationTime, long receiptLevel) throws VerificationFailedException {
        return this.issueReceiptCredential(new SecureRandom(), receiptCredentialRequest, receiptExpirationTime, receiptLevel);
    }

    public ReceiptCredentialResponse issueReceiptCredential(SecureRandom secureRandom, ReceiptCredentialRequest receiptCredentialRequest, long receiptExpirationTime, long receiptLevel) throws VerificationFailedException {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = this.serverSecretParams.guardedMap(serverSecretParams -> Native.ServerSecretParams_IssueReceiptCredentialDeterministic(serverSecretParams, random, receiptCredentialRequest.getInternalContentsForJNI(), receiptExpirationTime, receiptLevel));
        try {
            return new ReceiptCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifyReceiptCredentialPresentation(ReceiptCredentialPresentation receiptCredentialPresentation) throws VerificationFailedException {
        FilterExceptions.filterExceptions(VerificationFailedException.class, () -> this.serverSecretParams.guardedRunChecked(secretParams -> Native.ServerSecretParams_VerifyReceiptCredentialPresentation(secretParams, receiptCredentialPresentation.getInternalContentsForJNI())));
    }
}

