/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.incrementalmac;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.InvalidMacException;

public final class IncrementalMacInputStream
extends InputStream {
    private final NativeHandleGuard.CloseableOwner handleOwner;
    private final int chunkSize;
    private final MaybeEmptyChannel channel;
    private boolean closed = false;
    private boolean eof = false;
    private ReadState readState;
    private final ByteBuffer currentChunk;
    private static final int VALIDATION_BUFFER_SIZE = 8192;
    private final byte[] singleByteBuffer = new byte[1];
    private final byte[] chunkValidationBuffer;

    IncrementalMacInputStream(ReadableByteChannel channel, byte[] key, ChunkSizeChoice sizeChoice, byte[] digest, boolean useDirectBuffer) {
        this.chunkSize = sizeChoice.getSizeInBytes();
        this.currentChunk = useDirectBuffer ? ByteBuffer.allocateDirect(this.chunkSize) : ByteBuffer.allocate(this.chunkSize);
        this.chunkValidationBuffer = this.currentChunk.hasArray() ? null : new byte[8192];
        this.channel = new MaybeEmptyChannel(channel);
        this.readState = ReadState.READ_FROM_INPUT;
        this.handleOwner = new NativeHandleGuard.CloseableOwner(Native.ValidatingMac_Initialize(key, this.chunkSize, digest)){

            @Override
            protected void release(long nativeHandle) {
                Native.ValidatingMac_Destroy(nativeHandle);
            }
        };
    }

    public IncrementalMacInputStream(InputStream input, byte[] key, ChunkSizeChoice sizeChoice, byte[] digest) {
        this(Channels.newChannel(input), key, sizeChoice, digest, true);
    }

    @Override
    public int read() throws IOException {
        int read = 0;
        while (read == 0) {
            read = this.readInternal(this.singleByteBuffer, 0, 1);
        }
        return read == -1 ? -1 : Byte.toUnsignedInt(this.singleByteBuffer[0]);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("Destination buffer is not large enough");
        }
        return this.readInternal(bytes, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.channel.close();
        this.handleOwner.close();
    }

    private ReadChunkResult readFromInput() throws IOException {
        int bytesRead = this.channel.read(this.currentChunk);
        if (bytesRead == -1) {
            this.eof = true;
            if (!this.channel.hasAtLeastOneByteBeenRead) {
                this.handleOwner.guardedRun(handle -> Native.ValidatingMac_Update(handle, this.singleByteBuffer, 0, 0));
                return ReadChunkResult.EOF;
            }
        }
        if (!this.currentChunk.hasRemaining() || this.eof) {
            this.currentChunk.flip();
            this.validateChunk(this.currentChunk.slice());
            this.readState = ReadState.RELEASE_SAFE_BYTES;
        }
        return ReadChunkResult.PARTIAL_CHUNK_READ;
    }

    private int releaseSafeBytes(byte[] bytes, int offset, int requestedLen) throws IOException {
        if (this.currentChunk.hasRemaining()) {
            int bytesToRelease = Math.min(this.currentChunk.remaining(), requestedLen);
            this.currentChunk.get(bytes, offset, bytesToRelease);
            return bytesToRelease;
        }
        if (this.eof) {
            return -1;
        }
        this.currentChunk.clear();
        this.readState = ReadState.READ_FROM_INPUT;
        return 0;
    }

    private int readInternal(byte[] bytes, int offset, int requestedLen) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        return switch (this.readState) {
            default -> throw new IncompatibleClassChangeError();
            case ReadState.READ_FROM_INPUT -> this.readFromInput().getValue();
            case ReadState.RELEASE_SAFE_BYTES -> this.releaseSafeBytes(bytes, offset, requestedLen);
        };
    }

    private void validateChunk(ByteBuffer chunk) throws IOException {
        assert (chunk.limit() == chunk.capacity()) : "Must be invoked with ByteBuffer.slice()";
        IncrementalMacInputStream.assertValidBytes(this.validateChunkImpl(chunk));
        if (this.eof) {
            int validBytes = this.handleOwner.guardedMap(Native::ValidatingMac_Finalize);
            IncrementalMacInputStream.assertValidBytes(validBytes);
        }
    }

    private static void assertValidBytes(int validBytesCount) throws InvalidMacException {
        if (validBytesCount < 0) {
            throw new InvalidMacException();
        }
    }

    private int validateChunkImpl(ByteBuffer chunk) {
        return chunk.hasArray() ? this.validateChunkBackedByArray(chunk) : this.validateChunkWithExtraBuffer(chunk);
    }

    private int validateChunkWithExtraBuffer(ByteBuffer chunk) {
        int validBytes = 0;
        int bufferLimit = Math.min(chunk.limit(), 8192);
        while (chunk.hasRemaining()) {
            int currentlyValidating = Math.min(bufferLimit, chunk.remaining());
            chunk.get(this.chunkValidationBuffer, 0, currentlyValidating);
            validBytes = this.handleOwner.guardedMap(handle -> Native.ValidatingMac_Update(handle, this.chunkValidationBuffer, 0, currentlyValidating));
            assert (validBytes == 0 || validBytes == -1 || validBytes == this.chunkSize) : "Unexpected incremental mac update result";
        }
        return validBytes;
    }

    private int validateChunkBackedByArray(ByteBuffer chunk) {
        int arrayOffset = chunk.arrayOffset();
        int validBytes = this.handleOwner.guardedMap(handle -> Native.ValidatingMac_Update(handle, chunk.array(), arrayOffset, chunk.limit()));
        assert (validBytes == 0 || validBytes == -1 || validBytes == this.chunkSize) : "Unexpected incremental mac update result";
        return validBytes;
    }

    private static class MaybeEmptyChannel
    implements ReadableByteChannel {
        private final ReadableByteChannel inner;
        private boolean hasAtLeastOneByteBeenRead = false;

        private MaybeEmptyChannel(ReadableByteChannel inner) {
            this.inner = inner;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int result = this.inner.read(dst);
            if (result > 0) {
                this.hasAtLeastOneByteBeenRead = true;
            }
            return result;
        }

        @Override
        public boolean isOpen() {
            return this.inner.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }
    }

    private static enum ReadState {
        READ_FROM_INPUT,
        RELEASE_SAFE_BYTES;

    }

    private static enum ReadChunkResult {
        PARTIAL_CHUNK_READ(0),
        EOF(-1);

        private final int value;

        private ReadChunkResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

