/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.time.Duration;
import java.util.Set;
import java.util.function.LongToIntFunction;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.net.ChallengeOption;

public class RegistrationSessionState
extends NativeHandleGuard.SimpleOwner {
    RegistrationSessionState(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.RegistrationSession_Destroy(nativeHandle);
    }

    public boolean getAllowedToRequestCode() {
        return this.guardedMap(Native::RegistrationSession_GetAllowedToRequestCode);
    }

    public boolean getVerified() {
        return this.guardedMap(Native::RegistrationSession_GetVerified);
    }

    public Duration getNextCall() {
        return this.ofOptionalDurationSeconds(Native::RegistrationSession_GetNextCallSeconds);
    }

    public Duration getNextSms() {
        return this.ofOptionalDurationSeconds(Native::RegistrationSession_GetNextSmsSeconds);
    }

    public Duration getNextVerificationAttempt() {
        return this.ofOptionalDurationSeconds(Native::RegistrationSession_GetNextVerificationAttemptSeconds);
    }

    public Set<ChallengeOption> getRequestedInformation() {
        return Set.of((ChallengeOption[])this.guardedMap(Native::RegistrationSession_GetRequestedInformation));
    }

    private Duration ofOptionalDurationSeconds(LongToIntFunction getter) {
        int nextCallSeconds = this.guardedMap(handle -> getter.applyAsInt(handle));
        if (nextCallSeconds < 0) {
            return null;
        }
        return Duration.ofSeconds(nextCallSeconds);
    }
}

