/*****************************************************************************
 * Copyright (C) 2021 VLC authors and VideoLAN
 *
 * Authors: Prince Gupta <guptaprince8832@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * ( at your option ) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

import QtQuick

import VLC.Style
import VLC.Util

Rectangle {
    id: root

    //---------------------------------------------------------------------------------------------
    // Settings
    //---------------------------------------------------------------------------------------------

    property int animationDuration: VLCStyle.duration_long

    readonly property bool animationRunning: borderAnimation.running || bgAnimation.running

    //---------------------------------------------------------------------------------------------
    // Implementation
    //---------------------------------------------------------------------------------------------

    color: "transparent"

    border.width: VLCStyle.focus_border

    //---------------------------------------------------------------------------------------------
    // Animations
    //---------------------------------------------------------------------------------------------

    DelayedBehavior on border.color {
        delayedEnabled: root.enabled

        ColorAnimation {
            id: borderAnimation

            duration: root.animationDuration
        }
    }

    DelayedBehavior on color {
        delayedEnabled: root.enabled

        ColorAnimation {
            id: bgAnimation

            duration: root.animationDuration
        }
    }
}
