/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class AquaMenuItemUI
extends BasicMenuItemUI
implements AquaMenuPainter.Client {
    static final int kPlain = 0;
    static final int kCheckBox = 1;
    static final int kRadioButton = 2;
    static final String[] sPropertyPrefixes = new String[]{"MenuItem", "CheckBoxMenuItem", "RadioButtonMenuItem"};
    boolean fIsScreenMenuItem = false;
    boolean fIsIndeterminate = false;
    int fType;
    static final IndeterminateListener INDETERMINATE_LISTENER = new IndeterminateListener();

    AquaMenuItemUI(int n) {
        this.fType = n;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        int n = 0;
        if (jComponent instanceof JCheckBoxMenuItem) {
            n = 1;
        }
        if (jComponent instanceof JRadioButtonMenuItem) {
            n = 2;
        }
        return new AquaMenuItemUI(n);
    }

    @Override
    protected String getPropertyPrefix() {
        return sPropertyPrefixes[this.fType];
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        IndeterminateListener.install(this.menuItem);
    }

    @Override
    protected void uninstallListeners() {
        IndeterminateListener.uninstall(this.menuItem);
        super.uninstallListeners();
    }

    public void updateListenersForScreenMenuItem() {
        this.setIsScreenMenu(true);
    }

    protected void setIsScreenMenu(boolean bl) {
        if (this.fIsScreenMenuItem != bl) {
            this.fIsScreenMenuItem = bl;
            if (this.fIsScreenMenuItem) {
                this.removeListeners();
            } else {
                this.addListeners();
            }
        }
    }

    protected void removeListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void addListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        AquaMenuPainter.instance().paintMenuItem(this, graphics, jComponent, icon, icon2, color, color2, this.disabledForeground, this.selectionForeground, n, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        return AquaMenuPainter.instance().getPreferredMenuItemSize(jComponent, icon, icon2, n, this.acceleratorFont);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            Color color = graphics.getColor();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(color);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paintBackground(Graphics graphics, JComponent jComponent, int n, int n2) {
        if (jComponent.getParent() instanceof JMenuBar) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (((JMenuItem)jComponent).isBorderPainted()) {
            if (((JMenuItem)jComponent).getModel().isArmed()) {
                AquaMenuPainter.instance().paintSelectedMenuItemBackground(graphics, n, n2);
            }
        } else if (((JMenuItem)jComponent).getModel().isArmed()) {
            Color color2 = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
        } else {
            graphics.setColor(Color.green);
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color);
    }

    @Override
    protected void doClick(MenuSelectionManager menuSelectionManager) {
        final Dimension dimension = this.menuItem.getSize();
        AquaUtils.blinkMenu(new AquaUtils.Selectable(){

            @Override
            public void paintSelected(boolean bl) {
                AquaMenuItemUI.this.menuItem.setArmed(bl);
                AquaMenuItemUI.this.menuItem.paintImmediately(0, 0, dimension.width, dimension.height);
            }
        });
        super.doClick(menuSelectionManager);
    }

    static class IndeterminateListener
    implements PropertyChangeListener {
        static final String CLIENT_PROPERTY_KEY = "JMenuItem.selectedState";

        IndeterminateListener() {
        }

        static void install(JMenuItem jMenuItem) {
            jMenuItem.addPropertyChangeListener(CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
            IndeterminateListener.apply(jMenuItem, jMenuItem.getClientProperty(CLIENT_PROPERTY_KEY));
        }

        static void uninstall(JMenuItem jMenuItem) {
            jMenuItem.removePropertyChangeListener(CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!CLIENT_PROPERTY_KEY.equalsIgnoreCase(string)) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof JMenuItem)) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)object;
            IndeterminateListener.apply(jMenuItem, propertyChangeEvent.getNewValue());
        }

        static void apply(JMenuItem jMenuItem, Object object) {
            ButtonUI buttonUI = jMenuItem.getUI();
            if (!(buttonUI instanceof AquaMenuItemUI)) {
                return;
            }
            AquaMenuItemUI aquaMenuItemUI = (AquaMenuItemUI)buttonUI;
            aquaMenuItemUI.fIsIndeterminate = "indeterminate".equals(object);
            if (aquaMenuItemUI.fIsIndeterminate) {
                aquaMenuItemUI.checkIcon = UIManager.getIcon(aquaMenuItemUI.getPropertyPrefix() + ".dashIcon");
            } else {
                aquaMenuItemUI.checkIcon = UIManager.getIcon(aquaMenuItemUI.getPropertyPrefix() + ".checkIcon");
            }
        }

        public static boolean isIndeterminate(JMenuItem jMenuItem) {
            return "indeterminate".equals(jMenuItem.getClientProperty(CLIENT_PROPERTY_KEY));
        }
    }
}

