// automatically generated by stateify.

package kernel

import (
	"context"

	"gvisor.dev/gvisor/pkg/state"
	"gvisor.dev/gvisor/pkg/tcpip"
)

func (c *Cgroup) StateTypeName() string {
	return "pkg/sentry/kernel.Cgroup"
}

func (c *Cgroup) StateFields() []string {
	return []string{
		"Dentry",
		"CgroupImpl",
	}
}

func (c *Cgroup) beforeSave() {}

// +checklocksignore
func (c *Cgroup) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.Dentry)
	stateSinkObject.Save(1, &c.CgroupImpl)
}

func (c *Cgroup) afterLoad(context.Context) {}

// +checklocksignore
func (c *Cgroup) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.Dentry)
	stateSourceObject.Load(1, &c.CgroupImpl)
}

func (h *hierarchy) StateTypeName() string {
	return "pkg/sentry/kernel.hierarchy"
}

func (h *hierarchy) StateFields() []string {
	return []string{
		"id",
		"name",
		"controllers",
		"fs",
	}
}

func (h *hierarchy) beforeSave() {}

// +checklocksignore
func (h *hierarchy) StateSave(stateSinkObject state.Sink) {
	h.beforeSave()
	stateSinkObject.Save(0, &h.id)
	stateSinkObject.Save(1, &h.name)
	stateSinkObject.Save(2, &h.controllers)
	stateSinkObject.Save(3, &h.fs)
}

func (h *hierarchy) afterLoad(context.Context) {}

// +checklocksignore
func (h *hierarchy) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &h.id)
	stateSourceObject.Load(1, &h.name)
	stateSourceObject.Load(2, &h.controllers)
	stateSourceObject.Load(3, &h.fs)
}

func (r *CgroupRegistry) StateTypeName() string {
	return "pkg/sentry/kernel.CgroupRegistry"
}

func (r *CgroupRegistry) StateFields() []string {
	return []string{
		"lastHierarchyID",
		"lastCgroupID",
		"controllers",
		"hierarchies",
		"hierarchiesByName",
		"cgroups",
	}
}

func (r *CgroupRegistry) beforeSave() {}

// +checklocksignore
func (r *CgroupRegistry) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.lastHierarchyID)
	stateSinkObject.Save(1, &r.lastCgroupID)
	stateSinkObject.Save(2, &r.controllers)
	stateSinkObject.Save(3, &r.hierarchies)
	stateSinkObject.Save(4, &r.hierarchiesByName)
	stateSinkObject.Save(5, &r.cgroups)
}

func (r *CgroupRegistry) afterLoad(context.Context) {}

// +checklocksignore
func (r *CgroupRegistry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.lastHierarchyID)
	stateSourceObject.Load(1, &r.lastCgroupID)
	stateSourceObject.Load(2, &r.controllers)
	stateSourceObject.Load(3, &r.hierarchies)
	stateSourceObject.Load(4, &r.hierarchiesByName)
	stateSourceObject.Load(5, &r.cgroups)
}

func (f *FDFlags) StateTypeName() string {
	return "pkg/sentry/kernel.FDFlags"
}

func (f *FDFlags) StateFields() []string {
	return []string{
		"CloseOnExec",
	}
}

func (f *FDFlags) beforeSave() {}

// +checklocksignore
func (f *FDFlags) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.CloseOnExec)
}

func (f *FDFlags) afterLoad(context.Context) {}

// +checklocksignore
func (f *FDFlags) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.CloseOnExec)
}

func (d *descriptor) StateTypeName() string {
	return "pkg/sentry/kernel.descriptor"
}

func (d *descriptor) StateFields() []string {
	return []string{
		"file",
		"flags",
	}
}

func (d *descriptor) beforeSave() {}

// +checklocksignore
func (d *descriptor) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.file)
	stateSinkObject.Save(1, &d.flags)
}

func (d *descriptor) afterLoad(context.Context) {}

// +checklocksignore
func (d *descriptor) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.file)
	stateSourceObject.Load(1, &d.flags)
}

func (f *FDTable) StateTypeName() string {
	return "pkg/sentry/kernel.FDTable"
}

func (f *FDTable) StateFields() []string {
	return []string{
		"FDTableRefs",
		"k",
		"descriptorTable",
	}
}

func (f *FDTable) beforeSave() {}

// +checklocksignore
func (f *FDTable) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	var descriptorTableValue map[int32]descriptor
	descriptorTableValue = f.saveDescriptorTable()
	stateSinkObject.SaveValue(2, descriptorTableValue)
	stateSinkObject.Save(0, &f.FDTableRefs)
	stateSinkObject.Save(1, &f.k)
}

func (f *FDTable) afterLoad(context.Context) {}

// +checklocksignore
func (f *FDTable) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.FDTableRefs)
	stateSourceObject.Load(1, &f.k)
	stateSourceObject.LoadValue(2, new(map[int32]descriptor), func(y any) { f.loadDescriptorTable(ctx, y.(map[int32]descriptor)) })
}

func (r *FDTableRefs) StateTypeName() string {
	return "pkg/sentry/kernel.FDTableRefs"
}

func (r *FDTableRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FDTableRefs) beforeSave() {}

// +checklocksignore
func (r *FDTableRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FDTableRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (f *FSContext) StateTypeName() string {
	return "pkg/sentry/kernel.FSContext"
}

func (f *FSContext) StateFields() []string {
	return []string{
		"FSContextRefs",
		"root",
		"cwd",
		"umask",
	}
}

func (f *FSContext) beforeSave() {}

// +checklocksignore
func (f *FSContext) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.FSContextRefs)
	stateSinkObject.Save(1, &f.root)
	stateSinkObject.Save(2, &f.cwd)
	stateSinkObject.Save(3, &f.umask)
}

func (f *FSContext) afterLoad(context.Context) {}

// +checklocksignore
func (f *FSContext) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.FSContextRefs)
	stateSourceObject.Load(1, &f.root)
	stateSourceObject.Load(2, &f.cwd)
	stateSourceObject.Load(3, &f.umask)
}

func (r *FSContextRefs) StateTypeName() string {
	return "pkg/sentry/kernel.FSContextRefs"
}

func (r *FSContextRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FSContextRefs) beforeSave() {}

// +checklocksignore
func (r *FSContextRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FSContextRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (i *IPCNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.IPCNamespace"
}

func (i *IPCNamespace) StateFields() []string {
	return []string{
		"inode",
		"userNS",
		"queues",
		"semaphores",
		"shms",
		"posixQueues",
	}
}

func (i *IPCNamespace) beforeSave() {}

// +checklocksignore
func (i *IPCNamespace) StateSave(stateSinkObject state.Sink) {
	i.beforeSave()
	stateSinkObject.Save(0, &i.inode)
	stateSinkObject.Save(1, &i.userNS)
	stateSinkObject.Save(2, &i.queues)
	stateSinkObject.Save(3, &i.semaphores)
	stateSinkObject.Save(4, &i.shms)
	stateSinkObject.Save(5, &i.posixQueues)
}

func (i *IPCNamespace) afterLoad(context.Context) {}

// +checklocksignore
func (i *IPCNamespace) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &i.inode)
	stateSourceObject.Load(1, &i.userNS)
	stateSourceObject.Load(2, &i.queues)
	stateSourceObject.Load(3, &i.semaphores)
	stateSourceObject.Load(4, &i.shms)
	stateSourceObject.Load(5, &i.posixQueues)
}

func (uc *UserCounters) StateTypeName() string {
	return "pkg/sentry/kernel.UserCounters"
}

func (uc *UserCounters) StateFields() []string {
	return []string{
		"uid",
		"rlimitNProc",
	}
}

func (uc *UserCounters) beforeSave() {}

// +checklocksignore
func (uc *UserCounters) StateSave(stateSinkObject state.Sink) {
	uc.beforeSave()
	stateSinkObject.Save(0, &uc.uid)
	stateSinkObject.Save(1, &uc.rlimitNProc)
}

func (uc *UserCounters) afterLoad(context.Context) {}

// +checklocksignore
func (uc *UserCounters) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &uc.uid)
	stateSourceObject.Load(1, &uc.rlimitNProc)
}

func (c *CgroupMount) StateTypeName() string {
	return "pkg/sentry/kernel.CgroupMount"
}

func (c *CgroupMount) StateFields() []string {
	return []string{
		"Fs",
		"Root",
		"Mount",
	}
}

func (c *CgroupMount) beforeSave() {}

// +checklocksignore
func (c *CgroupMount) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.Fs)
	stateSinkObject.Save(1, &c.Root)
	stateSinkObject.Save(2, &c.Mount)
}

func (c *CgroupMount) afterLoad(context.Context) {}

// +checklocksignore
func (c *CgroupMount) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.Fs)
	stateSourceObject.Load(1, &c.Root)
	stateSourceObject.Load(2, &c.Mount)
}

func (k *Kernel) StateTypeName() string {
	return "pkg/sentry/kernel.Kernel"
}

func (k *Kernel) StateFields() []string {
	return []string{
		"featureSet",
		"timekeeper",
		"tasks",
		"rootUserNamespace",
		"rootNetworkNamespace",
		"applicationCores",
		"useHostCores",
		"extraAuxv",
		"vdso",
		"vdsoParams",
		"rootUTSNamespace",
		"rootIPCNamespace",
		"futexes",
		"globalInit",
		"syslog",
		"runningTasks",
		"cpuClockTickerRunning",
		"cpuClock",
		"uniqueID",
		"nextInotifyCookie",
		"netlinkPorts",
		"danglingEndpoints",
		"sockets",
		"nextSocketRecord",
		"SpecialOpts",
		"vfs",
		"hostMount",
		"pipeMount",
		"nsfsMount",
		"shmMount",
		"socketMount",
		"sysVShmDevID",
		"SleepForAddressSpaceActivation",
		"ptraceExceptions",
		"YAMAPtraceScope",
		"cgroupRegistry",
		"cgroupMountsMap",
		"userCountersMap",
		"MaxFDLimit",
		"containerNames",
		"additionalCheckpointState",
		"CheckpointWait",
		"checkpointGen",
		"UnixSocketOpts",
	}
}

func (k *Kernel) beforeSave() {}

// +checklocksignore
func (k *Kernel) StateSave(stateSinkObject state.Sink) {
	k.beforeSave()
	var danglingEndpointsValue []tcpip.Endpoint
	danglingEndpointsValue = k.saveDanglingEndpoints()
	stateSinkObject.SaveValue(21, danglingEndpointsValue)
	stateSinkObject.Save(0, &k.featureSet)
	stateSinkObject.Save(1, &k.timekeeper)
	stateSinkObject.Save(2, &k.tasks)
	stateSinkObject.Save(3, &k.rootUserNamespace)
	stateSinkObject.Save(4, &k.rootNetworkNamespace)
	stateSinkObject.Save(5, &k.applicationCores)
	stateSinkObject.Save(6, &k.useHostCores)
	stateSinkObject.Save(7, &k.extraAuxv)
	stateSinkObject.Save(8, &k.vdso)
	stateSinkObject.Save(9, &k.vdsoParams)
	stateSinkObject.Save(10, &k.rootUTSNamespace)
	stateSinkObject.Save(11, &k.rootIPCNamespace)
	stateSinkObject.Save(12, &k.futexes)
	stateSinkObject.Save(13, &k.globalInit)
	stateSinkObject.Save(14, &k.syslog)
	stateSinkObject.Save(15, &k.runningTasks)
	stateSinkObject.Save(16, &k.cpuClockTickerRunning)
	stateSinkObject.Save(17, &k.cpuClock)
	stateSinkObject.Save(18, &k.uniqueID)
	stateSinkObject.Save(19, &k.nextInotifyCookie)
	stateSinkObject.Save(20, &k.netlinkPorts)
	stateSinkObject.Save(22, &k.sockets)
	stateSinkObject.Save(23, &k.nextSocketRecord)
	stateSinkObject.Save(24, &k.SpecialOpts)
	stateSinkObject.Save(25, &k.vfs)
	stateSinkObject.Save(26, &k.hostMount)
	stateSinkObject.Save(27, &k.pipeMount)
	stateSinkObject.Save(28, &k.nsfsMount)
	stateSinkObject.Save(29, &k.shmMount)
	stateSinkObject.Save(30, &k.socketMount)
	stateSinkObject.Save(31, &k.sysVShmDevID)
	stateSinkObject.Save(32, &k.SleepForAddressSpaceActivation)
	stateSinkObject.Save(33, &k.ptraceExceptions)
	stateSinkObject.Save(34, &k.YAMAPtraceScope)
	stateSinkObject.Save(35, &k.cgroupRegistry)
	stateSinkObject.Save(36, &k.cgroupMountsMap)
	stateSinkObject.Save(37, &k.userCountersMap)
	stateSinkObject.Save(38, &k.MaxFDLimit)
	stateSinkObject.Save(39, &k.containerNames)
	stateSinkObject.Save(40, &k.additionalCheckpointState)
	stateSinkObject.Save(41, &k.CheckpointWait)
	stateSinkObject.Save(42, &k.checkpointGen)
	stateSinkObject.Save(43, &k.UnixSocketOpts)
}

func (k *Kernel) afterLoad(context.Context) {}

// +checklocksignore
func (k *Kernel) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &k.featureSet)
	stateSourceObject.Load(1, &k.timekeeper)
	stateSourceObject.Load(2, &k.tasks)
	stateSourceObject.Load(3, &k.rootUserNamespace)
	stateSourceObject.Load(4, &k.rootNetworkNamespace)
	stateSourceObject.Load(5, &k.applicationCores)
	stateSourceObject.Load(6, &k.useHostCores)
	stateSourceObject.Load(7, &k.extraAuxv)
	stateSourceObject.Load(8, &k.vdso)
	stateSourceObject.Load(9, &k.vdsoParams)
	stateSourceObject.Load(10, &k.rootUTSNamespace)
	stateSourceObject.Load(11, &k.rootIPCNamespace)
	stateSourceObject.Load(12, &k.futexes)
	stateSourceObject.Load(13, &k.globalInit)
	stateSourceObject.Load(14, &k.syslog)
	stateSourceObject.Load(15, &k.runningTasks)
	stateSourceObject.Load(16, &k.cpuClockTickerRunning)
	stateSourceObject.Load(17, &k.cpuClock)
	stateSourceObject.Load(18, &k.uniqueID)
	stateSourceObject.Load(19, &k.nextInotifyCookie)
	stateSourceObject.Load(20, &k.netlinkPorts)
	stateSourceObject.Load(22, &k.sockets)
	stateSourceObject.Load(23, &k.nextSocketRecord)
	stateSourceObject.Load(24, &k.SpecialOpts)
	stateSourceObject.Load(25, &k.vfs)
	stateSourceObject.Load(26, &k.hostMount)
	stateSourceObject.Load(27, &k.pipeMount)
	stateSourceObject.Load(28, &k.nsfsMount)
	stateSourceObject.Load(29, &k.shmMount)
	stateSourceObject.Load(30, &k.socketMount)
	stateSourceObject.Load(31, &k.sysVShmDevID)
	stateSourceObject.Load(32, &k.SleepForAddressSpaceActivation)
	stateSourceObject.Load(33, &k.ptraceExceptions)
	stateSourceObject.Load(34, &k.YAMAPtraceScope)
	stateSourceObject.Load(35, &k.cgroupRegistry)
	stateSourceObject.Load(36, &k.cgroupMountsMap)
	stateSourceObject.Load(37, &k.userCountersMap)
	stateSourceObject.Load(38, &k.MaxFDLimit)
	stateSourceObject.Load(39, &k.containerNames)
	stateSourceObject.Load(40, &k.additionalCheckpointState)
	stateSourceObject.Load(41, &k.CheckpointWait)
	stateSourceObject.Load(42, &k.checkpointGen)
	stateSourceObject.Load(43, &k.UnixSocketOpts)
	stateSourceObject.LoadValue(21, new([]tcpip.Endpoint), func(y any) { k.loadDanglingEndpoints(ctx, y.([]tcpip.Endpoint)) })
}

func (p *privateMemoryFileMetadata) StateTypeName() string {
	return "pkg/sentry/kernel.privateMemoryFileMetadata"
}

func (p *privateMemoryFileMetadata) StateFields() []string {
	return []string{
		"owners",
	}
}

func (p *privateMemoryFileMetadata) beforeSave() {}

// +checklocksignore
func (p *privateMemoryFileMetadata) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.owners)
}

func (p *privateMemoryFileMetadata) afterLoad(context.Context) {}

// +checklocksignore
func (p *privateMemoryFileMetadata) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.owners)
}

func (s *SocketRecord) StateTypeName() string {
	return "pkg/sentry/kernel.SocketRecord"
}

func (s *SocketRecord) StateFields() []string {
	return []string{
		"k",
		"Sock",
		"ID",
	}
}

func (s *SocketRecord) beforeSave() {}

// +checklocksignore
func (s *SocketRecord) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.k)
	stateSinkObject.Save(1, &s.Sock)
	stateSinkObject.Save(2, &s.ID)
}

func (s *SocketRecord) afterLoad(context.Context) {}

// +checklocksignore
func (s *SocketRecord) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.k)
	stateSourceObject.Load(1, &s.Sock)
	stateSourceObject.Load(2, &s.ID)
}

func (c *CheckpointGeneration) StateTypeName() string {
	return "pkg/sentry/kernel.CheckpointGeneration"
}

func (c *CheckpointGeneration) StateFields() []string {
	return []string{
		"Count",
		"Restore",
	}
}

func (c *CheckpointGeneration) beforeSave() {}

// +checklocksignore
func (c *CheckpointGeneration) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.Count)
	stateSinkObject.Save(1, &c.Restore)
}

func (c *CheckpointGeneration) afterLoad(context.Context) {}

// +checklocksignore
func (c *CheckpointGeneration) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.Count)
	stateSourceObject.Load(1, &c.Restore)
}

func (w *CheckpointWaitable) StateTypeName() string {
	return "pkg/sentry/kernel.CheckpointWaitable"
}

func (w *CheckpointWaitable) StateFields() []string {
	return []string{
		"k",
	}
}

func (w *CheckpointWaitable) beforeSave() {}

// +checklocksignore
func (w *CheckpointWaitable) StateSave(stateSinkObject state.Sink) {
	w.beforeSave()
	stateSinkObject.Save(0, &w.k)
}

func (w *CheckpointWaitable) afterLoad(context.Context) {}

// +checklocksignore
func (w *CheckpointWaitable) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &w.k)
}

func (p *pendingSignals) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignals"
}

func (p *pendingSignals) StateFields() []string {
	return []string{
		"signals",
	}
}

func (p *pendingSignals) beforeSave() {}

// +checklocksignore
func (p *pendingSignals) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	var signalsValue []savedPendingSignal
	signalsValue = p.saveSignals()
	stateSinkObject.SaveValue(0, signalsValue)
}

func (p *pendingSignals) afterLoad(context.Context) {}

// +checklocksignore
func (p *pendingSignals) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.LoadValue(0, new([]savedPendingSignal), func(y any) { p.loadSignals(ctx, y.([]savedPendingSignal)) })
}

func (p *pendingSignalQueue) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalQueue"
}

func (p *pendingSignalQueue) StateFields() []string {
	return []string{
		"pendingSignalList",
		"length",
	}
}

func (p *pendingSignalQueue) beforeSave() {}

// +checklocksignore
func (p *pendingSignalQueue) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.pendingSignalList)
	stateSinkObject.Save(1, &p.length)
}

func (p *pendingSignalQueue) afterLoad(context.Context) {}

// +checklocksignore
func (p *pendingSignalQueue) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.pendingSignalList)
	stateSourceObject.Load(1, &p.length)
}

func (p *pendingSignal) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignal"
}

func (p *pendingSignal) StateFields() []string {
	return []string{
		"pendingSignalEntry",
		"SignalInfo",
		"timer",
	}
}

func (p *pendingSignal) beforeSave() {}

// +checklocksignore
func (p *pendingSignal) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.pendingSignalEntry)
	stateSinkObject.Save(1, &p.SignalInfo)
	stateSinkObject.Save(2, &p.timer)
}

func (p *pendingSignal) afterLoad(context.Context) {}

// +checklocksignore
func (p *pendingSignal) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.pendingSignalEntry)
	stateSourceObject.Load(1, &p.SignalInfo)
	stateSourceObject.Load(2, &p.timer)
}

func (l *pendingSignalList) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalList"
}

func (l *pendingSignalList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *pendingSignalList) beforeSave() {}

// +checklocksignore
func (l *pendingSignalList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *pendingSignalList) afterLoad(context.Context) {}

// +checklocksignore
func (l *pendingSignalList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *pendingSignalEntry) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalEntry"
}

func (e *pendingSignalEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *pendingSignalEntry) beforeSave() {}

// +checklocksignore
func (e *pendingSignalEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *pendingSignalEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *pendingSignalEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (s *savedPendingSignal) StateTypeName() string {
	return "pkg/sentry/kernel.savedPendingSignal"
}

func (s *savedPendingSignal) StateFields() []string {
	return []string{
		"si",
		"timer",
	}
}

func (s *savedPendingSignal) beforeSave() {}

// +checklocksignore
func (s *savedPendingSignal) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.si)
	stateSinkObject.Save(1, &s.timer)
}

func (s *savedPendingSignal) afterLoad(context.Context) {}

// +checklocksignore
func (s *savedPendingSignal) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.si)
	stateSourceObject.Load(1, &s.timer)
}

func (it *IntervalTimer) StateTypeName() string {
	return "pkg/sentry/kernel.IntervalTimer"
}

func (it *IntervalTimer) StateFields() []string {
	return []string{
		"timer",
		"target",
		"signo",
		"id",
		"sigval",
		"group",
		"sigpending",
		"sigorphan",
		"overrunCur",
		"overrunLast",
	}
}

func (it *IntervalTimer) beforeSave() {}

// +checklocksignore
func (it *IntervalTimer) StateSave(stateSinkObject state.Sink) {
	it.beforeSave()
	stateSinkObject.Save(0, &it.timer)
	stateSinkObject.Save(1, &it.target)
	stateSinkObject.Save(2, &it.signo)
	stateSinkObject.Save(3, &it.id)
	stateSinkObject.Save(4, &it.sigval)
	stateSinkObject.Save(5, &it.group)
	stateSinkObject.Save(6, &it.sigpending)
	stateSinkObject.Save(7, &it.sigorphan)
	stateSinkObject.Save(8, &it.overrunCur)
	stateSinkObject.Save(9, &it.overrunLast)
}

func (it *IntervalTimer) afterLoad(context.Context) {}

// +checklocksignore
func (it *IntervalTimer) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &it.timer)
	stateSourceObject.Load(1, &it.target)
	stateSourceObject.Load(2, &it.signo)
	stateSourceObject.Load(3, &it.id)
	stateSourceObject.Load(4, &it.sigval)
	stateSourceObject.Load(5, &it.group)
	stateSourceObject.Load(6, &it.sigpending)
	stateSourceObject.Load(7, &it.sigorphan)
	stateSourceObject.Load(8, &it.overrunCur)
	stateSourceObject.Load(9, &it.overrunLast)
}

func (l *processGroupList) StateTypeName() string {
	return "pkg/sentry/kernel.processGroupList"
}

func (l *processGroupList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *processGroupList) beforeSave() {}

// +checklocksignore
func (l *processGroupList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *processGroupList) afterLoad(context.Context) {}

// +checklocksignore
func (l *processGroupList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *processGroupEntry) StateTypeName() string {
	return "pkg/sentry/kernel.processGroupEntry"
}

func (e *processGroupEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *processGroupEntry) beforeSave() {}

// +checklocksignore
func (e *processGroupEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *processGroupEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *processGroupEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (r *ProcessGroupRefs) StateTypeName() string {
	return "pkg/sentry/kernel.ProcessGroupRefs"
}

func (r *ProcessGroupRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *ProcessGroupRefs) beforeSave() {}

// +checklocksignore
func (r *ProcessGroupRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *ProcessGroupRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (p *ptraceOptions) StateTypeName() string {
	return "pkg/sentry/kernel.ptraceOptions"
}

func (p *ptraceOptions) StateFields() []string {
	return []string{
		"ExitKill",
		"SysGood",
		"TraceClone",
		"TraceExec",
		"TraceExit",
		"TraceFork",
		"TraceSeccomp",
		"TraceVfork",
		"TraceVforkDone",
	}
}

func (p *ptraceOptions) beforeSave() {}

// +checklocksignore
func (p *ptraceOptions) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.ExitKill)
	stateSinkObject.Save(1, &p.SysGood)
	stateSinkObject.Save(2, &p.TraceClone)
	stateSinkObject.Save(3, &p.TraceExec)
	stateSinkObject.Save(4, &p.TraceExit)
	stateSinkObject.Save(5, &p.TraceFork)
	stateSinkObject.Save(6, &p.TraceSeccomp)
	stateSinkObject.Save(7, &p.TraceVfork)
	stateSinkObject.Save(8, &p.TraceVforkDone)
}

func (p *ptraceOptions) afterLoad(context.Context) {}

// +checklocksignore
func (p *ptraceOptions) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.ExitKill)
	stateSourceObject.Load(1, &p.SysGood)
	stateSourceObject.Load(2, &p.TraceClone)
	stateSourceObject.Load(3, &p.TraceExec)
	stateSourceObject.Load(4, &p.TraceExit)
	stateSourceObject.Load(5, &p.TraceFork)
	stateSourceObject.Load(6, &p.TraceSeccomp)
	stateSourceObject.Load(7, &p.TraceVfork)
	stateSourceObject.Load(8, &p.TraceVforkDone)
}

func (s *ptraceStop) StateTypeName() string {
	return "pkg/sentry/kernel.ptraceStop"
}

func (s *ptraceStop) StateFields() []string {
	return []string{
		"frozen",
		"listen",
	}
}

func (s *ptraceStop) beforeSave() {}

// +checklocksignore
func (s *ptraceStop) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.frozen)
	stateSinkObject.Save(1, &s.listen)
}

func (s *ptraceStop) afterLoad(context.Context) {}

// +checklocksignore
func (s *ptraceStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.frozen)
	stateSourceObject.Load(1, &s.listen)
}

func (o *OldRSeqCriticalRegion) StateTypeName() string {
	return "pkg/sentry/kernel.OldRSeqCriticalRegion"
}

func (o *OldRSeqCriticalRegion) StateFields() []string {
	return []string{
		"CriticalSection",
		"Restart",
	}
}

func (o *OldRSeqCriticalRegion) beforeSave() {}

// +checklocksignore
func (o *OldRSeqCriticalRegion) StateSave(stateSinkObject state.Sink) {
	o.beforeSave()
	stateSinkObject.Save(0, &o.CriticalSection)
	stateSinkObject.Save(1, &o.Restart)
}

func (o *OldRSeqCriticalRegion) afterLoad(context.Context) {}

// +checklocksignore
func (o *OldRSeqCriticalRegion) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &o.CriticalSection)
	stateSourceObject.Load(1, &o.Restart)
}

func (ts *taskSeccomp) StateTypeName() string {
	return "pkg/sentry/kernel.taskSeccomp"
}

func (ts *taskSeccomp) StateFields() []string {
	return []string{
		"filters",
		"cache",
		"cacheAuditNumber",
	}
}

func (ts *taskSeccomp) beforeSave() {}

// +checklocksignore
func (ts *taskSeccomp) StateSave(stateSinkObject state.Sink) {
	ts.beforeSave()
	stateSinkObject.Save(0, &ts.filters)
	stateSinkObject.Save(1, &ts.cache)
	stateSinkObject.Save(2, &ts.cacheAuditNumber)
}

func (ts *taskSeccomp) afterLoad(context.Context) {}

// +checklocksignore
func (ts *taskSeccomp) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ts.filters)
	stateSourceObject.Load(1, &ts.cache)
	stateSourceObject.Load(2, &ts.cacheAuditNumber)
}

func (l *sessionList) StateTypeName() string {
	return "pkg/sentry/kernel.sessionList"
}

func (l *sessionList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *sessionList) beforeSave() {}

// +checklocksignore
func (l *sessionList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *sessionList) afterLoad(context.Context) {}

// +checklocksignore
func (l *sessionList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *sessionEntry) StateTypeName() string {
	return "pkg/sentry/kernel.sessionEntry"
}

func (e *sessionEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *sessionEntry) beforeSave() {}

// +checklocksignore
func (e *sessionEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *sessionEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *sessionEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (r *SessionRefs) StateTypeName() string {
	return "pkg/sentry/kernel.SessionRefs"
}

func (r *SessionRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *SessionRefs) beforeSave() {}

// +checklocksignore
func (r *SessionRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *SessionRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (s *Session) StateTypeName() string {
	return "pkg/sentry/kernel.Session"
}

func (s *Session) StateFields() []string {
	return []string{
		"SessionRefs",
		"leader",
		"id",
		"foreground",
		"processGroups",
		"sessionEntry",
	}
}

func (s *Session) beforeSave() {}

// +checklocksignore
func (s *Session) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.SessionRefs)
	stateSinkObject.Save(1, &s.leader)
	stateSinkObject.Save(2, &s.id)
	stateSinkObject.Save(3, &s.foreground)
	stateSinkObject.Save(4, &s.processGroups)
	stateSinkObject.Save(5, &s.sessionEntry)
}

func (s *Session) afterLoad(context.Context) {}

// +checklocksignore
func (s *Session) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.SessionRefs)
	stateSourceObject.Load(1, &s.leader)
	stateSourceObject.Load(2, &s.id)
	stateSourceObject.Load(3, &s.foreground)
	stateSourceObject.Load(4, &s.processGroups)
	stateSourceObject.Load(5, &s.sessionEntry)
}

func (pg *ProcessGroup) StateTypeName() string {
	return "pkg/sentry/kernel.ProcessGroup"
}

func (pg *ProcessGroup) StateFields() []string {
	return []string{
		"refs",
		"originator",
		"id",
		"session",
		"ancestors",
		"processGroupEntry",
	}
}

func (pg *ProcessGroup) beforeSave() {}

// +checklocksignore
func (pg *ProcessGroup) StateSave(stateSinkObject state.Sink) {
	pg.beforeSave()
	stateSinkObject.Save(0, &pg.refs)
	stateSinkObject.Save(1, &pg.originator)
	stateSinkObject.Save(2, &pg.id)
	stateSinkObject.Save(3, &pg.session)
	stateSinkObject.Save(4, &pg.ancestors)
	stateSinkObject.Save(5, &pg.processGroupEntry)
}

func (pg *ProcessGroup) afterLoad(context.Context) {}

// +checklocksignore
func (pg *ProcessGroup) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &pg.refs)
	stateSourceObject.Load(1, &pg.originator)
	stateSourceObject.Load(2, &pg.id)
	stateSourceObject.Load(3, &pg.session)
	stateSourceObject.Load(4, &pg.ancestors)
	stateSourceObject.Load(5, &pg.processGroupEntry)
}

func (sh *SignalHandlers) StateTypeName() string {
	return "pkg/sentry/kernel.SignalHandlers"
}

func (sh *SignalHandlers) StateFields() []string {
	return []string{
		"actions",
	}
}

func (sh *SignalHandlers) beforeSave() {}

// +checklocksignore
func (sh *SignalHandlers) StateSave(stateSinkObject state.Sink) {
	sh.beforeSave()
	stateSinkObject.Save(0, &sh.actions)
}

func (sh *SignalHandlers) afterLoad(context.Context) {}

// +checklocksignore
func (sh *SignalHandlers) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &sh.actions)
}

func (s *syscallTableInfo) StateTypeName() string {
	return "pkg/sentry/kernel.syscallTableInfo"
}

func (s *syscallTableInfo) StateFields() []string {
	return []string{
		"OS",
		"Arch",
	}
}

func (s *syscallTableInfo) beforeSave() {}

// +checklocksignore
func (s *syscallTableInfo) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.OS)
	stateSinkObject.Save(1, &s.Arch)
}

func (s *syscallTableInfo) afterLoad(context.Context) {}

// +checklocksignore
func (s *syscallTableInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.OS)
	stateSourceObject.Load(1, &s.Arch)
}

func (s *syslog) StateTypeName() string {
	return "pkg/sentry/kernel.syslog"
}

func (s *syslog) StateFields() []string {
	return []string{
		"msg",
	}
}

func (s *syslog) beforeSave() {}

// +checklocksignore
func (s *syslog) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.msg)
}

func (s *syslog) afterLoad(context.Context) {}

// +checklocksignore
func (s *syslog) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.msg)
}

func (t *Task) StateTypeName() string {
	return "pkg/sentry/kernel.Task"
}

func (t *Task) StateFields() []string {
	return []string{
		"taskNode",
		"runState",
		"taskWorkCount",
		"taskWork",
		"haveSyscallReturn",
		"gostate",
		"gostateTime",
		"appCPUClock",
		"appSysCPUClock",
		"yieldCount",
		"pendingSignals",
		"signalMask",
		"realSignalMask",
		"haveSavedSignalMask",
		"savedSignalMask",
		"signalStack",
		"signalQueue",
		"groupStopPending",
		"groupStopAcknowledged",
		"trapStopPending",
		"trapNotifyPending",
		"stop",
		"exitStatus",
		"syscallRestartBlock",
		"k",
		"containerID",
		"image",
		"fsContext",
		"fdTable",
		"vforkParent",
		"exitState",
		"exitTracerNotified",
		"exitTracerAcked",
		"exitParentNotified",
		"exitParentAcked",
		"ptraceTracer",
		"ptraceTracees",
		"ptraceSeized",
		"ptraceOpts",
		"ptraceSyscallMode",
		"ptraceSinglestep",
		"ptraceCode",
		"ptraceSiginfo",
		"ptraceEventMsg",
		"ptraceYAMAExceptionAdded",
		"ioUsage",
		"creds",
		"utsns",
		"ipcns",
		"mountNamespace",
		"parentDeathSignal",
		"seccomp",
		"cleartid",
		"allowedCPUMask",
		"cpu",
		"niceness",
		"numaPolicy",
		"numaNodeMask",
		"netns",
		"rseqCPU",
		"oldRSeqCPUAddr",
		"rseqAddr",
		"rseqSignature",
		"robustList",
		"startTime",
		"kcov",
		"cgroups",
		"memCgID",
		"userCounters",
		"sessionKeyring",
		"Origin",
		"onDestroyAction",
	}
}

func (t *Task) beforeSave() {}

// +checklocksignore
func (t *Task) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	var vforkParentValue *Task
	vforkParentValue = t.saveVforkParent()
	stateSinkObject.SaveValue(29, vforkParentValue)
	var ptraceTracerValue *Task
	ptraceTracerValue = t.savePtraceTracer()
	stateSinkObject.SaveValue(35, ptraceTracerValue)
	var seccompValue *taskSeccomp
	seccompValue = t.saveSeccomp()
	stateSinkObject.SaveValue(51, seccompValue)
	stateSinkObject.Save(0, &t.taskNode)
	stateSinkObject.Save(1, &t.runState)
	stateSinkObject.Save(2, &t.taskWorkCount)
	stateSinkObject.Save(3, &t.taskWork)
	stateSinkObject.Save(4, &t.haveSyscallReturn)
	stateSinkObject.Save(5, &t.gostate)
	stateSinkObject.Save(6, &t.gostateTime)
	stateSinkObject.Save(7, &t.appCPUClock)
	stateSinkObject.Save(8, &t.appSysCPUClock)
	stateSinkObject.Save(9, &t.yieldCount)
	stateSinkObject.Save(10, &t.pendingSignals)
	stateSinkObject.Save(11, &t.signalMask)
	stateSinkObject.Save(12, &t.realSignalMask)
	stateSinkObject.Save(13, &t.haveSavedSignalMask)
	stateSinkObject.Save(14, &t.savedSignalMask)
	stateSinkObject.Save(15, &t.signalStack)
	stateSinkObject.Save(16, &t.signalQueue)
	stateSinkObject.Save(17, &t.groupStopPending)
	stateSinkObject.Save(18, &t.groupStopAcknowledged)
	stateSinkObject.Save(19, &t.trapStopPending)
	stateSinkObject.Save(20, &t.trapNotifyPending)
	stateSinkObject.Save(21, &t.stop)
	stateSinkObject.Save(22, &t.exitStatus)
	stateSinkObject.Save(23, &t.syscallRestartBlock)
	stateSinkObject.Save(24, &t.k)
	stateSinkObject.Save(25, &t.containerID)
	stateSinkObject.Save(26, &t.image)
	stateSinkObject.Save(27, &t.fsContext)
	stateSinkObject.Save(28, &t.fdTable)
	stateSinkObject.Save(30, &t.exitState)
	stateSinkObject.Save(31, &t.exitTracerNotified)
	stateSinkObject.Save(32, &t.exitTracerAcked)
	stateSinkObject.Save(33, &t.exitParentNotified)
	stateSinkObject.Save(34, &t.exitParentAcked)
	stateSinkObject.Save(36, &t.ptraceTracees)
	stateSinkObject.Save(37, &t.ptraceSeized)
	stateSinkObject.Save(38, &t.ptraceOpts)
	stateSinkObject.Save(39, &t.ptraceSyscallMode)
	stateSinkObject.Save(40, &t.ptraceSinglestep)
	stateSinkObject.Save(41, &t.ptraceCode)
	stateSinkObject.Save(42, &t.ptraceSiginfo)
	stateSinkObject.Save(43, &t.ptraceEventMsg)
	stateSinkObject.Save(44, &t.ptraceYAMAExceptionAdded)
	stateSinkObject.Save(45, &t.ioUsage)
	stateSinkObject.Save(46, &t.creds)
	stateSinkObject.Save(47, &t.utsns)
	stateSinkObject.Save(48, &t.ipcns)
	stateSinkObject.Save(49, &t.mountNamespace)
	stateSinkObject.Save(50, &t.parentDeathSignal)
	stateSinkObject.Save(52, &t.cleartid)
	stateSinkObject.Save(53, &t.allowedCPUMask)
	stateSinkObject.Save(54, &t.cpu)
	stateSinkObject.Save(55, &t.niceness)
	stateSinkObject.Save(56, &t.numaPolicy)
	stateSinkObject.Save(57, &t.numaNodeMask)
	stateSinkObject.Save(58, &t.netns)
	stateSinkObject.Save(59, &t.rseqCPU)
	stateSinkObject.Save(60, &t.oldRSeqCPUAddr)
	stateSinkObject.Save(61, &t.rseqAddr)
	stateSinkObject.Save(62, &t.rseqSignature)
	stateSinkObject.Save(63, &t.robustList)
	stateSinkObject.Save(64, &t.startTime)
	stateSinkObject.Save(65, &t.kcov)
	stateSinkObject.Save(66, &t.cgroups)
	stateSinkObject.Save(67, &t.memCgID)
	stateSinkObject.Save(68, &t.userCounters)
	stateSinkObject.Save(69, &t.sessionKeyring)
	stateSinkObject.Save(70, &t.Origin)
	stateSinkObject.Save(71, &t.onDestroyAction)
}

// +checklocksignore
func (t *Task) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.taskNode)
	stateSourceObject.Load(1, &t.runState)
	stateSourceObject.Load(2, &t.taskWorkCount)
	stateSourceObject.Load(3, &t.taskWork)
	stateSourceObject.Load(4, &t.haveSyscallReturn)
	stateSourceObject.Load(5, &t.gostate)
	stateSourceObject.Load(6, &t.gostateTime)
	stateSourceObject.Load(7, &t.appCPUClock)
	stateSourceObject.Load(8, &t.appSysCPUClock)
	stateSourceObject.Load(9, &t.yieldCount)
	stateSourceObject.Load(10, &t.pendingSignals)
	stateSourceObject.Load(11, &t.signalMask)
	stateSourceObject.Load(12, &t.realSignalMask)
	stateSourceObject.Load(13, &t.haveSavedSignalMask)
	stateSourceObject.Load(14, &t.savedSignalMask)
	stateSourceObject.Load(15, &t.signalStack)
	stateSourceObject.Load(16, &t.signalQueue)
	stateSourceObject.Load(17, &t.groupStopPending)
	stateSourceObject.Load(18, &t.groupStopAcknowledged)
	stateSourceObject.Load(19, &t.trapStopPending)
	stateSourceObject.Load(20, &t.trapNotifyPending)
	stateSourceObject.Load(21, &t.stop)
	stateSourceObject.Load(22, &t.exitStatus)
	stateSourceObject.Load(23, &t.syscallRestartBlock)
	stateSourceObject.Load(24, &t.k)
	stateSourceObject.Load(25, &t.containerID)
	stateSourceObject.Load(26, &t.image)
	stateSourceObject.Load(27, &t.fsContext)
	stateSourceObject.Load(28, &t.fdTable)
	stateSourceObject.Load(30, &t.exitState)
	stateSourceObject.Load(31, &t.exitTracerNotified)
	stateSourceObject.Load(32, &t.exitTracerAcked)
	stateSourceObject.Load(33, &t.exitParentNotified)
	stateSourceObject.Load(34, &t.exitParentAcked)
	stateSourceObject.Load(36, &t.ptraceTracees)
	stateSourceObject.Load(37, &t.ptraceSeized)
	stateSourceObject.Load(38, &t.ptraceOpts)
	stateSourceObject.Load(39, &t.ptraceSyscallMode)
	stateSourceObject.Load(40, &t.ptraceSinglestep)
	stateSourceObject.Load(41, &t.ptraceCode)
	stateSourceObject.Load(42, &t.ptraceSiginfo)
	stateSourceObject.Load(43, &t.ptraceEventMsg)
	stateSourceObject.Load(44, &t.ptraceYAMAExceptionAdded)
	stateSourceObject.Load(45, &t.ioUsage)
	stateSourceObject.Load(46, &t.creds)
	stateSourceObject.Load(47, &t.utsns)
	stateSourceObject.Load(48, &t.ipcns)
	stateSourceObject.Load(49, &t.mountNamespace)
	stateSourceObject.Load(50, &t.parentDeathSignal)
	stateSourceObject.Load(52, &t.cleartid)
	stateSourceObject.Load(53, &t.allowedCPUMask)
	stateSourceObject.Load(54, &t.cpu)
	stateSourceObject.Load(55, &t.niceness)
	stateSourceObject.Load(56, &t.numaPolicy)
	stateSourceObject.Load(57, &t.numaNodeMask)
	stateSourceObject.Load(58, &t.netns)
	stateSourceObject.Load(59, &t.rseqCPU)
	stateSourceObject.Load(60, &t.oldRSeqCPUAddr)
	stateSourceObject.Load(61, &t.rseqAddr)
	stateSourceObject.Load(62, &t.rseqSignature)
	stateSourceObject.Load(63, &t.robustList)
	stateSourceObject.Load(64, &t.startTime)
	stateSourceObject.Load(65, &t.kcov)
	stateSourceObject.Load(66, &t.cgroups)
	stateSourceObject.Load(67, &t.memCgID)
	stateSourceObject.Load(68, &t.userCounters)
	stateSourceObject.Load(69, &t.sessionKeyring)
	stateSourceObject.Load(70, &t.Origin)
	stateSourceObject.Load(71, &t.onDestroyAction)
	stateSourceObject.LoadValue(29, new(*Task), func(y any) { t.loadVforkParent(ctx, y.(*Task)) })
	stateSourceObject.LoadValue(35, new(*Task), func(y any) { t.loadPtraceTracer(ctx, y.(*Task)) })
	stateSourceObject.LoadValue(51, new(*taskSeccomp), func(y any) { t.loadSeccomp(ctx, y.(*taskSeccomp)) })
	stateSourceObject.AfterLoad(func() { t.afterLoad(ctx) })
}

func (l *itimerRealListener) StateTypeName() string {
	return "pkg/sentry/kernel.itimerRealListener"
}

func (l *itimerRealListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *itimerRealListener) beforeSave() {}

// +checklocksignore
func (l *itimerRealListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *itimerRealListener) afterLoad(context.Context) {}

// +checklocksignore
func (l *itimerRealListener) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (l *itimerVirtListener) StateTypeName() string {
	return "pkg/sentry/kernel.itimerVirtListener"
}

func (l *itimerVirtListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *itimerVirtListener) beforeSave() {}

// +checklocksignore
func (l *itimerVirtListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *itimerVirtListener) afterLoad(context.Context) {}

// +checklocksignore
func (l *itimerVirtListener) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (l *itimerProfListener) StateTypeName() string {
	return "pkg/sentry/kernel.itimerProfListener"
}

func (l *itimerProfListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *itimerProfListener) beforeSave() {}

// +checklocksignore
func (l *itimerProfListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *itimerProfListener) afterLoad(context.Context) {}

// +checklocksignore
func (l *itimerProfListener) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (l *rlimitCPUSoftListener) StateTypeName() string {
	return "pkg/sentry/kernel.rlimitCPUSoftListener"
}

func (l *rlimitCPUSoftListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *rlimitCPUSoftListener) beforeSave() {}

// +checklocksignore
func (l *rlimitCPUSoftListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *rlimitCPUSoftListener) afterLoad(context.Context) {}

// +checklocksignore
func (l *rlimitCPUSoftListener) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (l *rlimitCPUHardListener) StateTypeName() string {
	return "pkg/sentry/kernel.rlimitCPUHardListener"
}

func (l *rlimitCPUHardListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *rlimitCPUHardListener) beforeSave() {}

// +checklocksignore
func (l *rlimitCPUHardListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *rlimitCPUHardListener) afterLoad(context.Context) {}

// +checklocksignore
func (l *rlimitCPUHardListener) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (r *runSyscallAfterPtraceEventClone) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterPtraceEventClone"
}

func (r *runSyscallAfterPtraceEventClone) StateFields() []string {
	return []string{
		"vforkChild",
		"vforkChildTID",
	}
}

func (r *runSyscallAfterPtraceEventClone) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterPtraceEventClone) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.vforkChild)
	stateSinkObject.Save(1, &r.vforkChildTID)
}

func (r *runSyscallAfterPtraceEventClone) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallAfterPtraceEventClone) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.vforkChild)
	stateSourceObject.Load(1, &r.vforkChildTID)
}

func (r *runSyscallAfterVforkStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterVforkStop"
}

func (r *runSyscallAfterVforkStop) StateFields() []string {
	return []string{
		"childTID",
	}
}

func (r *runSyscallAfterVforkStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterVforkStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.childTID)
}

func (r *runSyscallAfterVforkStop) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallAfterVforkStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.childTID)
}

func (v *vforkStop) StateTypeName() string {
	return "pkg/sentry/kernel.vforkStop"
}

func (v *vforkStop) StateFields() []string {
	return []string{}
}

func (v *vforkStop) beforeSave() {}

// +checklocksignore
func (v *vforkStop) StateSave(stateSinkObject state.Sink) {
	v.beforeSave()
}

func (v *vforkStop) afterLoad(context.Context) {}

// +checklocksignore
func (v *vforkStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (e *execStop) StateTypeName() string {
	return "pkg/sentry/kernel.execStop"
}

func (e *execStop) StateFields() []string {
	return []string{}
}

func (e *execStop) beforeSave() {}

// +checklocksignore
func (e *execStop) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
}

func (e *execStop) afterLoad(context.Context) {}

// +checklocksignore
func (e *execStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runSyscallAfterExecStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterExecStop"
}

func (r *runSyscallAfterExecStop) StateFields() []string {
	return []string{
		"image",
	}
}

func (r *runSyscallAfterExecStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterExecStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.image)
}

func (r *runSyscallAfterExecStop) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallAfterExecStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.image)
}

func (r *runExit) StateTypeName() string {
	return "pkg/sentry/kernel.runExit"
}

func (r *runExit) StateFields() []string {
	return []string{}
}

func (r *runExit) beforeSave() {}

// +checklocksignore
func (r *runExit) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExit) afterLoad(context.Context) {}

// +checklocksignore
func (r *runExit) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runExitMain) StateTypeName() string {
	return "pkg/sentry/kernel.runExitMain"
}

func (r *runExitMain) StateFields() []string {
	return []string{}
}

func (r *runExitMain) beforeSave() {}

// +checklocksignore
func (r *runExitMain) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExitMain) afterLoad(context.Context) {}

// +checklocksignore
func (r *runExitMain) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runExitNotify) StateTypeName() string {
	return "pkg/sentry/kernel.runExitNotify"
}

func (r *runExitNotify) StateFields() []string {
	return []string{}
}

func (r *runExitNotify) beforeSave() {}

// +checklocksignore
func (r *runExitNotify) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExitNotify) afterLoad(context.Context) {}

// +checklocksignore
func (r *runExitNotify) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (image *TaskImage) StateTypeName() string {
	return "pkg/sentry/kernel.TaskImage"
}

func (image *TaskImage) StateFields() []string {
	return []string{
		"Name",
		"Arch",
		"MemoryManager",
		"fu",
		"st",
		"fileCaps",
	}
}

func (image *TaskImage) beforeSave() {}

// +checklocksignore
func (image *TaskImage) StateSave(stateSinkObject state.Sink) {
	image.beforeSave()
	var stValue syscallTableInfo
	stValue = image.saveSt()
	stateSinkObject.SaveValue(4, stValue)
	stateSinkObject.Save(0, &image.Name)
	stateSinkObject.Save(1, &image.Arch)
	stateSinkObject.Save(2, &image.MemoryManager)
	stateSinkObject.Save(3, &image.fu)
	stateSinkObject.Save(5, &image.fileCaps)
}

func (image *TaskImage) afterLoad(context.Context) {}

// +checklocksignore
func (image *TaskImage) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &image.Name)
	stateSourceObject.Load(1, &image.Arch)
	stateSourceObject.Load(2, &image.MemoryManager)
	stateSourceObject.Load(3, &image.fu)
	stateSourceObject.Load(5, &image.fileCaps)
	stateSourceObject.LoadValue(4, new(syscallTableInfo), func(y any) { image.loadSt(ctx, y.(syscallTableInfo)) })
}

func (l *taskList) StateTypeName() string {
	return "pkg/sentry/kernel.taskList"
}

func (l *taskList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *taskList) beforeSave() {}

// +checklocksignore
func (l *taskList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *taskList) afterLoad(context.Context) {}

// +checklocksignore
func (l *taskList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *taskEntry) StateTypeName() string {
	return "pkg/sentry/kernel.taskEntry"
}

func (e *taskEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *taskEntry) beforeSave() {}

// +checklocksignore
func (e *taskEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *taskEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *taskEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (app *runApp) StateTypeName() string {
	return "pkg/sentry/kernel.runApp"
}

func (app *runApp) StateFields() []string {
	return []string{}
}

func (app *runApp) beforeSave() {}

// +checklocksignore
func (app *runApp) StateSave(stateSinkObject state.Sink) {
	app.beforeSave()
}

func (app *runApp) afterLoad(context.Context) {}

// +checklocksignore
func (app *runApp) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (g *groupStop) StateTypeName() string {
	return "pkg/sentry/kernel.groupStop"
}

func (g *groupStop) StateFields() []string {
	return []string{}
}

func (g *groupStop) beforeSave() {}

// +checklocksignore
func (g *groupStop) StateSave(stateSinkObject state.Sink) {
	g.beforeSave()
}

func (g *groupStop) afterLoad(context.Context) {}

// +checklocksignore
func (g *groupStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runInterrupt) StateTypeName() string {
	return "pkg/sentry/kernel.runInterrupt"
}

func (r *runInterrupt) StateFields() []string {
	return []string{}
}

func (r *runInterrupt) beforeSave() {}

// +checklocksignore
func (r *runInterrupt) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runInterrupt) afterLoad(context.Context) {}

// +checklocksignore
func (r *runInterrupt) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runInterruptAfterSignalDeliveryStop) StateTypeName() string {
	return "pkg/sentry/kernel.runInterruptAfterSignalDeliveryStop"
}

func (r *runInterruptAfterSignalDeliveryStop) StateFields() []string {
	return []string{}
}

func (r *runInterruptAfterSignalDeliveryStop) beforeSave() {}

// +checklocksignore
func (r *runInterruptAfterSignalDeliveryStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runInterruptAfterSignalDeliveryStop) afterLoad(context.Context) {}

// +checklocksignore
func (r *runInterruptAfterSignalDeliveryStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runSyscallAfterSyscallEnterStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterSyscallEnterStop"
}

func (r *runSyscallAfterSyscallEnterStop) StateFields() []string {
	return []string{}
}

func (r *runSyscallAfterSyscallEnterStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterSyscallEnterStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallAfterSyscallEnterStop) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallAfterSyscallEnterStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runSyscallAfterSysemuStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterSysemuStop"
}

func (r *runSyscallAfterSysemuStop) StateFields() []string {
	return []string{}
}

func (r *runSyscallAfterSysemuStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterSysemuStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallAfterSysemuStop) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallAfterSysemuStop) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runSyscallReinvoke) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallReinvoke"
}

func (r *runSyscallReinvoke) StateFields() []string {
	return []string{}
}

func (r *runSyscallReinvoke) beforeSave() {}

// +checklocksignore
func (r *runSyscallReinvoke) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallReinvoke) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallReinvoke) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (r *runSyscallExit) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallExit"
}

func (r *runSyscallExit) StateFields() []string {
	return []string{}
}

func (r *runSyscallExit) beforeSave() {}

// +checklocksignore
func (r *runSyscallExit) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallExit) afterLoad(context.Context) {}

// +checklocksignore
func (r *runSyscallExit) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (tg *ThreadGroup) StateTypeName() string {
	return "pkg/sentry/kernel.ThreadGroup"
}

func (tg *ThreadGroup) StateFields() []string {
	return []string{
		"threadGroupNode",
		"signalHandlers",
		"pendingSignals",
		"groupStopDequeued",
		"groupStopSignal",
		"groupStopPendingCount",
		"groupStopComplete",
		"groupStopWaitable",
		"groupContNotify",
		"groupContInterrupted",
		"groupContWaitable",
		"exiting",
		"exitStatus",
		"terminationSignal",
		"itimerRealTimer",
		"itimerRealListener",
		"itimerVirtTimer",
		"itimerVirtListener",
		"itimerProfTimer",
		"itimerProfListener",
		"rlimitCPUSoftTimer",
		"rlimitCPUSoftListener",
		"rlimitCPUHardTimer",
		"rlimitCPUHardListener",
		"timers",
		"nextTimerID",
		"appCPUClockLast",
		"appCPUClock",
		"appSysCPUClockLast",
		"appSysCPUClock",
		"yieldCount",
		"childCPUStats",
		"ioUsage",
		"maxRSS",
		"childMaxRSS",
		"limits",
		"processGroup",
		"execed",
		"oldRSeqCritical",
		"tty",
		"oomScoreAdj",
		"isChildSubreaper",
		"hasChildSubreaper",
	}
}

func (tg *ThreadGroup) beforeSave() {}

// +checklocksignore
func (tg *ThreadGroup) StateSave(stateSinkObject state.Sink) {
	tg.beforeSave()
	var appCPUClockLastValue *Task
	appCPUClockLastValue = tg.saveAppCPUClockLast()
	stateSinkObject.SaveValue(26, appCPUClockLastValue)
	var appSysCPUClockLastValue *Task
	appSysCPUClockLastValue = tg.saveAppSysCPUClockLast()
	stateSinkObject.SaveValue(28, appSysCPUClockLastValue)
	var oldRSeqCriticalValue *OldRSeqCriticalRegion
	oldRSeqCriticalValue = tg.saveOldRSeqCritical()
	stateSinkObject.SaveValue(38, oldRSeqCriticalValue)
	stateSinkObject.Save(0, &tg.threadGroupNode)
	stateSinkObject.Save(1, &tg.signalHandlers)
	stateSinkObject.Save(2, &tg.pendingSignals)
	stateSinkObject.Save(3, &tg.groupStopDequeued)
	stateSinkObject.Save(4, &tg.groupStopSignal)
	stateSinkObject.Save(5, &tg.groupStopPendingCount)
	stateSinkObject.Save(6, &tg.groupStopComplete)
	stateSinkObject.Save(7, &tg.groupStopWaitable)
	stateSinkObject.Save(8, &tg.groupContNotify)
	stateSinkObject.Save(9, &tg.groupContInterrupted)
	stateSinkObject.Save(10, &tg.groupContWaitable)
	stateSinkObject.Save(11, &tg.exiting)
	stateSinkObject.Save(12, &tg.exitStatus)
	stateSinkObject.Save(13, &tg.terminationSignal)
	stateSinkObject.Save(14, &tg.itimerRealTimer)
	stateSinkObject.Save(15, &tg.itimerRealListener)
	stateSinkObject.Save(16, &tg.itimerVirtTimer)
	stateSinkObject.Save(17, &tg.itimerVirtListener)
	stateSinkObject.Save(18, &tg.itimerProfTimer)
	stateSinkObject.Save(19, &tg.itimerProfListener)
	stateSinkObject.Save(20, &tg.rlimitCPUSoftTimer)
	stateSinkObject.Save(21, &tg.rlimitCPUSoftListener)
	stateSinkObject.Save(22, &tg.rlimitCPUHardTimer)
	stateSinkObject.Save(23, &tg.rlimitCPUHardListener)
	stateSinkObject.Save(24, &tg.timers)
	stateSinkObject.Save(25, &tg.nextTimerID)
	stateSinkObject.Save(27, &tg.appCPUClock)
	stateSinkObject.Save(29, &tg.appSysCPUClock)
	stateSinkObject.Save(30, &tg.yieldCount)
	stateSinkObject.Save(31, &tg.childCPUStats)
	stateSinkObject.Save(32, &tg.ioUsage)
	stateSinkObject.Save(33, &tg.maxRSS)
	stateSinkObject.Save(34, &tg.childMaxRSS)
	stateSinkObject.Save(35, &tg.limits)
	stateSinkObject.Save(36, &tg.processGroup)
	stateSinkObject.Save(37, &tg.execed)
	stateSinkObject.Save(39, &tg.tty)
	stateSinkObject.Save(40, &tg.oomScoreAdj)
	stateSinkObject.Save(41, &tg.isChildSubreaper)
	stateSinkObject.Save(42, &tg.hasChildSubreaper)
}

func (tg *ThreadGroup) afterLoad(context.Context) {}

// +checklocksignore
func (tg *ThreadGroup) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tg.threadGroupNode)
	stateSourceObject.Load(1, &tg.signalHandlers)
	stateSourceObject.Load(2, &tg.pendingSignals)
	stateSourceObject.Load(3, &tg.groupStopDequeued)
	stateSourceObject.Load(4, &tg.groupStopSignal)
	stateSourceObject.Load(5, &tg.groupStopPendingCount)
	stateSourceObject.Load(6, &tg.groupStopComplete)
	stateSourceObject.Load(7, &tg.groupStopWaitable)
	stateSourceObject.Load(8, &tg.groupContNotify)
	stateSourceObject.Load(9, &tg.groupContInterrupted)
	stateSourceObject.Load(10, &tg.groupContWaitable)
	stateSourceObject.Load(11, &tg.exiting)
	stateSourceObject.Load(12, &tg.exitStatus)
	stateSourceObject.Load(13, &tg.terminationSignal)
	stateSourceObject.Load(14, &tg.itimerRealTimer)
	stateSourceObject.Load(15, &tg.itimerRealListener)
	stateSourceObject.Load(16, &tg.itimerVirtTimer)
	stateSourceObject.Load(17, &tg.itimerVirtListener)
	stateSourceObject.Load(18, &tg.itimerProfTimer)
	stateSourceObject.Load(19, &tg.itimerProfListener)
	stateSourceObject.Load(20, &tg.rlimitCPUSoftTimer)
	stateSourceObject.Load(21, &tg.rlimitCPUSoftListener)
	stateSourceObject.Load(22, &tg.rlimitCPUHardTimer)
	stateSourceObject.Load(23, &tg.rlimitCPUHardListener)
	stateSourceObject.Load(24, &tg.timers)
	stateSourceObject.Load(25, &tg.nextTimerID)
	stateSourceObject.Load(27, &tg.appCPUClock)
	stateSourceObject.Load(29, &tg.appSysCPUClock)
	stateSourceObject.Load(30, &tg.yieldCount)
	stateSourceObject.Load(31, &tg.childCPUStats)
	stateSourceObject.Load(32, &tg.ioUsage)
	stateSourceObject.Load(33, &tg.maxRSS)
	stateSourceObject.Load(34, &tg.childMaxRSS)
	stateSourceObject.Load(35, &tg.limits)
	stateSourceObject.Load(36, &tg.processGroup)
	stateSourceObject.Load(37, &tg.execed)
	stateSourceObject.Load(39, &tg.tty)
	stateSourceObject.Load(40, &tg.oomScoreAdj)
	stateSourceObject.Load(41, &tg.isChildSubreaper)
	stateSourceObject.Load(42, &tg.hasChildSubreaper)
	stateSourceObject.LoadValue(26, new(*Task), func(y any) { tg.loadAppCPUClockLast(ctx, y.(*Task)) })
	stateSourceObject.LoadValue(28, new(*Task), func(y any) { tg.loadAppSysCPUClockLast(ctx, y.(*Task)) })
	stateSourceObject.LoadValue(38, new(*OldRSeqCriticalRegion), func(y any) { tg.loadOldRSeqCritical(ctx, y.(*OldRSeqCriticalRegion)) })
}

func (ts *TaskSet) StateTypeName() string {
	return "pkg/sentry/kernel.TaskSet"
}

func (ts *TaskSet) StateFields() []string {
	return []string{
		"Root",
		"sessions",
		"liveTasks",
		"noNewTasksIfZeroLive",
	}
}

func (ts *TaskSet) beforeSave() {}

// +checklocksignore
func (ts *TaskSet) StateSave(stateSinkObject state.Sink) {
	ts.beforeSave()
	stateSinkObject.Save(0, &ts.Root)
	stateSinkObject.Save(1, &ts.sessions)
	stateSinkObject.Save(2, &ts.liveTasks)
	stateSinkObject.Save(3, &ts.noNewTasksIfZeroLive)
}

// +checklocksignore
func (ts *TaskSet) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ts.Root)
	stateSourceObject.Load(1, &ts.sessions)
	stateSourceObject.Load(2, &ts.liveTasks)
	stateSourceObject.Load(3, &ts.noNewTasksIfZeroLive)
	stateSourceObject.AfterLoad(func() { ts.afterLoad(ctx) })
}

func (ns *PIDNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.PIDNamespace"
}

func (ns *PIDNamespace) StateFields() []string {
	return []string{
		"owner",
		"parent",
		"userns",
		"id",
		"last",
		"tasks",
		"tids",
		"tgids",
		"sessions",
		"sids",
		"processGroups",
		"pgids",
		"exiting",
		"extra",
	}
}

func (ns *PIDNamespace) beforeSave() {}

// +checklocksignore
func (ns *PIDNamespace) StateSave(stateSinkObject state.Sink) {
	ns.beforeSave()
	stateSinkObject.Save(0, &ns.owner)
	stateSinkObject.Save(1, &ns.parent)
	stateSinkObject.Save(2, &ns.userns)
	stateSinkObject.Save(3, &ns.id)
	stateSinkObject.Save(4, &ns.last)
	stateSinkObject.Save(5, &ns.tasks)
	stateSinkObject.Save(6, &ns.tids)
	stateSinkObject.Save(7, &ns.tgids)
	stateSinkObject.Save(8, &ns.sessions)
	stateSinkObject.Save(9, &ns.sids)
	stateSinkObject.Save(10, &ns.processGroups)
	stateSinkObject.Save(11, &ns.pgids)
	stateSinkObject.Save(12, &ns.exiting)
	stateSinkObject.Save(13, &ns.extra)
}

func (ns *PIDNamespace) afterLoad(context.Context) {}

// +checklocksignore
func (ns *PIDNamespace) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ns.owner)
	stateSourceObject.Load(1, &ns.parent)
	stateSourceObject.Load(2, &ns.userns)
	stateSourceObject.Load(3, &ns.id)
	stateSourceObject.Load(4, &ns.last)
	stateSourceObject.Load(5, &ns.tasks)
	stateSourceObject.Load(6, &ns.tids)
	stateSourceObject.Load(7, &ns.tgids)
	stateSourceObject.Load(8, &ns.sessions)
	stateSourceObject.Load(9, &ns.sids)
	stateSourceObject.Load(10, &ns.processGroups)
	stateSourceObject.Load(11, &ns.pgids)
	stateSourceObject.Load(12, &ns.exiting)
	stateSourceObject.Load(13, &ns.extra)
}

func (t *threadGroupNode) StateTypeName() string {
	return "pkg/sentry/kernel.threadGroupNode"
}

func (t *threadGroupNode) StateFields() []string {
	return []string{
		"pidns",
		"pidWithinNS",
		"eventQueue",
		"leader",
		"execing",
		"tasks",
		"tasksCount",
		"liveTasks",
		"activeTasks",
	}
}

func (t *threadGroupNode) beforeSave() {}

// +checklocksignore
func (t *threadGroupNode) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.pidns)
	stateSinkObject.Save(1, &t.pidWithinNS)
	stateSinkObject.Save(2, &t.eventQueue)
	stateSinkObject.Save(3, &t.leader)
	stateSinkObject.Save(4, &t.execing)
	stateSinkObject.Save(5, &t.tasks)
	stateSinkObject.Save(6, &t.tasksCount)
	stateSinkObject.Save(7, &t.liveTasks)
	stateSinkObject.Save(8, &t.activeTasks)
}

func (t *threadGroupNode) afterLoad(context.Context) {}

// +checklocksignore
func (t *threadGroupNode) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.pidns)
	stateSourceObject.Load(1, &t.pidWithinNS)
	stateSourceObject.Load(2, &t.eventQueue)
	stateSourceObject.Load(3, &t.leader)
	stateSourceObject.Load(4, &t.execing)
	stateSourceObject.Load(5, &t.tasks)
	stateSourceObject.Load(6, &t.tasksCount)
	stateSourceObject.Load(7, &t.liveTasks)
	stateSourceObject.Load(8, &t.activeTasks)
}

func (t *taskNode) StateTypeName() string {
	return "pkg/sentry/kernel.taskNode"
}

func (t *taskNode) StateFields() []string {
	return []string{
		"tg",
		"taskEntry",
		"parent",
		"children",
		"childPIDNamespace",
	}
}

func (t *taskNode) beforeSave() {}

// +checklocksignore
func (t *taskNode) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.tg)
	stateSinkObject.Save(1, &t.taskEntry)
	stateSinkObject.Save(2, &t.parent)
	stateSinkObject.Save(3, &t.children)
	stateSinkObject.Save(4, &t.childPIDNamespace)
}

func (t *taskNode) afterLoad(context.Context) {}

// +checklocksignore
func (t *taskNode) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.tg)
	stateSourceObject.Load(1, &t.taskEntry)
	stateSourceObject.Load(2, &t.parent)
	stateSourceObject.Load(3, &t.children)
	stateSourceObject.Load(4, &t.childPIDNamespace)
}

func (t *Timekeeper) StateTypeName() string {
	return "pkg/sentry/kernel.Timekeeper"
}

func (t *Timekeeper) StateFields() []string {
	return []string{
		"realtimeClock",
		"monotonicClock",
		"bootTime",
		"saveMonotonic",
		"saveRealtime",
	}
}

// +checklocksignore
func (t *Timekeeper) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.realtimeClock)
	stateSinkObject.Save(1, &t.monotonicClock)
	stateSinkObject.Save(2, &t.bootTime)
	stateSinkObject.Save(3, &t.saveMonotonic)
	stateSinkObject.Save(4, &t.saveRealtime)
}

// +checklocksignore
func (t *Timekeeper) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.realtimeClock)
	stateSourceObject.Load(1, &t.monotonicClock)
	stateSourceObject.Load(2, &t.bootTime)
	stateSourceObject.Load(3, &t.saveMonotonic)
	stateSourceObject.Load(4, &t.saveRealtime)
	stateSourceObject.AfterLoad(func() { t.afterLoad(ctx) })
}

func (tc *timekeeperClock) StateTypeName() string {
	return "pkg/sentry/kernel.timekeeperClock"
}

func (tc *timekeeperClock) StateFields() []string {
	return []string{
		"tk",
		"c",
	}
}

func (tc *timekeeperClock) beforeSave() {}

// +checklocksignore
func (tc *timekeeperClock) StateSave(stateSinkObject state.Sink) {
	tc.beforeSave()
	stateSinkObject.Save(0, &tc.tk)
	stateSinkObject.Save(1, &tc.c)
}

func (tc *timekeeperClock) afterLoad(context.Context) {}

// +checklocksignore
func (tc *timekeeperClock) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tc.tk)
	stateSourceObject.Load(1, &tc.c)
}

func (tty *TTY) StateTypeName() string {
	return "pkg/sentry/kernel.TTY"
}

func (tty *TTY) StateFields() []string {
	return []string{
		"TTYOperations",
		"index",
		"tg",
	}
}

func (tty *TTY) beforeSave() {}

// +checklocksignore
func (tty *TTY) StateSave(stateSinkObject state.Sink) {
	tty.beforeSave()
	stateSinkObject.Save(0, &tty.TTYOperations)
	stateSinkObject.Save(1, &tty.index)
	stateSinkObject.Save(2, &tty.tg)
}

func (tty *TTY) afterLoad(context.Context) {}

// +checklocksignore
func (tty *TTY) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tty.TTYOperations)
	stateSourceObject.Load(1, &tty.index)
	stateSourceObject.Load(2, &tty.tg)
}

func (u *UTSNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.UTSNamespace"
}

func (u *UTSNamespace) StateFields() []string {
	return []string{
		"hostName",
		"domainName",
		"userns",
		"inode",
	}
}

func (u *UTSNamespace) beforeSave() {}

// +checklocksignore
func (u *UTSNamespace) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.hostName)
	stateSinkObject.Save(1, &u.domainName)
	stateSinkObject.Save(2, &u.userns)
	stateSinkObject.Save(3, &u.inode)
}

func (u *UTSNamespace) afterLoad(context.Context) {}

// +checklocksignore
func (u *UTSNamespace) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.hostName)
	stateSourceObject.Load(1, &u.domainName)
	stateSourceObject.Load(2, &u.userns)
	stateSourceObject.Load(3, &u.inode)
}

func (v *VDSOParamPage) StateTypeName() string {
	return "pkg/sentry/kernel.VDSOParamPage"
}

func (v *VDSOParamPage) StateFields() []string {
	return []string{
		"fr",
		"seq",
		"copyScratchBuffer",
	}
}

func (v *VDSOParamPage) beforeSave() {}

// +checklocksignore
func (v *VDSOParamPage) StateSave(stateSinkObject state.Sink) {
	v.beforeSave()
	stateSinkObject.Save(0, &v.fr)
	stateSinkObject.Save(1, &v.seq)
	stateSinkObject.Save(2, &v.copyScratchBuffer)
}

// +checklocksignore
func (v *VDSOParamPage) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &v.fr)
	stateSourceObject.Load(1, &v.seq)
	stateSourceObject.Load(2, &v.copyScratchBuffer)
	stateSourceObject.AfterLoad(func() { v.afterLoad(ctx) })
}

func init() {
	state.Register((*Cgroup)(nil))
	state.Register((*hierarchy)(nil))
	state.Register((*CgroupRegistry)(nil))
	state.Register((*FDFlags)(nil))
	state.Register((*descriptor)(nil))
	state.Register((*FDTable)(nil))
	state.Register((*FDTableRefs)(nil))
	state.Register((*FSContext)(nil))
	state.Register((*FSContextRefs)(nil))
	state.Register((*IPCNamespace)(nil))
	state.Register((*UserCounters)(nil))
	state.Register((*CgroupMount)(nil))
	state.Register((*Kernel)(nil))
	state.Register((*privateMemoryFileMetadata)(nil))
	state.Register((*SocketRecord)(nil))
	state.Register((*CheckpointGeneration)(nil))
	state.Register((*CheckpointWaitable)(nil))
	state.Register((*pendingSignals)(nil))
	state.Register((*pendingSignalQueue)(nil))
	state.Register((*pendingSignal)(nil))
	state.Register((*pendingSignalList)(nil))
	state.Register((*pendingSignalEntry)(nil))
	state.Register((*savedPendingSignal)(nil))
	state.Register((*IntervalTimer)(nil))
	state.Register((*processGroupList)(nil))
	state.Register((*processGroupEntry)(nil))
	state.Register((*ProcessGroupRefs)(nil))
	state.Register((*ptraceOptions)(nil))
	state.Register((*ptraceStop)(nil))
	state.Register((*OldRSeqCriticalRegion)(nil))
	state.Register((*taskSeccomp)(nil))
	state.Register((*sessionList)(nil))
	state.Register((*sessionEntry)(nil))
	state.Register((*SessionRefs)(nil))
	state.Register((*Session)(nil))
	state.Register((*ProcessGroup)(nil))
	state.Register((*SignalHandlers)(nil))
	state.Register((*syscallTableInfo)(nil))
	state.Register((*syslog)(nil))
	state.Register((*Task)(nil))
	state.Register((*itimerRealListener)(nil))
	state.Register((*itimerVirtListener)(nil))
	state.Register((*itimerProfListener)(nil))
	state.Register((*rlimitCPUSoftListener)(nil))
	state.Register((*rlimitCPUHardListener)(nil))
	state.Register((*runSyscallAfterPtraceEventClone)(nil))
	state.Register((*runSyscallAfterVforkStop)(nil))
	state.Register((*vforkStop)(nil))
	state.Register((*execStop)(nil))
	state.Register((*runSyscallAfterExecStop)(nil))
	state.Register((*runExit)(nil))
	state.Register((*runExitMain)(nil))
	state.Register((*runExitNotify)(nil))
	state.Register((*TaskImage)(nil))
	state.Register((*taskList)(nil))
	state.Register((*taskEntry)(nil))
	state.Register((*runApp)(nil))
	state.Register((*groupStop)(nil))
	state.Register((*runInterrupt)(nil))
	state.Register((*runInterruptAfterSignalDeliveryStop)(nil))
	state.Register((*runSyscallAfterSyscallEnterStop)(nil))
	state.Register((*runSyscallAfterSysemuStop)(nil))
	state.Register((*runSyscallReinvoke)(nil))
	state.Register((*runSyscallExit)(nil))
	state.Register((*ThreadGroup)(nil))
	state.Register((*TaskSet)(nil))
	state.Register((*PIDNamespace)(nil))
	state.Register((*threadGroupNode)(nil))
	state.Register((*taskNode)(nil))
	state.Register((*Timekeeper)(nil))
	state.Register((*timekeeperClock)(nil))
	state.Register((*TTY)(nil))
	state.Register((*UTSNamespace)(nil))
	state.Register((*VDSOParamPage)(nil))
}
