/* SPDX-License-Identifier: GPL-3.0-or-later
 * Copyright © 2015-2019 by The qTox Project Contributors
 * Copyright © 2024-2026 The TokTok team.
 */

#include "genericchatitemwidget.h"

#include "src/widget/style.h"
#include "src/widget/tool/croppinglabel.h"

#include <QVariant>

GenericChatItemWidget::GenericChatItemWidget(bool compact_, Style& style, QWidget* parent)
    : QFrame(parent)
    , compact(compact_)
{
    setProperty("compact", compact_);

    nameLabel = new CroppingLabel(this);
    nameLabel->setObjectName("name");
    nameLabel->setTextFormat(Qt::PlainText);

    connect(&style, &Style::themeReload, this, &GenericChatItemWidget::reloadTheme);
}

bool GenericChatItemWidget::isCompact() const
{
    return compact;
}

void GenericChatItemWidget::setCompact(bool compact_)
{
    compact = compact_;
}

QString GenericChatItemWidget::getName() const
{
    return nameLabel->fullText();
}

void GenericChatItemWidget::searchName(const QString& searchString, bool hide)
{
    setVisible(!hide && getName().contains(searchString, Qt::CaseInsensitive));
}
