// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

//go:build go1.27

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "17.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 765 elements
	// Entry 0 - 1F
	0x00000001000f0930, 0x00010002f8000000, 0x0003f801080f0930, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80190286000, 0x002c68001829f000,
	0x002c8801b82a0800, 0x002e8000d82bc000, 0x002f7800302c9800, 0x00300008702cc800,
	0x00387801e0353800, 0x003a680328371800, 0x003e0001d83a4000, 0x003fe801883c1800,
	0x00418000783da000, 0x00420000e03e1800, 0x0042f000083ef800, 0x00430000583f0000,
	0x00438001103f5800, 0x0044b80768406800, 0x004c28004047d000, 0x004c780010481000,
	0x004c9800b0482000, 0x004d50003848d000, 0x004d900008490800, 0x004db00020491000,
	// Entry 20 - 3F
	0x004de00048493000, 0x004e380010497800, 0x004e580020498800, 0x004eb8000849a800,
	0x004ee0001049b000, 0x004ef8002049c000, 0x004f18000849e020, 0x004f3000c849e820,
	0x00500800184ab020, 0x00502800304ac820, 0x00507800104af820, 0x00509800b04b0820,
	0x00515000384bb820, 0x00519000104bf020, 0x0051a800104c0020, 0x0051c000104c1020,
	0x0051e000084c2020, 0x0051f000284c2820, 0x00523800104c5020, 0x00525800184c6020,
	0x00528800084c7820, 0x0052c800204c8020, 0x0052f000084ca020, 0x00533000884ca820,
	0x00540800184d3020, 0x00542800484d4820, 0x00547800184d9020, 0x00549800b04da820,
	0x00555000384e5820, 0x00559000104e9020, 0x0055a800284ea020, 0x0055e000504ec820,
	// Entry 40 - 5F
	0x00563800184f1820, 0x00565800184f3020, 0x00568000084f4820, 0x00570000204f5020,
	0x00573000604f7020, 0x0057c800384fd020, 0x0058080018500820, 0x0058280040502020,
	0x0058780010506020, 0x00589800b0507020, 0x0059500038512020, 0x0059900010515820,
	0x0059a80028516820, 0x0059e00048519020, 0x005a38001051d820, 0x005a58001851e820,
	0x005aa80018520020, 0x005ae00010521820, 0x005af80028522820, 0x005b300090525020,
	0x005c10001052e020, 0x005c28003052f020, 0x005c700018532020, 0x005c900020533820,
	0x005cc80010535820, 0x005ce00008536820, 0x005cf00010537020, 0x005d180010538020,
	0x005d400018539020, 0x005d70006053a820, 0x005df00028540820, 0x005e300018543020,
	// Entry 60 - 7F
	0x005e500020544820, 0x005e800008546820, 0x005eb80008547020, 0x005f3000a8547820,
	0x0060000068552020, 0x0060700018558820, 0x00609000b855a020, 0x0061500080565820,
	0x0061e0004856d820, 0x0062300018572020, 0x0062500020573820, 0x0062a80010575820,
	0x0062c00018576820, 0x0062e00010578020, 0x0063000020579020, 0x006330005057b020,
	0x0063b800b0580020, 0x006470001858b020, 0x00649000b858c820, 0x0065500050598020,
	0x0065a8002859d020, 0x0065e0004859f820, 0x00663000185a4020, 0x00665000205a5820,
	0x0066a800105a7820, 0x0066e000185a8820, 0x00670000205aa020, 0x00673000505ac020,
	0x00678800185b1020, 0x00680000685b2820, 0x00687000185b9020, 0x00689001985ba820,
	// Entry 80 - 9F
	0x006a3000185d4020, 0x006a5000305d5820, 0x006aa000805d8820, 0x006b3000d05e0820,
	0x006c0800185ed820, 0x006c2800905ef020, 0x006cd000c05f8020, 0x006d980048604020,
	0x006de80008608820, 0x006e000038609020, 0x006e50000860c820, 0x006e78003060d020,
	0x006eb00008610020, 0x006ec00040610820, 0x006f300050614820, 0x006f900018619820,
	0x00700801d061b020, 0x0071f800e8638020, 0x0074080010646820, 0x0074200008647820,
	0x0074300028648020, 0x00746000c064a820, 0x0075280008656820, 0x00753800b8657020,
	0x0076000028662820, 0x0076300008665020, 0x0076400038665820, 0x0076800050669020,
	0x0076e0002066e020, 0x0078000240670020, 0x007a480120694020, 0x007b8801386a6020,
	// Entry A0 - BF
	0x007cc801206b9820, 0x007df000786cb820, 0x007e7000686d3020, 0x00800006306d9820,
	0x008638000873c820, 0x008668000873d020, 0x0086800bc873d820, 0x00925000207fa020,
	0x00928000387fc020, 0x0092c000087ff820, 0x0092d00020800020, 0x0093000148802020,
	0x0094500020816820, 0x0094800108818820, 0x0095900020829020, 0x0095c0003882b020,
	0x009600000882e820, 0x009610002082f020, 0x0096400078831020, 0x0096c001c8838820,
	0x0098900020855020, 0x0098c00218857020, 0x009ae80100878820, 0x009c0000d0888820,
	0x009d0002b0895820, 0x009fc000308c0820, 0x00a00014e88c3820, 0x00b50000c0a12020,
	0x00b5c00208a1e040, 0x00b80000b0a3e840, 0x00b8f800c0a49840, 0x00ba0000a0a55840,
	// Entry C0 - DF
	0x00bb000068a5f840, 0x00bb700018a66040, 0x00bb900010a67840, 0x00bc0002f0a68840,
	0x00bf000050a97840, 0x00bf800050a9c840, 0x00c00000d0aa1840, 0x00c10002c8aae840,
	0x00c4000158adb040, 0x00c5800230af0840, 0x00c80000f8b13840, 0x00c9000060b23040,
	0x00c9800060b29040, 0x00ca000008b2f040, 0x00ca200150b2f840, 0x00cb800028b44840,
	0x00cc000160b47040, 0x00cd8000d0b5d040, 0x00ce800058b6a040, 0x00cef001f0b6f840,
	0x00d0f00208b8e840, 0x00d30000e8baf040, 0x00d3f80058bbd840, 0x00d4800050bc3040,
	0x00d5000070bc8040, 0x00d5800170bcf040, 0x00d7000060be6040, 0x00d8000268bec040,
	0x00da700530c12840, 0x00dfe001e0c65840, 0x00e1d80078c83840, 0x00e26801f0c8b040,
	// Entry E0 - FF
	0x00e4800158caa040, 0x00e5e80058cbf840, 0x00e6800158cc5040, 0x00e80010b0cda840,
	0x00f8c00030de5840, 0x00f9000130de8840, 0x00fa400030dfb840, 0x00fa800040dfe840,
	0x00fac80008e02840, 0x00fad80008e03040, 0x00fae80008e03840, 0x00faf800f8e04040,
	0x00fc0001a8e13840, 0x00fdb00078e2e040, 0x00fe300070e35840, 0x00feb00030e3c840,
	0x00fee80098e3f840, 0x00ff900018e49040, 0x00ffb00048e4a840, 0x0100000328e4f040,
	0x0103300060e81840, 0x0103a000d8e87840, 0x0104800068e95040, 0x0105000110e9b840,
	0x0106800090eac840, 0x0107100078eb5860, 0x0108000460ebd060, 0x010c8014d0f03060,
	0x0122000059050060, 0x0123003429055860, 0x0157280479398080, 0x015bb00bf13df880,
	// Entry 100 - 11F
	0x0167c8016949e880, 0x01693800094b5080, 0x01696800094b5880, 0x01698001c14b6080,
	0x016b7800114d2080, 0x016bf800c14d3080, 0x016d0000394df080, 0x016d4000394e2880,
	0x016d8000394e6080, 0x016dc000394e9880, 0x016e0000394ed080, 0x016e4000394f0880,
	0x016e8000394f4080, 0x016ec000394f7880, 0x016f0003f14fb080, 0x01740000d153a080,
	0x0174d802c9547080, 0x01780006b1573880, 0x017f8002815de880, 0x01820802b1606880,
	0x0184c80339631880, 0x0188280159665080, 0x01898802f167a880, 0x018c8002b16a9880,
	0x018f7801816d4880, 0x0191000f016ec880, 0x01a000ce00000370, 0x026e0002017dc880,
	0x02700290000871f0, 0x05000017297fc880, 0x0517280d4196f0a0, 0x05248001b9a430a0,
	// Entry 120 - 13F
	0x0526800ae1a5e8a0, 0x05320005c1b0c8a0, 0x05380006e9b688a0, 0x053f8801e1bd70a0,
	0x0541800051bf50a0, 0x05420001c1bfa0a0, 0x0544000231c160a0, 0x0546700061c390a0,
	0x05470003a1c3f0a0, 0x054af800f1c790a0, 0x054c000271c880a0, 0x054e780059caf0a0,
	0x054ef00109cb48a0, 0x05500001b9cc50a0, 0x0552000071ce08a0, 0x0552800051ce78a0,
	0x0552e00339cec8a0, 0x0556d800e1d200a0, 0x0558080031d2e0a0, 0x0558480031d310a0,
	0x0558880031d340a0, 0x0559000039d370a0, 0x0559400039d3a8a0, 0x05598001e1d3e0a0,
	0x055b8003f1d5c0a0, 0x055f800051d9b0a0, 0x0560015d2008ea30, 0x06bd8000b9da00a0,
	0x06be580189dab8a0, 0x06c0001c0009ec10, 0x06dc0004000c4b90, 0x06e00020000971f0,
	// Entry 140 - 15F
	0x070000c8000d29b0, 0x07c8000b71dc40a0, 0x07d3800351e7b0a0, 0x07d8000039eb00a0,
	0x07d8980029eb38a0, 0x07d8e800d1eb60a0, 0x07d9c00029ec30a0, 0x07d9f00009ec58a0,
	0x07da000011ec60a0, 0x07da180011ec70a0, 0x07da3000d1ec80a0, 0x07db001381ed50c0,
	0x07ef80015200d0c0, 0x07f100019a0220c0, 0x07f2a0009a03b8c0, 0x07f34000220450c0,
	0x07f380002a0470c0, 0x07f3b0043a0498c0, 0x07f7f8000a08d0c0, 0x07f80805f208d8c0,
	0x07fe1000320ec8c0, 0x07fe5000320ef8c0, 0x07fe9000320f28c0, 0x07fed0001a0f58c0,
	0x07ff00003a0f70c0, 0x07ff40003a0fa8c0, 0x07ffc8002a0fe0c0, 0x08000000621008c0,
	0x08006800d21068c0, 0x080140009a1138c0, 0x0801e0001211d0c0, 0x0801f8007a11e0c0,
	// Entry 160 - 17F
	0x08028000721258c0, 0x08040003da12c8c0, 0x080800001a16a0c0, 0x080838016a16b8c0,
	0x0809b802c21820c0, 0x080c80006a1ae0c0, 0x080d00000a1b48c0, 0x080e8001721b50c0,
	0x08140000ea1cc0c0, 0x081500018a1da8c0, 0x08170000e21f30c0, 0x08180001222010c0,
	0x08196800f22130c0, 0x081a80015a2220c0, 0x081c0000f22378c0, 0x081cf8012a2468c0,
	0x081e4000722590c0, 0x08200004f22600c0, 0x08250000522af0c0, 0x08258001222b40c0,
	0x0826c001222c60c0, 0x08280001422d80c0, 0x08298001422ec0c0, 0x082ac000623000e0,
	0x082b7800623060e0, 0x082be0007a30c0e0, 0x082c60003a3138e0, 0x082ca000123170e0,
	0x082cb8005a3180e0, 0x082d18007a31d8e0, 0x082d98003a3250e0, 0x082dd800123288e0,
	// Entry 180 - 19F
	0x082e0001a23298e0, 0x08300009ba3438e0, 0x083a0000b23df0e0, 0x083b0000423ea0e0,
	0x083c0000323ee0e0, 0x083c3801523f10e0, 0x083d90004a4060e0, 0x084000003240a8e0,
	0x084040000a40d8e0, 0x084050016240e0e0, 0x0841b800124240e0, 0x0841e0000a4250e0,
	0x0841f800ba4258e0, 0x0842b802424310e0, 0x084538004a4550e0, 0x084700009a4598e0,
	0x0847a000124630e0, 0x0847d8010a4640e0, 0x0848f800da4748e0, 0x0849f800da4820e0,
	0x084c0001c248f8e0, 0x084de000a24ab8e0, 0x084e9001924b58e0, 0x08502800124ce8e0,
	0x08506000424cf8e0, 0x0850a8001a4d38e0, 0x0850c800ea4d50e0, 0x0851c0001a4e38e0,
	0x0851f800524e50e0, 0x085280004a4ea0e0, 0x08530002024ee8e0, 0x085600013a50e8e0,
	// Entry 1A0 - 1BF
	0x08575800625220e0, 0x08580001b25280e0, 0x0859c800ea5430e0, 0x085ac000da5518e0,
	0x085bc000d255f0e0, 0x085cc8002256c0e0, 0x085d48003a56e0e0, 0x086000024a5718e0,
	0x086400019a5960e0, 0x086600019a5af8e0, 0x0867d001725c90e0, 0x08698000525e00e0,
	0x086a0001325e50e0, 0x086b4800ea5f80e0, 0x086c7000126068e0, 0x08730000fa6078e0,
	0x08740001526170e0, 0x087558001a62c0e0, 0x087580001262d8e0, 0x087610003262e8e0,
	0x087680004a6318e0, 0x0877d001726360e0, 0x087980015264d0e0, 0x087b8000d26620e0,
	0x087d8000e266f0e0, 0x087f0000ba67d0e0, 0x08800002726888e0, 0x08829001226af8e0,
	0x0883f802226c18e0, 0x088668000a6e38e0, 0x08868000ca6e40e0, 0x08878000526f08e0,
	// Entry 1C0 - 1DF
	0x08880001aa6f58e0, 0x0889b000927100e0, 0x088a80013a7190e0, 0x088c00030272c8e0,
	0x088f0800a275c8e0, 0x08900000927668e0, 0x089098017a76f8e0, 0x089400003a7870e0,
	0x089440000a78a8e0, 0x089450002278b0e0, 0x089478007a78d0e0, 0x0894f8005a7948e0,
	0x08958001da79a0e0, 0x08978000527b78e0, 0x08980000227bc8e0, 0x08982800427be8e0,
	0x08987800127c28e0, 0x08989800b27c38e0, 0x089950003a7ce8e0, 0x08999000127d20e0,
	0x0899a8002a7d30e0, 0x0899d800527d58e0, 0x089a3800127da8e0, 0x089a58001a7db8e0,
	0x089a80000a7dd0e0, 0x089ab8000a7dd8e0, 0x089ae8003a7de0e0, 0x089b30003a7e18e0,
	0x089b80002a7e50e0, 0x089c0000527e78e0, 0x089c58000a7ec8e0, 0x089c70000a7ed0e0,
	// Entry 1E0 - 1FF
	0x089c8001327ed8e0, 0x089db800528008e0, 0x089e10000a8058e0, 0x089e28000a8060e0,
	0x089e3800228068e0, 0x089e6000528088e0, 0x089eb8001280d8e0, 0x089f08001280e8e0,
	0x08a00002e280f8e0, 0x08a2e8002a83d8e0, 0x08a40002428400e0, 0x08a68000528640e0,
	0x08ac0001b28690e0, 0x08adc001328840e0, 0x08b000010a8970e0, 0x08b10801228a7900,
	0x08b28000528b9900, 0x08b300006a8be900, 0x08b40001d28c5100, 0x08b60000528e2100,
	0x08b68000a28e7100, 0x08b80000da8f1100, 0x08b8e8007a8fe900, 0x08b98000ba906100,
	0x08c00001e2911900, 0x08c500029a92f900, 0x08c7f80042959100, 0x08c848000a95d100,
	0x08c860004295d900, 0x08c8a80012961900, 0x08c8c000f2962900, 0x08c9b80012971900,
	// Entry 200 - 21F
	0x08c9d80062972900, 0x08ca800052978900, 0x08cd00004297d900, 0x08cd500172981900,
	0x08ced0005a998900, 0x08d000024299e100, 0x08d280029a9c2100, 0x08d580024a9eb900,
	0x08d8000052a10100, 0x08db000042a15100, 0x08de000112a19100, 0x08df800052a2a100,
	0x08e000004aa2f100, 0x08e050016aa33900, 0x08e1c00072a4a100, 0x08e28000eaa51100,
	0x08e3800102a5f900, 0x08e49000b2a6f900, 0x08e5480072a7a900, 0x08e800003aa81900,
	0x08e8400012a85100, 0x08e8580162a86100, 0x08e9d0000aa9c100, 0x08e9e00012a9c900,
	0x08e9f8004aa9d900, 0x08ea800052aa2100, 0x08eb000032aa7100, 0x08eb380012aaa100,
	0x08eb50012aaab100, 0x08ec800012abd900, 0x08ec980032abe900, 0x08ed000052ac1900,
	// Entry 220 - 23F
	0x08ed800162ac6900, 0x08ef000052adc900, 0x08f70000caae1900, 0x08f800008aaee100,
	0x08f890014aaf6900, 0x08f9f000eab0b100, 0x08fd80000ab19900, 0x08fe000192b1a100,
	0x08fff81cdab33100, 0x092000037ad00900, 0x092380002ad38100, 0x0924000622d3a900,
	0x097c800262d9c900, 0x097ee000badc2920, 0x09800022b2dce120, 0x09a3002ec2ff9120,
	0x09d1c04e1b2e5140, 0x0a200003d37c6940, 0x0a23d00e6b803960, 0x0b080001d38ea160,
	0x0b400011cb907160, 0x0b520000fba23960, 0x0b53000053a33160, 0x0b5370028ba38160,
	0x0b56000053a60960, 0x0b568000f3a65960, 0x0b57800033a74960, 0x0b58000233a77960,
	0x0b5a800053a9a960, 0x0b5ad8003ba9f960, 0x0b5b1800abaa3160, 0x0b5be8009baad960,
	// Entry 240 - 25F
	0x0b6a0001d3ab7160, 0x0b720002dbad4160, 0x0b750000cbb01960, 0x0b75d800cbb0e160,
	0x0b7800025bb1a960, 0x0b7a7801cbb40160, 0x0b7c78008bb5c960, 0x0b7f00002bb65160,
	0x0b7f80003bb67960, 0x0b8000c0000e7a50, 0x0c40001f3bb6b160, 0x0c5f38077bd5e980,
	0x0c67f8000bdd6180, 0x0c680000f80d93b0, 0x0c6c00039bdd6980, 0x0d7f800023e10180,
	0x0d7fa8003be12180, 0x0d7fe80013e15980, 0x0d8000091be16980, 0x0d8990000bea8180,
	0x0d8a80001bea8980, 0x0d8aa8000beaa180, 0x0d8b200023eaa980, 0x0d8b800c63eac980,
	0x0de000035bf72980, 0x0de380006bfa8180, 0x0de400004bfae980, 0x0de4800053fb3180,
	0x0de4e00043fb8180, 0x0e600007ebfbc180, 0x0e68000da403a980, 0x0e75d000bc114980,
	// Entry 260 - 27F
	0x0e7700008c120180, 0x0e78000174128980, 0x0e798000bc13f980, 0x0e7a8003a414b180,
	0x0e800007b4185180, 0x0e8800013c200180, 0x0e8948001c213980, 0x0e896005fc2151a0,
	0x0e900002342749a0, 0x0e960000a42979a0, 0x0e970000a42a19a0, 0x0e980002bc2ab9a0,
	0x0e9b0000cc2d71a0, 0x0ea00002ac2e39a0, 0x0ea2b0023c30e1a0, 0x0ea4f000143319a0,
	0x0ea510000c3329a0, 0x0ea52800143331a0, 0x0ea54800243341a0, 0x0ea57000643361a0,
	0x0ea5d8000c33c1a0, 0x0ea5e8003c33c9a0, 0x0ea628020c3401a0, 0x0ea83800243609a0,
	0x0ea86800443629a0, 0x0ea8b0003c3669a0, 0x0ea8f000e436a1a0, 0x0ea9d800243781a0,
	0x0eaa00002c37a1a0, 0x0eaa30000c37c9a0, 0x0eaa50003c37d1a0, 0x0eaa900aa43809a0,
	// Entry 280 - 29F
	0x0eb540092442a9a0, 0x0ebe700f9c4bc9a0, 0x0ece08065c5b61c0, 0x0ed4d8002c61b9c0,
	0x0ed508007c61e1c0, 0x0ef80000fc6259c0, 0x0ef92800346351c0, 0x0f0000003c6381c0,
	0x0f0040008c63b9c0, 0x0f00d8003c6441c0, 0x0f011800146479c0, 0x0f0130002c6489c0,
	0x0f018001f464b1c0, 0x0f0478000c66a1c0, 0x0f0800016c66a9c0, 0x0f098000746811c0,
	0x0f0a0000546881c0, 0x0f0a70001468d1c0, 0x0f148000fc68e1c0, 0x0f160001d469d9c0,
	0x0f17f8000c6ba9c0, 0x0f268001546bb1c0, 0x0f2e80015c6d01c0, 0x0f2ff8000c6e59c0,
	0x0f360000fc6e61c0, 0x0f370000b46f59c0, 0x0f37f000147009c0, 0x0f3f00003c7019c0,
	0x0f3f4000247051c0, 0x0f3f6800147071c0, 0x0f3f80007c7081c0, 0x0f4000062c70f9c0,
	// Entry 2A0 - 2BF
	0x0f463800847721c0, 0x0f4800026477a1c0, 0x0f4a8000547a01c0, 0x0f4af000147a51c0,
	0x0f638802247a61c0, 0x0f680801ec7c81c0, 0x0f700000247e69c0, 0x0f702800dc7e89c0,
	0x0f710800147f61c0, 0x0f7120000c7f71c0, 0x0f7138000c7f79c0, 0x0f714800547f81c0,
	0x0f71a000247fd1c0, 0x0f71c8000c7ff1c0, 0x0f71d8000c7ff9c0, 0x0f7210000c8001c0,
	0x0f7238000c8009c0, 0x0f7248000c8011c0, 0x0f7258000c8019c0, 0x0f7268001c8021c0,
	0x0f728800148039c0, 0x0f72a0000c8049c0, 0x0f72b8000c8051c0, 0x0f72c8000c8059c0,
	0x0f72d8000c8061c0, 0x0f72e8000c8069c0, 0x0f72f8000c8071c0, 0x0f730800148079c0,
	0x0f7320000c8089c0, 0x0f733800248091c0, 0x0f7360003c80b1c0, 0x0f73a0002480e9c0,
	// Entry 2C0 - 2DF
	0x0f73c800248109c0, 0x0f73f0000c8129c0, 0x0f740000548131c0, 0x0f7458008c8181c0,
	0x0f7508001c8209c0, 0x0f7528002c8221c0, 0x0f7558008c8249c0, 0x0f7780001482d1c0,
	0x0f8000016482e1c0, 0x0f818003248441c0, 0x0f8500007c8761c0, 0x0f8588007c87d9c0,
	0x0f8608007c8851c0, 0x0f8688012c88c9c0, 0x0f8800057489f1c0, 0x0f8f3000ec8f61c0,
	0x0f908001649049c0, 0x0f9200004c91a9c0, 0x0f9280001491f1c0, 0x0f930000349201c0,
	0x0f98001b449231c0, 0x0fb340038cad71e0, 0x0fb6e0008cb0f9e0, 0x0fb780006cb181e0,
	0x0fb80006d4b1e9e0, 0x0fbf000064b8b9e0, 0x0fbf80000cb919e0, 0x0fc0000064b921e0,
	0x0fc08001c4b981e0, 0x0fc2800054bb41e0, 0x0fc3000144bb91e0, 0x0fc48000f4bcd1e0,
	// Entry 2E0 - 2FF
	0x0fc5800064bdc1e0, 0x0fc6000014be21e0, 0x0fc680004cbe31e0, 0x0fc8000ac4be79e0,
	0x0fd3000074c939e0, 0x0fd380006cc9a9e0, 0x0fd400005cca11e0, 0x0fd47001ccca69e0,
	0x0fd640000ccc31e0, 0x0fd6680084cc39e0, 0x0fd6f80064ccb9e0, 0x0fd7780054cd19e0,
	0x0fd800049ccd69e0, 0x0fdca0033cd201e0, 0x100005370000db70, 0x153800820001b370,
	0x15ba0006f0028b70, 0x15c100b470036370, 0x167580e988043b70, 0x175f80137006c370,
	0x17c00010f4d539e0, 0x1800009a58051370, 0x189a80830005eb70, 0x191d808650079b70,
	0x700008000ce629e0, 0x7001000304e631e0, 0x7008000784e931e0, 0x780007fff00aead0,
	0x800007fff00b9ad0,
} // Size: 6144 bytes

var index = []uint16{ // 40471 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x969a, 0x96b3, 0x96cc, 0x96e5,
	0x96fd, 0x9716, 0x972e, 0x9746, 0x975e, 0x9776, 0x978f, 0x97a8,
	0x97c2, 0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9856, 0x9870,
	0x9889, 0x98a1, 0x98ba, 0x98d3, 0x98eb, 0x9904, 0x991d, 0x9937,
	0x994f, 0x9968, 0x9981, 0x999b, 0x99b4, 0x99cc, 0x99e6, 0x9a00,
	0x9a19, 0x9a31, 0x9a4a, 0x9a6a, 0x9a8e, 0x9aa0, 0x9aaf, 0x9ad2,
	// Entry 540 - 57F
	0x9af4, 0x9b06, 0x9b1b, 0x9b2e, 0x9b46, 0x9b5f, 0x9b78, 0x9b8c,
	0x9b9f, 0x9bb2, 0x9bc6, 0x9bd9, 0x9bec, 0x9c00, 0x9c1b, 0x9c32,
	0x9c4b, 0x9c67, 0x9c7a, 0x9c94, 0x9ca7, 0x9cbd, 0x9cd1, 0x9cec,
	0x9cff, 0x9d12, 0x9d2e, 0x9d4a, 0x9d5b, 0x9d6d, 0x9d7f, 0x9d92,
	0x9dab, 0x9dbd, 0x9dd5, 0x9ded, 0x9e06, 0x9e18, 0x9e2a, 0x9e3c,
	0x9e4e, 0x9e61, 0x9e73, 0x9e93, 0x9ea6, 0x9ec2, 0x9ed4, 0x9eec,
	0x9efd, 0x9f15, 0x9f2a, 0x9f3e, 0x9f5a, 0x9f6f, 0x9f84, 0x9fa2,
	0x9fbb, 0x9fcd, 0x9fde, 0x9ff1, 0xa004, 0xa014, 0xa025, 0xa038,
	// Entry 580 - 5BF
	0xa049, 0xa05a, 0xa06b, 0xa082, 0xa093, 0xa0a6, 0xa0bd, 0xa0ce,
	0xa0e5, 0xa0f6, 0xa10a, 0xa11c, 0xa132, 0xa142, 0xa15b, 0xa16e,
	0xa17f, 0xa191, 0xa1a3, 0xa1b4, 0xa1c7, 0xa1e9, 0xa208, 0xa22a,
	0xa243, 0xa25f, 0xa271, 0xa282, 0xa298, 0xa2a9, 0xa2bb, 0xa2d3,
	0xa2e9, 0xa301, 0xa30b, 0xa326, 0xa348, 0xa354, 0xa360, 0xa375,
	0xa38d, 0xa39e, 0xa3c6, 0xa3e1, 0xa3ff, 0xa41c, 0xa431, 0xa446,
	0xa477, 0xa48d, 0xa49f, 0xa4b1, 0xa4c3, 0xa4d3, 0xa4e5, 0xa4fc,
	0xa51e, 0xa532, 0xa54c, 0xa55f, 0xa582, 0xa5a5, 0xa5c7, 0xa5ea,
	// Entry 5C0 - 5FF
	0xa60c, 0xa61e, 0xa62f, 0xa648, 0xa659, 0xa66b, 0xa67d, 0xa68e,
	0xa6a0, 0xa6b1, 0xa6c3, 0xa6d4, 0xa6e6, 0xa6f8, 0xa70b, 0xa71c,
	0xa72d, 0xa73e, 0xa74f, 0xa760, 0xa773, 0xa79a, 0xa7c3, 0xa7ea,
	0xa815, 0xa842, 0xa850, 0xa861, 0xa872, 0xa883, 0xa894, 0xa8a6,
	0xa8b8, 0xa8c9, 0xa8da, 0xa8f4, 0xa905, 0xa914, 0xa923, 0xa932,
	0xa93e, 0xa94a, 0xa956, 0xa963, 0xa96f, 0xa982, 0xa994, 0xa9a6,
	0xa9bb, 0xa9d0, 0xa9e7, 0xa9f6, 0xaa15, 0xaa3d, 0xaa58, 0xaa6d,
	0xaa87, 0xaa9e, 0xaab5, 0xaacb, 0xaae1, 0xaaf9, 0xab10, 0xab27,
	// Entry 600 - 63F
	0xab3d, 0xab55, 0xab6d, 0xab84, 0xab97, 0xabaf, 0xabc9, 0xabe1,
	0xabfa, 0xac13, 0xac31, 0xac49, 0xac71, 0xac99, 0xacb1, 0xacce,
	0xacea, 0xad0a, 0xad26, 0xad38, 0xad4c, 0xad5e, 0xad79, 0xadaa,
	0xadbb, 0xadce, 0xade1, 0xae03, 0xae31, 0xae43, 0xae55, 0xae7c,
	0xae8f, 0xaea4, 0xaeb6, 0xaed1, 0xaef1, 0xaf1f, 0xaf32, 0xaf46,
	0xaf57, 0xaf88, 0xafae, 0xafc0, 0xafde, 0xaff9, 0xb019, 0xb03d,
	0xb06b, 0xb090, 0xb0a1, 0xb0c7, 0xb0f6, 0xb11e, 0xb15b, 0xb180,
	0xb1a7, 0xb1ce, 0xb1f5, 0xb20e, 0xb234, 0xb254, 0xb265, 0xb28c,
	// Entry 640 - 67F
	0xb29f, 0xb2bf, 0xb2e6, 0xb2f9, 0xb310, 0xb32b, 0xb34b, 0xb35b,
	0xb382, 0xb393, 0xb3ae, 0xb3c1, 0xb3e6, 0xb3f8, 0xb41f, 0xb43d,
	0xb45d, 0xb484, 0xb4ab, 0xb4cc, 0xb4e5, 0xb4f8, 0xb514, 0xb53c,
	0xb559, 0xb57b, 0xb59b, 0xb5b1, 0xb5d8, 0xb5f6, 0xb611, 0xb629,
	0xb639, 0xb648, 0xb658, 0xb670, 0xb695, 0xb6a5, 0xb6bc, 0xb6d7,
	0xb6f5, 0xb715, 0xb724, 0xb74b, 0xb763, 0xb78c, 0xb79c, 0xb7ac,
	0xb7e5, 0xb81e, 0xb841, 0xb85b, 0xb871, 0xb88d, 0xb8a3, 0xb8b5,
	0xb8d0, 0xb8ee, 0xb918, 0xb93e, 0xb962, 0xb977, 0xb98e, 0xb99e,
	// Entry 680 - 6BF
	0xb9ae, 0xb9c3, 0xb9d9, 0xb9ef, 0xba0b, 0xba28, 0xba53, 0xba68,
	0xba89, 0xbaaa, 0xbaca, 0xbae9, 0xbb08, 0xbb29, 0xbb49, 0xbb69,
	0xbb88, 0xbba9, 0xbbca, 0xbbea, 0xbc0c, 0xbc2c, 0xbc4e, 0xbc6a,
	0xbc8d, 0xbcae, 0xbcc5, 0xbce1, 0xbcfb, 0xbd13, 0xbd29, 0xbd40,
	0xbd58, 0xbd71, 0xbd95, 0xbdb8, 0xbdca, 0xbde0, 0xbdf9, 0xbe13,
	0xbe2b, 0xbe3e, 0xbe5d, 0xbe6f, 0xbe82, 0xbe9e, 0xbeb2, 0xbed3,
	0xbee3, 0xbef4, 0xbf06, 0xbf18, 0xbf2a, 0xbf45, 0xbf57, 0xbf6c,
	0xbf7e, 0xbf92, 0xbfa3, 0xbfb4, 0xbfc9, 0xbfe4, 0xbff3, 0xc003,
	// Entry 6C0 - 6FF
	0xc01c, 0xc02f, 0xc041, 0xc053, 0xc065, 0xc076, 0xc091, 0xc0ad,
	0xc0ca, 0xc0dd, 0xc0f0, 0xc104, 0xc117, 0xc12a, 0xc13e, 0xc150,
	0xc162, 0xc180, 0xc19b, 0xc1ad, 0xc1bf, 0xc1d8, 0xc1ea, 0xc1fc,
	0xc208, 0xc21b, 0xc22b, 0xc23a, 0xc258, 0xc276, 0xc28d, 0xc2a4,
	0xc2bd, 0xc2d6, 0xc2e2, 0xc2f0, 0xc30b, 0xc326, 0xc33e, 0xc372,
	0xc3a7, 0xc3df, 0xc42a, 0xc45d, 0xc48a, 0xc4a8, 0xc4cd, 0xc505,
	0xc543, 0xc570, 0xc58d, 0xc5b4, 0xc5d9, 0xc613, 0xc643, 0xc668,
	0xc6a0, 0xc6c2, 0xc6eb, 0xc725, 0xc746, 0xc767, 0xc78d, 0xc7ae,
	// Entry 700 - 73F
	0xc7cd, 0xc7e7, 0xc817, 0xc839, 0xc86a, 0xc89e, 0xc8d9, 0xc915,
	0xc950, 0xc984, 0xc9c1, 0xca00, 0xca42, 0xca86, 0xcac9, 0xcb05,
	0xcb43, 0xcb86, 0xcbcb, 0xcc08, 0xcc46, 0xcc68, 0xcc8d, 0xcc9e,
	0xccb5, 0xccc8, 0xccd9, 0xccea, 0xcd01, 0xcd14, 0xcd27, 0xcd3a,
	0xcd4d, 0xcd60, 0xcd74, 0xcd86, 0xcd99, 0xcdac, 0xcdc3, 0xcdd6,
	0xcdec, 0xce02, 0xce18, 0xce29, 0xce3f, 0xce55, 0xce6c, 0xce7e,
	0xce90, 0xcea2, 0xceb6, 0xcec7, 0xcedb, 0xceef, 0xcf03, 0xcf13,
	0xcf23, 0xcf35, 0xcf49, 0xcf5c, 0xcf6f, 0xcf7d, 0xcf8d, 0xcf9b,
	// Entry 740 - 77F
	0xcfab, 0xcfb9, 0xcfc9, 0xcfd7, 0xcfe7, 0xcff5, 0xd005, 0xd011,
	0xd022, 0xd030, 0xd03d, 0xd04a, 0xd059, 0xd067, 0xd075, 0xd082,
	0xd091, 0xd0a0, 0xd0ae, 0xd0ba, 0xd0c7, 0xd0d3, 0xd0df, 0xd0eb,
	0xd0f8, 0xd104, 0xd119, 0xd125, 0xd132, 0xd13f, 0xd14c, 0xd159,
	0xd167, 0xd174, 0xd181, 0xd18f, 0xd19c, 0xd1aa, 0xd1b7, 0xd1c4,
	0xd1d1, 0xd1e5, 0xd1f2, 0xd200, 0xd20d, 0xd21a, 0xd227, 0xd234,
	0xd249, 0xd25b, 0xd26e, 0xd280, 0xd29d, 0xd2b9, 0xd2d8, 0xd2fa,
	0xd316, 0xd331, 0xd34f, 0xd36e, 0xd38c, 0xd3a4, 0xd3bb, 0xd3cf,
	// Entry 780 - 7BF
	0xd3e4, 0xd3ed, 0xd401, 0xd40f, 0xd41d, 0xd42c, 0xd43a, 0xd44f,
	0xd463, 0xd479, 0xd48f, 0xd4a2, 0xd4b6, 0xd4ca, 0xd4dd, 0xd4f1,
	0xd505, 0xd51a, 0xd530, 0xd544, 0xd558, 0xd570, 0xd583, 0xd596,
	0xd5ae, 0xd5c2, 0xd5d7, 0xd5ec, 0xd601, 0xd612, 0xd628, 0xd640,
	0xd655, 0xd67d, 0xd69a, 0xd6b5, 0xd6cb, 0xd6eb, 0xd707, 0xd71e,
	0xd73d, 0xd758, 0xd76e, 0xd78f, 0xd7ab, 0xd7c6, 0xd7dc, 0xd7f7,
	0xd812, 0xd828, 0xd83e, 0xd858, 0xd86e, 0xd88b, 0xd8a7, 0xd8c2,
	0xd8db, 0xd8f7, 0xd917, 0xd932, 0xd955, 0xd970, 0xd98b, 0xd9a5,
	// Entry 7C0 - 7FF
	0xd9bf, 0xd9dc, 0xd9fe, 0xda1a, 0xda2e, 0xda3f, 0xda50, 0xda61,
	0xda72, 0xda88, 0xda99, 0xdaaa, 0xdabc, 0xdacf, 0xdae0, 0xdaf1,
	0xdb02, 0xdb13, 0xdb24, 0xdb35, 0xdb46, 0xdb58, 0xdb69, 0xdb7a,
	0xdb8c, 0xdb9d, 0xdbb4, 0xdbc6, 0xdbd8, 0xdbf0, 0xdc09, 0xdc20,
	0xdc33, 0xdc4e, 0xdc68, 0xdc83, 0xdc9e, 0xdcb9, 0xdcd5, 0xdcf0,
	0xdd0a, 0xdd25, 0xdd41, 0xdd5c, 0xdd82, 0xddb2, 0xdddd, 0xde07,
	0xde2d, 0xde60, 0xde90, 0xdec0, 0xdeef, 0xdf1f, 0xdf40, 0xdf7e,
	0xdfb7, 0xdff8, 0xe036, 0xe06f, 0xe0b0, 0xe0dc, 0xe107, 0xe12b,
	// Entry 800 - 83F
	0xe14d, 0xe16f, 0xe185, 0xe19e, 0xe1b5, 0xe1dd, 0xe20a, 0xe22a,
	0xe251, 0xe283, 0xe297, 0xe2b9, 0xe2d0, 0xe2e9, 0xe2f5, 0xe312,
	0xe32f, 0xe34b, 0xe368, 0xe37b, 0xe39c, 0xe3b0, 0xe3cc, 0xe3f0,
	0xe412, 0xe438, 0xe45d, 0xe492, 0xe4b2, 0xe4d3, 0xe4fb, 0xe530,
	0xe563, 0xe57e, 0xe59f, 0xe5b9, 0xe5cf, 0xe5f6, 0xe61d, 0xe643,
	0xe65d, 0xe685, 0xe6ac, 0xe6cc, 0xe6fe, 0xe725, 0xe74c, 0xe772,
	0xe799, 0xe7d3, 0xe7ec, 0xe805, 0xe81f, 0xe83d, 0xe85b, 0xe87a,
	0xe89a, 0xe8ba, 0xe8e3, 0xe912, 0xe93a, 0xe962, 0xe996, 0xe9a8,
	// Entry 840 - 87F
	0xe9be, 0xe9d9, 0xea09, 0xea23, 0xea38, 0xea54, 0xea70, 0xea82,
	0xea9b, 0xeac5, 0xead9, 0xeaf6, 0xeb0b, 0xeb20, 0xeb35, 0xeb56,
	0xeb76, 0xeb99, 0xebb8, 0xebd6, 0xebf2, 0xec0c, 0xec28, 0xec49,
	0xec65, 0xec80, 0xec99, 0xecab, 0xecbd, 0xeccf, 0xece4, 0xecf9,
	0xed0e, 0xed27, 0xed41, 0xed57, 0xed70, 0xed8a, 0xeda0, 0xedb4,
	0xedc8, 0xeddc, 0xedf1, 0xee07, 0xee22, 0xee3d, 0xee58, 0xee74,
	0xee8f, 0xeeab, 0xeece, 0xeefa, 0xef1f, 0xef34, 0xef54, 0xef78,
	0xef93, 0xefab, 0xefc2, 0xefdb, 0xefee, 0xf002, 0xf015, 0xf029,
	// Entry 880 - 8BF
	0xf03c, 0xf050, 0xf06b, 0xf086, 0xf0a0, 0xf0b9, 0xf0cc, 0xf0e0,
	0xf0fa, 0xf113, 0xf126, 0xf13a, 0xf14e, 0xf163, 0xf177, 0xf18c,
	0xf1a1, 0xf1b5, 0xf1ca, 0xf1de, 0xf1f3, 0xf208, 0xf21d, 0xf233,
	0xf248, 0xf25e, 0xf273, 0xf287, 0xf29c, 0xf2b0, 0xf2c5, 0xf2d9,
	0xf2ef, 0xf303, 0xf318, 0xf32c, 0xf341, 0xf355, 0xf369, 0xf37d,
	0xf392, 0xf3a6, 0xf3bb, 0xf3d1, 0xf3e5, 0xf3fa, 0xf40f, 0xf423,
	0xf437, 0xf44f, 0xf468, 0xf47d, 0xf495, 0xf4ad, 0xf4c4, 0xf4dc,
	0xf4f3, 0xf50b, 0xf52a, 0xf54a, 0xf568, 0xf585, 0xf59c, 0xf5b4,
	// Entry 8C0 - 8FF
	0xf5d2, 0xf5ef, 0xf606, 0xf61e, 0xf634, 0xf659, 0xf671, 0xf67e,
	0xf69b, 0xf6ba, 0xf6d1, 0xf6e8, 0xf70b, 0xf723, 0xf73c, 0xf750,
	0xf766, 0xf77c, 0xf790, 0xf7a7, 0xf7bc, 0xf7d0, 0xf7e5, 0xf801,
	0xf81d, 0xf83c, 0xf85c, 0xf86c, 0xf883, 0xf898, 0xf8ac, 0xf8c0,
	0xf8d6, 0xf8eb, 0xf900, 0xf914, 0xf92a, 0xf940, 0xf955, 0xf971,
	0xf991, 0xf9ab, 0xf9bf, 0xf9d4, 0xf9e8, 0xf9fc, 0xfa11, 0xfa2e,
	0xfa43, 0xfa5d, 0xfa72, 0xfa87, 0xfaa5, 0xfabb, 0xfad0, 0xfadc,
	0xfaf4, 0xfb09, 0xfb1d, 0xfb2d, 0xfb3e, 0xfb4e, 0xfb5f, 0xfb6f,
	// Entry 900 - 93F
	0xfb80, 0xfb98, 0xfbb0, 0xfbc0, 0xfbd1, 0xfbe1, 0xfbf2, 0xfc03,
	0xfc15, 0xfc26, 0xfc38, 0xfc4a, 0xfc5b, 0xfc6d, 0xfc7e, 0xfc90,
	0xfca2, 0xfcb4, 0xfcc7, 0xfcd9, 0xfcec, 0xfcfe, 0xfd0f, 0xfd21,
	0xfd32, 0xfd44, 0xfd55, 0xfd66, 0xfd78, 0xfd89, 0xfd9b, 0xfdac,
	0xfdbd, 0xfdce, 0xfddf, 0xfdf1, 0xfe03, 0xfe14, 0xfe25, 0xfe37,
	0xfe4c, 0xfe61, 0xfe75, 0xfe8a, 0xfe9e, 0xfeb3, 0xfecf, 0xfeec,
	0xff00, 0xff15, 0xff29, 0xff3e, 0xff51, 0xff69, 0xff7f, 0xff91,
	0xffa3, 0xffb5, 0xffce, 0xffe7, 0x0003, 0x0020, 0x0032, 0x0043,
	// Entry 940 - 97F
	0x0054, 0x0067, 0x0079, 0x008b, 0x009c, 0x00af, 0x00c2, 0x00d4,
	0x00fa, 0x011f, 0x0131, 0x0143, 0x0161, 0x017f, 0x019f, 0x01be,
	0x01f6, 0x021a, 0x0228, 0x023a, 0x0257, 0x0270, 0x0283, 0x029b,
	0x02ae, 0x02c3, 0x02d4, 0x02e6, 0x02f7, 0x0309, 0x031a, 0x032c,
	0x033e, 0x0350, 0x0362, 0x0374, 0x0386, 0x0399, 0x03ab, 0x03be,
	0x03d1, 0x03e3, 0x03f6, 0x0408, 0x041b, 0x042e, 0x0441, 0x0455,
	0x0468, 0x047c, 0x048f, 0x04a1, 0x04b4, 0x04c6, 0x04d9, 0x04eb,
	0x04fd, 0x0510, 0x0522, 0x0535, 0x0547, 0x0559, 0x056b, 0x057d,
	// Entry 980 - 9BF
	0x0590, 0x05a2, 0x05b5, 0x05c7, 0x05d9, 0x05ec, 0x0602, 0x0617,
	0x062d, 0x0642, 0x0658, 0x066e, 0x0684, 0x069a, 0x06b0, 0x06c4,
	0x06d7, 0x06eb, 0x06ff, 0x0711, 0x0724, 0x0736, 0x0749, 0x075b,
	0x076d, 0x0781, 0x0794, 0x07a7, 0x07b9, 0x07cd, 0x07e1, 0x07f4,
	0x0802, 0x0810, 0x081c, 0x0828, 0x0839, 0x084d, 0x0867, 0x0880,
	0x0896, 0x08ab, 0x08bc, 0x08ce, 0x08df, 0x08f1, 0x0902, 0x0914,
	0x092d, 0x0946, 0x095d, 0x096e, 0x0980, 0x0997, 0x09a8, 0x09ba,
	0x09cc, 0x09df, 0x09f1, 0x0a04, 0x0a17, 0x0a29, 0x0a3c, 0x0a4e,
	// Entry 9C0 - 9FF
	0x0a61, 0x0a74, 0x0a87, 0x0a9b, 0x0aae, 0x0ac2, 0x0ad5, 0x0ae7,
	0x0afa, 0x0b0c, 0x0b1f, 0x0b31, 0x0b43, 0x0b56, 0x0b68, 0x0b7b,
	0x0b8d, 0x0b9f, 0x0bb1, 0x0bc3, 0x0bd6, 0x0be8, 0x0bfb, 0x0c0e,
	0x0c20, 0x0c32, 0x0c45, 0x0c5b, 0x0c71, 0x0c86, 0x0c9c, 0x0cb1,
	0x0cc7, 0x0ce4, 0x0d02, 0x0d1e, 0x0d33, 0x0d49, 0x0d65, 0x0d7a,
	0x0d90, 0x0da4, 0x0daf, 0x0dc9, 0x0de3, 0x0e00, 0x0e1e, 0x0e31,
	0x0e43, 0x0e55, 0x0e69, 0x0e7c, 0x0e8f, 0x0ea1, 0x0eb5, 0x0ec9,
	0x0edc, 0x0ef6, 0x0f09, 0x0f1c, 0x0f2f, 0x0f43, 0x0f57, 0x0f7a,
	// Entry A00 - A3F
	0x0f9a, 0x0fbe, 0x0fd4, 0x0fe7, 0x0ff9, 0x1007, 0x1016, 0x1024,
	0x1033, 0x1041, 0x1050, 0x1066, 0x107c, 0x108a, 0x1099, 0x10a7,
	0x10b6, 0x10c5, 0x10d5, 0x10e4, 0x10f4, 0x1104, 0x1113, 0x1123,
	0x1132, 0x1142, 0x1152, 0x1162, 0x1173, 0x1183, 0x1194, 0x11a4,
	0x11b3, 0x11c3, 0x11d2, 0x11e2, 0x11f1, 0x1200, 0x1210, 0x121f,
	0x122f, 0x123e, 0x124d, 0x125c, 0x126b, 0x127b, 0x128a, 0x129a,
	0x12aa, 0x12b9, 0x12c8, 0x12d8, 0x12eb, 0x12fe, 0x1310, 0x1323,
	0x1335, 0x1348, 0x1362, 0x137d, 0x138f, 0x13a2, 0x13b4, 0x13c7,
	// Entry A40 - A7F
	0x13d8, 0x13eb, 0x13ff, 0x1413, 0x1423, 0x1433, 0x1443, 0x145a,
	0x1471, 0x148b, 0x14a6, 0x14b6, 0x14c5, 0x14d4, 0x14e5, 0x14f5,
	0x1505, 0x1514, 0x1525, 0x1536, 0x1546, 0x1552, 0x1561, 0x157b,
	0x1592, 0x15af, 0x15cb, 0x15e4, 0x1603, 0x1616, 0x1628, 0x1636,
	0x1645, 0x1653, 0x1662, 0x1670, 0x167f, 0x168d, 0x169c, 0x16ab,
	0x16b9, 0x16c8, 0x16d7, 0x16e6, 0x16f6, 0x1705, 0x1714, 0x1724,
	0x1734, 0x1744, 0x1753, 0x1762, 0x1773, 0x1782, 0x1791, 0x17a0,
	0x17af, 0x17bf, 0x17ce, 0x17de, 0x17ef, 0x17fe, 0x180e, 0x181e,
	// Entry A80 - ABF
	0x182d, 0x183c, 0x184f, 0x1861, 0x1874, 0x1886, 0x1899, 0x18ab,
	0x18be, 0x18d1, 0x18e3, 0x18f6, 0x1909, 0x191a, 0x1922, 0x1936,
	0x1946, 0x1955, 0x1964, 0x1975, 0x1985, 0x1995, 0x19a4, 0x19b5,
	0x19c6, 0x19d6, 0x19e6, 0x19fe, 0x1a17, 0x1a25, 0x1a35, 0x1a44,
	0x1a54, 0x1a65, 0x1a78, 0x1a88, 0x1a99, 0x1ac0, 0x1ad7, 0x1aeb,
	0x1afe, 0x1b22, 0x1b31, 0x1b41, 0x1b50, 0x1b60, 0x1b6f, 0x1b7f,
	0x1b96, 0x1bad, 0x1bbc, 0x1bcc, 0x1bdc, 0x1beb, 0x1bfb, 0x1c0b,
	0x1c1b, 0x1c2c, 0x1c3c, 0x1c4d, 0x1c5e, 0x1c6e, 0x1c7f, 0x1c8f,
	// Entry AC0 - AFF
	0x1ca0, 0x1cb1, 0x1cc2, 0x1cd4, 0x1ce5, 0x1cf7, 0x1d08, 0x1d18,
	0x1d29, 0x1d39, 0x1d4a, 0x1d5a, 0x1d6a, 0x1d7b, 0x1d8b, 0x1d9c,
	0x1dac, 0x1dbc, 0x1dcc, 0x1ddd, 0x1ded, 0x1dfe, 0x1e10, 0x1e20,
	0x1e31, 0x1e42, 0x1e52, 0x1e62, 0x1e73, 0x1e87, 0x1e9b, 0x1eae,
	0x1ec2, 0x1ed5, 0x1ee9, 0x1f04, 0x1f20, 0x1f33, 0x1f47, 0x1f5b,
	0x1f6e, 0x1f82, 0x1f96, 0x1fa8, 0x1fba, 0x1fcf, 0x1fe0, 0x1ff1,
	0x2003, 0x2017, 0x2032, 0x204a, 0x2062, 0x207d, 0x2099, 0x20aa,
	0x20ba, 0x20ca, 0x20dc, 0x20ed, 0x20fe, 0x210e, 0x2120, 0x2132,
	// Entry B00 - B3F
	0x2143, 0x2156, 0x2187, 0x21b7, 0x21e7, 0x2219, 0x224a, 0x227b,
	0x22ae, 0x22bf, 0x22df, 0x22f7, 0x230c, 0x2320, 0x2334, 0x2344,
	0x2355, 0x2365, 0x2376, 0x2386, 0x2397, 0x23af, 0x23c7, 0x23d7,
	0x23e8, 0x23f9, 0x2409, 0x241a, 0x242b, 0x243c, 0x244e, 0x245f,
	0x2471, 0x2483, 0x2494, 0x24a6, 0x24b7, 0x24c9, 0x24db, 0x24ed,
	0x2500, 0x2512, 0x2525, 0x2537, 0x2548, 0x255a, 0x256b, 0x257d,
	0x258e, 0x259f, 0x25b1, 0x25c2, 0x25d4, 0x25e5, 0x25f6, 0x2607,
	0x2619, 0x262a, 0x263c, 0x264d, 0x265f, 0x2671, 0x2682, 0x2693,
	// Entry B40 - B7F
	0x26a5, 0x26ba, 0x26cf, 0x26e3, 0x26f8, 0x270c, 0x2721, 0x273d,
	0x275a, 0x276e, 0x2783, 0x2798, 0x27ac, 0x27c1, 0x27d6, 0x27e9,
	0x27fc, 0x2812, 0x2827, 0x2843, 0x2854, 0x286d, 0x2886, 0x28a2,
	0x28bf, 0x28d1, 0x28e2, 0x28f3, 0x2906, 0x2918, 0x292a, 0x293b,
	0x294e, 0x2961, 0x2973, 0x298b, 0x29a3, 0x29ce, 0x29f5, 0x2a0f,
	0x2a26, 0x2a3c, 0x2a5b, 0x2a6d, 0x2a80, 0x2a92, 0x2aa5, 0x2ab7,
	0x2aca, 0x2ae4, 0x2afe, 0x2b10, 0x2b23, 0x2b36, 0x2b48, 0x2b5b,
	0x2b6e, 0x2b81, 0x2b95, 0x2ba8, 0x2bbc, 0x2bd0, 0x2be3, 0x2bf7,
	// Entry B80 - BBF
	0x2c0a, 0x2c1e, 0x2c32, 0x2c46, 0x2c5b, 0x2c6f, 0x2c84, 0x2c98,
	0x2cab, 0x2cbf, 0x2cd2, 0x2ce6, 0x2cf9, 0x2d0e, 0x2d21, 0x2d35,
	0x2d48, 0x2d5c, 0x2d6f, 0x2d82, 0x2d95, 0x2da9, 0x2dbc, 0x2dd0,
	0x2de5, 0x2df8, 0x2e0c, 0x2e20, 0x2e33, 0x2e46, 0x2e5b, 0x2e7d,
	0x2e9b, 0x2eb2, 0x2ec9, 0x2edf, 0x2ef6, 0x2f0c, 0x2f23, 0x2f41,
	0x2f60, 0x2f76, 0x2f8d, 0x2fa4, 0x2fba, 0x2fd1, 0x2fe8, 0x2ffd,
	0x3016, 0x3029, 0x3042, 0x305b, 0x3076, 0x308e, 0x30bd, 0x30dc,
	0x30ff, 0x311f, 0x313b, 0x315e, 0x317a, 0x3195, 0x31b0, 0x31cb,
	// Entry BC0 - BFF
	0x31e9, 0x3208, 0x321c, 0x322f, 0x3242, 0x3257, 0x326b, 0x327f,
	0x3292, 0x32a7, 0x32bc, 0x32d0, 0x32e4, 0x3300, 0x331d, 0x333b,
	0x3356, 0x3377, 0x3397, 0x33b4, 0x33d7, 0x33ea, 0x3404, 0x341d,
	0x3437, 0x3450, 0x346a, 0x3483, 0x349b, 0x34b2, 0x34c8, 0x34dd,
	0x34f3, 0x3509, 0x3520, 0x3535, 0x354b, 0x3560, 0x3576, 0x358d,
	0x35a5, 0x35bc, 0x35d4, 0x35e9, 0x35ff, 0x3615, 0x362a, 0x3640,
	0x3656, 0x3677, 0x3699, 0x36ba, 0x36dc, 0x36fd, 0x371b, 0x373c,
	0x375e, 0x377f, 0x37a1, 0x37c2, 0x37ed, 0x380b, 0x382d, 0x3850,
	// Entry C00 - C3F
	0x3872, 0x3895, 0x38b5, 0x38d4, 0x38f5, 0x3917, 0x3938, 0x395a,
	0x3978, 0x3996, 0x39b7, 0x39d9, 0x39fa, 0x3a1c, 0x3a32, 0x3a4d,
	0x3a63, 0x3a79, 0x3a97, 0x3aad, 0x3acb, 0x3aeb, 0x3b09, 0x3b1f,
	0x3b3f, 0x3b55, 0x3b6b, 0x3b88, 0x3bab, 0x3bcd, 0x3bee, 0x3c0e,
	0x3c30, 0x3c51, 0x3c70, 0x3c8a, 0x3ca9, 0x3cc6, 0x3cef, 0x3d1d,
	0x3d47, 0x3d65, 0x3d7c, 0x3d92, 0x3da8, 0x3dc0, 0x3dd7, 0x3dee,
	0x3e04, 0x3e1c, 0x3e34, 0x3e4b, 0x3e6f, 0x3e92, 0x3eb0, 0x3ec5,
	0x3edc, 0x3ef4, 0x3f0c, 0x3f23, 0x3f3d, 0x3f53, 0x3f6a, 0x3f82,
	// Entry C40 - C7F
	0x3f9a, 0x3fae, 0x3fc5, 0x3fdb, 0x3ff2, 0x4009, 0x4020, 0x403d,
	0x4057, 0x406c, 0x4081, 0x4096, 0x40ae, 0x40c7, 0x40df, 0x40f3,
	0x410b, 0x4120, 0x4138, 0x414c, 0x4163, 0x4178, 0x4192, 0x41a6,
	0x41bb, 0x41d0, 0x41e1, 0x41f7, 0x4208, 0x421e, 0x4234, 0x424a,
	0x425f, 0x4274, 0x428b, 0x429f, 0x42b7, 0x42cf, 0x42e4, 0x42ff,
	0x4315, 0x432b, 0x4340, 0x4356, 0x436c, 0x4383, 0x4398, 0x43ae,
	0x43c4, 0x43dd, 0x43f2, 0x4408, 0x441d, 0x443b, 0x445a, 0x4474,
	0x448b, 0x44a3, 0x44b8, 0x44ce, 0x44e4, 0x44ff, 0x4519, 0x4530,
	// Entry C80 - CBF
	0x4547, 0x455d, 0x456c, 0x457a, 0x4588, 0x4598, 0x45a7, 0x45b6,
	0x45c4, 0x45d4, 0x45e4, 0x45f3, 0x460c, 0x4621, 0x462e, 0x4641,
	0x4653, 0x4666, 0x4674, 0x4681, 0x4694, 0x46a5, 0x46b8, 0x46c6,
	0x46d9, 0x46ec, 0x4700, 0x4713, 0x4727, 0x473a, 0x4747, 0x4754,
	0x4767, 0x4779, 0x478c, 0x4799, 0x47a6, 0x47b3, 0x47c6, 0x47d7,
	0x47e9, 0x47fb, 0x480e, 0x481b, 0x4828, 0x483a, 0x484c, 0x4859,
	0x4870, 0x4887, 0x4899, 0x48ab, 0x48be, 0x48ca, 0x48db, 0x48e7,
	0x48f7, 0x490d, 0x491e, 0x492f, 0x493f, 0x4950, 0x4960, 0x4971,
	// Entry CC0 - CFF
	0x4981, 0x4992, 0x49a6, 0x49bc, 0x49d1, 0x49e7, 0x49f7, 0x4a08,
	0x4a18, 0x4a29, 0x4a3a, 0x4a43, 0x4a52, 0x4a62, 0x4a71, 0x4a84,
	0x4a99, 0x4aa6, 0x4ab2, 0x4ac0, 0x4acd, 0x4ada, 0x4ae9, 0x4af7,
	0x4b05, 0x4b12, 0x4b21, 0x4b30, 0x4b3e, 0x4b47, 0x4b50, 0x4b62,
	0x4b75, 0x4b88, 0x4bad, 0x4bd7, 0x4c02, 0x4c26, 0x4c4a, 0x4c71,
	0x4c93, 0x4caa, 0x4cc4, 0x4ce2, 0x4d02, 0x4d24, 0x4d35, 0x4d4b,
	0x4d62, 0x4d7e, 0x4d9f, 0x4dba, 0x4de4, 0x4dfb, 0x4e1b, 0x4e3b,
	0x4e6a, 0x4e8d, 0x4eb3, 0x4ece, 0x4eea, 0x4f05, 0x4f1f, 0x4f3a,
	// Entry D00 - D3F
	0x4f59, 0x4f6b, 0x4f7c, 0x4f8d, 0x4fa0, 0x4fb2, 0x4fc4, 0x4fd5,
	0x4fe8, 0x4ffb, 0x500d, 0x5023, 0x5039, 0x5051, 0x5068, 0x507f,
	0x5095, 0x50ad, 0x50c5, 0x50dc, 0x50f3, 0x510b, 0x512a, 0x5155,
	0x5177, 0x518b, 0x51a1, 0x51bc, 0x51d7, 0x51f2, 0x520d, 0x5223,
	0x5239, 0x524a, 0x525c, 0x526d, 0x527f, 0x5291, 0x52a2, 0x52b4,
	0x52c5, 0x52d7, 0x52e9, 0x52fc, 0x530e, 0x5321, 0x5333, 0x5344,
	0x5356, 0x5367, 0x5379, 0x538a, 0x539b, 0x53ad, 0x53be, 0x53d0,
	0x53e1, 0x53f3, 0x5406, 0x5418, 0x542b, 0x543c, 0x544e, 0x545f,
	// Entry D40 - D7F
	0x5470, 0x5481, 0x5492, 0x54a3, 0x54b5, 0x54c7, 0x54d8, 0x54e9,
	0x54f9, 0x550c, 0x5528, 0x553a, 0x554c, 0x5561, 0x5575, 0x558a,
	0x559e, 0x55b3, 0x55cf, 0x55ec, 0x5608, 0x5625, 0x5639, 0x564e,
	0x5662, 0x5677, 0x5692, 0x56a8, 0x56c5, 0x56e3, 0x56fe, 0x5713,
	0x5727, 0x573a, 0x5750, 0x5767, 0x577f, 0x5794, 0x57b0, 0x57cc,
	0x57ea, 0x580c, 0x582b, 0x5853, 0x586e, 0x588a, 0x58a5, 0x58c1,
	0x58dd, 0x58f8, 0x5914, 0x592f, 0x594b, 0x5967, 0x5984, 0x59a0,
	0x59bd, 0x59d9, 0x59f4, 0x5a10, 0x5a2b, 0x5a47, 0x5a62, 0x5a7d,
	// Entry D80 - DBF
	0x5a99, 0x5ab4, 0x5ad0, 0x5aeb, 0x5b07, 0x5b24, 0x5b40, 0x5b5d,
	0x5b78, 0x5b94, 0x5baf, 0x5bca, 0x5be5, 0x5c00, 0x5c1b, 0x5c37,
	0x5c53, 0x5c6e, 0x5c89, 0x5ca3, 0x5cc0, 0x5ce6, 0x5d0c, 0x5d32,
	0x5d43, 0x5d61, 0x5d85, 0x5da9, 0x5dcc, 0x5df0, 0x5e06, 0x5e1c,
	0x5e35, 0x5e55, 0x5e6b, 0x5e80, 0x5ea1, 0x5ec2, 0x5ee3, 0x5f02,
	0x5f1c, 0x5f40, 0x5f63, 0x5f7a, 0x5faa, 0x5fda, 0x5ff2, 0x6009,
	0x602b, 0x604c, 0x606c, 0x608d, 0x609e, 0x60b0, 0x60c1, 0x60d3,
	0x60e5, 0x60f6, 0x6108, 0x6119, 0x612b, 0x613d, 0x6150, 0x6162,
	// Entry DC0 - DFF
	0x6175, 0x6187, 0x619a, 0x61ac, 0x61bd, 0x61cf, 0x61e0, 0x61f2,
	0x6203, 0x6214, 0x6226, 0x6237, 0x6249, 0x625a, 0x626b, 0x627c,
	0x628d, 0x629e, 0x62af, 0x62c0, 0x62d2, 0x62e2, 0x62f7, 0x6307,
	0x6318, 0x6328, 0x6339, 0x6349, 0x635d, 0x636d, 0x637e, 0x6398,
	0x63ad, 0x63c1, 0x63d6, 0x63ea, 0x63ff, 0x6413, 0x6428, 0x6441,
	0x6459, 0x6473, 0x6488, 0x649e, 0x64b2, 0x64c5, 0x64d6, 0x64f6,
	0x6516, 0x6536, 0x6556, 0x656d, 0x657f, 0x6590, 0x65a1, 0x65b4,
	0x65c6, 0x65d8, 0x65e9, 0x65fc, 0x660f, 0x6621, 0x663c, 0x6650,
	// Entry E00 - E3F
	0x6667, 0x667f, 0x669c, 0x66b3, 0x66c5, 0x66d7, 0x66ef, 0x6708,
	0x6720, 0x6739, 0x6755, 0x6772, 0x678e, 0x67ab, 0x67c1, 0x67d7,
	0x67ed, 0x6803, 0x6827, 0x684b, 0x686f, 0x688c, 0x68ac, 0x68ce,
	0x68f1, 0x6915, 0x6939, 0x6960, 0x6987, 0x69ac, 0x69d1, 0x69f6,
	0x6a1b, 0x6a40, 0x6a64, 0x6a88, 0x6aad, 0x6acc, 0x6ae7, 0x6b01,
	0x6b1c, 0x6b32, 0x6b49, 0x6b5f, 0x6b75, 0x6b8b, 0x6ba2, 0x6bb8,
	0x6bce, 0x6be5, 0x6bfb, 0x6c11, 0x6c28, 0x6c3e, 0x6c63, 0x6c7d,
	0x6c96, 0x6cb5, 0x6cd4, 0x6cec, 0x6d04, 0x6d1c, 0x6d34, 0x6d54,
	// Entry E40 - E7F
	0x6d74, 0x6d9b, 0x6dba, 0x6ddb, 0x6df2, 0x6e08, 0x6e1e, 0x6e36,
	0x6e4d, 0x6e64, 0x6e7a, 0x6e92, 0x6eaa, 0x6ec1, 0x6edb, 0x6ef5,
	0x6f0f, 0x6f2a, 0x6f41, 0x6f60, 0x6f7a, 0x6f95, 0x6fb0, 0x6fcb,
	0x6fe5, 0x7000, 0x701b, 0x7036, 0x7050, 0x706b, 0x7086, 0x70a1,
	0x70bc, 0x70d6, 0x70f1, 0x710d, 0x7128, 0x7143, 0x715e, 0x7178,
	0x7194, 0x71b0, 0x71cc, 0x71e7, 0x7203, 0x721f, 0x723a, 0x7255,
	0x7270, 0x728c, 0x72a7, 0x72c3, 0x72de, 0x72f8, 0x7313, 0x732d,
	0x7348, 0x7363, 0x737d, 0x7398, 0x73aa, 0x73bd, 0x73d0, 0x73e3,
	// Entry E80 - EBF
	0x73f5, 0x7408, 0x741b, 0x742e, 0x7440, 0x7453, 0x7466, 0x7479,
	0x748c, 0x749e, 0x74b1, 0x74c5, 0x74d8, 0x74eb, 0x74fe, 0x7510,
	0x7524, 0x7538, 0x754c, 0x755f, 0x7573, 0x7587, 0x759a, 0x75ad,
	0x75c0, 0x75d4, 0x75e7, 0x75fb, 0x760e, 0x7620, 0x7633, 0x7645,
	0x7658, 0x766b, 0x767d, 0x768f, 0x76a4, 0x76be, 0x76d1, 0x76ed,
	0x7709, 0x771c, 0x7735, 0x7750, 0x7766, 0x7781, 0x7796, 0x77ac,
	0x77c7, 0x77dc, 0x77f1, 0x7806, 0x7820, 0x7834, 0x784d, 0x7862,
	0x7877, 0x7891, 0x78a8, 0x78bf, 0x78d6, 0x78ed, 0x7902, 0x791e,
	// Entry EC0 - EFF
	0x7938, 0x7954, 0x796f, 0x798c, 0x79a7, 0x79c1, 0x79dc, 0x79f9,
	0x7a14, 0x7a31, 0x7a4d, 0x7a68, 0x7a84, 0x7a9e, 0x7abf, 0x7ae0,
	0x7b00, 0x7b1f, 0x7b3f, 0x7b5a, 0x7b77, 0x7b94, 0x7bb1, 0x7bce,
	0x7bf0, 0x7c0b, 0x7c25, 0x7c40, 0x7c5a, 0x7c74, 0x7c8e, 0x7caf,
	0x7ccd, 0x7ce7, 0x7d01, 0x7d1d, 0x7d39, 0x7d55, 0x7d71, 0x7d8b,
	0x7da7, 0x7dc8, 0x7de7, 0x7e0b, 0x7e22, 0x7e3e, 0x7e5a, 0x7e75,
	0x7e90, 0x7eaa, 0x7ec7, 0x7ee1, 0x7efc, 0x7f19, 0x7f36, 0x7f53,
	0x7f6b, 0x7f86, 0x7fa3, 0x7fc5, 0x7fe5, 0x800a, 0x8029, 0x8046,
	// Entry F00 - F3F
	0x8065, 0x8087, 0x80a4, 0x80c3, 0x80dd, 0x80f8, 0x8115, 0x812f,
	0x814a, 0x8165, 0x8181, 0x8197, 0x81ae, 0x81c0, 0x81d3, 0x81e6,
	0x81fa, 0x820d, 0x821f, 0x8233, 0x8246, 0x8258, 0x826b, 0x827f,
	0x8292, 0x82a5, 0x82b7, 0x82cb, 0x82de, 0x82f1, 0x8304, 0x8317,
	0x832a, 0x833c, 0x8350, 0x8364, 0x8379, 0x838f, 0x83a4, 0x83b9,
	0x83cf, 0x83e5, 0x83fb, 0x8410, 0x8424, 0x8439, 0x844d, 0x8461,
	0x8477, 0x848e, 0x84a5, 0x84ba, 0x84cf, 0x84e3, 0x84f8, 0x8510,
	0x8525, 0x8539, 0x854e, 0x8564, 0x8579, 0x8590, 0x85a6, 0x85bb,
	// Entry F40 - F7F
	0x85d0, 0x85e5, 0x85fb, 0x8610, 0x8624, 0x8639, 0x864d, 0x8661,
	0x8676, 0x868e, 0x86a4, 0x86bd, 0x86d5, 0x86ed, 0x8708, 0x871d,
	0x8732, 0x8749, 0x875e, 0x8774, 0x878b, 0x87a7, 0x87c3, 0x87d9,
	0x87f5, 0x8811, 0x8828, 0x883e, 0x885b, 0x8877, 0x8893, 0x88ae,
	0x88cc, 0x88ea, 0x8906, 0x891c, 0x8932, 0x894d, 0x8962, 0x897c,
	0x8992, 0x89a8, 0x89c0, 0x89d8, 0x89f0, 0x8a08, 0x8a1e, 0x8a3b,
	0x8a5e, 0x8a7b, 0x8a98, 0x8ab3, 0x8ad1, 0x8aef, 0x8b0d, 0x8b2a,
	0x8b4c, 0x8b68, 0x8b85, 0x8ba8, 0x8bc3, 0x8be6, 0x8c07, 0x8c28,
	// Entry F80 - FBF
	0x8c4a, 0x8c6e, 0x8c8e, 0x8cac, 0x8cca, 0x8cec, 0x8d09, 0x8d25,
	0x8d41, 0x8d5c, 0x8d7c, 0x8d9a, 0x8db8, 0x8dd4, 0x8df2, 0x8e0e,
	0x8e2c, 0x8e48, 0x8e66, 0x8e82, 0x8e9e, 0x8eb9, 0x8ed4, 0x8eec,
	0x8f09, 0x8f2b, 0x8f46, 0x8f64, 0x8f7d, 0x8f9b, 0x8fbc, 0x8fda,
	0x8ffa, 0x9016, 0x9032, 0x904e, 0x906a, 0x9086, 0x90a3, 0x90c0,
	0x90df, 0x90fe, 0x911b, 0x9136, 0x914a, 0x915e, 0x9172, 0x9187,
	0x919c, 0x91b0, 0x91c4, 0x91d9, 0x91ed, 0x9201, 0x9215, 0x922a,
	0x923f, 0x9253, 0x9267, 0x927c, 0x9291, 0x92a6, 0x92bb, 0x92d1,
	// Entry FC0 - FFF
	0x92e7, 0x92fc, 0x9311, 0x9327, 0x933b, 0x934f, 0x9363, 0x9378,
	0x938d, 0x93a1, 0x93b5, 0x93ca, 0x93df, 0x93f4, 0x9409, 0x941f,
	0x9435, 0x944a, 0x945f, 0x9475, 0x9489, 0x949d, 0x94b1, 0x94c6,
	0x94db, 0x94ef, 0x9503, 0x9518, 0x952c, 0x9540, 0x9554, 0x9569,
	0x957e, 0x9592, 0x95a6, 0x95bb, 0x95d0, 0x95e5, 0x95fa, 0x9610,
	0x9626, 0x963b, 0x9650, 0x9666, 0x967a, 0x968e, 0x96a2, 0x96b7,
	0x96cc, 0x96e0, 0x96f4, 0x9709, 0x971e, 0x9733, 0x9749, 0x975f,
	0x9774, 0x9789, 0x979e, 0x97b3, 0x97c9, 0x97df, 0x97f4, 0x9809,
	// Entry 1000 - 103F
	0x981f, 0x9835, 0x984c, 0x9863, 0x9879, 0x988d, 0x98a1, 0x98b5,
	0x98ca, 0x98df, 0x98f3, 0x9907, 0x991c, 0x9930, 0x9944, 0x9958,
	0x996d, 0x9982, 0x9996, 0x99aa, 0x99bf, 0x99d3, 0x99e7, 0x99fb,
	0x9a10, 0x9a25, 0x9a39, 0x9a4d, 0x9a62, 0x9a76, 0x9a8a, 0x9a9e,
	0x9ab3, 0x9ac8, 0x9adc, 0x9af0, 0x9b05, 0x9b19, 0x9b2d, 0x9b41,
	0x9b56, 0x9b6b, 0x9b7f, 0x9b93, 0x9ba8, 0x9bbd, 0x9bd2, 0x9be8,
	0x9bfe, 0x9c13, 0x9c27, 0x9c3b, 0x9c4f, 0x9c64, 0x9c79, 0x9c8d,
	0x9ca1, 0x9cb6, 0x9ccb, 0x9ce0, 0x9cf5, 0x9d0b, 0x9d21, 0x9d36,
	// Entry 1040 - 107F
	0x9d4b, 0x9d61, 0x9d7c, 0x9d97, 0x9db2, 0x9dce, 0x9dea, 0x9e05,
	0x9e20, 0x9e3c, 0x9e50, 0x9e64, 0x9e78, 0x9e8d, 0x9ea2, 0x9eb6,
	0x9eca, 0x9edf, 0x9ef4, 0x9f09, 0x9f1f, 0x9f35, 0x9f4a, 0x9f5f,
	0x9f74, 0x9f89, 0x9f9f, 0x9fb5, 0x9fca, 0x9fdf, 0x9ff5, 0xa00b,
	0xa022, 0xa039, 0xa04f, 0xa063, 0xa077, 0xa08b, 0xa0a0, 0xa0b5,
	0xa0c9, 0xa0dd, 0xa0f2, 0xa110, 0xa12e, 0xa14c, 0xa16b, 0xa18a,
	0xa1a8, 0xa1c6, 0xa1da, 0xa1ee, 0xa202, 0xa217, 0xa22c, 0xa240,
	0xa254, 0xa269, 0xa27e, 0xa293, 0xa2a8, 0xa2be, 0xa2d4, 0xa2e9,
	// Entry 1080 - 10BF
	0xa2fe, 0xa314, 0xa328, 0xa33c, 0xa350, 0xa365, 0xa37a, 0xa38e,
	0xa3a2, 0xa3b7, 0xa3cb, 0xa3df, 0xa3f3, 0xa408, 0xa41d, 0xa431,
	0xa445, 0xa45a, 0xa46f, 0xa484, 0xa499, 0xa4af, 0xa4c5, 0xa4da,
	0xa4ef, 0xa505, 0xa519, 0xa52d, 0xa541, 0xa556, 0xa56b, 0xa57f,
	0xa593, 0xa5a8, 0xa5bc, 0xa5d0, 0xa5e4, 0xa5f9, 0xa60e, 0xa622,
	0xa636, 0xa64b, 0xa660, 0xa675, 0xa68b, 0xa6a1, 0xa6b6, 0xa6cb,
	0xa6e0, 0xa6f5, 0xa70b, 0xa721, 0xa736, 0xa74b, 0xa762, 0xa777,
	0xa78c, 0xa7a1, 0xa7b7, 0xa7cd, 0xa7e2, 0xa7f7, 0xa80d, 0xa822,
	// Entry 10C0 - 10FF
	0xa837, 0xa84c, 0xa862, 0xa878, 0xa88d, 0xa8a2, 0xa8b8, 0xa8cd,
	0xa8e2, 0xa8f7, 0xa90d, 0xa923, 0xa938, 0xa94d, 0xa963, 0xa978,
	0xa98d, 0xa9a2, 0xa9b8, 0xa9ce, 0xa9e3, 0xa9f8, 0xaa0e, 0xaa23,
	0xaa38, 0xaa4d, 0xaa63, 0xaa79, 0xaa8e, 0xaaa3, 0xaab9, 0xaacd,
	0xaae1, 0xaaf5, 0xab0a, 0xab1f, 0xab33, 0xab47, 0xab5c, 0xab70,
	0xab84, 0xab98, 0xabad, 0xabc2, 0xabd6, 0xabea, 0xabff, 0xac14,
	0xac29, 0xac3e, 0xac71, 0xac95, 0xacb7, 0xaccc, 0xacde, 0xacf0,
	0xacfe, 0xad10, 0xad1e, 0xad34, 0xad4a, 0xad66, 0xad78, 0xad8a,
	// Entry 1100 - 113F
	0xad9e, 0xadb1, 0xadc4, 0xadd6, 0xadea, 0xadfe, 0xae11, 0xae24,
	0xae3a, 0xae50, 0xae65, 0xae7a, 0xae8f, 0xaea6, 0xaebc, 0xaed2,
	0xaee9, 0xaf05, 0xaf24, 0xaf39, 0xaf4f, 0xaf64, 0xaf83, 0xaf98,
	0xafae, 0xafc3, 0xafe2, 0xaff7, 0xb00d, 0xb022, 0xb041, 0xb056,
	0xb06c, 0xb081, 0xb09a, 0xb0b3, 0xb0cd, 0xb0ed, 0xb106, 0xb11f,
	0xb139, 0xb152, 0xb171, 0xb189, 0xb19a, 0xb1ab, 0xb1bc, 0xb1cd,
	0xb1de, 0xb1ef, 0xb201, 0xb213, 0xb225, 0xb237, 0xb249, 0xb25b,
	0xb26d, 0xb27f, 0xb291, 0xb2a3, 0xb2b5, 0xb2c7, 0xb2d9, 0xb2eb,
	// Entry 1140 - 117F
	0xb2fd, 0xb30f, 0xb321, 0xb333, 0xb345, 0xb357, 0xb369, 0xb37b,
	0xb38d, 0xb39f, 0xb3b1, 0xb3c4, 0xb3d7, 0xb3e9, 0xb3fb, 0xb40d,
	0xb41f, 0xb431, 0xb444, 0xb457, 0xb46a, 0xb47d, 0xb490, 0xb4a3,
	0xb4b5, 0xb4c6, 0xb4d8, 0xb4ea, 0xb4fc, 0xb50e, 0xb520, 0xb532,
	0xb544, 0xb556, 0xb568, 0xb57a, 0xb58c, 0xb59e, 0xb5b0, 0xb5c2,
	0xb5d5, 0xb5e8, 0xb5fb, 0xb60e, 0xb621, 0xb634, 0xb647, 0xb65a,
	0xb66d, 0xb680, 0xb693, 0xb6a6, 0xb6b9, 0xb6cb, 0xb6dd, 0xb6ef,
	0xb701, 0xb713, 0xb725, 0xb737, 0xb749, 0xb75b, 0xb76d, 0xb77f,
	// Entry 1180 - 11BF
	0xb791, 0xb7a3, 0xb7bb, 0xb7d3, 0xb7eb, 0xb803, 0xb81b, 0xb833,
	0xb84c, 0xb860, 0xb876, 0xb88a, 0xb89f, 0xb8b3, 0xb8c8, 0xb8e4,
	0xb901, 0xb91d, 0xb931, 0xb946, 0xb95b, 0xb97a, 0xb98f, 0xb9ae,
	0xb9c4, 0xb9e4, 0xb9f9, 0xba18, 0xba2e, 0xba4e, 0xba6c, 0xba81,
	0xbaa0, 0xbab6, 0xbad6, 0xbaf4, 0xbb09, 0xbb24, 0xbb43, 0xbb61,
	0xbb7f, 0xbba8, 0xbbce, 0xbbf6, 0xbc13, 0xbc38, 0xbc6e, 0xbc91,
	0xbcc1, 0xbcde, 0xbd00, 0xbd15, 0xbd2a, 0xbd3f, 0xbd54, 0xbd69,
	0xbd80, 0xbd95, 0xbdab, 0xbdc0, 0xbdd6, 0xbdf3, 0xbe11, 0xbe2e,
	// Entry 11C0 - 11FF
	0xbe43, 0xbe59, 0xbe6f, 0xbe8f, 0xbea5, 0xbec5, 0xbedc, 0xbefd,
	0xbf13, 0xbf33, 0xbf4a, 0xbf6b, 0xbf81, 0xbfa1, 0xbfb8, 0xbfd9,
	0xbff7, 0xc00b, 0xc029, 0xc045, 0xc05a, 0xc071, 0xc086, 0xc09c,
	0xc0b1, 0xc0c7, 0xc0e4, 0xc102, 0xc11f, 0xc134, 0xc14a, 0xc160,
	0xc180, 0xc196, 0xc1b6, 0xc1cd, 0xc1ee, 0xc204, 0xc224, 0xc23b,
	0xc25c, 0xc272, 0xc292, 0xc2a9, 0xc2ca, 0xc2e9, 0xc2fd, 0xc313,
	0xc329, 0xc33f, 0xc355, 0xc36a, 0xc381, 0xc396, 0xc3ac, 0xc3c1,
	0xc3d7, 0xc3f4, 0xc409, 0xc41f, 0xc435, 0xc455, 0xc46b, 0xc48b,
	// Entry 1200 - 123F
	0xc4a2, 0xc4c3, 0xc4d9, 0xc4f9, 0xc510, 0xc531, 0xc547, 0xc567,
	0xc57e, 0xc59f, 0xc5be, 0xc5d2, 0xc5e7, 0xc60a, 0xc62d, 0xc650,
	0xc673, 0xc688, 0xc69f, 0xc6b4, 0xc6ca, 0xc6df, 0xc6f5, 0xc712,
	0xc727, 0xc73d, 0xc753, 0xc773, 0xc789, 0xc7a9, 0xc7c0, 0xc7e1,
	0xc7f7, 0xc817, 0xc82e, 0xc84f, 0xc865, 0xc885, 0xc89c, 0xc8bd,
	0xc8dc, 0xc8f0, 0xc90c, 0xc921, 0xc938, 0xc94d, 0xc963, 0xc978,
	0xc98e, 0xc9ab, 0xc9c0, 0xc9d6, 0xc9ec, 0xca0c, 0xca22, 0xca42,
	0xca59, 0xca7a, 0xca90, 0xcab0, 0xcac7, 0xcae8, 0xcafe, 0xcb1e,
	// Entry 1240 - 127F
	0xcb35, 0xcb56, 0xcb75, 0xcb89, 0xcba7, 0xcbbc, 0xcbdb, 0xcbf6,
	0xcc0b, 0xcc22, 0xcc37, 0xcc4d, 0xcc62, 0xcc78, 0xcc95, 0xccaa,
	0xccc0, 0xccd6, 0xccf6, 0xcd0c, 0xcd2c, 0xcd43, 0xcd64, 0xcd83,
	0xcd97, 0xcdb4, 0xcdc9, 0xcdde, 0xcdf5, 0xce0a, 0xce20, 0xce35,
	0xce4b, 0xce68, 0xce7d, 0xce93, 0xcea9, 0xcec9, 0xcedf, 0xceff,
	0xcf16, 0xcf37, 0xcf4d, 0xcf6d, 0xcf84, 0xcfa5, 0xcfbb, 0xcfdb,
	0xcff2, 0xd013, 0xd027, 0xd045, 0xd060, 0xd075, 0xd08c, 0xd0a1,
	0xd0b7, 0xd0cc, 0xd0e2, 0xd0ff, 0xd114, 0xd12a, 0xd140, 0xd160,
	// Entry 1280 - 12BF
	0xd176, 0xd196, 0xd1ad, 0xd1ce, 0xd1e4, 0xd204, 0xd21b, 0xd23c,
	0xd252, 0xd272, 0xd289, 0xd2aa, 0xd2c9, 0xd2dd, 0xd2fc, 0xd311,
	0xd32f, 0xd34f, 0xd36d, 0xd38b, 0xd3aa, 0xd3c9, 0xd3e8, 0xd407,
	0xd41d, 0xd433, 0xd44a, 0xd460, 0xd477, 0xd48d, 0xd4a4, 0xd4bb,
	0xd4dc, 0xd4f3, 0xd514, 0xd52c, 0xd54e, 0xd565, 0xd586, 0xd59e,
	0xd5c0, 0xd5d7, 0xd5f8, 0xd610, 0xd632, 0xd647, 0xd65c, 0xd673,
	0xd688, 0xd69e, 0xd6b3, 0xd6c9, 0xd6e6, 0xd6fb, 0xd711, 0xd727,
	0xd747, 0xd75d, 0xd77d, 0xd794, 0xd7b5, 0xd7cb, 0xd7eb, 0xd802,
	// Entry 12C0 - 12FF
	0xd823, 0xd839, 0xd859, 0xd870, 0xd891, 0xd8b0, 0xd8c4, 0xd8e3,
	0xd901, 0xd91d, 0xd932, 0xd94e, 0xd96d, 0xd984, 0xd999, 0xd9af,
	0xd9c4, 0xd9da, 0xd9f9, 0xda0e, 0xda24, 0xda43, 0xda5a, 0xda7b,
	0xda8f, 0xdaad, 0xdac8, 0xdadd, 0xdaf4, 0xdb09, 0xdb1f, 0xdb34,
	0xdb4a, 0xdb5f, 0xdb75, 0xdb8c, 0xdbad, 0xdbc1, 0xdbd7, 0xdbf4,
	0xdc0a, 0xdc27, 0xdc3e, 0xdc5c, 0xdc72, 0xdc89, 0xdc9f, 0xdcb6,
	0xdcce, 0xdcf0, 0xdd05, 0xdd1c, 0xdd33, 0xdd4a, 0xdd61, 0xdd77,
	0xdd8d, 0xdda3, 0xddb9, 0xddcf, 0xddec, 0xde09, 0xde27, 0xde44,
	// Entry 1300 - 133F
	0xde62, 0xde7f, 0xde9d, 0xdeb9, 0xded5, 0xdeea, 0xdf01, 0xdf16,
	0xdf2c, 0xdf41, 0xdf57, 0xdf6c, 0xdf82, 0xdf96, 0xdfad, 0xdfc4,
	0xdfdb, 0xdff2, 0xe011, 0xe030, 0xe04f, 0xe06e, 0xe086, 0xe09c,
	0xe0b3, 0xe0c9, 0xe0e0, 0xe0f6, 0xe10d, 0xe122, 0xe138, 0xe155,
	0xe172, 0xe18f, 0xe1ac, 0xe1cd, 0xe1ee, 0xe20f, 0xe230, 0xe250,
	0xe266, 0xe27d, 0xe293, 0xe2aa, 0xe2c0, 0xe2d7, 0xe2ec, 0xe30a,
	0xe328, 0xe347, 0xe365, 0xe384, 0xe3a2, 0xe3c1, 0xe3de, 0xe3fa,
	0xe418, 0xe436, 0xe454, 0xe472, 0xe491, 0xe4b0, 0xe4cf, 0xe4ee,
	// Entry 1340 - 137F
	0xe50d, 0xe52c, 0xe54b, 0xe56a, 0xe589, 0xe5a8, 0xe5c7, 0xe5e6,
	0xe602, 0xe61e, 0xe63a, 0xe656, 0xe674, 0xe692, 0xe6b0, 0xe6cf,
	0xe6ed, 0xe70b, 0xe728, 0xe745, 0xe762, 0xe780, 0xe79d, 0xe7ba,
	0xe7d7, 0xe7f4, 0xe811, 0xe82f, 0xe84c, 0xe869, 0xe887, 0xe8a5,
	0xe8c3, 0xe8e2, 0xe900, 0xe91e, 0xe93c, 0xe95a, 0xe978, 0xe997,
	0xe9b5, 0xe9d3, 0xe9f1, 0xea0f, 0xea2d, 0xea4c, 0xea6a, 0xea88,
	0xeaa5, 0xeac2, 0xeadf, 0xeafd, 0xeb1a, 0xeb37, 0xeb53, 0xeb70,
	0xeb8d, 0xebaa, 0xebc8, 0xebe5, 0xec02, 0xec20, 0xec3e, 0xec5c,
	// Entry 1380 - 13BF
	0xec7b, 0xec99, 0xecb7, 0xecd5, 0xecf3, 0xed11, 0xed30, 0xed4e,
	0xed6c, 0xed89, 0xeda6, 0xedc3, 0xede0, 0xedfe, 0xee1b, 0xee38,
	0xee55, 0xee72, 0xee8f, 0xeead, 0xeeca, 0xeee7, 0xef04, 0xef21,
	0xef3e, 0xef5c, 0xef79, 0xef96, 0xefb3, 0xefcf, 0xefec, 0xf009,
	0xf027, 0xf044, 0xf060, 0xf07d, 0xf09b, 0xf0b9, 0xf0d7, 0xf0f6,
	0xf114, 0xf132, 0xf14f, 0xf16c, 0xf189, 0xf1a7, 0xf1c4, 0xf1e1,
	0xf1ff, 0xf21d, 0xf23b, 0xf25a, 0xf278, 0xf296, 0xf2b4, 0xf2d2,
	0xf2f0, 0xf30f, 0xf32d, 0xf34b, 0xf36a, 0xf389, 0xf3a8, 0xf3c8,
	// Entry 13C0 - 13FF
	0xf3e7, 0xf406, 0xf424, 0xf442, 0xf460, 0xf47f, 0xf49d, 0xf4bb,
	0xf4d8, 0xf4f5, 0xf512, 0xf530, 0xf54d, 0xf56a, 0xf586, 0xf5aa,
	0xf5c8, 0xf5e6, 0xf604, 0xf623, 0xf641, 0xf65f, 0xf67c, 0xf699,
	0xf6b6, 0xf6d4, 0xf6f1, 0xf70e, 0xf72c, 0xf74a, 0xf768, 0xf787,
	0xf7a5, 0xf7c3, 0xf7e0, 0xf7fe, 0xf81c, 0xf83a, 0xf859, 0xf877,
	0xf895, 0xf8b3, 0xf8d1, 0xf8ef, 0xf90e, 0xf92c, 0xf94a, 0xf969,
	0xf988, 0xf9a7, 0xf9c7, 0xf9e6, 0xfa05, 0xfa20, 0xfa3c, 0xfa52,
	0xfa69, 0xfa80, 0xfa98, 0xfaaf, 0xfac7, 0xfade, 0xfaf6, 0xfb19,
	// Entry 1400 - 143F
	0xfb3b, 0xfb5e, 0xfb80, 0xfba3, 0xfbc5, 0xfbe8, 0xfc0e, 0xfc2c,
	0xfc3c, 0xfc4e, 0xfc5f, 0xfc71, 0xfc82, 0xfc93, 0xfca4, 0xfcb5,
	0xfcc7, 0xfcd8, 0xfcea, 0xfcfb, 0xfd0c, 0xfd20, 0xfd33, 0xfd44,
	0xfd55, 0xfd65, 0xfd74, 0xfd88, 0xfd9c, 0xfdb0, 0xfdbf, 0xfdd4,
	0xfde5, 0xfdfd, 0xfe0f, 0xfe21, 0xfe3c, 0xfe57, 0xfe65, 0xfe7b,
	0xfe8a, 0xfe98, 0xfea6, 0xfec7, 0xfed7, 0xfeeb, 0xfefc, 0xff0d,
	0xff1e, 0xff3c, 0xff59, 0xff67, 0xff76, 0xff85, 0xffa2, 0xffb4,
	0xffc4, 0xffd7, 0xffe5, 0xfff5, 0x000d, 0x001d, 0x0036, 0x004b,
	// Entry 1440 - 147F
	0x005f, 0x0080, 0x00a0, 0x00be, 0x00dc, 0x00f1, 0x010b, 0x0119,
	0x012d, 0x013d, 0x015b, 0x0177, 0x018c, 0x01a8, 0x01c0, 0x01d5,
	0x01f9, 0x0216, 0x0224, 0x0232, 0x024e, 0x026b, 0x0279, 0x029e,
	0x02bf, 0x02d4, 0x02e7, 0x02fe, 0x0317, 0x0336, 0x0354, 0x0373,
	0x0388, 0x039b, 0x03ab, 0x03c4, 0x03e0, 0x03f0, 0x0400, 0x0414,
	0x0425, 0x0437, 0x0448, 0x0463, 0x047d, 0x0496, 0x04a4, 0x04b2,
	0x04ca, 0x04e4, 0x04fb, 0x050e, 0x0523, 0x0538, 0x0546, 0x0555,
	0x0564, 0x0581, 0x059e, 0x05bb, 0x05d8, 0x05f7, 0x0607, 0x0617,
	// Entry 1480 - 14BF
	0x0627, 0x0638, 0x0649, 0x065b, 0x066c, 0x067d, 0x068e, 0x069f,
	0x06b0, 0x06c1, 0x06d2, 0x06e3, 0x06f4, 0x0705, 0x0716, 0x0727,
	0x073b, 0x074f, 0x0762, 0x0777, 0x0790, 0x07a0, 0x07b0, 0x07c0,
	0x07d1, 0x07e2, 0x07f4, 0x0805, 0x0816, 0x0827, 0x0838, 0x0849,
	0x085a, 0x086b, 0x087c, 0x088d, 0x089e, 0x08af, 0x08c0, 0x08d4,
	0x08e8, 0x08fd, 0x091a, 0x0937, 0x0945, 0x0953, 0x0961, 0x0970,
	0x097f, 0x098f, 0x099e, 0x09ad, 0x09bc, 0x09cb, 0x09da, 0x09e9,
	0x09f8, 0x0a07, 0x0a16, 0x0a25, 0x0a34, 0x0a43, 0x0a55, 0x0a67,
	// Entry 14C0 - 14FF
	0x0a78, 0x0a89, 0x0a9a, 0x0aac, 0x0abe, 0x0ad1, 0x0ae3, 0x0af5,
	0x0b07, 0x0b19, 0x0b2b, 0x0b3d, 0x0b4f, 0x0b61, 0x0b73, 0x0b85,
	0x0b9a, 0x0baf, 0x0bbe, 0x0bce, 0x0bdd, 0x0bed, 0x0bfd, 0x0c0c,
	0x0c1c, 0x0c2b, 0x0c3b, 0x0c4b, 0x0c5a, 0x0c6b, 0x0c7a, 0x0c8b,
	0x0c9b, 0x0caa, 0x0cba, 0x0cc9, 0x0cd9, 0x0ce8, 0x0cf7, 0x0d07,
	0x0d16, 0x0d26, 0x0d35, 0x0d44, 0x0d53, 0x0d62, 0x0d71, 0x0d81,
	0x0d91, 0x0da0, 0x0daf, 0x0dbe, 0x0dcd, 0x0de8, 0x0e03, 0x0e1d,
	0x0e38, 0x0e52, 0x0e6d, 0x0e88, 0x0ea4, 0x0ebe, 0x0ed9, 0x0ef3,
	// Entry 1500 - 153F
	0x0f0e, 0x0f28, 0x0f43, 0x0f67, 0x0f8b, 0x0fa6, 0x0fbd, 0x0fd4,
	0x0fe7, 0x0ff9, 0x100c, 0x101e, 0x1031, 0x1043, 0x1056, 0x1069,
	0x107c, 0x108f, 0x10a2, 0x10b4, 0x10c7, 0x10da, 0x10ed, 0x1100,
	0x1112, 0x1124, 0x113c, 0x1152, 0x1164, 0x1175, 0x1185, 0x119b,
	0x11ad, 0x11bd, 0x11d5, 0x11e6, 0x11f6, 0x120b, 0x121a, 0x122f,
	0x1249, 0x125b, 0x126c, 0x1282, 0x1294, 0x12ae, 0x12c6, 0x12d9,
	0x12e9, 0x12f8, 0x1307, 0x1318, 0x1328, 0x1338, 0x1347, 0x1358,
	0x1369, 0x1379, 0x1393, 0x13ae, 0x13c8, 0x13e2, 0x13fd, 0x1418,
	// Entry 1540 - 157F
	0x1438, 0x1457, 0x1476, 0x1496, 0x14a5, 0x14b7, 0x14c6, 0x14d9,
	0x14e8, 0x14fb, 0x1515, 0x153c, 0x1552, 0x156c, 0x157c, 0x15a1,
	0x15c6, 0x15ed, 0x1606, 0x162c, 0x1640, 0x1653, 0x1666, 0x167b,
	0x168f, 0x16a3, 0x16b6, 0x16cb, 0x16e0, 0x16f4, 0x1706, 0x1718,
	0x172a, 0x173c, 0x174e, 0x1761, 0x1774, 0x1787, 0x179a, 0x17ae,
	0x17c1, 0x17d4, 0x17e7, 0x17fa, 0x180d, 0x1820, 0x1833, 0x1847,
	0x185a, 0x186d, 0x1881, 0x1894, 0x18a7, 0x18ba, 0x18cd, 0x18e0,
	0x18f3, 0x1907, 0x191b, 0x192e, 0x1942, 0x1956, 0x196a, 0x197e,
	// Entry 1580 - 15BF
	0x1992, 0x19b7, 0x19ce, 0x19e5, 0x19fc, 0x1a13, 0x1a2b, 0x1a43,
	0x1a5c, 0x1a74, 0x1a8c, 0x1aa4, 0x1abc, 0x1ad4, 0x1aec, 0x1b04,
	0x1b1d, 0x1b35, 0x1b4e, 0x1b66, 0x1b7e, 0x1b96, 0x1baf, 0x1bc8,
	0x1be1, 0x1bfa, 0x1c13, 0x1c2a, 0x1c41, 0x1c59, 0x1c71, 0x1c88,
	0x1ca1, 0x1cb9, 0x1cd1, 0x1ce9, 0x1d01, 0x1d1a, 0x1d32, 0x1d4a,
	0x1d62, 0x1d7a, 0x1d93, 0x1dac, 0x1dc5, 0x1ddd, 0x1df6, 0x1e0f,
	0x1e28, 0x1e41, 0x1e5b, 0x1e75, 0x1e8f, 0x1eaa, 0x1ecc, 0x1ef2,
	0x1f17, 0x1f37, 0x1f58, 0x1f82, 0x1fa2, 0x1fc8, 0x1fe3, 0x1ffe,
	// Entry 15C0 - 15FF
	0x201a, 0x2037, 0x2053, 0x2070, 0x208e, 0x20ab, 0x20c8, 0x20e4,
	0x2100, 0x211c, 0x2139, 0x2156, 0x2173, 0x218f, 0x21ab, 0x21cc,
	0x21ee, 0x2212, 0x2236, 0x2259, 0x227d, 0x22a1, 0x22c6, 0x22e9,
	0x230d, 0x2331, 0x2355, 0x2379, 0x239c, 0x23bc, 0x23dd, 0x2401,
	0x2422, 0x2446, 0x245b, 0x2470, 0x2486, 0x249c, 0x24b2, 0x24c8,
	0x24df, 0x24f5, 0x250b, 0x2522, 0x2538, 0x254e, 0x2564, 0x257a,
	0x2590, 0x25a6, 0x25bd, 0x25d4, 0x25ec, 0x2602, 0x2618, 0x262e,
	0x2644, 0x2662, 0x2679, 0x2698, 0x26ae, 0x26cc, 0x26e3, 0x2702,
	// Entry 1600 - 163F
	0x2719, 0x272f, 0x2746, 0x275c, 0x2773, 0x2789, 0x27a5, 0x27c1,
	0x27dd, 0x27f9, 0x2815, 0x2831, 0x284d, 0x286a, 0x2886, 0x28a2,
	0x28c5, 0x28e8, 0x2905, 0x2925, 0x2945, 0x295c, 0x2973, 0x298b,
	0x29a3, 0x29bb, 0x29d3, 0x29eb, 0x2a09, 0x2a27, 0x2a44, 0x2a62,
	0x2a85, 0x2aa3, 0x2ac1, 0x2ade, 0x2afc, 0x2b1c, 0x2b3c, 0x2b5f,
	0x2b79, 0x2b88, 0x2b98, 0x2ba7, 0x2bb7, 0x2bc7, 0x2bd6, 0x2be6,
	0x2bf5, 0x2c05, 0x2c15, 0x2c24, 0x2c34, 0x2c43, 0x2c53, 0x2c62,
	0x2c71, 0x2c81, 0x2c90, 0x2ca0, 0x2caf, 0x2cbe, 0x2ccd, 0x2cdc,
	// Entry 1640 - 167F
	0x2ceb, 0x2cfb, 0x2d0b, 0x2d1a, 0x2d29, 0x2d3a, 0x2d4a, 0x2d5c,
	0x2d6e, 0x2d80, 0x2d93, 0x2da6, 0x2db9, 0x2dcc, 0x2dde, 0x2df0,
	0x2e09, 0x2e22, 0x2e3b, 0x2e50, 0x2e66, 0x2e81, 0x2e96, 0x2eab,
	0x2ec0, 0x2ed5, 0x2eea, 0x2eff, 0x2f13, 0x2f27, 0x2f36, 0x2f44,
	0x2f5a, 0x2f6d, 0x2f7d, 0x2f8c, 0x2f9b, 0x2fac, 0x2fbc, 0x2fcc,
	0x2fdb, 0x2fec, 0x2ffd, 0x300d, 0x301d, 0x302d, 0x303e, 0x304f,
	0x305f, 0x306f, 0x307f, 0x3090, 0x30a0, 0x30b0, 0x30c1, 0x30d1,
	0x30e1, 0x30f1, 0x3101, 0x3111, 0x3122, 0x3134, 0x3144, 0x3153,
	// Entry 1680 - 16BF
	0x3162, 0x3172, 0x3182, 0x3191, 0x31a1, 0x31b0, 0x31c0, 0x31cf,
	0x31e0, 0x31f0, 0x3204, 0x3218, 0x322c, 0x3240, 0x3254, 0x326e,
	0x3287, 0x32a1, 0x32bb, 0x32d6, 0x32ef, 0x3308, 0x3322, 0x333d,
	0x3357, 0x3371, 0x338b, 0x33a4, 0x33bd, 0x33d7, 0x33f2, 0x340c,
	0x3425, 0x343f, 0x3458, 0x3472, 0x348d, 0x34a7, 0x34c0, 0x34da,
	0x34f3, 0x350d, 0x3527, 0x3541, 0x355a, 0x3573, 0x358c, 0x35a6,
	0x35c0, 0x35da, 0x35f3, 0x360c, 0x3625, 0x3640, 0x365b, 0x3675,
	0x368f, 0x36aa, 0x36c4, 0x36ea, 0x3703, 0x371c, 0x3734, 0x374d,
	// Entry 16C0 - 16FF
	0x3765, 0x377e, 0x3796, 0x37af, 0x37c8, 0x37e1, 0x37fb, 0x3814,
	0x382d, 0x3847, 0x3861, 0x387a, 0x3894, 0x38af, 0x38c9, 0x38e3,
	0x38fd, 0x3917, 0x3931, 0x3948, 0x395f, 0x3975, 0x398a, 0x399f,
	0x39b6, 0x39cc, 0x39e2, 0x39f7, 0x3a0e, 0x3a25, 0x3a3b, 0x3a55,
	0x3a69, 0x3a7e, 0x3a95, 0x3aab, 0x3ac0, 0x3ad5, 0x3aeb, 0x3b01,
	0x3b1c, 0x3b36, 0x3b50, 0x3b6b, 0x3b80, 0x3b9a, 0x3bb3, 0x3bcc,
	0x3be6, 0x3c00, 0x3c16, 0x3c2b, 0x3c3f, 0x3c53, 0x3c68, 0x3c7d,
	0x3c97, 0x3cb0, 0x3cc9, 0x3ce3, 0x3cf7, 0x3d10, 0x3d28, 0x3d40,
	// Entry 1700 - 173F
	0x3d59, 0x3d72, 0x3d84, 0x3d96, 0x3da9, 0x3dbd, 0x3dcf, 0x3de1,
	0x3df3, 0x3e06, 0x3e18, 0x3e2a, 0x3e3c, 0x3e4f, 0x3e61, 0x3e73,
	0x3e86, 0x3e9a, 0x3eac, 0x3ebe, 0x3ed0, 0x3ee2, 0x3ef4, 0x3f05,
	0x3f17, 0x3f2c, 0x3f41, 0x3f56, 0x3f6b, 0x3f81, 0x3f91, 0x3fa8,
	0x3fbf, 0x3fd7, 0x3fef, 0x4005, 0x401c, 0x4033, 0x4046, 0x405d,
	0x4075, 0x408b, 0x40a1, 0x40b8, 0x40cb, 0x40df, 0x40f9, 0x410b,
	0x4124, 0x4138, 0x414f, 0x4167, 0x417d, 0x4194, 0x41a6, 0x41b8,
	0x41cf, 0x41e7, 0x41fe, 0x4214, 0x422a, 0x4241, 0x4253, 0x4269,
	// Entry 1740 - 177F
	0x4280, 0x4292, 0x42a5, 0x42b7, 0x42ca, 0x42dc, 0x42f4, 0x430c,
	0x4323, 0x433a, 0x434d, 0x435e, 0x4374, 0x4385, 0x4397, 0x43a8,
	0x43ba, 0x43cc, 0x43de, 0x43f1, 0x4409, 0x442a, 0x444b, 0x446e,
	0x4488, 0x44a9, 0x44c7, 0x44f3, 0x450d, 0x4527, 0x4541, 0x4554,
	0x4569, 0x4584, 0x459a, 0x45b5, 0x45ca, 0x45e0, 0x45f6, 0x460d,
	0x4622, 0x4638, 0x464d, 0x4669, 0x467f, 0x4694, 0x46aa, 0x46c0,
	0x46d6, 0x46f1, 0x470d, 0x4723, 0x4737, 0x474b, 0x4765, 0x477f,
	0x4799, 0x47ae, 0x47c3, 0x47e0, 0x4804, 0x481c, 0x4833, 0x484a,
	// Entry 1780 - 17BF
	0x4863, 0x487b, 0x4893, 0x48aa, 0x48c3, 0x48dc, 0x48f4, 0x490c,
	0x4923, 0x493a, 0x4953, 0x496b, 0x4983, 0x499a, 0x49b3, 0x49cc,
	0x49e4, 0x49f7, 0x4a0e, 0x4a21, 0x4a33, 0x4a44, 0x4a58, 0x4a7b,
	0x4a92, 0x4aa4, 0x4ab9, 0x4ace, 0x4ae6, 0x4af8, 0x4b0b, 0x4b2e,
	0x4b46, 0x4b58, 0x4b71, 0x4b85, 0x4b98, 0x4bb3, 0x4bcc, 0x4bec,
	0x4c17, 0x4c43, 0x4c5e, 0x4c80, 0x4c9b, 0x4cb8, 0x4cdc, 0x4d07,
	0x4d2c, 0x4d53, 0x4d78, 0x4d9f, 0x4dbe, 0x4dd9, 0x4dfd, 0x4e16,
	0x4e36, 0x4e56, 0x4e73, 0x4e99, 0x4ebf, 0x4ee5, 0x4efb, 0x4f18,
	// Entry 17C0 - 17FF
	0x4f35, 0x4f52, 0x4f6f, 0x4f8d, 0x4fab, 0x4fce, 0x4ff1, 0x500d,
	0x5021, 0x5034, 0x504d, 0x5075, 0x5091, 0x50aa, 0x50c4, 0x50de,
	0x50fd, 0x5113, 0x512a, 0x5145, 0x5160, 0x517b, 0x519d, 0x51ba,
	0x51e1, 0x51f8, 0x5210, 0x5223, 0x5237, 0x524a, 0x525f, 0x527b,
	0x5290, 0x52ac, 0x52c1, 0x52dd, 0x52f4, 0x5312, 0x532a, 0x5349,
	0x535e, 0x5374, 0x5389, 0x53a5, 0x53b7, 0x53d3, 0x53e5, 0x53fc,
	0x540f, 0x5421, 0x5438, 0x544a, 0x5461, 0x5474, 0x548c, 0x54ae,
	0x54d0, 0x54f2, 0x550b, 0x551d, 0x5534, 0x5546, 0x555d, 0x556f,
	// Entry 1800 - 183F
	0x5581, 0x5599, 0x55ab, 0x55c5, 0x55d7, 0x55e9, 0x55fb, 0x560d,
	0x561f, 0x5636, 0x564d, 0x565f, 0x5671, 0x5686, 0x56a0, 0x56b7,
	0x56d3, 0x56eb, 0x5708, 0x5723, 0x5745, 0x5761, 0x5784, 0x579e,
	0x57bd, 0x57de, 0x5804, 0x581d, 0x583d, 0x584f, 0x5868, 0x5882,
	0x589c, 0x58b4, 0x58cc, 0x58e5, 0x5901, 0x591d, 0x5939, 0x5958,
	0x596b, 0x597d, 0x598f, 0x59a3, 0x59b6, 0x59c9, 0x59db, 0x59ef,
	0x5a03, 0x5a16, 0x5a24, 0x5a33, 0x5a41, 0x5a59, 0x5a6c, 0x5a82,
	0x5a93, 0x5aaf, 0x5acb, 0x5ae7, 0x5b03, 0x5b26, 0x5b42, 0x5b5f,
	// Entry 1840 - 187F
	0x5b7c, 0x5b99, 0x5bba, 0x5be1, 0x5c08, 0x5c30, 0x5c58, 0x5c81,
	0x5cb6, 0x5ceb, 0x5d12, 0x5d38, 0x5d63, 0x5d8e, 0x5dbb, 0x5de8,
	0x5e13, 0x5e3e, 0x5e6b, 0x5e98, 0x5ec3, 0x5ed9, 0x5ef0, 0x5f04,
	0x5f1b, 0x5f33, 0x5f4b, 0x5f5d, 0x5f6f, 0x5f81, 0x5f94, 0x5fa6,
	0x5fb8, 0x5fcb, 0x5fde, 0x5ff1, 0x6004, 0x6018, 0x602b, 0x603e,
	0x6051, 0x6065, 0x6078, 0x608b, 0x609e, 0x60b1, 0x60c4, 0x60d7,
	0x60ea, 0x60fd, 0x6110, 0x6123, 0x6136, 0x6149, 0x615c, 0x616f,
	0x6182, 0x61a4, 0x61c5, 0x61e5, 0x6202, 0x621e, 0x623d, 0x625a,
	// Entry 1880 - 18BF
	0x6276, 0x6295, 0x62ab, 0x62c0, 0x62e4, 0x6308, 0x631c, 0x6330,
	0x6344, 0x6357, 0x636a, 0x637f, 0x6393, 0x63a7, 0x63ba, 0x63cf,
	0x63e4, 0x63f8, 0x640a, 0x641e, 0x6432, 0x6446, 0x645e, 0x6476,
	0x6484, 0x649d, 0x64ac, 0x64c6, 0x64e0, 0x64ef, 0x6503, 0x6512,
	0x652c, 0x653b, 0x6555, 0x6564, 0x657e, 0x6594, 0x65a3, 0x65bd,
	0x65cc, 0x65db, 0x65ea, 0x6604, 0x6613, 0x662d, 0x6645, 0x665d,
	0x666c, 0x6686, 0x66a0, 0x66af, 0x66c9, 0x66d9, 0x66e8, 0x6702,
	0x6712, 0x6721, 0x6731, 0x6741, 0x674f, 0x675d, 0x676d, 0x677f,
	// Entry 18C0 - 18FF
	0x6798, 0x67ab, 0x67bd, 0x67d4, 0x67e6, 0x67fd, 0x680f, 0x6833,
	0x684a, 0x6860, 0x686e, 0x687e, 0x6899, 0x68b6, 0x68ce, 0x68e9,
	0x68f9, 0x690a, 0x691b, 0x692b, 0x693c, 0x694d, 0x695d, 0x696e,
	0x697e, 0x698f, 0x699f, 0x69b0, 0x69c0, 0x69d0, 0x69e0, 0x69f1,
	0x6a02, 0x6a12, 0x6a23, 0x6a33, 0x6a44, 0x6a54, 0x6a65, 0x6a76,
	0x6a88, 0x6a99, 0x6aa9, 0x6ab9, 0x6ac9, 0x6ad9, 0x6aea, 0x6afa,
	0x6b0a, 0x6b1b, 0x6b2b, 0x6b3a, 0x6b54, 0x6b6e, 0x6b82, 0x6b95,
	0x6ba8, 0x6bbc, 0x6bcf, 0x6be3, 0x6bf6, 0x6c0d, 0x6c24, 0x6c3b,
	// Entry 1900 - 193F
	0x6c52, 0x6c69, 0x6c80, 0x6c97, 0x6cb4, 0x6cce, 0x6cdd, 0x6cee,
	0x6d07, 0x6d2c, 0x6d45, 0x6d65, 0x6d7e, 0x6d8f, 0x6d9f, 0x6daf,
	0x6dc1, 0x6dd2, 0x6de3, 0x6df3, 0x6e05, 0x6e17, 0x6e28, 0x6e39,
	0x6e4b, 0x6e5c, 0x6e6f, 0x6e81, 0x6e93, 0x6ea7, 0x6eba, 0x6ecd,
	0x6edf, 0x6ef3, 0x6f07, 0x6f1a, 0x6f2c, 0x6f3e, 0x6f50, 0x6f63,
	0x6f75, 0x6f88, 0x6f9b, 0x6fae, 0x6fc1, 0x6fd4, 0x6fe6, 0x6ff8,
	0x700a, 0x701d, 0x702f, 0x7041, 0x7053, 0x7065, 0x7078, 0x708a,
	0x709c, 0x70ae, 0x70c1, 0x70d3, 0x70e6, 0x70f8, 0x710b, 0x711d,
	// Entry 1940 - 197F
	0x712f, 0x7141, 0x7154, 0x716d, 0x7189, 0x7197, 0x71a8, 0x71b5,
	0x71d0, 0x71f2, 0x7212, 0x7236, 0x7254, 0x7271, 0x728e, 0x72b3,
	0x72d7, 0x72f5, 0x7317, 0x7332, 0x734b, 0x736e, 0x7392, 0x73b6,
	0x73da, 0x73fd, 0x7421, 0x7445, 0x7469, 0x748c, 0x74b0, 0x74d4,
	0x74f8, 0x751c, 0x753f, 0x7563, 0x7588, 0x75ac, 0x75d0, 0x75f4,
	0x7617, 0x763c, 0x7661, 0x7686, 0x76aa, 0x76cf, 0x76f4, 0x7718,
	0x773c, 0x7760, 0x7785, 0x77a9, 0x77ce, 0x77f2, 0x7815, 0x7839,
	0x785c, 0x7880, 0x78a4, 0x78c7, 0x78ea, 0x7910, 0x793b, 0x795f,
	// Entry 1980 - 19BF
	0x7983, 0x79ad, 0x79d9, 0x79fa, 0x7a1e, 0x7a41, 0x7a62, 0x7a89,
	0x7aaf, 0x7ad5, 0x7afb, 0x7b0e, 0x7b1e, 0x7b30, 0x7b44, 0x7b69,
	0x7b9d, 0x7bc6, 0x7bf7, 0x7c0e, 0x7c49, 0x7c62, 0x7c7b, 0x7c96,
	0x7caa, 0x7cc3, 0x7cde, 0x7d0e, 0x7d39, 0x7d53, 0x7d6c, 0x7d8e,
	0x7da9, 0x7dcd, 0x7df0, 0x7e15, 0x7e35, 0x7e55, 0x7e74, 0x7e9d,
	0x7eae, 0x7ecf, 0x7ee7, 0x7f06, 0x7f28, 0x7f3f, 0x7f5e, 0x7f75,
	0x7f8b, 0x7fa1, 0x7fb4, 0x7fc9, 0x7fe5, 0x800c, 0x8028, 0x8045,
	0x8061, 0x8084, 0x80a0, 0x80bc, 0x80da, 0x80f6, 0x8116, 0x8131,
	// Entry 19C0 - 19FF
	0x814d, 0x8169, 0x8191, 0x81ad, 0x81d2, 0x81ee, 0x820f, 0x822c,
	0x824e, 0x8277, 0x8293, 0x82b0, 0x82cd, 0x82ed, 0x8309, 0x832e,
	0x8351, 0x836d, 0x8389, 0x83a6, 0x83cf, 0x83f3, 0x840f, 0x842b,
	0x8447, 0x8465, 0x848a, 0x849a, 0x84ba, 0x84da, 0x84f7, 0x8515,
	0x8533, 0x8553, 0x856c, 0x8586, 0x859f, 0x85bf, 0x85d8, 0x85f1,
	0x8613, 0x862c, 0x8645, 0x865e, 0x8677, 0x8690, 0x86a9, 0x86c2,
	0x86db, 0x86fd, 0x8716, 0x8730, 0x8749, 0x8762, 0x877b, 0x8794,
	0x87ad, 0x87c4, 0x87e2, 0x87fd, 0x881c, 0x8833, 0x884a, 0x8861,
	// Entry 1A00 - 1A3F
	0x887c, 0x8898, 0x88bb, 0x88d2, 0x88f0, 0x8907, 0x891e, 0x8937,
	0x894e, 0x896a, 0x898a, 0x89ad, 0x89c4, 0x89db, 0x89f2, 0x8a12,
	0x8a30, 0x8a47, 0x8a60, 0x8a7a, 0x8a9b, 0x8ab6, 0x8ad5, 0x8aee,
	0x8b0c, 0x8b2a, 0x8b48, 0x8b66, 0x8b87, 0x8ba9, 0x8bc9, 0x8be9,
	0x8c09, 0x8c1e, 0x8c44, 0x8c6a, 0x8c90, 0x8cb6, 0x8cdc, 0x8d02,
	0x8d28, 0x8d5b, 0x8d81, 0x8da7, 0x8dcd, 0x8de8, 0x8e03, 0x8e1f,
	0x8e47, 0x8e6f, 0x8e92, 0x8eb2, 0x8eda, 0x8f00, 0x8f26, 0x8f4c,
	0x8f72, 0x8f98, 0x8fbe, 0x8fe4, 0x900a, 0x9030, 0x9056, 0x907c,
	// Entry 1A40 - 1A7F
	0x90a2, 0x90ca, 0x90f0, 0x9116, 0x913c, 0x9164, 0x9190, 0x91b7,
	0x91df, 0x920c, 0x9242, 0x926e, 0x9296, 0x92c3, 0x92ed, 0x9315,
	0x933f, 0x9361, 0x9378, 0x9399, 0x93b2, 0x93d7, 0x93ee, 0x9419,
	0x9437, 0x9455, 0x9478, 0x9492, 0x94b1, 0x94dc, 0x9505, 0x9530,
	0x9559, 0x9578, 0x9599, 0x95c5, 0x95eb, 0x9616, 0x9635, 0x9653,
	0x966c, 0x968d, 0x96a6, 0x96cf, 0x96ea, 0x9707, 0x9726, 0x9747,
	0x9765, 0x977c, 0x97a7, 0x97c8, 0x97e1, 0x97fc, 0x9819, 0x9836,
	0x984b, 0x9864, 0x987a, 0x9890, 0x98a6, 0x98bc, 0x98d7, 0x98f2,
	// Entry 1A80 - 1ABF
	0x9916, 0x992c, 0x9942, 0x9963, 0x9979, 0x998f, 0x99a1, 0x99b3,
	0x99c5, 0x99f8, 0x9a17, 0x9a36, 0x9a55, 0x9a7b, 0x9aa1, 0x9ac1,
	0x9adf, 0x9b05, 0x9b23, 0x9b41, 0x9b67, 0x9b8d, 0x9bab, 0x9bd1,
	0x9bf7, 0x9c1d, 0x9c3b, 0x9c5e, 0x9c7c, 0x9c9e, 0x9cbc, 0x9cdd,
	0x9cff, 0x9d1d, 0x9d54, 0x9d93, 0x9db1, 0x9dd1, 0x9e10, 0x9e2e,
	0x9e5b, 0x9e88, 0x9eb5, 0x9ecc, 0x9ee8, 0x9f03, 0x9f1b, 0x9f3f,
	0x9f57, 0x9f6e, 0x9f93, 0x9fb2, 0x9fd0, 0xa002, 0xa028, 0xa04c,
	0xa071, 0xa094, 0xa0b9, 0xa0dc, 0xa102, 0xa126, 0xa153, 0xa17e,
	// Entry 1AC0 - 1AFF
	0xa1a3, 0xa1c6, 0xa1eb, 0xa20e, 0xa234, 0xa258, 0xa27b, 0xa29c,
	0xa2c8, 0xa2f2, 0xa31e, 0xa348, 0xa374, 0xa39e, 0xa3ca, 0xa3f4,
	0xa41b, 0xa440, 0xa46d, 0xa498, 0xa4bd, 0xa4e0, 0xa502, 0xa522,
	0xa547, 0xa56a, 0xa58f, 0xa5b2, 0xa5d7, 0xa5fa, 0xa61d, 0xa63e,
	0xa665, 0xa68a, 0xa6b1, 0xa6d6, 0xa705, 0xa732, 0xa753, 0xa772,
	0xa797, 0xa7ba, 0xa7e0, 0xa804, 0xa829, 0xa84c, 0xa87c, 0xa8aa,
	0xa8d0, 0xa8f4, 0xa920, 0xa94a, 0xa96b, 0xa98a, 0xa9af, 0xa9d2,
	0xa9f7, 0xaa1a, 0xaa3f, 0xaa62, 0xaa87, 0xaaaa, 0xaad0, 0xaaf4,
	// Entry 1B00 - 1B3F
	0xab20, 0xab4a, 0xab75, 0xab9e, 0xabcd, 0xabfa, 0xac26, 0xac50,
	0xac7c, 0xaca6, 0xacc7, 0xace6, 0xad0b, 0xad2e, 0xad53, 0xad76,
	0xad9b, 0xadbe, 0xadee, 0xae1c, 0xae42, 0xae66, 0xae8b, 0xaeae,
	0xaed3, 0xaef6, 0xaf25, 0xaf52, 0xaf81, 0xafae, 0xafe1, 0xb012,
	0xb037, 0xb05a, 0xb07f, 0xb0a2, 0xb0c8, 0xb0ec, 0xb118, 0xb142,
	0xb16d, 0xb196, 0xb1bd, 0xb1e2, 0xb20e, 0xb238, 0xb263, 0xb28c,
	0xb2bc, 0xb2ea, 0xb30b, 0xb32a, 0xb34f, 0xb372, 0xb393, 0xb3b2,
	0xb3d3, 0xb3f2, 0xb417, 0xb43a, 0xb45f, 0xb482, 0xb4a7, 0xb4ca,
	// Entry 1B40 - 1B7F
	0xb4ef, 0xb512, 0xb537, 0xb55a, 0xb57f, 0xb5a2, 0xb5c8, 0xb5ec,
	0xb611, 0xb634, 0xb65a, 0xb67e, 0xb6a2, 0xb6c5, 0xb6e9, 0xb70d,
	0xb736, 0xb75e, 0xb78c, 0xb7b6, 0xb7d2, 0xb7ea, 0xb80f, 0xb832,
	0xb858, 0xb87c, 0xb8ac, 0xb8da, 0xb90a, 0xb938, 0xb96d, 0xb9a0,
	0xb9d0, 0xb9fe, 0xba32, 0xba64, 0xba8f, 0xbab8, 0xbae3, 0xbb0c,
	0xbb3c, 0xbb6a, 0xbb95, 0xbbbe, 0xbbed, 0xbc1a, 0xbc3f, 0xbc62,
	0xbc88, 0xbcac, 0xbccd, 0xbcec, 0xbd1c, 0xbd4a, 0xbd7a, 0xbda8,
	0xbddd, 0xbe10, 0xbe40, 0xbe6e, 0xbea2, 0xbed4, 0xbefa, 0xbf1e,
	// Entry 1B80 - 1BBF
	0xbf43, 0xbf66, 0xbf8b, 0xbfae, 0xbfd4, 0xbff8, 0xc028, 0xc056,
	0xc086, 0xc0b4, 0xc0e9, 0xc11c, 0xc14c, 0xc17a, 0xc1ae, 0xc1e0,
	0xc20a, 0xc232, 0xc25c, 0xc284, 0xc2b3, 0xc2e0, 0xc30a, 0xc332,
	0xc360, 0xc38c, 0xc3b1, 0xc3d4, 0xc3fa, 0xc41e, 0xc448, 0xc470,
	0xc49a, 0xc4c2, 0xc4f1, 0xc51e, 0xc548, 0xc570, 0xc59e, 0xc5ca,
	0xc5eb, 0xc60a, 0xc62f, 0xc652, 0xc678, 0xc69c, 0xc6bd, 0xc6dc,
	0xc700, 0xc722, 0xc745, 0xc766, 0xc786, 0xc7a4, 0xc7c7, 0xc7ea,
	0xc817, 0xc844, 0xc870, 0xc89c, 0xc8cf, 0xc902, 0xc927, 0xc94c,
	// Entry 1BC0 - 1BFF
	0xc97b, 0xc9aa, 0xc9d8, 0xca06, 0xca3b, 0xca70, 0xca95, 0xcaba,
	0xcae9, 0xcb18, 0xcb46, 0xcb74, 0xcb9b, 0xcbc2, 0xcbf3, 0xcc24,
	0xcc54, 0xcc84, 0xcca5, 0xccc6, 0xccf1, 0xcd1c, 0xcd46, 0xcd70,
	0xcda1, 0xcdd2, 0xcdf5, 0xce18, 0xce45, 0xce72, 0xce9e, 0xceca,
	0xcefd, 0xcf30, 0xcf52, 0xcf74, 0xcfa0, 0xcfcc, 0xcff7, 0xd022,
	0xd054, 0xd086, 0xd0aa, 0xd0ce, 0xd0fc, 0xd12a, 0xd157, 0xd184,
	0xd1b8, 0xd1ec, 0xd211, 0xd236, 0xd265, 0xd294, 0xd2c2, 0xd2f0,
	0xd317, 0xd33e, 0xd36f, 0xd3a0, 0xd3d0, 0xd400, 0xd425, 0xd44a,
	// Entry 1C00 - 1C3F
	0xd479, 0xd4a8, 0xd4d6, 0xd504, 0xd539, 0xd56e, 0xd595, 0xd5c6,
	0xd5f6, 0xd62d, 0xd650, 0xd673, 0xd6a0, 0xd6cd, 0xd6f9, 0xd725,
	0xd758, 0xd78b, 0xd7b0, 0xd7d5, 0xd804, 0xd833, 0xd861, 0xd88f,
	0xd8c4, 0xd8f9, 0xd91c, 0xd93e, 0xd963, 0xd987, 0xd9a8, 0xd9c8,
	0xd9ea, 0xda0b, 0xda30, 0xda54, 0xda79, 0xda9d, 0xdac0, 0xdae2,
	0xdb17, 0xdb4c, 0xdb8b, 0xdbca, 0xdc08, 0xdc46, 0xdc8b, 0xdcd0,
	0xdd08, 0xdd40, 0xdd82, 0xddc4, 0xde05, 0xde46, 0xde8e, 0xded6,
	0xdf09, 0xdf3c, 0xdf79, 0xdfb6, 0xdff2, 0xe02e, 0xe071, 0xe0b4,
	// Entry 1C40 - 1C7F
	0xe0ea, 0xe120, 0xe160, 0xe1a0, 0xe1df, 0xe21e, 0xe264, 0xe2aa,
	0xe2df, 0xe314, 0xe353, 0xe392, 0xe3d0, 0xe40e, 0xe453, 0xe498,
	0xe4d0, 0xe508, 0xe54a, 0xe58c, 0xe5cd, 0xe60e, 0xe656, 0xe69e,
	0xe6c2, 0xe6e6, 0xe71b, 0xe746, 0xe77a, 0xe7a3, 0xe7de, 0xe804,
	0xe82a, 0xe84f, 0xe873, 0xe8a1, 0xe8ae, 0xe8c2, 0xe8cd, 0xe8de,
	0xe8fd, 0xe930, 0xe959, 0xe98b, 0xe9b2, 0xe9eb, 0xea12, 0xea38,
	0xea5b, 0xea7d, 0xeaa9, 0xeabe, 0xead2, 0xeaed, 0xeb10, 0xeb33,
	0xeb63, 0xeb92, 0xebba, 0xebf0, 0xec15, 0xec3a, 0xec5e, 0xec81,
	// Entry 1C80 - 1CBF
	0xec96, 0xecaa, 0xecc5, 0xeceb, 0xed11, 0xed44, 0xed76, 0xed97,
	0xedb8, 0xede3, 0xee1c, 0xee44, 0xee6c, 0xee93, 0xeeb9, 0xeedc,
	0xeef5, 0xef0d, 0xef18, 0xef4d, 0xef78, 0xefac, 0xefd5, 0xf010,
	0xf037, 0xf05d, 0xf082, 0xf0a6, 0xf0d4, 0xf0de, 0xf0e9, 0xf0f0,
	0xf0f7, 0xf0ff, 0xf107, 0xf119, 0xf12a, 0xf13a, 0xf146, 0xf157,
	0xf161, 0xf16b, 0xf17b, 0xf190, 0xf1a1, 0xf1b3, 0xf1c5, 0xf1cb,
	0xf1de, 0xf1e9, 0xf1f0, 0xf1f7, 0xf205, 0xf219, 0xf228, 0xf242,
	0xf25d, 0xf278, 0xf29d, 0xf2b7, 0xf2d2, 0xf2ed, 0xf312, 0xf318,
	// Entry 1CC0 - 1CFF
	0xf325, 0xf32b, 0xf33c, 0xf34a, 0xf358, 0xf36b, 0xf37c, 0xf38a,
	0xf39d, 0xf3b4, 0xf3cb, 0xf3e5, 0xf3fb, 0xf411, 0xf426, 0xf434,
	0xf449, 0xf44e, 0xf45a, 0xf466, 0xf474, 0xf489, 0xf49e, 0xf4a3,
	0xf4cc, 0xf4f6, 0xf504, 0xf51b, 0xf526, 0xf52e, 0xf536, 0xf543,
	0xf558, 0xf560, 0xf56d, 0xf57b, 0xf599, 0xf5b8, 0xf5cc, 0xf5e5,
	0xf5fe, 0xf60e, 0xf623, 0xf639, 0xf650, 0xf65c, 0xf66e, 0xf676,
	0xf696, 0xf6ab, 0xf6b5, 0xf6c6, 0xf6dd, 0xf6f2, 0xf701, 0xf715,
	0xf729, 0xf73c, 0xf749, 0xf755, 0xf75d, 0xf76f, 0xf788, 0xf793,
	// Entry 1D00 - 1D3F
	0xf7a7, 0xf7b6, 0xf7c9, 0xf7d7, 0xf7ec, 0xf801, 0xf815, 0xf82c,
	0xf846, 0xf861, 0xf87c, 0xf898, 0xf8ad, 0xf8c1, 0xf8d1, 0xf8f1,
	0xf901, 0xf911, 0xf920, 0xf931, 0xf942, 0xf952, 0xf967, 0xf978,
	0xf98f, 0xf9ab, 0xf9c8, 0xf9e8, 0xf9f6, 0xfa03, 0xfa10, 0xfa1f,
	0xfa2d, 0xfa3b, 0xfa48, 0xfa57, 0xfa66, 0xfa74, 0xfa87, 0xfa96,
	0xfaab, 0xfac5, 0xfae0, 0xfafe, 0xfb1c, 0xfb3a, 0xfb58, 0xfb7a,
	0xfb98, 0xfbb6, 0xfbd4, 0xfbf2, 0xfc10, 0xfc2e, 0xfc4c, 0xfc6a,
	0xfc7c, 0xfc86, 0xfc93, 0xfca4, 0xfcad, 0xfcb6, 0xfcc0, 0xfccb,
	// Entry 1D40 - 1D7F
	0xfcd5, 0xfcdd, 0xfcec, 0xfcf5, 0xfcfe, 0xfd06, 0xfd11, 0xfd1d,
	0xfd2e, 0xfd37, 0xfd43, 0xfd4f, 0xfd5b, 0xfd64, 0xfd77, 0xfd84,
	0xfd8e, 0xfd9f, 0xfdb0, 0xfdc0, 0xfdca, 0xfdd4, 0xfddd, 0xfde9,
	0xfdf1, 0xfe01, 0xfe1d, 0xfe3a, 0xfe5e, 0xfe83, 0xfea6, 0xfec5,
	0xfedf, 0xfefa, 0xff10, 0xff30, 0xff54, 0xff6e, 0xff87, 0xffa1,
	0xffbb, 0xffd6, 0xfffa, 0x001a, 0x0034, 0x004e, 0x007a, 0x009b,
	0x00c3, 0x00db, 0x00f4, 0x010f, 0x0130, 0x0155, 0x0185, 0x01b4,
	0x01ce, 0x01e9, 0x0201, 0x020b, 0x0223, 0x023a, 0x0248, 0x025a,
	// Entry 1D80 - 1DBF
	0x0261, 0x0269, 0x0277, 0x027e, 0x028f, 0x029d, 0x02ad, 0x02c3,
	0x02da, 0x02e9, 0x0304, 0x0314, 0x032a, 0x033a, 0x0348, 0x0356,
	0x036d, 0x0378, 0x0391, 0x03a1, 0x03b8, 0x03cf, 0x03df, 0x03f5,
	0x040c, 0x041d, 0x0425, 0x0431, 0x043f, 0x044e, 0x0456, 0x046d,
	0x0477, 0x047f, 0x0490, 0x04a6, 0x04c4, 0x04cf, 0x04dc, 0x04ec,
	0x0502, 0x0512, 0x0520, 0x0530, 0x0540, 0x0550, 0x0560, 0x056e,
	0x0579, 0x0583, 0x058f, 0x059b, 0x05ad, 0x05be, 0x05cc, 0x05e2,
	0x05fb, 0x0616, 0x062e, 0x064b, 0x0666, 0x0681, 0x069e, 0x06b9,
	// Entry 1DC0 - 1DFF
	0x06d7, 0x06f3, 0x070f, 0x072b, 0x0747, 0x0754, 0x0764, 0x076c,
	0x0778, 0x0786, 0x07a1, 0x07bc, 0x07d5, 0x07ee, 0x0807, 0x0821,
	0x083a, 0x0854, 0x0870, 0x088b, 0x08a4, 0x08bf, 0x08d9, 0x08f6,
	0x0912, 0x092f, 0x0945, 0x0956, 0x0967, 0x097a, 0x098c, 0x099e,
	0x09af, 0x09c2, 0x09d5, 0x09e7, 0x09f8, 0x0a0c, 0x0a20, 0x0a33,
	0x0a4c, 0x0a66, 0x0a80, 0x0a97, 0x0aae, 0x0ac7, 0x0adf, 0x0af7,
	0x0b0e, 0x0b27, 0x0b40, 0x0b58, 0x0b6f, 0x0b89, 0x0ba3, 0x0bbc,
	0x0bdb, 0x0bfb, 0x0c1b, 0x0c39, 0x0c54, 0x0c6e, 0x0c90, 0x0cad,
	// Entry 1E00 - 1E3F
	0x0cc8, 0x0ce6, 0x0d02, 0x0d24, 0x0d3f, 0x0d4f, 0x0d61, 0x0d70,
	0x0d7d, 0x0d8d, 0x0d9c, 0x0dac, 0x0db9, 0x0dc9, 0x0dd9, 0x0de9,
	0x0df9, 0x0e14, 0x0e30, 0x0e44, 0x0e59, 0x0e73, 0x0e8b, 0x0ea6,
	0x0ec0, 0x0ed9, 0x0ef3, 0x0f0b, 0x0f21, 0x0f3a, 0x0f52, 0x0f69,
	0x0f82, 0x0f9c, 0x0fb5, 0x0fcf, 0x0fe4, 0x1000, 0x1016, 0x1036,
	0x1057, 0x1079, 0x109c, 0x10c2, 0x10e7, 0x1109, 0x1127, 0x1143,
	0x1176, 0x1195, 0x11b0, 0x11d3, 0x11f8, 0x121c, 0x123f, 0x1263,
	0x1289, 0x12af, 0x12d4, 0x12f9, 0x1323, 0x1348, 0x135f, 0x1374,
	// Entry 1E40 - 1E7F
	0x138c, 0x13a3, 0x13cc, 0x13f5, 0x1417, 0x143a, 0x145d, 0x1473,
	0x1487, 0x149e, 0x14b4, 0x14cb, 0x14df, 0x14f6, 0x150d, 0x1524,
	0x153b, 0x1551, 0x1568, 0x1580, 0x1599, 0x15b9, 0x15db, 0x15f1,
	0x1605, 0x161c, 0x1632, 0x1648, 0x165f, 0x1674, 0x1687, 0x169d,
	0x16b2, 0x16ce, 0x16ed, 0x1720, 0x1751, 0x176b, 0x1791, 0x17b1,
	0x17cb, 0x17e5, 0x17f8, 0x1815, 0x183f, 0x1856, 0x187a, 0x189f,
	0x18c4, 0x18ef, 0x191b, 0x1947, 0x1962, 0x197e, 0x199a, 0x19a1,
	0x19ab, 0x19bf, 0x19cb, 0x19df, 0x19e8, 0x19f1, 0x19f6, 0x1a00,
	// Entry 1E80 - 1EBF
	0x1a11, 0x1a21, 0x1a33, 0x1a4d, 0x1a65, 0x1a71, 0x1a7e, 0x1a8d,
	0x1a9c, 0x1aa6, 0x1ab8, 0x1ac0, 0x1ace, 0x1ad7, 0x1ae8, 0x1af5,
	0x1b04, 0x1b0f, 0x1b18, 0x1b23, 0x1b32, 0x1b3a, 0x1b45, 0x1b4a,
	0x1b58, 0x1b67, 0x1b6e, 0x1b7d, 0x1b88, 0x1b97, 0x1ba2, 0x1bac,
	0x1bb8, 0x1bbd, 0x1bc5, 0x1bd4, 0x1be3, 0x1bf3, 0x1c03, 0x1c12,
	0x1c24, 0x1c3e, 0x1c5c, 0x1c65, 0x1c6c, 0x1c71, 0x1c7b, 0x1c84,
	0x1c8a, 0x1c9e, 0x1ca8, 0x1cb6, 0x1cc4, 0x1cd3, 0x1cdc, 0x1cea,
	0x1cf3, 0x1cfe, 0x1d15, 0x1d30, 0x1d46, 0x1d6d, 0x1d98, 0x1da7,
	// Entry 1EC0 - 1EFF
	0x1dba, 0x1dd2, 0x1dde, 0x1dea, 0x1df7, 0x1e12, 0x1e24, 0x1e38,
	0x1e4e, 0x1e74, 0x1e96, 0x1ea2, 0x1eae, 0x1ebe, 0x1ecb, 0x1ed9,
	0x1ee2, 0x1ef0, 0x1efb, 0x1f09, 0x1f1f, 0x1f2a, 0x1f3d, 0x1f49,
	0x1f55, 0x1f65, 0x1f7b, 0x1f90, 0x1fa8, 0x1fbf, 0x1fd9, 0x1ff3,
	0x2010, 0x201e, 0x202f, 0x2036, 0x2047, 0x2054, 0x2064, 0x2082,
	0x20a3, 0x20bd, 0x20da, 0x20fd, 0x2123, 0x213c, 0x2155, 0x2177,
	0x2199, 0x21a1, 0x21a9, 0x21bd, 0x21d1, 0x21ea, 0x2203, 0x2213,
	0x2223, 0x222c, 0x2237, 0x2246, 0x2257, 0x226c, 0x2283, 0x22a3,
	// Entry 1F00 - 1F3F
	0x22c5, 0x22e0, 0x22fd, 0x2305, 0x231c, 0x232a, 0x2339, 0x234b,
	0x2366, 0x2384, 0x238e, 0x2398, 0x23a4, 0x23b1, 0x23be, 0x23d4,
	0x23e8, 0x23fd, 0x2416, 0x2424, 0x2430, 0x243c, 0x2449, 0x2456,
	0x246a, 0x2474, 0x247d, 0x2486, 0x248d, 0x2496, 0x249c, 0x24a0,
	0x24a6, 0x24c9, 0x24f3, 0x2501, 0x2509, 0x2517, 0x2549, 0x2560,
	0x2577, 0x2589, 0x25a4, 0x25c2, 0x25e9, 0x25f4, 0x25fc, 0x2604,
	0x261e, 0x2629, 0x262c, 0x2630, 0x2633, 0x2647, 0x2655, 0x2666,
	0x2676, 0x2688, 0x2693, 0x26a3, 0x26af, 0x26bc, 0x26ca, 0x26d0,
	// Entry 1F40 - 1F7F
	0x26f5, 0x271b, 0x2732, 0x274a, 0x275f, 0x276f, 0x2780, 0x278d,
	0x279c, 0x27af, 0x27bb, 0x27c4, 0x27d9, 0x27eb, 0x2800, 0x2813,
	0x2829, 0x284b, 0x286d, 0x2882, 0x289a, 0x28ae, 0x28c2, 0x28db,
	0x28f4, 0x2913, 0x2935, 0x2954, 0x2976, 0x2995, 0x29b7, 0x29d5,
	0x29f3, 0x2a09, 0x2a2c, 0x2a4e, 0x2a7a, 0x2a8b, 0x2aa6, 0x2ac0,
	0x2adc, 0x2b02, 0x2b3a, 0x2b78, 0x2b91, 0x2ba8, 0x2bc5, 0x2bdd,
	0x2c03, 0x2c27, 0x2c5d, 0x2c99, 0x2cae, 0x2cc9, 0x2ce2, 0x2cef,
	0x2cfd, 0x2d02, 0x2d0e, 0x2d1c, 0x2d26, 0x2d31, 0x2d3a, 0x2d46,
	// Entry 1F80 - 1FBF
	0x2d53, 0x2d5d, 0x2d68, 0x2d79, 0x2d89, 0x2d97, 0x2da4, 0x2db5,
	0x2dc3, 0x2dc6, 0x2dcd, 0x2dd3, 0x2de5, 0x2df7, 0x2e06, 0x2e1c,
	0x2e2b, 0x2e30, 0x2e39, 0x2e48, 0x2e58, 0x2e6a, 0x2e7d, 0x2e8e,
	0x2ea2, 0x2ea7, 0x2eac, 0x2ed4, 0x2ede, 0x2ef0, 0x2f04, 0x2f0c,
	0x2f27, 0x2f43, 0x2f54, 0x2f60, 0x2f6c, 0x2f7e, 0x2f86, 0x2f92,
	0x2fa2, 0x2faf, 0x2fb4, 0x2fbf, 0x2fca, 0x2fe6, 0x3007, 0x3027,
	0x3048, 0x306a, 0x3088, 0x30a9, 0x30cb, 0x30eb, 0x310a, 0x312d,
	0x314d, 0x3171, 0x3195, 0x31bc, 0x31e0, 0x3205, 0x322f, 0x325a,
	// Entry 1FC0 - 1FFF
	0x3280, 0x32a8, 0x32c9, 0x32ee, 0x330e, 0x3331, 0x3353, 0x337b,
	0x33a0, 0x33bf, 0x33e2, 0x3400, 0x3421, 0x3445, 0x346f, 0x3493,
	0x34b7, 0x34dd, 0x34ff, 0x3524, 0x3545, 0x3565, 0x3586, 0x35a6,
	0x35cd, 0x35f0, 0x3614, 0x3637, 0x365d, 0x3682, 0x36a7, 0x36cc,
	0x36f8, 0x3717, 0x3736, 0x3751, 0x3772, 0x379a, 0x37be, 0x37e1,
	0x3807, 0x382b, 0x3845, 0x385e, 0x3879, 0x389d, 0x38c3, 0x38e6,
	0x390a, 0x3925, 0x3933, 0x395a, 0x396d, 0x3978, 0x3995, 0x39a5,
	0x39c0, 0x39de, 0x39ed, 0x39ff, 0x3a25, 0x3a31, 0x3a47, 0x3a52,
	// Entry 2000 - 203F
	0x3a73, 0x3a88, 0x3aaa, 0x3ab5, 0x3ac6, 0x3ad7, 0x3af8, 0x3b19,
	0x3b38, 0x3b55, 0x3b73, 0x3b8b, 0x3ba5, 0x3bc1, 0x3bce, 0x3bd7,
	0x3bea, 0x3bfd, 0x3c18, 0x3c32, 0x3c4d, 0x3c69, 0x3c84, 0x3ca0,
	0x3cc0, 0x3cdd, 0x3cfd, 0x3d1e, 0x3d3c, 0x3d5d, 0x3d7a, 0x3d99,
	0x3db6, 0x3dcd, 0x3deb, 0x3e0b, 0x3e29, 0x3e3b, 0x3e54, 0x3e83,
	0x3eb2, 0x3ebf, 0x3ecf, 0x3ee1, 0x3ef6, 0x3f23, 0x3f38, 0x3f4e,
	0x3f65, 0x3f7b, 0x3f91, 0x3fa7, 0x3fbd, 0x3fea, 0x401a, 0x4045,
	0x407b, 0x40af, 0x40dc, 0x4114, 0x414a, 0x4172, 0x41a6, 0x41d8,
	// Entry 2040 - 207F
	0x4202, 0x422a, 0x4256, 0x4285, 0x4290, 0x429d, 0x42a9, 0x42c0,
	0x42ce, 0x42e6, 0x42fe, 0x431b, 0x4338, 0x4352, 0x4362, 0x4374,
	0x4386, 0x4392, 0x4396, 0x43a5, 0x43b7, 0x43c8, 0x43dc, 0x43f6,
	0x4413, 0x4422, 0x443a, 0x4446, 0x444e, 0x4458, 0x446f, 0x4486,
	0x44aa, 0x44cd, 0x44ee, 0x4511, 0x4547, 0x457c, 0x45b2, 0x45bd,
	0x45c6, 0x45d1, 0x45ec, 0x460f, 0x4633, 0x4654, 0x4677, 0x468a,
	0x469f, 0x46b6, 0x46c2, 0x46d5, 0x46e4, 0x46f6, 0x4709, 0x4718,
	0x4733, 0x474b, 0x4761, 0x477f, 0x4791, 0x47a7, 0x47b6, 0x47ca,
	// Entry 2080 - 20BF
	0x47ea, 0x47fe, 0x481c, 0x4830, 0x484a, 0x485e, 0x4871, 0x488c,
	0x48a9, 0x48c6, 0x48e5, 0x4903, 0x4922, 0x493d, 0x4961, 0x4972,
	0x498a, 0x499f, 0x49b0, 0x49c9, 0x49e3, 0x49fe, 0x4a17, 0x4a27,
	0x4a38, 0x4a44, 0x4a4c, 0x4a5e, 0x4a78, 0x4a96, 0x4ac1, 0x4af1,
	0x4b14, 0x4b1c, 0x4b25, 0x4b2d, 0x4b3e, 0x4b4d, 0x4b58, 0x4b76,
	0x4b89, 0x4b91, 0x4bac, 0x4bc0, 0x4bd1, 0x4be2, 0x4bf5, 0x4c07,
	0x4c19, 0x4c2a, 0x4c3d, 0x4c50, 0x4c62, 0x4c74, 0x4c89, 0x4c9e,
	0x4cb5, 0x4ccc, 0x4ce2, 0x4cf8, 0x4d10, 0x4d27, 0x4d3e, 0x4d53,
	// Entry 20C0 - 20FF
	0x4d6a, 0x4d81, 0x4d9a, 0x4db2, 0x4dca, 0x4de1, 0x4dfa, 0x4e13,
	0x4e2b, 0x4e43, 0x4e5e, 0x4e79, 0x4e96, 0x4eb3, 0x4ecf, 0x4eeb,
	0x4f09, 0x4f26, 0x4f43, 0x4f5e, 0x4f71, 0x4f84, 0x4f99, 0x4fad,
	0x4fc1, 0x4fd4, 0x4fe9, 0x4ffe, 0x5012, 0x5026, 0x503d, 0x5054,
	0x506d, 0x5086, 0x509e, 0x50b6, 0x50d0, 0x50e9, 0x5102, 0x5119,
	0x513b, 0x515d, 0x517f, 0x51a1, 0x51c3, 0x51e5, 0x5207, 0x5229,
	0x524b, 0x526d, 0x528f, 0x52b1, 0x52d3, 0x52f5, 0x5317, 0x5339,
	0x535b, 0x537d, 0x539f, 0x53c1, 0x53e3, 0x5405, 0x5427, 0x5449,
	// Entry 2100 - 213F
	0x546b, 0x548d, 0x54ab, 0x54c9, 0x54e7, 0x5505, 0x5523, 0x5541,
	0x555f, 0x557d, 0x559b, 0x55b9, 0x55d7, 0x55f5, 0x5613, 0x5631,
	0x564f, 0x566d, 0x568b, 0x56a9, 0x56c7, 0x56e5, 0x5703, 0x5721,
	0x573f, 0x575d, 0x577b, 0x5799, 0x57b5, 0x57d1, 0x57ed, 0x5809,
	0x5825, 0x5841, 0x585d, 0x5879, 0x5895, 0x58b1, 0x58cd, 0x58e9,
	0x5905, 0x5921, 0x593d, 0x5959, 0x5975, 0x5991, 0x59ad, 0x59c9,
	0x59e5, 0x5a01, 0x5a1d, 0x5a39, 0x5a55, 0x5a71, 0x5a83, 0x5aa1,
	0x5abf, 0x5adf, 0x5aff, 0x5b1e, 0x5b3d, 0x5b5e, 0x5b7e, 0x5b9e,
	// Entry 2140 - 217F
	0x5bbc, 0x5bd4, 0x5bec, 0x5c06, 0x5c1f, 0x5c38, 0x5c50, 0x5c6a,
	0x5c84, 0x5c9d, 0x5cb6, 0x5cd1, 0x5cee, 0x5d0b, 0x5d26, 0x5d41,
	0x5d6a, 0x5d93, 0x5dba, 0x5de1, 0x5e0d, 0x5e39, 0x5e63, 0x5e8d,
	0x5eae, 0x5ed5, 0x5efc, 0x5f1d, 0x5f3d, 0x5f63, 0x5f89, 0x5fa9,
	0x5fc8, 0x5fed, 0x6012, 0x6031, 0x604f, 0x6073, 0x6097, 0x60b5,
	0x60da, 0x6105, 0x612f, 0x6159, 0x6184, 0x61ae, 0x61d8, 0x61fd,
	0x6221, 0x624b, 0x6274, 0x629d, 0x62c7, 0x62f0, 0x6319, 0x633d,
	0x6363, 0x638f, 0x63bb, 0x63e7, 0x6413, 0x643f, 0x646b, 0x6491,
	// Entry 2180 - 21BF
	0x64b5, 0x64df, 0x6509, 0x6533, 0x655d, 0x6587, 0x65b1, 0x65d5,
	0x65ff, 0x662f, 0x665f, 0x668f, 0x66be, 0x66ed, 0x671d, 0x674c,
	0x677b, 0x67aa, 0x67d9, 0x6808, 0x6837, 0x6867, 0x6897, 0x68c1,
	0x68ea, 0x6913, 0x693a, 0x6961, 0x697f, 0x699b, 0x69c4, 0x69ed,
	0x6a0f, 0x6a37, 0x6a5f, 0x6a80, 0x6aa7, 0x6ace, 0x6aee, 0x6b14,
	0x6b3a, 0x6b59, 0x6b86, 0x6bb3, 0x6bd9, 0x6c05, 0x6c31, 0x6c56,
	0x6c84, 0x6cb2, 0x6cd9, 0x6d05, 0x6d31, 0x6d56, 0x6d88, 0x6dba,
	0x6de5, 0x6e0a, 0x6e2e, 0x6e50, 0x6e73, 0x6ea8, 0x6edd, 0x6efe,
	// Entry 21C0 - 21FF
	0x6f15, 0x6f2a, 0x6f42, 0x6f59, 0x6f70, 0x6f85, 0x6f9d, 0x6fb4,
	0x6fdb, 0x6fff, 0x7026, 0x704a, 0x705a, 0x7070, 0x7087, 0x70a0,
	0x70b0, 0x70c8, 0x70e2, 0x70fb, 0x7105, 0x711d, 0x7136, 0x714d,
	0x715c, 0x7174, 0x718a, 0x719f, 0x71af, 0x71ba, 0x71c6, 0x71d0,
	0x71e6, 0x71fc, 0x720f, 0x7223, 0x7236, 0x7268, 0x728b, 0x72bd,
	0x72f0, 0x7304, 0x7327, 0x735a, 0x7366, 0x7372, 0x7393, 0x73bd,
	0x73d8, 0x73f1, 0x7417, 0x7441, 0x746b, 0x748f, 0x74a1, 0x74b3,
	0x74c2, 0x74d1, 0x74e9, 0x7501, 0x7514, 0x7527, 0x7541, 0x755b,
	// Entry 2200 - 223F
	0x757b, 0x759b, 0x75b8, 0x75d5, 0x75f8, 0x761b, 0x7637, 0x7653,
	0x766f, 0x768b, 0x76ad, 0x76cf, 0x76eb, 0x7707, 0x7729, 0x774b,
	0x7766, 0x7781, 0x778e, 0x779b, 0x77c7, 0x77ce, 0x77d5, 0x77e1,
	0x77ee, 0x7807, 0x780f, 0x781b, 0x7836, 0x7852, 0x786e, 0x788a,
	0x78b0, 0x78dd, 0x78f3, 0x790a, 0x7918, 0x792c, 0x794b, 0x796a,
	0x798a, 0x79ab, 0x79cc, 0x79ec, 0x79fd, 0x7a0e, 0x7a28, 0x7a41,
	0x7a5a, 0x7a74, 0x7a80, 0x7a9b, 0x7ab7, 0x7ae1, 0x7b0c, 0x7b35,
	0x7b58, 0x7b81, 0x7bab, 0x7bb7, 0x7bdc, 0x7c01, 0x7c27, 0x7c4d,
	// Entry 2240 - 227F
	0x7c72, 0x7c97, 0x7cbd, 0x7ce3, 0x7cf6, 0x7d0a, 0x7d1d, 0x7d30,
	0x7d43, 0x7d5c, 0x7d75, 0x7d89, 0x7d9c, 0x7da1, 0x7da9, 0x7db0,
	0x7db5, 0x7dbf, 0x7dc9, 0x7dd2, 0x7dde, 0x7de1, 0x7def, 0x7dfe,
	0x7e09, 0x7e13, 0x7e22, 0x7e31, 0x7e3b, 0x7e50, 0x7e61, 0x7e68,
	0x7e80, 0x7e8c, 0x7e9d, 0x7eae, 0x7eb6, 0x7eda, 0x7ef3, 0x7f0d,
	0x7f26, 0x7f3d, 0x7f57, 0x7f70, 0x7f84, 0x7f90, 0x7fa0, 0x7fae,
	0x7fb6, 0x7fba, 0x7fc8, 0x7fcf, 0x7fe0, 0x7ff2, 0x8003, 0x800f,
	0x8019, 0x802a, 0x8036, 0x803e, 0x8050, 0x8060, 0x8070, 0x8083,
	// Entry 2280 - 22BF
	0x8093, 0x80a4, 0x80b8, 0x80c9, 0x80d8, 0x80eb, 0x80fd, 0x810f,
	0x8122, 0x8134, 0x8145, 0x814c, 0x8157, 0x815c, 0x8165, 0x816c,
	0x8172, 0x8178, 0x817f, 0x8184, 0x8189, 0x818f, 0x8195, 0x819b,
	0x819e, 0x81a3, 0x81a8, 0x81b0, 0x81bb, 0x81c4, 0x81cc, 0x81d2,
	0x81e2, 0x81f3, 0x8203, 0x8215, 0x8227, 0x8237, 0x8247, 0x8258,
	0x8268, 0x827a, 0x828c, 0x829c, 0x82ac, 0x82bc, 0x82ce, 0x82dd,
	0x82ed, 0x82fd, 0x830f, 0x831e, 0x8329, 0x8335, 0x8340, 0x8353,
	0x8369, 0x8378, 0x838a, 0x839a, 0x83ab, 0x83bc, 0x83d6, 0x83fa,
	// Entry 22C0 - 22FF
	0x841e, 0x8442, 0x8466, 0x848a, 0x84ae, 0x84d2, 0x84f8, 0x8518,
	0x852d, 0x854c, 0x8560, 0x8571, 0x857b, 0x8585, 0x858f, 0x8599,
	0x85a3, 0x85ad, 0x85c8, 0x85e2, 0x8603, 0x8623, 0x8634, 0x8644,
	0x865b, 0x8670, 0x8686, 0x869c, 0x86a6, 0x86b0, 0x86bf, 0x86c5,
	0x86d3, 0x86e7, 0x86ed, 0x86f4, 0x86fa, 0x86fe, 0x870d, 0x8718,
	0x8724, 0x8737, 0x8753, 0x876e, 0x877a, 0x878b, 0x879e, 0x87af,
	0x87cf, 0x87e3, 0x87f8, 0x8821, 0x883f, 0x885f, 0x8872, 0x8885,
	0x889e, 0x88ad, 0x88bb, 0x88d7, 0x88dd, 0x88e8, 0x88ee, 0x88f3,
	// Entry 2300 - 233F
	0x88f9, 0x88fd, 0x8902, 0x8908, 0x8919, 0x8920, 0x892b, 0x8933,
	0x8941, 0x894c, 0x8954, 0x895f, 0x8971, 0x8984, 0x8996, 0x89a9,
	0x89bd, 0x89cd, 0x89d1, 0x89de, 0x89f4, 0x8a0c, 0x8a24, 0x8a3b,
	0x8a49, 0x8a55, 0x8a5e, 0x8a62, 0x8a6d, 0x8a84, 0x8a9a, 0x8aa0,
	0x8aa8, 0x8aca, 0x8ae8, 0x8b06, 0x8b1b, 0x8b30, 0x8b3f, 0x8b61,
	0x8b72, 0x8b81, 0x8bb1, 0x8bbc, 0x8bd3, 0x8bea, 0x8c08, 0x8c33,
	0x8c3c, 0x8c5d, 0x8c7d, 0x8c8f, 0x8ca4, 0x8cb1, 0x8cb7, 0x8cbd,
	0x8cca, 0x8cda, 0x8ceb, 0x8d04, 0x8d0c, 0x8d1e, 0x8d26, 0x8d32,
	// Entry 2340 - 237F
	0x8d37, 0x8d3f, 0x8d52, 0x8d57, 0x8d60, 0x8d70, 0x8d74, 0x8d88,
	0x8da2, 0x8dab, 0x8dbe, 0x8dec, 0x8e01, 0x8e15, 0x8e23, 0x8e37,
	0x8e45, 0x8e5b, 0x8e72, 0x8e7c, 0x8e84, 0x8e8c, 0x8e97, 0x8ea2,
	0x8eae, 0x8eba, 0x8ecc, 0x8ed2, 0x8ee4, 0x8eed, 0x8ef6, 0x8f00,
	0x8f10, 0x8f20, 0x8f36, 0x8f3e, 0x8f4c, 0x8f60, 0x8f71, 0x8f82,
	0x8f99, 0x8fa4, 0x8fbe, 0x8fd2, 0x8fdf, 0x8fec, 0x9009, 0x9025,
	0x9047, 0x9060, 0x9077, 0x908e, 0x9096, 0x90b0, 0x90c2, 0x90d8,
	0x90ef, 0x9102, 0x911b, 0x9128, 0x913b, 0x9149, 0x915d, 0x9172,
	// Entry 2380 - 23BF
	0x918a, 0x91a5, 0x91bb, 0x91df, 0x9209, 0x9222, 0x923a, 0x9252,
	0x9276, 0x9294, 0x92b9, 0x92c7, 0x92d5, 0x92fb, 0x9321, 0x9348,
	0x9351, 0x936b, 0x9382, 0x9389, 0x9396, 0x93ad, 0x93d5, 0x9403,
	0x940d, 0x9422, 0x943d, 0x9463, 0x9489, 0x94aa, 0x94cb, 0x94e7,
	0x9503, 0x9522, 0x953d, 0x955a, 0x956c, 0x957f, 0x9591, 0x95c2,
	0x95ec, 0x961d, 0x9647, 0x9675, 0x96a3, 0x96c6, 0x96e5, 0x970a,
	0x971b, 0x973b, 0x9747, 0x9762, 0x9782, 0x97a3, 0x97cd, 0x97f8,
	0x9823, 0x984f, 0x9880, 0x98b2, 0x98dc, 0x9907, 0x9931, 0x995c,
	// Entry 23C0 - 23FF
	0x997e, 0x99a1, 0x99c3, 0x99e5, 0x9a09, 0x9a2c, 0x9a4f, 0x9a71,
	0x9a95, 0x9ab9, 0x9adc, 0x9aff, 0x9b23, 0x9b47, 0x9b6d, 0x9b92,
	0x9bb7, 0x9bdb, 0x9c01, 0x9c27, 0x9c4c, 0x9c71, 0x9c9e, 0x9ccb,
	0x9cfa, 0x9d28, 0x9d56, 0x9d83, 0x9db2, 0x9de1, 0x9e0f, 0x9e3d,
	0x9e5f, 0x9e6e, 0x9e7e, 0x9e91, 0x9ea7, 0x9ebd, 0x9ed3, 0x9ef2,
	0x9f15, 0x9f35, 0x9f5b, 0x9f82, 0x9faf, 0x9fc5, 0x9fed, 0xa018,
	0xa032, 0xa063, 0xa092, 0xa0ae, 0xa0da, 0xa0fd, 0xa11f, 0xa14a,
	0xa176, 0xa1a7, 0xa1d8, 0xa20b, 0xa215, 0xa248, 0xa26c, 0xa28c,
	// Entry 2400 - 243F
	0xa2ac, 0xa2cc, 0xa2ec, 0xa312, 0xa338, 0xa35e, 0xa37e, 0xa3a5,
	0xa3c2, 0xa3e5, 0xa403, 0xa414, 0xa42b, 0xa459, 0xa466, 0xa471,
	0xa47e, 0xa499, 0xa4b5, 0xa4c7, 0xa4e7, 0xa501, 0xa524, 0xa540,
	0xa54d, 0xa56a, 0xa57d, 0xa58f, 0xa5ad, 0xa5b9, 0xa5d3, 0xa5ee,
	0xa608, 0xa617, 0xa627, 0xa636, 0xa643, 0xa652, 0xa671, 0xa684,
	0xa691, 0xa6a0, 0xa6ae, 0xa6c7, 0xa6e9, 0xa704, 0xa733, 0xa763,
	0xa783, 0xa7a4, 0xa7ca, 0xa7f1, 0xa810, 0xa830, 0xa856, 0xa87d,
	0xa8ab, 0xa8da, 0xa901, 0xa929, 0xa940, 0xa959, 0xa97a, 0xa997,
	// Entry 2440 - 247F
	0xa9b4, 0xa9c8, 0xa9dd, 0xa9f2, 0xaa0d, 0xaa29, 0xaa45, 0xaa62,
	0xaa80, 0xaaa4, 0xaac9, 0xaae7, 0xaafc, 0xab12, 0xab28, 0xab3f,
	0xab55, 0xab6c, 0xab83, 0xab9b, 0xabb1, 0xabc8, 0xabdf, 0xabf7,
	0xac0e, 0xac26, 0xac3e, 0xac57, 0xac6d, 0xac84, 0xac9b, 0xacb3,
	0xacca, 0xace2, 0xacfa, 0xad13, 0xad2a, 0xad42, 0xad5a, 0xad73,
	0xad8b, 0xada4, 0xadbd, 0xadd7, 0xaded, 0xae04, 0xae1b, 0xae33,
	0xae4a, 0xae62, 0xae7a, 0xae93, 0xaeaa, 0xaec2, 0xaeda, 0xaef3,
	0xaf0b, 0xaf24, 0xaf3d, 0xaf57, 0xaf6e, 0xaf86, 0xaf9e, 0xafb7,
	// Entry 2480 - 24BF
	0xafcf, 0xafe8, 0xb001, 0xb01b, 0xb033, 0xb04c, 0xb065, 0xb07f,
	0xb098, 0xb0b2, 0xb0cc, 0xb0e7, 0xb0fd, 0xb114, 0xb12b, 0xb143,
	0xb15a, 0xb172, 0xb18a, 0xb1a3, 0xb1ba, 0xb1d2, 0xb1ea, 0xb203,
	0xb21b, 0xb234, 0xb24d, 0xb267, 0xb27e, 0xb296, 0xb2ae, 0xb2c7,
	0xb2df, 0xb2f8, 0xb311, 0xb32b, 0xb343, 0xb35c, 0xb375, 0xb38f,
	0xb3a8, 0xb3c2, 0xb3dc, 0xb3f7, 0xb40e, 0xb426, 0xb43e, 0xb457,
	0xb46f, 0xb488, 0xb4a1, 0xb4bb, 0xb4d3, 0xb4ec, 0xb505, 0xb51f,
	0xb538, 0xb552, 0xb56c, 0xb587, 0xb59f, 0xb5b8, 0xb5d1, 0xb5eb,
	// Entry 24C0 - 24FF
	0xb604, 0xb61e, 0xb638, 0xb653, 0xb66c, 0xb686, 0xb6a0, 0xb6bb,
	0xb6d5, 0xb6f0, 0xb70b, 0xb727, 0xb73d, 0xb754, 0xb76b, 0xb783,
	0xb79a, 0xb7b2, 0xb7ca, 0xb7e3, 0xb7fa, 0xb812, 0xb82a, 0xb843,
	0xb85b, 0xb874, 0xb88d, 0xb8a7, 0xb8be, 0xb8d6, 0xb8ee, 0xb907,
	0xb91f, 0xb938, 0xb951, 0xb96b, 0xb983, 0xb99c, 0xb9b5, 0xb9cf,
	0xb9e8, 0xba02, 0xba1c, 0xba37, 0xba4e, 0xba66, 0xba7e, 0xba97,
	0xbaaf, 0xbac8, 0xbae1, 0xbafb, 0xbb13, 0xbb2c, 0xbb45, 0xbb5f,
	0xbb78, 0xbb92, 0xbbac, 0xbbc7, 0xbbdf, 0xbbf8, 0xbc11, 0xbc2b,
	// Entry 2500 - 253F
	0xbc44, 0xbc5e, 0xbc78, 0xbc93, 0xbcac, 0xbcc6, 0xbce0, 0xbcfb,
	0xbd15, 0xbd30, 0xbd4b, 0xbd67, 0xbd7e, 0xbd96, 0xbdae, 0xbdc7,
	0xbddf, 0xbdf8, 0xbe11, 0xbe2b, 0xbe43, 0xbe5c, 0xbe75, 0xbe8f,
	0xbea8, 0xbec2, 0xbedc, 0xbef7, 0xbf0f, 0xbf28, 0xbf41, 0xbf5b,
	0xbf74, 0xbf8e, 0xbfa8, 0xbfc3, 0xbfdc, 0xbff6, 0xc010, 0xc02b,
	0xc045, 0xc060, 0xc07b, 0xc097, 0xc0af, 0xc0c8, 0xc0e1, 0xc0fb,
	0xc114, 0xc12e, 0xc148, 0xc163, 0xc17c, 0xc196, 0xc1b0, 0xc1cb,
	0xc1e5, 0xc200, 0xc21b, 0xc237, 0xc250, 0xc26a, 0xc284, 0xc29f,
	// Entry 2540 - 257F
	0xc2b9, 0xc2d4, 0xc2ef, 0xc30b, 0xc325, 0xc340, 0xc35b, 0xc377,
	0xc392, 0xc3ae, 0xc3ca, 0xc3e7, 0xc417, 0xc44e, 0xc479, 0xc4a5,
	0xc4d1, 0xc4f5, 0xc514, 0xc534, 0xc55a, 0xc57e, 0xc592, 0xc5a8,
	0xc5c3, 0xc5df, 0xc5fa, 0xc616, 0xc63d, 0xc65e, 0xc672, 0xc688,
	0xc6b7, 0xc6ed, 0xc712, 0xc74c, 0xc78d, 0xc7a1, 0xc7b6, 0xc7d1,
	0xc7ed, 0xc80d, 0xc82e, 0xc857, 0xc881, 0xc8a0, 0xc8bf, 0xc8d9,
	0xc8f3, 0xc90d, 0xc927, 0xc94c, 0xc971, 0xc996, 0xc9bb, 0xc9e4,
	0xca0d, 0xca37, 0xca61, 0xca8b, 0xcab4, 0xcade, 0xcb08, 0xcb2a,
	// Entry 2580 - 25BF
	0xcb58, 0xcb88, 0xcbb7, 0xcbe7, 0xcc05, 0xcc26, 0xcc41, 0xcc5f,
	0xcc81, 0xcca6, 0xccce, 0xccf9, 0xcd1a, 0xcd37, 0xcd63, 0xcd8f,
	0xcdbb, 0xcddb, 0xcdfa, 0xce14, 0xce39, 0xce63, 0xce87, 0xceab,
	0xcecf, 0xcef3, 0xcf15, 0xcf3a, 0xcf60, 0xcf83, 0xcfa8, 0xcfce,
	0xcff4, 0xd01c, 0xd043, 0xd06b, 0xd090, 0xd0b7, 0xd0de, 0xd106,
	0xd12e, 0xd158, 0xd181, 0xd1ab, 0xd1d2, 0xd1fb, 0xd240, 0xd285,
	0xd2cc, 0xd315, 0xd359, 0xd3a1, 0xd3e5, 0xd42d, 0xd45b, 0xd48b,
	0xd4ba, 0xd4eb, 0xd532, 0xd579, 0xd59d, 0xd5bf, 0xd5e4, 0xd608,
	// Entry 25C0 - 25FF
	0xd62d, 0xd653, 0xd672, 0xd693, 0xd6b6, 0xd6d3, 0xd6f1, 0xd70f,
	0xd71d, 0xd72c, 0xd738, 0xd746, 0xd763, 0xd772, 0xd787, 0xd79f,
	0xd7b8, 0xd7ce, 0xd7e5, 0xd802, 0xd820, 0xd83f, 0xd85f, 0xd880,
	0xd8a2, 0xd8cd, 0xd8fc, 0xd92a, 0xd956, 0xd971, 0xd98d, 0xd9a7,
	0xd9c5, 0xd9e9, 0xda0b, 0xda2c, 0xda4e, 0xda5a, 0xda6e, 0xda89,
	0xdaa8, 0xdac5, 0xdad8, 0xdae3, 0xdaff, 0xdb19, 0xdb25, 0xdb33,
	0xdb46, 0xdb62, 0xdb7a, 0xdb94, 0xdbd6, 0xdc17, 0xdc5b, 0xdc9e,
	0xdce0, 0xdd21, 0xdd65, 0xdda8, 0xddba, 0xddd0, 0xddf1, 0xde11,
	// Entry 2600 - 263F
	0xde30, 0xde4a, 0xde5e, 0xde6e, 0xde85, 0xde9a, 0xdedf, 0xdef9,
	0xdf24, 0xdf3b, 0xdf4f, 0xdf5d, 0xdf6e, 0xdf82, 0xdfa7, 0xdfd6,
	0xdff3, 0xe011, 0xe021, 0xe035, 0xe043, 0xe055, 0xe06c, 0xe082,
	0xe08f, 0xe0ad, 0xe0cf, 0xe0f0, 0xe112, 0xe12d, 0xe149, 0xe155,
	0xe16f, 0xe18a, 0xe199, 0xe1a8, 0xe1b9, 0xe1cb, 0xe1e3, 0xe1fc,
	0xe20f, 0xe220, 0xe242, 0xe257, 0xe274, 0xe280, 0xe28f, 0xe2af,
	0xe2e0, 0xe301, 0xe30d, 0xe31a, 0xe345, 0xe371, 0xe38e, 0xe39b,
	0xe3b7, 0xe3d3, 0xe3ec, 0xe405, 0xe41f, 0xe439, 0xe452, 0xe46b,
	// Entry 2640 - 267F
	0xe477, 0xe48f, 0xe4a3, 0xe4c9, 0xe4d4, 0xe4e7, 0xe4f2, 0xe4fd,
	0xe51f, 0xe542, 0xe546, 0xe54a, 0xe564, 0xe57f, 0xe59b, 0xe5b8,
	0xe5d6, 0xe5f8, 0xe613, 0xe62b, 0xe642, 0xe656, 0xe664, 0xe67b,
	0xe696, 0xe6aa, 0xe6c5, 0xe6e0, 0xe6f4, 0xe70d, 0xe73f, 0xe772,
	0xe799, 0xe7b9, 0xe7d5, 0xe7fc, 0xe814, 0xe82e, 0xe841, 0xe856,
	0xe86c, 0xe870, 0xe88c, 0xe8a9, 0xe8c1, 0xe8dd, 0xe8fe, 0xe924,
	0xe93e, 0xe956, 0xe970, 0xe98c, 0xe9a9, 0xe9c4, 0xe9dd, 0xe9f9,
	0xea14, 0xea31, 0xea4f, 0xea66, 0xea88, 0xeaa9, 0xeace, 0xeadb,
	// Entry 2680 - 26BF
	0xeb02, 0xeb2a, 0xeb5c, 0xeb80, 0xeb95, 0xebaa, 0xebc0, 0xebdf,
	0xebef, 0xec09, 0xec2a, 0xec43, 0xec58, 0xec6d, 0xec7f, 0xec98,
	0xecb5, 0xecca, 0xece2, 0xecfa, 0xed1c, 0xed3e, 0xed60, 0xed90,
	0xeda8, 0xedc7, 0xede1, 0xedf4, 0xee1e, 0xee38, 0xee51, 0xee63,
	0xee74, 0xee90, 0xeeab, 0xeebb, 0xeecc, 0xeeee, 0xef0a, 0xef25,
	0xef45, 0xef64, 0xef83, 0xef9c, 0xefbc, 0xefd3, 0xeff1, 0xf010,
	0xf031, 0xf051, 0xf06b, 0xf083, 0xf0b4, 0xf0e5, 0xf102, 0xf121,
	0xf136, 0xf14e, 0xf162, 0xf188, 0xf1a7, 0xf1c2, 0xf1dd, 0xf1fd,
	// Entry 26C0 - 26FF
	0xf20f, 0xf22b, 0xf249, 0xf27b, 0xf29a, 0xf2b6, 0xf2d5, 0xf2f7,
	0xf31c, 0xf339, 0xf359, 0xf386, 0xf3b6, 0xf3e2, 0xf411, 0xf443,
	0xf477, 0xf48f, 0xf4aa, 0xf4d0, 0xf4f9, 0xf516, 0xf536, 0xf56a,
	0xf59e, 0xf5be, 0xf5e1, 0xf60b, 0xf635, 0xf669, 0xf69d, 0xf6e1,
	0xf725, 0xf742, 0xf762, 0xf78f, 0xf7bf, 0xf7e0, 0xf804, 0xf82d,
	0xf859, 0xf86d, 0xf884, 0xf8ad, 0xf8d9, 0xf8f0, 0xf90a, 0xf92f,
	0xf951, 0xf96e, 0xf987, 0xf9a3, 0xf9d0, 0xfa00, 0xfa0c, 0xfa17,
	0xfa2f, 0xfa46, 0xfa62, 0xfa88, 0xfaae, 0xfad5, 0xfafc, 0xfb16,
	// Entry 2700 - 273F
	0xfb30, 0xfb4b, 0xfb66, 0xfb84, 0xfba2, 0xfbc4, 0xfbe6, 0xfbf5,
	0xfc04, 0xfc13, 0xfc24, 0xfc3f, 0xfc5c, 0xfc81, 0xfca8, 0xfccc,
	0xfcf2, 0xfd0d, 0xfd2a, 0xfd48, 0xfd68, 0xfd87, 0xfda8, 0xfdc4,
	0xfde2, 0xfdff, 0xfe1d, 0xfe2a, 0xfe39, 0xfe52, 0xfe6d, 0xfe82,
	0xfe97, 0xfeaa, 0xfec1, 0xfed7, 0xff05, 0xff21, 0xff37, 0xff4f,
	0xff56, 0xff60, 0xff6f, 0xff7e, 0xff8b, 0xff9f, 0xffc2, 0xffe4,
	0x0006, 0x002f, 0x005c, 0x0078, 0x0093, 0x00b6, 0x00c6, 0x00d4,
	0x00ea, 0x0109, 0x0135, 0x0154, 0x0173, 0x018e, 0x01ad, 0x01c9,
	// Entry 2740 - 277F
	0x01ec, 0x0216, 0x022b, 0x0242, 0x025c, 0x0285, 0x02b1, 0x02cf,
	0x02f1, 0x0308, 0x031a, 0x0332, 0x0348, 0x035e, 0x0374, 0x038a,
	0x03a0, 0x03b5, 0x03c8, 0x03dd, 0x03f3, 0x0409, 0x041f, 0x0435,
	0x044b, 0x045e, 0x0481, 0x04a2, 0x04c4, 0x04e4, 0x04fe, 0x051b,
	0x0546, 0x0570, 0x058c, 0x05a9, 0x05c4, 0x05e2, 0x05ef, 0x0601,
	0x0613, 0x062a, 0x0641, 0x064f, 0x065d, 0x066a, 0x0677, 0x068f,
	0x06a1, 0x06b5, 0x06c9, 0x06dd, 0x06f1, 0x0704, 0x0717, 0x072a,
	0x0742, 0x075a, 0x0770, 0x0786, 0x07a2, 0x07b8, 0x07d4, 0x07f1,
	// Entry 2780 - 27BF
	0x0820, 0x0856, 0x0879, 0x089f, 0x08bf, 0x08ed, 0x0922, 0x0946,
	0x097f, 0x09bf, 0x09d8, 0x09f9, 0x0a1a, 0x0a46, 0x0a73, 0x0a98,
	0x0ab9, 0x0ad2, 0x0aec, 0x0b19, 0x0b47, 0x0b6b, 0x0b90, 0x0bbc,
	0x0be9, 0x0c0f, 0x0c28, 0x0c45, 0x0c56, 0x0c66, 0x0c76, 0x0c93,
	0x0cb0, 0x0cc2, 0x0cdd, 0x0cfc, 0x0d08, 0x0d1d, 0x0d41, 0x0d69,
	0x0d91, 0x0dbd, 0x0dea, 0x0e1d, 0x0e3c, 0x0e59, 0x0e79, 0x0e98,
	0x0eb8, 0x0ed5, 0x0ef5, 0x0f15, 0x0f35, 0x0f55, 0x0f7b, 0x0f9f,
	0x0fc6, 0x0fec, 0x1017, 0x1046, 0x106c, 0x1090, 0x10b7, 0x10dd,
	// Entry 27C0 - 27FF
	0x1104, 0x112b, 0x1152, 0x1179, 0x11b6, 0x11f1, 0x122f, 0x126c,
	0x127e, 0x128e, 0x12d3, 0x131d, 0x1362, 0x13ac, 0x13d3, 0x13f8,
	0x1420, 0x1447, 0x146a, 0x148b, 0x14af, 0x14d2, 0x1504, 0x1537,
	0x1568, 0x1598, 0x15a3, 0x15af, 0x15bb, 0x15c8, 0x15f1, 0x1607,
	0x1626, 0x1643, 0x1676, 0x16a9, 0x16dd, 0x1711, 0x1736, 0x1759,
	0x177f, 0x17a4, 0x17db, 0x1813, 0x1848, 0x187e, 0x18b3, 0x18e9,
	0x1920, 0x1958, 0x1982, 0x19ad, 0x19d5, 0x19fe, 0x1a26, 0x1a4f,
	0x1a79, 0x1aa4, 0x1aba, 0x1ad1, 0x1ae5, 0x1afa, 0x1b0e, 0x1b23,
	// Entry 2800 - 283F
	0x1b39, 0x1b50, 0x1b80, 0x1b9f, 0x1bb8, 0x1bdb, 0x1bf4, 0x1c0b,
	0x1c14, 0x1c22, 0x1c36, 0x1c4b, 0x1c60, 0x1c78, 0x1c85, 0x1cae,
	0x1cd9, 0x1d04, 0x1d30, 0x1d40, 0x1d55, 0x1d6d, 0x1d8a, 0x1daf,
	0x1dc6, 0x1de5, 0x1dfe, 0x1e0e, 0x1e18, 0x1e26, 0x1e36, 0x1e45,
	0x1e54, 0x1e5e, 0x1e68, 0x1e6f, 0x1e75, 0x1e7b, 0x1e81, 0x1e92,
	0x1ea8, 0x1ebc, 0x1ec2, 0x1ec7, 0x1ecb, 0x1ed1, 0x1ed8, 0x1edf,
	0x1ee7, 0x1eef, 0x1f03, 0x1f18, 0x1f31, 0x1f4b, 0x1f7e, 0x1faf,
	0x1fe3, 0x2016, 0x2023, 0x2030, 0x2035, 0x205a, 0x207c, 0x20a0,
	// Entry 2840 - 287F
	0x20c4, 0x20e8, 0x210d, 0x212c, 0x2139, 0x2149, 0x2157, 0x2164,
	0x2178, 0x2192, 0x21af, 0x21cd, 0x21eb, 0x220c, 0x222b, 0x224a,
	0x226b, 0x228a, 0x22aa, 0x22c8, 0x22ee, 0x2309, 0x2329, 0x2347,
	0x2368, 0x2389, 0x23a8, 0x23c5, 0x23e5, 0x2404, 0x2423, 0x2443,
	0x2460, 0x247f, 0x249d, 0x24ba, 0x24d6, 0x24f4, 0x2511, 0x2531,
	0x254e, 0x256c, 0x258a, 0x25a8, 0x25cc, 0x25e8, 0x260b, 0x2638,
	0x2654, 0x267f, 0x26a0, 0x26c9, 0x26e7, 0x2708, 0x2729, 0x274f,
	0x2779, 0x27a1, 0x27bc, 0x27d8, 0x27f4, 0x2813, 0x2830, 0x284d,
	// Entry 2880 - 28BF
	0x286c, 0x2889, 0x28a7, 0x28c3, 0x28e7, 0x2900, 0x291e, 0x293a,
	0x2959, 0x2978, 0x2995, 0x29b0, 0x29ce, 0x29eb, 0x2a08, 0x2a26,
	0x2a41, 0x2a5e, 0x2a7a, 0x2a95, 0x2aaf, 0x2acb, 0x2ae6, 0x2b04,
	0x2b1f, 0x2b3b, 0x2b57, 0x2b73, 0x2b95, 0x2baf, 0x2bd0, 0x2bfb,
	0x2c15, 0x2c3e, 0x2c5d, 0x2c84, 0x2ca0, 0x2cbf, 0x2cde, 0x2d02,
	0x2d2a, 0x2d50, 0x2d76, 0x2d9a, 0x2dc2, 0x2de4, 0x2e04, 0x2e24,
	0x2e4d, 0x2e72, 0x2e95, 0x2eba, 0x2edd, 0x2f02, 0x2f25, 0x2f3f,
	0x2f5f, 0x2f7c, 0x2f9d, 0x2fc1, 0x2fe1, 0x2fff, 0x301d, 0x3038,
	// Entry 28C0 - 28FF
	0x3051, 0x3070, 0x308f, 0x30b4, 0x30dd, 0x3100, 0x311e, 0x3137,
	0x315d, 0x3183, 0x319d, 0x31b5, 0x31cf, 0x31e7, 0x3202, 0x321b,
	0x3236, 0x324f, 0x3268, 0x327f, 0x3298, 0x32af, 0x32c9, 0x32e1,
	0x32fb, 0x3313, 0x332f, 0x3349, 0x3364, 0x337d, 0x3397, 0x33af,
	0x33ca, 0x33e3, 0x33fb, 0x3411, 0x3429, 0x343f, 0x3458, 0x346f,
	0x3486, 0x349b, 0x34b3, 0x34c9, 0x34e1, 0x34f7, 0x3511, 0x3529,
	0x3542, 0x3559, 0x3571, 0x3587, 0x359f, 0x35b5, 0x35ce, 0x35e5,
	0x35fe, 0x3615, 0x362e, 0x3645, 0x3669, 0x368b, 0x36af, 0x36d1,
	// Entry 2900 - 293F
	0x36f8, 0x371d, 0x3741, 0x3763, 0x3785, 0x37a5, 0x37cb, 0x37ef,
	0x3813, 0x3835, 0x3850, 0x3869, 0x388b, 0x38ab, 0x38d0, 0x38f3,
	0x3917, 0x3939, 0x395c, 0x397d, 0x39a1, 0x39c3, 0x39e8, 0x3a0b,
	0x3a2e, 0x3a4f, 0x3a70, 0x3a8f, 0x3ab3, 0x3ad5, 0x3af9, 0x3b1b,
	0x3b42, 0x3b67, 0x3b8b, 0x3bad, 0x3bd3, 0x3bf7, 0x3c1d, 0x3c41,
	0x3c65, 0x3c87, 0x3cab, 0x3ccd, 0x3cf1, 0x3d13, 0x3d24, 0x3d37,
	0x3d4a, 0x3d5f, 0x3d73, 0x3d87, 0x3d9f, 0x3dc7, 0x3ded, 0x3e17,
	0x3e3f, 0x3e58, 0x3e77, 0x3e96, 0x3eb9, 0x3eda, 0x3ef5, 0x3f1b,
	// Entry 2940 - 297F
	0x3f43, 0x3f62, 0x3f7a, 0x3f8a, 0x3fa6, 0x3fbe, 0x3fd7, 0x3ff0,
	0x4009, 0x4021, 0x403a, 0x4053, 0x406c, 0x4084, 0x409d, 0x40b6,
	0x40cf, 0x40e8, 0x4100, 0x4119, 0x4133, 0x414c, 0x4165, 0x417e,
	0x4196, 0x41b0, 0x41ca, 0x41e4, 0x41fd, 0x4217, 0x4231, 0x424a,
	0x4263, 0x427c, 0x4296, 0x42af, 0x42c9, 0x42e2, 0x42fa, 0x4313,
	0x432b, 0x4344, 0x435d, 0x4375, 0x438e, 0x43a0, 0x43b3, 0x43c7,
	0x43da, 0x43ef, 0x4411, 0x4424, 0x4437, 0x444b, 0x445f, 0x4474,
	0x4487, 0x449a, 0x44ad, 0x44c7, 0x44dc, 0x44ef, 0x4511, 0x452b,
	// Entry 2980 - 29BF
	0x453f, 0x4552, 0x4566, 0x4581, 0x4594, 0x45ae, 0x45c0, 0x45d4,
	0x45f0, 0x460b, 0x461e, 0x4631, 0x4644, 0x465f, 0x467a, 0x468d,
	0x469f, 0x46b2, 0x46c6, 0x46da, 0x46f5, 0x470e, 0x4721, 0x4735,
	0x4749, 0x475c, 0x4770, 0x4784, 0x4798, 0x47ab, 0x47be, 0x47d1,
	0x47e4, 0x4802, 0x4816, 0x4828, 0x483a, 0x4865, 0x487c, 0x4895,
	0x48aa, 0x48bf, 0x48d4, 0x48e9, 0x48ff, 0x4914, 0x4929, 0x493e,
	0x4953, 0x4969, 0x4985, 0x499a, 0x49af, 0x49c5, 0x49da, 0x49f0,
	0x4a06, 0x4a1c, 0x4a31, 0x4a47, 0x4a5d, 0x4a74, 0x4a8a, 0x4a9f,
	// Entry 29C0 - 29FF
	0x4ab4, 0x4ac9, 0x4adf, 0x4af5, 0x4b0a, 0x4b1f, 0x4b34, 0x4b49,
	0x4b5e, 0x4b74, 0x4b8a, 0x4b9f, 0x4bb4, 0x4bc9, 0x4bde, 0x4bf3,
	0x4c09, 0x4c1f, 0x4c34, 0x4c49, 0x4c5f, 0x4c75, 0x4c8b, 0x4ca2,
	0x4cb9, 0x4ccf, 0x4ce5, 0x4cfa, 0x4d0f, 0x4d24, 0x4d3a, 0x4d50,
	0x4d65, 0x4d7a, 0x4d8f, 0x4da4, 0x4db9, 0x4dcf, 0x4de5, 0x4dfa,
	0x4e0f, 0x4e24, 0x4e39, 0x4e4e, 0x4e64, 0x4e7a, 0x4e8f, 0x4ea4,
	0x4eb9, 0x4ece, 0x4ee3, 0x4ef9, 0x4f0f, 0x4f24, 0x4f39, 0x4f55,
	0x4f71, 0x4f8e, 0x4faa, 0x4fc7, 0x4fe3, 0x4fff, 0x501b, 0x5037,
	// Entry 2A00 - 2A3F
	0x5053, 0x506e, 0x508a, 0x50a6, 0x50c2, 0x50de, 0x50fa, 0x5117,
	0x5134, 0x5151, 0x5170, 0x518e, 0x51ad, 0x51c8, 0x51e4, 0x5203,
	0x5229, 0x5246, 0x5262, 0x5286, 0x52aa, 0x52cb, 0x52f5, 0x5314,
	0x533a, 0x5353, 0x536d, 0x538d, 0x53ae, 0x53c9, 0x53eb, 0x5406,
	0x5420, 0x543b, 0x5448, 0x5464, 0x5481, 0x5492, 0x549d, 0x54af,
	0x54ca, 0x54d6, 0x54e3, 0x54f3, 0x5501, 0x551c, 0x5531, 0x5545,
	0x5550, 0x5565, 0x557a, 0x5595, 0x55b1, 0x55c5, 0x55d9, 0x55f5,
	0x5612, 0x5627, 0x563d, 0x5655, 0x566e, 0x5685, 0x569d, 0x56b4,
	// Entry 2A40 - 2A7F
	0x56cc, 0x56ed, 0x570e, 0x572a, 0x5737, 0x574d, 0x575b, 0x5765,
	0x577e, 0x578a, 0x5794, 0x57a0, 0x57b0, 0x57c6, 0x57dd, 0x57ea,
	0x57ff, 0x580a, 0x5817, 0x582d, 0x583e, 0x5852, 0x585b, 0x5868,
	0x5876, 0x589a, 0x58af, 0x58c5, 0x58d8, 0x58fd, 0x5907, 0x591a,
	0x592e, 0x593c, 0x5949, 0x5957, 0x5967, 0x597c, 0x5991, 0x59b0,
	0x59ce, 0x59e6, 0x59ff, 0x5a15, 0x5a34, 0x5a54, 0x5a7a, 0x5aa1,
	0x5aba, 0x5ad4, 0x5af0, 0x5b0d, 0x5b1b, 0x5b2d, 0x5b3e, 0x5b54,
	0x5b6a, 0x5b82, 0x5b94, 0x5ba3, 0x5bb4, 0x5bc9, 0x5bde, 0x5bf4,
	// Entry 2A80 - 2ABF
	0x5c04, 0x5c19, 0x5c2e, 0x5c42, 0x5c56, 0x5c6c, 0x5c81, 0x5c92,
	0x5ca4, 0x5cb9, 0x5cce, 0x5ce3, 0x5cf8, 0x5d08, 0x5d17, 0x5d28,
	0x5d37, 0x5d47, 0x5d58, 0x5d6a, 0x5d7e, 0x5d93, 0x5da8, 0x5db8,
	0x5dcb, 0x5dde, 0x5e04, 0x5e13, 0x5e22, 0x5e32, 0x5e4b, 0x5e5a,
	0x5e70, 0x5e86, 0x5e98, 0x5ea8, 0x5ec5, 0x5ed8, 0x5eeb, 0x5f00,
	0x5f14, 0x5f24, 0x5f35, 0x5f44, 0x5f53, 0x5f62, 0x5f77, 0x5f8c,
	0x5f9c, 0x5fae, 0x5fc3, 0x5fd8, 0x5fef, 0x6000, 0x6013, 0x6027,
	0x603b, 0x6057, 0x6072, 0x6082, 0x60a1, 0x60bf, 0x60cf, 0x60ec,
	// Entry 2AC0 - 2AFF
	0x6107, 0x611b, 0x612f, 0x613f, 0x615c, 0x6170, 0x6184, 0x61a1,
	0x61be, 0x61d3, 0x61e8, 0x61f8, 0x6208, 0x622f, 0x624c, 0x6269,
	0x6285, 0x6298, 0x62ab, 0x62c0, 0x62dc, 0x62ec, 0x630a, 0x631a,
	0x632b, 0x6348, 0x6365, 0x6382, 0x639e, 0x63bb, 0x63d8, 0x63f5,
	0x6412, 0x6430, 0x644e, 0x646d, 0x648c, 0x649e, 0x64bd, 0x64dc,
	0x64ee, 0x6501, 0x6513, 0x6527, 0x653c, 0x654f, 0x6561, 0x6573,
	0x6585, 0x6598, 0x65ac, 0x65c0, 0x65d7, 0x65eb, 0x65fd, 0x6611,
	0x6628, 0x663c, 0x6650, 0x6663, 0x6677, 0x6694, 0x66b3, 0x66c5,
	// Entry 2B00 - 2B3F
	0x66de, 0x66f1, 0x6705, 0x671b, 0x672f, 0x6743, 0x675b, 0x676f,
	0x6785, 0x6796, 0x67ae, 0x67c4, 0x67d6, 0x67ea, 0x67fe, 0x6811,
	0x6824, 0x6838, 0x684b, 0x6860, 0x6875, 0x688c, 0x68a0, 0x68b3,
	0x68c9, 0x68de, 0x68f0, 0x690b, 0x6926, 0x6940, 0x6958, 0x696c,
	0x697e, 0x6992, 0x69a8, 0x69bb, 0x69cf, 0x69e5, 0x69f8, 0x6a0b,
	0x6a20, 0x6a32, 0x6a47, 0x6a5c, 0x6a6e, 0x6a83, 0x6a95, 0x6aa7,
	0x6ab9, 0x6acc, 0x6adf, 0x6af2, 0x6b05, 0x6b19, 0x6b2e, 0x6b43,
	0x6b59, 0x6b6b, 0x6b7e, 0x6b92, 0x6ba6, 0x6bb9, 0x6bcc, 0x6be1,
	// Entry 2B40 - 2B7F
	0x6bf8, 0x6c16, 0x6c2a, 0x6c3d, 0x6c4f, 0x6c61, 0x6c78, 0x6c8b,
	0x6c9f, 0x6cb2, 0x6cc6, 0x6cd9, 0x6ceb, 0x6cff, 0x6d1b, 0x6d32,
	0x6d4c, 0x6d60, 0x6d73, 0x6d86, 0x6d98, 0x6dac, 0x6dc0, 0x6dd4,
	0x6de9, 0x6dfd, 0x6e11, 0x6e24, 0x6e38, 0x6e4d, 0x6e60, 0x6e73,
	0x6e85, 0x6e97, 0x6eab, 0x6ec1, 0x6ed3, 0x6ee5, 0x6ef8, 0x6f0a,
	0x6f1e, 0x6f31, 0x6f48, 0x6f5b, 0x6f70, 0x6f85, 0x6f9a, 0x6faf,
	0x6fc2, 0x6fd9, 0x6fed, 0x7001, 0x7015, 0x702a, 0x703e, 0x705b,
	0x7071, 0x7084, 0x7096, 0x70a9, 0x70be, 0x70d3, 0x70e6, 0x70f8,
	// Entry 2B80 - 2BBF
	0x710d, 0x7121, 0x7133, 0x7145, 0x7158, 0x716b, 0x717e, 0x7193,
	0x71a9, 0x71bc, 0x71cf, 0x71e2, 0x71fc, 0x7212, 0x7225, 0x7238,
	0x724b, 0x725f, 0x7273, 0x7293, 0x72a6, 0x72b9, 0x72cd, 0x72e0,
	0x72f6, 0x7313, 0x7326, 0x733a, 0x734d, 0x7360, 0x7372, 0x7384,
	0x7397, 0x73ae, 0x73c2, 0x73d5, 0x73e8, 0x73fb, 0x740f, 0x742e,
	0x7445, 0x7459, 0x746c, 0x747f, 0x7492, 0x74a5, 0x74b9, 0x74cc,
	0x74e1, 0x74f6, 0x750a, 0x7523, 0x7536, 0x754b, 0x755e, 0x7570,
	0x7583, 0x7596, 0x75aa, 0x75bf, 0x75d4, 0x75e8, 0x7617, 0x7647,
	// Entry 2BC0 - 2BFF
	0x7681, 0x76bc, 0x76eb, 0x7720, 0x7755, 0x7789, 0x77c3, 0x77fe,
	0x7838, 0x7862, 0x7897, 0x78d2, 0x7909, 0x7933, 0x7944, 0x7955,
	0x796a, 0x7974, 0x7997, 0x79b1, 0x79c9, 0x79e0, 0x79f2, 0x7a05,
	0x7a1e, 0x7a38, 0x7a4b, 0x7a5f, 0x7a78, 0x7a92, 0x7aaf, 0x7acd,
	0x7ad8, 0x7ae1, 0x7afc, 0x7b18, 0x7b35, 0x7b53, 0x7b74, 0x7b96,
	0x7baf, 0x7bc9, 0x7bd2, 0x7bf6, 0x7c11, 0x7c30, 0x7c40, 0x7c54,
	0x7c68, 0x7c7e, 0x7c93, 0x7ca8, 0x7cbc, 0x7cd2, 0x7ce8, 0x7cfd,
	0x7d18, 0x7d34, 0x7d53, 0x7d71, 0x7d8c, 0x7da7, 0x7db0, 0x7dc9,
	// Entry 2C00 - 2C3F
	0x7df4, 0x7e18, 0x7e4e, 0x7e72, 0x7e85, 0x7eb5, 0x7ec9, 0x7ee0,
	0x7ef7, 0x7f1a, 0x7f23, 0x7f38, 0x7f57, 0x7f72, 0x7f89, 0x7f9a,
	0x7fb1, 0x7fc2, 0x7fd9, 0x7fea, 0x8001, 0x8012, 0x8029, 0x803a,
	0x804c, 0x805e, 0x8070, 0x8082, 0x8094, 0x80a6, 0x80b8, 0x80ca,
	0x80dc, 0x80ee, 0x8100, 0x8112, 0x8124, 0x8136, 0x8148, 0x815a,
	0x816c, 0x817e, 0x8190, 0x81a2, 0x81b4, 0x81c6, 0x81d8, 0x81ea,
	0x8202, 0x8214, 0x8226, 0x8238, 0x824a, 0x825c, 0x826e, 0x8280,
	0x8292, 0x82a4, 0x82b6, 0x82c8, 0x82da, 0x82ec, 0x82fe, 0x8310,
	// Entry 2C40 - 2C7F
	0x8322, 0x8334, 0x8346, 0x8358, 0x836a, 0x837c, 0x838e, 0x83a0,
	0x83b2, 0x83c4, 0x83d6, 0x83e8, 0x83fa, 0x840c, 0x841e, 0x8430,
	0x8448, 0x845a, 0x8472, 0x8484, 0x849c, 0x84ae, 0x84c0, 0x84d2,
	0x84e4, 0x84f6, 0x8508, 0x8520, 0x8532, 0x8544, 0x8556, 0x8568,
	0x8579, 0x858b, 0x85a3, 0x85bb, 0x85e8, 0x861a, 0x863d, 0x8665,
	0x867c, 0x869a, 0x86af, 0x86ce, 0x86e5, 0x86f6, 0x870d, 0x871e,
	0x8735, 0x8746, 0x875d, 0x876e, 0x8785, 0x8796, 0x87a8, 0x87ba,
	0x87cc, 0x87de, 0x87f0, 0x8802, 0x8814, 0x8826, 0x8838, 0x884a,
	// Entry 2C80 - 2CBF
	0x885c, 0x886e, 0x8880, 0x8892, 0x88a4, 0x88b6, 0x88c8, 0x88da,
	0x88ec, 0x88fe, 0x8910, 0x8922, 0x8934, 0x8946, 0x895e, 0x8970,
	0x8982, 0x8994, 0x89a6, 0x89b8, 0x89ca, 0x89dc, 0x89ee, 0x8a00,
	0x8a12, 0x8a24, 0x8a36, 0x8a48, 0x8a5a, 0x8a6c, 0x8a7e, 0x8a90,
	0x8aa2, 0x8ab4, 0x8ac6, 0x8ad8, 0x8aea, 0x8afc, 0x8b0e, 0x8b20,
	0x8b32, 0x8b44, 0x8b56, 0x8b68, 0x8b7a, 0x8b8c, 0x8ba4, 0x8bb6,
	0x8bce, 0x8be0, 0x8bf8, 0x8c0a, 0x8c1c, 0x8c2e, 0x8c40, 0x8c52,
	0x8c64, 0x8c7c, 0x8c8e, 0x8ca0, 0x8cb2, 0x8cc4, 0x8cd5, 0x8ce7,
	// Entry 2CC0 - 2CFF
	0x8cff, 0x8d17, 0x8d29, 0x8d3b, 0x8d4d, 0x8d5f, 0x8d72, 0x8d98,
	0x8daf, 0x8dcd, 0x8de2, 0x8df3, 0x8e04, 0x8e15, 0x8e26, 0x8e37,
	0x8e48, 0x8e59, 0x8e6a, 0x8e7b, 0x8e8c, 0x8e9d, 0x8eae, 0x8ebf,
	0x8ed0, 0x8ee2, 0x8ef4, 0x8f06, 0x8f17, 0x8f28, 0x8f39, 0x8f4a,
	0x8f5b, 0x8f6c, 0x8f7d, 0x8f8f, 0x8fa1, 0x8fb3, 0x8fc5, 0x8fd7,
	0x8fe9, 0x8ffb, 0x900e, 0x9021, 0x9033, 0x9044, 0x9055, 0x9067,
	0x9078, 0x908a, 0x909c, 0x90ae, 0x90ce, 0x90e0, 0x90f4, 0x910d,
	0x9126, 0x9139, 0x9152, 0x916b, 0x917f, 0x9198, 0x91ab, 0x91c5,
	// Entry 2D00 - 2D3F
	0x91de, 0x91f7, 0x920f, 0x922a, 0x9245, 0x925e, 0x9271, 0x9284,
	0x929c, 0x92b4, 0x92c6, 0x92dd, 0x92f0, 0x9303, 0x931b, 0x9330,
	0x9345, 0x935a, 0x936f, 0x9382, 0x9391, 0x93a1, 0x93b1, 0x93c2,
	0x93d2, 0x93e1, 0x93f2, 0x9402, 0x9411, 0x9421, 0x9432, 0x9442,
	0x9452, 0x9461, 0x9472, 0x9482, 0x9492, 0x94a2, 0x94b2, 0x94c2,
	0x94d1, 0x94de, 0x94f6, 0x9510, 0x9528, 0x9543, 0x9562, 0x957c,
	0x959a, 0x95b5, 0x95d4, 0x95ed, 0x9605, 0x9620, 0x963b, 0x9655,
	0x966f, 0x968e, 0x96ad, 0x96c6, 0x96e1, 0x96fc, 0x971c, 0x9735,
	// Entry 2D40 - 2D7F
	0x974d, 0x9766, 0x977e, 0x9796, 0x97ab, 0x97c3, 0x97d9, 0x97f4,
	0x9812, 0x982f, 0x9847, 0x9860, 0x9873, 0x9887, 0x9899, 0x98ad,
	0x98c0, 0x98d2, 0x98e5, 0x98f9, 0x991c, 0x993f, 0x995e, 0x997d,
	0x999e, 0x99be, 0x99dd, 0x99ff, 0x9a21, 0x9a42, 0x9a64, 0x9a85,
	0x9aa7, 0x9ac9, 0x9aea, 0x9b09, 0x9b1b, 0x9b2d, 0x9b3f, 0x9b51,
	0x9b63, 0x9b76, 0x9b88, 0x9b9b, 0x9bad, 0x9bc0, 0x9bd3, 0x9be6,
	0x9bf8, 0x9c0b, 0x9c1f, 0x9c33, 0x9c45, 0x9c57, 0x9c6a, 0x9c7e,
	0x9c95, 0x9cac, 0x9cc3, 0x9cda, 0x9cec, 0x9cfe, 0x9d10, 0x9d27,
	// Entry 2D80 - 2DBF
	0x9d39, 0x9d4b, 0x9d5d, 0x9d6f, 0x9d7b, 0x9d88, 0x9d95, 0x9da3,
	0x9db0, 0x9dbe, 0x9dcc, 0x9dd9, 0x9de8, 0x9df7, 0x9e05, 0x9e14,
	0x9e23, 0x9e31, 0x9e40, 0x9e4c, 0x9e58, 0x9e64, 0x9e70, 0x9e7d,
	0x9e89, 0x9e96, 0x9ea3, 0x9eb0, 0x9ebe, 0x9ecb, 0x9ed8, 0x9ee5,
	0x9ef2, 0x9eff, 0x9f0d, 0x9f1b, 0x9f2a, 0x9f3a, 0x9f47, 0x9f53,
	0x9f61, 0x9f6f, 0x9f9c, 0x9fb4, 0x9fcc, 0x9fe4, 0x9ffc, 0xa014,
	0xa02c, 0xa044, 0xa05c, 0xa074, 0xa08c, 0xa0a4, 0xa0bc, 0xa0d4,
	0xa0ec, 0xa104, 0xa11c, 0xa137, 0xa151, 0xa16c, 0xa186, 0xa1a0,
	// Entry 2DC0 - 2DFF
	0xa1ba, 0xa1d3, 0xa1ed, 0xa207, 0xa223, 0xa23f, 0xa25b, 0xa277,
	0xa291, 0xa2ae, 0xa2ca, 0xa2e7, 0xa303, 0xa31f, 0xa33b, 0xa356,
	0xa372, 0xa38e, 0xa3ac, 0xa3ca, 0xa3e8, 0xa406, 0xa422, 0xa43e,
	0xa462, 0xa485, 0xa4a0, 0xa4bb, 0xa4d8, 0xa4f4, 0xa510, 0xa52b,
	0xa548, 0xa565, 0xa581, 0xa59c, 0xa5b8, 0xa5d4, 0xa5f1, 0xa60d,
	0xa62a, 0xa647, 0xa662, 0xa67f, 0xa69b, 0xa6ba, 0xa6d6, 0xa6f5,
	0xa716, 0xa73c, 0xa759, 0xa77a, 0xa796, 0xa7b3, 0xa7d4, 0xa7f6,
	0xa816, 0xa836, 0xa856, 0xa872, 0xa88e, 0xa8ab, 0xa8c5, 0xa8e3,
	// Entry 2E00 - 2E3F
	0xa8fb, 0xa911, 0xa933, 0xa958, 0xa97d, 0xa9a1, 0xa9c5, 0xa9e9,
	0xaa0f, 0xaa34, 0xaa44, 0xaa5d, 0xaa76, 0xaa91, 0xaaab, 0xaac5,
	0xaade, 0xaaf9, 0xab14, 0xab2e, 0xab43, 0xab5c, 0xab75, 0xab90,
	0xabaa, 0xabc4, 0xabd9, 0xabed, 0xac02, 0xac16, 0xac2a, 0xac3e,
	0xac51, 0xac65, 0xac79, 0xac8f, 0xaca5, 0xacbb, 0xacd1, 0xace5,
	0xacfc, 0xad12, 0xad29, 0xad3f, 0xad55, 0xad6b, 0xad80, 0xad96,
	0xadac, 0xadc4, 0xaddc, 0xadf4, 0xae0c, 0xae22, 0xae41, 0xae5f,
	0xae75, 0xae8b, 0xaea0, 0xaeb5, 0xaecc, 0xaee2, 0xaef8, 0xaf0d,
	// Entry 2E40 - 2E7F
	0xaf24, 0xaf3b, 0xaf51, 0xaf66, 0xaf7c, 0xaf92, 0xafa9, 0xafbf,
	0xafd6, 0xafed, 0xb002, 0xb019, 0xb02f, 0xb048, 0xb05e, 0xb077,
	0xb092, 0xb0b2, 0xb0c9, 0xb0e1, 0xb0f7, 0xb10f, 0xb129, 0xb144,
	0xb15b, 0xb176, 0xb18c, 0xb1a2, 0xb1b8, 0xb1d1, 0xb1e7, 0xb1ff,
	0xb214, 0xb22a, 0xb241, 0xb25b, 0xb275, 0xb28c, 0xb2a7, 0xb2c3,
	0xb2dd, 0xb2f7, 0xb30e, 0xb327, 0xb342, 0xb35d, 0xb377, 0xb38b,
	0xb3a3, 0xb3bb, 0xb3d5, 0xb3ee, 0xb407, 0xb41f, 0xb439, 0xb453,
	0xb46c, 0xb480, 0xb4a8, 0xb4d1, 0xb4f7, 0xb51d, 0xb541, 0xb566,
	// Entry 2E80 - 2EBF
	0xb58b, 0xb5b2, 0xb5dc, 0xb604, 0xb62d, 0xb656, 0xb65f, 0xb669,
	0xb672, 0xb688, 0xb69a, 0xb6ac, 0xb6be, 0xb6d0, 0xb6e2, 0xb6f5,
	0xb708, 0xb71b, 0xb72e, 0xb741, 0xb754, 0xb767, 0xb77a, 0xb78d,
	0xb7a0, 0xb7b3, 0xb7c6, 0xb7d9, 0xb7ec, 0xb7ff, 0xb812, 0xb825,
	0xb838, 0xb84b, 0xb85e, 0xb871, 0xb884, 0xb897, 0xb8aa, 0xb8bd,
	0xb8d0, 0xb8e3, 0xb8f6, 0xb909, 0xb91c, 0xb92f, 0xb942, 0xb955,
	0xb968, 0xb97b, 0xb98e, 0xb9a1, 0xb9b4, 0xb9c7, 0xb9da, 0xb9ed,
	0xba00, 0xba15, 0xba22, 0xba2f, 0xba3b, 0xba46, 0xba53, 0xba5e,
	// Entry 2EC0 - 2EFF
	0xba68, 0xba77, 0xba83, 0xba8e, 0xba99, 0xbaa5, 0xbab3, 0xbac1,
	0xbacd, 0xbad9, 0xbae4, 0xbaf0, 0xbafd, 0xbb0b, 0xbb16, 0xbb27,
	0xbb39, 0xbb49, 0xbb56, 0xbb66, 0xbb76, 0xbb84, 0xbb90, 0xbb9d,
	0xbba9, 0xbbb7, 0xbbc6, 0xbbd4, 0xbbe0, 0xbbec, 0xbbf8, 0xbc03,
	0xbc0e, 0xbc18, 0xbc23, 0xbc2f, 0xbc3b, 0xbc4a, 0xbc56, 0xbc64,
	0xbc74, 0xbc81, 0xbc8c, 0xbc97, 0xbca6, 0xbcb3, 0xbcc2, 0xbcce,
	0xbcde, 0xbce9, 0xbcf6, 0xbd03, 0xbd0f, 0xbd1b, 0xbd27, 0xbd34,
	0xbd41, 0xbd4b, 0xbd57, 0xbd63, 0xbd6e, 0xbd7c, 0xbd88, 0xbd94,
	// Entry 2F00 - 2F3F
	0xbda1, 0xbdaf, 0xbdbd, 0xbdc8, 0xbdd8, 0xbde3, 0xbdf1, 0xbdff,
	0xbe0b, 0xbe17, 0xbe22, 0xbe30, 0xbe3b, 0xbe47, 0xbe55, 0xbe60,
	0xbe6f, 0xbe7b, 0xbea5, 0xbece, 0xbef7, 0xbf22, 0xbf4c, 0xbf76,
	0xbf9f, 0xbfca, 0xbff5, 0xc01f, 0xc048, 0xc074, 0xc0a0, 0xc0ce,
	0xc0fc, 0xc129, 0xc156, 0xc185, 0xc1b3, 0xc1e1, 0xc20d, 0xc23d,
	0xc26d, 0xc29f, 0xc2d0, 0xc2da, 0xc2e3, 0xc2ec, 0xc2f6, 0xc2ff,
	0xc308, 0xc311, 0xc322, 0xc331, 0xc33a, 0xc350, 0xc366, 0xc37d,
	0xc392, 0xc3a4, 0xc3b2, 0xc3bb, 0xc3c6, 0xc3cf, 0xc3d8, 0xc3e1,
	// Entry 2F40 - 2F7F
	0xc3ea, 0xc3f3, 0xc3fd, 0xc408, 0xc411, 0xc41a, 0xc425, 0xc430,
	0xc439, 0xc442, 0xc44b, 0xc455, 0xc45f, 0xc469, 0xc473, 0xc47e,
	0xc487, 0xc490, 0xc499, 0xc4a2, 0xc4ab, 0xc4b6, 0xc4bf, 0xc4c8,
	0xc4d1, 0xc4e2, 0xc4f3, 0xc503, 0xc514, 0xc523, 0xc532, 0xc540,
	0xc54f, 0xc55e, 0xc575, 0xc57e, 0xc588, 0xc592, 0xc59c, 0xc5a6,
	0xc5b7, 0xc5d0, 0xc5d9, 0xc5e2, 0xc5ed, 0xc5f6, 0xc5ff, 0xc608,
	0xc613, 0xc61c, 0xc625, 0xc633, 0xc63c, 0xc645, 0xc650, 0xc659,
	0xc662, 0xc670, 0xc67c, 0xc688, 0xc691, 0xc69a, 0xc6a3, 0xc6ac,
	// Entry 2F80 - 2FBF
	0xc6bc, 0xc6c5, 0xc6ce, 0xc6d7, 0xc6e0, 0xc6e9, 0xc6f2, 0xc6fb,
	0xc70c, 0xc715, 0xc71e, 0xc727, 0xc731, 0xc73a, 0xc749, 0xc753,
	0xc75d, 0xc766, 0xc76f, 0xc779, 0xc782, 0xc78b, 0xc794, 0xc79d,
	0xc7ac, 0xc7bb, 0xc7e3, 0xc80b, 0xc835, 0xc85e, 0xc887, 0xc8af,
	0xc8d9, 0xc903, 0xc92c, 0xc954, 0xc97f, 0xc9aa, 0xc9d7, 0xca04,
	0xca30, 0xca5c, 0xca8a, 0xcab7, 0xcae4, 0xcb0f, 0xcb3e, 0xcb6d,
	0xcb9e, 0xcbce, 0xcbfe, 0xcc2d, 0xcc5e, 0xcc8f, 0xccbf, 0xccea,
	0xcd19, 0xcd23, 0xcd43, 0xcd63, 0xcd8b, 0xcda6, 0xcdba, 0xcdcf,
	// Entry 2FC0 - 2FFF
	0xcde4, 0xce01, 0xce1a, 0xce2f, 0xce41, 0xce58, 0xce6f, 0xce8c,
	0xcea0, 0xceb7, 0xcecd, 0xceed, 0xcf02, 0xcf1c, 0xcf37, 0xcf49,
	0xcf65, 0xcf78, 0xcf8e, 0xcfa7, 0xcfc1, 0xcfe1, 0xcfff, 0xd01d,
	0xd033, 0xd048, 0xd05c, 0xd074, 0xd089, 0xd0ac, 0xd0c3, 0xd0da,
	0xd0f2, 0xd10a, 0xd11f, 0xd134, 0xd14d, 0xd168, 0xd187, 0xd1a2,
	0xd1b9, 0xd1ce, 0xd1e5, 0xd1fe, 0xd21f, 0xd246, 0xd25e, 0xd27e,
	0xd294, 0xd2ad, 0xd2c9, 0xd2e5, 0xd2fc, 0xd313, 0xd32b, 0xd34b,
	0xd368, 0xd386, 0xd394, 0xd3a2, 0xd3af, 0xd3bd, 0xd3cc, 0xd3db,
	// Entry 3000 - 303F
	0xd3e9, 0xd3f8, 0xd406, 0xd414, 0xd421, 0xd42f, 0xd43e, 0xd44c,
	0xd45b, 0xd469, 0xd477, 0xd484, 0xd492, 0xd4a0, 0xd4ad, 0xd4bb,
	0xd4ca, 0xd4d9, 0xd4e7, 0xd4f6, 0xd506, 0xd516, 0xd525, 0xd535,
	0xd544, 0xd553, 0xd561, 0xd570, 0xd580, 0xd58f, 0xd59f, 0xd5ae,
	0xd5bd, 0xd5cb, 0xd5da, 0xd5e9, 0xd5f7, 0xd606, 0xd615, 0xd624,
	0xd632, 0xd641, 0xd651, 0xd660, 0xd66f, 0xd67e, 0xd68c, 0xd69b,
	0xd6ab, 0xd6ba, 0xd6c9, 0xd6d8, 0xd6e6, 0xd6f5, 0xd705, 0xd714,
	0xd724, 0xd733, 0xd742, 0xd750, 0xd75f, 0xd76f, 0xd77e, 0xd78e,
	// Entry 3040 - 307F
	0xd79d, 0xd7ac, 0xd7ba, 0xd7c9, 0xd7d8, 0xd7e7, 0xd7f5, 0xd804,
	0xd814, 0xd823, 0xd832, 0xd841, 0xd84f, 0xd85e, 0xd86e, 0xd87d,
	0xd88d, 0xd89d, 0xd8ac, 0xd8bc, 0xd8cd, 0xd8de, 0xd8ee, 0xd8ff,
	0xd90f, 0xd91f, 0xd92e, 0xd93e, 0xd94f, 0xd95f, 0xd970, 0xd980,
	0xd990, 0xd99f, 0xd9af, 0xd9bf, 0xd9ce, 0xd9de, 0xd9ee, 0xd9fe,
	0xda0d, 0xda1d, 0xda2e, 0xda3e, 0xda4e, 0xda5e, 0xda6d, 0xda7d,
	0xda8d, 0xda9d, 0xdaac, 0xdabc, 0xdacd, 0xdadd, 0xdaee, 0xdafe,
	0xdb0e, 0xdb1d, 0xdb2d, 0xdb3d, 0xdb4d, 0xdb5c, 0xdb6c, 0xdb7c,
	// Entry 3080 - 30BF
	0xdb8c, 0xdb9b, 0xdbab, 0xdbbc, 0xdbcc, 0xdbdc, 0xdbec, 0xdbfb,
	0xdc0b, 0xdc1c, 0xdc2c, 0xdc3c, 0xdc4c, 0xdc5b, 0xdc6b, 0xdc7c,
	0xdc8c, 0xdc9d, 0xdcad, 0xdcbd, 0xdccc, 0xdcdc, 0xdced, 0xdcfd,
	0xdd0e, 0xdd1e, 0xdd2e, 0xdd3d, 0xdd4d, 0xdd5d, 0xdd6d, 0xdd7c,
	0xdd8c, 0xdd9d, 0xddad, 0xddbd, 0xddcc, 0xdddc, 0xdded, 0xddfd,
	0xde0c, 0xde1b, 0xde29, 0xde38, 0xde48, 0xde57, 0xde67, 0xde76,
	0xde85, 0xde93, 0xdea2, 0xdeb2, 0xdec2, 0xded1, 0xdee1, 0xdef0,
	0xdeff, 0xdf0d, 0xdf1c, 0xdf2b, 0xdf39, 0xdf48, 0xdf57, 0xdf65,
	// Entry 30C0 - 30FF
	0xdf74, 0xdf84, 0xdf93, 0xdfa2, 0xdfb1, 0xdfbf, 0xdfce, 0xdfdd,
	0xdfec, 0xdffa, 0xe009, 0xe018, 0xe027, 0xe035, 0xe044, 0xe053,
	0xe061, 0xe070, 0xe07f, 0xe08e, 0xe09c, 0xe0ab, 0xe0bb, 0xe0ca,
	0xe0d9, 0xe0e8, 0xe0f6, 0xe105, 0xe114, 0xe123, 0xe131, 0xe140,
	0xe150, 0xe160, 0xe16f, 0xe17f, 0xe18e, 0xe19d, 0xe1ab, 0xe1ba,
	0xe1c9, 0xe1d8, 0xe1e6, 0xe1f5, 0xe204, 0xe213, 0xe222, 0xe231,
	0xe23f, 0xe24e, 0xe25e, 0xe26d, 0xe27c, 0xe28b, 0xe299, 0xe2a8,
	0xe2b8, 0xe2c7, 0xe2d6, 0xe2e5, 0xe2f3, 0xe302, 0xe312, 0xe321,
	// Entry 3100 - 313F
	0xe331, 0xe340, 0xe34f, 0xe35d, 0xe36c, 0xe37c, 0xe38b, 0xe39a,
	0xe3a9, 0xe3b7, 0xe3c6, 0xe3d5, 0xe3e3, 0xe3f2, 0xe401, 0xe410,
	0xe41e, 0xe42d, 0xe43d, 0xe44c, 0xe45b, 0xe46a, 0xe478, 0xe487,
	0xe497, 0xe4a6, 0xe4b6, 0xe4c5, 0xe4d4, 0xe4e2, 0xe4f1, 0xe501,
	0xe511, 0xe520, 0xe530, 0xe53f, 0xe54e, 0xe55c, 0xe56b, 0xe57a,
	0xe588, 0xe597, 0xe5a6, 0xe5b5, 0xe5c3, 0xe5d2, 0xe5e2, 0xe5f1,
	0xe601, 0xe611, 0xe620, 0xe630, 0xe641, 0xe651, 0xe662, 0xe672,
	0xe682, 0xe691, 0xe6a1, 0xe6b2, 0xe6c2, 0xe6d3, 0xe6e3, 0xe6f3,
	// Entry 3140 - 317F
	0xe702, 0xe712, 0xe722, 0xe731, 0xe741, 0xe751, 0xe761, 0xe770,
	0xe780, 0xe791, 0xe7a1, 0xe7b1, 0xe7c1, 0xe7d0, 0xe7e0, 0xe7f1,
	0xe801, 0xe811, 0xe821, 0xe830, 0xe840, 0xe850, 0xe860, 0xe86f,
	0xe87f, 0xe88f, 0xe89e, 0xe8ae, 0xe8be, 0xe8ce, 0xe8dd, 0xe8ed,
	0xe8fe, 0xe90e, 0xe91e, 0xe92e, 0xe93d, 0xe94d, 0xe95e, 0xe96f,
	0xe97f, 0xe990, 0xe9a0, 0xe9b0, 0xe9bf, 0xe9cf, 0xe9e0, 0xe9f0,
	0xea00, 0xea10, 0xea20, 0xea30, 0xea3f, 0xea4f, 0xea5f, 0xea6e,
	0xea7d, 0xea8b, 0xea9a, 0xeaaa, 0xeab9, 0xeac9, 0xead8, 0xeae6,
	// Entry 3180 - 31BF
	0xeaf5, 0xeb05, 0xeb14, 0xeb24, 0xeb33, 0xeb42, 0xeb50, 0xeb5f,
	0xeb6e, 0xeb7c, 0xeb8b, 0xeb9a, 0xeba9, 0xebb7, 0xebc6, 0xebd6,
	0xebe5, 0xebf5, 0xec05, 0xec14, 0xec24, 0xec35, 0xec45, 0xec56,
	0xec66, 0xec76, 0xec85, 0xec95, 0xeca6, 0xecb6, 0xecc7, 0xecd7,
	0xece6, 0xecf6, 0xed06, 0xed15, 0xed25, 0xed35, 0xed45, 0xed54,
	0xed64, 0xed75, 0xed85, 0xed95, 0xeda5, 0xedb4, 0xedc4, 0xedd5,
	0xede5, 0xedf4, 0xee03, 0xee11, 0xee20, 0xee30, 0xee40, 0xee4f,
	0xee5f, 0xee6e, 0xee7d, 0xee8b, 0xee9a, 0xeeaa, 0xeeba, 0xeec9,
	// Entry 31C0 - 31FF
	0xeed9, 0xeee8, 0xeef7, 0xef05, 0xef14, 0xef23, 0xef31, 0xef40,
	0xef4f, 0xef5e, 0xef6c, 0xef7b, 0xef8b, 0xef9a, 0xefa9, 0xefb8,
	0xefc6, 0xefd5, 0xefe5, 0xeff4, 0xf003, 0xf012, 0xf020, 0xf02f,
	0xf03f, 0xf04f, 0xf05e, 0xf06e, 0xf07d, 0xf08c, 0xf09a, 0xf0a9,
	0xf0b9, 0xf0c9, 0xf0d8, 0xf0e8, 0xf0f7, 0xf106, 0xf114, 0xf123,
	0xf132, 0xf141, 0xf14f, 0xf15e, 0xf16d, 0xf17c, 0xf18a, 0xf199,
	0xf1a9, 0xf1b8, 0xf1c7, 0xf1d6, 0xf1e4, 0xf1f3, 0xf203, 0xf212,
	0xf222, 0xf231, 0xf240, 0xf24e, 0xf25d, 0xf26d, 0xf27c, 0xf28c,
	// Entry 3200 - 323F
	0xf29b, 0xf2aa, 0xf2b8, 0xf2c7, 0xf2d6, 0xf2e5, 0xf2f3, 0xf302,
	0xf311, 0xf320, 0xf32e, 0xf33d, 0xf34d, 0xf35c, 0xf36c, 0xf37c,
	0xf38b, 0xf39c, 0xf3ac, 0xf3bd, 0xf3cd, 0xf3dd, 0xf3ec, 0xf3fc,
	0xf40d, 0xf41e, 0xf42e, 0xf43f, 0xf44f, 0xf45f, 0xf46e, 0xf47e,
	0xf48e, 0xf49e, 0xf4ad, 0xf4bd, 0xf4cd, 0xf4dd, 0xf4ec, 0xf4fc,
	0xf50d, 0xf51d, 0xf52e, 0xf53e, 0xf54e, 0xf55e, 0xf56d, 0xf57d,
	0xf58e, 0xf59e, 0xf5af, 0xf5bf, 0xf5cf, 0xf5de, 0xf5ee, 0xf5fe,
	0xf60d, 0xf61d, 0xf62d, 0xf63d, 0xf64c, 0xf65c, 0xf66d, 0xf67d,
	// Entry 3240 - 327F
	0xf68d, 0xf69d, 0xf6ac, 0xf6bc, 0xf6cd, 0xf6de, 0xf6ee, 0xf6ff,
	0xf70f, 0xf71f, 0xf72e, 0xf73e, 0xf74f, 0xf760, 0xf770, 0xf781,
	0xf791, 0xf7a1, 0xf7b0, 0xf7c0, 0xf7d0, 0xf7df, 0xf7ef, 0xf800,
	0xf810, 0xf821, 0xf831, 0xf841, 0xf850, 0xf860, 0xf871, 0xf882,
	0xf892, 0xf8a2, 0xf8b2, 0xf8c1, 0xf8d1, 0xf8e1, 0xf8f0, 0xf900,
	0xf90f, 0xf91f, 0xf92e, 0xf93d, 0xf94c, 0xf95a, 0xf969, 0xf979,
	0xf989, 0xf998, 0xf9a8, 0xf9b7, 0xf9c6, 0xf9d4, 0xf9e3, 0xf9f2,
	0xfa00, 0xfa0f, 0xfa1e, 0xfa2d, 0xfa3b, 0xfa4a, 0xfa5a, 0xfa69,
	// Entry 3280 - 32BF
	0xfa79, 0xfa88, 0xfa96, 0xfaa5, 0xfab4, 0xfac2, 0xfad1, 0xfae0,
	0xfaef, 0xfafd, 0xfb0c, 0xfb1c, 0xfb2b, 0xfb3b, 0xfb4a, 0xfb59,
	0xfb67, 0xfb76, 0xfb86, 0xfb95, 0xfba5, 0xfbb4, 0xfbc3, 0xfbd1,
	0xfbe0, 0xfbef, 0xfbfd, 0xfc0c, 0xfc1b, 0xfc2a, 0xfc38, 0xfc47,
	0xfc57, 0xfc66, 0xfc75, 0xfc84, 0xfc92, 0xfca1, 0xfcb1, 0xfcc0,
	0xfccf, 0xfcde, 0xfcec, 0xfcfb, 0xfd0b, 0xfd1b, 0xfd2a, 0xfd3a,
	0xfd49, 0xfd58, 0xfd66, 0xfd75, 0xfd85, 0xfd94, 0xfda4, 0xfdb3,
	0xfdc2, 0xfdd0, 0xfddf, 0xfdee, 0xfdfc, 0xfe0b, 0xfe1a, 0xfe29,
	// Entry 32C0 - 32FF
	0xfe37, 0xfe46, 0xfe56, 0xfe65, 0xfe74, 0xfe83, 0xfe91, 0xfea0,
	0xfeb0, 0xfebf, 0xfecf, 0xfedf, 0xfeee, 0xfefe, 0xff0f, 0xff20,
	0xff30, 0xff41, 0xff51, 0xff61, 0xff70, 0xff80, 0xff90, 0xff9f,
	0xffaf, 0xffbf, 0xffce, 0xffde, 0xffee, 0xfffd, 0x000d, 0x001e,
	0x002e, 0x003e, 0x004e, 0x005d, 0x006d, 0x007e, 0x008e, 0x009e,
	0x00ae, 0x00bd, 0x00cd, 0x00de, 0x00ee, 0x00ff, 0x010f, 0x011f,
	0x012e, 0x013e, 0x014f, 0x015f, 0x016f, 0x017f, 0x018f, 0x019e,
	0x01ae, 0x01bd, 0x01cd, 0x01de, 0x01ee, 0x01fe, 0x020e, 0x021d,
	// Entry 3300 - 333F
	0x022d, 0x023e, 0x024e, 0x025d, 0x026c, 0x027a, 0x0289, 0x0299,
	0x02a8, 0x02b8, 0x02c7, 0x02d6, 0x02e4, 0x02f3, 0x0303, 0x0312,
	0x0322, 0x0331, 0x0340, 0x034e, 0x035d, 0x036c, 0x037a, 0x0389,
	0x0398, 0x03a7, 0x03b5, 0x03c4, 0x03d4, 0x03e3, 0x03f2, 0x0401,
	0x040f, 0x041e, 0x042e, 0x043d, 0x044d, 0x045d, 0x046c, 0x047c,
	0x048d, 0x049d, 0x04ae, 0x04be, 0x04ce, 0x04dd, 0x04ed, 0x04fd,
	0x050d, 0x051c, 0x052c, 0x053c, 0x054b, 0x055b, 0x056b, 0x057b,
	0x058a, 0x059a, 0x05aa, 0x05ba, 0x05c9, 0x05d9, 0x05ea, 0x05fa,
	// Entry 3340 - 337F
	0x060a, 0x061a, 0x0629, 0x0639, 0x064a, 0x065a, 0x066b, 0x067b,
	0x068b, 0x069a, 0x06aa, 0x06ba, 0x06ca, 0x06d9, 0x06e9, 0x06f9,
	0x0709, 0x0718, 0x0728, 0x0739, 0x0749, 0x0759, 0x0769, 0x0778,
	0x0788, 0x0799, 0x07a9, 0x07b9, 0x07c9, 0x07d8, 0x07e8, 0x07f9,
	0x080a, 0x081a, 0x082b, 0x083b, 0x084b, 0x085a, 0x086a, 0x087a,
	0x088a, 0x0899, 0x08a9, 0x08b9, 0x08c8, 0x08d8, 0x08e9, 0x08f9,
	0x0909, 0x0919, 0x0928, 0x0938, 0x0949, 0x0959, 0x0969, 0x0978,
	0x0989, 0x0999, 0x09a9, 0x09b9, 0x09c8, 0x09d8, 0x09e8, 0x09f8,
	// Entry 3380 - 33BF
	0x0a07, 0x0a17, 0x0a27, 0x0a37, 0x0a46, 0x0a56, 0x0a67, 0x0a77,
	0x0a87, 0x0a97, 0x0aa6, 0x0ab6, 0x0ac7, 0x0ad7, 0x0ae7, 0x0af7,
	0x0b06, 0x0b16, 0x0b26, 0x0b35, 0x0b45, 0x0b55, 0x0b65, 0x0b74,
	0x0b84, 0x0b94, 0x0ba4, 0x0bb3, 0x0bc3, 0x0bd4, 0x0be4, 0x0bf4,
	0x0c04, 0x0c13, 0x0c23, 0x0c34, 0x0c44, 0x0c54, 0x0c64, 0x0c73,
	0x0c83, 0x0c94, 0x0ca4, 0x0cb5, 0x0cc5, 0x0cd5, 0x0ce4, 0x0cf4,
	0x0d04, 0x0d14, 0x0d23, 0x0d33, 0x0d43, 0x0d53, 0x0d62, 0x0d72,
	0x0d83, 0x0d93, 0x0da3, 0x0db3, 0x0dc2, 0x0dd2, 0x0de3, 0x0df3,
	// Entry 33C0 - 33FF
	0x0e02, 0x0e11, 0x0e1f, 0x0e2e, 0x0e3e, 0x0e4d, 0x0e5d, 0x0e6c,
	0x0e7b, 0x0e89, 0x0e98, 0x0ea7, 0x0eb5, 0x0ec4, 0x0ed3, 0x0ee2,
	0x0ef0, 0x0eff, 0x0f0f, 0x0f1e, 0x0f2d, 0x0f3c, 0x0f4a, 0x0f59,
	0x0f69, 0x0f78, 0x0f87, 0x0f96, 0x0fa4, 0x0fb3, 0x0fc3, 0x0fd3,
	0x0fe2, 0x0ff2, 0x1002, 0x1012, 0x1021, 0x1031, 0x1040, 0x104f,
	0x105d, 0x106c, 0x107b, 0x108a, 0x1098, 0x10a7, 0x10b7, 0x10c6,
	0x10d5, 0x10e4, 0x10f2, 0x1101, 0x1111, 0x1120, 0x112f, 0x113e,
	0x114c, 0x115b, 0x116b, 0x117b, 0x118a, 0x119a, 0x11aa, 0x11ba,
	// Entry 3400 - 343F
	0x11c9, 0x11d9, 0x11e8, 0x11f7, 0x1205, 0x1214, 0x1223, 0x1232,
	0x1240, 0x124f, 0x125f, 0x126e, 0x127d, 0x128c, 0x129a, 0x12a9,
	0x12b9, 0x12c8, 0x12d8, 0x12e8, 0x12f7, 0x1307, 0x1318, 0x1329,
	0x1339, 0x134a, 0x135b, 0x136b, 0x137c, 0x138c, 0x139c, 0x13ab,
	0x13bb, 0x13cb, 0x13db, 0x13ea, 0x13fa, 0x140b, 0x141b, 0x142b,
	0x143b, 0x144a, 0x145a, 0x146a, 0x147a, 0x1489, 0x1499, 0x14aa,
	0x14bb, 0x14cb, 0x14dc, 0x14ed, 0x14fd, 0x150d, 0x151d, 0x152c,
	0x153c, 0x154c, 0x155b, 0x156b, 0x157c, 0x158c, 0x159c, 0x15ac,
	// Entry 3440 - 347F
	0x15bb, 0x15cb, 0x15dc, 0x15ec, 0x15fc, 0x160c, 0x161b, 0x162b,
	0x163c, 0x164d, 0x165d, 0x166e, 0x167f, 0x168f, 0x16a0, 0x16b0,
	0x16c0, 0x16cf, 0x16df, 0x16ef, 0x16ff, 0x170e, 0x171e, 0x172d,
	0x173c, 0x174a, 0x1759, 0x1769, 0x1779, 0x1788, 0x1798, 0x17a8,
	0x17b7, 0x17c6, 0x17d5, 0x17e3, 0x17f2, 0x1801, 0x1810, 0x181e,
	0x182d, 0x183d, 0x184c, 0x185b, 0x186a, 0x1878, 0x1887, 0x1897,
	0x18a7, 0x18b6, 0x18c6, 0x18d6, 0x18e6, 0x18f5, 0x1905, 0x1914,
	0x1923, 0x1931, 0x1940, 0x194f, 0x195e, 0x196c, 0x197b, 0x198b,
	// Entry 3480 - 34BF
	0x199a, 0x19a9, 0x19b8, 0x19c6, 0x19d5, 0x19e5, 0x19f4, 0x1a02,
	0x1a0f, 0x1a1d, 0x1a2c, 0x1a3a, 0x1a48, 0x1a57, 0x1a65, 0x1a72,
	0x1a81, 0x1a8f, 0x1a9e, 0x1aac, 0x1ab9, 0x1ac7, 0x1ad6, 0x1ae4,
	0x1af1, 0x1aff, 0x1b0d, 0x1b1c, 0x1b2a, 0x1b39, 0x1b48, 0x1b55,
	0x1b62, 0x1b71, 0x1b7f, 0x1b8d, 0x1b9b, 0x1ba9, 0x1bb7, 0x1bc5,
	0x1bd3, 0x1be0, 0x1bed, 0x1bfc, 0x1c0a, 0x1c18, 0x1c27, 0x1c34,
	0x1c41, 0x1c50, 0x1c5e, 0x1c6b, 0x1c7a, 0x1c88, 0x1c97, 0x1ca6,
	0x1cb4, 0x1cc3, 0x1cd1, 0x1ce1, 0x1cf0, 0x1cfd, 0x1d0b, 0x1d19,
	// Entry 34C0 - 34FF
	0x1d28, 0x1d36, 0x1d44, 0x1d53, 0x1d61, 0x1d6f, 0x1d7e, 0x1d8c,
	0x1d9a, 0x1da9, 0x1db8, 0x1dc7, 0x1dd7, 0x1de5, 0x1df3, 0x1e01,
	0x1e0f, 0x1e1e, 0x1e2c, 0x1e3b, 0x1e49, 0x1e57, 0x1e66, 0x1e74,
	0x1e82, 0x1e91, 0x1e9f, 0x1eae, 0x1ebb, 0x1ec9, 0x1ed6, 0x1ee4,
	0x1ef1, 0x1efe, 0x1f0b, 0x1f19, 0x1f27, 0x1f35, 0x1f4c, 0x1f62,
	0x1f7a, 0x1f91, 0x1fa8, 0x1fc0, 0x1fd6, 0x1ff0, 0x1fff, 0x200f,
	0x201f, 0x202f, 0x2040, 0x2050, 0x2061, 0x2071, 0x2082, 0x2093,
	0x20a5, 0x20b6, 0x20c6, 0x20d6, 0x20e6, 0x20f7, 0x2108, 0x211a,
	// Entry 3500 - 353F
	0x212a, 0x213a, 0x214a, 0x215b, 0x216b, 0x217c, 0x218c, 0x219d,
	0x21ad, 0x21bd, 0x21ce, 0x21de, 0x21ee, 0x2200, 0x2210, 0x2220,
	0x2230, 0x2241, 0x224f, 0x225e, 0x226d, 0x227d, 0x228c, 0x229c,
	0x22ab, 0x22bb, 0x22ca, 0x22da, 0x22ea, 0x22fb, 0x230b, 0x231a,
	0x2329, 0x2338, 0x2348, 0x2358, 0x2369, 0x2378, 0x2387, 0x2396,
	0x23a6, 0x23b5, 0x23c5, 0x23d4, 0x23e4, 0x23f3, 0x2402, 0x2412,
	0x2421, 0x2430, 0x2441, 0x2450, 0x245f, 0x246e, 0x247e, 0x248c,
	0x249b, 0x24ac, 0x24bb, 0x24cb, 0x24da, 0x24ea, 0x24f9, 0x2509,
	// Entry 3540 - 357F
	0x2518, 0x2528, 0x2538, 0x2549, 0x255a, 0x256a, 0x2579, 0x2588,
	0x2597, 0x25a7, 0x25b7, 0x25c8, 0x25d7, 0x25e6, 0x25f5, 0x2605,
	0x2614, 0x2624, 0x2633, 0x2643, 0x2652, 0x2661, 0x2671, 0x2680,
	0x268f, 0x269f, 0x26b0, 0x26bf, 0x26ce, 0x26dd, 0x26ed, 0x26fc,
	0x270c, 0x271c, 0x272c, 0x273d, 0x274d, 0x275e, 0x276e, 0x277f,
	0x2790, 0x27a2, 0x27b3, 0x27c3, 0x27d3, 0x27e3, 0x27f4, 0x2805,
	0x2817, 0x2827, 0x2837, 0x2847, 0x2858, 0x2868, 0x2879, 0x2889,
	0x289a, 0x28aa, 0x28ba, 0x28cb, 0x28db, 0x28eb, 0x28fd, 0x290d,
	// Entry 3580 - 35BF
	0x291d, 0x292d, 0x293e, 0x294c, 0x295b, 0x296a, 0x297a, 0x2989,
	0x2999, 0x29a8, 0x29b8, 0x29c7, 0x29d7, 0x29e7, 0x29f8, 0x2a08,
	0x2a17, 0x2a26, 0x2a35, 0x2a45, 0x2a55, 0x2a66, 0x2a75, 0x2a84,
	0x2a93, 0x2aa3, 0x2ab2, 0x2ac2, 0x2ad1, 0x2ae1, 0x2af0, 0x2aff,
	0x2b0f, 0x2b1e, 0x2b2d, 0x2b3e, 0x2b4d, 0x2b5c, 0x2b6b, 0x2b7b,
	0x2b89, 0x2b98, 0x2ba9, 0x2bb8, 0x2bc8, 0x2bd7, 0x2be7, 0x2bf6,
	0x2c06, 0x2c15, 0x2c25, 0x2c35, 0x2c46, 0x2c56, 0x2c67, 0x2c76,
	0x2c85, 0x2c94, 0x2ca4, 0x2cb4, 0x2cc5, 0x2cd4, 0x2ce3, 0x2cf2,
	// Entry 35C0 - 35FF
	0x2d02, 0x2d11, 0x2d21, 0x2d30, 0x2d40, 0x2d4f, 0x2d5e, 0x2d6e,
	0x2d7d, 0x2d8c, 0x2d9d, 0x2dac, 0x2dbb, 0x2dca, 0x2dda, 0x2de8,
	0x2df7, 0x2e08, 0x2e17, 0x2e27, 0x2e36, 0x2e46, 0x2e55, 0x2e65,
	0x2e74, 0x2e84, 0x2e94, 0x2ea5, 0x2eb6, 0x2ec6, 0x2ed7, 0x2ee6,
	0x2ef5, 0x2f04, 0x2f14, 0x2f24, 0x2f35, 0x2f44, 0x2f53, 0x2f62,
	0x2f72, 0x2f81, 0x2f91, 0x2fa0, 0x2fb0, 0x2fbf, 0x2fce, 0x2fde,
	0x2fed, 0x2ffc, 0x300d, 0x301f, 0x302e, 0x303e, 0x304d, 0x305c,
	0x306c, 0x307b, 0x3092, 0x309b, 0x30a8, 0x30b9, 0x30ce, 0x30e3,
	// Entry 3600 - 363F
	0x30f9, 0x3109, 0x3119, 0x3128, 0x3136, 0x3145, 0x3153, 0x3161,
	0x3170, 0x3180, 0x318f, 0x319e, 0x31ad, 0x31bc, 0x31ca, 0x31d7,
	0x31e4, 0x31f3, 0x3201, 0x320f, 0x321c, 0x322b, 0x323a, 0x3248,
	0x325d, 0x3272, 0x3290, 0x32ac, 0x32c9, 0x32e4, 0x3308, 0x332a,
	0x3346, 0x3360, 0x337d, 0x3398, 0x33bc, 0x33de, 0x3401, 0x3422,
	0x3445, 0x3466, 0x3490, 0x34b8, 0x34dc, 0x34fe, 0x3521, 0x3542,
	0x3564, 0x3584, 0x35ad, 0x35d4, 0x35f7, 0x3618, 0x364a, 0x367a,
	0x3694, 0x36ac, 0x36d0, 0x36f2, 0x3711, 0x372e, 0x374d, 0x376a,
	// Entry 3640 - 367F
	0x3789, 0x37a6, 0x37c9, 0x37ea, 0x380d, 0x382e, 0x3858, 0x3880,
	0x389d, 0x38b5, 0x38d9, 0x3901, 0x392a, 0x393b, 0x3961, 0x397c,
	0x3998, 0x39b3, 0x39d6, 0x39f4, 0x3a17, 0x3a36, 0x3a4f, 0x3a69,
	0x3a78, 0x3a88, 0x3aa3, 0x3abc, 0x3ad8, 0x3af2, 0x3b0e, 0x3b28,
	0x3b44, 0x3b5e, 0x3b7a, 0x3b94, 0x3bbf, 0x3be8, 0x3c03, 0x3c1c,
	0x3c38, 0x3c52, 0x3c6e, 0x3c88, 0x3ca4, 0x3cbe, 0x3cd9, 0x3cf2,
	0x3d0e, 0x3d28, 0x3d48, 0x3d66, 0x3d87, 0x3da6, 0x3dc8, 0x3dea,
	0x3e06, 0x3e2a, 0x3e38, 0x3e47, 0x3e55, 0x3e64, 0x3e73, 0x3e83,
	// Entry 3680 - 36BF
	0x3e93, 0x3ea1, 0x3eb1, 0x3ebf, 0x3ece, 0x3edd, 0x3eed, 0x3efe,
	0x3f10, 0x3f22, 0x3f32, 0x3f43, 0x3f55, 0x3f63, 0x3f73, 0x3f82,
	0x3f93, 0x3fa2, 0x3fb4, 0x3fc5, 0x3fd6, 0x3fe6, 0x3ff7, 0x4006,
	0x4018, 0x4028, 0x4038, 0x4048, 0x4057, 0x4068, 0x4079, 0x408a,
	0x409b, 0x40ac, 0x40bc, 0x40cc, 0x40dc, 0x40ec, 0x40fb, 0x410a,
	0x4119, 0x4128, 0x4139, 0x4149, 0x4159, 0x416d, 0x417e, 0x418e,
	0x419e, 0x41af, 0x41be, 0x41ce, 0x41dd, 0x41ec, 0x41fb, 0x420a,
	0x421a, 0x4229, 0x423a, 0x424a, 0x425a, 0x4269, 0x4278, 0x4287,
	// Entry 36C0 - 36FF
	0x4296, 0x42a7, 0x42b7, 0x42c7, 0x42d7, 0x42e8, 0x42fa, 0x430d,
	0x431f, 0x4332, 0x434e, 0x436c, 0x4379, 0x4388, 0x4393, 0x439e,
	0x43ad, 0x43c0, 0x43e5, 0x440b, 0x4431, 0x4458, 0x447b, 0x449f,
	0x44c2, 0x44e6, 0x4510, 0x4534, 0x4557, 0x457a, 0x45a3, 0x45d7,
	0x4605, 0x4632, 0x465f, 0x4692, 0x46bf, 0x46e6, 0x470c, 0x4732,
	0x475e, 0x477e, 0x4797, 0x47b9, 0x47e1, 0x4800, 0x4821, 0x4848,
	0x4878, 0x48a5, 0x48c9, 0x48ec, 0x4913, 0x4938, 0x495e, 0x4982,
	0x499b, 0x49b2, 0x49c9, 0x49de, 0x49fb, 0x4a16, 0x4a34, 0x4a50,
	// Entry 3700 - 373F
	0x4a79, 0x4aa0, 0x4abc, 0x4ad8, 0x4aef, 0x4b04, 0x4b1b, 0x4b30,
	0x4b47, 0x4b5c, 0x4b73, 0x4b88, 0x4bb3, 0x4bdc, 0x4bf3, 0x4c08,
	0x4c30, 0x4c56, 0x4c78, 0x4c98, 0x4cc3, 0x4cec, 0x4d22, 0x4d56,
	0x4d73, 0x4d8e, 0x4db5, 0x4dda, 0x4e09, 0x4e36, 0x4e56, 0x4e74,
	0x4e8b, 0x4ea0, 0x4ed4, 0x4f06, 0x4f2a, 0x4f4c, 0x4f75, 0x4f9c,
	0x4fd0, 0x5002, 0x502d, 0x5056, 0x5074, 0x5090, 0x50b0, 0x50ce,
	0x50f9, 0x5122, 0x5139, 0x514e, 0x516f, 0x518e, 0x51b4, 0x51d8,
	0x5210, 0x5246, 0x525f, 0x5276, 0x528d, 0x52a2, 0x52b9, 0x52ce,
	// Entry 3740 - 377F
	0x52e6, 0x52fc, 0x530e, 0x5324, 0x533a, 0x5350, 0x5366, 0x537c,
	0x539a, 0x53b0, 0x53c5, 0x53e3, 0x53ff, 0x541d, 0x5439, 0x5457,
	0x547c, 0x549f, 0x54bc, 0x54d7, 0x54f5, 0x5511, 0x552f, 0x554b,
	0x5569, 0x5585, 0x55aa, 0x55bf, 0x55e0, 0x55fd, 0x5618, 0x5635,
	0x5666, 0x5682, 0x56a7, 0x56ca, 0x56e9, 0x5706, 0x572c, 0x5752,
	0x5776, 0x5798, 0x57ba, 0x57da, 0x57f9, 0x5816, 0x5835, 0x5852,
	0x5871, 0x588e, 0x58b8, 0x58e0, 0x590a, 0x5932, 0x595c, 0x5984,
	0x59ae, 0x59d6, 0x5a00, 0x5a28, 0x5a48, 0x5a6c, 0x5a89, 0x5aa9,
	// Entry 3780 - 37BF
	0x5acd, 0x5ae9, 0x5b06, 0x5b23, 0x5b4b, 0x5b63, 0x5b7c, 0x5b93,
	0x5bad, 0x5bc5, 0x5be7, 0x5c07, 0x5c25, 0x5c41, 0x5c5f, 0x5c7b,
	0x5c99, 0x5cb5, 0x5cd6, 0x5cf5, 0x5d15, 0x5d33, 0x5d5b, 0x5d7b,
	0x5da3, 0x5dd3, 0x5e01, 0x5e31, 0x5e5f, 0x5e7d, 0x5ea8, 0x5ed1,
	0x5f01, 0x5f2f, 0x5f54, 0x5f77, 0x5f98, 0x5fb7, 0x5fd7, 0x5ff5,
	0x6018, 0x6039, 0x6057, 0x6073, 0x608e, 0x60a7, 0x60ce, 0x60e7,
	0x6100, 0x6119, 0x6132, 0x6156, 0x6178, 0x619a, 0x61bf, 0x61e0,
	0x6203, 0x6225, 0x6247, 0x6269, 0x6288, 0x62a9, 0x62be, 0x62d3,
	// Entry 37C0 - 37FF
	0x62ed, 0x6302, 0x6317, 0x632c, 0x6345, 0x635b, 0x6372, 0x6388,
	0x639f, 0x63b9, 0x63cf, 0x63e6, 0x63fc, 0x6413, 0x642a, 0x6442,
	0x6459, 0x6471, 0x6487, 0x649e, 0x64b4, 0x64cb, 0x64e1, 0x64f7,
	0x650e, 0x6524, 0x653b, 0x6551, 0x6567, 0x657d, 0x6594, 0x65aa,
	0x65c0, 0x65d9, 0x65f2, 0x660b, 0x6624, 0x663e, 0x6658, 0x6672,
	0x668c, 0x66a6, 0x66c9, 0x66e9, 0x6706, 0x6729, 0x674b, 0x676a,
	0x678f, 0x67a7, 0x67c3, 0x67d9, 0x67f2, 0x6804, 0x6817, 0x6829,
	0x683c, 0x684e, 0x6861, 0x6873, 0x6886, 0x6898, 0x68ab, 0x68bd,
	// Entry 3800 - 383F
	0x68cf, 0x68e1, 0x68f4, 0x6906, 0x6918, 0x692b, 0x693f, 0x6952,
	0x6964, 0x6977, 0x6989, 0x69a0, 0x69b2, 0x69c4, 0x69d6, 0x69e9,
	0x69fb, 0x6a0d, 0x6a1e, 0x6a2f, 0x6a40, 0x6a51, 0x6a62, 0x6a74,
	0x6a86, 0x6a98, 0x6aab, 0x6abd, 0x6ad9, 0x6af5, 0x6b08, 0x6b1c,
	0x6b2f, 0x6b42, 0x6b5e, 0x6b7b, 0x6b94, 0x6bb0, 0x6bcc, 0x6be9,
	0x6c04, 0x6c1d, 0x6c36, 0x6c48, 0x6c61, 0x6c79, 0x6c90, 0x6ca3,
	0x6cb7, 0x6cca, 0x6cde, 0x6cf1, 0x6d05, 0x6d20, 0x6d3c, 0x6d57,
	0x6d73, 0x6d86, 0x6d9a, 0x6dae, 0x6dc1, 0x6dd5, 0x6de9, 0x6dfd,
	// Entry 3840 - 387F
	0x6e12, 0x6e26, 0x6e3b, 0x6e50, 0x6e64, 0x6e79, 0x6e8d, 0x6ea2,
	0x6eb7, 0x6ecc, 0x6ee2, 0x6ef7, 0x6f0d, 0x6f22, 0x6f36, 0x6f4b,
	0x6f5f, 0x6f74, 0x6f88, 0x6f9c, 0x6fb1, 0x6fc5, 0x6fda, 0x6fee,
	0x7002, 0x7016, 0x702a, 0x703e, 0x7053, 0x7068, 0x707c, 0x7090,
	0x70a5, 0x70c4, 0x70dc, 0x70f3, 0x710b, 0x7122, 0x713a, 0x7159,
	0x7179, 0x7198, 0x71b8, 0x71cf, 0x71e7, 0x71ff, 0x7216, 0x722e,
	0x7246, 0x725c, 0x7277, 0x7287, 0x729e, 0x72b3, 0x72c7, 0x72db,
	0x72f1, 0x7306, 0x731b, 0x732f, 0x7345, 0x735b, 0x7370, 0x738f,
	// Entry 3880 - 38BF
	0x73ad, 0x73cb, 0x73eb, 0x740a, 0x7429, 0x7447, 0x7467, 0x7487,
	0x74a6, 0x74c3, 0x74e0, 0x74fe, 0x751c, 0x753a, 0x7558, 0x7576,
	0x7598, 0x75bb, 0x75dd, 0x7606, 0x7625, 0x7646, 0x766a, 0x7682,
	0x7697, 0x76a7, 0x76bc, 0x76d3, 0x76e5, 0x76f9, 0x7711, 0x7724,
	0x7736, 0x7748, 0x775c, 0x776f, 0x7782, 0x7794, 0x77a8, 0x77bc,
	0x77cf, 0x77e1, 0x77f4, 0x7806, 0x7819, 0x782b, 0x783e, 0x7850,
	0x7863, 0x7875, 0x7888, 0x789a, 0x78ac, 0x78bf, 0x78d1, 0x78e3,
	0x78f5, 0x7907, 0x7919, 0x792b, 0x793d, 0x7950, 0x7962, 0x7974,
	// Entry 38C0 - 38FF
	0x7986, 0x7997, 0x79a9, 0x79ba, 0x79cc, 0x79dd, 0x79ed, 0x79fd,
	0x7a0e, 0x7a1e, 0x7a32, 0x7a45, 0x7a5f, 0x7a70, 0x7a82, 0x7a92,
	0x7aa2, 0x7ab3, 0x7ac3, 0x7ad3, 0x7ae3, 0x7af3, 0x7b03, 0x7b13,
	0x7b23, 0x7b33, 0x7b44, 0x7b54, 0x7b64, 0x7b74, 0x7b84, 0x7b94,
	0x7ba4, 0x7bb5, 0x7bc7, 0x7bd8, 0x7bea, 0x7bf9, 0x7c0c, 0x7c1f,
	0x7c32, 0x7c46, 0x7c59, 0x7c6d, 0x7c81, 0x7c95, 0x7cad, 0x7cc4,
	0x7cdb, 0x7cf2, 0x7cff, 0x7d12, 0x7d2e, 0x7d4a, 0x7d65, 0x7d81,
	0x7d9d, 0x7dbe, 0x7dda, 0x7dfb, 0x7e16, 0x7e31, 0x7e51, 0x7e74,
	// Entry 3900 - 393F
	0x7e8e, 0x7ea9, 0x7ec6, 0x7ee2, 0x7efe, 0x7f18, 0x7f3a, 0x7f57,
	0x7f72, 0x7f91, 0x7fac, 0x7fc7, 0x7fe7, 0x8003, 0x8020, 0x803a,
	0x805a, 0x8071, 0x8084, 0x8097, 0x80ac, 0x80bd, 0x80d3, 0x80e4,
	0x80f6, 0x8107, 0x811f, 0x8138, 0x8159, 0x816a, 0x817c, 0x818d,
	0x819f, 0x81b7, 0x81cf, 0x81e1, 0x81f9, 0x820c, 0x821e, 0x8236,
	0x8248, 0x8261, 0x827d, 0x8290, 0x82a3, 0x82c0, 0x82d3, 0x82f0,
	0x8308, 0x831a, 0x8332, 0x8344, 0x8360, 0x8372, 0x8384, 0x839c,
	0x83ae, 0x83c6, 0x83d8, 0x83ea, 0x83fc, 0x8414, 0x8426, 0x8438,
	// Entry 3940 - 397F
	0x8450, 0x846c, 0x847e, 0x8490, 0x84a8, 0x84c2, 0x84dc, 0x84f4,
	0x8512, 0x852a, 0x8549, 0x8563, 0x8581, 0x859a, 0x85b7, 0x85d6,
	0x85f3, 0x8603, 0x861a, 0x8632, 0x8645, 0x8658, 0x866b, 0x867e,
	0x8693, 0x86a7, 0x86bb, 0x86cd, 0x86e4, 0x86f9, 0x8715, 0x8729,
	0x873c, 0x874e, 0x8760, 0x8774, 0x8787, 0x879a, 0x87ac, 0x87c0,
	0x87d4, 0x87e7, 0x8802, 0x8819, 0x8830, 0x8847, 0x885e, 0x8875,
	0x888c, 0x88a1, 0x88cb, 0x88e7, 0x8902, 0x891d, 0x8939, 0x8954,
	0x8970, 0x898c, 0x89a9, 0x89c5, 0x89e1, 0x89fc, 0x8a17, 0x8a34,
	// Entry 3980 - 39BF
	0x8a50, 0x8a6c, 0x8a87, 0x8aa4, 0x8ac1, 0x8add, 0x8af9, 0x8b14,
	0x8b30, 0x8b4b, 0x8b67, 0x8b74, 0x8b81, 0x8b8e, 0x8b9b, 0x8ba9,
	0x8bb6, 0x8bc4, 0x8bd3, 0x8be1, 0x8bf0, 0x8c00, 0x8c0f, 0x8c1e,
	0x8c2e, 0x8c3c, 0x8c4b, 0x8c5b, 0x8c6a, 0x8c7a, 0x8c88, 0x8c97,
	0x8ca5, 0x8cb4, 0x8cc3, 0x8cd1, 0x8ce0, 0x8cee, 0x8cfd, 0x8d0c,
	0x8d1a, 0x8d29, 0x8d38, 0x8d46, 0x8d55, 0x8d63, 0x8d71, 0x8d7f,
	0x8d8d, 0x8d9c, 0x8daa, 0x8db8, 0x8dca, 0x8ddb, 0x8ded, 0x8dff,
	0x8e10, 0x8e22, 0x8e33, 0x8e45, 0x8e57, 0x8e69, 0x8e7f, 0x8e95,
	// Entry 39C0 - 39FF
	0x8eab, 0x8ec1, 0x8ed4, 0x8ee7, 0x8efb, 0x8f17, 0x8f2b, 0x8f3e,
	0x8f51, 0x8f64, 0x8f77, 0x8f8a, 0x8f9d, 0x8fb1, 0x8fcc, 0x8fe7,
	0x8ff6, 0x9004, 0x9012, 0x9022, 0x9031, 0x9040, 0x904e, 0x905e,
	0x906e, 0x907d, 0x9094, 0x90aa, 0x90c7, 0x90e4, 0x90fc, 0x9114,
	0x912d, 0x9145, 0x915e, 0x9177, 0x9190, 0x91aa, 0x91c3, 0x91dd,
	0x91f6, 0x920e, 0x9226, 0x923e, 0x9257, 0x926f, 0x929b, 0x92b3,
	0x92cb, 0x92e3, 0x92fe, 0x9318, 0x9332, 0x9352, 0x936a, 0x9382,
	0x9399, 0x93b4, 0x93d1, 0x93ee, 0x940d, 0x942c, 0x9442, 0x9459,
	// Entry 3A00 - 3A3F
	0x9470, 0x9488, 0x94a0, 0x94b9, 0x94cf, 0x94e6, 0x94fd, 0x9515,
	0x952b, 0x9542, 0x9559, 0x9571, 0x9587, 0x959e, 0x95b5, 0x95cd,
	0x95e3, 0x95fa, 0x9610, 0x9627, 0x963e, 0x9656, 0x966c, 0x9683,
	0x9699, 0x96b0, 0x96c6, 0x96dd, 0x96f4, 0x970c, 0x9722, 0x9739,
	0x974f, 0x9766, 0x977c, 0x9793, 0x97a9, 0x97c0, 0x97d6, 0x97ed,
	0x9803, 0x981a, 0x9830, 0x9847, 0x985c, 0x9872, 0x9883, 0x9894,
	0x98a4, 0x98b5, 0x98c5, 0x98d5, 0x98e5, 0x98f6, 0x9907, 0x9919,
	0x992a, 0x993c, 0x994d, 0x995e, 0x996f, 0x9983, 0x999a, 0x99af,
	// Entry 3A40 - 3A7F
	0x99c5, 0x99d8, 0x99ed, 0x9a00, 0x9a16, 0x9a2d, 0x9a42, 0x9a57,
	0x9a6e, 0x9a85, 0x9a9c, 0x9ab4, 0x9acb, 0x9ae3, 0x9afa, 0x9b11,
	0x9b28, 0x9b42, 0x9b5c, 0x9b77, 0x9b91, 0x9bac, 0x9bc1, 0x9bda,
	0x9beb, 0x9c10, 0x9c31, 0x9c50, 0x9c63, 0x9c79, 0x9c8f, 0x9ca6,
	0x9cbd, 0x9cd3, 0x9ce9, 0x9cff, 0x9d15, 0x9d2c, 0x9d43, 0x9d59,
	0x9d6f, 0x9d84, 0x9d99, 0x9daf, 0x9dc5, 0x9dda, 0x9def, 0x9e06,
	0x9e1d, 0x9e34, 0x9e4c, 0x9e64, 0x9e7b, 0x9e92, 0x9ea7, 0x9ebc,
	0x9ed1, 0x9ee7, 0x9efd, 0x9f12, 0x9f27, 0x9f46, 0x9f69, 0x9f89,
	// Entry 3A80 - 3ABF
	0x9fa4, 0x9fc6, 0x9fe0, 0xa00d, 0xa036, 0xa063, 0xa088, 0xa0ae,
	0xa0d4, 0xa0fc, 0xa11c, 0xa148, 0xa16d, 0xa18b, 0xa1b3, 0xa1e6,
	0xa208, 0xa236, 0xa252, 0xa27d, 0xa2a0, 0xa2bb, 0xa2e1, 0xa30e,
	0xa329, 0xa34e, 0xa36d, 0xa396, 0xa3c3, 0xa3d8, 0xa3f4, 0xa417,
	0xa42d, 0xa457, 0xa481, 0xa4a9, 0xa4d0, 0xa50a, 0xa53c, 0xa565,
	0xa587, 0xa5a1, 0xa5cd, 0xa5f6, 0xa61c, 0xa638, 0xa655, 0xa66f,
	0xa684, 0xa6a5, 0xa6c5, 0xa6f6, 0xa727, 0xa754, 0xa772, 0xa78b,
	0xa7a5, 0xa7bc, 0xa7d3, 0xa7ea, 0xa801, 0xa818, 0xa82f, 0xa847,
	// Entry 3AC0 - 3AFF
	0xa85f, 0xa877, 0xa88f, 0xa8a7, 0xa8bf, 0xa8d7, 0xa8ef, 0xa907,
	0xa91f, 0xa937, 0xa94f, 0xa967, 0xa97f, 0xa997, 0xa9af, 0xa9c7,
	0xa9df, 0xa9f7, 0xaa0f, 0xaa27, 0xaa3f, 0xaa57, 0xaa6f, 0xaa87,
	0xaaa0, 0xaab9, 0xaad1, 0xaae9, 0xab01, 0xab19, 0xab31, 0xab4a,
	0xab63, 0xab7c, 0xab95, 0xabae, 0xabc7, 0xabdf, 0xabf6, 0xac0e,
	0xac26, 0xac3e, 0xac56, 0xac6e, 0xac86, 0xac9e, 0xacb6, 0xacce,
	0xace6, 0xacfe, 0xad16, 0xad2e, 0xad46, 0xad5f, 0xad78, 0xad91,
	0xadaa, 0xadc3, 0xaddc, 0xadf5, 0xae0e, 0xae27, 0xae40, 0xae59,
	// Entry 3B00 - 3B3F
	0xae72, 0xae8b, 0xaea3, 0xaebb, 0xaed3, 0xaeeb, 0xaf03, 0xaf1b,
	0xaf33, 0xaf4a, 0xaf61, 0xaf78, 0xaf8f, 0xafa5, 0xafbb, 0xafd3,
	0xafea, 0xb002, 0xb01a, 0xb032, 0xb049, 0xb061, 0xb078, 0xb08e,
	0xb0a3, 0xb0bb, 0xb0d4, 0xb0eb, 0xb103, 0xb11a, 0xb130, 0xb147,
	0xb15e, 0xb176, 0xb18e, 0xb1a6, 0xb1c4, 0xb1e2, 0xb200, 0xb21d,
	0xb23a, 0xb258, 0xb277, 0xb293, 0xb2af, 0xb2cb, 0xb2e7, 0xb304,
	0xb322, 0xb33e, 0xb35d, 0xb379, 0xb38e, 0xb3a3, 0xb3b9, 0xb3d0,
	0xb3e6, 0xb3fc, 0xb414, 0xb42b, 0xb442, 0xb458, 0xb470, 0xb488,
	// Entry 3B40 - 3B7F
	0xb49f, 0xb4b5, 0xb4cb, 0xb4e0, 0xb4f6, 0xb50c, 0xb522, 0xb538,
	0xb54e, 0xb563, 0xb578, 0xb58e, 0xb5a3, 0xb5b8, 0xb5cf, 0xb5e5,
	0xb5fb, 0xb610, 0xb626, 0xb63b, 0xb650, 0xb664, 0xb67c, 0xb694,
	0xb6b0, 0xb6ce, 0xb6ea, 0xb70c, 0xb729, 0xb745, 0xb768, 0xb785,
	0xb7a4, 0xb7c3, 0xb7e5, 0xb808, 0xb82b, 0xb84d, 0xb870, 0xb894,
	0xb8b3, 0xb8db, 0xb8f9, 0xb915, 0xb936, 0xb951, 0xb972, 0xb98e,
	0xb9ab, 0xb9cf, 0xb9eb, 0xba06, 0xba28, 0xba44, 0xba62, 0xba7d,
	0xbaa0, 0xbac1, 0xbae2, 0xbaff, 0xbb1a, 0xbb37, 0xbb54, 0xbb6f,
	// Entry 3B80 - 3BBF
	0xbb8d, 0xbbb3, 0xbbd2, 0xbbf1, 0xbc0d, 0xbc2e, 0xbc49, 0xbc66,
	0xbc86, 0xbca6, 0xbcc6, 0xbce6, 0xbd06, 0xbd26, 0xbd46, 0xbd66,
	0xbd86, 0xbda6, 0xbdc6, 0xbde6, 0xbe06, 0xbe26, 0xbe46, 0xbe66,
	0xbe86, 0xbea6, 0xbec6, 0xbee6, 0xbf06, 0xbf26, 0xbf46, 0xbf66,
	0xbf86, 0xbfa6, 0xbfc6, 0xbfe6, 0xc006, 0xc026, 0xc046, 0xc066,
	0xc086, 0xc0a6, 0xc0c6, 0xc0e6, 0xc106, 0xc126, 0xc146, 0xc166,
	0xc186, 0xc1a6, 0xc1c6, 0xc1e6, 0xc206, 0xc226, 0xc246, 0xc266,
	0xc286, 0xc2a6, 0xc2c6, 0xc2e6, 0xc306, 0xc326, 0xc346, 0xc366,
	// Entry 3BC0 - 3BFF
	0xc386, 0xc3a6, 0xc3c6, 0xc3e6, 0xc406, 0xc426, 0xc446, 0xc466,
	0xc486, 0xc4a6, 0xc4c6, 0xc4e6, 0xc506, 0xc526, 0xc546, 0xc566,
	0xc586, 0xc5a6, 0xc5c6, 0xc5e6, 0xc606, 0xc626, 0xc646, 0xc666,
	0xc686, 0xc6a6, 0xc6c6, 0xc6e6, 0xc706, 0xc726, 0xc746, 0xc766,
	0xc786, 0xc7a6, 0xc7c6, 0xc7e6, 0xc806, 0xc826, 0xc846, 0xc866,
	0xc886, 0xc8a6, 0xc8c6, 0xc8e6, 0xc906, 0xc926, 0xc946, 0xc966,
	0xc986, 0xc9a6, 0xc9c6, 0xc9e6, 0xca06, 0xca26, 0xca46, 0xca66,
	0xca86, 0xcaa6, 0xcac6, 0xcae6, 0xcb06, 0xcb26, 0xcb46, 0xcb66,
	// Entry 3C00 - 3C3F
	0xcb86, 0xcba6, 0xcbc6, 0xcbe6, 0xcc06, 0xcc26, 0xcc46, 0xcc66,
	0xcc86, 0xcca6, 0xccc6, 0xcce6, 0xcd06, 0xcd26, 0xcd46, 0xcd66,
	0xcd86, 0xcda6, 0xcdc6, 0xcde6, 0xce06, 0xce26, 0xce46, 0xce66,
	0xce86, 0xcea6, 0xcec6, 0xcee6, 0xcf06, 0xcf26, 0xcf46, 0xcf66,
	0xcf86, 0xcfa6, 0xcfc6, 0xcfe6, 0xd006, 0xd026, 0xd046, 0xd066,
	0xd086, 0xd0a6, 0xd0c6, 0xd0e6, 0xd106, 0xd126, 0xd146, 0xd166,
	0xd186, 0xd1a6, 0xd1c6, 0xd1e6, 0xd206, 0xd226, 0xd246, 0xd266,
	0xd286, 0xd2a6, 0xd2c6, 0xd2e6, 0xd306, 0xd326, 0xd346, 0xd366,
	// Entry 3C40 - 3C7F
	0xd386, 0xd3a6, 0xd3c6, 0xd3e6, 0xd406, 0xd426, 0xd446, 0xd466,
	0xd486, 0xd4a6, 0xd4c6, 0xd4e6, 0xd506, 0xd526, 0xd546, 0xd566,
	0xd586, 0xd5a6, 0xd5c6, 0xd5e6, 0xd606, 0xd626, 0xd646, 0xd666,
	0xd686, 0xd6a6, 0xd6c6, 0xd6e6, 0xd706, 0xd726, 0xd746, 0xd766,
	0xd786, 0xd7a6, 0xd7c6, 0xd7e6, 0xd806, 0xd826, 0xd846, 0xd866,
	0xd886, 0xd8a6, 0xd8c6, 0xd8e6, 0xd906, 0xd926, 0xd946, 0xd966,
	0xd986, 0xd9a6, 0xd9c6, 0xd9e6, 0xda06, 0xda26, 0xda46, 0xda66,
	0xda86, 0xdaa6, 0xdac6, 0xdae6, 0xdb06, 0xdb26, 0xdb46, 0xdb66,
	// Entry 3C80 - 3CBF
	0xdb86, 0xdba6, 0xdbc6, 0xdbe6, 0xdc06, 0xdc26, 0xdc46, 0xdc66,
	0xdc86, 0xdca6, 0xdcc6, 0xdce6, 0xdd06, 0xdd26, 0xdd46, 0xdd66,
	0xdd86, 0xdda6, 0xddc6, 0xdde6, 0xde06, 0xde26, 0xde46, 0xde66,
	0xde86, 0xdea6, 0xdec6, 0xdee6, 0xdf06, 0xdf26, 0xdf46, 0xdf66,
	0xdf86, 0xdfa6, 0xdfc6, 0xdfe6, 0xe006, 0xe026, 0xe046, 0xe066,
	0xe086, 0xe0a6, 0xe0c6, 0xe0e6, 0xe106, 0xe126, 0xe146, 0xe166,
	0xe186, 0xe1a6, 0xe1c6, 0xe1e6, 0xe206, 0xe226, 0xe246, 0xe266,
	0xe286, 0xe2a6, 0xe2c6, 0xe2e6, 0xe306, 0xe326, 0xe346, 0xe366,
	// Entry 3CC0 - 3CFF
	0xe386, 0xe3a6, 0xe3c6, 0xe3e6, 0xe406, 0xe426, 0xe446, 0xe466,
	0xe486, 0xe4a6, 0xe4c6, 0xe4e6, 0xe506, 0xe526, 0xe546, 0xe566,
	0xe586, 0xe5a6, 0xe5c6, 0xe5e6, 0xe606, 0xe626, 0xe646, 0xe666,
	0xe686, 0xe6a6, 0xe6c6, 0xe6e6, 0xe706, 0xe726, 0xe746, 0xe766,
	0xe786, 0xe7a6, 0xe7c6, 0xe7e6, 0xe806, 0xe826, 0xe846, 0xe866,
	0xe886, 0xe8a6, 0xe8c6, 0xe8e6, 0xe906, 0xe926, 0xe946, 0xe966,
	0xe986, 0xe9a6, 0xe9c6, 0xe9e6, 0xea06, 0xea26, 0xea46, 0xea66,
	0xea86, 0xeaa6, 0xeac6, 0xeae6, 0xeb06, 0xeb26, 0xeb46, 0xeb66,
	// Entry 3D00 - 3D3F
	0xeb86, 0xeba6, 0xebc6, 0xebe6, 0xec06, 0xec26, 0xec46, 0xec66,
	0xec86, 0xeca6, 0xecc6, 0xece6, 0xed06, 0xed26, 0xed46, 0xed66,
	0xed86, 0xeda6, 0xedc6, 0xede6, 0xee06, 0xee26, 0xee46, 0xee66,
	0xee86, 0xeea6, 0xeec6, 0xeee6, 0xef06, 0xef26, 0xef46, 0xef66,
	0xef86, 0xefa6, 0xefc6, 0xefe6, 0xf006, 0xf026, 0xf046, 0xf066,
	0xf086, 0xf0a6, 0xf0c6, 0xf0e6, 0xf106, 0xf126, 0xf146, 0xf166,
	0xf186, 0xf1a6, 0xf1c6, 0xf1e6, 0xf206, 0xf226, 0xf246, 0xf266,
	0xf286, 0xf2a6, 0xf2c6, 0xf2e6, 0xf306, 0xf326, 0xf346, 0xf366,
	// Entry 3D40 - 3D7F
	0xf386, 0xf3a6, 0xf3c6, 0xf3e6, 0xf406, 0xf426, 0xf446, 0xf466,
	0xf486, 0xf4a6, 0xf4c6, 0xf4e6, 0xf506, 0xf526, 0xf546, 0xf566,
	0xf586, 0xf5a6, 0xf5c6, 0xf5e6, 0xf606, 0xf626, 0xf646, 0xf666,
	0xf686, 0xf6a6, 0xf6c6, 0xf6e6, 0xf706, 0xf726, 0xf746, 0xf766,
	0xf786, 0xf79d, 0xf7b4, 0xf7cb, 0xf7e3, 0xf7fb, 0xf818, 0xf82f,
	0xf84e, 0xf86d, 0xf88c, 0xf8ab, 0xf8ca, 0xf8e6, 0xf907, 0xf92c,
	0xf94a, 0xf961, 0xf979, 0xf98e, 0xf9a4, 0xf9bc, 0xf9d8, 0xf9ef,
	0xfa05, 0xfa28, 0xfa48, 0xfa67, 0xfa92, 0xfabc, 0xfad9, 0xfaf7,
	// Entry 3D80 - 3DBF
	0xfb14, 0xfb31, 0xfb50, 0xfb6f, 0xfb8a, 0xfba7, 0xfbc6, 0xfbe3,
	0xfc00, 0xfc23, 0xfc40, 0xfc5f, 0xfc7c, 0xfc99, 0xfcb9, 0xfcdb,
	0xfcf7, 0xfd16, 0xfd33, 0xfd51, 0xfd6f, 0xfd8c, 0xfda8, 0xfdc3,
	0xfdde, 0xfdf8, 0xfe12, 0xfe38, 0xfe5b, 0xfe7b, 0xfe98, 0xfeb7,
	0xfed5, 0xfef4, 0xff10, 0xff2e, 0xff4b, 0xff6c, 0xff8a, 0xffaa,
	0xffc9, 0xffeb, 0x000a, 0x002b, 0x004b, 0x006c, 0x008a, 0x00aa,
	0x00c9, 0x00e9, 0x0106, 0x0125, 0x0143, 0x0162, 0x017e, 0x019c,
	0x01b9, 0x01da, 0x01f8, 0x0218, 0x0237, 0x0257, 0x0274, 0x0293,
	// Entry 3DC0 - 3DFF
	0x02b1, 0x02d1, 0x02ee, 0x030d, 0x032b, 0x034c, 0x036a, 0x038a,
	0x03a9, 0x03cc, 0x03ec, 0x040e, 0x042f, 0x0451, 0x0470, 0x0491,
	0x04af, 0x04ce, 0x04ea, 0x050a, 0x0527, 0x0546, 0x0562, 0x0582,
	0x059f, 0x05c0, 0x05de, 0x05fe, 0x061d, 0x063c, 0x0658, 0x0676,
	0x0693, 0x06b3, 0x06d0, 0x06ef, 0x070d, 0x072e, 0x074c, 0x076c,
	0x078b, 0x07b2, 0x07d6, 0x07f7, 0x0815, 0x0835, 0x0854, 0x0882,
	0x08ad, 0x08d1, 0x08f2, 0x0915, 0x0937, 0x0962, 0x098a, 0x09b4,
	0x09dd, 0x0a03, 0x0a26, 0x0a5d, 0x0a91, 0x0aa8, 0x0abf, 0x0adb,
	// Entry 3E00 - 3E3F
	0x0af7, 0x0b15, 0x0b33, 0x0b64, 0x0b95, 0x0bb2, 0x0bcf, 0x0bf6,
	0x0c1d, 0x0c44, 0x0c56, 0x0c73, 0x0c90, 0x0ca9, 0x0cc6, 0x0ce9,
	0x0d16, 0x0d3d, 0x0d66, 0x0d8f, 0x0db1, 0x0ddc, 0x0e06, 0x0e25,
	0x0e4d, 0x0e76, 0x0ea1, 0x0ed5, 0x0f07, 0x0f27, 0x0f45, 0x0f60,
	0x0f7d, 0x0f99, 0x0fb6, 0x0fd0, 0x0fee, 0x1009, 0x1027, 0x1042,
	0x1070, 0x108e, 0x10a9, 0x10cf, 0x10f2, 0x1118, 0x113b, 0x1158,
	0x1172, 0x118e, 0x11a9, 0x11e6, 0x1222, 0x125e, 0x1297, 0x12d1,
	0x1308, 0x1343, 0x137b, 0x13b4, 0x13ea, 0x1424, 0x145b, 0x1495,
	// Entry 3E40 - 3E7F
	0x14cc, 0x1505, 0x153b, 0x1573, 0x15c6, 0x1616, 0x1668, 0x168d,
	0x16af, 0x16d3, 0x16f6, 0x1732, 0x176d, 0x17a9, 0x17ed, 0x1828,
	0x1853, 0x187d, 0x18a8, 0x18d3, 0x1906, 0x1930, 0x195b, 0x1985,
	0x19b0, 0x19db, 0x1a0e, 0x1a38, 0x1a64, 0x1a90, 0x1ac4, 0x1aef,
	0x1b1a, 0x1b46, 0x1b71, 0x1b9c, 0x1bc8, 0x1bf3, 0x1c1f, 0x1c4b,
	0x1c76, 0x1ca2, 0x1cce, 0x1cf8, 0x1d23, 0x1d4e, 0x1d78, 0x1da3,
	0x1dce, 0x1df8, 0x1e23, 0x1e4e, 0x1e79, 0x1ea4, 0x1ed1, 0x1efe,
	0x1f29, 0x1f53, 0x1f7e, 0x1fa9, 0x1fdc, 0x2006, 0x2030, 0x205b,
	// Entry 3E80 - 3EBF
	0x208e, 0x20b8, 0x20e3, 0x210e, 0x2138, 0x2163, 0x218d, 0x21b8,
	0x21eb, 0x2215, 0x2240, 0x226a, 0x2295, 0x22c0, 0x22f3, 0x231d,
	0x2349, 0x2374, 0x23a0, 0x23cc, 0x2400, 0x242b, 0x2457, 0x2482,
	0x24ae, 0x24da, 0x250e, 0x2539, 0x2564, 0x258f, 0x25c2, 0x25ec,
	0x2617, 0x2641, 0x266c, 0x2697, 0x26ca, 0x26f4, 0x272c, 0x2763,
	0x27a3, 0x27d5, 0x2807, 0x2836, 0x2865, 0x2894, 0x28ce, 0x2906,
	0x293f, 0x2978, 0x29b1, 0x29f2, 0x2a2a, 0x2a51, 0x2a79, 0x2aa1,
	0x2ac9, 0x2af9, 0x2b20, 0x2b47, 0x2b6f, 0x2b97, 0x2bbf, 0x2bef,
	// Entry 3EC0 - 3EFF
	0x2c16, 0x2c3e, 0x2c67, 0x2c90, 0x2cb9, 0x2cea, 0x2d12, 0x2d42,
	0x2d69, 0x2d99, 0x2dc0, 0x2de8, 0x2e0f, 0x2e37, 0x2e67, 0x2e8e,
	0x2eb6, 0x2ee6, 0x2f0d, 0x2f36, 0x2f5f, 0x2f87, 0x2fb0, 0x2fd9,
	0x3002, 0x3033, 0x305b, 0x3098, 0x30bf, 0x30e7, 0x310f, 0x3137,
	0x3167, 0x318e, 0x31c9, 0x3203, 0x323e, 0x3279, 0x32b3, 0x32dd,
	0x3306, 0x3330, 0x335a, 0x3383, 0x33ad, 0x33d6, 0x3400, 0x342a,
	0x3453, 0x347e, 0x34a8, 0x34d3, 0x34fd, 0x3527, 0x3552, 0x357d,
	0x35a8, 0x35d2, 0x35fd, 0x3628, 0x3651, 0x367b, 0x36a5, 0x36cf,
	// Entry 3F00 - 3F3F
	0x36f8, 0x3722, 0x374c, 0x3775, 0x379f, 0x37c9, 0x37f3, 0x381f,
	0x384b, 0x3875, 0x389e, 0x38c8, 0x38f2, 0x391b, 0x3945, 0x396f,
	0x3998, 0x39c2, 0x39eb, 0x3a15, 0x3a3f, 0x3a68, 0x3a92, 0x3abc,
	0x3ae5, 0x3b10, 0x3b3a, 0x3b65, 0x3b90, 0x3bbb, 0x3be5, 0x3c10,
	0x3c3b, 0x3c65, 0x3c8f, 0x3cb9, 0x3cef, 0x3d19, 0x3d42, 0x3d6c,
	0x3d96, 0x3dbf, 0x3df9, 0x3e32, 0x3e5b, 0x3e83, 0x3eac, 0x3ed4,
	0x3efe, 0x3f27, 0x3f51, 0x3f7a, 0x3fa5, 0x3fcf, 0x3ff7, 0x4020,
	0x4049, 0x4073, 0x409c, 0x40c5, 0x40ed, 0x411a, 0x4147, 0x4174,
	// Entry 3F40 - 3F7F
	0x41a7, 0x41d1, 0x4204, 0x422e, 0x4263, 0x428f, 0x42c3, 0x42ee,
	0x4323, 0x434f, 0x4382, 0x43ac, 0x43e0, 0x440b, 0x443f, 0x446a,
	0x449d, 0x44c7, 0x44fa, 0x4524, 0x4551, 0x457d, 0x45aa, 0x45d7,
	0x4603, 0x462e, 0x4658, 0x4682, 0x46b2, 0x46d9, 0x4709, 0x4730,
	0x4762, 0x478b, 0x47bc, 0x47e4, 0x4816, 0x483f, 0x486f, 0x4896,
	0x48c7, 0x48ef, 0x4920, 0x4948, 0x4978, 0x499f, 0x49cf, 0x49f6,
	0x4a20, 0x4a49, 0x4a73, 0x4a9d, 0x4ac6, 0x4aee, 0x4b15, 0x4b3c,
	0x4b68, 0x4b93, 0x4bbf, 0x4beb, 0x4c15, 0x4c40, 0x4c6a, 0x4c94,
	// Entry 3F80 - 3FBF
	0x4cbd, 0x4ce7, 0x4d12, 0x4d3c, 0x4d67, 0x4d90, 0x4db9, 0x4de6,
	0x4e16, 0x4e2d, 0x4e45, 0x4e64, 0x4e84, 0x4ea6, 0x4ec8, 0x4eec,
	0x4f10, 0x4f3b, 0x4f5b, 0x4f7c, 0x4f9f, 0x4fcb, 0x4fe9, 0x501e,
	0x503f, 0x5063, 0x5083, 0x50b7, 0x50e8, 0x511b, 0x514e, 0x5182,
	0x51b6, 0x51e9, 0x521d, 0x524f, 0x5283, 0x52b4, 0x52ee, 0x5322,
	0x5356, 0x5391, 0x53c3, 0x53f7, 0x542c, 0x545f, 0x5494, 0x54c4,
	0x54f6, 0x5528, 0x555b, 0x5590, 0x55c3, 0x55f7, 0x562d, 0x5661,
	0x5697, 0x56d0, 0x5702, 0x5736, 0x5767, 0x579a, 0x57ce, 0x57ff,
	// Entry 3FC0 - 3FFF
	0x5831, 0x5863, 0x5897, 0x58d1, 0x5905, 0x5938, 0x5974, 0x59a6,
	0x59da, 0x5a0b, 0x5a3d, 0x5a6e, 0x5a9e, 0x5ad7, 0x5b0b, 0x5b3d,
	0x5b6f, 0x5ba3, 0x5bd4, 0x5c07, 0x5c3b, 0x5c6f, 0x5ca0, 0x5cd4,
	0x5d09, 0x5d3e, 0x5d73, 0x5d98, 0x5dbf, 0x5df4, 0x5e28, 0x5e5c,
	0x5e90, 0x5eca, 0x5efd, 0x5f32, 0x5f6d, 0x5f9f, 0x5fda, 0x600c,
	0x6040, 0x6071, 0x60a2, 0x60dc, 0x610d, 0x6147, 0x6178, 0x61b2,
	0x61e4, 0x621e, 0x6259, 0x6294, 0x62c4, 0x62f6, 0x6326, 0x6357,
	0x6388, 0x63b8, 0x63e9, 0x641a, 0x644c, 0x647d, 0x64ae, 0x64e1,
	// Entry 4000 - 403F
	0x6514, 0x6545, 0x6576, 0x65aa, 0x65dc, 0x6610, 0x6642, 0x6674,
	0x66a6, 0x66d7, 0x6708, 0x673a, 0x676b, 0x679b, 0x67cf, 0x6803,
	0x6837, 0x6869, 0x689b, 0x68c2, 0x68ea, 0x6914, 0x6940, 0x697b,
	0x69b5, 0x69db, 0x69fc, 0x6a39, 0x6a75, 0x6a98, 0x6abb, 0x6ae1,
	0x6b04, 0x6b28, 0x6b4c, 0x6b72, 0x6b95, 0x6bc0, 0x6bdf, 0x6be8,
	0x6c15, 0x6c3a, 0x6c56, 0x6c6a, 0x6c7e, 0x6c92, 0x6ca6, 0x6cba,
	0x6cce, 0x6ce2, 0x6cf6, 0x6d0a, 0x6d1f, 0x6d34, 0x6d49, 0x6d5e,
	0x6d73, 0x6d88, 0x6d9d, 0x6dc1, 0x6df1, 0x6e25, 0x6e49, 0x6e71,
	// Entry 4040 - 407F
	0x6ea0, 0x6ecc, 0x6f08, 0x6f45, 0x6f77, 0x6f93, 0x6fb0, 0x6fd0,
	0x6ff1, 0x700b, 0x7026, 0x7041, 0x7063, 0x7086, 0x70a5, 0x70c5,
	0x70e5, 0x7106, 0x7127, 0x7149, 0x716c, 0x7199, 0x71bf, 0x71e5,
	0x720c, 0x7238, 0x7267, 0x7297, 0x72c8, 0x72fa, 0x7334, 0x736f,
	0x73ab, 0x73e8, 0x7420, 0x7459, 0x748a, 0x74bc, 0x74ee, 0x7521,
	0x7559, 0x7592, 0x759c, 0x75ac, 0x75de, 0x7611, 0x7620, 0x7633,
	0x7640, 0x7654, 0x7663, 0x7676, 0x7683, 0x768e, 0x76a5, 0x76b4,
	0x76c3, 0x76ce, 0x76e1, 0x76f7, 0x7704, 0x771a, 0x7731, 0x7749,
	// Entry 4080 - 40BF
	0x7762, 0x7783, 0x77a5, 0x77b6, 0x77c5, 0x77d3, 0x77e2, 0x77f4,
	0x7808, 0x781f, 0x7830, 0x7845, 0x7856, 0x7868, 0x787b, 0x7898,
	0x78ba, 0x78d7, 0x78eb, 0x7908, 0x7922, 0x793a, 0x7954, 0x796c,
	0x7986, 0x799e, 0x79b9, 0x79d2, 0x79ec, 0x7a04, 0x7a25, 0x7a56,
	0x7a84, 0x7ab5, 0x7ae3, 0x7b13, 0x7b40, 0x7b71, 0x7b9f, 0x7bcf,
	0x7bfc, 0x7c2b, 0x7c59, 0x7c79, 0x7c96, 0x7cb5, 0x7cd1, 0x7cef,
	0x7d0c, 0x7d33, 0x7d57, 0x7d76, 0x7d92, 0x7db0, 0x7dcd, 0x7ded,
	0x7e0a, 0x7e29, 0x7e47, 0x7e67, 0x7e84, 0x7ea3, 0x7ec1, 0x7ee0,
	// Entry 40C0 - 40FF
	0x7efc, 0x7f1a, 0x7f37, 0x7f57, 0x7f74, 0x7f93, 0x7fb1, 0x7fd0,
	0x7fec, 0x800c, 0x8029, 0x8048, 0x8064, 0x8084, 0x80a1, 0x80c1,
	0x80de, 0x80fd, 0x811b, 0x813c, 0x815a, 0x817a, 0x8199, 0x81b8,
	0x81d4, 0x81f2, 0x820f, 0x822e, 0x824a, 0x8268, 0x8285, 0x82a4,
	0x82c0, 0x82de, 0x82fb, 0x831a, 0x8336, 0x8354, 0x8371, 0x8390,
	0x83ac, 0x83ca, 0x83e7, 0x8408, 0x8426, 0x8446, 0x8465, 0x8484,
	0x84a0, 0x84be, 0x84db, 0x84fa, 0x8516, 0x8534, 0x8551, 0x8570,
	0x858c, 0x85aa, 0x85c7, 0x85e6, 0x8602, 0x8620, 0x863d, 0x865d,
	// Entry 4100 - 413F
	0x867a, 0x8699, 0x86b7, 0x86d7, 0x86f4, 0x8713, 0x8731, 0x8750,
	0x876c, 0x878a, 0x87a7, 0x87c6, 0x87e2, 0x880a, 0x882f, 0x884e,
	0x886a, 0x8888, 0x88a5, 0x88e1, 0x891a, 0x8956, 0x898f, 0x89cb,
	0x8a04, 0x8a2f, 0x8a57, 0x8a70, 0x8a8a, 0x8aa2, 0x8ab7, 0x8acc,
	0x8ae2, 0x8af5, 0x8b09, 0x8b23, 0x8b3e, 0x8b50, 0x8b63, 0x8b72,
	0x8b88, 0x8b9b, 0x8bac, 0x8bc0, 0x8bd3, 0x8be6, 0x8bfb, 0x8c0f,
	0x8c23, 0x8c36, 0x8c4b, 0x8c60, 0x8c74, 0x8c83, 0x8c96, 0x8cae,
	0x8cc3, 0x8cde, 0x8cf5, 0x8d0c, 0x8d2c, 0x8d4c, 0x8d6c, 0x8d8c,
	// Entry 4140 - 417F
	0x8dac, 0x8dcc, 0x8dec, 0x8e0c, 0x8e2c, 0x8e4c, 0x8e6c, 0x8e8c,
	0x8eac, 0x8ecc, 0x8eec, 0x8f0c, 0x8f2c, 0x8f4c, 0x8f6c, 0x8f8c,
	0x8fac, 0x8fcc, 0x8fec, 0x900c, 0x902c, 0x904c, 0x9069, 0x9082,
	0x90a0, 0x90bb, 0x90cd, 0x90e3, 0x9101, 0x911f, 0x913d, 0x915b,
	0x9179, 0x9197, 0x91b5, 0x91d3, 0x91f1, 0x920f, 0x922d, 0x924b,
	0x9269, 0x9287, 0x92a5, 0x92c3, 0x92e1, 0x92ff, 0x931d, 0x933b,
	0x9359, 0x9377, 0x9395, 0x93b3, 0x93d1, 0x93ef, 0x940b, 0x9422,
	0x943f, 0x944e, 0x946e, 0x948f, 0x94ae, 0x94cb, 0x94e9, 0x9504,
	// Entry 4180 - 41BF
	0x9521, 0x953d, 0x955e, 0x957f, 0x95a0, 0x95c1, 0x95e2, 0x9604,
	0x9626, 0x9648, 0x966a, 0x969a, 0x96b5, 0x96d0, 0x96eb, 0x9706,
	0x9721, 0x973d, 0x9759, 0x9775, 0x9791, 0x97ad, 0x97c9, 0x97e5,
	0x9801, 0x981d, 0x9839, 0x9855, 0x9871, 0x988d, 0x98a9, 0x98c5,
	0x98e1, 0x98fd, 0x9919, 0x9935, 0x9951, 0x996d, 0x9989, 0x99a5,
	0x99c1, 0x99dd, 0x99f9, 0x9a15, 0x9a31, 0x9a4d, 0x9a69, 0x9a85,
	0x9aa1, 0x9abd, 0x9ad9, 0x9af5, 0x9b11, 0x9b2d, 0x9b49, 0x9b65,
	0x9b80, 0x9ba4, 0x9bcd, 0x9be4, 0x9c02, 0x9c25, 0x9c48, 0x9c65,
	// Entry 41C0 - 41FF
	0x9c88, 0x9cab, 0x9cc9, 0x9cec, 0x9d09, 0x9d2d, 0x9d50, 0x9d73,
	0x9d95, 0x9dba, 0x9ddf, 0x9e02, 0x9e1f, 0x9e3c, 0x9e5e, 0x9e80,
	0x9e9c, 0x9ebd, 0x9eda, 0x9ef7, 0x9f19, 0x9f38, 0x9f57, 0x9f76,
	0x9f95, 0x9fb2, 0x9fcb, 0x9fe5, 0x9fff, 0xa01a, 0xa034, 0xa04d,
	0xa068, 0xa082, 0xa09b, 0xa0b5, 0xa0d0, 0xa0ea, 0xa104, 0xa11d,
	0xa138, 0xa152, 0xa16c, 0xa186, 0xa1a0, 0xa1ba, 0xa1d3, 0xa1e6,
	0xa1fa, 0xa20c, 0xa21c, 0xa230, 0xa242, 0xa254, 0xa272, 0xa28b,
	0xa2a2, 0xa2bc, 0xa2d5, 0xa2eb, 0xa301, 0xa31e, 0xa33e, 0xa35f,
	// Entry 4200 - 423F
	0xa37b, 0xa390, 0xa3a8, 0xa3c0, 0xa3d8, 0xa3f0, 0xa408, 0xa421,
	0xa43a, 0xa453, 0xa46c, 0xa485, 0xa49e, 0xa4b7, 0xa4d0, 0xa4e9,
	0xa502, 0xa51b, 0xa534, 0xa54d, 0xa566, 0xa57f, 0xa598, 0xa5b1,
	0xa5ca, 0xa5e3, 0xa5fc, 0xa615, 0xa62e, 0xa647, 0xa660, 0xa679,
	0xa692, 0xa6ab, 0xa6c4, 0xa6dd, 0xa6f6, 0xa70f, 0xa728, 0xa741,
	0xa75a, 0xa773, 0xa78c, 0xa7a5, 0xa7be, 0xa7d7, 0xa7f0, 0xa809,
	0xa822, 0xa83b, 0xa854, 0xa86d, 0xa886, 0xa89f, 0xa8b8, 0xa8d1,
	0xa8ea, 0xa903, 0xa91c, 0xa935, 0xa94e, 0xa967, 0xa980, 0xa999,
	// Entry 4240 - 427F
	0xa9b2, 0xa9cc, 0xa9e6, 0xaa00, 0xaa1a, 0xaa34, 0xaa4e, 0xaa68,
	0xaa82, 0xaa9c, 0xaab6, 0xaad0, 0xaae4, 0xaaf8, 0xab0c, 0xab20,
	0xab34, 0xab48, 0xab5c, 0xab70, 0xab84, 0xab98, 0xabac, 0xabc0,
	0xabd4, 0xabe8, 0xac02, 0xac1e, 0xac39, 0xac55, 0xac71, 0xac91,
	0xacac, 0xacc7, 0xace7, 0xad06, 0xad21, 0xad3d, 0xad58, 0xad74,
	0xad90, 0xadad, 0xadc9, 0xade5, 0xae03, 0xae1e, 0xae3b, 0xae55,
	0xae70, 0xae86, 0xaea2, 0xaebd, 0xaeda, 0xaef5, 0xaf0b, 0xaf26,
	0xaf3c, 0xaf52, 0xaf6d, 0xaf83, 0xaf99, 0xafaf, 0xafcb, 0xafe1,
	// Entry 4280 - 42BF
	0xaff7, 0xb013, 0xb029, 0xb03f, 0xb05d, 0xb07a, 0xb090, 0xb0a6,
	0xb0bc, 0xb0d2, 0xb0e8, 0xb0fe, 0xb114, 0xb12a, 0xb140, 0xb15c,
	0xb172, 0xb18d, 0xb1a3, 0xb1b9, 0xb1cf, 0xb1e5, 0xb1fb, 0xb211,
	0xb227, 0xb23d, 0xb253, 0xb269, 0xb27f, 0xb29c, 0xb2bc, 0xb2da,
	0xb2f6, 0xb312, 0xb328, 0xb344, 0xb35a, 0xb370, 0xb396, 0xb3b4,
	0xb3d8, 0xb3f4, 0xb40a, 0xb420, 0xb43c, 0xb452, 0xb468, 0xb47e,
	0xb494, 0xb4aa, 0xb4c5, 0xb4db, 0xb4f1, 0xb507, 0xb51d, 0xb533,
	0xb550, 0xb56d, 0xb58a, 0xb5a7, 0xb5c4, 0xb5e1, 0xb5fe, 0xb61b,
	// Entry 42C0 - 42FF
	0xb638, 0xb655, 0xb672, 0xb68f, 0xb6ac, 0xb6c9, 0xb6e6, 0xb703,
	0xb720, 0xb73d, 0xb75a, 0xb777, 0xb794, 0xb7b1, 0xb7ce, 0xb7eb,
	0xb808, 0xb825, 0xb842, 0xb85f, 0xb87c, 0xb896, 0xb8af, 0xb8c0,
	0xb8d1, 0xb8e2, 0xb8f5, 0xb907, 0xb919, 0xb92a, 0xb93d, 0xb950,
	0xb962, 0xb973, 0xb987, 0xb99b, 0xb9ae, 0xb9c1, 0xb9d4, 0xb9e9,
	0xb9fd, 0xba11, 0xba2a, 0xba43, 0xba5e, 0xba78, 0xba92, 0xbaab,
	0xbac6, 0xbae1, 0xbafb, 0xbb15, 0xbb2f, 0xbb4b, 0xbb66, 0xbb81,
	0xbb9b, 0xbbb7, 0xbbd3, 0xbbee, 0xbc08, 0xbc25, 0xbc42, 0xbc5e,
	// Entry 4300 - 433F
	0xbc7a, 0xbc96, 0xbcb4, 0xbcd1, 0xbcee, 0xbd05, 0xbd20, 0xbd3c,
	0xbd57, 0xbd73, 0xbd93, 0xbdb6, 0xbdd3, 0xbdef, 0xbe11, 0xbe30,
	0xbe52, 0xbe6d, 0xbe89, 0xbeac, 0xbed0, 0xbef5, 0xbf18, 0xbf3a,
	0xbf5e, 0xbf88, 0xbfb3, 0xbfde, 0xc00a, 0xc02d, 0xc04f, 0xc073,
	0xc09d, 0xc0c8, 0xc0f3, 0xc11e, 0xc14b, 0xc16a, 0xc18f, 0xc1ac,
	0xc1cb, 0xc1ea, 0xc207, 0xc22d, 0xc255, 0xc275, 0xc294, 0xc2c2,
	0xc2e1, 0xc2ff, 0xc31c, 0xc33c, 0xc35d, 0xc38d, 0xc3ae, 0xc3cd,
	0xc3f2, 0xc419, 0xc441, 0xc469, 0xc48f, 0xc4b6, 0xc4da, 0xc500,
	// Entry 4340 - 437F
	0xc527, 0xc549, 0xc56d, 0xc580, 0xc5a2, 0xc5b7, 0xc5d0, 0xc5df,
	0xc5f0, 0xc602, 0xc611, 0xc625, 0xc63b, 0xc650, 0xc665, 0xc678,
	0xc68f, 0xc69f, 0xc6b0, 0xc6c1, 0xc6d2, 0xc6e3, 0xc6f4, 0xc70c,
	0xc71b, 0xc731, 0xc744, 0xc758, 0xc764, 0xc776, 0xc786, 0xc799,
	0xc7ab, 0xc7c5, 0xc7d7, 0xc7ea, 0xc7fe, 0xc813, 0xc827, 0xc834,
	0xc848, 0xc854, 0xc868, 0xc885, 0xc8a3, 0xc8c3, 0xc8dd, 0xc8f5,
	0xc90d, 0xc926, 0xc941, 0xc959, 0xc971, 0xc987, 0xc9a0, 0xc9b7,
	0xc9d2, 0xc9ec, 0xca02, 0xca18, 0xca34, 0xca56, 0xca6f, 0xca86,
	// Entry 4380 - 43BF
	0xca9e, 0xcab7, 0xcad1, 0xcae8, 0xcaff, 0xcb16, 0xcb32, 0xcb48,
	0xcb5e, 0xcb76, 0xcb8d, 0xcba5, 0xcbbb, 0xcbd8, 0xcbef, 0xcc09,
	0xcc23, 0xcc3a, 0xcc54, 0xcc6c, 0xcc85, 0xcca0, 0xccbc, 0xccd8,
	0xcd03, 0xcd12, 0xcd21, 0xcd30, 0xcd40, 0xcd4f, 0xcd5e, 0xcd6d,
	0xcd7c, 0xcd8b, 0xcd9b, 0xcdaa, 0xcdb9, 0xcdc8, 0xcdd7, 0xcde6,
	0xcdf5, 0xce05, 0xce15, 0xce24, 0xce33, 0xce43, 0xce52, 0xce61,
	0xce70, 0xce80, 0xce90, 0xcea0, 0xceaf, 0xcebe, 0xcecd, 0xcedd,
	0xceec, 0xcefb, 0xcf0c, 0xcf1b, 0xcf2b, 0xcf3b, 0xcf4a, 0xcf59,
	// Entry 43C0 - 43FF
	0xcf68, 0xcf77, 0xcf87, 0xcf96, 0xcfa6, 0xcfb7, 0xcfc6, 0xcfd8,
	0xcfe7, 0xcff7, 0xd006, 0xd015, 0xd026, 0xd035, 0xd045, 0xd054,
	0xd063, 0xd075, 0xd084, 0xd094, 0xd0a4, 0xd0b4, 0xd0c3, 0xd0d3,
	0xd0e3, 0xd0f4, 0xd104, 0xd114, 0xd126, 0xd136, 0xd148, 0xd158,
	0xd168, 0xd179, 0xd18a, 0xd19b, 0xd1ac, 0xd1bc, 0xd1ce, 0xd1e9,
	0xd1ff, 0xd215, 0xd22d, 0xd244, 0xd25b, 0xd271, 0xd289, 0xd2a1,
	0xd2b8, 0xd2cf, 0xd2e9, 0xd303, 0xd31c, 0xd335, 0xd34e, 0xd369,
	0xd383, 0xd39d, 0xd3bc, 0xd3db, 0xd3fc, 0xd41c, 0xd43c, 0xd45b,
	// Entry 4400 - 443F
	0xd47c, 0xd49d, 0xd4bd, 0xd4d0, 0xd4e4, 0xd4f8, 0xd50c, 0xd51f,
	0xd533, 0xd547, 0xd55b, 0xd570, 0xd583, 0xd597, 0xd5ab, 0xd5bf,
	0xd5d3, 0xd5e8, 0xd5fb, 0xd60f, 0xd624, 0xd638, 0xd64c, 0xd660,
	0xd674, 0xd687, 0xd69c, 0xd6b1, 0xd6c6, 0xd6da, 0xd6ef, 0xd704,
	0xd718, 0xd72c, 0xd741, 0xd757, 0xd76e, 0xd784, 0xd79c, 0xd7b0,
	0xd7ce, 0xd7ec, 0xd7fe, 0xd813, 0xd825, 0xd837, 0xd84b, 0xd861,
	0xd873, 0xd885, 0xd899, 0xd8aa, 0xd8bd, 0xd8d0, 0xd8e3, 0xd8f7,
	0xd908, 0xd91a, 0xd930, 0xd944, 0xd957, 0xd96a, 0xd97d, 0xd990,
	// Entry 4440 - 447F
	0xd9a3, 0xd9b6, 0xd9c9, 0xd9dc, 0xd9f6, 0xda0a, 0xda1f, 0xda34,
	0xda49, 0xda5c, 0xda72, 0xda89, 0xda9f, 0xdab6, 0xdac9, 0xdadf,
	0xdaf4, 0xdb0b, 0xdb22, 0xdb38, 0xdb4e, 0xdb63, 0xdb78, 0xdb8d,
	0xdba0, 0xdbb7, 0xdbce, 0xdbe7, 0xdbfc, 0xdc12, 0xdc25, 0xdc39,
	0xdc4d, 0xdc61, 0xdc77, 0xdc8c, 0xdca1, 0xdcb7, 0xdccc, 0xdce0,
	0xdcf4, 0xdd08, 0xdd1c, 0xdd3a, 0xdd59, 0xdd79, 0xdd9a, 0xddb9,
	0xddcd, 0xdde1, 0xddf6, 0xde09, 0xde1e, 0xde30, 0xde42, 0xde56,
	0xde6a, 0xde7d, 0xde90, 0xdea3, 0xdeb7, 0xdecc, 0xdedf, 0xdef3,
	// Entry 4480 - 44BF
	0xdf06, 0xdf18, 0xdf2d, 0xdf40, 0xdf52, 0xdf66, 0xdf7a, 0xdf8f,
	0xdfa5, 0xdfba, 0xdfcc, 0xdfdd, 0xdfee, 0xe001, 0xe016, 0xe028,
	0xe03a, 0xe04c, 0xe05f, 0xe072, 0xe085, 0xe098, 0xe0ab, 0xe0be,
	0xe0d1, 0xe0e4, 0xe0f7, 0xe10a, 0xe11d, 0xe130, 0xe143, 0xe157,
	0xe16a, 0xe17d, 0xe190, 0xe1a3, 0xe1b6, 0xe1c9, 0xe1dc, 0xe1ef,
	0xe202, 0xe215, 0xe228, 0xe23b, 0xe24e, 0xe261, 0xe274, 0xe287,
	0xe29b, 0xe2af, 0xe2c2, 0xe2dd, 0xe2fa, 0xe317, 0xe334, 0xe34e,
	0xe36a, 0xe37f, 0xe397, 0xe3af, 0xe3c5, 0xe3db, 0xe3f1, 0xe40a,
	// Entry 44C0 - 44FF
	0xe424, 0xe441, 0xe45e, 0xe47b, 0xe499, 0xe4b6, 0xe4d4, 0xe4f2,
	0xe510, 0xe52e, 0xe54d, 0xe56b, 0xe58a, 0xe5a3, 0xe5bc, 0xe5d5,
	0xe5ef, 0xe607, 0xe621, 0xe63b, 0xe655, 0xe66f, 0xe68a, 0xe6a4,
	0xe6be, 0xe6d8, 0xe6f1, 0xe70b, 0xe725, 0xe740, 0xe759, 0xe773,
	0xe78d, 0xe7a8, 0xe7c1, 0xe7da, 0xe7f3, 0xe80c, 0xe826, 0xe83f,
	0xe858, 0xe873, 0xe88e, 0xe8a9, 0xe8c5, 0xe8e0, 0xe8fc, 0xe918,
	0xe934, 0xe950, 0xe96d, 0xe989, 0xe9a6, 0xe9bd, 0xe9d4, 0xe9eb,
	0xea03, 0xea19, 0xea31, 0xea49, 0xea61, 0xea79, 0xea92, 0xeaaa,
	// Entry 4500 - 453F
	0xeac2, 0xeada, 0xeaf1, 0xeb09, 0xeb21, 0xeb3a, 0xeb51, 0xeb69,
	0xeb81, 0xeb9a, 0xebb1, 0xebc8, 0xebdf, 0xebf6, 0xec0e, 0xec25,
	0xec3c, 0xec4f, 0xec61, 0xec74, 0xec86, 0xec9a, 0xecab, 0xecbe,
	0xecd3, 0xece5, 0xecf8, 0xed0a, 0xed1d, 0xed2f, 0xed41, 0xed54,
	0xed66, 0xed7c, 0xed90, 0xeda2, 0xedb6, 0xedc9, 0xeddc, 0xeded,
	0xedff, 0xee11, 0xee23, 0xee34, 0xee47, 0xee59, 0xee6a, 0xee7d,
	0xee8f, 0xeea1, 0xeeb3, 0xeec5, 0xeed6, 0xeee8, 0xeefb, 0xef0d,
	0xef1f, 0xef31, 0xef42, 0xef54, 0xef66, 0xef7a, 0xef8c, 0xef9e,
	// Entry 4540 - 457F
	0xefb0, 0xefc3, 0xefd4, 0xefe5, 0xeff6, 0xf007, 0xf019, 0xf02c,
	0xf03d, 0xf04e, 0xf062, 0xf074, 0xf087, 0xf098, 0xf0a9, 0xf0bc,
	0xf0cf, 0xf0e2, 0xf0f5, 0xf108, 0xf11a, 0xf12b, 0xf13c, 0xf14c,
	0xf15c, 0xf16c, 0xf17c, 0xf18c, 0xf19d, 0xf1ae, 0xf1bf, 0xf1d1,
	0xf1e2, 0xf1f3, 0xf206, 0xf218, 0xf22a, 0xf23b, 0xf24e, 0xf261,
	0xf273, 0xf289, 0xf2a0, 0xf2b8, 0xf2cf, 0xf2e7, 0xf2ff, 0xf319,
	0xf32f, 0xf347, 0xf35e, 0xf376, 0xf38c, 0xf3a3, 0xf3bc, 0xf3d4,
	0xf3eb, 0xf402, 0xf419, 0xf42f, 0xf447, 0xf45e, 0xf477, 0xf48e,
	// Entry 4580 - 45BF
	0xf4a6, 0xf4bd, 0xf4d6, 0xf4ee, 0xf508, 0xf521, 0xf539, 0xf54f,
	0xf566, 0xf57e, 0xf596, 0xf5ad, 0xf5c5, 0xf5d9, 0xf5ee, 0xf604,
	0xf619, 0xf62f, 0xf645, 0xf65d, 0xf671, 0xf687, 0xf69c, 0xf6b2,
	0xf6c6, 0xf6db, 0xf6f2, 0xf708, 0xf71d, 0xf732, 0xf747, 0xf75b,
	0xf771, 0xf786, 0xf79d, 0xf7b2, 0xf7c8, 0xf7dd, 0xf7f4, 0xf80a,
	0xf822, 0xf839, 0xf84f, 0xf863, 0xf878, 0xf88e, 0xf8a4, 0xf8b9,
	0xf8cf, 0xf8df, 0xf8f0, 0xf901, 0xf913, 0xf924, 0xf936, 0xf948,
	0xf959, 0xf969, 0xf97a, 0xf98b, 0xf99d, 0xf9ae, 0xf9be, 0xf9cf,
	// Entry 45C0 - 45FF
	0xf9e0, 0xf9f1, 0xfa03, 0xfa14, 0xfa25, 0xfa36, 0xfa48, 0xfa58,
	0xfa69, 0xfa7a, 0xfa8b, 0xfa9d, 0xfaae, 0xfac0, 0xfad1, 0xfae3,
	0xfaf3, 0xfb04, 0xfb15, 0xfb25, 0xfb36, 0xfb48, 0xfb5a, 0xfb6f,
	0xfb81, 0xfb9e, 0xfbbb, 0xfbd8, 0xfbf5, 0xfc11, 0xfc2f, 0xfc4c,
	0xfc6a, 0xfc87, 0xfca4, 0xfcc2, 0xfcdf, 0xfcfc, 0xfd19, 0xfd36,
	0xfd54, 0xfd72, 0xfd90, 0xfdad, 0xfdcb, 0xfde8, 0xfe06, 0xfe24,
	0xfe41, 0xfe5e, 0xfe7c, 0xfe99, 0xfeb7, 0xfed4, 0xfef1, 0xff0f,
	0xff2e, 0xff4c, 0xff6a, 0xff86, 0xffa4, 0xffc1, 0xffdf, 0xfffd,
	// Entry 4600 - 463F
	0x001a, 0x0039, 0x0056, 0x0074, 0x0092, 0x00b0, 0x00ce, 0x00eb,
	0x0109, 0x0127, 0x0145, 0x0163, 0x0180, 0x01a0, 0x01b9, 0x01d4,
	0x01ee, 0x0208, 0x0223, 0x023d, 0x0258, 0x0272, 0x028b, 0x02a5,
	0x02bf, 0x02d9, 0x02f4, 0x030d, 0x0328, 0x0342, 0x035c, 0x0376,
	0x0391, 0x03ab, 0x03c5, 0x03e0, 0x03f9, 0x0413, 0x042d, 0x0447,
	0x0461, 0x047c, 0x0496, 0x04b1, 0x04ca, 0x04e4, 0x04fe, 0x0517,
	0x0531, 0x0548, 0x0561, 0x0579, 0x0591, 0x05aa, 0x05c2, 0x05db,
	0x05f3, 0x060a, 0x0622, 0x063a, 0x0652, 0x066b, 0x0682, 0x069b,
	// Entry 4640 - 467F
	0x06b3, 0x06cb, 0x06e3, 0x06fc, 0x0714, 0x072c, 0x0745, 0x075c,
	0x0774, 0x078c, 0x07a4, 0x07bc, 0x07d5, 0x07ed, 0x0806, 0x081d,
	0x0835, 0x084d, 0x0864, 0x087c, 0x088b, 0x089b, 0x08ab, 0x08bc,
	0x08cc, 0x08dd, 0x08ed, 0x08fe, 0x090f, 0x091f, 0x092e, 0x093e,
	0x094e, 0x095f, 0x0970, 0x0982, 0x0992, 0x09a3, 0x09b2, 0x09c2,
	0x09d2, 0x09e2, 0x09f3, 0x0a03, 0x0a13, 0x0a25, 0x0a34, 0x0a44,
	0x0a54, 0x0a64, 0x0a75, 0x0a85, 0x0a96, 0x0aa8, 0x0ab8, 0x0ac9,
	0x0ad8, 0x0ae8, 0x0af8, 0x0b09, 0x0b1a, 0x0b2c, 0x0b3b, 0x0b4b,
	// Entry 4680 - 46BF
	0x0b5b, 0x0b6c, 0x0b7d, 0x0b8e, 0x0ba0, 0x0bb1, 0x0bc2, 0x0bd2,
	0x0be5, 0x0bf8, 0x0c0b, 0x0c1e, 0x0c31, 0x0c44, 0x0c57, 0x0c6a,
	0x0c7d, 0x0c90, 0x0ca3, 0x0cb6, 0x0cc9, 0x0cdc, 0x0cef, 0x0d02,
	0x0d16, 0x0d2a, 0x0d3d, 0x0d51, 0x0d65, 0x0d78, 0x0d8c, 0x0d9f,
	0x0db2, 0x0dc5, 0x0dd8, 0x0deb, 0x0dfe, 0x0e11, 0x0e24, 0x0e37,
	0x0e4a, 0x0e5d, 0x0e70, 0x0e83, 0x0e96, 0x0ea9, 0x0ebc, 0x0ecf,
	0x0ee2, 0x0ef5, 0x0f08, 0x0f1b, 0x0f2e, 0x0f41, 0x0f54, 0x0f67,
	0x0f7a, 0x0f8d, 0x0fa0, 0x0fb3, 0x0fc6, 0x0fd9, 0x0fec, 0x0fff,
	// Entry 46C0 - 46FF
	0x1012, 0x1025, 0x1038, 0x104b, 0x105e, 0x1071, 0x1084, 0x1097,
	0x10aa, 0x10bd, 0x10d0, 0x10e3, 0x10f6, 0x1109, 0x111c, 0x1132,
	0x1145, 0x1158, 0x116b, 0x117e, 0x1191, 0x11a5, 0x11b9, 0x11cc,
	0x11df, 0x11f2, 0x1205, 0x1218, 0x122b, 0x123d, 0x124f, 0x1261,
	0x1273, 0x1285, 0x1297, 0x12a9, 0x12bb, 0x12ce, 0x12e1, 0x12f4,
	0x1306, 0x1318, 0x132a, 0x133d, 0x1350, 0x1363, 0x1375, 0x1387,
	0x1399, 0x13ab, 0x13bd, 0x13cf, 0x13e1, 0x13f3, 0x1405, 0x1417,
	0x1429, 0x143b, 0x144d, 0x145f, 0x1471, 0x1483, 0x1495, 0x14a7,
	// Entry 4700 - 473F
	0x14b9, 0x14cb, 0x14dd, 0x14ef, 0x1501, 0x1513, 0x1525, 0x1537,
	0x1549, 0x155b, 0x156d, 0x157f, 0x1591, 0x15a3, 0x15b5, 0x15c7,
	0x15d9, 0x15eb, 0x15fd, 0x160f, 0x1621, 0x1633, 0x1645, 0x1657,
	0x1669, 0x167b, 0x168d, 0x169f, 0x16b1, 0x16c3, 0x16d5, 0x16e7,
	0x16f9, 0x170b, 0x171d, 0x172f, 0x1741, 0x1753, 0x1765, 0x1777,
	0x178d, 0x17a3, 0x17b9, 0x17cf, 0x17e5, 0x17fb, 0x1811, 0x1827,
	0x183d, 0x1853, 0x1869, 0x187f, 0x1895, 0x18ab, 0x18c1, 0x18d7,
	0x18ed, 0x1903, 0x1919, 0x192b, 0x193d, 0x194f, 0x1961, 0x1973,
	// Entry 4740 - 477F
	0x1985, 0x1997, 0x19a9, 0x19bb, 0x19cd, 0x19df, 0x19f1, 0x1a03,
	0x1a15, 0x1a27, 0x1a39, 0x1a4b, 0x1a5d, 0x1a6f, 0x1a81, 0x1a93,
	0x1aa5, 0x1ab7, 0x1ac9, 0x1adb, 0x1aed, 0x1aff, 0x1b11, 0x1b23,
	0x1b35, 0x1b47, 0x1b59, 0x1b6b, 0x1b7d, 0x1b8f, 0x1ba1, 0x1bb3,
	0x1bc5, 0x1bd7, 0x1be9, 0x1bfb, 0x1c0d, 0x1c1f, 0x1c31, 0x1c43,
	0x1c55, 0x1c67, 0x1c79, 0x1c8b, 0x1c9d, 0x1caf, 0x1cc1, 0x1cd3,
	0x1ce5, 0x1cf7, 0x1d09, 0x1d1b, 0x1d2d, 0x1d3f, 0x1d51, 0x1d63,
	0x1d75, 0x1d87, 0x1d99, 0x1dab, 0x1dbd, 0x1dcf, 0x1de1, 0x1df3,
	// Entry 4780 - 47BF
	0x1e05, 0x1e17, 0x1e29, 0x1e3b, 0x1e4d, 0x1e5f, 0x1e71, 0x1e83,
	0x1e95, 0x1ea7, 0x1eb9, 0x1ecb, 0x1edd, 0x1eef, 0x1f01, 0x1f13,
	0x1f25, 0x1f37, 0x1f49, 0x1f5b, 0x1f6d, 0x1f7f, 0x1f91, 0x1fa3,
	0x1fb5, 0x1fc7, 0x1fd9, 0x1feb, 0x1ffd, 0x200f, 0x2021, 0x2033,
	0x2045, 0x2057, 0x2069, 0x207b, 0x208d, 0x209f, 0x20b1, 0x20c3,
	0x20d5, 0x20e7, 0x20f9, 0x210b, 0x211d, 0x212f, 0x2141, 0x2153,
	0x2165, 0x2177, 0x2189, 0x219b, 0x21ad, 0x21bf, 0x21d1, 0x21e3,
	0x21f5, 0x2207, 0x2219, 0x222b, 0x223d, 0x224f, 0x2261, 0x2275,
	// Entry 47C0 - 47FF
	0x2289, 0x229d, 0x22b1, 0x22c5, 0x22d9, 0x22ed, 0x2301, 0x2315,
	0x232c, 0x2343, 0x235a, 0x2371, 0x2385, 0x2399, 0x23ad, 0x23c5,
	0x23db, 0x23f0, 0x2405, 0x241c, 0x2431, 0x2443, 0x2455, 0x2467,
	0x2479, 0x248b, 0x249d, 0x24af, 0x24c1, 0x24e1, 0x250d, 0x253e,
	0x2556, 0x2575, 0x2596, 0x25b6, 0x25ea, 0x2614, 0x2636, 0x2657,
	0x2678, 0x26a2, 0x26c2, 0x26ee, 0x2710, 0x272f, 0x274e, 0x276f,
	0x2798, 0x27bb, 0x27da, 0x27fe, 0x2832, 0x2852, 0x2872, 0x2893,
	0x28bc, 0x28f0, 0x290a, 0x2938, 0x2956, 0x297e, 0x29a1, 0x29c1,
	// Entry 4800 - 483F
	0x29e3, 0x29fa, 0x2a26, 0x2a65, 0x2a86, 0x2aab, 0x2aca, 0x2af4,
	0x2b14, 0x2b48, 0x2b6a, 0x2b95, 0x2bbc, 0x2bdb, 0x2c03, 0x2c34,
	0x2c52, 0x2c6e, 0x2c8b, 0x2ca9, 0x2cdc, 0x2cfd, 0x2d0f, 0x2d21,
	0x2d33, 0x2d45, 0x2d57, 0x2d6a, 0x2d7d, 0x2d90, 0x2da3, 0x2db6,
	0x2dc9, 0x2ddc, 0x2def, 0x2e02, 0x2e15, 0x2e28, 0x2e3b, 0x2e4e,
	0x2e61, 0x2e74, 0x2e87, 0x2e9a, 0x2ead, 0x2ec0, 0x2ed3, 0x2ee6,
	0x2ef9, 0x2f0c, 0x2f1f, 0x2f32, 0x2f45, 0x2f58, 0x2f6b, 0x2f7e,
	0x2f91, 0x2fa4, 0x2fb7, 0x2fca, 0x2fdd, 0x2ff0, 0x3003, 0x3016,
	// Entry 4840 - 487F
	0x3029, 0x303c, 0x304f, 0x3062, 0x3075, 0x3088, 0x309b, 0x30ae,
	0x30c1, 0x30d4, 0x30e7, 0x30fa, 0x310d, 0x312a, 0x3146, 0x3163,
	0x3181, 0x319b, 0x31b6, 0x31d3, 0x31ef, 0x320b, 0x3227, 0x3243,
	0x3261, 0x327c, 0x3297, 0x32b5, 0x32d1, 0x32eb, 0x3308, 0x3324,
	0x3340, 0x335c, 0x3377, 0x3394, 0x33af, 0x33ca, 0x33e7, 0x3402,
	0x3420, 0x3443, 0x3467, 0x348b, 0x34a1, 0x34b6, 0x34cc, 0x34e3,
	0x34f6, 0x350a, 0x3520, 0x3535, 0x354a, 0x355f, 0x3574, 0x358b,
	0x359f, 0x35b9, 0x35cd, 0x35e4, 0x35f9, 0x360c, 0x3622, 0x3637,
	// Entry 4880 - 48BF
	0x364c, 0x3661, 0x3675, 0x3694, 0x36b4, 0x36c8, 0x36dc, 0x36f2,
	0x3707, 0x371c, 0x3730, 0x3747, 0x3763, 0x3779, 0x3794, 0x37a9,
	0x37bf, 0x37d6, 0x37ef, 0x3802, 0x3816, 0x382c, 0x3841, 0x3856,
	0x3871, 0x3886, 0x38a1, 0x38b6, 0x38d3, 0x38ea, 0x3904, 0x3918,
	0x3932, 0x3946, 0x395d, 0x3972, 0x3985, 0x399b, 0x39b0, 0x39c5,
	0x39e0, 0x39f5, 0x3a09, 0x3a1d, 0x3a31, 0x3a47, 0x3a5c, 0x3a7b,
	0x3a90, 0x3aa4, 0x3abb, 0x3ad7, 0x3aea, 0x3afc, 0x3b0f, 0x3b28,
	0x3b38, 0x3b49, 0x3b5b, 0x3b6d, 0x3b7f, 0x3b91, 0x3ba3, 0x3bb7,
	// Entry 48C0 - 48FF
	0x3bc8, 0x3bd9, 0x3bed, 0x3bfe, 0x3c0e, 0x3c21, 0x3c33, 0x3c45,
	0x3c56, 0x3c67, 0x3c79, 0x3c8a, 0x3c9e, 0x3cb7, 0x3ccc, 0x3ce1,
	0x3cf7, 0x3d0d, 0x3d21, 0x3d36, 0x3d4b, 0x3d60, 0x3d75, 0x3d8a,
	0x3d9f, 0x3db5, 0x3dca, 0x3ddf, 0x3df5, 0x3e0a, 0x3e1e, 0x3e34,
	0x3e49, 0x3e5f, 0x3e75, 0x3e8a, 0x3e9f, 0x3eb4, 0x3ecc, 0x3ee9,
	0x3efe, 0x3f15, 0x3f2e, 0x3f3d, 0x3f4c, 0x3f5b, 0x3f6a, 0x3f79,
	0x3f88, 0x3f97, 0x3fa6, 0x3fb5, 0x3fc4, 0x3fd3, 0x3fe2, 0x3ff1,
	0x4000, 0x4010, 0x401f, 0x402e, 0x403d, 0x404c, 0x405b, 0x406b,
	// Entry 4900 - 493F
	0x407b, 0x408b, 0x409b, 0x40ab, 0x40ba, 0x40d0, 0x40e2, 0x40f4,
	0x4106, 0x4118, 0x412a, 0x413c, 0x414e, 0x4160, 0x4172, 0x4184,
	0x4196, 0x41a8, 0x41ba, 0x41cc, 0x41de, 0x41f0, 0x4202, 0x4214,
	0x4226, 0x4238, 0x424a, 0x425c, 0x426e, 0x4280, 0x4292, 0x42a4,
	0x42c2, 0x42e0, 0x42fe, 0x431c, 0x433b, 0x435a, 0x4379, 0x439a,
	0x43b9, 0x43d8, 0x43f7, 0x4418, 0x4437, 0x4458, 0x4477, 0x4498,
	0x44b7, 0x44d7, 0x44f7, 0x4516, 0x4537, 0x4556, 0x4575, 0x4594,
	0x45b3, 0x45d4, 0x45f3, 0x4614, 0x4633, 0x4652, 0x4673, 0x4696,
	// Entry 4940 - 497F
	0x46af, 0x46c8, 0x46e1, 0x46fa, 0x4714, 0x472e, 0x4748, 0x4762,
	0x477c, 0x4796, 0x47b0, 0x47ca, 0x47e4, 0x47ff, 0x481a, 0x4834,
	0x4856, 0x4870, 0x488a, 0x48a4, 0x48be, 0x48d8, 0x48f2, 0x490c,
	0x4935, 0x4957, 0x4974, 0x4991, 0x49ac, 0x49c7, 0x49e4, 0x4a00,
	0x4a1c, 0x4a37, 0x4a54, 0x4a71, 0x4a8d, 0x4aa8, 0x4ac6, 0x4ae4,
	0x4b01, 0x4b1e, 0x4b3b, 0x4b5a, 0x4b7d, 0x4ba0, 0x4bc5, 0x4be9,
	0x4c0d, 0x4c30, 0x4c55, 0x4c7a, 0x4c9e, 0x4cc2, 0x4ce6, 0x4d0c,
	0x4d31, 0x4d56, 0x4d7a, 0x4da0, 0x4dc6, 0x4deb, 0x4e0f, 0x4e36,
	// Entry 4980 - 49BF
	0x4e5d, 0x4e83, 0x4ea9, 0x4ecf, 0x4ef7, 0x4f1e, 0x4f45, 0x4f71,
	0x4f9d, 0x4fcb, 0x4ff8, 0x5025, 0x5051, 0x507f, 0x50ad, 0x50da,
	0x50ff, 0x5125, 0x514d, 0x5174, 0x519b, 0x51c1, 0x51e9, 0x5211,
	0x5238, 0x525e, 0x5271, 0x5288, 0x529f, 0x52be, 0x52d5, 0x52ec,
	0x5308, 0x5329, 0x5341, 0x5358, 0x536c, 0x5381, 0x5395, 0x53aa,
	0x53be, 0x53d3, 0x53e7, 0x53fc, 0x5411, 0x5427, 0x543c, 0x5452,
	0x5467, 0x547b, 0x5490, 0x54a4, 0x54b9, 0x54cd, 0x54e1, 0x54f6,
	0x550a, 0x551f, 0x5533, 0x5547, 0x555b, 0x556f, 0x5583, 0x5598,
	// Entry 49C0 - 49FF
	0x55ad, 0x55c1, 0x55d5, 0x55e9, 0x55fe, 0x5615, 0x562b, 0x5640,
	0x5659, 0x566e, 0x5687, 0x5698, 0x56ac, 0x56c0, 0x56d6, 0x56eb,
	0x5700, 0x5718, 0x5735, 0x5753, 0x576f, 0x5789, 0x57ac, 0x57c9,
	0x57ec, 0x580b, 0x5827, 0x5843, 0x5866, 0x5882, 0x589d, 0x58bc,
	0x58d9, 0x58f5, 0x5912, 0x592e, 0x594b, 0x5968, 0x5985, 0x59a1,
	0x59bd, 0x59da, 0x59f6, 0x5a14, 0x5a32, 0x5a51, 0x5a6c, 0x5a89,
	0x5aa5, 0x5ac4, 0x5ae2, 0x5b01, 0x5b1f, 0x5b3c, 0x5b59, 0x5b79,
	0x5b96, 0x5bb3, 0x5bd1, 0x5bed, 0x5c0b, 0x5c2e, 0x5c4a, 0x5c66,
	// Entry 4A00 - 4A3F
	0x5c82, 0x5c9f, 0x5cbb, 0x5cd7, 0x5cf4, 0x5d10, 0x5d2c, 0x5d48,
	0x5d65, 0x5d81, 0x5d9e, 0x5dbb, 0x5dd7, 0x5df4, 0x5e10, 0x5e2d,
	0x5e49, 0x5e65, 0x5e82, 0x5e9e, 0x5ebc, 0x5ed8, 0x5ef5, 0x5f12,
	0x5f2e, 0x5f4b, 0x5f67, 0x5f83, 0x5f9f, 0x5fbe, 0x5fd5, 0x5feb,
	0x6002, 0x6019, 0x6031, 0x6049, 0x605d, 0x6072, 0x6084, 0x609b,
	0x60b3, 0x60ca, 0x60e2, 0x60f8, 0x610e, 0x6124, 0x613a, 0x6150,
	0x6167, 0x617f, 0x6198, 0x61b1, 0x61c6, 0x61db, 0x61f3, 0x6209,
	0x6220, 0x6234, 0x6248, 0x625f, 0x6275, 0x628b, 0x62a2, 0x62b8,
	// Entry 4A40 - 4A7F
	0x62ce, 0x62e5, 0x62fa, 0x631c, 0x633e, 0x6353, 0x6369, 0x637e,
	0x6396, 0x63b3, 0x63ce, 0x63ec, 0x6418, 0x643d, 0x6457, 0x6476,
	0x6498, 0x64a8, 0x64b9, 0x64ca, 0x64dc, 0x64ed, 0x64ff, 0x6510,
	0x6522, 0x6532, 0x6543, 0x6553, 0x6564, 0x6574, 0x6585, 0x6595,
	0x65a6, 0x65b7, 0x65c8, 0x65da, 0x65ec, 0x65fd, 0x660f, 0x6621,
	0x6632, 0x6643, 0x6654, 0x6666, 0x6677, 0x6689, 0x669b, 0x66ac,
	0x66bd, 0x66ce, 0x66e0, 0x66f2, 0x6705, 0x6718, 0x6729, 0x673b,
	0x674d, 0x675e, 0x6770, 0x6782, 0x6793, 0x67a4, 0x67b5, 0x67c6,
	// Entry 4A80 - 4ABF
	0x67d7, 0x67e8, 0x67fa, 0x680c, 0x681f, 0x6832, 0x6843, 0x685c,
	0x6882, 0x68a9, 0x68d0, 0x68f7, 0x6920, 0x6949, 0x696c, 0x698e,
	0x69b1, 0x69d5, 0x69f5, 0x6a16, 0x6a39, 0x6a5b, 0x6a7d, 0x6a9f,
	0x6ac1, 0x6ae5, 0x6b06, 0x6b27, 0x6b4b, 0x6b6d, 0x6b8d, 0x6bb0,
	0x6bd2, 0x6bf4, 0x6c16, 0x6c37, 0x6c58, 0x6c79, 0x6c9c, 0x6cbe,
	0x6cdf, 0x6d03, 0x6d2c, 0x6d56, 0x6d78, 0x6d99, 0x6dbb, 0x6dde,
	0x6dfd, 0x6e27, 0x6e49, 0x6e6a, 0x6e8b, 0x6eac, 0x6ecd, 0x6ef0,
	0x6f15, 0x6f35, 0x6f58, 0x6f77, 0x6f99, 0x6fba, 0x6fda, 0x6ffa,
	// Entry 4AC0 - 4AFF
	0x701a, 0x703c, 0x705d, 0x707d, 0x70a0, 0x70c8, 0x70f1, 0x710d,
	0x7128, 0x7144, 0x7161, 0x717a, 0x719e, 0x71ba, 0x71d5, 0x71f0,
	0x720b, 0x7228, 0x7247, 0x7261, 0x727e, 0x7297, 0x72b3, 0x72ce,
	0x72e8, 0x7304, 0x7327, 0x734b, 0x736d, 0x7387, 0x73a1, 0x73bd,
	0x73d8, 0x73f2, 0x740f, 0x7431, 0x744b, 0x7466, 0x7482, 0x749c,
	0x74b7, 0x74d2, 0x74ec, 0x7507, 0x7523, 0x753e, 0x755a, 0x7576,
	0x7593, 0x75ae, 0x75ca, 0x75e6, 0x7603, 0x761e, 0x763a, 0x7656,
	0x7671, 0x768d, 0x76a8, 0x76c4, 0x76e0, 0x76fd, 0x7719, 0x7736,
	// Entry 4B00 - 4B3F
	0x7752, 0x776f, 0x778a, 0x77a6, 0x77c2, 0x77de, 0x77f9, 0x7814,
	0x7830, 0x784d, 0x7869, 0x7886, 0x78a2, 0x78bf, 0x78db, 0x78f8,
	0x7915, 0x7931, 0x794f, 0x796a, 0x7985, 0x79a0, 0x79bb, 0x79d7,
	0x79f2, 0x7a0e, 0x7a29, 0x7a45, 0x7a60, 0x7a7c, 0x7a97, 0x7ab3,
	0x7acf, 0x7aea, 0x7b06, 0x7b22, 0x7b3f, 0x7b5b, 0x7b78, 0x7b93,
	0x7baf, 0x7bcb, 0x7be8, 0x7c03, 0x7c20, 0x7c3e, 0x7c5d, 0x7c7c,
	0x7c9c, 0x7cbb, 0x7cdb, 0x7cfb, 0x7d1a, 0x7d3a, 0x7d58, 0x7d7c,
	0x7d9b, 0x7dba, 0x7dd9, 0x7df9, 0x7e18, 0x7e36, 0x7e55, 0x7e74,
	// Entry 4B40 - 4B7F
	0x7e93, 0x7eb2, 0x7ed2, 0x7ef1, 0x7f11, 0x7f30, 0x7f4f, 0x7f6f,
	0x7f8d, 0x7fac, 0x7fd6, 0x7fff, 0x801f, 0x803e, 0x805e, 0x807d,
	0x80a2, 0x80c1, 0x80e1, 0x8100, 0x8120, 0x8140, 0x8160, 0x817e,
	0x819d, 0x81c7, 0x81f0, 0x820f, 0x822e, 0x824e, 0x827a, 0x8299,
	0x82b5, 0x82d2, 0x82ef, 0x830d, 0x832a, 0x8348, 0x8366, 0x8383,
	0x83a1, 0x83bd, 0x83df, 0x83fc, 0x8419, 0x8436, 0x8454, 0x8471,
	0x848d, 0x84aa, 0x84c7, 0x84e4, 0x8501, 0x851f, 0x853c, 0x855a,
	0x8577, 0x8594, 0x85b2, 0x85ce, 0x85eb, 0x8613, 0x863a, 0x8658,
	// Entry 4B80 - 4BBF
	0x8675, 0x8693, 0x86b0, 0x86d3, 0x86f0, 0x870e, 0x872b, 0x8749,
	0x8767, 0x8785, 0x87a1, 0x87be, 0x87e6, 0x880d, 0x882a, 0x8847,
	0x8865, 0x888f, 0x88ac, 0x88c4, 0x88dd, 0x88f5, 0x890f, 0x892f,
	0x8950, 0x8968, 0x8981, 0x899a, 0x89b3, 0x89cd, 0x89e6, 0x89ff,
	0x8a18, 0x8a32, 0x8a4b, 0x8a64, 0x8a7e, 0x8a97, 0x8ab1, 0x8aca,
	0x8ae3, 0x8afd, 0x8b16, 0x8b2f, 0x8b48, 0x8b61, 0x8b7a, 0x8b93,
	0x8bb2, 0x8bcb, 0x8bea, 0x8c04, 0x8c1e, 0x8c37, 0x8c4e, 0x8c65,
	0x8c7c, 0x8c93, 0x8caa, 0x8cc4, 0x8ce2, 0x8cff, 0x8d1a, 0x8d33,
	// Entry 4BC0 - 4BFF
	0x8d4d, 0x8d67, 0x8d80, 0x8d99, 0x8db4, 0x8dce, 0x8de8, 0x8e01,
	0x8e1c, 0x8e37, 0x8e51, 0x8e61, 0x8e70, 0x8e7f, 0x8e90, 0x8ea0,
	0x8eb0, 0x8ebf, 0x8ed0, 0x8ee1, 0x8ef1, 0x8f03, 0x8f15, 0x8f27,
	0x8f3a, 0x8f51, 0x8f5c, 0x8f72, 0x8f89, 0x8fa0, 0x8fb7, 0x8fce,
	0x8fe5, 0x8ffc, 0x9013, 0x902a, 0x9041, 0x9058, 0x906f, 0x9086,
	0x909d, 0x90b4, 0x90cc, 0x90e3, 0x90fa, 0x9111, 0x9128, 0x9143,
	0x915e, 0x9170, 0x918f, 0x91a8, 0x91c8, 0x91e9, 0x91f5, 0x920d,
	0x9221, 0x9236, 0x924b, 0x9260, 0x9275, 0x928a, 0x929f, 0x92b4,
	// Entry 4C00 - 4C3F
	0x92c9, 0x92de, 0x92f3, 0x9308, 0x931d, 0x9332, 0x9347, 0x935d,
	0x9372, 0x9387, 0x939c, 0x93b1, 0x93ca, 0x93e3, 0x93f2, 0x9402,
	0x9410, 0x941e, 0x942e, 0x943d, 0x944c, 0x945a, 0x946a, 0x947a,
	0x9489, 0x9498, 0x94aa, 0x94bc, 0x94cd, 0x94de, 0x94ef, 0x9502,
	0x9514, 0x9526, 0x953d, 0x9554, 0x956d, 0x9585, 0x959d, 0x95b4,
	0x95cd, 0x95e6, 0x95fe, 0x9614, 0x962d, 0x9644, 0x965c, 0x966e,
	0x967e, 0x968e, 0x969f, 0x96b0, 0x96c0, 0x96d1, 0x96e3, 0x96f6,
	0x9707, 0x9717, 0x9728, 0x9739, 0x9749, 0x975a, 0x976a, 0x977a,
	// Entry 4C40 - 4C7F
	0x978b, 0x979d, 0x97ae, 0x97bf, 0x97cf, 0x97df, 0x97f0, 0x9803,
	0x9813, 0x9823, 0x9842, 0x9853, 0x9864, 0x9876, 0x9887, 0x9898,
	0x98a9, 0x98ba, 0x98ca, 0x98db, 0x98eb, 0x98fb, 0x990c, 0x991d,
	0x992d, 0x9948, 0x9963, 0x997a, 0x999a, 0x99c1, 0x99f1, 0x9a21,
	0x9a51, 0x9a7c, 0x9a93, 0x9ab9, 0x9ad5, 0x9b02, 0x9b2f, 0x9b5e,
	0x9b84, 0x9ba4, 0x9bc6, 0x9be9, 0x9c11, 0x9c31, 0x9c46, 0x9c63,
	0x9c7e, 0x9c98, 0x9cb3, 0x9ccb, 0x9ce9, 0x9d00, 0x9d1d, 0x9d35,
	0x9d4a, 0x9d65, 0x9d7b, 0x9d93, 0x9daa, 0x9dc1, 0x9dd8, 0x9df1,
	// Entry 4C80 - 4CBF
	0x9e07, 0x9e1d, 0x9e39, 0x9e68, 0x9e81, 0x9e98, 0x9eb9, 0x9ece,
	0x9ee6, 0x9f04, 0x9f35, 0x9f58, 0x9f6f, 0x9f85, 0x9fa1, 0x9fd0,
	0x9fe6, 0x9ffc, 0xa014, 0xa02b, 0xa042, 0xa058, 0xa071, 0xa08a,
	0xa0a8, 0xa0c5, 0xa0e5, 0xa0f9, 0xa10c, 0xa120, 0xa131, 0xa143,
	0xa157, 0xa16a, 0xa17d, 0xa190, 0xa1a5, 0xa1b7, 0xa1c9, 0xa1de,
	0xa1f1, 0xa202, 0xa216, 0xa22e, 0xa241, 0xa253, 0xa266, 0xa279,
	0xa291, 0xa2ac, 0xa2cc, 0xa2e7, 0xa307, 0xa324, 0xa341, 0xa35d,
	0xa379, 0xa39a, 0xa3b6, 0xa3d4, 0xa3e6, 0xa3f8, 0xa40d, 0xa427,
	// Entry 4CC0 - 4CFF
	0xa44c, 0xa47b, 0xa49e, 0xa4c7, 0xa4ef, 0xa506, 0xa51c, 0xa538,
	0xa54d, 0xa564, 0xa580, 0xa596, 0xa5ac, 0xa5c4, 0xa5d9, 0xa5ee,
	0xa606, 0xa61a, 0xa631, 0xa647, 0xa65d, 0xa672, 0xa688, 0xa6a6,
	0xa6c4, 0xa6e7, 0xa70a, 0xa724, 0xa743, 0xa762, 0xa782, 0xa799,
	0xa7b6, 0xa7cc, 0xa7e3, 0xa7fb, 0xa80f, 0xa824, 0xa840, 0xa857,
	0xa86d, 0xa883, 0xa899, 0xa8b1, 0xa8c6, 0xa8db, 0xa8f3, 0xa909,
	0xa91d, 0xa933, 0xa949, 0xa95e, 0xa973, 0xa988, 0xa99f, 0xa9b5,
	0xa9ca, 0xa9e2, 0xa9ff, 0xaa13, 0xaa26, 0xaa3a, 0xaa4f, 0xaa60,
	// Entry 4D00 - 4D3F
	0xaa72, 0xaa86, 0xaa99, 0xaaac, 0xaabf, 0xaad2, 0xaae7, 0xaaf9,
	0xab0b, 0xab20, 0xab33, 0xab44, 0xab58, 0xab6b, 0xab7e, 0xab91,
	0xaba3, 0xabbe, 0xabd5, 0xabe9, 0xabfc, 0xac13, 0xac2a, 0xac39,
	0xac49, 0xac58, 0xac68, 0xac77, 0xac87, 0xac9e, 0xacb6, 0xaccd,
	0xace5, 0xacf4, 0xad04, 0xad13, 0xad23, 0xad33, 0xad44, 0xad54,
	0xad65, 0xad76, 0xad86, 0xad97, 0xada7, 0xadb8, 0xadc9, 0xadda,
	0xadec, 0xadfd, 0xae0f, 0xae20, 0xae30, 0xae41, 0xae51, 0xae62,
	0xae72, 0xae82, 0xae93, 0xaea3, 0xaeb4, 0xaec4, 0xaed4, 0xaee4,
	// Entry 4D40 - 4D7F
	0xaef4, 0xaf04, 0xaf15, 0xaf26, 0xaf36, 0xaf46, 0xaf57, 0xaf73,
	0xaf8e, 0xafaa, 0xafbe, 0xafde, 0xaff1, 0xb005, 0xb018, 0xb02c,
	0xb047, 0xb063, 0xb07e, 0xb09a, 0xb0ad, 0xb0c1, 0xb0d4, 0xb0e8,
	0xb0f5, 0xb101, 0xb114, 0xb12a, 0xb147, 0xb15e, 0xb17d, 0xb195,
	0xb1a6, 0xb1b7, 0xb1ca, 0xb1dc, 0xb1ee, 0xb1ff, 0xb212, 0xb225,
	0xb237, 0xb248, 0xb25c, 0xb270, 0xb283, 0xb296, 0xb2a9, 0xb2be,
	0xb2d2, 0xb2e6, 0xb2ff, 0xb319, 0xb32a, 0xb33a, 0xb34a, 0xb35c,
	0xb36d, 0xb37e, 0xb38e, 0xb3a0, 0xb3b2, 0xb3c3, 0xb3df, 0xb3fe,
	// Entry 4D80 - 4DBF
	0xb41d, 0xb440, 0xb463, 0xb47e, 0xb492, 0xb4a9, 0xb4bd, 0xb4d0,
	0xb4df, 0xb4ef, 0xb4fe, 0xb50e, 0xb51d, 0xb52d, 0xb53c, 0xb54c,
	0xb55b, 0xb56b, 0xb57b, 0xb58c, 0xb59c, 0xb5ad, 0xb5be, 0xb5ce,
	0xb5df, 0xb5ef, 0xb600, 0xb611, 0xb622, 0xb634, 0xb645, 0xb658,
	0xb66a, 0xb67b, 0xb68c, 0xb69c, 0xb6ad, 0xb6bd, 0xb6ce, 0xb6de,
	0xb6ee, 0xb6ff, 0xb70f, 0xb720, 0xb730, 0xb740, 0xb750, 0xb760,
	0xb770, 0xb781, 0xb792, 0xb7a2, 0xb7b2, 0xb7c6, 0xb7d9, 0xb7ed,
	0xb800, 0xb814, 0xb827, 0xb83b, 0xb84e, 0xb862, 0xb874, 0xb885,
	// Entry 4DC0 - 4DFF
	0xb89d, 0xb8b4, 0xb8c6, 0xb8d9, 0xb8f3, 0xb8ff, 0xb912, 0xb92d,
	0xb945, 0xb95c, 0xb973, 0xb98a, 0xb9a1, 0xb9b8, 0xb9cf, 0xb9e6,
	0xb9fe, 0xba15, 0xba2c, 0xba43, 0xba5a, 0xba71, 0xba88, 0xba9f,
	0xbab6, 0xbacd, 0xbae5, 0xbafb, 0xbb12, 0xbb28, 0xbb3e, 0xbb54,
	0xbb6a, 0xbb81, 0xbb98, 0xbbae, 0xbbc4, 0xbbdc, 0xbbf3, 0xbc0a,
	0xbc20, 0xbc38, 0xbc50, 0xbc67, 0xbc7e, 0xbc92, 0xbca5, 0xbcb5,
	0xbcc4, 0xbcd3, 0xbce2, 0xbcf3, 0xbd05, 0xbd16, 0xbd28, 0xbd3a,
	0xbd4b, 0xbd5d, 0xbd6e, 0xbd80, 0xbd92, 0xbda4, 0xbdb7, 0xbdc9,
	// Entry 4E00 - 4E3F
	0xbddc, 0xbdee, 0xbdff, 0xbe11, 0xbe22, 0xbe34, 0xbe45, 0xbe56,
	0xbe68, 0xbe79, 0xbe8b, 0xbe9c, 0xbeae, 0xbebf, 0xbed0, 0xbee1,
	0xbef2, 0xbf03, 0xbf14, 0xbf27, 0xbf3a, 0xbf4e, 0xbf61, 0xbf75,
	0xbf88, 0xbf9c, 0xbfaf, 0xbfc3, 0xbfd7, 0xbfe4, 0xbff2, 0xbfff,
	0xc00d, 0xc01e, 0xc02e, 0xc03e, 0xc050, 0xc061, 0xc072, 0xc082,
	0xc094, 0xc0a6, 0xc0b7, 0xc0ca, 0xc0d6, 0xc0e9, 0xc0fd, 0xc10f,
	0xc123, 0xc137, 0xc148, 0xc159, 0xc16a, 0xc17b, 0xc18c, 0xc19d,
	0xc1af, 0xc1c2, 0xc1d4, 0xc1e7, 0xc1f9, 0xc20c, 0xc21e, 0xc231,
	// Entry 4E40 - 4E7F
	0xc244, 0xc257, 0xc26b, 0xc27e, 0xc292, 0xc2a5, 0xc2b7, 0xc2ca,
	0xc2dc, 0xc2ef, 0xc301, 0xc313, 0xc326, 0xc338, 0xc34b, 0xc35d,
	0xc36f, 0xc381, 0xc393, 0xc3a5, 0xc3b7, 0xc3ca, 0xc3dd, 0xc3f7,
	0xc40c, 0xc422, 0xc43a, 0xc44f, 0xc463, 0xc473, 0xc484, 0xc494,
	0xc4a5, 0xc4b5, 0xc4c6, 0xc4de, 0xc4f7, 0xc50f, 0xc528, 0xc538,
	0xc549, 0xc559, 0xc56a, 0xc57b, 0xc58d, 0xc59e, 0xc5b0, 0xc5c2,
	0xc5d3, 0xc5e5, 0xc5f6, 0xc608, 0xc61a, 0xc62c, 0xc63f, 0xc651,
	0xc664, 0xc676, 0xc687, 0xc699, 0xc6aa, 0xc6bc, 0xc6cd, 0xc6de,
	// Entry 4E80 - 4EBF
	0xc6f0, 0xc701, 0xc713, 0xc724, 0xc735, 0xc746, 0xc757, 0xc769,
	0xc77a, 0xc78c, 0xc79e, 0xc7af, 0xc7c0, 0xc7d5, 0xc7e9, 0xc7fe,
	0xc812, 0xc827, 0xc843, 0xc860, 0xc87c, 0xc899, 0xc8ad, 0xc8c2,
	0xc8d6, 0xc8eb, 0xc8fe, 0xc913, 0xc92b, 0xc943, 0xc94d, 0xc95a,
	0xc96e, 0xc987, 0xc998, 0xc9ab, 0xc9bd, 0xc9d8, 0xc9f6, 0xca08,
	0xca2a, 0xca4b, 0xca5d, 0xca6e, 0xca7f, 0xca92, 0xcaa4, 0xcab6,
	0xcac7, 0xcada, 0xcaed, 0xcaff, 0xcb0b, 0xcb1f, 0xcb31, 0xcb4a,
	0xcb60, 0xcb76, 0xcb8f, 0xcba8, 0xcbc3, 0xcbdd, 0xcbf7, 0xcc10,
	// Entry 4EC0 - 4EFF
	0xcc2b, 0xcc46, 0xcc60, 0xcc7a, 0xcc97, 0xccb4, 0xccd0, 0xccec,
	0xcd08, 0xcd26, 0xcd43, 0xcd60, 0xcd82, 0xcda5, 0xcdb4, 0xcdc4,
	0xcdd3, 0xcde2, 0xcdf1, 0xce01, 0xce10, 0xce20, 0xce30, 0xce41,
	0xce51, 0xce62, 0xce73, 0xce84, 0xce94, 0xcea5, 0xceb5, 0xcec6,
	0xced7, 0xcee8, 0xcefa, 0xcf0b, 0xcf1d, 0xcf2e, 0xcf3e, 0xcf4f,
	0xcf5f, 0xcf71, 0xcf82, 0xcf92, 0xcfa2, 0xcfb3, 0xcfc3, 0xcfd4,
	0xcfe5, 0xcff5, 0xd005, 0xd015, 0xd025, 0xd035, 0xd045, 0xd055,
	0xd066, 0xd07a, 0xd08d, 0xd0a1, 0xd0b4, 0xd0c7, 0xd0db, 0xd0ee,
	// Entry 4F00 - 4F3F
	0xd102, 0xd116, 0xd128, 0xd139, 0xd14b, 0xd157, 0xd16a, 0xd17f,
	0xd192, 0xd1ac, 0xd1c4, 0xd1d5, 0xd1e5, 0xd1fa, 0xd215, 0xd225,
	0xd235, 0xd245, 0xd255, 0xd266, 0xd278, 0xd289, 0xd29b, 0xd2ac,
	0xd2be, 0xd2cf, 0xd2e1, 0xd2f3, 0xd305, 0xd318, 0xd32a, 0xd33d,
	0xd350, 0xd362, 0xd373, 0xd385, 0xd396, 0xd3a8, 0xd3b9, 0xd3ca,
	0xd3dc, 0xd3ed, 0xd3ff, 0xd410, 0xd421, 0xd432, 0xd443, 0xd454,
	0xd465, 0xd476, 0xd488, 0xd49a, 0xd4ae, 0xd4c0, 0xd4d3, 0xd4e5,
	0xd4f8, 0xd50a, 0xd51d, 0xd52f, 0xd542, 0xd554, 0xd567, 0xd57a,
	// Entry 4F40 - 4F7F
	0xd58e, 0xd5a1, 0xd5b5, 0xd5c9, 0xd5dd, 0xd5f0, 0xd604, 0xd617,
	0xd62b, 0xd63f, 0xd653, 0xd667, 0xd67c, 0xd690, 0xd6a5, 0xd6b9,
	0xd6ce, 0xd6e2, 0xd6f5, 0xd709, 0xd71c, 0xd730, 0xd743, 0xd756,
	0xd76a, 0xd77d, 0xd791, 0xd7a5, 0xd7b8, 0xd7cb, 0xd7de, 0xd7f1,
	0xd804, 0xd818, 0xd82b, 0xd83e, 0xd855, 0xd86c, 0xd882, 0xd899,
	0xd8af, 0xd8c6, 0xd8dc, 0xd8f3, 0xd909, 0xd920, 0xd934, 0xd949,
	0xd95d, 0xd970, 0xd983, 0xd998, 0xd9ac, 0xd9c0, 0xd9d3, 0xd9e8,
	0xd9fd, 0xda11, 0xda36, 0xda4e, 0xda63, 0xda77, 0xda87, 0xda98,
	// Entry 4F80 - 4FBF
	0xdaa8, 0xdab9, 0xdac9, 0xdada, 0xdaf2, 0xdb0a, 0xdb1b, 0xdb2c,
	0xdb3d, 0xdb4e, 0xdb5f, 0xdb71, 0xdb82, 0xdb94, 0xdba6, 0xdbb7,
	0xdbc9, 0xdbda, 0xdbec, 0xdbfe, 0xdc10, 0xdc23, 0xdc35, 0xdc48,
	0xdc5a, 0xdc6b, 0xdc7d, 0xdc8e, 0xdca0, 0xdcb1, 0xdcc2, 0xdcd4,
	0xdce5, 0xdcf7, 0xdd08, 0xdd19, 0xdd2a, 0xdd3b, 0xdd4d, 0xdd5e,
	0xdd70, 0xdd82, 0xdd93, 0xdda4, 0xddb9, 0xddcb, 0xdde0, 0xddf5,
	0xde09, 0xde1e, 0xde32, 0xde47, 0xde63, 0xde80, 0xde95, 0xdeaa,
	0xdebf, 0xded4, 0xdee7, 0xdef1, 0xdf07, 0xdf19, 0xdf36, 0xdf5a,
	// Entry 4FC0 - 4FFF
	0xdf73, 0xdf8c, 0xdfa8, 0xdfc5, 0xdfe1, 0xdffc, 0xe017, 0xe034,
	0xe050, 0xe06c, 0xe087, 0xe0a1, 0xe0bc, 0xe0d7, 0xe0f2, 0xe10d,
	0xe123, 0xe13a, 0xe150, 0xe167, 0xe17d, 0xe194, 0xe1b2, 0xe1d1,
	0xe1ef, 0xe20e, 0xe225, 0xe23c, 0xe253, 0xe26a, 0xe281, 0xe299,
	0xe2b0, 0xe2c8, 0xe2e0, 0xe2f7, 0xe30f, 0xe326, 0xe33e, 0xe356,
	0xe36e, 0xe387, 0xe39f, 0xe3b8, 0xe3d0, 0xe3e7, 0xe3ff, 0xe416,
	0xe42e, 0xe445, 0xe45c, 0xe474, 0xe48b, 0xe4a3, 0xe4ba, 0xe4d1,
	0xe4e8, 0xe4ff, 0xe516, 0xe52e, 0xe546, 0xe55d, 0xe574, 0xe58c,
	// Entry 5000 - 503F
	0xe5a4, 0xe5bd, 0xe5d8, 0xe5f3, 0xe60d, 0xe628, 0xe642, 0xe65d,
	0xe67f, 0xe6a2, 0xe6c4, 0xe6e7, 0xe702, 0xe71d, 0xe738, 0xe753,
	0xe76f, 0xe792, 0xe7ad, 0xe7c7, 0xe7e0, 0xe800, 0xe817, 0xe82a,
	0xe847, 0xe85f, 0xe872, 0xe88c, 0xe8aa, 0xe8cb, 0xe8eb, 0xe90c,
	0xe919, 0xe927, 0xe934, 0xe942, 0xe94f, 0xe95d, 0xe972, 0xe988,
	0xe99d, 0xe9b3, 0xe9c0, 0xe9ce, 0xe9db, 0xe9e9, 0xe9f7, 0xea06,
	0xea14, 0xea23, 0xea32, 0xea42, 0xea50, 0xea5f, 0xea6d, 0xea7c,
	0xea8b, 0xea9b, 0xeaaa, 0xeaba, 0xeac9, 0xead9, 0xeae8, 0xeaf6,
	// Entry 5040 - 507F
	0xeb05, 0xeb13, 0xeb22, 0xeb30, 0xeb3f, 0xeb4d, 0xeb5c, 0xeb6a,
	0xeb79, 0xeb87, 0xeb96, 0xeba4, 0xebb2, 0xebc1, 0xebcf, 0xebde,
	0xebec, 0xebfb, 0xec0a, 0xec18, 0xec26, 0xec38, 0xec49, 0xec5b,
	0xec6c, 0xec7e, 0xec97, 0xecb1, 0xecca, 0xece4, 0xecf5, 0xed07,
	0xed18, 0xed2a, 0xed3a, 0xed4f, 0xed61, 0xed72, 0xed81, 0xed93,
	0xedab, 0xedb2, 0xedbd, 0xedc7, 0xedd8, 0xede2, 0xedf1, 0xee07,
	0xee16, 0xee24, 0xee32, 0xee42, 0xee51, 0xee60, 0xee6e, 0xee7e,
	0xee8e, 0xee9d, 0xeeae, 0xeec3, 0xeed6, 0xeee6, 0xef00, 0xef15,
	// Entry 5080 - 50BF
	0xef2a, 0xef36, 0xef46, 0xef57, 0xef67, 0xef78, 0xef88, 0xef99,
	0xefb1, 0xefca, 0xefe2, 0xeffb, 0xf00b, 0xf01c, 0xf02c, 0xf03d,
	0xf04e, 0xf060, 0xf071, 0xf083, 0xf095, 0xf0a6, 0xf0b8, 0xf0c9,
	0xf0db, 0xf0ed, 0xf0ff, 0xf112, 0xf124, 0xf137, 0xf149, 0xf15a,
	0xf16c, 0xf17d, 0xf18f, 0xf1a0, 0xf1b1, 0xf1c3, 0xf1d4, 0xf1e6,
	0xf1f7, 0xf208, 0xf219, 0xf22a, 0xf23b, 0xf24d, 0xf25f, 0xf270,
	0xf281, 0xf296, 0xf2aa, 0xf2bf, 0xf2d3, 0xf2e8, 0xf304, 0xf321,
	0xf33d, 0xf35a, 0xf36e, 0xf388, 0xf39d, 0xf3b1, 0xf3cb, 0xf3e0,
	// Entry 50C0 - 50FF
	0xf3f8, 0xf40d, 0xf421, 0xf434, 0xf446, 0xf45b, 0xf468, 0xf481,
	0xf48b, 0xf49d, 0xf4ae, 0xf4bf, 0xf4d2, 0xf4e4, 0xf4f6, 0xf507,
	0xf51a, 0xf52d, 0xf53f, 0xf54f, 0xf560, 0xf570, 0xf581, 0xf591,
	0xf5a2, 0xf5ba, 0xf5d3, 0xf5eb, 0xf604, 0xf614, 0xf625, 0xf635,
	0xf646, 0xf657, 0xf669, 0xf67a, 0xf68c, 0xf69e, 0xf6af, 0xf6c1,
	0xf6d2, 0xf6e4, 0xf6f6, 0xf708, 0xf71b, 0xf72d, 0xf740, 0xf752,
	0xf763, 0xf775, 0xf786, 0xf798, 0xf7a9, 0xf7ba, 0xf7cc, 0xf7dd,
	0xf7ef, 0xf800, 0xf811, 0xf822, 0xf833, 0xf844, 0xf856, 0xf868,
	// Entry 5100 - 513F
	0xf879, 0xf88a, 0xf89f, 0xf8b3, 0xf8c8, 0xf8dc, 0xf8f1, 0xf90d,
	0xf92a, 0xf93e, 0xf953, 0xf967, 0xf97c, 0xf994, 0xf9a9, 0xf9bd,
	0xf9d0, 0xf9e2, 0xf9f6, 0xfa03, 0xfa17, 0xfa2c, 0xfa41, 0xfa5a,
	0xfa73, 0xfa8c, 0xfaa4, 0xfadc, 0xfb12, 0xfb45, 0xfb7f, 0xfbb9,
	0xfbd9, 0xfc03, 0xfc2d, 0xfc57, 0xfc84, 0xfcb0, 0xfcda, 0xfd0e,
	0xfd43, 0xfd6a, 0xfd8f, 0xfdb5, 0xfdcf, 0xfded, 0xfe0c, 0xfe19,
	0xfe27, 0xfe34, 0xfe42, 0xfe4f, 0xfe5d, 0xfe72, 0xfe88, 0xfe9d,
	0xfeb3, 0xfec0, 0xfece, 0xfedb, 0xfee9, 0xfef7, 0xff06, 0xff14,
	// Entry 5140 - 517F
	0xff23, 0xff32, 0xff40, 0xff4f, 0xff5d, 0xff6c, 0xff7b, 0xff8a,
	0xff9a, 0xffa9, 0xffb9, 0xffc8, 0xffd6, 0xffe5, 0xfff3, 0x0002,
	0x0010, 0x001e, 0x002d, 0x003b, 0x004a, 0x0058, 0x0066, 0x0074,
	0x0082, 0x0090, 0x009f, 0x00ae, 0x00bc, 0x00ca, 0x00d9, 0x00eb,
	0x00fc, 0x010e, 0x011f, 0x0131, 0x014a, 0x0164, 0x017d, 0x0197,
	0x01a8, 0x01ba, 0x01cb, 0x01dd, 0x01ef, 0x0200, 0x0210, 0x0225,
	0x022f, 0x0240, 0x0256, 0x0264, 0x0273, 0x0281, 0x028f, 0x029f,
	0x02ae, 0x02bd, 0x02cb, 0x02db, 0x02eb, 0x02fa, 0x0317, 0x032e,
	// Entry 5180 - 51BF
	0x0352, 0x0376, 0x039a, 0x03bf, 0x03eb, 0x0403, 0x0430, 0x0445,
	0x0468, 0x0492, 0x04c3, 0x04d1, 0x04e0, 0x04ee, 0x04fd, 0x050b,
	0x051a, 0x0528, 0x0537, 0x0545, 0x0554, 0x0563, 0x0573, 0x0582,
	0x0592, 0x05a2, 0x05b1, 0x05c1, 0x05d0, 0x05e0, 0x05f0, 0x0600,
	0x0611, 0x0621, 0x0632, 0x0642, 0x0651, 0x0661, 0x0670, 0x0680,
	0x068f, 0x069e, 0x06ae, 0x06bd, 0x06cd, 0x06dc, 0x06eb, 0x06fa,
	0x0709, 0x0718, 0x0728, 0x0737, 0x0746, 0x0756, 0x0769, 0x077b,
	0x078e, 0x07a0, 0x07b3, 0x07c5, 0x07d8, 0x07ea, 0x07fd, 0x080f,
	// Entry 51C0 - 51FF
	0x0822, 0x0833, 0x0843, 0x085b, 0x0872, 0x0882, 0x0891, 0x08a0,
	0x08b1, 0x08c1, 0x08d1, 0x08e0, 0x08f1, 0x0902, 0x0912, 0x0928,
	0x093d, 0x0952, 0x0969, 0x097f, 0x0995, 0x09aa, 0x09c1, 0x09d8,
	0x09ee, 0x0a12, 0x0a35, 0x0a58, 0x0a7d, 0x0aa1, 0x0ac5, 0x0ae8,
	0x0b0d, 0x0b32, 0x0b56, 0x0b64, 0x0b73, 0x0b82, 0x0b90, 0x0b9e,
	0x0bb6, 0x0bc4, 0x0bd3, 0x0be1, 0x0bef, 0x0bfd, 0x0c0c, 0x0c1b,
	0x0c29, 0x0c37, 0x0c45, 0x0c54, 0x0c62, 0x0c6f, 0x0c7d, 0x0c8c,
	0x0c9a, 0x0cb2, 0x0cc1, 0x0cd0, 0x0cdf, 0x0cf7, 0x0d14, 0x0d31,
	// Entry 5200 - 523F
	0x0d57, 0x0d68, 0x0d7a, 0x0d8b, 0x0d9d, 0x0dae, 0x0dc0, 0x0dd1,
	0x0de3, 0x0df4, 0x0e06, 0x0e18, 0x0e28, 0x0e37, 0x0e45, 0x0e53,
	0x0e63, 0x0e72, 0x0e81, 0x0e8f, 0x0e9f, 0x0eaf, 0x0ebe, 0x0ecd,
	0x0edf, 0x0ef6, 0x0f07, 0x0f16, 0x0f24, 0x0f32, 0x0f41, 0x0f51,
	0x0f60, 0x0f70, 0x0f7f, 0x0f8e, 0x0f9c, 0x0fab, 0x0fb9, 0x0fc8,
	0x0fd6, 0x0fe5, 0x0ff3, 0x1002, 0x1010, 0x101f, 0x102e, 0x103e,
	0x104d, 0x105d, 0x106d, 0x107c, 0x108c, 0x109b, 0x10ab, 0x10bb,
	0x10cb, 0x10dc, 0x10ec, 0x10fd, 0x110d, 0x111c, 0x112c, 0x113b,
	// Entry 5240 - 527F
	0x114b, 0x115a, 0x1169, 0x1179, 0x1188, 0x1198, 0x11a7, 0x11b6,
	0x11c5, 0x11d4, 0x11e3, 0x11f3, 0x1203, 0x1212, 0x1221, 0x1231,
	0x1244, 0x1256, 0x1269, 0x127b, 0x128e, 0x12a8, 0x12c3, 0x12d5,
	0x12e8, 0x12fa, 0x130d, 0x1320, 0x1332, 0x1343, 0x1353, 0x136a,
	0x1389, 0x13a5, 0x13c2, 0x13df, 0x13fc, 0x1419, 0x1436, 0x1453,
	0x146f, 0x148b, 0x14a9, 0x14c6, 0x14e3, 0x1501, 0x151f, 0x153c,
	0x155a, 0x1578, 0x1596, 0x15b5, 0x15d2, 0x15ef, 0x160c, 0x1629,
	0x1646, 0x1665, 0x1684, 0x16a3, 0x16c1, 0x16e0, 0x16fe, 0x171d,
	// Entry 5280 - 52BF
	0x173a, 0x1754, 0x176f, 0x178a, 0x17a5, 0x17c0, 0x17db, 0x17f6,
	0x1810, 0x182a, 0x1846, 0x1861, 0x187c, 0x1898, 0x18b4, 0x18cf,
	0x18eb, 0x1907, 0x1923, 0x1940, 0x195b, 0x1976, 0x1991, 0x19ac,
	0x19c7, 0x19e4, 0x1a01, 0x1a1e, 0x1a3a, 0x1a57, 0x1a73, 0x1a90,
	0x1aa6, 0x1abb, 0x1ad0, 0x1ae7, 0x1afd, 0x1b13, 0x1b28, 0x1b3f,
	0x1b56, 0x1b6c, 0x1b82, 0x1b9b, 0x1bb4, 0x1bcc, 0x1be4, 0x1bfc,
	0x1c16, 0x1c2f, 0x1c48, 0x1c56, 0x1c6a, 0x1c7f, 0x1c93, 0x1ca8,
	0x1cbc, 0x1cd1, 0x1ce5, 0x1cf9, 0x1d0e, 0x1d24, 0x1d39, 0x1d4f,
	// Entry 52C0 - 52FF
	0x1d65, 0x1d7a, 0x1d90, 0x1da5, 0x1dbb, 0x1dd1, 0x1de7, 0x1dfe,
	0x1e14, 0x1e29, 0x1e3f, 0x1e54, 0x1e6a, 0x1e7f, 0x1e94, 0x1eaa,
	0x1ebf, 0x1ed5, 0x1eea, 0x1eff, 0x1f15, 0x1f2a, 0x1f3f, 0x1f54,
	0x1f6a, 0x1f80, 0x1f95, 0x1faa, 0x1fc0, 0x1fd5, 0x1fee, 0x2006,
	0x201f, 0x2037, 0x2050, 0x2068, 0x2081, 0x2099, 0x20b2, 0x20ce,
	0x20e6, 0x20f8, 0x2117, 0x212c, 0x2142, 0x2157, 0x216d, 0x2185,
	0x219b, 0x21b7, 0x21cd, 0x21e2, 0x21f7, 0x220e, 0x2224, 0x223a,
	0x224f, 0x2266, 0x227d, 0x2293, 0x22a7, 0x22bc, 0x22d0, 0x22e5,
	// Entry 5300 - 533F
	0x22f9, 0x230e, 0x232a, 0x2347, 0x235b, 0x2370, 0x2384, 0x2399,
	0x23ae, 0x23c4, 0x23d9, 0x23ef, 0x2405, 0x241a, 0x2430, 0x2445,
	0x245b, 0x2471, 0x2487, 0x249e, 0x24b4, 0x24cb, 0x24e1, 0x24f6,
	0x250c, 0x2521, 0x2537, 0x254c, 0x2561, 0x2577, 0x258c, 0x25a2,
	0x25b7, 0x25cc, 0x25e1, 0x25f6, 0x260b, 0x2621, 0x2637, 0x264c,
	0x2661, 0x2677, 0x268d, 0x26a6, 0x26be, 0x26d7, 0x26ef, 0x2708,
	0x2728, 0x2749, 0x2761, 0x277a, 0x2792, 0x27ab, 0x27c4, 0x27dc,
	0x27f3, 0x280c, 0x2824, 0x283a, 0x2860, 0x2879, 0x2896, 0x28b4,
	// Entry 5340 - 537F
	0x28d1, 0x28ee, 0x290c, 0x2929, 0x2947, 0x2965, 0x298b, 0x29ad,
	0x29c7, 0x29e2, 0x29fc, 0x2a17, 0x2a32, 0x2a4c, 0x2a67, 0x2a81,
	0x2a9c, 0x2ab7, 0x2ad3, 0x2aee, 0x2b0a, 0x2b25, 0x2b3f, 0x2b5a,
	0x2b74, 0x2b8f, 0x2ba9, 0x2bc3, 0x2bde, 0x2bf8, 0x2c13, 0x2c2d,
	0x2c48, 0x2c64, 0x2c7f, 0x2c9b, 0x2cb6, 0x2cd0, 0x2cea, 0x2d04,
	0x2d1e, 0x2d38, 0x2d52, 0x2d6d, 0x2d88, 0x2da2, 0x2dbc, 0x2dd8,
	0x2dfd, 0x2e19, 0x2e3a, 0x2e69, 0x2e93, 0x2eb1, 0x2ece, 0x2ef8,
	0x2f20, 0x2f48, 0x2f70, 0x2f98, 0x2fba, 0x2fdc, 0x2ff7, 0x3011,
	// Entry 5380 - 53BF
	0x3032, 0x3052, 0x3081, 0x30b0, 0x30ca, 0x30da, 0x30ee, 0x3103,
	0x3117, 0x312b, 0x313f, 0x3154, 0x3169, 0x317e, 0x319a, 0x31b6,
	0x31cf, 0x31e0, 0x31f2, 0x3203, 0x3215, 0x3227, 0x3238, 0x324a,
	0x325b, 0x326d, 0x327f, 0x3291, 0x32a4, 0x32b6, 0x32c9, 0x32db,
	0x32ec, 0x32fe, 0x330f, 0x3321, 0x3332, 0x3343, 0x3355, 0x3366,
	0x3378, 0x3389, 0x339b, 0x33ae, 0x33c0, 0x33d2, 0x33e3, 0x33f4,
	0x3405, 0x3416, 0x3427, 0x3438, 0x344a, 0x345c, 0x346d, 0x347e,
	0x3491, 0x34a9, 0x34c1, 0x34e2, 0x3503, 0x3525, 0x3546, 0x3564,
	// Entry 53C0 - 53FF
	0x3582, 0x35a1, 0x35bf, 0x35dd, 0x35fb, 0x3619, 0x3637, 0x3655,
	0x3674, 0x3692, 0x36b1, 0x36c6, 0x36da, 0x36f1, 0x3702, 0x3714,
	0x3725, 0x373d, 0x374f, 0x3783, 0x37b0, 0x37d3, 0x37ea, 0x3801,
	0x381f, 0x383e, 0x385c, 0x387b, 0x3899, 0x38b8, 0x38d8, 0x38f9,
	0x3919, 0x393a, 0x395a, 0x397b, 0x3991, 0x39a7, 0x39bd, 0x39d3,
	0x39e8, 0x39fd, 0x3a12, 0x3a27, 0x3a3c, 0x3a51, 0x3a66, 0x3a7c,
	0x3a91, 0x3aa6, 0x3abc, 0x3ad1, 0x3ae6, 0x3afb, 0x3b10, 0x3b26,
	0x3b3b, 0x3b51, 0x3b66, 0x3b7b, 0x3b91, 0x3ba5, 0x3bb9, 0x3bcd,
	// Entry 5400 - 543F
	0x3be1, 0x3bf5, 0x3c0a, 0x3c1f, 0x3c39, 0x3c53, 0x3c6d, 0x3c87,
	0x3ca1, 0x3cbb, 0x3cd5, 0x3cf0, 0x3d0a, 0x3d26, 0x3d3d, 0x3d5c,
	0x3d7e, 0x3d9b, 0x3dc0, 0x3ddc, 0x3df3, 0x3e15, 0x3e32, 0x3e4c,
	0x3e6c, 0x3e91, 0x3eb1, 0x3ed2, 0x3eee, 0x3f06, 0x3f2d, 0x3f4f,
	0x3f6d, 0x3f81, 0x3fa5, 0x3fba, 0x3fd9, 0x3ff7, 0x401f, 0x4046,
	0x406d, 0x4095, 0x40aa, 0x40bf, 0x40d5, 0x40ea, 0x4100, 0x411a,
	0x4134, 0x414f, 0x416a, 0x417d, 0x4191, 0x41a3, 0x41b6, 0x41c8,
	0x41dc, 0x41ee, 0x41ff, 0x4213, 0x4225, 0x4237, 0x424b, 0x425f,
	// Entry 5440 - 547F
	0x4271, 0x4283, 0x4296, 0x42ab, 0x42bf, 0x42d4, 0x42e8, 0x42fa,
	0x430c, 0x431e, 0x4332, 0x4346, 0x4359, 0x436c, 0x437e, 0x4392,
	0x43a7, 0x43bb, 0x43cf, 0x43e3, 0x43f3, 0x4405, 0x4416, 0x4427,
	0x443a, 0x444c, 0x445e, 0x446f, 0x4482, 0x4495, 0x44a7, 0x44b9,
	0x44cc, 0x44de, 0x44f1, 0x4503, 0x4516, 0x4530, 0x454b, 0x4565,
	0x4577, 0x458a, 0x459c, 0x45af, 0x45c2, 0x45d6, 0x45e9, 0x45fd,
	0x4611, 0x4624, 0x4638, 0x464b, 0x465f, 0x4673, 0x4687, 0x469c,
	0x46b0, 0x46c5, 0x46d9, 0x46ec, 0x4700, 0x4713, 0x4727, 0x473a,
	// Entry 5480 - 54BF
	0x474d, 0x4761, 0x4774, 0x4788, 0x479b, 0x47ae, 0x47c1, 0x47d4,
	0x47e7, 0x47fb, 0x480f, 0x4822, 0x4835, 0x484c, 0x4862, 0x4879,
	0x488f, 0x48a6, 0x48c4, 0x48e3, 0x4901, 0x4917, 0x492e, 0x4944,
	0x495b, 0x4975, 0x498c, 0x49a2, 0x49b7, 0x49ce, 0x49dd, 0x49f3,
	0x4a0b, 0x4a21, 0x4a37, 0x4a4b, 0x4a5e, 0x4a71, 0x4a86, 0x4a9a,
	0x4aae, 0x4ac1, 0x4ad6, 0x4aeb, 0x4aff, 0x4b13, 0x4b27, 0x4b3d,
	0x4b52, 0x4b67, 0x4b7b, 0x4b91, 0x4ba7, 0x4bbc, 0x4bd0, 0x4be7,
	0x4bfe, 0x4c14, 0x4c2a, 0x4c40, 0x4c58, 0x4c6f, 0x4c86, 0x4ca2,
	// Entry 54C0 - 54FF
	0x4cb3, 0x4cc4, 0x4cd5, 0x4ce7, 0x4cf8, 0x4d0a, 0x4d1b, 0x4d2d,
	0x4d3e, 0x4d50, 0x4d61, 0x4d73, 0x4d84, 0x4d95, 0x4da6, 0x4db8,
	0x4dc9, 0x4dda, 0x4dec, 0x4dff, 0x4e11, 0x4e22, 0x4e34, 0x4e45,
	0x4e56, 0x4e67, 0x4e78, 0x4e89, 0x4e9b, 0x4eac, 0x4ebd, 0x4ecd,
	0x4ee8, 0x4f04, 0x4f1f, 0x4f3b, 0x4f56, 0x4f72, 0x4f8d, 0x4fa9,
	0x4fc4, 0x4fe0, 0x4ffb, 0x5016, 0x5031, 0x504d, 0x5068, 0x5083,
	0x509f, 0x50bc, 0x50d8, 0x50f3, 0x510f, 0x512a, 0x5145, 0x5160,
	0x517b, 0x5197, 0x51b2, 0x51cd, 0x51e7, 0x51fc, 0x5210, 0x5224,
	// Entry 5500 - 553F
	0x5238, 0x524c, 0x5261, 0x5279, 0x528f, 0x52a6, 0x52bc, 0x52d3,
	0x52e9, 0x5300, 0x5316, 0x532d, 0x5343, 0x535a, 0x5371, 0x5389,
	0x53a0, 0x53b8, 0x53d0, 0x53e7, 0x53ff, 0x5416, 0x542e, 0x5446,
	0x545e, 0x5477, 0x548f, 0x54a8, 0x54c0, 0x54d7, 0x54ef, 0x5506,
	0x551e, 0x5535, 0x554c, 0x5564, 0x557b, 0x5593, 0x55aa, 0x55c1,
	0x55d8, 0x55ef, 0x5606, 0x561e, 0x5636, 0x564d, 0x5664, 0x567c,
	0x5695, 0x56ae, 0x56c6, 0x56e1, 0x56fb, 0x5716, 0x5730, 0x574b,
	0x576d, 0x5787, 0x57a2, 0x57bc, 0x57d7, 0x57f2, 0x580c, 0x5824,
	// Entry 5540 - 557F
	0x583d, 0x5857, 0x586b, 0x587e, 0x5893, 0x58ab, 0x58c2, 0x58d9,
	0x58f2, 0x590a, 0x5922, 0x5939, 0x5952, 0x596b, 0x5983, 0x5999,
	0x59b0, 0x59c6, 0x59dd, 0x59f3, 0x5a0a, 0x5a21, 0x5a38, 0x5a4f,
	0x5a66, 0x5a7d, 0x5a94, 0x5aab, 0x5ac3, 0x5ada, 0x5af1, 0x5b09,
	0x5b20, 0x5b38, 0x5b4f, 0x5b66, 0x5b7e, 0x5b95, 0x5bad, 0x5bc4,
	0x5bdb, 0x5bf3, 0x5c0b, 0x5c24, 0x5c3c, 0x5c53, 0x5c6b, 0x5c83,
	0x5c9c, 0x5cb4, 0x5ccb, 0x5ce3, 0x5cfa, 0x5d11, 0x5d28, 0x5d43,
	0x5d5d, 0x5d78, 0x5d92, 0x5dad, 0x5dc8, 0x5de3, 0x5dfe, 0x5e19,
	// Entry 5580 - 55BF
	0x5e34, 0x5e4e, 0x5e62, 0x5e72, 0x5e8a, 0x5ea1, 0x5eb8, 0x5ed1,
	0x5ee9, 0x5f01, 0x5f18, 0x5f31, 0x5f4a, 0x5f62, 0x5f76, 0x5f8a,
	0x5f9e, 0x5fb2, 0x5fc6, 0x5fdb, 0x5fef, 0x6004, 0x6018, 0x602d,
	0x6041, 0x6055, 0x606a, 0x607e, 0x6093, 0x60a7, 0x60bc, 0x60d2,
	0x60e7, 0x60fd, 0x6112, 0x6126, 0x613b, 0x614f, 0x6164, 0x6179,
	0x618d, 0x61a2, 0x61b6, 0x61cb, 0x61e0, 0x61f4, 0x6208, 0x621c,
	0x6230, 0x6246, 0x625a, 0x626e, 0x6282, 0x6297, 0x62ad, 0x62c2,
	0x62d9, 0x62ea, 0x6300, 0x6315, 0x632a, 0x6341, 0x6357, 0x636d,
	// Entry 55C0 - 55FF
	0x6382, 0x6399, 0x63b0, 0x63c6, 0x63d7, 0x63e8, 0x63fa, 0x640b,
	0x641c, 0x642d, 0x643e, 0x644f, 0x6460, 0x6471, 0x6482, 0x6494,
	0x64a5, 0x64b6, 0x64c7, 0x64d8, 0x64e9, 0x64f9, 0x6506, 0x651a,
	0x652e, 0x6542, 0x6556, 0x6568, 0x657e, 0x6593, 0x65a5, 0x65b4,
	0x65c5, 0x65d2, 0x65e0, 0x65ed, 0x65fb, 0x6608, 0x6616, 0x662b,
	0x6641, 0x6656, 0x666c, 0x6679, 0x6687, 0x6694, 0x66a2, 0x66b1,
	0x66bf, 0x66ce, 0x66dd, 0x66eb, 0x66fa, 0x6708, 0x6717, 0x6726,
	0x6735, 0x6745, 0x6754, 0x6764, 0x6773, 0x6781, 0x6790, 0x679e,
	// Entry 5600 - 563F
	0x67ad, 0x67bb, 0x67c9, 0x67d8, 0x67e6, 0x67f5, 0x6803, 0x6811,
	0x681f, 0x682d, 0x683b, 0x684a, 0x6859, 0x6867, 0x6875, 0x6885,
	0x6897, 0x68b3, 0x68c4, 0x68d6, 0x68e7, 0x68f9, 0x6912, 0x6923,
	0x6935, 0x6947, 0x6957, 0x6965, 0x696f, 0x6980, 0x699f, 0x69c8,
	0x69df, 0x69fc, 0x6a10, 0x6a2b, 0x6a46, 0x6a5d, 0x6a7b, 0x6a92,
	0x6ab1, 0x6ac0, 0x6ace, 0x6adc, 0x6aec, 0x6afb, 0x6b0a, 0x6b18,
	0x6b28, 0x6b38, 0x6b47, 0x6b56, 0x6b65, 0x6b93, 0x6bbe, 0x6bda,
	0x6bf9, 0x6c14, 0x6c34, 0x6c53, 0x6c75, 0x6c91, 0x6caf, 0x6ccd,
	// Entry 5640 - 567F
	0x6ce5, 0x6cfe, 0x6d1d, 0x6d3c, 0x6d54, 0x6d6e, 0x6d87, 0x6da0,
	0x6dbd, 0x6de4, 0x6df2, 0x6e03, 0x6e17, 0x6e29, 0x6e3f, 0x6e50,
	0x6e63, 0x6e77, 0x6e87, 0x6e97, 0x6ea5, 0x6eb8, 0x6ec9, 0x6ed9,
	0x6ee8, 0x6f02, 0x6f1c, 0x6f2b, 0x6f3e, 0x6f5b, 0x6f78, 0x6f8a,
	0x6f9c, 0x6fac, 0x6fbc, 0x6fd4, 0x6fec, 0x7000, 0x7015, 0x7032,
	0x7042, 0x705a, 0x7074, 0x7094, 0x70ad, 0x70c7, 0x70e8, 0x7103,
	0x711d, 0x712e, 0x713f, 0x715b, 0x717c, 0x7197, 0x71b8, 0x71d2,
	0x71f2, 0x720e, 0x722b, 0x7248, 0x726f, 0x7285, 0x7297, 0x72b5,
	// Entry 5680 - 56BF
	0x72d7, 0x72fa, 0x7317, 0x7334, 0x7345, 0x7356, 0x7373, 0x739a,
	0x73ab, 0x73c5, 0x73e1, 0x73fd, 0x7417, 0x7433, 0x744d, 0x7468,
	0x7483, 0x7496, 0x74aa, 0x74bd, 0x74da, 0x74eb, 0x7504, 0x7521,
	0x7552, 0x7575, 0x7589, 0x759c, 0x75af, 0x75cc, 0x75e0, 0x75f4,
	0x7606, 0x7622, 0x763e, 0x767b, 0x769f, 0x76e2, 0x76f5, 0x770a,
	0x771b, 0x772d, 0x7740, 0x7755, 0x7767, 0x7782, 0x7796, 0x77a8,
	0x77bc, 0x77cd, 0x77e6, 0x7801, 0x7821, 0x7832, 0x784e, 0x786a,
	0x7887, 0x789b, 0x78ba, 0x78cc, 0x78df, 0x78f0, 0x7902, 0x792d,
	// Entry 56C0 - 56FF
	0x7951, 0x7976, 0x7998, 0x79ba, 0x79e6, 0x7a08, 0x7a2c, 0x7a4f,
	0x7a71, 0x7a93, 0x7abd, 0x7ae0, 0x7b02, 0x7b24, 0x7b51, 0x7b74,
	0x7b96, 0x7bc2, 0x7be4, 0x7c08, 0x7c34, 0x7c57, 0x7c69, 0x7c7b,
	0x7c8f, 0x7ca3, 0x7cb4, 0x7cc6, 0x7cd8, 0x7cf4, 0x7d07, 0x7d19,
	0x7d3e, 0x7d51, 0x7d62, 0x7d7b, 0x7d91, 0x7daa, 0x7dbc, 0x7dd9,
	0x7dec, 0x7dfe, 0x7e12, 0x7e24, 0x7e36, 0x7e49, 0x7e61, 0x7e7e,
	0x7e91, 0x7ea4, 0x7eb4, 0x7ece, 0x7ef2, 0x7f03, 0x7f2c, 0x7f47,
	0x7f61, 0x7f7c, 0x7f97, 0x7fb0, 0x7fc3, 0x7fd6, 0x7fe7, 0x7ff8,
	// Entry 5700 - 573F
	0x8014, 0x8035, 0x804f, 0x806c, 0x8089, 0x80a2, 0x80b5, 0x80c9,
	0x80dc, 0x80ef, 0x810a, 0x812e, 0x815c, 0x8178, 0x8195, 0x81b8,
	0x81e0, 0x81fc, 0x821d, 0x823f, 0x825f, 0x8287, 0x82a4, 0x82c0,
	0x82e7, 0x8303, 0x831f, 0x833b, 0x8357, 0x8368, 0x837e, 0x8390,
	0x83ba, 0x83dc, 0x83ff, 0x8429, 0x8444, 0x8460, 0x8486, 0x84a2,
	0x84c6, 0x84e2, 0x8506, 0x8521, 0x853c, 0x8562, 0x857e, 0x8599,
	0x85bc, 0x85d7, 0x8602, 0x8624, 0x8640, 0x865b, 0x8677, 0x869a,
	0x86bf, 0x86ec, 0x8708, 0x872c, 0x874f, 0x876c, 0x878d, 0x87ba,
	// Entry 5740 - 577F
	0x87d6, 0x87f5, 0x8811, 0x8836, 0x885a, 0x8875, 0x8898, 0x88b3,
	0x88cf, 0x88f4, 0x890f, 0x892b, 0x8947, 0x8963, 0x8988, 0x89a5,
	0x89c1, 0x89de, 0x89f8, 0x8a13, 0x8a36, 0x8a51, 0x8a64, 0x8a85,
	0x8a97, 0x8abf, 0x8ad1, 0x8afd, 0x8b11, 0x8b23, 0x8b35, 0x8b48,
	0x8b60, 0x8b7d, 0x8b9e, 0x8bb0, 0x8bc3, 0x8bd8, 0x8bee, 0x8c0e,
	0x8c1f, 0x8c38, 0x8c51, 0x8c6e, 0x8c80, 0x8c9b, 0x8cba, 0x8cce,
	0x8ce1, 0x8cf9, 0x8d0c, 0x8d30, 0x8d53, 0x8d70, 0x8d95, 0x8db1,
	0x8dc5, 0x8dd8, 0x8df9, 0x8e16, 0x8e34, 0x8e4c, 0x8e5d, 0x8e7a,
	// Entry 5780 - 57BF
	0x8e8c, 0x8ea8, 0x8ed3, 0x8eef, 0x8f15, 0x8f2c, 0x8f3e, 0x8f61,
	0x8f7d, 0x8f9e, 0x8fb0, 0x8fc2, 0x8fde, 0x8ff0, 0x9003, 0x9017,
	0x902c, 0x903d, 0x9053, 0x9069, 0x907b, 0x908c, 0x90a7, 0x90c3,
	0x90de, 0x90fa, 0x9115, 0x9130, 0x914b, 0x9166, 0x917f, 0x9190,
	0x91a3, 0x91bf, 0x91dc, 0x91fc, 0x921a, 0x9236, 0x9249, 0x9259,
	0x926b, 0x927c, 0x928f, 0x92b0, 0x92d5, 0x92e6, 0x92f8, 0x930e,
	0x9323, 0x9358, 0x936f, 0x9380, 0x93a1, 0x93b3, 0x93c4, 0x93e0,
	0x93fd, 0x941a, 0x9433, 0x9446, 0x9457, 0x9468, 0x947a, 0x948b,
	// Entry 57C0 - 57FF
	0x94a4, 0x94be, 0x94e1, 0x94fd, 0x9518, 0x9535, 0x9550, 0x956a,
	0x9587, 0x95a3, 0x95bd, 0x95d8, 0x95f9, 0x9614, 0x9640, 0x965a,
	0x9676, 0x969b, 0x96c5, 0x96df, 0x96fb, 0x9716, 0x9730, 0x974b,
	0x9765, 0x9780, 0x979a, 0x97b4, 0x97ce, 0x97f0, 0x9812, 0x9834,
	0x984e, 0x9873, 0x988d, 0x98a8, 0x98c2, 0x98dc, 0x98f6, 0x9911,
	0x992c, 0x9947, 0x9963, 0x997e, 0x9999, 0x99b6, 0x99d1, 0x99ea,
	0x9a04, 0x9a1e, 0x9a43, 0x9a5e, 0x9a78, 0x9a8a, 0x9aa9, 0x9abb,
	0x9ace, 0x9ae1, 0x9af4, 0x9b07, 0x9b24, 0x9b36, 0x9b57, 0x9b69,
	// Entry 5800 - 583F
	0x9b85, 0x9ba4, 0x9bb7, 0x9bca, 0x9bdf, 0x9c15, 0x9c57, 0x9c6b,
	0x9c7c, 0x9c97, 0x9cb0, 0x9cca, 0x9cdc, 0x9cee, 0x9d02, 0x9d15,
	0x9d2a, 0x9d4b, 0x9d5c, 0x9d96, 0x9da8, 0x9dba, 0x9dd9, 0x9deb,
	0x9dfd, 0x9e14, 0x9e26, 0x9e38, 0x9e57, 0x9e6c, 0x9e81, 0x9e92,
	0x9ea6, 0x9ec2, 0x9eee, 0x9f13, 0x9f38, 0x9f55, 0x9f72, 0x9f9a,
	0x9fb8, 0x9fd5, 0x9ff3, 0xa010, 0xa02d, 0xa04b, 0xa069, 0xa090,
	0xa0ad, 0xa0cb, 0xa0f2, 0xa115, 0xa132, 0xa157, 0xa17c, 0xa199,
	0xa1b7, 0xa1d5, 0xa1f3, 0xa220, 0xa240, 0xa25f, 0xa27c, 0xa29a,
	// Entry 5840 - 587F
	0xa2b7, 0xa2dc, 0xa2fb, 0xa318, 0xa33f, 0xa374, 0xa3a3, 0xa3c2,
	0xa3eb, 0xa409, 0xa427, 0xa446, 0xa47a, 0xa496, 0xa4b9, 0xa4e3,
	0xa509, 0xa526, 0xa544, 0xa560, 0xa574, 0xa592, 0xa5b9, 0xa5d2,
	0xa5ff, 0xa614, 0xa626, 0xa642, 0xa654, 0xa670, 0xa694, 0xa6a5,
	0xa6b7, 0xa6cc, 0xa6df, 0xa6f0, 0xa70b, 0xa71d, 0xa738, 0xa754,
	0xa771, 0xa793, 0xa7b5, 0xa7da, 0xa7f5, 0xa812, 0xa82f, 0xa855,
	0xa870, 0xa894, 0xa8b2, 0xa8d5, 0xa8f0, 0xa90b, 0xa92f, 0xa954,
	0xa971, 0xa988, 0xa9a7, 0xa9c6, 0xa9e0, 0xa9fa, 0xaa0c, 0xaa20,
	// Entry 5880 - 58BF
	0xaa3f, 0xaa62, 0xaa7e, 0xaa90, 0xaaa2, 0xaab4, 0xaacf, 0xaaf7,
	0xab08, 0xab24, 0xab3a, 0xab4c, 0xab5e, 0xab70, 0xab83, 0xab97,
	0xaba8, 0xabba, 0xabcb, 0xabdd, 0xabee, 0xac07, 0xac19, 0xac30,
	0xac45, 0xac5a, 0xac6d, 0xac88, 0xaca5, 0xacc1, 0xacde, 0xad0b,
	0xad2c, 0xad40, 0xad5c, 0xad80, 0xad9d, 0xadb6, 0xadc7, 0xadd9,
	0xadec, 0xae08, 0xae2a, 0xae4b, 0xae5f, 0xae79, 0xae8b, 0xae9e,
	0xaeaf, 0xaec8, 0xaee2, 0xaefb, 0xaf0c, 0xaf25, 0xaf37, 0xaf49,
	0xaf6b, 0xaf96, 0xafab, 0xafc9, 0xafe8, 0xb010, 0xb02f, 0xb05c,
	// Entry 58C0 - 58FF
	0xb07a, 0xb099, 0xb0b8, 0xb0e1, 0xb109, 0xb13a, 0xb161, 0xb180,
	0xb194, 0xb1a5, 0xb1b8, 0xb1ca, 0xb1ec, 0xb20f, 0xb231, 0xb26c,
	0xb28e, 0xb2a5, 0xb2c0, 0xb2df, 0xb30f, 0xb323, 0xb348, 0xb369,
	0xb38b, 0xb3ad, 0xb3d4, 0xb3f7, 0xb418, 0xb439, 0xb45d, 0xb47e,
	0xb4a2, 0xb4c8, 0xb4d9, 0xb4eb, 0xb4fd, 0xb50f, 0xb523, 0xb534,
	0xb54d, 0xb567, 0xb581, 0xb59b, 0xb5b4, 0xb5cd, 0xb5e7, 0xb600,
	0xb61a, 0xb637, 0xb64b, 0xb669, 0xb686, 0xb6a3, 0xb6c6, 0xb6d7,
	0xb6e9, 0xb6fa, 0xb70b, 0xb71c, 0xb736, 0xb748, 0xb762, 0xb77d,
	// Entry 5900 - 593F
	0xb799, 0xb7b4, 0xb7d0, 0xb7ec, 0xb808, 0xb823, 0xb83f, 0xb85b,
	0xb878, 0xb894, 0xb8af, 0xb8ca, 0xb8e5, 0xb900, 0xb91c, 0xb937,
	0xb94e, 0xb960, 0xb983, 0xb998, 0xb9aa, 0xb9bc, 0xb9cf, 0xb9ea,
	0xba07, 0xba25, 0xba41, 0xba5f, 0xba7c, 0xba97, 0xbab9, 0xbacc,
	0xbae0, 0xbaf4, 0xbb06, 0xbb1b, 0xbb50, 0xbb85, 0xbb99, 0xbbac,
	0xbbc0, 0xbbd5, 0xbbec, 0xbbff, 0xbc1a, 0xbc36, 0xbc49, 0xbc64,
	0xbc81, 0xbca0, 0xbcbd, 0xbcda, 0xbcf7, 0xbd19, 0xbd39, 0xbd56,
	0xbd73, 0xbd90, 0xbda5, 0xbdb8, 0xbdd0, 0xbdfa, 0xbe0e, 0xbe20,
	// Entry 5940 - 597F
	0xbe44, 0xbe57, 0xbe6c, 0xbe7d, 0xbe93, 0xbea5, 0xbeb8, 0xbeda,
	0xbeed, 0xbf01, 0xbf12, 0xbf2b, 0xbf3d, 0xbf50, 0xbf64, 0xbf76,
	0xbf8b, 0xbf9d, 0xbfb0, 0xbfc1, 0xbfdb, 0xbff5, 0xc00f, 0xc025,
	0xc037, 0xc06c, 0xc086, 0xc098, 0xc0b3, 0xc0cf, 0xc0eb, 0xc107,
	0xc124, 0xc13f, 0xc152, 0xc164, 0xc175, 0xc18b, 0xc19c, 0xc1b2,
	0xc1c4, 0xc1d6, 0xc1f3, 0xc20e, 0xc243, 0xc254, 0xc267, 0xc279,
	0xc28b, 0xc29d, 0xc2c3, 0xc2d3, 0xc2e7, 0xc2fb, 0xc32a, 0xc34e,
	0xc380, 0xc391, 0xc3a2, 0xc3b3, 0xc3cb, 0xc3e6, 0xc400, 0xc427,
	// Entry 5980 - 59BF
	0xc453, 0xc469, 0xc482, 0xc4a5, 0xc4b8, 0xc4c9, 0xc4e6, 0xc508,
	0xc524, 0xc53d, 0xc551, 0xc564, 0xc584, 0xc5a0, 0xc5b1, 0xc5c7,
	0xc5d8, 0xc5f5, 0xc60e, 0xc620, 0xc642, 0xc664, 0xc67f, 0xc69a,
	0xc6b6, 0xc6d1, 0xc6f5, 0xc718, 0xc72a, 0xc73c, 0xc74f, 0xc761,
	0xc77b, 0xc79a, 0xc7b6, 0xc7d2, 0xc7ed, 0xc809, 0xc82b, 0xc847,
	0xc862, 0xc87d, 0xc899, 0xc8b4, 0xc8d0, 0xc8eb, 0xc907, 0xc923,
	0xc93e, 0xc95a, 0xc977, 0xc992, 0xc9b5, 0xc9d0, 0xc9ee, 0xca02,
	0xca1e, 0xca30, 0xca4a, 0xca65, 0xca81, 0xca9e, 0xcab1, 0xcac4,
	// Entry 59C0 - 59FF
	0xcad9, 0xcaed, 0xcaff, 0xcb1e, 0xcb30, 0xcb41, 0xcb57, 0xcb7a,
	0xcb8c, 0xcb9f, 0xcbb1, 0xcbc2, 0xcbdb, 0xcbed, 0xcbff, 0xcc1b,
	0xcc2d, 0xcc40, 0xcc51, 0xcc63, 0xcc7d, 0xcc91, 0xcca3, 0xccbd,
	0xccd8, 0xccf2, 0xcd0f, 0xcd3b, 0xcd4e, 0xcd6a, 0xcd86, 0xcda3,
	0xcdc0, 0xcdeb, 0xce08, 0xce1b, 0xce2d, 0xce40, 0xce5d, 0xce79,
	0xce95, 0xceb0, 0xced5, 0xcef0, 0xcf0a, 0xcf26, 0xcf40, 0xcf5b,
	0xcf78, 0xcf9c, 0xcfc2, 0xcfde, 0xcff1, 0xd00e, 0xd020, 0xd032,
	0xd045, 0xd064, 0xd082, 0xd0ac, 0xd0c9, 0xd0dc, 0xd0fd, 0xd10f,
	// Entry 5A00 - 5A3F
	0xd129, 0xd13b, 0xd159, 0xd179, 0xd198, 0xd1b7, 0xd1d5, 0xd1f5,
	0xd215, 0xd234, 0xd255, 0xd275, 0xd295, 0xd2b4, 0xd2d5, 0xd2f6,
	0xd316, 0xd333, 0xd350, 0xd36c, 0xd38a, 0xd3a8, 0xd3c5, 0xd3e5,
	0xd405, 0xd427, 0xd448, 0xd469, 0xd489, 0xd4ab, 0xd4cd, 0xd4ee,
	0xd50e, 0xd52e, 0xd550, 0xd571, 0xd592, 0xd5b2, 0xd5d4, 0xd603,
	0xd624, 0xd645, 0xd665, 0xd687, 0xd6a9, 0xd6ca, 0xd6ea, 0xd70a,
	0xd72c, 0xd75b, 0xd77c, 0xd79d, 0xd7cd, 0xd7fc, 0xd81b, 0xd83a,
	0xd85b, 0xd889, 0xd8a9, 0xd8c9, 0xd8f8, 0xd927, 0xd955, 0xd984,
	// Entry 5A40 - 5A7F
	0xd9b4, 0xd9e4, 0xda10, 0xda3f, 0xda6f, 0xda9f, 0xdacd, 0xdafc,
	0xdb2b, 0xdb5b, 0xdb8b, 0xdbbc, 0xdbdf, 0xdc04, 0xdc28, 0xdc4c,
	0xdc6f, 0xdc8e, 0xdcad, 0xdcce, 0xdcee, 0xdd1b, 0xdd3b, 0xdd68,
	0xdd88, 0xdda8, 0xddc8, 0xdde8, 0xde0d, 0xde33, 0xde5a, 0xde89,
	0xdeb9, 0xdede, 0xdf04, 0xdf31, 0xdf60, 0xdf86, 0xdfa9, 0xdfd1,
	0xdffa, 0xe01e, 0xe042, 0xe06c, 0xe096, 0xe0bf, 0xe0ea, 0xe115,
	0xe13f, 0xe173, 0xe19c, 0xe1c5, 0xe1f1, 0xe21e, 0xe23e, 0xe25a,
	0xe276, 0xe298, 0xe2b7, 0xe2d5, 0xe2f3, 0xe316, 0xe332, 0xe34e,
	// Entry 5A80 - 5ABF
	0xe36a, 0xe388, 0xe3a4, 0xe3c2, 0xe3de, 0xe402, 0xe41e, 0xe43a,
	0xe458, 0xe473, 0xe48e, 0xe4b0, 0xe4cd, 0xe4e8, 0xe503, 0xe524,
	0xe543, 0xe55f, 0xe57e, 0xe5a9, 0xe5c9, 0xe5e5, 0xe60b, 0xe631,
	0xe64e, 0xe66a, 0xe685, 0xe6a0, 0xe6bb, 0xe6d7, 0xe6f7, 0xe712,
	0xe72d, 0xe743, 0xe764, 0xe789, 0xe7ad, 0xe7d7, 0xe7fb, 0xe820,
	0xe844, 0xe869, 0xe88d, 0xe8a9, 0xe8c8, 0xe8e9, 0xe914, 0xe93d,
	0xe95a, 0xe975, 0xe999, 0xe9bd, 0xe9df, 0xea0a, 0xea26, 0xea4c,
	0xea68, 0xea85, 0xeaa0, 0xeac3, 0xeae6, 0xeb03, 0xeb20, 0xeb4a,
	// Entry 5AC0 - 5AFF
	0xeb68, 0xeb94, 0xebb5, 0xebdc, 0xebf7, 0xec24, 0xec3e, 0xec58,
	0xec75, 0xec8f, 0xecb4, 0xecca, 0xece0, 0xecf6, 0xed0c, 0xed22,
	0xed38, 0xed4e, 0xed76, 0xed8c, 0xedaf, 0xedc5, 0xeddb, 0xedf1,
	0xee07, 0xee1d, 0xee33, 0xee49, 0xee5f, 0xee75, 0xee8b, 0xeea1,
	0xeeb7, 0xeecd, 0xeee3, 0xeef9, 0xef0f, 0xef25, 0xef3b, 0xef51,
	0xef70, 0xef90, 0xefb9, 0xefeb, 0xf012, 0xf028, 0xf03e, 0xf054,
	0xf06a, 0xf080, 0xf096, 0xf0ac, 0xf0c2, 0xf0d8, 0xf0ee, 0xf104,
	0xf124, 0xf144, 0xf16f, 0xf18f, 0xf1ae, 0xf1ce, 0xf1ed, 0xf20c,
	// Entry 5B00 - 5B3F
	0xf22b, 0xf24d, 0xf263, 0xf279, 0xf299, 0xf2b8, 0xf2d8, 0xf2fd,
	0xf31c, 0xf34e, 0xf378, 0xf397, 0xf3b9, 0xf3cf, 0xf3e5, 0xf406,
	0xf423, 0xf43f, 0xf45b, 0xf489, 0xf4a6, 0xf4c0, 0xf4e6, 0xf50d,
	0xf531, 0xf551, 0xf570, 0xf58e, 0xf5af, 0xf5d2, 0xf5f2, 0xf61a,
	0xf637, 0xf65b, 0xf67c, 0xf69c, 0xf6b7, 0xf6db, 0xf6f8, 0xf710,
	0xf72b, 0xf747, 0xf763, 0xf77e, 0xf7a3, 0xf7c7, 0xf7e3, 0xf7ff,
	0xf821, 0xf844, 0xf85f, 0xf87a, 0xf898, 0xf8b8, 0xf8d4, 0xf8e6,
	0xf908, 0xf930, 0xf947, 0xf95e, 0xf975, 0xf98c, 0xf9a3, 0xf9ba,
	// Entry 5B40 - 5B7F
	0xf9d1, 0xf9e8, 0xf9ff, 0xfa16, 0xfa2d, 0xfa45, 0xfa5c, 0xfa73,
	0xfa8a, 0xfaa1, 0xfab8, 0xfacf, 0xfae6, 0xfafd, 0xfb14, 0xfb2b,
	0xfb42, 0xfb59, 0xfb70, 0xfb87, 0xfb9e, 0xfbb5, 0xfbcc, 0xfbe3,
	0xfbfa, 0xfc11, 0xfc28, 0xfc3f, 0xfc56, 0xfc6d, 0xfc84, 0xfc9b,
	0xfcb2, 0xfcc9, 0xfce0, 0xfcf7, 0xfd0e, 0xfd25, 0xfd3c, 0xfd53,
	0xfd6a, 0xfd81, 0xfd98, 0xfdaf, 0xfdc6, 0xfddd, 0xfdf4, 0xfe0b,
	0xfe22, 0xfe39, 0xfe50, 0xfe67, 0xfe7e, 0xfe95, 0xfeac, 0xfec3,
	0xfedb, 0xfef2, 0xff09, 0xff20, 0xff37, 0xff4e, 0xff65, 0xff7c,
	// Entry 5B80 - 5BBF
	0xff93, 0xffaa, 0xffc1, 0xffd8, 0xffef, 0x0006, 0x001d, 0x0034,
	0x004b, 0x0062, 0x0079, 0x0090, 0x00a7, 0x00be, 0x00d5, 0x00ec,
	0x0103, 0x011a, 0x0131, 0x0148, 0x015f, 0x0176, 0x018d, 0x01a4,
	0x01bb, 0x01d2, 0x01e9, 0x0200, 0x0217, 0x022f, 0x0247, 0x025f,
	0x0277, 0x028f, 0x02a8, 0x02c0, 0x02d9, 0x02f2, 0x030a, 0x0322,
	0x033a, 0x0352, 0x036a, 0x0382, 0x039a, 0x03b2, 0x03cb, 0x03e3,
	0x03fb, 0x0413, 0x042c, 0x0444, 0x045c, 0x0474, 0x048c, 0x04a4,
	0x04bc, 0x04d4, 0x04ec, 0x0504, 0x051c, 0x0534, 0x054c, 0x0564,
	// Entry 5BC0 - 5BFF
	0x057c, 0x0594, 0x05ad, 0x05c5, 0x05dd, 0x05f5, 0x060d, 0x0625,
	0x063d, 0x0655, 0x066d, 0x0686, 0x069e, 0x06b6, 0x06cf, 0x06e7,
	0x0700, 0x0718, 0x0730, 0x0749, 0x0761, 0x0779, 0x0791, 0x07a9,
	0x07c1, 0x07d9, 0x07f1, 0x0809, 0x0821, 0x0839, 0x0851, 0x0869,
	0x0881, 0x0899, 0x08b1, 0x08c9, 0x08e1, 0x08f9, 0x0911, 0x0929,
	0x0941, 0x0959, 0x0971, 0x0989, 0x09a1, 0x09b9, 0x09d1, 0x09e9,
	0x0a01, 0x0a19, 0x0a32, 0x0a4a, 0x0a62, 0x0a7a, 0x0a92, 0x0aaa,
	0x0ac2, 0x0adb, 0x0af4, 0x0b0d, 0x0b25, 0x0b3d, 0x0b55, 0x0b6d,
	// Entry 5C00 - 5C3F
	0x0b85, 0x0b9d, 0x0bb5, 0x0bcd, 0x0be6, 0x0bfe, 0x0c16, 0x0c2e,
	0x0c46, 0x0c5e, 0x0c76, 0x0c8e, 0x0ca6, 0x0cbe, 0x0cd6, 0x0cee,
	0x0d06, 0x0d1e, 0x0d36, 0x0d4e, 0x0d66, 0x0d7e, 0x0d96, 0x0dae,
	0x0dc6, 0x0dde, 0x0df6, 0x0e0f, 0x0e27, 0x0e3f, 0x0e57, 0x0e6f,
	0x0e87, 0x0e9f, 0x0eb7, 0x0ecf, 0x0ee7, 0x0eff, 0x0f17, 0x0f2f,
	0x0f47, 0x0f5f, 0x0f77, 0x0f8f, 0x0fa7, 0x0fbf, 0x0fd7, 0x0ff0,
	0x1008, 0x1020, 0x1038, 0x1050, 0x1069, 0x1081, 0x1099, 0x10b1,
	0x10ca, 0x10e2, 0x10fa, 0x1112, 0x112a, 0x1142, 0x115a, 0x1172,
	// Entry 5C40 - 5C7F
	0x118a, 0x11a2, 0x11ba, 0x11d2, 0x11ea, 0x1203, 0x121b, 0x1233,
	0x124c, 0x1264, 0x127c, 0x1295, 0x12ae, 0x12c7, 0x12e0, 0x12f9,
	0x1312, 0x132b, 0x1344, 0x135d, 0x1375, 0x138d, 0x13a6, 0x13be,
	0x13d6, 0x13ef, 0x1407, 0x141f, 0x1437, 0x144f, 0x1467, 0x147f,
	0x1497, 0x14af, 0x14c7, 0x14df, 0x14f7, 0x150f, 0x1527, 0x1540,
	0x1559, 0x1572, 0x158b, 0x15a4, 0x15bd, 0x15d6, 0x15ef, 0x1607,
	0x161f, 0x1637, 0x164f, 0x1667, 0x167f, 0x1697, 0x16af, 0x16c8,
	0x16e0, 0x16f9, 0x1711, 0x1729, 0x1741, 0x1759, 0x1771, 0x1789,
	// Entry 5C80 - 5CBF
	0x17a1, 0x17ba, 0x17d2, 0x17eb, 0x1803, 0x181b, 0x1833, 0x184c,
	0x1864, 0x187c, 0x1894, 0x18ac, 0x18c4, 0x18dc, 0x18f4, 0x190c,
	0x1925, 0x193d, 0x1955, 0x196d, 0x1985, 0x199d, 0x19b5, 0x19ce,
	0x19e6, 0x19fe, 0x1a16, 0x1a2e, 0x1a47, 0x1a5f, 0x1a77, 0x1a8f,
	0x1aa7, 0x1abf, 0x1ad7, 0x1aef, 0x1b07, 0x1b1f, 0x1b37, 0x1b4f,
	0x1b67, 0x1b80, 0x1b98, 0x1bb0, 0x1bc8, 0x1be0, 0x1bf8, 0x1c10,
	0x1c28, 0x1c40, 0x1c59, 0x1c71, 0x1c89, 0x1ca1, 0x1cb9, 0x1cd1,
	0x1ce9, 0x1d01, 0x1d19, 0x1d31, 0x1d49, 0x1d62, 0x1d7a, 0x1d92,
	// Entry 5CC0 - 5CFF
	0x1daa, 0x1dc2, 0x1dda, 0x1df2, 0x1e0b, 0x1e23, 0x1e3c, 0x1e54,
	0x1e6c, 0x1e84, 0x1e9c, 0x1eb4, 0x1ecc, 0x1ee4, 0x1efd, 0x1f15,
	0x1f2e, 0x1f46, 0x1f5f, 0x1f77, 0x1f8f, 0x1fa7, 0x1fbf, 0x1fd8,
	0x1ff1, 0x200a, 0x2022, 0x203a, 0x2052, 0x206a, 0x2082, 0x209a,
	0x20b2, 0x20ca, 0x20e3, 0x20fb, 0x2114, 0x212d, 0x2145, 0x215d,
	0x2175, 0x218d, 0x21a6, 0x21be, 0x21d6, 0x21ee, 0x2206, 0x221e,
	0x2236, 0x224e, 0x2266, 0x227e, 0x2297, 0x22af, 0x22c7, 0x22df,
	0x22f7, 0x230f, 0x2327, 0x2340, 0x2358, 0x2370, 0x2388, 0x23a0,
	// Entry 5D00 - 5D3F
	0x23b8, 0x23d0, 0x23e8, 0x2400, 0x2418, 0x2430, 0x2449, 0x2461,
	0x247a, 0x2492, 0x24aa, 0x24c2, 0x24da, 0x24f2, 0x250a, 0x2523,
	0x253b, 0x2553, 0x256c, 0x2584, 0x259c, 0x25b4, 0x25cc, 0x25e4,
	0x25fc, 0x2614, 0x262c, 0x2644, 0x265c, 0x2674, 0x268c, 0x26a4,
	0x26bc, 0x26d4, 0x26ed, 0x2705, 0x271d, 0x2735, 0x274d, 0x2765,
	0x277d, 0x2795, 0x27ae, 0x27c6, 0x27de, 0x27f6, 0x280e, 0x2827,
	0x283f, 0x2858, 0x2870, 0x2889, 0x28a1, 0x28b9, 0x28d1, 0x28e9,
	0x2901, 0x2919, 0x2931, 0x2949, 0x2961, 0x2979, 0x2991, 0x29a9,
	// Entry 5D40 - 5D7F
	0x29c1, 0x29d9, 0x29f2, 0x2a0a, 0x2a22, 0x2a3a, 0x2a52, 0x2a6b,
	0x2a83, 0x2a9b, 0x2ab3, 0x2acc, 0x2ae5, 0x2afd, 0x2b15, 0x2b2e,
	0x2b46, 0x2b5e, 0x2b76, 0x2b8e, 0x2ba6, 0x2bbe, 0x2bd6, 0x2bef,
	0x2c07, 0x2c1f, 0x2c38, 0x2c51, 0x2c6a, 0x2c83, 0x2c9c, 0x2cb5,
	0x2cce, 0x2ce7, 0x2cff, 0x2d17, 0x2d2f, 0x2d48, 0x2d60, 0x2d79,
	0x2d91, 0x2daa, 0x2dc2, 0x2dda, 0x2df2, 0x2e0a, 0x2e22, 0x2e3b,
	0x2e53, 0x2e6b, 0x2e84, 0x2e9c, 0x2eb4, 0x2ecc, 0x2ee4, 0x2efd,
	0x2f15, 0x2f2d, 0x2f45, 0x2f5e, 0x2f76, 0x2f8e, 0x2fa7, 0x2fc0,
	// Entry 5D80 - 5DBF
	0x2fd8, 0x2ff0, 0x3008, 0x3020, 0x3038, 0x3050, 0x3068, 0x3081,
	0x3099, 0x30b1, 0x30c9, 0x30e1, 0x30f9, 0x3111, 0x3129, 0x3141,
	0x3159, 0x3171, 0x3189, 0x31a1, 0x31b9, 0x31d1, 0x31e9, 0x3201,
	0x3219, 0x3231, 0x3249, 0x3261, 0x3279, 0x3291, 0x32aa, 0x32c3,
	0x32db, 0x32f3, 0x330b, 0x3323, 0x333b, 0x3353, 0x336b, 0x3384,
	0x339c, 0x33b4, 0x33cc, 0x33e4, 0x33fc, 0x3414, 0x342c, 0x3444,
	0x345d, 0x3475, 0x348e, 0x34a6, 0x34bf, 0x34d7, 0x34ef, 0x3508,
	0x3520, 0x3538, 0x3550, 0x3568, 0x3580, 0x3599, 0x35b2, 0x35cb,
	// Entry 5DC0 - 5DFF
	0x35e4, 0x35fd, 0x3617, 0x3630, 0x3649, 0x3662, 0x367b, 0x3694,
	0x36ad, 0x36c6, 0x36df, 0x36f8, 0x3711, 0x372a, 0x3743, 0x375d,
	0x3776, 0x378f, 0x37a8, 0x37c1, 0x37da, 0x37f3, 0x380c, 0x3825,
	0x383e, 0x3857, 0x3870, 0x3889, 0x38a2, 0x38bc, 0x38d5, 0x38ef,
	0x3908, 0x3921, 0x393a, 0x3953, 0x396c, 0x3985, 0x399e, 0x39b8,
	0x39d1, 0x39ea, 0x3a03, 0x3a1c, 0x3a36, 0x3a4e, 0x3a67, 0x3a7f,
	0x3a97, 0x3aaf, 0x3ac7, 0x3ae0, 0x3af8, 0x3b11, 0x3b2a, 0x3b43,
	0x3b5c, 0x3b75, 0x3b8e, 0x3ba6, 0x3bbe, 0x3bd6, 0x3bee, 0x3c07,
	// Entry 5E00 - 5E3F
	0x3c20, 0x3c39, 0x3c51, 0x3c69, 0x3c81, 0x3c99, 0x3cb1, 0x3cc9,
	0x3ce1, 0x3cf9, 0x3d11, 0x3d2a, 0x3d42, 0x3d5b, 0x3d73, 0x3d8b,
	0x3da3, 0x3dbb, 0x3dd4, 0x3dec, 0x3e05, 0x3e1d, 0x3e35, 0x3e4d,
	0x3e65, 0x3e7e, 0x3e96, 0x3eaf, 0x3ec7, 0x3edf, 0x3ef7, 0x3f10,
	0x3f28, 0x3f40, 0x3f58, 0x3f71, 0x3f8a, 0x3fa3, 0x3fbc, 0x3fd4,
	0x3fec, 0x4004, 0x401c, 0x4034, 0x404c, 0x4064, 0x407c, 0x4094,
	0x40ac, 0x40c4, 0x40dc, 0x40f4, 0x410c, 0x4125, 0x413e, 0x4156,
	0x416e, 0x4187, 0x419f, 0x41b7, 0x41d0, 0x41e8, 0x4200, 0x4218,
	// Entry 5E40 - 5E7F
	0x4230, 0x4248, 0x4260, 0x4278, 0x4290, 0x42a8, 0x42c0, 0x42d8,
	0x42f0, 0x4308, 0x4320, 0x4338, 0x4350, 0x4368, 0x4381, 0x4399,
	0x43b2, 0x43cb, 0x43e3, 0x43fb, 0x4413, 0x442b, 0x4443, 0x445b,
	0x4473, 0x448c, 0x44a4, 0x44bc, 0x44d4, 0x44ec, 0x4504, 0x451c,
	0x4535, 0x454d, 0x4565, 0x457d, 0x4595, 0x45ad, 0x45c5, 0x45dd,
	0x45f5, 0x460d, 0x4625, 0x463d, 0x4655, 0x466d, 0x4685, 0x469d,
	0x46b6, 0x46ce, 0x46e6, 0x46fe, 0x4716, 0x472f, 0x4747, 0x475f,
	0x4777, 0x478f, 0x47a7, 0x47bf, 0x47d7, 0x47ef, 0x4808, 0x4821,
	// Entry 5E80 - 5EBF
	0x4839, 0x4851, 0x4869, 0x4882, 0x489a, 0x48b2, 0x48ca, 0x48e2,
	0x48fa, 0x4912, 0x492a, 0x4942, 0x495a, 0x4973, 0x498c, 0x49a4,
	0x49bc, 0x49d4, 0x49ec, 0x4a04, 0x4a1c, 0x4a34, 0x4a4c, 0x4a64,
	0x4a7d, 0x4a95, 0x4aad, 0x4ac5, 0x4add, 0x4af5, 0x4b0d, 0x4b25,
	0x4b3d, 0x4b55, 0x4b6d, 0x4b85, 0x4b9d, 0x4bb5, 0x4bcd, 0x4be6,
	0x4bfe, 0x4c16, 0x4c2e, 0x4c46, 0x4c5f, 0x4c77, 0x4c90, 0x4ca8,
	0x4cc1, 0x4cd9, 0x4cf1, 0x4d0a, 0x4d22, 0x4d3a, 0x4d52, 0x4d6a,
	0x4d82, 0x4d9b, 0x4db3, 0x4dcb, 0x4de3, 0x4dfb, 0x4e13, 0x4e2b,
	// Entry 5EC0 - 5EFF
	0x4e43, 0x4e5b, 0x4e73, 0x4e8b, 0x4ea3, 0x4ebb, 0x4ed3, 0x4eeb,
	0x4f03, 0x4f1b, 0x4f34, 0x4f4c, 0x4f65, 0x4f7d, 0x4f95, 0x4fad,
	0x4fc5, 0x4fdd, 0x4ff5, 0x500d, 0x5025, 0x503d, 0x5056, 0x506f,
	0x5087, 0x509f, 0x50b7, 0x50cf, 0x50e7, 0x50ff, 0x5117, 0x512f,
	0x5147, 0x515f, 0x5177, 0x518f, 0x51a7, 0x51bf, 0x51d7, 0x51ef,
	0x5207, 0x5220, 0x5238, 0x5250, 0x5268, 0x5280, 0x5298, 0x52b0,
	0x52c9, 0x52e1, 0x52f9, 0x5311, 0x532a, 0x5342, 0x535a, 0x5372,
	0x538a, 0x53a2, 0x53ba, 0x53d2, 0x53ea, 0x5402, 0x541a, 0x5432,
	// Entry 5F00 - 5F3F
	0x544b, 0x5464, 0x547d, 0x5496, 0x54af, 0x54c8, 0x54e1, 0x54fa,
	0x5513, 0x552b, 0x5544, 0x555c, 0x5574, 0x558c, 0x55a4, 0x55bc,
	0x55d5, 0x55ee, 0x5606, 0x561e, 0x5636, 0x564e, 0x5667, 0x5680,
	0x5699, 0x56b1, 0x56ca, 0x56e3, 0x56fb, 0x5713, 0x572b, 0x5743,
	0x575b, 0x5773, 0x578b, 0x57a3, 0x57bc, 0x57d5, 0x57ee, 0x5807,
	0x5820, 0x5839, 0x5852, 0x586b, 0x5884, 0x589d, 0x58b6, 0x58cf,
	0x58e7, 0x58ff, 0x5917, 0x5930, 0x5948, 0x5960, 0x5978, 0x5990,
	0x59a8, 0x59c1, 0x59d9, 0x59f2, 0x5a0a, 0x5a23, 0x5a3b, 0x5a54,
	// Entry 5F40 - 5F7F
	0x5a6c, 0x5a84, 0x5a9d, 0x5ab5, 0x5acd, 0x5ae5, 0x5afd, 0x5b16,
	0x5b2e, 0x5b46, 0x5b5e, 0x5b77, 0x5b8f, 0x5ba7, 0x5bbf, 0x5bd8,
	0x5bf0, 0x5c08, 0x5c20, 0x5c38, 0x5c50, 0x5c68, 0x5c81, 0x5c99,
	0x5cb2, 0x5cca, 0x5ce2, 0x5cfa, 0x5d12, 0x5d2b, 0x5d43, 0x5d5b,
	0x5d73, 0x5d8c, 0x5da4, 0x5dbd, 0x5dd5, 0x5ded, 0x5e05, 0x5e1d,
	0x5e35, 0x5e4d, 0x5e66, 0x5e7e, 0x5e96, 0x5eae, 0x5ec6, 0x5ede,
	0x5ef7, 0x5f10, 0x5f28, 0x5f40, 0x5f59, 0x5f71, 0x5f89, 0x5fa2,
	0x5fba, 0x5fd3, 0x5feb, 0x6003, 0x601b, 0x6033, 0x604b, 0x6063,
	// Entry 5F80 - 5FBF
	0x607b, 0x6093, 0x60ab, 0x60c4, 0x60dd, 0x60f6, 0x610f, 0x6127,
	0x6140, 0x6159, 0x6171, 0x618a, 0x61a2, 0x61bb, 0x61d3, 0x61eb,
	0x6203, 0x621b, 0x6233, 0x624b, 0x6263, 0x627b, 0x6293, 0x62ab,
	0x62c4, 0x62dd, 0x62f6, 0x630f, 0x6328, 0x6341, 0x635a, 0x6373,
	0x638c, 0x63a4, 0x63bd, 0x63d6, 0x63ef, 0x6408, 0x6421, 0x643a,
	0x6453, 0x646c, 0x6485, 0x649e, 0x64b7, 0x64d0, 0x64e9, 0x6502,
	0x651b, 0x6535, 0x654f, 0x6568, 0x6581, 0x659a, 0x65b3, 0x65cc,
	0x65e5, 0x65fe, 0x6617, 0x6630, 0x6649, 0x6662, 0x667b, 0x6694,
	// Entry 5FC0 - 5FFF
	0x66ad, 0x66c6, 0x66df, 0x66f8, 0x6711, 0x672a, 0x6743, 0x675c,
	0x6775, 0x678e, 0x67a7, 0x67c0, 0x67d9, 0x67fc, 0x6821, 0x6848,
	0x6872, 0x6897, 0x68bf, 0x68e1, 0x6902, 0x6921, 0x6945, 0x6966,
	0x698a, 0x69ad, 0x69ce, 0x69f8, 0x6a20, 0x6a47, 0x6a65, 0x6a83,
	0x6aa0, 0x6ac2, 0x6ae4, 0x6b06, 0x6b37, 0x6b6b, 0x6b98, 0x6bc7,
	0x6bf2, 0x6c32, 0x6c67, 0x6c99, 0x6cd9, 0x6d07, 0x6d3f, 0x6d6a,
	0x6d9d, 0x6dd3, 0x6df7, 0x6e10, 0x6e29, 0x6e42, 0x6e5b, 0x6e74,
	0x6e8d, 0x6ea6, 0x6ebf, 0x6ed8, 0x6ef1, 0x6f0a, 0x6f23, 0x6f3c,
	// Entry 6000 - 603F
	0x6f55, 0x6f6e, 0x6f87, 0x6fa0, 0x6fb9, 0x6fd2, 0x6feb, 0x7004,
	0x701d, 0x7036, 0x704f, 0x7068, 0x7081, 0x709a, 0x70b3, 0x70cc,
	0x70e5, 0x70fe, 0x7117, 0x7130, 0x7149, 0x7162, 0x717b, 0x7194,
	0x71ad, 0x71c6, 0x71df, 0x71f8, 0x7211, 0x722a, 0x7243, 0x725c,
	0x7275, 0x728e, 0x72a7, 0x72c0, 0x72d9, 0x72f2, 0x730b, 0x7324,
	0x733d, 0x7356, 0x736f, 0x7388, 0x73a1, 0x73ba, 0x73d3, 0x73ec,
	0x7405, 0x741e, 0x7437, 0x7450, 0x7469, 0x7482, 0x749b, 0x74b4,
	0x74cd, 0x74e6, 0x74ff, 0x7518, 0x7531, 0x754a, 0x7563, 0x757c,
	// Entry 6040 - 607F
	0x7595, 0x75ae, 0x75c7, 0x75e0, 0x75f9, 0x7612, 0x762b, 0x7644,
	0x765d, 0x7676, 0x768f, 0x76a8, 0x76c1, 0x76da, 0x76f3, 0x770c,
	0x7725, 0x773e, 0x7757, 0x7770, 0x7789, 0x77a2, 0x77bb, 0x77d4,
	0x77ed, 0x7806, 0x781f, 0x7838, 0x7851, 0x786a, 0x7883, 0x789c,
	0x78b5, 0x78ce, 0x78e7, 0x7900, 0x7919, 0x7932, 0x794b, 0x7964,
	0x797d, 0x7996, 0x79af, 0x79c8, 0x79e1, 0x79fa, 0x7a13, 0x7a2c,
	0x7a45, 0x7a5e, 0x7a77, 0x7a90, 0x7aa9, 0x7ac2, 0x7adb, 0x7af4,
	0x7b0d, 0x7b26, 0x7b3f, 0x7b58, 0x7b71, 0x7b8a, 0x7ba3, 0x7bbc,
	// Entry 6080 - 60BF
	0x7bd5, 0x7bee, 0x7c07, 0x7c20, 0x7c39, 0x7c52, 0x7c6b, 0x7c84,
	0x7c9d, 0x7cb6, 0x7ccf, 0x7ce8, 0x7d01, 0x7d1a, 0x7d33, 0x7d4c,
	0x7d65, 0x7d7e, 0x7d97, 0x7db0, 0x7dc9, 0x7de2, 0x7dfb, 0x7e14,
	0x7e2d, 0x7e46, 0x7e5f, 0x7e78, 0x7e91, 0x7eaa, 0x7ec3, 0x7edc,
	0x7ef5, 0x7f0e, 0x7f27, 0x7f40, 0x7f59, 0x7f72, 0x7f8b, 0x7fa4,
	0x7fbd, 0x7fd6, 0x7fef, 0x8008, 0x8021, 0x803a, 0x8053, 0x806c,
	0x8085, 0x809e, 0x80b7, 0x80d0, 0x80e9, 0x8102, 0x811b, 0x8134,
	0x814d, 0x8166, 0x817f, 0x8198, 0x81b1, 0x81ca, 0x81e3, 0x81fc,
	// Entry 60C0 - 60FF
	0x8215, 0x822e, 0x8247, 0x8260, 0x8279, 0x8292, 0x82ab, 0x82c4,
	0x82dd, 0x82f6, 0x830f, 0x8328, 0x8341, 0x835a, 0x8373, 0x838c,
	0x83a5, 0x83be, 0x83d7, 0x83f0, 0x8409, 0x8422, 0x843b, 0x8454,
	0x846d, 0x8486, 0x849f, 0x84b8, 0x84d1, 0x84ea, 0x8503, 0x851c,
	0x8535, 0x854e, 0x8567, 0x8580, 0x8599, 0x85b2, 0x85cb, 0x85e4,
	0x85fd, 0x8616, 0x862f, 0x8648, 0x8661, 0x867a, 0x8693, 0x86ac,
	0x86c5, 0x86de, 0x86f7, 0x8710, 0x8729, 0x8742, 0x875b, 0x8774,
	0x878d, 0x87a6, 0x87bf, 0x87d8, 0x87f1, 0x880a, 0x8823, 0x883c,
	// Entry 6100 - 613F
	0x8855, 0x886e, 0x8887, 0x88a0, 0x88b9, 0x88d2, 0x88eb, 0x8904,
	0x891d, 0x8936, 0x894f, 0x8968, 0x8981, 0x899a, 0x89b3, 0x89cc,
	0x89e5, 0x89fe, 0x8a17, 0x8a30, 0x8a49, 0x8a62, 0x8a7b, 0x8a94,
	0x8aad, 0x8ac6, 0x8adf, 0x8af8, 0x8b11, 0x8b2a, 0x8b43, 0x8b5c,
	0x8b75, 0x8b8e, 0x8ba7, 0x8bc0, 0x8bd9, 0x8bf2, 0x8c0b, 0x8c24,
	0x8c3d, 0x8c56, 0x8c6f, 0x8c88, 0x8ca1, 0x8cba, 0x8cd3, 0x8cec,
	0x8d05, 0x8d1e, 0x8d37, 0x8d50, 0x8d69, 0x8d82, 0x8d9b, 0x8db4,
	0x8dcd, 0x8de6, 0x8dff, 0x8e18, 0x8e31, 0x8e4a, 0x8e63, 0x8e7c,
	// Entry 6140 - 617F
	0x8e95, 0x8eae, 0x8ec7, 0x8ee0, 0x8ef9, 0x8f12, 0x8f2b, 0x8f44,
	0x8f5d, 0x8f76, 0x8f8f, 0x8fa8, 0x8fc1, 0x8fda, 0x8ff3, 0x900c,
	0x9025, 0x903e, 0x9057, 0x9070, 0x9089, 0x90a2, 0x90bb, 0x90d4,
	0x90ed, 0x9106, 0x911f, 0x9138, 0x9151, 0x916a, 0x9183, 0x919c,
	0x91b5, 0x91ce, 0x91e7, 0x9200, 0x9219, 0x9232, 0x924b, 0x9264,
	0x927d, 0x9296, 0x92af, 0x92c8, 0x92e1, 0x92fa, 0x9313, 0x932c,
	0x9345, 0x935e, 0x9377, 0x9390, 0x93a9, 0x93c2, 0x93db, 0x93f4,
	0x940d, 0x9426, 0x943f, 0x9458, 0x9471, 0x948a, 0x94a3, 0x94bc,
	// Entry 6180 - 61BF
	0x94d5, 0x94ee, 0x9507, 0x9520, 0x9539, 0x9552, 0x956b, 0x9584,
	0x959d, 0x95b6, 0x95cf, 0x95e8, 0x9601, 0x961a, 0x9633, 0x964c,
	0x9665, 0x967e, 0x9697, 0x96b0, 0x96c9, 0x96e2, 0x96fb, 0x9714,
	0x972d, 0x9746, 0x975f, 0x9778, 0x9791, 0x97aa, 0x97c3, 0x97dc,
	0x97f5, 0x980e, 0x9827, 0x9840, 0x9859, 0x9872, 0x988b, 0x98a4,
	0x98bd, 0x98d6, 0x98ef, 0x9908, 0x9921, 0x993a, 0x9953, 0x996c,
	0x9985, 0x999e, 0x99b7, 0x99d0, 0x99e9, 0x9a02, 0x9a1b, 0x9a34,
	0x9a4d, 0x9a66, 0x9a7f, 0x9a98, 0x9ab1, 0x9aca, 0x9ae3, 0x9afc,
	// Entry 61C0 - 61FF
	0x9b15, 0x9b2e, 0x9b47, 0x9b60, 0x9b79, 0x9b92, 0x9bab, 0x9bc4,
	0x9bdd, 0x9bf6, 0x9c0f, 0x9c28, 0x9c41, 0x9c5a, 0x9c73, 0x9c8c,
	0x9ca5, 0x9cbe, 0x9cd7, 0x9cf0, 0x9d09, 0x9d22, 0x9d3b, 0x9d54,
	0x9d6d, 0x9d86, 0x9d9f, 0x9db8, 0x9dd1, 0x9dea, 0x9e03, 0x9e1c,
	0x9e35, 0x9e4e, 0x9e67, 0x9e80, 0x9e99, 0x9eb2, 0x9ecb, 0x9ee4,
	0x9efd, 0x9f16, 0x9f2f, 0x9f48, 0x9f61, 0x9f7a, 0x9f93, 0x9fac,
	0x9fc5, 0x9fde, 0x9ff7, 0xa010, 0xa029, 0xa042, 0xa05b, 0xa074,
	0xa08d, 0xa0a6, 0xa0bf, 0xa0d8, 0xa0f1, 0xa10a, 0xa123, 0xa13c,
	// Entry 6200 - 623F
	0xa155, 0xa16e, 0xa187, 0xa1a0, 0xa1b9, 0xa1d2, 0xa1eb, 0xa204,
	0xa21d, 0xa236, 0xa24f, 0xa268, 0xa281, 0xa29a, 0xa2b3, 0xa2cc,
	0xa2e5, 0xa2fe, 0xa317, 0xa330, 0xa349, 0xa362, 0xa37b, 0xa394,
	0xa3ad, 0xa3c6, 0xa3df, 0xa3f8, 0xa411, 0xa42a, 0xa443, 0xa45c,
	0xa475, 0xa48e, 0xa4a7, 0xa4c0, 0xa4d9, 0xa4f2, 0xa50b, 0xa524,
	0xa53d, 0xa556, 0xa56f, 0xa588, 0xa5a1, 0xa5ba, 0xa5d3, 0xa5ec,
	0xa605, 0xa61e, 0xa637, 0xa650, 0xa669, 0xa682, 0xa69b, 0xa6b4,
	0xa6cd, 0xa6e6, 0xa6ff, 0xa718, 0xa731, 0xa74a, 0xa763, 0xa77c,
	// Entry 6240 - 627F
	0xa795, 0xa7ae, 0xa7c7, 0xa7e0, 0xa7f9, 0xa812, 0xa82b, 0xa844,
	0xa85d, 0xa876, 0xa88f, 0xa8a8, 0xa8c1, 0xa8da, 0xa8f3, 0xa90c,
	0xa925, 0xa93e, 0xa957, 0xa970, 0xa989, 0xa9a2, 0xa9bb, 0xa9d4,
	0xa9ed, 0xaa06, 0xaa1f, 0xaa38, 0xaa51, 0xaa6a, 0xaa83, 0xaa9c,
	0xaab5, 0xaace, 0xaae7, 0xab00, 0xab19, 0xab32, 0xab4b, 0xab64,
	0xab7d, 0xab96, 0xabaf, 0xabc8, 0xabe1, 0xabfa, 0xac13, 0xac2c,
	0xac45, 0xac5e, 0xac77, 0xac90, 0xaca9, 0xacc2, 0xacdb, 0xacf4,
	0xad0d, 0xad26, 0xad3f, 0xad58, 0xad71, 0xad8a, 0xada3, 0xadbc,
	// Entry 6280 - 62BF
	0xadd5, 0xadee, 0xae07, 0xae20, 0xae39, 0xae52, 0xae6b, 0xae84,
	0xae9d, 0xaeb6, 0xaecf, 0xaee8, 0xaf01, 0xaf1a, 0xaf33, 0xaf4c,
	0xaf65, 0xaf7e, 0xaf97, 0xafb0, 0xafc9, 0xafe2, 0xaffb, 0xb014,
	0xb02d, 0xb046, 0xb05f, 0xb078, 0xb091, 0xb0aa, 0xb0c3, 0xb0dc,
	0xb0f5, 0xb10e, 0xb127, 0xb140, 0xb159, 0xb172, 0xb18b, 0xb1a4,
	0xb1bd, 0xb1d6, 0xb1ef, 0xb208, 0xb221, 0xb23a, 0xb253, 0xb26c,
	0xb285, 0xb29e, 0xb2b7, 0xb2d0, 0xb2e9, 0xb302, 0xb31b, 0xb334,
	0xb34d, 0xb366, 0xb37f, 0xb398, 0xb3b1, 0xb3ca, 0xb3e3, 0xb3fc,
	// Entry 62C0 - 62FF
	0xb415, 0xb42e, 0xb447, 0xb460, 0xb479, 0xb492, 0xb4ab, 0xb4c4,
	0xb4dd, 0xb4f6, 0xb50f, 0xb528, 0xb541, 0xb55a, 0xb573, 0xb58c,
	0xb5a5, 0xb5be, 0xb5d7, 0xb5f0, 0xb609, 0xb622, 0xb63b, 0xb654,
	0xb66d, 0xb686, 0xb69f, 0xb6b8, 0xb6d1, 0xb6ea, 0xb703, 0xb71c,
	0xb735, 0xb74e, 0xb767, 0xb780, 0xb799, 0xb7b2, 0xb7cb, 0xb7e4,
	0xb7fd, 0xb816, 0xb82f, 0xb848, 0xb861, 0xb87a, 0xb893, 0xb8ac,
	0xb8c5, 0xb8de, 0xb8f7, 0xb910, 0xb929, 0xb942, 0xb95b, 0xb974,
	0xb98d, 0xb9a6, 0xb9bf, 0xb9d8, 0xb9f1, 0xba0a, 0xba23, 0xba3c,
	// Entry 6300 - 633F
	0xba55, 0xba6e, 0xba87, 0xbaa0, 0xbab9, 0xbad2, 0xbaeb, 0xbb04,
	0xbb1d, 0xbb36, 0xbb4f, 0xbb68, 0xbb81, 0xbb9a, 0xbbb3, 0xbbcc,
	0xbbe5, 0xbbfe, 0xbc17, 0xbc30, 0xbc49, 0xbc62, 0xbc7b, 0xbc94,
	0xbcad, 0xbcc6, 0xbcdf, 0xbcf8, 0xbd11, 0xbd2a, 0xbd43, 0xbd5c,
	0xbd75, 0xbd8e, 0xbda7, 0xbdc0, 0xbdd9, 0xbdf2, 0xbe0b, 0xbe24,
	0xbe3d, 0xbe56, 0xbe6f, 0xbe88, 0xbea1, 0xbeba, 0xbed3, 0xbeec,
	0xbf05, 0xbf1e, 0xbf37, 0xbf50, 0xbf69, 0xbf82, 0xbf9b, 0xbfb4,
	0xbfcd, 0xbfe6, 0xbfff, 0xc018, 0xc031, 0xc04a, 0xc063, 0xc07c,
	// Entry 6340 - 637F
	0xc095, 0xc0ae, 0xc0c7, 0xc0e0, 0xc0f9, 0xc112, 0xc12b, 0xc144,
	0xc15d, 0xc176, 0xc18f, 0xc1a8, 0xc1c1, 0xc1da, 0xc1f3, 0xc20c,
	0xc225, 0xc23e, 0xc257, 0xc270, 0xc289, 0xc2a2, 0xc2bb, 0xc2d4,
	0xc2ed, 0xc306, 0xc31f, 0xc338, 0xc351, 0xc36a, 0xc383, 0xc39c,
	0xc3b5, 0xc3ce, 0xc3e7, 0xc400, 0xc419, 0xc432, 0xc44b, 0xc464,
	0xc47d, 0xc496, 0xc4af, 0xc4c8, 0xc4e1, 0xc4fa, 0xc513, 0xc52c,
	0xc545, 0xc55e, 0xc577, 0xc590, 0xc5a9, 0xc5c2, 0xc5db, 0xc5f4,
	0xc60d, 0xc626, 0xc63f, 0xc658, 0xc671, 0xc68a, 0xc6a3, 0xc6bc,
	// Entry 6380 - 63BF
	0xc6d5, 0xc6ee, 0xc707, 0xc720, 0xc739, 0xc752, 0xc76b, 0xc784,
	0xc79d, 0xc7b6, 0xc7cf, 0xc7e8, 0xc801, 0xc81a, 0xc833, 0xc84c,
	0xc865, 0xc87e, 0xc897, 0xc8b0, 0xc8c9, 0xc8e2, 0xc8fb, 0xc914,
	0xc92d, 0xc946, 0xc95f, 0xc978, 0xc991, 0xc9aa, 0xc9c3, 0xc9dc,
	0xc9f5, 0xca0e, 0xca27, 0xca40, 0xca59, 0xca72, 0xca8b, 0xcaa4,
	0xcabd, 0xcad6, 0xcaef, 0xcb08, 0xcb21, 0xcb3a, 0xcb53, 0xcb6c,
	0xcb85, 0xcb9e, 0xcbb7, 0xcbd0, 0xcbe9, 0xcc02, 0xcc1b, 0xcc34,
	0xcc4d, 0xcc66, 0xcc7f, 0xcc98, 0xccb1, 0xccca, 0xcce3, 0xccfc,
	// Entry 63C0 - 63FF
	0xcd15, 0xcd2e, 0xcd47, 0xcd60, 0xcd79, 0xcd92, 0xcdab, 0xcdc4,
	0xcddd, 0xcdf6, 0xce0f, 0xce28, 0xce41, 0xce5a, 0xce73, 0xce8c,
	0xcea5, 0xcebe, 0xced7, 0xcef0, 0xcf09, 0xcf22, 0xcf3b, 0xcf54,
	0xcf6d, 0xcf86, 0xcf9f, 0xcfb8, 0xcfd1, 0xcfea, 0xd003, 0xd01c,
	0xd035, 0xd04e, 0xd067, 0xd080, 0xd099, 0xd0b2, 0xd0cb, 0xd0e4,
	0xd0fd, 0xd116, 0xd12f, 0xd148, 0xd161, 0xd17a, 0xd193, 0xd1ac,
	0xd1c5, 0xd1de, 0xd1f7, 0xd210, 0xd229, 0xd242, 0xd25b, 0xd274,
	0xd28d, 0xd2a6, 0xd2bf, 0xd2d8, 0xd2f1, 0xd30a, 0xd323, 0xd33c,
	// Entry 6400 - 643F
	0xd355, 0xd36e, 0xd387, 0xd3a0, 0xd3b9, 0xd3d2, 0xd3eb, 0xd404,
	0xd41d, 0xd436, 0xd44f, 0xd468, 0xd481, 0xd49a, 0xd4b3, 0xd4cc,
	0xd4e5, 0xd4fe, 0xd517, 0xd530, 0xd549, 0xd562, 0xd57b, 0xd594,
	0xd5ad, 0xd5c6, 0xd5df, 0xd5f8, 0xd611, 0xd62a, 0xd643, 0xd65c,
	0xd675, 0xd68e, 0xd6a7, 0xd6c0, 0xd6d9, 0xd6f2, 0xd70b, 0xd724,
	0xd73d, 0xd756, 0xd76f, 0xd788, 0xd7a1, 0xd7ba, 0xd7d3, 0xd7ec,
	0xd805, 0xd81e, 0xd837, 0xd850, 0xd869, 0xd882, 0xd89b, 0xd8b4,
	0xd8cd, 0xd8e6, 0xd8ff, 0xd918, 0xd931, 0xd94a, 0xd963, 0xd97c,
	// Entry 6440 - 647F
	0xd995, 0xd9ae, 0xd9c7, 0xd9e0, 0xd9f9, 0xda12, 0xda2b, 0xda44,
	0xda5d, 0xda76, 0xda8f, 0xdaa8, 0xdac1, 0xdada, 0xdaf3, 0xdb0c,
	0xdb25, 0xdb3e, 0xdb57, 0xdb70, 0xdb89, 0xdba2, 0xdbbb, 0xdbd4,
	0xdbed, 0xdc06, 0xdc1f, 0xdc38, 0xdc51, 0xdc6a, 0xdc83, 0xdc9c,
	0xdcb5, 0xdcce, 0xdce7, 0xdd00, 0xdd19, 0xdd32, 0xdd4b, 0xdd64,
	0xdd7d, 0xdd96, 0xddaf, 0xddc8, 0xdde1, 0xddfa, 0xde13, 0xde2c,
	0xde45, 0xde5e, 0xde77, 0xde90, 0xdea9, 0xdec2, 0xdedb, 0xdef4,
	0xdf0d, 0xdf26, 0xdf3f, 0xdf58, 0xdf71, 0xdf8a, 0xdfa3, 0xdfbc,
	// Entry 6480 - 64BF
	0xdfd5, 0xdfee, 0xe007, 0xe020, 0xe039, 0xe052, 0xe06b, 0xe084,
	0xe09d, 0xe0b6, 0xe0cf, 0xe0e8, 0xe101, 0xe11a, 0xe133, 0xe14c,
	0xe165, 0xe17e, 0xe197, 0xe1b0, 0xe1c9, 0xe1e2, 0xe1fb, 0xe214,
	0xe22d, 0xe246, 0xe25f, 0xe278, 0xe291, 0xe2aa, 0xe2c3, 0xe2dc,
	0xe2f5, 0xe30e, 0xe327, 0xe340, 0xe359, 0xe372, 0xe38b, 0xe3a4,
	0xe3bd, 0xe3d6, 0xe3ef, 0xe408, 0xe421, 0xe43a, 0xe453, 0xe46c,
	0xe485, 0xe49e, 0xe4b7, 0xe4d0, 0xe4e9, 0xe502, 0xe51b, 0xe534,
	0xe54d, 0xe566, 0xe57f, 0xe598, 0xe5b1, 0xe5ca, 0xe5e3, 0xe5fc,
	// Entry 64C0 - 64FF
	0xe615, 0xe62e, 0xe647, 0xe660, 0xe679, 0xe692, 0xe6ab, 0xe6c4,
	0xe6dd, 0xe6f6, 0xe70f, 0xe728, 0xe741, 0xe75a, 0xe773, 0xe78c,
	0xe7a5, 0xe7be, 0xe7d7, 0xe7f0, 0xe809, 0xe822, 0xe83b, 0xe854,
	0xe86d, 0xe886, 0xe89f, 0xe8b8, 0xe8d1, 0xe8ea, 0xe903, 0xe91c,
	0xe935, 0xe94e, 0xe967, 0xe980, 0xe999, 0xe9b2, 0xe9cb, 0xe9e4,
	0xe9fd, 0xea16, 0xea2f, 0xea48, 0xea61, 0xea7a, 0xea93, 0xeaac,
	0xeac5, 0xeade, 0xeaf7, 0xeb10, 0xeb29, 0xeb42, 0xeb5b, 0xeb74,
	0xeb8d, 0xeba6, 0xebbf, 0xebd8, 0xebf1, 0xec0a, 0xec23, 0xec3c,
	// Entry 6500 - 653F
	0xec55, 0xec6e, 0xec87, 0xeca0, 0xecb9, 0xecd2, 0xeceb, 0xed04,
	0xed1d, 0xed36, 0xed4f, 0xed68, 0xed81, 0xed9a, 0xedb3, 0xedcc,
	0xede5, 0xedfe, 0xee17, 0xee30, 0xee49, 0xee62, 0xee7b, 0xee94,
	0xeead, 0xeec6, 0xeedf, 0xeef8, 0xef11, 0xef2a, 0xef43, 0xef5c,
	0xef75, 0xef8e, 0xefa7, 0xefc0, 0xefd9, 0xeff2, 0xf00b, 0xf024,
	0xf03d, 0xf056, 0xf06f, 0xf088, 0xf0a1, 0xf0ba, 0xf0d3, 0xf0ec,
	0xf105, 0xf11e, 0xf137, 0xf150, 0xf169, 0xf182, 0xf19b, 0xf1b4,
	0xf1cd, 0xf1e6, 0xf1ff, 0xf218, 0xf231, 0xf24a, 0xf263, 0xf27c,
	// Entry 6540 - 657F
	0xf295, 0xf2ae, 0xf2c7, 0xf2e0, 0xf2f9, 0xf312, 0xf32b, 0xf344,
	0xf35d, 0xf376, 0xf38f, 0xf3a8, 0xf3c1, 0xf3da, 0xf3f3, 0xf40c,
	0xf425, 0xf43e, 0xf457, 0xf470, 0xf489, 0xf4a2, 0xf4bb, 0xf4d4,
	0xf4ed, 0xf506, 0xf51f, 0xf538, 0xf551, 0xf56a, 0xf583, 0xf59c,
	0xf5b5, 0xf5ce, 0xf5e7, 0xf600, 0xf619, 0xf632, 0xf64b, 0xf664,
	0xf67d, 0xf696, 0xf6af, 0xf6c8, 0xf6e1, 0xf6fa, 0xf713, 0xf72c,
	0xf745, 0xf75e, 0xf777, 0xf790, 0xf7a9, 0xf7c2, 0xf7db, 0xf7f4,
	0xf80d, 0xf826, 0xf83f, 0xf858, 0xf871, 0xf88a, 0xf8a3, 0xf8bc,
	// Entry 6580 - 65BF
	0xf8d5, 0xf8ee, 0xf907, 0xf920, 0xf939, 0xf952, 0xf96b, 0xf984,
	0xf99d, 0xf9b6, 0xf9cf, 0xf9e8, 0xfa01, 0xfa1a, 0xfa33, 0xfa4c,
	0xfa65, 0xfa7e, 0xfa97, 0xfab0, 0xfac9, 0xfae2, 0xfafb, 0xfb14,
	0xfb2d, 0xfb46, 0xfb5f, 0xfb78, 0xfb91, 0xfbaa, 0xfbc3, 0xfbdc,
	0xfbf5, 0xfc0e, 0xfc27, 0xfc40, 0xfc59, 0xfc72, 0xfc8b, 0xfca4,
	0xfcbd, 0xfcd6, 0xfcef, 0xfd08, 0xfd21, 0xfd3a, 0xfd53, 0xfd6c,
	0xfd85, 0xfd9e, 0xfdb7, 0xfdd0, 0xfde9, 0xfe02, 0xfe1b, 0xfe34,
	0xfe4d, 0xfe66, 0xfe7f, 0xfe98, 0xfeb1, 0xfeca, 0xfee3, 0xfefc,
	// Entry 65C0 - 65FF
	0xff15, 0xff2e, 0xff47, 0xff60, 0xff79, 0xff92, 0xffab, 0xffc4,
	0xffdd, 0xfff6, 0x000f, 0x0028, 0x0041, 0x005a, 0x0073, 0x008c,
	0x00a5, 0x00be, 0x00d7, 0x00f0, 0x0109, 0x0122, 0x013b, 0x0154,
	0x016d, 0x0186, 0x019f, 0x01b8, 0x01d1, 0x01ea, 0x0203, 0x021c,
	0x0235, 0x024e, 0x0267, 0x0280, 0x0299, 0x02b2, 0x02cb, 0x02e4,
	0x02fd, 0x0316, 0x032f, 0x0348, 0x0361, 0x037a, 0x0393, 0x03ac,
	0x03c5, 0x03de, 0x03f7, 0x0410, 0x0429, 0x0442, 0x045b, 0x0474,
	0x048d, 0x04a6, 0x04bf, 0x04d8, 0x04f1, 0x050a, 0x0523, 0x053c,
	// Entry 6600 - 663F
	0x0555, 0x056e, 0x0587, 0x05a0, 0x05b9, 0x05d2, 0x05eb, 0x0604,
	0x061d, 0x0636, 0x064f, 0x0668, 0x0681, 0x069a, 0x06b3, 0x06cc,
	0x06e5, 0x06fe, 0x0717, 0x0730, 0x0749, 0x0762, 0x077b, 0x0794,
	0x07ad, 0x07c6, 0x07df, 0x07f8, 0x0811, 0x082a, 0x0843, 0x085c,
	0x0875, 0x088e, 0x08a7, 0x08c0, 0x08d9, 0x08f2, 0x090b, 0x0924,
	0x093d, 0x0956, 0x096f, 0x0988, 0x09a1, 0x09ba, 0x09d3, 0x09ec,
	0x0a05, 0x0a1e, 0x0a37, 0x0a50, 0x0a69, 0x0a82, 0x0a9b, 0x0ab4,
	0x0acd, 0x0ae6, 0x0aff, 0x0b18, 0x0b31, 0x0b4a, 0x0b63, 0x0b7c,
	// Entry 6640 - 667F
	0x0b95, 0x0bae, 0x0bc7, 0x0be0, 0x0bf9, 0x0c12, 0x0c2b, 0x0c44,
	0x0c5d, 0x0c76, 0x0c8f, 0x0ca8, 0x0cc1, 0x0cda, 0x0cf3, 0x0d0c,
	0x0d25, 0x0d3e, 0x0d57, 0x0d70, 0x0d89, 0x0da2, 0x0dbb, 0x0dd4,
	0x0ded, 0x0e06, 0x0e1f, 0x0e38, 0x0e51, 0x0e6a, 0x0e83, 0x0e9c,
	0x0eb5, 0x0ece, 0x0ee7, 0x0f00, 0x0f19, 0x0f32, 0x0f4b, 0x0f64,
	0x0f7d, 0x0f96, 0x0faf, 0x0fc8, 0x0fe1, 0x0ffa, 0x1013, 0x102c,
	0x1045, 0x105e, 0x1077, 0x1090, 0x10a9, 0x10c2, 0x10db, 0x10f4,
	0x110d, 0x1126, 0x113f, 0x1158, 0x1171, 0x118a, 0x11a3, 0x11bc,
	// Entry 6680 - 66BF
	0x11d5, 0x11ee, 0x1207, 0x1220, 0x1239, 0x1252, 0x126b, 0x1284,
	0x129d, 0x12b6, 0x12cf, 0x12e8, 0x1301, 0x131a, 0x1333, 0x134c,
	0x1365, 0x137e, 0x1397, 0x13b0, 0x13c9, 0x13e2, 0x13fb, 0x1414,
	0x142d, 0x1446, 0x145f, 0x1478, 0x1491, 0x14aa, 0x14c3, 0x14dc,
	0x14f5, 0x150e, 0x1527, 0x1540, 0x1559, 0x1572, 0x158b, 0x15a4,
	0x15bd, 0x15d6, 0x15ef, 0x1608, 0x1621, 0x163a, 0x1653, 0x166c,
	0x1685, 0x169e, 0x16b7, 0x16d0, 0x16e9, 0x1702, 0x171b, 0x1734,
	0x174d, 0x1766, 0x177f, 0x1798, 0x17b1, 0x17ca, 0x17e3, 0x17fc,
	// Entry 66C0 - 66FF
	0x1815, 0x182e, 0x1847, 0x1860, 0x1879, 0x1892, 0x18ab, 0x18c4,
	0x18dd, 0x18f6, 0x190f, 0x1928, 0x1941, 0x195a, 0x1973, 0x198c,
	0x19a5, 0x19be, 0x19d7, 0x19f0, 0x1a09, 0x1a22, 0x1a3b, 0x1a54,
	0x1a6d, 0x1a86, 0x1a9f, 0x1ab8, 0x1ad1, 0x1aea, 0x1b03, 0x1b1c,
	0x1b35, 0x1b4e, 0x1b67, 0x1b80, 0x1b99, 0x1bb2, 0x1bcb, 0x1be4,
	0x1bfd, 0x1c16, 0x1c2f, 0x1c48, 0x1c61, 0x1c7a, 0x1c93, 0x1cac,
	0x1cc5, 0x1cde, 0x1cf7, 0x1d10, 0x1d29, 0x1d42, 0x1d5b, 0x1d74,
	0x1d8d, 0x1da6, 0x1dbf, 0x1dd8, 0x1df1, 0x1e0a, 0x1e23, 0x1e3c,
	// Entry 6700 - 673F
	0x1e55, 0x1e6e, 0x1e87, 0x1ea0, 0x1eb9, 0x1ed2, 0x1eeb, 0x1f04,
	0x1f1d, 0x1f36, 0x1f4f, 0x1f68, 0x1f81, 0x1f9a, 0x1fb3, 0x1fcc,
	0x1fe5, 0x1ffe, 0x2017, 0x2030, 0x2049, 0x2062, 0x207b, 0x2094,
	0x20ad, 0x20c6, 0x20df, 0x20f8, 0x2111, 0x212a, 0x2143, 0x215c,
	0x2175, 0x218e, 0x21a7, 0x21c0, 0x21d9, 0x21f2, 0x220b, 0x2224,
	0x223d, 0x2256, 0x226f, 0x2288, 0x22a1, 0x22ba, 0x22d3, 0x22ec,
	0x2305, 0x231e, 0x2337, 0x2350, 0x2369, 0x2382, 0x239b, 0x23b4,
	0x23cd, 0x23e6, 0x23ff, 0x2418, 0x2431, 0x244a, 0x2463, 0x247c,
	// Entry 6740 - 677F
	0x2495, 0x24ae, 0x24c7, 0x24e0, 0x24f9, 0x2512, 0x252b, 0x2544,
	0x255d, 0x2576, 0x258f, 0x25a8, 0x25c1, 0x25da, 0x25f3, 0x260c,
	0x2625, 0x263e, 0x2657, 0x2670, 0x2689, 0x26a2, 0x26bb, 0x26d4,
	0x26ed, 0x2706, 0x271f, 0x2738, 0x2751, 0x276a, 0x2783, 0x279c,
	0x27b5, 0x27ce, 0x27e7, 0x2800, 0x2819, 0x2832, 0x284b, 0x2864,
	0x287d, 0x2896, 0x28af, 0x28c8, 0x28e1, 0x28fa, 0x2913, 0x292c,
	0x2945, 0x295e, 0x2977, 0x2990, 0x29a9, 0x29c2, 0x29db, 0x29f4,
	0x2a0d, 0x2a26, 0x2a3f, 0x2a58, 0x2a71, 0x2a8a, 0x2aa3, 0x2abc,
	// Entry 6780 - 67BF
	0x2ad5, 0x2aee, 0x2b07, 0x2b20, 0x2b39, 0x2b52, 0x2b6b, 0x2b84,
	0x2b9d, 0x2bb6, 0x2bcf, 0x2be8, 0x2c01, 0x2c1a, 0x2c33, 0x2c4c,
	0x2c65, 0x2c7e, 0x2c97, 0x2cb0, 0x2cc9, 0x2ce2, 0x2cfb, 0x2d14,
	0x2d2d, 0x2d46, 0x2d5f, 0x2d78, 0x2d91, 0x2daa, 0x2dc3, 0x2ddc,
	0x2df5, 0x2e0e, 0x2e27, 0x2e40, 0x2e59, 0x2e72, 0x2e8b, 0x2ea4,
	0x2ebd, 0x2ed6, 0x2eef, 0x2f08, 0x2f21, 0x2f3a, 0x2f53, 0x2f6c,
	0x2f85, 0x2f9e, 0x2fb7, 0x2fd0, 0x2fe9, 0x3002, 0x301b, 0x3034,
	0x304d, 0x3066, 0x307f, 0x3098, 0x30b1, 0x30ca, 0x30e3, 0x30fc,
	// Entry 67C0 - 67FF
	0x3115, 0x312e, 0x3147, 0x3160, 0x3179, 0x3192, 0x31ab, 0x31c4,
	0x31dd, 0x31f6, 0x320f, 0x3228, 0x3241, 0x325a, 0x3273, 0x328c,
	0x32a5, 0x32be, 0x32d7, 0x32f0, 0x3309, 0x3322, 0x333b, 0x3354,
	0x336d, 0x3386, 0x339f, 0x33b8, 0x33d1, 0x33ea, 0x3403, 0x341c,
	0x3435, 0x344e, 0x3467, 0x3480, 0x3499, 0x34b2, 0x34cb, 0x34e4,
	0x34fd, 0x3516, 0x352f, 0x3548, 0x3561, 0x357a, 0x3593, 0x35ac,
	0x35c5, 0x35de, 0x35f7, 0x3610, 0x3629, 0x3642, 0x365b, 0x3674,
	0x368d, 0x36a6, 0x36bf, 0x36d8, 0x36f1, 0x370a, 0x3723, 0x373c,
	// Entry 6800 - 683F
	0x3755, 0x376e, 0x3787, 0x37a0, 0x37b9, 0x37d2, 0x37eb, 0x3804,
	0x381d, 0x3836, 0x384f, 0x3868, 0x3881, 0x389a, 0x38b3, 0x38cc,
	0x38e5, 0x38fe, 0x3917, 0x3930, 0x3949, 0x3962, 0x397b, 0x3994,
	0x39ad, 0x39c6, 0x39df, 0x39f8, 0x3a11, 0x3a2a, 0x3a43, 0x3a5c,
	0x3a75, 0x3a8e, 0x3aa7, 0x3ac0, 0x3ad9, 0x3af2, 0x3b0b, 0x3b24,
	0x3b3d, 0x3b56, 0x3b6f, 0x3b88, 0x3ba1, 0x3bba, 0x3bd3, 0x3bec,
	0x3c05, 0x3c1e, 0x3c37, 0x3c50, 0x3c69, 0x3c82, 0x3c9b, 0x3cb4,
	0x3ccd, 0x3ce6, 0x3cff, 0x3d18, 0x3d31, 0x3d4a, 0x3d63, 0x3d7c,
	// Entry 6840 - 687F
	0x3d95, 0x3dae, 0x3dc7, 0x3de0, 0x3df9, 0x3e12, 0x3e2b, 0x3e44,
	0x3e5d, 0x3e76, 0x3e8f, 0x3ea8, 0x3ec1, 0x3eda, 0x3ef3, 0x3f0c,
	0x3f25, 0x3f3e, 0x3f57, 0x3f70, 0x3f89, 0x3fa2, 0x3fbb, 0x3fd4,
	0x3fed, 0x4006, 0x401f, 0x4038, 0x4051, 0x406a, 0x4083, 0x409c,
	0x40b5, 0x40ce, 0x40e7, 0x4100, 0x4119, 0x4132, 0x414b, 0x4164,
	0x417d, 0x4196, 0x41af, 0x41c8, 0x41e1, 0x41fa, 0x4213, 0x422c,
	0x4245, 0x425e, 0x4277, 0x4290, 0x42a9, 0x42c2, 0x42db, 0x42f4,
	0x430d, 0x4326, 0x433f, 0x4358, 0x4371, 0x438a, 0x43a3, 0x43bc,
	// Entry 6880 - 68BF
	0x43d5, 0x43ee, 0x4407, 0x4420, 0x4439, 0x4452, 0x446b, 0x4484,
	0x449d, 0x44b6, 0x44cf, 0x44e8, 0x4501, 0x451a, 0x4533, 0x454c,
	0x4565, 0x457e, 0x4597, 0x45b0, 0x45c9, 0x45e2, 0x45fb, 0x4614,
	0x462d, 0x4646, 0x465f, 0x4678, 0x4691, 0x46aa, 0x46c3, 0x46dc,
	0x46f5, 0x470e, 0x4727, 0x4740, 0x4759, 0x4772, 0x478b, 0x47a4,
	0x47bd, 0x47d6, 0x47ef, 0x4808, 0x4821, 0x483a, 0x4853, 0x486c,
	0x4885, 0x489e, 0x48b7, 0x48d0, 0x48e9, 0x4902, 0x491b, 0x4934,
	0x494d, 0x4966, 0x497f, 0x4998, 0x49b1, 0x49ca, 0x49e3, 0x49fc,
	// Entry 68C0 - 68FF
	0x4a15, 0x4a2e, 0x4a47, 0x4a60, 0x4a79, 0x4a92, 0x4aab, 0x4ac4,
	0x4add, 0x4af6, 0x4b0f, 0x4b28, 0x4b41, 0x4b5a, 0x4b73, 0x4b8c,
	0x4ba5, 0x4bbe, 0x4bd7, 0x4bf0, 0x4c09, 0x4c22, 0x4c3b, 0x4c54,
	0x4c6d, 0x4c86, 0x4c9f, 0x4cb8, 0x4cd1, 0x4cea, 0x4d03, 0x4d1c,
	0x4d35, 0x4d4e, 0x4d67, 0x4d80, 0x4d99, 0x4db2, 0x4dcb, 0x4de4,
	0x4dfd, 0x4e16, 0x4e2f, 0x4e48, 0x4e61, 0x4e7a, 0x4e93, 0x4eac,
	0x4ec5, 0x4ede, 0x4ef7, 0x4f10, 0x4f29, 0x4f42, 0x4f5b, 0x4f74,
	0x4f8d, 0x4fa6, 0x4fbf, 0x4fd8, 0x4ff1, 0x500a, 0x5023, 0x503c,
	// Entry 6900 - 693F
	0x5055, 0x506e, 0x5087, 0x50a0, 0x50b9, 0x50d2, 0x50eb, 0x5104,
	0x511d, 0x5136, 0x514f, 0x5168, 0x5181, 0x519a, 0x51b3, 0x51cc,
	0x51e5, 0x51fe, 0x5217, 0x5230, 0x5249, 0x5262, 0x527b, 0x5294,
	0x52ad, 0x52c6, 0x52df, 0x52f8, 0x5311, 0x532a, 0x5343, 0x535c,
	0x5375, 0x538e, 0x53a7, 0x53c0, 0x53d9, 0x53f2, 0x540b, 0x5424,
	0x543d, 0x5456, 0x546f, 0x5488, 0x54a1, 0x54ba, 0x54d3, 0x54ec,
	0x5505, 0x551e, 0x5537, 0x5550, 0x5569, 0x5582, 0x559b, 0x55b4,
	0x55cd, 0x55e6, 0x55ff, 0x5618, 0x5631, 0x564a, 0x5663, 0x567c,
	// Entry 6940 - 697F
	0x5695, 0x56ae, 0x56c7, 0x56e0, 0x56f9, 0x5712, 0x572b, 0x5744,
	0x575d, 0x5776, 0x578f, 0x57a8, 0x57c1, 0x57da, 0x57f3, 0x580c,
	0x5825, 0x583e, 0x5857, 0x5870, 0x5889, 0x58a2, 0x58bb, 0x58d4,
	0x58ed, 0x5906, 0x591f, 0x5938, 0x5951, 0x596a, 0x5983, 0x599c,
	0x59b5, 0x59ce, 0x59e7, 0x5a00, 0x5a19, 0x5a32, 0x5a4b, 0x5a64,
	0x5a7d, 0x5a96, 0x5aaf, 0x5ac8, 0x5ae1, 0x5afa, 0x5b13, 0x5b2c,
	0x5b45, 0x5b5e, 0x5b77, 0x5b90, 0x5ba9, 0x5bc2, 0x5bdb, 0x5bf4,
	0x5c0d, 0x5c26, 0x5c3f, 0x5c58, 0x5c71, 0x5c8a, 0x5ca3, 0x5cbc,
	// Entry 6980 - 69BF
	0x5cd5, 0x5cee, 0x5d07, 0x5d20, 0x5d39, 0x5d52, 0x5d6b, 0x5d84,
	0x5d9d, 0x5db6, 0x5dcf, 0x5de8, 0x5e01, 0x5e1a, 0x5e33, 0x5e4c,
	0x5e65, 0x5e7e, 0x5e97, 0x5eb0, 0x5ec9, 0x5ee2, 0x5efb, 0x5f14,
	0x5f2d, 0x5f46, 0x5f5f, 0x5f78, 0x5f91, 0x5faa, 0x5fc3, 0x5fdc,
	0x5ff5, 0x600e, 0x6027, 0x6040, 0x6059, 0x6072, 0x608b, 0x60a4,
	0x60bd, 0x60d6, 0x60ef, 0x6108, 0x6121, 0x613a, 0x6153, 0x616c,
	0x6185, 0x619e, 0x61b7, 0x61d0, 0x61e9, 0x6202, 0x621b, 0x6234,
	0x624d, 0x6266, 0x627f, 0x6298, 0x62b1, 0x62ca, 0x62e3, 0x62fc,
	// Entry 69C0 - 69FF
	0x6315, 0x632e, 0x6347, 0x6360, 0x6379, 0x6392, 0x63ab, 0x63c4,
	0x63dd, 0x63f6, 0x640f, 0x6428, 0x6441, 0x645a, 0x6473, 0x648c,
	0x64a5, 0x64be, 0x64d7, 0x64f0, 0x6509, 0x6522, 0x653b, 0x6554,
	0x656d, 0x6586, 0x659f, 0x65b8, 0x65d1, 0x65ea, 0x6603, 0x661c,
	0x6635, 0x664e, 0x6667, 0x6680, 0x6699, 0x66b2, 0x66cb, 0x66e4,
	0x66fd, 0x6716, 0x672f, 0x6748, 0x6761, 0x677a, 0x6793, 0x67ac,
	0x67c5, 0x67de, 0x67f7, 0x6810, 0x6829, 0x6842, 0x685b, 0x6874,
	0x688d, 0x68a6, 0x68bf, 0x68d8, 0x68f1, 0x690a, 0x6923, 0x693c,
	// Entry 6A00 - 6A3F
	0x6955, 0x696e, 0x6987, 0x69a0, 0x69b9, 0x69d2, 0x69eb, 0x6a04,
	0x6a1d, 0x6a36, 0x6a4f, 0x6a68, 0x6a81, 0x6a9a, 0x6ab3, 0x6acc,
	0x6ae5, 0x6afe, 0x6b17, 0x6b30, 0x6b49, 0x6b62, 0x6b7b, 0x6b94,
	0x6bad, 0x6bc6, 0x6bdf, 0x6bf8, 0x6c11, 0x6c2a, 0x6c43, 0x6c5c,
	0x6c75, 0x6c8e, 0x6ca7, 0x6cc0, 0x6cd9, 0x6cf2, 0x6d0b, 0x6d24,
	0x6d3d, 0x6d56, 0x6d6f, 0x6d88, 0x6da1, 0x6dba, 0x6dd3, 0x6dec,
	0x6e05, 0x6e1e, 0x6e37, 0x6e50, 0x6e69, 0x6e82, 0x6e9b, 0x6eb4,
	0x6ecd, 0x6ee6, 0x6eff, 0x6f18, 0x6f31, 0x6f4a, 0x6f63, 0x6f7c,
	// Entry 6A40 - 6A7F
	0x6f95, 0x6fae, 0x6fc7, 0x6fe0, 0x6ff9, 0x7012, 0x702b, 0x7044,
	0x705d, 0x7076, 0x708f, 0x70a8, 0x70c1, 0x70da, 0x70f3, 0x710c,
	0x7125, 0x713e, 0x7157, 0x7170, 0x7189, 0x71a2, 0x71bb, 0x71d4,
	0x71ed, 0x7206, 0x721f, 0x7238, 0x7251, 0x726a, 0x7283, 0x729c,
	0x72b5, 0x72ce, 0x72e7, 0x7300, 0x7319, 0x7332, 0x734b, 0x7364,
	0x737d, 0x7396, 0x73af, 0x73c8, 0x73e1, 0x73fa, 0x7413, 0x742c,
	0x7445, 0x745e, 0x7477, 0x7490, 0x74a9, 0x74c2, 0x74db, 0x74f4,
	0x750d, 0x7526, 0x753f, 0x7558, 0x7571, 0x758a, 0x75a3, 0x75bc,
	// Entry 6A80 - 6ABF
	0x75d5, 0x75ee, 0x7607, 0x7620, 0x7639, 0x7652, 0x766b, 0x7684,
	0x769d, 0x76b6, 0x76cf, 0x76e8, 0x7701, 0x771a, 0x7733, 0x774c,
	0x7765, 0x777e, 0x7797, 0x77b0, 0x77c9, 0x77e2, 0x77fb, 0x7814,
	0x782d, 0x7846, 0x785f, 0x7878, 0x7891, 0x78aa, 0x78c3, 0x78dc,
	0x78f5, 0x790e, 0x7927, 0x7940, 0x7959, 0x7972, 0x798b, 0x79a4,
	0x79bd, 0x79d6, 0x79ef, 0x7a08, 0x7a21, 0x7a3a, 0x7a53, 0x7a6c,
	0x7a85, 0x7a9e, 0x7ab7, 0x7ad0, 0x7ae9, 0x7b02, 0x7b1b, 0x7b34,
	0x7b4d, 0x7b66, 0x7b7f, 0x7b98, 0x7bb1, 0x7bca, 0x7be3, 0x7bfc,
	// Entry 6AC0 - 6AFF
	0x7c15, 0x7c2e, 0x7c47, 0x7c60, 0x7c79, 0x7c92, 0x7cab, 0x7cc4,
	0x7cdd, 0x7cf6, 0x7d0f, 0x7d28, 0x7d41, 0x7d5a, 0x7d73, 0x7d8c,
	0x7da5, 0x7dbe, 0x7dd7, 0x7df0, 0x7e09, 0x7e22, 0x7e3b, 0x7e54,
	0x7e6d, 0x7e86, 0x7e9f, 0x7eb8, 0x7ed1, 0x7eea, 0x7f03, 0x7f1c,
	0x7f35, 0x7f4e, 0x7f67, 0x7f80, 0x7f99, 0x7fb2, 0x7fcb, 0x7fe4,
	0x7ffd, 0x8016, 0x802f, 0x8048, 0x8061, 0x807a, 0x8093, 0x80ac,
	0x80c5, 0x80de, 0x80f7, 0x8110, 0x8129, 0x8142, 0x815b, 0x8174,
	0x818d, 0x81a6, 0x81bf, 0x81d8, 0x81f1, 0x820a, 0x8223, 0x823c,
	// Entry 6B00 - 6B3F
	0x8255, 0x826e, 0x8287, 0x82a0, 0x82b9, 0x82d2, 0x82eb, 0x8304,
	0x831d, 0x8336, 0x834f, 0x8368, 0x8381, 0x839a, 0x83b3, 0x83cc,
	0x83e5, 0x83fe, 0x8417, 0x8430, 0x8449, 0x8462, 0x847b, 0x8494,
	0x84ad, 0x84c6, 0x84df, 0x84f8, 0x8511, 0x852a, 0x8543, 0x855c,
	0x8575, 0x858e, 0x85a7, 0x85c0, 0x85d9, 0x85f2, 0x860b, 0x8624,
	0x863d, 0x8656, 0x866f, 0x8688, 0x86a1, 0x86ba, 0x86d3, 0x86ec,
	0x8705, 0x871e, 0x8737, 0x8750, 0x8769, 0x8782, 0x879b, 0x87b4,
	0x87cd, 0x87e6, 0x87ff, 0x8818, 0x8831, 0x884a, 0x8863, 0x887c,
	// Entry 6B40 - 6B7F
	0x8895, 0x88ae, 0x88c7, 0x88e0, 0x88f9, 0x8912, 0x892b, 0x8944,
	0x895d, 0x8976, 0x898f, 0x89a8, 0x89c1, 0x89da, 0x89f3, 0x8a0c,
	0x8a25, 0x8a3e, 0x8a57, 0x8a70, 0x8a89, 0x8aa2, 0x8abb, 0x8ad4,
	0x8aed, 0x8b06, 0x8b1f, 0x8b38, 0x8b51, 0x8b6a, 0x8b83, 0x8b9c,
	0x8bb5, 0x8bce, 0x8be7, 0x8c00, 0x8c19, 0x8c32, 0x8c4b, 0x8c64,
	0x8c7d, 0x8c96, 0x8caf, 0x8cc8, 0x8ce1, 0x8cfa, 0x8d13, 0x8d2c,
	0x8d45, 0x8d5e, 0x8d77, 0x8d90, 0x8da9, 0x8dc2, 0x8ddb, 0x8df4,
	0x8e0d, 0x8e26, 0x8e3f, 0x8e58, 0x8e71, 0x8e8a, 0x8ea3, 0x8ebc,
	// Entry 6B80 - 6BBF
	0x8ed5, 0x8eee, 0x8f07, 0x8f20, 0x8f39, 0x8f52, 0x8f6b, 0x8f84,
	0x8f9d, 0x8fb6, 0x8fcf, 0x8fe8, 0x9001, 0x901a, 0x9033, 0x904c,
	0x9065, 0x907e, 0x9097, 0x90b0, 0x90c9, 0x90e2, 0x90fb, 0x9114,
	0x912d, 0x9146, 0x915f, 0x9178, 0x9191, 0x91aa, 0x91c3, 0x91dc,
	0x91f5, 0x920e, 0x9227, 0x9240, 0x9259, 0x9272, 0x928b, 0x92a4,
	0x92bd, 0x92d6, 0x92ef, 0x9308, 0x9321, 0x933a, 0x9353, 0x936c,
	0x9385, 0x939e, 0x93b7, 0x93d0, 0x93e9, 0x9402, 0x941b, 0x9434,
	0x944d, 0x9466, 0x947f, 0x9498, 0x94b1, 0x94ca, 0x94e3, 0x94fc,
	// Entry 6BC0 - 6BFF
	0x9515, 0x952e, 0x9547, 0x9560, 0x9579, 0x9592, 0x95ab, 0x95c4,
	0x95dd, 0x95f6, 0x960f, 0x9628, 0x9641, 0x965a, 0x9673, 0x968c,
	0x96a5, 0x96be, 0x96d7, 0x96f0, 0x9709, 0x9722, 0x973b, 0x9754,
	0x976d, 0x9786, 0x979f, 0x97b8, 0x97d1, 0x97ea, 0x9803, 0x981c,
	0x9835, 0x984e, 0x9867, 0x9880, 0x9899, 0x98b2, 0x98cb, 0x98e4,
	0x98fd, 0x9916, 0x992f, 0x9948, 0x9961, 0x997a, 0x9993, 0x99ac,
	0x99c5, 0x99de, 0x99f7, 0x9a10, 0x9a29, 0x9a42, 0x9a5b, 0x9a74,
	0x9a8d, 0x9aa6, 0x9abf, 0x9ad8, 0x9af1, 0x9b0a, 0x9b23, 0x9b3c,
	// Entry 6C00 - 6C3F
	0x9b55, 0x9b6e, 0x9b87, 0x9ba0, 0x9bb9, 0x9bd2, 0x9beb, 0x9c04,
	0x9c1d, 0x9c36, 0x9c4f, 0x9c68, 0x9c81, 0x9c9a, 0x9cb3, 0x9ccc,
	0x9ce5, 0x9cfe, 0x9d17, 0x9d30, 0x9d49, 0x9d62, 0x9d7b, 0x9d94,
	0x9dad, 0x9dc6, 0x9ddf, 0x9df8, 0x9e11, 0x9e2a, 0x9e43, 0x9e5c,
	0x9e75, 0x9e8e, 0x9ea7, 0x9ec0, 0x9ed9, 0x9ef2, 0x9f0b, 0x9f24,
	0x9f3d, 0x9f56, 0x9f6f, 0x9f88, 0x9fa1, 0x9fba, 0x9fd3, 0x9fec,
	0xa005, 0xa01e, 0xa037, 0xa050, 0xa069, 0xa082, 0xa09b, 0xa0b4,
	0xa0cd, 0xa0e6, 0xa0ff, 0xa118, 0xa131, 0xa14a, 0xa163, 0xa17c,
	// Entry 6C40 - 6C7F
	0xa195, 0xa1ae, 0xa1c7, 0xa1e0, 0xa1f9, 0xa212, 0xa22b, 0xa244,
	0xa25d, 0xa276, 0xa28f, 0xa2a8, 0xa2c1, 0xa2da, 0xa2f3, 0xa30c,
	0xa325, 0xa33e, 0xa357, 0xa370, 0xa389, 0xa3a2, 0xa3bb, 0xa3d4,
	0xa3ed, 0xa406, 0xa41f, 0xa438, 0xa451, 0xa46a, 0xa483, 0xa49c,
	0xa4b5, 0xa4ce, 0xa4e7, 0xa500, 0xa519, 0xa532, 0xa54b, 0xa564,
	0xa57d, 0xa596, 0xa5af, 0xa5c8, 0xa5e1, 0xa5fa, 0xa613, 0xa62c,
	0xa645, 0xa65e, 0xa677, 0xa690, 0xa6a9, 0xa6c2, 0xa6db, 0xa6f4,
	0xa70d, 0xa726, 0xa73f, 0xa758, 0xa771, 0xa78a, 0xa7a3, 0xa7bc,
	// Entry 6C80 - 6CBF
	0xa7d5, 0xa7ee, 0xa807, 0xa820, 0xa839, 0xa852, 0xa86b, 0xa884,
	0xa89d, 0xa8b6, 0xa8cf, 0xa8e8, 0xa901, 0xa91a, 0xa933, 0xa94c,
	0xa965, 0xa97e, 0xa997, 0xa9b0, 0xa9c9, 0xa9e2, 0xa9fb, 0xaa14,
	0xaa2d, 0xaa46, 0xaa5f, 0xaa78, 0xaa91, 0xaaaa, 0xaac3, 0xaadc,
	0xaaf5, 0xab0e, 0xab27, 0xab40, 0xab59, 0xab72, 0xab8b, 0xaba4,
	0xabbd, 0xabd6, 0xabef, 0xac08, 0xac21, 0xac3a, 0xac53, 0xac6c,
	0xac85, 0xac9e, 0xacb7, 0xacd0, 0xace9, 0xad02, 0xad1b, 0xad34,
	0xad4d, 0xad66, 0xad7f, 0xad98, 0xadb1, 0xadca, 0xade3, 0xadfc,
	// Entry 6CC0 - 6CFF
	0xae15, 0xae2e, 0xae47, 0xae60, 0xae79, 0xae92, 0xaeab, 0xaec4,
	0xaedd, 0xaef6, 0xaf0f, 0xaf28, 0xaf41, 0xaf5a, 0xaf73, 0xaf8c,
	0xafa5, 0xafbe, 0xafd7, 0xaff0, 0xb009, 0xb022, 0xb03b, 0xb054,
	0xb06d, 0xb086, 0xb09f, 0xb0b8, 0xb0d1, 0xb0ea, 0xb103, 0xb11c,
	0xb135, 0xb14e, 0xb167, 0xb180, 0xb199, 0xb1b2, 0xb1cb, 0xb1e4,
	0xb1fd, 0xb216, 0xb22f, 0xb248, 0xb261, 0xb27a, 0xb293, 0xb2ac,
	0xb2c5, 0xb2de, 0xb2f7, 0xb310, 0xb329, 0xb342, 0xb35b, 0xb374,
	0xb38d, 0xb3a6, 0xb3bf, 0xb3d8, 0xb3f1, 0xb40a, 0xb423, 0xb43c,
	// Entry 6D00 - 6D3F
	0xb455, 0xb46e, 0xb487, 0xb4a0, 0xb4b9, 0xb4d2, 0xb4eb, 0xb504,
	0xb51d, 0xb536, 0xb54f, 0xb568, 0xb581, 0xb59a, 0xb5b3, 0xb5cc,
	0xb5e5, 0xb5fe, 0xb617, 0xb630, 0xb649, 0xb662, 0xb67b, 0xb694,
	0xb6ad, 0xb6c6, 0xb6df, 0xb6f8, 0xb711, 0xb72a, 0xb743, 0xb75c,
	0xb775, 0xb78e, 0xb7a7, 0xb7c0, 0xb7d9, 0xb7f2, 0xb80b, 0xb824,
	0xb83d, 0xb856, 0xb86f, 0xb888, 0xb8a1, 0xb8ba, 0xb8d3, 0xb8ec,
	0xb905, 0xb91e, 0xb937, 0xb950, 0xb969, 0xb982, 0xb99b, 0xb9b4,
	0xb9cd, 0xb9e6, 0xb9ff, 0xba18, 0xba31, 0xba4a, 0xba63, 0xba7c,
	// Entry 6D40 - 6D7F
	0xba95, 0xbaae, 0xbac7, 0xbae0, 0xbaf9, 0xbb12, 0xbb2b, 0xbb44,
	0xbb5d, 0xbb76, 0xbb8f, 0xbba8, 0xbbc1, 0xbbda, 0xbbf3, 0xbc0c,
	0xbc25, 0xbc3e, 0xbc57, 0xbc70, 0xbc89, 0xbca2, 0xbcbb, 0xbcd4,
	0xbced, 0xbd06, 0xbd1f, 0xbd38, 0xbd51, 0xbd6a, 0xbd83, 0xbd9c,
	0xbdb5, 0xbdce, 0xbde7, 0xbe00, 0xbe19, 0xbe32, 0xbe4b, 0xbe64,
	0xbe7d, 0xbe96, 0xbeaf, 0xbec8, 0xbee1, 0xbefa, 0xbf13, 0xbf2c,
	0xbf45, 0xbf5e, 0xbf77, 0xbf90, 0xbfa9, 0xbfc2, 0xbfdb, 0xbff4,
	0xc00d, 0xc026, 0xc03f, 0xc058, 0xc071, 0xc08a, 0xc0a3, 0xc0bc,
	// Entry 6D80 - 6DBF
	0xc0d5, 0xc0ee, 0xc107, 0xc120, 0xc139, 0xc152, 0xc16b, 0xc184,
	0xc19d, 0xc1b6, 0xc1cf, 0xc1e8, 0xc201, 0xc21a, 0xc233, 0xc24c,
	0xc265, 0xc27e, 0xc297, 0xc2b0, 0xc2c9, 0xc2e2, 0xc2fb, 0xc314,
	0xc32d, 0xc346, 0xc35f, 0xc378, 0xc391, 0xc3aa, 0xc3c3, 0xc3dc,
	0xc3f5, 0xc40e, 0xc427, 0xc440, 0xc459, 0xc472, 0xc48b, 0xc4a4,
	0xc4bd, 0xc4d6, 0xc4ef, 0xc508, 0xc521, 0xc53a, 0xc553, 0xc56c,
	0xc585, 0xc59e, 0xc5b7, 0xc5d0, 0xc5e9, 0xc602, 0xc61b, 0xc634,
	0xc64d, 0xc666, 0xc67f, 0xc698, 0xc6b1, 0xc6ca, 0xc6e3, 0xc6fc,
	// Entry 6DC0 - 6DFF
	0xc715, 0xc72e, 0xc747, 0xc760, 0xc779, 0xc792, 0xc7ab, 0xc7c4,
	0xc7dd, 0xc7f6, 0xc80f, 0xc828, 0xc841, 0xc85a, 0xc873, 0xc88c,
	0xc8a5, 0xc8be, 0xc8d7, 0xc8f0, 0xc909, 0xc922, 0xc93b, 0xc954,
	0xc96d, 0xc986, 0xc99f, 0xc9b8, 0xc9d1, 0xc9ea, 0xca03, 0xca1c,
	0xca35, 0xca4e, 0xca67, 0xca80, 0xca99, 0xcab2, 0xcacb, 0xcae4,
	0xcafd, 0xcb16, 0xcb2f, 0xcb48, 0xcb61, 0xcb7a, 0xcb93, 0xcbac,
	0xcbc5, 0xcbde, 0xcbf7, 0xcc10, 0xcc29, 0xcc42, 0xcc5b, 0xcc74,
	0xcc8d, 0xcca6, 0xccbf, 0xccd8, 0xccf1, 0xcd0a, 0xcd23, 0xcd3c,
	// Entry 6E00 - 6E3F
	0xcd55, 0xcd6e, 0xcd87, 0xcda0, 0xcdb9, 0xcdd2, 0xcdeb, 0xce04,
	0xce1d, 0xce36, 0xce4f, 0xce68, 0xce81, 0xce9a, 0xceb3, 0xcecc,
	0xcee5, 0xcefe, 0xcf17, 0xcf30, 0xcf49, 0xcf62, 0xcf7b, 0xcf94,
	0xcfad, 0xcfc6, 0xcfdf, 0xcff8, 0xd011, 0xd02a, 0xd043, 0xd05c,
	0xd075, 0xd08e, 0xd0a7, 0xd0c0, 0xd0d9, 0xd0f2, 0xd10b, 0xd124,
	0xd13d, 0xd156, 0xd16f, 0xd188, 0xd1a1, 0xd1ba, 0xd1d3, 0xd1ec,
	0xd205, 0xd21e, 0xd237, 0xd250, 0xd269, 0xd282, 0xd29b, 0xd2b4,
	0xd2cd, 0xd2e6, 0xd2ff, 0xd318, 0xd331, 0xd34a, 0xd363, 0xd37c,
	// Entry 6E40 - 6E7F
	0xd395, 0xd3ae, 0xd3c7, 0xd3e0, 0xd3f9, 0xd412, 0xd42b, 0xd444,
	0xd45d, 0xd476, 0xd48f, 0xd4a8, 0xd4c1, 0xd4da, 0xd4f3, 0xd50c,
	0xd525, 0xd53e, 0xd557, 0xd570, 0xd589, 0xd5a2, 0xd5bb, 0xd5d4,
	0xd5ed, 0xd606, 0xd61f, 0xd638, 0xd651, 0xd66a, 0xd683, 0xd69c,
	0xd6b5, 0xd6ce, 0xd6e7, 0xd700, 0xd719, 0xd732, 0xd74b, 0xd764,
	0xd77d, 0xd796, 0xd7af, 0xd7c8, 0xd7e1, 0xd7fa, 0xd813, 0xd82c,
	0xd845, 0xd85e, 0xd877, 0xd890, 0xd8a9, 0xd8c2, 0xd8db, 0xd8f4,
	0xd90d, 0xd926, 0xd93f, 0xd958, 0xd971, 0xd98a, 0xd9a3, 0xd9bc,
	// Entry 6E80 - 6EBF
	0xd9d5, 0xd9ee, 0xda07, 0xda20, 0xda39, 0xda52, 0xda6b, 0xda84,
	0xda9d, 0xdab6, 0xdacf, 0xdae8, 0xdb01, 0xdb1a, 0xdb33, 0xdb4c,
	0xdb65, 0xdb7e, 0xdb97, 0xdbb0, 0xdbc9, 0xdbe2, 0xdbfb, 0xdc14,
	0xdc2d, 0xdc46, 0xdc5f, 0xdc78, 0xdc91, 0xdcaa, 0xdcc3, 0xdcdc,
	0xdcf5, 0xdd0e, 0xdd27, 0xdd40, 0xdd59, 0xdd72, 0xdd8b, 0xdda4,
	0xddbd, 0xddd6, 0xddef, 0xde08, 0xde21, 0xde3a, 0xde53, 0xde6c,
	0xde85, 0xde9e, 0xdeb7, 0xded0, 0xdee9, 0xdf02, 0xdf1b, 0xdf34,
	0xdf4d, 0xdf66, 0xdf7f, 0xdf98, 0xdfb1, 0xdfca, 0xdfe3, 0xdffc,
	// Entry 6EC0 - 6EFF
	0xe015, 0xe02e, 0xe047, 0xe060, 0xe079, 0xe092, 0xe0ab, 0xe0c4,
	0xe0dd, 0xe0f6, 0xe10f, 0xe128, 0xe141, 0xe15a, 0xe173, 0xe18c,
	0xe1a5, 0xe1be, 0xe1d7, 0xe1f0, 0xe209, 0xe222, 0xe23b, 0xe254,
	0xe26d, 0xe286, 0xe29f, 0xe2b8, 0xe2d1, 0xe2ea, 0xe303, 0xe31c,
	0xe335, 0xe34e, 0xe367, 0xe380, 0xe399, 0xe3b2, 0xe3cb, 0xe3e4,
	0xe3fd, 0xe416, 0xe42f, 0xe448, 0xe461, 0xe47a, 0xe493, 0xe4ac,
	0xe4c5, 0xe4de, 0xe4f7, 0xe510, 0xe529, 0xe542, 0xe55b, 0xe574,
	0xe58d, 0xe5a6, 0xe5bf, 0xe5d8, 0xe5f1, 0xe60a, 0xe623, 0xe63c,
	// Entry 6F00 - 6F3F
	0xe655, 0xe66e, 0xe687, 0xe6a0, 0xe6b9, 0xe6d2, 0xe6eb, 0xe704,
	0xe71d, 0xe736, 0xe74f, 0xe768, 0xe781, 0xe79a, 0xe7b3, 0xe7cc,
	0xe7e5, 0xe7fe, 0xe817, 0xe830, 0xe849, 0xe862, 0xe87b, 0xe894,
	0xe8ad, 0xe8c6, 0xe8df, 0xe8f8, 0xe911, 0xe92a, 0xe943, 0xe95c,
	0xe975, 0xe98e, 0xe9a7, 0xe9c0, 0xe9d9, 0xe9f2, 0xea0b, 0xea24,
	0xea3d, 0xea56, 0xea6f, 0xea88, 0xeaa1, 0xeaba, 0xead3, 0xeaec,
	0xeb05, 0xeb1e, 0xeb37, 0xeb50, 0xeb69, 0xeb82, 0xeb9b, 0xebb4,
	0xebcd, 0xebe6, 0xebff, 0xec18, 0xec31, 0xec4a, 0xec63, 0xec7c,
	// Entry 6F40 - 6F7F
	0xec95, 0xecae, 0xecc7, 0xece0, 0xecf9, 0xed12, 0xed2b, 0xed44,
	0xed5d, 0xed76, 0xed8f, 0xeda8, 0xedc1, 0xedda, 0xedf3, 0xee0c,
	0xee25, 0xee3e, 0xee57, 0xee70, 0xee89, 0xeea2, 0xeebb, 0xeed4,
	0xeeed, 0xef06, 0xef1f, 0xef38, 0xef51, 0xef6a, 0xef83, 0xef9c,
	0xefb5, 0xefce, 0xefe7, 0xf000, 0xf019, 0xf032, 0xf04b, 0xf064,
	0xf07d, 0xf096, 0xf0af, 0xf0c8, 0xf0e1, 0xf0fa, 0xf113, 0xf12c,
	0xf145, 0xf15e, 0xf177, 0xf190, 0xf1a9, 0xf1c2, 0xf1db, 0xf1f4,
	0xf20d, 0xf226, 0xf23f, 0xf258, 0xf271, 0xf28a, 0xf2a3, 0xf2bc,
	// Entry 6F80 - 6FBF
	0xf2d5, 0xf2ee, 0xf307, 0xf320, 0xf339, 0xf352, 0xf36b, 0xf384,
	0xf39d, 0xf3b6, 0xf3cf, 0xf3e8, 0xf401, 0xf41a, 0xf433, 0xf44c,
	0xf465, 0xf47e, 0xf497, 0xf4b0, 0xf4c9, 0xf4e2, 0xf4fb, 0xf514,
	0xf52e, 0xf547, 0xf560, 0xf579, 0xf592, 0xf5ab, 0xf5c4, 0xf5dd,
	0xf5f6, 0xf60f, 0xf628, 0xf641, 0xf65a, 0xf673, 0xf68c, 0xf6a5,
	0xf6be, 0xf6d8, 0xf6f1, 0xf70a, 0xf723, 0xf73c, 0xf755, 0xf76e,
	0xf787, 0xf7a0, 0xf7b9, 0xf7d2, 0xf7eb, 0xf804, 0xf81d, 0xf837,
	0xf850, 0xf869, 0xf883, 0xf89c, 0xf8b5, 0xf8ce, 0xf8e7, 0xf901,
	// Entry 6FC0 - 6FFF
	0xf91a, 0xf934, 0xf94e, 0xf967, 0xf980, 0xf999, 0xf9b2, 0xf9cb,
	0xf9e4, 0xf9fd, 0xfa16, 0xfa2f, 0xfa48, 0xfa61, 0xfa7a, 0xfa93,
	0xfaac, 0xfac5, 0xfade, 0xfaf7, 0xfb10, 0xfb29, 0xfb42, 0xfb5c,
	0xfb76, 0xfb90, 0xfba9, 0xfbc2, 0xfbdb, 0xfbf4, 0xfc0d, 0xfc26,
	0xfc3f, 0xfc58, 0xfc71, 0xfc8a, 0xfca3, 0xfcbc, 0xfcd5, 0xfcee,
	0xfd07, 0xfd20, 0xfd39, 0xfd52, 0xfd6b, 0xfd84, 0xfd9d, 0xfdb6,
	0xfdcf, 0xfde8, 0xfe01, 0xfe1a, 0xfe33, 0xfe4c, 0xfe65, 0xfe7e,
	0xfe97, 0xfeb1, 0xfeca, 0xfee4, 0xfefd, 0xff16, 0xff30, 0xff49,
	// Entry 7000 - 703F
	0xff63, 0xff7c, 0xff96, 0xffaf, 0xffc8, 0xffe2, 0xfffc, 0x0016,
	0x002f, 0x0049, 0x0063, 0x007c, 0x0095, 0x00af, 0x00c9, 0x00e3,
	0x00fc, 0x0115, 0x012e, 0x0148, 0x0162, 0x017b, 0x0194, 0x01ad,
	0x01c6, 0x01df, 0x01f9, 0x0212, 0x022b, 0x0244, 0x025d, 0x0276,
	0x028f, 0x02a8, 0x02c1, 0x02da, 0x02f3, 0x030d, 0x0326, 0x033f,
	0x0358, 0x0371, 0x038a, 0x03a3, 0x03bc, 0x03d5, 0x03ee, 0x0407,
	0x0421, 0x043a, 0x0453, 0x046c, 0x0485, 0x049e, 0x04b7, 0x04d0,
	0x04e9, 0x0502, 0x051b, 0x0534, 0x054d, 0x0566, 0x057f, 0x0598,
	// Entry 7040 - 707F
	0x05b1, 0x05ca, 0x05e3, 0x05fc, 0x0615, 0x062e, 0x0647, 0x0660,
	0x0679, 0x0692, 0x06ab, 0x06c4, 0x06dd, 0x06f6, 0x070f, 0x0728,
	0x0741, 0x075a, 0x0773, 0x078c, 0x07a5, 0x07be, 0x07d7, 0x07f0,
	0x0809, 0x0822, 0x083b, 0x0854, 0x086d, 0x0886, 0x089f, 0x08b8,
	0x08d1, 0x08ea, 0x0903, 0x091c, 0x0935, 0x094e, 0x0967, 0x0980,
	0x0999, 0x09b2, 0x09cb, 0x09e4, 0x09fd, 0x0a16, 0x0a2f, 0x0a48,
	0x0a61, 0x0a7a, 0x0a93, 0x0aac, 0x0ac6, 0x0ae0, 0x0af9, 0x0b12,
	0x0b2b, 0x0b44, 0x0b5d, 0x0b77, 0x0b90, 0x0ba9, 0x0bc3, 0x0bdc,
	// Entry 7080 - 70BF
	0x0bf5, 0x0c0e, 0x0c27, 0x0c40, 0x0c59, 0x0c73, 0x0c8c, 0x0ca6,
	0x0cbf, 0x0cd8, 0x0cf1, 0x0d0a, 0x0d23, 0x0d3c, 0x0d55, 0x0d6e,
	0x0d87, 0x0da0, 0x0db9, 0x0dd3, 0x0dec, 0x0e05, 0x0e1e, 0x0e37,
	0x0e50, 0x0e69, 0x0e82, 0x0e9b, 0x0eb4, 0x0ecd, 0x0ee6, 0x0eff,
	0x0f18, 0x0f31, 0x0f4a, 0x0f63, 0x0f7c, 0x0f95, 0x0fae, 0x0fc7,
	0x0fe0, 0x0ff9, 0x1012, 0x102b, 0x1044, 0x105d, 0x1076, 0x108f,
	0x10a8, 0x10c1, 0x10da, 0x10f3, 0x110c, 0x1125, 0x113e, 0x1157,
	0x1170, 0x1189, 0x11a2, 0x11bb, 0x11d5, 0x11ee, 0x1207, 0x1220,
	// Entry 70C0 - 70FF
	0x1239, 0x1252, 0x126b, 0x1284, 0x129d, 0x12b6, 0x12cf, 0x12e8,
	0x1301, 0x131a, 0x1333, 0x134c, 0x1365, 0x137e, 0x1397, 0x13b0,
	0x13c9, 0x13e2, 0x13fb, 0x1415, 0x142e, 0x1447, 0x1460, 0x1479,
	0x1492, 0x14ac, 0x14c5, 0x14de, 0x14f7, 0x1510, 0x1529, 0x1543,
	0x155c, 0x1575, 0x158e, 0x15a7, 0x15c0, 0x15d9, 0x15f2, 0x160b,
	0x1624, 0x163d, 0x1657, 0x1670, 0x1689, 0x16a2, 0x16bb, 0x16d4,
	0x16ed, 0x1706, 0x171f, 0x1738, 0x1751, 0x176a, 0x1783, 0x179c,
	0x17b5, 0x17ce, 0x17e7, 0x1800, 0x1819, 0x1832, 0x184b, 0x1865,
	// Entry 7100 - 713F
	0x187e, 0x1897, 0x18b1, 0x18cb, 0x18e5, 0x18fe, 0x1917, 0x1930,
	0x1949, 0x1963, 0x197d, 0x1997, 0x19b0, 0x19c9, 0x19e2, 0x19fb,
	0x1a14, 0x1a2d, 0x1a46, 0x1a5f, 0x1a78, 0x1a91, 0x1aaa, 0x1ac3,
	0x1adc, 0x1af5, 0x1b0e, 0x1b27, 0x1b40, 0x1b59, 0x1b72, 0x1b8b,
	0x1ba4, 0x1bbd, 0x1bd6, 0x1bf0, 0x1c09, 0x1c22, 0x1c3b, 0x1c54,
	0x1c6d, 0x1c87, 0x1ca0, 0x1cb9, 0x1cd2, 0x1ceb, 0x1d05, 0x1d1e,
	0x1d37, 0x1d50, 0x1d6a, 0x1d83, 0x1d9c, 0x1db5, 0x1dce, 0x1de7,
	0x1e00, 0x1e19, 0x1e32, 0x1e4b, 0x1e64, 0x1e7e, 0x1e97, 0x1eb9,
	// Entry 7140 - 717F
	0x1ed3, 0x1eec, 0x1f05, 0x1f1e, 0x1f38, 0x1f51, 0x1f6a, 0x1f83,
	0x1f9c, 0x1fb5, 0x1fce, 0x1fed, 0x2006, 0x201f, 0x2038, 0x2051,
	0x206a, 0x2083, 0x209c, 0x20b5, 0x20ce, 0x20e7, 0x2100, 0x2119,
	0x2132, 0x214b, 0x2164, 0x217d, 0x21aa, 0x21d6, 0x21ef, 0x2208,
	0x2221, 0x223a, 0x2253, 0x226c, 0x2285, 0x229e, 0x22b7, 0x22d0,
	0x22e9, 0x2302, 0x231b, 0x2334, 0x234d, 0x2366, 0x237f, 0x2398,
	0x23b1, 0x23ca, 0x23e3, 0x23fc, 0x2415, 0x242e, 0x2447, 0x2460,
	0x2479, 0x2492, 0x24ab, 0x24c4, 0x24dd, 0x24f6, 0x250f, 0x2528,
	// Entry 7180 - 71BF
	0x2541, 0x255a, 0x2573, 0x258c, 0x25a5, 0x25be, 0x25d8, 0x25f1,
	0x260a, 0x2623, 0x263c, 0x2655, 0x266e, 0x2687, 0x26a1, 0x26ba,
	0x26d3, 0x26ec, 0x2705, 0x271e, 0x2737, 0x2750, 0x2769, 0x2782,
	0x279b, 0x27b4, 0x27cd, 0x27e6, 0x27ff, 0x2818, 0x2831, 0x284a,
	0x2863, 0x287c, 0x2895, 0x28ae, 0x28c7, 0x28e0, 0x28f9, 0x2912,
	0x292b, 0x2944, 0x295d, 0x2976, 0x298f, 0x29a8, 0x29c1, 0x29da,
	0x29f3, 0x2a0c, 0x2a25, 0x2a3e, 0x2a57, 0x2a70, 0x2a89, 0x2aa2,
	0x2abb, 0x2ad4, 0x2aed, 0x2b06, 0x2b1f, 0x2b38, 0x2b51, 0x2b6a,
	// Entry 71C0 - 71FF
	0x2b83, 0x2b9c, 0x2bb5, 0x2bce, 0x2be7, 0x2c00, 0x2c19, 0x2c32,
	0x2c4b, 0x2c64, 0x2c7d, 0x2c96, 0x2caf, 0x2cc8, 0x2ce1, 0x2cfa,
	0x2d13, 0x2d2c, 0x2d45, 0x2d5e, 0x2d77, 0x2d8c, 0x2da2, 0x2db9,
	0x2dcf, 0x2de6, 0x2dfd, 0x2e13, 0x2e2a, 0x2e40, 0x2e57, 0x2e6d,
	0x2e84, 0x2e9c, 0x2eb3, 0x2ecb, 0x2ee1, 0x2ef7, 0x2f0e, 0x2f24,
	0x2f3b, 0x2f51, 0x2f67, 0x2f7e, 0x2f94, 0x2fab, 0x2fc1, 0x2fd7,
	0x2fed, 0x3003, 0x3019, 0x3033, 0x304c, 0x3066, 0x307f, 0x3099,
	0x30b2, 0x30cc, 0x30e6, 0x30ff, 0x3119, 0x3133, 0x3151, 0x3176,
	// Entry 7200 - 723F
	0x319b, 0x31c0, 0x31da, 0x31ff, 0x3219, 0x3230, 0x3246, 0x325c,
	0x3274, 0x328b, 0x32a2, 0x32b8, 0x32d0, 0x32e8, 0x32ff, 0x331e,
	0x333c, 0x3365, 0x338b, 0x33a8, 0x33c7, 0x33e5, 0x3402, 0x3424,
	0x344f, 0x3477, 0x3496, 0x34b4, 0x34cf, 0x34ec, 0x3508, 0x3527,
	0x3543, 0x355f, 0x357e, 0x3599, 0x35b1, 0x35d0, 0x35ea, 0x3606,
	0x3624, 0x3640, 0x365b, 0x3679, 0x3695, 0x36b6, 0x36d4, 0x36f2,
	0x3713, 0x3731, 0x374a, 0x3765, 0x3786, 0x37a2, 0x37bb, 0x37db,
	0x37fc, 0x3814, 0x3831, 0x384a, 0x3862, 0x387c, 0x3896, 0x38b1,
	// Entry 7240 - 727F
	0x38cf, 0x38ea, 0x3902, 0x3923, 0x393c, 0x3958, 0x3971, 0x398c,
	0x39a5, 0x39bd, 0x39d6, 0x39ee, 0x3a0c, 0x3a27, 0x3a40, 0x3a63,
	0x3a87, 0x3aa2, 0x3abe, 0x3ada, 0x3af4, 0x3b0e, 0x3b27, 0x3b42,
	0x3b5b, 0x3b76, 0x3b8e, 0x3ba7, 0x3bc2, 0x3bdb, 0x3bf3, 0x3c0b,
	0x3c24, 0x3c3c, 0x3c53, 0x3c6b, 0x3c83, 0x3c9c, 0x3cb7, 0x3cd8,
	0x3cf1, 0x3d0c, 0x3d2a, 0x3d49, 0x3d63, 0x3d7e, 0x3d9a, 0x3db2,
	0x3dcd, 0x3def, 0x3e12, 0x3e33, 0x3e50, 0x3e70, 0x3e88, 0x3ea5,
	0x3ec3, 0x3ee1, 0x3f01, 0x3f22, 0x3f40, 0x3f5b, 0x3f78, 0x3f94,
	// Entry 7280 - 72BF
	0x3faf, 0x3fc9, 0x3fe2, 0x4003, 0x4021, 0x403b, 0x4057, 0x4070,
	0x4089, 0x40a4, 0x40c5, 0x40e0, 0x40f8, 0x4113, 0x4130, 0x414c,
	0x4168, 0x4188, 0x41a1, 0x41bb, 0x41d3, 0x41ee, 0x420e, 0x422b,
	0x4243, 0x425e, 0x4277, 0x428e, 0x42a6, 0x42bf, 0x42e0, 0x42f8,
	0x4310, 0x432d, 0x4347, 0x4365, 0x437f, 0x439a, 0x43b7, 0x43d1,
	0x43f7, 0x4414, 0x442e, 0x444a, 0x4465, 0x448b, 0x44aa, 0x44c3,
	0x44de, 0x44fc, 0x4516, 0x452f, 0x454b, 0x4564, 0x457d, 0x4598,
	0x45b0, 0x45c9, 0x45e3, 0x45ff, 0x4619, 0x4636, 0x4650, 0x4671,
	// Entry 72C0 - 72FF
	0x468a, 0x46a7, 0x46c6, 0x46df, 0x46fa, 0x4712, 0x472f, 0x474b,
	0x4768, 0x4784, 0x479e, 0x47b6, 0x47d0, 0x47e8, 0x4802, 0x481b,
	0x4838, 0x4853, 0x486a, 0x4884, 0x489c, 0x48b8, 0x48d7, 0x48f2,
	0x490a, 0x4923, 0x493d, 0x4958, 0x496f, 0x4987, 0x49a0, 0x49b9,
	0x49d1, 0x49ed, 0x4a06, 0x4a1f, 0x4a40, 0x4a59, 0x4a72, 0x4a8f,
	0x4aa7, 0x4ac0, 0x4ada, 0x4af5, 0x4b0d, 0x4b28, 0x4b43, 0x4b5f,
	0x4b79, 0x4b92, 0x4bb2, 0x4bcc, 0x4be6, 0x4bff, 0x4c18, 0x4c31,
	0x4c4d, 0x4c6d, 0x4c86, 0x4c9e, 0x4cb6, 0x4cce, 0x4ce6, 0x4cfe,
	// Entry 7300 - 733F
	0x4d17, 0x4d2f, 0x4d47, 0x4d60, 0x4d7a, 0x4d93, 0x4dad, 0x4dc7,
	0x4de4, 0x4dfd, 0x4e17, 0x4e31, 0x4e4a, 0x4e64, 0x4e83, 0x4e9c,
	0x4eb7, 0x4ed0, 0x4ee8, 0x4f00, 0x4f1c, 0x4f35, 0x4f4d, 0x4f67,
	0x4f81, 0x4f9d, 0x4fb6, 0x4fd1, 0x4fe9, 0x5005, 0x5025, 0x5041,
	0x5058, 0x5071, 0x508c, 0x50aa, 0x50c3, 0x50df, 0x50fa, 0x5113,
	0x512c, 0x5147, 0x5160, 0x517b, 0x5193, 0x51ab, 0x51c6, 0x51df,
	0x51f9, 0x5212, 0x522d, 0x5245, 0x525f, 0x5278, 0x5291, 0x52ab,
	0x52c8, 0x52e3, 0x52fe, 0x5317, 0x532f, 0x534a, 0x5363, 0x537b,
	// Entry 7340 - 737F
	0x5396, 0x53b0, 0x53cc, 0x53e5, 0x53fd, 0x5416, 0x542f, 0x5449,
	0x5462, 0x547a, 0x5495, 0x54b0, 0x54c9, 0x54e2, 0x54fa, 0x5513,
	0x552c, 0x5548, 0x5562, 0x557b, 0x5596, 0x55b0, 0x55ca, 0x55e5,
	0x55fc, 0x5618, 0x5630, 0x5648, 0x5660, 0x5678, 0x5692, 0x56ac,
	0x56c2, 0x56da, 0x56f1, 0x570a, 0x5724, 0x573d, 0x5754, 0x576c,
	0x5785, 0x579d, 0x57b4, 0x57cd, 0x57e5, 0x57fe, 0x5816, 0x5833,
	0x584a, 0x5863, 0x5882, 0x589a, 0x58b2, 0x58cb, 0x58e4, 0x58fe,
	0x5916, 0x592e, 0x5947, 0x595f, 0x5977, 0x598f, 0x59aa, 0x59c3,
	// Entry 7380 - 73BF
	0x59dc, 0x59f4, 0x5a0d, 0x5a27, 0x5a3f, 0x5a57, 0x5a74, 0x5a8d,
	0x5aa5, 0x5abe, 0x5ad6, 0x5af1, 0x5b0a, 0x5b23, 0x5b3e, 0x5b57,
	0x5b71, 0x5b8c, 0x5ba6, 0x5bbf, 0x5bd7, 0x5bf3, 0x5c0c, 0x5c26,
	0x5c43, 0x5c5f, 0x5c77, 0x5c90, 0x5cac, 0x5cc5, 0x5ce4, 0x5cfc,
	0x5d14, 0x5d36, 0x5d5a, 0x5d73, 0x5d8d, 0x5da6, 0x5dc0, 0x5dd7,
	0x5df1, 0x5e0b, 0x5e25, 0x5e40, 0x5e5a, 0x5e73, 0x5e8c, 0x5ea3,
	0x5ebc, 0x5ed8, 0x5ef5, 0x5f11, 0x5f2b, 0x5f44, 0x5f5d, 0x5f76,
	0x5f8f, 0x5fa7, 0x5fc0, 0x5fd8, 0x5ff8, 0x6010, 0x602a, 0x6044,
	// Entry 73C0 - 73FF
	0x605e, 0x6077, 0x6092, 0x60aa, 0x60c4, 0x60de, 0x60f6, 0x610e,
	0x612a, 0x6143, 0x615a, 0x6173, 0x618c, 0x61a5, 0x61c1, 0x61e1,
	0x61fa, 0x6213, 0x622c, 0x6245, 0x625d, 0x6276, 0x6291, 0x62aa,
	0x62c2, 0x62db, 0x62f5, 0x630d, 0x6326, 0x633f, 0x635a, 0x6374,
	0x6392, 0x63ae, 0x63c6, 0x63df, 0x63f5, 0x640d, 0x6423, 0x6439,
	0x6451, 0x646f, 0x6487, 0x649f, 0x64c1, 0x64da, 0x64f3, 0x650d,
	0x6527, 0x6548, 0x6566, 0x657e, 0x6596, 0x65af, 0x65c8, 0x65e7,
	0x65ff, 0x6617, 0x662f, 0x6647, 0x665e, 0x6675, 0x668e, 0x66a6,
	// Entry 7400 - 743F
	0x66c1, 0x66d9, 0x66f1, 0x670a, 0x6728, 0x673f, 0x6756, 0x676e,
	0x6785, 0x679d, 0x67b4, 0x67cc, 0x67e4, 0x67fb, 0x6813, 0x682b,
	0x6843, 0x685c, 0x6873, 0x6889, 0x68a0, 0x68b7, 0x68cf, 0x68e7,
	0x68ff, 0x6916, 0x692e, 0x6947, 0x6961, 0x6979, 0x6992, 0x69ac,
	0x69c2, 0x69da, 0x69f3, 0x6a0a, 0x6a23, 0x6a3c, 0x6a54, 0x6a6d,
	0x6a84, 0x6a9e, 0x6ab6, 0x6ace, 0x6ae5, 0x6afe, 0x6b17, 0x6b30,
	0x6b48, 0x6b60, 0x6b77, 0x6b8e, 0x6ba7, 0x6bbf, 0x6bdb, 0x6bf4,
	0x6c0c, 0x6c25, 0x6c3d, 0x6c54, 0x6c6b, 0x6c83, 0x6c9a, 0x6cb3,
	// Entry 7440 - 747F
	0x6ccb, 0x6ce2, 0x6cf9, 0x6d12, 0x6d2a, 0x6d42, 0x6d5c, 0x6d75,
	0x6d82, 0x6d90, 0x6d9d, 0x6dab, 0x6db8, 0x6dc5, 0x6dd1, 0x6ddf,
	0x6dee, 0x6dfc, 0x6e0a, 0x6e18, 0x6e28, 0x6e35, 0x6e44, 0x6e52,
	0x6e5f, 0x6e6c, 0x6e78, 0x6e85, 0x6e93, 0x6ea2, 0x6eaf, 0x6ebc,
	0x6ec8, 0x6ed5, 0x6ee3, 0x6ef0, 0x6efe, 0x6f0b, 0x6f19, 0x6f27,
	0x6f34, 0x6f41, 0x6f50, 0x6f5e, 0x6f6c, 0x6f79, 0x6f88, 0x6f97,
	0x6fa5, 0x6fae, 0x6fbe, 0x6fce, 0x6fde, 0x6fee, 0x6ffe, 0x700e,
	0x701e, 0x702e, 0x703e, 0x704e, 0x705e, 0x706e, 0x707e, 0x708e,
	// Entry 7480 - 74BF
	0x709e, 0x70ae, 0x70be, 0x70ce, 0x70de, 0x70ee, 0x70fe, 0x710e,
	0x711e, 0x712e, 0x713e, 0x714f, 0x7160, 0x7171, 0x7182, 0x7193,
	0x71a4, 0x71b5, 0x71c6, 0x71dc, 0x71f2, 0x7209, 0x7220, 0x7231,
	0x7242, 0x7253, 0x7264, 0x7276, 0x7288, 0x729a, 0x72ac, 0x72bc,
	0x72cc, 0x72dc, 0x72ec, 0x72fc, 0x730d, 0x731d, 0x732e, 0x733e,
	0x734e, 0x735e, 0x736e, 0x737f, 0x7390, 0x73a0, 0x73b0, 0x73c0,
	0x73d0, 0x73e0, 0x73f1, 0x7401, 0x7411, 0x7421, 0x7432, 0x7443,
	0x7453, 0x7464, 0x7475, 0x7487, 0x7498, 0x74a8, 0x74b8, 0x74c9,
	// Entry 74C0 - 74FF
	0x74da, 0x74ea, 0x74fb, 0x750b, 0x751b, 0x752d, 0x753e, 0x754f,
	0x755f, 0x7571, 0x7583, 0x7594, 0x75a9, 0x75bc, 0x75cf, 0x75e2,
	0x75f6, 0x760a, 0x761e, 0x7633, 0x7648, 0x765b, 0x7670, 0x7683,
	0x7696, 0x76aa, 0x76bd, 0x76d0, 0x76e4, 0x76f7, 0x770a, 0x771d,
	0x7732, 0x7745, 0x775b, 0x776d, 0x777f, 0x7792, 0x77a4, 0x77b7,
	0x77c9, 0x77db, 0x77f8, 0x7814, 0x7830, 0x7850, 0x7871, 0x7884,
	0x789b, 0x78b2, 0x78c8, 0x78de, 0x78f5, 0x790c, 0x7922, 0x7938,
	0x794e, 0x7964, 0x797b, 0x7992, 0x79a9, 0x79c0, 0x79d7, 0x79ee,
	// Entry 7500 - 753F
	0x7a05, 0x7a1c, 0x7a32, 0x7a48, 0x7a5f, 0x7a76, 0x7a8c, 0x7aa2,
	0x7ab8, 0x7ace, 0x7ae5, 0x7afc, 0x7b16, 0x7b32, 0x7b4c, 0x7b66,
	0x7b81, 0x7b9b, 0x7bb6, 0x7bd1, 0x7beb, 0x7c06, 0x7c20, 0x7c3b,
	0x7c57, 0x7c72, 0x7c8e, 0x7caa, 0x7cc4, 0x7cdd, 0x7cf7, 0x7d11,
	0x7d2a, 0x7d42, 0x7d5b, 0x7d75, 0x7d8f, 0x7da8, 0x7dc2, 0x7ddc,
	0x7dfc, 0x7e17, 0x7e32, 0x7e4c, 0x7e69, 0x7e84, 0x7e9f, 0x7ebb,
	0x7ed5, 0x7ef0, 0x7f0a, 0x7f22, 0x7f38, 0x7f56, 0x7f6d, 0x7f83,
	0x7f99, 0x7fb1, 0x7fc8, 0x7fdf, 0x7ff5, 0x800d, 0x8025, 0x803c,
	// Entry 7540 - 757F
	0x8054, 0x8070, 0x8091, 0x80ad, 0x80d1, 0x80f1, 0x810e, 0x8127,
	0x813d, 0x8152, 0x8173, 0x818d, 0x81a3, 0x81b9, 0x81cf, 0x81e5,
	0x81f9, 0x8216, 0x8232, 0x8247, 0x825c, 0x8271, 0x8299, 0x82ba,
	0x82d4, 0x82f3, 0x8311, 0x832f, 0x834c, 0x8367, 0x8381, 0x839c,
	0x83b8, 0x83d2, 0x83ed, 0x8408, 0x8423, 0x843e, 0x8459, 0x8474,
	0x848e, 0x84a8, 0x84c2, 0x84dc, 0x84f7, 0x8511, 0x852b, 0x8542,
	0x8556, 0x856c, 0x857e, 0x8591, 0x85a5, 0x85b8, 0x85cc, 0x85e0,
	0x85f3, 0x8607, 0x861a, 0x862e, 0x8642, 0x8656, 0x866b, 0x867f,
	// Entry 7580 - 75BF
	0x8694, 0x86a7, 0x86bb, 0x86ce, 0x86e2, 0x86f5, 0x8708, 0x871c,
	0x872f, 0x8743, 0x8756, 0x8769, 0x877c, 0x878f, 0x87a2, 0x87b5,
	0x87c9, 0x87dc, 0x87f3, 0x8809, 0x881f, 0x8836, 0x884c, 0x8863,
	0x8879, 0x8890, 0x88a5, 0x88b8, 0x88cb, 0x88da, 0x88f0, 0x8904,
	0x8917, 0x892a, 0x893f, 0x8953, 0x8967, 0x897a, 0x898f, 0x89a4,
	0x89b8, 0x89d4, 0x89f0, 0x8a0c, 0x8a28, 0x8a47, 0x8a63, 0x8a80,
	0x8a9c, 0x8ab8, 0x8ad4, 0x8af0, 0x8b0c, 0x8b28, 0x8b44, 0x8b60,
	0x8b7c, 0x8b98, 0x8bb4, 0x8bd0, 0x8bed, 0x8c09, 0x8c25, 0x8c42,
	// Entry 75C0 - 75FF
	0x8c5f, 0x8c7b, 0x8c97, 0x8cb4, 0x8cd0, 0x8cec, 0x8d08, 0x8d25,
	0x8d41, 0x8d5b, 0x8d75, 0x8d8f, 0x8da9, 0x8dc6, 0x8de0, 0x8dfb,
	0x8e15, 0x8e2f, 0x8e49, 0x8e63, 0x8e7d, 0x8e97, 0x8eb1, 0x8ecb,
	0x8ee5, 0x8eff, 0x8f19, 0x8f33, 0x8f4e, 0x8f68, 0x8f82, 0x8f9d,
	0x8fb8, 0x8fd2, 0x8fec, 0x9007, 0x9021, 0x903b, 0x9055, 0x9070,
	0x908a, 0x90a0, 0x90b5, 0x90ca, 0x90e1, 0x90f7, 0x910d, 0x9122,
	0x9139, 0x9150, 0x9166, 0x917c, 0x9195, 0x91ae, 0x91c9, 0x91e4,
	0x91fe, 0x9218, 0x9234, 0x924f, 0x926a, 0x928e, 0x92b2, 0x92d8,
	// Entry 7600 - 763F
	0x92e9, 0x92fe, 0x9315, 0x932f, 0x934e, 0x936f, 0x938f, 0x93ab,
	0x93ca, 0x93e9, 0x940b, 0x9426, 0x9444, 0x9462, 0x9481, 0x949f,
	0x94bd, 0x94da, 0x94f8, 0x9514, 0x9530, 0x954f, 0x9575, 0x9593,
	0x95b1, 0x95d3, 0x95ef, 0x960e, 0x962a, 0x9647, 0x9666, 0x9684,
	0x969e, 0x96bb, 0x96d8, 0x96f8, 0x9711, 0x972d, 0x9749, 0x9766,
	0x9782, 0x979e, 0x97b9, 0x97d5, 0x97ef, 0x9809, 0x9826, 0x984a,
	0x9866, 0x9882, 0x98a2, 0x98bc, 0x98d9, 0x98f3, 0x9901, 0x990f,
	0x9920, 0x992f, 0x993d, 0x994c, 0x9962, 0x9970, 0x997e, 0x998d,
	// Entry 7640 - 767F
	0x999b, 0x99a9, 0x99bb, 0x99cc, 0x99db, 0x99ea, 0x99f8, 0x9a07,
	0x9a19, 0x9a2f, 0x9a3e, 0x9a4e, 0x9a5c, 0x9a6b, 0x9a7a, 0x9a8a,
	0x9a9a, 0x9aaa, 0x9abb, 0x9acc, 0x9ada, 0x9ae8, 0x9af9, 0x9b07,
	0x9b16, 0x9b25, 0x9b35, 0x9b4c, 0x9b5a, 0x9b68, 0x9b77, 0x9b87,
	0x9b97, 0x9ba7, 0x9bb6, 0x9bc6, 0x9bd6, 0x9be6, 0x9bf9, 0x9c0c,
	0x9c25, 0x9c34, 0x9c43, 0x9c52, 0x9c62, 0x9c71, 0x9c80, 0x9c92,
	0x9ca0, 0x9cae, 0x9cbd, 0x9ccc, 0x9cdc, 0x9cf3, 0x9d03, 0x9d14,
	0x9d22, 0x9d30, 0x9d3f, 0x9d4e, 0x9d5d, 0x9d6d, 0x9d7b, 0x9d8a,
	// Entry 7680 - 76BF
	0x9d99, 0x9db9, 0x9dd1, 0x9de5, 0x9dff, 0x9e1c, 0x9e2d, 0x9e3f,
	0x9e52, 0x9e64, 0x9e77, 0x9e88, 0x9e9a, 0x9eac, 0x9ebd, 0x9ece,
	0x9ee0, 0x9ef3, 0x9f06, 0x9f17, 0x9f29, 0x9f3c, 0x9f50, 0x9f62,
	0x9f74, 0x9f86, 0x9f98, 0x9fab, 0x9fbc, 0x9fce, 0x9fe1, 0x9ff5,
	0xa007, 0xa01a, 0xa02d, 0xa03e, 0xa050, 0xa062, 0xa075, 0xa088,
	0xa0a3, 0xa0b5, 0xa0cf, 0xa0e1, 0xa0f3, 0xa105, 0xa117, 0xa128,
	0xa13a, 0xa14d, 0xa160, 0xa172, 0xa185, 0xa197, 0xa1a9, 0xa1bb,
	0xa1cf, 0xa1e1, 0xa1f0, 0xa203, 0xa212, 0xa221, 0xa233, 0xa245,
	// Entry 76C0 - 76FF
	0xa257, 0xa269, 0xa27b, 0xa28d, 0xa29f, 0xa2ba, 0xa2d5, 0xa2f0,
	0xa30b, 0xa326, 0xa341, 0xa356, 0xa36a, 0xa37f, 0xa399, 0xa3b3,
	0xa3d7, 0xa3fd, 0xa418, 0xa434, 0xa44e, 0xa470, 0xa48b, 0xa49f,
	0xa4b3, 0xa4c7, 0xa4db, 0xa4ef, 0xa503, 0xa517, 0xa52b, 0xa53f,
	0xa553, 0xa567, 0xa57b, 0xa58f, 0xa5a3, 0xa5b7, 0xa5cb, 0xa5df,
	0xa5f3, 0xa607, 0xa61b, 0xa62f, 0xa643, 0xa657, 0xa66b, 0xa67f,
	0xa693, 0xa6a7, 0xa6bb, 0xa6cf, 0xa6e3, 0xa6f7, 0xa70b, 0xa71f,
	0xa733, 0xa747, 0xa75b, 0xa76f, 0xa783, 0xa797, 0xa7ab, 0xa7bf,
	// Entry 7700 - 773F
	0xa7d3, 0xa7e7, 0xa7fb, 0xa80f, 0xa823, 0xa837, 0xa84b, 0xa85f,
	0xa873, 0xa887, 0xa89b, 0xa8af, 0xa8c3, 0xa8d7, 0xa8eb, 0xa8ff,
	0xa913, 0xa927, 0xa93b, 0xa94f, 0xa963, 0xa977, 0xa98b, 0xa99f,
	0xa9b3, 0xa9c7, 0xa9db, 0xa9ef, 0xaa03, 0xaa17, 0xaa2b, 0xaa3f,
	0xaa53, 0xaa67, 0xaa7b, 0xaa8f, 0xaaa3, 0xaab7, 0xaacb, 0xaadf,
	0xaaf3, 0xab07, 0xab1b, 0xab2f, 0xab43, 0xab57, 0xab6b, 0xab7f,
	0xab93, 0xaba7, 0xabbb, 0xabcf, 0xabe3, 0xabf7, 0xac0b, 0xac1f,
	0xac33, 0xac47, 0xac5b, 0xac6f, 0xac83, 0xac97, 0xacab, 0xacbf,
	// Entry 7740 - 777F
	0xacd3, 0xace7, 0xacfb, 0xad0f, 0xad23, 0xad37, 0xad4b, 0xad5f,
	0xad73, 0xad87, 0xad9b, 0xadaf, 0xadc3, 0xadd7, 0xadeb, 0xadff,
	0xae13, 0xae27, 0xae3b, 0xae4f, 0xae63, 0xae77, 0xae8b, 0xae9f,
	0xaeb3, 0xaec7, 0xaedb, 0xaeef, 0xaf03, 0xaf17, 0xaf2b, 0xaf3f,
	0xaf53, 0xaf67, 0xaf7b, 0xaf8f, 0xafa3, 0xafb7, 0xafcb, 0xafdf,
	0xaff3, 0xb007, 0xb01b, 0xb02f, 0xb043, 0xb057, 0xb06b, 0xb07f,
	0xb093, 0xb0a7, 0xb0bb, 0xb0cf, 0xb0e3, 0xb0f7, 0xb10b, 0xb11f,
	0xb133, 0xb147, 0xb15b, 0xb16f, 0xb183, 0xb197, 0xb1ab, 0xb1bf,
	// Entry 7780 - 77BF
	0xb1d3, 0xb1e7, 0xb1fb, 0xb20f, 0xb223, 0xb237, 0xb24b, 0xb25f,
	0xb273, 0xb287, 0xb29b, 0xb2af, 0xb2c3, 0xb2d7, 0xb2eb, 0xb2ff,
	0xb313, 0xb327, 0xb33b, 0xb34f, 0xb363, 0xb377, 0xb38b, 0xb39f,
	0xb3b3, 0xb3c7, 0xb3db, 0xb3ef, 0xb403, 0xb417, 0xb42b, 0xb43f,
	0xb453, 0xb467, 0xb47b, 0xb48f, 0xb4a3, 0xb4b7, 0xb4cb, 0xb4df,
	0xb4f3, 0xb507, 0xb51b, 0xb52f, 0xb543, 0xb557, 0xb56b, 0xb57f,
	0xb593, 0xb5a7, 0xb5bb, 0xb5cf, 0xb5e3, 0xb5f7, 0xb60b, 0xb61f,
	0xb633, 0xb647, 0xb65b, 0xb66f, 0xb683, 0xb697, 0xb6ab, 0xb6bf,
	// Entry 77C0 - 77FF
	0xb6d3, 0xb6e7, 0xb6fb, 0xb70f, 0xb723, 0xb737, 0xb74b, 0xb75f,
	0xb773, 0xb787, 0xb79b, 0xb7af, 0xb7c3, 0xb7d7, 0xb7eb, 0xb7ff,
	0xb813, 0xb827, 0xb83b, 0xb84f, 0xb863, 0xb877, 0xb88b, 0xb89f,
	0xb8b3, 0xb8c7, 0xb8db, 0xb8ef, 0xb903, 0xb917, 0xb92b, 0xb93f,
	0xb953, 0xb967, 0xb97b, 0xb98f, 0xb9a3, 0xb9b7, 0xb9cb, 0xb9df,
	0xb9f3, 0xba07, 0xba1b, 0xba2f, 0xba43, 0xba57, 0xba6b, 0xba7f,
	0xba93, 0xbaa7, 0xbabb, 0xbacf, 0xbae3, 0xbaf7, 0xbb0b, 0xbb1f,
	0xbb33, 0xbb47, 0xbb5b, 0xbb6f, 0xbb83, 0xbb97, 0xbbab, 0xbbbf,
	// Entry 7800 - 783F
	0xbbd3, 0xbbe7, 0xbbfb, 0xbc0f, 0xbc23, 0xbc37, 0xbc4b, 0xbc5f,
	0xbc73, 0xbc87, 0xbc9b, 0xbcaf, 0xbcc3, 0xbcd7, 0xbceb, 0xbcff,
	0xbd13, 0xbd27, 0xbd3b, 0xbd4f, 0xbd63, 0xbd77, 0xbd8b, 0xbd9f,
	0xbdb3, 0xbdc7, 0xbddb, 0xbdef, 0xbe03, 0xbe17, 0xbe2b, 0xbe3f,
	0xbe53, 0xbe67, 0xbe7b, 0xbe8f, 0xbea3, 0xbeb7, 0xbecb, 0xbedf,
	0xbef3, 0xbf07, 0xbf1b, 0xbf2f, 0xbf43, 0xbf57, 0xbf6b, 0xbf7f,
	0xbf93, 0xbfa7, 0xbfbb, 0xbfcf, 0xbfe3, 0xbff7, 0xc00b, 0xc01f,
	0xc033, 0xc047, 0xc05b, 0xc06f, 0xc083, 0xc097, 0xc0ab, 0xc0bf,
	// Entry 7840 - 787F
	0xc0d3, 0xc0e7, 0xc0fb, 0xc10f, 0xc123, 0xc137, 0xc14b, 0xc15f,
	0xc173, 0xc187, 0xc19b, 0xc1af, 0xc1c3, 0xc1d7, 0xc1eb, 0xc1ff,
	0xc213, 0xc227, 0xc23b, 0xc24f, 0xc263, 0xc277, 0xc28b, 0xc29f,
	0xc2b3, 0xc2c7, 0xc2db, 0xc2ef, 0xc303, 0xc317, 0xc32b, 0xc33f,
	0xc353, 0xc367, 0xc37b, 0xc38f, 0xc3a3, 0xc3b7, 0xc3cb, 0xc3df,
	0xc3f3, 0xc407, 0xc41b, 0xc42f, 0xc443, 0xc457, 0xc46b, 0xc47f,
	0xc493, 0xc4a7, 0xc4bb, 0xc4cf, 0xc4e3, 0xc4f7, 0xc50b, 0xc51f,
	0xc533, 0xc547, 0xc55b, 0xc56f, 0xc583, 0xc597, 0xc5ab, 0xc5bf,
	// Entry 7880 - 78BF
	0xc5d3, 0xc5e7, 0xc5fb, 0xc60f, 0xc623, 0xc637, 0xc64b, 0xc65f,
	0xc673, 0xc687, 0xc69b, 0xc6af, 0xc6c3, 0xc6d7, 0xc6eb, 0xc6ff,
	0xc713, 0xc727, 0xc73b, 0xc74f, 0xc763, 0xc777, 0xc78b, 0xc79f,
	0xc7b3, 0xc7c7, 0xc7db, 0xc7ef, 0xc803, 0xc817, 0xc82b, 0xc83f,
	0xc853, 0xc867, 0xc87b, 0xc88f, 0xc8a3, 0xc8b7, 0xc8cb, 0xc8df,
	0xc8f3, 0xc907, 0xc91b, 0xc92f, 0xc943, 0xc957, 0xc96b, 0xc97f,
	0xc993, 0xc9a7, 0xc9bb, 0xc9cf, 0xc9e3, 0xc9f7, 0xca0b, 0xca1f,
	0xca33, 0xca47, 0xca5b, 0xca6f, 0xca83, 0xca97, 0xcaab, 0xcabf,
	// Entry 78C0 - 78FF
	0xcad3, 0xcae7, 0xcafb, 0xcb0f, 0xcb23, 0xcb37, 0xcb4b, 0xcb5f,
	0xcb73, 0xcb87, 0xcb9b, 0xcbaf, 0xcbc3, 0xcbd7, 0xcbeb, 0xcbff,
	0xcc13, 0xcc27, 0xcc3b, 0xcc4f, 0xcc63, 0xcc77, 0xcc8b, 0xcc9f,
	0xccb3, 0xccc7, 0xccdb, 0xccef, 0xcd03, 0xcd17, 0xcd2b, 0xcd3f,
	0xcd53, 0xcd67, 0xcd7b, 0xcd8f, 0xcda3, 0xcdb7, 0xcdcb, 0xcddf,
	0xcdf3, 0xce07, 0xce1b, 0xce2f, 0xce43, 0xce57, 0xce6b, 0xce7f,
	0xce93, 0xcea7, 0xcebb, 0xcecf, 0xcee3, 0xcef7, 0xcf0b, 0xcf1f,
	0xcf33, 0xcf47, 0xcf5b, 0xcf6f, 0xcf83, 0xcf97, 0xcfab, 0xcfbf,
	// Entry 7900 - 793F
	0xcfd3, 0xcfe7, 0xcffb, 0xd00f, 0xd023, 0xd037, 0xd04b, 0xd05f,
	0xd073, 0xd087, 0xd09b, 0xd0af, 0xd0c3, 0xd0d7, 0xd0eb, 0xd0ff,
	0xd113, 0xd127, 0xd13b, 0xd14f, 0xd163, 0xd177, 0xd18b, 0xd19f,
	0xd1b3, 0xd1c7, 0xd1db, 0xd1ef, 0xd203, 0xd217, 0xd22b, 0xd23f,
	0xd253, 0xd267, 0xd27b, 0xd28f, 0xd2a3, 0xd2b7, 0xd2cb, 0xd2df,
	0xd2f3, 0xd307, 0xd31b, 0xd32f, 0xd343, 0xd357, 0xd36b, 0xd37f,
	0xd393, 0xd3a7, 0xd3bb, 0xd3cf, 0xd3e3, 0xd3f7, 0xd40b, 0xd41f,
	0xd433, 0xd447, 0xd45b, 0xd46f, 0xd483, 0xd497, 0xd4ab, 0xd4bf,
	// Entry 7940 - 797F
	0xd4d3, 0xd4e7, 0xd4fb, 0xd50f, 0xd523, 0xd537, 0xd54b, 0xd55f,
	0xd573, 0xd587, 0xd59b, 0xd5af, 0xd5c3, 0xd5d7, 0xd5eb, 0xd5ff,
	0xd613, 0xd627, 0xd63b, 0xd64f, 0xd663, 0xd677, 0xd68b, 0xd69f,
	0xd6b3, 0xd6c7, 0xd6db, 0xd6ef, 0xd703, 0xd717, 0xd72b, 0xd73f,
	0xd753, 0xd767, 0xd77b, 0xd78f, 0xd7a3, 0xd7b7, 0xd7cb, 0xd7df,
	0xd7f3, 0xd807, 0xd81b, 0xd82f, 0xd843, 0xd857, 0xd86b, 0xd87f,
	0xd893, 0xd8a7, 0xd8bb, 0xd8cf, 0xd8e3, 0xd8f7, 0xd90b, 0xd91f,
	0xd933, 0xd947, 0xd95b, 0xd96f, 0xd983, 0xd997, 0xd9ab, 0xd9bf,
	// Entry 7980 - 79BF
	0xd9d3, 0xd9e7, 0xd9fb, 0xda0f, 0xda23, 0xda37, 0xda4b, 0xda5f,
	0xda73, 0xda87, 0xda9b, 0xdaaf, 0xdac3, 0xdad7, 0xdaeb, 0xdaff,
	0xdb13, 0xdb27, 0xdb3b, 0xdb4f, 0xdb63, 0xdb77, 0xdb8b, 0xdb9f,
	0xdbb3, 0xdbc7, 0xdbdb, 0xdbef, 0xdc03, 0xdc17, 0xdc2b, 0xdc3f,
	0xdc53, 0xdc67, 0xdc7b, 0xdc8f, 0xdca3, 0xdcb7, 0xdccb, 0xdcdf,
	0xdcf3, 0xdd07, 0xdd1b, 0xdd2f, 0xdd43, 0xdd57, 0xdd6b, 0xdd7f,
	0xdd93, 0xdda7, 0xddbb, 0xddcf, 0xdde3, 0xddf7, 0xde0b, 0xde1f,
	0xde33, 0xde47, 0xde5b, 0xde6f, 0xde83, 0xde97, 0xdeab, 0xdebf,
	// Entry 79C0 - 79FF
	0xded3, 0xdee7, 0xdefb, 0xdf0f, 0xdf23, 0xdf37, 0xdf4b, 0xdf5f,
	0xdf73, 0xdf87, 0xdf9b, 0xdfaf, 0xdfc3, 0xdfd7, 0xdfeb, 0xdfff,
	0xe013, 0xe027, 0xe03b, 0xe04f, 0xe063, 0xe077, 0xe08b, 0xe0ae,
	0xe0d1, 0xe0f4, 0xe117, 0xe13a, 0xe15d, 0xe180, 0xe1a3, 0xe1c6,
	0xe1e9, 0xe20c, 0xe22f, 0xe252, 0xe275, 0xe298, 0xe2bb, 0xe2de,
	0xe301, 0xe324, 0xe347, 0xe36a, 0xe38d, 0xe3b0, 0xe3d3, 0xe3f6,
	0xe419, 0xe43c, 0xe45f, 0xe482, 0xe4a5, 0xe4c8, 0xe4eb, 0xe50e,
	0xe531, 0xe554, 0xe577, 0xe59a, 0xe5bd, 0xe5e0, 0xe603, 0xe626,
	// Entry 7A00 - 7A3F
	0xe649, 0xe66c, 0xe68f, 0xe6b2, 0xe6d5, 0xe6f8, 0xe71b, 0xe73e,
	0xe761, 0xe784, 0xe7a7, 0xe7ca, 0xe7ed, 0xe810, 0xe833, 0xe856,
	0xe879, 0xe89c, 0xe8bf, 0xe8e2, 0xe905, 0xe928, 0xe94b, 0xe96e,
	0xe991, 0xe9b4, 0xe9d7, 0xe9fa, 0xea1d, 0xea40, 0xea63, 0xea86,
	0xeaa9, 0xeacc, 0xeaef, 0xeb12, 0xeb35, 0xeb58, 0xeb7b, 0xeb9e,
	0xebc1, 0xebe4, 0xec07, 0xec2a, 0xec4d, 0xec70, 0xec93, 0xecb6,
	0xecd9, 0xecfc, 0xed1f, 0xed42, 0xed65, 0xed88, 0xedab, 0xedce,
	0xedf1, 0xee14, 0xee37, 0xee5a, 0xee7d, 0xeea0, 0xeec3, 0xeee6,
	// Entry 7A40 - 7A7F
	0xef09, 0xef2c, 0xef4f, 0xef72, 0xef95, 0xefb8, 0xefdb, 0xeffe,
	0xf021, 0xf044, 0xf067, 0xf08a, 0xf0ad, 0xf0d0, 0xf0f3, 0xf116,
	0xf139, 0xf15c, 0xf17f, 0xf1a2, 0xf1c5, 0xf1e8, 0xf20b, 0xf22e,
	0xf251, 0xf274, 0xf297, 0xf2ba, 0xf2dd, 0xf300, 0xf323, 0xf346,
	0xf369, 0xf38c, 0xf3af, 0xf3d2, 0xf3f5, 0xf418, 0xf43b, 0xf45e,
	0xf481, 0xf4a4, 0xf4c7, 0xf4ea, 0xf50d, 0xf530, 0xf553, 0xf576,
	0xf599, 0xf5bc, 0xf5df, 0xf602, 0xf625, 0xf648, 0xf66b, 0xf68e,
	0xf6b1, 0xf6d4, 0xf6f7, 0xf71a, 0xf73d, 0xf760, 0xf783, 0xf7a6,
	// Entry 7A80 - 7ABF
	0xf7c9, 0xf7ec, 0xf80f, 0xf832, 0xf855, 0xf878, 0xf89b, 0xf8be,
	0xf8e1, 0xf904, 0xf927, 0xf94a, 0xf96d, 0xf990, 0xf9b3, 0xf9d6,
	0xf9f9, 0xfa1c, 0xfa3f, 0xfa62, 0xfa85, 0xfaa8, 0xfacb, 0xfaee,
	0xfb11, 0xfb34, 0xfb57, 0xfb7a, 0xfb9d, 0xfbc0, 0xfbe3, 0xfc06,
	0xfc29, 0xfc4c, 0xfc6f, 0xfc92, 0xfcb5, 0xfcd8, 0xfcfb, 0xfd1e,
	0xfd41, 0xfd64, 0xfd87, 0xfdaa, 0xfdcd, 0xfdf0, 0xfe13, 0xfe36,
	0xfe59, 0xfe7c, 0xfe9f, 0xfec2, 0xfee5, 0xff08, 0xff2b, 0xff4e,
	0xff71, 0xff94, 0xffb7, 0xffda, 0xfffd, 0x0020, 0x0043, 0x0066,
	// Entry 7AC0 - 7AFF
	0x0089, 0x00ac, 0x00cf, 0x00f2, 0x0115, 0x0138, 0x015b, 0x017e,
	0x01a1, 0x01c4, 0x01e7, 0x020a, 0x022d, 0x0250, 0x0273, 0x0296,
	0x02b9, 0x02dc, 0x02ff, 0x0322, 0x0345, 0x0368, 0x038b, 0x03ae,
	0x03d1, 0x03f4, 0x0417, 0x043a, 0x045d, 0x0480, 0x04a3, 0x04c6,
	0x04e9, 0x050c, 0x052f, 0x0552, 0x0575, 0x0598, 0x05bb, 0x05de,
	0x0601, 0x0624, 0x0647, 0x066a, 0x068d, 0x06b0, 0x06d3, 0x06f6,
	0x0719, 0x073c, 0x075f, 0x0782, 0x07a5, 0x07c8, 0x07eb, 0x080e,
	0x0831, 0x0854, 0x0877, 0x089a, 0x08bd, 0x08e0, 0x0903, 0x0926,
	// Entry 7B00 - 7B3F
	0x0949, 0x096c, 0x098f, 0x09b2, 0x09d5, 0x09f8, 0x0a1b, 0x0a3e,
	0x0a61, 0x0a84, 0x0aa7, 0x0aca, 0x0aed, 0x0b10, 0x0b33, 0x0b56,
	0x0b79, 0x0b9c, 0x0bbf, 0x0be2, 0x0c05, 0x0c28, 0x0c4b, 0x0c6e,
	0x0c91, 0x0cb4, 0x0cd7, 0x0cfa, 0x0d1d, 0x0d40, 0x0d63, 0x0d86,
	0x0da9, 0x0dcc, 0x0def, 0x0e12, 0x0e35, 0x0e58, 0x0e7b, 0x0e9e,
	0x0ec1, 0x0ee4, 0x0f07, 0x0f2a, 0x0f4d, 0x0f70, 0x0f93, 0x0fb6,
	0x0fd9, 0x0ffc, 0x101f, 0x1042, 0x1065, 0x1088, 0x10ab, 0x10ce,
	0x10f1, 0x1114, 0x1137, 0x115a, 0x117d, 0x11a0, 0x11c3, 0x11e6,
	// Entry 7B40 - 7B7F
	0x1209, 0x122c, 0x124f, 0x1272, 0x1295, 0x12b8, 0x12db, 0x12fe,
	0x1321, 0x1344, 0x1367, 0x138a, 0x13ad, 0x13d0, 0x13f3, 0x1416,
	0x1439, 0x145c, 0x147f, 0x14a2, 0x14c5, 0x14e8, 0x150b, 0x152e,
	0x1551, 0x1574, 0x1597, 0x15ba, 0x15dd, 0x1600, 0x1623, 0x1646,
	0x1669, 0x168c, 0x16af, 0x16d2, 0x16f5, 0x1718, 0x173b, 0x175e,
	0x1781, 0x17a4, 0x17c7, 0x17ea, 0x180d, 0x1830, 0x1853, 0x1876,
	0x1899, 0x18bc, 0x18df, 0x1902, 0x1925, 0x1948, 0x196b, 0x198e,
	0x19b1, 0x19d4, 0x19f7, 0x1a1a, 0x1a3d, 0x1a60, 0x1a83, 0x1aa6,
	// Entry 7B80 - 7BBF
	0x1ac9, 0x1aec, 0x1b0f, 0x1b32, 0x1b55, 0x1b78, 0x1b9b, 0x1bbe,
	0x1be1, 0x1c04, 0x1c27, 0x1c4a, 0x1c6d, 0x1c90, 0x1cb3, 0x1cd6,
	0x1cf9, 0x1d1c, 0x1d3f, 0x1d62, 0x1d85, 0x1da8, 0x1dcb, 0x1dee,
	0x1e11, 0x1e34, 0x1e57, 0x1e7a, 0x1e9d, 0x1ec0, 0x1ee3, 0x1f06,
	0x1f29, 0x1f4c, 0x1f6f, 0x1f92, 0x1fb5, 0x1fd8, 0x1ffb, 0x201e,
	0x2041, 0x2064, 0x2087, 0x20aa, 0x20cd, 0x20f0, 0x2104, 0x2118,
	0x212c, 0x2140, 0x2154, 0x2168, 0x217c, 0x2190, 0x21a4, 0x21b8,
	0x21cc, 0x21e0, 0x21f4, 0x2208, 0x221c, 0x2230, 0x2244, 0x2258,
	// Entry 7BC0 - 7BFF
	0x226c, 0x2280, 0x2294, 0x22a8, 0x22bc, 0x22d0, 0x22e4, 0x22f8,
	0x230c, 0x2320, 0x2334, 0x2348, 0x235c, 0x2370, 0x2384, 0x2398,
	0x23ac, 0x23c0, 0x23d4, 0x23e8, 0x23fc, 0x2410, 0x2424, 0x2438,
	0x244c, 0x2460, 0x2474, 0x2488, 0x249c, 0x24b0, 0x24c4, 0x24d8,
	0x24ec, 0x2500, 0x2514, 0x2528, 0x253c, 0x2550, 0x2564, 0x2578,
	0x258c, 0x25a0, 0x25b4, 0x25c8, 0x25dc, 0x25f0, 0x2604, 0x2618,
	0x262c, 0x2640, 0x2654, 0x2668, 0x267c, 0x2690, 0x26a4, 0x26b8,
	0x26cc, 0x26e0, 0x26f4, 0x2708, 0x271c, 0x2730, 0x2744, 0x2758,
	// Entry 7C00 - 7C3F
	0x276c, 0x2780, 0x2794, 0x27a8, 0x27bc, 0x27d0, 0x27e4, 0x27f8,
	0x280c, 0x2820, 0x2834, 0x2848, 0x285c, 0x2870, 0x2884, 0x2898,
	0x28ac, 0x28c0, 0x28d4, 0x28e8, 0x28fc, 0x2910, 0x2924, 0x2938,
	0x294c, 0x2960, 0x2974, 0x2988, 0x299c, 0x29b0, 0x29c4, 0x29d8,
	0x29ec, 0x2a09, 0x2a26, 0x2a43, 0x2a60, 0x2a7d, 0x2a9a, 0x2ac1,
	0x2ae8, 0x2b0f, 0x2b36, 0x2b5d, 0x2b84, 0x2bab, 0x2bc4, 0x2bde,
	0x2bf3, 0x2c08, 0x2c1d, 0x2c33, 0x2c48, 0x2c5d, 0x2c72, 0x2c87,
	0x2c9c, 0x2cb1, 0x2cc6, 0x2cdb, 0x2cf0, 0x2d05, 0x2d1a, 0x2d2f,
	// Entry 7C40 - 7C7F
	0x2d44, 0x2d59, 0x2d6e, 0x2d83, 0x2d98, 0x2dae, 0x2dc4, 0x2dda,
	0x2df0, 0x2e06, 0x2e1c, 0x2e32, 0x2e48, 0x2e5e, 0x2e75, 0x2e8c,
	0x2ea3, 0x2eb9, 0x2ecf, 0x2ee5, 0x2efb, 0x2f11, 0x2f27, 0x2f3d,
	0x2f53, 0x2f69, 0x2f7f, 0x2f95, 0x2fab, 0x2fc1, 0x2fd7, 0x2fed,
	0x3003, 0x3019, 0x302f, 0x3045, 0x305b, 0x3071, 0x3087, 0x309d,
	0x30b3, 0x30ca, 0x30e0, 0x30f6, 0x310c, 0x3122, 0x3138, 0x314e,
	0x3164, 0x317a, 0x3190, 0x31a6, 0x31bc, 0x31d2, 0x31e8, 0x31fe,
	0x3214, 0x322a, 0x3240, 0x3256, 0x326c, 0x3282, 0x3298, 0x32ae,
	// Entry 7C80 - 7CBF
	0x32c4, 0x32da, 0x32f0, 0x3306, 0x331c, 0x3332, 0x3348, 0x335e,
	0x3374, 0x338a, 0x33a0, 0x33b6, 0x33cc, 0x33e2, 0x33f8, 0x340e,
	0x3424, 0x343a, 0x3450, 0x3466, 0x347c, 0x3492, 0x34a8, 0x34be,
	0x34d4, 0x34ea, 0x3500, 0x3517, 0x352d, 0x3543, 0x3559, 0x356f,
	0x3585, 0x359b, 0x35b1, 0x35c7, 0x35dd, 0x35f3, 0x3609, 0x361f,
	0x3635, 0x364b, 0x3661, 0x3678, 0x368e, 0x36a4, 0x36ba, 0x36d0,
	0x36e6, 0x36fc, 0x3712, 0x3728, 0x373e, 0x3754, 0x376a, 0x3780,
	0x3796, 0x37ac, 0x37c2, 0x37d8, 0x37ef, 0x3805, 0x381b, 0x3831,
	// Entry 7CC0 - 7CFF
	0x3847, 0x385d, 0x3873, 0x3889, 0x389f, 0x38b5, 0x38cc, 0x38e2,
	0x38f8, 0x390e, 0x3924, 0x393a, 0x3950, 0x3966, 0x397c, 0x3992,
	0x39a8, 0x39be, 0x39d4, 0x39ea, 0x3a00, 0x3a17, 0x3a2e, 0x3a44,
	0x3a5a, 0x3a70, 0x3a86, 0x3a9c, 0x3ab2, 0x3ac8, 0x3ade, 0x3af4,
	0x3b0a, 0x3b20, 0x3b36, 0x3b4c, 0x3b62, 0x3b78, 0x3b8e, 0x3ba4,
	0x3bba, 0x3bd0, 0x3be6, 0x3bfc, 0x3c12, 0x3c28, 0x3c3e, 0x3c54,
	0x3c6a, 0x3c80, 0x3c96, 0x3cac, 0x3cc2, 0x3cd8, 0x3cee, 0x3d04,
	0x3d1a, 0x3d30, 0x3d46, 0x3d5c, 0x3d72, 0x3d88, 0x3d9e, 0x3db4,
	// Entry 7D00 - 7D3F
	0x3dca, 0x3de0, 0x3df6, 0x3e0c, 0x3e23, 0x3e39, 0x3e4f, 0x3e65,
	0x3e7b, 0x3e91, 0x3ea7, 0x3ebd, 0x3ed3, 0x3ee9, 0x3eff, 0x3f15,
	0x3f2c, 0x3f42, 0x3f58, 0x3f6e, 0x3f84, 0x3f9a, 0x3fb0, 0x3fc6,
	0x3fdc, 0x3ff2, 0x4008, 0x401e, 0x4034, 0x404a, 0x4060, 0x4076,
	0x408c, 0x40a2, 0x40b8, 0x40ce, 0x40e4, 0x40fa, 0x4110, 0x4126,
	0x413c, 0x4152, 0x4168, 0x417e, 0x4194, 0x41aa, 0x41c0, 0x41d6,
	0x41ec, 0x4202, 0x4218, 0x422e, 0x4244, 0x425a, 0x4270, 0x4286,
	0x429c, 0x42b2, 0x42c8, 0x42de, 0x42f4, 0x430a, 0x4320, 0x4336,
	// Entry 7D40 - 7D7F
	0x434c, 0x4362, 0x4378, 0x438e, 0x43a4, 0x43ba, 0x43d0, 0x43e6,
	0x43fc, 0x4412, 0x4428, 0x4443, 0x445e, 0x4478, 0x4492, 0x44ac,
	0x44c6, 0x44de, 0x44f6, 0x450e, 0x4526, 0x453e, 0x4556, 0x456e,
	0x4586, 0x459d, 0x45b2, 0x45c7, 0x45dc, 0x45f1, 0x4606, 0x461b,
	0x4630, 0x4645, 0x465a, 0x466f, 0x4684, 0x4699, 0x46ae, 0x46c3,
	0x46d8, 0x46ed, 0x4702, 0x4717, 0x472c, 0x4741, 0x4756, 0x476b,
	0x4780, 0x4795, 0x47aa, 0x47bf, 0x47d4, 0x47e9, 0x47fe, 0x4813,
	0x4828, 0x483d, 0x4852, 0x4867, 0x487c, 0x4891, 0x48a6, 0x48bb,
	// Entry 7D80 - 7DBF
	0x48d0, 0x48e5, 0x48fa, 0x490f, 0x4924, 0x4939, 0x494e, 0x4963,
	0x4978, 0x498d, 0x49a2, 0x49b7, 0x49cc, 0x49e1, 0x49f6, 0x4a0b,
	0x4a20, 0x4a35, 0x4a4a, 0x4a5f, 0x4a74, 0x4a89, 0x4a9e, 0x4ab3,
	0x4ac8, 0x4add, 0x4af2, 0x4b07, 0x4b1c, 0x4b31, 0x4b46, 0x4b5b,
	0x4b70, 0x4b85, 0x4b9a, 0x4baf, 0x4bc4, 0x4bd9, 0x4bee, 0x4c03,
	0x4c18, 0x4c2d, 0x4c42, 0x4c57, 0x4c6c, 0x4c81, 0x4c96, 0x4cab,
	0x4cc0, 0x4cd5, 0x4cea, 0x4cff, 0x4d14, 0x4d29, 0x4d3e, 0x4d53,
	0x4d68, 0x4d7d, 0x4d92, 0x4da7, 0x4dbc, 0x4dd1, 0x4de6, 0x4dfb,
	// Entry 7DC0 - 7DFF
	0x4e10, 0x4e25, 0x4e3a, 0x4e4f, 0x4e64, 0x4e79, 0x4e8e, 0x4ea3,
	0x4eb8, 0x4ecd, 0x4ee2, 0x4ef7, 0x4f0c, 0x4f21, 0x4f36, 0x4f4b,
	0x4f60, 0x4f75, 0x4f8a, 0x4f9f, 0x4fb4, 0x4fc9, 0x4fde, 0x4ff3,
	0x5008, 0x501d, 0x5032, 0x5047, 0x505c, 0x5071, 0x5086, 0x509b,
	0x50b0, 0x50c5, 0x50da, 0x50ef, 0x5104, 0x5119, 0x512e, 0x5143,
	0x5158, 0x516d, 0x5182, 0x5197, 0x51ac, 0x51c1, 0x51d6, 0x51eb,
	0x5200, 0x5215, 0x522a, 0x523f, 0x5254, 0x5269, 0x527e, 0x5293,
	0x52a8, 0x52bd, 0x52d2, 0x52e7, 0x52fc, 0x5311, 0x5326, 0x533b,
	// Entry 7E00 - 7E3F
	0x5350, 0x5365, 0x537a, 0x538f, 0x53a4, 0x53b9, 0x53ce, 0x53e3,
	0x53f8, 0x540d, 0x5422, 0x5437, 0x544c, 0x5461, 0x5476, 0x548b,
	0x54a0, 0x54b5, 0x54ca, 0x54df, 0x54f4, 0x5509, 0x551e, 0x5533,
	0x5548, 0x555d, 0x5572, 0x5587, 0x559c, 0x55b1, 0x55c6, 0x55db,
	0x55f0, 0x5605, 0x561a, 0x562f, 0x5644, 0x5659, 0x566e, 0x5683,
	0x5698, 0x56ad, 0x56c2, 0x56d7, 0x56ec, 0x5701, 0x5716, 0x572b,
	0x5740, 0x5755, 0x576a, 0x577f, 0x5794, 0x57a9, 0x57be, 0x57d3,
	0x57e8, 0x57fd, 0x5812, 0x5827, 0x583c, 0x5851, 0x5866, 0x587b,
	// Entry 7E40 - 7E7F
	0x5890, 0x58a5, 0x58ba, 0x58cf, 0x58e4, 0x58f9, 0x590e, 0x5923,
	0x5938, 0x594d, 0x5962, 0x5977, 0x598c, 0x59a1, 0x59b6, 0x59cb,
	0x59e0, 0x59f5, 0x5a0a, 0x5a1f, 0x5a34, 0x5a49, 0x5a5e, 0x5a73,
	0x5a88, 0x5a9d, 0x5ab2, 0x5ac7, 0x5adc, 0x5af1, 0x5b06, 0x5b1b,
	0x5b30, 0x5b45, 0x5b5a, 0x5b6f, 0x5b84, 0x5b99, 0x5bae, 0x5bc3,
	0x5bd8, 0x5bed, 0x5c02, 0x5c17, 0x5c2c, 0x5c41, 0x5c56, 0x5c6b,
	0x5c80, 0x5c95, 0x5caa, 0x5cbf, 0x5cd4, 0x5ce9, 0x5cfe, 0x5d13,
	0x5d28, 0x5d3d, 0x5d52, 0x5d67, 0x5d7c, 0x5d91, 0x5da6, 0x5dbb,
	// Entry 7E80 - 7EBF
	0x5dd0, 0x5de5, 0x5dfa, 0x5e0f, 0x5e24, 0x5e39, 0x5e4e, 0x5e63,
	0x5e78, 0x5e8d, 0x5ea2, 0x5eb7, 0x5ecc, 0x5ee1, 0x5ef6, 0x5f0b,
	0x5f20, 0x5f35, 0x5f4a, 0x5f5f, 0x5f74, 0x5f89, 0x5f9e, 0x5fb3,
	0x5fc8, 0x5fdd, 0x5ff2, 0x6007, 0x601c, 0x6031, 0x6046, 0x605b,
	0x6070, 0x6085, 0x609a, 0x60af, 0x60c4, 0x60d9, 0x60ee, 0x6103,
	0x6118, 0x612d, 0x6142, 0x6157, 0x616c, 0x6181, 0x6196, 0x61ab,
	0x61c0, 0x61d5, 0x61ea, 0x61ff, 0x6214, 0x6229, 0x623e, 0x6253,
	0x6268, 0x627d, 0x6292, 0x62a7, 0x62bc, 0x62d1, 0x62e6, 0x62fb,
	// Entry 7EC0 - 7EFF
	0x6310, 0x6325, 0x633a, 0x634f, 0x6364, 0x6379, 0x638e, 0x63a3,
	0x63b8, 0x63cd, 0x63e2, 0x63f7, 0x640c, 0x6421, 0x6436, 0x644b,
	0x6460, 0x6475, 0x648a, 0x649f, 0x64b4, 0x64c9, 0x64de, 0x64f3,
	0x6508, 0x651d, 0x6532, 0x6547, 0x655c, 0x6571, 0x6586, 0x659b,
	0x65b0, 0x65c5, 0x65da, 0x65ef, 0x6604, 0x6619, 0x662a, 0x663b,
	0x664c, 0x665d, 0x666e, 0x667f, 0x6690, 0x66a1, 0x66b2, 0x66c3,
	0x66d4, 0x66e5, 0x66f8, 0x670b, 0x671e, 0x6731, 0x6744, 0x6756,
	0x676e, 0x6780, 0x6792, 0x67a9, 0x67bb, 0x67cd, 0x67df, 0x67f0,
	// Entry 7F00 - 7F3F
	0x6801, 0x6812, 0x6823, 0x6836, 0x6849, 0x685c, 0x686f, 0x6889,
	0x68a3, 0x68bd, 0x68e9, 0x6903, 0x6923, 0x6936, 0x6949, 0x695c,
	0x696f, 0x6984, 0x6999, 0x69ae, 0x69c3, 0x69df, 0x69f2, 0x6a07,
	0x6a1a, 0x6a2f, 0x6a42, 0x6a57, 0x6a6a, 0x6a7f, 0x6a90, 0x6aa2,
	0x6ab5, 0x6ac8, 0x6adb, 0x6af0, 0x6b05, 0x6b18, 0x6b2d, 0x6b3e,
	0x6b56, 0x6b68, 0x6b79, 0x6b8c, 0x6b9d, 0x6bae, 0x6bc0, 0x6bd7,
	0x6be9, 0x6bfb, 0x6c13, 0x6c2d, 0x6c45, 0x6c5b, 0x6c6d, 0x6c7e,
	0x6c90, 0x6ca2, 0x6cb5, 0x6ccb, 0x6ce5, 0x6cf7, 0x6d0e, 0x6d21,
	// Entry 7F40 - 7F7F
	0x6d33, 0x6d45, 0x6d57, 0x6d69, 0x6d7b, 0x6d8e, 0x6da1, 0x6db8,
	0x6dcf, 0x6de6, 0x6dfd, 0x6e16, 0x6e2f, 0x6e47, 0x6e5f, 0x6e77,
	0x6e90, 0x6eb5, 0x6ed9, 0x6eff, 0x6f21, 0x6f43, 0x6f66, 0x6f84,
	0x6fb0, 0x6fcf, 0x6feb, 0x7009, 0x7027, 0x704b, 0x7064, 0x7083,
	0x709c, 0x70ba, 0x70d1, 0x70eb, 0x7103, 0x711b, 0x7137, 0x714f,
	0x716d, 0x7185, 0x71a2, 0x71b8, 0x71d1, 0x71e8, 0x71ff, 0x721a,
	0x7232, 0x724c, 0x726a, 0x727e, 0x72a4, 0x72c3, 0x72e6, 0x7300,
	0x7318, 0x732b, 0x7341, 0x735b, 0x7376, 0x7390, 0x73ae, 0x73ca,
	// Entry 7F80 - 7FBF
	0x73e3, 0x73ea, 0x7405, 0x741e, 0x7431, 0x7446, 0x745a, 0x746d,
	0x7481, 0x748f, 0x749d, 0x74a7, 0x74bb, 0x74cd, 0x74da, 0x74e8,
	0x7502, 0x751c, 0x752d, 0x7552, 0x757f, 0x75ac, 0x75d1, 0x75f9,
	0x762f, 0x7665, 0x767f, 0x7699, 0x76b4, 0x76ce, 0x76e9, 0x7704,
	0x7720, 0x773a, 0x7755, 0x7770, 0x778c, 0x77a7, 0x77c3, 0x77df,
	0x77fc, 0x7815, 0x7835, 0x7856, 0x7870, 0x7890, 0x78a9, 0x78c3,
	0x78e4, 0x7904, 0x791d, 0x7937, 0x7958, 0x7971, 0x7991, 0x79b2,
	0x79cc, 0x79e2, 0x79f6, 0x7a10, 0x7a28, 0x7a3b, 0x7a50, 0x7a64,
	// Entry 7FC0 - 7FFF
	0x7a78, 0x7a8c, 0x7aa1, 0x7ab9, 0x7ad4, 0x7aeb, 0x7b04, 0x7b1e,
	0x7b3a, 0x7b53, 0x7b6b, 0x7b81, 0x7b94, 0x7ba8, 0x7bbc, 0x7bd5,
	0x7bec, 0x7c06, 0x7c1f, 0x7c39, 0x7c56, 0x7c71, 0x7c8e, 0x7cae,
	0x7ccc, 0x7ce5, 0x7cfc, 0x7d16, 0x7d2f, 0x7d3d, 0x7d50, 0x7d61,
	0x7d75, 0x7d88, 0x7d99, 0x7dab, 0x7dd8, 0x7e06, 0x7e34, 0x7e62,
	0x7e74, 0x7e9a, 0x7ebe, 0x7ee5, 0x7f0b, 0x7f33, 0x7f59, 0x7f82,
	0x7faa, 0x7fc3, 0x7fda, 0x7ff4, 0x800d, 0x8028, 0x8044, 0x8063,
	0x8081, 0x809f, 0x80bb, 0x80da, 0x80f8, 0x8107, 0x8118, 0x8130,
	// Entry 8000 - 803F
	0x8149, 0x8167, 0x8182, 0x819e, 0x81c0, 0x81cf, 0x81e4, 0x8221,
	0x823b, 0x825d, 0x8281, 0x8291, 0x82a2, 0x82c2, 0x82e3, 0x82f0,
	0x8308, 0x831e, 0x8337, 0x834f, 0x8364, 0x8377, 0x8387, 0x8399,
	0x83ac, 0x83c8, 0x83e5, 0x8405, 0x8426, 0x843d, 0x8455, 0x847c,
	0x84a4, 0x84cd, 0x84f7, 0x8517, 0x8538, 0x8558, 0x8579, 0x85a1,
	0x85ca, 0x85eb, 0x860d, 0x862b, 0x864a, 0x8668, 0x8687, 0x86a8,
	0x86ca, 0x86eb, 0x870d, 0x872b, 0x874a, 0x8768, 0x8787, 0x87a6,
	0x87c6, 0x87e5, 0x8805, 0x8823, 0x8842, 0x8860, 0x887f, 0x889f,
	// Entry 8040 - 807F
	0x88c0, 0x88e0, 0x8901, 0x8921, 0x8942, 0x8962, 0x8983, 0x89a1,
	0x89c0, 0x89de, 0x89fd, 0x8a20, 0x8a44, 0x8a67, 0x8a8b, 0x8aaa,
	0x8ac9, 0x8ae8, 0x8b07, 0x8b26, 0x8b45, 0x8b64, 0x8b83, 0x8ba2,
	0x8bc1, 0x8be0, 0x8bff, 0x8c1e, 0x8c3d, 0x8c5c, 0x8c7b, 0x8c9a,
	0x8cb9, 0x8cd8, 0x8cf7, 0x8d16, 0x8d35, 0x8d54, 0x8d73, 0x8d92,
	0x8db1, 0x8dc4, 0x8dd6, 0x8de8, 0x8dfc, 0x8e0f, 0x8e22, 0x8e34,
	0x8e48, 0x8e5c, 0x8e6f, 0x8e7b, 0x8e8f, 0x8e9a, 0x8ea8, 0x8eb7,
	0x8ec7, 0x8ed5, 0x8ee4, 0x8ef4, 0x8f03, 0x8f13, 0x8f23, 0x8f31,
	// Entry 8080 - 80BF
	0x8f40, 0x8f4f, 0x8f5f, 0x8f6f, 0x8f7f, 0x8f90, 0x8f9f, 0x8faf,
	0x8fbf, 0x8fd0, 0x8fe0, 0x8ff1, 0x9002, 0x9014, 0x9022, 0x9031,
	0x9040, 0x9050, 0x905f, 0x906f, 0x907f, 0x9090, 0x90a0, 0x90b0,
	0x90c1, 0x90d1, 0x90e2, 0x90f3, 0x9105, 0x9114, 0x9124, 0x9134,
	0x9145, 0x9155, 0x9166, 0x9177, 0x9189, 0x9199, 0x91aa, 0x91bb,
	0x91cd, 0x91de, 0x91f0, 0x9202, 0x9211, 0x9220, 0x9230, 0x923f,
	0x924f, 0x925f, 0x9270, 0x927f, 0x928f, 0x929f, 0x92b0, 0x92c0,
	0x92d1, 0x92e2, 0x92f4, 0x9304, 0x9314, 0x9325, 0x9335, 0x9346,
	// Entry 80C0 - 80FF
	0x9358, 0x9368, 0x9379, 0x938b, 0x939c, 0x93ae, 0x93c0, 0x93cf,
	0x93df, 0x93ef, 0x9400, 0x9410, 0x9421, 0x9432, 0x9444, 0x9454,
	0x9465, 0x9476, 0x9488, 0x9499, 0x94ab, 0x94bd, 0x94d0, 0x94e0,
	0x94f1, 0x9502, 0x9514, 0x9525, 0x9537, 0x9549, 0x955c, 0x956d,
	0x957f, 0x9591, 0x95a4, 0x95b6, 0x95c9, 0x95dc, 0x95f0, 0x95ff,
	0x960e, 0x961e, 0x962d, 0x963d, 0x964d, 0x965e, 0x966d, 0x967d,
	0x968d, 0x969e, 0x96ae, 0x96bf, 0x96d0, 0x96e2, 0x96f1, 0x9701,
	0x9711, 0x9722, 0x9732, 0x9743, 0x9754, 0x9766, 0x9776, 0x9787,
	// Entry 8100 - 813F
	0x9798, 0x97aa, 0x97bb, 0x97cd, 0x97df, 0x97f2, 0x9802, 0x9812,
	0x9823, 0x9833, 0x9844, 0x9856, 0x9866, 0x9877, 0x9889, 0x989a,
	0x98ac, 0x98be, 0x98ce, 0x98df, 0x98f0, 0x9902, 0x9913, 0x9925,
	0x9937, 0x994a, 0x995b, 0x996d, 0x997f, 0x9992, 0x99a4, 0x99b7,
	0x99ca, 0x99de, 0x99ee, 0x99fe, 0x9a0f, 0x9a1f, 0x9a30, 0x9a41,
	0x9a53, 0x9a63, 0x9a74, 0x9a85, 0x9a97, 0x9aa8, 0x9aba, 0x9acc,
	0x9adf, 0x9aef, 0x9b00, 0x9b11, 0x9b23, 0x9b34, 0x9b46, 0x9b58,
	0x9b6b, 0x9b7c, 0x9b8e, 0x9ba0, 0x9bb3, 0x9bc5, 0x9bd8, 0x9beb,
	// Entry 8140 - 817F
	0x9bff, 0x9c0f, 0x9c20, 0x9c31, 0x9c43, 0x9c54, 0x9c66, 0x9c78,
	0x9c8b, 0x9c9c, 0x9cae, 0x9cc0, 0x9cd3, 0x9ce5, 0x9cf8, 0x9d0b,
	0x9d1f, 0x9d31, 0x9d43, 0x9d56, 0x9d68, 0x9d7b, 0x9d8f, 0x9da1,
	0x9db4, 0x9dc8, 0x9ddc, 0x9df0, 0x9e08, 0x9e23, 0x9e47, 0x9e6e,
	0x9e92, 0x9eb9, 0x9edc, 0x9f02, 0x9f25, 0x9f4b, 0x9f69, 0x9f92,
	0x9fbb, 0x9fe4, 0xa00d, 0xa018, 0xa037, 0xa056, 0xa06c, 0xa082,
	0xa09c, 0xa0ac, 0xa0be, 0xa0cf, 0xa0e0, 0xa0f1, 0xa116, 0xa13c,
	0xa150, 0xa16d, 0xa18a, 0xa1bf, 0xa1eb, 0xa216, 0xa21c, 0xa263,
	// Entry 8180 - 81BF
	0xa2aa, 0xa2c1, 0xa2d9, 0xa2f9, 0xa31a, 0xa338, 0xa367, 0xa397,
	0xa3bc, 0xa3ea, 0xa418, 0xa43b, 0xa464, 0xa490, 0xa4b8, 0xa4e3,
	0xa502, 0xa524, 0xa543, 0xa565, 0xa57e, 0xa597, 0xa5c0, 0xa5e7,
	0xa60b, 0xa630, 0xa650, 0xa66a, 0xa68d, 0xa6b0, 0xa6d9, 0xa6ee,
	0xa723, 0xa748, 0xa76d, 0xa792, 0xa7c0, 0xa7dc, 0xa803, 0xa82a,
	0xa846, 0xa862, 0xa88c, 0xa8b2, 0xa8da, 0xa90a, 0xa93d, 0xa962,
	0xa985, 0xa9a9, 0xa9c8, 0xa9ea, 0xaa09, 0xaa2b, 0xaa54, 0xaa70,
	0xaa97, 0xaab7, 0xaada, 0xab04, 0xab27, 0xab3f, 0xab59, 0xab70,
	// Entry 81C0 - 81FF
	0xab88, 0xaba1, 0xabbb, 0xabd2, 0xabea, 0xac01, 0xac19, 0xac32,
	0xac4b, 0xac65, 0xac7e, 0xac98, 0xacb2, 0xaccd, 0xace6, 0xad00,
	0xad1a, 0xad35, 0xad4f, 0xad6a, 0xad85, 0xada1, 0xadba, 0xadd4,
	0xadee, 0xae09, 0xae23, 0xae3e, 0xae59, 0xae75, 0xae8f, 0xaeaa,
	0xaec5, 0xaee1, 0xaefc, 0xaf18, 0xaf34, 0xaf51, 0xaf6a, 0xaf84,
	0xaf9e, 0xafb9, 0xafd3, 0xafee, 0xb009, 0xb025, 0xb03f, 0xb05a,
	0xb075, 0xb091, 0xb0ac, 0xb0c8, 0xb0e4, 0xb101, 0xb11b, 0xb136,
	0xb151, 0xb16d, 0xb188, 0xb1a4, 0xb1c0, 0xb1dd, 0xb1f8, 0xb214,
	// Entry 8200 - 823F
	0xb230, 0xb24d, 0xb269, 0xb286, 0xb2a3, 0xb2c1, 0xb2df, 0xb304,
	0xb32a, 0xb349, 0xb36e, 0xb39a, 0xb3c7, 0xb3ed, 0xb412, 0xb43e,
	0xb46b, 0xb491, 0xb4af, 0xb4d4, 0xb4fa, 0xb519, 0xb53b, 0xb567,
	0xb592, 0xb5b3, 0xb5d4, 0xb5ff, 0xb62a, 0xb64b, 0xb66c, 0xb697,
	0xb6c3, 0xb6e5, 0xb707, 0xb733, 0xb75f, 0xb781, 0xb797, 0xb79e,
	0xb7d8, 0xb7f2, 0xb800, 0xb816, 0xb821, 0xb82d, 0xb83a, 0xb84b,
	0xb84f, 0xb853, 0xb858, 0xb85d, 0xb867, 0xb86f, 0xb875, 0xb87a,
	0xb881, 0xb887, 0xb88d, 0xb896, 0xb89d, 0xb8c8, 0xb8cf, 0xb8d9,
	// Entry 8240 - 827F
	0xb8e2, 0xb8fa, 0xb914, 0xb92a, 0xb948, 0xb95f, 0xb97a, 0xb995,
	0xb9b4, 0xb9cd, 0xb9e4, 0xb9fc, 0xba13, 0xba31, 0xba46, 0xba65,
	0xba79, 0xbaa6, 0xbadd, 0xbb0c, 0xbb31, 0xbb5e, 0xbb83, 0xbba9,
	0xbbd5, 0xbbfc, 0xbc22, 0xbc59, 0xbc8b, 0xbcbc, 0xbcf4, 0xbd24,
	0xbd4a, 0xbd78, 0xbd9e, 0xbdc5, 0xbdf2, 0xbe1a, 0xbe41, 0xbe79,
	0xbeac, 0xbede, 0xbf05, 0xbf33, 0xbf5f, 0xbf88, 0xbfaf, 0xbfd7,
	0xc003, 0xc029, 0xc045, 0xc05f, 0xc07c, 0xc09b, 0xc0ba, 0xc0d8,
	0xc0f9, 0xc116, 0xc135, 0xc153, 0xc170, 0xc18d, 0xc1ac, 0xc1d1,
	// Entry 8280 - 82BF
	0xc1fc, 0xc226, 0xc253, 0xc274, 0xc2a1, 0xc2c1, 0xc2e3, 0xc31a,
	0xc339, 0xc360, 0xc380, 0xc3a7, 0xc3c5, 0xc3e7, 0xc411, 0xc434,
	0xc451, 0xc47f, 0xc4a0, 0xc4c1, 0xc4e9, 0xc508, 0xc525, 0xc539,
	0xc553, 0xc56a, 0xc585, 0xc59a, 0xc5b1, 0xc5c8, 0xc5e8, 0xc600,
	0xc627, 0xc653, 0xc66c, 0xc680, 0xc698, 0xc6b6, 0xc6d4, 0xc6f4,
	0xc713, 0xc735, 0xc755, 0xc776, 0xc796, 0xc7b9, 0xc7e5, 0xc812,
	0xc83e, 0xc86d, 0xc88c, 0xc8ae, 0xc8c5, 0xc8db, 0xc8f1, 0xc90a,
	0xc92c, 0xc94d, 0xc971, 0xc991, 0xc9b2, 0xc9df, 0xca0d, 0xca39,
	// Entry 82C0 - 82FF
	0xca67, 0xca95, 0xcac9, 0xcafa, 0xcb12, 0xcb35, 0xcb56, 0xcb78,
	0xcb8c, 0xcb9e, 0xcbb1, 0xcbc6, 0xcbdc, 0xcbf1, 0xcc11, 0xcc30,
	0xcc5a, 0xcc84, 0xcca3, 0xcccd, 0xccea, 0xcd12, 0xcd40, 0xcd59,
	0xcd7d, 0xcd9b, 0xcdbf, 0xcddf, 0xce02, 0xce21, 0xce45, 0xce6b,
	0xce96, 0xcebb, 0xcedd, 0xcf07, 0xcf30, 0xcf5e, 0xcf93, 0xcfc7,
	0xd001, 0xd01f, 0xd043, 0xd07d, 0xd0a2, 0xd0d1, 0xd0e6, 0xd103,
	0xd123, 0xd147, 0xd170, 0xd194, 0xd1b9, 0xd1de, 0xd1f2, 0xd20f,
	0xd22f, 0xd257, 0xd280, 0xd2af, 0xd2cf, 0xd2f9, 0xd338, 0xd37d,
	// Entry 8300 - 833F
	0xd3a6, 0xd3d5, 0xd41a, 0xd44a, 0xd484, 0xd4ac, 0xd4c2, 0xd4d7,
	0xd4ea, 0xd4fe, 0xd511, 0xd52f, 0xd54e, 0xd572, 0xd59c, 0xd5c0,
	0xd5eb, 0xd610, 0xd631, 0xd653, 0xd677, 0xd699, 0xd6c1, 0xd6e2,
	0xd70c, 0xd734, 0xd753, 0xd775, 0xd798, 0xd7c1, 0xd7e1, 0xd7ff,
	0xd827, 0xd84f, 0xd86e, 0xd88f, 0xd8ad, 0xd8d3, 0xd8fc, 0xd927,
	0xd948, 0xd969, 0xd992, 0xd9ba, 0xd9e3, 0xda0d, 0xda2e, 0xda4d,
	0xda6b, 0xda93, 0xdab3, 0xdad8, 0xdaf7, 0xdb20, 0xdb4d, 0xdb78,
	0xdb96, 0xdbb4, 0xdbd0, 0xdbed, 0xdc0d, 0xdc2f, 0xdc55, 0xdc7d,
	// Entry 8340 - 837F
	0xdc9f, 0xdcc9, 0xdcf1, 0xdd12, 0xdd34, 0xdd55, 0xdd7f, 0xdd9f,
	0xddcc, 0xddf9, 0xde19, 0xde36, 0xde56, 0xde7c, 0xdea2, 0xdec7,
	0xdeec, 0xdf0d, 0xdf30, 0xdf52, 0xdf72, 0xdf93, 0xdfbb, 0xdfe3,
	0xe008, 0xe032, 0xe05a, 0xe079, 0xe0a0, 0xe0d1, 0xe0f1, 0xe119,
	0xe139, 0xe159, 0xe17d, 0xe1a0, 0xe1c3, 0xe1e9, 0xe208, 0xe22b,
	0xe24b, 0xe273, 0xe29b, 0xe2c6, 0xe2e6, 0xe30e, 0xe333, 0xe356,
	0xe37a, 0xe398, 0xe3bd, 0xe3de, 0xe401, 0xe426, 0xe44f, 0xe477,
	0xe49e, 0xe4c9, 0xe4f5, 0xe51c, 0xe544, 0xe56b, 0xe591, 0xe5be,
	// Entry 8380 - 83BF
	0xe5e4, 0xe60c, 0xe634, 0xe659, 0xe682, 0xe6a4, 0xe6c6, 0xe6e8,
	0xe709, 0xe729, 0xe74c, 0xe773, 0xe79c, 0xe7c1, 0xe7e5, 0xe80a,
	0xe827, 0xe845, 0xe864, 0xe885, 0xe8a5, 0xe8d1, 0xe8fc, 0xe929,
	0xe959, 0xe988, 0xe9af, 0xe9e5, 0xea18, 0xea39, 0xea76, 0xeab2,
	0xeae7, 0xeb09, 0xeb27, 0xeb4a, 0xeb6a, 0xeb92, 0xebb9, 0xebdc,
	0xec01, 0xec24, 0xec48, 0xec70, 0xec99, 0xecc7, 0xecfa, 0xed2a,
	0xed5f, 0xed8d, 0xedb8, 0xede8, 0xee20, 0xee4f, 0xee7e, 0xeeae,
	0xeee2, 0xef10, 0xef3d, 0xef68, 0xef95, 0xefc7, 0xefff, 0xf02b,
	// Entry 83C0 - 83FF
	0xf058, 0xf087, 0xf0a8, 0xf0cb, 0xf102, 0xf12e, 0xf15c, 0xf186,
	0xf1b2, 0xf1e5, 0xf211, 0xf23d, 0xf26e, 0xf29e, 0xf2d5, 0xf30e,
	0xf342, 0xf377, 0xf39d, 0xf3c1, 0xf3e6, 0xf40b, 0xf441, 0xf475,
	0xf4a0, 0xf4cb, 0xf4f8, 0xf529, 0xf565, 0xf59a, 0xf5d2, 0xf603,
	0xf63f, 0xf674, 0xf6ac, 0xf6d2, 0xf6f8, 0xf724, 0xf751, 0xf778,
	0xf7a1, 0xf7ca, 0xf7fb, 0xf82d, 0xf861, 0xf889, 0xf8b9, 0xf8ea,
	0xf91d, 0xf941, 0xf966, 0xf985, 0xf9a8, 0xf9cc, 0xf9ef, 0xfa12,
	0xfa35, 0xfa58, 0xfa7b, 0xfaa6, 0xfacf, 0xfafa, 0xfb23, 0xfb47,
	// Entry 8400 - 843F
	0xfb6f, 0xfb8c, 0xfba9, 0xfbc5, 0xfbe9, 0xfc06, 0xfc22, 0xfc41,
	0xfc61, 0xfc7b, 0xfc93, 0xfca9, 0xfcbd, 0xfcd0, 0xfcf0, 0xfd10,
	0xfd30, 0xfd46, 0xfd62, 0xfd7c, 0xfd92, 0xfda6, 0xfdbc, 0xfdd9,
	0xfdf6, 0xfe15, 0xfe33, 0xfe51, 0xfe6e, 0xfe91, 0xfeb5, 0xfeca,
	0xfeeb, 0xff0d, 0xff22, 0xff37, 0xff58, 0xff7a, 0xff94, 0xffae,
	0xffd2, 0xffed, 0x0007, 0x001d, 0x0035, 0x004e, 0x0069, 0x0080,
	0x0099, 0x00ba, 0x00da, 0x00f4, 0x010b, 0x0125, 0x0140, 0x0160,
	0x0181, 0x019a, 0x01b3, 0x01cb, 0x01e6, 0x0200, 0x021d, 0x023e,
	// Entry 8440 - 847F
	0x025e, 0x028b, 0x02a4, 0x02c0, 0x02e0, 0x0304, 0x0328, 0x0351,
	0x037a, 0x03a5, 0x03d0, 0x03fc, 0x0428, 0x0453, 0x047e, 0x04ad,
	0x04dc, 0x04fe, 0x0520, 0x0551, 0x0582, 0x05a5, 0x05c1, 0x05de,
	0x05fa, 0x061f, 0x0644, 0x0658, 0x0671, 0x0689, 0x06a4, 0x06be,
	0x06db, 0x06fc, 0x071c, 0x0749, 0x0766, 0x0790, 0x07b2, 0x07d4,
	0x07f6, 0x0817, 0x0838, 0x0859, 0x0882, 0x08a1, 0x08c0, 0x08df,
	0x08fe, 0x091d, 0x0936, 0x094d, 0x0965, 0x097b, 0x0994, 0x09ab,
	0x09c6, 0x09df, 0x09fe, 0x0a1f, 0x0a3e, 0x0a64, 0x0a84, 0x0aad,
	// Entry 8480 - 84BF
	0x0ad5, 0x0af3, 0x0b0f, 0x0b2d, 0x0b4a, 0x0b66, 0x0b83, 0x0ba1,
	0x0bbe, 0x0be4, 0x0c0a, 0x0c24, 0x0c39, 0x0c49, 0x0c5d, 0x0c71,
	0x0c85, 0x0c9d, 0x0cb7, 0x0cd6, 0x0cf8, 0x0d09, 0x0d1c, 0x0d38,
	0x0d51, 0x0d67, 0x0d87, 0x0da7, 0x0dc7, 0x0de7, 0x0e07, 0x0e27,
	0x0e47, 0x0e67, 0x0e87, 0x0ea8, 0x0ec9, 0x0ee3, 0x0efd, 0x0f19,
	0x0f34, 0x0f55, 0x0f74, 0x0f95, 0x0fbc, 0x0fd5, 0x0ff1, 0x100f,
	0x102a, 0x1047, 0x1066, 0x1079, 0x1090, 0x10a5, 0x10b9, 0x10ce,
	0x10ed, 0x110c, 0x1121, 0x113c, 0x115b, 0x117a, 0x1193, 0x11ac,
	// Entry 84C0 - 84FF
	0x11ce, 0x11f2, 0x120c, 0x122a, 0x1244, 0x1262, 0x1299, 0x12d2,
	0x1316, 0x134f, 0x138a, 0x13d2, 0x141a, 0x1462, 0x1476, 0x1495,
	0x14b4, 0x14cb, 0x14df, 0x14f5, 0x150a, 0x1522, 0x1539, 0x1550,
	0x1568, 0x1587, 0x15a6, 0x15c7, 0x15e4, 0x1600, 0x1622, 0x1642,
	0x1667, 0x1687, 0x16a6, 0x16d2, 0x16fc, 0x1727, 0x1750, 0x176f,
	0x1782, 0x1796, 0x17b3, 0x17d0, 0x17ed, 0x180a, 0x1827, 0x1844,
	0x1861, 0x187e, 0x189b, 0x18b9, 0x18d7, 0x18f5, 0x1913, 0x1931,
	0x194f, 0x196d, 0x198b, 0x19a9, 0x19c7, 0x19e5, 0x1a03, 0x1a21,
	// Entry 8500 - 853F
	0x1a3f, 0x1a5d, 0x1a7b, 0x1a99, 0x1ab7, 0x1ad5, 0x1af3, 0x1b17,
	0x1b3b, 0x1b5f, 0x1b83, 0x1ba7, 0x1bcb, 0x1bf0, 0x1c15, 0x1c3a,
	0x1c5f, 0x1c84, 0x1ca9, 0x1cce, 0x1cf3, 0x1d18, 0x1d3d, 0x1d62,
	0x1d87, 0x1dac, 0x1dd1, 0x1df6, 0x1e1b, 0x1e40, 0x1e65, 0x1e8a,
	0x1eaf, 0x1ed4, 0x1ef9, 0x1f1e, 0x1f43, 0x1f68, 0x1f8d, 0x1fb2,
	0x1fd7, 0x1ffc, 0x2021, 0x2046, 0x2065, 0x2086, 0x20a7, 0x20bb,
	0x20d0, 0x20e4, 0x20f8, 0x210e, 0x2123, 0x2138, 0x214c, 0x2162,
	0x2178, 0x218d, 0x21a1, 0x21b8, 0x21cf, 0x21e8, 0x2201, 0x2219,
	// Entry 8540 - 857F
	0x2231, 0x224b, 0x2264, 0x227d, 0x228f, 0x22a0, 0x22b1, 0x22c4,
	0x22d6, 0x22e8, 0x22f9, 0x230c, 0x231f, 0x2331, 0x2342, 0x2356,
	0x236a, 0x2380, 0x2396, 0x23ab, 0x23c0, 0x23d7, 0x23ed, 0x2403,
	0x2415, 0x242e, 0x2444, 0x245d, 0x2475, 0x2485, 0x2499, 0x24b2,
	0x24c5, 0x24da, 0x24f5, 0x250e, 0x2522, 0x253a, 0x2555, 0x257e,
	0x2596, 0x25b0, 0x25c6, 0x25df, 0x25f2, 0x2607, 0x2621, 0x2636,
	0x264d, 0x2662, 0x2677, 0x268f, 0x26a1, 0x26b2, 0x26ca, 0x26e1,
	0x26f5, 0x2709, 0x2723, 0x2740, 0x2755, 0x2769, 0x2780, 0x2795,
	// Entry 8580 - 85BF
	0x27ac, 0x27c2, 0x27d6, 0x27ec, 0x2803, 0x281d, 0x2833, 0x284e,
	0x2866, 0x2879, 0x2890, 0x28a9, 0x28be, 0x28d2, 0x28e6, 0x2907,
	0x291e, 0x2933, 0x2949, 0x295c, 0x2976, 0x2990, 0x29a9, 0x29c3,
	0x29d8, 0x29f2, 0x2a0d, 0x2a20, 0x2a33, 0x2a48, 0x2a5b, 0x2a72,
	0x2a89, 0x2a9e, 0x2ab6, 0x2acd, 0x2ae3, 0x2af9, 0x2b11, 0x2b26,
	0x2b3b, 0x2b54, 0x2b6c, 0x2b86, 0x2ba0, 0x2bb7, 0x2bce, 0x2be9,
	0x2c04, 0x2c21, 0x2c3d, 0x2c59, 0x2c74, 0x2c91, 0x2cae, 0x2cca,
	0x2ce5, 0x2d00, 0x2d1d, 0x2d39, 0x2d55, 0x2d70, 0x2d8d, 0x2daa,
	// Entry 85C0 - 85FF
	0x2dc6, 0x2de0, 0x2dfa, 0x2e16, 0x2e31, 0x2e4c, 0x2e5a, 0x2e69,
	0x2e84, 0x2e9f, 0x2eba, 0x2ed5, 0x2ef0, 0x2f0b, 0x2f26, 0x2f41,
	0x2f5c, 0x2f77, 0x2f92, 0x2fad, 0x2fc8, 0x2fe3, 0x2ffe, 0x3019,
	0x3034, 0x304f, 0x306a, 0x3085, 0x30a0, 0x30bb, 0x30d6, 0x30f1,
	0x310c, 0x3127, 0x3140, 0x3159, 0x3172, 0x318b, 0x31a4, 0x31bd,
	0x31d6, 0x31ef, 0x3208, 0x3221, 0x323a, 0x3253, 0x326c, 0x3285,
	0x329e, 0x32b7, 0x32d0, 0x32e9, 0x3302, 0x331b, 0x3334, 0x334d,
	0x3366, 0x337f, 0x3398, 0x33b1, 0x33ce, 0x33eb, 0x3408, 0x3425,
	// Entry 8600 - 863F
	0x3442, 0x345f, 0x347c, 0x3499, 0x34b6, 0x34d3, 0x34f0, 0x350d,
	0x352a, 0x3547, 0x3564, 0x3581, 0x359e, 0x35bb, 0x35d8, 0x35f5,
	0x3612, 0x362f, 0x364c, 0x3669, 0x3686, 0x36a3, 0x36be, 0x36d9,
	0x36f4, 0x370f, 0x372a, 0x3745, 0x3760, 0x377b, 0x3796, 0x37b1,
	0x37cc, 0x37e7, 0x3802, 0x381d, 0x3838, 0x3853, 0x386e, 0x3889,
	0x38a4, 0x38bf, 0x38da, 0x38f5, 0x3910, 0x392b, 0x3946, 0x3968,
	0x398a, 0x39ac, 0x39ce, 0x39f0, 0x3a12, 0x3a34, 0x3a56, 0x3a78,
	0x3a9a, 0x3abc, 0x3ade, 0x3b00, 0x3b22, 0x3b44, 0x3b66, 0x3b88,
	// Entry 8640 - 867F
	0x3baa, 0x3bcc, 0x3bee, 0x3c10, 0x3c32, 0x3c54, 0x3c76, 0x3c98,
	0x3cba, 0x3cda, 0x3cfa, 0x3d1a, 0x3d3a, 0x3d5a, 0x3d7a, 0x3d9a,
	0x3dba, 0x3dda, 0x3dfa, 0x3e1a, 0x3e3a, 0x3e5a, 0x3e7a, 0x3e9a,
	0x3eba, 0x3eda, 0x3efa, 0x3f1a, 0x3f3a, 0x3f5a, 0x3f7a, 0x3f9a,
	0x3fba, 0x3fda, 0x3ffa, 0x4017, 0x4034, 0x4051, 0x406e, 0x408b,
	0x40a8, 0x40c5, 0x40e2, 0x40ff, 0x411c, 0x4139, 0x4156, 0x4173,
	0x4190, 0x41ad, 0x41ca, 0x41e7, 0x4204, 0x421f, 0x423a, 0x4255,
	0x4270, 0x428b, 0x42a6, 0x42c1, 0x42dc, 0x42f7, 0x4312, 0x432d,
	// Entry 8680 - 86BF
	0x4348, 0x4363, 0x437e, 0x4399, 0x43b4, 0x43cf, 0x43ea, 0x4405,
	0x4420, 0x443b, 0x4456, 0x4471, 0x4493, 0x44b5, 0x44d7, 0x44f9,
	0x451b, 0x453d, 0x455f, 0x4581, 0x45a3, 0x45c5, 0x45e7, 0x4609,
	0x462b, 0x464d, 0x466f, 0x4691, 0x46b3, 0x46d5, 0x46f7, 0x4719,
	0x473b, 0x475d, 0x477f, 0x47a1, 0x47c3, 0x47e5, 0x4805, 0x4825,
	0x4845, 0x4865, 0x4885, 0x48a5, 0x48c5, 0x48e5, 0x4905, 0x4925,
	0x4945, 0x4965, 0x4985, 0x49a5, 0x49c5, 0x49e5, 0x4a05, 0x4a25,
	0x4a45, 0x4a65, 0x4a85, 0x4aa5, 0x4ac5, 0x4ae5, 0x4b05, 0x4b25,
	// Entry 86C0 - 86FF
	0x4b43, 0x4b61, 0x4b7f, 0x4b9d, 0x4bbb, 0x4bd9, 0x4bf7, 0x4c15,
	0x4c33, 0x4c51, 0x4c6f, 0x4c8d, 0x4cab, 0x4cc9, 0x4ce7, 0x4d05,
	0x4d23, 0x4d41, 0x4d5f, 0x4d7d, 0x4d9b, 0x4db7, 0x4dd3, 0x4def,
	0x4e0b, 0x4e27, 0x4e43, 0x4e5f, 0x4e7b, 0x4e97, 0x4eb3, 0x4ecf,
	0x4eeb, 0x4f07, 0x4f23, 0x4f3f, 0x4f5b, 0x4f77, 0x4f93, 0x4faf,
	0x4fcb, 0x4fe7, 0x5003, 0x501f, 0x503b, 0x5057, 0x5073, 0x5097,
	0x50bb, 0x50df, 0x5103, 0x5127, 0x514b, 0x516f, 0x5193, 0x51b7,
	0x51db, 0x51ff, 0x5223, 0x5247, 0x526b, 0x528f, 0x52b3, 0x52d7,
	// Entry 8700 - 873F
	0x52fb, 0x531f, 0x5341, 0x5363, 0x5385, 0x53a7, 0x53c9, 0x53eb,
	0x540d, 0x542f, 0x5451, 0x5473, 0x5495, 0x54b7, 0x54d9, 0x54fb,
	0x551d, 0x553f, 0x5561, 0x5583, 0x55a5, 0x55c7, 0x55e9, 0x560b,
	0x562d, 0x564f, 0x5671, 0x5693, 0x56b6, 0x56d9, 0x56fc, 0x571f,
	0x5742, 0x5765, 0x5788, 0x57ab, 0x57ce, 0x57f1, 0x5814, 0x5837,
	0x585a, 0x587d, 0x58a0, 0x58c3, 0x58e6, 0x5909, 0x592c, 0x594f,
	0x5972, 0x5995, 0x59b8, 0x59db, 0x59fe, 0x5a21, 0x5a42, 0x5a63,
	0x5a84, 0x5aa5, 0x5ac6, 0x5ae7, 0x5b08, 0x5b29, 0x5b4a, 0x5b6b,
	// Entry 8740 - 877F
	0x5b8c, 0x5bad, 0x5bce, 0x5bef, 0x5c10, 0x5c31, 0x5c52, 0x5c73,
	0x5c94, 0x5cb5, 0x5cd6, 0x5cf7, 0x5d18, 0x5d39, 0x5d5a, 0x5d7b,
	0x5d9c, 0x5dbd, 0x5dde, 0x5dff, 0x5e20, 0x5e41, 0x5e62, 0x5e83,
	0x5ea4, 0x5ec5, 0x5ee6, 0x5f07, 0x5f28, 0x5f49, 0x5f6a, 0x5f8b,
	0x5fac, 0x5fcd, 0x5fee, 0x600f, 0x6030, 0x6051, 0x6072, 0x6093,
	0x60b4, 0x60d5, 0x60f4, 0x6113, 0x6132, 0x6151, 0x6170, 0x618f,
	0x61ae, 0x61cd, 0x61ec, 0x620b, 0x622a, 0x6249, 0x6268, 0x6287,
	0x62a6, 0x62c5, 0x62e4, 0x6303, 0x6322, 0x6341, 0x6360, 0x637f,
	// Entry 8780 - 87BF
	0x639e, 0x63bd, 0x63dc, 0x63fb, 0x6421, 0x6447, 0x646d, 0x6493,
	0x64b9, 0x64df, 0x6505, 0x652b, 0x6551, 0x6577, 0x659d, 0x65c3,
	0x65e9, 0x660f, 0x6635, 0x665b, 0x6681, 0x66a7, 0x66cd, 0x66f3,
	0x6719, 0x673f, 0x6765, 0x678b, 0x67b1, 0x67d7, 0x67fb, 0x681f,
	0x6843, 0x6867, 0x688b, 0x68af, 0x68d3, 0x68f7, 0x691b, 0x693f,
	0x6963, 0x6987, 0x69ab, 0x69cf, 0x69f3, 0x6a17, 0x6a3b, 0x6a5f,
	0x6a83, 0x6aa7, 0x6acb, 0x6aef, 0x6b13, 0x6b37, 0x6b5b, 0x6b7f,
	0x6ba7, 0x6bcf, 0x6bf7, 0x6c1f, 0x6c47, 0x6c6f, 0x6c97, 0x6cbf,
	// Entry 87C0 - 87FF
	0x6ce7, 0x6d0f, 0x6d37, 0x6d5f, 0x6d87, 0x6daf, 0x6dd7, 0x6dff,
	0x6e27, 0x6e4f, 0x6e77, 0x6e9f, 0x6ec7, 0x6eef, 0x6f17, 0x6f3f,
	0x6f67, 0x6f8f, 0x6fb5, 0x6fdb, 0x7001, 0x7027, 0x704d, 0x7073,
	0x7099, 0x70bf, 0x70e5, 0x710b, 0x7131, 0x7157, 0x717d, 0x71a3,
	0x71c9, 0x71ef, 0x7215, 0x723b, 0x7261, 0x7287, 0x72ad, 0x72d3,
	0x72f9, 0x731f, 0x7345, 0x736b, 0x7398, 0x73c5, 0x73f2, 0x741f,
	0x744c, 0x7479, 0x74a6, 0x74d3, 0x7500, 0x752d, 0x755a, 0x7587,
	0x75b4, 0x75e1, 0x760e, 0x763b, 0x7668, 0x7695, 0x76c2, 0x76ef,
	// Entry 8800 - 883F
	0x771c, 0x7749, 0x7776, 0x77a3, 0x77d0, 0x77fd, 0x7828, 0x7853,
	0x787e, 0x78a9, 0x78d4, 0x78ff, 0x792a, 0x7955, 0x7980, 0x79ab,
	0x79d6, 0x7a01, 0x7a2c, 0x7a57, 0x7a82, 0x7aad, 0x7ad8, 0x7b03,
	0x7b2e, 0x7b59, 0x7b84, 0x7baf, 0x7bda, 0x7c05, 0x7c30, 0x7c5b,
	0x7c7b, 0x7c9b, 0x7cbb, 0x7cdb, 0x7cfb, 0x7d1b, 0x7d3b, 0x7d5b,
	0x7d7b, 0x7d9b, 0x7dbb, 0x7ddb, 0x7dfb, 0x7e1b, 0x7e3b, 0x7e5b,
	0x7e7b, 0x7e9b, 0x7ebb, 0x7edb, 0x7efb, 0x7f1b, 0x7f3b, 0x7f5b,
	0x7f7b, 0x7f9b, 0x7fb9, 0x7fd7, 0x7ff5, 0x8013, 0x8031, 0x804f,
	// Entry 8840 - 887F
	0x806d, 0x808b, 0x80a9, 0x80c7, 0x80e5, 0x8103, 0x8121, 0x813f,
	0x815d, 0x817b, 0x8199, 0x81b7, 0x81d5, 0x81f3, 0x8211, 0x822f,
	0x824d, 0x826b, 0x8289, 0x82a7, 0x82ca, 0x82ed, 0x830c, 0x832a,
	0x8349, 0x8368, 0x8389, 0x83a7, 0x83c4, 0x83e3, 0x8401, 0x8420,
	0x843f, 0x845b, 0x8477, 0x8493, 0x84b4, 0x84d0, 0x84ed, 0x8513,
	0x8532, 0x854f, 0x8570, 0x858d, 0x85aa, 0x85c7, 0x85e6, 0x85fd,
	0x861a, 0x8636, 0x8653, 0x8670, 0x868f, 0x86ab, 0x86c6, 0x86e3,
	0x86ff, 0x871c, 0x8739, 0x8753, 0x876d, 0x8787, 0x87a6, 0x87c0,
	// Entry 8880 - 88BF
	0x87db, 0x87fe, 0x881b, 0x8836, 0x8855, 0x8870, 0x888b, 0x88a6,
	0x88c3, 0x88e9, 0x8909, 0x8927, 0x8945, 0x8961, 0x897d, 0x8998,
	0x89b9, 0x89d9, 0x89fa, 0x8a1b, 0x8a3e, 0x8a5e, 0x8a7d, 0x8a9e,
	0x8abe, 0x8adf, 0x8b00, 0x8b1e, 0x8b3c, 0x8b5a, 0x8b7d, 0x8b9b,
	0x8bba, 0x8be2, 0x8c03, 0x8c22, 0x8c45, 0x8c64, 0x8c83, 0x8ca2,
	0x8cc3, 0x8cdc, 0x8cfb, 0x8d19, 0x8d38, 0x8d57, 0x8d78, 0x8d96,
	0x8db3, 0x8dd2, 0x8df0, 0x8e0f, 0x8e2e, 0x8e4a, 0x8e66, 0x8e82,
	0x8ea3, 0x8ebf, 0x8edc, 0x8f01, 0x8f20, 0x8f3d, 0x8f5e, 0x8f7b,
	// Entry 88C0 - 88FF
	0x8f98, 0x8fb5, 0x8fd4, 0x8ffc, 0x901e, 0x903e, 0x905e, 0x907c,
	0x909a, 0x90b7, 0x90dd, 0x9102, 0x9128, 0x914e, 0x9176, 0x919b,
	0x91bf, 0x91e5, 0x920a, 0x9230, 0x9256, 0x9279, 0x929c, 0x92bf,
	0x92e7, 0x930a, 0x932e, 0x935b, 0x9381, 0x93a5, 0x93cd, 0x93f1,
	0x9415, 0x9439, 0x945f, 0x947d, 0x94a1, 0x94c4, 0x94e8, 0x950c,
	0x9532, 0x9555, 0x9577, 0x959b, 0x95be, 0x95e2, 0x9606, 0x9627,
	0x9648, 0x9669, 0x968f, 0x96b0, 0x96d2, 0x96fc, 0x9720, 0x9742,
	0x9768, 0x978a, 0x97ac, 0x97ce, 0x97f2, 0x981f, 0x9846, 0x986b,
	// Entry 8900 - 893F
	0x9890, 0x98b3, 0x98d6, 0x98f8, 0x9922, 0x994b, 0x9975, 0x999f,
	0x99cb, 0x99f4, 0x9a1c, 0x9a46, 0x9a6f, 0x9a99, 0x9ac3, 0x9aea,
	0x9b11, 0x9b38, 0x9b64, 0x9b8b, 0x9bb3, 0x9be4, 0x9c0e, 0x9c36,
	0x9c62, 0x9c8a, 0x9cb2, 0x9cda, 0x9d04, 0x9d26, 0x9d4e, 0x9d75,
	0x9d9d, 0x9dc5, 0x9def, 0x9e16, 0x9e3c, 0x9e64, 0x9e8b, 0x9eb3,
	0x9edb, 0x9f00, 0x9f25, 0x9f4a, 0x9f74, 0x9f99, 0x9fbf, 0x9fed,
	0xa015, 0xa03b, 0xa065, 0xa08b, 0xa0b1, 0xa0d7, 0xa0ff, 0xa130,
	0xa15b, 0xa184, 0xa1ad, 0xa1d4, 0xa1fb, 0xa221, 0xa252, 0xa282,
	// Entry 8940 - 897F
	0xa2b3, 0xa2e4, 0xa317, 0xa347, 0xa376, 0xa3a7, 0xa3d7, 0xa408,
	0xa439, 0xa467, 0xa495, 0xa4c3, 0xa4f6, 0xa524, 0xa553, 0xa58b,
	0xa5bc, 0xa5eb, 0xa61e, 0xa64d, 0xa67c, 0xa6ab, 0xa6dc, 0xa705,
	0xa734, 0xa762, 0xa791, 0xa7c0, 0xa7f1, 0xa81f, 0xa84c, 0xa87b,
	0xa8a9, 0xa8d8, 0xa907, 0xa933, 0xa95f, 0xa98b, 0xa9bc, 0xa9e8,
	0xaa15, 0xaa4a, 0xaa79, 0xaaa6, 0xaad7, 0xab04, 0xab31, 0xab5e,
	0xab8d, 0xabc5, 0xabf7, 0xac27, 0xac57, 0xac85, 0xacb3, 0xace0,
	0xad01, 0xad20, 0xad3c, 0xad57, 0xad72, 0xad8f, 0xadab, 0xadc7,
	// Entry 8980 - 89BF
	0xade2, 0xadff, 0xae1c, 0xae38, 0xae5d, 0xae81, 0xaea5, 0xaecb,
	0xaef0, 0xaf15, 0xaf39, 0xaf5f, 0xaf85, 0xafaa, 0xafcc, 0xafed,
	0xb00e, 0xb031, 0xb053, 0xb075, 0xb096, 0xb0b9, 0xb0dc, 0xb0fe,
	0xb125, 0xb14b, 0xb171, 0xb199, 0xb1c0, 0xb1e7, 0xb20d, 0xb235,
	0xb25d, 0xb284, 0xb2a5, 0xb2c5, 0xb2e5, 0xb307, 0xb328, 0xb349,
	0xb369, 0xb38b, 0xb3ad, 0xb3ce, 0xb3e9, 0xb406, 0xb420, 0xb43b,
	0xb457, 0xb473, 0xb493, 0xb4b5, 0xb4e1, 0xb50b, 0xb52d, 0xb54f,
	0xb575, 0xb598, 0xb5ba, 0xb5de, 0xb605, 0xb637, 0xb660, 0xb68c,
	// Entry 89C0 - 89FF
	0xb6b8, 0xb6e4, 0xb71b, 0xb753, 0xb786, 0xb7b9, 0xb7e3, 0xb80f,
	0xb83b, 0xb867, 0xb88f, 0xb8b9, 0xb8ef, 0xb925, 0xb952, 0xb98d,
	0xb9c4, 0xba00, 0xba37, 0xba71, 0xbaa0, 0xbad0, 0xbaff, 0xbb2e,
	0xbb67, 0xbb9e, 0xbbdf, 0xbc1b, 0xbc4d, 0xbc7f, 0xbcbd, 0xbcf2,
	0xbd2c, 0xbd6d, 0xbd9f, 0xbdd1, 0xbe04, 0xbe3b, 0xbe71, 0xbea6,
	0xbed9, 0xbf12, 0xbf45, 0xbf74, 0xbfaa, 0xbfe5, 0xc017, 0xc04d,
	0xc06f, 0xc096, 0xc0bf, 0xc0eb, 0xc11d, 0xc149, 0xc17a, 0xc1a7,
	0xc1d0, 0xc1fe, 0xc231, 0xc269, 0xc297, 0xc2ca, 0xc301, 0xc329,
	// Entry 8A00 - 8A3F
	0xc356, 0xc385, 0xc3ae, 0xc3de, 0xc419, 0xc452, 0xc467, 0xc491,
	0xc4ab, 0xc4cb, 0xc4f0, 0xc510, 0xc533, 0xc55f, 0xc581, 0xc5ae,
	0xc5e0, 0xc602, 0xc617, 0xc637, 0xc655, 0xc678, 0xc696, 0xc6ab,
	0xc6c4, 0xc6d8, 0xc6fc, 0xc71b, 0xc73d, 0xc75a, 0xc781, 0xc7a3,
	0xc7c1, 0xc7da, 0xc7f1, 0xc806, 0xc826, 0xc844, 0xc867, 0xc882,
	0xc8ab, 0xc8c1, 0xc8dd, 0xc903, 0xc924, 0xc948, 0xc967, 0xc997,
	0xc9c7, 0xc9dd, 0xca04, 0xca2d, 0xca55, 0xca7d, 0xca9a, 0xcac6,
	0xcaf7, 0xcb29, 0xcb4a, 0xcb7b, 0xcbaa, 0xcbda, 0xcbf9, 0xcc24,
	// Entry 8A40 - 8A7F
	0xcc45, 0xcc64, 0xcc84, 0xccaf, 0xccd0, 0xccfa, 0xcd1c, 0xcd3f,
	0xcd67, 0xcd90, 0xcdc9, 0xcdfe, 0xce20, 0xce44, 0xce67, 0xce8a,
	0xceb3, 0xcede, 0xcf08, 0xcf23, 0xcf4d, 0xcf7c, 0xcfad, 0xcfcc,
	0xd004, 0xd03d, 0xd05a, 0xd083, 0xd0a4, 0xd0c7, 0xd0e8, 0xd10a,
	0xd12b, 0xd156, 0xd187, 0xd1a7, 0xd1c7, 0xd1e7, 0xd20e, 0xd237,
	0xd265, 0xd290, 0xd2ba, 0xd2e7, 0xd30d, 0xd335, 0xd361, 0xd389,
	0xd3aa, 0xd3c7, 0xd3e6, 0xd407, 0xd432, 0xd45c, 0xd47e, 0xd4a7,
	0xd4ca, 0xd4f2, 0xd51c, 0xd54b, 0xd572, 0xd59b, 0xd5c8, 0xd5f4,
	// Entry 8A80 - 8ABF
	0xd61d, 0xd64c, 0xd67e, 0xd6b5, 0xd6eb, 0xd720, 0xd752, 0xd775,
	0xd79b, 0xd7c2, 0xd7f7, 0xd82d, 0xd85e, 0xd88f, 0xd8bf, 0xd8f1,
	0xd929, 0xd95d, 0xd983, 0xd9ad, 0xd9e1, 0xda15, 0xda48, 0xda70,
	0xda90, 0xdab5, 0xdadc, 0xdb04, 0xdb26, 0xdb4e, 0xdb74, 0xdb99,
	0xdbbb, 0xdbd6, 0xdbf6, 0xdc1f, 0xdc49, 0xdc6e, 0xdc91, 0xdcc1,
	0xdcf0, 0xdd1f, 0xdd4c, 0xdd78, 0xdda7, 0xddd5, 0xde0a, 0xde1f,
	0xde39, 0xde51, 0xde6b, 0xde84, 0xde9c, 0xdeb6, 0xdecf, 0xdee8,
	0xdf03, 0xdf1d, 0xdf35, 0xdf4f, 0xdf68, 0xdf7e, 0xdf96, 0xdfad,
	// Entry 8AC0 - 8AFF
	0xdfc8, 0xdfe3, 0xe003, 0xe023, 0xe045, 0xe067, 0xe085, 0xe0a3,
	0xe0c1, 0xe0e1, 0xe101, 0xe11d, 0xe142, 0xe16a, 0xe192, 0xe1ba,
	0xe1e4, 0xe218, 0xe24c, 0xe27c, 0xe2a9, 0xe2d7, 0xe30b, 0xe340,
	0xe374, 0xe3aa, 0xe3da, 0xe408, 0xe438, 0xe469, 0xe4a5, 0xe4c9,
	0xe500, 0xe530, 0xe561, 0xe59d, 0xe5c6, 0xe5f0, 0xe619, 0xe644,
	0xe670, 0xe69b, 0xe6c9, 0xe6f3, 0xe71e, 0xe748, 0xe770, 0xe799,
	0xe7c1, 0xe7ec, 0xe818, 0xe843, 0xe86d, 0xe898, 0xe8c2, 0xe8f8,
	0xe92e, 0xe969, 0xe9a0, 0xe9d7, 0xea13, 0xea37, 0xea65, 0xea93,
	// Entry 8B00 - 8B3F
	0xeac1, 0xeae9, 0xeb12, 0xeb3a, 0xeb64, 0xeb8f, 0xebbb, 0xebe6,
	0xec13, 0xec43, 0xec74, 0xeca4, 0xecd6, 0xed09, 0xed3d, 0xed70,
	0xeda5, 0xedda, 0xee10, 0xee45, 0xee7c, 0xeead, 0xeedc, 0xef0d,
	0xef3f, 0xef7c, 0xefa1, 0xefd9, 0xf00a, 0xf045, 0xf082, 0xf0a6,
	0xf0d2, 0xf0ff, 0xf12b, 0xf150, 0xf179, 0xf1a3, 0xf1cc, 0xf1f8,
	0xf225, 0xf251, 0xf27c, 0xf2a8, 0xf2d3, 0xf30b, 0xf343, 0xf380,
	0xf3b7, 0xf3ee, 0xf42a, 0xf44f, 0xf481, 0xf4b4, 0xf4e6, 0xf51a,
	0xf550, 0xf587, 0xf5bd, 0xf5f5, 0xf634, 0xf674, 0xf69d, 0xf6c7,
	// Entry 8B40 - 8B7F
	0xf6f0, 0xf719, 0xf743, 0xf76c, 0xf79c, 0xf7d2, 0xf809, 0xf83f,
	0xf875, 0xf8ac, 0xf8e2, 0xf914, 0xf945, 0xf977, 0xf99c, 0xf9c1,
	0xf9e9, 0xfa0f, 0xfa46, 0xfa7c, 0xfab2, 0xfae8, 0xfb20, 0xfb58,
	0xfb95, 0xfbc7, 0xfbf8, 0xfc29, 0xfc5a, 0xfc8d, 0xfcc0, 0xfcf8,
	0xfd2f, 0xfd67, 0xfd9e, 0xfdd9, 0xfe14, 0xfe55, 0xfe96, 0xfed7,
	0xff18, 0xff59, 0xff9a, 0xffdb, 0x001c, 0x0056, 0x0090, 0x00c6,
	0x00fc, 0x0137, 0x0170, 0x01a9, 0x01e8, 0x0227, 0x026d, 0x02b3,
	0x02f2, 0x0331, 0x0370, 0x03af, 0x03e7, 0x041f, 0x0453, 0x0487,
	// Entry 8B80 - 8BBF
	0x04c0, 0x04eb, 0x0517, 0x0542, 0x056f, 0x059d, 0x05c7, 0x05f1,
	0x061b, 0x0645, 0x066f, 0x0695, 0x06bb, 0x06e6, 0x0716, 0x074c,
	0x0783, 0x07b9, 0x07f0, 0x0834, 0x0879, 0x08bd, 0x0901, 0x0946,
	0x098a, 0x09c2, 0x09fa, 0x0a3a, 0x0a7a, 0x0aae, 0x0ae2, 0x0b24,
	0x0b66, 0x0b89, 0x0bac, 0x0bc4, 0x0bdc, 0x0bf5, 0x0c10, 0x0c30,
	0x0c5c, 0x0c80, 0x0c9b, 0x0cab, 0x0cbf, 0x0ceb, 0x0d13, 0x0d40,
	0x0d69, 0x0d93, 0x0db3, 0x0deb, 0x0e1e, 0x0e59, 0x0e79, 0x0e9e,
	0x0ec0, 0x0ee8, 0x0f10, 0x0f36, 0x0f5c, 0x0f78, 0x0f94, 0x0fb1,
	// Entry 8BC0 - 8BFF
	0x0fc6, 0x0fdf, 0x0ff6, 0x1012, 0x1030, 0x104a, 0x1064, 0x1080,
	0x10a2, 0x10b6, 0x10ce, 0x10e8, 0x1108, 0x112e, 0x115b, 0x118d,
	0x11b4, 0x11e2, 0x1215, 0x1239, 0x125e, 0x1284, 0x129d, 0x12b7,
	0x12d0, 0x12ed, 0x130c, 0x1328, 0x1338, 0x1350, 0x1368, 0x1381,
	0x1399, 0x13b4, 0x13ce, 0x13f2, 0x1416, 0x142f, 0x1448, 0x1468,
	0x1488, 0x14a8, 0x14bf, 0x14df, 0x14fb, 0x1512, 0x1532, 0x154e,
	0x156b, 0x1589, 0x15a8, 0x15c3, 0x15e7, 0x1607, 0x1627, 0x1650,
	0x1675, 0x168b, 0x16a9, 0x16c8, 0x16df, 0x16fe, 0x171c, 0x173d,
	// Entry 8C00 - 8C3F
	0x175d, 0x177d, 0x1796, 0x17b7, 0x17d8, 0x17fb, 0x181a, 0x183d,
	0x1869, 0x1890, 0x18b6, 0x18dc, 0x1902, 0x1913, 0x192d, 0x1948,
	0x196c, 0x1985, 0x19a7, 0x19c2, 0x19e4, 0x1a07, 0x1a17, 0x1a27,
	0x1a3d, 0x1a5b, 0x1a7d, 0x1aa4, 0x1acc, 0x1af3, 0x1b1f, 0x1b46,
	0x1b6b, 0x1b99, 0x1bb5, 0x1bce, 0x1be7, 0x1c00, 0x1c19, 0x1c32,
	0x1c4b, 0x1c64, 0x1c76, 0x1c9a, 0x1cbf, 0x1cda, 0x1cf4, 0x1d0e,
	0x1d2c, 0x1d46, 0x1d67, 0x1d78, 0x1d8d, 0x1da2, 0x1db3, 0x1dca,
	0x1de5, 0x1e00, 0x1e1b, 0x1e36, 0x1e51, 0x1e70, 0x1e8f, 0x1eae,
	// Entry 8C40 - 8C7F
	0x1ecd, 0x1eec, 0x1f0b, 0x1f2a, 0x1f49, 0x1f69, 0x1f89, 0x1fa9,
	0x1fc9, 0x1fe9, 0x2009, 0x2029, 0x2053, 0x2077, 0x209a, 0x20b7,
	0x20dd, 0x2108, 0x212d, 0x214c, 0x2188, 0x21b9, 0x21e9, 0x220f,
	0x223e, 0x2263, 0x228f, 0x22b1, 0x22d4, 0x22f6, 0x2327, 0x2356,
	0x237e, 0x23ab, 0x23de, 0x240f, 0x2437, 0x246a, 0x249d, 0x24c5,
	0x24f8, 0x2520, 0x253e, 0x256c, 0x259a, 0x25c8, 0x25f6, 0x2624,
	0x2652, 0x2671, 0x2691, 0x26b1, 0x26d4, 0x26f5, 0x2716, 0x2739,
	0x275b, 0x277b, 0x27a3, 0x27c0, 0x27e2, 0x2802, 0x2825, 0x2848,
	// Entry 8C80 - 8CBF
	0x2869, 0x2888, 0x28aa, 0x28cb, 0x28ec, 0x290e, 0x292d, 0x294e,
	0x296e, 0x298e, 0x29ad, 0x29cf, 0x29ee, 0x2a0e, 0x2a2e, 0x2a4e,
	0x2a6c, 0x2a91, 0x2aaf, 0x2adc, 0x2aff, 0x2b2a, 0x2b4a, 0x2b6a,
	0x2b8b, 0x2bac, 0x2bce, 0x2bef, 0x2c10, 0x2c32, 0x2c53, 0x2c73,
	0x2c94, 0x2cb5, 0x2cd6, 0x2cf6, 0x2d17, 0x2d38, 0x2d59, 0x2d7a,
	0x2d9a, 0x2dbb, 0x2ddc, 0x2dfe, 0x2e20, 0x2e42, 0x2e65, 0x2e85,
	0x2ea6, 0x2ec9, 0x2eed, 0x2f24, 0x2f45, 0x2f6c, 0x2f95, 0x2fbc,
	0x2fdd, 0x2fff, 0x3021, 0x3044, 0x3066, 0x3088, 0x30ab, 0x30cd,
	// Entry 8CC0 - 8CFF
	0x30ee, 0x3110, 0x3132, 0x3153, 0x3175, 0x3197, 0x31b8, 0x31da,
	0x31fc, 0x321f, 0x3242, 0x3265, 0x328e, 0x32b2, 0x32e1, 0x3319,
	0x333c, 0x3360, 0x3390, 0x33c1, 0x33f6, 0x342e, 0x344e, 0x346f,
	0x3490, 0x34b0, 0x34d0, 0x34f0, 0x3510, 0x3531, 0x3551, 0x3571,
	0x3591, 0x35b1, 0x35d2, 0x35f4, 0x3614, 0x3634, 0x3655, 0x3676,
	0x3696, 0x36b8, 0x36d9, 0x36f9, 0x3719, 0x3739, 0x3759, 0x377a,
	0x379a, 0x37bb, 0x37dc, 0x37fd, 0x381f, 0x3840, 0x3861, 0x3882,
	0x38a2, 0x38c3, 0x38e2, 0x3902, 0x3921, 0x3940, 0x395f, 0x397f,
	// Entry 8D00 - 8D3F
	0x399e, 0x39be, 0x39dd, 0x39fa, 0x3a17, 0x3a34, 0x3a51, 0x3a6e,
	0x3a8b, 0x3aa8, 0x3ace, 0x3af3, 0x3b1b, 0x3b41, 0x3b6d, 0x3b8e,
	0x3bb8, 0x3bd9, 0x3bf9, 0x3c19, 0x3c3b, 0x3c5c, 0x3c7d, 0x3c9d,
	0x3cbf, 0x3ce1, 0x3d02, 0x3d26, 0x3d47, 0x3d55, 0x3d63, 0x3d71,
	0x3d7f, 0x3d8d, 0x3d9b, 0x3da9, 0x3db7, 0x3dc6, 0x3dd4, 0x3de3,
	0x3df1, 0x3dff, 0x3e0d, 0x3e1b, 0x3e29, 0x3e37, 0x3e44, 0x3e59,
	0x3e67, 0x3e7d, 0x3e8a, 0x3e97, 0x3eac, 0x3eba, 0x3ed0, 0x3edd,
	0x3eeb, 0x3f01, 0x3f0e, 0x3f23, 0x3f33, 0x3f42, 0x3f52, 0x3f62,
	// Entry 8D40 - 8D7F
	0x3f72, 0x3f82, 0x3f92, 0x3fa3, 0x3fb3, 0x3fc3, 0x3fd3, 0x3fe3,
	0x3ff4, 0x4004, 0x4014, 0x4025, 0x4035, 0x4045, 0x4055, 0x4065,
	0x4075, 0x4084, 0x4094, 0x40a4, 0x40b4, 0x40c5, 0x40d5, 0x40e4,
	0x40f3, 0x4104, 0x4113, 0x4125, 0x4136, 0x4147, 0x4158, 0x416a,
	0x417b, 0x418c, 0x419c, 0x41ac, 0x41bd, 0x41ce, 0x41df, 0x41f0,
	0x41ff, 0x4210, 0x421f, 0x4230, 0x4241, 0x4251, 0x4261, 0x4273,
	0x4284, 0x4295, 0x42a5, 0x42b7, 0x42c9, 0x42da, 0x42ea, 0x42fe,
	0x4313, 0x4328, 0x433d, 0x4353, 0x4367, 0x437c, 0x4391, 0x43a7,
	// Entry 8D80 - 8DBF
	0x43bc, 0x43d0, 0x43e5, 0x43fb, 0x4410, 0x4425, 0x4439, 0x444e,
	0x4463, 0x4478, 0x448d, 0x44a1, 0x44b7, 0x44cc, 0x44e1, 0x44f6,
	0x450c, 0x4522, 0x4537, 0x454d, 0x4563, 0x4578, 0x458e, 0x45a4,
	0x45b9, 0x45ce, 0x45e5, 0x45fb, 0x4611, 0x4626, 0x463d, 0x4654,
	0x466a, 0x467a, 0x468b, 0x469d, 0x46af, 0x46c0, 0x46d1, 0x46e1,
	0x46f2, 0x4703, 0x4714, 0x4725, 0x4736, 0x4746, 0x4757, 0x4768,
	0x477a, 0x478b, 0x479c, 0x47ac, 0x47bd, 0x47cf, 0x47e0, 0x47f2,
	0x4803, 0x4813, 0x4824, 0x4835, 0x4846, 0x4858, 0x4869, 0x4878,
	// Entry 8DC0 - 8DFF
	0x4889, 0x489d, 0x48af, 0x48c0, 0x48d1, 0x48e4, 0x48f6, 0x4908,
	0x4919, 0x492c, 0x493f, 0x4951, 0x496a, 0x497e, 0x4993, 0x49a8,
	0x49be, 0x49ce, 0x49df, 0x49ef, 0x4a03, 0x4a18, 0x4a2d, 0x4a43,
	0x4a53, 0x4a67, 0x4a7c, 0x4a8d, 0x4a9d, 0x4aad, 0x4ac1, 0x4ad6,
	0x4ae7, 0x4afb, 0x4b10, 0x4b20, 0x4b30, 0x4b40, 0x4b50, 0x4b64,
	0x4b79, 0x4b89, 0x4b9e, 0x4bb4, 0x4bc4, 0x4bd3, 0x4be3, 0x4bf1,
	0x4c00, 0x4c10, 0x4c1e, 0x4c2d, 0x4c3c, 0x4c4c, 0x4c5d, 0x4c6d,
	0x4c7d, 0x4c8e, 0x4c9c, 0x4cab, 0x4cbb, 0x4ccb, 0x4cdb, 0x4ceb,
	// Entry 8E00 - 8E3F
	0x4cfb, 0x4d09, 0x4d1d, 0x4d2b, 0x4d41, 0x4d57, 0x4d6d, 0x4d84,
	0x4d9b, 0x4db1, 0x4dc7, 0x4de4, 0x4dfa, 0x4e11, 0x4e27, 0x4e43,
	0x4e60, 0x4e7c, 0x4e99, 0x4eb5, 0x4ed1, 0x4eee, 0x4f0a, 0x4f27,
	0x4f43, 0x4f5f, 0x4f7c, 0x4f98, 0x4fb4, 0x4fd1, 0x4fed, 0x500a,
	0x5028, 0x5046, 0x5064, 0x5083, 0x50a1, 0x50c0, 0x50de, 0x50fd,
	0x511b, 0x5139, 0x5157, 0x5176, 0x5194, 0x51b3, 0x51d1, 0x51f0,
	0x520f, 0x522e, 0x524d, 0x526c, 0x528b, 0x52aa, 0x52c9, 0x52e8,
	0x5307, 0x5327, 0x5347, 0x5365, 0x5383, 0x53a1, 0x53c0, 0x53de,
	// Entry 8E40 - 8E7F
	0x53fd, 0x541b, 0x5438, 0x5455, 0x5472, 0x5490, 0x54ad, 0x54cb,
	0x54e8, 0x5506, 0x5524, 0x5542, 0x5560, 0x557e, 0x559c, 0x55ba,
	0x55d8, 0x55f7, 0x5615, 0x5634, 0x5652, 0x5671, 0x568f, 0x56ad,
	0x56cb, 0x56ea, 0x5708, 0x5727, 0x5745, 0x5768, 0x5786, 0x57a4,
	0x57c2, 0x57e1, 0x5800, 0x581e, 0x583c, 0x585a, 0x5878, 0x5897,
	0x58b5, 0x58d4, 0x58f2, 0x5910, 0x592e, 0x594c, 0x596b, 0x5989,
	0x59a8, 0x59c6, 0x59e9, 0x5a07, 0x5a25, 0x5a43, 0x5a62, 0x5a80,
	0x5a9f, 0x5abd, 0x5adb, 0x5af9, 0x5b17, 0x5b36, 0x5b54, 0x5b73,
	// Entry 8E80 - 8EBF
	0x5b91, 0x5bb0, 0x5bcf, 0x5bee, 0x5c0d, 0x5c2c, 0x5c4b, 0x5c6a,
	0x5c88, 0x5ca6, 0x5cc4, 0x5ce3, 0x5d01, 0x5d20, 0x5d3e, 0x5d5e,
	0x5d7e, 0x5d9d, 0x5dbc, 0x5ddb, 0x5dfa, 0x5e19, 0x5e39, 0x5e59,
	0x5e79, 0x5e99, 0x5eba, 0x5eda, 0x5efb, 0x5f1b, 0x5f3c, 0x5f5d,
	0x5f82, 0x5fa8, 0x5fcd, 0x5feb, 0x6009, 0x6027, 0x6046, 0x6066,
	0x6086, 0x60a6, 0x60c6, 0x60e7, 0x6105, 0x6123, 0x6141, 0x6160,
	0x617e, 0x619d, 0x61bb, 0x61da, 0x61f9, 0x6218, 0x6238, 0x6258,
	0x6277, 0x6297, 0x62b6, 0x62d6, 0x62fa, 0x631f, 0x6343, 0x6362,
	// Entry 8EC0 - 8EFF
	0x6381, 0x63a0, 0x63c0, 0x63df, 0x63ff, 0x641e, 0x643d, 0x645c,
	0x647b, 0x649b, 0x64ba, 0x64da, 0x64f9, 0x6517, 0x6536, 0x6555,
	0x6574, 0x6594, 0x65b3, 0x65d3, 0x65f2, 0x6611, 0x6630, 0x6650,
	0x6670, 0x668e, 0x66ac, 0x66ca, 0x66e9, 0x6707, 0x6726, 0x6744,
	0x6764, 0x6784, 0x67a4, 0x67c4, 0x67e4, 0x67fb, 0x6812, 0x682b,
	0x6843, 0x685b, 0x6872, 0x688b, 0x68a4, 0x68bc, 0x68e0, 0x6903,
	0x692a, 0x6952, 0x697e, 0x69ae, 0x69d5, 0x69ee, 0x6a08, 0x6a21,
	0x6a3a, 0x6a51, 0x6a70, 0x6a87, 0x6a9f, 0x6ab6, 0x6acc, 0x6ae3,
	// Entry 8F00 - 8F3F
	0x6af9, 0x6b0f, 0x6b27, 0x6b3f, 0x6b57, 0x6b6f, 0x6b87, 0x6b9e,
	0x6bb4, 0x6bcd, 0x6be5, 0x6bfc, 0x6c15, 0x6c2c, 0x6c44, 0x6c5b,
	0x6c73, 0x6c8a, 0x6ca2, 0x6cba, 0x6cd2, 0x6cea, 0x6d02, 0x6d19,
	0x6d31, 0x6d48, 0x6d5f, 0x6d74, 0x6d91, 0x6da6, 0x6dbc, 0x6dd1,
	0x6de5, 0x6dfa, 0x6e0e, 0x6e22, 0x6e38, 0x6e4e, 0x6e64, 0x6e7a,
	0x6e90, 0x6ea5, 0x6eb9, 0x6ed0, 0x6ee6, 0x6efb, 0x6f12, 0x6f27,
	0x6f3d, 0x6f52, 0x6f68, 0x6f7d, 0x6f93, 0x6fa9, 0x6fbf, 0x6fd5,
	0x6feb, 0x7000, 0x7016, 0x702b, 0x7036, 0x704e, 0x706f, 0x707a,
	// Entry 8F40 - 8F7F
	0x7091, 0x70a1, 0x70b0, 0x70bf, 0x70d0, 0x70e0, 0x70f0, 0x70ff,
	0x7110, 0x7121, 0x7131, 0x714f, 0x716a, 0x7180, 0x7196, 0x71ae,
	0x71c5, 0x71dc, 0x71f2, 0x720a, 0x7222, 0x7239, 0x724f, 0x7268,
	0x7281, 0x7299, 0x72b1, 0x72c9, 0x72e3, 0x72fc, 0x7315, 0x7333,
	0x7351, 0x7371, 0x7390, 0x73af, 0x73cd, 0x73ed, 0x740d, 0x742c,
	0x744b, 0x746a, 0x748b, 0x74ab, 0x74cb, 0x74ea, 0x750b, 0x752c,
	0x754c, 0x756b, 0x758d, 0x75af, 0x75d0, 0x75f1, 0x7612, 0x7635,
	0x7657, 0x7679, 0x7690, 0x76a9, 0x76be, 0x76d6, 0x76f0, 0x770f,
	// Entry 8F80 - 8FBF
	0x772e, 0x774f, 0x776f, 0x778f, 0x77ae, 0x77cf, 0x77f0, 0x7810,
	0x7827, 0x7847, 0x7864, 0x7887, 0x789d, 0x78bd, 0x78dd, 0x7906,
	0x7925, 0x793d, 0x7955, 0x796f, 0x7988, 0x79a1, 0x79b9, 0x79d3,
	0x79ed, 0x7a06, 0x7a1e, 0x7a39, 0x7a54, 0x7a6e, 0x7a88, 0x7aa2,
	0x7abe, 0x7ad9, 0x7af4, 0x7b14, 0x7b34, 0x7b56, 0x7b77, 0x7b98,
	0x7bb8, 0x7bda, 0x7bfc, 0x7c1d, 0x7c3e, 0x7c5f, 0x7c82, 0x7ca4,
	0x7cc6, 0x7ce7, 0x7d0a, 0x7d2d, 0x7d4f, 0x7d70, 0x7d94, 0x7db8,
	0x7ddb, 0x7dfe, 0x7e21, 0x7e46, 0x7e6a, 0x7e8e, 0x7ea4, 0x7ec6,
	// Entry 8FC0 - 8FFF
	0x7eea, 0x7f0d, 0x7f30, 0x7f52, 0x7f76, 0x7f9a, 0x7fbd, 0x7fdf,
	0x800a, 0x8034, 0x805f, 0x808a, 0x80a9, 0x80c9, 0x80e1, 0x80f8,
	0x8110, 0x8127, 0x813e, 0x8156, 0x816d, 0x8184, 0x819b, 0x81b2,
	0x81c9, 0x81e1, 0x81f9, 0x8211, 0x8228, 0x823f, 0x8256, 0x826d,
	0x8284, 0x829d, 0x82b4, 0x82cc, 0x82e4, 0x82fc, 0x8313, 0x832a,
	0x8343, 0x8362, 0x8382, 0x83a1, 0x83c0, 0x83df, 0x83ff, 0x841e,
	0x843d, 0x845c, 0x847b, 0x849a, 0x84ba, 0x84da, 0x84fa, 0x8519,
	0x8538, 0x8557, 0x8576, 0x8597, 0x85b6, 0x85d6, 0x85f6, 0x8615,
	// Entry 9000 - 903F
	0x8636, 0x8655, 0x8673, 0x8691, 0x86af, 0x86ce, 0x86ed, 0x870b,
	0x8729, 0x8747, 0x8767, 0x8786, 0x87a4, 0x87c4, 0x87eb, 0x8811,
	0x8832, 0x8854, 0x8875, 0x8896, 0x88b7, 0x88d8, 0x88f9, 0x891b,
	0x893d, 0x895f, 0x8980, 0x89a1, 0x89c2, 0x89e3, 0x8a06, 0x8a27,
	0x8a49, 0x8a6b, 0x8a8c, 0x8aad, 0x8ad0, 0x8af9, 0x8b22, 0x8b41,
	0x8b5f, 0x8b7e, 0x8b9c, 0x8bba, 0x8bd8, 0x8bf7, 0x8c15, 0x8c33,
	0x8c51, 0x8c6f, 0x8c8e, 0x8cad, 0x8ccc, 0x8cea, 0x8d08, 0x8d26,
	0x8d44, 0x8d62, 0x8d82, 0x8da0, 0x8dbf, 0x8dde, 0x8dfd, 0x8e1b,
	// Entry 9040 - 907F
	0x8e39, 0x8e59, 0x8e7e, 0x8ea4, 0x8ec9, 0x8eee, 0x8f14, 0x8f39,
	0x8f5e, 0x8f83, 0x8fa8, 0x8fce, 0x8ff4, 0x901a, 0x903f, 0x9064,
	0x9089, 0x90ae, 0x90d3, 0x90fa, 0x911f, 0x9145, 0x916b, 0x9191,
	0x91b6, 0x91db, 0x9202, 0x9239, 0x9262, 0x9278, 0x928f, 0x92a5,
	0x92bc, 0x92d3, 0x92ec, 0x9305, 0x9323, 0x9341, 0x9361, 0x9380,
	0x939f, 0x93bd, 0x93dd, 0x93fd, 0x941c, 0x9437, 0x9452, 0x946f,
	0x948b, 0x94a7, 0x94c2, 0x94df, 0x94fc, 0x9518, 0x9533, 0x954e,
	0x956b, 0x9587, 0x95a3, 0x95be, 0x95db, 0x95f8, 0x9614, 0x9625,
	// Entry 9080 - 90BF
	0x9638, 0x964b, 0x9665, 0x9678, 0x968b, 0x969e, 0x96b1, 0x96c3,
	0x96d4, 0x96ef, 0x970b, 0x9727, 0x9743, 0x975f, 0x977b, 0x9797,
	0x97b3, 0x97cf, 0x97eb, 0x9807, 0x9823, 0x983f, 0x985b, 0x9877,
	0x9893, 0x98af, 0x98cb, 0x98e7, 0x9903, 0x991f, 0x993b, 0x9957,
	0x9973, 0x998f, 0x99ab, 0x99c7, 0x99e3, 0x99ff, 0x9a1b, 0x9a37,
	0x9a53, 0x9a6f, 0x9a8b, 0x9aa7, 0x9ac3, 0x9adf, 0x9afb, 0x9b17,
	0x9b33, 0x9b4f, 0x9b6b, 0x9b87, 0x9ba3, 0x9bbf, 0x9bdb, 0x9bf7,
	0x9c13, 0x9c2f, 0x9c4b, 0x9c64, 0x9c7e, 0x9c98, 0x9cb2, 0x9ccc,
	// Entry 90C0 - 90FF
	0x9ce6, 0x9d00, 0x9d1a, 0x9d34, 0x9d4e, 0x9d68, 0x9d82, 0x9d9c,
	0x9db6, 0x9dd0, 0x9dea, 0x9e04, 0x9e1e, 0x9e38, 0x9e52, 0x9e6c,
	0x9e86, 0x9ea0, 0x9eba, 0x9ed4, 0x9eee, 0x9f08, 0x9f22, 0x9f3c,
	0x9f56, 0x9f70, 0x9f8a, 0x9fa4, 0x9fbe, 0x9fd8, 0x9ff2, 0xa00c,
	0xa026, 0xa040, 0xa05a, 0xa074, 0xa08e, 0xa0a8, 0xa0c2, 0xa0dc,
	0xa0f6, 0xa110, 0xa12a, 0xa144, 0xa15e, 0xa16f, 0xa189, 0xa1a3,
	0xa1bf, 0xa1da, 0xa1f5, 0xa20f, 0xa22b, 0xa247, 0xa262, 0xa27c,
	0xa297, 0xa2b4, 0xa2d0, 0xa2eb, 0xa305, 0xa31f, 0xa33b, 0xa356,
	// Entry 9100 - 913F
	0xa371, 0xa38b, 0xa3a7, 0xa3c3, 0xa3de, 0xa3f8, 0xa413, 0xa430,
	0xa44c, 0xa467, 0xa47d, 0xa499, 0xa4b5, 0xa4d3, 0xa4f0, 0xa50d,
	0xa529, 0xa547, 0xa565, 0xa582, 0xa59e, 0xa5bb, 0xa5da, 0xa5f8,
	0xa615, 0xa62d, 0xa646, 0xa65f, 0xa67a, 0xa694, 0xa6ae, 0xa6c7,
	0xa6e2, 0xa6fd, 0xa717, 0xa730, 0xa74a, 0xa766, 0xa781, 0xa79b,
	0xa7b3, 0xa7c4, 0xa7d8, 0xa7ec, 0xa800, 0xa814, 0xa828, 0xa83c,
	0xa850, 0xa864, 0xa878, 0xa88d, 0xa8a2, 0xa8b7, 0xa8cc, 0xa8e1,
	0xa8f6, 0xa90b, 0xa920, 0xa935, 0xa94a, 0xa95f, 0xa974, 0xa988,
	// Entry 9140 - 917F
	0xa998, 0xa9a7, 0xa9b6, 0xa9c7, 0xa9d7, 0xa9e7, 0xa9f6, 0xaa07,
	0xaa18, 0xaa28, 0xaa4d, 0xaa7b, 0xaa92, 0xaaad, 0xaad8, 0xaafc,
	0xab20, 0xab44, 0xab68, 0xab8c, 0xabb0, 0xabd4, 0xabf8, 0xac1c,
	0xac40, 0xac64, 0xac88, 0xacac, 0xacd0, 0xacf4, 0xad18, 0xad3c,
	0xad60, 0xad84, 0xada8, 0xadcc, 0xadf0, 0xae14, 0xae38, 0xae5c,
	0xae80, 0xaeaf, 0xaed4, 0xaef9, 0xaf03, 0xaf0d, 0xaf1c, 0xaf3a,
	0xaf58, 0xaf76, 0xaf94, 0xafb2, 0xafd0, 0xafee, 0xb00c, 0xb02a,
	0xb048, 0xb066, 0xb084, 0xb0a2, 0xb0c0, 0xb0de, 0xb0fc, 0xb11a,
	// Entry 9180 - 91BF
	0xb138, 0xb156, 0xb174, 0xb192, 0xb1b0, 0xb1ce, 0xb1ec, 0xb20a,
	0xb228, 0xb232, 0xb23c, 0xb246, 0xb250, 0xb25b, 0xb265, 0xb28c,
	0xb2b3, 0xb2da, 0xb301, 0xb328, 0xb34f, 0xb376, 0xb39d, 0xb3c4,
	0xb3eb, 0xb412, 0xb439, 0xb460, 0xb487, 0xb4ae, 0xb4d5, 0xb4fc,
	0xb523, 0xb54a, 0xb571, 0xb598, 0xb5bf, 0xb5e6, 0xb60d, 0xb634,
	0xb65b, 0xb669, 0xb677, 0xb685, 0xb68f, 0xb6b0, 0xb6c4, 0xb6eb,
	0xb712, 0xb739, 0xb760, 0xb787, 0xb7ae, 0xb7d5, 0xb7fc, 0xb823,
	0xb84a, 0xb871, 0xb898, 0xb8bf, 0xb8e6, 0xb90d, 0xb934, 0xb95b,
	// Entry 91C0 - 91FF
	0xb982, 0xb9a9, 0xb9d0, 0xb9f7, 0xba1e, 0xba45, 0xba6c, 0xba93,
	0xbaba, 0xbae9, 0xbafc, 0xbb0f, 0xbb22, 0xbb35, 0xbb48, 0xbb51,
	0xbb5b, 0xbb67, 0xbb73, 0xbb7d, 0xbb88, 0xbb92, 0xbb9c, 0xbba7,
	0xbbc7, 0xbbd1, 0xbbe0, 0xbbf5, 0xbc02, 0xbc10, 0xbc1f, 0xbc35,
	0xbc4c, 0xbc68, 0xbc77, 0xbc93, 0xbcaf, 0xbcb9, 0xbcc4, 0xbcd2,
	0xbce2, 0xbced, 0xbcf8, 0xbd03, 0xbd13, 0xbd35, 0xbd57, 0xbd79,
	0xbd9b, 0xbdbd, 0xbddf, 0xbe01, 0xbe23, 0xbe45, 0xbe67, 0xbe89,
	0xbeab, 0xbecd, 0xbeef, 0xbf11, 0xbf33, 0xbf55, 0xbf77, 0xbf99,
	// Entry 9200 - 923F
	0xbfbb, 0xbfdd, 0xbfff, 0xc021, 0xc043, 0xc065, 0xc087, 0xc09b,
	0xc0b0, 0xc0c3, 0xc0e5, 0xc107, 0xc129, 0xc13c, 0xc15e, 0xc180,
	0xc1a2, 0xc1c4, 0xc1e6, 0xc208, 0xc22a, 0xc24c, 0xc26e, 0xc290,
	0xc2b2, 0xc2d4, 0xc2f6, 0xc318, 0xc33a, 0xc35c, 0xc37e, 0xc3a0,
	0xc3c2, 0xc3e4, 0xc406, 0xc428, 0xc44a, 0xc46c, 0xc48e, 0xc4b0,
	0xc4d2, 0xc4f4, 0xc516, 0xc538, 0xc55a, 0xc57c, 0xc59e, 0xc5c0,
	0xc5e2, 0xc604, 0xc626, 0xc648, 0xc66a, 0xc68c, 0xc6bf, 0xc6f2,
	0xc725, 0xc758, 0xc78b, 0xc7be, 0xc7f1, 0xc824, 0xc857, 0xc872,
	// Entry 9240 - 927F
	0xc88a, 0xc89f, 0xc8b4, 0xc8cb, 0xc8e0, 0xc8fb, 0xc911, 0xc918,
	0xc91d, 0xc92c, 0xc93c, 0xc952, 0xc959, 0xc96a, 0xc97f, 0xc986,
	0xc995, 0xc99f, 0xc9a6, 0xc9af, 0xc9c8, 0xc9dc, 0xc9f6, 0xca0a,
	0xca19, 0xca34, 0xca4d, 0xca67, 0xca77, 0xca91, 0xcaa9, 0xcac4,
	0xcad1, 0xcae3, 0xcaff, 0xcb1a, 0xcb2d, 0xcb3a, 0xcb46, 0xcb53,
	0xcb5e, 0xcb6b, 0xcb74, 0xcb8e, 0xcba4, 0xcbc4, 0xcbd3, 0xcbe2,
	0xcbf6, 0xcc08, 0xcc0b, 0xcc1c, 0xcc23, 0xcc27, 0xcc2e, 0xcc36,
	0xcc3e, 0xcc4c, 0xcc5a, 0xcc63, 0xcc69, 0xcc73, 0xcc78, 0xcc86,
	// Entry 9280 - 92BF
	0xcc8a, 0xcc92, 0xcc9b, 0xcca2, 0xccae, 0xccb9, 0xccbd, 0xcccd,
	0xccd7, 0xcce2, 0xccf9, 0xcd01, 0xcd07, 0xcd10, 0xcd16, 0xcd1b,
	0xcd25, 0xcd2e, 0xcd33, 0xcd39, 0xcd42, 0xcd4b, 0xcd56, 0xcd5a,
	0xcd5f, 0xcd67, 0xcd71, 0xcd7a, 0xcd88, 0xcd94, 0xcd9f, 0xcdab,
	0xcdb4, 0xcdbf, 0xcdcd, 0xcdda, 0xcde3, 0xcde8, 0xcdf4, 0xce08,
	0xce0d, 0xce11, 0xce16, 0xce22, 0xce3d, 0xce4b, 0xce55, 0xce5e,
	0xce66, 0xce6c, 0xce79, 0xce7e, 0xce86, 0xce8d, 0xce96, 0xce9f,
	0xcea8, 0xceb3, 0xceba, 0xcec8, 0xcedd, 0xcef0, 0xcefa, 0xcf08,
	// Entry 92C0 - 92FF
	0xcf16, 0xcf1e, 0xcf30, 0xcf3b, 0xcf54, 0xcf6c, 0xcf73, 0xcf79,
	0xcf88, 0xcf95, 0xcfa3, 0xcfb1, 0xcfc1, 0xcfca, 0xcfdb, 0xcfe2,
	0xcfee, 0xcffb, 0xd008, 0xd015, 0xd024, 0xd032, 0xd03f, 0xd049,
	0xd05e, 0xd06c, 0xd07a, 0xd094, 0xd0a6, 0xd0b4, 0xd0c3, 0xd0de,
	0xd0ef, 0xd0fb, 0xd108, 0xd126, 0xd145, 0xd150, 0xd161, 0xd16f,
	0xd17b, 0xd189, 0xd19e, 0xd1a8, 0xd1b4, 0xd1ba, 0xd1c3, 0xd1d1,
	0xd1d8, 0xd1e3, 0xd1e9, 0xd1f6, 0xd205, 0xd20f, 0xd219, 0xd225,
	0xd22e, 0xd236, 0xd23d, 0xd251, 0xd25d, 0xd273, 0xd27c, 0xd282,
	// Entry 9300 - 933F
	0xd292, 0xd299, 0xd29f, 0xd2ac, 0xd2c3, 0xd2da, 0xd2ea, 0xd2fd,
	0xd30b, 0xd316, 0xd31c, 0xd322, 0xd32e, 0xd334, 0xd340, 0xd351,
	0xd35f, 0xd366, 0xd373, 0xd379, 0xd38a, 0xd394, 0xd3a8, 0xd3b2,
	0xd3cd, 0xd3e6, 0xd402, 0xd416, 0xd41d, 0xd430, 0xd445, 0xd454,
	0xd45d, 0xd474, 0xd486, 0xd48c, 0xd499, 0xd4a6, 0xd4ad, 0xd4bb,
	0xd4cc, 0xd4db, 0xd4ef, 0xd503, 0xd50b, 0xd50f, 0xd527, 0xd52c,
	0xd536, 0xd547, 0xd54d, 0xd55d, 0xd564, 0xd573, 0xd582, 0xd591,
	0xd59e, 0xd5ab, 0xd5bc, 0xd5cd, 0xd5d4, 0xd5e1, 0xd5e6, 0xd607,
	// Entry 9340 - 937F
	0xd614, 0xd61b, 0xd63e, 0xd65f, 0xd680, 0xd6a1, 0xd6c2, 0xd6c5,
	0xd6ca, 0xd6cc, 0xd6d9, 0xd6dc, 0xd6e1, 0xd6e8, 0xd6ee, 0xd6f1,
	0xd6f7, 0xd700, 0xd705, 0xd70a, 0xd70f, 0xd714, 0xd717, 0xd71b,
	0xd720, 0xd726, 0xd72d, 0xd734, 0xd737, 0xd73a, 0xd73e, 0xd746,
	0xd74d, 0xd759, 0xd75c, 0xd75f, 0xd767, 0xd772, 0xd776, 0xd783,
	0xd78b, 0xd791, 0xd79f, 0xd7a9, 0xd7c0, 0xd7c4, 0xd7cb, 0xd7d0,
	0xd7d6, 0xd7e5, 0xd7f3, 0xd7fa, 0xd804, 0xd80c, 0xd816, 0xd821,
	0xd829, 0xd834, 0xd842, 0xd84c, 0xd857, 0xd85f, 0xd867, 0xd870,
	// Entry 9380 - 93BF
	0xd87c, 0xd885, 0xd88e, 0xd898, 0xd8a0, 0xd8aa, 0xd8b2, 0xd8b6,
	0xd8b9, 0xd8bc, 0xd8c0, 0xd8c5, 0xd8cb, 0xd8eb, 0xd90d, 0xd92f,
	0xd952, 0xd962, 0xd972, 0xd97e, 0xd98c, 0xd99c, 0xd9af, 0xd9be,
	0xd9c3, 0xd9cd, 0xd9d7, 0xd9de, 0xd9e5, 0xd9ea, 0xd9ef, 0xd9f5,
	0xd9fb, 0xda09, 0xda0e, 0xda15, 0xda1a, 0xda23, 0xda30, 0xda40,
	0xda4d, 0xda59, 0xda63, 0xda75, 0xda88, 0xda8b, 0xda8f, 0xda92,
	0xda97, 0xda9d, 0xdab8, 0xdacd, 0xdae4, 0xdaf2, 0xdb07, 0xdb16,
	0xdb2c, 0xdb3f, 0xdb4e, 0xdb57, 0xdb62, 0xdb66, 0xdb79, 0xdb81,
	// Entry 93C0 - 93FF
	0xdb8e, 0xdb9d, 0xdba2, 0xdbac, 0xdbc2, 0xdbcf, 0xdbd2, 0xdbd7,
	0xdbee, 0xdbf7, 0xdbfd, 0xdc05, 0xdc10, 0xdc1c, 0xdc23, 0xdc2e,
	0xdc35, 0xdc39, 0xdc42, 0xdc4d, 0xdc51, 0xdc5a, 0xdc5e, 0xdc65,
	0xdc76, 0xdc7d, 0xdc8a, 0xdc96, 0xdca0, 0xdcaf, 0xdcbc, 0xdccc,
	0xdcd6, 0xdce1, 0xdced, 0xdcf9, 0xdd0a, 0xdd1a, 0xdd2a, 0xdd49,
	0xdd5c, 0xdd68, 0xdd6c, 0xdd7b, 0xdd8b, 0xdda1, 0xdda8, 0xddb3,
	0xddbe, 0xddcb, 0xddd7, 0xdde5, 0xddf4, 0xde00, 0xde15, 0xde1e,
	0xde2f, 0xde40, 0xde4b, 0xde61, 0xde7a, 0xde91, 0xdea9, 0xdeb9,
	// Entry 9400 - 943F
	0xdede, 0xdee2, 0xdef3, 0xdefc, 0xdf04, 0xdf0f, 0xdf1b, 0xdf1e,
	0xdf29, 0xdf39, 0xdf47, 0xdf55, 0xdf5d, 0xdf6e, 0xdf78, 0xdf90,
	0xdfaa, 0xdfb3, 0xdfbc, 0xdfc3, 0xdfd0, 0xdfd9, 0xdfe7, 0xdff7,
	0xe004, 0xe00a, 0xe012, 0xe030, 0xe03b, 0xe044, 0xe04e, 0xe057,
	0xe062, 0xe067, 0xe071, 0xe077, 0xe07b, 0xe08d, 0xe092, 0xe09d,
	0xe0ae, 0xe0c8, 0xe0da, 0xe0e5, 0xe0ef, 0xe0f6, 0xe103, 0xe114,
	0xe137, 0xe157, 0xe176, 0xe193, 0xe1b1, 0xe1b8, 0xe1c3, 0xe1cc,
	0xe1d8, 0xe202, 0xe210, 0xe220, 0xe230, 0xe241, 0xe247, 0xe258,
	// Entry 9440 - 947F
	0xe264, 0xe26e, 0xe273, 0xe280, 0xe28e, 0xe29d, 0xe2a9, 0xe2c2,
	0xe2f7, 0xe345, 0xe377, 0xe3ad, 0xe3c2, 0xe3d8, 0xe3f8, 0xe3ff,
	0xe41a, 0xe438, 0xe43f, 0xe44c, 0xe46a, 0xe489, 0xe49a, 0xe4ae,
	0xe4b1, 0xe4b5, 0xe4be, 0xe4c2, 0xe4df, 0xe4e7, 0xe4f2, 0xe4fe,
	0xe51d, 0xe53b, 0xe56f, 0xe58f, 0xe5ab, 0xe5c7, 0xe5d1, 0xe5f7,
	0xe61b, 0xe633, 0xe64b, 0xe669, 0xe66d, 0xe67b, 0xe681, 0xe687,
	0xe693, 0xe698, 0xe69e, 0xe6a8, 0xe6b1, 0xe6bd, 0xe6dd, 0xe6f9,
	0xe707, 0xe71a, 0xe72d, 0xe73d, 0xe74e, 0xe762, 0xe774, 0xe788,
	// Entry 9480 - 94BF
	0xe79a, 0xe7b2, 0xe7cc, 0xe7ea, 0xe80a, 0xe82b, 0xe84c, 0xe860,
	0xe883, 0xe88f, 0xe8b6, 0xe8de, 0xe8f6, 0xe907, 0xe918, 0xe924,
	0xe92d, 0xe93a, 0xe93f, 0xe945, 0xe94e, 0xe968, 0xe977, 0xe98c,
	0xe9a1, 0xe9b8, 0xe9ce, 0xe9e4, 0xe9f9, 0xea10, 0xea27, 0xea3d,
	0xea52, 0xea6a, 0xea82, 0xea97, 0xeaac, 0xeac3, 0xead9, 0xeaef,
	0xeb04, 0xeb1b, 0xeb32, 0xeb48, 0xeb5d, 0xeb75, 0xeb8d, 0xeb9a,
	0xebbb, 0xebdf, 0xebe7, 0xec00, 0xec0c, 0xec10, 0xec16, 0xec27,
	0xec41, 0xec4a, 0xec4e, 0xec6d, 0xec7a, 0xec89, 0xec8f, 0xec99,
	// Entry 94C0 - 94FF
	0xeca1, 0xecac, 0xecc8, 0xece4, 0xed01, 0xed1a, 0xed33, 0xed4c,
	0xed62, 0xed72, 0xed82, 0xed99, 0xeda8, 0xedc1, 0xedd2, 0xeddf,
	0xedf0, 0xee08, 0xee1f, 0xee34, 0xee45, 0xee56, 0xee69, 0xee89,
	0xeeb2, 0xeec9, 0xeee2, 0xeef7, 0xef20, 0xef55, 0xef78, 0xef9a,
	0xefbd, 0xefdf, 0xf002, 0xf024, 0xf047, 0xf067, 0xf089, 0xf0a9,
	0xf0cb, 0xf0eb, 0xf10d, 0xf118, 0xf128, 0xf13a, 0xf153, 0xf15a,
	0xf16b, 0xf187, 0xf1a3, 0xf1b9, 0xf1c7, 0xf1d5, 0xf1e5, 0xf1f5,
	0xf207, 0xf210, 0xf225, 0xf22e, 0xf234, 0xf240, 0xf248, 0xf259,
	// Entry 9500 - 953F
	0xf26b, 0xf289, 0xf29e, 0xf2b0, 0xf2c0, 0xf2cf, 0xf2db, 0xf2e1,
	0xf2ec, 0xf2ff, 0xf30c, 0xf318, 0xf322, 0xf331, 0xf33f, 0xf343,
	0xf34c, 0xf354, 0xf362, 0xf36c, 0xf377, 0xf37f, 0xf383, 0xf388,
	0xf393, 0xf3a2, 0xf3b5, 0xf3c3, 0xf3cb, 0xf3d3, 0xf3da, 0xf404,
	0xf412, 0xf42b, 0xf444, 0xf44f, 0xf456, 0xf469, 0xf47f, 0xf48a,
	0xf496, 0xf49a, 0xf4b5, 0xf4c5, 0xf4d5, 0xf4e4, 0xf4f4, 0xf506,
	0xf519, 0xf52b, 0xf53f, 0xf552, 0xf566, 0xf577, 0xf589, 0xf594,
	0xf5a9, 0xf5b7, 0xf5cd, 0xf5dc, 0xf5f4, 0xf608, 0xf625, 0xf635,
	// Entry 9540 - 957F
	0xf64f, 0xf658, 0xf662, 0xf66d, 0xf67e, 0xf691, 0xf696, 0xf6a3,
	0xf6c2, 0xf6d8, 0xf6f4, 0xf721, 0xf74c, 0xf780, 0xf796, 0xf7ad,
	0xf7b9, 0xf7d7, 0xf7f4, 0xf801, 0xf824, 0xf840, 0xf84d, 0xf859,
	0xf86c, 0xf879, 0xf88d, 0xf899, 0xf8a6, 0xf8b5, 0xf8c1, 0xf8d5,
	0xf8f3, 0xf910, 0xf92a, 0xf954, 0xf986, 0xf997, 0xf9a3, 0xf9ad,
	0xf9b9, 0xf9c4, 0xf9d4, 0xf9ed, 0xfa0b, 0xfa28, 0xfa36, 0xfa42,
	0xfa4c, 0xfa57, 0xfa61, 0xfa6f, 0xfa81, 0xfa95, 0xfaa0, 0xfac3,
	0xfad9, 0xfae8, 0xfaf4, 0xfb01, 0xfb0b, 0xfb1d, 0xfb33, 0xfb56,
	// Entry 9580 - 95BF
	0xfb70, 0xfb90, 0xfbb7, 0xfbce, 0xfbef, 0xfbff, 0xfc0e, 0xfc1c,
	0xfc32, 0xfc47, 0xfc57, 0xfc6d, 0xfc86, 0xfc9a, 0xfcae, 0xfcc0,
	0xfcd3, 0xfce7, 0xfd04, 0xfd2c, 0xfd3b, 0xfd53, 0xfd6b, 0xfd83,
	0xfd9b, 0xfdb3, 0xfdcb, 0xfdea, 0xfe09, 0xfe28, 0xfe47, 0xfe64,
	0xfe81, 0xfe9e, 0xfebb, 0xfede, 0xff01, 0xff24, 0xff47, 0xff5e,
	0xff75, 0xff8c, 0xffa3, 0xffc0, 0xffdd, 0xfffa, 0x0017, 0x0033,
	0x005f, 0x007a, 0x00a5, 0x00b5, 0x00c3, 0x00d4, 0x00e4, 0x00ff,
	0x0120, 0x0139, 0x0158, 0x0170, 0x0188, 0x01c4, 0x01f9, 0x0232,
	// Entry 95C0 - 95FF
	0x024c, 0x026b, 0x0290, 0x02a2, 0x02bc, 0x02c9, 0x02de, 0x02e4,
	0x02ee, 0x02fe, 0x0309, 0x0319, 0x033a, 0x033f, 0x0344, 0x034e,
	0x0355, 0x0359, 0x0361, 0x0364, 0x0370, 0x037a, 0x0382, 0x0389,
	0x0392, 0x039d, 0x03a7, 0x03ba, 0x03be, 0x03cb, 0x03d5, 0x03e8,
	0x03fc, 0x040a, 0x041b, 0x0422, 0x042a, 0x043a, 0x044c, 0x045d,
	0x046b, 0x046f, 0x0476, 0x047f, 0x0497, 0x04ad, 0x04be, 0x04d9,
	0x04f0, 0x04f4, 0x0501, 0x050f, 0x0520, 0x053e, 0x0552, 0x0566,
	0x057e, 0x0585, 0x0590, 0x0599, 0x05ab, 0x05b5, 0x05c3, 0x05d4,
	// Entry 9600 - 963F
	0x05df, 0x05ec, 0x05f4, 0x05ff, 0x0605, 0x0611, 0x0617, 0x061b,
	0x0622, 0x0632, 0x0639, 0x0646, 0x0652, 0x066f, 0x067e, 0x0698,
	0x06a3, 0x06af, 0x06bd, 0x06d3, 0x06e0, 0x06ec, 0x06ef, 0x06ff,
	0x070d, 0x071d, 0x0722, 0x0728, 0x0734, 0x0737, 0x073f, 0x0748,
	0x0750, 0x0760, 0x0765, 0x076e, 0x077f, 0x0785, 0x078d, 0x0795,
	0x07a2, 0x07ac, 0x07c9, 0x07dd, 0x07f7, 0x0805, 0x0820, 0x0832,
	0x0843, 0x084c, 0x0860, 0x0871, 0x087f, 0x0886, 0x0893, 0x0898,
	0x089c, 0x08a9, 0x08b3, 0x08c0, 0x08cc, 0x08d8, 0x08fa, 0x0913,
	// Entry 9640 - 967F
	0x092d, 0x0948, 0x0963, 0x0983, 0x09a3, 0x09c5, 0x09e5, 0x0a07,
	0x0a24, 0x0a43, 0x0a62, 0x0a7e, 0x0aa7, 0x0ac9, 0x0af0, 0x0b19,
	0x0b42, 0x0b60, 0x0b7a, 0x0b95, 0x0bb2, 0x0bd1, 0x0bf0, 0x0c11,
	0x0c2b, 0x0c47, 0x0c65, 0x0c85, 0x0ca9, 0x0cce, 0x0cee, 0x0d13,
	0x0d3c, 0x0d62, 0x0d8a, 0x0db2, 0x0de2, 0x0e13, 0x0e32, 0x0e4f,
	0x0e6d, 0x0e8f, 0x0eba, 0x0ee0, 0x0f13, 0x0f3c, 0x0f65, 0x0f90,
	0x0fad, 0x0fcc, 0x0feb, 0x100a, 0x1026, 0x1044, 0x1063, 0x1085,
	0x10a2, 0x10bf, 0x10de, 0x10ff, 0x1120, 0x113c, 0x115a, 0x117a,
	// Entry 9680 - 96BF
	0x1195, 0x11b2, 0x11cf, 0x11e9, 0x1202, 0x121e, 0x123c, 0x1255,
	0x126e, 0x128a, 0x12a4, 0x12bf, 0x12e2, 0x1307, 0x1325, 0x1342,
	0x1367, 0x1386, 0x13a0, 0x13bb, 0x13db, 0x13f6, 0x1415, 0x1430,
	0x1454, 0x1471, 0x149c, 0x14c9, 0x14ea, 0x150b, 0x1528, 0x1546,
	0x1566, 0x1582, 0x15a4, 0x15c2, 0x15e2, 0x1602, 0x1622, 0x1642,
	0x165f, 0x1681, 0x16a6, 0x16c2, 0x16dc, 0x16f7, 0x1716, 0x1731,
	0x1750, 0x1770, 0x177e, 0x1789, 0x1796, 0x17a4, 0x17b4, 0x17c3,
	0x17d6, 0x17dc, 0x17e4, 0x17ec, 0x17f2, 0x17f7, 0x1823, 0x184d,
	// Entry 96C0 - 96FF
	0x187a, 0x18a6, 0x18c1, 0x18d9, 0x18ea, 0x18fc, 0x1913, 0x192f,
	0x1959, 0x1965, 0x1976, 0x1991, 0x19a3, 0x19b6, 0x19c7, 0x19d9,
	0x19f0, 0x1a0c, 0x1a3b, 0x1a66, 0x1a73, 0x1a85, 0x1a9d, 0x1ab7,
	0x1ae8, 0x1b15, 0x1b23, 0x1b35, 0x1b4d, 0x1b67, 0x1b93, 0x1ba3,
	0x1bb4, 0x1bc6, 0x1bd6, 0x1beb, 0x1c01, 0x1c1c, 0x1c28, 0x1c35,
	0x1c43, 0x1c4f, 0x1c5c, 0x1c6e, 0x1c85, 0x1c9f, 0x1cba, 0x1cd3,
	0x1ced, 0x1d0c, 0x1d30, 0x1d49, 0x1d63, 0x1d7b, 0x1d94, 0x1db2,
	0x1dd5, 0x1df0, 0x1e0c, 0x1e26, 0x1e41, 0x1e61, 0x1e7f, 0x1e9e,
	// Entry 9700 - 973F
	0x1eb6, 0x1ed8, 0x1ef5, 0x1f13, 0x1f2a, 0x1f4b, 0x1f73, 0x1f90,
	0x1fad, 0x1fca, 0x1fe6, 0x1fff, 0x201e, 0x203c, 0x205f, 0x2080,
	0x209f, 0x20be, 0x20e0, 0x20f0, 0x2109, 0x2117, 0x212e, 0x2145,
	0x2158, 0x216b, 0x217d, 0x2190, 0x21a2, 0x21b2, 0x21c3, 0x21d6,
	0x21e9, 0x21fb, 0x220e, 0x2220, 0x2231, 0x225e, 0x2289, 0x22b7,
	0x22e4, 0x2312, 0x233e, 0x236d, 0x239b, 0x23c8, 0x23f3, 0x2421,
	0x244e, 0x247e, 0x24ac, 0x24dd, 0x250d, 0x2537, 0x255f, 0x258a,
	0x25b4, 0x25e4, 0x2612, 0x2643, 0x2673, 0x26a9, 0x26dd, 0x2714,
	// Entry 9740 - 977F
	0x274a, 0x277b, 0x27aa, 0x27dc, 0x280d, 0x283e, 0x286d, 0x289f,
	0x28d0, 0x28ff, 0x292c, 0x295c, 0x298b, 0x29bb, 0x29e9, 0x2a1a,
	0x2a4a, 0x2a7f, 0x2ab2, 0x2ae8, 0x2b1d, 0x2b38, 0x2b51, 0x2b6d,
	0x2b88, 0x2b9f, 0x2bb4, 0x2bcc, 0x2be3, 0x2bfd, 0x2c15, 0x2c30,
	0x2c4a, 0x2c6a, 0x2c88, 0x2ca9, 0x2cc9, 0x2cde, 0x2cf1, 0x2d07,
	0x2d1c, 0x2d36, 0x2d4e, 0x2d69, 0x2d83, 0x2d9e, 0x2db9, 0x2dd4,
	0x2def, 0x2e0a, 0x2e22, 0x2e48, 0x2e6c, 0x2e93, 0x2eb9, 0x2ee0,
	0x2f07, 0x2f2e, 0x2f55, 0x2f75, 0x2f93, 0x2fb4, 0x2fd4, 0x2ff5,
	// Entry 9780 - 97BF
	0x3016, 0x3037, 0x3058, 0x307f, 0x30a4, 0x30cc, 0x30f3, 0x311b,
	0x3143, 0x316b, 0x3193, 0x31b9, 0x31dd, 0x3204, 0x322a, 0x3251,
	0x3278, 0x329f, 0x32c6, 0x32f1, 0x331a, 0x3346, 0x3371, 0x339d,
	0x33c9, 0x33f5, 0x3421, 0x343d, 0x3457, 0x3474, 0x3490, 0x34bf,
	0x34ec, 0x351c, 0x354b, 0x356c, 0x358b, 0x35ad, 0x35ce, 0x35e9,
	0x360b, 0x362b, 0x364c, 0x366f, 0x3693, 0x36b3, 0x36d4, 0x36f5,
	0x3718, 0x373a, 0x375c, 0x3786, 0x37b1, 0x37dc, 0x3808, 0x3823,
	0x3845, 0x386b, 0x389c, 0x38bc, 0x38d8, 0x38f8, 0x3916, 0x3937,
	// Entry 97C0 - 97FF
	0x3957, 0x3970, 0x3989, 0x39a2, 0x39bb, 0x39df, 0x3a04, 0x3a33,
	0x3a66, 0x3a9b, 0x3ad0, 0x3b05, 0x3b3a, 0x3b59, 0x3b80, 0x3ba9,
	0x3bcc, 0x3bee, 0x3c02, 0x3c21, 0x3c41, 0x3c5f, 0x3c78, 0x3c88,
	0x3c9c, 0x3cb8, 0x3cd5, 0x3cfa, 0x3d09, 0x3d14, 0x3d1f, 0x3d2c,
	0x3d3d, 0x3d4d, 0x3d62, 0x3d6b, 0x3d78, 0x3d8e, 0x3d98, 0x3da4,
	0x3db5, 0x3dc1, 0x3dd4, 0x3de4, 0x3df5, 0x3dfe, 0x3e28, 0x3e3c,
	0x3e50, 0x3e5a, 0x3e68, 0x3e85, 0x3e92, 0x3e9c, 0x3ea5, 0x3eb2,
	0x3ece, 0x3eea, 0x3f18, 0x3f3d, 0x3f65, 0x3f9b, 0x3fb8, 0x3fd8,
	// Entry 9800 - 983F
	0x3fe6, 0x3ff4, 0x4005, 0x400b, 0x4011, 0x401e, 0x402e, 0x4033,
	0x4049, 0x4051, 0x4057, 0x4068, 0x4071, 0x407b, 0x4083, 0x408e,
	0x409b, 0x40af, 0x40bf, 0x40cc, 0x40d1, 0x40d9, 0x40de, 0x40ef,
	0x4101, 0x4112, 0x411e, 0x4132, 0x413f, 0x4156, 0x415e, 0x4169,
	0x4172, 0x4179, 0x4181, 0x4186, 0x418c, 0x4192, 0x41a0, 0x41ab,
	0x41be, 0x41cf, 0x41d2, 0x41df, 0x41e6, 0x41ef, 0x41f7, 0x41ff,
	0x420d, 0x4218, 0x4222, 0x4231, 0x423f, 0x4246, 0x424e, 0x4251,
	0x4258, 0x4263, 0x426b, 0x4276, 0x4281, 0x4286, 0x428f, 0x4294,
	// Entry 9840 - 987F
	0x42c3, 0x42cf, 0x42e5, 0x4307, 0x432b, 0x433a, 0x4347, 0x434c,
	0x435a, 0x4371, 0x4388, 0x438c, 0x4394, 0x439b, 0x43a6, 0x43af,
	0x43b3, 0x43bc, 0x43c4, 0x43ca, 0x43d6, 0x43db, 0x43df, 0x43e2,
	0x43e7, 0x43ea, 0x43f2, 0x43fb, 0x43ff, 0x4406, 0x440c, 0x4416,
	0x441c, 0x4421, 0x442d, 0x4437, 0x443f, 0x4447, 0x444c, 0x4453,
	0x445b, 0x4460, 0x4467, 0x4473, 0x4479, 0x4480, 0x4487, 0x448f,
	0x4496, 0x449c, 0x44a0, 0x44a7, 0x44ab, 0x44b0, 0x44b5, 0x44be,
	0x44c3, 0x44cb, 0x44d1, 0x44d7, 0x44dc, 0x44e0, 0x44e9, 0x44f5,
	// Entry 9880 - 98BF
	0x450d, 0x4527, 0x453b, 0x4555, 0x4559, 0x455c, 0x4560, 0x4565,
	0x456e, 0x457a, 0x4585, 0x4599, 0x45ad, 0x45be, 0x45cc, 0x45da,
	0x45e6, 0x45ed, 0x45f8, 0x4604, 0x460a, 0x460f, 0x4616, 0x461c,
	0x4622, 0x462c, 0x4634, 0x463e, 0x4643, 0x4652, 0x4661, 0x466c,
	0x467d, 0x4682, 0x4687, 0x4692, 0x46a0, 0x46b5, 0x46ca, 0x46d9,
	0x46f1, 0x46f5, 0x46fa, 0x4701, 0x470a, 0x470d, 0x4712, 0x4718,
	0x471d, 0x4729, 0x4733, 0x4738, 0x473e, 0x4742, 0x4747, 0x4758,
	0x4763, 0x4776, 0x477f, 0x4789, 0x4799, 0x47a0, 0x47a6, 0x47b7,
	// Entry 98C0 - 98FF
	0x47be, 0x47c3, 0x47c9, 0x47d0, 0x47dd, 0x47ec, 0x47f8, 0x4802,
	0x480c, 0x4811, 0x4817, 0x4824, 0x482f, 0x4835, 0x483c, 0x4848,
	0x485a, 0x486d, 0x487f, 0x4893, 0x48a7, 0x48b9, 0x48e6, 0x4913,
	0x4942, 0x4969, 0x4991, 0x49b8, 0x49e1, 0x4a0a, 0x4a31, 0x4a58,
	0x4a80, 0x4aa7, 0x4ad0, 0x4af9, 0x4b20, 0x4b49, 0x4b73, 0x4b9c,
	0x4bc7, 0x4bf2, 0x4c1b, 0x4c55, 0x4c8f, 0x4ccb, 0x4ce2, 0x4cfa,
	0x4d11, 0x4d2a, 0x4d43, 0x4d5a, 0x4d71, 0x4d89, 0x4da0, 0x4db9,
	0x4dd2, 0x4de9, 0x4e02, 0x4e1c, 0x4e35, 0x4e50, 0x4e6b, 0x4e84,
	// Entry 9900 - 993F
	0x4ebe, 0x4ef8, 0x4f34, 0x4f68, 0x4f9d, 0x4fd1, 0x5007, 0x503d,
	0x5071, 0x50a5, 0x50da, 0x510e, 0x5144, 0x517a, 0x51ae, 0x51e4,
	0x521b, 0x5251, 0x5289, 0x52c1, 0x52f7, 0x532f, 0x5367, 0x53a1,
	0x53b7, 0x53cd, 0x53e5, 0x5412, 0x543f, 0x546e, 0x5486, 0x549d,
	0x54b6, 0x54ce, 0x54e5, 0x54fe, 0x550e, 0x551f, 0x552f, 0x5540,
	0x5553, 0x5567, 0x557b, 0x558c, 0x559f, 0x55b1, 0x55c4, 0x55d9,
	0x55ef, 0x5605, 0x5618, 0x562d, 0x5641, 0x5656, 0x5662, 0x5674,
	0x567a, 0x5680, 0x568c, 0x569c, 0x56a6, 0x56b0, 0x56bd, 0x56cd,
	// Entry 9940 - 997F
	0x56d8, 0x56dd, 0x56e3, 0x56e8, 0x56ec, 0x56f5, 0x56fe, 0x5708,
	0x570e, 0x571b, 0x5722, 0x5727, 0x572b, 0x5733, 0x5741, 0x5747,
	0x5754, 0x5759, 0x575e, 0x5761, 0x576a, 0x576f, 0x577e, 0x5787,
	0x5790, 0x5794, 0x57a1, 0x57ac, 0x57b2, 0x57b6, 0x57bc, 0x57c2,
	0x57c9, 0x57d6, 0x57da, 0x57e0, 0x57ea, 0x57f4, 0x57fd, 0x5804,
	0x5808, 0x5813, 0x5826, 0x5831, 0x5836, 0x5846, 0x584f, 0x5855,
	0x5858, 0x585c, 0x5862, 0x586b, 0x5877, 0x587b, 0x5882, 0x5887,
	0x588c, 0x5896, 0x58a4, 0x58ac, 0x58b5, 0x58b9, 0x58c6, 0x58cb,
	// Entry 9980 - 99BF
	0x58db, 0x58e0, 0x58ee, 0x58fa, 0x5909, 0x591a, 0x5925, 0x5933,
	0x5937, 0x593c, 0x5942, 0x594d, 0x5958, 0x595d, 0x5966, 0x596c,
	0x5972, 0x5978, 0x5986, 0x598b, 0x598e, 0x5999, 0x59a0, 0x59ae,
	0x59b6, 0x59c2, 0x59cf, 0x59f6, 0x5a0b, 0x5a23, 0x5a33, 0x5a3d,
	0x5a44, 0x5a50, 0x5a69, 0x5a77, 0x5a82, 0x5aaa, 0x5ab9, 0x5ac7,
	0x5ad5, 0x5ae1, 0x5afd, 0x5b08, 0x5b1e, 0x5b35, 0x5b44, 0x5b53,
	0x5b63, 0x5b72, 0x5b82, 0x5b92, 0x5ba3, 0x5bb2, 0x5bc2, 0x5bd2,
	0x5be3, 0x5bf3, 0x5c04, 0x5c15, 0x5c27, 0x5c36, 0x5c46, 0x5c56,
	// Entry 99C0 - 99FF
	0x5c67, 0x5c77, 0x5c88, 0x5c9a, 0x5caa, 0x5cbb, 0x5ccc, 0x5cde,
	0x5cef, 0x5d01, 0x5d13, 0x5d26, 0x5d35, 0x5d45, 0x5d55, 0x5d66,
	0x5d76, 0x5d87, 0x5d98, 0x5daa, 0x5dba, 0x5dcb, 0x5ddd, 0x5dee,
	0x5e00, 0x5e12, 0x5e25, 0x5e35, 0x5e46, 0x5e57, 0x5e69, 0x5e7a,
	0x5e8c, 0x5e9e, 0x5eb1, 0x5ec2, 0x5ed4, 0x5ee6, 0x5ef9, 0x5f0b,
	0x5f1e, 0x5f31, 0x5f6c, 0x5fa6, 0x5fe1, 0x601b, 0x604f, 0x608b,
	0x60c6, 0x6102, 0x613d, 0x6172, 0x61b4, 0x61f1, 0x622c, 0x6269,
	0x62a4, 0x62da, 0x6316, 0x6350, 0x638c, 0x63c6, 0x63fb, 0x643c,
	// Entry 9A00 - 9A3F
	0x6478, 0x64b3, 0x64ef, 0x652a, 0x655f, 0x659a, 0x65d4, 0x660f,
	0x6649, 0x667d, 0x66be, 0x66fa, 0x6734, 0x6770, 0x67aa, 0x67df,
	0x681c, 0x6857, 0x6894, 0x68cf, 0x6905, 0x6947, 0x6980, 0x69b8,
	0x69f0, 0x6a28, 0x6a49, 0x6a6b, 0x6a8d, 0x6aaf, 0x6aca, 0x6ae5,
	0x6b00, 0x6b1b, 0x6b36, 0x6b51, 0x6b6e, 0x6b8b, 0x6ba8, 0x6bc5,
	0x6be2, 0x6bff, 0x6c1e, 0x6c3d, 0x6c5d, 0x6c7d, 0x6c9d, 0x6cbd,
	0x6cd4, 0x6ced, 0x6d05, 0x6d1f, 0x6d38, 0x6d4f, 0x6d68, 0x6d80,
	0x6d9a, 0x6db3, 0x6dc9, 0x6de0, 0x6df7, 0x6e0e, 0x6e22, 0x6e56,
	// Entry 9A40 - 9A7F
	0x6e8a, 0x6ebd, 0x6ecf, 0x6ee9, 0x6efe, 0x6f1c, 0x6f3a, 0x6f5f,
	0x6f83, 0x6fa5, 0x6fc8, 0x6feb, 0x700d, 0x7044, 0x707c, 0x70b3,
	0x70eb, 0x7132, 0x717a, 0x71c1, 0x7208, 0x7260, 0x72b8, 0x730f,
	0x7366, 0x73bd, 0x7414, 0x7437, 0x7469, 0x7481, 0x7493, 0x74a8,
	0x74be, 0x74e8, 0x751c, 0x7551, 0x757b, 0x75a3, 0x75b3, 0x75c4,
	0x75d6, 0x75ec, 0x7603, 0x7631, 0x764a, 0x7672, 0x7697, 0x76be,
	0x76e4, 0x7702, 0x770e, 0x772b, 0x7744, 0x775e, 0x7775, 0x778e,
	0x779e, 0x77be, 0x77dd, 0x77f2, 0x7806, 0x783c, 0x7872, 0x78a8,
	// Entry 9A80 - 9ABF
	0x78de, 0x7914, 0x794b, 0x7982, 0x79b8, 0x79fe, 0x7a45, 0x7a8b,
	0x7ad0, 0x7b15, 0x7b5a, 0x7b9f, 0x7be3, 0x7c08, 0x7c2e, 0x7c56,
	0x7c7c, 0x7c9a, 0x7cb8, 0x7cd5, 0x7cf3, 0x7d18, 0x7d3e, 0x7d66,
	0x7d8c, 0x7dbf, 0x7df5, 0x7e2b, 0x7e5e, 0x7e72, 0x7e85, 0x7e98,
	0x7ead, 0x7ec1, 0x7ed5, 0x7ee8, 0x7efd, 0x7f12, 0x7f26, 0x7f37,
	0x7f58, 0x7f79, 0x7f9a, 0x7fbb, 0x7fdc, 0x7ffd, 0x801e, 0x803f,
	0x8060, 0x8081, 0x80a2, 0x80c3, 0x80e4, 0x8105, 0x8126, 0x8147,
	0x8168, 0x8189, 0x81aa, 0x81cb, 0x81ec, 0x820d, 0x822e, 0x824f,
	// Entry 9AC0 - 9AFF
	0x8270, 0x8291, 0x82b2, 0x82d3, 0x82f4, 0x8315, 0x8336, 0x8357,
	0x8378, 0x8399, 0x83ba, 0x83db, 0x83fc, 0x841d, 0x843e, 0x845f,
	0x8480, 0x84a1, 0x84c2, 0x84e3, 0x8504, 0x8525, 0x8546, 0x8567,
	0x8588, 0x85a9, 0x85ca, 0x85eb, 0x860c, 0x862d, 0x864e, 0x866f,
	0x8690, 0x86b1, 0x86d2, 0x86f3, 0x8714, 0x8735, 0x8756, 0x8777,
	0x8798, 0x87b9, 0x87da, 0x87fb, 0x881c, 0x883d, 0x885e, 0x887f,
	0x88a0, 0x88c1, 0x88e2, 0x8903, 0x8924, 0x8945, 0x8966, 0x8987,
	0x89a8, 0x89c9, 0x89ea, 0x8a0b, 0x8a2c, 0x8a4d, 0x8a6e, 0x8a8f,
	// Entry 9B00 - 9B3F
	0x8ab0, 0x8ad1, 0x8af2, 0x8b13, 0x8b34, 0x8b55, 0x8b76, 0x8b97,
	0x8bb8, 0x8bd9, 0x8bfa, 0x8c1b, 0x8c3c, 0x8c5d, 0x8c7e, 0x8c9f,
	0x8cc0, 0x8ce1, 0x8d02, 0x8d23, 0x8d44, 0x8d65, 0x8d86, 0x8da7,
	0x8dc8, 0x8de9, 0x8e0a, 0x8e2b, 0x8e4c, 0x8e6d, 0x8e8e, 0x8eaf,
	0x8ed0, 0x8ef1, 0x8f12, 0x8f33, 0x8f54, 0x8f75, 0x8f96, 0x8fb7,
	0x8fd8, 0x8ff9, 0x901a, 0x903b, 0x905c, 0x907d, 0x909e, 0x90bf,
	0x90e0, 0x9101, 0x9122, 0x9143, 0x9164, 0x9185, 0x91a6, 0x91c7,
	0x91e8, 0x9209, 0x922a, 0x924b, 0x926c, 0x928d, 0x92ae, 0x92cf,
	// Entry 9B40 - 9B7F
	0x92f0, 0x9311, 0x9332, 0x9353, 0x9374, 0x9395, 0x93b6, 0x93d7,
	0x93f8, 0x9419, 0x943a, 0x945b, 0x947c, 0x949d, 0x94be, 0x94df,
	0x9500, 0x9521, 0x9542, 0x9563, 0x9584, 0x95a5, 0x95c6, 0x95e7,
	0x9608, 0x9629, 0x964a, 0x966b, 0x968c, 0x96ad, 0x96ce, 0x96ef,
	0x9710, 0x9731, 0x9752, 0x9773, 0x9794, 0x97b5, 0x97d6, 0x97f7,
	0x9818, 0x9839, 0x985a, 0x987b, 0x989c, 0x98bd, 0x98de, 0x98ff,
	0x9920, 0x9941, 0x9962, 0x9983, 0x99a4, 0x99c5, 0x99e6, 0x9a07,
	0x9a28, 0x9a49, 0x9a6a, 0x9a8b, 0x9aac, 0x9acd, 0x9aee, 0x9b0f,
	// Entry 9B80 - 9BBF
	0x9b30, 0x9b51, 0x9b72, 0x9b93, 0x9bb4, 0x9bd5, 0x9bf6, 0x9c17,
	0x9c38, 0x9c59, 0x9c7a, 0x9c9b, 0x9cbc, 0x9cdd, 0x9cfe, 0x9d1f,
	0x9d40, 0x9d61, 0x9d82, 0x9da3, 0x9dc4, 0x9de5, 0x9e06, 0x9e27,
	0x9e48, 0x9e69, 0x9e8a, 0x9eab, 0x9ecc, 0x9eed, 0x9f0e, 0x9f2f,
	0x9f50, 0x9f71, 0x9f92, 0x9fb3, 0x9fd4, 0x9ff5, 0xa016, 0xa037,
	0xa058, 0xa079, 0xa09a, 0xa0bb, 0xa0dc, 0xa0fd, 0xa11e, 0xa13f,
	0xa160, 0xa181, 0xa1a2, 0xa1c3, 0xa1e4, 0xa205, 0xa226, 0xa247,
	0xa268, 0xa289, 0xa2aa, 0xa2cb, 0xa2ec, 0xa30d, 0xa32e, 0xa34f,
	// Entry 9BC0 - 9BFF
	0xa370, 0xa391, 0xa3b2, 0xa3d3, 0xa3f4, 0xa415, 0xa436, 0xa457,
	0xa478, 0xa499, 0xa4ba, 0xa4db, 0xa4fc, 0xa51d, 0xa53e, 0xa55f,
	0xa580, 0xa5a1, 0xa5c2, 0xa5e3, 0xa604, 0xa625, 0xa646, 0xa667,
	0xa688, 0xa6a9, 0xa6ca, 0xa6eb, 0xa70c, 0xa72d, 0xa74e, 0xa76f,
	0xa790, 0xa7b1, 0xa7d2, 0xa7f3, 0xa814, 0xa835, 0xa856, 0xa877,
	0xa898, 0xa8b9, 0xa8da, 0xa8fb, 0xa91c, 0xa93d, 0xa95e, 0xa97f,
	0xa9a0, 0xa9c1, 0xa9e2, 0xaa03, 0xaa24, 0xaa45, 0xaa66, 0xaa87,
	0xaaa8, 0xaac9, 0xaaea, 0xab0b, 0xab2c, 0xab4d, 0xab6e, 0xab8f,
	// Entry 9C00 - 9C3F
	0xabb0, 0xabd1, 0xabf2, 0xac13, 0xac34, 0xac55, 0xac76, 0xac97,
	0xacb8, 0xacd9, 0xacfa, 0xad1b, 0xad3c, 0xad5d, 0xad7e, 0xad9f,
	0xadc0, 0xade1, 0xae02, 0xae23, 0xae44, 0xae65, 0xae86, 0xaea7,
	0xaec8, 0xaee9, 0xaf0a, 0xaf2b, 0xaf4c, 0xaf6d, 0xaf8e, 0xafaf,
	0xafd0, 0xaff1, 0xb012, 0xb033, 0xb054, 0xb075, 0xb096, 0xb0b7,
	0xb0d8, 0xb0f9, 0xb11a, 0xb13b, 0xb15c, 0xb17d, 0xb19e, 0xb1bf,
	0xb1e0, 0xb201, 0xb222, 0xb243, 0xb264, 0xb285, 0xb2a6, 0xb2c7,
	0xb2e8, 0xb309, 0xb32a, 0xb34b, 0xb36c, 0xb38d, 0xb3ae, 0xb3cf,
	// Entry 9C40 - 9C7F
	0xb3f0, 0xb411, 0xb432, 0xb453, 0xb474, 0xb495, 0xb4b6, 0xb4d7,
	0xb4f8, 0xb519, 0xb53a, 0xb55b, 0xb57c, 0xb59d, 0xb5be, 0xb5df,
	0xb600, 0xb621, 0xb642, 0xb663, 0xb684, 0xb6a5, 0xb6c6, 0xb6e7,
	0xb708, 0xb729, 0xb74a, 0xb76b, 0xb78c, 0xb7ad, 0xb7ce, 0xb7ef,
	0xb810, 0xb831, 0xb852, 0xb873, 0xb894, 0xb8b5, 0xb8d6, 0xb8f7,
	0xb918, 0xb939, 0xb95a, 0xb97b, 0xb99c, 0xb9bd, 0xb9de, 0xb9ff,
	0xba20, 0xba41, 0xba62, 0xba83, 0xbaa4, 0xbac5, 0xbae6, 0xbb07,
	0xbb28, 0xbb49, 0xbb6a, 0xbb8b, 0xbbac, 0xbbcd, 0xbbee, 0xbc0f,
	// Entry 9C80 - 9CBF
	0xbc30, 0xbc51, 0xbc72, 0xbc93, 0xbcb4, 0xbcd5, 0xbcf6, 0xbd17,
	0xbd38, 0xbd59, 0xbd7a, 0xbd9b, 0xbdbc, 0xbddd, 0xbdfe, 0xbe1f,
	0xbe40, 0xbe61, 0xbe82, 0xbea3, 0xbec4, 0xbee5, 0xbf06, 0xbf27,
	0xbf48, 0xbf69, 0xbf8a, 0xbfab, 0xbfcc, 0xbfed, 0xc00e, 0xc02f,
	0xc050, 0xc071, 0xc092, 0xc0b3, 0xc0d4, 0xc0f5, 0xc116, 0xc137,
	0xc158, 0xc179, 0xc19a, 0xc1bb, 0xc1dc, 0xc1fd, 0xc21e, 0xc23f,
	0xc260, 0xc281, 0xc2a2, 0xc2c3, 0xc2e4, 0xc305, 0xc326, 0xc347,
	0xc368, 0xc389, 0xc3aa, 0xc3cb, 0xc3ec, 0xc40d, 0xc42e, 0xc44f,
	// Entry 9CC0 - 9CFF
	0xc470, 0xc491, 0xc4b2, 0xc4d3, 0xc4f4, 0xc515, 0xc521, 0xc52a,
	0xc53e, 0xc550, 0xc55f, 0xc56e, 0xc57e, 0xc58b, 0xc599, 0xc5ad,
	0xc5c2, 0xc5ce, 0xc5db, 0xc5e4, 0xc5f4, 0xc601, 0xc60c, 0xc61a,
	0xc627, 0xc634, 0xc643, 0xc651, 0xc65f, 0xc66c, 0xc67b, 0xc68a,
	0xc698, 0xc6a1, 0xc6ae, 0xc6c0, 0xc6cf, 0xc6e4, 0xc6f5, 0xc706,
	0xc720, 0xc73a, 0xc754, 0xc76e, 0xc788, 0xc7a2, 0xc7bc, 0xc7d6,
	0xc7f0, 0xc80a, 0xc824, 0xc83e, 0xc858, 0xc872, 0xc88c, 0xc8a6,
	0xc8c0, 0xc8da, 0xc8f4, 0xc90e, 0xc928, 0xc942, 0xc95c, 0xc976,
	// Entry 9D00 - 9D3F
	0xc990, 0xc9aa, 0xc9c1, 0xc9d4, 0xc9ec, 0xca01, 0xca0d, 0xca1d,
	0xca35, 0xca4d, 0xca65, 0xca7d, 0xca95, 0xcaad, 0xcac5, 0xcadd,
	0xcaf5, 0xcb0d, 0xcb25, 0xcb3d, 0xcb55, 0xcb6d, 0xcb85, 0xcb9d,
	0xcbb5, 0xcbcd, 0xcbe5, 0xcbfd, 0xcc15, 0xcc2d, 0xcc45, 0xcc5d,
	0xcc75, 0xcc8d, 0xcca3, 0xccb4, 0xcccb, 0xccd4, 0xccde, 0xccf3,
	0xcd08, 0xcd1d, 0xcd32, 0xcd47, 0xcd5c, 0xcd71, 0xcd86, 0xcd9b,
	0xcdb0, 0xcdc5, 0xcdda, 0xcdef, 0xce04, 0xce19, 0xce2e, 0xce43,
	0xce58, 0xce6d, 0xce82, 0xce97, 0xceac, 0xcec1, 0xced6, 0xceeb,
	// Entry 9D40 - 9D7F
	0xcf00, 0xcf15, 0xcf2a, 0xcf3f, 0xcf54, 0xcf69, 0xcf7e, 0xcf93,
	0xcfa8, 0xcfbd, 0xcfd2, 0xcfe7, 0xcffc, 0xd011, 0xd026, 0xd03b,
	0xd050, 0xd065, 0xd07a, 0xd08f, 0xd0a4, 0xd0b9, 0xd0ce, 0xd0e3,
	0xd0f8, 0xd10d, 0xd122, 0xd137, 0xd14c, 0xd161, 0xd176, 0xd18b,
	0xd1a0, 0xd1b5, 0xd1ca, 0xd1df, 0xd1f4, 0xd209, 0xd21e, 0xd233,
	0xd248, 0xd25d, 0xd272, 0xd287, 0xd29c, 0xd2b1, 0xd2c6, 0xd2db,
	0xd2f0, 0xd305, 0xd31a, 0xd32f, 0xd344, 0xd359, 0xd36e, 0xd383,
	0xd398, 0xd3ad, 0xd3c3, 0xd3d9, 0xd3ef, 0xd405, 0xd41b, 0xd431,
	// Entry 9D80 - 9DBF
	0xd447, 0xd45d, 0xd473, 0xd489, 0xd49f, 0xd4b5, 0xd4cb, 0xd4e1,
	0xd4f7, 0xd50d, 0xd523, 0xd539, 0xd54f, 0xd565, 0xd57b, 0xd591,
	0xd5a7, 0xd5bd, 0xd5d3, 0xd5e9, 0xd5ff, 0xd615, 0xd62b, 0xd641,
	0xd657, 0xd66d, 0xd683, 0xd699, 0xd6af, 0xd6c5, 0xd6db, 0xd6f1,
	0xd707, 0xd71d, 0xd733, 0xd749, 0xd75f, 0xd775, 0xd78b, 0xd7a1,
	0xd7b7, 0xd7cd, 0xd7e3, 0xd7f9, 0xd80f, 0xd825, 0xd83b, 0xd851,
	0xd867, 0xd87d, 0xd893, 0xd8a9, 0xd8bf, 0xd8d5, 0xd8eb, 0xd901,
	0xd917, 0xd92d, 0xd943, 0xd959, 0xd96f, 0xd985, 0xd99b, 0xd9b1,
	// Entry 9DC0 - 9DFF
	0xd9c7, 0xd9dd, 0xd9f3, 0xda09, 0xda1f, 0xda35, 0xda4b, 0xda61,
	0xda77, 0xda8d, 0xdaa3, 0xdab9, 0xdacf, 0xdae5, 0xdafb, 0xdb11,
	0xdb27, 0xdb3d, 0xdb53, 0xdb69, 0xdb7f, 0xdb95, 0xdbab, 0xdbc1,
	0xdbd7, 0xdbed, 0xdc03, 0xdc19, 0xdc2f, 0xdc45, 0xdc5b, 0xdc71,
	0xdc87, 0xdc9d, 0xdcb3, 0xdcc9, 0xdcdf, 0xdcf5, 0xdd0b, 0xdd21,
	0xdd37, 0xdd4d, 0xdd63, 0xdd79, 0xdd8f, 0xdda5, 0xddbb, 0xddd1,
	0xdde7, 0xddfd, 0xde13, 0xde29, 0xde3f, 0xde55, 0xde6b, 0xde81,
	0xde97, 0xdead, 0xdec3, 0xded9, 0xdeef, 0xdf05, 0xdf1b, 0xdf31,
	// Entry 9E00 - 9E3F
	0xdf47, 0xdf5d, 0xdf73, 0xdf89, 0xdf9f, 0xdfb5, 0xdfcb, 0xdfe1,
	0xdff7, 0xe00d, 0xe023, 0xe039, 0xe04f, 0xe065, 0xe07b, 0xe091,
	0xe0a7, 0xe0bd, 0xe0d3, 0xe0e9, 0xe0ff, 0xe115, 0xe12b,
} // Size: 80966 bytes

const directData string = "" + // Size: 490 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph Extension G><CJK Ideograph Extension H>" +
	"<CJK Ideograph Extension I><CJK Ideograph Extension J><CJK Ideograph><Ha" +
	"ngul Syllable><Low Surrogate><Non Private Use High Surrogate><Plane 15 P" +
	"rivate Use><Plane 16 Private Use><Private Use High Surrogate><Private Us" +
	"e><Tangut Ideograph Supplement><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 1040683 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER TURNED AYBARMENIAN SMALL LETTER AYBARMENIAN SMAL" +
	"L LETTER BENARMENIAN SMALL LETTER GIMARMENIAN SMALL LETTER DAARMENIAN SM" +
	"ALL LETTER ECHARMENIAN SMALL LETTER ZAARMENIAN SMALL LETTER EHARMENIAN S" +
	"MALL LETTER ETARMENIAN SMALL LETTER TOARMENIAN SMALL LETTER ZHEARMENIAN " +
	"SMALL LETTER INIARMENIAN SMALL LETTER LIWNARMENIAN SMALL LETTER XEHARMEN" +
	"IAN SMALL LETTER CAARMENIAN SMALL LETTER KENARMENIAN SMALL LETTER HOARME" +
	"NIAN SMALL LETTER JAARMENIAN SMALL LETTER GHADARMENIAN SMALL LETTER CHEH" +
	"ARMENIAN SMALL LETTER MENARMENIAN SMALL LETTER YIARMENIAN SMALL LETTER N" +
	"OWARMENIAN SMALL LETTER SHAARMENIAN SMALL LETTER VOARMENIAN SMALL LETTER" +
	" CHAARMENIAN SMALL LETTER PEHARMENIAN SMALL LETTER JHEHARMENIAN SMALL LE" +
	"TTER RAARMENIAN SMALL LETTER SEHARMENIAN SMALL LETTER VEWARMENIAN SMALL " +
	"LETTER TIWNARMENIAN SMALL LETTER REHARMENIAN SMALL LETTER COARMENIAN SMA" +
	"LL LETTER YIWNARMENIAN SMALL LETTER PIWRARMENIAN SMALL LETTER KEHARMENIA" +
	"N SMALL LETTER OHARMENIAN SMALL LETTER FEHARMENIAN SMALL LIGATURE ECH YI" +
	"WNARMENIAN SMALL LETTER YI WITH STROKEARMENIAN FULL STOPARMENIAN HYPHENR" +
	"IGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGNARME" +
	"NIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT SHAL" +
	"SHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCENT TI" +
	"PEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW ACC" +
	"ENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH MUQ" +
	"DAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TELISHA" +
	" GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MUNAHH" +
	"EBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULAHEBR" +
	"EW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW ACC" +
	"ENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT DEHIH" +
	"EBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW POIN" +
	"T HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW POI" +
	"NT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW POI" +
	"NT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW POINT " +
	"QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATION M" +
	"AQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHEBREW" +
	" POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBREW MA" +
	"RK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANHEBRE" +
	"W LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALETHEBR" +
	"EW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEBREW " +
	"LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFHEBRE" +
	"W LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER FINA" +
	"L NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW LETTE" +
	"R FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSADIHE" +
	"BREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAVHEBR") + ("" +
	"EW YOD TRIANGLEHEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH" +
	" VAV YODHEBREW LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBRE" +
	"W PUNCTUATION GERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOT" +
	"E MARKERARABIC SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABI" +
	"C-INDIC CUBE ROOTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILL" +
	"E SIGNARABIC-INDIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC D" +
	"ATE SEPARATORARABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLAL" +
	"LAHOU ALAYHE WASSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH" +
	" ALAYHEARABIC SIGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HI" +
	"GH TAHARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH" +
	" ZAINARABIC SMALL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICO" +
	"LONARABIC LETTER MARKARABIC END OF TEXT MARKARABIC TRIPLE DOT PUNCTUATIO" +
	"N MARKARABIC QUESTION MARKARABIC LETTER KASHMIRI YEHARABIC LETTER HAMZAA" +
	"RABIC LETTER ALEF WITH MADDA ABOVEARABIC LETTER ALEF WITH HAMZA ABOVEARA" +
	"BIC LETTER WAW WITH HAMZA ABOVEARABIC LETTER ALEF WITH HAMZA BELOWARABIC" +
	" LETTER YEH WITH HAMZA ABOVEARABIC LETTER ALEFARABIC LETTER BEHARABIC LE" +
	"TTER TEH MARBUTAARABIC LETTER TEHARABIC LETTER THEHARABIC LETTER JEEMARA" +
	"BIC LETTER HAHARABIC LETTER KHAHARABIC LETTER DALARABIC LETTER THALARABI" +
	"C LETTER REHARABIC LETTER ZAINARABIC LETTER SEENARABIC LETTER SHEENARABI" +
	"C LETTER SADARABIC LETTER DADARABIC LETTER TAHARABIC LETTER ZAHARABIC LE" +
	"TTER AINARABIC LETTER GHAINARABIC LETTER KEHEH WITH TWO DOTS ABOVEARABIC" +
	" LETTER KEHEH WITH THREE DOTS BELOWARABIC LETTER FARSI YEH WITH INVERTED" +
	" VARABIC LETTER FARSI YEH WITH TWO DOTS ABOVEARABIC LETTER FARSI YEH WIT" +
	"H THREE DOTS ABOVEARABIC TATWEELARABIC LETTER FEHARABIC LETTER QAFARABIC" +
	" LETTER KAFARABIC LETTER LAMARABIC LETTER MEEMARABIC LETTER NOONARABIC L" +
	"ETTER HEHARABIC LETTER WAWARABIC LETTER ALEF MAKSURAARABIC LETTER YEHARA" +
	"BIC FATHATANARABIC DAMMATANARABIC KASRATANARABIC FATHAARABIC DAMMAARABIC" +
	" KASRAARABIC SHADDAARABIC SUKUNARABIC MADDAH ABOVEARABIC HAMZA ABOVEARAB" +
	"IC HAMZA BELOWARABIC SUBSCRIPT ALEFARABIC INVERTED DAMMAARABIC MARK NOON" +
	" GHUNNAARABIC ZWARAKAYARABIC VOWEL SIGN SMALL V ABOVEARABIC VOWEL SIGN I" +
	"NVERTED SMALL V ABOVEARABIC VOWEL SIGN DOT BELOWARABIC REVERSED DAMMAARA" +
	"BIC FATHA WITH TWO DOTSARABIC WAVY HAMZA BELOWARABIC-INDIC DIGIT ZEROARA" +
	"BIC-INDIC DIGIT ONEARABIC-INDIC DIGIT TWOARABIC-INDIC DIGIT THREEARABIC-" +
	"INDIC DIGIT FOURARABIC-INDIC DIGIT FIVEARABIC-INDIC DIGIT SIXARABIC-INDI" +
	"C DIGIT SEVENARABIC-INDIC DIGIT EIGHTARABIC-INDIC DIGIT NINEARABIC PERCE" +
	"NT SIGNARABIC DECIMAL SEPARATORARABIC THOUSANDS SEPARATORARABIC FIVE POI" +
	"NTED STARARABIC LETTER DOTLESS BEHARABIC LETTER DOTLESS QAFARABIC LETTER" +
	" SUPERSCRIPT ALEFARABIC LETTER ALEF WASLAARABIC LETTER ALEF WITH WAVY HA" +
	"MZA ABOVEARABIC LETTER ALEF WITH WAVY HAMZA BELOWARABIC LETTER HIGH HAMZ" +
	"AARABIC LETTER HIGH HAMZA ALEFARABIC LETTER HIGH HAMZA WAWARABIC LETTER " +
	"U WITH HAMZA ABOVEARABIC LETTER HIGH HAMZA YEHARABIC LETTER TTEHARABIC L" +
	"ETTER TTEHEHARABIC LETTER BEEHARABIC LETTER TEH WITH RINGARABIC LETTER T" +
	"EH WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER PEHARABIC LETTER TEHEHAR" +
	"ABIC LETTER BEHEHARABIC LETTER HAH WITH HAMZA ABOVEARABIC LETTER HAH WIT" +
	"H TWO DOTS VERTICAL ABOVEARABIC LETTER NYEHARABIC LETTER DYEHARABIC LETT" +
	"ER HAH WITH THREE DOTS ABOVEARABIC LETTER TCHEHARABIC LETTER TCHEHEHARAB" +
	"IC LETTER DDALARABIC LETTER DAL WITH RINGARABIC LETTER DAL WITH DOT BELO" +
	"WARABIC LETTER DAL WITH DOT BELOW AND SMALL TAHARABIC LETTER DAHALARABIC" +
	" LETTER DDAHALARABIC LETTER DULARABIC LETTER DAL WITH THREE DOTS ABOVE D" +
	"OWNWARDSARABIC LETTER DAL WITH FOUR DOTS ABOVEARABIC LETTER RREHARABIC L" +
	"ETTER REH WITH SMALL VARABIC LETTER REH WITH RINGARABIC LETTER REH WITH " +
	"DOT BELOWARABIC LETTER REH WITH SMALL V BELOWARABIC LETTER REH WITH DOT " +
	"BELOW AND DOT ABOVEARABIC LETTER REH WITH TWO DOTS ABOVEARABIC LETTER JE" +
	"HARABIC LETTER REH WITH FOUR DOTS ABOVEARABIC LETTER SEEN WITH DOT BELOW" +
	" AND DOT ABOVEARABIC LETTER SEEN WITH THREE DOTS BELOWARABIC LETTER SEEN" +
	" WITH THREE DOTS BELOW AND THREE DOTS ABOVEARABIC LETTER SAD WITH TWO DO" +
	"TS BELOWARABIC LETTER SAD WITH THREE DOTS ABOVEARABIC LETTER TAH WITH TH" +
	"REE DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS ABOVEARABIC LETTER DOTLE" +
	"SS FEHARABIC LETTER FEH WITH DOT MOVED BELOWARABIC LETTER FEH WITH DOT B" +
	"ELOWARABIC LETTER VEHARABIC LETTER FEH WITH THREE DOTS BELOWARABIC LETTE" +
	"R PEHEHARABIC LETTER QAF WITH DOT ABOVEARABIC LETTER QAF WITH THREE DOTS" +
	" ABOVEARABIC LETTER KEHEHARABIC LETTER SWASH KAFARABIC LETTER KAF WITH R" +
	"INGARABIC LETTER KAF WITH DOT ABOVEARABIC LETTER NGARABIC LETTER KAF WIT" +
	"H THREE DOTS BELOWARABIC LETTER GAFARABIC LETTER GAF WITH RINGARABIC LET") + ("" +
	"TER NGOEHARABIC LETTER GAF WITH TWO DOTS BELOWARABIC LETTER GUEHARABIC L" +
	"ETTER GAF WITH THREE DOTS ABOVEARABIC LETTER LAM WITH SMALL VARABIC LETT" +
	"ER LAM WITH DOT ABOVEARABIC LETTER LAM WITH THREE DOTS ABOVEARABIC LETTE" +
	"R LAM WITH THREE DOTS BELOWARABIC LETTER NOON WITH DOT BELOWARABIC LETTE" +
	"R NOON GHUNNAARABIC LETTER RNOONARABIC LETTER NOON WITH RINGARABIC LETTE" +
	"R NOON WITH THREE DOTS ABOVEARABIC LETTER HEH DOACHASHMEEARABIC LETTER T" +
	"CHEH WITH DOT ABOVEARABIC LETTER HEH WITH YEH ABOVEARABIC LETTER HEH GOA" +
	"LARABIC LETTER HEH GOAL WITH HAMZA ABOVEARABIC LETTER TEH MARBUTA GOALAR" +
	"ABIC LETTER WAW WITH RINGARABIC LETTER KIRGHIZ OEARABIC LETTER OEARABIC " +
	"LETTER UARABIC LETTER YUARABIC LETTER KIRGHIZ YUARABIC LETTER WAW WITH T" +
	"WO DOTS ABOVEARABIC LETTER VEARABIC LETTER FARSI YEHARABIC LETTER YEH WI" +
	"TH TAILARABIC LETTER YEH WITH SMALL VARABIC LETTER WAW WITH DOT ABOVEARA" +
	"BIC LETTER EARABIC LETTER YEH WITH THREE DOTS BELOWARABIC LETTER YEH BAR" +
	"REEARABIC LETTER YEH BARREE WITH HAMZA ABOVEARABIC FULL STOPARABIC LETTE" +
	"R AEARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURAARABIC SMAL" +
	"L HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURAARABIC SMALL HIGH MEEM INI" +
	"TIAL FORMARABIC SMALL HIGH LAM ALEFARABIC SMALL HIGH JEEMARABIC SMALL HI" +
	"GH THREE DOTSARABIC SMALL HIGH SEENARABIC END OF AYAHARABIC START OF RUB" +
	" EL HIZBARABIC SMALL HIGH ROUNDED ZEROARABIC SMALL HIGH UPRIGHT RECTANGU" +
	"LAR ZEROARABIC SMALL HIGH DOTLESS HEAD OF KHAHARABIC SMALL HIGH MEEM ISO" +
	"LATED FORMARABIC SMALL LOW SEENARABIC SMALL HIGH MADDAARABIC SMALL WAWAR" +
	"ABIC SMALL YEHARABIC SMALL HIGH YEHARABIC SMALL HIGH NOONARABIC PLACE OF" +
	" SAJDAHARABIC EMPTY CENTRE LOW STOPARABIC EMPTY CENTRE HIGH STOPARABIC R" +
	"OUNDED HIGH STOP WITH FILLED CENTREARABIC SMALL LOW MEEMARABIC LETTER DA" +
	"L WITH INVERTED VARABIC LETTER REH WITH INVERTED VEXTENDED ARABIC-INDIC " +
	"DIGIT ZEROEXTENDED ARABIC-INDIC DIGIT ONEEXTENDED ARABIC-INDIC DIGIT TWO" +
	"EXTENDED ARABIC-INDIC DIGIT THREEEXTENDED ARABIC-INDIC DIGIT FOUREXTENDE" +
	"D ARABIC-INDIC DIGIT FIVEEXTENDED ARABIC-INDIC DIGIT SIXEXTENDED ARABIC-" +
	"INDIC DIGIT SEVENEXTENDED ARABIC-INDIC DIGIT EIGHTEXTENDED ARABIC-INDIC " +
	"DIGIT NINEARABIC LETTER SHEEN WITH DOT BELOWARABIC LETTER DAD WITH DOT B" +
	"ELOWARABIC LETTER GHAIN WITH DOT BELOWARABIC SIGN SINDHI AMPERSANDARABIC" +
	" SIGN SINDHI POSTPOSITION MENARABIC LETTER HEH WITH INVERTED VSYRIAC END" +
	" OF PARAGRAPHSYRIAC SUPRALINEAR FULL STOPSYRIAC SUBLINEAR FULL STOPSYRIA" +
	"C SUPRALINEAR COLONSYRIAC SUBLINEAR COLONSYRIAC HORIZONTAL COLONSYRIAC C" +
	"OLON SKEWED LEFTSYRIAC COLON SKEWED RIGHTSYRIAC SUPRALINEAR COLON SKEWED" +
	" LEFTSYRIAC SUBLINEAR COLON SKEWED RIGHTSYRIAC CONTRACTIONSYRIAC HARKLEA" +
	"N OBELUSSYRIAC HARKLEAN METOBELUSSYRIAC HARKLEAN ASTERISCUSSYRIAC ABBREV" +
	"IATION MARKSYRIAC LETTER ALAPHSYRIAC LETTER SUPERSCRIPT ALAPHSYRIAC LETT" +
	"ER BETHSYRIAC LETTER GAMALSYRIAC LETTER GAMAL GARSHUNISYRIAC LETTER DALA" +
	"THSYRIAC LETTER DOTLESS DALATH RISHSYRIAC LETTER HESYRIAC LETTER WAWSYRI" +
	"AC LETTER ZAINSYRIAC LETTER HETHSYRIAC LETTER TETHSYRIAC LETTER TETH GAR" +
	"SHUNISYRIAC LETTER YUDHSYRIAC LETTER YUDH HESYRIAC LETTER KAPHSYRIAC LET" +
	"TER LAMADHSYRIAC LETTER MIMSYRIAC LETTER NUNSYRIAC LETTER SEMKATHSYRIAC " +
	"LETTER FINAL SEMKATHSYRIAC LETTER ESYRIAC LETTER PESYRIAC LETTER REVERSE" +
	"D PESYRIAC LETTER SADHESYRIAC LETTER QAPHSYRIAC LETTER RISHSYRIAC LETTER" +
	" SHINSYRIAC LETTER TAWSYRIAC LETTER PERSIAN BHETHSYRIAC LETTER PERSIAN G" +
	"HAMALSYRIAC LETTER PERSIAN DHALATHSYRIAC PTHAHA ABOVESYRIAC PTHAHA BELOW" +
	"SYRIAC PTHAHA DOTTEDSYRIAC ZQAPHA ABOVESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA " +
	"DOTTEDSYRIAC RBASA ABOVESYRIAC RBASA BELOWSYRIAC DOTTED ZLAMA HORIZONTAL" +
	"SYRIAC DOTTED ZLAMA ANGULARSYRIAC HBASA ABOVESYRIAC HBASA BELOWSYRIAC HB" +
	"ASA-ESASA DOTTEDSYRIAC ESASA ABOVESYRIAC ESASA BELOWSYRIAC RWAHASYRIAC F" +
	"EMININE DOTSYRIAC QUSHSHAYASYRIAC RUKKAKHASYRIAC TWO VERTICAL DOTS ABOVE" +
	"SYRIAC TWO VERTICAL DOTS BELOWSYRIAC THREE DOTS ABOVESYRIAC THREE DOTS B" +
	"ELOWSYRIAC OBLIQUE LINE ABOVESYRIAC OBLIQUE LINE BELOWSYRIAC MUSICSYRIAC" +
	" BARREKHSYRIAC LETTER SOGDIAN ZHAINSYRIAC LETTER SOGDIAN KHAPHSYRIAC LET" +
	"TER SOGDIAN FEARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOWARABIC" +
	" LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER BEH WITH TH" +
	"REE DOTS POINTING UPWARDS BELOWARABIC LETTER BEH WITH THREE DOTS POINTIN" +
	"G UPWARDS BELOW AND TWO DOTS ABOVEARABIC LETTER BEH WITH TWO DOTS BELOW " +
	"AND DOT ABOVEARABIC LETTER BEH WITH INVERTED SMALL V BELOWARABIC LETTER " +
	"BEH WITH SMALL VARABIC LETTER HAH WITH TWO DOTS ABOVEARABIC LETTER HAH W" +
	"ITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER DAL WITH TWO DOTS VER" +
	"TICALLY BELOW AND SMALL TAHARABIC LETTER DAL WITH INVERTED SMALL V BELOW" +
	"ARABIC LETTER REH WITH STROKEARABIC LETTER SEEN WITH FOUR DOTS ABOVEARAB") + ("" +
	"IC LETTER AIN WITH TWO DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS POINT" +
	"ING DOWNWARDS ABOVEARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVEARABI" +
	"C LETTER FEH WITH TWO DOTS BELOWARABIC LETTER FEH WITH THREE DOTS POINTI" +
	"NG UPWARDS BELOWARABIC LETTER KEHEH WITH DOT ABOVEARABIC LETTER KEHEH WI" +
	"TH THREE DOTS ABOVEARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS " +
	"BELOWARABIC LETTER MEEM WITH DOT ABOVEARABIC LETTER MEEM WITH DOT BELOWA" +
	"RABIC LETTER NOON WITH TWO DOTS BELOWARABIC LETTER NOON WITH SMALL TAHAR" +
	"ABIC LETTER NOON WITH SMALL VARABIC LETTER LAM WITH BARARABIC LETTER REH" +
	" WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER REH WITH HAMZA ABOVEARABIC " +
	"LETTER SEEN WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER HAH WITH SMALL A" +
	"RABIC LETTER TAH BELOWARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND" +
	" TWO DOTSARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTSARA" +
	"BIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER HA" +
	"H WITH SMALL ARABIC LETTER TAH ABOVEARABIC LETTER ALEF WITH EXTENDED ARA" +
	"BIC-INDIC DIGIT TWO ABOVEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC D" +
	"IGIT THREE ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT" +
	" TWO ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE" +
	" ABOVEARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELO" +
	"WARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETT" +
	"ER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER YEH BAR" +
	"REE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER YEH BARREE W" +
	"ITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER HAH WITH EXTEND" +
	"ED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER SEEN WITH EXTENDED ARABIC-" +
	"INDIC DIGIT FOUR ABOVEARABIC LETTER SEEN WITH INVERTED VARABIC LETTER KA" +
	"F WITH TWO DOTS ABOVETHAANA LETTER HAATHAANA LETTER SHAVIYANITHAANA LETT" +
	"ER NOONUTHAANA LETTER RAATHAANA LETTER BAATHAANA LETTER LHAVIYANITHAANA " +
	"LETTER KAAFUTHAANA LETTER ALIFUTHAANA LETTER VAAVUTHAANA LETTER MEEMUTHA" +
	"ANA LETTER FAAFUTHAANA LETTER DHAALUTHAANA LETTER THAATHAANA LETTER LAAM" +
	"UTHAANA LETTER GAAFUTHAANA LETTER GNAVIYANITHAANA LETTER SEENUTHAANA LET" +
	"TER DAVIYANITHAANA LETTER ZAVIYANITHAANA LETTER TAVIYANITHAANA LETTER YA" +
	"ATHAANA LETTER PAVIYANITHAANA LETTER JAVIYANITHAANA LETTER CHAVIYANITHAA" +
	"NA LETTER TTAATHAANA LETTER HHAATHAANA LETTER KHAATHAANA LETTER THAALUTH" +
	"AANA LETTER ZAATHAANA LETTER SHEENUTHAANA LETTER SAADHUTHAANA LETTER DAA" +
	"DHUTHAANA LETTER TOTHAANA LETTER ZOTHAANA LETTER AINUTHAANA LETTER GHAIN" +
	"UTHAANA LETTER QAAFUTHAANA LETTER WAAVUTHAANA ABAFILITHAANA AABAAFILITHA" +
	"ANA IBIFILITHAANA EEBEEFILITHAANA UBUFILITHAANA OOBOOFILITHAANA EBEFILIT" +
	"HAANA EYBEYFILITHAANA OBOFILITHAANA OABOAFILITHAANA SUKUNTHAANA LETTER N" +
	"AANKO DIGIT ZERONKO DIGIT ONENKO DIGIT TWONKO DIGIT THREENKO DIGIT FOURN" +
	"KO DIGIT FIVENKO DIGIT SIXNKO DIGIT SEVENNKO DIGIT EIGHTNKO DIGIT NINENK" +
	"O LETTER ANKO LETTER EENKO LETTER INKO LETTER ENKO LETTER UNKO LETTER OO" +
	"NKO LETTER ONKO LETTER DAGBASINNANKO LETTER NNKO LETTER BANKO LETTER PAN" +
	"KO LETTER TANKO LETTER JANKO LETTER CHANKO LETTER DANKO LETTER RANKO LET" +
	"TER RRANKO LETTER SANKO LETTER GBANKO LETTER FANKO LETTER KANKO LETTER L" +
	"ANKO LETTER NA WOLOSONKO LETTER MANKO LETTER NYANKO LETTER NANKO LETTER " +
	"HANKO LETTER WANKO LETTER YANKO LETTER NYA WOLOSONKO LETTER JONA JANKO L" +
	"ETTER JONA CHANKO LETTER JONA RANKO COMBINING SHORT HIGH TONENKO COMBINI" +
	"NG SHORT LOW TONENKO COMBINING SHORT RISING TONENKO COMBINING LONG DESCE" +
	"NDING TONENKO COMBINING LONG HIGH TONENKO COMBINING LONG LOW TONENKO COM" +
	"BINING LONG RISING TONENKO COMBINING NASALIZATION MARKNKO COMBINING DOUB" +
	"LE DOT ABOVENKO HIGH TONE APOSTROPHENKO LOW TONE APOSTROPHENKO SYMBOL OO" +
	" DENNENNKO SYMBOL GBAKURUNENNKO COMMANKO EXCLAMATION MARKNKO LAJANYALANN" +
	"KO DANTAYALANNKO DOROME SIGNNKO TAMAN SIGNSAMARITAN LETTER ALAFSAMARITAN" +
	" LETTER BITSAMARITAN LETTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER " +
	"IYSAMARITAN LETTER BAASAMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN L" +
	"ETTER TITSAMARITAN LETTER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABAT" +
	"SAMARITAN LETTER MIMSAMARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITA" +
	"N LETTER INSAMARITAN LETTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER Q" +
	"UFSAMARITAN LETTER RISHSAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARIT" +
	"AN MARK INSAMARITAN MARK IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK D" +
	"AGESHSAMARITAN MODIFIER LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC Y" +
	"UTSAMARITAN VOWEL SIGN LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN " +
	"OVERLONG AASAMARITAN VOWEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN " +
	"VOWEL SIGN OVERLONG ASAMARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASA" +
	"MARITAN MODIFIER LETTER SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOW") + ("" +
	"EL SIGN LONG USAMARITAN VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN" +
	" VOWEL SIGN LONG ISAMARITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN " +
	"VOWEL SIGN SUKUNSAMARITAN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMAR" +
	"ITAN PUNCTUATION AFSAAQSAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION " +
	"BAUSAMARITAN PUNCTUATION ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN" +
	" ABBREVIATION MARKSAMARITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATI" +
	"ON ZIQAASAMARITAN PUNCTUATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN P" +
	"UNCTUATION TURUSAMARITAN PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MA" +
	"SHFAATSAMARITAN PUNCTUATION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABM" +
	"ANDAIC LETTER AGMANDAIC LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNA" +
	"MANDAIC LETTER AZMANDAIC LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAM" +
	"ANDAIC LETTER AKMANDAIC LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDA" +
	"IC LETTER ASMANDAIC LETTER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC " +
	"LETTER AQMANDAIC LETTER ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LET" +
	"TER DUSHENNAMANDAIC LETTER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARK" +
	"MANDAIC VOCALIZATION MARKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIA" +
	"C LETTER MALAYALAM NGASYRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM " +
	"NYASYRIAC LETTER MALAYALAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER M" +
	"ALAYALAM NNNASYRIAC LETTER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC" +
	" LETTER MALAYALAM LLASYRIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM" +
	" SSAARABIC LETTER ALEF WITH ATTACHED FATHAARABIC LETTER ALEF WITH ATTACH" +
	"ED TOP RIGHT FATHAARABIC LETTER ALEF WITH RIGHT MIDDLE STROKEARABIC LETT" +
	"ER ALEF WITH LEFT MIDDLE STROKEARABIC LETTER ALEF WITH ATTACHED KASRAARA" +
	"BIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRAARABIC LETTER ALEF WITH " +
	"ATTACHED ROUND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED RIGHT ROUND DOT" +
	"ARABIC LETTER ALEF WITH ATTACHED LEFT ROUND DOTARABIC LETTER ALEF WITH A" +
	"TTACHED ROUND DOT BELOWARABIC LETTER ALEF WITH DOT ABOVEARABIC LETTER AL" +
	"EF WITH ATTACHED TOP RIGHT FATHA AND DOT ABOVEARABIC LETTER ALEF WITH RI" +
	"GHT MIDDLE STROKE AND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED BOTTOM R" +
	"IGHT KASRA AND DOT ABOVEARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA" +
	" AND LEFT RINGARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND LEFT RINGA" +
	"RABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND LEFT RINGARABIC L" +
	"ETTER ALEF WITH ATTACHED RIGHT HAMZAARABIC LETTER ALEF WITH ATTACHED LEF" +
	"T HAMZAARABIC TATWEEL WITH OVERSTRUCK HAMZAARABIC TATWEEL WITH OVERSTRUC" +
	"K WAWARABIC TATWEEL WITH TWO DOTS BELOWARABIC LETTER THIN YEHARABIC BASE" +
	"LINE ROUND DOTARABIC RAISED ROUND DOTARABIC LETTER NOON WITH INVERTED SM" +
	"ALL VARABIC LETTER HAH WITH INVERTED SMALL V BELOWARABIC LETTER TAH WITH" +
	" DOT BELOWARABIC LETTER TAH WITH THREE DOTS BELOWARABIC LETTER KEHEH WIT" +
	"H TWO DOTS VERTICALLY BELOWARABIC VERTICAL TAILARABIC LETTER NOON WITH R" +
	"ING ABOVEARABIC POUND MARK ABOVEARABIC PIASTRE MARK ABOVEARABIC PEPETARA" +
	"BIC SMALL HIGH WORD AL-JUZARABIC SMALL LOW WORD ISHMAAMARABIC SMALL LOW " +
	"WORD IMAALAARABIC SMALL LOW WORD TASHEELARABIC MADDA WAAJIBARABIC SUPERS" +
	"CRIPT ALEF MOKHASSASARABIC DOUBLED MADDAARABIC HALF MADDA OVER MADDAARAB" +
	"IC LETTER BEH WITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC" +
	" LETTER JEEM WITH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARA" +
	"BIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH" +
	" DOT BELOWARABIC LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE" +
	" DOTS ABOVEARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC L" +
	"ETTER YEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPAR" +
	"ABIC LETTER WAW WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER L" +
	"OW ALEFARABIC LETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THR" +
	"EE DOTS BELOWARABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGH" +
	"T WAWARABIC LETTER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THRE" +
	"E DOTS BELOWARABIC LETTER KAF WITH DOT BELOWARABIC LETTER QAF WITH DOT B" +
	"ELOW AND NO DOTS ABOVEARABIC LETTER BEH WITH SMALL MEEM ABOVEARABIC LETT" +
	"ER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH SMALL TEH ABOVEARABIC" +
	" LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH WITH TWO DOTS BELOW A" +
	"ND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC LETTER AFRICAN QAFARA" +
	"BIC LETTER AFRICAN NOONARABIC LETTER PEH WITH SMALL VARABIC LETTER TEH W" +
	"ITH SMALL VARABIC LETTER TTEH WITH SMALL VARABIC LETTER TCHEH WITH SMALL" +
	" VARABIC LETTER KEHEH WITH SMALL VARABIC LETTER GHAIN WITH THREE DOTS AB" +
	"OVEARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVEARABIC LETTER JEEM WIT" +
	"H THREE DOTS ABOVEARABIC LETTER JEEM WITH THREE DOTS BELOWARABIC LETTER " +
	"LAM WITH SMALL ARABIC LETTER TAH ABOVEARABIC LETTER GRAFARABIC SMALL FAR") + ("" +
	"SI YEHARABIC SMALL HIGH FARSI YEHARABIC SMALL HIGH YEH BARREE WITH TWO D" +
	"OTS BELOWARABIC SMALL HIGH WORD SAHARABIC SMALL HIGH ZAHARABIC LARGE ROU" +
	"ND DOT ABOVEARABIC LARGE ROUND DOT BELOWARABIC SUKUN BELOWARABIC LARGE C" +
	"IRCLE BELOWARABIC LARGE ROUND DOT INSIDE CIRCLE BELOWARABIC SMALL LOW WA" +
	"WARABIC SMALL HIGH WORD AR-RUBARABIC SMALL HIGH SADARABIC SMALL HIGH AIN" +
	"ARABIC SMALL HIGH QAFARABIC SMALL HIGH NOON WITH KASRAARABIC SMALL LOW N" +
	"OON WITH KASRAARABIC SMALL HIGH WORD ATH-THALATHAARABIC SMALL HIGH WORD " +
	"AS-SAJDAARABIC SMALL HIGH WORD AN-NISFARABIC SMALL HIGH WORD SAKTAARABIC" +
	" SMALL HIGH WORD QIFARABIC SMALL HIGH WORD WAQFAARABIC SMALL HIGH FOOTNO" +
	"TE MARKERARABIC SMALL HIGH SIGN SAFHAARABIC DISPUTED END OF AYAHARABIC T" +
	"URNED DAMMA BELOWARABIC CURLY FATHAARABIC CURLY DAMMAARABIC CURLY KASRAA" +
	"RABIC CURLY FATHATANARABIC CURLY DAMMATANARABIC CURLY KASRATANARABIC TON" +
	"E ONE DOT ABOVEARABIC TONE TWO DOTS ABOVEARABIC TONE LOOP ABOVEARABIC TO" +
	"NE ONE DOT BELOWARABIC TONE TWO DOTS BELOWARABIC TONE LOOP BELOWARABIC O" +
	"PEN FATHATANARABIC OPEN DAMMATANARABIC OPEN KASRATANARABIC SMALL HIGH WA" +
	"WARABIC FATHA WITH RINGARABIC FATHA WITH DOT ABOVEARABIC KASRA WITH DOT " +
	"BELOWARABIC LEFT ARROWHEAD ABOVEARABIC RIGHT ARROWHEAD ABOVEARABIC LEFT " +
	"ARROWHEAD BELOWARABIC RIGHT ARROWHEAD BELOWARABIC DOUBLE RIGHT ARROWHEAD" +
	" ABOVEARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOTARABIC RIGHT ARROWHEAD" +
	" ABOVE WITH DOTARABIC DAMMA WITH DOTARABIC MARK SIDEWAYS NOON GHUNNADEVA" +
	"NAGARI SIGN INVERTED CANDRABINDUDEVANAGARI SIGN CANDRABINDUDEVANAGARI SI" +
	"GN ANUSVARADEVANAGARI SIGN VISARGADEVANAGARI LETTER SHORT ADEVANAGARI LE" +
	"TTER ADEVANAGARI LETTER AADEVANAGARI LETTER IDEVANAGARI LETTER IIDEVANAG" +
	"ARI LETTER UDEVANAGARI LETTER UUDEVANAGARI LETTER VOCALIC RDEVANAGARI LE" +
	"TTER VOCALIC LDEVANAGARI LETTER CANDRA EDEVANAGARI LETTER SHORT EDEVANAG" +
	"ARI LETTER EDEVANAGARI LETTER AIDEVANAGARI LETTER CANDRA ODEVANAGARI LET" +
	"TER SHORT ODEVANAGARI LETTER ODEVANAGARI LETTER AUDEVANAGARI LETTER KADE" +
	"VANAGARI LETTER KHADEVANAGARI LETTER GADEVANAGARI LETTER GHADEVANAGARI L" +
	"ETTER NGADEVANAGARI LETTER CADEVANAGARI LETTER CHADEVANAGARI LETTER JADE" +
	"VANAGARI LETTER JHADEVANAGARI LETTER NYADEVANAGARI LETTER TTADEVANAGARI " +
	"LETTER TTHADEVANAGARI LETTER DDADEVANAGARI LETTER DDHADEVANAGARI LETTER " +
	"NNADEVANAGARI LETTER TADEVANAGARI LETTER THADEVANAGARI LETTER DADEVANAGA" +
	"RI LETTER DHADEVANAGARI LETTER NADEVANAGARI LETTER NNNADEVANAGARI LETTER" +
	" PADEVANAGARI LETTER PHADEVANAGARI LETTER BADEVANAGARI LETTER BHADEVANAG" +
	"ARI LETTER MADEVANAGARI LETTER YADEVANAGARI LETTER RADEVANAGARI LETTER R" +
	"RADEVANAGARI LETTER LADEVANAGARI LETTER LLADEVANAGARI LETTER LLLADEVANAG" +
	"ARI LETTER VADEVANAGARI LETTER SHADEVANAGARI LETTER SSADEVANAGARI LETTER" +
	" SADEVANAGARI LETTER HADEVANAGARI VOWEL SIGN OEDEVANAGARI VOWEL SIGN OOE" +
	"DEVANAGARI SIGN NUKTADEVANAGARI SIGN AVAGRAHADEVANAGARI VOWEL SIGN AADEV" +
	"ANAGARI VOWEL SIGN IDEVANAGARI VOWEL SIGN IIDEVANAGARI VOWEL SIGN UDEVAN" +
	"AGARI VOWEL SIGN UUDEVANAGARI VOWEL SIGN VOCALIC RDEVANAGARI VOWEL SIGN " +
	"VOCALIC RRDEVANAGARI VOWEL SIGN CANDRA EDEVANAGARI VOWEL SIGN SHORT EDEV" +
	"ANAGARI VOWEL SIGN EDEVANAGARI VOWEL SIGN AIDEVANAGARI VOWEL SIGN CANDRA" +
	" ODEVANAGARI VOWEL SIGN SHORT ODEVANAGARI VOWEL SIGN ODEVANAGARI VOWEL S" +
	"IGN AUDEVANAGARI SIGN VIRAMADEVANAGARI VOWEL SIGN PRISHTHAMATRA EDEVANAG" +
	"ARI VOWEL SIGN AWDEVANAGARI OMDEVANAGARI STRESS SIGN UDATTADEVANAGARI ST" +
	"RESS SIGN ANUDATTADEVANAGARI GRAVE ACCENTDEVANAGARI ACUTE ACCENTDEVANAGA" +
	"RI VOWEL SIGN CANDRA LONG EDEVANAGARI VOWEL SIGN UEDEVANAGARI VOWEL SIGN" +
	" UUEDEVANAGARI LETTER QADEVANAGARI LETTER KHHADEVANAGARI LETTER GHHADEVA" +
	"NAGARI LETTER ZADEVANAGARI LETTER DDDHADEVANAGARI LETTER RHADEVANAGARI L" +
	"ETTER FADEVANAGARI LETTER YYADEVANAGARI LETTER VOCALIC RRDEVANAGARI LETT" +
	"ER VOCALIC LLDEVANAGARI VOWEL SIGN VOCALIC LDEVANAGARI VOWEL SIGN VOCALI" +
	"C LLDEVANAGARI DANDADEVANAGARI DOUBLE DANDADEVANAGARI DIGIT ZERODEVANAGA" +
	"RI DIGIT ONEDEVANAGARI DIGIT TWODEVANAGARI DIGIT THREEDEVANAGARI DIGIT F" +
	"OURDEVANAGARI DIGIT FIVEDEVANAGARI DIGIT SIXDEVANAGARI DIGIT SEVENDEVANA" +
	"GARI DIGIT EIGHTDEVANAGARI DIGIT NINEDEVANAGARI ABBREVIATION SIGNDEVANAG" +
	"ARI SIGN HIGH SPACING DOTDEVANAGARI LETTER CANDRA ADEVANAGARI LETTER OED" +
	"EVANAGARI LETTER OOEDEVANAGARI LETTER AWDEVANAGARI LETTER UEDEVANAGARI L" +
	"ETTER UUEDEVANAGARI LETTER MARWARI DDADEVANAGARI LETTER ZHADEVANAGARI LE" +
	"TTER HEAVY YADEVANAGARI LETTER GGADEVANAGARI LETTER JJADEVANAGARI LETTER" +
	" GLOTTAL STOPDEVANAGARI LETTER DDDADEVANAGARI LETTER BBABENGALI ANJIBENG" +
	"ALI SIGN CANDRABINDUBENGALI SIGN ANUSVARABENGALI SIGN VISARGABENGALI LET" +
	"TER ABENGALI LETTER AABENGALI LETTER IBENGALI LETTER IIBENGALI LETTER UB" +
	"ENGALI LETTER UUBENGALI LETTER VOCALIC RBENGALI LETTER VOCALIC LBENGALI ") + ("" +
	"LETTER EBENGALI LETTER AIBENGALI LETTER OBENGALI LETTER AUBENGALI LETTER" +
	" KABENGALI LETTER KHABENGALI LETTER GABENGALI LETTER GHABENGALI LETTER N" +
	"GABENGALI LETTER CABENGALI LETTER CHABENGALI LETTER JABENGALI LETTER JHA" +
	"BENGALI LETTER NYABENGALI LETTER TTABENGALI LETTER TTHABENGALI LETTER DD" +
	"ABENGALI LETTER DDHABENGALI LETTER NNABENGALI LETTER TABENGALI LETTER TH" +
	"ABENGALI LETTER DABENGALI LETTER DHABENGALI LETTER NABENGALI LETTER PABE" +
	"NGALI LETTER PHABENGALI LETTER BABENGALI LETTER BHABENGALI LETTER MABENG" +
	"ALI LETTER YABENGALI LETTER RABENGALI LETTER LABENGALI LETTER SHABENGALI" +
	" LETTER SSABENGALI LETTER SABENGALI LETTER HABENGALI SIGN NUKTABENGALI S" +
	"IGN AVAGRAHABENGALI VOWEL SIGN AABENGALI VOWEL SIGN IBENGALI VOWEL SIGN " +
	"IIBENGALI VOWEL SIGN UBENGALI VOWEL SIGN UUBENGALI VOWEL SIGN VOCALIC RB" +
	"ENGALI VOWEL SIGN VOCALIC RRBENGALI VOWEL SIGN EBENGALI VOWEL SIGN AIBEN" +
	"GALI VOWEL SIGN OBENGALI VOWEL SIGN AUBENGALI SIGN VIRAMABENGALI LETTER " +
	"KHANDA TABENGALI AU LENGTH MARKBENGALI LETTER RRABENGALI LETTER RHABENGA" +
	"LI LETTER YYABENGALI LETTER VOCALIC RRBENGALI LETTER VOCALIC LLBENGALI V" +
	"OWEL SIGN VOCALIC LBENGALI VOWEL SIGN VOCALIC LLBENGALI DIGIT ZEROBENGAL" +
	"I DIGIT ONEBENGALI DIGIT TWOBENGALI DIGIT THREEBENGALI DIGIT FOURBENGALI" +
	" DIGIT FIVEBENGALI DIGIT SIXBENGALI DIGIT SEVENBENGALI DIGIT EIGHTBENGAL" +
	"I DIGIT NINEBENGALI LETTER RA WITH MIDDLE DIAGONALBENGALI LETTER RA WITH" +
	" LOWER DIAGONALBENGALI RUPEE MARKBENGALI RUPEE SIGNBENGALI CURRENCY NUME" +
	"RATOR ONEBENGALI CURRENCY NUMERATOR TWOBENGALI CURRENCY NUMERATOR THREEB" +
	"ENGALI CURRENCY NUMERATOR FOURBENGALI CURRENCY NUMERATOR ONE LESS THAN T" +
	"HE DENOMINATORBENGALI CURRENCY DENOMINATOR SIXTEENBENGALI ISSHARBENGALI " +
	"GANDA MARKBENGALI LETTER VEDIC ANUSVARABENGALI ABBREVIATION SIGNBENGALI " +
	"SANDHI MARKGURMUKHI SIGN ADAK BINDIGURMUKHI SIGN BINDIGURMUKHI SIGN VISA" +
	"RGAGURMUKHI LETTER AGURMUKHI LETTER AAGURMUKHI LETTER IGURMUKHI LETTER I" +
	"IGURMUKHI LETTER UGURMUKHI LETTER UUGURMUKHI LETTER EEGURMUKHI LETTER AI" +
	"GURMUKHI LETTER OOGURMUKHI LETTER AUGURMUKHI LETTER KAGURMUKHI LETTER KH" +
	"AGURMUKHI LETTER GAGURMUKHI LETTER GHAGURMUKHI LETTER NGAGURMUKHI LETTER" +
	" CAGURMUKHI LETTER CHAGURMUKHI LETTER JAGURMUKHI LETTER JHAGURMUKHI LETT" +
	"ER NYAGURMUKHI LETTER TTAGURMUKHI LETTER TTHAGURMUKHI LETTER DDAGURMUKHI" +
	" LETTER DDHAGURMUKHI LETTER NNAGURMUKHI LETTER TAGURMUKHI LETTER THAGURM" +
	"UKHI LETTER DAGURMUKHI LETTER DHAGURMUKHI LETTER NAGURMUKHI LETTER PAGUR" +
	"MUKHI LETTER PHAGURMUKHI LETTER BAGURMUKHI LETTER BHAGURMUKHI LETTER MAG" +
	"URMUKHI LETTER YAGURMUKHI LETTER RAGURMUKHI LETTER LAGURMUKHI LETTER LLA" +
	"GURMUKHI LETTER VAGURMUKHI LETTER SHAGURMUKHI LETTER SAGURMUKHI LETTER H" +
	"AGURMUKHI SIGN NUKTAGURMUKHI VOWEL SIGN AAGURMUKHI VOWEL SIGN IGURMUKHI " +
	"VOWEL SIGN IIGURMUKHI VOWEL SIGN UGURMUKHI VOWEL SIGN UUGURMUKHI VOWEL S" +
	"IGN EEGURMUKHI VOWEL SIGN AIGURMUKHI VOWEL SIGN OOGURMUKHI VOWEL SIGN AU" +
	"GURMUKHI SIGN VIRAMAGURMUKHI SIGN UDAATGURMUKHI LETTER KHHAGURMUKHI LETT" +
	"ER GHHAGURMUKHI LETTER ZAGURMUKHI LETTER RRAGURMUKHI LETTER FAGURMUKHI D" +
	"IGIT ZEROGURMUKHI DIGIT ONEGURMUKHI DIGIT TWOGURMUKHI DIGIT THREEGURMUKH" +
	"I DIGIT FOURGURMUKHI DIGIT FIVEGURMUKHI DIGIT SIXGURMUKHI DIGIT SEVENGUR" +
	"MUKHI DIGIT EIGHTGURMUKHI DIGIT NINEGURMUKHI TIPPIGURMUKHI ADDAKGURMUKHI" +
	" IRIGURMUKHI URAGURMUKHI EK ONKARGURMUKHI SIGN YAKASHGURMUKHI ABBREVIATI" +
	"ON SIGNGUJARATI SIGN CANDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SIGN VISA" +
	"RGAGUJARATI LETTER AGUJARATI LETTER AAGUJARATI LETTER IGUJARATI LETTER I" +
	"IGUJARATI LETTER UGUJARATI LETTER UUGUJARATI LETTER VOCALIC RGUJARATI LE" +
	"TTER VOCALIC LGUJARATI VOWEL CANDRA EGUJARATI LETTER EGUJARATI LETTER AI" +
	"GUJARATI VOWEL CANDRA OGUJARATI LETTER OGUJARATI LETTER AUGUJARATI LETTE" +
	"R KAGUJARATI LETTER KHAGUJARATI LETTER GAGUJARATI LETTER GHAGUJARATI LET" +
	"TER NGAGUJARATI LETTER CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJARATI L" +
	"ETTER JHAGUJARATI LETTER NYAGUJARATI LETTER TTAGUJARATI LETTER TTHAGUJAR" +
	"ATI LETTER DDAGUJARATI LETTER DDHAGUJARATI LETTER NNAGUJARATI LETTER TAG" +
	"UJARATI LETTER THAGUJARATI LETTER DAGUJARATI LETTER DHAGUJARATI LETTER N" +
	"AGUJARATI LETTER PAGUJARATI LETTER PHAGUJARATI LETTER BAGUJARATI LETTER " +
	"BHAGUJARATI LETTER MAGUJARATI LETTER YAGUJARATI LETTER RAGUJARATI LETTER" +
	" LAGUJARATI LETTER LLAGUJARATI LETTER VAGUJARATI LETTER SHAGUJARATI LETT" +
	"ER SSAGUJARATI LETTER SAGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJARATI SI" +
	"GN AVAGRAHAGUJARATI VOWEL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VOWEL SIG" +
	"N IIGUJARATI VOWEL SIGN UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIGN VOCAL" +
	"IC RGUJARATI VOWEL SIGN VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJARATI V" +
	"OWEL SIGN EGUJARATI VOWEL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJARATI VO" +
	"WEL SIGN OGUJARATI VOWEL SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGUJARATI ") + ("" +
	"LETTER VOCALIC RRGUJARATI LETTER VOCALIC LLGUJARATI VOWEL SIGN VOCALIC L" +
	"GUJARATI VOWEL SIGN VOCALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT ONEGUJAR" +
	"ATI DIGIT TWOGUJARATI DIGIT THREEGUJARATI DIGIT FOURGUJARATI DIGIT FIVEG" +
	"UJARATI DIGIT SIXGUJARATI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI DIGIT " +
	"NINEGUJARATI ABBREVIATION SIGNGUJARATI RUPEE SIGNGUJARATI LETTER ZHAGUJA" +
	"RATI SIGN SUKUNGUJARATI SIGN SHADDAGUJARATI SIGN MADDAHGUJARATI SIGN THR" +
	"EE-DOT NUKTA ABOVEGUJARATI SIGN CIRCLE NUKTA ABOVEGUJARATI SIGN TWO-CIRC" +
	"LE NUKTA ABOVEORIYA SIGN CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARG" +
	"AORIYA LETTER AORIYA LETTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER " +
	"UORIYA LETTER UUORIYA LETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER" +
	" EORIYA LETTER AIORIYA LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTE" +
	"R KHAORIYA LETTER GAORIYA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA" +
	" LETTER CHAORIYA LETTER JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER T" +
	"TAORIYA LETTER TTHAORIYA LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIY" +
	"A LETTER TAORIYA LETTER THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER N" +
	"AORIYA LETTER PAORIYA LETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LET" +
	"TER MAORIYA LETTER YAORIYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA" +
	" LETTER VAORIYA LETTER SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HA" +
	"ORIYA SIGN NUKTAORIYA SIGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN I" +
	"ORIYA VOWEL SIGN IIORIYA VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN" +
	" VOCALIC RORIYA VOWEL SIGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN " +
	"AIORIYA VOWEL SIGN OORIYA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA SIGN OVERL" +
	"INEORIYA AI LENGTH MARKORIYA AU LENGTH MARKORIYA LETTER RRAORIYA LETTER " +
	"RHAORIYA LETTER YYAORIYA LETTER VOCALIC RRORIYA LETTER VOCALIC LLORIYA V" +
	"OWEL SIGN VOCALIC LORIYA VOWEL SIGN VOCALIC LLORIYA DIGIT ZEROORIYA DIGI" +
	"T ONEORIYA DIGIT TWOORIYA DIGIT THREEORIYA DIGIT FOURORIYA DIGIT FIVEORI" +
	"YA DIGIT SIXORIYA DIGIT SEVENORIYA DIGIT EIGHTORIYA DIGIT NINEORIYA ISSH" +
	"ARORIYA LETTER WAORIYA FRACTION ONE QUARTERORIYA FRACTION ONE HALFORIYA " +
	"FRACTION THREE QUARTERSORIYA FRACTION ONE SIXTEENTHORIYA FRACTION ONE EI" +
	"GHTHORIYA FRACTION THREE SIXTEENTHSTAMIL SIGN ANUSVARATAMIL SIGN VISARGA" +
	"TAMIL LETTER ATAMIL LETTER AATAMIL LETTER ITAMIL LETTER IITAMIL LETTER U" +
	"TAMIL LETTER UUTAMIL LETTER ETAMIL LETTER EETAMIL LETTER AITAMIL LETTER " +
	"OTAMIL LETTER OOTAMIL LETTER AUTAMIL LETTER KATAMIL LETTER NGATAMIL LETT" +
	"ER CATAMIL LETTER JATAMIL LETTER NYATAMIL LETTER TTATAMIL LETTER NNATAMI" +
	"L LETTER TATAMIL LETTER NATAMIL LETTER NNNATAMIL LETTER PATAMIL LETTER M" +
	"ATAMIL LETTER YATAMIL LETTER RATAMIL LETTER RRATAMIL LETTER LATAMIL LETT" +
	"ER LLATAMIL LETTER LLLATAMIL LETTER VATAMIL LETTER SHATAMIL LETTER SSATA" +
	"MIL LETTER SATAMIL LETTER HATAMIL VOWEL SIGN AATAMIL VOWEL SIGN ITAMIL V" +
	"OWEL SIGN IITAMIL VOWEL SIGN UTAMIL VOWEL SIGN UUTAMIL VOWEL SIGN ETAMIL" +
	" VOWEL SIGN EETAMIL VOWEL SIGN AITAMIL VOWEL SIGN OTAMIL VOWEL SIGN OOTA" +
	"MIL VOWEL SIGN AUTAMIL SIGN VIRAMATAMIL OMTAMIL AU LENGTH MARKTAMIL DIGI" +
	"T ZEROTAMIL DIGIT ONETAMIL DIGIT TWOTAMIL DIGIT THREETAMIL DIGIT FOURTAM" +
	"IL DIGIT FIVETAMIL DIGIT SIXTAMIL DIGIT SEVENTAMIL DIGIT EIGHTTAMIL DIGI" +
	"T NINETAMIL NUMBER TENTAMIL NUMBER ONE HUNDREDTAMIL NUMBER ONE THOUSANDT" +
	"AMIL DAY SIGNTAMIL MONTH SIGNTAMIL YEAR SIGNTAMIL DEBIT SIGNTAMIL CREDIT" +
	" SIGNTAMIL AS ABOVE SIGNTAMIL RUPEE SIGNTAMIL NUMBER SIGNTELUGU SIGN COM" +
	"BINING CANDRABINDU ABOVETELUGU SIGN CANDRABINDUTELUGU SIGN ANUSVARATELUG" +
	"U SIGN VISARGATELUGU SIGN COMBINING ANUSVARA ABOVETELUGU LETTER ATELUGU " +
	"LETTER AATELUGU LETTER ITELUGU LETTER IITELUGU LETTER UTELUGU LETTER UUT" +
	"ELUGU LETTER VOCALIC RTELUGU LETTER VOCALIC LTELUGU LETTER ETELUGU LETTE" +
	"R EETELUGU LETTER AITELUGU LETTER OTELUGU LETTER OOTELUGU LETTER AUTELUG" +
	"U LETTER KATELUGU LETTER KHATELUGU LETTER GATELUGU LETTER GHATELUGU LETT" +
	"ER NGATELUGU LETTER CATELUGU LETTER CHATELUGU LETTER JATELUGU LETTER JHA" +
	"TELUGU LETTER NYATELUGU LETTER TTATELUGU LETTER TTHATELUGU LETTER DDATEL" +
	"UGU LETTER DDHATELUGU LETTER NNATELUGU LETTER TATELUGU LETTER THATELUGU " +
	"LETTER DATELUGU LETTER DHATELUGU LETTER NATELUGU LETTER PATELUGU LETTER " +
	"PHATELUGU LETTER BATELUGU LETTER BHATELUGU LETTER MATELUGU LETTER YATELU" +
	"GU LETTER RATELUGU LETTER RRATELUGU LETTER LATELUGU LETTER LLATELUGU LET" +
	"TER LLLATELUGU LETTER VATELUGU LETTER SHATELUGU LETTER SSATELUGU LETTER " +
	"SATELUGU LETTER HATELUGU SIGN NUKTATELUGU SIGN AVAGRAHATELUGU VOWEL SIGN" +
	" AATELUGU VOWEL SIGN ITELUGU VOWEL SIGN IITELUGU VOWEL SIGN UTELUGU VOWE" +
	"L SIGN UUTELUGU VOWEL SIGN VOCALIC RTELUGU VOWEL SIGN VOCALIC RRTELUGU V" +
	"OWEL SIGN ETELUGU VOWEL SIGN EETELUGU VOWEL SIGN AITELUGU VOWEL SIGN OTE" +
	"LUGU VOWEL SIGN OOTELUGU VOWEL SIGN AUTELUGU SIGN VIRAMATELUGU LENGTH MA") + ("" +
	"RKTELUGU AI LENGTH MARKTELUGU LETTER TSATELUGU LETTER DZATELUGU LETTER R" +
	"RRATELUGU ARCHAIC SHRIITELUGU LETTER NAKAARA POLLUTELUGU LETTER VOCALIC " +
	"RRTELUGU LETTER VOCALIC LLTELUGU VOWEL SIGN VOCALIC LTELUGU VOWEL SIGN V" +
	"OCALIC LLTELUGU DIGIT ZEROTELUGU DIGIT ONETELUGU DIGIT TWOTELUGU DIGIT T" +
	"HREETELUGU DIGIT FOURTELUGU DIGIT FIVETELUGU DIGIT SIXTELUGU DIGIT SEVEN" +
	"TELUGU DIGIT EIGHTTELUGU DIGIT NINETELUGU SIGN SIDDHAMTELUGU FRACTION DI" +
	"GIT ZERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR ODD POWERS " +
	"OF FOURTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOURTELUGU FRACTION D" +
	"IGIT THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR EVEN POWE" +
	"RS OF FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOURTELUGU FRACTI" +
	"ON DIGIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUUMUKANNADA SIGN SPAC" +
	"ING CANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN ANUSVARAKANNADA SIGN" +
	" VISARGAKANNADA SIGN SIDDHAMKANNADA LETTER AKANNADA LETTER AAKANNADA LET" +
	"TER IKANNADA LETTER IIKANNADA LETTER UKANNADA LETTER UUKANNADA LETTER VO" +
	"CALIC RKANNADA LETTER VOCALIC LKANNADA LETTER EKANNADA LETTER EEKANNADA " +
	"LETTER AIKANNADA LETTER OKANNADA LETTER OOKANNADA LETTER AUKANNADA LETTE" +
	"R KAKANNADA LETTER KHAKANNADA LETTER GAKANNADA LETTER GHAKANNADA LETTER " +
	"NGAKANNADA LETTER CAKANNADA LETTER CHAKANNADA LETTER JAKANNADA LETTER JH" +
	"AKANNADA LETTER NYAKANNADA LETTER TTAKANNADA LETTER TTHAKANNADA LETTER D" +
	"DAKANNADA LETTER DDHAKANNADA LETTER NNAKANNADA LETTER TAKANNADA LETTER T" +
	"HAKANNADA LETTER DAKANNADA LETTER DHAKANNADA LETTER NAKANNADA LETTER PAK" +
	"ANNADA LETTER PHAKANNADA LETTER BAKANNADA LETTER BHAKANNADA LETTER MAKAN" +
	"NADA LETTER YAKANNADA LETTER RAKANNADA LETTER RRAKANNADA LETTER LAKANNAD" +
	"A LETTER LLAKANNADA LETTER VAKANNADA LETTER SHAKANNADA LETTER SSAKANNADA" +
	" LETTER SAKANNADA LETTER HAKANNADA SIGN NUKTAKANNADA SIGN AVAGRAHAKANNAD" +
	"A VOWEL SIGN AAKANNADA VOWEL SIGN IKANNADA VOWEL SIGN IIKANNADA VOWEL SI" +
	"GN UKANNADA VOWEL SIGN UUKANNADA VOWEL SIGN VOCALIC RKANNADA VOWEL SIGN " +
	"VOCALIC RRKANNADA VOWEL SIGN EKANNADA VOWEL SIGN EEKANNADA VOWEL SIGN AI" +
	"KANNADA VOWEL SIGN OKANNADA VOWEL SIGN OOKANNADA VOWEL SIGN AUKANNADA SI" +
	"GN VIRAMAKANNADA LENGTH MARKKANNADA AI LENGTH MARKKANNADA ARCHAIC SHRIIK" +
	"ANNADA LETTER NAKAARA POLLUKANNADA LETTER FAKANNADA LETTER VOCALIC RRKAN" +
	"NADA LETTER VOCALIC LLKANNADA VOWEL SIGN VOCALIC LKANNADA VOWEL SIGN VOC" +
	"ALIC LLKANNADA DIGIT ZEROKANNADA DIGIT ONEKANNADA DIGIT TWOKANNADA DIGIT" +
	" THREEKANNADA DIGIT FOURKANNADA DIGIT FIVEKANNADA DIGIT SIXKANNADA DIGIT" +
	" SEVENKANNADA DIGIT EIGHTKANNADA DIGIT NINEKANNADA SIGN JIHVAMULIYAKANNA" +
	"DA SIGN UPADHMANIYAKANNADA SIGN COMBINING ANUSVARA ABOVE RIGHTMALAYALAM " +
	"SIGN COMBINING ANUSVARA ABOVEMALAYALAM SIGN CANDRABINDUMALAYALAM SIGN AN" +
	"USVARAMALAYALAM SIGN VISARGAMALAYALAM LETTER VEDIC ANUSVARAMALAYALAM LET" +
	"TER AMALAYALAM LETTER AAMALAYALAM LETTER IMALAYALAM LETTER IIMALAYALAM L" +
	"ETTER UMALAYALAM LETTER UUMALAYALAM LETTER VOCALIC RMALAYALAM LETTER VOC" +
	"ALIC LMALAYALAM LETTER EMALAYALAM LETTER EEMALAYALAM LETTER AIMALAYALAM " +
	"LETTER OMALAYALAM LETTER OOMALAYALAM LETTER AUMALAYALAM LETTER KAMALAYAL" +
	"AM LETTER KHAMALAYALAM LETTER GAMALAYALAM LETTER GHAMALAYALAM LETTER NGA" +
	"MALAYALAM LETTER CAMALAYALAM LETTER CHAMALAYALAM LETTER JAMALAYALAM LETT" +
	"ER JHAMALAYALAM LETTER NYAMALAYALAM LETTER TTAMALAYALAM LETTER TTHAMALAY" +
	"ALAM LETTER DDAMALAYALAM LETTER DDHAMALAYALAM LETTER NNAMALAYALAM LETTER" +
	" TAMALAYALAM LETTER THAMALAYALAM LETTER DAMALAYALAM LETTER DHAMALAYALAM " +
	"LETTER NAMALAYALAM LETTER NNNAMALAYALAM LETTER PAMALAYALAM LETTER PHAMAL" +
	"AYALAM LETTER BAMALAYALAM LETTER BHAMALAYALAM LETTER MAMALAYALAM LETTER " +
	"YAMALAYALAM LETTER RAMALAYALAM LETTER RRAMALAYALAM LETTER LAMALAYALAM LE" +
	"TTER LLAMALAYALAM LETTER LLLAMALAYALAM LETTER VAMALAYALAM LETTER SHAMALA" +
	"YALAM LETTER SSAMALAYALAM LETTER SAMALAYALAM LETTER HAMALAYALAM LETTER T" +
	"TTAMALAYALAM SIGN VERTICAL BAR VIRAMAMALAYALAM SIGN CIRCULAR VIRAMAMALAY" +
	"ALAM SIGN AVAGRAHAMALAYALAM VOWEL SIGN AAMALAYALAM VOWEL SIGN IMALAYALAM" +
	" VOWEL SIGN IIMALAYALAM VOWEL SIGN UMALAYALAM VOWEL SIGN UUMALAYALAM VOW" +
	"EL SIGN VOCALIC RMALAYALAM VOWEL SIGN VOCALIC RRMALAYALAM VOWEL SIGN EMA" +
	"LAYALAM VOWEL SIGN EEMALAYALAM VOWEL SIGN AIMALAYALAM VOWEL SIGN OMALAYA" +
	"LAM VOWEL SIGN OOMALAYALAM VOWEL SIGN AUMALAYALAM SIGN VIRAMAMALAYALAM L" +
	"ETTER DOT REPHMALAYALAM SIGN PARAMALAYALAM LETTER CHILLU MMALAYALAM LETT" +
	"ER CHILLU YMALAYALAM LETTER CHILLU LLLMALAYALAM AU LENGTH MARKMALAYALAM " +
	"FRACTION ONE ONE-HUNDRED-AND-SIXTIETHMALAYALAM FRACTION ONE FORTIETHMALA" +
	"YALAM FRACTION THREE EIGHTIETHSMALAYALAM FRACTION ONE TWENTIETHMALAYALAM" +
	" FRACTION ONE TENTHMALAYALAM FRACTION THREE TWENTIETHSMALAYALAM FRACTION" +
	" ONE FIFTHMALAYALAM LETTER ARCHAIC IIMALAYALAM LETTER VOCALIC RRMALAYALA") + ("" +
	"M LETTER VOCALIC LLMALAYALAM VOWEL SIGN VOCALIC LMALAYALAM VOWEL SIGN VO" +
	"CALIC LLMALAYALAM DIGIT ZEROMALAYALAM DIGIT ONEMALAYALAM DIGIT TWOMALAYA" +
	"LAM DIGIT THREEMALAYALAM DIGIT FOURMALAYALAM DIGIT FIVEMALAYALAM DIGIT S" +
	"IXMALAYALAM DIGIT SEVENMALAYALAM DIGIT EIGHTMALAYALAM DIGIT NINEMALAYALA" +
	"M NUMBER TENMALAYALAM NUMBER ONE HUNDREDMALAYALAM NUMBER ONE THOUSANDMAL" +
	"AYALAM FRACTION ONE QUARTERMALAYALAM FRACTION ONE HALFMALAYALAM FRACTION" +
	" THREE QUARTERSMALAYALAM FRACTION ONE SIXTEENTHMALAYALAM FRACTION ONE EI" +
	"GHTHMALAYALAM FRACTION THREE SIXTEENTHSMALAYALAM DATE MARKMALAYALAM LETT" +
	"ER CHILLU NNMALAYALAM LETTER CHILLU NMALAYALAM LETTER CHILLU RRMALAYALAM" +
	" LETTER CHILLU LMALAYALAM LETTER CHILLU LLMALAYALAM LETTER CHILLU KSINHA" +
	"LA SIGN CANDRABINDUSINHALA SIGN ANUSVARAYASINHALA SIGN VISARGAYASINHALA " +
	"LETTER AYANNASINHALA LETTER AAYANNASINHALA LETTER AEYANNASINHALA LETTER " +
	"AEEYANNASINHALA LETTER IYANNASINHALA LETTER IIYANNASINHALA LETTER UYANNA" +
	"SINHALA LETTER UUYANNASINHALA LETTER IRUYANNASINHALA LETTER IRUUYANNASIN" +
	"HALA LETTER ILUYANNASINHALA LETTER ILUUYANNASINHALA LETTER EYANNASINHALA" +
	" LETTER EEYANNASINHALA LETTER AIYANNASINHALA LETTER OYANNASINHALA LETTER" +
	" OOYANNASINHALA LETTER AUYANNASINHALA LETTER ALPAPRAANA KAYANNASINHALA L" +
	"ETTER MAHAAPRAANA KAYANNASINHALA LETTER ALPAPRAANA GAYANNASINHALA LETTER" +
	" MAHAAPRAANA GAYANNASINHALA LETTER KANTAJA NAASIKYAYASINHALA LETTER SANY" +
	"AKA GAYANNASINHALA LETTER ALPAPRAANA CAYANNASINHALA LETTER MAHAAPRAANA C" +
	"AYANNASINHALA LETTER ALPAPRAANA JAYANNASINHALA LETTER MAHAAPRAANA JAYANN" +
	"ASINHALA LETTER TAALUJA NAASIKYAYASINHALA LETTER TAALUJA SANYOOGA NAAKSI" +
	"KYAYASINHALA LETTER SANYAKA JAYANNASINHALA LETTER ALPAPRAANA TTAYANNASIN" +
	"HALA LETTER MAHAAPRAANA TTAYANNASINHALA LETTER ALPAPRAANA DDAYANNASINHAL" +
	"A LETTER MAHAAPRAANA DDAYANNASINHALA LETTER MUURDHAJA NAYANNASINHALA LET" +
	"TER SANYAKA DDAYANNASINHALA LETTER ALPAPRAANA TAYANNASINHALA LETTER MAHA" +
	"APRAANA TAYANNASINHALA LETTER ALPAPRAANA DAYANNASINHALA LETTER MAHAAPRAA" +
	"NA DAYANNASINHALA LETTER DANTAJA NAYANNASINHALA LETTER SANYAKA DAYANNASI" +
	"NHALA LETTER ALPAPRAANA PAYANNASINHALA LETTER MAHAAPRAANA PAYANNASINHALA" +
	" LETTER ALPAPRAANA BAYANNASINHALA LETTER MAHAAPRAANA BAYANNASINHALA LETT" +
	"ER MAYANNASINHALA LETTER AMBA BAYANNASINHALA LETTER YAYANNASINHALA LETTE" +
	"R RAYANNASINHALA LETTER DANTAJA LAYANNASINHALA LETTER VAYANNASINHALA LET" +
	"TER TAALUJA SAYANNASINHALA LETTER MUURDHAJA SAYANNASINHALA LETTER DANTAJ" +
	"A SAYANNASINHALA LETTER HAYANNASINHALA LETTER MUURDHAJA LAYANNASINHALA L" +
	"ETTER FAYANNASINHALA SIGN AL-LAKUNASINHALA VOWEL SIGN AELA-PILLASINHALA " +
	"VOWEL SIGN KETTI AEDA-PILLASINHALA VOWEL SIGN DIGA AEDA-PILLASINHALA VOW" +
	"EL SIGN KETTI IS-PILLASINHALA VOWEL SIGN DIGA IS-PILLASINHALA VOWEL SIGN" +
	" KETTI PAA-PILLASINHALA VOWEL SIGN DIGA PAA-PILLASINHALA VOWEL SIGN GAET" +
	"TA-PILLASINHALA VOWEL SIGN KOMBUVASINHALA VOWEL SIGN DIGA KOMBUVASINHALA" +
	" VOWEL SIGN KOMBU DEKASINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLASINHALA V" +
	"OWEL SIGN KOMBUVA HAA DIGA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HAA GAYA" +
	"NUKITTASINHALA VOWEL SIGN GAYANUKITTASINHALA LITH DIGIT ZEROSINHALA LITH" +
	" DIGIT ONESINHALA LITH DIGIT TWOSINHALA LITH DIGIT THREESINHALA LITH DIG" +
	"IT FOURSINHALA LITH DIGIT FIVESINHALA LITH DIGIT SIXSINHALA LITH DIGIT S" +
	"EVENSINHALA LITH DIGIT EIGHTSINHALA LITH DIGIT NINESINHALA VOWEL SIGN DI" +
	"GA GAETTA-PILLASINHALA VOWEL SIGN DIGA GAYANUKITTASINHALA PUNCTUATION KU" +
	"NDDALIYATHAI CHARACTER KO KAITHAI CHARACTER KHO KHAITHAI CHARACTER KHO K" +
	"HUATTHAI CHARACTER KHO KHWAITHAI CHARACTER KHO KHONTHAI CHARACTER KHO RA" +
	"KHANGTHAI CHARACTER NGO NGUTHAI CHARACTER CHO CHANTHAI CHARACTER CHO CHI" +
	"NGTHAI CHARACTER CHO CHANGTHAI CHARACTER SO SOTHAI CHARACTER CHO CHOETHA" +
	"I CHARACTER YO YINGTHAI CHARACTER DO CHADATHAI CHARACTER TO PATAKTHAI CH" +
	"ARACTER THO THANTHAI CHARACTER THO NANGMONTHOTHAI CHARACTER THO PHUTHAOT" +
	"HAI CHARACTER NO NENTHAI CHARACTER DO DEKTHAI CHARACTER TO TAOTHAI CHARA" +
	"CTER THO THUNGTHAI CHARACTER THO THAHANTHAI CHARACTER THO THONGTHAI CHAR" +
	"ACTER NO NUTHAI CHARACTER BO BAIMAITHAI CHARACTER PO PLATHAI CHARACTER P" +
	"HO PHUNGTHAI CHARACTER FO FATHAI CHARACTER PHO PHANTHAI CHARACTER FO FAN" +
	"THAI CHARACTER PHO SAMPHAOTHAI CHARACTER MO MATHAI CHARACTER YO YAKTHAI " +
	"CHARACTER RO RUATHAI CHARACTER RUTHAI CHARACTER LO LINGTHAI CHARACTER LU" +
	"THAI CHARACTER WO WAENTHAI CHARACTER SO SALATHAI CHARACTER SO RUSITHAI C" +
	"HARACTER SO SUATHAI CHARACTER HO HIPTHAI CHARACTER LO CHULATHAI CHARACTE" +
	"R O ANGTHAI CHARACTER HO NOKHUKTHAI CHARACTER PAIYANNOITHAI CHARACTER SA" +
	"RA ATHAI CHARACTER MAI HAN-AKATTHAI CHARACTER SARA AATHAI CHARACTER SARA" +
	" AMTHAI CHARACTER SARA ITHAI CHARACTER SARA IITHAI CHARACTER SARA UETHAI" +
	" CHARACTER SARA UEETHAI CHARACTER SARA UTHAI CHARACTER SARA UUTHAI CHARA") + ("" +
	"CTER PHINTHUTHAI CURRENCY SYMBOL BAHTTHAI CHARACTER SARA ETHAI CHARACTER" +
	" SARA AETHAI CHARACTER SARA OTHAI CHARACTER SARA AI MAIMUANTHAI CHARACTE" +
	"R SARA AI MAIMALAITHAI CHARACTER LAKKHANGYAOTHAI CHARACTER MAIYAMOKTHAI " +
	"CHARACTER MAITAIKHUTHAI CHARACTER MAI EKTHAI CHARACTER MAI THOTHAI CHARA" +
	"CTER MAI TRITHAI CHARACTER MAI CHATTAWATHAI CHARACTER THANTHAKHATTHAI CH" +
	"ARACTER NIKHAHITTHAI CHARACTER YAMAKKANTHAI CHARACTER FONGMANTHAI DIGIT " +
	"ZEROTHAI DIGIT ONETHAI DIGIT TWOTHAI DIGIT THREETHAI DIGIT FOURTHAI DIGI" +
	"T FIVETHAI DIGIT SIXTHAI DIGIT SEVENTHAI DIGIT EIGHTTHAI DIGIT NINETHAI " +
	"CHARACTER ANGKHANKHUTHAI CHARACTER KHOMUTLAO LETTER KOLAO LETTER KHO SUN" +
	"GLAO LETTER KHO TAMLAO LETTER PALI GHALAO LETTER NGOLAO LETTER COLAO LET" +
	"TER PALI CHALAO LETTER SO TAMLAO LETTER PALI JHALAO LETTER NYOLAO LETTER" +
	" PALI NYALAO LETTER PALI TTALAO LETTER PALI TTHALAO LETTER PALI DDALAO L" +
	"ETTER PALI DDHALAO LETTER PALI NNALAO LETTER DOLAO LETTER TOLAO LETTER T" +
	"HO SUNGLAO LETTER THO TAMLAO LETTER PALI DHALAO LETTER NOLAO LETTER BOLA" +
	"O LETTER POLAO LETTER PHO SUNGLAO LETTER FO TAMLAO LETTER PHO TAMLAO LET" +
	"TER FO SUNGLAO LETTER PALI BHALAO LETTER MOLAO LETTER YOLAO LETTER LO LI" +
	"NGLAO LETTER LO LOOTLAO LETTER WOLAO LETTER SANSKRIT SHALAO LETTER SANSK" +
	"RIT SSALAO LETTER SO SUNGLAO LETTER HO SUNGLAO LETTER PALI LLALAO LETTER" +
	" OLAO LETTER HO TAMLAO ELLIPSISLAO VOWEL SIGN ALAO VOWEL SIGN MAI KANLAO" +
	" VOWEL SIGN AALAO VOWEL SIGN AMLAO VOWEL SIGN ILAO VOWEL SIGN IILAO VOWE" +
	"L SIGN YLAO VOWEL SIGN YYLAO VOWEL SIGN ULAO VOWEL SIGN UULAO SIGN PALI " +
	"VIRAMALAO VOWEL SIGN MAI KONLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL SIGN NYOL" +
	"AO VOWEL SIGN ELAO VOWEL SIGN EILAO VOWEL SIGN OLAO VOWEL SIGN AYLAO VOW" +
	"EL SIGN AILAO KO LALAO TONE MAI EKLAO TONE MAI THOLAO TONE MAI TILAO TON" +
	"E MAI CATAWALAO CANCELLATION MARKLAO NIGGAHITALAO YAMAKKANLAO DIGIT ZERO" +
	"LAO DIGIT ONELAO DIGIT TWOLAO DIGIT THREELAO DIGIT FOURLAO DIGIT FIVELAO" +
	" DIGIT SIXLAO DIGIT SEVENLAO DIGIT EIGHTLAO DIGIT NINELAO HO NOLAO HO MO" +
	"LAO LETTER KHMU GOLAO LETTER KHMU NYOTIBETAN SYLLABLE OMTIBETAN MARK GTE" +
	"R YIG MGO TRUNCATED ATIBETAN MARK GTER YIG MGO -UM RNAM BCAD MATIBETAN M" +
	"ARK GTER YIG MGO -UM GTER TSHEG MATIBETAN MARK INITIAL YIG MGO MDUN MATI" +
	"BETAN MARK CLOSING YIG MGO SGAB MATIBETAN MARK CARET YIG MGO PHUR SHAD M" +
	"ATIBETAN MARK YIG MGO TSHEG SHAD MATIBETAN MARK SBRUL SHADTIBETAN MARK B" +
	"SKUR YIG MGOTIBETAN MARK BKA- SHOG YIG MGOTIBETAN MARK INTERSYLLABIC TSH" +
	"EGTIBETAN MARK DELIMITER TSHEG BSTARTIBETAN MARK SHADTIBETAN MARK NYIS S" +
	"HADTIBETAN MARK TSHEG SHADTIBETAN MARK NYIS TSHEG SHADTIBETAN MARK RIN C" +
	"HEN SPUNGS SHADTIBETAN MARK RGYA GRAM SHADTIBETAN MARK CARET -DZUD RTAGS" +
	" ME LONG CANTIBETAN MARK GTER TSHEGTIBETAN LOGOTYPE SIGN CHAD RTAGSTIBET" +
	"AN LOGOTYPE SIGN LHAG RTAGSTIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTA" +
	"GSTIBETAN ASTROLOGICAL SIGN -KHYUD PATIBETAN ASTROLOGICAL SIGN SDONG TSH" +
	"UGSTIBETAN SIGN RDEL DKAR GCIGTIBETAN SIGN RDEL DKAR GNYISTIBETAN SIGN R" +
	"DEL DKAR GSUMTIBETAN SIGN RDEL NAG GCIGTIBETAN SIGN RDEL NAG GNYISTIBETA" +
	"N SIGN RDEL DKAR RDEL NAGTIBETAN DIGIT ZEROTIBETAN DIGIT ONETIBETAN DIGI" +
	"T TWOTIBETAN DIGIT THREETIBETAN DIGIT FOURTIBETAN DIGIT FIVETIBETAN DIGI" +
	"T SIXTIBETAN DIGIT SEVENTIBETAN DIGIT EIGHTTIBETAN DIGIT NINETIBETAN DIG" +
	"IT HALF ONETIBETAN DIGIT HALF TWOTIBETAN DIGIT HALF THREETIBETAN DIGIT H" +
	"ALF FOURTIBETAN DIGIT HALF FIVETIBETAN DIGIT HALF SIXTIBETAN DIGIT HALF " +
	"SEVENTIBETAN DIGIT HALF EIGHTTIBETAN DIGIT HALF NINETIBETAN DIGIT HALF Z" +
	"EROTIBETAN MARK BSDUS RTAGSTIBETAN MARK NGAS BZUNG NYI ZLATIBETAN MARK C" +
	"ARET -DZUD RTAGS BZHI MIG CANTIBETAN MARK NGAS BZUNG SGOR RTAGSTIBETAN M" +
	"ARK CHE MGOTIBETAN MARK TSA -PHRUTIBETAN MARK GUG RTAGS GYONTIBETAN MARK" +
	" GUG RTAGS GYASTIBETAN MARK ANG KHANG GYONTIBETAN MARK ANG KHANG GYASTIB" +
	"ETAN SIGN YAR TSHESTIBETAN SIGN MAR TSHESTIBETAN LETTER KATIBETAN LETTER" +
	" KHATIBETAN LETTER GATIBETAN LETTER GHATIBETAN LETTER NGATIBETAN LETTER " +
	"CATIBETAN LETTER CHATIBETAN LETTER JATIBETAN LETTER NYATIBETAN LETTER TT" +
	"ATIBETAN LETTER TTHATIBETAN LETTER DDATIBETAN LETTER DDHATIBETAN LETTER " +
	"NNATIBETAN LETTER TATIBETAN LETTER THATIBETAN LETTER DATIBETAN LETTER DH" +
	"ATIBETAN LETTER NATIBETAN LETTER PATIBETAN LETTER PHATIBETAN LETTER BATI" +
	"BETAN LETTER BHATIBETAN LETTER MATIBETAN LETTER TSATIBETAN LETTER TSHATI" +
	"BETAN LETTER DZATIBETAN LETTER DZHATIBETAN LETTER WATIBETAN LETTER ZHATI" +
	"BETAN LETTER ZATIBETAN LETTER -ATIBETAN LETTER YATIBETAN LETTER RATIBETA" +
	"N LETTER LATIBETAN LETTER SHATIBETAN LETTER SSATIBETAN LETTER SATIBETAN " +
	"LETTER HATIBETAN LETTER ATIBETAN LETTER KSSATIBETAN LETTER FIXED-FORM RA" +
	"TIBETAN LETTER KKATIBETAN LETTER RRATIBETAN VOWEL SIGN AATIBETAN VOWEL S" +
	"IGN ITIBETAN VOWEL SIGN IITIBETAN VOWEL SIGN UTIBETAN VOWEL SIGN UUTIBET") + ("" +
	"AN VOWEL SIGN VOCALIC RTIBETAN VOWEL SIGN VOCALIC RRTIBETAN VOWEL SIGN V" +
	"OCALIC LTIBETAN VOWEL SIGN VOCALIC LLTIBETAN VOWEL SIGN ETIBETAN VOWEL S" +
	"IGN EETIBETAN VOWEL SIGN OTIBETAN VOWEL SIGN OOTIBETAN SIGN RJES SU NGA " +
	"ROTIBETAN SIGN RNAM BCADTIBETAN VOWEL SIGN REVERSED ITIBETAN VOWEL SIGN " +
	"REVERSED IITIBETAN SIGN NYI ZLA NAA DATIBETAN SIGN SNA LDANTIBETAN MARK " +
	"HALANTATIBETAN MARK PALUTATIBETAN SIGN LCI RTAGSTIBETAN SIGN YANG RTAGST" +
	"IBETAN SIGN LCE TSA CANTIBETAN SIGN MCHU CANTIBETAN SIGN GRU CAN RGYINGS" +
	"TIBETAN SIGN GRU MED RGYINGSTIBETAN SIGN INVERTED MCHU CANTIBETAN SUBJOI" +
	"NED SIGN LCE TSA CANTIBETAN SUBJOINED SIGN MCHU CANTIBETAN SUBJOINED SIG" +
	"N INVERTED MCHU CANTIBETAN SUBJOINED LETTER KATIBETAN SUBJOINED LETTER K" +
	"HATIBETAN SUBJOINED LETTER GATIBETAN SUBJOINED LETTER GHATIBETAN SUBJOIN" +
	"ED LETTER NGATIBETAN SUBJOINED LETTER CATIBETAN SUBJOINED LETTER CHATIBE" +
	"TAN SUBJOINED LETTER JATIBETAN SUBJOINED LETTER NYATIBETAN SUBJOINED LET" +
	"TER TTATIBETAN SUBJOINED LETTER TTHATIBETAN SUBJOINED LETTER DDATIBETAN " +
	"SUBJOINED LETTER DDHATIBETAN SUBJOINED LETTER NNATIBETAN SUBJOINED LETTE" +
	"R TATIBETAN SUBJOINED LETTER THATIBETAN SUBJOINED LETTER DATIBETAN SUBJO" +
	"INED LETTER DHATIBETAN SUBJOINED LETTER NATIBETAN SUBJOINED LETTER PATIB" +
	"ETAN SUBJOINED LETTER PHATIBETAN SUBJOINED LETTER BATIBETAN SUBJOINED LE" +
	"TTER BHATIBETAN SUBJOINED LETTER MATIBETAN SUBJOINED LETTER TSATIBETAN S" +
	"UBJOINED LETTER TSHATIBETAN SUBJOINED LETTER DZATIBETAN SUBJOINED LETTER" +
	" DZHATIBETAN SUBJOINED LETTER WATIBETAN SUBJOINED LETTER ZHATIBETAN SUBJ" +
	"OINED LETTER ZATIBETAN SUBJOINED LETTER -ATIBETAN SUBJOINED LETTER YATIB" +
	"ETAN SUBJOINED LETTER RATIBETAN SUBJOINED LETTER LATIBETAN SUBJOINED LET" +
	"TER SHATIBETAN SUBJOINED LETTER SSATIBETAN SUBJOINED LETTER SATIBETAN SU" +
	"BJOINED LETTER HATIBETAN SUBJOINED LETTER ATIBETAN SUBJOINED LETTER KSSA" +
	"TIBETAN SUBJOINED LETTER FIXED-FORM WATIBETAN SUBJOINED LETTER FIXED-FOR" +
	"M YATIBETAN SUBJOINED LETTER FIXED-FORM RATIBETAN KU RU KHATIBETAN KU RU" +
	" KHA BZHI MIG CANTIBETAN CANTILLATION SIGN HEAVY BEATTIBETAN CANTILLATIO" +
	"N SIGN LIGHT BEATTIBETAN CANTILLATION SIGN CANG TE-UTIBETAN CANTILLATION" +
	" SIGN SBUB -CHALTIBETAN SYMBOL DRIL BUTIBETAN SYMBOL RDO RJETIBETAN SYMB" +
	"OL PADMA GDANTIBETAN SYMBOL RDO RJE RGYA GRAMTIBETAN SYMBOL PHUR PATIBET" +
	"AN SYMBOL NOR BUTIBETAN SYMBOL NOR BU NYIS -KHYILTIBETAN SYMBOL NOR BU G" +
	"SUM -KHYILTIBETAN SYMBOL NOR BU BZHI -KHYILTIBETAN SIGN RDEL NAG RDEL DK" +
	"ARTIBETAN SIGN RDEL NAG GSUMTIBETAN MARK BSKA- SHOG GI MGO RGYANTIBETAN " +
	"MARK MNYAM YIG GI MGO RGYANTIBETAN MARK NYIS TSHEGTIBETAN MARK INITIAL B" +
	"RDA RNYING YIG MGO MDUN MATIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB " +
	"MARIGHT-FACING SVASTI SIGNLEFT-FACING SVASTI SIGNRIGHT-FACING SVASTI SIG" +
	"N WITH DOTSLEFT-FACING SVASTI SIGN WITH DOTSTIBETAN MARK LEADING MCHAN R" +
	"TAGSTIBETAN MARK TRAILING MCHAN RTAGSMYANMAR LETTER KAMYANMAR LETTER KHA" +
	"MYANMAR LETTER GAMYANMAR LETTER GHAMYANMAR LETTER NGAMYANMAR LETTER CAMY" +
	"ANMAR LETTER CHAMYANMAR LETTER JAMYANMAR LETTER JHAMYANMAR LETTER NYAMYA" +
	"NMAR LETTER NNYAMYANMAR LETTER TTAMYANMAR LETTER TTHAMYANMAR LETTER DDAM" +
	"YANMAR LETTER DDHAMYANMAR LETTER NNAMYANMAR LETTER TAMYANMAR LETTER THAM" +
	"YANMAR LETTER DAMYANMAR LETTER DHAMYANMAR LETTER NAMYANMAR LETTER PAMYAN" +
	"MAR LETTER PHAMYANMAR LETTER BAMYANMAR LETTER BHAMYANMAR LETTER MAMYANMA" +
	"R LETTER YAMYANMAR LETTER RAMYANMAR LETTER LAMYANMAR LETTER WAMYANMAR LE" +
	"TTER SAMYANMAR LETTER HAMYANMAR LETTER LLAMYANMAR LETTER AMYANMAR LETTER" +
	" SHAN AMYANMAR LETTER IMYANMAR LETTER IIMYANMAR LETTER UMYANMAR LETTER U" +
	"UMYANMAR LETTER EMYANMAR LETTER MON EMYANMAR LETTER OMYANMAR LETTER AUMY" +
	"ANMAR VOWEL SIGN TALL AAMYANMAR VOWEL SIGN AAMYANMAR VOWEL SIGN IMYANMAR" +
	" VOWEL SIGN IIMYANMAR VOWEL SIGN UMYANMAR VOWEL SIGN UUMYANMAR VOWEL SIG" +
	"N EMYANMAR VOWEL SIGN AIMYANMAR VOWEL SIGN MON IIMYANMAR VOWEL SIGN MON " +
	"OMYANMAR VOWEL SIGN E ABOVEMYANMAR SIGN ANUSVARAMYANMAR SIGN DOT BELOWMY" +
	"ANMAR SIGN VISARGAMYANMAR SIGN VIRAMAMYANMAR SIGN ASATMYANMAR CONSONANT " +
	"SIGN MEDIAL YAMYANMAR CONSONANT SIGN MEDIAL RAMYANMAR CONSONANT SIGN MED" +
	"IAL WAMYANMAR CONSONANT SIGN MEDIAL HAMYANMAR LETTER GREAT SAMYANMAR DIG" +
	"IT ZEROMYANMAR DIGIT ONEMYANMAR DIGIT TWOMYANMAR DIGIT THREEMYANMAR DIGI" +
	"T FOURMYANMAR DIGIT FIVEMYANMAR DIGIT SIXMYANMAR DIGIT SEVENMYANMAR DIGI" +
	"T EIGHTMYANMAR DIGIT NINEMYANMAR SIGN LITTLE SECTIONMYANMAR SIGN SECTION" +
	"MYANMAR SYMBOL LOCATIVEMYANMAR SYMBOL COMPLETEDMYANMAR SYMBOL AFOREMENTI" +
	"ONEDMYANMAR SYMBOL GENITIVEMYANMAR LETTER SHAMYANMAR LETTER SSAMYANMAR L" +
	"ETTER VOCALIC RMYANMAR LETTER VOCALIC RRMYANMAR LETTER VOCALIC LMYANMAR " +
	"LETTER VOCALIC LLMYANMAR VOWEL SIGN VOCALIC RMYANMAR VOWEL SIGN VOCALIC " +
	"RRMYANMAR VOWEL SIGN VOCALIC LMYANMAR VOWEL SIGN VOCALIC LLMYANMAR LETTE") + ("" +
	"R MON NGAMYANMAR LETTER MON JHAMYANMAR LETTER MON BBAMYANMAR LETTER MON " +
	"BBEMYANMAR CONSONANT SIGN MON MEDIAL NAMYANMAR CONSONANT SIGN MON MEDIAL" +
	" MAMYANMAR CONSONANT SIGN MON MEDIAL LAMYANMAR LETTER SGAW KAREN SHAMYAN" +
	"MAR VOWEL SIGN SGAW KAREN EUMYANMAR TONE MARK SGAW KAREN HATHIMYANMAR TO" +
	"NE MARK SGAW KAREN KE PHOMYANMAR LETTER WESTERN PWO KAREN THAMYANMAR LET" +
	"TER WESTERN PWO KAREN PWAMYANMAR VOWEL SIGN WESTERN PWO KAREN EUMYANMAR " +
	"VOWEL SIGN WESTERN PWO KAREN UEMYANMAR SIGN WESTERN PWO KAREN TONE-1MYAN" +
	"MAR SIGN WESTERN PWO KAREN TONE-2MYANMAR SIGN WESTERN PWO KAREN TONE-3MY" +
	"ANMAR SIGN WESTERN PWO KAREN TONE-4MYANMAR SIGN WESTERN PWO KAREN TONE-5" +
	"MYANMAR LETTER EASTERN PWO KAREN NNAMYANMAR LETTER EASTERN PWO KAREN YWA" +
	"MYANMAR LETTER EASTERN PWO KAREN GHWAMYANMAR VOWEL SIGN GEBA KAREN IMYAN" +
	"MAR VOWEL SIGN KAYAH OEMYANMAR VOWEL SIGN KAYAH UMYANMAR VOWEL SIGN KAYA" +
	"H EEMYANMAR LETTER SHAN KAMYANMAR LETTER SHAN KHAMYANMAR LETTER SHAN GAM" +
	"YANMAR LETTER SHAN CAMYANMAR LETTER SHAN ZAMYANMAR LETTER SHAN NYAMYANMA" +
	"R LETTER SHAN DAMYANMAR LETTER SHAN NAMYANMAR LETTER SHAN PHAMYANMAR LET" +
	"TER SHAN FAMYANMAR LETTER SHAN BAMYANMAR LETTER SHAN THAMYANMAR LETTER S" +
	"HAN HAMYANMAR CONSONANT SIGN SHAN MEDIAL WAMYANMAR VOWEL SIGN SHAN AAMYA" +
	"NMAR VOWEL SIGN SHAN EMYANMAR VOWEL SIGN SHAN E ABOVEMYANMAR VOWEL SIGN " +
	"SHAN FINAL YMYANMAR SIGN SHAN TONE-2MYANMAR SIGN SHAN TONE-3MYANMAR SIGN" +
	" SHAN TONE-5MYANMAR SIGN SHAN TONE-6MYANMAR SIGN SHAN COUNCIL TONE-2MYAN" +
	"MAR SIGN SHAN COUNCIL TONE-3MYANMAR SIGN SHAN COUNCIL EMPHATIC TONEMYANM" +
	"AR LETTER RUMAI PALAUNG FAMYANMAR SIGN RUMAI PALAUNG TONE-5MYANMAR SHAN " +
	"DIGIT ZEROMYANMAR SHAN DIGIT ONEMYANMAR SHAN DIGIT TWOMYANMAR SHAN DIGIT" +
	" THREEMYANMAR SHAN DIGIT FOURMYANMAR SHAN DIGIT FIVEMYANMAR SHAN DIGIT S" +
	"IXMYANMAR SHAN DIGIT SEVENMYANMAR SHAN DIGIT EIGHTMYANMAR SHAN DIGIT NIN" +
	"EMYANMAR SIGN KHAMTI TONE-1MYANMAR SIGN KHAMTI TONE-3MYANMAR VOWEL SIGN " +
	"AITON AMYANMAR VOWEL SIGN AITON AIMYANMAR SYMBOL SHAN ONEMYANMAR SYMBOL " +
	"SHAN EXCLAMATIONGEORGIAN CAPITAL LETTER ANGEORGIAN CAPITAL LETTER BANGEO" +
	"RGIAN CAPITAL LETTER GANGEORGIAN CAPITAL LETTER DONGEORGIAN CAPITAL LETT" +
	"ER ENGEORGIAN CAPITAL LETTER VINGEORGIAN CAPITAL LETTER ZENGEORGIAN CAPI" +
	"TAL LETTER TANGEORGIAN CAPITAL LETTER INGEORGIAN CAPITAL LETTER KANGEORG" +
	"IAN CAPITAL LETTER LASGEORGIAN CAPITAL LETTER MANGEORGIAN CAPITAL LETTER" +
	" NARGEORGIAN CAPITAL LETTER ONGEORGIAN CAPITAL LETTER PARGEORGIAN CAPITA" +
	"L LETTER ZHARGEORGIAN CAPITAL LETTER RAEGEORGIAN CAPITAL LETTER SANGEORG" +
	"IAN CAPITAL LETTER TARGEORGIAN CAPITAL LETTER UNGEORGIAN CAPITAL LETTER " +
	"PHARGEORGIAN CAPITAL LETTER KHARGEORGIAN CAPITAL LETTER GHANGEORGIAN CAP" +
	"ITAL LETTER QARGEORGIAN CAPITAL LETTER SHINGEORGIAN CAPITAL LETTER CHING" +
	"EORGIAN CAPITAL LETTER CANGEORGIAN CAPITAL LETTER JILGEORGIAN CAPITAL LE" +
	"TTER CILGEORGIAN CAPITAL LETTER CHARGEORGIAN CAPITAL LETTER XANGEORGIAN " +
	"CAPITAL LETTER JHANGEORGIAN CAPITAL LETTER HAEGEORGIAN CAPITAL LETTER HE" +
	"GEORGIAN CAPITAL LETTER HIEGEORGIAN CAPITAL LETTER WEGEORGIAN CAPITAL LE" +
	"TTER HARGEORGIAN CAPITAL LETTER HOEGEORGIAN CAPITAL LETTER YNGEORGIAN CA" +
	"PITAL LETTER AENGEORGIAN LETTER ANGEORGIAN LETTER BANGEORGIAN LETTER GAN" +
	"GEORGIAN LETTER DONGEORGIAN LETTER ENGEORGIAN LETTER VINGEORGIAN LETTER " +
	"ZENGEORGIAN LETTER TANGEORGIAN LETTER INGEORGIAN LETTER KANGEORGIAN LETT" +
	"ER LASGEORGIAN LETTER MANGEORGIAN LETTER NARGEORGIAN LETTER ONGEORGIAN L" +
	"ETTER PARGEORGIAN LETTER ZHARGEORGIAN LETTER RAEGEORGIAN LETTER SANGEORG" +
	"IAN LETTER TARGEORGIAN LETTER UNGEORGIAN LETTER PHARGEORGIAN LETTER KHAR" +
	"GEORGIAN LETTER GHANGEORGIAN LETTER QARGEORGIAN LETTER SHINGEORGIAN LETT" +
	"ER CHINGEORGIAN LETTER CANGEORGIAN LETTER JILGEORGIAN LETTER CILGEORGIAN" +
	" LETTER CHARGEORGIAN LETTER XANGEORGIAN LETTER JHANGEORGIAN LETTER HAEGE" +
	"ORGIAN LETTER HEGEORGIAN LETTER HIEGEORGIAN LETTER WEGEORGIAN LETTER HAR" +
	"GEORGIAN LETTER HOEGEORGIAN LETTER FIGEORGIAN LETTER YNGEORGIAN LETTER E" +
	"LIFIGEORGIAN LETTER TURNED GANGEORGIAN LETTER AINGEORGIAN PARAGRAPH SEPA" +
	"RATORMODIFIER LETTER GEORGIAN NARGEORGIAN LETTER AENGEORGIAN LETTER HARD" +
	" SIGNGEORGIAN LETTER LABIAL SIGNHANGUL CHOSEONG KIYEOKHANGUL CHOSEONG SS" +
	"ANGKIYEOKHANGUL CHOSEONG NIEUNHANGUL CHOSEONG TIKEUTHANGUL CHOSEONG SSAN" +
	"GTIKEUTHANGUL CHOSEONG RIEULHANGUL CHOSEONG MIEUMHANGUL CHOSEONG PIEUPHA" +
	"NGUL CHOSEONG SSANGPIEUPHANGUL CHOSEONG SIOSHANGUL CHOSEONG SSANGSIOSHAN" +
	"GUL CHOSEONG IEUNGHANGUL CHOSEONG CIEUCHANGUL CHOSEONG SSANGCIEUCHANGUL " +
	"CHOSEONG CHIEUCHHANGUL CHOSEONG KHIEUKHHANGUL CHOSEONG THIEUTHHANGUL CHO" +
	"SEONG PHIEUPHHANGUL CHOSEONG HIEUHHANGUL CHOSEONG NIEUN-KIYEOKHANGUL CHO" +
	"SEONG SSANGNIEUNHANGUL CHOSEONG NIEUN-TIKEUTHANGUL CHOSEONG NIEUN-PIEUPH" +
	"ANGUL CHOSEONG TIKEUT-KIYEOKHANGUL CHOSEONG RIEUL-NIEUNHANGUL CHOSEONG S") + ("" +
	"SANGRIEULHANGUL CHOSEONG RIEUL-HIEUHHANGUL CHOSEONG KAPYEOUNRIEULHANGUL " +
	"CHOSEONG MIEUM-PIEUPHANGUL CHOSEONG KAPYEOUNMIEUMHANGUL CHOSEONG PIEUP-K" +
	"IYEOKHANGUL CHOSEONG PIEUP-NIEUNHANGUL CHOSEONG PIEUP-TIKEUTHANGUL CHOSE" +
	"ONG PIEUP-SIOSHANGUL CHOSEONG PIEUP-SIOS-KIYEOKHANGUL CHOSEONG PIEUP-SIO" +
	"S-TIKEUTHANGUL CHOSEONG PIEUP-SIOS-PIEUPHANGUL CHOSEONG PIEUP-SSANGSIOSH" +
	"ANGUL CHOSEONG PIEUP-SIOS-CIEUCHANGUL CHOSEONG PIEUP-CIEUCHANGUL CHOSEON" +
	"G PIEUP-CHIEUCHHANGUL CHOSEONG PIEUP-THIEUTHHANGUL CHOSEONG PIEUP-PHIEUP" +
	"HHANGUL CHOSEONG KAPYEOUNPIEUPHANGUL CHOSEONG KAPYEOUNSSANGPIEUPHANGUL C" +
	"HOSEONG SIOS-KIYEOKHANGUL CHOSEONG SIOS-NIEUNHANGUL CHOSEONG SIOS-TIKEUT" +
	"HANGUL CHOSEONG SIOS-RIEULHANGUL CHOSEONG SIOS-MIEUMHANGUL CHOSEONG SIOS" +
	"-PIEUPHANGUL CHOSEONG SIOS-PIEUP-KIYEOKHANGUL CHOSEONG SIOS-SSANGSIOSHAN" +
	"GUL CHOSEONG SIOS-IEUNGHANGUL CHOSEONG SIOS-CIEUCHANGUL CHOSEONG SIOS-CH" +
	"IEUCHHANGUL CHOSEONG SIOS-KHIEUKHHANGUL CHOSEONG SIOS-THIEUTHHANGUL CHOS" +
	"EONG SIOS-PHIEUPHHANGUL CHOSEONG SIOS-HIEUHHANGUL CHOSEONG CHITUEUMSIOSH" +
	"ANGUL CHOSEONG CHITUEUMSSANGSIOSHANGUL CHOSEONG CEONGCHIEUMSIOSHANGUL CH" +
	"OSEONG CEONGCHIEUMSSANGSIOSHANGUL CHOSEONG PANSIOSHANGUL CHOSEONG IEUNG-" +
	"KIYEOKHANGUL CHOSEONG IEUNG-TIKEUTHANGUL CHOSEONG IEUNG-MIEUMHANGUL CHOS" +
	"EONG IEUNG-PIEUPHANGUL CHOSEONG IEUNG-SIOSHANGUL CHOSEONG IEUNG-PANSIOSH" +
	"ANGUL CHOSEONG SSANGIEUNGHANGUL CHOSEONG IEUNG-CIEUCHANGUL CHOSEONG IEUN" +
	"G-CHIEUCHHANGUL CHOSEONG IEUNG-THIEUTHHANGUL CHOSEONG IEUNG-PHIEUPHHANGU" +
	"L CHOSEONG YESIEUNGHANGUL CHOSEONG CIEUC-IEUNGHANGUL CHOSEONG CHITUEUMCI" +
	"EUCHANGUL CHOSEONG CHITUEUMSSANGCIEUCHANGUL CHOSEONG CEONGCHIEUMCIEUCHAN" +
	"GUL CHOSEONG CEONGCHIEUMSSANGCIEUCHANGUL CHOSEONG CHIEUCH-KHIEUKHHANGUL " +
	"CHOSEONG CHIEUCH-HIEUHHANGUL CHOSEONG CHITUEUMCHIEUCHHANGUL CHOSEONG CEO" +
	"NGCHIEUMCHIEUCHHANGUL CHOSEONG PHIEUPH-PIEUPHANGUL CHOSEONG KAPYEOUNPHIE" +
	"UPHHANGUL CHOSEONG SSANGHIEUHHANGUL CHOSEONG YEORINHIEUHHANGUL CHOSEONG " +
	"KIYEOK-TIKEUTHANGUL CHOSEONG NIEUN-SIOSHANGUL CHOSEONG NIEUN-CIEUCHANGUL" +
	" CHOSEONG NIEUN-HIEUHHANGUL CHOSEONG TIKEUT-RIEULHANGUL CHOSEONG FILLERH" +
	"ANGUL JUNGSEONG FILLERHANGUL JUNGSEONG AHANGUL JUNGSEONG AEHANGUL JUNGSE" +
	"ONG YAHANGUL JUNGSEONG YAEHANGUL JUNGSEONG EOHANGUL JUNGSEONG EHANGUL JU" +
	"NGSEONG YEOHANGUL JUNGSEONG YEHANGUL JUNGSEONG OHANGUL JUNGSEONG WAHANGU" +
	"L JUNGSEONG WAEHANGUL JUNGSEONG OEHANGUL JUNGSEONG YOHANGUL JUNGSEONG UH" +
	"ANGUL JUNGSEONG WEOHANGUL JUNGSEONG WEHANGUL JUNGSEONG WIHANGUL JUNGSEON" +
	"G YUHANGUL JUNGSEONG EUHANGUL JUNGSEONG YIHANGUL JUNGSEONG IHANGUL JUNGS" +
	"EONG A-OHANGUL JUNGSEONG A-UHANGUL JUNGSEONG YA-OHANGUL JUNGSEONG YA-YOH" +
	"ANGUL JUNGSEONG EO-OHANGUL JUNGSEONG EO-UHANGUL JUNGSEONG EO-EUHANGUL JU" +
	"NGSEONG YEO-OHANGUL JUNGSEONG YEO-UHANGUL JUNGSEONG O-EOHANGUL JUNGSEONG" +
	" O-EHANGUL JUNGSEONG O-YEHANGUL JUNGSEONG O-OHANGUL JUNGSEONG O-UHANGUL " +
	"JUNGSEONG YO-YAHANGUL JUNGSEONG YO-YAEHANGUL JUNGSEONG YO-YEOHANGUL JUNG" +
	"SEONG YO-OHANGUL JUNGSEONG YO-IHANGUL JUNGSEONG U-AHANGUL JUNGSEONG U-AE" +
	"HANGUL JUNGSEONG U-EO-EUHANGUL JUNGSEONG U-YEHANGUL JUNGSEONG U-UHANGUL " +
	"JUNGSEONG YU-AHANGUL JUNGSEONG YU-EOHANGUL JUNGSEONG YU-EHANGUL JUNGSEON" +
	"G YU-YEOHANGUL JUNGSEONG YU-YEHANGUL JUNGSEONG YU-UHANGUL JUNGSEONG YU-I" +
	"HANGUL JUNGSEONG EU-UHANGUL JUNGSEONG EU-EUHANGUL JUNGSEONG YI-UHANGUL J" +
	"UNGSEONG I-AHANGUL JUNGSEONG I-YAHANGUL JUNGSEONG I-OHANGUL JUNGSEONG I-" +
	"UHANGUL JUNGSEONG I-EUHANGUL JUNGSEONG I-ARAEAHANGUL JUNGSEONG ARAEAHANG" +
	"UL JUNGSEONG ARAEA-EOHANGUL JUNGSEONG ARAEA-UHANGUL JUNGSEONG ARAEA-IHAN" +
	"GUL JUNGSEONG SSANGARAEAHANGUL JUNGSEONG A-EUHANGUL JUNGSEONG YA-UHANGUL" +
	" JUNGSEONG YEO-YAHANGUL JUNGSEONG O-YAHANGUL JUNGSEONG O-YAEHANGUL JONGS" +
	"EONG KIYEOKHANGUL JONGSEONG SSANGKIYEOKHANGUL JONGSEONG KIYEOK-SIOSHANGU" +
	"L JONGSEONG NIEUNHANGUL JONGSEONG NIEUN-CIEUCHANGUL JONGSEONG NIEUN-HIEU" +
	"HHANGUL JONGSEONG TIKEUTHANGUL JONGSEONG RIEULHANGUL JONGSEONG RIEUL-KIY" +
	"EOKHANGUL JONGSEONG RIEUL-MIEUMHANGUL JONGSEONG RIEUL-PIEUPHANGUL JONGSE" +
	"ONG RIEUL-SIOSHANGUL JONGSEONG RIEUL-THIEUTHHANGUL JONGSEONG RIEUL-PHIEU" +
	"PHHANGUL JONGSEONG RIEUL-HIEUHHANGUL JONGSEONG MIEUMHANGUL JONGSEONG PIE" +
	"UPHANGUL JONGSEONG PIEUP-SIOSHANGUL JONGSEONG SIOSHANGUL JONGSEONG SSANG" +
	"SIOSHANGUL JONGSEONG IEUNGHANGUL JONGSEONG CIEUCHANGUL JONGSEONG CHIEUCH" +
	"HANGUL JONGSEONG KHIEUKHHANGUL JONGSEONG THIEUTHHANGUL JONGSEONG PHIEUPH" +
	"HANGUL JONGSEONG HIEUHHANGUL JONGSEONG KIYEOK-RIEULHANGUL JONGSEONG KIYE" +
	"OK-SIOS-KIYEOKHANGUL JONGSEONG NIEUN-KIYEOKHANGUL JONGSEONG NIEUN-TIKEUT" +
	"HANGUL JONGSEONG NIEUN-SIOSHANGUL JONGSEONG NIEUN-PANSIOSHANGUL JONGSEON" +
	"G NIEUN-THIEUTHHANGUL JONGSEONG TIKEUT-KIYEOKHANGUL JONGSEONG TIKEUT-RIE" +
	"ULHANGUL JONGSEONG RIEUL-KIYEOK-SIOSHANGUL JONGSEONG RIEUL-NIEUNHANGUL J" +
	"ONGSEONG RIEUL-TIKEUTHANGUL JONGSEONG RIEUL-TIKEUT-HIEUHHANGUL JONGSEONG") + ("" +
	" SSANGRIEULHANGUL JONGSEONG RIEUL-MIEUM-KIYEOKHANGUL JONGSEONG RIEUL-MIE" +
	"UM-SIOSHANGUL JONGSEONG RIEUL-PIEUP-SIOSHANGUL JONGSEONG RIEUL-PIEUP-HIE" +
	"UHHANGUL JONGSEONG RIEUL-KAPYEOUNPIEUPHANGUL JONGSEONG RIEUL-SSANGSIOSHA" +
	"NGUL JONGSEONG RIEUL-PANSIOSHANGUL JONGSEONG RIEUL-KHIEUKHHANGUL JONGSEO" +
	"NG RIEUL-YEORINHIEUHHANGUL JONGSEONG MIEUM-KIYEOKHANGUL JONGSEONG MIEUM-" +
	"RIEULHANGUL JONGSEONG MIEUM-PIEUPHANGUL JONGSEONG MIEUM-SIOSHANGUL JONGS" +
	"EONG MIEUM-SSANGSIOSHANGUL JONGSEONG MIEUM-PANSIOSHANGUL JONGSEONG MIEUM" +
	"-CHIEUCHHANGUL JONGSEONG MIEUM-HIEUHHANGUL JONGSEONG KAPYEOUNMIEUMHANGUL" +
	" JONGSEONG PIEUP-RIEULHANGUL JONGSEONG PIEUP-PHIEUPHHANGUL JONGSEONG PIE" +
	"UP-HIEUHHANGUL JONGSEONG KAPYEOUNPIEUPHANGUL JONGSEONG SIOS-KIYEOKHANGUL" +
	" JONGSEONG SIOS-TIKEUTHANGUL JONGSEONG SIOS-RIEULHANGUL JONGSEONG SIOS-P" +
	"IEUPHANGUL JONGSEONG PANSIOSHANGUL JONGSEONG IEUNG-KIYEOKHANGUL JONGSEON" +
	"G IEUNG-SSANGKIYEOKHANGUL JONGSEONG SSANGIEUNGHANGUL JONGSEONG IEUNG-KHI" +
	"EUKHHANGUL JONGSEONG YESIEUNGHANGUL JONGSEONG YESIEUNG-SIOSHANGUL JONGSE" +
	"ONG YESIEUNG-PANSIOSHANGUL JONGSEONG PHIEUPH-PIEUPHANGUL JONGSEONG KAPYE" +
	"OUNPHIEUPHHANGUL JONGSEONG HIEUH-NIEUNHANGUL JONGSEONG HIEUH-RIEULHANGUL" +
	" JONGSEONG HIEUH-MIEUMHANGUL JONGSEONG HIEUH-PIEUPHANGUL JONGSEONG YEORI" +
	"NHIEUHHANGUL JONGSEONG KIYEOK-NIEUNHANGUL JONGSEONG KIYEOK-PIEUPHANGUL J" +
	"ONGSEONG KIYEOK-CHIEUCHHANGUL JONGSEONG KIYEOK-KHIEUKHHANGUL JONGSEONG K" +
	"IYEOK-HIEUHHANGUL JONGSEONG SSANGNIEUNETHIOPIC SYLLABLE HAETHIOPIC SYLLA" +
	"BLE HUETHIOPIC SYLLABLE HIETHIOPIC SYLLABLE HAAETHIOPIC SYLLABLE HEEETHI" +
	"OPIC SYLLABLE HEETHIOPIC SYLLABLE HOETHIOPIC SYLLABLE HOAETHIOPIC SYLLAB" +
	"LE LAETHIOPIC SYLLABLE LUETHIOPIC SYLLABLE LIETHIOPIC SYLLABLE LAAETHIOP" +
	"IC SYLLABLE LEEETHIOPIC SYLLABLE LEETHIOPIC SYLLABLE LOETHIOPIC SYLLABLE" +
	" LWAETHIOPIC SYLLABLE HHAETHIOPIC SYLLABLE HHUETHIOPIC SYLLABLE HHIETHIO" +
	"PIC SYLLABLE HHAAETHIOPIC SYLLABLE HHEEETHIOPIC SYLLABLE HHEETHIOPIC SYL" +
	"LABLE HHOETHIOPIC SYLLABLE HHWAETHIOPIC SYLLABLE MAETHIOPIC SYLLABLE MUE" +
	"THIOPIC SYLLABLE MIETHIOPIC SYLLABLE MAAETHIOPIC SYLLABLE MEEETHIOPIC SY" +
	"LLABLE MEETHIOPIC SYLLABLE MOETHIOPIC SYLLABLE MWAETHIOPIC SYLLABLE SZAE" +
	"THIOPIC SYLLABLE SZUETHIOPIC SYLLABLE SZIETHIOPIC SYLLABLE SZAAETHIOPIC " +
	"SYLLABLE SZEEETHIOPIC SYLLABLE SZEETHIOPIC SYLLABLE SZOETHIOPIC SYLLABLE" +
	" SZWAETHIOPIC SYLLABLE RAETHIOPIC SYLLABLE RUETHIOPIC SYLLABLE RIETHIOPI" +
	"C SYLLABLE RAAETHIOPIC SYLLABLE REEETHIOPIC SYLLABLE REETHIOPIC SYLLABLE" +
	" ROETHIOPIC SYLLABLE RWAETHIOPIC SYLLABLE SAETHIOPIC SYLLABLE SUETHIOPIC" +
	" SYLLABLE SIETHIOPIC SYLLABLE SAAETHIOPIC SYLLABLE SEEETHIOPIC SYLLABLE " +
	"SEETHIOPIC SYLLABLE SOETHIOPIC SYLLABLE SWAETHIOPIC SYLLABLE SHAETHIOPIC" +
	" SYLLABLE SHUETHIOPIC SYLLABLE SHIETHIOPIC SYLLABLE SHAAETHIOPIC SYLLABL" +
	"E SHEEETHIOPIC SYLLABLE SHEETHIOPIC SYLLABLE SHOETHIOPIC SYLLABLE SHWAET" +
	"HIOPIC SYLLABLE QAETHIOPIC SYLLABLE QUETHIOPIC SYLLABLE QIETHIOPIC SYLLA" +
	"BLE QAAETHIOPIC SYLLABLE QEEETHIOPIC SYLLABLE QEETHIOPIC SYLLABLE QOETHI" +
	"OPIC SYLLABLE QOAETHIOPIC SYLLABLE QWAETHIOPIC SYLLABLE QWIETHIOPIC SYLL" +
	"ABLE QWAAETHIOPIC SYLLABLE QWEEETHIOPIC SYLLABLE QWEETHIOPIC SYLLABLE QH" +
	"AETHIOPIC SYLLABLE QHUETHIOPIC SYLLABLE QHIETHIOPIC SYLLABLE QHAAETHIOPI" +
	"C SYLLABLE QHEEETHIOPIC SYLLABLE QHEETHIOPIC SYLLABLE QHOETHIOPIC SYLLAB" +
	"LE QHWAETHIOPIC SYLLABLE QHWIETHIOPIC SYLLABLE QHWAAETHIOPIC SYLLABLE QH" +
	"WEEETHIOPIC SYLLABLE QHWEETHIOPIC SYLLABLE BAETHIOPIC SYLLABLE BUETHIOPI" +
	"C SYLLABLE BIETHIOPIC SYLLABLE BAAETHIOPIC SYLLABLE BEEETHIOPIC SYLLABLE" +
	" BEETHIOPIC SYLLABLE BOETHIOPIC SYLLABLE BWAETHIOPIC SYLLABLE VAETHIOPIC" +
	" SYLLABLE VUETHIOPIC SYLLABLE VIETHIOPIC SYLLABLE VAAETHIOPIC SYLLABLE V" +
	"EEETHIOPIC SYLLABLE VEETHIOPIC SYLLABLE VOETHIOPIC SYLLABLE VWAETHIOPIC " +
	"SYLLABLE TAETHIOPIC SYLLABLE TUETHIOPIC SYLLABLE TIETHIOPIC SYLLABLE TAA" +
	"ETHIOPIC SYLLABLE TEEETHIOPIC SYLLABLE TEETHIOPIC SYLLABLE TOETHIOPIC SY" +
	"LLABLE TWAETHIOPIC SYLLABLE CAETHIOPIC SYLLABLE CUETHIOPIC SYLLABLE CIET" +
	"HIOPIC SYLLABLE CAAETHIOPIC SYLLABLE CEEETHIOPIC SYLLABLE CEETHIOPIC SYL" +
	"LABLE COETHIOPIC SYLLABLE CWAETHIOPIC SYLLABLE XAETHIOPIC SYLLABLE XUETH" +
	"IOPIC SYLLABLE XIETHIOPIC SYLLABLE XAAETHIOPIC SYLLABLE XEEETHIOPIC SYLL" +
	"ABLE XEETHIOPIC SYLLABLE XOETHIOPIC SYLLABLE XOAETHIOPIC SYLLABLE XWAETH" +
	"IOPIC SYLLABLE XWIETHIOPIC SYLLABLE XWAAETHIOPIC SYLLABLE XWEEETHIOPIC S" +
	"YLLABLE XWEETHIOPIC SYLLABLE NAETHIOPIC SYLLABLE NUETHIOPIC SYLLABLE NIE" +
	"THIOPIC SYLLABLE NAAETHIOPIC SYLLABLE NEEETHIOPIC SYLLABLE NEETHIOPIC SY" +
	"LLABLE NOETHIOPIC SYLLABLE NWAETHIOPIC SYLLABLE NYAETHIOPIC SYLLABLE NYU" +
	"ETHIOPIC SYLLABLE NYIETHIOPIC SYLLABLE NYAAETHIOPIC SYLLABLE NYEEETHIOPI" +
	"C SYLLABLE NYEETHIOPIC SYLLABLE NYOETHIOPIC SYLLABLE NYWAETHIOPIC SYLLAB" +
	"LE GLOTTAL AETHIOPIC SYLLABLE GLOTTAL UETHIOPIC SYLLABLE GLOTTAL IETHIOP") + ("" +
	"IC SYLLABLE GLOTTAL AAETHIOPIC SYLLABLE GLOTTAL EEETHIOPIC SYLLABLE GLOT" +
	"TAL EETHIOPIC SYLLABLE GLOTTAL OETHIOPIC SYLLABLE GLOTTAL WAETHIOPIC SYL" +
	"LABLE KAETHIOPIC SYLLABLE KUETHIOPIC SYLLABLE KIETHIOPIC SYLLABLE KAAETH" +
	"IOPIC SYLLABLE KEEETHIOPIC SYLLABLE KEETHIOPIC SYLLABLE KOETHIOPIC SYLLA" +
	"BLE KOAETHIOPIC SYLLABLE KWAETHIOPIC SYLLABLE KWIETHIOPIC SYLLABLE KWAAE" +
	"THIOPIC SYLLABLE KWEEETHIOPIC SYLLABLE KWEETHIOPIC SYLLABLE KXAETHIOPIC " +
	"SYLLABLE KXUETHIOPIC SYLLABLE KXIETHIOPIC SYLLABLE KXAAETHIOPIC SYLLABLE" +
	" KXEEETHIOPIC SYLLABLE KXEETHIOPIC SYLLABLE KXOETHIOPIC SYLLABLE KXWAETH" +
	"IOPIC SYLLABLE KXWIETHIOPIC SYLLABLE KXWAAETHIOPIC SYLLABLE KXWEEETHIOPI" +
	"C SYLLABLE KXWEETHIOPIC SYLLABLE WAETHIOPIC SYLLABLE WUETHIOPIC SYLLABLE" +
	" WIETHIOPIC SYLLABLE WAAETHIOPIC SYLLABLE WEEETHIOPIC SYLLABLE WEETHIOPI" +
	"C SYLLABLE WOETHIOPIC SYLLABLE WOAETHIOPIC SYLLABLE PHARYNGEAL AETHIOPIC" +
	" SYLLABLE PHARYNGEAL UETHIOPIC SYLLABLE PHARYNGEAL IETHIOPIC SYLLABLE PH" +
	"ARYNGEAL AAETHIOPIC SYLLABLE PHARYNGEAL EEETHIOPIC SYLLABLE PHARYNGEAL E" +
	"ETHIOPIC SYLLABLE PHARYNGEAL OETHIOPIC SYLLABLE ZAETHIOPIC SYLLABLE ZUET" +
	"HIOPIC SYLLABLE ZIETHIOPIC SYLLABLE ZAAETHIOPIC SYLLABLE ZEEETHIOPIC SYL" +
	"LABLE ZEETHIOPIC SYLLABLE ZOETHIOPIC SYLLABLE ZWAETHIOPIC SYLLABLE ZHAET" +
	"HIOPIC SYLLABLE ZHUETHIOPIC SYLLABLE ZHIETHIOPIC SYLLABLE ZHAAETHIOPIC S" +
	"YLLABLE ZHEEETHIOPIC SYLLABLE ZHEETHIOPIC SYLLABLE ZHOETHIOPIC SYLLABLE " +
	"ZHWAETHIOPIC SYLLABLE YAETHIOPIC SYLLABLE YUETHIOPIC SYLLABLE YIETHIOPIC" +
	" SYLLABLE YAAETHIOPIC SYLLABLE YEEETHIOPIC SYLLABLE YEETHIOPIC SYLLABLE " +
	"YOETHIOPIC SYLLABLE YOAETHIOPIC SYLLABLE DAETHIOPIC SYLLABLE DUETHIOPIC " +
	"SYLLABLE DIETHIOPIC SYLLABLE DAAETHIOPIC SYLLABLE DEEETHIOPIC SYLLABLE D" +
	"EETHIOPIC SYLLABLE DOETHIOPIC SYLLABLE DWAETHIOPIC SYLLABLE DDAETHIOPIC " +
	"SYLLABLE DDUETHIOPIC SYLLABLE DDIETHIOPIC SYLLABLE DDAAETHIOPIC SYLLABLE" +
	" DDEEETHIOPIC SYLLABLE DDEETHIOPIC SYLLABLE DDOETHIOPIC SYLLABLE DDWAETH" +
	"IOPIC SYLLABLE JAETHIOPIC SYLLABLE JUETHIOPIC SYLLABLE JIETHIOPIC SYLLAB" +
	"LE JAAETHIOPIC SYLLABLE JEEETHIOPIC SYLLABLE JEETHIOPIC SYLLABLE JOETHIO" +
	"PIC SYLLABLE JWAETHIOPIC SYLLABLE GAETHIOPIC SYLLABLE GUETHIOPIC SYLLABL" +
	"E GIETHIOPIC SYLLABLE GAAETHIOPIC SYLLABLE GEEETHIOPIC SYLLABLE GEETHIOP" +
	"IC SYLLABLE GOETHIOPIC SYLLABLE GOAETHIOPIC SYLLABLE GWAETHIOPIC SYLLABL" +
	"E GWIETHIOPIC SYLLABLE GWAAETHIOPIC SYLLABLE GWEEETHIOPIC SYLLABLE GWEET" +
	"HIOPIC SYLLABLE GGAETHIOPIC SYLLABLE GGUETHIOPIC SYLLABLE GGIETHIOPIC SY" +
	"LLABLE GGAAETHIOPIC SYLLABLE GGEEETHIOPIC SYLLABLE GGEETHIOPIC SYLLABLE " +
	"GGOETHIOPIC SYLLABLE GGWAAETHIOPIC SYLLABLE THAETHIOPIC SYLLABLE THUETHI" +
	"OPIC SYLLABLE THIETHIOPIC SYLLABLE THAAETHIOPIC SYLLABLE THEEETHIOPIC SY" +
	"LLABLE THEETHIOPIC SYLLABLE THOETHIOPIC SYLLABLE THWAETHIOPIC SYLLABLE C" +
	"HAETHIOPIC SYLLABLE CHUETHIOPIC SYLLABLE CHIETHIOPIC SYLLABLE CHAAETHIOP" +
	"IC SYLLABLE CHEEETHIOPIC SYLLABLE CHEETHIOPIC SYLLABLE CHOETHIOPIC SYLLA" +
	"BLE CHWAETHIOPIC SYLLABLE PHAETHIOPIC SYLLABLE PHUETHIOPIC SYLLABLE PHIE" +
	"THIOPIC SYLLABLE PHAAETHIOPIC SYLLABLE PHEEETHIOPIC SYLLABLE PHEETHIOPIC" +
	" SYLLABLE PHOETHIOPIC SYLLABLE PHWAETHIOPIC SYLLABLE TSAETHIOPIC SYLLABL" +
	"E TSUETHIOPIC SYLLABLE TSIETHIOPIC SYLLABLE TSAAETHIOPIC SYLLABLE TSEEET" +
	"HIOPIC SYLLABLE TSEETHIOPIC SYLLABLE TSOETHIOPIC SYLLABLE TSWAETHIOPIC S" +
	"YLLABLE TZAETHIOPIC SYLLABLE TZUETHIOPIC SYLLABLE TZIETHIOPIC SYLLABLE T" +
	"ZAAETHIOPIC SYLLABLE TZEEETHIOPIC SYLLABLE TZEETHIOPIC SYLLABLE TZOETHIO" +
	"PIC SYLLABLE TZOAETHIOPIC SYLLABLE FAETHIOPIC SYLLABLE FUETHIOPIC SYLLAB" +
	"LE FIETHIOPIC SYLLABLE FAAETHIOPIC SYLLABLE FEEETHIOPIC SYLLABLE FEETHIO" +
	"PIC SYLLABLE FOETHIOPIC SYLLABLE FWAETHIOPIC SYLLABLE PAETHIOPIC SYLLABL" +
	"E PUETHIOPIC SYLLABLE PIETHIOPIC SYLLABLE PAAETHIOPIC SYLLABLE PEEETHIOP" +
	"IC SYLLABLE PEETHIOPIC SYLLABLE POETHIOPIC SYLLABLE PWAETHIOPIC SYLLABLE" +
	" RYAETHIOPIC SYLLABLE MYAETHIOPIC SYLLABLE FYAETHIOPIC COMBINING GEMINAT" +
	"ION AND VOWEL LENGTH MARKETHIOPIC COMBINING VOWEL LENGTH MARKETHIOPIC CO" +
	"MBINING GEMINATION MARKETHIOPIC SECTION MARKETHIOPIC WORDSPACEETHIOPIC F" +
	"ULL STOPETHIOPIC COMMAETHIOPIC SEMICOLONETHIOPIC COLONETHIOPIC PREFACE C" +
	"OLONETHIOPIC QUESTION MARKETHIOPIC PARAGRAPH SEPARATORETHIOPIC DIGIT ONE" +
	"ETHIOPIC DIGIT TWOETHIOPIC DIGIT THREEETHIOPIC DIGIT FOURETHIOPIC DIGIT " +
	"FIVEETHIOPIC DIGIT SIXETHIOPIC DIGIT SEVENETHIOPIC DIGIT EIGHTETHIOPIC D" +
	"IGIT NINEETHIOPIC NUMBER TENETHIOPIC NUMBER TWENTYETHIOPIC NUMBER THIRTY" +
	"ETHIOPIC NUMBER FORTYETHIOPIC NUMBER FIFTYETHIOPIC NUMBER SIXTYETHIOPIC " +
	"NUMBER SEVENTYETHIOPIC NUMBER EIGHTYETHIOPIC NUMBER NINETYETHIOPIC NUMBE" +
	"R HUNDREDETHIOPIC NUMBER TEN THOUSANDETHIOPIC SYLLABLE SEBATBEIT MWAETHI" +
	"OPIC SYLLABLE MWIETHIOPIC SYLLABLE MWEEETHIOPIC SYLLABLE MWEETHIOPIC SYL" +
	"LABLE SEBATBEIT BWAETHIOPIC SYLLABLE BWIETHIOPIC SYLLABLE BWEEETHIOPIC S") + ("" +
	"YLLABLE BWEETHIOPIC SYLLABLE SEBATBEIT FWAETHIOPIC SYLLABLE FWIETHIOPIC " +
	"SYLLABLE FWEEETHIOPIC SYLLABLE FWEETHIOPIC SYLLABLE SEBATBEIT PWAETHIOPI" +
	"C SYLLABLE PWIETHIOPIC SYLLABLE PWEEETHIOPIC SYLLABLE PWEETHIOPIC TONAL " +
	"MARK YIZETETHIOPIC TONAL MARK DERETETHIOPIC TONAL MARK RIKRIKETHIOPIC TO" +
	"NAL MARK SHORT RIKRIKETHIOPIC TONAL MARK DIFATETHIOPIC TONAL MARK KENATE" +
	"THIOPIC TONAL MARK CHIRETETHIOPIC TONAL MARK HIDETETHIOPIC TONAL MARK DE" +
	"RET-HIDETETHIOPIC TONAL MARK KURTCHEROKEE LETTER ACHEROKEE LETTER ECHERO" +
	"KEE LETTER ICHEROKEE LETTER OCHEROKEE LETTER UCHEROKEE LETTER VCHEROKEE " +
	"LETTER GACHEROKEE LETTER KACHEROKEE LETTER GECHEROKEE LETTER GICHEROKEE " +
	"LETTER GOCHEROKEE LETTER GUCHEROKEE LETTER GVCHEROKEE LETTER HACHEROKEE " +
	"LETTER HECHEROKEE LETTER HICHEROKEE LETTER HOCHEROKEE LETTER HUCHEROKEE " +
	"LETTER HVCHEROKEE LETTER LACHEROKEE LETTER LECHEROKEE LETTER LICHEROKEE " +
	"LETTER LOCHEROKEE LETTER LUCHEROKEE LETTER LVCHEROKEE LETTER MACHEROKEE " +
	"LETTER MECHEROKEE LETTER MICHEROKEE LETTER MOCHEROKEE LETTER MUCHEROKEE " +
	"LETTER NACHEROKEE LETTER HNACHEROKEE LETTER NAHCHEROKEE LETTER NECHEROKE" +
	"E LETTER NICHEROKEE LETTER NOCHEROKEE LETTER NUCHEROKEE LETTER NVCHEROKE" +
	"E LETTER QUACHEROKEE LETTER QUECHEROKEE LETTER QUICHEROKEE LETTER QUOCHE" +
	"ROKEE LETTER QUUCHEROKEE LETTER QUVCHEROKEE LETTER SACHEROKEE LETTER SCH" +
	"EROKEE LETTER SECHEROKEE LETTER SICHEROKEE LETTER SOCHEROKEE LETTER SUCH" +
	"EROKEE LETTER SVCHEROKEE LETTER DACHEROKEE LETTER TACHEROKEE LETTER DECH" +
	"EROKEE LETTER TECHEROKEE LETTER DICHEROKEE LETTER TICHEROKEE LETTER DOCH" +
	"EROKEE LETTER DUCHEROKEE LETTER DVCHEROKEE LETTER DLACHEROKEE LETTER TLA" +
	"CHEROKEE LETTER TLECHEROKEE LETTER TLICHEROKEE LETTER TLOCHEROKEE LETTER" +
	" TLUCHEROKEE LETTER TLVCHEROKEE LETTER TSACHEROKEE LETTER TSECHEROKEE LE" +
	"TTER TSICHEROKEE LETTER TSOCHEROKEE LETTER TSUCHEROKEE LETTER TSVCHEROKE" +
	"E LETTER WACHEROKEE LETTER WECHEROKEE LETTER WICHEROKEE LETTER WOCHEROKE" +
	"E LETTER WUCHEROKEE LETTER WVCHEROKEE LETTER YACHEROKEE LETTER YECHEROKE" +
	"E LETTER YICHEROKEE LETTER YOCHEROKEE LETTER YUCHEROKEE LETTER YVCHEROKE" +
	"E LETTER MVCHEROKEE SMALL LETTER YECHEROKEE SMALL LETTER YICHEROKEE SMAL" +
	"L LETTER YOCHEROKEE SMALL LETTER YUCHEROKEE SMALL LETTER YVCHEROKEE SMAL" +
	"L LETTER MVCANADIAN SYLLABICS HYPHENCANADIAN SYLLABICS ECANADIAN SYLLABI" +
	"CS AAICANADIAN SYLLABICS ICANADIAN SYLLABICS IICANADIAN SYLLABICS OCANAD" +
	"IAN SYLLABICS OOCANADIAN SYLLABICS Y-CREE OOCANADIAN SYLLABICS CARRIER E" +
	"ECANADIAN SYLLABICS CARRIER ICANADIAN SYLLABICS ACANADIAN SYLLABICS AACA" +
	"NADIAN SYLLABICS WECANADIAN SYLLABICS WEST-CREE WECANADIAN SYLLABICS WIC" +
	"ANADIAN SYLLABICS WEST-CREE WICANADIAN SYLLABICS WIICANADIAN SYLLABICS W" +
	"EST-CREE WIICANADIAN SYLLABICS WOCANADIAN SYLLABICS WEST-CREE WOCANADIAN" +
	" SYLLABICS WOOCANADIAN SYLLABICS WEST-CREE WOOCANADIAN SYLLABICS NASKAPI" +
	" WOOCANADIAN SYLLABICS WACANADIAN SYLLABICS WEST-CREE WACANADIAN SYLLABI" +
	"CS WAACANADIAN SYLLABICS WEST-CREE WAACANADIAN SYLLABICS NASKAPI WAACANA" +
	"DIAN SYLLABICS AICANADIAN SYLLABICS Y-CREE WCANADIAN SYLLABICS GLOTTAL S" +
	"TOPCANADIAN SYLLABICS FINAL ACUTECANADIAN SYLLABICS FINAL GRAVECANADIAN " +
	"SYLLABICS FINAL BOTTOM HALF RINGCANADIAN SYLLABICS FINAL TOP HALF RINGCA" +
	"NADIAN SYLLABICS FINAL RIGHT HALF RINGCANADIAN SYLLABICS FINAL RINGCANAD" +
	"IAN SYLLABICS FINAL DOUBLE ACUTECANADIAN SYLLABICS FINAL DOUBLE SHORT VE" +
	"RTICAL STROKESCANADIAN SYLLABICS FINAL MIDDLE DOTCANADIAN SYLLABICS FINA" +
	"L SHORT HORIZONTAL STROKECANADIAN SYLLABICS FINAL PLUSCANADIAN SYLLABICS" +
	" FINAL DOWN TACKCANADIAN SYLLABICS ENCANADIAN SYLLABICS INCANADIAN SYLLA" +
	"BICS ONCANADIAN SYLLABICS ANCANADIAN SYLLABICS PECANADIAN SYLLABICS PAAI" +
	"CANADIAN SYLLABICS PICANADIAN SYLLABICS PIICANADIAN SYLLABICS POCANADIAN" +
	" SYLLABICS POOCANADIAN SYLLABICS Y-CREE POOCANADIAN SYLLABICS CARRIER HE" +
	"ECANADIAN SYLLABICS CARRIER HICANADIAN SYLLABICS PACANADIAN SYLLABICS PA" +
	"ACANADIAN SYLLABICS PWECANADIAN SYLLABICS WEST-CREE PWECANADIAN SYLLABIC" +
	"S PWICANADIAN SYLLABICS WEST-CREE PWICANADIAN SYLLABICS PWIICANADIAN SYL" +
	"LABICS WEST-CREE PWIICANADIAN SYLLABICS PWOCANADIAN SYLLABICS WEST-CREE " +
	"PWOCANADIAN SYLLABICS PWOOCANADIAN SYLLABICS WEST-CREE PWOOCANADIAN SYLL" +
	"ABICS PWACANADIAN SYLLABICS WEST-CREE PWACANADIAN SYLLABICS PWAACANADIAN" +
	" SYLLABICS WEST-CREE PWAACANADIAN SYLLABICS Y-CREE PWAACANADIAN SYLLABIC" +
	"S PCANADIAN SYLLABICS WEST-CREE PCANADIAN SYLLABICS CARRIER HCANADIAN SY" +
	"LLABICS TECANADIAN SYLLABICS TAAICANADIAN SYLLABICS TICANADIAN SYLLABICS" +
	" TIICANADIAN SYLLABICS TOCANADIAN SYLLABICS TOOCANADIAN SYLLABICS Y-CREE" +
	" TOOCANADIAN SYLLABICS CARRIER DEECANADIAN SYLLABICS CARRIER DICANADIAN " +
	"SYLLABICS TACANADIAN SYLLABICS TAACANADIAN SYLLABICS TWECANADIAN SYLLABI" +
	"CS WEST-CREE TWECANADIAN SYLLABICS TWICANADIAN SYLLABICS WEST-CREE TWICA") + ("" +
	"NADIAN SYLLABICS TWIICANADIAN SYLLABICS WEST-CREE TWIICANADIAN SYLLABICS" +
	" TWOCANADIAN SYLLABICS WEST-CREE TWOCANADIAN SYLLABICS TWOOCANADIAN SYLL" +
	"ABICS WEST-CREE TWOOCANADIAN SYLLABICS TWACANADIAN SYLLABICS WEST-CREE T" +
	"WACANADIAN SYLLABICS TWAACANADIAN SYLLABICS WEST-CREE TWAACANADIAN SYLLA" +
	"BICS NASKAPI TWAACANADIAN SYLLABICS TCANADIAN SYLLABICS TTECANADIAN SYLL" +
	"ABICS TTICANADIAN SYLLABICS TTOCANADIAN SYLLABICS TTACANADIAN SYLLABICS " +
	"KECANADIAN SYLLABICS KAAICANADIAN SYLLABICS KICANADIAN SYLLABICS KIICANA" +
	"DIAN SYLLABICS KOCANADIAN SYLLABICS KOOCANADIAN SYLLABICS Y-CREE KOOCANA" +
	"DIAN SYLLABICS KACANADIAN SYLLABICS KAACANADIAN SYLLABICS KWECANADIAN SY" +
	"LLABICS WEST-CREE KWECANADIAN SYLLABICS KWICANADIAN SYLLABICS WEST-CREE " +
	"KWICANADIAN SYLLABICS KWIICANADIAN SYLLABICS WEST-CREE KWIICANADIAN SYLL" +
	"ABICS KWOCANADIAN SYLLABICS WEST-CREE KWOCANADIAN SYLLABICS KWOOCANADIAN" +
	" SYLLABICS WEST-CREE KWOOCANADIAN SYLLABICS KWACANADIAN SYLLABICS WEST-C" +
	"REE KWACANADIAN SYLLABICS KWAACANADIAN SYLLABICS WEST-CREE KWAACANADIAN " +
	"SYLLABICS NASKAPI KWAACANADIAN SYLLABICS KCANADIAN SYLLABICS KWCANADIAN " +
	"SYLLABICS SOUTH-SLAVEY KEHCANADIAN SYLLABICS SOUTH-SLAVEY KIHCANADIAN SY" +
	"LLABICS SOUTH-SLAVEY KOHCANADIAN SYLLABICS SOUTH-SLAVEY KAHCANADIAN SYLL" +
	"ABICS CECANADIAN SYLLABICS CAAICANADIAN SYLLABICS CICANADIAN SYLLABICS C" +
	"IICANADIAN SYLLABICS COCANADIAN SYLLABICS COOCANADIAN SYLLABICS Y-CREE C" +
	"OOCANADIAN SYLLABICS CACANADIAN SYLLABICS CAACANADIAN SYLLABICS CWECANAD" +
	"IAN SYLLABICS WEST-CREE CWECANADIAN SYLLABICS CWICANADIAN SYLLABICS WEST" +
	"-CREE CWICANADIAN SYLLABICS CWIICANADIAN SYLLABICS WEST-CREE CWIICANADIA" +
	"N SYLLABICS CWOCANADIAN SYLLABICS WEST-CREE CWOCANADIAN SYLLABICS CWOOCA" +
	"NADIAN SYLLABICS WEST-CREE CWOOCANADIAN SYLLABICS CWACANADIAN SYLLABICS " +
	"WEST-CREE CWACANADIAN SYLLABICS CWAACANADIAN SYLLABICS WEST-CREE CWAACAN" +
	"ADIAN SYLLABICS NASKAPI CWAACANADIAN SYLLABICS CCANADIAN SYLLABICS SAYIS" +
	"I THCANADIAN SYLLABICS MECANADIAN SYLLABICS MAAICANADIAN SYLLABICS MICAN" +
	"ADIAN SYLLABICS MIICANADIAN SYLLABICS MOCANADIAN SYLLABICS MOOCANADIAN S" +
	"YLLABICS Y-CREE MOOCANADIAN SYLLABICS MACANADIAN SYLLABICS MAACANADIAN S" +
	"YLLABICS MWECANADIAN SYLLABICS WEST-CREE MWECANADIAN SYLLABICS MWICANADI" +
	"AN SYLLABICS WEST-CREE MWICANADIAN SYLLABICS MWIICANADIAN SYLLABICS WEST" +
	"-CREE MWIICANADIAN SYLLABICS MWOCANADIAN SYLLABICS WEST-CREE MWOCANADIAN" +
	" SYLLABICS MWOOCANADIAN SYLLABICS WEST-CREE MWOOCANADIAN SYLLABICS MWACA" +
	"NADIAN SYLLABICS WEST-CREE MWACANADIAN SYLLABICS MWAACANADIAN SYLLABICS " +
	"WEST-CREE MWAACANADIAN SYLLABICS NASKAPI MWAACANADIAN SYLLABICS MCANADIA" +
	"N SYLLABICS WEST-CREE MCANADIAN SYLLABICS MHCANADIAN SYLLABICS ATHAPASCA" +
	"N MCANADIAN SYLLABICS SAYISI MCANADIAN SYLLABICS NECANADIAN SYLLABICS NA" +
	"AICANADIAN SYLLABICS NICANADIAN SYLLABICS NIICANADIAN SYLLABICS NOCANADI" +
	"AN SYLLABICS NOOCANADIAN SYLLABICS Y-CREE NOOCANADIAN SYLLABICS NACANADI" +
	"AN SYLLABICS NAACANADIAN SYLLABICS NWECANADIAN SYLLABICS WEST-CREE NWECA" +
	"NADIAN SYLLABICS NWACANADIAN SYLLABICS WEST-CREE NWACANADIAN SYLLABICS N" +
	"WAACANADIAN SYLLABICS WEST-CREE NWAACANADIAN SYLLABICS NASKAPI NWAACANAD" +
	"IAN SYLLABICS NCANADIAN SYLLABICS CARRIER NGCANADIAN SYLLABICS NHCANADIA" +
	"N SYLLABICS LECANADIAN SYLLABICS LAAICANADIAN SYLLABICS LICANADIAN SYLLA" +
	"BICS LIICANADIAN SYLLABICS LOCANADIAN SYLLABICS LOOCANADIAN SYLLABICS Y-" +
	"CREE LOOCANADIAN SYLLABICS LACANADIAN SYLLABICS LAACANADIAN SYLLABICS LW" +
	"ECANADIAN SYLLABICS WEST-CREE LWECANADIAN SYLLABICS LWICANADIAN SYLLABIC" +
	"S WEST-CREE LWICANADIAN SYLLABICS LWIICANADIAN SYLLABICS WEST-CREE LWIIC" +
	"ANADIAN SYLLABICS LWOCANADIAN SYLLABICS WEST-CREE LWOCANADIAN SYLLABICS " +
	"LWOOCANADIAN SYLLABICS WEST-CREE LWOOCANADIAN SYLLABICS LWACANADIAN SYLL" +
	"ABICS WEST-CREE LWACANADIAN SYLLABICS LWAACANADIAN SYLLABICS WEST-CREE L" +
	"WAACANADIAN SYLLABICS LCANADIAN SYLLABICS WEST-CREE LCANADIAN SYLLABICS " +
	"MEDIAL LCANADIAN SYLLABICS SECANADIAN SYLLABICS SAAICANADIAN SYLLABICS S" +
	"ICANADIAN SYLLABICS SIICANADIAN SYLLABICS SOCANADIAN SYLLABICS SOOCANADI" +
	"AN SYLLABICS Y-CREE SOOCANADIAN SYLLABICS SACANADIAN SYLLABICS SAACANADI" +
	"AN SYLLABICS SWECANADIAN SYLLABICS WEST-CREE SWECANADIAN SYLLABICS SWICA" +
	"NADIAN SYLLABICS WEST-CREE SWICANADIAN SYLLABICS SWIICANADIAN SYLLABICS " +
	"WEST-CREE SWIICANADIAN SYLLABICS SWOCANADIAN SYLLABICS WEST-CREE SWOCANA" +
	"DIAN SYLLABICS SWOOCANADIAN SYLLABICS WEST-CREE SWOOCANADIAN SYLLABICS S" +
	"WACANADIAN SYLLABICS WEST-CREE SWACANADIAN SYLLABICS SWAACANADIAN SYLLAB" +
	"ICS WEST-CREE SWAACANADIAN SYLLABICS NASKAPI SWAACANADIAN SYLLABICS SCAN" +
	"ADIAN SYLLABICS ATHAPASCAN SCANADIAN SYLLABICS SWCANADIAN SYLLABICS BLAC" +
	"KFOOT SCANADIAN SYLLABICS MOOSE-CREE SKCANADIAN SYLLABICS NASKAPI SKWCAN" +
	"ADIAN SYLLABICS NASKAPI S-WCANADIAN SYLLABICS NASKAPI SPWACANADIAN SYLLA") + ("" +
	"BICS NASKAPI STWACANADIAN SYLLABICS NASKAPI SKWACANADIAN SYLLABICS NASKA" +
	"PI SCWACANADIAN SYLLABICS SHECANADIAN SYLLABICS SHICANADIAN SYLLABICS SH" +
	"IICANADIAN SYLLABICS SHOCANADIAN SYLLABICS SHOOCANADIAN SYLLABICS SHACAN" +
	"ADIAN SYLLABICS SHAACANADIAN SYLLABICS SHWECANADIAN SYLLABICS WEST-CREE " +
	"SHWECANADIAN SYLLABICS SHWICANADIAN SYLLABICS WEST-CREE SHWICANADIAN SYL" +
	"LABICS SHWIICANADIAN SYLLABICS WEST-CREE SHWIICANADIAN SYLLABICS SHWOCAN" +
	"ADIAN SYLLABICS WEST-CREE SHWOCANADIAN SYLLABICS SHWOOCANADIAN SYLLABICS" +
	" WEST-CREE SHWOOCANADIAN SYLLABICS SHWACANADIAN SYLLABICS WEST-CREE SHWA" +
	"CANADIAN SYLLABICS SHWAACANADIAN SYLLABICS WEST-CREE SHWAACANADIAN SYLLA" +
	"BICS SHCANADIAN SYLLABICS YECANADIAN SYLLABICS YAAICANADIAN SYLLABICS YI" +
	"CANADIAN SYLLABICS YIICANADIAN SYLLABICS YOCANADIAN SYLLABICS YOOCANADIA" +
	"N SYLLABICS Y-CREE YOOCANADIAN SYLLABICS YACANADIAN SYLLABICS YAACANADIA" +
	"N SYLLABICS YWECANADIAN SYLLABICS WEST-CREE YWECANADIAN SYLLABICS YWICAN" +
	"ADIAN SYLLABICS WEST-CREE YWICANADIAN SYLLABICS YWIICANADIAN SYLLABICS W" +
	"EST-CREE YWIICANADIAN SYLLABICS YWOCANADIAN SYLLABICS WEST-CREE YWOCANAD" +
	"IAN SYLLABICS YWOOCANADIAN SYLLABICS WEST-CREE YWOOCANADIAN SYLLABICS YW" +
	"ACANADIAN SYLLABICS WEST-CREE YWACANADIAN SYLLABICS YWAACANADIAN SYLLABI" +
	"CS WEST-CREE YWAACANADIAN SYLLABICS NASKAPI YWAACANADIAN SYLLABICS YCANA" +
	"DIAN SYLLABICS BIBLE-CREE YCANADIAN SYLLABICS WEST-CREE YCANADIAN SYLLAB" +
	"ICS SAYISI YICANADIAN SYLLABICS RECANADIAN SYLLABICS R-CREE RECANADIAN S" +
	"YLLABICS WEST-CREE LECANADIAN SYLLABICS RAAICANADIAN SYLLABICS RICANADIA" +
	"N SYLLABICS RIICANADIAN SYLLABICS ROCANADIAN SYLLABICS ROOCANADIAN SYLLA" +
	"BICS WEST-CREE LOCANADIAN SYLLABICS RACANADIAN SYLLABICS RAACANADIAN SYL" +
	"LABICS WEST-CREE LACANADIAN SYLLABICS RWAACANADIAN SYLLABICS WEST-CREE R" +
	"WAACANADIAN SYLLABICS RCANADIAN SYLLABICS WEST-CREE RCANADIAN SYLLABICS " +
	"MEDIAL RCANADIAN SYLLABICS FECANADIAN SYLLABICS FAAICANADIAN SYLLABICS F" +
	"ICANADIAN SYLLABICS FIICANADIAN SYLLABICS FOCANADIAN SYLLABICS FOOCANADI" +
	"AN SYLLABICS FACANADIAN SYLLABICS FAACANADIAN SYLLABICS FWAACANADIAN SYL" +
	"LABICS WEST-CREE FWAACANADIAN SYLLABICS FCANADIAN SYLLABICS THECANADIAN " +
	"SYLLABICS N-CREE THECANADIAN SYLLABICS THICANADIAN SYLLABICS N-CREE THIC" +
	"ANADIAN SYLLABICS THIICANADIAN SYLLABICS N-CREE THIICANADIAN SYLLABICS T" +
	"HOCANADIAN SYLLABICS THOOCANADIAN SYLLABICS THACANADIAN SYLLABICS THAACA" +
	"NADIAN SYLLABICS THWAACANADIAN SYLLABICS WEST-CREE THWAACANADIAN SYLLABI" +
	"CS THCANADIAN SYLLABICS TTHECANADIAN SYLLABICS TTHICANADIAN SYLLABICS TT" +
	"HOCANADIAN SYLLABICS TTHACANADIAN SYLLABICS TTHCANADIAN SYLLABICS TYECAN" +
	"ADIAN SYLLABICS TYICANADIAN SYLLABICS TYOCANADIAN SYLLABICS TYACANADIAN " +
	"SYLLABICS NUNAVIK HECANADIAN SYLLABICS NUNAVIK HICANADIAN SYLLABICS NUNA" +
	"VIK HIICANADIAN SYLLABICS NUNAVIK HOCANADIAN SYLLABICS NUNAVIK HOOCANADI" +
	"AN SYLLABICS NUNAVIK HACANADIAN SYLLABICS NUNAVIK HAACANADIAN SYLLABICS " +
	"NUNAVIK HCANADIAN SYLLABICS NUNAVUT HCANADIAN SYLLABICS HKCANADIAN SYLLA" +
	"BICS QAAICANADIAN SYLLABICS QICANADIAN SYLLABICS QIICANADIAN SYLLABICS Q" +
	"OCANADIAN SYLLABICS QOOCANADIAN SYLLABICS QACANADIAN SYLLABICS QAACANADI" +
	"AN SYLLABICS QCANADIAN SYLLABICS TLHECANADIAN SYLLABICS TLHICANADIAN SYL" +
	"LABICS TLHOCANADIAN SYLLABICS TLHACANADIAN SYLLABICS WEST-CREE RECANADIA" +
	"N SYLLABICS WEST-CREE RICANADIAN SYLLABICS WEST-CREE ROCANADIAN SYLLABIC" +
	"S WEST-CREE RACANADIAN SYLLABICS NGAAICANADIAN SYLLABICS NGICANADIAN SYL" +
	"LABICS NGIICANADIAN SYLLABICS NGOCANADIAN SYLLABICS NGOOCANADIAN SYLLABI" +
	"CS NGACANADIAN SYLLABICS NGAACANADIAN SYLLABICS NGCANADIAN SYLLABICS NNG" +
	"CANADIAN SYLLABICS SAYISI SHECANADIAN SYLLABICS SAYISI SHICANADIAN SYLLA" +
	"BICS SAYISI SHOCANADIAN SYLLABICS SAYISI SHACANADIAN SYLLABICS WOODS-CRE" +
	"E THECANADIAN SYLLABICS WOODS-CREE THICANADIAN SYLLABICS WOODS-CREE THOC" +
	"ANADIAN SYLLABICS WOODS-CREE THACANADIAN SYLLABICS WOODS-CREE THCANADIAN" +
	" SYLLABICS LHICANADIAN SYLLABICS LHIICANADIAN SYLLABICS LHOCANADIAN SYLL" +
	"ABICS LHOOCANADIAN SYLLABICS LHACANADIAN SYLLABICS LHAACANADIAN SYLLABIC" +
	"S LHCANADIAN SYLLABICS TH-CREE THECANADIAN SYLLABICS TH-CREE THICANADIAN" +
	" SYLLABICS TH-CREE THIICANADIAN SYLLABICS TH-CREE THOCANADIAN SYLLABICS " +
	"TH-CREE THOOCANADIAN SYLLABICS TH-CREE THACANADIAN SYLLABICS TH-CREE THA" +
	"ACANADIAN SYLLABICS TH-CREE THCANADIAN SYLLABICS AIVILIK BCANADIAN SYLLA" +
	"BICS BLACKFOOT ECANADIAN SYLLABICS BLACKFOOT ICANADIAN SYLLABICS BLACKFO" +
	"OT OCANADIAN SYLLABICS BLACKFOOT ACANADIAN SYLLABICS BLACKFOOT WECANADIA" +
	"N SYLLABICS BLACKFOOT WICANADIAN SYLLABICS BLACKFOOT WOCANADIAN SYLLABIC" +
	"S BLACKFOOT WACANADIAN SYLLABICS BLACKFOOT NECANADIAN SYLLABICS BLACKFOO" +
	"T NICANADIAN SYLLABICS BLACKFOOT NOCANADIAN SYLLABICS BLACKFOOT NACANADI" +
	"AN SYLLABICS BLACKFOOT KECANADIAN SYLLABICS BLACKFOOT KICANADIAN SYLLABI") + ("" +
	"CS BLACKFOOT KOCANADIAN SYLLABICS BLACKFOOT KACANADIAN SYLLABICS SAYISI " +
	"HECANADIAN SYLLABICS SAYISI HICANADIAN SYLLABICS SAYISI HOCANADIAN SYLLA" +
	"BICS SAYISI HACANADIAN SYLLABICS CARRIER GHUCANADIAN SYLLABICS CARRIER G" +
	"HOCANADIAN SYLLABICS CARRIER GHECANADIAN SYLLABICS CARRIER GHEECANADIAN " +
	"SYLLABICS CARRIER GHICANADIAN SYLLABICS CARRIER GHACANADIAN SYLLABICS CA" +
	"RRIER RUCANADIAN SYLLABICS CARRIER ROCANADIAN SYLLABICS CARRIER RECANADI" +
	"AN SYLLABICS CARRIER REECANADIAN SYLLABICS CARRIER RICANADIAN SYLLABICS " +
	"CARRIER RACANADIAN SYLLABICS CARRIER WUCANADIAN SYLLABICS CARRIER WOCANA" +
	"DIAN SYLLABICS CARRIER WECANADIAN SYLLABICS CARRIER WEECANADIAN SYLLABIC" +
	"S CARRIER WICANADIAN SYLLABICS CARRIER WACANADIAN SYLLABICS CARRIER HWUC" +
	"ANADIAN SYLLABICS CARRIER HWOCANADIAN SYLLABICS CARRIER HWECANADIAN SYLL" +
	"ABICS CARRIER HWEECANADIAN SYLLABICS CARRIER HWICANADIAN SYLLABICS CARRI" +
	"ER HWACANADIAN SYLLABICS CARRIER THUCANADIAN SYLLABICS CARRIER THOCANADI" +
	"AN SYLLABICS CARRIER THECANADIAN SYLLABICS CARRIER THEECANADIAN SYLLABIC" +
	"S CARRIER THICANADIAN SYLLABICS CARRIER THACANADIAN SYLLABICS CARRIER TT" +
	"UCANADIAN SYLLABICS CARRIER TTOCANADIAN SYLLABICS CARRIER TTECANADIAN SY" +
	"LLABICS CARRIER TTEECANADIAN SYLLABICS CARRIER TTICANADIAN SYLLABICS CAR" +
	"RIER TTACANADIAN SYLLABICS CARRIER PUCANADIAN SYLLABICS CARRIER POCANADI" +
	"AN SYLLABICS CARRIER PECANADIAN SYLLABICS CARRIER PEECANADIAN SYLLABICS " +
	"CARRIER PICANADIAN SYLLABICS CARRIER PACANADIAN SYLLABICS CARRIER PCANAD" +
	"IAN SYLLABICS CARRIER GUCANADIAN SYLLABICS CARRIER GOCANADIAN SYLLABICS " +
	"CARRIER GECANADIAN SYLLABICS CARRIER GEECANADIAN SYLLABICS CARRIER GICAN" +
	"ADIAN SYLLABICS CARRIER GACANADIAN SYLLABICS CARRIER KHUCANADIAN SYLLABI" +
	"CS CARRIER KHOCANADIAN SYLLABICS CARRIER KHECANADIAN SYLLABICS CARRIER K" +
	"HEECANADIAN SYLLABICS CARRIER KHICANADIAN SYLLABICS CARRIER KHACANADIAN " +
	"SYLLABICS CARRIER KKUCANADIAN SYLLABICS CARRIER KKOCANADIAN SYLLABICS CA" +
	"RRIER KKECANADIAN SYLLABICS CARRIER KKEECANADIAN SYLLABICS CARRIER KKICA" +
	"NADIAN SYLLABICS CARRIER KKACANADIAN SYLLABICS CARRIER KKCANADIAN SYLLAB" +
	"ICS CARRIER NUCANADIAN SYLLABICS CARRIER NOCANADIAN SYLLABICS CARRIER NE" +
	"CANADIAN SYLLABICS CARRIER NEECANADIAN SYLLABICS CARRIER NICANADIAN SYLL" +
	"ABICS CARRIER NACANADIAN SYLLABICS CARRIER MUCANADIAN SYLLABICS CARRIER " +
	"MOCANADIAN SYLLABICS CARRIER MECANADIAN SYLLABICS CARRIER MEECANADIAN SY" +
	"LLABICS CARRIER MICANADIAN SYLLABICS CARRIER MACANADIAN SYLLABICS CARRIE" +
	"R YUCANADIAN SYLLABICS CARRIER YOCANADIAN SYLLABICS CARRIER YECANADIAN S" +
	"YLLABICS CARRIER YEECANADIAN SYLLABICS CARRIER YICANADIAN SYLLABICS CARR" +
	"IER YACANADIAN SYLLABICS CARRIER JUCANADIAN SYLLABICS SAYISI JUCANADIAN " +
	"SYLLABICS CARRIER JOCANADIAN SYLLABICS CARRIER JECANADIAN SYLLABICS CARR" +
	"IER JEECANADIAN SYLLABICS CARRIER JICANADIAN SYLLABICS SAYISI JICANADIAN" +
	" SYLLABICS CARRIER JACANADIAN SYLLABICS CARRIER JJUCANADIAN SYLLABICS CA" +
	"RRIER JJOCANADIAN SYLLABICS CARRIER JJECANADIAN SYLLABICS CARRIER JJEECA" +
	"NADIAN SYLLABICS CARRIER JJICANADIAN SYLLABICS CARRIER JJACANADIAN SYLLA" +
	"BICS CARRIER LUCANADIAN SYLLABICS CARRIER LOCANADIAN SYLLABICS CARRIER L" +
	"ECANADIAN SYLLABICS CARRIER LEECANADIAN SYLLABICS CARRIER LICANADIAN SYL" +
	"LABICS CARRIER LACANADIAN SYLLABICS CARRIER DLUCANADIAN SYLLABICS CARRIE" +
	"R DLOCANADIAN SYLLABICS CARRIER DLECANADIAN SYLLABICS CARRIER DLEECANADI" +
	"AN SYLLABICS CARRIER DLICANADIAN SYLLABICS CARRIER DLACANADIAN SYLLABICS" +
	" CARRIER LHUCANADIAN SYLLABICS CARRIER LHOCANADIAN SYLLABICS CARRIER LHE" +
	"CANADIAN SYLLABICS CARRIER LHEECANADIAN SYLLABICS CARRIER LHICANADIAN SY" +
	"LLABICS CARRIER LHACANADIAN SYLLABICS CARRIER TLHUCANADIAN SYLLABICS CAR" +
	"RIER TLHOCANADIAN SYLLABICS CARRIER TLHECANADIAN SYLLABICS CARRIER TLHEE" +
	"CANADIAN SYLLABICS CARRIER TLHICANADIAN SYLLABICS CARRIER TLHACANADIAN S" +
	"YLLABICS CARRIER TLUCANADIAN SYLLABICS CARRIER TLOCANADIAN SYLLABICS CAR" +
	"RIER TLECANADIAN SYLLABICS CARRIER TLEECANADIAN SYLLABICS CARRIER TLICAN" +
	"ADIAN SYLLABICS CARRIER TLACANADIAN SYLLABICS CARRIER ZUCANADIAN SYLLABI" +
	"CS CARRIER ZOCANADIAN SYLLABICS CARRIER ZECANADIAN SYLLABICS CARRIER ZEE" +
	"CANADIAN SYLLABICS CARRIER ZICANADIAN SYLLABICS CARRIER ZACANADIAN SYLLA" +
	"BICS CARRIER ZCANADIAN SYLLABICS CARRIER INITIAL ZCANADIAN SYLLABICS CAR" +
	"RIER DZUCANADIAN SYLLABICS CARRIER DZOCANADIAN SYLLABICS CARRIER DZECANA" +
	"DIAN SYLLABICS CARRIER DZEECANADIAN SYLLABICS CARRIER DZICANADIAN SYLLAB" +
	"ICS CARRIER DZACANADIAN SYLLABICS CARRIER SUCANADIAN SYLLABICS CARRIER S" +
	"OCANADIAN SYLLABICS CARRIER SECANADIAN SYLLABICS CARRIER SEECANADIAN SYL" +
	"LABICS CARRIER SICANADIAN SYLLABICS CARRIER SACANADIAN SYLLABICS CARRIER" +
	" SHUCANADIAN SYLLABICS CARRIER SHOCANADIAN SYLLABICS CARRIER SHECANADIAN" +
	" SYLLABICS CARRIER SHEECANADIAN SYLLABICS CARRIER SHICANADIAN SYLLABICS ") + ("" +
	"CARRIER SHACANADIAN SYLLABICS CARRIER SHCANADIAN SYLLABICS CARRIER TSUCA" +
	"NADIAN SYLLABICS CARRIER TSOCANADIAN SYLLABICS CARRIER TSECANADIAN SYLLA" +
	"BICS CARRIER TSEECANADIAN SYLLABICS CARRIER TSICANADIAN SYLLABICS CARRIE" +
	"R TSACANADIAN SYLLABICS CARRIER CHUCANADIAN SYLLABICS CARRIER CHOCANADIA" +
	"N SYLLABICS CARRIER CHECANADIAN SYLLABICS CARRIER CHEECANADIAN SYLLABICS" +
	" CARRIER CHICANADIAN SYLLABICS CARRIER CHACANADIAN SYLLABICS CARRIER TTS" +
	"UCANADIAN SYLLABICS CARRIER TTSOCANADIAN SYLLABICS CARRIER TTSECANADIAN " +
	"SYLLABICS CARRIER TTSEECANADIAN SYLLABICS CARRIER TTSICANADIAN SYLLABICS" +
	" CARRIER TTSACANADIAN SYLLABICS CHI SIGNCANADIAN SYLLABICS FULL STOPCANA" +
	"DIAN SYLLABICS QAICANADIAN SYLLABICS NGAICANADIAN SYLLABICS NNGICANADIAN" +
	" SYLLABICS NNGIICANADIAN SYLLABICS NNGOCANADIAN SYLLABICS NNGOOCANADIAN " +
	"SYLLABICS NNGACANADIAN SYLLABICS NNGAACANADIAN SYLLABICS WOODS-CREE THWE" +
	"ECANADIAN SYLLABICS WOODS-CREE THWICANADIAN SYLLABICS WOODS-CREE THWIICA" +
	"NADIAN SYLLABICS WOODS-CREE THWOCANADIAN SYLLABICS WOODS-CREE THWOOCANAD" +
	"IAN SYLLABICS WOODS-CREE THWACANADIAN SYLLABICS WOODS-CREE THWAACANADIAN" +
	" SYLLABICS WOODS-CREE FINAL THCANADIAN SYLLABICS BLACKFOOT WOGHAM SPACE " +
	"MARKOGHAM LETTER BEITHOGHAM LETTER LUISOGHAM LETTER FEARNOGHAM LETTER SA" +
	"ILOGHAM LETTER NIONOGHAM LETTER UATHOGHAM LETTER DAIROGHAM LETTER TINNEO" +
	"GHAM LETTER COLLOGHAM LETTER CEIRTOGHAM LETTER MUINOGHAM LETTER GORTOGHA" +
	"M LETTER NGEADALOGHAM LETTER STRAIFOGHAM LETTER RUISOGHAM LETTER AILMOGH" +
	"AM LETTER ONNOGHAM LETTER UROGHAM LETTER EADHADHOGHAM LETTER IODHADHOGHA" +
	"M LETTER EABHADHOGHAM LETTER OROGHAM LETTER UILLEANNOGHAM LETTER IFINOGH" +
	"AM LETTER EAMHANCHOLLOGHAM LETTER PEITHOGHAM FEATHER MARKOGHAM REVERSED " +
	"FEATHER MARKRUNIC LETTER FEHU FEOH FE FRUNIC LETTER VRUNIC LETTER URUZ U" +
	"R URUNIC LETTER YRRUNIC LETTER YRUNIC LETTER WRUNIC LETTER THURISAZ THUR" +
	"S THORNRUNIC LETTER ETHRUNIC LETTER ANSUZ ARUNIC LETTER OS ORUNIC LETTER" +
	" AC ARUNIC LETTER AESCRUNIC LETTER LONG-BRANCH-OSS ORUNIC LETTER SHORT-T" +
	"WIG-OSS ORUNIC LETTER ORUNIC LETTER OERUNIC LETTER ONRUNIC LETTER RAIDO " +
	"RAD REID RRUNIC LETTER KAUNARUNIC LETTER CENRUNIC LETTER KAUN KRUNIC LET" +
	"TER GRUNIC LETTER ENGRUNIC LETTER GEBO GYFU GRUNIC LETTER GARRUNIC LETTE" +
	"R WUNJO WYNN WRUNIC LETTER HAGLAZ HRUNIC LETTER HAEGL HRUNIC LETTER LONG" +
	"-BRANCH-HAGALL HRUNIC LETTER SHORT-TWIG-HAGALL HRUNIC LETTER NAUDIZ NYD " +
	"NAUD NRUNIC LETTER SHORT-TWIG-NAUD NRUNIC LETTER DOTTED-NRUNIC LETTER IS" +
	"AZ IS ISS IRUNIC LETTER ERUNIC LETTER JERAN JRUNIC LETTER GERRUNIC LETTE" +
	"R LONG-BRANCH-AR AERUNIC LETTER SHORT-TWIG-AR ARUNIC LETTER IWAZ EOHRUNI" +
	"C LETTER PERTHO PEORTH PRUNIC LETTER ALGIZ EOLHXRUNIC LETTER SOWILO SRUN" +
	"IC LETTER SIGEL LONG-BRANCH-SOL SRUNIC LETTER SHORT-TWIG-SOL SRUNIC LETT" +
	"ER CRUNIC LETTER ZRUNIC LETTER TIWAZ TIR TYR TRUNIC LETTER SHORT-TWIG-TY" +
	"R TRUNIC LETTER DRUNIC LETTER BERKANAN BEORC BJARKAN BRUNIC LETTER SHORT" +
	"-TWIG-BJARKAN BRUNIC LETTER DOTTED-PRUNIC LETTER OPEN-PRUNIC LETTER EHWA" +
	"Z EH ERUNIC LETTER MANNAZ MAN MRUNIC LETTER LONG-BRANCH-MADR MRUNIC LETT" +
	"ER SHORT-TWIG-MADR MRUNIC LETTER LAUKAZ LAGU LOGR LRUNIC LETTER DOTTED-L" +
	"RUNIC LETTER INGWAZRUNIC LETTER INGRUNIC LETTER DAGAZ DAEG DRUNIC LETTER" +
	" OTHALAN ETHEL ORUNIC LETTER EARRUNIC LETTER IORRUNIC LETTER CWEORTHRUNI" +
	"C LETTER CALCRUNIC LETTER CEALCRUNIC LETTER STANRUNIC LETTER LONG-BRANCH" +
	"-YRRUNIC LETTER SHORT-TWIG-YRRUNIC LETTER ICELANDIC-YRRUNIC LETTER QRUNI" +
	"C LETTER XRUNIC SINGLE PUNCTUATIONRUNIC MULTIPLE PUNCTUATIONRUNIC CROSS " +
	"PUNCTUATIONRUNIC ARLAUG SYMBOLRUNIC TVIMADUR SYMBOLRUNIC BELGTHOR SYMBOL" +
	"RUNIC LETTER KRUNIC LETTER SHRUNIC LETTER OORUNIC LETTER FRANKS CASKET O" +
	"SRUNIC LETTER FRANKS CASKET ISRUNIC LETTER FRANKS CASKET EHRUNIC LETTER " +
	"FRANKS CASKET ACRUNIC LETTER FRANKS CASKET AESCTAGALOG LETTER ATAGALOG L" +
	"ETTER ITAGALOG LETTER UTAGALOG LETTER KATAGALOG LETTER GATAGALOG LETTER " +
	"NGATAGALOG LETTER TATAGALOG LETTER DATAGALOG LETTER NATAGALOG LETTER PAT" +
	"AGALOG LETTER BATAGALOG LETTER MATAGALOG LETTER YATAGALOG LETTER RATAGAL" +
	"OG LETTER LATAGALOG LETTER WATAGALOG LETTER SATAGALOG LETTER HATAGALOG V" +
	"OWEL SIGN ITAGALOG VOWEL SIGN UTAGALOG SIGN VIRAMATAGALOG SIGN PAMUDPODT" +
	"AGALOG LETTER ARCHAIC RAHANUNOO LETTER AHANUNOO LETTER IHANUNOO LETTER U" +
	"HANUNOO LETTER KAHANUNOO LETTER GAHANUNOO LETTER NGAHANUNOO LETTER TAHAN" +
	"UNOO LETTER DAHANUNOO LETTER NAHANUNOO LETTER PAHANUNOO LETTER BAHANUNOO" +
	" LETTER MAHANUNOO LETTER YAHANUNOO LETTER RAHANUNOO LETTER LAHANUNOO LET" +
	"TER WAHANUNOO LETTER SAHANUNOO LETTER HAHANUNOO VOWEL SIGN IHANUNOO VOWE" +
	"L SIGN UHANUNOO SIGN PAMUDPODPHILIPPINE SINGLE PUNCTUATIONPHILIPPINE DOU" +
	"BLE PUNCTUATIONBUHID LETTER ABUHID LETTER IBUHID LETTER UBUHID LETTER KA" +
	"BUHID LETTER GABUHID LETTER NGABUHID LETTER TABUHID LETTER DABUHID LETTE") + ("" +
	"R NABUHID LETTER PABUHID LETTER BABUHID LETTER MABUHID LETTER YABUHID LE" +
	"TTER RABUHID LETTER LABUHID LETTER WABUHID LETTER SABUHID LETTER HABUHID" +
	" VOWEL SIGN IBUHID VOWEL SIGN UTAGBANWA LETTER ATAGBANWA LETTER ITAGBANW" +
	"A LETTER UTAGBANWA LETTER KATAGBANWA LETTER GATAGBANWA LETTER NGATAGBANW" +
	"A LETTER TATAGBANWA LETTER DATAGBANWA LETTER NATAGBANWA LETTER PATAGBANW" +
	"A LETTER BATAGBANWA LETTER MATAGBANWA LETTER YATAGBANWA LETTER LATAGBANW" +
	"A LETTER WATAGBANWA LETTER SATAGBANWA VOWEL SIGN ITAGBANWA VOWEL SIGN UK" +
	"HMER LETTER KAKHMER LETTER KHAKHMER LETTER KOKHMER LETTER KHOKHMER LETTE" +
	"R NGOKHMER LETTER CAKHMER LETTER CHAKHMER LETTER COKHMER LETTER CHOKHMER" +
	" LETTER NYOKHMER LETTER DAKHMER LETTER TTHAKHMER LETTER DOKHMER LETTER T" +
	"THOKHMER LETTER NNOKHMER LETTER TAKHMER LETTER THAKHMER LETTER TOKHMER L" +
	"ETTER THOKHMER LETTER NOKHMER LETTER BAKHMER LETTER PHAKHMER LETTER POKH" +
	"MER LETTER PHOKHMER LETTER MOKHMER LETTER YOKHMER LETTER ROKHMER LETTER " +
	"LOKHMER LETTER VOKHMER LETTER SHAKHMER LETTER SSOKHMER LETTER SAKHMER LE" +
	"TTER HAKHMER LETTER LAKHMER LETTER QAKHMER INDEPENDENT VOWEL QAQKHMER IN" +
	"DEPENDENT VOWEL QAAKHMER INDEPENDENT VOWEL QIKHMER INDEPENDENT VOWEL QII" +
	"KHMER INDEPENDENT VOWEL QUKHMER INDEPENDENT VOWEL QUKKHMER INDEPENDENT V" +
	"OWEL QUUKHMER INDEPENDENT VOWEL QUUVKHMER INDEPENDENT VOWEL RYKHMER INDE" +
	"PENDENT VOWEL RYYKHMER INDEPENDENT VOWEL LYKHMER INDEPENDENT VOWEL LYYKH" +
	"MER INDEPENDENT VOWEL QEKHMER INDEPENDENT VOWEL QAIKHMER INDEPENDENT VOW" +
	"EL QOO TYPE ONEKHMER INDEPENDENT VOWEL QOO TYPE TWOKHMER INDEPENDENT VOW" +
	"EL QAUKHMER VOWEL INHERENT AQKHMER VOWEL INHERENT AAKHMER VOWEL SIGN AAK" +
	"HMER VOWEL SIGN IKHMER VOWEL SIGN IIKHMER VOWEL SIGN YKHMER VOWEL SIGN Y" +
	"YKHMER VOWEL SIGN UKHMER VOWEL SIGN UUKHMER VOWEL SIGN UAKHMER VOWEL SIG" +
	"N OEKHMER VOWEL SIGN YAKHMER VOWEL SIGN IEKHMER VOWEL SIGN EKHMER VOWEL " +
	"SIGN AEKHMER VOWEL SIGN AIKHMER VOWEL SIGN OOKHMER VOWEL SIGN AUKHMER SI" +
	"GN NIKAHITKHMER SIGN REAHMUKKHMER SIGN YUUKALEAPINTUKHMER SIGN MUUSIKATO" +
	"ANKHMER SIGN TRIISAPKHMER SIGN BANTOCKHMER SIGN ROBATKHMER SIGN TOANDAKH" +
	"IATKHMER SIGN KAKABATKHMER SIGN AHSDAKHMER SIGN SAMYOK SANNYAKHMER SIGN " +
	"VIRIAMKHMER SIGN COENGKHMER SIGN BATHAMASATKHMER SIGN KHANKHMER SIGN BAR" +
	"IYOOSANKHMER SIGN CAMNUC PII KUUHKHMER SIGN LEK TOOKHMER SIGN BEYYALKHME" +
	"R SIGN PHNAEK MUANKHMER SIGN KOOMUUTKHMER CURRENCY SYMBOL RIELKHMER SIGN" +
	" AVAKRAHASANYAKHMER SIGN ATTHACANKHMER DIGIT ZEROKHMER DIGIT ONEKHMER DI" +
	"GIT TWOKHMER DIGIT THREEKHMER DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT SIXK" +
	"HMER DIGIT SEVENKHMER DIGIT EIGHTKHMER DIGIT NINEKHMER SYMBOL LEK ATTAK " +
	"SONKHMER SYMBOL LEK ATTAK MUOYKHMER SYMBOL LEK ATTAK PIIKHMER SYMBOL LEK" +
	" ATTAK BEIKHMER SYMBOL LEK ATTAK BUONKHMER SYMBOL LEK ATTAK PRAMKHMER SY" +
	"MBOL LEK ATTAK PRAM-MUOYKHMER SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL LEK " +
	"ATTAK PRAM-BEIKHMER SYMBOL LEK ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOLIAN E" +
	"LLIPSISMONGOLIAN COMMAMONGOLIAN FULL STOPMONGOLIAN COLONMONGOLIAN FOUR D" +
	"OTSMONGOLIAN TODO SOFT HYPHENMONGOLIAN SIBE SYLLABLE BOUNDARY MARKERMONG" +
	"OLIAN MANCHU COMMAMONGOLIAN MANCHU FULL STOPMONGOLIAN NIRUGUMONGOLIAN FR" +
	"EE VARIATION SELECTOR ONEMONGOLIAN FREE VARIATION SELECTOR TWOMONGOLIAN " +
	"FREE VARIATION SELECTOR THREEMONGOLIAN VOWEL SEPARATORMONGOLIAN FREE VAR" +
	"IATION SELECTOR FOURMONGOLIAN DIGIT ZEROMONGOLIAN DIGIT ONEMONGOLIAN DIG" +
	"IT TWOMONGOLIAN DIGIT THREEMONGOLIAN DIGIT FOURMONGOLIAN DIGIT FIVEMONGO" +
	"LIAN DIGIT SIXMONGOLIAN DIGIT SEVENMONGOLIAN DIGIT EIGHTMONGOLIAN DIGIT " +
	"NINEMONGOLIAN LETTER AMONGOLIAN LETTER EMONGOLIAN LETTER IMONGOLIAN LETT" +
	"ER OMONGOLIAN LETTER UMONGOLIAN LETTER OEMONGOLIAN LETTER UEMONGOLIAN LE" +
	"TTER EEMONGOLIAN LETTER NAMONGOLIAN LETTER ANGMONGOLIAN LETTER BAMONGOLI" +
	"AN LETTER PAMONGOLIAN LETTER QAMONGOLIAN LETTER GAMONGOLIAN LETTER MAMON" +
	"GOLIAN LETTER LAMONGOLIAN LETTER SAMONGOLIAN LETTER SHAMONGOLIAN LETTER " +
	"TAMONGOLIAN LETTER DAMONGOLIAN LETTER CHAMONGOLIAN LETTER JAMONGOLIAN LE" +
	"TTER YAMONGOLIAN LETTER RAMONGOLIAN LETTER WAMONGOLIAN LETTER FAMONGOLIA" +
	"N LETTER KAMONGOLIAN LETTER KHAMONGOLIAN LETTER TSAMONGOLIAN LETTER ZAMO" +
	"NGOLIAN LETTER HAAMONGOLIAN LETTER ZRAMONGOLIAN LETTER LHAMONGOLIAN LETT" +
	"ER ZHIMONGOLIAN LETTER CHIMONGOLIAN LETTER TODO LONG VOWEL SIGNMONGOLIAN" +
	" LETTER TODO EMONGOLIAN LETTER TODO IMONGOLIAN LETTER TODO OMONGOLIAN LE" +
	"TTER TODO UMONGOLIAN LETTER TODO OEMONGOLIAN LETTER TODO UEMONGOLIAN LET" +
	"TER TODO ANGMONGOLIAN LETTER TODO BAMONGOLIAN LETTER TODO PAMONGOLIAN LE" +
	"TTER TODO QAMONGOLIAN LETTER TODO GAMONGOLIAN LETTER TODO MAMONGOLIAN LE" +
	"TTER TODO TAMONGOLIAN LETTER TODO DAMONGOLIAN LETTER TODO CHAMONGOLIAN L" +
	"ETTER TODO JAMONGOLIAN LETTER TODO TSAMONGOLIAN LETTER TODO YAMONGOLIAN " +
	"LETTER TODO WAMONGOLIAN LETTER TODO KAMONGOLIAN LETTER TODO GAAMONGOLIAN") + ("" +
	" LETTER TODO HAAMONGOLIAN LETTER TODO JIAMONGOLIAN LETTER TODO NIAMONGOL" +
	"IAN LETTER TODO DZAMONGOLIAN LETTER SIBE EMONGOLIAN LETTER SIBE IMONGOLI" +
	"AN LETTER SIBE IYMONGOLIAN LETTER SIBE UEMONGOLIAN LETTER SIBE UMONGOLIA" +
	"N LETTER SIBE ANGMONGOLIAN LETTER SIBE KAMONGOLIAN LETTER SIBE GAMONGOLI" +
	"AN LETTER SIBE HAMONGOLIAN LETTER SIBE PAMONGOLIAN LETTER SIBE SHAMONGOL" +
	"IAN LETTER SIBE TAMONGOLIAN LETTER SIBE DAMONGOLIAN LETTER SIBE JAMONGOL" +
	"IAN LETTER SIBE FAMONGOLIAN LETTER SIBE GAAMONGOLIAN LETTER SIBE HAAMONG" +
	"OLIAN LETTER SIBE TSAMONGOLIAN LETTER SIBE ZAMONGOLIAN LETTER SIBE RAAMO" +
	"NGOLIAN LETTER SIBE CHAMONGOLIAN LETTER SIBE ZHAMONGOLIAN LETTER MANCHU " +
	"IMONGOLIAN LETTER MANCHU KAMONGOLIAN LETTER MANCHU RAMONGOLIAN LETTER MA" +
	"NCHU FAMONGOLIAN LETTER MANCHU ZHAMONGOLIAN LETTER CHA WITH TWO DOTSMONG" +
	"OLIAN LETTER ALI GALI ANUSVARA ONEMONGOLIAN LETTER ALI GALI VISARGA ONEM" +
	"ONGOLIAN LETTER ALI GALI DAMARUMONGOLIAN LETTER ALI GALI UBADAMAMONGOLIA" +
	"N LETTER ALI GALI INVERTED UBADAMAMONGOLIAN LETTER ALI GALI BALUDAMONGOL" +
	"IAN LETTER ALI GALI THREE BALUDAMONGOLIAN LETTER ALI GALI AMONGOLIAN LET" +
	"TER ALI GALI IMONGOLIAN LETTER ALI GALI KAMONGOLIAN LETTER ALI GALI NGAM" +
	"ONGOLIAN LETTER ALI GALI CAMONGOLIAN LETTER ALI GALI TTAMONGOLIAN LETTER" +
	" ALI GALI TTHAMONGOLIAN LETTER ALI GALI DDAMONGOLIAN LETTER ALI GALI NNA" +
	"MONGOLIAN LETTER ALI GALI TAMONGOLIAN LETTER ALI GALI DAMONGOLIAN LETTER" +
	" ALI GALI PAMONGOLIAN LETTER ALI GALI PHAMONGOLIAN LETTER ALI GALI SSAMO" +
	"NGOLIAN LETTER ALI GALI ZHAMONGOLIAN LETTER ALI GALI ZAMONGOLIAN LETTER " +
	"ALI GALI AHMONGOLIAN LETTER TODO ALI GALI TAMONGOLIAN LETTER TODO ALI GA" +
	"LI ZHAMONGOLIAN LETTER MANCHU ALI GALI GHAMONGOLIAN LETTER MANCHU ALI GA" +
	"LI NGAMONGOLIAN LETTER MANCHU ALI GALI CAMONGOLIAN LETTER MANCHU ALI GAL" +
	"I JHAMONGOLIAN LETTER MANCHU ALI GALI TTAMONGOLIAN LETTER MANCHU ALI GAL" +
	"I DDHAMONGOLIAN LETTER MANCHU ALI GALI TAMONGOLIAN LETTER MANCHU ALI GAL" +
	"I DHAMONGOLIAN LETTER MANCHU ALI GALI SSAMONGOLIAN LETTER MANCHU ALI GAL" +
	"I CYAMONGOLIAN LETTER MANCHU ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI GAL" +
	"I ZAMONGOLIAN LETTER ALI GALI HALF UMONGOLIAN LETTER ALI GALI HALF YAMON" +
	"GOLIAN LETTER MANCHU ALI GALI BHAMONGOLIAN LETTER ALI GALI DAGALGAMONGOL" +
	"IAN LETTER MANCHU ALI GALI LHACANADIAN SYLLABICS OYCANADIAN SYLLABICS AY" +
	"CANADIAN SYLLABICS AAYCANADIAN SYLLABICS WAYCANADIAN SYLLABICS POYCANADI" +
	"AN SYLLABICS PAYCANADIAN SYLLABICS PWOYCANADIAN SYLLABICS TAYCANADIAN SY" +
	"LLABICS KAYCANADIAN SYLLABICS KWAYCANADIAN SYLLABICS MAYCANADIAN SYLLABI" +
	"CS NOYCANADIAN SYLLABICS NAYCANADIAN SYLLABICS LAYCANADIAN SYLLABICS SOY" +
	"CANADIAN SYLLABICS SAYCANADIAN SYLLABICS SHOYCANADIAN SYLLABICS SHAYCANA" +
	"DIAN SYLLABICS SHWOYCANADIAN SYLLABICS YOYCANADIAN SYLLABICS YAYCANADIAN" +
	" SYLLABICS RAYCANADIAN SYLLABICS NWICANADIAN SYLLABICS OJIBWAY NWICANADI" +
	"AN SYLLABICS NWIICANADIAN SYLLABICS OJIBWAY NWIICANADIAN SYLLABICS NWOCA" +
	"NADIAN SYLLABICS OJIBWAY NWOCANADIAN SYLLABICS NWOOCANADIAN SYLLABICS OJ" +
	"IBWAY NWOOCANADIAN SYLLABICS RWEECANADIAN SYLLABICS RWICANADIAN SYLLABIC" +
	"S RWIICANADIAN SYLLABICS RWOCANADIAN SYLLABICS RWOOCANADIAN SYLLABICS RW" +
	"ACANADIAN SYLLABICS OJIBWAY PCANADIAN SYLLABICS OJIBWAY TCANADIAN SYLLAB" +
	"ICS OJIBWAY KCANADIAN SYLLABICS OJIBWAY CCANADIAN SYLLABICS OJIBWAY MCAN" +
	"ADIAN SYLLABICS OJIBWAY NCANADIAN SYLLABICS OJIBWAY SCANADIAN SYLLABICS " +
	"OJIBWAY SHCANADIAN SYLLABICS EASTERN WCANADIAN SYLLABICS WESTERN WCANADI" +
	"AN SYLLABICS FINAL SMALL RINGCANADIAN SYLLABICS FINAL RAISED DOTCANADIAN" +
	" SYLLABICS R-CREE RWECANADIAN SYLLABICS WEST-CREE LOOCANADIAN SYLLABICS " +
	"WEST-CREE LAACANADIAN SYLLABICS THWECANADIAN SYLLABICS THWACANADIAN SYLL" +
	"ABICS TTHWECANADIAN SYLLABICS TTHOOCANADIAN SYLLABICS TTHAACANADIAN SYLL" +
	"ABICS TLHWECANADIAN SYLLABICS TLHOOCANADIAN SYLLABICS SAYISI SHWECANADIA" +
	"N SYLLABICS SAYISI SHOOCANADIAN SYLLABICS SAYISI HOOCANADIAN SYLLABICS C" +
	"ARRIER GWUCANADIAN SYLLABICS CARRIER DENE GEECANADIAN SYLLABICS CARRIER " +
	"GAACANADIAN SYLLABICS CARRIER GWACANADIAN SYLLABICS SAYISI JUUCANADIAN S" +
	"YLLABICS CARRIER JWACANADIAN SYLLABICS BEAVER DENE LCANADIAN SYLLABICS B" +
	"EAVER DENE RCANADIAN SYLLABICS CARRIER DENTAL SLIMBU VOWEL-CARRIER LETTE" +
	"RLIMBU LETTER KALIMBU LETTER KHALIMBU LETTER GALIMBU LETTER GHALIMBU LET" +
	"TER NGALIMBU LETTER CALIMBU LETTER CHALIMBU LETTER JALIMBU LETTER JHALIM" +
	"BU LETTER YANLIMBU LETTER TALIMBU LETTER THALIMBU LETTER DALIMBU LETTER " +
	"DHALIMBU LETTER NALIMBU LETTER PALIMBU LETTER PHALIMBU LETTER BALIMBU LE" +
	"TTER BHALIMBU LETTER MALIMBU LETTER YALIMBU LETTER RALIMBU LETTER LALIMB" +
	"U LETTER WALIMBU LETTER SHALIMBU LETTER SSALIMBU LETTER SALIMBU LETTER H" +
	"ALIMBU LETTER GYANLIMBU LETTER TRALIMBU VOWEL SIGN ALIMBU VOWEL SIGN ILI" +
	"MBU VOWEL SIGN ULIMBU VOWEL SIGN EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN O") + ("" +
	"OLIMBU VOWEL SIGN AULIMBU VOWEL SIGN ELIMBU VOWEL SIGN OLIMBU SUBJOINED " +
	"LETTER YALIMBU SUBJOINED LETTER RALIMBU SUBJOINED LETTER WALIMBU SMALL L" +
	"ETTER KALIMBU SMALL LETTER NGALIMBU SMALL LETTER ANUSVARALIMBU SMALL LET" +
	"TER TALIMBU SMALL LETTER NALIMBU SMALL LETTER PALIMBU SMALL LETTER MALIM" +
	"BU SMALL LETTER RALIMBU SMALL LETTER LALIMBU SIGN MUKPHRENGLIMBU SIGN KE" +
	"MPHRENGLIMBU SIGN SA-ILIMBU SIGN LOOLIMBU EXCLAMATION MARKLIMBU QUESTION" +
	" MARKLIMBU DIGIT ZEROLIMBU DIGIT ONELIMBU DIGIT TWOLIMBU DIGIT THREELIMB" +
	"U DIGIT FOURLIMBU DIGIT FIVELIMBU DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGIT " +
	"EIGHTLIMBU DIGIT NINETAI LE LETTER KATAI LE LETTER XATAI LE LETTER NGATA" +
	"I LE LETTER TSATAI LE LETTER SATAI LE LETTER YATAI LE LETTER TATAI LE LE" +
	"TTER THATAI LE LETTER LATAI LE LETTER PATAI LE LETTER PHATAI LE LETTER M" +
	"ATAI LE LETTER FATAI LE LETTER VATAI LE LETTER HATAI LE LETTER QATAI LE " +
	"LETTER KHATAI LE LETTER TSHATAI LE LETTER NATAI LE LETTER ATAI LE LETTER" +
	" ITAI LE LETTER EETAI LE LETTER EHTAI LE LETTER UTAI LE LETTER OOTAI LE " +
	"LETTER OTAI LE LETTER UETAI LE LETTER ETAI LE LETTER AUETAI LE LETTER AI" +
	"TAI LE LETTER TONE-2TAI LE LETTER TONE-3TAI LE LETTER TONE-4TAI LE LETTE" +
	"R TONE-5TAI LE LETTER TONE-6NEW TAI LUE LETTER HIGH QANEW TAI LUE LETTER" +
	" LOW QANEW TAI LUE LETTER HIGH KANEW TAI LUE LETTER HIGH XANEW TAI LUE L" +
	"ETTER HIGH NGANEW TAI LUE LETTER LOW KANEW TAI LUE LETTER LOW XANEW TAI " +
	"LUE LETTER LOW NGANEW TAI LUE LETTER HIGH TSANEW TAI LUE LETTER HIGH SAN" +
	"EW TAI LUE LETTER HIGH YANEW TAI LUE LETTER LOW TSANEW TAI LUE LETTER LO" +
	"W SANEW TAI LUE LETTER LOW YANEW TAI LUE LETTER HIGH TANEW TAI LUE LETTE" +
	"R HIGH THANEW TAI LUE LETTER HIGH NANEW TAI LUE LETTER LOW TANEW TAI LUE" +
	" LETTER LOW THANEW TAI LUE LETTER LOW NANEW TAI LUE LETTER HIGH PANEW TA" +
	"I LUE LETTER HIGH PHANEW TAI LUE LETTER HIGH MANEW TAI LUE LETTER LOW PA" +
	"NEW TAI LUE LETTER LOW PHANEW TAI LUE LETTER LOW MANEW TAI LUE LETTER HI" +
	"GH FANEW TAI LUE LETTER HIGH VANEW TAI LUE LETTER HIGH LANEW TAI LUE LET" +
	"TER LOW FANEW TAI LUE LETTER LOW VANEW TAI LUE LETTER LOW LANEW TAI LUE " +
	"LETTER HIGH HANEW TAI LUE LETTER HIGH DANEW TAI LUE LETTER HIGH BANEW TA" +
	"I LUE LETTER LOW HANEW TAI LUE LETTER LOW DANEW TAI LUE LETTER LOW BANEW" +
	" TAI LUE LETTER HIGH KVANEW TAI LUE LETTER HIGH XVANEW TAI LUE LETTER LO" +
	"W KVANEW TAI LUE LETTER LOW XVANEW TAI LUE LETTER HIGH SUANEW TAI LUE LE" +
	"TTER LOW SUANEW TAI LUE VOWEL SIGN VOWEL SHORTENERNEW TAI LUE VOWEL SIGN" +
	" AANEW TAI LUE VOWEL SIGN IINEW TAI LUE VOWEL SIGN UNEW TAI LUE VOWEL SI" +
	"GN UUNEW TAI LUE VOWEL SIGN ENEW TAI LUE VOWEL SIGN AENEW TAI LUE VOWEL " +
	"SIGN ONEW TAI LUE VOWEL SIGN OANEW TAI LUE VOWEL SIGN UENEW TAI LUE VOWE" +
	"L SIGN AYNEW TAI LUE VOWEL SIGN AAYNEW TAI LUE VOWEL SIGN UYNEW TAI LUE " +
	"VOWEL SIGN OYNEW TAI LUE VOWEL SIGN OAYNEW TAI LUE VOWEL SIGN UEYNEW TAI" +
	" LUE VOWEL SIGN IYNEW TAI LUE LETTER FINAL VNEW TAI LUE LETTER FINAL NGN" +
	"EW TAI LUE LETTER FINAL NNEW TAI LUE LETTER FINAL MNEW TAI LUE LETTER FI" +
	"NAL KNEW TAI LUE LETTER FINAL DNEW TAI LUE LETTER FINAL BNEW TAI LUE TON" +
	"E MARK-1NEW TAI LUE TONE MARK-2NEW TAI LUE DIGIT ZERONEW TAI LUE DIGIT O" +
	"NENEW TAI LUE DIGIT TWONEW TAI LUE DIGIT THREENEW TAI LUE DIGIT FOURNEW " +
	"TAI LUE DIGIT FIVENEW TAI LUE DIGIT SIXNEW TAI LUE DIGIT SEVENNEW TAI LU" +
	"E DIGIT EIGHTNEW TAI LUE DIGIT NINENEW TAI LUE THAM DIGIT ONENEW TAI LUE" +
	" SIGN LAENEW TAI LUE SIGN LAEVKHMER SYMBOL PATHAMASATKHMER SYMBOL MUOY K" +
	"OETKHMER SYMBOL PII KOETKHMER SYMBOL BEI KOETKHMER SYMBOL BUON KOETKHMER" +
	" SYMBOL PRAM KOETKHMER SYMBOL PRAM-MUOY KOETKHMER SYMBOL PRAM-PII KOETKH" +
	"MER SYMBOL PRAM-BEI KOETKHMER SYMBOL PRAM-BUON KOETKHMER SYMBOL DAP KOET" +
	"KHMER SYMBOL DAP-MUOY KOETKHMER SYMBOL DAP-PII KOETKHMER SYMBOL DAP-BEI " +
	"KOETKHMER SYMBOL DAP-BUON KOETKHMER SYMBOL DAP-PRAM KOETKHMER SYMBOL TUT" +
	"EYASATKHMER SYMBOL MUOY ROCKHMER SYMBOL PII ROCKHMER SYMBOL BEI ROCKHMER" +
	" SYMBOL BUON ROCKHMER SYMBOL PRAM ROCKHMER SYMBOL PRAM-MUOY ROCKHMER SYM" +
	"BOL PRAM-PII ROCKHMER SYMBOL PRAM-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHMER" +
	" SYMBOL DAP ROCKHMER SYMBOL DAP-MUOY ROCKHMER SYMBOL DAP-PII ROCKHMER SY" +
	"MBOL DAP-BEI ROCKHMER SYMBOL DAP-BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGINE" +
	"SE LETTER KABUGINESE LETTER GABUGINESE LETTER NGABUGINESE LETTER NGKABUG" +
	"INESE LETTER PABUGINESE LETTER BABUGINESE LETTER MABUGINESE LETTER MPABU" +
	"GINESE LETTER TABUGINESE LETTER DABUGINESE LETTER NABUGINESE LETTER NRAB" +
	"UGINESE LETTER CABUGINESE LETTER JABUGINESE LETTER NYABUGINESE LETTER NY" +
	"CABUGINESE LETTER YABUGINESE LETTER RABUGINESE LETTER LABUGINESE LETTER " +
	"VABUGINESE LETTER SABUGINESE LETTER ABUGINESE LETTER HABUGINESE VOWEL SI" +
	"GN IBUGINESE VOWEL SIGN UBUGINESE VOWEL SIGN EBUGINESE VOWEL SIGN OBUGIN" +
	"ESE VOWEL SIGN AEBUGINESE PALLAWABUGINESE END OF SECTIONTAI THAM LETTER ") + ("" +
	"HIGH KATAI THAM LETTER HIGH KHATAI THAM LETTER HIGH KXATAI THAM LETTER L" +
	"OW KATAI THAM LETTER LOW KXATAI THAM LETTER LOW KHATAI THAM LETTER NGATA" +
	"I THAM LETTER HIGH CATAI THAM LETTER HIGH CHATAI THAM LETTER LOW CATAI T" +
	"HAM LETTER LOW SATAI THAM LETTER LOW CHATAI THAM LETTER NYATAI THAM LETT" +
	"ER RATATAI THAM LETTER HIGH RATHATAI THAM LETTER DATAI THAM LETTER LOW R" +
	"ATHATAI THAM LETTER RANATAI THAM LETTER HIGH TATAI THAM LETTER HIGH THAT" +
	"AI THAM LETTER LOW TATAI THAM LETTER LOW THATAI THAM LETTER NATAI THAM L" +
	"ETTER BATAI THAM LETTER HIGH PATAI THAM LETTER HIGH PHATAI THAM LETTER H" +
	"IGH FATAI THAM LETTER LOW PATAI THAM LETTER LOW FATAI THAM LETTER LOW PH" +
	"ATAI THAM LETTER MATAI THAM LETTER LOW YATAI THAM LETTER HIGH YATAI THAM" +
	" LETTER RATAI THAM LETTER RUETAI THAM LETTER LATAI THAM LETTER LUETAI TH" +
	"AM LETTER WATAI THAM LETTER HIGH SHATAI THAM LETTER HIGH SSATAI THAM LET" +
	"TER HIGH SATAI THAM LETTER HIGH HATAI THAM LETTER LLATAI THAM LETTER ATA" +
	"I THAM LETTER LOW HATAI THAM LETTER ITAI THAM LETTER IITAI THAM LETTER U" +
	"TAI THAM LETTER UUTAI THAM LETTER EETAI THAM LETTER OOTAI THAM LETTER LA" +
	"ETAI THAM LETTER GREAT SATAI THAM CONSONANT SIGN MEDIAL RATAI THAM CONSO" +
	"NANT SIGN MEDIAL LATAI THAM CONSONANT SIGN LA TANG LAITAI THAM SIGN MAI " +
	"KANG LAITAI THAM CONSONANT SIGN FINAL NGATAI THAM CONSONANT SIGN LOW PAT" +
	"AI THAM CONSONANT SIGN HIGH RATHA OR LOW PATAI THAM CONSONANT SIGN MATAI" +
	" THAM CONSONANT SIGN BATAI THAM CONSONANT SIGN SATAI THAM SIGN SAKOTTAI " +
	"THAM VOWEL SIGN ATAI THAM VOWEL SIGN MAI SATTAI THAM VOWEL SIGN AATAI TH" +
	"AM VOWEL SIGN TALL AATAI THAM VOWEL SIGN ITAI THAM VOWEL SIGN IITAI THAM" +
	" VOWEL SIGN UETAI THAM VOWEL SIGN UUETAI THAM VOWEL SIGN UTAI THAM VOWEL" +
	" SIGN UUTAI THAM VOWEL SIGN OTAI THAM VOWEL SIGN OA BELOWTAI THAM VOWEL " +
	"SIGN OYTAI THAM VOWEL SIGN ETAI THAM VOWEL SIGN AETAI THAM VOWEL SIGN OO" +
	"TAI THAM VOWEL SIGN AITAI THAM VOWEL SIGN THAM AITAI THAM VOWEL SIGN OA " +
	"ABOVETAI THAM SIGN MAI KANGTAI THAM SIGN TONE-1TAI THAM SIGN TONE-2TAI T" +
	"HAM SIGN KHUEN TONE-3TAI THAM SIGN KHUEN TONE-4TAI THAM SIGN KHUEN TONE-" +
	"5TAI THAM SIGN RA HAAMTAI THAM SIGN MAI SAMTAI THAM SIGN KHUEN-LUE KARAN" +
	"TAI THAM COMBINING CRYPTOGRAMMIC DOTTAI THAM HORA DIGIT ZEROTAI THAM HOR" +
	"A DIGIT ONETAI THAM HORA DIGIT TWOTAI THAM HORA DIGIT THREETAI THAM HORA" +
	" DIGIT FOURTAI THAM HORA DIGIT FIVETAI THAM HORA DIGIT SIXTAI THAM HORA " +
	"DIGIT SEVENTAI THAM HORA DIGIT EIGHTTAI THAM HORA DIGIT NINETAI THAM THA" +
	"M DIGIT ZEROTAI THAM THAM DIGIT ONETAI THAM THAM DIGIT TWOTAI THAM THAM " +
	"DIGIT THREETAI THAM THAM DIGIT FOURTAI THAM THAM DIGIT FIVETAI THAM THAM" +
	" DIGIT SIXTAI THAM THAM DIGIT SEVENTAI THAM THAM DIGIT EIGHTTAI THAM THA" +
	"M DIGIT NINETAI THAM SIGN WIANGTAI THAM SIGN WIANGWAAKTAI THAM SIGN SAWA" +
	"NTAI THAM SIGN KEOWTAI THAM SIGN HOYTAI THAM SIGN DOKMAITAI THAM SIGN RE" +
	"VERSED ROTATED RANATAI THAM SIGN MAI YAMOKTAI THAM SIGN KAANTAI THAM SIG" +
	"N KAANKUUTAI THAM SIGN SATKAANTAI THAM SIGN SATKAANKUUTAI THAM SIGN HANG" +
	"TAI THAM SIGN CAANGCOMBINING DOUBLED CIRCUMFLEX ACCENTCOMBINING DIAERESI" +
	"S-RINGCOMBINING INFINITYCOMBINING DOWNWARDS ARROWCOMBINING TRIPLE DOTCOM" +
	"BINING X-X BELOWCOMBINING WIGGLY LINE BELOWCOMBINING OPEN MARK BELOWCOMB" +
	"INING DOUBLE OPEN MARK BELOWCOMBINING LIGHT CENTRALIZATION STROKE BELOWC" +
	"OMBINING STRONG CENTRALIZATION STROKE BELOWCOMBINING PARENTHESES ABOVECO" +
	"MBINING DOUBLE PARENTHESES ABOVECOMBINING PARENTHESES BELOWCOMBINING PAR" +
	"ENTHESES OVERLAYCOMBINING LATIN SMALL LETTER W BELOWCOMBINING LATIN SMAL" +
	"L LETTER TURNED W BELOWCOMBINING LEFT PARENTHESIS ABOVE LEFTCOMBINING RI" +
	"GHT PARENTHESIS ABOVE RIGHTCOMBINING LEFT PARENTHESIS BELOW LEFTCOMBININ" +
	"G RIGHT PARENTHESIS BELOW RIGHTCOMBINING SQUARE BRACKETS ABOVECOMBINING " +
	"NUMBER SIGN ABOVECOMBINING INVERTED DOUBLE ARCH ABOVECOMBINING PLUS SIGN" +
	" ABOVECOMBINING DOUBLE PLUS SIGN ABOVECOMBINING DOUBLE PLUS SIGN BELOWCO" +
	"MBINING TRIPLE ACUTE ACCENTCOMBINING LATIN SMALL LETTER INSULAR GCOMBINI" +
	"NG LATIN SMALL LETTER INSULAR RCOMBINING LATIN SMALL LETTER INSULAR TCOM" +
	"BINING DOUBLE CARONCOMBINING VERTICAL-LINE-ACUTECOMBINING GRAVE-VERTICAL" +
	"-LINECOMBINING VERTICAL-LINE-GRAVECOMBINING ACUTE-VERTICAL-LINECOMBINING" +
	" VERTICAL-LINE-MACRONCOMBINING MACRON-VERTICAL-LINECOMBINING VERTICAL-LI" +
	"NE-ACUTE-GRAVECOMBINING VERTICAL-LINE-GRAVE-ACUTECOMBINING MACRON-ACUTE-" +
	"GRAVECOMBINING SHARP SIGNCOMBINING FLAT SIGNCOMBINING DOWN TACK ABOVECOM" +
	"BINING DIAERESIS WITH RAISED LEFT DOTCOMBINING DOT-AND-RING BELOWCOMBINI" +
	"NG LEFT TACK ABOVECOMBINING RIGHT TACK ABOVECOMBINING MINUS SIGN ABOVECO" +
	"MBINING INVERTED BRIDGE ABOVECOMBINING SQUARE ABOVECOMBINING SEAGULL ABO" +
	"VECOMBINING DOUBLE ARCH BELOWCOMBINING DOUBLE ARCH ABOVECOMBINING EQUALS" +
	" SIGN ABOVECOMBINING LEFT ANGLE CENTRED ABOVECOMBINING UPWARDS ARROW ABO") + ("" +
	"VECOMBINING DOUBLE RIGHTWARDS ARROW ABOVEBALINESE SIGN ULU RICEMBALINESE" +
	" SIGN ULU CANDRABALINESE SIGN CECEKBALINESE SIGN SURANGBALINESE SIGN BIS" +
	"AHBALINESE LETTER AKARABALINESE LETTER AKARA TEDUNGBALINESE LETTER IKARA" +
	"BALINESE LETTER IKARA TEDUNGBALINESE LETTER UKARABALINESE LETTER UKARA T" +
	"EDUNGBALINESE LETTER RA REPABALINESE LETTER RA REPA TEDUNGBALINESE LETTE" +
	"R LA LENGABALINESE LETTER LA LENGA TEDUNGBALINESE LETTER EKARABALINESE L" +
	"ETTER AIKARABALINESE LETTER OKARABALINESE LETTER OKARA TEDUNGBALINESE LE" +
	"TTER KABALINESE LETTER KA MAHAPRANABALINESE LETTER GABALINESE LETTER GA " +
	"GORABALINESE LETTER NGABALINESE LETTER CABALINESE LETTER CA LACABALINESE" +
	" LETTER JABALINESE LETTER JA JERABALINESE LETTER NYABALINESE LETTER TA L" +
	"ATIKBALINESE LETTER TA MURDA MAHAPRANABALINESE LETTER DA MURDA ALPAPRANA" +
	"BALINESE LETTER DA MURDA MAHAPRANABALINESE LETTER NA RAMBATBALINESE LETT" +
	"ER TABALINESE LETTER TA TAWABALINESE LETTER DABALINESE LETTER DA MADUBAL" +
	"INESE LETTER NABALINESE LETTER PABALINESE LETTER PA KAPALBALINESE LETTER" +
	" BABALINESE LETTER BA KEMBANGBALINESE LETTER MABALINESE LETTER YABALINES" +
	"E LETTER RABALINESE LETTER LABALINESE LETTER WABALINESE LETTER SA SAGABA" +
	"LINESE LETTER SA SAPABALINESE LETTER SABALINESE LETTER HABALINESE SIGN R" +
	"EREKANBALINESE VOWEL SIGN TEDUNGBALINESE VOWEL SIGN ULUBALINESE VOWEL SI" +
	"GN ULU SARIBALINESE VOWEL SIGN SUKUBALINESE VOWEL SIGN SUKU ILUTBALINESE" +
	" VOWEL SIGN RA REPABALINESE VOWEL SIGN RA REPA TEDUNGBALINESE VOWEL SIGN" +
	" LA LENGABALINESE VOWEL SIGN LA LENGA TEDUNGBALINESE VOWEL SIGN TALINGBA" +
	"LINESE VOWEL SIGN TALING REPABALINESE VOWEL SIGN TALING TEDUNGBALINESE V" +
	"OWEL SIGN TALING REPA TEDUNGBALINESE VOWEL SIGN PEPETBALINESE VOWEL SIGN" +
	" PEPET TEDUNGBALINESE ADEG ADEGBALINESE LETTER KAF SASAKBALINESE LETTER " +
	"KHOT SASAKBALINESE LETTER TZIR SASAKBALINESE LETTER EF SASAKBALINESE LET" +
	"TER VE SASAKBALINESE LETTER ZAL SASAKBALINESE LETTER ASYURA SASAKBALINES" +
	"E LETTER ARCHAIC JNYABALINESE INVERTED CARIK SIKIBALINESE INVERTED CARIK" +
	" PARERENBALINESE DIGIT ZEROBALINESE DIGIT ONEBALINESE DIGIT TWOBALINESE " +
	"DIGIT THREEBALINESE DIGIT FOURBALINESE DIGIT FIVEBALINESE DIGIT SIXBALIN" +
	"ESE DIGIT SEVENBALINESE DIGIT EIGHTBALINESE DIGIT NINEBALINESE PANTIBALI" +
	"NESE PAMADABALINESE WINDUBALINESE CARIK PAMUNGKAHBALINESE CARIK SIKIBALI" +
	"NESE CARIK PARERENBALINESE PAMENENGBALINESE MUSICAL SYMBOL DONGBALINESE " +
	"MUSICAL SYMBOL DENGBALINESE MUSICAL SYMBOL DUNGBALINESE MUSICAL SYMBOL D" +
	"ANGBALINESE MUSICAL SYMBOL DANG SURANGBALINESE MUSICAL SYMBOL DINGBALINE" +
	"SE MUSICAL SYMBOL DAENGBALINESE MUSICAL SYMBOL DEUNGBALINESE MUSICAL SYM" +
	"BOL DAINGBALINESE MUSICAL SYMBOL DANG GEDEBALINESE MUSICAL SYMBOL COMBIN" +
	"ING TEGEHBALINESE MUSICAL SYMBOL COMBINING ENDEPBALINESE MUSICAL SYMBOL " +
	"COMBINING KEMPULBALINESE MUSICAL SYMBOL COMBINING KEMPLIBALINESE MUSICAL" +
	" SYMBOL COMBINING JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH J" +
	"EGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGANBALINESE MUSI" +
	"CAL SYMBOL COMBINING BENDEBALINESE MUSICAL SYMBOL COMBINING GONGBALINESE" +
	" MUSICAL SYMBOL RIGHT-HAND OPEN DUGBALINESE MUSICAL SYMBOL RIGHT-HAND OP" +
	"EN DAGBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUKBALINESE MUSICAL SYMB" +
	"OL RIGHT-HAND CLOSED TAKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANGBALIN" +
	"ESE MUSICAL SYMBOL LEFT-HAND OPEN PUNGBALINESE MUSICAL SYMBOL LEFT-HAND " +
	"CLOSED PLAKBALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUKBALINESE MUSICAL" +
	" SYMBOL LEFT-HAND OPEN PINGBALINESE PANTI LANTANGBALINESE PAMADA LANTANG" +
	"BALINESE PANTI BAWAKSUNDANESE SIGN PANYECEKSUNDANESE SIGN PANGLAYARSUNDA" +
	"NESE SIGN PANGWISADSUNDANESE LETTER ASUNDANESE LETTER ISUNDANESE LETTER " +
	"USUNDANESE LETTER AESUNDANESE LETTER OSUNDANESE LETTER ESUNDANESE LETTER" +
	" EUSUNDANESE LETTER KASUNDANESE LETTER QASUNDANESE LETTER GASUNDANESE LE" +
	"TTER NGASUNDANESE LETTER CASUNDANESE LETTER JASUNDANESE LETTER ZASUNDANE" +
	"SE LETTER NYASUNDANESE LETTER TASUNDANESE LETTER DASUNDANESE LETTER NASU" +
	"NDANESE LETTER PASUNDANESE LETTER FASUNDANESE LETTER VASUNDANESE LETTER " +
	"BASUNDANESE LETTER MASUNDANESE LETTER YASUNDANESE LETTER RASUNDANESE LET" +
	"TER LASUNDANESE LETTER WASUNDANESE LETTER SASUNDANESE LETTER XASUNDANESE" +
	" LETTER HASUNDANESE CONSONANT SIGN PAMINGKALSUNDANESE CONSONANT SIGN PAN" +
	"YAKRASUNDANESE CONSONANT SIGN PANYIKUSUNDANESE VOWEL SIGN PANGHULUSUNDAN" +
	"ESE VOWEL SIGN PANYUKUSUNDANESE VOWEL SIGN PANAELAENGSUNDANESE VOWEL SIG" +
	"N PANOLONGSUNDANESE VOWEL SIGN PAMEPETSUNDANESE VOWEL SIGN PANEULEUNGSUN" +
	"DANESE SIGN PAMAAEHSUNDANESE SIGN VIRAMASUNDANESE CONSONANT SIGN PASANGA" +
	"N MASUNDANESE CONSONANT SIGN PASANGAN WASUNDANESE LETTER KHASUNDANESE LE" +
	"TTER SYASUNDANESE DIGIT ZEROSUNDANESE DIGIT ONESUNDANESE DIGIT TWOSUNDAN" +
	"ESE DIGIT THREESUNDANESE DIGIT FOURSUNDANESE DIGIT FIVESUNDANESE DIGIT S") + ("" +
	"IXSUNDANESE DIGIT SEVENSUNDANESE DIGIT EIGHTSUNDANESE DIGIT NINESUNDANES" +
	"E AVAGRAHASUNDANESE LETTER REUSUNDANESE LETTER LEUSUNDANESE LETTER BHASU" +
	"NDANESE LETTER FINAL KSUNDANESE LETTER FINAL MBATAK LETTER ABATAK LETTER" +
	" SIMALUNGUN ABATAK LETTER HABATAK LETTER SIMALUNGUN HABATAK LETTER MANDA" +
	"ILING HABATAK LETTER BABATAK LETTER KARO BABATAK LETTER PABATAK LETTER S" +
	"IMALUNGUN PABATAK LETTER NABATAK LETTER MANDAILING NABATAK LETTER WABATA" +
	"K LETTER SIMALUNGUN WABATAK LETTER PAKPAK WABATAK LETTER GABATAK LETTER " +
	"SIMALUNGUN GABATAK LETTER JABATAK LETTER DABATAK LETTER RABATAK LETTER S" +
	"IMALUNGUN RABATAK LETTER MABATAK LETTER SIMALUNGUN MABATAK LETTER SOUTHE" +
	"RN TABATAK LETTER NORTHERN TABATAK LETTER SABATAK LETTER SIMALUNGUN SABA" +
	"TAK LETTER MANDAILING SABATAK LETTER YABATAK LETTER SIMALUNGUN YABATAK L" +
	"ETTER NGABATAK LETTER LABATAK LETTER SIMALUNGUN LABATAK LETTER NYABATAK " +
	"LETTER CABATAK LETTER NDABATAK LETTER MBABATAK LETTER IBATAK LETTER UBAT" +
	"AK SIGN TOMPIBATAK VOWEL SIGN EBATAK VOWEL SIGN PAKPAK EBATAK VOWEL SIGN" +
	" EEBATAK VOWEL SIGN IBATAK VOWEL SIGN KARO IBATAK VOWEL SIGN OBATAK VOWE" +
	"L SIGN KARO OBATAK VOWEL SIGN UBATAK VOWEL SIGN U FOR SIMALUNGUN SABATAK" +
	" CONSONANT SIGN NGBATAK CONSONANT SIGN HBATAK PANGOLATBATAK PANONGONANBA" +
	"TAK SYMBOL BINDU NA METEKBATAK SYMBOL BINDU PINARBORASBATAK SYMBOL BINDU" +
	" JUDULBATAK SYMBOL BINDU PANGOLATLEPCHA LETTER KALEPCHA LETTER KLALEPCHA" +
	" LETTER KHALEPCHA LETTER GALEPCHA LETTER GLALEPCHA LETTER NGALEPCHA LETT" +
	"ER CALEPCHA LETTER CHALEPCHA LETTER JALEPCHA LETTER NYALEPCHA LETTER TAL" +
	"EPCHA LETTER THALEPCHA LETTER DALEPCHA LETTER NALEPCHA LETTER PALEPCHA L" +
	"ETTER PLALEPCHA LETTER PHALEPCHA LETTER FALEPCHA LETTER FLALEPCHA LETTER" +
	" BALEPCHA LETTER BLALEPCHA LETTER MALEPCHA LETTER MLALEPCHA LETTER TSALE" +
	"PCHA LETTER TSHALEPCHA LETTER DZALEPCHA LETTER YALEPCHA LETTER RALEPCHA " +
	"LETTER LALEPCHA LETTER HALEPCHA LETTER HLALEPCHA LETTER VALEPCHA LETTER " +
	"SALEPCHA LETTER SHALEPCHA LETTER WALEPCHA LETTER ALEPCHA SUBJOINED LETTE" +
	"R YALEPCHA SUBJOINED LETTER RALEPCHA VOWEL SIGN AALEPCHA VOWEL SIGN ILEP" +
	"CHA VOWEL SIGN OLEPCHA VOWEL SIGN OOLEPCHA VOWEL SIGN ULEPCHA VOWEL SIGN" +
	" UULEPCHA VOWEL SIGN ELEPCHA CONSONANT SIGN KLEPCHA CONSONANT SIGN MLEPC" +
	"HA CONSONANT SIGN LLEPCHA CONSONANT SIGN NLEPCHA CONSONANT SIGN PLEPCHA " +
	"CONSONANT SIGN RLEPCHA CONSONANT SIGN TLEPCHA CONSONANT SIGN NYIN-DOLEPC" +
	"HA CONSONANT SIGN KANGLEPCHA SIGN RANLEPCHA SIGN NUKTALEPCHA PUNCTUATION" +
	" TA-ROLLEPCHA PUNCTUATION NYET THYOOM TA-ROLLEPCHA PUNCTUATION CER-WALEP" +
	"CHA PUNCTUATION TSHOOK CER-WALEPCHA PUNCTUATION TSHOOKLEPCHA DIGIT ZEROL" +
	"EPCHA DIGIT ONELEPCHA DIGIT TWOLEPCHA DIGIT THREELEPCHA DIGIT FOURLEPCHA" +
	" DIGIT FIVELEPCHA DIGIT SIXLEPCHA DIGIT SEVENLEPCHA DIGIT EIGHTLEPCHA DI" +
	"GIT NINELEPCHA LETTER TTALEPCHA LETTER TTHALEPCHA LETTER DDAOL CHIKI DIG" +
	"IT ZEROOL CHIKI DIGIT ONEOL CHIKI DIGIT TWOOL CHIKI DIGIT THREEOL CHIKI " +
	"DIGIT FOUROL CHIKI DIGIT FIVEOL CHIKI DIGIT SIXOL CHIKI DIGIT SEVENOL CH" +
	"IKI DIGIT EIGHTOL CHIKI DIGIT NINEOL CHIKI LETTER LAOL CHIKI LETTER ATOL" +
	" CHIKI LETTER AGOL CHIKI LETTER ANGOL CHIKI LETTER ALOL CHIKI LETTER LAA" +
	"OL CHIKI LETTER AAKOL CHIKI LETTER AAJOL CHIKI LETTER AAMOL CHIKI LETTER" +
	" AAWOL CHIKI LETTER LIOL CHIKI LETTER ISOL CHIKI LETTER IHOL CHIKI LETTE" +
	"R INYOL CHIKI LETTER IROL CHIKI LETTER LUOL CHIKI LETTER UCOL CHIKI LETT" +
	"ER UDOL CHIKI LETTER UNNOL CHIKI LETTER UYOL CHIKI LETTER LEOL CHIKI LET" +
	"TER EPOL CHIKI LETTER EDDOL CHIKI LETTER ENOL CHIKI LETTER ERROL CHIKI L" +
	"ETTER LOOL CHIKI LETTER OTTOL CHIKI LETTER OBOL CHIKI LETTER OVOL CHIKI " +
	"LETTER OHOL CHIKI MU TTUDDAGOL CHIKI GAAHLAA TTUDDAAGOL CHIKI MU-GAAHLAA" +
	" TTUDDAAGOL CHIKI RELAAOL CHIKI PHAARKAAOL CHIKI AHADOL CHIKI PUNCTUATIO" +
	"N MUCAADOL CHIKI PUNCTUATION DOUBLE MUCAADCYRILLIC SMALL LETTER ROUNDED " +
	"VECYRILLIC SMALL LETTER LONG-LEGGED DECYRILLIC SMALL LETTER NARROW OCYRI" +
	"LLIC SMALL LETTER WIDE ESCYRILLIC SMALL LETTER TALL TECYRILLIC SMALL LET" +
	"TER THREE-LEGGED TECYRILLIC SMALL LETTER TALL HARD SIGNCYRILLIC SMALL LE" +
	"TTER TALL YATCYRILLIC SMALL LETTER UNBLENDED UKCYRILLIC CAPITAL LETTER T" +
	"JECYRILLIC SMALL LETTER TJEGEORGIAN MTAVRULI CAPITAL LETTER ANGEORGIAN M" +
	"TAVRULI CAPITAL LETTER BANGEORGIAN MTAVRULI CAPITAL LETTER GANGEORGIAN M" +
	"TAVRULI CAPITAL LETTER DONGEORGIAN MTAVRULI CAPITAL LETTER ENGEORGIAN MT" +
	"AVRULI CAPITAL LETTER VINGEORGIAN MTAVRULI CAPITAL LETTER ZENGEORGIAN MT" +
	"AVRULI CAPITAL LETTER TANGEORGIAN MTAVRULI CAPITAL LETTER INGEORGIAN MTA" +
	"VRULI CAPITAL LETTER KANGEORGIAN MTAVRULI CAPITAL LETTER LASGEORGIAN MTA" +
	"VRULI CAPITAL LETTER MANGEORGIAN MTAVRULI CAPITAL LETTER NARGEORGIAN MTA" +
	"VRULI CAPITAL LETTER ONGEORGIAN MTAVRULI CAPITAL LETTER PARGEORGIAN MTAV" +
	"RULI CAPITAL LETTER ZHARGEORGIAN MTAVRULI CAPITAL LETTER RAEGEORGIAN MTA") + ("" +
	"VRULI CAPITAL LETTER SANGEORGIAN MTAVRULI CAPITAL LETTER TARGEORGIAN MTA" +
	"VRULI CAPITAL LETTER UNGEORGIAN MTAVRULI CAPITAL LETTER PHARGEORGIAN MTA" +
	"VRULI CAPITAL LETTER KHARGEORGIAN MTAVRULI CAPITAL LETTER GHANGEORGIAN M" +
	"TAVRULI CAPITAL LETTER QARGEORGIAN MTAVRULI CAPITAL LETTER SHINGEORGIAN " +
	"MTAVRULI CAPITAL LETTER CHINGEORGIAN MTAVRULI CAPITAL LETTER CANGEORGIAN" +
	" MTAVRULI CAPITAL LETTER JILGEORGIAN MTAVRULI CAPITAL LETTER CILGEORGIAN" +
	" MTAVRULI CAPITAL LETTER CHARGEORGIAN MTAVRULI CAPITAL LETTER XANGEORGIA" +
	"N MTAVRULI CAPITAL LETTER JHANGEORGIAN MTAVRULI CAPITAL LETTER HAEGEORGI" +
	"AN MTAVRULI CAPITAL LETTER HEGEORGIAN MTAVRULI CAPITAL LETTER HIEGEORGIA" +
	"N MTAVRULI CAPITAL LETTER WEGEORGIAN MTAVRULI CAPITAL LETTER HARGEORGIAN" +
	" MTAVRULI CAPITAL LETTER HOEGEORGIAN MTAVRULI CAPITAL LETTER FIGEORGIAN " +
	"MTAVRULI CAPITAL LETTER YNGEORGIAN MTAVRULI CAPITAL LETTER ELIFIGEORGIAN" +
	" MTAVRULI CAPITAL LETTER TURNED GANGEORGIAN MTAVRULI CAPITAL LETTER AING" +
	"EORGIAN MTAVRULI CAPITAL LETTER AENGEORGIAN MTAVRULI CAPITAL LETTER HARD" +
	" SIGNGEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGNSUNDANESE PUNCTUATION B" +
	"INDU SURYASUNDANESE PUNCTUATION BINDU PANGLONGSUNDANESE PUNCTUATION BIND" +
	"U PURNAMASUNDANESE PUNCTUATION BINDU CAKRASUNDANESE PUNCTUATION BINDU LE" +
	"U SATANGASUNDANESE PUNCTUATION BINDU KA SATANGASUNDANESE PUNCTUATION BIN" +
	"DU DA SATANGASUNDANESE PUNCTUATION BINDU BA SATANGAVEDIC TONE KARSHANAVE" +
	"DIC TONE SHARAVEDIC TONE PRENKHAVEDIC SIGN NIHSHVASAVEDIC SIGN YAJURVEDI" +
	"C MIDLINE SVARITAVEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITAVED" +
	"IC TONE YAJURVEDIC INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC KATHAKA INDE" +
	"PENDENT SVARITAVEDIC TONE CANDRA BELOWVEDIC TONE YAJURVEDIC KATHAKA INDE" +
	"PENDENT SVARITA SCHROEDERVEDIC TONE DOUBLE SVARITAVEDIC TONE TRIPLE SVAR" +
	"ITAVEDIC TONE KATHAKA ANUDATTAVEDIC TONE DOT BELOWVEDIC TONE TWO DOTS BE" +
	"LOWVEDIC TONE THREE DOTS BELOWVEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT S" +
	"VARITAVEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITAVEDIC SIGN VISARGA SVAR" +
	"ITAVEDIC SIGN VISARGA UDATTAVEDIC SIGN REVERSED VISARGA UDATTAVEDIC SIGN" +
	" VISARGA ANUDATTAVEDIC SIGN REVERSED VISARGA ANUDATTAVEDIC SIGN VISARGA " +
	"UDATTA WITH TAILVEDIC SIGN VISARGA ANUDATTA WITH TAILVEDIC SIGN ANUSVARA" +
	" ANTARGOMUKHAVEDIC SIGN ANUSVARA BAHIRGOMUKHAVEDIC SIGN ANUSVARA VAMAGOM" +
	"UKHAVEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAILVEDIC SIGN TIRYAKVEDIC SIGN" +
	" HEXIFORM LONG ANUSVARAVEDIC SIGN LONG ANUSVARAVEDIC SIGN RTHANG LONG AN" +
	"USVARAVEDIC SIGN ANUSVARA UBHAYATO MUKHAVEDIC SIGN ARDHAVISARGAVEDIC SIG" +
	"N ROTATED ARDHAVISARGAVEDIC TONE CANDRA ABOVEVEDIC SIGN JIHVAMULIYAVEDIC" +
	" SIGN UPADHMANIYAVEDIC SIGN ATIKRAMAVEDIC TONE RING ABOVEVEDIC TONE DOUB" +
	"LE RING ABOVEVEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHALATIN LETTER SMALL C" +
	"APITAL ALATIN LETTER SMALL CAPITAL AELATIN SMALL LETTER TURNED AELATIN L" +
	"ETTER SMALL CAPITAL BARRED BLATIN LETTER SMALL CAPITAL CLATIN LETTER SMA" +
	"LL CAPITAL DLATIN LETTER SMALL CAPITAL ETHLATIN LETTER SMALL CAPITAL ELA" +
	"TIN SMALL LETTER TURNED OPEN ELATIN SMALL LETTER TURNED ILATIN LETTER SM" +
	"ALL CAPITAL JLATIN LETTER SMALL CAPITAL KLATIN LETTER SMALL CAPITAL L WI" +
	"TH STROKELATIN LETTER SMALL CAPITAL MLATIN LETTER SMALL CAPITAL REVERSED" +
	" NLATIN LETTER SMALL CAPITAL OLATIN LETTER SMALL CAPITAL OPEN OLATIN SMA" +
	"LL LETTER SIDEWAYS OLATIN SMALL LETTER SIDEWAYS OPEN OLATIN SMALL LETTER" +
	" SIDEWAYS O WITH STROKELATIN SMALL LETTER TURNED OELATIN LETTER SMALL CA" +
	"PITAL OULATIN SMALL LETTER TOP HALF OLATIN SMALL LETTER BOTTOM HALF OLAT" +
	"IN LETTER SMALL CAPITAL PLATIN LETTER SMALL CAPITAL REVERSED RLATIN LETT" +
	"ER SMALL CAPITAL TURNED RLATIN LETTER SMALL CAPITAL TLATIN LETTER SMALL " +
	"CAPITAL ULATIN SMALL LETTER SIDEWAYS ULATIN SMALL LETTER SIDEWAYS DIAERE" +
	"SIZED ULATIN SMALL LETTER SIDEWAYS TURNED MLATIN LETTER SMALL CAPITAL VL" +
	"ATIN LETTER SMALL CAPITAL WLATIN LETTER SMALL CAPITAL ZLATIN LETTER SMAL" +
	"L CAPITAL EZHLATIN LETTER VOICED LARYNGEAL SPIRANTLATIN LETTER AINGREEK " +
	"LETTER SMALL CAPITAL GAMMAGREEK LETTER SMALL CAPITAL LAMDAGREEK LETTER S" +
	"MALL CAPITAL PIGREEK LETTER SMALL CAPITAL RHOGREEK LETTER SMALL CAPITAL " +
	"PSICYRILLIC LETTER SMALL CAPITAL ELMODIFIER LETTER CAPITAL AMODIFIER LET" +
	"TER CAPITAL AEMODIFIER LETTER CAPITAL BMODIFIER LETTER CAPITAL BARRED BM" +
	"ODIFIER LETTER CAPITAL DMODIFIER LETTER CAPITAL EMODIFIER LETTER CAPITAL" +
	" REVERSED EMODIFIER LETTER CAPITAL GMODIFIER LETTER CAPITAL HMODIFIER LE" +
	"TTER CAPITAL IMODIFIER LETTER CAPITAL JMODIFIER LETTER CAPITAL KMODIFIER" +
	" LETTER CAPITAL LMODIFIER LETTER CAPITAL MMODIFIER LETTER CAPITAL NMODIF" +
	"IER LETTER CAPITAL REVERSED NMODIFIER LETTER CAPITAL OMODIFIER LETTER CA" +
	"PITAL OUMODIFIER LETTER CAPITAL PMODIFIER LETTER CAPITAL RMODIFIER LETTE" +
	"R CAPITAL TMODIFIER LETTER CAPITAL UMODIFIER LETTER CAPITAL WMODIFIER LE") + ("" +
	"TTER SMALL AMODIFIER LETTER SMALL TURNED AMODIFIER LETTER SMALL ALPHAMOD" +
	"IFIER LETTER SMALL TURNED AEMODIFIER LETTER SMALL BMODIFIER LETTER SMALL" +
	" DMODIFIER LETTER SMALL EMODIFIER LETTER SMALL SCHWAMODIFIER LETTER SMAL" +
	"L OPEN EMODIFIER LETTER SMALL TURNED OPEN EMODIFIER LETTER SMALL GMODIFI" +
	"ER LETTER SMALL TURNED IMODIFIER LETTER SMALL KMODIFIER LETTER SMALL MMO" +
	"DIFIER LETTER SMALL ENGMODIFIER LETTER SMALL OMODIFIER LETTER SMALL OPEN" +
	" OMODIFIER LETTER SMALL TOP HALF OMODIFIER LETTER SMALL BOTTOM HALF OMOD" +
	"IFIER LETTER SMALL PMODIFIER LETTER SMALL TMODIFIER LETTER SMALL UMODIFI" +
	"ER LETTER SMALL SIDEWAYS UMODIFIER LETTER SMALL TURNED MMODIFIER LETTER " +
	"SMALL VMODIFIER LETTER SMALL AINMODIFIER LETTER SMALL BETAMODIFIER LETTE" +
	"R SMALL GREEK GAMMAMODIFIER LETTER SMALL DELTAMODIFIER LETTER SMALL GREE" +
	"K PHIMODIFIER LETTER SMALL CHILATIN SUBSCRIPT SMALL LETTER ILATIN SUBSCR" +
	"IPT SMALL LETTER RLATIN SUBSCRIPT SMALL LETTER ULATIN SUBSCRIPT SMALL LE" +
	"TTER VGREEK SUBSCRIPT SMALL LETTER BETAGREEK SUBSCRIPT SMALL LETTER GAMM" +
	"AGREEK SUBSCRIPT SMALL LETTER RHOGREEK SUBSCRIPT SMALL LETTER PHIGREEK S" +
	"UBSCRIPT SMALL LETTER CHILATIN SMALL LETTER UELATIN SMALL LETTER B WITH " +
	"MIDDLE TILDELATIN SMALL LETTER D WITH MIDDLE TILDELATIN SMALL LETTER F W" +
	"ITH MIDDLE TILDELATIN SMALL LETTER M WITH MIDDLE TILDELATIN SMALL LETTER" +
	" N WITH MIDDLE TILDELATIN SMALL LETTER P WITH MIDDLE TILDELATIN SMALL LE" +
	"TTER R WITH MIDDLE TILDELATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TI" +
	"LDELATIN SMALL LETTER S WITH MIDDLE TILDELATIN SMALL LETTER T WITH MIDDL" +
	"E TILDELATIN SMALL LETTER Z WITH MIDDLE TILDELATIN SMALL LETTER TURNED G" +
	"MODIFIER LETTER CYRILLIC ENLATIN SMALL LETTER INSULAR GLATIN SMALL LETTE" +
	"R TH WITH STRIKETHROUGHLATIN SMALL CAPITAL LETTER I WITH STROKELATIN SMA" +
	"LL LETTER IOTA WITH STROKELATIN SMALL LETTER P WITH STROKELATIN SMALL CA" +
	"PITAL LETTER U WITH STROKELATIN SMALL LETTER UPSILON WITH STROKELATIN SM" +
	"ALL LETTER B WITH PALATAL HOOKLATIN SMALL LETTER D WITH PALATAL HOOKLATI" +
	"N SMALL LETTER F WITH PALATAL HOOKLATIN SMALL LETTER G WITH PALATAL HOOK" +
	"LATIN SMALL LETTER K WITH PALATAL HOOKLATIN SMALL LETTER L WITH PALATAL " +
	"HOOKLATIN SMALL LETTER M WITH PALATAL HOOKLATIN SMALL LETTER N WITH PALA" +
	"TAL HOOKLATIN SMALL LETTER P WITH PALATAL HOOKLATIN SMALL LETTER R WITH " +
	"PALATAL HOOKLATIN SMALL LETTER S WITH PALATAL HOOKLATIN SMALL LETTER ESH" +
	" WITH PALATAL HOOKLATIN SMALL LETTER V WITH PALATAL HOOKLATIN SMALL LETT" +
	"ER X WITH PALATAL HOOKLATIN SMALL LETTER Z WITH PALATAL HOOKLATIN SMALL " +
	"LETTER A WITH RETROFLEX HOOKLATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK" +
	"LATIN SMALL LETTER D WITH HOOK AND TAILLATIN SMALL LETTER E WITH RETROFL" +
	"EX HOOKLATIN SMALL LETTER OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER R" +
	"EVERSED OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER SCHWA WITH RETROFLE" +
	"X HOOKLATIN SMALL LETTER I WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN O " +
	"WITH RETROFLEX HOOKLATIN SMALL LETTER ESH WITH RETROFLEX HOOKLATIN SMALL" +
	" LETTER U WITH RETROFLEX HOOKLATIN SMALL LETTER EZH WITH RETROFLEX HOOKM" +
	"ODIFIER LETTER SMALL TURNED ALPHAMODIFIER LETTER SMALL CMODIFIER LETTER " +
	"SMALL C WITH CURLMODIFIER LETTER SMALL ETHMODIFIER LETTER SMALL REVERSED" +
	" OPEN EMODIFIER LETTER SMALL FMODIFIER LETTER SMALL DOTLESS J WITH STROK" +
	"EMODIFIER LETTER SMALL SCRIPT GMODIFIER LETTER SMALL TURNED HMODIFIER LE" +
	"TTER SMALL I WITH STROKEMODIFIER LETTER SMALL IOTAMODIFIER LETTER SMALL " +
	"CAPITAL IMODIFIER LETTER SMALL CAPITAL I WITH STROKEMODIFIER LETTER SMAL" +
	"L J WITH CROSSED-TAILMODIFIER LETTER SMALL L WITH RETROFLEX HOOKMODIFIER" +
	" LETTER SMALL L WITH PALATAL HOOKMODIFIER LETTER SMALL CAPITAL LMODIFIER" +
	" LETTER SMALL M WITH HOOKMODIFIER LETTER SMALL TURNED M WITH LONG LEGMOD" +
	"IFIER LETTER SMALL N WITH LEFT HOOKMODIFIER LETTER SMALL N WITH RETROFLE" +
	"X HOOKMODIFIER LETTER SMALL CAPITAL NMODIFIER LETTER SMALL BARRED OMODIF" +
	"IER LETTER SMALL PHIMODIFIER LETTER SMALL S WITH HOOKMODIFIER LETTER SMA" +
	"LL ESHMODIFIER LETTER SMALL T WITH PALATAL HOOKMODIFIER LETTER SMALL U B" +
	"ARMODIFIER LETTER SMALL UPSILONMODIFIER LETTER SMALL CAPITAL UMODIFIER L" +
	"ETTER SMALL V WITH HOOKMODIFIER LETTER SMALL TURNED VMODIFIER LETTER SMA" +
	"LL ZMODIFIER LETTER SMALL Z WITH RETROFLEX HOOKMODIFIER LETTER SMALL Z W" +
	"ITH CURLMODIFIER LETTER SMALL EZHMODIFIER LETTER SMALL THETACOMBINING DO" +
	"TTED GRAVE ACCENTCOMBINING DOTTED ACUTE ACCENTCOMBINING SNAKE BELOWCOMBI" +
	"NING SUSPENSION MARKCOMBINING MACRON-ACUTECOMBINING GRAVE-MACRONCOMBININ" +
	"G MACRON-GRAVECOMBINING ACUTE-MACRONCOMBINING GRAVE-ACUTE-GRAVECOMBINING" +
	" ACUTE-GRAVE-ACUTECOMBINING LATIN SMALL LETTER R BELOWCOMBINING BREVE-MA" +
	"CRONCOMBINING MACRON-BREVECOMBINING DOUBLE CIRCUMFLEX ABOVECOMBINING OGO" +
	"NEK ABOVECOMBINING ZIGZAG BELOWCOMBINING IS BELOWCOMBINING UR ABOVECOMBI") + ("" +
	"NING US ABOVECOMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVECOMBININ" +
	"G LATIN SMALL LETTER AECOMBINING LATIN SMALL LETTER AOCOMBINING LATIN SM" +
	"ALL LETTER AVCOMBINING LATIN SMALL LETTER C CEDILLACOMBINING LATIN SMALL" +
	" LETTER INSULAR DCOMBINING LATIN SMALL LETTER ETHCOMBINING LATIN SMALL L" +
	"ETTER GCOMBINING LATIN LETTER SMALL CAPITAL GCOMBINING LATIN SMALL LETTE" +
	"R KCOMBINING LATIN SMALL LETTER LCOMBINING LATIN LETTER SMALL CAPITAL LC" +
	"OMBINING LATIN LETTER SMALL CAPITAL MCOMBINING LATIN SMALL LETTER NCOMBI" +
	"NING LATIN LETTER SMALL CAPITAL NCOMBINING LATIN LETTER SMALL CAPITAL RC" +
	"OMBINING LATIN SMALL LETTER R ROTUNDACOMBINING LATIN SMALL LETTER SCOMBI" +
	"NING LATIN SMALL LETTER LONG SCOMBINING LATIN SMALL LETTER ZCOMBINING LA" +
	"TIN SMALL LETTER ALPHACOMBINING LATIN SMALL LETTER BCOMBINING LATIN SMAL" +
	"L LETTER BETACOMBINING LATIN SMALL LETTER SCHWACOMBINING LATIN SMALL LET" +
	"TER FCOMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDECOMBINING LA" +
	"TIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL" +
	" LETTER PCOMBINING LATIN SMALL LETTER ESHCOMBINING LATIN SMALL LETTER U " +
	"WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL LETTER WCOMBINING " +
	"LATIN SMALL LETTER A WITH DIAERESISCOMBINING LATIN SMALL LETTER O WITH D" +
	"IAERESISCOMBINING LATIN SMALL LETTER U WITH DIAERESISCOMBINING UP TACK A" +
	"BOVECOMBINING KAVYKA ABOVE RIGHTCOMBINING KAVYKA ABOVE LEFTCOMBINING DOT" +
	" ABOVE LEFTCOMBINING WIDE INVERTED BRIDGE BELOWCOMBINING DOT BELOW LEFTC" +
	"OMBINING DELETION MARKCOMBINING DOUBLE INVERTED BREVE BELOWCOMBINING ALM" +
	"OST EQUAL TO BELOWCOMBINING LEFT ARROWHEAD ABOVECOMBINING RIGHT ARROWHEA" +
	"D AND DOWN ARROWHEAD BELOWLATIN CAPITAL LETTER A WITH RING BELOWLATIN SM" +
	"ALL LETTER A WITH RING BELOWLATIN CAPITAL LETTER B WITH DOT ABOVELATIN S" +
	"MALL LETTER B WITH DOT ABOVELATIN CAPITAL LETTER B WITH DOT BELOWLATIN S" +
	"MALL LETTER B WITH DOT BELOWLATIN CAPITAL LETTER B WITH LINE BELOWLATIN " +
	"SMALL LETTER B WITH LINE BELOWLATIN CAPITAL LETTER C WITH CEDILLA AND AC" +
	"UTELATIN SMALL LETTER C WITH CEDILLA AND ACUTELATIN CAPITAL LETTER D WIT" +
	"H DOT ABOVELATIN SMALL LETTER D WITH DOT ABOVELATIN CAPITAL LETTER D WIT" +
	"H DOT BELOWLATIN SMALL LETTER D WITH DOT BELOWLATIN CAPITAL LETTER D WIT" +
	"H LINE BELOWLATIN SMALL LETTER D WITH LINE BELOWLATIN CAPITAL LETTER D W" +
	"ITH CEDILLALATIN SMALL LETTER D WITH CEDILLALATIN CAPITAL LETTER D WITH " +
	"CIRCUMFLEX BELOWLATIN SMALL LETTER D WITH CIRCUMFLEX BELOWLATIN CAPITAL " +
	"LETTER E WITH MACRON AND GRAVELATIN SMALL LETTER E WITH MACRON AND GRAVE" +
	"LATIN CAPITAL LETTER E WITH MACRON AND ACUTELATIN SMALL LETTER E WITH MA" +
	"CRON AND ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOWLATIN SMALL LE" +
	"TTER E WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH TILDE BELOWLATIN" +
	" SMALL LETTER E WITH TILDE BELOWLATIN CAPITAL LETTER E WITH CEDILLA AND " +
	"BREVELATIN SMALL LETTER E WITH CEDILLA AND BREVELATIN CAPITAL LETTER F W" +
	"ITH DOT ABOVELATIN SMALL LETTER F WITH DOT ABOVELATIN CAPITAL LETTER G W" +
	"ITH MACRONLATIN SMALL LETTER G WITH MACRONLATIN CAPITAL LETTER H WITH DO" +
	"T ABOVELATIN SMALL LETTER H WITH DOT ABOVELATIN CAPITAL LETTER H WITH DO" +
	"T BELOWLATIN SMALL LETTER H WITH DOT BELOWLATIN CAPITAL LETTER H WITH DI" +
	"AERESISLATIN SMALL LETTER H WITH DIAERESISLATIN CAPITAL LETTER H WITH CE" +
	"DILLALATIN SMALL LETTER H WITH CEDILLALATIN CAPITAL LETTER H WITH BREVE " +
	"BELOWLATIN SMALL LETTER H WITH BREVE BELOWLATIN CAPITAL LETTER I WITH TI" +
	"LDE BELOWLATIN SMALL LETTER I WITH TILDE BELOWLATIN CAPITAL LETTER I WIT" +
	"H DIAERESIS AND ACUTELATIN SMALL LETTER I WITH DIAERESIS AND ACUTELATIN " +
	"CAPITAL LETTER K WITH ACUTELATIN SMALL LETTER K WITH ACUTELATIN CAPITAL " +
	"LETTER K WITH DOT BELOWLATIN SMALL LETTER K WITH DOT BELOWLATIN CAPITAL " +
	"LETTER K WITH LINE BELOWLATIN SMALL LETTER K WITH LINE BELOWLATIN CAPITA" +
	"L LETTER L WITH DOT BELOWLATIN SMALL LETTER L WITH DOT BELOWLATIN CAPITA" +
	"L LETTER L WITH DOT BELOW AND MACRONLATIN SMALL LETTER L WITH DOT BELOW " +
	"AND MACRONLATIN CAPITAL LETTER L WITH LINE BELOWLATIN SMALL LETTER L WIT" +
	"H LINE BELOWLATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOWLATIN SMALL LETT" +
	"ER L WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER M WITH ACUTELATIN SMALL L" +
	"ETTER M WITH ACUTELATIN CAPITAL LETTER M WITH DOT ABOVELATIN SMALL LETTE" +
	"R M WITH DOT ABOVELATIN CAPITAL LETTER M WITH DOT BELOWLATIN SMALL LETTE" +
	"R M WITH DOT BELOWLATIN CAPITAL LETTER N WITH DOT ABOVELATIN SMALL LETTE" +
	"R N WITH DOT ABOVELATIN CAPITAL LETTER N WITH DOT BELOWLATIN SMALL LETTE" +
	"R N WITH DOT BELOWLATIN CAPITAL LETTER N WITH LINE BELOWLATIN SMALL LETT" +
	"ER N WITH LINE BELOWLATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOWLATIN SM" +
	"ALL LETTER N WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER O WITH TILDE AND " +
	"ACUTELATIN SMALL LETTER O WITH TILDE AND ACUTELATIN CAPITAL LETTER O WIT") + ("" +
	"H TILDE AND DIAERESISLATIN SMALL LETTER O WITH TILDE AND DIAERESISLATIN " +
	"CAPITAL LETTER O WITH MACRON AND GRAVELATIN SMALL LETTER O WITH MACRON A" +
	"ND GRAVELATIN CAPITAL LETTER O WITH MACRON AND ACUTELATIN SMALL LETTER O" +
	" WITH MACRON AND ACUTELATIN CAPITAL LETTER P WITH ACUTELATIN SMALL LETTE" +
	"R P WITH ACUTELATIN CAPITAL LETTER P WITH DOT ABOVELATIN SMALL LETTER P " +
	"WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT ABOVELATIN SMALL LETTER R " +
	"WITH DOT ABOVELATIN CAPITAL LETTER R WITH DOT BELOWLATIN SMALL LETTER R " +
	"WITH DOT BELOWLATIN CAPITAL LETTER R WITH DOT BELOW AND MACRONLATIN SMAL" +
	"L LETTER R WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER R WITH LINE BEL" +
	"OWLATIN SMALL LETTER R WITH LINE BELOWLATIN CAPITAL LETTER S WITH DOT AB" +
	"OVELATIN SMALL LETTER S WITH DOT ABOVELATIN CAPITAL LETTER S WITH DOT BE" +
	"LOWLATIN SMALL LETTER S WITH DOT BELOWLATIN CAPITAL LETTER S WITH ACUTE " +
	"AND DOT ABOVELATIN SMALL LETTER S WITH ACUTE AND DOT ABOVELATIN CAPITAL " +
	"LETTER S WITH CARON AND DOT ABOVELATIN SMALL LETTER S WITH CARON AND DOT" +
	" ABOVELATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVELATIN SMALL LET" +
	"TER S WITH DOT BELOW AND DOT ABOVELATIN CAPITAL LETTER T WITH DOT ABOVEL" +
	"ATIN SMALL LETTER T WITH DOT ABOVELATIN CAPITAL LETTER T WITH DOT BELOWL" +
	"ATIN SMALL LETTER T WITH DOT BELOWLATIN CAPITAL LETTER T WITH LINE BELOW" +
	"LATIN SMALL LETTER T WITH LINE BELOWLATIN CAPITAL LETTER T WITH CIRCUMFL" +
	"EX BELOWLATIN SMALL LETTER T WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U" +
	" WITH DIAERESIS BELOWLATIN SMALL LETTER U WITH DIAERESIS BELOWLATIN CAPI" +
	"TAL LETTER U WITH TILDE BELOWLATIN SMALL LETTER U WITH TILDE BELOWLATIN " +
	"CAPITAL LETTER U WITH CIRCUMFLEX BELOWLATIN SMALL LETTER U WITH CIRCUMFL" +
	"EX BELOWLATIN CAPITAL LETTER U WITH TILDE AND ACUTELATIN SMALL LETTER U " +
	"WITH TILDE AND ACUTELATIN CAPITAL LETTER U WITH MACRON AND DIAERESISLATI" +
	"N SMALL LETTER U WITH MACRON AND DIAERESISLATIN CAPITAL LETTER V WITH TI" +
	"LDELATIN SMALL LETTER V WITH TILDELATIN CAPITAL LETTER V WITH DOT BELOWL" +
	"ATIN SMALL LETTER V WITH DOT BELOWLATIN CAPITAL LETTER W WITH GRAVELATIN" +
	" SMALL LETTER W WITH GRAVELATIN CAPITAL LETTER W WITH ACUTELATIN SMALL L" +
	"ETTER W WITH ACUTELATIN CAPITAL LETTER W WITH DIAERESISLATIN SMALL LETTE" +
	"R W WITH DIAERESISLATIN CAPITAL LETTER W WITH DOT ABOVELATIN SMALL LETTE" +
	"R W WITH DOT ABOVELATIN CAPITAL LETTER W WITH DOT BELOWLATIN SMALL LETTE" +
	"R W WITH DOT BELOWLATIN CAPITAL LETTER X WITH DOT ABOVELATIN SMALL LETTE" +
	"R X WITH DOT ABOVELATIN CAPITAL LETTER X WITH DIAERESISLATIN SMALL LETTE" +
	"R X WITH DIAERESISLATIN CAPITAL LETTER Y WITH DOT ABOVELATIN SMALL LETTE" +
	"R Y WITH DOT ABOVELATIN CAPITAL LETTER Z WITH CIRCUMFLEXLATIN SMALL LETT" +
	"ER Z WITH CIRCUMFLEXLATIN CAPITAL LETTER Z WITH DOT BELOWLATIN SMALL LET" +
	"TER Z WITH DOT BELOWLATIN CAPITAL LETTER Z WITH LINE BELOWLATIN SMALL LE" +
	"TTER Z WITH LINE BELOWLATIN SMALL LETTER H WITH LINE BELOWLATIN SMALL LE" +
	"TTER T WITH DIAERESISLATIN SMALL LETTER W WITH RING ABOVELATIN SMALL LET" +
	"TER Y WITH RING ABOVELATIN SMALL LETTER A WITH RIGHT HALF RINGLATIN SMAL" +
	"L LETTER LONG S WITH DOT ABOVELATIN SMALL LETTER LONG S WITH DIAGONAL ST" +
	"ROKELATIN SMALL LETTER LONG S WITH HIGH STROKELATIN CAPITAL LETTER SHARP" +
	" SLATIN SMALL LETTER DELTALATIN CAPITAL LETTER A WITH DOT BELOWLATIN SMA" +
	"LL LETTER A WITH DOT BELOWLATIN CAPITAL LETTER A WITH HOOK ABOVELATIN SM" +
	"ALL LETTER A WITH HOOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND A" +
	"CUTELATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER A" +
	" WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE" +
	"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER " +
	"A WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX A" +
	"ND TILDELATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETT" +
	"ER A WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER A WITH CIRCUMFLEX A" +
	"ND DOT BELOWLATIN CAPITAL LETTER A WITH BREVE AND ACUTELATIN SMALL LETTE" +
	"R A WITH BREVE AND ACUTELATIN CAPITAL LETTER A WITH BREVE AND GRAVELATIN" +
	" SMALL LETTER A WITH BREVE AND GRAVELATIN CAPITAL LETTER A WITH BREVE AN" +
	"D HOOK ABOVELATIN SMALL LETTER A WITH BREVE AND HOOK ABOVELATIN CAPITAL " +
	"LETTER A WITH BREVE AND TILDELATIN SMALL LETTER A WITH BREVE AND TILDELA" +
	"TIN CAPITAL LETTER A WITH BREVE AND DOT BELOWLATIN SMALL LETTER A WITH B" +
	"REVE AND DOT BELOWLATIN CAPITAL LETTER E WITH DOT BELOWLATIN SMALL LETTE" +
	"R E WITH DOT BELOWLATIN CAPITAL LETTER E WITH HOOK ABOVELATIN SMALL LETT" +
	"ER E WITH HOOK ABOVELATIN CAPITAL LETTER E WITH TILDELATIN SMALL LETTER " +
	"E WITH TILDELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTELATIN SMALL " +
	"LETTER E WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEX" +
	" AND GRAVELATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LE") + ("" +
	"TTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER E WITH CIRCUMFLE" +
	"X AND HOOK ABOVELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDELATIN SM" +
	"ALL LETTER E WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER E WITH CIRCUM" +
	"FLEX AND DOT BELOWLATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATI" +
	"N CAPITAL LETTER I WITH HOOK ABOVELATIN SMALL LETTER I WITH HOOK ABOVELA" +
	"TIN CAPITAL LETTER I WITH DOT BELOWLATIN SMALL LETTER I WITH DOT BELOWLA" +
	"TIN CAPITAL LETTER O WITH DOT BELOWLATIN SMALL LETTER O WITH DOT BELOWLA" +
	"TIN CAPITAL LETTER O WITH HOOK ABOVELATIN SMALL LETTER O WITH HOOK ABOVE" +
	"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER O WIT" +
	"H CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVELA" +
	"TIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER O WITH " +
	"CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK A" +
	"BOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER O" +
	" WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT" +
	" BELOWLATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LE" +
	"TTER O WITH HORN AND ACUTELATIN SMALL LETTER O WITH HORN AND ACUTELATIN " +
	"CAPITAL LETTER O WITH HORN AND GRAVELATIN SMALL LETTER O WITH HORN AND G" +
	"RAVELATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVELATIN SMALL LETTER O " +
	"WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER O WITH HORN AND TILDELATIN " +
	"SMALL LETTER O WITH HORN AND TILDELATIN CAPITAL LETTER O WITH HORN AND D" +
	"OT BELOWLATIN SMALL LETTER O WITH HORN AND DOT BELOWLATIN CAPITAL LETTER" +
	" U WITH DOT BELOWLATIN SMALL LETTER U WITH DOT BELOWLATIN CAPITAL LETTER" +
	" U WITH HOOK ABOVELATIN SMALL LETTER U WITH HOOK ABOVELATIN CAPITAL LETT" +
	"ER U WITH HORN AND ACUTELATIN SMALL LETTER U WITH HORN AND ACUTELATIN CA" +
	"PITAL LETTER U WITH HORN AND GRAVELATIN SMALL LETTER U WITH HORN AND GRA" +
	"VELATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVELATIN SMALL LETTER U WI" +
	"TH HORN AND HOOK ABOVELATIN CAPITAL LETTER U WITH HORN AND TILDELATIN SM" +
	"ALL LETTER U WITH HORN AND TILDELATIN CAPITAL LETTER U WITH HORN AND DOT" +
	" BELOWLATIN SMALL LETTER U WITH HORN AND DOT BELOWLATIN CAPITAL LETTER Y" +
	" WITH GRAVELATIN SMALL LETTER Y WITH GRAVELATIN CAPITAL LETTER Y WITH DO" +
	"T BELOWLATIN SMALL LETTER Y WITH DOT BELOWLATIN CAPITAL LETTER Y WITH HO" +
	"OK ABOVELATIN SMALL LETTER Y WITH HOOK ABOVELATIN CAPITAL LETTER Y WITH " +
	"TILDELATIN SMALL LETTER Y WITH TILDELATIN CAPITAL LETTER MIDDLE-WELSH LL" +
	"LATIN SMALL LETTER MIDDLE-WELSH LLLATIN CAPITAL LETTER MIDDLE-WELSH VLAT" +
	"IN SMALL LETTER MIDDLE-WELSH VLATIN CAPITAL LETTER Y WITH LOOPLATIN SMAL" +
	"L LETTER Y WITH LOOPGREEK SMALL LETTER ALPHA WITH PSILIGREEK SMALL LETTE" +
	"R ALPHA WITH DASIAGREEK SMALL LETTER ALPHA WITH PSILI AND VARIAGREEK SMA" +
	"LL LETTER ALPHA WITH DASIA AND VARIAGREEK SMALL LETTER ALPHA WITH PSILI " +
	"AND OXIAGREEK SMALL LETTER ALPHA WITH DASIA AND OXIAGREEK SMALL LETTER A" +
	"LPHA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER ALPHA WITH DASIA AND P" +
	"ERISPOMENIGREEK CAPITAL LETTER ALPHA WITH PSILIGREEK CAPITAL LETTER ALPH" +
	"A WITH DASIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIAGREEK CAPITAL" +
	" LETTER ALPHA WITH DASIA AND VARIAGREEK CAPITAL LETTER ALPHA WITH PSILI " +
	"AND OXIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIAGREEK CAPITAL LETT" +
	"ER ALPHA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH DASIA" +
	" AND PERISPOMENIGREEK SMALL LETTER EPSILON WITH PSILIGREEK SMALL LETTER " +
	"EPSILON WITH DASIAGREEK SMALL LETTER EPSILON WITH PSILI AND VARIAGREEK S" +
	"MALL LETTER EPSILON WITH DASIA AND VARIAGREEK SMALL LETTER EPSILON WITH " +
	"PSILI AND OXIAGREEK SMALL LETTER EPSILON WITH DASIA AND OXIAGREEK CAPITA" +
	"L LETTER EPSILON WITH PSILIGREEK CAPITAL LETTER EPSILON WITH DASIAGREEK " +
	"CAPITAL LETTER EPSILON WITH PSILI AND VARIAGREEK CAPITAL LETTER EPSILON " +
	"WITH DASIA AND VARIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIAGREE" +
	"K CAPITAL LETTER EPSILON WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH " +
	"PSILIGREEK SMALL LETTER ETA WITH DASIAGREEK SMALL LETTER ETA WITH PSILI " +
	"AND VARIAGREEK SMALL LETTER ETA WITH DASIA AND VARIAGREEK SMALL LETTER E" +
	"TA WITH PSILI AND OXIAGREEK SMALL LETTER ETA WITH DASIA AND OXIAGREEK SM" +
	"ALL LETTER ETA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER ETA WITH DAS" +
	"IA AND PERISPOMENIGREEK CAPITAL LETTER ETA WITH PSILIGREEK CAPITAL LETTE" +
	"R ETA WITH DASIAGREEK CAPITAL LETTER ETA WITH PSILI AND VARIAGREEK CAPIT" +
	"AL LETTER ETA WITH DASIA AND VARIAGREEK CAPITAL LETTER ETA WITH PSILI AN" +
	"D OXIAGREEK CAPITAL LETTER ETA WITH DASIA AND OXIAGREEK CAPITAL LETTER E" +
	"TA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PER" +
	"ISPOMENIGREEK SMALL LETTER IOTA WITH PSILIGREEK SMALL LETTER IOTA WITH D" +
	"ASIAGREEK SMALL LETTER IOTA WITH PSILI AND VARIAGREEK SMALL LETTER IOTA ") + ("" +
	"WITH DASIA AND VARIAGREEK SMALL LETTER IOTA WITH PSILI AND OXIAGREEK SMA" +
	"LL LETTER IOTA WITH DASIA AND OXIAGREEK SMALL LETTER IOTA WITH PSILI AND" +
	" PERISPOMENIGREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK CAPI" +
	"TAL LETTER IOTA WITH PSILIGREEK CAPITAL LETTER IOTA WITH DASIAGREEK CAPI" +
	"TAL LETTER IOTA WITH PSILI AND VARIAGREEK CAPITAL LETTER IOTA WITH DASIA" +
	" AND VARIAGREEK CAPITAL LETTER IOTA WITH PSILI AND OXIAGREEK CAPITAL LET" +
	"TER IOTA WITH DASIA AND OXIAGREEK CAPITAL LETTER IOTA WITH PSILI AND PER" +
	"ISPOMENIGREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK SMALL " +
	"LETTER OMICRON WITH PSILIGREEK SMALL LETTER OMICRON WITH DASIAGREEK SMAL" +
	"L LETTER OMICRON WITH PSILI AND VARIAGREEK SMALL LETTER OMICRON WITH DAS" +
	"IA AND VARIAGREEK SMALL LETTER OMICRON WITH PSILI AND OXIAGREEK SMALL LE" +
	"TTER OMICRON WITH DASIA AND OXIAGREEK CAPITAL LETTER OMICRON WITH PSILIG" +
	"REEK CAPITAL LETTER OMICRON WITH DASIAGREEK CAPITAL LETTER OMICRON WITH " +
	"PSILI AND VARIAGREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIAGREEK CA" +
	"PITAL LETTER OMICRON WITH PSILI AND OXIAGREEK CAPITAL LETTER OMICRON WIT" +
	"H DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH PSILIGREEK SMALL LETTER " +
	"UPSILON WITH DASIAGREEK SMALL LETTER UPSILON WITH PSILI AND VARIAGREEK S" +
	"MALL LETTER UPSILON WITH DASIA AND VARIAGREEK SMALL LETTER UPSILON WITH " +
	"PSILI AND OXIAGREEK SMALL LETTER UPSILON WITH DASIA AND OXIAGREEK SMALL " +
	"LETTER UPSILON WITH PSILI AND PERISPOMENIGREEK SMALL LETTER UPSILON WITH" +
	" DASIA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH DASIAGREEK CAPIT" +
	"AL LETTER UPSILON WITH DASIA AND VARIAGREEK CAPITAL LETTER UPSILON WITH " +
	"DASIA AND OXIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENIGRE" +
	"EK SMALL LETTER OMEGA WITH PSILIGREEK SMALL LETTER OMEGA WITH DASIAGREEK" +
	" SMALL LETTER OMEGA WITH PSILI AND VARIAGREEK SMALL LETTER OMEGA WITH DA" +
	"SIA AND VARIAGREEK SMALL LETTER OMEGA WITH PSILI AND OXIAGREEK SMALL LET" +
	"TER OMEGA WITH DASIA AND OXIAGREEK SMALL LETTER OMEGA WITH PSILI AND PER" +
	"ISPOMENIGREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK CAPITAL" +
	" LETTER OMEGA WITH PSILIGREEK CAPITAL LETTER OMEGA WITH DASIAGREEK CAPIT" +
	"AL LETTER OMEGA WITH PSILI AND VARIAGREEK CAPITAL LETTER OMEGA WITH DASI" +
	"A AND VARIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIAGREEK CAPITAL L" +
	"ETTER OMEGA WITH DASIA AND OXIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND" +
	" PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK S" +
	"MALL LETTER ALPHA WITH VARIAGREEK SMALL LETTER ALPHA WITH OXIAGREEK SMAL" +
	"L LETTER EPSILON WITH VARIAGREEK SMALL LETTER EPSILON WITH OXIAGREEK SMA" +
	"LL LETTER ETA WITH VARIAGREEK SMALL LETTER ETA WITH OXIAGREEK SMALL LETT" +
	"ER IOTA WITH VARIAGREEK SMALL LETTER IOTA WITH OXIAGREEK SMALL LETTER OM" +
	"ICRON WITH VARIAGREEK SMALL LETTER OMICRON WITH OXIAGREEK SMALL LETTER U" +
	"PSILON WITH VARIAGREEK SMALL LETTER UPSILON WITH OXIAGREEK SMALL LETTER " +
	"OMEGA WITH VARIAGREEK SMALL LETTER OMEGA WITH OXIAGREEK SMALL LETTER ALP" +
	"HA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND Y" +
	"POGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMM" +
	"ENIGREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK " +
	"SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETT" +
	"ER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA W" +
	"ITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH" +
	" DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH " +
	"PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGE" +
	"GRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMME" +
	"NIGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREE" +
	"K CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPIT" +
	"AL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETT" +
	"ER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETT" +
	"ER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER" +
	" ETA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND Y" +
	"POGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMEN" +
	"IGREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMAL" +
	"L LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA" +
	" WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI " +
	"AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND P" +
	"ERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PROS" +
	"GEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENIGREEK CA" +
	"PITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LE" +
	"TTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA") + ("" +
	" WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DAS" +
	"IA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PE" +
	"RISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PERI" +
	"SPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEG" +
	"RAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL " +
	"LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OM" +
	"EGA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH " +
	"PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND " +
	"OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMEN" +
	"I AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI A" +
	"ND YPOGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI" +
	"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LE" +
	"TTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER O" +
	"MEGA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA W" +
	"ITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DAS" +
	"IA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND " +
	"PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND " +
	"PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER ALPHA WITH VRACHYGREEK " +
	"SMALL LETTER ALPHA WITH MACRONGREEK SMALL LETTER ALPHA WITH VARIA AND YP" +
	"OGEGRAMMENIGREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENIGREEK SMALL LETTER" +
	" ALPHA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PERISPOM" +
	"ENIGREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPI" +
	"TAL LETTER ALPHA WITH VRACHYGREEK CAPITAL LETTER ALPHA WITH MACRONGREEK " +
	"CAPITAL LETTER ALPHA WITH VARIAGREEK CAPITAL LETTER ALPHA WITH OXIAGREEK" +
	" CAPITAL LETTER ALPHA WITH PROSGEGRAMMENIGREEK KORONISGREEK PROSGEGRAMME" +
	"NIGREEK PSILIGREEK PERISPOMENIGREEK DIALYTIKA AND PERISPOMENIGREEK SMALL" +
	" LETTER ETA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH YPOG" +
	"EGRAMMENIGREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL L" +
	"ETTER ETA WITH PERISPOMENIGREEK SMALL LETTER ETA WITH PERISPOMENI AND YP" +
	"OGEGRAMMENIGREEK CAPITAL LETTER EPSILON WITH VARIAGREEK CAPITAL LETTER E" +
	"PSILON WITH OXIAGREEK CAPITAL LETTER ETA WITH VARIAGREEK CAPITAL LETTER " +
	"ETA WITH OXIAGREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENIGREEK PSILI AND" +
	" VARIAGREEK PSILI AND OXIAGREEK PSILI AND PERISPOMENIGREEK SMALL LETTER " +
	"IOTA WITH VRACHYGREEK SMALL LETTER IOTA WITH MACRONGREEK SMALL LETTER IO" +
	"TA WITH DIALYTIKA AND VARIAGREEK SMALL LETTER IOTA WITH DIALYTIKA AND OX" +
	"IAGREEK SMALL LETTER IOTA WITH PERISPOMENIGREEK SMALL LETTER IOTA WITH D" +
	"IALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH VRACHYGREEK CAPIT" +
	"AL LETTER IOTA WITH MACRONGREEK CAPITAL LETTER IOTA WITH VARIAGREEK CAPI" +
	"TAL LETTER IOTA WITH OXIAGREEK DASIA AND VARIAGREEK DASIA AND OXIAGREEK " +
	"DASIA AND PERISPOMENIGREEK SMALL LETTER UPSILON WITH VRACHYGREEK SMALL L" +
	"ETTER UPSILON WITH MACRONGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND V" +
	"ARIAGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIAGREEK SMALL LETTER" +
	" RHO WITH PSILIGREEK SMALL LETTER RHO WITH DASIAGREEK SMALL LETTER UPSIL" +
	"ON WITH PERISPOMENIGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPO" +
	"MENIGREEK CAPITAL LETTER UPSILON WITH VRACHYGREEK CAPITAL LETTER UPSILON" +
	" WITH MACRONGREEK CAPITAL LETTER UPSILON WITH VARIAGREEK CAPITAL LETTER " +
	"UPSILON WITH OXIAGREEK CAPITAL LETTER RHO WITH DASIAGREEK DIALYTIKA AND " +
	"VARIAGREEK DIALYTIKA AND OXIAGREEK VARIAGREEK SMALL LETTER OMEGA WITH VA" +
	"RIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENIGREEK SM" +
	"ALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WIT" +
	"H PERISPOMENIGREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI" +
	"GREEK CAPITAL LETTER OMICRON WITH VARIAGREEK CAPITAL LETTER OMICRON WITH" +
	" OXIAGREEK CAPITAL LETTER OMEGA WITH VARIAGREEK CAPITAL LETTER OMEGA WIT" +
	"H OXIAGREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENIGREEK OXIAGREEK DASI" +
	"AEN QUADEM QUADEN SPACEEM SPACETHREE-PER-EM SPACEFOUR-PER-EM SPACESIX-PE" +
	"R-EM SPACEFIGURE SPACEPUNCTUATION SPACETHIN SPACEHAIR SPACEZERO WIDTH SP" +
	"ACEZERO WIDTH NON-JOINERZERO WIDTH JOINERLEFT-TO-RIGHT MARKRIGHT-TO-LEFT" +
	" MARKHYPHENNON-BREAKING HYPHENFIGURE DASHEN DASHEM DASHHORIZONTAL BARDOU" +
	"BLE VERTICAL LINEDOUBLE LOW LINELEFT SINGLE QUOTATION MARKRIGHT SINGLE Q" +
	"UOTATION MARKSINGLE LOW-9 QUOTATION MARKSINGLE HIGH-REVERSED-9 QUOTATION" +
	" MARKLEFT DOUBLE QUOTATION MARKRIGHT DOUBLE QUOTATION MARKDOUBLE LOW-9 Q" +
	"UOTATION MARKDOUBLE HIGH-REVERSED-9 QUOTATION MARKDAGGERDOUBLE DAGGERBUL" +
	"LETTRIANGULAR BULLETONE DOT LEADERTWO DOT LEADERHORIZONTAL ELLIPSISHYPHE" +
	"NATION POINTLINE SEPARATORPARAGRAPH SEPARATORLEFT-TO-RIGHT EMBEDDINGRIGH") + ("" +
	"T-TO-LEFT EMBEDDINGPOP DIRECTIONAL FORMATTINGLEFT-TO-RIGHT OVERRIDERIGHT" +
	"-TO-LEFT OVERRIDENARROW NO-BREAK SPACEPER MILLE SIGNPER TEN THOUSAND SIG" +
	"NPRIMEDOUBLE PRIMETRIPLE PRIMEREVERSED PRIMEREVERSED DOUBLE PRIMEREVERSE" +
	"D TRIPLE PRIMECARETSINGLE LEFT-POINTING ANGLE QUOTATION MARKSINGLE RIGHT" +
	"-POINTING ANGLE QUOTATION MARKREFERENCE MARKDOUBLE EXCLAMATION MARKINTER" +
	"ROBANGOVERLINEUNDERTIECHARACTER TIECARET INSERTION POINTASTERISMHYPHEN B" +
	"ULLETFRACTION SLASHLEFT SQUARE BRACKET WITH QUILLRIGHT SQUARE BRACKET WI" +
	"TH QUILLDOUBLE QUESTION MARKQUESTION EXCLAMATION MARKEXCLAMATION QUESTIO" +
	"N MARKTIRONIAN SIGN ETREVERSED PILCROW SIGNBLACK LEFTWARDS BULLETBLACK R" +
	"IGHTWARDS BULLETLOW ASTERISKREVERSED SEMICOLONCLOSE UPTWO ASTERISKS ALIG" +
	"NED VERTICALLYCOMMERCIAL MINUS SIGNSWUNG DASHINVERTED UNDERTIEFLOWER PUN" +
	"CTUATION MARKTHREE DOT PUNCTUATIONQUADRUPLE PRIMEFOUR DOT PUNCTUATIONFIV" +
	"E DOT PUNCTUATIONTWO DOT PUNCTUATIONFOUR DOT MARKDOTTED CROSSTRICOLONVER" +
	"TICAL FOUR DOTSMEDIUM MATHEMATICAL SPACEWORD JOINERFUNCTION APPLICATIONI" +
	"NVISIBLE TIMESINVISIBLE SEPARATORINVISIBLE PLUSLEFT-TO-RIGHT ISOLATERIGH" +
	"T-TO-LEFT ISOLATEFIRST STRONG ISOLATEPOP DIRECTIONAL ISOLATEINHIBIT SYMM" +
	"ETRIC SWAPPINGACTIVATE SYMMETRIC SWAPPINGINHIBIT ARABIC FORM SHAPINGACTI" +
	"VATE ARABIC FORM SHAPINGNATIONAL DIGIT SHAPESNOMINAL DIGIT SHAPESSUPERSC" +
	"RIPT ZEROSUPERSCRIPT LATIN SMALL LETTER ISUPERSCRIPT FOURSUPERSCRIPT FIV" +
	"ESUPERSCRIPT SIXSUPERSCRIPT SEVENSUPERSCRIPT EIGHTSUPERSCRIPT NINESUPERS" +
	"CRIPT PLUS SIGNSUPERSCRIPT MINUSSUPERSCRIPT EQUALS SIGNSUPERSCRIPT LEFT " +
	"PARENTHESISSUPERSCRIPT RIGHT PARENTHESISSUPERSCRIPT LATIN SMALL LETTER N" +
	"SUBSCRIPT ZEROSUBSCRIPT ONESUBSCRIPT TWOSUBSCRIPT THREESUBSCRIPT FOURSUB" +
	"SCRIPT FIVESUBSCRIPT SIXSUBSCRIPT SEVENSUBSCRIPT EIGHTSUBSCRIPT NINESUBS" +
	"CRIPT PLUS SIGNSUBSCRIPT MINUSSUBSCRIPT EQUALS SIGNSUBSCRIPT LEFT PARENT" +
	"HESISSUBSCRIPT RIGHT PARENTHESISLATIN SUBSCRIPT SMALL LETTER ALATIN SUBS" +
	"CRIPT SMALL LETTER ELATIN SUBSCRIPT SMALL LETTER OLATIN SUBSCRIPT SMALL " +
	"LETTER XLATIN SUBSCRIPT SMALL LETTER SCHWALATIN SUBSCRIPT SMALL LETTER H" +
	"LATIN SUBSCRIPT SMALL LETTER KLATIN SUBSCRIPT SMALL LETTER LLATIN SUBSCR" +
	"IPT SMALL LETTER MLATIN SUBSCRIPT SMALL LETTER NLATIN SUBSCRIPT SMALL LE" +
	"TTER PLATIN SUBSCRIPT SMALL LETTER SLATIN SUBSCRIPT SMALL LETTER TEURO-C" +
	"URRENCY SIGNCOLON SIGNCRUZEIRO SIGNFRENCH FRANC SIGNLIRA SIGNMILL SIGNNA" +
	"IRA SIGNPESETA SIGNRUPEE SIGNWON SIGNNEW SHEQEL SIGNDONG SIGNEURO SIGNKI" +
	"P SIGNTUGRIK SIGNDRACHMA SIGNGERMAN PENNY SIGNPESO SIGNGUARANI SIGNAUSTR" +
	"AL SIGNHRYVNIA SIGNCEDI SIGNLIVRE TOURNOIS SIGNSPESMILO SIGNTENGE SIGNIN" +
	"DIAN RUPEE SIGNTURKISH LIRA SIGNNORDIC MARK SIGNMANAT SIGNRUBLE SIGNLARI" +
	" SIGNBITCOIN SIGNSOM SIGNSAUDI RIYAL SIGNCOMBINING LEFT HARPOON ABOVECOM" +
	"BINING RIGHT HARPOON ABOVECOMBINING LONG VERTICAL LINE OVERLAYCOMBINING " +
	"SHORT VERTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE ARROW ABOVECOMBINING " +
	"CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW ABOVECOMBINING RIGHT ARROW ABO" +
	"VECOMBINING RING OVERLAYCOMBINING CLOCKWISE RING OVERLAYCOMBINING ANTICL" +
	"OCKWISE RING OVERLAYCOMBINING THREE DOTS ABOVECOMBINING FOUR DOTS ABOVEC" +
	"OMBINING ENCLOSING CIRCLECOMBINING ENCLOSING SQUARECOMBINING ENCLOSING D" +
	"IAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHCOMBINING LEFT RIGHT ARROW ABO" +
	"VECOMBINING ENCLOSING SCREENCOMBINING ENCLOSING KEYCAPCOMBINING ENCLOSIN" +
	"G UPWARD POINTING TRIANGLECOMBINING REVERSE SOLIDUS OVERLAYCOMBINING DOU" +
	"BLE VERTICAL STROKE OVERLAYCOMBINING ANNUITY SYMBOLCOMBINING TRIPLE UNDE" +
	"RDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LEFTWARDS ARROW OVERLAYCOMBININ" +
	"G LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS HARPOON WITH BARB DOWN" +
	"WARDSCOMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDSCOMBINING LEFT ARROW" +
	" BELOWCOMBINING RIGHT ARROW BELOWCOMBINING ASTERISK ABOVEACCOUNT OFADDRE" +
	"SSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE CELSIUSCENTRE LINE SYMB" +
	"OLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRENHEITSCRIPT SMALL GSCR" +
	"IPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK CAPITAL HPLANCK CONSTAN" +
	"TPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-LETTER CAPITAL ISCRIPT" +
	" CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUCK CAPITAL NNUMERO SIGN" +
	"SOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-STRUCK CAPITAL PDOUBLE-S" +
	"TRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITAL RDOUBLE-STRUCK CAPIT" +
	"AL RPRESCRIPTION TAKERESPONSESERVICE MARKTELEPHONE SIGNTRADE MARK SIGNVE" +
	"RSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINVERTED OHM SIGNBLACK-LE" +
	"TTER CAPITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN SIGNANGSTROM SIGNSCRI" +
	"PT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED SYMBOLSCRIPT SMALL ESCRIPT C" +
	"APITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAPITAL MSCRIPT SMALL OAL" +
	"EF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMATION SOURCEROTATED CAP") + ("" +
	"ITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-STRUCK SMALL GAMMADOUBL" +
	"E-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUBLE-STRUCK N-ARY SUMMAT" +
	"IONTURNED SANS-SERIF CAPITAL GTURNED SANS-SERIF CAPITAL LREVERSED SANS-S" +
	"ERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-STRUCK ITALIC CAPITAL DD" +
	"OUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SMALL EDOUBLE-STRUCK ITA" +
	"LIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LINETURNED AMPERSANDPER " +
	"SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN SOURCEVULGAR FRACTION" +
	" ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR FRACTION ONE TENTHVULGAR FRA" +
	"CTION ONE THIRDVULGAR FRACTION TWO THIRDSVULGAR FRACTION ONE FIFTHVULGAR" +
	" FRACTION TWO FIFTHSVULGAR FRACTION THREE FIFTHSVULGAR FRACTION FOUR FIF" +
	"THSVULGAR FRACTION ONE SIXTHVULGAR FRACTION FIVE SIXTHSVULGAR FRACTION O" +
	"NE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGAR FRACTION FIVE EIGHTHSVULGAR" +
	" FRACTION SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN NUMERAL ONEROMAN NUME" +
	"RAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOURROMAN NUMERAL FIVEROMAN NUME" +
	"RAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN NUMERAL NINEROMAN NUM" +
	"ERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL TWELVEROMAN NUMERAL FIFTYROMAN" +
	" NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMAN NUMERAL ONE THOUSAND" +
	"SMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMALL ROMAN NUMERAL THREES" +
	"MALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMALL ROMAN NUMERAL SIXSM" +
	"ALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSMALL ROMAN NUMERAL NINE" +
	"SMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENSMALL ROMAN NUMERAL TWE" +
	"LVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ONE HUNDREDSMALL ROMAN N" +
	"UMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSANDROMAN NUMERAL ONE THO" +
	"USAND C DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL TEN THOUSANDROMAN NUME" +
	"RAL REVERSED ONE HUNDREDLATIN SMALL LETTER REVERSED CROMAN NUMERAL SIX L" +
	"ATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERAL FIFTY THOUSANDROMAN " +
	"NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION ZERO THIRDSTURNED DIGIT TWOT" +
	"URNED DIGIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHTWARDS ARROWDOWNWARDS A" +
	"RROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWNORTH EAST ARROWSOUTH E" +
	"AST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WITH STROKERIGHTWARDS ARROW WIT" +
	"H STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWLEFTWARDS TWO HEADED AR" +
	"ROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO HEADED ARROWDOWNWARDS TWO HEAD" +
	"ED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW WITH TAILLEFTWARDS ARR" +
	"OW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW FROM BARDOWNWARDS ARRO" +
	"W FROM BARUP DOWN ARROW WITH BASELEFTWARDS ARROW WITH HOOKRIGHTWARDS ARR" +
	"OW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS ARROW WITH LOOPLEFT RIGH" +
	"T WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS ZIGZAG ARROWUPWARDS AR" +
	"ROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHTWARDSDOWNWARDS ARROW W" +
	"ITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWARDSRIGHTWARDS ARROW WIT" +
	"H CORNER DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFTWARDSANTICLOCKWISE TOP" +
	" SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNORTH WEST ARROW TO LONG " +
	"BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BARANTICLOCKWISE OPEN" +
	" CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS HARPOON WITH BARB UPWA" +
	"RDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPWARDS HARPOON WITH BARB RIGHTW" +
	"ARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS HARPOON WITH BARB UPWA" +
	"RDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS HARPOON WITH BARB RIG" +
	"HTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS ARROW OVER LEFTWA" +
	"RDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROWLEFTWARDS ARROW OVER " +
	"RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAIRED ARROWSRIGHTWARDS P" +
	"AIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPOON OVER RIGHTWARDS HAR" +
	"POONRIGHTWARDS HARPOON OVER LEFTWARDS HARPOONLEFTWARDS DOUBLE ARROW WITH" +
	" STROKELEFT RIGHT DOUBLE ARROW WITH STROKERIGHTWARDS DOUBLE ARROW WITH S" +
	"TROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIGHTWARDS DOUBLE ARROWDO" +
	"WNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN DOUBLE ARROWNORTH WES" +
	"T DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DOUBLE ARROWSOUTH WEST D" +
	"OUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE ARROWLEFTWARDS SQUIGG" +
	"LE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WITH DOUBLE STROKEDOWNWAR" +
	"DS ARROW WITH DOUBLE STROKELEFTWARDS DASHED ARROWUPWARDS DASHED ARROWRIG" +
	"HTWARDS DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARDS ARROW TO BARRIGHTWAR" +
	"DS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE ARROWRIGHTWARDS WHITE " +
	"ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARROW FROM BARUPWARDS WHITE ARRO" +
	"W ON PEDESTALUPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BARUPWARDS " +
	"WHITE ARROW ON PEDESTAL WITH VERTICAL BARUPWARDS WHITE DOUBLE ARROWUPWAR" +
	"DS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE ARROW FROM WALLNORTH W") + ("" +
	"EST ARROW TO CORNERSOUTH EAST ARROW TO CORNERUP DOWN WHITE ARROWRIGHT AR" +
	"ROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROWTHREE RIG" +
	"HTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL STROKERIGHTWARDS ARROW WITH " +
	"VERTICAL STROKELEFT RIGHT ARROW WITH VERTICAL STROKELEFTWARDS ARROW WITH" +
	" DOUBLE VERTICAL STROKERIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKELEFT " +
	"RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS OPEN-HEADED ARROWRIGHTW" +
	"ARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROWFOR ALLCOMPLEMENTPARTI" +
	"AL DIFFERENTIALTHERE EXISTSTHERE DOES NOT EXISTEMPTY SETINCREMENTNABLAEL" +
	"EMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS AS MEMBERDOES NOT CONT" +
	"AIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF PROOFN-ARY PRODUCTN-ARY COPR" +
	"ODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDOT PLUSDIVISION SLASHSE" +
	"T MINUSASTERISK OPERATORRING OPERATORBULLET OPERATORSQUARE ROOTCUBE ROOT" +
	"FOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLEMEASURED ANGLESPHERICA" +
	"L ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT PARALLEL TOLOGICAL ANDLOGICA" +
	"L ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE INTEGRALCONTOUR INTEG" +
	"RALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGRALCLOCKWISE CONTOUR IN" +
	"TEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAUSERATIOPROPORTIONDOT M" +
	"INUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPERATORREVERSED TILDEINVE" +
	"RTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDEMINUS TILDEASYMPTOTICALLY EQU" +
	"AL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUAL TOAPPROXIMATELY BUT " +
	"NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY NOR ACTUALLY EQUAL TOALMOST E" +
	"QUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TOTRIPLE TILDEALL EQUAL " +
	"TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TODIFFERENCE BETWEENAPPROACHES T" +
	"HE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL TO OR THE IMAGE OFIMAG" +
	"E OF OR APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS COLONRING IN EQUAL TORI" +
	"NG EQUAL TOCORRESPONDS TOESTIMATESEQUIANGULAR TOSTAR EQUALSDELTA EQUAL T" +
	"OEQUAL TO BY DEFINITIONMEASURED BYQUESTIONED EQUAL TONOT EQUAL TOIDENTIC" +
	"AL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-THAN OR EQUAL TOGREATER-" +
	"THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THAN OVER EQUAL TOLESS-TH" +
	"AN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMUCH LESS-THANMUCH GREAT" +
	"ER-THANBETWEENNOT EQUIVALENT TONOT LESS-THANNOT GREATER-THANNEITHER LESS" +
	"-THAN NOR EQUAL TONEITHER GREATER-THAN NOR EQUAL TOLESS-THAN OR EQUIVALE" +
	"NT TOGREATER-THAN OR EQUIVALENT TONEITHER LESS-THAN NOR EQUIVALENT TONEI" +
	"THER GREATER-THAN NOR EQUIVALENT TOLESS-THAN OR GREATER-THANGREATER-THAN" +
	" OR LESS-THANNEITHER LESS-THAN NOR GREATER-THANNEITHER GREATER-THAN NOR " +
	"LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCEEDS OR EQUAL TOPRECEDE" +
	"S OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TODOES NOT PRECEDEDOES NOT SUCC" +
	"EEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A SUPERSET OFSUBSET OF OR EQUA" +
	"L TOSUPERSET OF OR EQUAL TONEITHER A SUBSET OF NOR EQUAL TONEITHER A SUP" +
	"ERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSUPERSET OF WITH NOT EQU" +
	"AL TOMULTISETMULTISET MULTIPLICATIONMULTISET UNIONSQUARE IMAGE OFSQUARE " +
	"ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGINAL OF OR EQUAL TOSQUA" +
	"RE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED TIMESCIRCLED DIVISION S" +
	"LASHCIRCLED DOT OPERATORCIRCLED RING OPERATORCIRCLED ASTERISK OPERATORCI" +
	"RCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED MINUSSQUARED TIMESSQUARED DO" +
	"T OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSERTIONMODELSTRUEFORCESTR" +
	"IPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL BAR DOUBLE RIGHT TURNST" +
	"ILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGATED DOUBLE VERTICAL BAR DOUBL" +
	"E RIGHT TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS UNDER RELATIONNORMAL SU" +
	"BGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROUP OF OR EQUAL TOCONTAI" +
	"NS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE OFMULTIMAPHERMITIAN CO" +
	"NJUGATE MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WITH ARCRIGHT TRIANGLEN-A" +
	"RY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-ARY UNIONDIAMOND OPERA" +
	"TORDOT OPERATORSTAR OPERATORDIVISION TIMESBOWTIELEFT NORMAL FACTOR SEMID" +
	"IRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUCTLEFT SEMIDIRECT PRODU" +
	"CTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCURLY LOGICAL ORCURLY LOG" +
	"ICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSECTIONDOUBLE UNIONPITCH" +
	"FORKEQUAL AND PARALLEL TOLESS-THAN WITH DOTGREATER-THAN WITH DOTVERY MUC" +
	"H LESS-THANVERY MUCH GREATER-THANLESS-THAN EQUAL TO OR GREATER-THANGREAT" +
	"ER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LESS-THANEQUAL TO OR GREATER-TH" +
	"ANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT PRECEDE OR EQUALDOES " +
	"NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR EQUAL TONOT SQUARE ORIGINAL O" +
	"F OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE ORIGINAL OF OR NOT EQ" +
	"UAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATER-THAN BUT NOT EQUIVALENT TOP") + ("" +
	"RECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUIVALENT TONOT NORMAL SU" +
	"BGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NORMAL SUBGROUP OF OR EQ" +
	"UAL TODOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUALVERTICAL ELLIPSISMIDLI" +
	"NE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDOWN RIGHT DIAGONAL ELLI" +
	"PSISELEMENT OF WITH LONG HORIZONTAL STROKEELEMENT OF WITH VERTICAL BAR A" +
	"T END OF HORIZONTAL STROKESMALL ELEMENT OF WITH VERTICAL BAR AT END OF H" +
	"ORIZONTAL STROKEELEMENT OF WITH DOT ABOVEELEMENT OF WITH OVERBARSMALL EL" +
	"EMENT OF WITH OVERBARELEMENT OF WITH UNDERBARELEMENT OF WITH TWO HORIZON" +
	"TAL STROKESCONTAINS WITH LONG HORIZONTAL STROKECONTAINS WITH VERTICAL BA" +
	"R AT END OF HORIZONTAL STROKESMALL CONTAINS WITH VERTICAL BAR AT END OF " +
	"HORIZONTAL STROKECONTAINS WITH OVERBARSMALL CONTAINS WITH OVERBARZ NOTAT" +
	"ION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSEUP ARROWHEADDOWN ARROW" +
	"HEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGHT CEILINGLEFT FLOORRIG" +
	"HT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT CROPTOP LEFT CROPREVE" +
	"RSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHONE RECORDERPOSITION IN" +
	"DICATORVIEWDATA SQUAREPLACE OF INTEREST SIGNTURNED NOT SIGNWATCHHOURGLAS" +
	"STOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT CORNERBOTTOM RIGHT CORNERTOP" +
	" HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARROWHEAD BETWEEN TWO HOR" +
	"IZONTAL BARSOPTION KEYERASE TO THE RIGHTX IN A RECTANGLE BOXKEYBOARDLEFT" +
	"-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE BRACKETERASE TO THE LEFTBENZ" +
	"ENE RINGCYLINDRICITYALL AROUND-PROFILESYMMETRYTOTAL RUNOUTDIMENSION ORIG" +
	"INCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNCTIONAL SYMBOL I-BEAMAP" +
	"L FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMBOL QUAD EQUALAPL FUNCT" +
	"IONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD DIAMONDAPL FUNCTIONAL" +
	" SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEAPL FUNCTIONAL SYMBOL C" +
	"IRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUNCTIONAL SYMBOL SLASH B" +
	"ARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONAL SYMBOL QUAD SLASHAPL" +
	" FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SYMBOL QUAD LESS-THANAPL" +
	" FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL SYMBOL LEFTWARDS VANE" +
	"APL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONAL SYMBOL QUAD LEFTWARD" +
	"S ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROWAPL FUNCTIONAL SYMBOL " +
	"CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UNDERBARAPL FUNCTIONAL S" +
	"YMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN CARETAPL FUNCTIONAL SYM" +
	"BOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTAPL FUNCTIONAL SYMBOL U" +
	"PWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARROWAPL FUNCTIONAL SYMBOL" +
	" UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL FUNCTIONAL SYMBOL QUA" +
	"D UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTIONAL SYMBOL UP TACK JO" +
	"TAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONAL SYMBOL QUAD DOWNWARD" +
	"S ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUNCTIONAL SYMBOL DELTA U" +
	"NDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL FUNCTIONAL SYMBOL JOT U" +
	"NDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FUNCTIONAL SYMBOL UP SHO" +
	"E JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONAL SYMBOL CIRCLE STARAP" +
	"L FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBOL UP TACK DIAERESISAPL" +
	" FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYMBOL STAR DIAERESISAPL " +
	"FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMBOL CIRCLE DIAERESISAPL" +
	" FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL SYMBOL LEFT SHOE STILEA" +
	"PL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL SYMBOL GREATER-THAN D" +
	"IAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIONAL SYMBOL DEL TILDEAP" +
	"L FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STILE TILDEAPL FUNCTIONAL" +
	" SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QUAD NOT EQUALAPL FUNCTI" +
	"ONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOWN CARET TILDEAPL FUNCT" +
	"IONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL IOTAAPL FUNCTIONAL SYMB" +
	"OL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SYMBOL ALPHA UNDERBARAPL" +
	" FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL SYMBOL IOTA UNDERBARAP" +
	"L FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL SYMBOL ALPHANOT CHECK M" +
	"ARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDERED OPEN BOXBELL SYMBOL" +
	"VERTICAL LINE WITH MIDDLE DOTINSERTION SYMBOLCONTINUOUS UNDERLINE SYMBOL" +
	"DISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPOSITION SYMBOLWHITE SQU" +
	"ARE WITH CENTRE VERTICAL LINEENTER SYMBOLALTERNATIVE KEY SYMBOLHELM SYMB" +
	"OLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGLE DOWNBROKEN CIRCLE WI" +
	"TH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYSTERESIS SYMBOLOPEN-CIRC" +
	"UIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE SYMBOLPASSIVE-PULL-DO" +
	"WN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIRECT CURRENT SYMBOL FORM " +
	"TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL QUADDECIMAL SEPARATOR K") + ("" +
	"EY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOLCLEAR SCREEN SYMBOLLEF" +
	"T PARENTHESIS UPPER HOOKLEFT PARENTHESIS EXTENSIONLEFT PARENTHESIS LOWER" +
	" HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS EXTENSIONRIGHT PARENT" +
	"HESIS LOWER HOOKLEFT SQUARE BRACKET UPPER CORNERLEFT SQUARE BRACKET EXTE" +
	"NSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT SQUARE BRACKET UPPER CORNERRI" +
	"GHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BRACKET LOWER CORNERLEFT CURLY " +
	"BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECELEFT CURLY BRACKET LOWE" +
	"R HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BRACKET UPPER HOOKRIGHT CURLY B" +
	"RACKET MIDDLE PIECERIGHT CURLY BRACKET LOWER HOOKINTEGRAL EXTENSIONHORIZ" +
	"ONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTIONUPPER" +
	" RIGHT OR LOWER LEFT CURLY BRACKET SECTIONSUMMATION TOPSUMMATION BOTTOMT" +
	"OP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUARE BRACKET OVER TOP SQU" +
	"ARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX LINERIGHT VERTICAL BOX" +
	" LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3HORIZONTAL SCAN LINE-7H" +
	"ORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHTDENTIS" +
	"TRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTRY SYMBOL LIGHT VERTICA" +
	"L WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLEDENTI" +
	"STRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLEDENTISTRY SYMBOL LIGHT VE" +
	"RTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIA" +
	"NGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLEDENTISTRY SYMB" +
	"OL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WIT" +
	"H WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVEDENTISTRY SYMBOL" +
	" LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL LIGHT UP AND HORIZONTALDENTIS" +
	"TRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTISTRY SYMBOL LIGHT VERTICAL AN" +
	"D BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLVERTICAL LINE EXTENSION" +
	"METRICAL BREVEMETRICAL LONG OVER SHORTMETRICAL SHORT OVER LONGMETRICAL L" +
	"ONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER LONGMETRICAL TWO SHORTS JOIN" +
	"EDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICAL PENTASEMEEARTH GROUNDFUSETO" +
	"P PARENTHESISBOTTOM PARENTHESISTOP CURLY BRACKETBOTTOM CURLY BRACKETTOP " +
	"TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL BRACKETWHITE TRAPEZIUMBENZEN" +
	"E RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTELECTRICAL INTERSECTIOND" +
	"ECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE TRIANGLEBLACK LEFT-POI" +
	"NTING DOUBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIANGLEBLACK DOWN-POINTIN" +
	"G DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARB" +
	"LACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK RIGHT-POINTING" +
	" TRIANGLE WITH DOUBLE VERTICAL BARALARM CLOCKSTOPWATCHTIMER CLOCKHOURGLA" +
	"SS WITH FLOWING SANDBLACK MEDIUM LEFT-POINTING TRIANGLEBLACK MEDIUM RIGH" +
	"T-POINTING TRIANGLEBLACK MEDIUM UP-POINTING TRIANGLEBLACK MEDIUM DOWN-PO" +
	"INTING TRIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR STOPBLACK CIRCLE FOR " +
	"RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMBOLPOWER SLEEP SYMBOLOB" +
	"SERVER EYE SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSYMBOL FOR ST" +
	"ART OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSIONSYMBOL FO" +
	"R ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACKSPACESYMBOL" +
	" FOR HORIZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERTICAL TABULA" +
	"TIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR SHIFT OUTSY" +
	"MBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE CONTROL ON" +
	"ESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREESYMBOL FOR " +
	"DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR SYNCHRONOUS" +
	" IDLESYMBOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYMBOL FOR END" +
	" OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FILE SEPARATO" +
	"RSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL FOR UNIT SE" +
	"PARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXSYMBOL FOR N" +
	"EWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TWOSYMBOL FOR" +
	" DELETE SQUARE CHECKER BOARD FORMSYMBOL FOR DELETE RECTANGULAR CHECKER B" +
	"OARD FORMSYMBOL FOR DELETE MEDIUM SHADE FORMOCR HOOKOCR CHAIROCR FORKOCR" +
	" INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR BRANCH BANK IDENTIFICATIONOC" +
	"R AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOUNT NUMBEROCR DOUBLE BACKSLASH" +
	"CIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED DIGIT THREECIRCLED DIGIT FOURC" +
	"IRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED DIGIT SEVENCIRCLED DIGIT EIGHT" +
	"CIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED NUMBER ELEVENCIRCLED NUMBER " +
	"TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER FOURTEENCIRCLED NUMBER FIFTE" +
	"ENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVENTEENCIRCLED NUMBER EIGHTEENC" +
	"IRCLED NUMBER NINETEENCIRCLED NUMBER TWENTYPARENTHESIZED DIGIT ONEPARENT" +
	"HESIZED DIGIT TWOPARENTHESIZED DIGIT THREEPARENTHESIZED DIGIT FOURPARENT") + ("" +
	"HESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPARENTHESIZED DIGIT SEVENPARENT" +
	"HESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINEPARENTHESIZED NUMBER TENPAREN" +
	"THESIZED NUMBER ELEVENPARENTHESIZED NUMBER TWELVEPARENTHESIZED NUMBER TH" +
	"IRTEENPARENTHESIZED NUMBER FOURTEENPARENTHESIZED NUMBER FIFTEENPARENTHES" +
	"IZED NUMBER SIXTEENPARENTHESIZED NUMBER SEVENTEENPARENTHESIZED NUMBER EI" +
	"GHTEENPARENTHESIZED NUMBER NINETEENPARENTHESIZED NUMBER TWENTYDIGIT ONE " +
	"FULL STOPDIGIT TWO FULL STOPDIGIT THREE FULL STOPDIGIT FOUR FULL STOPDIG" +
	"IT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT SEVEN FULL STOPDIGIT EIGHT FUL" +
	"L STOPDIGIT NINE FULL STOPNUMBER TEN FULL STOPNUMBER ELEVEN FULL STOPNUM" +
	"BER TWELVE FULL STOPNUMBER THIRTEEN FULL STOPNUMBER FOURTEEN FULL STOPNU" +
	"MBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL STOPNUMBER SEVENTEEN FULL STOP" +
	"NUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FULL STOPNUMBER TWENTY FULL STO" +
	"PPARENTHESIZED LATIN SMALL LETTER APARENTHESIZED LATIN SMALL LETTER BPAR" +
	"ENTHESIZED LATIN SMALL LETTER CPARENTHESIZED LATIN SMALL LETTER DPARENTH" +
	"ESIZED LATIN SMALL LETTER EPARENTHESIZED LATIN SMALL LETTER FPARENTHESIZ" +
	"ED LATIN SMALL LETTER GPARENTHESIZED LATIN SMALL LETTER HPARENTHESIZED L" +
	"ATIN SMALL LETTER IPARENTHESIZED LATIN SMALL LETTER JPARENTHESIZED LATIN" +
	" SMALL LETTER KPARENTHESIZED LATIN SMALL LETTER LPARENTHESIZED LATIN SMA" +
	"LL LETTER MPARENTHESIZED LATIN SMALL LETTER NPARENTHESIZED LATIN SMALL L" +
	"ETTER OPARENTHESIZED LATIN SMALL LETTER PPARENTHESIZED LATIN SMALL LETTE" +
	"R QPARENTHESIZED LATIN SMALL LETTER RPARENTHESIZED LATIN SMALL LETTER SP" +
	"ARENTHESIZED LATIN SMALL LETTER TPARENTHESIZED LATIN SMALL LETTER UPAREN" +
	"THESIZED LATIN SMALL LETTER VPARENTHESIZED LATIN SMALL LETTER WPARENTHES" +
	"IZED LATIN SMALL LETTER XPARENTHESIZED LATIN SMALL LETTER YPARENTHESIZED" +
	" LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL LETTER ACIRCLED LATIN CAPITAL" +
	" LETTER BCIRCLED LATIN CAPITAL LETTER CCIRCLED LATIN CAPITAL LETTER DCIR" +
	"CLED LATIN CAPITAL LETTER ECIRCLED LATIN CAPITAL LETTER FCIRCLED LATIN C" +
	"APITAL LETTER GCIRCLED LATIN CAPITAL LETTER HCIRCLED LATIN CAPITAL LETTE" +
	"R ICIRCLED LATIN CAPITAL LETTER JCIRCLED LATIN CAPITAL LETTER KCIRCLED L" +
	"ATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL LETTER MCIRCLED LATIN CAPITAL" +
	" LETTER NCIRCLED LATIN CAPITAL LETTER OCIRCLED LATIN CAPITAL LETTER PCIR" +
	"CLED LATIN CAPITAL LETTER QCIRCLED LATIN CAPITAL LETTER RCIRCLED LATIN C" +
	"APITAL LETTER SCIRCLED LATIN CAPITAL LETTER TCIRCLED LATIN CAPITAL LETTE" +
	"R UCIRCLED LATIN CAPITAL LETTER VCIRCLED LATIN CAPITAL LETTER WCIRCLED L" +
	"ATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL LETTER YCIRCLED LATIN CAPITAL" +
	" LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLED LATIN SMALL LETTER BCIRCLED" +
	" LATIN SMALL LETTER CCIRCLED LATIN SMALL LETTER DCIRCLED LATIN SMALL LET" +
	"TER ECIRCLED LATIN SMALL LETTER FCIRCLED LATIN SMALL LETTER GCIRCLED LAT" +
	"IN SMALL LETTER HCIRCLED LATIN SMALL LETTER ICIRCLED LATIN SMALL LETTER " +
	"JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN SMALL LETTER LCIRCLED LATIN S" +
	"MALL LETTER MCIRCLED LATIN SMALL LETTER NCIRCLED LATIN SMALL LETTER OCIR" +
	"CLED LATIN SMALL LETTER PCIRCLED LATIN SMALL LETTER QCIRCLED LATIN SMALL" +
	" LETTER RCIRCLED LATIN SMALL LETTER SCIRCLED LATIN SMALL LETTER TCIRCLED" +
	" LATIN SMALL LETTER UCIRCLED LATIN SMALL LETTER VCIRCLED LATIN SMALL LET" +
	"TER WCIRCLED LATIN SMALL LETTER XCIRCLED LATIN SMALL LETTER YCIRCLED LAT" +
	"IN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE CIRCLED NUMBER ELEVENNEGATIV" +
	"E CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUMBER THIRTEENNEGATIVE CIRCLED " +
	"NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFTEENNEGATIVE CIRCLED NUMBER SI" +
	"XTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGATIVE CIRCLED NUMBER EIGHTEENNE" +
	"GATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRCLED NUMBER TWENTYDOUBLE CIRCL" +
	"ED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE CIRCLED DIGIT THREEDOUBLE CIR" +
	"CLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOUBLE CIRCLED DIGIT SIXDOUBLE C" +
	"IRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGHTDOUBLE CIRCLED DIGIT NINEDOU" +
	"BLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGIT ZEROBOX DRAWINGS LIGHT HORI" +
	"ZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAWINGS LIGHT VERTICALBOX DRAWIN" +
	"GS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE DASH HORIZONTALBOX DRAWINGS H" +
	"EAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIGHT TRIPLE DASH VERTICALBOX DR" +
	"AWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWINGS LIGHT QUADRUPLE DASH HORIZ" +
	"ONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTALBOX DRAWINGS LIGHT QUAD" +
	"RUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADRUPLE DASH VERTICALBOX DRAWING" +
	"S LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIGHT AND RIGHT HEAVYBOX DRAWING" +
	"S DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY DOWN AND RIGHTBOX DRAWING" +
	"S LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGHT AND LEFT HEAVYBOX DRAWINGS " +
	"DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY DOWN AND LEFTBOX DRAWINGS LI") + ("" +
	"GHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND RIGHT HEAVYBOX DRAWINGS UP HEA" +
	"VY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND RIGHTBOX DRAWINGS LIGHT UP A" +
	"ND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEF" +
	"T LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DRAWINGS LIGHT VERTICAL AND RIG" +
	"HTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVYBOX DRAWINGS UP HEAVY AND R" +
	"IGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS VE" +
	"RTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVYBO" +
	"X DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND " +
	"RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBOX DRAWINGS VERTICAL LIGHT AND" +
	" LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN HE" +
	"AVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHTBOX DRAWI" +
	"NGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWINGS UP LIGHT AND LEFT DOWN HEAV" +
	"YBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DRAWINGS LIGHT DOWN AND HORIZON" +
	"TALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT HEAVY " +
	"AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVYBOX DRAWI" +
	"NGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT DOW" +
	"N HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVYBOX DRAWINGS HEAVY DO" +
	"WN AND HORIZONTALBOX DRAWINGS LIGHT UP AND HORIZONTALBOX DRAWINGS LEFT H" +
	"EAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHTBOX DRA" +
	"WINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND HORIZONTAL " +
	"LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVYBOX DRAWINGS LEFT LIGHT A" +
	"ND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND HORIZONTALBOX DRAWINGS LIGHT " +
	"VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHTB" +
	"OX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHTBOX DRAWINGS VERTICAL LIG" +
	"HT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHTBO" +
	"X DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHTBOX DRAWINGS VERTICAL HEAVY" +
	" AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHTBOX " +
	"DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS LEFT DOWN HEAVY " +
	"AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHTBOX DRA" +
	"WINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX DRAWINGS UP LIGHT AND DOWN H" +
	"ORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVYBOX DRAWI" +
	"NGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX DRAWINGS HEAVY VERTICAL AND H" +
	"ORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HORIZONTALBOX DRAWINGS HEAVY DOU" +
	"BLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH VERTICALBOX DRAWINGS H" +
	"EAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBLE HORIZONTALBOX DRAWINGS DOUB" +
	"LE VERTICALBOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLEBOX DRAWINGS DOWN DO" +
	"UBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DOWN AND RIGHTBOX DRAWINGS DOWN" +
	" SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DOUBLE AND LEFT SINGLEBOX DRAWI" +
	"NGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SINGLE AND RIGHT DOUBLEBOX DRAWI" +
	"NGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE UP AND RIGHTBOX DRAWIN" +
	"GS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP DOUBLE AND LEFT SINGLEBOX DR" +
	"AWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLEBO" +
	"X DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE VERTICAL " +
	"AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLEBOX DRAWINGS VERTIC" +
	"AL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE VERTICAL AND LEFTBOX DRAWIN" +
	"GS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS DOWN DOUBLE AND HORIZON" +
	"TAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORIZONTALBOX DRAWINGS UP SINGLE " +
	"AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLEBOX DRA" +
	"WINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS VERTICAL SINGLE AND HORIZONTA" +
	"L DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS D" +
	"OUBLE VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT ARC DOWN AND RIGHTBOX DR" +
	"AWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS LIGHT ARC UP AND LEFTBOX DRAW" +
	"INGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LO" +
	"WER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHTBOX DRAWING" +
	"S LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LEFTBOX DRAWINGS LIGHT UPBOX DR" +
	"AWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBOX DRAWINGS HEAVY LEFTBOX DRAW" +
	"INGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DRAWINGS HEAVY DOWNBOX DRAWINGS" +
	" LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIGHT UP AND HEAVY DOWNBOX DRAWI" +
	"NGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS HEAVY UP AND LIGHT DOWNUPPER " +
	"HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE QUARTER BLOCKLOWER THREE EIGHT" +
	"HS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS BLOCKLOWER THREE QUARTERS BLO" +
	"CKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT SEVEN EIGHTHS BLOCKLEFT THREE " +
	"QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT HALF BLOCKLEFT THREE EIGHTHS B" +
	"LOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH BLOCKRIGHT HALF BLOCKLIGHT SHA") + ("" +
	"DEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BLOCKRIGHT ONE EIGHTH BLOCKQUAD" +
	"RANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT UPPER LEFTQUADRANT UPPER LEF" +
	"T AND LOWER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT AND LOWER RIGHTQUADR" +
	"ANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFTQUADRANT UPPER LEFT AND UPP" +
	"ER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGHTQUADRANT UPPER RIGHT AND LOW" +
	"ER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHTBLACK SQUAREWH" +
	"ITE SQUAREWHITE SQUARE WITH ROUNDED CORNERSWHITE SQUARE CONTAINING BLACK" +
	" SMALL SQUARESQUARE WITH HORIZONTAL FILLSQUARE WITH VERTICAL FILLSQUARE " +
	"WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH UPPER LEFT TO LOWER RIGHT FIL" +
	"LSQUARE WITH UPPER RIGHT TO LOWER LEFT FILLSQUARE WITH DIAGONAL CROSSHAT" +
	"CH FILLBLACK SMALL SQUAREWHITE SMALL SQUAREBLACK RECTANGLEWHITE RECTANGL" +
	"EBLACK VERTICAL RECTANGLEWHITE VERTICAL RECTANGLEBLACK PARALLELOGRAMWHIT" +
	"E PARALLELOGRAMBLACK UP-POINTING TRIANGLEWHITE UP-POINTING TRIANGLEBLACK" +
	" UP-POINTING SMALL TRIANGLEWHITE UP-POINTING SMALL TRIANGLEBLACK RIGHT-P" +
	"OINTING TRIANGLEWHITE RIGHT-POINTING TRIANGLEBLACK RIGHT-POINTING SMALL " +
	"TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLEBLACK RIGHT-POINTING POINTERW" +
	"HITE RIGHT-POINTING POINTERBLACK DOWN-POINTING TRIANGLEWHITE DOWN-POINTI" +
	"NG TRIANGLEBLACK DOWN-POINTING SMALL TRIANGLEWHITE DOWN-POINTING SMALL T" +
	"RIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LEFT-POINTING TRIANGLEBLACK LEF" +
	"T-POINTING SMALL TRIANGLEWHITE LEFT-POINTING SMALL TRIANGLEBLACK LEFT-PO" +
	"INTING POINTERWHITE LEFT-POINTING POINTERBLACK DIAMONDWHITE DIAMONDWHITE" +
	" DIAMOND CONTAINING BLACK SMALL DIAMONDFISHEYELOZENGEWHITE CIRCLEDOTTED " +
	"CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLACK CIRCLECIRCLE WITH LEFT HALF" +
	" BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WITH LOWER HALF BLACKCIRCLE WIT" +
	"H UPPER HALF BLACKCIRCLE WITH UPPER RIGHT QUADRANT BLACKCIRCLE WITH ALL " +
	"BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLACK CIRCLERIGHT HALF BLACK CIRC" +
	"LEINVERSE BULLETINVERSE WHITE CIRCLEUPPER HALF INVERSE WHITE CIRCLELOWER" +
	" HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRANT CIRCULAR ARCUPPER RIGHT QU" +
	"ADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIRCULAR ARCLOWER LEFT QUADRANT " +
	"CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIRCLEBLACK LOWER RIGHT TRIANGLE" +
	"BLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT TRIANGLEBLACK UPPER RIGHT TRIA" +
	"NGLEWHITE BULLETSQUARE WITH LEFT HALF BLACKSQUARE WITH RIGHT HALF BLACKS" +
	"QUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQUARE WITH LOWER RIGHT DIAGONA" +
	"L HALF BLACKWHITE SQUARE WITH VERTICAL BISECTING LINEWHITE UP-POINTING T" +
	"RIANGLE WITH DOTUP-POINTING TRIANGLE WITH LEFT HALF BLACKUP-POINTING TRI" +
	"ANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHITE SQUARE WITH UPPER LEFT QUAD" +
	"RANTWHITE SQUARE WITH LOWER LEFT QUADRANTWHITE SQUARE WITH LOWER RIGHT Q" +
	"UADRANTWHITE SQUARE WITH UPPER RIGHT QUADRANTWHITE CIRCLE WITH UPPER LEF" +
	"T QUADRANTWHITE CIRCLE WITH LOWER LEFT QUADRANTWHITE CIRCLE WITH LOWER R" +
	"IGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT QUADRANTUPPER LEFT TRIANGLEUP" +
	"PER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE MEDIUM SQUAREBLACK MEDIUM SQU" +
	"AREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SMALL SQUARELOWER RIGHT TRIANGL" +
	"EBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOMETBLACK STARWHITE STARLIGHTNI" +
	"NGTHUNDERSTORMSUNASCENDING NODEDESCENDING NODECONJUNCTIONOPPOSITIONBLACK" +
	" TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT BOX WITH CHECKBALLOT BOX WITH " +
	"XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAGEWHITE SHOGI PIECEBLACK SHOGI" +
	" PIECESHAMROCKREVERSED ROTATED FLORAL HEART BULLETBLACK LEFT POINTING IN" +
	"DEXBLACK RIGHT POINTING INDEXWHITE LEFT POINTING INDEXWHITE UP POINTING " +
	"INDEXWHITE RIGHT POINTING INDEXWHITE DOWN POINTING INDEXSKULL AND CROSSB" +
	"ONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD SIGNCADUCEUSANKHORTHODOX CROSS" +
	"CHI RHOCROSS OF LORRAINECROSS OF JERUSALEMSTAR AND CRESCENTFARSI SYMBOLA" +
	"DI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN YANGTRIGRAM FOR HEAVENTRIGRAM " +
	"FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDERTRIGRAM FOR WINDTRIGRAM FOR W" +
	"ATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWHEEL OF DHARMAWHITE FROWNING F" +
	"ACEWHITE SMILING FACEBLACK SMILING FACEWHITE SUN WITH RAYSFIRST QUARTER " +
	"MOONLAST QUARTER MOONMERCURYFEMALE SIGNEARTHMALE SIGNJUPITERSATURNURANUS" +
	"NEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGOLIBRASCORPIUSSAGITTARIUSCAPRI" +
	"CORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHESS QUEENWHITE CHESS ROOKWHITE" +
	" CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS PAWNBLACK CHESS KINGBLACK CHE" +
	"SS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPBLACK CHESS KNIGHTBLACK CHESS " +
	"PAWNBLACK SPADE SUITWHITE HEART SUITWHITE DIAMOND SUITBLACK CLUB SUITWHI" +
	"TE SPADE SUITBLACK HEART SUITBLACK DIAMOND SUITWHITE CLUB SUITHOT SPRING" +
	"SQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTESBEAMED SIXTEENTH NOTESMUSIC F" +
	"LAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNWEST SYRIAC CROSSEAST SYRIAC C") + ("" +
	"ROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYMBOL FOR TYPE-1 PLASTICSRECYCL" +
	"ING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYMBOL FOR TYPE-3 PLASTICSRECYCL" +
	"ING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYMBOL FOR TYPE-5 PLASTICSRECYCL" +
	"ING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYMBOL FOR TYPE-7 PLASTICSRECYCL" +
	"ING SYMBOL FOR GENERIC MATERIALSBLACK UNIVERSAL RECYCLING SYMBOLRECYCLED" +
	" PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBOLPERMANENT PAPER SIGNWHEELCHA" +
	"IR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE FACE-4DIE FACE-5DIE FACE-6WHI" +
	"TE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH TWO DOTSBLACK CIRCLE WITH WHIT" +
	"E DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTSMONOGRAM FOR YANGMONOGRAM FOR" +
	" YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSER YINDIGRAM FOR LESSER YANGDI" +
	"GRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAMMER AND PICKANCHORCROSSED SWO" +
	"RDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERGEARSTAFF OF HERMESATOM SYMBOL" +
	"FLEUR-DE-LISOUTLINED WHITE STARTHREE LINES CONVERGING RIGHTTHREE LINES C" +
	"ONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGNDOUBLED FEMALE SIGNDOUBLED MA" +
	"LE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE AND FEMALE SIGNMALE WITH STR" +
	"OKE SIGNMALE WITH STROKE AND MALE AND FEMALE SIGNVERTICAL MALE WITH STRO" +
	"KE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDIUM WHITE CIRCLEMEDIUM BLACK C" +
	"IRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMBOLDIVORCE SYMBOLUNMARRIED PAR" +
	"TNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERESPALLASJUNOVESTACHIRONBLACK MO" +
	"ON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQUADRATESOCCER BALLBASEBALLSQUA" +
	"RED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KINGBLACK DRAUGHTS MANBLACK DRAU" +
	"GHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLOUDRAINBLACK SNOWMANTHUNDER CL" +
	"OUD AND RAINTURNED WHITE SHOGI PIECETURNED BLACK SHOGI PIECEWHITE DIAMON" +
	"D IN SQUARECROSSING LANESDISABLED CAROPHIUCHUSPICKCAR SLIDINGHELMET WITH" +
	" WHITE CROSSCIRCLED CROSSING LANESCHAINSNO ENTRYALTERNATE ONE-WAY LEFT W" +
	"AY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHITE TWO-WAY LEFT WAY TRAFFICBL" +
	"ACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRIVE SLOW SIGNHEAVY WHITE DOWN-" +
	"POINTING TRIANGLELEFT CLOSED ENTRYSQUARED SALTIREFALLING DIAGONAL IN WHI" +
	"TE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRICTED LEFT ENTRY-1RESTRICTED LE" +
	"FT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEAVY CIRCLE WITH STROKE AND TWO" +
	" DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED PENTAGRAMLEFT-HANDED INTERLA" +
	"CED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS ON SHIELDSHINTO SHRINECHURCHC" +
	"ASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH HANDLESMAP SYMBOL FOR LIGHTH" +
	"OUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG IN HOLEFERRYSAILBOATSQUARE FO" +
	"UR CORNERSSKIERICE SKATEPERSON WITH BALLTENTJAPANESE BANK SYMBOLHEADSTON" +
	"E GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQUAREWHITE FLAG WITH HORIZONTAL" +
	" MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUPPER BLADE SCISSORSBLACK SCISS" +
	"ORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE HEAVY CHECK MARKTELEPHONE LOC" +
	"ATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED FISTRAISED HANDVICTORY HANDWR" +
	"ITING HANDLOWER RIGHT PENCILPENCILUPPER RIGHT PENCILWHITE NIBBLACK NIBCH" +
	"ECK MARKHEAVY CHECK MARKMULTIPLICATION XHEAVY MULTIPLICATION XBALLOT XHE" +
	"AVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK CROSSOPEN CENTRE CROSSHEAVY " +
	"OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE LATIN CROSSOUTLINED LATIN CRO" +
	"SSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-SPOKED ASTERISKFOUR BALLOON-SP" +
	"OKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTERISKFOUR CLUB-SPOKED ASTERISK" +
	"BLACK FOUR POINTED STARWHITE FOUR POINTED STARSPARKLESSTRESS OUTLINED WH" +
	"ITE STARCIRCLED WHITE STAROPEN CENTRE BLACK STARBLACK CENTRE WHITE STARO" +
	"UTLINED BLACK STARHEAVY OUTLINED BLACK STARPINWHEEL STARSHADOWED WHITE S" +
	"TARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT SPOKED ASTERISKEIGHT POINTED " +
	"BLACK STAREIGHT POINTED PINWHEEL STARSIX POINTED BLACK STAREIGHT POINTED" +
	" RECTILINEAR BLACK STARHEAVY EIGHT POINTED RECTILINEAR BLACK STARTWELVE " +
	"POINTED BLACK STARSIXTEEN POINTED ASTERISKTEARDROP-SPOKED ASTERISKOPEN C" +
	"ENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDROP-SPOKED ASTERISKSIX PETALLED" +
	" BLACK AND WHITE FLORETTEBLACK FLORETTEWHITE FLORETTEEIGHT PETALLED OUTL" +
	"INED BLACK FLORETTECIRCLED OPEN CENTRE EIGHT POINTED STARHEAVY TEARDROP-" +
	"SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIFOLIATE SNOWFLAKEHEAVY CHEVRON" +
	" SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKED ASTERISKEIGHT TEARDROP-SPOK" +
	"ED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISKCROSS" +
	" MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED CROSS MARKLOWER RIGHT DROP-SH" +
	"ADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWED WHITE SQUARELOWER RIGHT SHA" +
	"DOWED WHITE SQUAREUPPER RIGHT SHADOWED WHITE SQUAREBLACK QUESTION MARK O" +
	"RNAMENTWHITE QUESTION MARK ORNAMENTWHITE EXCLAMATION MARK ORNAMENTBLACK " +
	"DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK SYMBOLLIGHT VERTICAL BARMEDI" +
	"UM VERTICAL BARHEAVY VERTICAL BARHEAVY SINGLE TURNED COMMA QUOTATION MAR") + ("" +
	"K ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE TURNED " +
	"COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE COMMA QUOTATION MARK ORNAMENTH" +
	"EAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENTHEAVY LOW DOUBLE COMMA QUOT" +
	"ATION MARK ORNAMENTCURVED STEM PARAGRAPH SIGN ORNAMENTHEAVY EXCLAMATION " +
	"MARK ORNAMENTHEAVY HEART EXCLAMATION MARK ORNAMENTHEAVY BLACK HEARTROTAT" +
	"ED HEAVY BLACK HEART BULLETFLORAL HEARTROTATED FLORAL HEART BULLETMEDIUM" +
	" LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PARENTHESIS ORNAMENTMEDIUM FLATTE" +
	"NED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT" +
	"MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENTMEDIUM RIGHT-POINTING ANGLE B" +
	"RACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY RI" +
	"GHT-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY LEFT-POINTING ANGLE BRAC" +
	"KET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENTLIGHT LEFT TORTOI" +
	"SE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENTMEDI" +
	"UM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT CURLY BRACKET ORNAMENTDINGBAT" +
	" NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE CIRCLED DIGIT TWODINGBAT NEG" +
	"ATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE CIRCLED DIGIT FOURDINGBAT NEGA" +
	"TIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIRCLED DIGIT SIXDINGBAT NEGATIV" +
	"E CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCLED DIGIT EIGHTDINGBAT NEGATIV" +
	"E CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLED NUMBER TENDINGBAT CIRCLED S" +
	"ANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SERIF DIGIT TWODINGBAT CIRCLED S" +
	"ANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-SERIF DIGIT FOURDINGBAT CIRCLE" +
	"D SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS-SERIF DIGIT SIXDINGBAT CIRCL" +
	"ED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SANS-SERIF DIGIT EIGHTDINGBAT C" +
	"IRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED SANS-SERIF NUMBER TENDINGBAT" +
	" NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGBAT NEGATIVE CIRCLED SANS-SERI" +
	"F DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREEDINGBAT NEGATI" +
	"VE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGI" +
	"T FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIXDINGBAT NEGATIVE CIRC" +
	"LED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGH" +
	"TDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINEDINGBAT NEGATIVE CIRCLED " +
	"SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGHTWARDS ARROWHEAVY PLUS SIGNHE" +
	"AVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUTH EAST ARROWHEAVY RIGHTWARDS " +
	"ARROWHEAVY NORTH EAST ARROWDRAFTING POINT RIGHTWARDS ARROWHEAVY ROUND-TI" +
	"PPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTWARDS ARROWHEAVY TRIANGLE-HEAD" +
	"ED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED RIGHTWARDS ARROWHEAVY DASHED T" +
	"RIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTWARDS ARROWTHREE-D TOP-LIGHTED" +
	" RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEADBLACK RI" +
	"GHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROWHEAVY" +
	" BLACK CURVED UPWARDS AND RIGHTWARDS ARROWSQUAT BLACK RIGHTWARDS ARROWHE" +
	"AVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWRIGHT-SHADED WHITE RIGHTWARDS " +
	"ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK-TILTED SHADOWED WHITE RIGHTW" +
	"ARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROWHEAVY LOWER RIGHT-" +
	"SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWAR" +
	"DS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWCURLY LOOPNOT" +
	"CHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWCIRCLED HEAVY WHITE RIGH" +
	"TWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARROWBLACK-FEATHERED SOUTH EAST A" +
	"RROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-FEATHERED NORTH EAST ARROWHEAV" +
	"Y BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLACK-FEATHERED RIGHTWARDS ARROW" +
	"HEAVY BLACK-FEATHERED NORTH EAST ARROWTEARDROP-BARBED RIGHTWARDS ARROWHE" +
	"AVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-TAILED RIGHTWARDS ARROWHEAVY " +
	"WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED RIGHTWARDS ARROWDOUBLE CURLY " +
	"LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE CONTAINING SMALL WHITE TRIANGL" +
	"EPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT S-SHAPED BAG DELIMITERRIGHT S" +
	"-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVERSE SOLIDUS PRECEDING SUBSETS" +
	"UPERSET PRECEDING SOLIDUSVERTICAL BAR WITH HORIZONTAL STROKEMATHEMATICAL" +
	" RISING DIAGONALLONG DIVISIONMATHEMATICAL FALLING DIAGONALSQUARED LOGICA" +
	"L ANDSQUARED LOGICAL ORWHITE DIAMOND WITH CENTRED DOTAND WITH DOTELEMENT" +
	" OF OPENING UPWARDSLOWER RIGHT CORNER WITH DOTUPPER LEFT CORNER WITH DOT" +
	"LEFT OUTER JOINRIGHT OUTER JOINFULL OUTER JOINLARGE UP TACKLARGE DOWN TA" +
	"CKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND RIGHT TACKLEFT MULTIMAPLONG RI" +
	"GHT TACKLONG LEFT TACKUP TACK WITH CIRCLE ABOVELOZENGE DIVIDED BY HORIZO" +
	"NTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE CONCAVE-SIDED DIAMOND WITH LEF" +
	"TWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICKWHITE SQUARE " +
	"WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTWARDS TICKMATHEMATICAL LEFT WH") + ("" +
	"ITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE SQUARE BRACKETMATHEMATICAL LE" +
	"FT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BRACKETMATHEMATICAL LEFT DOUBLE" +
	" ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANGLE BRACKETMATHEMATICAL LEFT W" +
	"HITE TORTOISE SHELL BRACKETMATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACK" +
	"ETMATHEMATICAL LEFT FLATTENED PARENTHESISMATHEMATICAL RIGHT FLATTENED PA" +
	"RENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS QUADRUPLE ARROWANTICLOCKWISE G" +
	"APPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE ARROWRIGHT ARROW WITH CIRCLED " +
	"PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARROWLONG LEFT RIGHT ARROWLONG L" +
	"EFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE ARROWLONG LEFT RIGHT DOUBLE " +
	"ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGHTWARDS ARROW FROM BARLONG LEF" +
	"TWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS DOUBLE ARROW FROM BARLONG RI" +
	"GHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLANKBRAILLE PATTERN DOTS-1BRAILL" +
	"E PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAILLE PATTERN DOTS-3BRAILLE PAT" +
	"TERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE PATTERN DOTS-123BRAILLE PATTE" +
	"RN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PATTERN DOTS-24BRAILLE PATTERN D" +
	"OTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTERN DOTS-134BRAILLE PATTERN DO" +
	"TS-234BRAILLE PATTERN DOTS-1234BRAILLE PATTERN DOTS-5BRAILLE PATTERN DOT" +
	"S-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN DOTS-125BRAILLE PATTERN DOTS-" +
	"35BRAILLE PATTERN DOTS-135BRAILLE PATTERN DOTS-235BRAILLE PATTERN DOTS-1" +
	"235BRAILLE PATTERN DOTS-45BRAILLE PATTERN DOTS-145BRAILLE PATTERN DOTS-2" +
	"45BRAILLE PATTERN DOTS-1245BRAILLE PATTERN DOTS-345BRAILLE PATTERN DOTS-" +
	"1345BRAILLE PATTERN DOTS-2345BRAILLE PATTERN DOTS-12345BRAILLE PATTERN D" +
	"OTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN DOTS-26BRAILLE PATTERN DOTS-" +
	"126BRAILLE PATTERN DOTS-36BRAILLE PATTERN DOTS-136BRAILLE PATTERN DOTS-2" +
	"36BRAILLE PATTERN DOTS-1236BRAILLE PATTERN DOTS-46BRAILLE PATTERN DOTS-1" +
	"46BRAILLE PATTERN DOTS-246BRAILLE PATTERN DOTS-1246BRAILLE PATTERN DOTS-" +
	"346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN DOTS-2346BRAILLE PATTERN DOT" +
	"S-12346BRAILLE PATTERN DOTS-56BRAILLE PATTERN DOTS-156BRAILLE PATTERN DO" +
	"TS-256BRAILLE PATTERN DOTS-1256BRAILLE PATTERN DOTS-356BRAILLE PATTERN D" +
	"OTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PATTERN DOTS-12356BRAILLE PATTE" +
	"RN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE PATTERN DOTS-2456BRAILLE PAT" +
	"TERN DOTS-12456BRAILLE PATTERN DOTS-3456BRAILLE PATTERN DOTS-13456BRAILL" +
	"E PATTERN DOTS-23456BRAILLE PATTERN DOTS-123456BRAILLE PATTERN DOTS-7BRA" +
	"ILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27BRAILLE PATTERN DOTS-127BRAIL" +
	"LE PATTERN DOTS-37BRAILLE PATTERN DOTS-137BRAILLE PATTERN DOTS-237BRAILL" +
	"E PATTERN DOTS-1237BRAILLE PATTERN DOTS-47BRAILLE PATTERN DOTS-147BRAILL" +
	"E PATTERN DOTS-247BRAILLE PATTERN DOTS-1247BRAILLE PATTERN DOTS-347BRAIL" +
	"LE PATTERN DOTS-1347BRAILLE PATTERN DOTS-2347BRAILLE PATTERN DOTS-12347B" +
	"RAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-157BRAILLE PATTERN DOTS-257BR" +
	"AILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS-357BRAILLE PATTERN DOTS-1357" +
	"BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DOTS-12357BRAILLE PATTERN DOTS-" +
	"457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN DOTS-2457BRAILLE PATTERN DOT" +
	"S-12457BRAILLE PATTERN DOTS-3457BRAILLE PATTERN DOTS-13457BRAILLE PATTER" +
	"N DOTS-23457BRAILLE PATTERN DOTS-123457BRAILLE PATTERN DOTS-67BRAILLE PA" +
	"TTERN DOTS-167BRAILLE PATTERN DOTS-267BRAILLE PATTERN DOTS-1267BRAILLE P" +
	"ATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRAILLE PATTERN DOTS-2367BRAILLE" +
	" PATTERN DOTS-12367BRAILLE PATTERN DOTS-467BRAILLE PATTERN DOTS-1467BRAI" +
	"LLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-12467BRAILLE PATTERN DOTS-3467" +
	"BRAILLE PATTERN DOTS-13467BRAILLE PATTERN DOTS-23467BRAILLE PATTERN DOTS" +
	"-123467BRAILLE PATTERN DOTS-567BRAILLE PATTERN DOTS-1567BRAILLE PATTERN " +
	"DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE PATTERN DOTS-3567BRAILLE PATT" +
	"ERN DOTS-13567BRAILLE PATTERN DOTS-23567BRAILLE PATTERN DOTS-123567BRAIL" +
	"LE PATTERN DOTS-4567BRAILLE PATTERN DOTS-14567BRAILLE PATTERN DOTS-24567" +
	"BRAILLE PATTERN DOTS-124567BRAILLE PATTERN DOTS-34567BRAILLE PATTERN DOT" +
	"S-134567BRAILLE PATTERN DOTS-234567BRAILLE PATTERN DOTS-1234567BRAILLE P" +
	"ATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE PATTERN DOTS-28BRAILLE PATTE" +
	"RN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE PATTERN DOTS-138BRAILLE PATTER" +
	"N DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE PATTERN DOTS-48BRAILLE PATTER" +
	"N DOTS-148BRAILLE PATTERN DOTS-248BRAILLE PATTERN DOTS-1248BRAILLE PATTE" +
	"RN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE PATTERN DOTS-2348BRAILLE PAT" +
	"TERN DOTS-12348BRAILLE PATTERN DOTS-58BRAILLE PATTERN DOTS-158BRAILLE PA" +
	"TTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAILLE PATTERN DOTS-358BRAILLE P" +
	"ATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BRAILLE PATTERN DOTS-12358BRAIL" +
	"LE PATTERN DOTS-458BRAILLE PATTERN DOTS-1458BRAILLE PATTERN DOTS-2458BRA") + ("" +
	"ILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS-3458BRAILLE PATTERN DOTS-134" +
	"58BRAILLE PATTERN DOTS-23458BRAILLE PATTERN DOTS-123458BRAILLE PATTERN D" +
	"OTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTERN DOTS-268BRAILLE PATTERN DO" +
	"TS-1268BRAILLE PATTERN DOTS-368BRAILLE PATTERN DOTS-1368BRAILLE PATTERN " +
	"DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE PATTERN DOTS-468BRAILLE PATTE" +
	"RN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILLE PATTERN DOTS-12468BRAILLE P" +
	"ATTERN DOTS-3468BRAILLE PATTERN DOTS-13468BRAILLE PATTERN DOTS-23468BRAI" +
	"LLE PATTERN DOTS-123468BRAILLE PATTERN DOTS-568BRAILLE PATTERN DOTS-1568" +
	"BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DOTS-12568BRAILLE PATTERN DOTS-" +
	"3568BRAILLE PATTERN DOTS-13568BRAILLE PATTERN DOTS-23568BRAILLE PATTERN " +
	"DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE PATTERN DOTS-14568BRAILLE PA" +
	"TTERN DOTS-24568BRAILLE PATTERN DOTS-124568BRAILLE PATTERN DOTS-34568BRA" +
	"ILLE PATTERN DOTS-134568BRAILLE PATTERN DOTS-234568BRAILLE PATTERN DOTS-" +
	"1234568BRAILLE PATTERN DOTS-78BRAILLE PATTERN DOTS-178BRAILLE PATTERN DO" +
	"TS-278BRAILLE PATTERN DOTS-1278BRAILLE PATTERN DOTS-378BRAILLE PATTERN D" +
	"OTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PATTERN DOTS-12378BRAILLE PATTE" +
	"RN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE PATTERN DOTS-2478BRAILLE PAT" +
	"TERN DOTS-12478BRAILLE PATTERN DOTS-3478BRAILLE PATTERN DOTS-13478BRAILL" +
	"E PATTERN DOTS-23478BRAILLE PATTERN DOTS-123478BRAILLE PATTERN DOTS-578B" +
	"RAILLE PATTERN DOTS-1578BRAILLE PATTERN DOTS-2578BRAILLE PATTERN DOTS-12" +
	"578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN DOTS-13578BRAILLE PATTERN DO" +
	"TS-23578BRAILLE PATTERN DOTS-123578BRAILLE PATTERN DOTS-4578BRAILLE PATT" +
	"ERN DOTS-14578BRAILLE PATTERN DOTS-24578BRAILLE PATTERN DOTS-124578BRAIL" +
	"LE PATTERN DOTS-34578BRAILLE PATTERN DOTS-134578BRAILLE PATTERN DOTS-234" +
	"578BRAILLE PATTERN DOTS-1234578BRAILLE PATTERN DOTS-678BRAILLE PATTERN D" +
	"OTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PATTERN DOTS-12678BRAILLE PATTE" +
	"RN DOTS-3678BRAILLE PATTERN DOTS-13678BRAILLE PATTERN DOTS-23678BRAILLE " +
	"PATTERN DOTS-123678BRAILLE PATTERN DOTS-4678BRAILLE PATTERN DOTS-14678BR" +
	"AILLE PATTERN DOTS-24678BRAILLE PATTERN DOTS-124678BRAILLE PATTERN DOTS-" +
	"34678BRAILLE PATTERN DOTS-134678BRAILLE PATTERN DOTS-234678BRAILLE PATTE" +
	"RN DOTS-1234678BRAILLE PATTERN DOTS-5678BRAILLE PATTERN DOTS-15678BRAILL" +
	"E PATTERN DOTS-25678BRAILLE PATTERN DOTS-125678BRAILLE PATTERN DOTS-3567" +
	"8BRAILLE PATTERN DOTS-135678BRAILLE PATTERN DOTS-235678BRAILLE PATTERN D" +
	"OTS-1235678BRAILLE PATTERN DOTS-45678BRAILLE PATTERN DOTS-145678BRAILLE " +
	"PATTERN DOTS-245678BRAILLE PATTERN DOTS-1245678BRAILLE PATTERN DOTS-3456" +
	"78BRAILLE PATTERN DOTS-1345678BRAILLE PATTERN DOTS-2345678BRAILLE PATTER" +
	"N DOTS-12345678RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKERIGHTWARD" +
	"S TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS DOUBLE ARROW WIT" +
	"H VERTICAL STROKERIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKELEFT RIGHT " +
	"DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW FROM BARLEF" +
	"TWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUBLE ARROW FROM BARDOWNWARDS AR" +
	"ROW WITH HORIZONTAL STROKEUPWARDS ARROW WITH HORIZONTAL STROKEUPWARDS TR" +
	"IPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS DOUBLE DASH ARROWRIGHTWARDS DO" +
	"UBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWRIGHTWARDS TRIPLE DASH ARROWRI" +
	"GHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTWARDS ARROW WITH DOTTED STEMUP" +
	"WARDS ARROW TO BARDOWNWARDS ARROW TO BARRIGHTWARDS ARROW WITH TAIL WITH " +
	"VERTICAL STROKERIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKERIG" +
	"HTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARDS TWO-HEADED ARROW WITH TAIL " +
	"WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VE" +
	"RTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS ARROW-TAILLEFTWARDS DOUBLE A" +
	"RROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWARDS ARROW TO BLACK DIAMONDRIG" +
	"HTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARROW FROM BAR TO BLACK DIAMONDR" +
	"IGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNORTH WEST AND SOUTH EAST ARROW" +
	"NORTH EAST AND SOUTH WEST ARROWNORTH WEST ARROW WITH HOOKNORTH EAST ARRO" +
	"W WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH WEST ARROW WITH HOOKNORTH WES" +
	"T ARROW AND NORTH EAST ARROWNORTH EAST ARROW AND SOUTH EAST ARROWSOUTH E" +
	"AST ARROW AND SOUTH WEST ARROWSOUTH WEST ARROW AND NORTH WEST ARROWRISIN" +
	"G DIAGONAL CROSSING FALLING DIAGONALFALLING DIAGONAL CROSSING RISING DIA" +
	"GONALSOUTH EAST ARROW CROSSING NORTH EAST ARROWNORTH EAST ARROW CROSSING" +
	" SOUTH EAST ARROWFALLING DIAGONAL CROSSING NORTH EAST ARROWRISING DIAGON" +
	"AL CROSSING SOUTH EAST ARROWNORTH EAST ARROW CROSSING NORTH WEST ARROWNO" +
	"RTH WEST ARROW CROSSING NORTH EAST ARROWWAVE ARROW POINTING DIRECTLY RIG" +
	"HTARROW POINTING RIGHTWARDS THEN CURVING UPWARDSARROW POINTING RIGHTWARD" +
	"S THEN CURVING DOWNWARDSARROW POINTING DOWNWARDS THEN CURVING LEFTWARDSA") + ("" +
	"RROW POINTING DOWNWARDS THEN CURVING RIGHTWARDSRIGHT-SIDE ARC CLOCKWISE " +
	"ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP ARC ANTICLOCKWISE ARROWBOTTOM " +
	"ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE ARROW WITH MINUSTOP ARC ANTICLO" +
	"CKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCULAR CLOCKWISE ARROWLOWER LEFT" +
	" SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKWISE CLOSED CIRCLE ARROWCLOCKW" +
	"ISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROWLEFTW" +
	"ARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHORT RIGHTWARDS ARROW ABOVE LEFT" +
	"WARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOWLEFTWARDS ARROW WITH PLUS BEL" +
	"OWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARROW THROUGH SMALL CIRCLEUPWARDS" +
	" TWO-HEADED ARROW FROM SMALL CIRCLELEFT BARB UP RIGHT BARB DOWN HARPOONL" +
	"EFT BARB DOWN RIGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB LEFT HARPOONU" +
	"P BARB LEFT DOWN BARB RIGHT HARPOONLEFT BARB UP RIGHT BARB UP HARPOONUP " +
	"BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB DOWN RIGHT BARB DOWN HARPOON" +
	"UP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARDS HARPOON WITH BARB UP TO BAR" +
	"RIGHTWARDS HARPOON WITH BARB UP TO BARUPWARDS HARPOON WITH BARB RIGHT TO" +
	" BARDOWNWARDS HARPOON WITH BARB RIGHT TO BARLEFTWARDS HARPOON WITH BARB " +
	"DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOWN TO BARUPWARDS HARPOON WITH " +
	"BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB LEFT TO BARLEFTWARDS HARPOON" +
	" WITH BARB UP FROM BARRIGHTWARDS HARPOON WITH BARB UP FROM BARUPWARDS HA" +
	"RPOON WITH BARB RIGHT FROM BARDOWNWARDS HARPOON WITH BARB RIGHT FROM BAR" +
	"LEFTWARDS HARPOON WITH BARB DOWN FROM BARRIGHTWARDS HARPOON WITH BARB DO" +
	"WN FROM BARUPWARDS HARPOON WITH BARB LEFT FROM BARDOWNWARDS HARPOON WITH" +
	" BARB LEFT FROM BARLEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOO" +
	"N WITH BARB DOWNUPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WI" +
	"TH BARB RIGHTRIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WI" +
	"TH BARB DOWNDOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WI" +
	"TH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WIT" +
	"H BARB UPLEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH " +
	"BARB DOWNRIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BA" +
	"RB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB" +
	" DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASHLEFTWARDS HARPOON WIT" +
	"H BARB DOWN BELOW LONG DASHRIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DA" +
	"SHRIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHUPWARDS HARPOON WITH " +
	"BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHTDOWNWARDS HARPOON WITH" +
	" BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHTRIGHT DOUBLE ARROW WITH" +
	" ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS ARROWTILDE OPERATOR ABOVE RIGH" +
	"TWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE T" +
	"ILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST EQUAL TOLESS-THAN ABOVE LEFTW" +
	"ARDS ARROWLEFTWARDS ARROW THROUGH LESS-THANGREATER-THAN ABOVE RIGHTWARDS" +
	" ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW THROUGH SUBSETSUPERSE" +
	"T ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT FISH TAILUP FISH TAILDOWN FIS" +
	"H TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATION SPOTZ NOTATION TYPE COLONL" +
	"EFT WHITE CURLY BRACKETRIGHT WHITE CURLY BRACKETLEFT WHITE PARENTHESISRI" +
	"GHT WHITE PARENTHESISZ NOTATION LEFT IMAGE BRACKETZ NOTATION RIGHT IMAGE" +
	" BRACKETZ NOTATION LEFT BINDING BRACKETZ NOTATION RIGHT BINDING BRACKETL" +
	"EFT SQUARE BRACKET WITH UNDERBARRIGHT SQUARE BRACKET WITH UNDERBARLEFT S" +
	"QUARE BRACKET WITH TICK IN TOP CORNERRIGHT SQUARE BRACKET WITH TICK IN B" +
	"OTTOM CORNERLEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNERRIGHT SQUARE B" +
	"RACKET WITH TICK IN TOP CORNERLEFT ANGLE BRACKET WITH DOTRIGHT ANGLE BRA" +
	"CKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGHT ARC GREATER-THAN BRACKETDOU" +
	"BLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIGHT ARC LESS-THAN BRACKETLEFT " +
	"BLACK TORTOISE SHELL BRACKETRIGHT BLACK TORTOISE SHELL BRACKETDOTTED FEN" +
	"CEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENING LEFTRIGHT ANGLE VARIANT WIT" +
	"H SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE WITH S INSIDEACUTE ANGLESPHER" +
	"ICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPENING UPTURNED ANGLEREVERSED AN" +
	"GLEANGLE WITH UNDERBARREVERSED ANGLE WITH UNDERBAROBLIQUE ANGLE OPENING " +
	"UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW" +
	" POINTING UP AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINT" +
	"ING UP AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOW" +
	"N AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AN" +
	"D LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP" +
	"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UPMEASURE" +
	"D ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWNMEASURED AN" +
	"GLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWNREVERSED EMPTY S") + ("" +
	"ETEMPTY SET WITH OVERBAREMPTY SET WITH SMALL CIRCLE ABOVEEMPTY SET WITH " +
	"RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW ABOVECIRCLE WITH HORIZONTAL B" +
	"ARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCLED REVERSE SOLIDUSCIRCLED PER" +
	"PENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTI" +
	"CAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED ANTICLOCKWISE-ROTATED DIVISION " +
	"SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BULLETCIRCLED BULLETCIRCLED LES" +
	"S-THANCIRCLED GREATER-THANCIRCLE WITH SMALL CIRCLE TO THE RIGHTCIRCLE WI" +
	"TH TWO HORIZONTAL STROKES TO THE RIGHTSQUARED RISING DIAGONAL SLASHSQUAR" +
	"ED FALLING DIAGONAL SLASHSQUARED ASTERISKSQUARED SMALL CIRCLESQUARED SQU" +
	"ARETWO JOINED SQUARESTRIANGLE WITH DOT ABOVETRIANGLE WITH UNDERBARS IN T" +
	"RIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT TRIANGLE ABOVE LEFT TRIANGLEL" +
	"EFT TRIANGLE BESIDE VERTICAL BARVERTICAL BAR BESIDE RIGHT TRIANGLEBOWTIE" +
	" WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF BLACKBLACK BOWTIETIMES WITH " +
	"LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKWHITE HOURGLASSBLACK HOURGLASS" +
	"LEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOUBLE WIGGLY FENCERIGHT DOUBLE " +
	"WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INFINITYINFINITY NEGATED WITH VE" +
	"RTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH CONTOURED OUTLINEINCREASES AS" +
	"SHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARALLELEQUALS SIGN AND SLANTED P" +
	"ARALLEL WITH TILDE ABOVEIDENTICAL TO AND SLANTED PARALLELGLEICH STARKTHE" +
	"RMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT HALF BLACKDOWN-POINTING TRIAN" +
	"GLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH DOWN ARROWBLACK LOZENGEWHITE" +
	" CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DOWN ARROWERROR-BARRED WHITE SQ" +
	"UAREERROR-BARRED BLACK SQUAREERROR-BARRED WHITE DIAMONDERROR-BARRED BLAC" +
	"K DIAMONDERROR-BARRED WHITE CIRCLEERROR-BARRED BLACK CIRCLERULE-DELAYEDR" +
	"EVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBARREVERSE SOLIDUS WITH HORIZONT" +
	"AL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUBLE PLUSTRIPLE PLUSLEFT-POINTI" +
	"NG CURVED ANGLE BRACKETRIGHT-POINTING CURVED ANGLE BRACKETTINYMINYN-ARY " +
	"CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPERATORN-ARY CIRCLED TIMES OPERA" +
	"TORN-ARY UNION OPERATOR WITH DOTN-ARY UNION OPERATOR WITH PLUSN-ARY SQUA" +
	"RE INTERSECTION OPERATORN-ARY SQUARE UNION OPERATORTWO LOGICAL AND OPERA" +
	"TORTWO LOGICAL OR OPERATORN-ARY TIMES OPERATORMODULO TWO SUMSUMMATION WI" +
	"TH INTEGRALQUADRUPLE INTEGRAL OPERATORFINITE PART INTEGRALINTEGRAL WITH " +
	"DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIRCULATION FUNCTIONANTICLOCKWIS" +
	"E INTEGRATIONLINE INTEGRATION WITH RECTANGULAR PATH AROUND POLELINE INTE" +
	"GRATION WITH SEMICIRCULAR PATH AROUND POLELINE INTEGRATION NOT INCLUDING" +
	" THE POLEINTEGRAL AROUND A POINT OPERATORQUATERNION INTEGRAL OPERATORINT" +
	"EGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRAL WITH TIMES SIGNINTEGRAL WIT" +
	"H INTERSECTIONINTEGRAL WITH UNIONINTEGRAL WITH OVERBARINTEGRAL WITH UNDE" +
	"RBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTATION SCHEMA COMPOSITIONZ NOTAT" +
	"ION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTIONPLUS SIGN WITH SMALL CIRCLE" +
	" ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOVEPLUS SIGN WITH TILDE ABOVEPL" +
	"US SIGN WITH DOT BELOWPLUS SIGN WITH TILDE BELOWPLUS SIGN WITH SUBSCRIPT" +
	" TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN WITH COMMA ABOVEMINUS SIGN W" +
	"ITH DOT BELOWMINUS SIGN WITH FALLING DOTSMINUS SIGN WITH RISING DOTSPLUS" +
	" SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT HALF CIRCLEVECTOR OR CROSS P" +
	"RODUCTMULTIPLICATION SIGN WITH DOT ABOVEMULTIPLICATION SIGN WITH UNDERBA" +
	"RSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH PRODUCTMULTIPLICATION SIGN I" +
	"N LEFT HALF CIRCLEMULTIPLICATION SIGN IN RIGHT HALF CIRCLECIRCLED MULTIP" +
	"LICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPLICATION SIGN IN DOUBLE CIRCLE" +
	"CIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEMINUS SIGN IN TRIANGLEMULTIPLI" +
	"CATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGHTHAND INTERIOR PRODUCTZ NOTAT" +
	"ION RELATIONAL COMPOSITIONAMALGAMATION OR COPRODUCTINTERSECTION WITH DOT" +
	"UNION WITH MINUS SIGNUNION WITH OVERBARINTERSECTION WITH OVERBARINTERSEC" +
	"TION WITH LOGICAL ANDUNION WITH LOGICAL ORUNION ABOVE INTERSECTIONINTERS" +
	"ECTION ABOVE UNIONUNION ABOVE BAR ABOVE INTERSECTIONINTERSECTION ABOVE B" +
	"AR ABOVE UNIONUNION BESIDE AND JOINED WITH UNIONINTERSECTION BESIDE AND " +
	"JOINED WITH INTERSECTIONCLOSED UNION WITH SERIFSCLOSED INTERSECTION WITH" +
	" SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQUARE UNIONCLOSED UNION WITH SE" +
	"RIFS AND SMASH PRODUCTLOGICAL AND WITH DOT ABOVELOGICAL OR WITH DOT ABOV" +
	"EDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INTERSECTING LOGICAL ANDTWO INTE" +
	"RSECTING LOGICAL ORSLOPING LARGE ORSLOPING LARGE ANDLOGICAL OR OVERLAPPI" +
	"NG LOGICAL ANDLOGICAL AND WITH MIDDLE STEMLOGICAL OR WITH MIDDLE STEMLOG" +
	"ICAL AND WITH HORIZONTAL DASHLOGICAL OR WITH HORIZONTAL DASHLOGICAL AND " +
	"WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBARLOGICAL AND WITH DOUBLE UNDE") + ("" +
	"RBARSMALL VEE WITH UNDERBARLOGICAL OR WITH DOUBLE OVERBARLOGICAL OR WITH" +
	" DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTRICTIONZ NOTATION RANGE ANTIRE" +
	"STRICTIONEQUALS SIGN WITH DOT BELOWIDENTICAL WITH DOT ABOVETRIPLE HORIZO" +
	"NTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE HORIZONTAL BAR WITH TRIPLE VE" +
	"RTICAL STROKETILDE OPERATOR WITH DOT ABOVETILDE OPERATOR WITH RISING DOT" +
	"SSIMILAR MINUS SIMILARCONGRUENT WITH DOT ABOVEEQUALS WITH ASTERISKALMOST" +
	" EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATELY EQUAL OR EQUAL TOEQUALS SI" +
	"GN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SIGNEQUALS SIGN ABOVE TILDE OPE" +
	"RATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUALS SIGNSTHREE CONSECUTIVE EQU" +
	"ALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOWEQUIVALENT WI" +
	"TH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INSIDEGREATER-THAN WITH CIRCLE I" +
	"NSIDELESS-THAN WITH QUESTION MARK ABOVEGREATER-THAN WITH QUESTION MARK A" +
	"BOVELESS-THAN OR SLANTED EQUAL TOGREATER-THAN OR SLANTED EQUAL TOLESS-TH" +
	"AN OR SLANTED EQUAL TO WITH DOT INSIDEGREATER-THAN OR SLANTED EQUAL TO W" +
	"ITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVEGREATER-THAN O" +
	"R SLANTED EQUAL TO WITH DOT ABOVELESS-THAN OR SLANTED EQUAL TO WITH DOT " +
	"ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFTLESS-THAN" +
	" OR APPROXIMATEGREATER-THAN OR APPROXIMATELESS-THAN AND SINGLE-LINE NOT " +
	"EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQUAL TOLESS-THAN AND NOT APPRO" +
	"XIMATEGREATER-THAN AND NOT APPROXIMATELESS-THAN ABOVE DOUBLE-LINE EQUAL " +
	"ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THANLE" +
	"SS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN ABOVE SIMILAR OR EQUALLESS-TH" +
	"AN ABOVE SIMILAR ABOVE GREATER-THANGREATER-THAN ABOVE SIMILAR ABOVE LESS" +
	"-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUALGREATER-THAN AB" +
	"OVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-THAN ABOVE SLANTED EQUAL ABOVE" +
	" GREATER-THAN ABOVE SLANTED EQUALGREATER-THAN ABOVE SLANTED EQUAL ABOVE " +
	"LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL TO OR LESS-THANSLANTED EQUAL " +
	"TO OR GREATER-THANSLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDESLANTED E" +
	"QUAL TO OR GREATER-THAN WITH DOT INSIDEDOUBLE-LINE EQUAL TO OR LESS-THAN" +
	"DOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-LINE SLANTED EQUAL TO OR LESS" +
	"-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATER-THANSIMILAR OR LESS-THANSIM" +
	"ILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGNSIMILAR ABO" +
	"VE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NESTED LESS-THANDOUBLE NESTED GR" +
	"EATER-THANDOUBLE NESTED LESS-THAN WITH UNDERBARGREATER-THAN OVERLAPPING " +
	"LESS-THANGREATER-THAN BESIDE LESS-THANLESS-THAN CLOSED BY CURVEGREATER-T" +
	"HAN CLOSED BY CURVELESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUALGREATER-" +
	"THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMALLER THANLARGER THANSMALLER T" +
	"HAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUALS SIGN WITH BUMPY ABOVEPRECED" +
	"ES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS ABOVE SINGLE-LINE EQUALS SIGNPR" +
	"ECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEEDS ABOVE SINGLE-LINE NOT EQUA" +
	"L TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOVE EQUALS SIGNPRECEDES ABOVE N" +
	"OT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECEDES ABOVE ALMOST EQUAL TOSUCC" +
	"EEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NOT ALMOST EQUAL TOSUCCEEDS ABO" +
	"VE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE SUCCEEDSSUBSET WITH DOTSUPER" +
	"SET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPERSET WITH PLUS SIGN BELOWSUBS" +
	"ET WITH MULTIPLICATION SIGN BELOWSUPERSET WITH MULTIPLICATION SIGN BELOW" +
	"SUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSET OF OR EQUAL TO WITH DOT ABO" +
	"VESUBSET OF ABOVE EQUALS SIGNSUPERSET OF ABOVE EQUALS SIGNSUBSET OF ABOV" +
	"E TILDE OPERATORSUPERSET OF ABOVE TILDE OPERATORSUBSET OF ABOVE ALMOST E" +
	"QUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUBSET OF ABOVE NOT EQUAL TOSUPE" +
	"RSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN BOX OPERATORSQUARE RIGHT OPEN" +
	" BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCLOSED SUBSET OR EQUAL TOCLOSED" +
	" SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETSUPERSET ABOVE SUBSETSUBSET AB" +
	"OVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET BESIDE SUBSETSUPERSET BESIDE A" +
	"ND JOINED BY DASH WITH SUBSETELEMENT OF OPENING DOWNWARDSPITCHFORK WITH " +
	"TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFORKINGSHORT LEFT TACKSHORT DOW" +
	"N TACKSHORT UP TACKPERPENDICULAR WITH SVERTICAL BAR TRIPLE RIGHT TURNSTI" +
	"LEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICAL BAR DOUBLE LEFT TURNSTILEDO" +
	"UBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG DASH FROM LEFT MEMBER OF DOU" +
	"BLE VERTICALSHORT DOWN TACK WITH OVERBARSHORT UP TACK WITH UNDERBARSHORT" +
	" UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN TACKDOUBLE UP TACKDOUBLE STROK" +
	"E NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDOES NOT DIVIDE WITH REVERSED N" +
	"EGATION SLASHVERTICAL LINE WITH CIRCLE ABOVEVERTICAL LINE WITH CIRCLE BE" +
	"LOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH HORIZONTAL STROKEPARALLEL WI") + ("" +
	"TH TILDE OPERATORTRIPLE VERTICAL BAR BINARY RELATIONTRIPLE VERTICAL BAR " +
	"WITH HORIZONTAL STROKETRIPLE COLON OPERATORTRIPLE NESTED LESS-THANTRIPLE" +
	" NESTED GREATER-THANDOUBLE-LINE SLANTED LESS-THAN OR EQUAL TODOUBLE-LINE" +
	" SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOLIDUS BINARY RELATIONLARGE TRI" +
	"PLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPERATORWHITE VERTICAL BARN-ARY " +
	"WHITE VERTICAL BARNORTH EAST WHITE ARROWNORTH WEST WHITE ARROWSOUTH EAST" +
	" WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGHT WHITE ARROWLEFTWARDS BLACK " +
	"ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARROWNORTH EAST BLACK ARROWNORTH" +
	" WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUTH WEST BLACK ARROWLEFT RIGHT " +
	"BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS ARROW WITH TIP DOWNWARDSRIGHTWA" +
	"RDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW WITH TIP DOWNWARDSLEFTWARDS AR" +
	"ROW WITH TIP UPWARDSSQUARE WITH TOP HALF BLACKSQUARE WITH BOTTOM HALF BL" +
	"ACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BLACKSQUARE WITH LOWER LEFT DIA" +
	"GONAL HALF BLACKDIAMOND WITH LEFT HALF BLACKDIAMOND WITH RIGHT HALF BLAC" +
	"KDIAMOND WITH TOP HALF BLACKDIAMOND WITH BOTTOM HALF BLACKDOTTED SQUAREB" +
	"LACK LARGE SQUAREWHITE LARGE SQUAREBLACK VERY SMALL SQUAREWHITE VERY SMA" +
	"LL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE HEXAGONBLACK HEXAGONHORIZONTA" +
	"L BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDIUM DIAMONDWHITE MEDIUM DIAMON" +
	"DBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBLACK SMALL DIAMONDBLACK SMALL " +
	"LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL ELLIPSEWHITE HORIZONTAL ELLIP" +
	"SEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLIPSELEFT ARROW WITH SMALL CIRC" +
	"LETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIRCLED PLUSLONG LEFTWARDS SQUIG" +
	"GLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKELEFTWARDS TWO-HE" +
	"ADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED ARROW FROM BA" +
	"RLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFTWARDS ARROW WITH DOTTED STEML" +
	"EFTWARDS ARROW WITH TAIL WITH VERTICAL STROKELEFTWARDS ARROW WITH TAIL W" +
	"ITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED ARROW WITH TAILLEFTWARDS " +
	"TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKELEFTWARDS TWO-HEADED ARRO" +
	"W WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW THROUGH XWAVE ARR" +
	"OW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE LEFTWARDS ARROWREVERSE TILDE " +
	"OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL" +
	" TORIGHTWARDS ARROW THROUGH GREATER-THANRIGHTWARDS ARROW THROUGH SUPERSE" +
	"TLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRUPLE ARROWREVERSE TILDE OPERAT" +
	"OR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TOT" +
	"ILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABOVE ALMOST EQUAL TO" +
	"LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATORRIGHTWARDS ARROW ABOVE REVER" +
	"SE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED ZIGZAG ARROWSHORT SLANTED NOR" +
	"TH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE MEDIUM STARBLACK SMALL STARWH" +
	"ITE SMALL STARBLACK RIGHT-POINTING PENTAGONWHITE RIGHT-POINTING PENTAGON" +
	"HEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSIDEHEAVY CIRCLE WITH CIRCLE IN" +
	"SIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTED NORTH ARROW WITH HOOKED HEA" +
	"DBACKSLANTED SOUTH ARROW WITH HOOKED TAILSLANTED NORTH ARROW WITH HORIZO" +
	"NTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZONTAL TAILBENT ARROW POINTING" +
	" DOWNWARDS THEN NORTH EASTSHORT BENT ARROW POINTING DOWNWARDS THEN NORTH" +
	" EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIANGLE-HEADED ARROWRIGHTWA" +
	"RDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-HEADED ARROWLEFT RIGHT TRIAN" +
	"GLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARROWNORTH WEST TRIANGLE-HEADED " +
	"ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH EAST TRIANGLE-HEADED ARROWSOU" +
	"TH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIANGLE-HEADED DASHED ARROWUPWAR" +
	"DS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS TRIANGLE-HEADED DASHED ARROWDO" +
	"WNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWISE TRIANGLE-HEADED OPEN CIRCL" +
	"E ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROWLEFTWARDS TRIANGLE" +
	"-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED ARROW TO BARRIGHTWARDS TRIAN" +
	"GLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-HEADED ARROW TO BARNORTH WEST " +
	"TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH" +
	" EAST TRIANGLE-HEADED ARROW TO BARSOUTH WEST TRIANGLE-HEADED ARROW TO BA" +
	"RLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEUPWARDS TR" +
	"IANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKERIGHTWARDS TRIANGLE-HEA" +
	"DED ARROW WITH DOUBLE HORIZONTAL STROKEDOWNWARDS TRIANGLE-HEADED ARROW W" +
	"ITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB KEYVERTICAL TAB KEYLEFTWARDS " +
	"TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIAN" +
	"GLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROWRIGHTWARDS " +
	"TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIA" +
	"NGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROWLEFTWARDS TR") + ("" +
	"IANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE-HEADED PAIRED ARROWSRIGHTWAR" +
	"DS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS TRIANGLE-HEADED PAIRED ARROWSL" +
	"EFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS BLACK CIRCLED WHITE ARROWRIGHT" +
	"WARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BLACK CIRCLED WHITE ARROWANTICL" +
	"OCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADE" +
	"D BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROW" +
	"ANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROWRETURN LEFTRETURN RIGHTN" +
	"EWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS CIRCLING ANTICLOCKWISERIGHTWA" +
	"RDS BLACK ARROWEQUALS SIGN WITH INFINITY ABOVESYMBOL FOR TYPE A ELECTRON" +
	"ICSTHREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEADTHREE-D RIGHT-LIGH" +
	"TED UPWARDS EQUILATERAL ARROWHEADTHREE-D TOP-LIGHTED RIGHTWARDS EQUILATE" +
	"RAL ARROWHEADTHREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEADBLACK L" +
	"EFTWARDS EQUILATERAL ARROWHEADBLACK UPWARDS EQUILATERAL ARROWHEADBLACK R" +
	"IGHTWARDS EQUILATERAL ARROWHEADBLACK DOWNWARDS EQUILATERAL ARROWHEADDOWN" +
	"WARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSDOWNWARDS TRIANGLE-HE" +
	"ADED ARROW WITH LONG TIP RIGHTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH LO" +
	"NG TIP LEFTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSLE" +
	"FTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSRIGHTWARDS TRIANGLE-H" +
	"EADED ARROW WITH LONG TIP UPWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LO" +
	"NG TIP DOWNWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS" +
	"BLACK CURVED DOWNWARDS AND LEFTWARDS ARROWBLACK CURVED DOWNWARDS AND RIG" +
	"HTWARDS ARROWBLACK CURVED UPWARDS AND LEFTWARDS ARROWBLACK CURVED UPWARD" +
	"S AND RIGHTWARDS ARROWBLACK CURVED LEFTWARDS AND UPWARDS ARROWBLACK CURV" +
	"ED RIGHTWARDS AND UPWARDS ARROWBLACK CURVED LEFTWARDS AND DOWNWARDS ARRO" +
	"WBLACK CURVED RIGHTWARDS AND DOWNWARDS ARROWRIBBON ARROW DOWN LEFTRIBBON" +
	" ARROW DOWN RIGHTRIBBON ARROW UP LEFTRIBBON ARROW UP RIGHTRIBBON ARROW L" +
	"EFT UPRIBBON ARROW RIGHT UPRIBBON ARROW LEFT DOWNRIBBON ARROW RIGHT DOWN" +
	"UPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BARUP ARROWHEAD IN A RECTAN" +
	"GLE BOXOVERLAPPING WHITE SQUARESOVERLAPPING WHITE AND BLACK SQUARESOVERL" +
	"APPING BLACK SQUARESBALLOT BOX WITH LIGHT XCIRCLED XCIRCLED BOLD XBLACK " +
	"SQUARE CENTREDBLACK DIAMOND CENTREDTURNED BLACK PENTAGONHORIZONTAL BLACK" +
	" OCTAGONBLACK OCTAGONBLACK MEDIUM UP-POINTING TRIANGLE CENTREDBLACK MEDI" +
	"UM DOWN-POINTING TRIANGLE CENTREDBLACK MEDIUM LEFT-POINTING TRIANGLE CEN" +
	"TREDBLACK MEDIUM RIGHT-POINTING TRIANGLE CENTREDNEPTUNE FORM TWOTOP HALF" +
	" BLACK CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR POINTED BLACK CUSPROTATE" +
	"D LIGHT FOUR POINTED BLACK CUSPWHITE FOUR POINTED CUSPROTATED WHITE FOUR" +
	" POINTED CUSPSQUARE POSITION INDICATORUNCERTAINTY SIGNGROUP MARKPLUTO FO" +
	"RM TWOPLUTO FORM THREEPLUTO FORM FOURPLUTO FORM FIVETRANSPLUTOPROSERPINA" +
	"ASTRAEAHYGIEAPHOLUSNESSUSWHITE MOON SELENABLACK DIAMOND ON CROSSTRUE LIG" +
	"HT MOON ARTACUPIDOHADESZEUSKRONOSAPOLLONADMETOSVULCANUSPOSEIDONLEFT HALF" +
	" BLACK STARRIGHT HALF BLACK STARSTAR WITH LEFT HALF BLACKSTAR WITH RIGHT" +
	" HALF BLACKLEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSUPWARDS TW" +
	"O-HEADED ARROW WITH TRIANGLE ARROWHEADSRIGHTWARDS TWO-HEADED ARROW WITH " +
	"TRIANGLE ARROWHEADSDOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSER" +
	"IS FORM ONEERIS FORM TWOSEDNARUSSIAN ASTROLOGICAL SYMBOL VIGINTILERUSSIA" +
	"N ASTROLOGICAL SYMBOL NOVILERUSSIAN ASTROLOGICAL SYMBOL QUINTILERUSSIAN " +
	"ASTROLOGICAL SYMBOL BINOVILERUSSIAN ASTROLOGICAL SYMBOL SENTAGONRUSSIAN " +
	"ASTROLOGICAL SYMBOL TREDECILEEQUALS SIGN WITH INFINITY BELOWUNITED SYMBO" +
	"LSEPARATED SYMBOLDOUBLED SYMBOLPASSED SYMBOLREVERSED RIGHT ANGLEHELLSCHR" +
	"EIBER PAUSE SYMBOLGLAGOLITIC CAPITAL LETTER AZUGLAGOLITIC CAPITAL LETTER" +
	" BUKYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC CAPITAL LETTER GLAGOLIGLAG" +
	"OLITIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL LETTER YESTUGLAGOLITIC CAP" +
	"ITAL LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER DZELOGLAGOLITIC CAPITAL LET" +
	"TER ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGOLITIC CAPITAL LETTER INITIA" +
	"L IZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC CAPITAL LETTER DJERVIGLAGOLI" +
	"TIC CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LETTER LJUDIJEGLAGOLITIC CAPIT" +
	"AL LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NASHIGLAGOLITIC CAPITAL LETTE" +
	"R ONUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLITIC CAPITAL LETTER RITSIGLAG" +
	"OLITIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL LETTER TVRIDOGLAGOLITIC CA" +
	"PITAL LETTER UKUGLAGOLITIC CAPITAL LETTER FRITUGLAGOLITIC CAPITAL LETTER" +
	" HERUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC CAPITAL LETTER PEGLAGOLITIC" +
	" CAPITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER TSIGLAGOLITIC CAPITAL LETT" +
	"ER CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLITIC CAPITAL LETTER YERUGLAG" +
	"OLITIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL LETTER YATIGLAGOLITIC CAPIT") + ("" +
	"AL LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER YUGLAGOLITIC CAPITAL LETTE" +
	"R SMALL YUSGLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAILGLAGOLITIC CAPIT" +
	"AL LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED SMALL YUSGLAGOLITIC CAPITA" +
	"L LETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOTATED BIG YUSGLAGOLITIC CAPI" +
	"TAL LETTER FITAGLAGOLITIC CAPITAL LETTER IZHITSAGLAGOLITIC CAPITAL LETTE" +
	"R SHTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI AGLAGOLITIC CAPITAL LETTER" +
	" LATINATE MYSLITEGLAGOLITIC CAPITAL LETTER CAUDATE CHRIVIGLAGOLITIC SMAL" +
	"L LETTER AZUGLAGOLITIC SMALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAG" +
	"OLITIC SMALL LETTER GLAGOLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL" +
	" LETTER YESTUGLAGOLITIC SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZEL" +
	"OGLAGOLITIC SMALL LETTER ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SM" +
	"ALL LETTER INITIAL IZHEGLAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER " +
	"DJERVIGLAGOLITIC SMALL LETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLI" +
	"TIC SMALL LETTER MYSLITEGLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LE" +
	"TTER ONUGLAGOLITIC SMALL LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGO" +
	"LITIC SMALL LETTER SLOVOGLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL L" +
	"ETTER UKUGLAGOLITIC SMALL LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOL" +
	"ITIC SMALL LETTER OTUGLAGOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER S" +
	"HTAGLAGOLITIC SMALL LETTER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC S" +
	"MALL LETTER SHAGLAGOLITIC SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIG" +
	"LAGOLITIC SMALL LETTER YATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC " +
	"SMALL LETTER YUGLAGOLITIC SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER " +
	"SMALL YUS WITH TAILGLAGOLITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOT" +
	"ATED SMALL YUSGLAGOLITIC SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOT" +
	"ATED BIG YUSGLAGOLITIC SMALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAG" +
	"LAGOLITIC SMALL LETTER SHTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOL" +
	"ITIC SMALL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LETTER CAUDATE CHRIVI" +
	"LATIN CAPITAL LETTER L WITH DOUBLE BARLATIN SMALL LETTER L WITH DOUBLE B" +
	"ARLATIN CAPITAL LETTER L WITH MIDDLE TILDELATIN CAPITAL LETTER P WITH ST" +
	"ROKELATIN CAPITAL LETTER R WITH TAILLATIN SMALL LETTER A WITH STROKELATI" +
	"N SMALL LETTER T WITH DIAGONAL STROKELATIN CAPITAL LETTER H WITH DESCEND" +
	"ERLATIN SMALL LETTER H WITH DESCENDERLATIN CAPITAL LETTER K WITH DESCEND" +
	"ERLATIN SMALL LETTER K WITH DESCENDERLATIN CAPITAL LETTER Z WITH DESCEND" +
	"ERLATIN SMALL LETTER Z WITH DESCENDERLATIN CAPITAL LETTER ALPHALATIN CAP" +
	"ITAL LETTER M WITH HOOKLATIN CAPITAL LETTER TURNED ALATIN CAPITAL LETTER" +
	" TURNED ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLATIN CAPITAL LETTER W " +
	"WITH HOOKLATIN SMALL LETTER W WITH HOOKLATIN SMALL LETTER V WITH CURLLAT" +
	"IN CAPITAL LETTER HALF HLATIN SMALL LETTER HALF HLATIN SMALL LETTER TAIL" +
	"LESS PHILATIN SMALL LETTER E WITH NOTCHLATIN SMALL LETTER TURNED R WITH " +
	"TAILLATIN SMALL LETTER O WITH LOW RING INSIDELATIN LETTER SMALL CAPITAL " +
	"TURNED ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETTER CAPITAL VLATIN CAP" +
	"ITAL LETTER S WITH SWASH TAILLATIN CAPITAL LETTER Z WITH SWASH TAILCOPTI" +
	"C CAPITAL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC CAPITAL LETTER VIDAC" +
	"OPTIC SMALL LETTER VIDACOPTIC CAPITAL LETTER GAMMACOPTIC SMALL LETTER GA" +
	"MMACOPTIC CAPITAL LETTER DALDACOPTIC SMALL LETTER DALDACOPTIC CAPITAL LE" +
	"TTER EIECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTER SOUCOPTIC SMALL LET" +
	"TER SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTER ZATACOPTIC CAPITAL " +
	"LETTER HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL LETTER THETHECOPTIC SM" +
	"ALL LETTER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC SMALL LETTER IAUDACOP" +
	"TIC CAPITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPTIC CAPITAL LETTER LAU" +
	"LACOPTIC SMALL LETTER LAULACOPTIC CAPITAL LETTER MICOPTIC SMALL LETTER M" +
	"ICOPTIC CAPITAL LETTER NICOPTIC SMALL LETTER NICOPTIC CAPITAL LETTER KSI" +
	"COPTIC SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTIC SMALL LETTER OCOPTI" +
	"C CAPITAL LETTER PICOPTIC SMALL LETTER PICOPTIC CAPITAL LETTER ROCOPTIC " +
	"SMALL LETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMALL LETTER SIMACOPTIC " +
	"CAPITAL LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAPITAL LETTER UACOPTIC " +
	"SMALL LETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL LETTER FICOPTIC CAPI" +
	"TAL LETTER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL LETTER PSICOPTIC SMA" +
	"LL LETTER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL LETTER OOUCOPTIC CAPI" +
	"TAL LETTER DIALECT-P ALEFCOPTIC SMALL LETTER DIALECT-P ALEFCOPTIC CAPITA" +
	"L LETTER OLD COPTIC AINCOPTIC SMALL LETTER OLD COPTIC AINCOPTIC CAPITAL " +
	"LETTER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOGRAMMIC EIECOPTIC CAPI" +
	"TAL LETTER DIALECT-P KAPACOPTIC SMALL LETTER DIALECT-P KAPACOPTIC CAPITA" +
	"L LETTER DIALECT-P NICOPTIC SMALL LETTER DIALECT-P NICOPTIC CAPITAL LETT") + ("" +
	"ER CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMIC NICOPTIC CAPITAL LE" +
	"TTER OLD COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC OOUCOPTIC CAPITAL LETT" +
	"ER SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LETTER CROSSED SHEICOPTI" +
	"C SMALL LETTER CROSSED SHEICOPTIC CAPITAL LETTER OLD COPTIC SHEICOPTIC S" +
	"MALL LETTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OLD COPTIC ESHCOPTIC SM" +
	"ALL LETTER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHMIMIC KHEICOPTIC SMALL" +
	" LETTER AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-P HORICOPTIC SMALL LE" +
	"TTER DIALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC HORICOPTIC SMALL LET" +
	"TER OLD COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC HACOPTIC SMALL LETTE" +
	"R OLD COPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOPTIC SMALL LETTER L-SH" +
	"APED HACOPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC SMALL LETTER OLD COPTI" +
	"C HEICOPTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMALL LETTER OLD COPTIC " +
	"HATCOPTIC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SMALL LETTER OLD COPTIC" +
	" GANGIACOPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC SMALL LETTER OLD COPTI" +
	"C DJACOPTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC SMALL LETTER OLD COPTI" +
	"C SHIMACOPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC SMALL LETTER OLD NUB" +
	"IAN SHIMACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC SMALL LETTER OLD NUB" +
	"IAN NGICOPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC SMALL LETTER OLD NUBIA" +
	"N NYICOPTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMALL LETTER OLD NUBIAN " +
	"WAUCOPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBOL PI ROCOPTIC SYMBOL " +
	"STAUROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPTIC SYMBOL SHIMA SIMAC" +
	"OPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL LETTER CRYPTOGRAMMIC" +
	" SHEICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPTIC SMALL LETTER CRYPT" +
	"OGRAMMIC GANGIACOPTIC COMBINING NI ABOVECOPTIC COMBINING SPIRITUS ASPERC" +
	"OPTIC COMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER BOHAIRIC KHEICOPTIC " +
	"SMALL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL STOPCOPTIC OLD NUBIAN D" +
	"IRECT QUESTION MARKCOPTIC OLD NUBIAN INDIRECT QUESTION MARKCOPTIC OLD NU" +
	"BIAN VERSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FULL STOPCOPTIC MORPHOL" +
	"OGICAL DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMALL LETTER BANGEORGIAN " +
	"SMALL LETTER GANGEORGIAN SMALL LETTER DONGEORGIAN SMALL LETTER ENGEORGIA" +
	"N SMALL LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN SMALL LETTER TANGEOR" +
	"GIAN SMALL LETTER INGEORGIAN SMALL LETTER KANGEORGIAN SMALL LETTER LASGE" +
	"ORGIAN SMALL LETTER MANGEORGIAN SMALL LETTER NARGEORGIAN SMALL LETTER ON" +
	"GEORGIAN SMALL LETTER PARGEORGIAN SMALL LETTER ZHARGEORGIAN SMALL LETTER" +
	" RAEGEORGIAN SMALL LETTER SANGEORGIAN SMALL LETTER TARGEORGIAN SMALL LET" +
	"TER UNGEORGIAN SMALL LETTER PHARGEORGIAN SMALL LETTER KHARGEORGIAN SMALL" +
	" LETTER GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL LETTER SHINGEORGIAN " +
	"SMALL LETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN SMALL LETTER JILGEORG" +
	"IAN SMALL LETTER CILGEORGIAN SMALL LETTER CHARGEORGIAN SMALL LETTER XANG" +
	"EORGIAN SMALL LETTER JHANGEORGIAN SMALL LETTER HAEGEORGIAN SMALL LETTER " +
	"HEGEORGIAN SMALL LETTER HIEGEORGIAN SMALL LETTER WEGEORGIAN SMALL LETTER" +
	" HARGEORGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER YNGEORGIAN SMALL LETT" +
	"ER AENTIFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH LETTER YABHTIFINAGH " +
	"LETTER YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERBER ACADEMY YAJTIFINAG" +
	"H LETTER YAJTIFINAGH LETTER YADTIFINAGH LETTER YADHTIFINAGH LETTER YADDT" +
	"IFINAGH LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LETTER YAFTIFINAGH LETTE" +
	"R YAKTIFINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKHHTIFINAGH LETTER YAHT" +
	"IFINAGH LETTER BERBER ACADEMY YAHTIFINAGH LETTER TUAREG YAHTIFINAGH LETT" +
	"ER YAHHTIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFINAGH LETTER TUAREG YAK" +
	"HTIFINAGH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFINAGH LETTER YITIFINAGH" +
	" LETTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LETTER TUAREG YAZHTIFIN" +
	"AGH LETTER YALTIFINAGH LETTER YAMTIFINAGH LETTER YANTIFINAGH LETTER TUAR" +
	"EG YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH LETTER YAPTIFINAGH LETTER YUT" +
	"IFINAGH LETTER YARTIFINAGH LETTER YARRTIFINAGH LETTER YAGHTIFINAGH LETTE" +
	"R TUAREG YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETTER YASTIFINAGH LETTER" +
	" YASSTIFINAGH LETTER YASHTIFINAGH LETTER YATTIFINAGH LETTER YATHTIFINAGH" +
	" LETTER YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAVTIFINAGH LETTER YAWTI" +
	"FINAGH LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER TAWELLEMET YAZTIFINA" +
	"GH LETTER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOTIFINAGH MODIFIER LETT" +
	"ER LABIALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAGH CONSONANT JOINERETH" +
	"IOPIC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYLLABLE ROAETHIOPIC SYL" +
	"LABLE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BOAETHIOPIC SYLLABLE TO" +
	"AETHIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC SYLLABLE NYOAETHIOPI" +
	"C SYLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC SYLLABLE DOAETHIOPIC ") + ("" +
	"SYLLABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE THOAETHIOPIC SYLLABL" +
	"E CHOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAETHIOPIC SYLLABLE GGWAE" +
	"THIOPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPIC SYLLABLE GGWEETHIOP" +
	"IC SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLABLE SSIETHIOPIC SYLLAB" +
	"LE SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEETHIOPIC SYLLABLE SSOE" +
	"THIOPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC SYLLABLE CCIETHIOPIC S" +
	"YLLABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE CCEETHIOPIC SYLLABLE" +
	" CCOETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIOPIC SYLLABLE ZZIETHIO" +
	"PIC SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYLLABLE ZZEETHIOPIC SYL" +
	"LABLE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CCHUETHIOPIC SYLLABLE C" +
	"CHIETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEETHIOPIC SYLLABLE CCHEE" +
	"THIOPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC SYLLABLE QYUETHIOPIC " +
	"SYLLABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE QYEEETHIOPIC SYLLABL" +
	"E QYEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHIOPIC SYLLABLE KYUETHI" +
	"OPIC SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYLLABLE KYEEETHIOPIC SY" +
	"LLABLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XYAETHIOPIC SYLLABLE XY" +
	"UETHIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPIC SYLLABLE XYEEETHIOP" +
	"IC SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLABLE GYAETHIOPIC SYLLAB" +
	"LE GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAETHIOPIC SYLLABLE GYEEE" +
	"THIOPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING CYRILLIC LETTER BECOM" +
	"BINING CYRILLIC LETTER VECOMBINING CYRILLIC LETTER GHECOMBINING CYRILLIC" +
	" LETTER DECOMBINING CYRILLIC LETTER ZHECOMBINING CYRILLIC LETTER ZECOMBI" +
	"NING CYRILLIC LETTER KACOMBINING CYRILLIC LETTER ELCOMBINING CYRILLIC LE" +
	"TTER EMCOMBINING CYRILLIC LETTER ENCOMBINING CYRILLIC LETTER OCOMBINING " +
	"CYRILLIC LETTER PECOMBINING CYRILLIC LETTER ERCOMBINING CYRILLIC LETTER " +
	"ESCOMBINING CYRILLIC LETTER TECOMBINING CYRILLIC LETTER HACOMBINING CYRI" +
	"LLIC LETTER TSECOMBINING CYRILLIC LETTER CHECOMBINING CYRILLIC LETTER SH" +
	"ACOMBINING CYRILLIC LETTER SHCHACOMBINING CYRILLIC LETTER FITACOMBINING " +
	"CYRILLIC LETTER ES-TECOMBINING CYRILLIC LETTER ACOMBINING CYRILLIC LETTE" +
	"R IECOMBINING CYRILLIC LETTER DJERVCOMBINING CYRILLIC LETTER MONOGRAPH U" +
	"KCOMBINING CYRILLIC LETTER YATCOMBINING CYRILLIC LETTER YUCOMBINING CYRI" +
	"LLIC LETTER IOTIFIED ACOMBINING CYRILLIC LETTER LITTLE YUSCOMBINING CYRI" +
	"LLIC LETTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFIED BIG YUSRIGHT ANGLE" +
	" SUBSTITUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION MARKERLEFT SUBSTITUT" +
	"ION BRACKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SUBSTITUTION BRACKETRIG" +
	"HT DOTTED SUBSTITUTION BRACKETRAISED INTERPOLATION MARKERRAISED DOTTED I" +
	"NTERPOLATION MARKERDOTTED TRANSPOSITION MARKERLEFT TRANSPOSITION BRACKET" +
	"RIGHT TRANSPOSITION BRACKETRAISED SQUARELEFT RAISED OMISSION BRACKETRIGH" +
	"T RAISED OMISSION BRACKETEDITORIAL CORONISPARAGRAPHOSFORKED PARAGRAPHOSR" +
	"EVERSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOSDOWNWARDS ANCORAUPWAR" +
	"DS ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE HYPHENINVERTED INTERR" +
	"OBANGPALM BRANCHHYPHEN WITH DIAERESISTILDE WITH RING ABOVELEFT LOW PARAP" +
	"HRASE BRACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH DOT ABOVETILDE WITH " +
	"DOT BELOWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL BAR WITH QUILLTOP LE" +
	"FT HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HALF BRACKETBOTTOM RIGH" +
	"T HALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS U BRACKETLEFT DOUBLE" +
	" PARENTHESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER ONE DOT PUNCTUATIONONE" +
	" DOT OVER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNCTUATIONFIVE DOT MARKR" +
	"EVERSED QUESTION MARKVERTICAL TILDERING POINTWORD SEPARATOR MIDDLE DOTTU" +
	"RNED COMMARAISED DOTRAISED COMMATURNED SEMICOLONDAGGER WITH LEFT GUARDDA" +
	"GGER WITH RIGHT GUARDTURNED DAGGERTOP HALF SECTION SIGNTWO-EM DASHTHREE-" +
	"EM DASHSTENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGLY VERTICAL LINECAPITU" +
	"LUMDOUBLE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9 QUOTATION MARKDASH W" +
	"ITH LEFT UPTURNDOUBLE SUSPENSION MARKINVERTED LOW KAVYKAINVERTED LOW KAV" +
	"YKA WITH KAVYKA ABOVELOW KAVYKALOW KAVYKA WITH DOTDOUBLE STACKED COMMADO" +
	"TTED SOLIDUSTRIPLE DAGGERMEDIEVAL COMMAPARAGRAPHUS MARKPUNCTUS ELEVATUS " +
	"MARKCORNISH VERSE DIVIDERCROSS PATTY WITH RIGHT CROSSBARCROSS PATTY WITH" +
	" LEFT CROSSBARTIRONIAN SIGN CAPITAL ETMEDIEVAL EXCLAMATION MARKMEDIEVAL " +
	"QUESTION MARKLEFT SQUARE BRACKET WITH STROKERIGHT SQUARE BRACKET WITH ST" +
	"ROKELEFT SQUARE BRACKET WITH DOUBLE STROKERIGHT SQUARE BRACKET WITH DOUB" +
	"LE STROKETOP HALF LEFT PARENTHESISTOP HALF RIGHT PARENTHESISBOTTOM HALF " +
	"LEFT PARENTHESISBOTTOM HALF RIGHT PARENTHESISOBLIQUE HYPHENCJK RADICAL R" +
	"EPEATCJK RADICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND TWOCJK RA" +
	"DICAL SECOND THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL TABLECJK ") + ("" +
	"RADICAL KNIFE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJK RADICAL " +
	"SEALCJK RADICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME ONECJK RA" +
	"DICAL LAME TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK RADICAL SNA" +
	"KECJK RADICAL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWOCJK RADICA" +
	"L HEART ONECJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RAPCJK RADIC" +
	"AL CHOKECJK RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RADICAL MOTH" +
	"ERCJK RADICAL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER TWOCJK RADI" +
	"CAL FIRECJK RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMPLIFIED HAL" +
	"F TREE TRUNKCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK RADICAL BO" +
	"LT OF CLOTHCJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SPIRIT TWOCJ" +
	"K RADICAL BAMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKCJK RADICAL" +
	" NET ONECJK RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NET FOURCJK " +
	"RADICAL MESHCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK RADICAL O" +
	"LDCJK RADICAL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJK RADICAL " +
	"MORTARCJK RADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GRASS THREEC" +
	"JK RADICAL TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RADICAL WEST " +
	"TWOCJK RADICAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK RADICAL HO" +
	"RNCJK RADICAL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHELLCJK RADIC" +
	"AL FOOTCJK RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WALKCJK RADIC" +
	"AL WALK ONECJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-SIMPLIFIED " +
	"GOLDCJK RADICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMPLIFIED LON" +
	"GCJK RADICAL C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL MOUND TWO" +
	"CJK RADICAL RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNED LEATHERC" +
	"JK RADICAL C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK RADICAL C-S" +
	"IMPLIFIED FLYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL EAT THREE" +
	"CJK RADICAL C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMPLIFIED HOR" +
	"SECJK RADICAL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FISHCJK RADI" +
	"CAL C-SIMPLIFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL SIMPLIFIED" +
	" WHEATCJK RADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FROGCJK RADI" +
	"CAL J-SIMPLIFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL J-SIMPLIFI" +
	"ED TOOTHCJK RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED DRAGONCJK" +
	" RADICAL C-SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SIMPLIFIED T" +
	"URTLECJK RADICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI RADICAL LIN" +
	"EKANGXI RADICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKANGXI RADIC" +
	"AL HOOKKANGXI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANKANGXI RADI" +
	"CAL LEGSKANGXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL DOWN BOXK" +
	"ANGXI RADICAL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGXI RADICAL " +
	"OPEN BOXKANGXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL WRAPKANGX" +
	"I RADICAL SPOONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HIDING ENCLOS" +
	"UREKANGXI RADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL SEALKANGXI " +
	"RADICAL CLIFFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI RADICAL MO" +
	"UTHKANGXI RADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL SCHOLARKAN" +
	"GXI RADICAL GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKANGXI RADIC" +
	"AL BIGKANGXI RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL ROOFKANGXI " +
	"RADICAL INCHKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADICAL CORPSE" +
	"KANGXI RADICAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIVERKANGXI R" +
	"ADICAL WORKKANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI RADICAL DRY" +
	"KANGXI RADICAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI RADICAL LON" +
	"G STRIDEKANGXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RADICAL BOWKA" +
	"NGXI RADICAL SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKANGXI RADICA" +
	"L HEARTKANGXI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL HANDKANGX" +
	"I RADICAL BRANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI RADICAL DI" +
	"PPERKANGXI RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTKANGXI RADI" +
	"CAL SUNKANGXI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TREEKANGXI RA" +
	"DICAL LACKKANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICAL WEAPONKA" +
	"NGXI RADICAL DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKANGXI RADICA" +
	"L CLANKANGXI RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL FIREKANGXI " +
	"RADICAL CLAWKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI RADICAL H" +
	"ALF TREE TRUNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RADICAL COWK" +
	"ANGXI RADICAL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKANGXI RADICA" +
	"L MELONKANGXI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL LIFEKANGXI " +
	"RADICAL USEKANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKANGXI RADICA" +
	"L SICKNESSKANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI RADICAL S" +
	"KINKANGXI RADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKANGXI RADIC") + ("" +
	"AL ARROWKANGXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICAL TRACKKAN" +
	"GXI RADICAL GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI RADICAL B" +
	"AMBOOKANGXI RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARKANGXI RADI" +
	"CAL NETKANGXI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICAL OLDKANGX" +
	"I RADICAL ANDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADICAL BRUSHKA" +
	"NGXI RADICAL MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKANGXI RADICA" +
	"L ARRIVEKANGXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADICAL OPPOSEK" +
	"ANGXI RADICAL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORKANGXI RADI" +
	"CAL GRASSKANGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADICAL BLOODKA" +
	"NGXI RADICAL WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICAL WESTKANG" +
	"XI RADICAL SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI RADICAL VAL" +
	"LEYKANGXI RADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERKANGXI RADI" +
	"CAL SHELLKANGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FOOTKANGXI R" +
	"ADICAL BODYKANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADICAL MORNIN" +
	"GKANGXI RADICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANGXI RADICAL" +
	" DISTINGUISHKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RADICAL LONG" +
	"KANGXI RADICAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKANGXI RADICA" +
	"L SHORT TAILED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGXI RADICAL " +
	"WRONGKANGXI RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL TANNED LEAT" +
	"HERKANGXI RADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFKANGXI RADI" +
	"CAL WINDKANGXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEADKANGXI RA" +
	"DICAL FRAGRANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RADICAL TALL" +
	"KANGXI RADICAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFICIAL WINEKA" +
	"NGXI RADICAL CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKANGXI RADIC" +
	"AL BIRDKANGXI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WHEATKANGXI " +
	"RADICAL HEMPKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI RADICAL BLA" +
	"CKKANGXI RADICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL TRIPODKANGX" +
	"I RADICAL DRUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADICAL EVENKA" +
	"NGXI RADICAL TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKANGXI RADIC" +
	"AL FLUTEIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRAPHIC DESCR" +
	"IPTION CHARACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO" +
	" MIDDLE AND RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND B" +
	"ELOWIDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC DESCRIPTI" +
	"ON CHARACTER SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARACTER SURROU" +
	"ND FROM BELOWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFTIDEOGRA" +
	"PHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC DESCRIPTI" +
	"ON CHARACTER SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER " +
	"SURROUND FROM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVERLAIDIDEOGR" +
	"APHIC DESCRIPTION CHARACTER SURROUND FROM RIGHTIDEOGRAPHIC DESCRIPTION C" +
	"HARACTER SURROUND FROM LOWER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER HORI" +
	"ZONTAL REFLECTIONIDEOGRAPHIC DESCRIPTION CHARACTER ROTATIONIDEOGRAPHIC S" +
	"PACEIDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAPANESE INDUSTRIAL " +
	"STANDARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CLOSING MARKIDEOGRA" +
	"PHIC NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLEFT DOUBLE ANGLE B" +
	"RACKETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGHT CORNER BRACKETL" +
	"EFT WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT BLACK LENTICULAR " +
	"BRACKETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MARKLEFT TORTOISE S" +
	"HELL BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENTICULAR BRACKETRIG" +
	"HT WHITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BRACKETRIGHT WHITE " +
	"TORTOISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WHITE SQUARE BRACKE" +
	"TWAVE DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PRIME QUOTATION MAR" +
	"KLOW DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHOU NUMERAL ONEHANG" +
	"ZHOU NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL FOURHANGZHOU NUME" +
	"RAL FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZHOU NUMERAL EIGHT" +
	"HANGZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRAPHIC RISING TONE " +
	"MARKIDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING TONE MARKHANGUL " +
	"SINGLE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DASHVERTICAL KANA RE" +
	"PEAT MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVERTICAL KANA REPEAT" +
	" MARK UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALFVE" +
	"RTICAL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKIDEOGRAPHIC TELEGRA" +
	"PH LINE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZHOU NUMERAL TWENTY" +
	"HANGZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION MARKMASU MARKPART " +
	"ALTERNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAPHIC HALF FILL SPA" +
	"CEHIRAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETTER SMALL IHIRAGAN") + ("" +
	"A LETTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAGANA LETTER SMALL " +
	"EHIRAGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTER OHIRAGANA LETTE" +
	"R KAHIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER GIHIRAGANA LETTE" +
	"R KUHIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER GEHIRAGANA LETTE" +
	"R KOHIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER ZAHIRAGANA LETTE" +
	"R SIHIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER ZUHIRAGANA LETTE" +
	"R SEHIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER ZOHIRAGANA LETTE" +
	"R TAHIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER DIHIRAGANA LETTE" +
	"R SMALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA LETTER TEHIRAGANA" +
	" LETTER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA LETTER NAHIRAGANA" +
	" LETTER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA LETTER NOHIRAGANA" +
	" LETTER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA LETTER HIHIRAGANA" +
	" LETTER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA LETTER BUHIRAGANA" +
	" LETTER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA LETTER PEHIRAGANA" +
	" LETTER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA LETTER MAHIRAGANA" +
	" LETTER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA LETTER MOHIRAGANA" +
	" LETTER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL YUHIRAGANA LETTE" +
	"R YUHIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA LETTER RAHIRAGANA" +
	" LETTER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA LETTER ROHIRAGANA" +
	" LETTER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIRAGANA LETTER WEHI" +
	"RAGANA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRAGANA LETTER SMALL" +
	" KAHIRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA VOICED SOUND MARK" +
	"COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAKANA-HIRAGANA VOIC" +
	"ED SOUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHIRAGANA ITERATION " +
	"MARKHIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORIKATAKANA-HIRAGANA" +
	" DOUBLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AKATAKANA LETTER SM" +
	"ALL IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA LETTER UKATAKANA L" +
	"ETTER SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKATAKANA LETTER OKA" +
	"TAKANA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKATAKANA LETTER GIKA" +
	"TAKANA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKATAKANA LETTER GEKA" +
	"TAKANA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKATAKANA LETTER ZAKA" +
	"TAKANA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKATAKANA LETTER ZUKA" +
	"TAKANA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKATAKANA LETTER ZOKA" +
	"TAKANA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKATAKANA LETTER DIKA" +
	"TAKANA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER DUKATAKANA LETTE" +
	"R TEKATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER DOKATAKANA LETTE" +
	"R NAKATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER NEKATAKANA LETTE" +
	"R NOKATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER PAKATAKANA LETTE" +
	"R HIKATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER HUKATAKANA LETTE" +
	"R BUKATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER BEKATAKANA LETTE" +
	"R PEKATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER POKATAKANA LETTE" +
	"R MAKATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER MEKATAKANA LETTE" +
	"R MOKATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA LETTER SMALL YUKA" +
	"TAKANA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER YOKATAKANA LETTE" +
	"R RAKATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER REKATAKANA LETTE" +
	"R ROKATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA LETTER WIKATAKANA" +
	" LETTER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA LETTER VUKATAKANA " +
	"LETTER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER VAKATAKANA LETTER" +
	" VIKATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE DOTKATAKANA-HIRAG" +
	"ANA PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA VOICED ITERATION" +
	" MARKKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LETTER PBOPOMOFO LET" +
	"TER MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER TBOPOMOFO LETTER " +
	"NBOPOMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOPOMOFO LETTER HBOP" +
	"OMOFO LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOFO LETTER ZHBOPOMO" +
	"FO LETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO LETTER ZBOPOMOFO" +
	" LETTER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LETTER OBOPOMOFO LET" +
	"TER EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTER EIBOPOMOFO LETT" +
	"ER AUBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTER ENBOPOMOFO LETT" +
	"ER ANGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LETTER IBOPOMOFO LET" +
	"TER UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER NGBOPOMOFO LETTE" +
	"R GNBOPOMOFO LETTER IHBOPOMOFO LETTER O WITH DOT ABOVEBOPOMOFO LETTER NN" +
	"HANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL LETTER KIYEOK-SIOSHA" +
	"NGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LETTER NIEUN-HIEUHHANGU" +
	"L LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTER RIEULHANGUL LETTER") + ("" +
	" RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER RIEUL-PIEUPHANGUL LE" +
	"TTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LETTER RIEUL-PHIEUPHHAN" +
	"GUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETTER PIEUPHANGUL LETTE" +
	"R SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SIOSHANGUL LETTER SSAN" +
	"GSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LETTER SSANGCIEUCHANGU" +
	"L LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER THIEUTHHANGUL LETTER " +
	"PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETTER AEHANGUL LETTER Y" +
	"AHANGUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHANGUL LETTER YEOHANGUL" +
	" LETTER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETTER WAEHANGUL LETTER " +
	"OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHANGUL LETTER WEHANGUL" +
	" LETTER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LETTER YIHANGUL LETTER " +
	"IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER NIEUN-TIKEUTHANGUL L" +
	"ETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LETTER RIEUL-KIYEOK-SI" +
	"OSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEUP-SIOSHANGUL LETTER " +
	"RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL LETTER MIEUM-PIEUPHAN" +
	"GUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANGUL LETTER KAPYEOUNMI" +
	"EUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIKEUTHANGUL LETTER PIE" +
	"UP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL LETTER PIEUP-CIEUCHA" +
	"NGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUPHANGUL LETTER KAPYEO" +
	"UNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER SIOS-NIEUNHANGUL LETT" +
	"ER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER SIOS-CIEUCHANGUL LET" +
	"TER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YESIEUNGHANGUL LETTER Y" +
	"ESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LETTER KAPYEOUNPHIEUPHH" +
	"ANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANGUL LETTER YO-YAHANGU" +
	"L LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YEOHANGUL LETTER YU-YE" +
	"HANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER ARAEAEIDEOGRAPHIC ANN" +
	"OTATION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE MARKIDEOGRAPHIC ANNOT" +
	"ATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRAPHIC ANNOTATION THRE" +
	"E MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC ANNOTATION TOP MARKIDE" +
	"OGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATION BOTTOM MARKIDEOGRA" +
	"PHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SECOND MARKIDEOGRAPHIC " +
	"ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH MARKIDEOGRAPHIC ANNOT" +
	"ATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKIDEOGRAPHIC ANNOTATION" +
	" MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOFO LETTER JIBOPOMOFO " +
	"LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMOFO LETTER OOBOPOMOFO" +
	" LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPOMOFO LETTER INNBOPOM" +
	"OFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGBOPOMOFO LETTER AINNB" +
	"OPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER OMBOPOMOFO LETTER O" +
	"NGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOFO FINAL LETTER TBOPO" +
	"MOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO LETTER GHBOPOMOFO LET" +
	"TER LHBOPOMOFO LETTER ZYBOPOMOFO FINAL LETTER GBOPOMOFO LETTER GWBOPOMOF" +
	"O LETTER KWBOPOMOFO LETTER OEBOPOMOFO LETTER AHCJK STROKE TCJK STROKE WG" +
	"CJK STROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZGCJK " +
	"STROKE HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZPCJK " +
	"STROKE HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK STRO" +
	"KE SCJK STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGCJK S" +
	"TROKE SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STROKE " +
	"PZCJK STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE HZZ" +
	"ZGCJK STROKE PGCJK STROKE QCJK STROKE HXGCJK STROKE SZPIDEOGRAPHIC DESCR" +
	"IPTION CHARACTER SUBTRACTIONKATAKANA LETTER SMALL KUKATAKANA LETTER SMAL" +
	"L SIKATAKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER SMAL" +
	"L NUKATAKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER SMAL" +
	"L HUKATAKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER SMAL" +
	"L MUKATAKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER SMAL" +
	"L RUKATAKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HANGUL" +
	" KIYEOKPARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHESIZE" +
	"D HANGUL RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPARENT" +
	"HESIZED HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIEUCP" +
	"ARENTHESIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED HAN" +
	"GUL THIEUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARENTH" +
	"ESIZED HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGUL T" +
	"IKEUT APARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENTHES" +
	"IZED HANGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IEUNG" +
	" APARENTHESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHESIZE") + ("" +
	"D HANGUL KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL PHI" +
	"EUPH APARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTHESI" +
	"ZED KOREAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHESIZ" +
	"ED IDEOGRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH THREE" +
	"PARENTHESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED ID" +
	"EOGRAPH SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHTPAR" +
	"ENTHESIZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDEOGR" +
	"APH MOONPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARENTH" +
	"ESIZED IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOGRAP" +
	"H EARTHPARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENTHES" +
	"IZED IDEOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOGRAP" +
	"H NAMEPARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIALPA" +
	"RENTHESIZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARENTH" +
	"ESIZED IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED IDEO" +
	"GRAPH STUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH ENTE" +
	"RPRISEPARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANCEPA" +
	"RENTHESIZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZED " +
	"IDEOGRAPH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIONCIR" +
	"CLED IDEOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH KOT" +
	"OCIRCLED NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQUARE" +
	"CIRCLED NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQUAR" +
	"ECIRCLED NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQUAR" +
	"ECIRCLED NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK SQ" +
	"UAREPARTNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TWOCI" +
	"RCLED NUMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWENTY" +
	" FIVECIRCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMBER " +
	"TWENTY EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NUMBE" +
	"R THIRTY ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCLED " +
	"NUMBER THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRCLED" +
	" HANGUL NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL MIE" +
	"UMCIRCLED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED HAN" +
	"GUL CIEUCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL THIE" +
	"UTHCIRCLED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK ACIRC" +
	"LED HANGUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLED H" +
	"ANGUL MIEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGUL I" +
	"EUNG ACIRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KHIEU" +
	"KH ACIRCLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HIEUH" +
	" ACIRCLED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLED H" +
	"ANGUL IEUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOGRAP" +
	"H TWOCIRCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH FIVE" +
	"CIRCLED IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCIRCL" +
	"ED IDEOGRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED IDEO" +
	"GRAPH FIRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGRAPH" +
	" METALCIRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH STOC" +
	"KCIRCLED IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAMECI" +
	"RCLED IDEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH CONG" +
	"RATULATIONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEOGRA" +
	"PH MALECIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEOGRA" +
	"PH EXCELLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED ID" +
	"EOGRAPH ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOGRAP" +
	"H CORRECTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGRAPH" +
	" LOWCIRCLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH MEDIC" +
	"INECIRCLED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH SU" +
	"PERVISECIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED IDE" +
	"OGRAPH ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLED N" +
	"UMBER THIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NINEC" +
	"IRCLED NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCIRCL" +
	"ED NUMBER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FIVEC" +
	"IRCLED NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY EI" +
	"GHTCIRCLED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRAPHI" +
	"C TELEGRAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDEOGR") + ("" +
	"APHIC TELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR OCT" +
	"OBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SYMBO" +
	"L FOR DECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCLED " +
	"KATAKANA ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCLED " +
	"KATAKANA OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCIRCL" +
	"ED KATAKANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA SIC" +
	"IRCLED KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAKANA" +
	" TACIRCLED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED KATA" +
	"KANA TOCIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCLED " +
	"KATAKANA NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HICIRC" +
	"LED KATAKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA MA" +
	"CIRCLED KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATAKAN" +
	"A MOCIRCLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED KAT" +
	"AKANA RACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRCLED" +
	" KATAKANA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WECIR" +
	"CLED KATAKANA WOSQUARE ERA NAME REIWASQUARE APAATOSQUARE ARUHUASQUARE AN" +
	"PEASQUARE AARUSQUARE ININGUSQUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE EE" +
	"KAASQUARE ONSUSQUARE OOMUSQUARE KAIRISQUARE KARATTOSQUARE KARORIISQUARE " +
	"GARONSQUARE GANMASQUARE GIGASQUARE GINIISQUARE KYURIISQUARE GIRUDAASQUAR" +
	"E KIROSQUARE KIROGURAMUSQUARE KIROMEETORUSQUARE KIROWATTOSQUARE GURAMUSQ" +
	"UARE GURAMUTONSQUARE KURUZEIROSQUARE KUROONESQUARE KEESUSQUARE KORUNASQU" +
	"ARE KOOPOSQUARE SAIKURUSQUARE SANTIIMUSQUARE SIRINGUSQUARE SENTISQUARE S" +
	"ENTOSQUARE DAASUSQUARE DESISQUARE DORUSQUARE TONSQUARE NANOSQUARE NOTTOS" +
	"QUARE HAITUSQUARE PAASENTOSQUARE PAATUSQUARE BAARERUSQUARE PIASUTORUSQUA" +
	"RE PIKURUSQUARE PIKOSQUARE BIRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUSSYE" +
	"RUSQUARE HURANSQUARE HEKUTAARUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQUAR" +
	"E PENSUSQUARE PEEZISQUARE BEETASQUARE POINTOSQUARE BORUTOSQUARE HONSQUAR" +
	"E PONDOSQUARE HOORUSQUARE HOONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHASQUA" +
	"RE MARUKUSQUARE MANSYONSQUARE MIKURONSQUARE MIRISQUARE MIRIBAARUSQUARE M" +
	"EGASQUARE MEGATONSQUARE MEETORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQUARE" +
	" RITTORUSQUARE RIRASQUARE RUPIISQUARE RUUBURUSQUARE REMUSQUARE RENTOGENS" +
	"QUARE WATTOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELEGRA" +
	"PH SYMBOL FOR HOUR ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR HOUR THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR " +
	"FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR HOUR EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINEI" +
	"DEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" HOUR ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR HOUR THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR" +
	"TEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR HOUR SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEENIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR HOUR NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR HOUR TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HO" +
	"UR TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOURSQUARE HPASQUARE DASQUARE AUSQUA" +
	"RE BARSQUARE OVSQUARE PCSQUARE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUARE " +
	"IUSQUARE ERA NAME HEISEISQUARE ERA NAME SYOUWASQUARE ERA NAME TAISYOUSQU" +
	"ARE ERA NAME MEIZISQUARE CORPORATIONSQUARE PA AMPSSQUARE NASQUARE MU ASQ" +
	"UARE MASQUARE KASQUARE KBSQUARE MBSQUARE GBSQUARE CALSQUARE KCALSQUARE P" +
	"FSQUARE NFSQUARE MU FSQUARE MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZSQU" +
	"ARE MHZSQUARE GHZSQUARE THZSQUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUARE " +
	"FMSQUARE NMSQUARE MU MSQUARE MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQUARE" +
	" CM SQUAREDSQUARE M SQUAREDSQUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM CUB" +
	"EDSQUARE M CUBEDSQUARE KM CUBEDSQUARE M OVER SSQUARE M OVER S SQUAREDSQU" +
	"ARE PASQUARE KPASQUARE MPASQUARE GPASQUARE RADSQUARE RAD OVER SSQUARE RA" +
	"D OVER S SQUAREDSQUARE PSSQUARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE NV" +
	"SQUARE MU VSQUARE MVSQUARE KVSQUARE MV MEGASQUARE PWSQUARE NWSQUARE MU W" +
	"SQUARE MWSQUARE KWSQUARE MW MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUARE " +
	"BQSQUARE CCSQUARE CDSQUARE C OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE HA" +
	"SQUARE HPSQUARE INSQUARE KKSQUARE KM CAPITALSQUARE KTSQUARE LMSQUARE LNS" +
	"QUARE LOGSQUARE LXSQUARE MB SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE PMS" +
	"QUARE PPMSQUARE PRSQUARE SRSQUARE SVSQUARE WBSQUARE V OVER MSQUARE A OVE") + ("" +
	"R MIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR DAY TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELEGRA" +
	"PH SYMBOL FOR DAY FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR DAY SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVE" +
	"NIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR DAY NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR DAY ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR " +
	"DAY FOURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR DAY SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTE" +
	"ENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH SYM" +
	"BOL FOR DAY NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR DAY TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRAPHI" +
	"C TELEGRAPH SYMBOL FOR DAY TWENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY TWENTY-FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR DAY TWENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY TWENTY-EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR DAY THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY T" +
	"HIRTY-ONESQUARE GALHEXAGRAM FOR THE CREATIVE HEAVENHEXAGRAM FOR THE RECE" +
	"PTIVE EARTHHEXAGRAM FOR DIFFICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTHFUL" +
	" FOLLYHEXAGRAM FOR WAITINGHEXAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYHEXA" +
	"GRAM FOR HOLDING TOGETHERHEXAGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADINGH" +
	"EXAGRAM FOR PEACEHEXAGRAM FOR STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGRAM " +
	"FOR GREAT POSSESSIONHEXAGRAM FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGRAM " +
	"FOR FOLLOWINGHEXAGRAM FOR WORK ON THE DECAYEDHEXAGRAM FOR APPROACHHEXAGR" +
	"AM FOR CONTEMPLATIONHEXAGRAM FOR BITING THROUGHHEXAGRAM FOR GRACEHEXAGRA" +
	"M FOR SPLITTING APARTHEXAGRAM FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRAM F" +
	"OR GREAT TAMINGHEXAGRAM FOR MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDERANC" +
	"EHEXAGRAM FOR THE ABYSMAL WATERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM FO" +
	"R INFLUENCEHEXAGRAM FOR DURATIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREAT P" +
	"OWERHEXAGRAM FOR PROGRESSHEXAGRAM FOR DARKENING OF THE LIGHTHEXAGRAM FOR" +
	" THE FAMILYHEXAGRAM FOR OPPOSITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FOR D" +
	"ELIVERANCEHEXAGRAM FOR DECREASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREAKTH" +
	"ROUGHHEXAGRAM FOR COMING TO MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGRAM " +
	"FOR PUSHING UPWARDHEXAGRAM FOR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRAM F" +
	"OR REVOLUTIONHEXAGRAM FOR THE CAULDRONHEXAGRAM FOR THE AROUSING THUNDERH" +
	"EXAGRAM FOR THE KEEPING STILL MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRAM F" +
	"OR THE MARRYING MAIDENHEXAGRAM FOR ABUNDANCEHEXAGRAM FOR THE WANDERERHEX" +
	"AGRAM FOR THE GENTLE WINDHEXAGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DISPER" +
	"SIONHEXAGRAM FOR LIMITATIONHEXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL PR" +
	"EPONDERANCEHEXAGRAM FOR AFTER COMPLETIONHEXAGRAM FOR BEFORE COMPLETIONYI" +
	" SYLLABLE ITYI SYLLABLE IXYI SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETYI S" +
	"YLLABLE IEXYI SYLLABLE IEYI SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXYI S" +
	"YLLABLE AYI SYLLABLE APYI SYLLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI SY" +
	"LLABLE OTYI SYLLABLE OXYI SYLLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SYLLA" +
	"BLE EYI SYLLABLE WUYI SYLLABLE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYLLAB" +
	"LE BIPYI SYLLABLE BIETYI SYLLABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEPYI " +
	"SYLLABLE BATYI SYLLABLE BAXYI SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE BUOX" +
	"YI SYLLABLE BUOYI SYLLABLE BUOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLABLE" +
	" BOYI SYLLABLE BOPYI SYLLABLE BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLLABL" +
	"E BUTYI SYLLABLE BUXYI SYLLABLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI SYLL" +
	"ABLE BURYI SYLLABLE BYTYI SYLLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI SY" +
	"LLABLE BYRXYI SYLLABLE BYRYI SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE PIYI" +
	" SYLLABLE PIPYI SYLLABLE PIEXYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLABLE " +
	"PATYI SYLLABLE PAXYI SYLLABLE PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYLLAB" +
	"LE PUOYI SYLLABLE PUOPYI SYLLABLE POTYI SYLLABLE POXYI SYLLABLE POYI SYL" +
	"LABLE POPYI SYLLABLE PUTYI SYLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPYI S" +
	"YLLABLE PURXYI SYLLABLE PURYI SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE PYY" +
	"I SYLLABLE PYPYI SYLLABLE PYRXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLABLE" +
	" BBIXYI SYLLABLE BBIYI SYLLABLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIEXYI" +
	" SYLLABLE BBIEYI SYLLABLE BBIEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYLLAB" +
	"LE BBAYI SYLLABLE BBAPYI SYLLABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BBUOP" +
	"YI SYLLABLE BBOTYI SYLLABLE BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYLLAB") + ("" +
	"LE BBEXYI SYLLABLE BBEYI SYLLABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBUXYI" +
	" SYLLABLE BBUYI SYLLABLE BBUPYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLLABL" +
	"E BBYTYI SYLLABLE BBYXYI SYLLABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBITYI " +
	"SYLLABLE NBIXYI SYLLABLE NBIYI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLABLE" +
	" NBIEYI SYLLABLE NBIEPYI SYLLABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBAYI " +
	"SYLLABLE NBAPYI SYLLABLE NBOTYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLABLE " +
	"NBOPYI SYLLABLE NBUTYI SYLLABLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI SY" +
	"LLABLE NBURXYI SYLLABLE NBURYI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLABLE " +
	"NBYYI SYLLABLE NBYPYI SYLLABLE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITYI S" +
	"YLLABLE HMIXYI SYLLABLE HMIYI SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLABLE " +
	"HMIEYI SYLLABLE HMIEPYI SYLLABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAYI S" +
	"YLLABLE HMAPYI SYLLABLE HMUOXYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLLABL" +
	"E HMOTYI SYLLABLE HMOXYI SYLLABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUTYI " +
	"SYLLABLE HMUXYI SYLLABLE HMUYI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLABLE" +
	" HMURYI SYLLABLE HMYXYI SYLLABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRXYI " +
	"SYLLABLE HMYRYI SYLLABLE MITYI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE MIP" +
	"YI SYLLABLE MIEXYI SYLLABLE MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLLABL" +
	"E MAXYI SYLLABLE MAYI SYLLABLE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI SYL" +
	"LABLE MUOYI SYLLABLE MUOPYI SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MOYI " +
	"SYLLABLE MOPYI SYLLABLE MEXYI SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE MUXY" +
	"I SYLLABLE MUYI SYLLABLE MUPYI SYLLABLE MURXYI SYLLABLE MURYI SYLLABLE M" +
	"YTYI SYLLABLE MYXYI SYLLABLE MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLABLE" +
	" FIXYI SYLLABLE FIYI SYLLABLE FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYLLAB" +
	"LE FAYI SYLLABLE FAPYI SYLLABLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SYLLA" +
	"BLE FUTYI SYLLABLE FUXYI SYLLABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI SY" +
	"LLABLE FURYI SYLLABLE FYTYI SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYPYI " +
	"SYLLABLE VITYI SYLLABLE VIXYI SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE VIET" +
	"YI SYLLABLE VIEXYI SYLLABLE VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLLABL" +
	"E VAXYI SYLLABLE VAYI SYLLABLE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SYLLA" +
	"BLE VOYI SYLLABLE VOPYI SYLLABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI SYL" +
	"LABLE VUXYI SYLLABLE VUYI SYLLABLE VUPYI SYLLABLE VURXYI SYLLABLE VURYI " +
	"SYLLABLE VYTYI SYLLABLE VYXYI SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE VYRX" +
	"YI SYLLABLE VYRYI SYLLABLE DITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABLE D" +
	"IPYI SYLLABLE DIEXYI SYLLABLE DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SYLLA" +
	"BLE DAXYI SYLLABLE DAYI SYLLABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI SY" +
	"LLABLE DOTYI SYLLABLE DOXYI SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEXYI " +
	"SYLLABLE DEYI SYLLABLE DEPYI SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE DUYI" +
	" SYLLABLE DUPYI SYLLABLE DURXYI SYLLABLE DURYI SYLLABLE TITYI SYLLABLE T" +
	"IXYI SYLLABLE TIYI SYLLABLE TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLLABL" +
	"E TIEPYI SYLLABLE TATYI SYLLABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI SYLL" +
	"ABLE TUOTYI SYLLABLE TUOXYI SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE TOTY" +
	"I SYLLABLE TOXYI SYLLABLE TOYI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE TE" +
	"YI SYLLABLE TEPYI SYLLABLE TUTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABLE T" +
	"UPYI SYLLABLE TURXYI SYLLABLE TURYI SYLLABLE DDITYI SYLLABLE DDIXYI SYLL" +
	"ABLE DDIYI SYLLABLE DDIPYI SYLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE DDI" +
	"EPYI SYLLABLE DDATYI SYLLABLE DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI SYLL" +
	"ABLE DDUOXYI SYLLABLE DDUOYI SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABLE D" +
	"DOXYI SYLLABLE DDOYI SYLLABLE DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI SYLL" +
	"ABLE DDEPYI SYLLABLE DDUTYI SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE DDUP" +
	"YI SYLLABLE DDURXYI SYLLABLE DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI SYLL" +
	"ABLE NDIYI SYLLABLE NDIPYI SYLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE NDA" +
	"TYI SYLLABLE NDAXYI SYLLABLE NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SYLLA" +
	"BLE NDOXYI SYLLABLE NDOYI SYLLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE NDEYI" +
	" SYLLABLE NDEPYI SYLLABLE NDUTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLABLE" +
	" NDUPYI SYLLABLE NDURXYI SYLLABLE NDURYI SYLLABLE HNITYI SYLLABLE HNIXYI" +
	" SYLLABLE HNIYI SYLLABLE HNIPYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYLLAB" +
	"LE HNIEYI SYLLABLE HNIEPYI SYLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE HNAY" +
	"I SYLLABLE HNAPYI SYLLABLE HNUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SYLLA" +
	"BLE HNOXYI SYLLABLE HNOPYI SYLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HNEPY" +
	"I SYLLABLE HNUTYI SYLLABLE NITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABLE N" +
	"IPYI SYLLABLE NIEXYI SYLLABLE NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SYLLA" +
	"BLE NAYI SYLLABLE NAPYI SYLLABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPYI S" +
	"YLLABLE NOTYI SYLLABLE NOXYI SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NEXYI" +
	" SYLLABLE NEYI SYLLABLE NEPYI SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE NUY") + ("" +
	"I SYLLABLE NUPYI SYLLABLE NURXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLABLE" +
	" HLIXYI SYLLABLE HLIYI SYLLABLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIEYI " +
	"SYLLABLE HLIEPYI SYLLABLE HLATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLABLE" +
	" HLAPYI SYLLABLE HLUOXYI SYLLABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HLOXY" +
	"I SYLLABLE HLOYI SYLLABLE HLOPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLABLE" +
	" HLEPYI SYLLABLE HLUTYI SYLLABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPYI S" +
	"YLLABLE HLURXYI SYLLABLE HLURYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLABLE" +
	" HLYYI SYLLABLE HLYPYI SYLLABLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITYI S" +
	"YLLABLE LIXYI SYLLABLE LIYI SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE LIEX" +
	"YI SYLLABLE LIEYI SYLLABLE LIEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLABLE" +
	" LAYI SYLLABLE LAPYI SYLLABLE LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI SYLL" +
	"ABLE LUOPYI SYLLABLE LOTYI SYLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPYI S" +
	"YLLABLE LEXYI SYLLABLE LEYI SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LUXYI" +
	" SYLLABLE LUYI SYLLABLE LUPYI SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE LY" +
	"TYI SYLLABLE LYXYI SYLLABLE LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLABLE" +
	" LYRYI SYLLABLE GITYI SYLLABLE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYLLAB" +
	"LE GIETYI SYLLABLE GIEXYI SYLLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GATYI " +
	"SYLLABLE GAXYI SYLLABLE GAYI SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE GUO" +
	"XYI SYLLABLE GUOYI SYLLABLE GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLLABL" +
	"E GOYI SYLLABLE GOPYI SYLLABLE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYLLAB" +
	"LE GEPYI SYLLABLE GUTYI SYLLABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI SYLL" +
	"ABLE GURXYI SYLLABLE GURYI SYLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIYI S" +
	"YLLABLE KIPYI SYLLABLE KIEXYI SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE KA" +
	"TYI SYLLABLE KAXYI SYLLABLE KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLABLE" +
	" KUOYI SYLLABLE KUOPYI SYLLABLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SYLLA" +
	"BLE KOPYI SYLLABLE KETYI SYLLABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI SYL" +
	"LABLE KUTYI SYLLABLE KUXYI SYLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURXYI " +
	"SYLLABLE KURYI SYLLABLE GGITYI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABLE G" +
	"GIEXYI SYLLABLE GGIEYI SYLLABLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAXYI " +
	"SYLLABLE GGAYI SYLLABLE GGAPYI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLLABL" +
	"E GGUOYI SYLLABLE GGUOPYI SYLLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GGOYI" +
	" SYLLABLE GGOPYI SYLLABLE GGETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLABLE" +
	" GGEPYI SYLLABLE GGUTYI SYLLABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPYI S" +
	"YLLABLE GGURXYI SYLLABLE GGURYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLLABL" +
	"E MGATYI SYLLABLE MGAXYI SYLLABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUOXYI" +
	" SYLLABLE MGUOYI SYLLABLE MGUOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYLLAB" +
	"LE MGOYI SYLLABLE MGOPYI SYLLABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEPYI " +
	"SYLLABLE MGUTYI SYLLABLE MGUXYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLABLE " +
	"MGURXYI SYLLABLE MGURYI SYLLABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIYI S" +
	"YLLABLE HXIPYI SYLLABLE HXIETYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLLABL" +
	"E HXIEPYI SYLLABLE HXATYI SYLLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXAPYI" +
	" SYLLABLE HXUOTYI SYLLABLE HXUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI SYLL" +
	"ABLE HXOTYI SYLLABLE HXOXYI SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE HXEX" +
	"YI SYLLABLE HXEYI SYLLABLE HXEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SYLLA" +
	"BLE NGIEPYI SYLLABLE NGATYI SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE NGAP" +
	"YI SYLLABLE NGUOTYI SYLLABLE NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI SYL" +
	"LABLE NGOXYI SYLLABLE NGOYI SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE NGE" +
	"YI SYLLABLE NGEPYI SYLLABLE HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLLABL" +
	"E HATYI SYLLABLE HAXYI SYLLABLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI SYLL" +
	"ABLE HUOXYI SYLLABLE HUOYI SYLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HOXYI" +
	" SYLLABLE HOYI SYLLABLE HOPYI SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE HEPY" +
	"I SYLLABLE WATYI SYLLABLE WAXYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE WU" +
	"OXYI SYLLABLE WUOYI SYLLABLE WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLLABL" +
	"E WOPYI SYLLABLE WEXYI SYLLABLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SYLLA" +
	"BLE ZIXYI SYLLABLE ZIYI SYLLABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI SY" +
	"LLABLE ZIEPYI SYLLABLE ZATYI SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZAPYI" +
	" SYLLABLE ZUOXYI SYLLABLE ZUOYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLABLE " +
	"ZOXYI SYLLABLE ZOYI SYLLABLE ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLABLE" +
	" ZEPYI SYLLABLE ZUTYI SYLLABLE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYLLAB" +
	"LE ZURXYI SYLLABLE ZURYI SYLLABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI SYL" +
	"LABLE ZYPYI SYLLABLE ZYRXYI SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CIXYI" +
	" SYLLABLE CIYI SYLLABLE CIPYI SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABLE C" +
	"IEYI SYLLABLE CIEPYI SYLLABLE CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLLABL" +
	"E CAPYI SYLLABLE CUOXYI SYLLABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI SY") + ("" +
	"LLABLE COXYI SYLLABLE COYI SYLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEYI S" +
	"YLLABLE CEPYI SYLLABLE CUTYI SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CUPYI" +
	" SYLLABLE CURXYI SYLLABLE CURYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABLE C" +
	"YYI SYLLABLE CYPYI SYLLABLE CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYLLAB" +
	"LE ZZIXYI SYLLABLE ZZIYI SYLLABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZIEX" +
	"YI SYLLABLE ZZIEYI SYLLABLE ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI SYLL" +
	"ABLE ZZAYI SYLLABLE ZZAPYI SYLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZOPY" +
	"I SYLLABLE ZZEXYI SYLLABLE ZZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLLABL" +
	"E ZZUYI SYLLABLE ZZUPYI SYLLABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZYTYI" +
	" SYLLABLE ZZYXYI SYLLABLE ZZYYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLLABL" +
	"E ZZYRYI SYLLABLE NZITYI SYLLABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIPYI " +
	"SYLLABLE NZIEXYI SYLLABLE NZIEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYLLAB" +
	"LE NZAXYI SYLLABLE NZAYI SYLLABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZUOY" +
	"I SYLLABLE NZOXYI SYLLABLE NZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLLABL" +
	"E NZUXYI SYLLABLE NZUYI SYLLABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZURYI" +
	" SYLLABLE NZYTYI SYLLABLE NZYXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLABLE" +
	" NZYRXYI SYLLABLE NZYRYI SYLLABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI SYL" +
	"LABLE SIPYI SYLLABLE SIEXYI SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE SATY" +
	"I SYLLABLE SAXYI SYLLABLE SAYI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABLE S" +
	"UOYI SYLLABLE SUOPYI SYLLABLE SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLLABL" +
	"E SOPYI SYLLABLE SEXYI SYLLABLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SYLLA" +
	"BLE SUXYI SYLLABLE SUYI SYLLABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI SY" +
	"LLABLE SYTYI SYLLABLE SYXYI SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYRXYI" +
	" SYLLABLE SYRYI SYLLABLE SSITYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLABLE " +
	"SSIPYI SYLLABLE SSIEXYI SYLLABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSATYI" +
	" SYLLABLE SSAXYI SYLLABLE SSAYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLABLE" +
	" SSOXYI SYLLABLE SSOYI SYLLABLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI SY" +
	"LLABLE SSEPYI SYLLABLE SSUTYI SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE SS" +
	"UPYI SYLLABLE SSYTYI SYLLABLE SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI SYLL" +
	"ABLE SSYRXYI SYLLABLE SSYRYI SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE ZH" +
	"AYI SYLLABLE ZHAPYI SYLLABLE ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI SY" +
	"LLABLE ZHOTYI SYLLABLE ZHOXYI SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE ZH" +
	"ETYI SYLLABLE ZHEXYI SYLLABLE ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI SYLL" +
	"ABLE ZHUXYI SYLLABLE ZHUYI SYLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE ZHU" +
	"RYI SYLLABLE ZHYTYI SYLLABLE ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SYLLA" +
	"BLE ZHYRXYI SYLLABLE ZHYRYI SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE CHA" +
	"YI SYLLABLE CHAPYI SYLLABLE CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI SYL" +
	"LABLE CHUOPYI SYLLABLE CHOTYI SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE CH" +
	"OPYI SYLLABLE CHETYI SYLLABLE CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI SYLL" +
	"ABLE CHUXYI SYLLABLE CHUYI SYLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE CHU" +
	"RYI SYLLABLE CHYTYI SYLLABLE CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SYLLA" +
	"BLE CHYRXYI SYLLABLE CHYRYI SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE RRUO" +
	"XYI SYLLABLE RRUOYI SYLLABLE RROTYI SYLLABLE RROXYI SYLLABLE RROYI SYLLA" +
	"BLE RROPYI SYLLABLE RRETYI SYLLABLE RREXYI SYLLABLE RREYI SYLLABLE RREPY" +
	"I SYLLABLE RRUTYI SYLLABLE RRUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLLABL" +
	"E RRURXYI SYLLABLE RRURYI SYLLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RRYYI" +
	" SYLLABLE RRYPYI SYLLABLE RRYRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYLLAB" +
	"LE NRAXYI SYLLABLE NRAYI SYLLABLE NRAPYI SYLLABLE NROXYI SYLLABLE NROYI " +
	"SYLLABLE NROPYI SYLLABLE NRETYI SYLLABLE NREXYI SYLLABLE NREYI SYLLABLE " +
	"NREPYI SYLLABLE NRUTYI SYLLABLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI SY" +
	"LLABLE NRURXYI SYLLABLE NRURYI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLABLE " +
	"NRYYI SYLLABLE NRYPYI SYLLABLE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATYI S" +
	"YLLABLE SHAXYI SYLLABLE SHAYI SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLABLE " +
	"SHUOYI SYLLABLE SHUOPYI SYLLABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOYI S" +
	"YLLABLE SHOPYI SYLLABLE SHETYI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABLE S" +
	"HEPYI SYLLABLE SHUTYI SYLLABLE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI SYL" +
	"LABLE SHURXYI SYLLABLE SHURYI SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABLE S" +
	"HYYI SYLLABLE SHYPYI SYLLABLE SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI SYL" +
	"LABLE RAXYI SYLLABLE RAYI SYLLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUOYI " +
	"SYLLABLE RUOPYI SYLLABLE ROTYI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE ROP" +
	"YI SYLLABLE REXYI SYLLABLE REYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABLE R" +
	"UXYI SYLLABLE RUYI SYLLABLE RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLLABL" +
	"E RYTYI SYLLABLE RYXYI SYLLABLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI SYLL" +
	"ABLE RYRYI SYLLABLE JITYI SYLLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI SY") + ("" +
	"LLABLE JIETYI SYLLABLE JIEXYI SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE JU" +
	"OTYI SYLLABLE JUOXYI SYLLABLE JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SYLLA" +
	"BLE JOXYI SYLLABLE JOYI SYLLABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI SYL" +
	"LABLE JUYI SYLLABLE JUPYI SYLLABLE JURXYI SYLLABLE JURYI SYLLABLE JYTYI " +
	"SYLLABLE JYXYI SYLLABLE JYYI SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE JYR" +
	"YI SYLLABLE QITYI SYLLABLE QIXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABLE Q" +
	"IETYI SYLLABLE QIEXYI SYLLABLE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI SYL" +
	"LABLE QUOXYI SYLLABLE QUOYI SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE QOXY" +
	"I SYLLABLE QOYI SYLLABLE QOPYI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE QU" +
	"YI SYLLABLE QUPYI SYLLABLE QURXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLABLE" +
	" QYXYI SYLLABLE QYYI SYLLABLE QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SYLLA" +
	"BLE JJITYI SYLLABLE JJIXYI SYLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJIET" +
	"YI SYLLABLE JJIEXYI SYLLABLE JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI SY" +
	"LLABLE JJUOYI SYLLABLE JJUOPYI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLABLE " +
	"JJOYI SYLLABLE JJOPYI SYLLABLE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI SYL" +
	"LABLE JJUPYI SYLLABLE JJURXYI SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABLE J" +
	"JYXYI SYLLABLE JJYYI SYLLABLE JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI SYL" +
	"LABLE NJIYI SYLLABLE NJIPYI SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABLE N" +
	"JIEYI SYLLABLE NJIEPYI SYLLABLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOTYI " +
	"SYLLABLE NJOXYI SYLLABLE NJOYI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLABLE " +
	"NJUYI SYLLABLE NJUPYI SYLLABLE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTYI S" +
	"YLLABLE NJYXYI SYLLABLE NJYYI SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLABLE " +
	"NJYRYI SYLLABLE NYITYI SYLLABLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI SY" +
	"LLABLE NYIETYI SYLLABLE NYIEXYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLLABL" +
	"E NYUOXYI SYLLABLE NYUOYI SYLLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE NYOX" +
	"YI SYLLABLE NYOYI SYLLABLE NYOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYLLAB" +
	"LE NYUYI SYLLABLE NYUPYI SYLLABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI SYL" +
	"LABLE XIPYI SYLLABLE XIETYI SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE XIEP" +
	"YI SYLLABLE XUOXYI SYLLABLE XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLABLE" +
	" XOYI SYLLABLE XOPYI SYLLABLE XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLLABL" +
	"E XYPYI SYLLABLE XYRXYI SYLLABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI SYL" +
	"LABLE YIYI SYLLABLE YIPYI SYLLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YIEYI" +
	" SYLLABLE YIEPYI SYLLABLE YUOTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLABLE" +
	" YUOPYI SYLLABLE YOTYI SYLLABLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SYLLA" +
	"BLE YUTYI SYLLABLE YUXYI SYLLABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI SY" +
	"LLABLE YURYI SYLLABLE YYTYI SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYPYI " +
	"SYLLABLE YYRXYI SYLLABLE YYRYI RADICAL QOTYI RADICAL LIYI RADICAL KITYI " +
	"RADICAL NYIPYI RADICAL CYPYI RADICAL SSIYI RADICAL GGOPYI RADICAL GEPYI " +
	"RADICAL MIYI RADICAL HXITYI RADICAL LYRYI RADICAL BBUTYI RADICAL MOPYI R" +
	"ADICAL YOYI RADICAL PUTYI RADICAL HXUOYI RADICAL TATYI RADICAL GAYI RADI" +
	"CAL ZUPYI RADICAL CYTYI RADICAL DDURYI RADICAL BURYI RADICAL GGUOYI RADI" +
	"CAL NYOPYI RADICAL TUYI RADICAL OPYI RADICAL JJUTYI RADICAL ZOTYI RADICA" +
	"L PYTYI RADICAL HMOYI RADICAL YITYI RADICAL VURYI RADICAL SHYYI RADICAL " +
	"VEPYI RADICAL ZAYI RADICAL JOYI RADICAL NZUPYI RADICAL JJYYI RADICAL GOT" +
	"YI RADICAL JJIEYI RADICAL WOYI RADICAL DUYI RADICAL SHURYI RADICAL LIEYI" +
	" RADICAL CYYI RADICAL CUOPYI RADICAL CIPYI RADICAL HXOPYI RADICAL SHATYI" +
	" RADICAL ZURYI RADICAL SHOPYI RADICAL CHEYI RADICAL ZZIETYI RADICAL NBIE" +
	"YI RADICAL KELISU LETTER BALISU LETTER PALISU LETTER PHALISU LETTER DALI" +
	"SU LETTER TALISU LETTER THALISU LETTER GALISU LETTER KALISU LETTER KHALI" +
	"SU LETTER JALISU LETTER CALISU LETTER CHALISU LETTER DZALISU LETTER TSAL" +
	"ISU LETTER TSHALISU LETTER MALISU LETTER NALISU LETTER LALISU LETTER SAL" +
	"ISU LETTER ZHALISU LETTER ZALISU LETTER NGALISU LETTER HALISU LETTER XAL" +
	"ISU LETTER HHALISU LETTER FALISU LETTER WALISU LETTER SHALISU LETTER YAL" +
	"ISU LETTER GHALISU LETTER ALISU LETTER AELISU LETTER ELISU LETTER EULISU" +
	" LETTER ILISU LETTER OLISU LETTER ULISU LETTER UELISU LETTER UHLISU LETT" +
	"ER OELISU LETTER TONE MYA TILISU LETTER TONE NA POLISU LETTER TONE MYA C" +
	"YALISU LETTER TONE MYA BOLISU LETTER TONE MYA NALISU LETTER TONE MYA JEU" +
	"LISU PUNCTUATION COMMALISU PUNCTUATION FULL STOPVAI SYLLABLE EEVAI SYLLA" +
	"BLE EENVAI SYLLABLE HEEVAI SYLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE PEE" +
	"VAI SYLLABLE BHEEVAI SYLLABLE BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVAI S" +
	"YLLABLE MGBEEVAI SYLLABLE GBEEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYLLAB" +
	"LE TEEVAI SYLLABLE THEEVAI SYLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABLE L" +
	"EEVAI SYLLABLE REEVAI SYLLABLE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVAI S" +
	"YLLABLE SHEEVAI SYLLABLE ZEEVAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLLABL") + ("" +
	"E JEEVAI SYLLABLE NJEEVAI SYLLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NGGEE" +
	"VAI SYLLABLE GEEVAI SYLLABLE MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI SYL" +
	"LABLE IVAI SYLLABLE INVAI SYLLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIVAI " +
	"SYLLABLE WINVAI SYLLABLE PIVAI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABLE M" +
	"BIVAI SYLLABLE KPIVAI SYLLABLE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI SY" +
	"LLABLE VIVAI SYLLABLE TIVAI SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE DHH" +
	"IVAI SYLLABLE LIVAI SYLLABLE RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYLLAB" +
	"LE SIVAI SYLLABLE SHIVAI SYLLABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVAI S" +
	"YLLABLE JIVAI SYLLABLE NJIVAI SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE NGG" +
	"IVAI SYLLABLE GIVAI SYLLABLE MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYLLAB" +
	"LE AVAI SYLLABLE ANVAI SYLLABLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVAI S" +
	"YLLABLE WAVAI SYLLABLE WANVAI SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE BA" +
	"VAI SYLLABLE MBAVAI SYLLABLE KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI SY" +
	"LLABLE GBAVAI SYLLABLE FAVAI SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE THAV" +
	"AI SYLLABLE DHAVAI SYLLABLE DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYLLAB" +
	"LE DAVAI SYLLABLE NDAVAI SYLLABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVAI S" +
	"YLLABLE ZHAVAI SYLLABLE CAVAI SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE YA" +
	"VAI SYLLABLE KAVAI SYLLABLE KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SYLLA" +
	"BLE MAVAI SYLLABLE NAVAI SYLLABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONVAI " +
	"SYLLABLE HOOVAI SYLLABLE WOOVAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLLABL" +
	"E BHOOVAI SYLLABLE BOOVAI SYLLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE MGB" +
	"OOVAI SYLLABLE GBOOVAI SYLLABLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVAI S" +
	"YLLABLE THOOVAI SYLLABLE DHOOVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SYLLA" +
	"BLE ROOVAI SYLLABLE DOOVAI SYLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE SHO" +
	"OVAI SYLLABLE ZOOVAI SYLLABLE ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI SY" +
	"LLABLE NJOOVAI SYLLABLE YOOVAI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLLABL" +
	"E GOOVAI SYLLABLE MOOVAI SYLLABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UVAI " +
	"SYLLABLE UNVAI SYLLABLE HUVAI SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE WU" +
	"NVAI SYLLABLE PUVAI SYLLABLE BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SYLLA" +
	"BLE KPUVAI SYLLABLE MGBUVAI SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE VUVA" +
	"I SYLLABLE TUVAI SYLLABLE THUVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYLLAB" +
	"LE LUVAI SYLLABLE RUVAI SYLLABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI SY" +
	"LLABLE SHUVAI SYLLABLE ZUVAI SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE JUV" +
	"AI SYLLABLE NJUVAI SYLLABLE YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYLLAB" +
	"LE GUVAI SYLLABLE MUVAI SYLLABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI SYL" +
	"LABLE ONVAI SYLLABLE NGONVAI SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE WOV" +
	"AI SYLLABLE WONVAI SYLLABLE POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLLABL" +
	"E MBOVAI SYLLABLE KPOVAI SYLLABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GBONV" +
	"AI SYLLABLE FOVAI SYLLABLE VOVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLABLE" +
	" DHOVAI SYLLABLE DHHOVAI SYLLABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI SY" +
	"LLABLE NDOVAI SYLLABLE SOVAI SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE ZHO" +
	"VAI SYLLABLE COVAI SYLLABLE JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLLABL" +
	"E KOVAI SYLLABLE NGGOVAI SYLLABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI SY" +
	"LLABLE NYOVAI SYLLABLE EVAI SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE HEV" +
	"AI SYLLABLE HENVAI SYLLABLE WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLLABL" +
	"E BHEVAI SYLLABLE BEVAI SYLLABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPENVAI" +
	" SYLLABLE MGBEVAI SYLLABLE GBEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYLLAB" +
	"LE VEVAI SYLLABLE TEVAI SYLLABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHEVAI" +
	" SYLLABLE LEVAI SYLLABLE REVAI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABLE S" +
	"EVAI SYLLABLE SHEVAI SYLLABLE ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SYLLA" +
	"BLE JEVAI SYLLABLE NJEVAI SYLLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGEVAI" +
	" SYLLABLE NGGENVAI SYLLABLE GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLLABL" +
	"E NEVAI SYLLABLE NYEVAI SYLLABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVAI F" +
	"ULL STOPVAI QUESTION MARKVAI SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVAI S" +
	"YLLABLE NDOLE SOOVAI SYMBOL FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI SYMB" +
	"OL NIIVAI SYMBOL BANGVAI SYMBOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI SYMB" +
	"OL DOONGVAI SYMBOL KUNGVAI SYMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGVAI " +
	"DIGIT ZEROVAI DIGIT ONEVAI DIGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI DIG" +
	"IT FIVEVAI DIGIT SIXVAI DIGIT SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI SYLL" +
	"ABLE NDOLE MAVAI SYLLABLE NDOLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRILLIC" +
	" SMALL LETTER ZEMLYACYRILLIC CAPITAL LETTER DZELOCYRILLIC SMALL LETTER D" +
	"ZELOCYRILLIC CAPITAL LETTER REVERSED DZECYRILLIC SMALL LETTER REVERSED D" +
	"ZECYRILLIC CAPITAL LETTER IOTACYRILLIC SMALL LETTER IOTACYRILLIC CAPITAL" +
	" LETTER DJERVCYRILLIC SMALL LETTER DJERVCYRILLIC CAPITAL LETTER MONOGRAP") + ("" +
	"H UKCYRILLIC SMALL LETTER MONOGRAPH UKCYRILLIC CAPITAL LETTER BROAD OMEG" +
	"ACYRILLIC SMALL LETTER BROAD OMEGACYRILLIC CAPITAL LETTER NEUTRAL YERCYR" +
	"ILLIC SMALL LETTER NEUTRAL YERCYRILLIC CAPITAL LETTER YERU WITH BACK YER" +
	"CYRILLIC SMALL LETTER YERU WITH BACK YERCYRILLIC CAPITAL LETTER IOTIFIED" +
	" YATCYRILLIC SMALL LETTER IOTIFIED YATCYRILLIC CAPITAL LETTER REVERSED Y" +
	"UCYRILLIC SMALL LETTER REVERSED YUCYRILLIC CAPITAL LETTER IOTIFIED ACYRI" +
	"LLIC SMALL LETTER IOTIFIED ACYRILLIC CAPITAL LETTER CLOSED LITTLE YUSCYR" +
	"ILLIC SMALL LETTER CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER BLENDED YUSC" +
	"YRILLIC SMALL LETTER BLENDED YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOSED " +
	"LITTLE YUSCYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC CAPIT" +
	"AL LETTER YNCYRILLIC SMALL LETTER YNCYRILLIC CAPITAL LETTER REVERSED TSE" +
	"CYRILLIC SMALL LETTER REVERSED TSECYRILLIC CAPITAL LETTER SOFT DECYRILLI" +
	"C SMALL LETTER SOFT DECYRILLIC CAPITAL LETTER SOFT ELCYRILLIC SMALL LETT" +
	"ER SOFT ELCYRILLIC CAPITAL LETTER SOFT EMCYRILLIC SMALL LETTER SOFT EMCY" +
	"RILLIC CAPITAL LETTER MONOCULAR OCYRILLIC SMALL LETTER MONOCULAR OCYRILL" +
	"IC CAPITAL LETTER BINOCULAR OCYRILLIC SMALL LETTER BINOCULAR OCYRILLIC C" +
	"APITAL LETTER DOUBLE MONOCULAR OCYRILLIC SMALL LETTER DOUBLE MONOCULAR O" +
	"CYRILLIC LETTER MULTIOCULAR OCOMBINING CYRILLIC VZMETCOMBINING CYRILLIC " +
	"TEN MILLIONS SIGNCOMBINING CYRILLIC HUNDRED MILLIONS SIGNCOMBINING CYRIL" +
	"LIC THOUSAND MILLIONS SIGNSLAVONIC ASTERISKCOMBINING CYRILLIC LETTER UKR" +
	"AINIAN IECOMBINING CYRILLIC LETTER ICOMBINING CYRILLIC LETTER YICOMBININ" +
	"G CYRILLIC LETTER UCOMBINING CYRILLIC LETTER HARD SIGNCOMBINING CYRILLIC" +
	" LETTER YERUCOMBINING CYRILLIC LETTER SOFT SIGNCOMBINING CYRILLIC LETTER" +
	" OMEGACOMBINING CYRILLIC KAVYKACOMBINING CYRILLIC PAYEROKCYRILLIC KAVYKA" +
	"CYRILLIC PAYEROKCYRILLIC CAPITAL LETTER DWECYRILLIC SMALL LETTER DWECYRI" +
	"LLIC CAPITAL LETTER DZWECYRILLIC SMALL LETTER DZWECYRILLIC CAPITAL LETTE" +
	"R ZHWECYRILLIC SMALL LETTER ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC SMA" +
	"LL LETTER CCHECYRILLIC CAPITAL LETTER DZZECYRILLIC SMALL LETTER DZZECYRI" +
	"LLIC CAPITAL LETTER TE WITH MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH MID" +
	"DLE HOOKCYRILLIC CAPITAL LETTER TWECYRILLIC SMALL LETTER TWECYRILLIC CAP" +
	"ITAL LETTER TSWECYRILLIC SMALL LETTER TSWECYRILLIC CAPITAL LETTER TSSECY" +
	"RILLIC SMALL LETTER TSSECYRILLIC CAPITAL LETTER TCHECYRILLIC SMALL LETTE" +
	"R TCHECYRILLIC CAPITAL LETTER HWECYRILLIC SMALL LETTER HWECYRILLIC CAPIT" +
	"AL LETTER SHWECYRILLIC SMALL LETTER SHWECYRILLIC CAPITAL LETTER DOUBLE O" +
	"CYRILLIC SMALL LETTER DOUBLE OCYRILLIC CAPITAL LETTER CROSSED OCYRILLIC " +
	"SMALL LETTER CROSSED OMODIFIER LETTER CYRILLIC HARD SIGNMODIFIER LETTER " +
	"CYRILLIC SOFT SIGNCOMBINING CYRILLIC LETTER EFCOMBINING CYRILLIC LETTER " +
	"IOTIFIED EBAMUM LETTER ABAMUM LETTER KABAMUM LETTER UBAMUM LETTER KUBAMU" +
	"M LETTER EEBAMUM LETTER REEBAMUM LETTER TAEBAMUM LETTER OBAMUM LETTER NY" +
	"IBAMUM LETTER IBAMUM LETTER LABAMUM LETTER PABAMUM LETTER RIIBAMUM LETTE" +
	"R RIEEBAMUM LETTER LEEEEBAMUM LETTER MEEEEBAMUM LETTER TAABAMUM LETTER N" +
	"DAABAMUM LETTER NJAEMBAMUM LETTER MBAMUM LETTER SUUBAMUM LETTER MUBAMUM " +
	"LETTER SHIIBAMUM LETTER SIBAMUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LETTE" +
	"R KYEEBAMUM LETTER KETBAMUM LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJUAE" +
	"BAMUM LETTER YOQBAMUM LETTER SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM LET" +
	"TER NSHABAMUM LETTER KEUXBAMUM LETTER PEUXBAMUM LETTER NJEEBAMUM LETTER " +
	"NTEEBAMUM LETTER PUEBAMUM LETTER WUEBAMUM LETTER PEEBAMUM LETTER FEEBAMU" +
	"M LETTER RUBAMUM LETTER LUBAMUM LETTER MIBAMUM LETTER NIBAMUM LETTER REU" +
	"XBAMUM LETTER RAEBAMUM LETTER KENBAMUM LETTER NGKWAENBAMUM LETTER NGGABA" +
	"MUM LETTER NGABAMUM LETTER SHOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM LETT" +
	"ER FOMBAMUM LETTER WABAMUM LETTER NABAMUM LETTER LIBAMUM LETTER PIBAMUM " +
	"LETTER LOQBAMUM LETTER KOBAMUM LETTER MBENBAMUM LETTER RENBAMUM LETTER M" +
	"ENBAMUM LETTER MABAMUM LETTER TIBAMUM LETTER KIBAMUM LETTER MOBAMUM LETT" +
	"ER MBAABAMUM LETTER TETBAMUM LETTER KPABAMUM LETTER TENBAMUM LETTER NTUU" +
	"BAMUM LETTER SAMBABAMUM LETTER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER KOGH" +
	"OMBAMUM COMBINING MARK KOQNDONBAMUM COMBINING MARK TUKWENTISBAMUM NJAEML" +
	"IBAMUM FULL STOPBAMUM COLONBAMUM COMMABAMUM SEMICOLONBAMUM QUESTION MARK" +
	"MODIFIER LETTER CHINESE TONE YIN PINGMODIFIER LETTER CHINESE TONE YANG P" +
	"INGMODIFIER LETTER CHINESE TONE YIN SHANGMODIFIER LETTER CHINESE TONE YA" +
	"NG SHANGMODIFIER LETTER CHINESE TONE YIN QUMODIFIER LETTER CHINESE TONE " +
	"YANG QUMODIFIER LETTER CHINESE TONE YIN RUMODIFIER LETTER CHINESE TONE Y" +
	"ANG RUMODIFIER LETTER EXTRA-HIGH DOTTED TONE BARMODIFIER LETTER HIGH DOT" +
	"TED TONE BARMODIFIER LETTER MID DOTTED TONE BARMODIFIER LETTER LOW DOTTE" +
	"D TONE BARMODIFIER LETTER EXTRA-LOW DOTTED TONE BARMODIFIER LETTER EXTRA") + ("" +
	"-HIGH DOTTED LEFT-STEM TONE BARMODIFIER LETTER HIGH DOTTED LEFT-STEM TON" +
	"E BARMODIFIER LETTER MID DOTTED LEFT-STEM TONE BARMODIFIER LETTER LOW DO" +
	"TTED LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE B" +
	"ARMODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BARMODIFIER LETTER HIGH LEFT" +
	"-STEM TONE BARMODIFIER LETTER MID LEFT-STEM TONE BARMODIFIER LETTER LOW " +
	"LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIER L" +
	"ETTER DOT VERTICAL BARMODIFIER LETTER DOT SLASHMODIFIER LETTER DOT HORIZ" +
	"ONTAL BARMODIFIER LETTER LOWER RIGHT CORNER ANGLEMODIFIER LETTER RAISED " +
	"UP ARROWMODIFIER LETTER RAISED DOWN ARROWMODIFIER LETTER RAISED EXCLAMAT" +
	"ION MARKMODIFIER LETTER RAISED INVERTED EXCLAMATION MARKMODIFIER LETTER " +
	"LOW INVERTED EXCLAMATION MARKMODIFIER LETTER STRESS AND HIGH TONEMODIFIE" +
	"R LETTER STRESS AND LOW TONELATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLATIN" +
	" SMALL LETTER EGYPTOLOGICAL ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AINLA" +
	"TIN SMALL LETTER EGYPTOLOGICAL AINLATIN CAPITAL LETTER HENGLATIN SMALL L" +
	"ETTER HENGLATIN CAPITAL LETTER TZLATIN SMALL LETTER TZLATIN CAPITAL LETT" +
	"ER TRESILLOLATIN SMALL LETTER TRESILLOLATIN CAPITAL LETTER CUATRILLOLATI" +
	"N SMALL LETTER CUATRILLOLATIN CAPITAL LETTER CUATRILLO WITH COMMALATIN S" +
	"MALL LETTER CUATRILLO WITH COMMALATIN LETTER SMALL CAPITAL FLATIN LETTER" +
	" SMALL CAPITAL SLATIN CAPITAL LETTER AALATIN SMALL LETTER AALATIN CAPITA" +
	"L LETTER AOLATIN SMALL LETTER AOLATIN CAPITAL LETTER AULATIN SMALL LETTE" +
	"R AULATIN CAPITAL LETTER AVLATIN SMALL LETTER AVLATIN CAPITAL LETTER AV " +
	"WITH HORIZONTAL BARLATIN SMALL LETTER AV WITH HORIZONTAL BARLATIN CAPITA" +
	"L LETTER AYLATIN SMALL LETTER AYLATIN CAPITAL LETTER REVERSED C WITH DOT" +
	"LATIN SMALL LETTER REVERSED C WITH DOTLATIN CAPITAL LETTER K WITH STROKE" +
	"LATIN SMALL LETTER K WITH STROKELATIN CAPITAL LETTER K WITH DIAGONAL STR" +
	"OKELATIN SMALL LETTER K WITH DIAGONAL STROKELATIN CAPITAL LETTER K WITH " +
	"STROKE AND DIAGONAL STROKELATIN SMALL LETTER K WITH STROKE AND DIAGONAL " +
	"STROKELATIN CAPITAL LETTER BROKEN LLATIN SMALL LETTER BROKEN LLATIN CAPI" +
	"TAL LETTER L WITH HIGH STROKELATIN SMALL LETTER L WITH HIGH STROKELATIN " +
	"CAPITAL LETTER O WITH LONG STROKE OVERLAYLATIN SMALL LETTER O WITH LONG " +
	"STROKE OVERLAYLATIN CAPITAL LETTER O WITH LOOPLATIN SMALL LETTER O WITH " +
	"LOOPLATIN CAPITAL LETTER OOLATIN SMALL LETTER OOLATIN CAPITAL LETTER P W" +
	"ITH STROKE THROUGH DESCENDERLATIN SMALL LETTER P WITH STROKE THROUGH DES" +
	"CENDERLATIN CAPITAL LETTER P WITH FLOURISHLATIN SMALL LETTER P WITH FLOU" +
	"RISHLATIN CAPITAL LETTER P WITH SQUIRREL TAILLATIN SMALL LETTER P WITH S" +
	"QUIRREL TAILLATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDERLATIN SM" +
	"ALL LETTER Q WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER Q WITH DI" +
	"AGONAL STROKELATIN SMALL LETTER Q WITH DIAGONAL STROKELATIN CAPITAL LETT" +
	"ER R ROTUNDALATIN SMALL LETTER R ROTUNDALATIN CAPITAL LETTER RUM ROTUNDA" +
	"LATIN SMALL LETTER RUM ROTUNDALATIN CAPITAL LETTER V WITH DIAGONAL STROK" +
	"ELATIN SMALL LETTER V WITH DIAGONAL STROKELATIN CAPITAL LETTER VYLATIN S" +
	"MALL LETTER VYLATIN CAPITAL LETTER VISIGOTHIC ZLATIN SMALL LETTER VISIGO" +
	"THIC ZLATIN CAPITAL LETTER THORN WITH STROKELATIN SMALL LETTER THORN WIT" +
	"H STROKELATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN SM" +
	"ALL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER VENDL" +
	"ATIN SMALL LETTER VENDLATIN CAPITAL LETTER ETLATIN SMALL LETTER ETLATIN " +
	"CAPITAL LETTER ISLATIN SMALL LETTER ISLATIN CAPITAL LETTER CONLATIN SMAL" +
	"L LETTER CONMODIFIER LETTER USLATIN SMALL LETTER DUMLATIN SMALL LETTER L" +
	"UMLATIN SMALL LETTER MUMLATIN SMALL LETTER NUMLATIN SMALL LETTER RUMLATI" +
	"N LETTER SMALL CAPITAL RUMLATIN SMALL LETTER TUMLATIN SMALL LETTER UMLAT" +
	"IN CAPITAL LETTER INSULAR DLATIN SMALL LETTER INSULAR DLATIN CAPITAL LET" +
	"TER INSULAR FLATIN SMALL LETTER INSULAR FLATIN CAPITAL LETTER INSULAR GL" +
	"ATIN CAPITAL LETTER TURNED INSULAR GLATIN SMALL LETTER TURNED INSULAR GL" +
	"ATIN CAPITAL LETTER TURNED LLATIN SMALL LETTER TURNED LLATIN CAPITAL LET" +
	"TER INSULAR RLATIN SMALL LETTER INSULAR RLATIN CAPITAL LETTER INSULAR SL" +
	"ATIN SMALL LETTER INSULAR SLATIN CAPITAL LETTER INSULAR TLATIN SMALL LET" +
	"TER INSULAR TMODIFIER LETTER LOW CIRCUMFLEX ACCENTMODIFIER LETTER COLONM" +
	"ODIFIER LETTER SHORT EQUALS SIGNLATIN CAPITAL LETTER SALTILLOLATIN SMALL" +
	" LETTER SALTILLOLATIN CAPITAL LETTER TURNED HLATIN SMALL LETTER L WITH R" +
	"ETROFLEX HOOK AND BELTLATIN LETTER SINOLOGICAL DOTLATIN CAPITAL LETTER N" +
	" WITH DESCENDERLATIN SMALL LETTER N WITH DESCENDERLATIN CAPITAL LETTER C" +
	" WITH BARLATIN SMALL LETTER C WITH BARLATIN SMALL LETTER C WITH PALATAL " +
	"HOOKLATIN SMALL LETTER H WITH PALATAL HOOKLATIN CAPITAL LETTER B WITH FL" +
	"OURISHLATIN SMALL LETTER B WITH FLOURISHLATIN CAPITAL LETTER F WITH STRO") + ("" +
	"KELATIN SMALL LETTER F WITH STROKELATIN CAPITAL LETTER VOLAPUK AELATIN S" +
	"MALL LETTER VOLAPUK AELATIN CAPITAL LETTER VOLAPUK OELATIN SMALL LETTER " +
	"VOLAPUK OELATIN CAPITAL LETTER VOLAPUK UELATIN SMALL LETTER VOLAPUK UELA" +
	"TIN CAPITAL LETTER G WITH OBLIQUE STROKELATIN SMALL LETTER G WITH OBLIQU" +
	"E STROKELATIN CAPITAL LETTER K WITH OBLIQUE STROKELATIN SMALL LETTER K W" +
	"ITH OBLIQUE STROKELATIN CAPITAL LETTER N WITH OBLIQUE STROKELATIN SMALL " +
	"LETTER N WITH OBLIQUE STROKELATIN CAPITAL LETTER R WITH OBLIQUE STROKELA" +
	"TIN SMALL LETTER R WITH OBLIQUE STROKELATIN CAPITAL LETTER S WITH OBLIQU" +
	"E STROKELATIN SMALL LETTER S WITH OBLIQUE STROKELATIN CAPITAL LETTER H W" +
	"ITH HOOKLATIN CAPITAL LETTER REVERSED OPEN ELATIN CAPITAL LETTER SCRIPT " +
	"GLATIN CAPITAL LETTER L WITH BELTLATIN CAPITAL LETTER SMALL CAPITAL ILAT" +
	"IN LETTER SMALL CAPITAL QLATIN CAPITAL LETTER TURNED KLATIN CAPITAL LETT" +
	"ER TURNED TLATIN CAPITAL LETTER J WITH CROSSED-TAILLATIN CAPITAL LETTER " +
	"CHILATIN CAPITAL LETTER BETALATIN SMALL LETTER BETALATIN CAPITAL LETTER " +
	"OMEGALATIN SMALL LETTER OMEGALATIN CAPITAL LETTER U WITH STROKELATIN SMA" +
	"LL LETTER U WITH STROKELATIN CAPITAL LETTER GLOTTAL ALATIN SMALL LETTER " +
	"GLOTTAL ALATIN CAPITAL LETTER GLOTTAL ILATIN SMALL LETTER GLOTTAL ILATIN" +
	" CAPITAL LETTER GLOTTAL ULATIN SMALL LETTER GLOTTAL ULATIN CAPITAL LETTE" +
	"R OLD POLISH OLATIN SMALL LETTER OLD POLISH OLATIN CAPITAL LETTER ANGLIC" +
	"ANA WLATIN SMALL LETTER ANGLICANA WLATIN CAPITAL LETTER C WITH PALATAL H" +
	"OOKLATIN CAPITAL LETTER S WITH HOOKLATIN CAPITAL LETTER Z WITH PALATAL H" +
	"OOKLATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAYLATIN SMALL LETTER D " +
	"WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER S WITH SHORT STROKE OVERLA" +
	"YLATIN SMALL LETTER S WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER RAMS" +
	" HORNLATIN CAPITAL LETTER S WITH DIAGONAL STROKELATIN SMALL LETTER S WIT" +
	"H DIAGONAL STROKELATIN CAPITAL LETTER PHARYNGEAL VOICED FRICATIVELATIN S" +
	"MALL LETTER PHARYNGEAL VOICED FRICATIVELATIN CAPITAL LETTER CLOSED INSUL" +
	"AR GLATIN SMALL LETTER CLOSED INSULAR GLATIN CAPITAL LETTER DOUBLE THORN" +
	"LATIN SMALL LETTER DOUBLE THORNLATIN CAPITAL LETTER DOUBLE WYNNLATIN SMA" +
	"LL LETTER DOUBLE WYNNLATIN CAPITAL LETTER MIDDLE SCOTS SLATIN SMALL LETT" +
	"ER MIDDLE SCOTS SLATIN CAPITAL LETTER SIGMOID SLATIN SMALL LETTER SIGMOI" +
	"D SLATIN CAPITAL LETTER LAMBDALATIN SMALL LETTER LAMBDALATIN CAPITAL LET" +
	"TER LAMBDA WITH STROKEMODIFIER LETTER CAPITAL SMODIFIER LETTER CAPITAL C" +
	"MODIFIER LETTER CAPITAL FMODIFIER LETTER CAPITAL QLATIN CAPITAL LETTER R" +
	"EVERSED HALF HLATIN SMALL LETTER REVERSED HALF HLATIN EPIGRAPHIC LETTER " +
	"SIDEWAYS IMODIFIER LETTER CAPITAL H WITH STROKEMODIFIER LETTER SMALL LIG" +
	"ATURE OELATIN LETTER SMALL CAPITAL TURNED MLATIN EPIGRAPHIC LETTER REVER" +
	"SED FLATIN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPHIC LETTER INVERTED " +
	"MLATIN EPIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETTER ARCHAIC MSYLOTI " +
	"NAGRI LETTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN DVISVARASYLOTI NAGR" +
	"I LETTER USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OSYLOTI NAGRI SIGN HA" +
	"SANTASYLOTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYLOTI NAGRI LETTER GO" +
	"SYLOTI NAGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLOTI NAGRI LETTER COS" +
	"YLOTI NAGRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NAGRI LETTER JHOSYLOT" +
	"I NAGRI LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGRI LETTER DDOSYLOTI " +
	"NAGRI LETTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI LETTER THOSYLOTI NAG" +
	"RI LETTER DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTER NOSYLOTI NAGRI LE" +
	"TTER POSYLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI LETTER " +
	"BHOSYLOTI NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI NAGRI LETTER LOSYL" +
	"OTI NAGRI LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGRI LETTER HOSYLOTI N" +
	"AGRI VOWEL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIGN USYLOT" +
	"I NAGRI VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI NAGRI POETRY MARK-1" +
	"SYLOTI NAGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI POETRY " +
	"MARK-4SYLOTI NAGRI SIGN ALTERNATE HASANTANORTH INDIC FRACTION ONE QUARTE" +
	"RNORTH INDIC FRACTION ONE HALFNORTH INDIC FRACTION THREE QUARTERSNORTH I" +
	"NDIC FRACTION ONE SIXTEENTHNORTH INDIC FRACTION ONE EIGHTHNORTH INDIC FR" +
	"ACTION THREE SIXTEENTHSNORTH INDIC QUARTER MARKNORTH INDIC PLACEHOLDER M" +
	"ARKNORTH INDIC RUPEE MARKNORTH INDIC QUANTITY MARKPHAGS-PA LETTER KAPHAG" +
	"S-PA LETTER KHAPHAGS-PA LETTER GAPHAGS-PA LETTER NGAPHAGS-PA LETTER CAPH" +
	"AGS-PA LETTER CHAPHAGS-PA LETTER JAPHAGS-PA LETTER NYAPHAGS-PA LETTER TA" +
	"PHAGS-PA LETTER THAPHAGS-PA LETTER DAPHAGS-PA LETTER NAPHAGS-PA LETTER P" +
	"APHAGS-PA LETTER PHAPHAGS-PA LETTER BAPHAGS-PA LETTER MAPHAGS-PA LETTER " +
	"TSAPHAGS-PA LETTER TSHAPHAGS-PA LETTER DZAPHAGS-PA LETTER WAPHAGS-PA LET" +
	"TER ZHAPHAGS-PA LETTER ZAPHAGS-PA LETTER SMALL APHAGS-PA LETTER YAPHAGS-") + ("" +
	"PA LETTER RAPHAGS-PA LETTER LAPHAGS-PA LETTER SHAPHAGS-PA LETTER SAPHAGS" +
	"-PA LETTER HAPHAGS-PA LETTER APHAGS-PA LETTER IPHAGS-PA LETTER UPHAGS-PA" +
	" LETTER EPHAGS-PA LETTER OPHAGS-PA LETTER QAPHAGS-PA LETTER XAPHAGS-PA L" +
	"ETTER FAPHAGS-PA LETTER GGAPHAGS-PA LETTER EEPHAGS-PA SUBJOINED LETTER W" +
	"APHAGS-PA SUBJOINED LETTER YAPHAGS-PA LETTER TTAPHAGS-PA LETTER TTHAPHAG" +
	"S-PA LETTER DDAPHAGS-PA LETTER NNAPHAGS-PA LETTER ALTERNATE YAPHAGS-PA L" +
	"ETTER VOICELESS SHAPHAGS-PA LETTER VOICED HAPHAGS-PA LETTER ASPIRATED FA" +
	"PHAGS-PA SUBJOINED LETTER RAPHAGS-PA SUPERFIXED LETTER RAPHAGS-PA LETTER" +
	" CANDRABINDUPHAGS-PA SINGLE HEAD MARKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA M" +
	"ARK SHADPHAGS-PA MARK DOUBLE SHADSAURASHTRA SIGN ANUSVARASAURASHTRA SIGN" +
	" VISARGASAURASHTRA LETTER ASAURASHTRA LETTER AASAURASHTRA LETTER ISAURAS" +
	"HTRA LETTER IISAURASHTRA LETTER USAURASHTRA LETTER UUSAURASHTRA LETTER V" +
	"OCALIC RSAURASHTRA LETTER VOCALIC RRSAURASHTRA LETTER VOCALIC LSAURASHTR" +
	"A LETTER VOCALIC LLSAURASHTRA LETTER ESAURASHTRA LETTER EESAURASHTRA LET" +
	"TER AISAURASHTRA LETTER OSAURASHTRA LETTER OOSAURASHTRA LETTER AUSAURASH" +
	"TRA LETTER KASAURASHTRA LETTER KHASAURASHTRA LETTER GASAURASHTRA LETTER " +
	"GHASAURASHTRA LETTER NGASAURASHTRA LETTER CASAURASHTRA LETTER CHASAURASH" +
	"TRA LETTER JASAURASHTRA LETTER JHASAURASHTRA LETTER NYASAURASHTRA LETTER" +
	" TTASAURASHTRA LETTER TTHASAURASHTRA LETTER DDASAURASHTRA LETTER DDHASAU" +
	"RASHTRA LETTER NNASAURASHTRA LETTER TASAURASHTRA LETTER THASAURASHTRA LE" +
	"TTER DASAURASHTRA LETTER DHASAURASHTRA LETTER NASAURASHTRA LETTER PASAUR" +
	"ASHTRA LETTER PHASAURASHTRA LETTER BASAURASHTRA LETTER BHASAURASHTRA LET" +
	"TER MASAURASHTRA LETTER YASAURASHTRA LETTER RASAURASHTRA LETTER LASAURAS" +
	"HTRA LETTER VASAURASHTRA LETTER SHASAURASHTRA LETTER SSASAURASHTRA LETTE" +
	"R SASAURASHTRA LETTER HASAURASHTRA LETTER LLASAURASHTRA CONSONANT SIGN H" +
	"AARUSAURASHTRA VOWEL SIGN AASAURASHTRA VOWEL SIGN ISAURASHTRA VOWEL SIGN" +
	" IISAURASHTRA VOWEL SIGN USAURASHTRA VOWEL SIGN UUSAURASHTRA VOWEL SIGN " +
	"VOCALIC RSAURASHTRA VOWEL SIGN VOCALIC RRSAURASHTRA VOWEL SIGN VOCALIC L" +
	"SAURASHTRA VOWEL SIGN VOCALIC LLSAURASHTRA VOWEL SIGN ESAURASHTRA VOWEL " +
	"SIGN EESAURASHTRA VOWEL SIGN AISAURASHTRA VOWEL SIGN OSAURASHTRA VOWEL S" +
	"IGN OOSAURASHTRA VOWEL SIGN AUSAURASHTRA SIGN VIRAMASAURASHTRA SIGN CAND" +
	"RABINDUSAURASHTRA DANDASAURASHTRA DOUBLE DANDASAURASHTRA DIGIT ZEROSAURA" +
	"SHTRA DIGIT ONESAURASHTRA DIGIT TWOSAURASHTRA DIGIT THREESAURASHTRA DIGI" +
	"T FOURSAURASHTRA DIGIT FIVESAURASHTRA DIGIT SIXSAURASHTRA DIGIT SEVENSAU" +
	"RASHTRA DIGIT EIGHTSAURASHTRA DIGIT NINECOMBINING DEVANAGARI DIGIT ZEROC" +
	"OMBINING DEVANAGARI DIGIT ONECOMBINING DEVANAGARI DIGIT TWOCOMBINING DEV" +
	"ANAGARI DIGIT THREECOMBINING DEVANAGARI DIGIT FOURCOMBINING DEVANAGARI D" +
	"IGIT FIVECOMBINING DEVANAGARI DIGIT SIXCOMBINING DEVANAGARI DIGIT SEVENC" +
	"OMBINING DEVANAGARI DIGIT EIGHTCOMBINING DEVANAGARI DIGIT NINECOMBINING " +
	"DEVANAGARI LETTER ACOMBINING DEVANAGARI LETTER UCOMBINING DEVANAGARI LET" +
	"TER KACOMBINING DEVANAGARI LETTER NACOMBINING DEVANAGARI LETTER PACOMBIN" +
	"ING DEVANAGARI LETTER RACOMBINING DEVANAGARI LETTER VICOMBINING DEVANAGA" +
	"RI SIGN AVAGRAHADEVANAGARI SIGN SPACING CANDRABINDUDEVANAGARI SIGN CANDR" +
	"ABINDU VIRAMADEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMADEVANAGARI SIGN CA" +
	"NDRABINDU TWODEVANAGARI SIGN CANDRABINDU THREEDEVANAGARI SIGN CANDRABIND" +
	"U AVAGRAHADEVANAGARI SIGN PUSHPIKADEVANAGARI GAP FILLERDEVANAGARI CARETD" +
	"EVANAGARI HEADSTROKEDEVANAGARI SIGN SIDDHAMDEVANAGARI JAIN OMDEVANAGARI " +
	"LETTER AYDEVANAGARI VOWEL SIGN AYKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEKA" +
	"YAH LI DIGIT TWOKAYAH LI DIGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT FI" +
	"VEKAYAH LI DIGIT SIXKAYAH LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DIG" +
	"IT NINEKAYAH LI LETTER KAKAYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI L" +
	"ETTER NGAKAYAH LI LETTER SAKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH LI" +
	" LETTER NYAKAYAH LI LETTER TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH " +
	"LI LETTER PAKAYAH LI LETTER PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYAH" +
	" LI LETTER BAKAYAH LI LETTER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYAH" +
	" LI LETTER WAKAYAH LI LETTER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAYA" +
	"H LI LETTER CAKAYAH LI LETTER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH " +
	"LI LETTER OOKAYAH LI VOWEL UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI VO" +
	"WEL EEKAYAH LI VOWEL OKAYAH LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI TO" +
	"NE CALYA PLOPHUKAYAH LI SIGN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJANG" +
	" LETTER GAREJANG LETTER NGAREJANG LETTER TAREJANG LETTER DAREJANG LETTER" +
	" NAREJANG LETTER PAREJANG LETTER BAREJANG LETTER MAREJANG LETTER CAREJAN" +
	"G LETTER JAREJANG LETTER NYAREJANG LETTER SAREJANG LETTER RAREJANG LETTE" +
	"R LAREJANG LETTER YAREJANG LETTER WAREJANG LETTER HAREJANG LETTER MBAREJ") + ("" +
	"ANG LETTER NGGAREJANG LETTER NDAREJANG LETTER NYJAREJANG LETTER AREJANG " +
	"VOWEL SIGN IREJANG VOWEL SIGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIRE" +
	"JANG VOWEL SIGN OREJANG VOWEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL SI" +
	"GN EAREJANG CONSONANT SIGN NGREJANG CONSONANT SIGN NREJANG CONSONANT SIG" +
	"N RREJANG CONSONANT SIGN HREJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEON" +
	"G TIKEUT-MIEUMHANGUL CHOSEONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHAN" +
	"GUL CHOSEONG TIKEUT-CIEUCHANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RIE" +
	"UL-SSANGKIYEOKHANGUL CHOSEONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTIK" +
	"EUTHANGUL CHOSEONG RIEUL-MIEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEONG" +
	" RIEUL-SSANGPIEUPHANGUL CHOSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIEU" +
	"L-SIOSHANGUL CHOSEONG RIEUL-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CHO" +
	"SEONG MIEUM-KIYEOKHANGUL CHOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIOS" +
	"HANGUL CHOSEONG PIEUP-SIOS-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL CH" +
	"OSEONG PIEUP-HIEUHHANGUL CHOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-R" +
	"IEULHANGUL CHOSEONG IEUNG-HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL CH" +
	"OSEONG SSANGTHIEUTHHANGUL CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-SI" +
	"OSHANGUL CHOSEONG SSANGYEORINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN C" +
	"ECAKJAVANESE SIGN LAYARJAVANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE LE" +
	"TTER I KAWIJAVANESE LETTER IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE " +
	"LETTER PA CEREKJAVANESE LETTER NGA LELETJAVANESE LETTER NGA LELET RASWAD" +
	"IJAVANESE LETTER EJAVANESE LETTER AIJAVANESE LETTER OJAVANESE LETTER KAJ" +
	"AVANESE LETTER KA SASAKJAVANESE LETTER KA MURDAJAVANESE LETTER GAJAVANES" +
	"E LETTER GA MURDAJAVANESE LETTER NGAJAVANESE LETTER CAJAVANESE LETTER CA" +
	" MURDAJAVANESE LETTER JAJAVANESE LETTER NYA MURDAJAVANESE LETTER JA MAHA" +
	"PRANAJAVANESE LETTER NYAJAVANESE LETTER TTAJAVANESE LETTER TTA MAHAPRANA" +
	"JAVANESE LETTER DDAJAVANESE LETTER DDA MAHAPRANAJAVANESE LETTER NA MURDA" +
	"JAVANESE LETTER TAJAVANESE LETTER TA MURDAJAVANESE LETTER DAJAVANESE LET" +
	"TER DA MAHAPRANAJAVANESE LETTER NAJAVANESE LETTER PAJAVANESE LETTER PA M" +
	"URDAJAVANESE LETTER BAJAVANESE LETTER BA MURDAJAVANESE LETTER MAJAVANESE" +
	" LETTER YAJAVANESE LETTER RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJA" +
	"VANESE LETTER WAJAVANESE LETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAVA" +
	"NESE LETTER SAJAVANESE LETTER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL S" +
	"IGN TARUNGJAVANESE VOWEL SIGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VOW" +
	"EL SIGN WULU MELIKJAVANESE VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MENDU" +
	"TJAVANESE VOWEL SIGN TALINGJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL " +
	"SIGN PEPETJAVANESE CONSONANT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJA" +
	"VANESE CONSONANT SIGN CAKRAJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVANE" +
	"SE RIGHT RERENGGANJAVANESE PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA LU" +
	"HURJAVANESE PADA WINDUJAVANESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE " +
	"PADA LUNGSIJAVANESE PADA ADEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISELE" +
	"HJAVANESE TURNED PADA PISELEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAVA" +
	"NESE DIGIT ONEJAVANESE DIGIT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOURJ" +
	"AVANESE DIGIT FIVEJAVANESE DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT E" +
	"IGHTJAVANESE DIGIT NINEJAVANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-ISE" +
	"NMYANMAR LETTER SHAN GHAMYANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAMY" +
	"ANMAR LETTER SHAN NNAMYANMAR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMAR" +
	" MODIFIER LETTER SHAN REDUPLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR L" +
	"ETTER TAI LAING FAMYANMAR LETTER TAI LAING GAMYANMAR LETTER TAI LAING GH" +
	"AMYANMAR LETTER TAI LAING JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER T" +
	"AI LAING DDAMYANMAR LETTER TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMYA" +
	"NMAR TAI LAING DIGIT ZEROMYANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING DI" +
	"GIT TWOMYANMAR TAI LAING DIGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR " +
	"TAI LAING DIGIT FIVEMYANMAR TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT S" +
	"EVENMYANMAR TAI LAING DIGIT EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LET" +
	"TER TAI LAING LLAMYANMAR LETTER TAI LAING DAMYANMAR LETTER TAI LAING DHA" +
	"MYANMAR LETTER TAI LAING BAMYANMAR LETTER TAI LAING BHACHAM LETTER ACHAM" +
	" LETTER ICHAM LETTER UCHAM LETTER ECHAM LETTER AICHAM LETTER OCHAM LETTE" +
	"R KACHAM LETTER KHACHAM LETTER GACHAM LETTER GHACHAM LETTER NGUECHAM LET" +
	"TER NGACHAM LETTER CHACHAM LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM " +
	"LETTER NHUECHAM LETTER NHACHAM LETTER NHJACHAM LETTER TACHAM LETTER THAC" +
	"HAM LETTER DACHAM LETTER DHACHAM LETTER NUECHAM LETTER NACHAM LETTER DDA" +
	"CHAM LETTER PACHAM LETTER PPACHAM LETTER PHACHAM LETTER BACHAM LETTER BH" +
	"ACHAM LETTER MUECHAM LETTER MACHAM LETTER BBACHAM LETTER YACHAM LETTER R" +
	"ACHAM LETTER LACHAM LETTER VACHAM LETTER SSACHAM LETTER SACHAM LETTER HA") + ("" +
	"CHAM VOWEL SIGN AACHAM VOWEL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EIC" +
	"HAM VOWEL SIGN UCHAM VOWEL SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICHA" +
	"M VOWEL SIGN AUCHAM VOWEL SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT SI" +
	"GN RACHAM CONSONANT SIGN LACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHAM" +
	" LETTER FINAL GCHAM LETTER FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LETT" +
	"ER FINAL CHCHAM LETTER FINAL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHAM" +
	" LETTER FINAL YCHAM LETTER FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL S" +
	"SCHAM CONSONANT SIGN FINAL MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROCH" +
	"AM DIGIT ONECHAM DIGIT TWOCHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIVE" +
	"CHAM DIGIT SIXCHAM DIGIT SEVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCTU" +
	"ATION SPIRALCHAM PUNCTUATION DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUNC" +
	"TUATION TRIPLE DANDAMYANMAR LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYAN" +
	"MAR LETTER KHAMTI CHAMYANMAR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAMY" +
	"ANMAR LETTER KHAMTI NYAMYANMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI TT" +
	"HAMYANMAR LETTER KHAMTI DDAMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHAM" +
	"TI DHAMYANMAR LETTER KHAMTI NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KHA" +
	"MTI HAMYANMAR LETTER KHAMTI HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER " +
	"LETTER KHAMTI REDUPLICATIONMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMTI" +
	" ZAMYANMAR LETTER KHAMTI RAMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM K" +
	"HAMTI QNMYANMAR LOGOGRAM KHAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANMA" +
	"R SYMBOL AITON ONEMYANMAR SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMAR" +
	" SIGN PAO KAREN TONEMYANMAR SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING " +
	"TONE-5MYANMAR LETTER SHWE PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI " +
	"VIET LETTER LOW KOTAI VIET LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIET" +
	" LETTER HIGH KHOTAI VIET LETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VIE" +
	"T LETTER LOW GOTAI VIET LETTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET LE" +
	"TTER HIGH NGOTAI VIET LETTER LOW COTAI VIET LETTER HIGH COTAI VIET LETTE" +
	"R LOW CHOTAI VIET LETTER HIGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER H" +
	"IGH SOTAI VIET LETTER LOW NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LOW" +
	" DOTAI VIET LETTER HIGH DOTAI VIET LETTER LOW TOTAI VIET LETTER HIGH TOT" +
	"AI VIET LETTER LOW THOTAI VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI " +
	"VIET LETTER HIGH NOTAI VIET LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIET" +
	" LETTER LOW POTAI VIET LETTER HIGH POTAI VIET LETTER LOW PHOTAI VIET LET" +
	"TER HIGH PHOTAI VIET LETTER LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTER" +
	" LOW MOTAI VIET LETTER HIGH MOTAI VIET LETTER LOW YOTAI VIET LETTER HIGH" +
	" YOTAI VIET LETTER LOW ROTAI VIET LETTER HIGH ROTAI VIET LETTER LOW LOTA" +
	"I VIET LETTER HIGH LOTAI VIET LETTER LOW VOTAI VIET LETTER HIGH VOTAI VI" +
	"ET LETTER LOW HOTAI VIET LETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LET" +
	"TER HIGH OTAI VIET MAI KANGTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VOW" +
	"EL UETAI VIET VOWEL UTAI VIET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITTA" +
	"I VIET VOWEL IATAI VIET VOWEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI " +
	"VIET VOWEL AYTAI VIET VOWEL ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI V" +
	"IET TONE MAI NUENGTAI VIET TONE MAI THOTAI VIET TONE MAI SONGTAI VIET SY" +
	"MBOL KONTAI VIET SYMBOL NUENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOITA" +
	"I VIET SYMBOL KOI KOIMEETEI MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI MA" +
	"YEK LETTER CHAMEETEI MAYEK LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYEK" +
	" LETTER TTHAMEETEI MAYEK LETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK " +
	"LETTER NNAMEETEI MAYEK LETTER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VOW" +
	"EL SIGN IIMEETEI MAYEK VOWEL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI MA" +
	"YEK VOWEL SIGN AUMEETEI MAYEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI " +
	"MAYEK AHANG KHUDAMMEETEI MAYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MARK" +
	"MEETEI MAYEK WORD REPETITION MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI M" +
	"AYEK VIRAMAETHIOPIC SYLLABLE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABLE" +
	" TTHAAETHIOPIC SYLLABLE TTHEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TTH" +
	"OETHIOPIC SYLLABLE DDHUETHIOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETHI" +
	"OPIC SYLLABLE DDHEEETHIOPIC SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC " +
	"SYLLABLE DZUETHIOPIC SYLLABLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABLE" +
	" DZEEETHIOPIC SYLLABLE DZEETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAET" +
	"HIOPIC SYLLABLE CCHHUETHIOPIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETHI" +
	"OPIC SYLLABLE CCHHEEETHIOPIC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIOP" +
	"IC SYLLABLE BBAETHIOPIC SYLLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLAB" +
	"LE BBAAETHIOPIC SYLLABLE BBEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBOL" +
	"ATIN SMALL LETTER BARRED ALPHALATIN SMALL LETTER A REVERSED-SCHWALATIN S" +
	"MALL LETTER BLACKLETTER ELATIN SMALL LETTER BARRED ELATIN SMALL LETTER E") + ("" +
	" WITH FLOURISHLATIN SMALL LETTER LENIS FLATIN SMALL LETTER SCRIPT G WITH" +
	" CROSSED-TAILLATIN SMALL LETTER L WITH INVERTED LAZY SLATIN SMALL LETTER" +
	" L WITH DOUBLE MIDDLE TILDELATIN SMALL LETTER L WITH MIDDLE RINGLATIN SM" +
	"ALL LETTER M WITH CROSSED-TAILLATIN SMALL LETTER N WITH CROSSED-TAILLATI" +
	"N SMALL LETTER ENG WITH CROSSED-TAILLATIN SMALL LETTER BLACKLETTER OLATI" +
	"N SMALL LETTER BLACKLETTER O WITH STROKELATIN SMALL LETTER OPEN O WITH S" +
	"TROKELATIN SMALL LETTER INVERTED OELATIN SMALL LETTER TURNED OE WITH STR" +
	"OKELATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKELATIN SMALL LETTER" +
	" TURNED O OPEN-OLATIN SMALL LETTER TURNED O OPEN-O WITH STROKELATIN SMAL" +
	"L LETTER STIRRUP RLATIN LETTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMALL" +
	" LETTER R WITHOUT HANDLELATIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R " +
	"WITH CROSSED-TAILLATIN SMALL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMAL" +
	"L LETTER SCRIPT RLATIN SMALL LETTER SCRIPT R WITH RINGLATIN SMALL LETTER" +
	" BASELINE ESHLATIN SMALL LETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTER" +
	" U BAR WITH SHORT RIGHT LEGLATIN SMALL LETTER UILATIN SMALL LETTER TURNE" +
	"D UILATIN SMALL LETTER U WITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMALL" +
	" LETTER CHI WITH LOW RIGHT RINGLATIN SMALL LETTER CHI WITH LOW LEFT SERI" +
	"FLATIN SMALL LETTER X WITH LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG " +
	"LEFT LEGLATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN " +
	"SMALL LETTER X WITH LONG LEFT LEG WITH SERIFLATIN SMALL LETTER Y WITH SH" +
	"ORT RIGHT LEGMODIFIER BREVE WITH INVERTED BREVEMODIFIER LETTER SMALL HEN" +
	"GMODIFIER LETTER SMALL L WITH INVERTED LAZY SMODIFIER LETTER SMALL L WIT" +
	"H MIDDLE TILDEMODIFIER LETTER SMALL U WITH LEFT HOOKLATIN SMALL LETTER S" +
	"AKHA YATLATIN SMALL LETTER IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SMA" +
	"LL LETTER UOLATIN SMALL LETTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL " +
	"OMEGALATIN SMALL LETTER DZ DIGRAPH WITH RETROFLEX HOOKLATIN SMALL LETTER" +
	" TS DIGRAPH WITH RETROFLEX HOOKLATIN SMALL LETTER TURNED R WITH MIDDLE T" +
	"ILDEMODIFIER LETTER SMALL TURNED WMODIFIER LETTER LEFT TACKMODIFIER LETT" +
	"ER RIGHT TACKCHEROKEE SMALL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMAL" +
	"L LETTER ICHEROKEE SMALL LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL L" +
	"ETTER VCHEROKEE SMALL LETTER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LE" +
	"TTER GECHEROKEE SMALL LETTER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LE" +
	"TTER GUCHEROKEE SMALL LETTER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LE" +
	"TTER HECHEROKEE SMALL LETTER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LE" +
	"TTER HUCHEROKEE SMALL LETTER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LE" +
	"TTER LECHEROKEE SMALL LETTER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LE" +
	"TTER LUCHEROKEE SMALL LETTER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LE" +
	"TTER MECHEROKEE SMALL LETTER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LE" +
	"TTER MUCHEROKEE SMALL LETTER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL L" +
	"ETTER NAHCHEROKEE SMALL LETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL " +
	"LETTER NOCHEROKEE SMALL LETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL " +
	"LETTER QUACHEROKEE SMALL LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMA" +
	"LL LETTER QUOCHEROKEE SMALL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE " +
	"SMALL LETTER SACHEROKEE SMALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE S" +
	"MALL LETTER SICHEROKEE SMALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE S" +
	"MALL LETTER SVCHEROKEE SMALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE S" +
	"MALL LETTER DECHEROKEE SMALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE S" +
	"MALL LETTER TICHEROKEE SMALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE S" +
	"MALL LETTER DVCHEROKEE SMALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE" +
	" SMALL LETTER TLECHEROKEE SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHERO" +
	"KEE SMALL LETTER TLUCHEROKEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACH" +
	"EROKEE SMALL LETTER TSECHEROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TS" +
	"OCHEROKEE SMALL LETTER TSUCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER" +
	" WACHEROKEE SMALL LETTER WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER" +
	" WOCHEROKEE SMALL LETTER WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER" +
	" YAMEETEI MAYEK LETTER KOKMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAI" +
	"MEETEI MAYEK LETTER MITMEETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETE" +
	"I MAYEK LETTER CHILMEETEI MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI" +
	" MAYEK LETTER NGOUMEETEI MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI " +
	"MAYEK LETTER YANGMEETEI MAYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAY" +
	"EK LETTER IMEETEI MAYEK LETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK" +
	" LETTER GOKMEETEI MAYEK LETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK L" +
	"ETTER BAMEETEI MAYEK LETTER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTE" +
	"R GHOUMEETEI MAYEK LETTER DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTE") + ("" +
	"R KOK LONSUMMEETEI MAYEK LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUM" +
	"MEETEI MAYEK LETTER PA LONSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK L" +
	"ETTER TIL LONSUMMEETEI MAYEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LON" +
	"SUMMEETEI MAYEK VOWEL SIGN ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK " +
	"VOWEL SIGN ANAPMEETEI MAYEK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUN" +
	"APMEETEI MAYEK VOWEL SIGN UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYE" +
	"K VOWEL SIGN NUNGMEETEI MAYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK " +
	"APUN IYEKMEETEI MAYEK DIGIT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT" +
	" TWOMEETEI MAYEK DIGIT THREEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FI" +
	"VEMEETEI MAYEK DIGIT SIXMEETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHT" +
	"MEETEI MAYEK DIGIT NINEHANGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGU" +
	"L JUNGSEONG YO-AHANGUL JUNGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGS" +
	"EONG U-YEOHANGUL JUNGSEONG U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG Y" +
	"U-OHANGUL JUNGSEONG EU-AHANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGU" +
	"L JUNGSEONG EU-OHANGUL JUNGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNG" +
	"SEONG I-YEOHANGUL JUNGSEONG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I" +
	"-YOHANGUL JUNGSEONG I-YUHANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANG" +
	"UL JUNGSEONG ARAEA-EHANGUL JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-C" +
	"HIEUCHHANGUL JONGSEONG SSANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANG" +
	"UL JONGSEONG TIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TI" +
	"KEUT-SIOS-KIYEOKHANGUL JONGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHI" +
	"EUCHHANGUL JONGSEONG TIKEUT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHAN" +
	"GUL JONGSEONG RIEUL-KIYEOK-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGU" +
	"L JONGSEONG RIEUL-MIEUM-HIEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL J" +
	"ONGSEONG RIEUL-PIEUP-PHIEUPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSE" +
	"ONG RIEUL-YEORINHIEUH-HIEUHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEON" +
	"G MIEUM-NIEUNHANGUL JONGSEONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEU" +
	"MHANGUL JONGSEONG MIEUM-PIEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JON" +
	"GSEONG PIEUP-TIKEUTHANGUL JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG " +
	"PIEUP-MIEUMHANGUL JONGSEONG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUT" +
	"HANGUL JONGSEONG PIEUP-CIEUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEO" +
	"NG SIOS-MIEUMHANGUL JONGSEONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSI" +
	"OS-KIYEOKHANGUL JONGSEONG SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSH" +
	"ANGUL JONGSEONG SIOS-CIEUCHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG " +
	"SIOS-THIEUTHHANGUL JONGSEONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHAN" +
	"GUL JONGSEONG PANSIOS-KAPYEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL" +
	" JONGSEONG YESIEUNG-HIEUHHANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CI" +
	"EUC-SSANGPIEUPHANGUL JONGSEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHA" +
	"NGUL JONGSEONG PHIEUPH-THIEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPAT" +
	"IBILITY IDEOGRAPH-F901CJK COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY " +
	"IDEOGRAPH-F903CJK COMPATIBILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAP" +
	"H-F905CJK COMPATIBILITY IDEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJ" +
	"K COMPATIBILITY IDEOGRAPH-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPAT" +
	"IBILITY IDEOGRAPH-F90ACJK COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY " +
	"IDEOGRAPH-F90CCJK COMPATIBILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAP" +
	"H-F90ECJK COMPATIBILITY IDEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJ" +
	"K COMPATIBILITY IDEOGRAPH-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPAT" +
	"IBILITY IDEOGRAPH-F913CJK COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY " +
	"IDEOGRAPH-F915CJK COMPATIBILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAP" +
	"H-F917CJK COMPATIBILITY IDEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJ" +
	"K COMPATIBILITY IDEOGRAPH-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPAT" +
	"IBILITY IDEOGRAPH-F91CCJK COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY " +
	"IDEOGRAPH-F91ECJK COMPATIBILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAP" +
	"H-F920CJK COMPATIBILITY IDEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJ" +
	"K COMPATIBILITY IDEOGRAPH-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPAT" +
	"IBILITY IDEOGRAPH-F925CJK COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY " +
	"IDEOGRAPH-F927CJK COMPATIBILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAP" +
	"H-F929CJK COMPATIBILITY IDEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJ" +
	"K COMPATIBILITY IDEOGRAPH-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPAT" +
	"IBILITY IDEOGRAPH-F92ECJK COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY " +
	"IDEOGRAPH-F930CJK COMPATIBILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAP" +
	"H-F932CJK COMPATIBILITY IDEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJ" +
	"K COMPATIBILITY IDEOGRAPH-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPAT" +
	"IBILITY IDEOGRAPH-F937CJK COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY ") + ("" +
	"IDEOGRAPH-F939CJK COMPATIBILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAP" +
	"H-F93BCJK COMPATIBILITY IDEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJ" +
	"K COMPATIBILITY IDEOGRAPH-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPAT" +
	"IBILITY IDEOGRAPH-F940CJK COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY " +
	"IDEOGRAPH-F942CJK COMPATIBILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAP" +
	"H-F944CJK COMPATIBILITY IDEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJ" +
	"K COMPATIBILITY IDEOGRAPH-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPAT" +
	"IBILITY IDEOGRAPH-F949CJK COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY " +
	"IDEOGRAPH-F94BCJK COMPATIBILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAP" +
	"H-F94DCJK COMPATIBILITY IDEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJ" +
	"K COMPATIBILITY IDEOGRAPH-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPAT" +
	"IBILITY IDEOGRAPH-F952CJK COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY " +
	"IDEOGRAPH-F954CJK COMPATIBILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAP" +
	"H-F956CJK COMPATIBILITY IDEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJ" +
	"K COMPATIBILITY IDEOGRAPH-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPAT" +
	"IBILITY IDEOGRAPH-F95BCJK COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY " +
	"IDEOGRAPH-F95DCJK COMPATIBILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAP" +
	"H-F95FCJK COMPATIBILITY IDEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJ" +
	"K COMPATIBILITY IDEOGRAPH-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPAT" +
	"IBILITY IDEOGRAPH-F964CJK COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY " +
	"IDEOGRAPH-F966CJK COMPATIBILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAP" +
	"H-F968CJK COMPATIBILITY IDEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJ" +
	"K COMPATIBILITY IDEOGRAPH-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPAT" +
	"IBILITY IDEOGRAPH-F96DCJK COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY " +
	"IDEOGRAPH-F96FCJK COMPATIBILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAP" +
	"H-F971CJK COMPATIBILITY IDEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJ" +
	"K COMPATIBILITY IDEOGRAPH-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPAT" +
	"IBILITY IDEOGRAPH-F976CJK COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY " +
	"IDEOGRAPH-F978CJK COMPATIBILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAP" +
	"H-F97ACJK COMPATIBILITY IDEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJ" +
	"K COMPATIBILITY IDEOGRAPH-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPAT" +
	"IBILITY IDEOGRAPH-F97FCJK COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY " +
	"IDEOGRAPH-F981CJK COMPATIBILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAP" +
	"H-F983CJK COMPATIBILITY IDEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJ" +
	"K COMPATIBILITY IDEOGRAPH-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPAT" +
	"IBILITY IDEOGRAPH-F988CJK COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY " +
	"IDEOGRAPH-F98ACJK COMPATIBILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAP" +
	"H-F98CCJK COMPATIBILITY IDEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJ" +
	"K COMPATIBILITY IDEOGRAPH-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPAT" +
	"IBILITY IDEOGRAPH-F991CJK COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY " +
	"IDEOGRAPH-F993CJK COMPATIBILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAP" +
	"H-F995CJK COMPATIBILITY IDEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJ" +
	"K COMPATIBILITY IDEOGRAPH-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPAT" +
	"IBILITY IDEOGRAPH-F99ACJK COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY " +
	"IDEOGRAPH-F99CCJK COMPATIBILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAP" +
	"H-F99ECJK COMPATIBILITY IDEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9A3CJK COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY " +
	"IDEOGRAPH-F9A5CJK COMPATIBILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAP" +
	"H-F9A7CJK COMPATIBILITY IDEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9ACCJK COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY " +
	"IDEOGRAPH-F9AECJK COMPATIBILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAP" +
	"H-F9B0CJK COMPATIBILITY IDEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9B5CJK COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY " +
	"IDEOGRAPH-F9B7CJK COMPATIBILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAP" +
	"H-F9B9CJK COMPATIBILITY IDEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9BECJK COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY " +
	"IDEOGRAPH-F9C0CJK COMPATIBILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAP" +
	"H-F9C2CJK COMPATIBILITY IDEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9C7CJK COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY ") + ("" +
	"IDEOGRAPH-F9C9CJK COMPATIBILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAP" +
	"H-F9CBCJK COMPATIBILITY IDEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9D0CJK COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY " +
	"IDEOGRAPH-F9D2CJK COMPATIBILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAP" +
	"H-F9D4CJK COMPATIBILITY IDEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9D9CJK COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY " +
	"IDEOGRAPH-F9DBCJK COMPATIBILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAP" +
	"H-F9DDCJK COMPATIBILITY IDEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9E2CJK COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY " +
	"IDEOGRAPH-F9E4CJK COMPATIBILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAP" +
	"H-F9E6CJK COMPATIBILITY IDEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPAT" +
	"IBILITY IDEOGRAPH-F9EBCJK COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY " +
	"IDEOGRAPH-F9EDCJK COMPATIBILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAP" +
	"H-F9EFCJK COMPATIBILITY IDEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9F4CJK COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY " +
	"IDEOGRAPH-F9F6CJK COMPATIBILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAP" +
	"H-F9F8CJK COMPATIBILITY IDEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJ" +
	"K COMPATIBILITY IDEOGRAPH-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9FDCJK COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY " +
	"IDEOGRAPH-F9FFCJK COMPATIBILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAP" +
	"H-FA01CJK COMPATIBILITY IDEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA06CJK COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY " +
	"IDEOGRAPH-FA08CJK COMPATIBILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAP" +
	"H-FA0ACJK COMPATIBILITY IDEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPAT" +
	"IBILITY IDEOGRAPH-FA0FCJK COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY " +
	"IDEOGRAPH-FA11CJK COMPATIBILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAP" +
	"H-FA13CJK COMPATIBILITY IDEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA18CJK COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY " +
	"IDEOGRAPH-FA1ACJK COMPATIBILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAP" +
	"H-FA1CCJK COMPATIBILITY IDEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJ" +
	"K COMPATIBILITY IDEOGRAPH-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA21CJK COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY " +
	"IDEOGRAPH-FA23CJK COMPATIBILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAP" +
	"H-FA25CJK COMPATIBILITY IDEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA2ACJK COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY " +
	"IDEOGRAPH-FA2CCJK COMPATIBILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAP" +
	"H-FA2ECJK COMPATIBILITY IDEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA33CJK COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY " +
	"IDEOGRAPH-FA35CJK COMPATIBILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAP" +
	"H-FA37CJK COMPATIBILITY IDEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA3CCJK COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY " +
	"IDEOGRAPH-FA3ECJK COMPATIBILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAP" +
	"H-FA40CJK COMPATIBILITY IDEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA45CJK COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY " +
	"IDEOGRAPH-FA47CJK COMPATIBILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAP" +
	"H-FA49CJK COMPATIBILITY IDEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA4ECJK COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY " +
	"IDEOGRAPH-FA50CJK COMPATIBILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAP" +
	"H-FA52CJK COMPATIBILITY IDEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA57CJK COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY ") + ("" +
	"IDEOGRAPH-FA59CJK COMPATIBILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAP" +
	"H-FA5BCJK COMPATIBILITY IDEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA60CJK COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY " +
	"IDEOGRAPH-FA62CJK COMPATIBILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAP" +
	"H-FA64CJK COMPATIBILITY IDEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA69CJK COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY " +
	"IDEOGRAPH-FA6BCJK COMPATIBILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAP" +
	"H-FA6DCJK COMPATIBILITY IDEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA74CJK COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY " +
	"IDEOGRAPH-FA76CJK COMPATIBILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAP" +
	"H-FA78CJK COMPATIBILITY IDEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJ" +
	"K COMPATIBILITY IDEOGRAPH-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA7DCJK COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY " +
	"IDEOGRAPH-FA7FCJK COMPATIBILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAP" +
	"H-FA81CJK COMPATIBILITY IDEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA86CJK COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY " +
	"IDEOGRAPH-FA88CJK COMPATIBILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAP" +
	"H-FA8ACJK COMPATIBILITY IDEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPAT" +
	"IBILITY IDEOGRAPH-FA8FCJK COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY " +
	"IDEOGRAPH-FA91CJK COMPATIBILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAP" +
	"H-FA93CJK COMPATIBILITY IDEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA98CJK COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY " +
	"IDEOGRAPH-FA9ACJK COMPATIBILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAP" +
	"H-FA9CCJK COMPATIBILITY IDEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJ" +
	"K COMPATIBILITY IDEOGRAPH-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAA1CJK COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY " +
	"IDEOGRAPH-FAA3CJK COMPATIBILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAP" +
	"H-FAA5CJK COMPATIBILITY IDEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAAACJK COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY " +
	"IDEOGRAPH-FAACCJK COMPATIBILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAP" +
	"H-FAAECJK COMPATIBILITY IDEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAB3CJK COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY " +
	"IDEOGRAPH-FAB5CJK COMPATIBILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAP" +
	"H-FAB7CJK COMPATIBILITY IDEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJ" +
	"K COMPATIBILITY IDEOGRAPH-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPAT" +
	"IBILITY IDEOGRAPH-FABCCJK COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY " +
	"IDEOGRAPH-FABECJK COMPATIBILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAP" +
	"H-FAC0CJK COMPATIBILITY IDEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAC5CJK COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY " +
	"IDEOGRAPH-FAC7CJK COMPATIBILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAP" +
	"H-FAC9CJK COMPATIBILITY IDEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJ" +
	"K COMPATIBILITY IDEOGRAPH-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPAT" +
	"IBILITY IDEOGRAPH-FACECJK COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY " +
	"IDEOGRAPH-FAD0CJK COMPATIBILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAP" +
	"H-FAD2CJK COMPATIBILITY IDEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAD7CJK COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY " +
	"IDEOGRAPH-FAD9LATIN SMALL LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL " +
	"LIGATURE FLLATIN SMALL LIGATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL L" +
	"IGATURE LONG S TLATIN SMALL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWAR" +
	"MENIAN SMALL LIGATURE MEN ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMA" +
	"LL LIGATURE VEW NOWARMENIAN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH" +
	" HIRIQHEBREW POINT JUDEO-SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD P" +
	"ATAHHEBREW LETTER ALTERNATIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER W" +
	"IDE DALETHEBREW LETTER WIDE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE L") + ("" +
	"AMEDHEBREW LETTER WIDE FINAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WID" +
	"E TAVHEBREW LETTER ALTERNATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOT" +
	"HEBREW LETTER SHIN WITH SIN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN D" +
	"OTHEBREW LETTER SHIN WITH DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATA" +
	"HHEBREW LETTER ALEF WITH QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTE" +
	"R BET WITH DAGESHHEBREW LETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH" +
	" DAGESHHEBREW LETTER HE WITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LE" +
	"TTER ZAYIN WITH DAGESHHEBREW LETTER TET WITH DAGESHHEBREW LETTER YOD WIT" +
	"H DAGESHHEBREW LETTER FINAL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESH" +
	"HEBREW LETTER LAMED WITH DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTE" +
	"R NUN WITH DAGESHHEBREW LETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE " +
	"WITH DAGESHHEBREW LETTER PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHE" +
	"BREW LETTER QOF WITH DAGESHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER S" +
	"HIN WITH DAGESHHEBREW LETTER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAM" +
	"HEBREW LETTER BET WITH RAFEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE W" +
	"ITH RAFEHEBREW LIGATURE ALEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORM" +
	"ARABIC LETTER ALEF WASLA FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABI" +
	"C LETTER BEEH FINAL FORMARABIC LETTER BEEH INITIAL FORMARABIC LETTER BEE" +
	"H MEDIAL FORMARABIC LETTER PEH ISOLATED FORMARABIC LETTER PEH FINAL FORM" +
	"ARABIC LETTER PEH INITIAL FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER" +
	" BEHEH ISOLATED FORMARABIC LETTER BEHEH FINAL FORMARABIC LETTER BEHEH IN" +
	"ITIAL FORMARABIC LETTER BEHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED F" +
	"ORMARABIC LETTER TTEHEH FINAL FORMARABIC LETTER TTEHEH INITIAL FORMARABI" +
	"C LETTER TTEHEH MEDIAL FORMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTE" +
	"R TEHEH FINAL FORMARABIC LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH ME" +
	"DIAL FORMARABIC LETTER TTEH ISOLATED FORMARABIC LETTER TTEH FINAL FORMAR" +
	"ABIC LETTER TTEH INITIAL FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER" +
	" VEH ISOLATED FORMARABIC LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL " +
	"FORMARABIC LETTER VEH MEDIAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC" +
	" LETTER PEHEH FINAL FORMARABIC LETTER PEHEH INITIAL FORMARABIC LETTER PE" +
	"HEH MEDIAL FORMARABIC LETTER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL " +
	"FORMARABIC LETTER DYEH INITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC " +
	"LETTER NYEH ISOLATED FORMARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH" +
	" INITIAL FORMARABIC LETTER NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED " +
	"FORMARABIC LETTER TCHEH FINAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC" +
	" LETTER TCHEH MEDIAL FORMARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTE" +
	"R TCHEHEH FINAL FORMARABIC LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHE" +
	"HEH MEDIAL FORMARABIC LETTER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FI" +
	"NAL FORMARABIC LETTER DAHAL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMA" +
	"RABIC LETTER DUL ISOLATED FORMARABIC LETTER DUL FINAL FORMARABIC LETTER " +
	"DDAL ISOLATED FORMARABIC LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATE" +
	"D FORMARABIC LETTER JEH FINAL FORMARABIC LETTER RREH ISOLATED FORMARABIC" +
	" LETTER RREH FINAL FORMARABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KE" +
	"HEH FINAL FORMARABIC LETTER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL" +
	" FORMARABIC LETTER GAF ISOLATED FORMARABIC LETTER GAF FINAL FORMARABIC L" +
	"ETTER GAF INITIAL FORMARABIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH IS" +
	"OLATED FORMARABIC LETTER GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMA" +
	"RABIC LETTER GUEH MEDIAL FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LET" +
	"TER NGOEH FINAL FORMARABIC LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH " +
	"MEDIAL FORMARABIC LETTER NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHU" +
	"NNA FINAL FORMARABIC LETTER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL" +
	" FORMARABIC LETTER RNOON INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARAB" +
	"IC LETTER HEH WITH YEH ABOVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABO" +
	"VE FINAL FORMARABIC LETTER HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL " +
	"FINAL FORMARABIC LETTER HEH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDI" +
	"AL FORMARABIC LETTER HEH DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOAC" +
	"HASHMEE FINAL FORMARABIC LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTE" +
	"R HEH DOACHASHMEE MEDIAL FORMARABIC LETTER YEH BARREE ISOLATED FORMARABI" +
	"C LETTER YEH BARREE FINAL FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE " +
	"ISOLATED FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC " +
	"SYMBOL DOT ABOVEARABIC SYMBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABI" +
	"C SYMBOL TWO DOTS BELOWARABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE" +
	" DOTS BELOWARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBO" +
	"L THREE DOTS POINTING DOWNWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC") + ("" +
	" SYMBOL FOUR DOTS BELOWARABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYM" +
	"BOL TWO DOTS VERTICALLY ABOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARAB" +
	"IC SYMBOL RINGARABIC SYMBOL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOW" +
	"ARABIC SYMBOL WASLA ABOVEARABIC LIGATURE JALLA WA-ALAAARABIC LIGATURE DA" +
	"AMAT BARAKAATUHUMARABIC LIGATURE RAHMATU ALLAAHI TAAALAA ALAYHARABIC LIG" +
	"ATURE RAHMATU ALLAAHI ALAYHIMARABIC LIGATURE RAHMATU ALLAAHI ALAYHIMAAAR" +
	"ABIC LIGATURE RAHIMAHUM ALLAAHU TAAALAAARABIC LIGATURE RAHIMAHUMAA ALLAA" +
	"HARABIC LIGATURE RAHIMAHUMAA ALLAAHU TAAALAAARABIC LIGATURE RADI ALLAAHU" +
	" TAAALAA ANHUMARABIC LIGATURE HAFIZAHU ALLAAHARABIC LIGATURE HAFIZAHU AL" +
	"LAAHU TAAALAAARABIC LIGATURE HAFIZAHUM ALLAAHU TAAALAAARABIC LIGATURE HA" +
	"FIZAHUMAA ALLAAHU TAAALAAARABIC LIGATURE SALLALLAAHU TAAALAA ALAYHI WA-S" +
	"ALLAMARABIC LIGATURE AJJAL ALLAAHU FARAJAHU ASH-SHAREEFARABIC LIGATURE A" +
	"LAYHI AR-RAHMAHARABIC LETTER NG ISOLATED FORMARABIC LETTER NG FINAL FORM" +
	"ARABIC LETTER NG INITIAL FORMARABIC LETTER NG MEDIAL FORMARABIC LETTER U" +
	" ISOLATED FORMARABIC LETTER U FINAL FORMARABIC LETTER OE ISOLATED FORMAR" +
	"ABIC LETTER OE FINAL FORMARABIC LETTER YU ISOLATED FORMARABIC LETTER YU " +
	"FINAL FORMARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER VE" +
	" ISOLATED FORMARABIC LETTER VE FINAL FORMARABIC LETTER KIRGHIZ OE ISOLAT" +
	"ED FORMARABIC LETTER KIRGHIZ OE FINAL FORMARABIC LETTER KIRGHIZ YU ISOLA" +
	"TED FORMARABIC LETTER KIRGHIZ YU FINAL FORMARABIC LETTER E ISOLATED FORM" +
	"ARABIC LETTER E FINAL FORMARABIC LETTER E INITIAL FORMARABIC LETTER E ME" +
	"DIAL FORMARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORMAR" +
	"ABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORMARABIC LIGATUR" +
	"E YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORMARABIC LIGATURE YEH WITH H" +
	"AMZA ABOVE WITH ALEF FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH" +
	" AE ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM" +
	"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORMARABIC LIGATU" +
	"RE YEH WITH HAMZA ABOVE WITH WAW FINAL FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH U ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U " +
	"FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORMARAB" +
	"IC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORMARABIC LIGATURE YEH W" +
	"ITH HAMZA ABOVE WITH YU ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOV" +
	"E WITH YU FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED" +
	" FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORMARABIC LIGATU" +
	"RE YEH WITH HAMZA ABOVE WITH E INITIAL FORMARABIC LIGATURE UIGHUR KIRGHI" +
	"Z YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE UI" +
	"GHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABIC LIG" +
	"ATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM" +
	"ARABIC LETTER FARSI YEH ISOLATED FORMARABIC LETTER FARSI YEH FINAL FORMA" +
	"RABIC LETTER FARSI YEH INITIAL FORMARABIC LETTER FARSI YEH MEDIAL FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORMARABIC LIGATUR" +
	"E YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORMARABIC LIGATURE YEH WITH HA" +
	"MZA ABOVE WITH MEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WI" +
	"TH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH Y" +
	"EH ISOLATED FORMARABIC LIGATURE BEH WITH JEEM ISOLATED FORMARABIC LIGATU" +
	"RE BEH WITH HAH ISOLATED FORMARABIC LIGATURE BEH WITH KHAH ISOLATED FORM" +
	"ARABIC LIGATURE BEH WITH MEEM ISOLATED FORMARABIC LIGATURE BEH WITH ALEF" +
	" MAKSURA ISOLATED FORMARABIC LIGATURE BEH WITH YEH ISOLATED FORMARABIC L" +
	"IGATURE TEH WITH JEEM ISOLATED FORMARABIC LIGATURE TEH WITH HAH ISOLATED" +
	" FORMARABIC LIGATURE TEH WITH KHAH ISOLATED FORMARABIC LIGATURE TEH WITH" +
	" MEEM ISOLATED FORMARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORMAR" +
	"ABIC LIGATURE TEH WITH YEH ISOLATED FORMARABIC LIGATURE THEH WITH JEEM I" +
	"SOLATED FORMARABIC LIGATURE THEH WITH MEEM ISOLATED FORMARABIC LIGATURE " +
	"THEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE THEH WITH YEH ISOLAT" +
	"ED FORMARABIC LIGATURE JEEM WITH HAH ISOLATED FORMARABIC LIGATURE JEEM W" +
	"ITH MEEM ISOLATED FORMARABIC LIGATURE HAH WITH JEEM ISOLATED FORMARABIC " +
	"LIGATURE HAH WITH MEEM ISOLATED FORMARABIC LIGATURE KHAH WITH JEEM ISOLA" +
	"TED FORMARABIC LIGATURE KHAH WITH HAH ISOLATED FORMARABIC LIGATURE KHAH " +
	"WITH MEEM ISOLATED FORMARABIC LIGATURE SEEN WITH JEEM ISOLATED FORMARABI" +
	"C LIGATURE SEEN WITH HAH ISOLATED FORMARABIC LIGATURE SEEN WITH KHAH ISO" +
	"LATED FORMARABIC LIGATURE SEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SA" +
	"D WITH HAH ISOLATED FORMARABIC LIGATURE SAD WITH MEEM ISOLATED FORMARABI" +
	"C LIGATURE DAD WITH JEEM ISOLATED FORMARABIC LIGATURE DAD WITH HAH ISOLA" +
	"TED FORMARABIC LIGATURE DAD WITH KHAH ISOLATED FORMARABIC LIGATURE DAD W") + ("" +
	"ITH MEEM ISOLATED FORMARABIC LIGATURE TAH WITH HAH ISOLATED FORMARABIC L" +
	"IGATURE TAH WITH MEEM ISOLATED FORMARABIC LIGATURE ZAH WITH MEEM ISOLATE" +
	"D FORMARABIC LIGATURE AIN WITH JEEM ISOLATED FORMARABIC LIGATURE AIN WIT" +
	"H MEEM ISOLATED FORMARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORMARABIC " +
	"LIGATURE GHAIN WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH JEEM ISOL" +
	"ATED FORMARABIC LIGATURE FEH WITH HAH ISOLATED FORMARABIC LIGATURE FEH W" +
	"ITH KHAH ISOLATED FORMARABIC LIGATURE FEH WITH MEEM ISOLATED FORMARABIC " +
	"LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE FEH WITH YEH" +
	" ISOLATED FORMARABIC LIGATURE QAF WITH HAH ISOLATED FORMARABIC LIGATURE " +
	"QAF WITH MEEM ISOLATED FORMARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATE" +
	"D FORMARABIC LIGATURE QAF WITH YEH ISOLATED FORMARABIC LIGATURE KAF WITH" +
	" ALEF ISOLATED FORMARABIC LIGATURE KAF WITH JEEM ISOLATED FORMARABIC LIG" +
	"ATURE KAF WITH HAH ISOLATED FORMARABIC LIGATURE KAF WITH KHAH ISOLATED F" +
	"ORMARABIC LIGATURE KAF WITH LAM ISOLATED FORMARABIC LIGATURE KAF WITH ME" +
	"EM ISOLATED FORMARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORMARABI" +
	"C LIGATURE KAF WITH YEH ISOLATED FORMARABIC LIGATURE LAM WITH JEEM ISOLA" +
	"TED FORMARABIC LIGATURE LAM WITH HAH ISOLATED FORMARABIC LIGATURE LAM WI" +
	"TH KHAH ISOLATED FORMARABIC LIGATURE LAM WITH MEEM ISOLATED FORMARABIC L" +
	"IGATURE LAM WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE LAM WITH YEH " +
	"ISOLATED FORMARABIC LIGATURE MEEM WITH JEEM ISOLATED FORMARABIC LIGATURE" +
	" MEEM WITH HAH ISOLATED FORMARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM" +
	"ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORMARABIC LIGATURE MEEM WITH AL" +
	"EF MAKSURA ISOLATED FORMARABIC LIGATURE MEEM WITH YEH ISOLATED FORMARABI" +
	"C LIGATURE NOON WITH JEEM ISOLATED FORMARABIC LIGATURE NOON WITH HAH ISO" +
	"LATED FORMARABIC LIGATURE NOON WITH KHAH ISOLATED FORMARABIC LIGATURE NO" +
	"ON WITH MEEM ISOLATED FORMARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATE" +
	"D FORMARABIC LIGATURE NOON WITH YEH ISOLATED FORMARABIC LIGATURE HEH WIT" +
	"H JEEM ISOLATED FORMARABIC LIGATURE HEH WITH MEEM ISOLATED FORMARABIC LI" +
	"GATURE HEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE HEH WITH YEH I" +
	"SOLATED FORMARABIC LIGATURE YEH WITH JEEM ISOLATED FORMARABIC LIGATURE Y" +
	"EH WITH HAH ISOLATED FORMARABIC LIGATURE YEH WITH KHAH ISOLATED FORMARAB" +
	"IC LIGATURE YEH WITH MEEM ISOLATED FORMARABIC LIGATURE YEH WITH ALEF MAK" +
	"SURA ISOLATED FORMARABIC LIGATURE YEH WITH YEH ISOLATED FORMARABIC LIGAT" +
	"URE THAL WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE REH WITH SUP" +
	"ERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT" +
	" ALEF ISOLATED FORMARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORMARA" +
	"BIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORMARABIC LIGATURE SHADDA WI" +
	"TH FATHA ISOLATED FORMARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORMARA" +
	"BIC LIGATURE SHADDA WITH KASRA ISOLATED FORMARABIC LIGATURE SHADDA WITH " +
	"SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH " +
	"REH FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORMA" +
	"RABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORMARABIC LIGATURE " +
	"YEH WITH HAMZA ABOVE WITH NOON FINAL FORMARABIC LIGATURE YEH WITH HAMZA " +
	"ABOVE WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE W" +
	"ITH YEH FINAL FORMARABIC LIGATURE BEH WITH REH FINAL FORMARABIC LIGATURE" +
	" BEH WITH ZAIN FINAL FORMARABIC LIGATURE BEH WITH MEEM FINAL FORMARABIC " +
	"LIGATURE BEH WITH NOON FINAL FORMARABIC LIGATURE BEH WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE BEH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH" +
	" REH FINAL FORMARABIC LIGATURE TEH WITH ZAIN FINAL FORMARABIC LIGATURE T" +
	"EH WITH MEEM FINAL FORMARABIC LIGATURE TEH WITH NOON FINAL FORMARABIC LI" +
	"GATURE TEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH YEH FINA" +
	"L FORMARABIC LIGATURE THEH WITH REH FINAL FORMARABIC LIGATURE THEH WITH " +
	"ZAIN FINAL FORMARABIC LIGATURE THEH WITH MEEM FINAL FORMARABIC LIGATURE " +
	"THEH WITH NOON FINAL FORMARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FO" +
	"RMARABIC LIGATURE THEH WITH YEH FINAL FORMARABIC LIGATURE FEH WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE FEH WITH YEH FINAL FORMARABIC LIGATURE" +
	" QAF WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE QAF WITH YEH FINAL FORM" +
	"ARABIC LIGATURE KAF WITH ALEF FINAL FORMARABIC LIGATURE KAF WITH LAM FIN" +
	"AL FORMARABIC LIGATURE KAF WITH MEEM FINAL FORMARABIC LIGATURE KAF WITH " +
	"ALEF MAKSURA FINAL FORMARABIC LIGATURE KAF WITH YEH FINAL FORMARABIC LIG" +
	"ATURE LAM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH ALEF MAKSURA FINA" +
	"L FORMARABIC LIGATURE LAM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH A" +
	"LEF FINAL FORMARABIC LIGATURE MEEM WITH MEEM FINAL FORMARABIC LIGATURE N" +
	"OON WITH REH FINAL FORMARABIC LIGATURE NOON WITH ZAIN FINAL FORMARABIC L") + ("" +
	"IGATURE NOON WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH NOON FINAL FO" +
	"RMARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON " +
	"WITH YEH FINAL FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FI" +
	"NAL FORMARABIC LIGATURE YEH WITH REH FINAL FORMARABIC LIGATURE YEH WITH " +
	"ZAIN FINAL FORMARABIC LIGATURE YEH WITH MEEM FINAL FORMARABIC LIGATURE Y" +
	"EH WITH NOON FINAL FORMARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORMA" +
	"RABIC LIGATURE YEH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABO" +
	"VE WITH JEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH I" +
	"NITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORMARABIC LIGATURE" +
	" YEH WITH HAMZA ABOVE WITH HEH INITIAL FORMARABIC LIGATURE BEH WITH JEEM" +
	" INITIAL FORMARABIC LIGATURE BEH WITH HAH INITIAL FORMARABIC LIGATURE BE" +
	"H WITH KHAH INITIAL FORMARABIC LIGATURE BEH WITH MEEM INITIAL FORMARABIC" +
	" LIGATURE BEH WITH HEH INITIAL FORMARABIC LIGATURE TEH WITH JEEM INITIAL" +
	" FORMARABIC LIGATURE TEH WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH K" +
	"HAH INITIAL FORMARABIC LIGATURE TEH WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E TEH WITH HEH INITIAL FORMARABIC LIGATURE THEH WITH MEEM INITIAL FORMAR" +
	"ABIC LIGATURE JEEM WITH HAH INITIAL FORMARABIC LIGATURE JEEM WITH MEEM I" +
	"NITIAL FORMARABIC LIGATURE HAH WITH JEEM INITIAL FORMARABIC LIGATURE HAH" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE KHAH WITH JEEM INITIAL FORMARABIC" +
	" LIGATURE KHAH WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM INIT" +
	"IAL FORMARABIC LIGATURE SEEN WITH HAH INITIAL FORMARABIC LIGATURE SEEN W" +
	"ITH KHAH INITIAL FORMARABIC LIGATURE SEEN WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE SAD WITH HAH INITIAL FORMARABIC LIGATURE SAD WITH KHAH INITIAL F" +
	"ORMARABIC LIGATURE SAD WITH MEEM INITIAL FORMARABIC LIGATURE DAD WITH JE" +
	"EM INITIAL FORMARABIC LIGATURE DAD WITH HAH INITIAL FORMARABIC LIGATURE " +
	"DAD WITH KHAH INITIAL FORMARABIC LIGATURE DAD WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE TAH WITH HAH INITIAL FORMARABIC LIGATURE ZAH WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE AIN WITH JEEM INITIAL FORMARABIC LIGATURE AIN WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE GHAIN WITH JEEM INITIAL FORMARABIC LI" +
	"GATURE GHAIN WITH MEEM INITIAL FORMARABIC LIGATURE FEH WITH JEEM INITIAL" +
	" FORMARABIC LIGATURE FEH WITH HAH INITIAL FORMARABIC LIGATURE FEH WITH K" +
	"HAH INITIAL FORMARABIC LIGATURE FEH WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E QAF WITH HAH INITIAL FORMARABIC LIGATURE QAF WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE KAF WITH JEEM INITIAL FORMARABIC LIGATURE KAF WITH HAH INIT" +
	"IAL FORMARABIC LIGATURE KAF WITH KHAH INITIAL FORMARABIC LIGATURE KAF WI" +
	"TH LAM INITIAL FORMARABIC LIGATURE KAF WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE LAM WITH JEEM INITIAL FORMARABIC LIGATURE LAM WITH HAH INITIAL FORM" +
	"ARABIC LIGATURE LAM WITH KHAH INITIAL FORMARABIC LIGATURE LAM WITH MEEM " +
	"INITIAL FORMARABIC LIGATURE LAM WITH HEH INITIAL FORMARABIC LIGATURE MEE" +
	"M WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH HAH INITIAL FORMARABIC" +
	" LIGATURE MEEM WITH KHAH INITIAL FORMARABIC LIGATURE MEEM WITH MEEM INIT" +
	"IAL FORMARABIC LIGATURE NOON WITH JEEM INITIAL FORMARABIC LIGATURE NOON " +
	"WITH HAH INITIAL FORMARABIC LIGATURE NOON WITH KHAH INITIAL FORMARABIC L" +
	"IGATURE NOON WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HEH INITIAL" +
	" FORMARABIC LIGATURE HEH WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH " +
	"MEEM INITIAL FORMARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORMA" +
	"RABIC LIGATURE YEH WITH JEEM INITIAL FORMARABIC LIGATURE YEH WITH HAH IN" +
	"ITIAL FORMARABIC LIGATURE YEH WITH KHAH INITIAL FORMARABIC LIGATURE YEH " +
	"WITH MEEM INITIAL FORMARABIC LIGATURE YEH WITH HEH INITIAL FORMARABIC LI" +
	"GATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WIT" +
	"H HAMZA ABOVE WITH HEH MEDIAL FORMARABIC LIGATURE BEH WITH MEEM MEDIAL F" +
	"ORMARABIC LIGATURE BEH WITH HEH MEDIAL FORMARABIC LIGATURE TEH WITH MEEM" +
	" MEDIAL FORMARABIC LIGATURE TEH WITH HEH MEDIAL FORMARABIC LIGATURE THEH" +
	" WITH MEEM MEDIAL FORMARABIC LIGATURE THEH WITH HEH MEDIAL FORMARABIC LI" +
	"GATURE SEEN WITH MEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HEH MEDIAL FO" +
	"RMARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORMARABIC LIGATURE SHEEN WITH " +
	"HEH MEDIAL FORMARABIC LIGATURE KAF WITH LAM MEDIAL FORMARABIC LIGATURE K" +
	"AF WITH MEEM MEDIAL FORMARABIC LIGATURE LAM WITH MEEM MEDIAL FORMARABIC " +
	"LIGATURE NOON WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH HEH MEDIAL " +
	"FORMARABIC LIGATURE YEH WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HE" +
	"H MEDIAL FORMARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORMARABIC LIGATUR" +
	"E SHADDA WITH DAMMA MEDIAL FORMARABIC LIGATURE SHADDA WITH KASRA MEDIAL " +
	"FORMARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE T") + ("" +
	"AH WITH YEH ISOLATED FORMARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED " +
	"FORMARABIC LIGATURE AIN WITH YEH ISOLATED FORMARABIC LIGATURE GHAIN WITH" +
	" ALEF MAKSURA ISOLATED FORMARABIC LIGATURE GHAIN WITH YEH ISOLATED FORMA" +
	"RABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SEEN " +
	"WITH YEH ISOLATED FORMARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED F" +
	"ORMARABIC LIGATURE SHEEN WITH YEH ISOLATED FORMARABIC LIGATURE HAH WITH " +
	"ALEF MAKSURA ISOLATED FORMARABIC LIGATURE HAH WITH YEH ISOLATED FORMARAB" +
	"IC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE JEEM WIT" +
	"H YEH ISOLATED FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORMA" +
	"RABIC LIGATURE KHAH WITH YEH ISOLATED FORMARABIC LIGATURE SAD WITH ALEF " +
	"MAKSURA ISOLATED FORMARABIC LIGATURE SAD WITH YEH ISOLATED FORMARABIC LI" +
	"GATURE DAD WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE DAD WITH YEH I" +
	"SOLATED FORMARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORMARABIC LIGATURE" +
	" SHEEN WITH HAH ISOLATED FORMARABIC LIGATURE SHEEN WITH KHAH ISOLATED FO" +
	"RMARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SHEEN WIT" +
	"H REH ISOLATED FORMARABIC LIGATURE SEEN WITH REH ISOLATED FORMARABIC LIG" +
	"ATURE SAD WITH REH ISOLATED FORMARABIC LIGATURE DAD WITH REH ISOLATED FO" +
	"RMARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TAH WI" +
	"TH YEH FINAL FORMARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE AIN WITH YEH FINAL FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE GHAIN WITH YEH FINAL FORMARABIC LIGATURE SEEN " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH YEH FINAL FORMARAB" +
	"IC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SHEEN WITH" +
	" YEH FINAL FORMARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORMARABIC LI" +
	"GATURE HAH WITH YEH FINAL FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA FIN" +
	"AL FORMARABIC LIGATURE JEEM WITH YEH FINAL FORMARABIC LIGATURE KHAH WITH" +
	" ALEF MAKSURA FINAL FORMARABIC LIGATURE KHAH WITH YEH FINAL FORMARABIC L" +
	"IGATURE SAD WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH YEH FIN" +
	"AL FORMARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE D" +
	"AD WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH JEEM FINAL FORMARABIC L" +
	"IGATURE SHEEN WITH HAH FINAL FORMARABIC LIGATURE SHEEN WITH KHAH FINAL F" +
	"ORMARABIC LIGATURE SHEEN WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH " +
	"REH FINAL FORMARABIC LIGATURE SEEN WITH REH FINAL FORMARABIC LIGATURE SA" +
	"D WITH REH FINAL FORMARABIC LIGATURE DAD WITH REH FINAL FORMARABIC LIGAT" +
	"URE SHEEN WITH JEEM INITIAL FORMARABIC LIGATURE SHEEN WITH HAH INITIAL F" +
	"ORMARABIC LIGATURE SHEEN WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WIT" +
	"H MEEM INITIAL FORMARABIC LIGATURE SEEN WITH HEH INITIAL FORMARABIC LIGA" +
	"TURE SHEEN WITH HEH INITIAL FORMARABIC LIGATURE TAH WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE SEEN WITH JEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HA" +
	"H MEDIAL FORMARABIC LIGATURE SEEN WITH KHAH MEDIAL FORMARABIC LIGATURE S" +
	"HEEN WITH JEEM MEDIAL FORMARABIC LIGATURE SHEEN WITH HAH MEDIAL FORMARAB" +
	"IC LIGATURE SHEEN WITH KHAH MEDIAL FORMARABIC LIGATURE TAH WITH MEEM MED" +
	"IAL FORMARABIC LIGATURE ZAH WITH MEEM MEDIAL FORMARABIC LIGATURE ALEF WI" +
	"TH FATHATAN FINAL FORMARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORMOR" +
	"NATE LEFT PARENTHESISORNATE RIGHT PARENTHESISARABIC LIGATURE RAHIMAHU AL" +
	"LAAHARABIC LIGATURE RADI ALLAAHU ANHARABIC LIGATURE RADI ALLAAHU ANHAAAR" +
	"ABIC LIGATURE RADI ALLAAHU ANHUMARABIC LIGATURE RADI ALLAAHU ANHUMAAARAB" +
	"IC LIGATURE RADI ALLAAHU ANHUNNAARABIC LIGATURE SALLALLAAHU ALAYHI WA-AA" +
	"LIHARABIC LIGATURE ALAYHI AS-SALAAMARABIC LIGATURE ALAYHIM AS-SALAAMARAB" +
	"IC LIGATURE ALAYHIMAA AS-SALAAMARABIC LIGATURE ALAYHI AS-SALAATU WAS-SAL" +
	"AAMARABIC LIGATURE QUDDISA SIRRAHARABIC LIGATURE SALLALLAHU ALAYHI WAAAL" +
	"IHEE WA-SALLAMARABIC LIGATURE ALAYHAA AS-SALAAMARABIC LIGATURE TABAARAKA" +
	" WA-TAAALAAARABIC LIGATURE RAHIMAHUM ALLAAHARABIC LIGATURE TEH WITH JEEM" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM" +
	"ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE TEH W" +
	"ITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH KHAH WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIG" +
	"ATURE TEH WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH MEEM W" +
	"ITH KHAH INITIAL FORMARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORMA" +
	"RABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE HAH W" +
	"ITH MEEM WITH YEH FINAL FORMARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKS" +
	"URA FINAL FORMARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORMARABIC" +
	" LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH " +
	"JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH") + ("" +
	" FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORMARABIC LI" +
	"GATURE SEEN WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH ME" +
	"EM WITH MEEM FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL " +
	"FORMARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORMARABIC LIGATURE SAD " +
	"WITH HAH WITH HAH INITIAL FORMARABIC LIGATURE SAD WITH MEEM WITH MEEM FI" +
	"NAL FORMARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORMARABIC LIGATU" +
	"RE SHEEN WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE SHEEN WITH JEEM " +
	"WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORMA" +
	"RABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE SHE" +
	"EN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH ME" +
	"EM INITIAL FORMARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM" +
	"ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE DAD WI" +
	"TH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH HAH FIN" +
	"AL FORMARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORMARABIC LIGATUR" +
	"E TAH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH" +
	" YEH FINAL FORMARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORMARABIC " +
	"LIGATURE AIN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORMARABIC LIGA" +
	"TURE GHAIN WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE GHAIN WITH MEEM " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE FEH WITH KHAH WITH MEEM FINA" +
	"L FORMARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E QAF WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH ME" +
	"EM FINAL FORMARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORMARABIC LIG" +
	"ATURE LAM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH HAH WITH " +
	"ALEF MAKSURA FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL F" +
	"ORMARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORMARABIC LIGATURE LAM" +
	" WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM I" +
	"NITIAL FORMARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORMARABIC LIGAT" +
	"URE LAM WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH HAH WIT" +
	"H JEEM INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE MEEM WIT" +
	"H JEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH MEEM INI" +
	"TIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORMARABIC LIG" +
	"ATURE MEEM WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE RAHMATU ALLAA" +
	"HI ALAYHARABIC LIGATURE RAHMATU ALLAAHI ALAYHAAARABIC LIGATURE MEEM WITH" +
	" JEEM WITH KHAH INITIAL FORMARABIC LIGATURE HEH WITH MEEM WITH JEEM INIT" +
	"IAL FORMARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGAT" +
	"URE NOON WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WI" +
	"TH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL" +
	" FORMARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E NOON WITH JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH M" +
	"EEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORMARABIC LIGAT" +
	"URE YEH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH KHAH WI" +
	"TH YEH FINAL FORMARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORMARABIC" +
	" LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH " +
	"WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH ALEF MAK" +
	"SURA FINAL FORMARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORMARABIC L" +
	"IGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM W" +
	"ITH MEEM WITH YEH FINAL FORMARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKS" +
	"URA FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FOR" +
	"MARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGAT" +
	"URE SAD WITH HAH WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH " +
	"YEH FINAL FORMARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORMARABIC LIG" +
	"ATURE LAM WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM WIT" +
	"H YEH FINAL FORMARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORMARABIC L" +
	"IGATURE YEH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE YEH WITH MEEM W" +
	"ITH YEH FINAL FORMARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORMARAB" +
	"IC LIGATURE QAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH H" +
	"AH WITH YEH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FOR" +
	"MARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN " +
	"WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH YEH FINA" +
	"L FORMARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORMARABIC LIGATUR") + ("" +
	"E MEEM WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH M" +
	"EEM INITIAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORMARABIC" +
	" LIGATURE LAM WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JE" +
	"EM WITH HAH FINAL FORMARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORMA" +
	"RABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WIT" +
	"H JEEM WITH YEH FINAL FORMARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL F" +
	"ORMARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE KAF W" +
	"ITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH JEEM WITH MEEM I" +
	"NITIAL FORMARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORMARABIC LI" +
	"GATURE SEEN WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM " +
	"WITH YEH FINAL FORMARABIC LIGATURE RAHIMAHU ALLAAH TAAALAAARABIC LIGATUR" +
	"E RADI ALLAAHU TAAALAA ANHARABIC LIGATURE RADI ALLAAHU TAAALAA ANHAAARAB" +
	"IC LIGATURE RADI ALLAAHU TAAALAA ANHUMAAARABIC LIGATURE SALLALLAHU ALAYH" +
	"I WA-ALAA AALIHEE WA-SALLAMARABIC LIGATURE AJJAL ALLAAHU TAAALAA FARAJAH" +
	"U ASH-SHAREEFARABIC LIGATURE KARRAMA ALLAAHU WAJHAHARABIC LIGATURE SALAA" +
	"MUHU ALAYNAAARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FOR" +
	"MARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGA" +
	"TURE ALLAH ISOLATED FORMARABIC LIGATURE AKBAR ISOLATED FORMARABIC LIGATU" +
	"RE MOHAMMAD ISOLATED FORMARABIC LIGATURE SALAM ISOLATED FORMARABIC LIGAT" +
	"URE RASOUL ISOLATED FORMARABIC LIGATURE ALAYHE ISOLATED FORMARABIC LIGAT" +
	"URE WASALLAM ISOLATED FORMARABIC LIGATURE SALLA ISOLATED FORMARABIC LIGA" +
	"TURE SALLALLAHOU ALAYHE WASALLAMARABIC LIGATURE JALLAJALALOUHOURIAL SIGN" +
	"ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEMARABIC LIGATURE SUBHAANAHU " +
	"WA TAAALAAARABIC LIGATURE AZZA WA JALLVARIATION SELECTOR-1VARIATION SELE" +
	"CTOR-2VARIATION SELECTOR-3VARIATION SELECTOR-4VARIATION SELECTOR-5VARIAT" +
	"ION SELECTOR-6VARIATION SELECTOR-7VARIATION SELECTOR-8VARIATION SELECTOR" +
	"-9VARIATION SELECTOR-10VARIATION SELECTOR-11VARIATION SELECTOR-12VARIATI" +
	"ON SELECTOR-13VARIATION SELECTOR-14VARIATION SELECTOR-15VARIATION SELECT" +
	"OR-16PRESENTATION FORM FOR VERTICAL COMMAPRESENTATION FORM FOR VERTICAL " +
	"IDEOGRAPHIC COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRE" +
	"SENTATION FORM FOR VERTICAL COLONPRESENTATION FORM FOR VERTICAL SEMICOLO" +
	"NPRESENTATION FORM FOR VERTICAL EXCLAMATION MARKPRESENTATION FORM FOR VE" +
	"RTICAL QUESTION MARKPRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR" +
	" BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRE" +
	"SENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT H" +
	"ALFCOMBINING LIGATURE RIGHT HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBININ" +
	"G DOUBLE TILDE RIGHT HALFCOMBINING MACRON LEFT HALFCOMBINING MACRON RIGH" +
	"T HALFCOMBINING CONJOINING MACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBI" +
	"NING LIGATURE RIGHT HALF BELOWCOMBINING TILDE LEFT HALF BELOWCOMBINING T" +
	"ILDE RIGHT HALF BELOWCOMBINING MACRON LEFT HALF BELOWCOMBINING MACRON RI" +
	"GHT HALF BELOWCOMBINING CONJOINING MACRON BELOWCOMBINING CYRILLIC TITLO " +
	"LEFT HALFCOMBINING CYRILLIC TITLO RIGHT HALFPRESENTATION FORM FOR VERTIC" +
	"AL TWO DOT LEADERPRESENTATION FORM FOR VERTICAL EM DASHPRESENTATION FORM" +
	" FOR VERTICAL EN DASHPRESENTATION FORM FOR VERTICAL LOW LINEPRESENTATION" +
	" FORM FOR VERTICAL WAVY LOW LINEPRESENTATION FORM FOR VERTICAL LEFT PARE" +
	"NTHESISPRESENTATION FORM FOR VERTICAL RIGHT PARENTHESISPRESENTATION FORM" +
	" FOR VERTICAL LEFT CURLY BRACKETPRESENTATION FORM FOR VERTICAL RIGHT CUR" +
	"LY BRACKETPRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRES" +
	"ENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKETPRESENTATION FORM" +
	" FOR VERTICAL LEFT BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICA" +
	"L RIGHT BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL LEFT DOUB" +
	"LE ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKE" +
	"TPRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKETPRESENTATION FORM FOR " +
	"VERTICAL RIGHT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL LEFT CORNER B" +
	"RACKETPRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKETPRESENTATION FO" +
	"RM FOR VERTICAL LEFT WHITE CORNER BRACKETPRESENTATION FORM FOR VERTICAL " +
	"RIGHT WHITE CORNER BRACKETSESAME DOTWHITE SESAME DOTPRESENTATION FORM FO" +
	"R VERTICAL LEFT SQUARE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT SQUAR" +
	"E BRACKETDASHED OVERLINECENTRELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVER" +
	"LINEDASHED LOW LINECENTRELINE LOW LINEWAVY LOW LINESMALL COMMASMALL IDEO" +
	"GRAPHIC COMMASMALL FULL STOPSMALL SEMICOLONSMALL COLONSMALL QUESTION MAR" +
	"KSMALL EXCLAMATION MARKSMALL EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PA" +
	"RENTHESISSMALL LEFT CURLY BRACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TOR" +
	"TOISE SHELL BRACKETSMALL RIGHT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSM") + ("" +
	"ALL AMPERSANDSMALL ASTERISKSMALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-T" +
	"HAN SIGNSMALL GREATER-THAN SIGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMA" +
	"LL DOLLAR SIGNSMALL PERCENT SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLA" +
	"TED FORMARABIC TATWEEL WITH FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMA" +
	"RABIC TAIL FRAGMENTARABIC KASRATAN ISOLATED FORMARABIC FATHA ISOLATED FO" +
	"RMARABIC FATHA MEDIAL FORMARABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL " +
	"FORMARABIC KASRA ISOLATED FORMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOL" +
	"ATED FORMARABIC SHADDA MEDIAL FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN" +
	" MEDIAL FORMARABIC LETTER HAMZA ISOLATED FORMARABIC LETTER ALEF WITH MAD" +
	"DA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORMARAB" +
	"IC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH HAM" +
	"ZA ABOVE FINAL FORMARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORMARABI" +
	"C LETTER WAW WITH HAMZA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA BE" +
	"LOW ISOLATED FORMARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORMARABIC LE" +
	"TTER YEH WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER YEH WITH HAMZA ABOV" +
	"E FINAL FORMARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORMARABIC LETTER" +
	" YEH WITH HAMZA ABOVE MEDIAL FORMARABIC LETTER ALEF ISOLATED FORMARABIC " +
	"LETTER ALEF FINAL FORMARABIC LETTER BEH ISOLATED FORMARABIC LETTER BEH F" +
	"INAL FORMARABIC LETTER BEH INITIAL FORMARABIC LETTER BEH MEDIAL FORMARAB" +
	"IC LETTER TEH MARBUTA ISOLATED FORMARABIC LETTER TEH MARBUTA FINAL FORMA" +
	"RABIC LETTER TEH ISOLATED FORMARABIC LETTER TEH FINAL FORMARABIC LETTER " +
	"TEH INITIAL FORMARABIC LETTER TEH MEDIAL FORMARABIC LETTER THEH ISOLATED" +
	" FORMARABIC LETTER THEH FINAL FORMARABIC LETTER THEH INITIAL FORMARABIC " +
	"LETTER THEH MEDIAL FORMARABIC LETTER JEEM ISOLATED FORMARABIC LETTER JEE" +
	"M FINAL FORMARABIC LETTER JEEM INITIAL FORMARABIC LETTER JEEM MEDIAL FOR" +
	"MARABIC LETTER HAH ISOLATED FORMARABIC LETTER HAH FINAL FORMARABIC LETTE" +
	"R HAH INITIAL FORMARABIC LETTER HAH MEDIAL FORMARABIC LETTER KHAH ISOLAT" +
	"ED FORMARABIC LETTER KHAH FINAL FORMARABIC LETTER KHAH INITIAL FORMARABI" +
	"C LETTER KHAH MEDIAL FORMARABIC LETTER DAL ISOLATED FORMARABIC LETTER DA" +
	"L FINAL FORMARABIC LETTER THAL ISOLATED FORMARABIC LETTER THAL FINAL FOR" +
	"MARABIC LETTER REH ISOLATED FORMARABIC LETTER REH FINAL FORMARABIC LETTE" +
	"R ZAIN ISOLATED FORMARABIC LETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOL" +
	"ATED FORMARABIC LETTER SEEN FINAL FORMARABIC LETTER SEEN INITIAL FORMARA" +
	"BIC LETTER SEEN MEDIAL FORMARABIC LETTER SHEEN ISOLATED FORMARABIC LETTE" +
	"R SHEEN FINAL FORMARABIC LETTER SHEEN INITIAL FORMARABIC LETTER SHEEN ME" +
	"DIAL FORMARABIC LETTER SAD ISOLATED FORMARABIC LETTER SAD FINAL FORMARAB" +
	"IC LETTER SAD INITIAL FORMARABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD" +
	" ISOLATED FORMARABIC LETTER DAD FINAL FORMARABIC LETTER DAD INITIAL FORM" +
	"ARABIC LETTER DAD MEDIAL FORMARABIC LETTER TAH ISOLATED FORMARABIC LETTE" +
	"R TAH FINAL FORMARABIC LETTER TAH INITIAL FORMARABIC LETTER TAH MEDIAL F" +
	"ORMARABIC LETTER ZAH ISOLATED FORMARABIC LETTER ZAH FINAL FORMARABIC LET" +
	"TER ZAH INITIAL FORMARABIC LETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLA" +
	"TED FORMARABIC LETTER AIN FINAL FORMARABIC LETTER AIN INITIAL FORMARABIC" +
	" LETTER AIN MEDIAL FORMARABIC LETTER GHAIN ISOLATED FORMARABIC LETTER GH" +
	"AIN FINAL FORMARABIC LETTER GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL" +
	" FORMARABIC LETTER FEH ISOLATED FORMARABIC LETTER FEH FINAL FORMARABIC L" +
	"ETTER FEH INITIAL FORMARABIC LETTER FEH MEDIAL FORMARABIC LETTER QAF ISO" +
	"LATED FORMARABIC LETTER QAF FINAL FORMARABIC LETTER QAF INITIAL FORMARAB" +
	"IC LETTER QAF MEDIAL FORMARABIC LETTER KAF ISOLATED FORMARABIC LETTER KA" +
	"F FINAL FORMARABIC LETTER KAF INITIAL FORMARABIC LETTER KAF MEDIAL FORMA" +
	"RABIC LETTER LAM ISOLATED FORMARABIC LETTER LAM FINAL FORMARABIC LETTER " +
	"LAM INITIAL FORMARABIC LETTER LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED" +
	" FORMARABIC LETTER MEEM FINAL FORMARABIC LETTER MEEM INITIAL FORMARABIC " +
	"LETTER MEEM MEDIAL FORMARABIC LETTER NOON ISOLATED FORMARABIC LETTER NOO" +
	"N FINAL FORMARABIC LETTER NOON INITIAL FORMARABIC LETTER NOON MEDIAL FOR" +
	"MARABIC LETTER HEH ISOLATED FORMARABIC LETTER HEH FINAL FORMARABIC LETTE" +
	"R HEH INITIAL FORMARABIC LETTER HEH MEDIAL FORMARABIC LETTER WAW ISOLATE" +
	"D FORMARABIC LETTER WAW FINAL FORMARABIC LETTER ALEF MAKSURA ISOLATED FO" +
	"RMARABIC LETTER ALEF MAKSURA FINAL FORMARABIC LETTER YEH ISOLATED FORMAR" +
	"ABIC LETTER YEH FINAL FORMARABIC LETTER YEH INITIAL FORMARABIC LETTER YE" +
	"H MEDIAL FORMARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FOR" +
	"MARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORMARABIC LIGATUR" +
	"E LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH A" +
	"LEF WITH HAMZA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA ") + ("" +
	"BELOW ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL " +
	"FORMARABIC LIGATURE LAM WITH ALEF ISOLATED FORMARABIC LIGATURE LAM WITH " +
	"ALEF FINAL FORMZERO WIDTH NO-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWI" +
	"DTH QUOTATION MARKFULLWIDTH NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PE" +
	"RCENT SIGNFULLWIDTH AMPERSANDFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHE" +
	"SISFULLWIDTH RIGHT PARENTHESISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLW" +
	"IDTH COMMAFULLWIDTH HYPHEN-MINUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULL" +
	"WIDTH DIGIT ZEROFULLWIDTH DIGIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT TH" +
	"REEFULLWIDTH DIGIT FOURFULLWIDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH " +
	"DIGIT SEVENFULLWIDTH DIGIT EIGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLW" +
	"IDTH SEMICOLONFULLWIDTH LESS-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GRE" +
	"ATER-THAN SIGNFULLWIDTH QUESTION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LA" +
	"TIN CAPITAL LETTER AFULLWIDTH LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPI" +
	"TAL LETTER CFULLWIDTH LATIN CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETT" +
	"ER EFULLWIDTH LATIN CAPITAL LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULL" +
	"WIDTH LATIN CAPITAL LETTER HFULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LA" +
	"TIN CAPITAL LETTER JFULLWIDTH LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPI" +
	"TAL LETTER LFULLWIDTH LATIN CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETT" +
	"ER NFULLWIDTH LATIN CAPITAL LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULL" +
	"WIDTH LATIN CAPITAL LETTER QFULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LA" +
	"TIN CAPITAL LETTER SFULLWIDTH LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPI" +
	"TAL LETTER UFULLWIDTH LATIN CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETT" +
	"ER WFULLWIDTH LATIN CAPITAL LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULL" +
	"WIDTH LATIN CAPITAL LETTER ZFULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVER" +
	"SE SOLIDUSFULLWIDTH RIGHT SQUARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLW" +
	"IDTH LOW LINEFULLWIDTH GRAVE ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWID" +
	"TH LATIN SMALL LETTER BFULLWIDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMA" +
	"LL LETTER DFULLWIDTH LATIN SMALL LETTER EFULLWIDTH LATIN SMALL LETTER FF" +
	"ULLWIDTH LATIN SMALL LETTER GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LAT" +
	"IN SMALL LETTER IFULLWIDTH LATIN SMALL LETTER JFULLWIDTH LATIN SMALL LET" +
	"TER KFULLWIDTH LATIN SMALL LETTER LFULLWIDTH LATIN SMALL LETTER MFULLWID" +
	"TH LATIN SMALL LETTER NFULLWIDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMA" +
	"LL LETTER PFULLWIDTH LATIN SMALL LETTER QFULLWIDTH LATIN SMALL LETTER RF" +
	"ULLWIDTH LATIN SMALL LETTER SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LAT" +
	"IN SMALL LETTER UFULLWIDTH LATIN SMALL LETTER VFULLWIDTH LATIN SMALL LET" +
	"TER WFULLWIDTH LATIN SMALL LETTER XFULLWIDTH LATIN SMALL LETTER YFULLWID" +
	"TH LATIN SMALL LETTER ZFULLWIDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LI" +
	"NEFULLWIDTH RIGHT CURLY BRACKETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PAREN" +
	"THESISFULLWIDTH RIGHT WHITE PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHA" +
	"LFWIDTH LEFT CORNER BRACKETHALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOG" +
	"RAPHIC COMMAHALFWIDTH KATAKANA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHAL" +
	"FWIDTH KATAKANA LETTER SMALL AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH" +
	" KATAKANA LETTER SMALL UHALFWIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAK" +
	"ANA LETTER SMALL OHALFWIDTH KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA L" +
	"ETTER SMALL YUHALFWIDTH KATAKANA LETTER SMALL YOHALFWIDTH KATAKANA LETTE" +
	"R SMALL TUHALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATA" +
	"KANA LETTER AHALFWIDTH KATAKANA LETTER IHALFWIDTH KATAKANA LETTER UHALFW" +
	"IDTH KATAKANA LETTER EHALFWIDTH KATAKANA LETTER OHALFWIDTH KATAKANA LETT" +
	"ER KAHALFWIDTH KATAKANA LETTER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH K" +
	"ATAKANA LETTER KEHALFWIDTH KATAKANA LETTER KOHALFWIDTH KATAKANA LETTER S" +
	"AHALFWIDTH KATAKANA LETTER SIHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAK" +
	"ANA LETTER SEHALFWIDTH KATAKANA LETTER SOHALFWIDTH KATAKANA LETTER TAHAL" +
	"FWIDTH KATAKANA LETTER TIHALFWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA " +
	"LETTER TEHALFWIDTH KATAKANA LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWID" +
	"TH KATAKANA LETTER NIHALFWIDTH KATAKANA LETTER NUHALFWIDTH KATAKANA LETT" +
	"ER NEHALFWIDTH KATAKANA LETTER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH K" +
	"ATAKANA LETTER HIHALFWIDTH KATAKANA LETTER HUHALFWIDTH KATAKANA LETTER H" +
	"EHALFWIDTH KATAKANA LETTER HOHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAK" +
	"ANA LETTER MIHALFWIDTH KATAKANA LETTER MUHALFWIDTH KATAKANA LETTER MEHAL" +
	"FWIDTH KATAKANA LETTER MOHALFWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA " +
	"LETTER YUHALFWIDTH KATAKANA LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWID" +
	"TH KATAKANA LETTER RIHALFWIDTH KATAKANA LETTER RUHALFWIDTH KATAKANA LETT" +
	"ER REHALFWIDTH KATAKANA LETTER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH K" +
	"ATAKANA LETTER NHALFWIDTH KATAKANA VOICED SOUND MARKHALFWIDTH KATAKANA S") + ("" +
	"EMI-VOICED SOUND MARKHALFWIDTH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYE" +
	"OKHALFWIDTH HANGUL LETTER SSANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOS" +
	"HALFWIDTH HANGUL LETTER NIEUNHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDT" +
	"H HANGUL LETTER NIEUN-HIEUHHALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGU" +
	"L LETTER SSANGTIKEUTHALFWIDTH HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER" +
	" RIEUL-KIYEOKHALFWIDTH HANGUL LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER " +
	"RIEUL-PIEUPHALFWIDTH HANGUL LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIE" +
	"UL-THIEUTHHALFWIDTH HANGUL LETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER R" +
	"IEUL-HIEUHHALFWIDTH HANGUL LETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALF" +
	"WIDTH HANGUL LETTER SSANGPIEUPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDT" +
	"H HANGUL LETTER SIOSHALFWIDTH HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LE" +
	"TTER IEUNGHALFWIDTH HANGUL LETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEU" +
	"CHALFWIDTH HANGUL LETTER CHIEUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH" +
	" HANGUL LETTER THIEUTHHALFWIDTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LE" +
	"TTER HIEUHHALFWIDTH HANGUL LETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH H" +
	"ANGUL LETTER YAHALFWIDTH HANGUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALF" +
	"WIDTH HANGUL LETTER EHALFWIDTH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER " +
	"YEHALFWIDTH HANGUL LETTER OHALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LE" +
	"TTER WAEHALFWIDTH HANGUL LETTER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HA" +
	"NGUL LETTER UHALFWIDTH HANGUL LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWI" +
	"DTH HANGUL LETTER WIHALFWIDTH HANGUL LETTER YUHALFWIDTH HANGUL LETTER EU" +
	"HALFWIDTH HANGUL LETTER YIHALFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFU" +
	"LLWIDTH POUND SIGNFULLWIDTH NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BAR" +
	"FULLWIDTH YEN SIGNFULLWIDTH WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWI" +
	"DTH LEFTWARDS ARROWHALFWIDTH UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALF" +
	"WIDTH DOWNWARDS ARROWHALFWIDTH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLI" +
	"NEAR ANNOTATION ANCHORINTERLINEAR ANNOTATION SEPARATORINTERLINEAR ANNOTA" +
	"TION TERMINATOROBJECT REPLACEMENT CHARACTERREPLACEMENT CHARACTERLINEAR B" +
	" SYLLABLE B008 ALINEAR B SYLLABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B" +
	" SYLLABLE B061 OLINEAR B SYLLABLE B010 ULINEAR B SYLLABLE B001 DALINEAR " +
	"B SYLLABLE B045 DELINEAR B SYLLABLE B007 DILINEAR B SYLLABLE B014 DOLINE" +
	"AR B SYLLABLE B051 DULINEAR B SYLLABLE B057 JALINEAR B SYLLABLE B046 JEL" +
	"INEAR B SYLLABLE B036 JOLINEAR B SYLLABLE B065 JULINEAR B SYLLABLE B077 " +
	"KALINEAR B SYLLABLE B044 KELINEAR B SYLLABLE B067 KILINEAR B SYLLABLE B0" +
	"70 KOLINEAR B SYLLABLE B081 KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE" +
	" B013 MELINEAR B SYLLABLE B073 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLA" +
	"BLE B023 MULINEAR B SYLLABLE B006 NALINEAR B SYLLABLE B024 NELINEAR B SY" +
	"LLABLE B030 NILINEAR B SYLLABLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B" +
	" SYLLABLE B003 PALINEAR B SYLLABLE B072 PELINEAR B SYLLABLE B039 PILINEA" +
	"R B SYLLABLE B011 POLINEAR B SYLLABLE B050 PULINEAR B SYLLABLE B016 QALI" +
	"NEAR B SYLLABLE B078 QELINEAR B SYLLABLE B021 QILINEAR B SYLLABLE B032 Q" +
	"OLINEAR B SYLLABLE B060 RALINEAR B SYLLABLE B027 RELINEAR B SYLLABLE B05" +
	"3 RILINEAR B SYLLABLE B002 ROLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE " +
	"B031 SALINEAR B SYLLABLE B009 SELINEAR B SYLLABLE B041 SILINEAR B SYLLAB" +
	"LE B012 SOLINEAR B SYLLABLE B058 SULINEAR B SYLLABLE B059 TALINEAR B SYL" +
	"LABLE B004 TELINEAR B SYLLABLE B037 TILINEAR B SYLLABLE B005 TOLINEAR B " +
	"SYLLABLE B069 TULINEAR B SYLLABLE B054 WALINEAR B SYLLABLE B075 WELINEAR" +
	" B SYLLABLE B040 WILINEAR B SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALIN" +
	"EAR B SYLLABLE B074 ZELINEAR B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2" +
	"LINEAR B SYLLABLE B043 A3LINEAR B SYLLABLE B085 AULINEAR B SYLLABLE B071" +
	" DWELINEAR B SYLLABLE B090 DWOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABL" +
	"E B029 PU2LINEAR B SYLLABLE B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B S" +
	"YLLABLE B033 RA3LINEAR B SYLLABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINE" +
	"AR B SYLLABLE B087 TWELINEAR B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINE" +
	"AR B SYMBOL B019LINEAR B SYMBOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL " +
	"B047LINEAR B SYMBOL B049LINEAR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B" +
	" SYMBOL B064LINEAR B SYMBOL B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083" +
	"LINEAR B SYMBOL B086LINEAR B SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR" +
	" B IDEOGRAM B102 WOMANLINEAR B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 " +
	"EQUIDLINEAR B IDEOGRAM B105F MARELINEAR B IDEOGRAM B105M STALLIONLINEAR " +
	"B IDEOGRAM B106F EWELINEAR B IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F S" +
	"HE-GOATLINEAR B IDEOGRAM B107M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR " +
	"B IDEOGRAM B108M BOARLINEAR B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M " +
	"BULLLINEAR B IDEOGRAM B120 WHEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B ID") + ("" +
	"EOGRAM B122 OLIVELINEAR B IDEOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPE" +
	"RUSLINEAR B MONOGRAM B127 KAPOLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEO" +
	"GRAM B130 OILLINEAR B IDEOGRAM B131 WINELINEAR B IDEOGRAM B132LINEAR B M" +
	"ONOGRAM B133 AREPALINEAR B MONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRON" +
	"ZELINEAR B IDEOGRAM B141 GOLDLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B14" +
	"5 WOOLLINEAR B IDEOGRAM B146LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151" +
	" HORNLINEAR B IDEOGRAM B152LINEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154L" +
	"INEAR B MONOGRAM B156 TURO2LINEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158L" +
	"INEAR B IDEOGRAM B159 CLOTHLINEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161L" +
	"INEAR B IDEOGRAM B162 GARMENTLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOG" +
	"RAM B164LINEAR B IDEOGRAM B165LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B1" +
	"67LINEAR B IDEOGRAM B168LINEAR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINE" +
	"AR B IDEOGRAM B171LINEAR B IDEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINE" +
	"AR B IDEOGRAM B174LINEAR B IDEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEA" +
	"R B IDEOGRAM B178LINEAR B IDEOGRAM B179LINEAR B IDEOGRAM B180LINEAR B ID" +
	"EOGRAM B181LINEAR B IDEOGRAM B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM" +
	" B184LINEAR B IDEOGRAM B185LINEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190L" +
	"INEAR B IDEOGRAM B191 HELMETLINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDE" +
	"OGRAM B225 BATHTUBLINEAR B IDEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARR" +
	"OWLINEAR B IDEOGRAM B232LINEAR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B2" +
	"34LINEAR B IDEOGRAM B236LINEAR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B I" +
	"DEOGRAM B241 CHARIOTLINEAR B IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRA" +
	"M B243 WHEELLINEAR B IDEOGRAM B245LINEAR B IDEOGRAM B246LINEAR B MONOGRA" +
	"M B247 DIPTELINEAR B IDEOGRAM B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRA" +
	"M B251LINEAR B IDEOGRAM B252LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254" +
	" DARTLINEAR B IDEOGRAM B255LINEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257L" +
	"INEAR B IDEOGRAM B258LINEAR B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155" +
	"LINEAR B IDEOGRAM VESSEL B200LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOG" +
	"RAM VESSEL B202LINEAR B IDEOGRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B20" +
	"4LINEAR B IDEOGRAM VESSEL B205LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEO" +
	"GRAM VESSEL B207LINEAR B IDEOGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B2" +
	"09LINEAR B IDEOGRAM VESSEL B210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDE" +
	"OGRAM VESSEL B212LINEAR B IDEOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B" +
	"214LINEAR B IDEOGRAM VESSEL B215LINEAR B IDEOGRAM VESSEL B216LINEAR B ID" +
	"EOGRAM VESSEL B217LINEAR B IDEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL " +
	"B219LINEAR B IDEOGRAM VESSEL B221LINEAR B IDEOGRAM VESSEL B222LINEAR B I" +
	"DEOGRAM VESSEL B226LINEAR B IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL" +
	" B228LINEAR B IDEOGRAM VESSEL B229LINEAR B IDEOGRAM VESSEL B250LINEAR B " +
	"IDEOGRAM VESSEL B305AEGEAN WORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTA" +
	"EGEAN CHECK MARKAEGEAN NUMBER ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEG" +
	"EAN NUMBER FOURAEGEAN NUMBER FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEG" +
	"EAN NUMBER EIGHTAEGEAN NUMBER NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYA" +
	"EGEAN NUMBER THIRTYAEGEAN NUMBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER S" +
	"IXTYAEGEAN NUMBER SEVENTYAEGEAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN " +
	"NUMBER ONE HUNDREDAEGEAN NUMBER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAE" +
	"GEAN NUMBER FOUR HUNDREDAEGEAN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUND" +
	"REDAEGEAN NUMBER SEVEN HUNDREDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER N" +
	"INE HUNDREDAEGEAN NUMBER ONE THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NU" +
	"MBER THREE THOUSANDAEGEAN NUMBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSAN" +
	"DAEGEAN NUMBER SIX THOUSANDAEGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIG" +
	"HT THOUSANDAEGEAN NUMBER NINE THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN N" +
	"UMBER TWENTY THOUSANDAEGEAN NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY TH" +
	"OUSANDAEGEAN NUMBER FIFTY THOUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUM" +
	"BER SEVENTY THOUSANDAEGEAN NUMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY TH" +
	"OUSANDAEGEAN WEIGHT BASE UNITAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SE" +
	"COND SUBUNITAEGEAN WEIGHT THIRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEA" +
	"N DRY MEASURE FIRST SUBUNITAEGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEA" +
	"SURE SECOND SUBUNITAEGEAN MEASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ON" +
	"E QUARTERGREEK ACROPHONIC ATTIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACH" +
	"MAGREEK ACROPHONIC ATTIC FIVEGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONI" +
	"C ATTIC FIVE HUNDREDGREEK ACROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC" +
	" ATTIC FIFTY THOUSANDGREEK ACROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC" +
	" ATTIC TEN TALENTSGREEK ACROPHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC A" +
	"TTIC ONE HUNDRED TALENTSGREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK") + ("" +
	" ACROPHONIC ATTIC ONE THOUSAND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSA" +
	"ND TALENTSGREEK ACROPHONIC ATTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN " +
	"STATERSGREEK ACROPHONIC ATTIC FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HU" +
	"NDRED STATERSGREEK ACROPHONIC ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC" +
	" ATTIC ONE THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN THOUSAND STATERSGR" +
	"EEK ACROPHONIC ATTIC FIFTY THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MN" +
	"ASGREEK ACROPHONIC HERAEUM ONE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREE" +
	"K ACROPHONIC HERMIONIAN ONEGREEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHON" +
	"IC THESPIAN TWOGREEK ACROPHONIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EP" +
	"IDAUREAN TWO DRACHMASGREEK ACROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TR" +
	"OEZENIAN TENGREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHON" +
	"IC HERMIONIAN TENGREEK ACROPHONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN" +
	" TENGREEK ACROPHONIC THESPIAN THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGRE" +
	"EK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN" +
	" FIFTYGREEK ACROPHONIC THESPIAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDR" +
	"EDGREEK ACROPHONIC THESPIAN THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIV" +
	"E HUNDREDGREEK ACROPHONIC TROEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPI" +
	"AN FIVE HUNDREDGREEK ACROPHONIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC N" +
	"AXIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC" +
	" THESPIAN FIVE THOUSANDGREEK ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONI" +
	"C STRATIAN FIFTY MNASGREEK ONE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FO" +
	"RMGREEK TWO THIRDS SIGNGREEK THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TAL" +
	"ENT SIGNGREEK DRACHMA SIGNGREEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE" +
	" OBOLS SIGNGREEK FOUR OBOLS SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGN" +
	"GREEK KYATHOS BASE SIGNGREEK LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIG" +
	"NGREEK ARTABE SIGNGREEK AROURA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE " +
	"SIGNGREEK ZERO SIGNGREEK ONE QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICT" +
	"ION SIGNNOMISMA SIGNROMAN SEXTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIG" +
	"NROMAN SEXTULA SIGNROMAN DIMIDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DEN" +
	"ARIUS SIGNROMAN QUINARIUS SIGNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNR" +
	"OMAN AS SIGNROMAN CENTURIAL SIGNASCIA SYMBOLGREEK SYMBOL TAU RHOPHAISTOS" +
	" DISC SIGN PEDESTRIANPHAISTOS DISC SIGN PLUMED HEADPHAISTOS DISC SIGN TA" +
	"TTOOED HEADPHAISTOS DISC SIGN CAPTIVEPHAISTOS DISC SIGN CHILDPHAISTOS DI" +
	"SC SIGN WOMANPHAISTOS DISC SIGN HELMETPHAISTOS DISC SIGN GAUNTLETPHAISTO" +
	"S DISC SIGN TIARAPHAISTOS DISC SIGN ARROWPHAISTOS DISC SIGN BOWPHAISTOS " +
	"DISC SIGN SHIELDPHAISTOS DISC SIGN CLUBPHAISTOS DISC SIGN MANACLESPHAIST" +
	"OS DISC SIGN MATTOCKPHAISTOS DISC SIGN SAWPHAISTOS DISC SIGN LIDPHAISTOS" +
	" DISC SIGN BOOMERANGPHAISTOS DISC SIGN CARPENTRY PLANEPHAISTOS DISC SIGN" +
	" DOLIUMPHAISTOS DISC SIGN COMBPHAISTOS DISC SIGN SLINGPHAISTOS DISC SIGN" +
	" COLUMNPHAISTOS DISC SIGN BEEHIVEPHAISTOS DISC SIGN SHIPPHAISTOS DISC SI" +
	"GN HORNPHAISTOS DISC SIGN HIDEPHAISTOS DISC SIGN BULLS LEGPHAISTOS DISC " +
	"SIGN CATPHAISTOS DISC SIGN RAMPHAISTOS DISC SIGN EAGLEPHAISTOS DISC SIGN" +
	" DOVEPHAISTOS DISC SIGN TUNNYPHAISTOS DISC SIGN BEEPHAISTOS DISC SIGN PL" +
	"ANE TREEPHAISTOS DISC SIGN VINEPHAISTOS DISC SIGN PAPYRUSPHAISTOS DISC S" +
	"IGN ROSETTEPHAISTOS DISC SIGN LILYPHAISTOS DISC SIGN OX BACKPHAISTOS DIS" +
	"C SIGN FLUTEPHAISTOS DISC SIGN GRATERPHAISTOS DISC SIGN STRAINERPHAISTOS" +
	" DISC SIGN SMALL AXEPHAISTOS DISC SIGN WAVY BANDPHAISTOS DISC SIGN COMBI" +
	"NING OBLIQUE STROKELYCIAN LETTER ALYCIAN LETTER ELYCIAN LETTER BLYCIAN L" +
	"ETTER BHLYCIAN LETTER GLYCIAN LETTER DLYCIAN LETTER ILYCIAN LETTER WLYCI" +
	"AN LETTER ZLYCIAN LETTER THLYCIAN LETTER JLYCIAN LETTER KLYCIAN LETTER Q" +
	"LYCIAN LETTER LLYCIAN LETTER MLYCIAN LETTER NLYCIAN LETTER MMLYCIAN LETT" +
	"ER NNLYCIAN LETTER ULYCIAN LETTER PLYCIAN LETTER KKLYCIAN LETTER RLYCIAN" +
	" LETTER SLYCIAN LETTER TLYCIAN LETTER TTLYCIAN LETTER ANLYCIAN LETTER EN" +
	"LYCIAN LETTER HLYCIAN LETTER XCARIAN LETTER ACARIAN LETTER P2CARIAN LETT" +
	"ER DCARIAN LETTER LCARIAN LETTER UUUCARIAN LETTER RCARIAN LETTER LDCARIA" +
	"N LETTER A2CARIAN LETTER QCARIAN LETTER BCARIAN LETTER MCARIAN LETTER OC" +
	"ARIAN LETTER D2CARIAN LETTER TCARIAN LETTER SHCARIAN LETTER SH2CARIAN LE" +
	"TTER SCARIAN LETTER C-18CARIAN LETTER UCARIAN LETTER NNCARIAN LETTER XCA" +
	"RIAN LETTER NCARIAN LETTER TT2CARIAN LETTER PCARIAN LETTER SSCARIAN LETT" +
	"ER ICARIAN LETTER ECARIAN LETTER UUUUCARIAN LETTER KCARIAN LETTER K2CARI" +
	"AN LETTER NDCARIAN LETTER UUCARIAN LETTER GCARIAN LETTER G2CARIAN LETTER" +
	" STCARIAN LETTER ST2CARIAN LETTER NGCARIAN LETTER IICARIAN LETTER C-39CA" +
	"RIAN LETTER TTCARIAN LETTER UUU2CARIAN LETTER RRCARIAN LETTER MBCARIAN L" +
	"ETTER MB2CARIAN LETTER MB3CARIAN LETTER MB4CARIAN LETTER LD2CARIAN LETTE") + ("" +
	"R E2CARIAN LETTER UUU3COPTIC EPACT THOUSANDS MARKCOPTIC EPACT DIGIT ONEC" +
	"OPTIC EPACT DIGIT TWOCOPTIC EPACT DIGIT THREECOPTIC EPACT DIGIT FOURCOPT" +
	"IC EPACT DIGIT FIVECOPTIC EPACT DIGIT SIXCOPTIC EPACT DIGIT SEVENCOPTIC " +
	"EPACT DIGIT EIGHTCOPTIC EPACT DIGIT NINECOPTIC EPACT NUMBER TENCOPTIC EP" +
	"ACT NUMBER TWENTYCOPTIC EPACT NUMBER THIRTYCOPTIC EPACT NUMBER FORTYCOPT" +
	"IC EPACT NUMBER FIFTYCOPTIC EPACT NUMBER SIXTYCOPTIC EPACT NUMBER SEVENT" +
	"YCOPTIC EPACT NUMBER EIGHTYCOPTIC EPACT NUMBER NINETYCOPTIC EPACT NUMBER" +
	" ONE HUNDREDCOPTIC EPACT NUMBER TWO HUNDREDCOPTIC EPACT NUMBER THREE HUN" +
	"DREDCOPTIC EPACT NUMBER FOUR HUNDREDCOPTIC EPACT NUMBER FIVE HUNDREDCOPT" +
	"IC EPACT NUMBER SIX HUNDREDCOPTIC EPACT NUMBER SEVEN HUNDREDCOPTIC EPACT" +
	" NUMBER EIGHT HUNDREDCOPTIC EPACT NUMBER NINE HUNDREDOLD ITALIC LETTER A" +
	"OLD ITALIC LETTER BEOLD ITALIC LETTER KEOLD ITALIC LETTER DEOLD ITALIC L" +
	"ETTER EOLD ITALIC LETTER VEOLD ITALIC LETTER ZEOLD ITALIC LETTER HEOLD I" +
	"TALIC LETTER THEOLD ITALIC LETTER IOLD ITALIC LETTER KAOLD ITALIC LETTER" +
	" ELOLD ITALIC LETTER EMOLD ITALIC LETTER ENOLD ITALIC LETTER ESHOLD ITAL" +
	"IC LETTER OOLD ITALIC LETTER PEOLD ITALIC LETTER SHEOLD ITALIC LETTER KU" +
	"OLD ITALIC LETTER EROLD ITALIC LETTER ESOLD ITALIC LETTER TEOLD ITALIC L" +
	"ETTER UOLD ITALIC LETTER EKSOLD ITALIC LETTER PHEOLD ITALIC LETTER KHEOL" +
	"D ITALIC LETTER EFOLD ITALIC LETTER ERSOLD ITALIC LETTER CHEOLD ITALIC L" +
	"ETTER IIOLD ITALIC LETTER UUOLD ITALIC LETTER ESSOLD ITALIC NUMERAL ONEO" +
	"LD ITALIC NUMERAL FIVEOLD ITALIC NUMERAL TENOLD ITALIC NUMERAL FIFTYOLD " +
	"ITALIC LETTER YEOLD ITALIC LETTER NORTHERN TSEOLD ITALIC LETTER SOUTHERN" +
	" TSEGOTHIC LETTER AHSAGOTHIC LETTER BAIRKANGOTHIC LETTER GIBAGOTHIC LETT" +
	"ER DAGSGOTHIC LETTER AIHVUSGOTHIC LETTER QAIRTHRAGOTHIC LETTER IUJAGOTHI" +
	"C LETTER HAGLGOTHIC LETTER THIUTHGOTHIC LETTER EISGOTHIC LETTER KUSMAGOT" +
	"HIC LETTER LAGUSGOTHIC LETTER MANNAGOTHIC LETTER NAUTHSGOTHIC LETTER JER" +
	"GOTHIC LETTER URUSGOTHIC LETTER PAIRTHRAGOTHIC LETTER NINETYGOTHIC LETTE" +
	"R RAIDAGOTHIC LETTER SAUILGOTHIC LETTER TEIWSGOTHIC LETTER WINJAGOTHIC L" +
	"ETTER FAIHUGOTHIC LETTER IGGWSGOTHIC LETTER HWAIRGOTHIC LETTER OTHALGOTH" +
	"IC LETTER NINE HUNDREDOLD PERMIC LETTER ANOLD PERMIC LETTER BUROLD PERMI" +
	"C LETTER GAIOLD PERMIC LETTER DOIOLD PERMIC LETTER EOLD PERMIC LETTER ZH" +
	"OIOLD PERMIC LETTER DZHOIOLD PERMIC LETTER ZATAOLD PERMIC LETTER DZITAOL" +
	"D PERMIC LETTER IOLD PERMIC LETTER KOKEOLD PERMIC LETTER LEIOLD PERMIC L" +
	"ETTER MENOEOLD PERMIC LETTER NENOEOLD PERMIC LETTER VOOIOLD PERMIC LETTE" +
	"R PEEIOLD PERMIC LETTER REIOLD PERMIC LETTER SIIOLD PERMIC LETTER TAIOLD" +
	" PERMIC LETTER UOLD PERMIC LETTER CHERYOLD PERMIC LETTER SHOOIOLD PERMIC" +
	" LETTER SHCHOOIOLD PERMIC LETTER YRYOLD PERMIC LETTER YERUOLD PERMIC LET" +
	"TER OOLD PERMIC LETTER OOOLD PERMIC LETTER EFOLD PERMIC LETTER HAOLD PER" +
	"MIC LETTER TSIUOLD PERMIC LETTER VEROLD PERMIC LETTER YEROLD PERMIC LETT" +
	"ER YERIOLD PERMIC LETTER YATOLD PERMIC LETTER IEOLD PERMIC LETTER YUOLD " +
	"PERMIC LETTER YAOLD PERMIC LETTER IACOMBINING OLD PERMIC LETTER ANCOMBIN" +
	"ING OLD PERMIC LETTER DOICOMBINING OLD PERMIC LETTER ZATACOMBINING OLD P" +
	"ERMIC LETTER NENOECOMBINING OLD PERMIC LETTER SIIUGARITIC LETTER ALPAUGA" +
	"RITIC LETTER BETAUGARITIC LETTER GAMLAUGARITIC LETTER KHAUGARITIC LETTER" +
	" DELTAUGARITIC LETTER HOUGARITIC LETTER WOUGARITIC LETTER ZETAUGARITIC L" +
	"ETTER HOTAUGARITIC LETTER TETUGARITIC LETTER YODUGARITIC LETTER KAFUGARI" +
	"TIC LETTER SHINUGARITIC LETTER LAMDAUGARITIC LETTER MEMUGARITIC LETTER D" +
	"HALUGARITIC LETTER NUNUGARITIC LETTER ZUUGARITIC LETTER SAMKAUGARITIC LE" +
	"TTER AINUGARITIC LETTER PUUGARITIC LETTER SADEUGARITIC LETTER QOPAUGARIT" +
	"IC LETTER RASHAUGARITIC LETTER THANNAUGARITIC LETTER GHAINUGARITIC LETTE" +
	"R TOUGARITIC LETTER IUGARITIC LETTER UUGARITIC LETTER SSUUGARITIC WORD D" +
	"IVIDEROLD PERSIAN SIGN AOLD PERSIAN SIGN IOLD PERSIAN SIGN UOLD PERSIAN " +
	"SIGN KAOLD PERSIAN SIGN KUOLD PERSIAN SIGN GAOLD PERSIAN SIGN GUOLD PERS" +
	"IAN SIGN XAOLD PERSIAN SIGN CAOLD PERSIAN SIGN JAOLD PERSIAN SIGN JIOLD " +
	"PERSIAN SIGN TAOLD PERSIAN SIGN TUOLD PERSIAN SIGN DAOLD PERSIAN SIGN DI" +
	"OLD PERSIAN SIGN DUOLD PERSIAN SIGN THAOLD PERSIAN SIGN PAOLD PERSIAN SI" +
	"GN BAOLD PERSIAN SIGN FAOLD PERSIAN SIGN NAOLD PERSIAN SIGN NUOLD PERSIA" +
	"N SIGN MAOLD PERSIAN SIGN MIOLD PERSIAN SIGN MUOLD PERSIAN SIGN YAOLD PE" +
	"RSIAN SIGN VAOLD PERSIAN SIGN VIOLD PERSIAN SIGN RAOLD PERSIAN SIGN RUOL" +
	"D PERSIAN SIGN LAOLD PERSIAN SIGN SAOLD PERSIAN SIGN ZAOLD PERSIAN SIGN " +
	"SHAOLD PERSIAN SIGN SSAOLD PERSIAN SIGN HAOLD PERSIAN SIGN AURAMAZDAAOLD" +
	" PERSIAN SIGN AURAMAZDAA-2OLD PERSIAN SIGN AURAMAZDAAHAOLD PERSIAN SIGN " +
	"XSHAAYATHIYAOLD PERSIAN SIGN DAHYAAUSHOLD PERSIAN SIGN DAHYAAUSH-2OLD PE" +
	"RSIAN SIGN BAGAOLD PERSIAN SIGN BUUMISHOLD PERSIAN WORD DIVIDEROLD PERSI") + ("" +
	"AN NUMBER ONEOLD PERSIAN NUMBER TWOOLD PERSIAN NUMBER TENOLD PERSIAN NUM" +
	"BER TWENTYOLD PERSIAN NUMBER HUNDREDDESERET CAPITAL LETTER LONG IDESERET" +
	" CAPITAL LETTER LONG EDESERET CAPITAL LETTER LONG ADESERET CAPITAL LETTE" +
	"R LONG AHDESERET CAPITAL LETTER LONG ODESERET CAPITAL LETTER LONG OODESE" +
	"RET CAPITAL LETTER SHORT IDESERET CAPITAL LETTER SHORT EDESERET CAPITAL " +
	"LETTER SHORT ADESERET CAPITAL LETTER SHORT AHDESERET CAPITAL LETTER SHOR" +
	"T ODESERET CAPITAL LETTER SHORT OODESERET CAPITAL LETTER AYDESERET CAPIT" +
	"AL LETTER OWDESERET CAPITAL LETTER WUDESERET CAPITAL LETTER YEEDESERET C" +
	"APITAL LETTER HDESERET CAPITAL LETTER PEEDESERET CAPITAL LETTER BEEDESER" +
	"ET CAPITAL LETTER TEEDESERET CAPITAL LETTER DEEDESERET CAPITAL LETTER CH" +
	"EEDESERET CAPITAL LETTER JEEDESERET CAPITAL LETTER KAYDESERET CAPITAL LE" +
	"TTER GAYDESERET CAPITAL LETTER EFDESERET CAPITAL LETTER VEEDESERET CAPIT" +
	"AL LETTER ETHDESERET CAPITAL LETTER THEEDESERET CAPITAL LETTER ESDESERET" +
	" CAPITAL LETTER ZEEDESERET CAPITAL LETTER ESHDESERET CAPITAL LETTER ZHEE" +
	"DESERET CAPITAL LETTER ERDESERET CAPITAL LETTER ELDESERET CAPITAL LETTER" +
	" EMDESERET CAPITAL LETTER ENDESERET CAPITAL LETTER ENGDESERET CAPITAL LE" +
	"TTER OIDESERET CAPITAL LETTER EWDESERET SMALL LETTER LONG IDESERET SMALL" +
	" LETTER LONG EDESERET SMALL LETTER LONG ADESERET SMALL LETTER LONG AHDES" +
	"ERET SMALL LETTER LONG ODESERET SMALL LETTER LONG OODESERET SMALL LETTER" +
	" SHORT IDESERET SMALL LETTER SHORT EDESERET SMALL LETTER SHORT ADESERET " +
	"SMALL LETTER SHORT AHDESERET SMALL LETTER SHORT ODESERET SMALL LETTER SH" +
	"ORT OODESERET SMALL LETTER AYDESERET SMALL LETTER OWDESERET SMALL LETTER" +
	" WUDESERET SMALL LETTER YEEDESERET SMALL LETTER HDESERET SMALL LETTER PE" +
	"EDESERET SMALL LETTER BEEDESERET SMALL LETTER TEEDESERET SMALL LETTER DE" +
	"EDESERET SMALL LETTER CHEEDESERET SMALL LETTER JEEDESERET SMALL LETTER K" +
	"AYDESERET SMALL LETTER GAYDESERET SMALL LETTER EFDESERET SMALL LETTER VE" +
	"EDESERET SMALL LETTER ETHDESERET SMALL LETTER THEEDESERET SMALL LETTER E" +
	"SDESERET SMALL LETTER ZEEDESERET SMALL LETTER ESHDESERET SMALL LETTER ZH" +
	"EEDESERET SMALL LETTER ERDESERET SMALL LETTER ELDESERET SMALL LETTER EMD" +
	"ESERET SMALL LETTER ENDESERET SMALL LETTER ENGDESERET SMALL LETTER OIDES" +
	"ERET SMALL LETTER EWSHAVIAN LETTER PEEPSHAVIAN LETTER TOTSHAVIAN LETTER " +
	"KICKSHAVIAN LETTER FEESHAVIAN LETTER THIGHSHAVIAN LETTER SOSHAVIAN LETTE" +
	"R SURESHAVIAN LETTER CHURCHSHAVIAN LETTER YEASHAVIAN LETTER HUNGSHAVIAN " +
	"LETTER BIBSHAVIAN LETTER DEADSHAVIAN LETTER GAGSHAVIAN LETTER VOWSHAVIAN" +
	" LETTER THEYSHAVIAN LETTER ZOOSHAVIAN LETTER MEASURESHAVIAN LETTER JUDGE" +
	"SHAVIAN LETTER WOESHAVIAN LETTER HA-HASHAVIAN LETTER LOLLSHAVIAN LETTER " +
	"MIMESHAVIAN LETTER IFSHAVIAN LETTER EGGSHAVIAN LETTER ASHSHAVIAN LETTER " +
	"ADOSHAVIAN LETTER ONSHAVIAN LETTER WOOLSHAVIAN LETTER OUTSHAVIAN LETTER " +
	"AHSHAVIAN LETTER ROARSHAVIAN LETTER NUNSHAVIAN LETTER EATSHAVIAN LETTER " +
	"AGESHAVIAN LETTER ICESHAVIAN LETTER UPSHAVIAN LETTER OAKSHAVIAN LETTER O" +
	"OZESHAVIAN LETTER OILSHAVIAN LETTER AWESHAVIAN LETTER ARESHAVIAN LETTER " +
	"ORSHAVIAN LETTER AIRSHAVIAN LETTER ERRSHAVIAN LETTER ARRAYSHAVIAN LETTER" +
	" EARSHAVIAN LETTER IANSHAVIAN LETTER YEWOSMANYA LETTER ALEFOSMANYA LETTE" +
	"R BAOSMANYA LETTER TAOSMANYA LETTER JAOSMANYA LETTER XAOSMANYA LETTER KH" +
	"AOSMANYA LETTER DEELOSMANYA LETTER RAOSMANYA LETTER SAOSMANYA LETTER SHI" +
	"INOSMANYA LETTER DHAOSMANYA LETTER CAYNOSMANYA LETTER GAOSMANYA LETTER F" +
	"AOSMANYA LETTER QAAFOSMANYA LETTER KAAFOSMANYA LETTER LAANOSMANYA LETTER" +
	" MIINOSMANYA LETTER NUUNOSMANYA LETTER WAWOSMANYA LETTER HAOSMANYA LETTE" +
	"R YAOSMANYA LETTER AOSMANYA LETTER EOSMANYA LETTER IOSMANYA LETTER OOSMA" +
	"NYA LETTER UOSMANYA LETTER AAOSMANYA LETTER EEOSMANYA LETTER OOOSMANYA D" +
	"IGIT ZEROOSMANYA DIGIT ONEOSMANYA DIGIT TWOOSMANYA DIGIT THREEOSMANYA DI" +
	"GIT FOUROSMANYA DIGIT FIVEOSMANYA DIGIT SIXOSMANYA DIGIT SEVENOSMANYA DI" +
	"GIT EIGHTOSMANYA DIGIT NINEOSAGE CAPITAL LETTER AOSAGE CAPITAL LETTER AI" +
	"OSAGE CAPITAL LETTER AINOSAGE CAPITAL LETTER AHOSAGE CAPITAL LETTER BRAO" +
	"SAGE CAPITAL LETTER CHAOSAGE CAPITAL LETTER EHCHAOSAGE CAPITAL LETTER EO" +
	"SAGE CAPITAL LETTER EINOSAGE CAPITAL LETTER HAOSAGE CAPITAL LETTER HYAOS" +
	"AGE CAPITAL LETTER IOSAGE CAPITAL LETTER KAOSAGE CAPITAL LETTER EHKAOSAG" +
	"E CAPITAL LETTER KYAOSAGE CAPITAL LETTER LAOSAGE CAPITAL LETTER MAOSAGE " +
	"CAPITAL LETTER NAOSAGE CAPITAL LETTER OOSAGE CAPITAL LETTER OINOSAGE CAP" +
	"ITAL LETTER PAOSAGE CAPITAL LETTER EHPAOSAGE CAPITAL LETTER SAOSAGE CAPI" +
	"TAL LETTER SHAOSAGE CAPITAL LETTER TAOSAGE CAPITAL LETTER EHTAOSAGE CAPI" +
	"TAL LETTER TSAOSAGE CAPITAL LETTER EHTSAOSAGE CAPITAL LETTER TSHAOSAGE C" +
	"APITAL LETTER DHAOSAGE CAPITAL LETTER UOSAGE CAPITAL LETTER WAOSAGE CAPI" +
	"TAL LETTER KHAOSAGE CAPITAL LETTER GHAOSAGE CAPITAL LETTER ZAOSAGE CAPIT") + ("" +
	"AL LETTER ZHAOSAGE SMALL LETTER AOSAGE SMALL LETTER AIOSAGE SMALL LETTER" +
	" AINOSAGE SMALL LETTER AHOSAGE SMALL LETTER BRAOSAGE SMALL LETTER CHAOSA" +
	"GE SMALL LETTER EHCHAOSAGE SMALL LETTER EOSAGE SMALL LETTER EINOSAGE SMA" +
	"LL LETTER HAOSAGE SMALL LETTER HYAOSAGE SMALL LETTER IOSAGE SMALL LETTER" +
	" KAOSAGE SMALL LETTER EHKAOSAGE SMALL LETTER KYAOSAGE SMALL LETTER LAOSA" +
	"GE SMALL LETTER MAOSAGE SMALL LETTER NAOSAGE SMALL LETTER OOSAGE SMALL L" +
	"ETTER OINOSAGE SMALL LETTER PAOSAGE SMALL LETTER EHPAOSAGE SMALL LETTER " +
	"SAOSAGE SMALL LETTER SHAOSAGE SMALL LETTER TAOSAGE SMALL LETTER EHTAOSAG" +
	"E SMALL LETTER TSAOSAGE SMALL LETTER EHTSAOSAGE SMALL LETTER TSHAOSAGE S" +
	"MALL LETTER DHAOSAGE SMALL LETTER UOSAGE SMALL LETTER WAOSAGE SMALL LETT" +
	"ER KHAOSAGE SMALL LETTER GHAOSAGE SMALL LETTER ZAOSAGE SMALL LETTER ZHAE" +
	"LBASAN LETTER AELBASAN LETTER BEELBASAN LETTER CEELBASAN LETTER CHEELBAS" +
	"AN LETTER DEELBASAN LETTER NDEELBASAN LETTER DHEELBASAN LETTER EIELBASAN" +
	" LETTER EELBASAN LETTER FEELBASAN LETTER GEELBASAN LETTER GJEELBASAN LET" +
	"TER HEELBASAN LETTER IELBASAN LETTER JEELBASAN LETTER KEELBASAN LETTER L" +
	"EELBASAN LETTER LLEELBASAN LETTER MEELBASAN LETTER NEELBASAN LETTER NAEL" +
	"BASAN LETTER NJEELBASAN LETTER OELBASAN LETTER PEELBASAN LETTER QEELBASA" +
	"N LETTER REELBASAN LETTER RREELBASAN LETTER SEELBASAN LETTER SHEELBASAN " +
	"LETTER TEELBASAN LETTER THEELBASAN LETTER UELBASAN LETTER VEELBASAN LETT" +
	"ER XEELBASAN LETTER YELBASAN LETTER ZEELBASAN LETTER ZHEELBASAN LETTER G" +
	"HEELBASAN LETTER GHAMMAELBASAN LETTER KHECAUCASIAN ALBANIAN LETTER ALTCA" +
	"UCASIAN ALBANIAN LETTER BETCAUCASIAN ALBANIAN LETTER GIMCAUCASIAN ALBANI" +
	"AN LETTER DATCAUCASIAN ALBANIAN LETTER EBCAUCASIAN ALBANIAN LETTER ZARLC" +
	"AUCASIAN ALBANIAN LETTER EYNCAUCASIAN ALBANIAN LETTER ZHILCAUCASIAN ALBA" +
	"NIAN LETTER TASCAUCASIAN ALBANIAN LETTER CHACAUCASIAN ALBANIAN LETTER YO" +
	"WDCAUCASIAN ALBANIAN LETTER ZHACAUCASIAN ALBANIAN LETTER IRBCAUCASIAN AL" +
	"BANIAN LETTER SHACAUCASIAN ALBANIAN LETTER LANCAUCASIAN ALBANIAN LETTER " +
	"INYACAUCASIAN ALBANIAN LETTER XEYNCAUCASIAN ALBANIAN LETTER DYANCAUCASIA" +
	"N ALBANIAN LETTER CARCAUCASIAN ALBANIAN LETTER JHOXCAUCASIAN ALBANIAN LE" +
	"TTER KARCAUCASIAN ALBANIAN LETTER LYITCAUCASIAN ALBANIAN LETTER HEYTCAUC" +
	"ASIAN ALBANIAN LETTER QAYCAUCASIAN ALBANIAN LETTER AORCAUCASIAN ALBANIAN" +
	" LETTER CHOYCAUCASIAN ALBANIAN LETTER CHICAUCASIAN ALBANIAN LETTER CYAYC" +
	"AUCASIAN ALBANIAN LETTER MAQCAUCASIAN ALBANIAN LETTER QARCAUCASIAN ALBAN" +
	"IAN LETTER NOWCCAUCASIAN ALBANIAN LETTER DZYAYCAUCASIAN ALBANIAN LETTER " +
	"SHAKCAUCASIAN ALBANIAN LETTER JAYNCAUCASIAN ALBANIAN LETTER ONCAUCASIAN " +
	"ALBANIAN LETTER TYAYCAUCASIAN ALBANIAN LETTER FAMCAUCASIAN ALBANIAN LETT" +
	"ER DZAYCAUCASIAN ALBANIAN LETTER CHATCAUCASIAN ALBANIAN LETTER PENCAUCAS" +
	"IAN ALBANIAN LETTER GHEYSCAUCASIAN ALBANIAN LETTER RATCAUCASIAN ALBANIAN" +
	" LETTER SEYKCAUCASIAN ALBANIAN LETTER VEYZCAUCASIAN ALBANIAN LETTER TIWR" +
	"CAUCASIAN ALBANIAN LETTER SHOYCAUCASIAN ALBANIAN LETTER IWNCAUCASIAN ALB" +
	"ANIAN LETTER CYAWCAUCASIAN ALBANIAN LETTER CAYNCAUCASIAN ALBANIAN LETTER" +
	" YAYDCAUCASIAN ALBANIAN LETTER PIWRCAUCASIAN ALBANIAN LETTER KIWCAUCASIA" +
	"N ALBANIAN CITATION MARKVITHKUQI CAPITAL LETTER AVITHKUQI CAPITAL LETTER" +
	" BBEVITHKUQI CAPITAL LETTER BEVITHKUQI CAPITAL LETTER CEVITHKUQI CAPITAL" +
	" LETTER CHEVITHKUQI CAPITAL LETTER DEVITHKUQI CAPITAL LETTER DHEVITHKUQI" +
	" CAPITAL LETTER EIVITHKUQI CAPITAL LETTER EVITHKUQI CAPITAL LETTER FEVIT" +
	"HKUQI CAPITAL LETTER GAVITHKUQI CAPITAL LETTER HAVITHKUQI CAPITAL LETTER" +
	" HHAVITHKUQI CAPITAL LETTER IVITHKUQI CAPITAL LETTER IJEVITHKUQI CAPITAL" +
	" LETTER JEVITHKUQI CAPITAL LETTER KAVITHKUQI CAPITAL LETTER LAVITHKUQI C" +
	"APITAL LETTER LLAVITHKUQI CAPITAL LETTER MEVITHKUQI CAPITAL LETTER NEVIT" +
	"HKUQI CAPITAL LETTER NJEVITHKUQI CAPITAL LETTER OVITHKUQI CAPITAL LETTER" +
	" PEVITHKUQI CAPITAL LETTER QAVITHKUQI CAPITAL LETTER REVITHKUQI CAPITAL " +
	"LETTER SEVITHKUQI CAPITAL LETTER SHEVITHKUQI CAPITAL LETTER TEVITHKUQI C" +
	"APITAL LETTER THEVITHKUQI CAPITAL LETTER UVITHKUQI CAPITAL LETTER VEVITH" +
	"KUQI CAPITAL LETTER XEVITHKUQI CAPITAL LETTER YVITHKUQI CAPITAL LETTER Z" +
	"EVITHKUQI SMALL LETTER AVITHKUQI SMALL LETTER BBEVITHKUQI SMALL LETTER B" +
	"EVITHKUQI SMALL LETTER CEVITHKUQI SMALL LETTER CHEVITHKUQI SMALL LETTER " +
	"DEVITHKUQI SMALL LETTER DHEVITHKUQI SMALL LETTER EIVITHKUQI SMALL LETTER" +
	" EVITHKUQI SMALL LETTER FEVITHKUQI SMALL LETTER GAVITHKUQI SMALL LETTER " +
	"HAVITHKUQI SMALL LETTER HHAVITHKUQI SMALL LETTER IVITHKUQI SMALL LETTER " +
	"IJEVITHKUQI SMALL LETTER JEVITHKUQI SMALL LETTER KAVITHKUQI SMALL LETTER" +
	" LAVITHKUQI SMALL LETTER LLAVITHKUQI SMALL LETTER MEVITHKUQI SMALL LETTE" +
	"R NEVITHKUQI SMALL LETTER NJEVITHKUQI SMALL LETTER OVITHKUQI SMALL LETTE" +
	"R PEVITHKUQI SMALL LETTER QAVITHKUQI SMALL LETTER REVITHKUQI SMALL LETTE") + ("" +
	"R SEVITHKUQI SMALL LETTER SHEVITHKUQI SMALL LETTER TEVITHKUQI SMALL LETT" +
	"ER THEVITHKUQI SMALL LETTER UVITHKUQI SMALL LETTER VEVITHKUQI SMALL LETT" +
	"ER XEVITHKUQI SMALL LETTER YVITHKUQI SMALL LETTER ZETODHRI LETTER ATODHR" +
	"I LETTER ASTODHRI LETTER BATODHRI LETTER MBATODHRI LETTER CATODHRI LETTE" +
	"R CHATODHRI LETTER DATODHRI LETTER NDATODHRI LETTER DHATODHRI LETTER EIT" +
	"ODHRI LETTER ETODHRI LETTER FATODHRI LETTER GATODHRI LETTER NGATODHRI LE" +
	"TTER GJATODHRI LETTER NGJATODHRI LETTER HATODHRI LETTER HJATODHRI LETTER" +
	" ITODHRI LETTER JATODHRI LETTER KATODHRI LETTER LATODHRI LETTER LLATODHR" +
	"I LETTER MATODHRI LETTER NATODHRI LETTER NJANTODHRI LETTER OTODHRI LETTE" +
	"R PATODHRI LETTER QATODHRI LETTER RATODHRI LETTER RRATODHRI LETTER SATOD" +
	"HRI LETTER SHATODHRI LETTER SHTATODHRI LETTER TATODHRI LETTER THATODHRI " +
	"LETTER UTODHRI LETTER VATODHRI LETTER XATODHRI LETTER NXATODHRI LETTER X" +
	"HATODHRI LETTER NXHATODHRI LETTER YTODHRI LETTER JYTODHRI LETTER ZATODHR" +
	"I LETTER ZHATODHRI LETTER GHATODHRI LETTER STATODHRI LETTER SKANTODHRI L" +
	"ETTER KHATODHRI LETTER PSATODHRI LETTER OOLINEAR A SIGN AB001LINEAR A SI" +
	"GN AB002LINEAR A SIGN AB003LINEAR A SIGN AB004LINEAR A SIGN AB005LINEAR " +
	"A SIGN AB006LINEAR A SIGN AB007LINEAR A SIGN AB008LINEAR A SIGN AB009LIN" +
	"EAR A SIGN AB010LINEAR A SIGN AB011LINEAR A SIGN AB013LINEAR A SIGN AB01" +
	"6LINEAR A SIGN AB017LINEAR A SIGN AB020LINEAR A SIGN AB021LINEAR A SIGN " +
	"AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB022LINEAR A SIGN AB022FLINEAR " +
	"A SIGN AB022MLINEAR A SIGN AB023LINEAR A SIGN AB023MLINEAR A SIGN AB024L" +
	"INEAR A SIGN AB026LINEAR A SIGN AB027LINEAR A SIGN AB028LINEAR A SIGN A0" +
	"28BLINEAR A SIGN AB029LINEAR A SIGN AB030LINEAR A SIGN AB031LINEAR A SIG" +
	"N AB034LINEAR A SIGN AB037LINEAR A SIGN AB038LINEAR A SIGN AB039LINEAR A" +
	" SIGN AB040LINEAR A SIGN AB041LINEAR A SIGN AB044LINEAR A SIGN AB045LINE" +
	"AR A SIGN AB046LINEAR A SIGN AB047LINEAR A SIGN AB048LINEAR A SIGN AB049" +
	"LINEAR A SIGN AB050LINEAR A SIGN AB051LINEAR A SIGN AB053LINEAR A SIGN A" +
	"B054LINEAR A SIGN AB055LINEAR A SIGN AB056LINEAR A SIGN AB057LINEAR A SI" +
	"GN AB058LINEAR A SIGN AB059LINEAR A SIGN AB060LINEAR A SIGN AB061LINEAR " +
	"A SIGN AB065LINEAR A SIGN AB066LINEAR A SIGN AB067LINEAR A SIGN AB069LIN" +
	"EAR A SIGN AB070LINEAR A SIGN AB073LINEAR A SIGN AB074LINEAR A SIGN AB07" +
	"6LINEAR A SIGN AB077LINEAR A SIGN AB078LINEAR A SIGN AB079LINEAR A SIGN " +
	"AB080LINEAR A SIGN AB081LINEAR A SIGN AB082LINEAR A SIGN AB085LINEAR A S" +
	"IGN AB086LINEAR A SIGN AB087LINEAR A SIGN A100-102LINEAR A SIGN AB118LIN" +
	"EAR A SIGN AB120LINEAR A SIGN A120BLINEAR A SIGN AB122LINEAR A SIGN AB12" +
	"3LINEAR A SIGN AB131ALINEAR A SIGN AB131BLINEAR A SIGN A131CLINEAR A SIG" +
	"N AB164LINEAR A SIGN AB171LINEAR A SIGN AB180LINEAR A SIGN AB188LINEAR A" +
	" SIGN AB191LINEAR A SIGN A301LINEAR A SIGN A302LINEAR A SIGN A303LINEAR " +
	"A SIGN A304LINEAR A SIGN A305LINEAR A SIGN A306LINEAR A SIGN A307LINEAR " +
	"A SIGN A308LINEAR A SIGN A309ALINEAR A SIGN A309BLINEAR A SIGN A309CLINE" +
	"AR A SIGN A310LINEAR A SIGN A311LINEAR A SIGN A312LINEAR A SIGN A313ALIN" +
	"EAR A SIGN A313BLINEAR A SIGN A313CLINEAR A SIGN A314LINEAR A SIGN A315L" +
	"INEAR A SIGN A316LINEAR A SIGN A317LINEAR A SIGN A318LINEAR A SIGN A319L" +
	"INEAR A SIGN A320LINEAR A SIGN A321LINEAR A SIGN A322LINEAR A SIGN A323L" +
	"INEAR A SIGN A324LINEAR A SIGN A325LINEAR A SIGN A326LINEAR A SIGN A327L" +
	"INEAR A SIGN A328LINEAR A SIGN A329LINEAR A SIGN A330LINEAR A SIGN A331L" +
	"INEAR A SIGN A332LINEAR A SIGN A333LINEAR A SIGN A334LINEAR A SIGN A335L" +
	"INEAR A SIGN A336LINEAR A SIGN A337LINEAR A SIGN A338LINEAR A SIGN A339L" +
	"INEAR A SIGN A340LINEAR A SIGN A341LINEAR A SIGN A342LINEAR A SIGN A343L" +
	"INEAR A SIGN A344LINEAR A SIGN A345LINEAR A SIGN A346LINEAR A SIGN A347L" +
	"INEAR A SIGN A348LINEAR A SIGN A349LINEAR A SIGN A350LINEAR A SIGN A351L" +
	"INEAR A SIGN A352LINEAR A SIGN A353LINEAR A SIGN A354LINEAR A SIGN A355L" +
	"INEAR A SIGN A356LINEAR A SIGN A357LINEAR A SIGN A358LINEAR A SIGN A359L" +
	"INEAR A SIGN A360LINEAR A SIGN A361LINEAR A SIGN A362LINEAR A SIGN A363L" +
	"INEAR A SIGN A364LINEAR A SIGN A365LINEAR A SIGN A366LINEAR A SIGN A367L" +
	"INEAR A SIGN A368LINEAR A SIGN A369LINEAR A SIGN A370LINEAR A SIGN A371L" +
	"INEAR A SIGN A400-VASLINEAR A SIGN A401-VASLINEAR A SIGN A402-VASLINEAR " +
	"A SIGN A403-VASLINEAR A SIGN A404-VASLINEAR A SIGN A405-VASLINEAR A SIGN" +
	" A406-VASLINEAR A SIGN A407-VASLINEAR A SIGN A408-VASLINEAR A SIGN A409-" +
	"VASLINEAR A SIGN A410-VASLINEAR A SIGN A411-VASLINEAR A SIGN A412-VASLIN" +
	"EAR A SIGN A413-VASLINEAR A SIGN A414-VASLINEAR A SIGN A415-VASLINEAR A " +
	"SIGN A416-VASLINEAR A SIGN A417-VASLINEAR A SIGN A418-VASLINEAR A SIGN A" +
	"501LINEAR A SIGN A502LINEAR A SIGN A503LINEAR A SIGN A504LINEAR A SIGN A" +
	"505LINEAR A SIGN A506LINEAR A SIGN A508LINEAR A SIGN A509LINEAR A SIGN A") + ("" +
	"510LINEAR A SIGN A511LINEAR A SIGN A512LINEAR A SIGN A513LINEAR A SIGN A" +
	"515LINEAR A SIGN A516LINEAR A SIGN A520LINEAR A SIGN A521LINEAR A SIGN A" +
	"523LINEAR A SIGN A524LINEAR A SIGN A525LINEAR A SIGN A526LINEAR A SIGN A" +
	"527LINEAR A SIGN A528LINEAR A SIGN A529LINEAR A SIGN A530LINEAR A SIGN A" +
	"531LINEAR A SIGN A532LINEAR A SIGN A534LINEAR A SIGN A535LINEAR A SIGN A" +
	"536LINEAR A SIGN A537LINEAR A SIGN A538LINEAR A SIGN A539LINEAR A SIGN A" +
	"540LINEAR A SIGN A541LINEAR A SIGN A542LINEAR A SIGN A545LINEAR A SIGN A" +
	"547LINEAR A SIGN A548LINEAR A SIGN A549LINEAR A SIGN A550LINEAR A SIGN A" +
	"551LINEAR A SIGN A552LINEAR A SIGN A553LINEAR A SIGN A554LINEAR A SIGN A" +
	"555LINEAR A SIGN A556LINEAR A SIGN A557LINEAR A SIGN A559LINEAR A SIGN A" +
	"563LINEAR A SIGN A564LINEAR A SIGN A565LINEAR A SIGN A566LINEAR A SIGN A" +
	"568LINEAR A SIGN A569LINEAR A SIGN A570LINEAR A SIGN A571LINEAR A SIGN A" +
	"572LINEAR A SIGN A573LINEAR A SIGN A574LINEAR A SIGN A575LINEAR A SIGN A" +
	"576LINEAR A SIGN A577LINEAR A SIGN A578LINEAR A SIGN A579LINEAR A SIGN A" +
	"580LINEAR A SIGN A581LINEAR A SIGN A582LINEAR A SIGN A583LINEAR A SIGN A" +
	"584LINEAR A SIGN A585LINEAR A SIGN A586LINEAR A SIGN A587LINEAR A SIGN A" +
	"588LINEAR A SIGN A589LINEAR A SIGN A591LINEAR A SIGN A592LINEAR A SIGN A" +
	"594LINEAR A SIGN A595LINEAR A SIGN A596LINEAR A SIGN A598LINEAR A SIGN A" +
	"600LINEAR A SIGN A601LINEAR A SIGN A602LINEAR A SIGN A603LINEAR A SIGN A" +
	"604LINEAR A SIGN A606LINEAR A SIGN A608LINEAR A SIGN A609LINEAR A SIGN A" +
	"610LINEAR A SIGN A611LINEAR A SIGN A612LINEAR A SIGN A613LINEAR A SIGN A" +
	"614LINEAR A SIGN A615LINEAR A SIGN A616LINEAR A SIGN A617LINEAR A SIGN A" +
	"618LINEAR A SIGN A619LINEAR A SIGN A620LINEAR A SIGN A621LINEAR A SIGN A" +
	"622LINEAR A SIGN A623LINEAR A SIGN A624LINEAR A SIGN A626LINEAR A SIGN A" +
	"627LINEAR A SIGN A628LINEAR A SIGN A629LINEAR A SIGN A634LINEAR A SIGN A" +
	"637LINEAR A SIGN A638LINEAR A SIGN A640LINEAR A SIGN A642LINEAR A SIGN A" +
	"643LINEAR A SIGN A644LINEAR A SIGN A645LINEAR A SIGN A646LINEAR A SIGN A" +
	"648LINEAR A SIGN A649LINEAR A SIGN A651LINEAR A SIGN A652LINEAR A SIGN A" +
	"653LINEAR A SIGN A654LINEAR A SIGN A655LINEAR A SIGN A656LINEAR A SIGN A" +
	"657LINEAR A SIGN A658LINEAR A SIGN A659LINEAR A SIGN A660LINEAR A SIGN A" +
	"661LINEAR A SIGN A662LINEAR A SIGN A663LINEAR A SIGN A664LINEAR A SIGN A" +
	"701 ALINEAR A SIGN A702 BLINEAR A SIGN A703 DLINEAR A SIGN A704 ELINEAR " +
	"A SIGN A705 FLINEAR A SIGN A706 HLINEAR A SIGN A707 JLINEAR A SIGN A708 " +
	"KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 L2LINEAR A SIGN A709-3 L3LINEA" +
	"R A SIGN A709-4 L4LINEAR A SIGN A709-6 L6LINEAR A SIGN A710 WLINEAR A SI" +
	"GN A711 XLINEAR A SIGN A712 YLINEAR A SIGN A713 OMEGALINEAR A SIGN A714 " +
	"ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717 DDLINEAR A SIGN A726 EYYYLINE" +
	"AR A SIGN A732 JELINEAR A SIGN A800LINEAR A SIGN A801LINEAR A SIGN A802L" +
	"INEAR A SIGN A803LINEAR A SIGN A804LINEAR A SIGN A805LINEAR A SIGN A806L" +
	"INEAR A SIGN A807MODIFIER LETTER SMALL CAPITAL AAMODIFIER LETTER SUPERSC" +
	"RIPT TRIANGULAR COLONMODIFIER LETTER SUPERSCRIPT HALF TRIANGULAR COLONMO" +
	"DIFIER LETTER SMALL AEMODIFIER LETTER SMALL CAPITAL BMODIFIER LETTER SMA" +
	"LL B WITH HOOKMODIFIER LETTER SMALL DZ DIGRAPHMODIFIER LETTER SMALL DZ D" +
	"IGRAPH WITH RETROFLEX HOOKMODIFIER LETTER SMALL DZ DIGRAPH WITH CURLMODI" +
	"FIER LETTER SMALL DEZH DIGRAPHMODIFIER LETTER SMALL D WITH TAILMODIFIER " +
	"LETTER SMALL D WITH HOOKMODIFIER LETTER SMALL D WITH HOOK AND TAILMODIFI" +
	"ER LETTER SMALL REVERSED EMODIFIER LETTER SMALL CLOSED REVERSED OPEN EMO" +
	"DIFIER LETTER SMALL FENG DIGRAPHMODIFIER LETTER SMALL RAMS HORNMODIFIER " +
	"LETTER SMALL CAPITAL GMODIFIER LETTER SMALL G WITH HOOKMODIFIER LETTER S" +
	"MALL CAPITAL G WITH HOOKMODIFIER LETTER SMALL H WITH STROKEMODIFIER LETT" +
	"ER SMALL CAPITAL HMODIFIER LETTER SMALL HENG WITH HOOKMODIFIER LETTER SM" +
	"ALL DOTLESS J WITH STROKE AND HOOKMODIFIER LETTER SMALL LS DIGRAPHMODIFI" +
	"ER LETTER SMALL LZ DIGRAPHMODIFIER LETTER SMALL L WITH BELTMODIFIER LETT" +
	"ER SMALL CAPITAL L WITH BELTMODIFIER LETTER SMALL L WITH RETROFLEX HOOK " +
	"AND BELTMODIFIER LETTER SMALL LEZHMODIFIER LETTER SMALL LEZH WITH RETROF" +
	"LEX HOOKMODIFIER LETTER SMALL TURNED YMODIFIER LETTER SMALL TURNED Y WIT" +
	"H BELTMODIFIER LETTER SMALL O WITH STROKEMODIFIER LETTER SMALL CAPITAL O" +
	"EMODIFIER LETTER SMALL CLOSED OMEGAMODIFIER LETTER SMALL QMODIFIER LETTE" +
	"R SMALL TURNED R WITH LONG LEGMODIFIER LETTER SMALL TURNED R WITH LONG L" +
	"EG AND RETROFLEX HOOKMODIFIER LETTER SMALL R WITH TAILMODIFIER LETTER SM" +
	"ALL R WITH FISHHOOKMODIFIER LETTER SMALL CAPITAL RMODIFIER LETTER SMALL " +
	"TC DIGRAPH WITH CURLMODIFIER LETTER SMALL TS DIGRAPHMODIFIER LETTER SMAL" +
	"L TS DIGRAPH WITH RETROFLEX HOOKMODIFIER LETTER SMALL TESH DIGRAPHMODIFI" +
	"ER LETTER SMALL T WITH RETROFLEX HOOKMODIFIER LETTER SMALL V WITH RIGHT ") + ("" +
	"HOOKMODIFIER LETTER SMALL CAPITAL YMODIFIER LETTER GLOTTAL STOP WITH STR" +
	"OKEMODIFIER LETTER REVERSED GLOTTAL STOP WITH STROKEMODIFIER LETTER BILA" +
	"BIAL CLICKMODIFIER LETTER DENTAL CLICKMODIFIER LETTER LATERAL CLICKMODIF" +
	"IER LETTER ALVEOLAR CLICKMODIFIER LETTER RETROFLEX CLICK WITH RETROFLEX " +
	"HOOKMODIFIER LETTER SMALL S WITH CURLCYPRIOT SYLLABLE ACYPRIOT SYLLABLE " +
	"ECYPRIOT SYLLABLE ICYPRIOT SYLLABLE OCYPRIOT SYLLABLE UCYPRIOT SYLLABLE " +
	"JACYPRIOT SYLLABLE JOCYPRIOT SYLLABLE KACYPRIOT SYLLABLE KECYPRIOT SYLLA" +
	"BLE KICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE KUCYPRIOT SYLLABLE LACYPRIOT S" +
	"YLLABLE LECYPRIOT SYLLABLE LICYPRIOT SYLLABLE LOCYPRIOT SYLLABLE LUCYPRI" +
	"OT SYLLABLE MACYPRIOT SYLLABLE MECYPRIOT SYLLABLE MICYPRIOT SYLLABLE MOC" +
	"YPRIOT SYLLABLE MUCYPRIOT SYLLABLE NACYPRIOT SYLLABLE NECYPRIOT SYLLABLE" +
	" NICYPRIOT SYLLABLE NOCYPRIOT SYLLABLE NUCYPRIOT SYLLABLE PACYPRIOT SYLL" +
	"ABLE PECYPRIOT SYLLABLE PICYPRIOT SYLLABLE POCYPRIOT SYLLABLE PUCYPRIOT " +
	"SYLLABLE RACYPRIOT SYLLABLE RECYPRIOT SYLLABLE RICYPRIOT SYLLABLE ROCYPR" +
	"IOT SYLLABLE RUCYPRIOT SYLLABLE SACYPRIOT SYLLABLE SECYPRIOT SYLLABLE SI" +
	"CYPRIOT SYLLABLE SOCYPRIOT SYLLABLE SUCYPRIOT SYLLABLE TACYPRIOT SYLLABL" +
	"E TECYPRIOT SYLLABLE TICYPRIOT SYLLABLE TOCYPRIOT SYLLABLE TUCYPRIOT SYL" +
	"LABLE WACYPRIOT SYLLABLE WECYPRIOT SYLLABLE WICYPRIOT SYLLABLE WOCYPRIOT" +
	" SYLLABLE XACYPRIOT SYLLABLE XECYPRIOT SYLLABLE ZACYPRIOT SYLLABLE ZOIMP" +
	"ERIAL ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC LETTER BETHIMPERIAL ARAMAIC L" +
	"ETTER GIMELIMPERIAL ARAMAIC LETTER DALETHIMPERIAL ARAMAIC LETTER HEIMPER" +
	"IAL ARAMAIC LETTER WAWIMPERIAL ARAMAIC LETTER ZAYINIMPERIAL ARAMAIC LETT" +
	"ER HETHIMPERIAL ARAMAIC LETTER TETHIMPERIAL ARAMAIC LETTER YODHIMPERIAL " +
	"ARAMAIC LETTER KAPHIMPERIAL ARAMAIC LETTER LAMEDHIMPERIAL ARAMAIC LETTER" +
	" MEMIMPERIAL ARAMAIC LETTER NUNIMPERIAL ARAMAIC LETTER SAMEKHIMPERIAL AR" +
	"AMAIC LETTER AYINIMPERIAL ARAMAIC LETTER PEIMPERIAL ARAMAIC LETTER SADHE" +
	"IMPERIAL ARAMAIC LETTER QOPHIMPERIAL ARAMAIC LETTER RESHIMPERIAL ARAMAIC" +
	" LETTER SHINIMPERIAL ARAMAIC LETTER TAWIMPERIAL ARAMAIC SECTION SIGNIMPE" +
	"RIAL ARAMAIC NUMBER ONEIMPERIAL ARAMAIC NUMBER TWOIMPERIAL ARAMAIC NUMBE" +
	"R THREEIMPERIAL ARAMAIC NUMBER TENIMPERIAL ARAMAIC NUMBER TWENTYIMPERIAL" +
	" ARAMAIC NUMBER ONE HUNDREDIMPERIAL ARAMAIC NUMBER ONE THOUSANDIMPERIAL " +
	"ARAMAIC NUMBER TEN THOUSANDPALMYRENE LETTER ALEPHPALMYRENE LETTER BETHPA" +
	"LMYRENE LETTER GIMELPALMYRENE LETTER DALETHPALMYRENE LETTER HEPALMYRENE " +
	"LETTER WAWPALMYRENE LETTER ZAYINPALMYRENE LETTER HETHPALMYRENE LETTER TE" +
	"THPALMYRENE LETTER YODHPALMYRENE LETTER KAPHPALMYRENE LETTER LAMEDHPALMY" +
	"RENE LETTER MEMPALMYRENE LETTER FINAL NUNPALMYRENE LETTER NUNPALMYRENE L" +
	"ETTER SAMEKHPALMYRENE LETTER AYINPALMYRENE LETTER PEPALMYRENE LETTER SAD" +
	"HEPALMYRENE LETTER QOPHPALMYRENE LETTER RESHPALMYRENE LETTER SHINPALMYRE" +
	"NE LETTER TAWPALMYRENE LEFT-POINTING FLEURONPALMYRENE RIGHT-POINTING FLE" +
	"URONPALMYRENE NUMBER ONEPALMYRENE NUMBER TWOPALMYRENE NUMBER THREEPALMYR" +
	"ENE NUMBER FOURPALMYRENE NUMBER FIVEPALMYRENE NUMBER TENPALMYRENE NUMBER" +
	" TWENTYNABATAEAN LETTER FINAL ALEPHNABATAEAN LETTER ALEPHNABATAEAN LETTE" +
	"R FINAL BETHNABATAEAN LETTER BETHNABATAEAN LETTER GIMELNABATAEAN LETTER " +
	"DALETHNABATAEAN LETTER FINAL HENABATAEAN LETTER HENABATAEAN LETTER WAWNA" +
	"BATAEAN LETTER ZAYINNABATAEAN LETTER HETHNABATAEAN LETTER TETHNABATAEAN " +
	"LETTER FINAL YODHNABATAEAN LETTER YODHNABATAEAN LETTER FINAL KAPHNABATAE" +
	"AN LETTER KAPHNABATAEAN LETTER FINAL LAMEDHNABATAEAN LETTER LAMEDHNABATA" +
	"EAN LETTER FINAL MEMNABATAEAN LETTER MEMNABATAEAN LETTER FINAL NUNNABATA" +
	"EAN LETTER NUNNABATAEAN LETTER SAMEKHNABATAEAN LETTER AYINNABATAEAN LETT" +
	"ER PENABATAEAN LETTER SADHENABATAEAN LETTER QOPHNABATAEAN LETTER RESHNAB" +
	"ATAEAN LETTER FINAL SHINNABATAEAN LETTER SHINNABATAEAN LETTER TAWNABATAE" +
	"AN NUMBER ONENABATAEAN NUMBER TWONABATAEAN NUMBER THREENABATAEAN NUMBER " +
	"FOURNABATAEAN CRUCIFORM NUMBER FOURNABATAEAN NUMBER FIVENABATAEAN NUMBER" +
	" TENNABATAEAN NUMBER TWENTYNABATAEAN NUMBER ONE HUNDREDHATRAN LETTER ALE" +
	"PHHATRAN LETTER BETHHATRAN LETTER GIMELHATRAN LETTER DALETH-RESHHATRAN L" +
	"ETTER HEHATRAN LETTER WAWHATRAN LETTER ZAYNHATRAN LETTER HETHHATRAN LETT" +
	"ER TETHHATRAN LETTER YODHHATRAN LETTER KAPHHATRAN LETTER LAMEDHHATRAN LE" +
	"TTER MEMHATRAN LETTER NUNHATRAN LETTER SAMEKHHATRAN LETTER AYNHATRAN LET" +
	"TER PEHATRAN LETTER SADHEHATRAN LETTER QOPHHATRAN LETTER SHINHATRAN LETT" +
	"ER TAWHATRAN NUMBER ONEHATRAN NUMBER FIVEHATRAN NUMBER TENHATRAN NUMBER " +
	"TWENTYHATRAN NUMBER ONE HUNDREDPHOENICIAN LETTER ALFPHOENICIAN LETTER BE" +
	"TPHOENICIAN LETTER GAMLPHOENICIAN LETTER DELTPHOENICIAN LETTER HEPHOENIC" +
	"IAN LETTER WAUPHOENICIAN LETTER ZAIPHOENICIAN LETTER HETPHOENICIAN LETTE" +
	"R TETPHOENICIAN LETTER YODPHOENICIAN LETTER KAFPHOENICIAN LETTER LAMDPHO") + ("" +
	"ENICIAN LETTER MEMPHOENICIAN LETTER NUNPHOENICIAN LETTER SEMKPHOENICIAN " +
	"LETTER AINPHOENICIAN LETTER PEPHOENICIAN LETTER SADEPHOENICIAN LETTER QO" +
	"FPHOENICIAN LETTER ROSHPHOENICIAN LETTER SHINPHOENICIAN LETTER TAUPHOENI" +
	"CIAN NUMBER ONEPHOENICIAN NUMBER TENPHOENICIAN NUMBER TWENTYPHOENICIAN N" +
	"UMBER ONE HUNDREDPHOENICIAN NUMBER TWOPHOENICIAN NUMBER THREEPHOENICIAN " +
	"WORD SEPARATORLYDIAN LETTER ALYDIAN LETTER BLYDIAN LETTER GLYDIAN LETTER" +
	" DLYDIAN LETTER ELYDIAN LETTER VLYDIAN LETTER ILYDIAN LETTER YLYDIAN LET" +
	"TER KLYDIAN LETTER LLYDIAN LETTER MLYDIAN LETTER NLYDIAN LETTER OLYDIAN " +
	"LETTER RLYDIAN LETTER SSLYDIAN LETTER TLYDIAN LETTER ULYDIAN LETTER FLYD" +
	"IAN LETTER QLYDIAN LETTER SLYDIAN LETTER TTLYDIAN LETTER ANLYDIAN LETTER" +
	" ENLYDIAN LETTER LYLYDIAN LETTER NNLYDIAN LETTER CLYDIAN TRIANGULAR MARK" +
	"SIDETIC LETTER N01SIDETIC LETTER N02SIDETIC LETTER N03SIDETIC LETTER N04" +
	"SIDETIC LETTER N05SIDETIC LETTER N06SIDETIC LETTER N07SIDETIC LETTER N08" +
	"SIDETIC LETTER N09SIDETIC LETTER N10SIDETIC LETTER N11SIDETIC LETTER N12" +
	"SIDETIC LETTER N13SIDETIC LETTER N14SIDETIC LETTER N15SIDETIC LETTER N16" +
	"SIDETIC LETTER N17SIDETIC LETTER N18SIDETIC LETTER N19SIDETIC LETTER N20" +
	"SIDETIC LETTER N21SIDETIC LETTER N22SIDETIC LETTER N23SIDETIC LETTER N24" +
	"SIDETIC LETTER N25SIDETIC LETTER N26MEROITIC HIEROGLYPHIC LETTER AMEROIT" +
	"IC HIEROGLYPHIC LETTER EMEROITIC HIEROGLYPHIC LETTER IMEROITIC HIEROGLYP" +
	"HIC LETTER OMEROITIC HIEROGLYPHIC LETTER YAMEROITIC HIEROGLYPHIC LETTER " +
	"WAMEROITIC HIEROGLYPHIC LETTER BAMEROITIC HIEROGLYPHIC LETTER BA-2MEROIT" +
	"IC HIEROGLYPHIC LETTER PAMEROITIC HIEROGLYPHIC LETTER MAMEROITIC HIEROGL" +
	"YPHIC LETTER NAMEROITIC HIEROGLYPHIC LETTER NA-2MEROITIC HIEROGLYPHIC LE" +
	"TTER NEMEROITIC HIEROGLYPHIC LETTER NE-2MEROITIC HIEROGLYPHIC LETTER RAM" +
	"EROITIC HIEROGLYPHIC LETTER RA-2MEROITIC HIEROGLYPHIC LETTER LAMEROITIC " +
	"HIEROGLYPHIC LETTER KHAMEROITIC HIEROGLYPHIC LETTER HHAMEROITIC HIEROGLY" +
	"PHIC LETTER SAMEROITIC HIEROGLYPHIC LETTER SA-2MEROITIC HIEROGLYPHIC LET" +
	"TER SEMEROITIC HIEROGLYPHIC LETTER KAMEROITIC HIEROGLYPHIC LETTER QAMERO" +
	"ITIC HIEROGLYPHIC LETTER TAMEROITIC HIEROGLYPHIC LETTER TA-2MEROITIC HIE" +
	"ROGLYPHIC LETTER TEMEROITIC HIEROGLYPHIC LETTER TE-2MEROITIC HIEROGLYPHI" +
	"C LETTER TOMEROITIC HIEROGLYPHIC LETTER DAMEROITIC HIEROGLYPHIC SYMBOL V" +
	"IDJMEROITIC HIEROGLYPHIC SYMBOL VIDJ-2MEROITIC CURSIVE LETTER AMEROITIC " +
	"CURSIVE LETTER EMEROITIC CURSIVE LETTER IMEROITIC CURSIVE LETTER OMEROIT" +
	"IC CURSIVE LETTER YAMEROITIC CURSIVE LETTER WAMEROITIC CURSIVE LETTER BA" +
	"MEROITIC CURSIVE LETTER PAMEROITIC CURSIVE LETTER MAMEROITIC CURSIVE LET" +
	"TER NAMEROITIC CURSIVE LETTER NEMEROITIC CURSIVE LETTER RAMEROITIC CURSI" +
	"VE LETTER LAMEROITIC CURSIVE LETTER KHAMEROITIC CURSIVE LETTER HHAMEROIT" +
	"IC CURSIVE LETTER SAMEROITIC CURSIVE LETTER ARCHAIC SAMEROITIC CURSIVE L" +
	"ETTER SEMEROITIC CURSIVE LETTER KAMEROITIC CURSIVE LETTER QAMEROITIC CUR" +
	"SIVE LETTER TAMEROITIC CURSIVE LETTER TEMEROITIC CURSIVE LETTER TOMEROIT" +
	"IC CURSIVE LETTER DAMEROITIC CURSIVE FRACTION ELEVEN TWELFTHSMEROITIC CU" +
	"RSIVE FRACTION ONE HALFMEROITIC CURSIVE LOGOGRAM RMTMEROITIC CURSIVE LOG" +
	"OGRAM IMNMEROITIC CURSIVE NUMBER ONEMEROITIC CURSIVE NUMBER TWOMEROITIC " +
	"CURSIVE NUMBER THREEMEROITIC CURSIVE NUMBER FOURMEROITIC CURSIVE NUMBER " +
	"FIVEMEROITIC CURSIVE NUMBER SIXMEROITIC CURSIVE NUMBER SEVENMEROITIC CUR" +
	"SIVE NUMBER EIGHTMEROITIC CURSIVE NUMBER NINEMEROITIC CURSIVE NUMBER TEN" +
	"MEROITIC CURSIVE NUMBER TWENTYMEROITIC CURSIVE NUMBER THIRTYMEROITIC CUR" +
	"SIVE NUMBER FORTYMEROITIC CURSIVE NUMBER FIFTYMEROITIC CURSIVE NUMBER SI" +
	"XTYMEROITIC CURSIVE NUMBER SEVENTYMEROITIC CURSIVE NUMBER ONE HUNDREDMER" +
	"OITIC CURSIVE NUMBER TWO HUNDREDMEROITIC CURSIVE NUMBER THREE HUNDREDMER" +
	"OITIC CURSIVE NUMBER FOUR HUNDREDMEROITIC CURSIVE NUMBER FIVE HUNDREDMER" +
	"OITIC CURSIVE NUMBER SIX HUNDREDMEROITIC CURSIVE NUMBER SEVEN HUNDREDMER" +
	"OITIC CURSIVE NUMBER EIGHT HUNDREDMEROITIC CURSIVE NUMBER NINE HUNDREDME" +
	"ROITIC CURSIVE NUMBER ONE THOUSANDMEROITIC CURSIVE NUMBER TWO THOUSANDME" +
	"ROITIC CURSIVE NUMBER THREE THOUSANDMEROITIC CURSIVE NUMBER FOUR THOUSAN" +
	"DMEROITIC CURSIVE NUMBER FIVE THOUSANDMEROITIC CURSIVE NUMBER SIX THOUSA" +
	"NDMEROITIC CURSIVE NUMBER SEVEN THOUSANDMEROITIC CURSIVE NUMBER EIGHT TH" +
	"OUSANDMEROITIC CURSIVE NUMBER NINE THOUSANDMEROITIC CURSIVE NUMBER TEN T" +
	"HOUSANDMEROITIC CURSIVE NUMBER TWENTY THOUSANDMEROITIC CURSIVE NUMBER TH" +
	"IRTY THOUSANDMEROITIC CURSIVE NUMBER FORTY THOUSANDMEROITIC CURSIVE NUMB" +
	"ER FIFTY THOUSANDMEROITIC CURSIVE NUMBER SIXTY THOUSANDMEROITIC CURSIVE " +
	"NUMBER SEVENTY THOUSANDMEROITIC CURSIVE NUMBER EIGHTY THOUSANDMEROITIC C" +
	"URSIVE NUMBER NINETY THOUSANDMEROITIC CURSIVE NUMBER ONE HUNDRED THOUSAN" +
	"DMEROITIC CURSIVE NUMBER TWO HUNDRED THOUSANDMEROITIC CURSIVE NUMBER THR") + ("" +
	"EE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER FOUR HUNDRED THOUSANDMEROITIC" +
	" CURSIVE NUMBER FIVE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER SIX HUNDRED" +
	" THOUSANDMEROITIC CURSIVE NUMBER SEVEN HUNDRED THOUSANDMEROITIC CURSIVE " +
	"NUMBER EIGHT HUNDRED THOUSANDMEROITIC CURSIVE NUMBER NINE HUNDRED THOUSA" +
	"NDMEROITIC CURSIVE FRACTION ONE TWELFTHMEROITIC CURSIVE FRACTION TWO TWE" +
	"LFTHSMEROITIC CURSIVE FRACTION THREE TWELFTHSMEROITIC CURSIVE FRACTION F" +
	"OUR TWELFTHSMEROITIC CURSIVE FRACTION FIVE TWELFTHSMEROITIC CURSIVE FRAC" +
	"TION SIX TWELFTHSMEROITIC CURSIVE FRACTION SEVEN TWELFTHSMEROITIC CURSIV" +
	"E FRACTION EIGHT TWELFTHSMEROITIC CURSIVE FRACTION NINE TWELFTHSMEROITIC" +
	" CURSIVE FRACTION TEN TWELFTHSKHAROSHTHI LETTER AKHAROSHTHI VOWEL SIGN I" +
	"KHAROSHTHI VOWEL SIGN UKHAROSHTHI VOWEL SIGN VOCALIC RKHAROSHTHI VOWEL S" +
	"IGN EKHAROSHTHI VOWEL SIGN OKHAROSHTHI VOWEL LENGTH MARKKHAROSHTHI SIGN " +
	"DOUBLE RING BELOWKHAROSHTHI SIGN ANUSVARAKHAROSHTHI SIGN VISARGAKHAROSHT" +
	"HI LETTER KAKHAROSHTHI LETTER KHAKHAROSHTHI LETTER GAKHAROSHTHI LETTER G" +
	"HAKHAROSHTHI LETTER CAKHAROSHTHI LETTER CHAKHAROSHTHI LETTER JAKHAROSHTH" +
	"I LETTER NYAKHAROSHTHI LETTER TTAKHAROSHTHI LETTER TTHAKHAROSHTHI LETTER" +
	" DDAKHAROSHTHI LETTER DDHAKHAROSHTHI LETTER NNAKHAROSHTHI LETTER TAKHARO" +
	"SHTHI LETTER THAKHAROSHTHI LETTER DAKHAROSHTHI LETTER DHAKHAROSHTHI LETT" +
	"ER NAKHAROSHTHI LETTER PAKHAROSHTHI LETTER PHAKHAROSHTHI LETTER BAKHAROS" +
	"HTHI LETTER BHAKHAROSHTHI LETTER MAKHAROSHTHI LETTER YAKHAROSHTHI LETTER" +
	" RAKHAROSHTHI LETTER LAKHAROSHTHI LETTER VAKHAROSHTHI LETTER SHAKHAROSHT" +
	"HI LETTER SSAKHAROSHTHI LETTER SAKHAROSHTHI LETTER ZAKHAROSHTHI LETTER H" +
	"AKHAROSHTHI LETTER KKAKHAROSHTHI LETTER TTTHAKHAROSHTHI LETTER TTTAKHARO" +
	"SHTHI LETTER VHAKHAROSHTHI SIGN BAR ABOVEKHAROSHTHI SIGN CAUDAKHAROSHTHI" +
	" SIGN DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI DIGIT ONEKHAROSHTHI DIGIT TWO" +
	"KHAROSHTHI DIGIT THREEKHAROSHTHI DIGIT FOURKHAROSHTHI NUMBER TENKHAROSHT" +
	"HI NUMBER TWENTYKHAROSHTHI NUMBER ONE HUNDREDKHAROSHTHI NUMBER ONE THOUS" +
	"ANDKHAROSHTHI FRACTION ONE HALFKHAROSHTHI PUNCTUATION DOTKHAROSHTHI PUNC" +
	"TUATION SMALL CIRCLEKHAROSHTHI PUNCTUATION CIRCLEKHAROSHTHI PUNCTUATION " +
	"CRESCENT BARKHAROSHTHI PUNCTUATION MANGALAMKHAROSHTHI PUNCTUATION LOTUSK" +
	"HAROSHTHI PUNCTUATION DANDAKHAROSHTHI PUNCTUATION DOUBLE DANDAKHAROSHTHI" +
	" PUNCTUATION LINESOLD SOUTH ARABIAN LETTER HEOLD SOUTH ARABIAN LETTER LA" +
	"MEDHOLD SOUTH ARABIAN LETTER HETHOLD SOUTH ARABIAN LETTER MEMOLD SOUTH A" +
	"RABIAN LETTER QOPHOLD SOUTH ARABIAN LETTER WAWOLD SOUTH ARABIAN LETTER S" +
	"HINOLD SOUTH ARABIAN LETTER RESHOLD SOUTH ARABIAN LETTER BETHOLD SOUTH A" +
	"RABIAN LETTER TAWOLD SOUTH ARABIAN LETTER SATOLD SOUTH ARABIAN LETTER KA" +
	"PHOLD SOUTH ARABIAN LETTER NUNOLD SOUTH ARABIAN LETTER KHETHOLD SOUTH AR" +
	"ABIAN LETTER SADHEOLD SOUTH ARABIAN LETTER SAMEKHOLD SOUTH ARABIAN LETTE" +
	"R FEOLD SOUTH ARABIAN LETTER ALEFOLD SOUTH ARABIAN LETTER AYNOLD SOUTH A" +
	"RABIAN LETTER DHADHEOLD SOUTH ARABIAN LETTER GIMELOLD SOUTH ARABIAN LETT" +
	"ER DALETHOLD SOUTH ARABIAN LETTER GHAYNOLD SOUTH ARABIAN LETTER TETHOLD " +
	"SOUTH ARABIAN LETTER ZAYNOLD SOUTH ARABIAN LETTER DHALETHOLD SOUTH ARABI" +
	"AN LETTER YODHOLD SOUTH ARABIAN LETTER THAWOLD SOUTH ARABIAN LETTER THET" +
	"HOLD SOUTH ARABIAN NUMBER ONEOLD SOUTH ARABIAN NUMBER FIFTYOLD SOUTH ARA" +
	"BIAN NUMERIC INDICATOROLD NORTH ARABIAN LETTER HEHOLD NORTH ARABIAN LETT" +
	"ER LAMOLD NORTH ARABIAN LETTER HAHOLD NORTH ARABIAN LETTER MEEMOLD NORTH" +
	" ARABIAN LETTER QAFOLD NORTH ARABIAN LETTER WAWOLD NORTH ARABIAN LETTER " +
	"ES-2OLD NORTH ARABIAN LETTER REHOLD NORTH ARABIAN LETTER BEHOLD NORTH AR" +
	"ABIAN LETTER TEHOLD NORTH ARABIAN LETTER ES-1OLD NORTH ARABIAN LETTER KA" +
	"FOLD NORTH ARABIAN LETTER NOONOLD NORTH ARABIAN LETTER KHAHOLD NORTH ARA" +
	"BIAN LETTER SADOLD NORTH ARABIAN LETTER ES-3OLD NORTH ARABIAN LETTER FEH" +
	"OLD NORTH ARABIAN LETTER ALEFOLD NORTH ARABIAN LETTER AINOLD NORTH ARABI" +
	"AN LETTER DADOLD NORTH ARABIAN LETTER GEEMOLD NORTH ARABIAN LETTER DALOL" +
	"D NORTH ARABIAN LETTER GHAINOLD NORTH ARABIAN LETTER TAHOLD NORTH ARABIA" +
	"N LETTER ZAINOLD NORTH ARABIAN LETTER THALOLD NORTH ARABIAN LETTER YEHOL" +
	"D NORTH ARABIAN LETTER THEHOLD NORTH ARABIAN LETTER ZAHOLD NORTH ARABIAN" +
	" NUMBER ONEOLD NORTH ARABIAN NUMBER TENOLD NORTH ARABIAN NUMBER TWENTYMA" +
	"NICHAEAN LETTER ALEPHMANICHAEAN LETTER BETHMANICHAEAN LETTER BHETHMANICH" +
	"AEAN LETTER GIMELMANICHAEAN LETTER GHIMELMANICHAEAN LETTER DALETHMANICHA" +
	"EAN LETTER HEMANICHAEAN LETTER WAWMANICHAEAN SIGN UDMANICHAEAN LETTER ZA" +
	"YINMANICHAEAN LETTER ZHAYINMANICHAEAN LETTER JAYINMANICHAEAN LETTER JHAY" +
	"INMANICHAEAN LETTER HETHMANICHAEAN LETTER TETHMANICHAEAN LETTER YODHMANI" +
	"CHAEAN LETTER KAPHMANICHAEAN LETTER XAPHMANICHAEAN LETTER KHAPHMANICHAEA" +
	"N LETTER LAMEDHMANICHAEAN LETTER DHAMEDHMANICHAEAN LETTER THAMEDHMANICHA") + ("" +
	"EAN LETTER MEMMANICHAEAN LETTER NUNMANICHAEAN LETTER SAMEKHMANICHAEAN LE" +
	"TTER AYINMANICHAEAN LETTER AAYINMANICHAEAN LETTER PEMANICHAEAN LETTER FE" +
	"MANICHAEAN LETTER SADHEMANICHAEAN LETTER QOPHMANICHAEAN LETTER XOPHMANIC" +
	"HAEAN LETTER QHOPHMANICHAEAN LETTER RESHMANICHAEAN LETTER SHINMANICHAEAN" +
	" LETTER SSHINMANICHAEAN LETTER TAWMANICHAEAN ABBREVIATION MARK ABOVEMANI" +
	"CHAEAN ABBREVIATION MARK BELOWMANICHAEAN NUMBER ONEMANICHAEAN NUMBER FIV" +
	"EMANICHAEAN NUMBER TENMANICHAEAN NUMBER TWENTYMANICHAEAN NUMBER ONE HUND" +
	"REDMANICHAEAN PUNCTUATION STARMANICHAEAN PUNCTUATION FLEURONMANICHAEAN P" +
	"UNCTUATION DOUBLE DOT WITHIN DOTMANICHAEAN PUNCTUATION DOT WITHIN DOTMAN" +
	"ICHAEAN PUNCTUATION DOTMANICHAEAN PUNCTUATION TWO DOTSMANICHAEAN PUNCTUA" +
	"TION LINE FILLERAVESTAN LETTER AAVESTAN LETTER AAAVESTAN LETTER AOAVESTA" +
	"N LETTER AAOAVESTAN LETTER ANAVESTAN LETTER AANAVESTAN LETTER AEAVESTAN " +
	"LETTER AEEAVESTAN LETTER EAVESTAN LETTER EEAVESTAN LETTER OAVESTAN LETTE" +
	"R OOAVESTAN LETTER IAVESTAN LETTER IIAVESTAN LETTER UAVESTAN LETTER UUAV" +
	"ESTAN LETTER KEAVESTAN LETTER XEAVESTAN LETTER XYEAVESTAN LETTER XVEAVES" +
	"TAN LETTER GEAVESTAN LETTER GGEAVESTAN LETTER GHEAVESTAN LETTER CEAVESTA" +
	"N LETTER JEAVESTAN LETTER TEAVESTAN LETTER THEAVESTAN LETTER DEAVESTAN L" +
	"ETTER DHEAVESTAN LETTER TTEAVESTAN LETTER PEAVESTAN LETTER FEAVESTAN LET" +
	"TER BEAVESTAN LETTER BHEAVESTAN LETTER NGEAVESTAN LETTER NGYEAVESTAN LET" +
	"TER NGVEAVESTAN LETTER NEAVESTAN LETTER NYEAVESTAN LETTER NNEAVESTAN LET" +
	"TER MEAVESTAN LETTER HMEAVESTAN LETTER YYEAVESTAN LETTER YEAVESTAN LETTE" +
	"R VEAVESTAN LETTER REAVESTAN LETTER LEAVESTAN LETTER SEAVESTAN LETTER ZE" +
	"AVESTAN LETTER SHEAVESTAN LETTER ZHEAVESTAN LETTER SHYEAVESTAN LETTER SS" +
	"HEAVESTAN LETTER HEAVESTAN ABBREVIATION MARKTINY TWO DOTS OVER ONE DOT P" +
	"UNCTUATIONSMALL TWO DOTS OVER ONE DOT PUNCTUATIONLARGE TWO DOTS OVER ONE" +
	" DOT PUNCTUATIONLARGE ONE DOT OVER TWO DOTS PUNCTUATIONLARGE TWO RINGS O" +
	"VER ONE RING PUNCTUATIONLARGE ONE RING OVER TWO RINGS PUNCTUATIONINSCRIP" +
	"TIONAL PARTHIAN LETTER ALEPHINSCRIPTIONAL PARTHIAN LETTER BETHINSCRIPTIO" +
	"NAL PARTHIAN LETTER GIMELINSCRIPTIONAL PARTHIAN LETTER DALETHINSCRIPTION" +
	"AL PARTHIAN LETTER HEINSCRIPTIONAL PARTHIAN LETTER WAWINSCRIPTIONAL PART" +
	"HIAN LETTER ZAYININSCRIPTIONAL PARTHIAN LETTER HETHINSCRIPTIONAL PARTHIA" +
	"N LETTER TETHINSCRIPTIONAL PARTHIAN LETTER YODHINSCRIPTIONAL PARTHIAN LE" +
	"TTER KAPHINSCRIPTIONAL PARTHIAN LETTER LAMEDHINSCRIPTIONAL PARTHIAN LETT" +
	"ER MEMINSCRIPTIONAL PARTHIAN LETTER NUNINSCRIPTIONAL PARTHIAN LETTER SAM" +
	"EKHINSCRIPTIONAL PARTHIAN LETTER AYININSCRIPTIONAL PARTHIAN LETTER PEINS" +
	"CRIPTIONAL PARTHIAN LETTER SADHEINSCRIPTIONAL PARTHIAN LETTER QOPHINSCRI" +
	"PTIONAL PARTHIAN LETTER RESHINSCRIPTIONAL PARTHIAN LETTER SHININSCRIPTIO" +
	"NAL PARTHIAN LETTER TAWINSCRIPTIONAL PARTHIAN NUMBER ONEINSCRIPTIONAL PA" +
	"RTHIAN NUMBER TWOINSCRIPTIONAL PARTHIAN NUMBER THREEINSCRIPTIONAL PARTHI" +
	"AN NUMBER FOURINSCRIPTIONAL PARTHIAN NUMBER TENINSCRIPTIONAL PARTHIAN NU" +
	"MBER TWENTYINSCRIPTIONAL PARTHIAN NUMBER ONE HUNDREDINSCRIPTIONAL PARTHI" +
	"AN NUMBER ONE THOUSANDINSCRIPTIONAL PAHLAVI LETTER ALEPHINSCRIPTIONAL PA" +
	"HLAVI LETTER BETHINSCRIPTIONAL PAHLAVI LETTER GIMELINSCRIPTIONAL PAHLAVI" +
	" LETTER DALETHINSCRIPTIONAL PAHLAVI LETTER HEINSCRIPTIONAL PAHLAVI LETTE" +
	"R WAW-AYIN-RESHINSCRIPTIONAL PAHLAVI LETTER ZAYININSCRIPTIONAL PAHLAVI L" +
	"ETTER HETHINSCRIPTIONAL PAHLAVI LETTER TETHINSCRIPTIONAL PAHLAVI LETTER " +
	"YODHINSCRIPTIONAL PAHLAVI LETTER KAPHINSCRIPTIONAL PAHLAVI LETTER LAMEDH" +
	"INSCRIPTIONAL PAHLAVI LETTER MEM-QOPHINSCRIPTIONAL PAHLAVI LETTER NUNINS" +
	"CRIPTIONAL PAHLAVI LETTER SAMEKHINSCRIPTIONAL PAHLAVI LETTER PEINSCRIPTI" +
	"ONAL PAHLAVI LETTER SADHEINSCRIPTIONAL PAHLAVI LETTER SHININSCRIPTIONAL " +
	"PAHLAVI LETTER TAWINSCRIPTIONAL PAHLAVI NUMBER ONEINSCRIPTIONAL PAHLAVI " +
	"NUMBER TWOINSCRIPTIONAL PAHLAVI NUMBER THREEINSCRIPTIONAL PAHLAVI NUMBER" +
	" FOURINSCRIPTIONAL PAHLAVI NUMBER TENINSCRIPTIONAL PAHLAVI NUMBER TWENTY" +
	"INSCRIPTIONAL PAHLAVI NUMBER ONE HUNDREDINSCRIPTIONAL PAHLAVI NUMBER ONE" +
	" THOUSANDPSALTER PAHLAVI LETTER ALEPHPSALTER PAHLAVI LETTER BETHPSALTER " +
	"PAHLAVI LETTER GIMELPSALTER PAHLAVI LETTER DALETHPSALTER PAHLAVI LETTER " +
	"HEPSALTER PAHLAVI LETTER WAW-AYIN-RESHPSALTER PAHLAVI LETTER ZAYINPSALTE" +
	"R PAHLAVI LETTER HETHPSALTER PAHLAVI LETTER YODHPSALTER PAHLAVI LETTER K" +
	"APHPSALTER PAHLAVI LETTER LAMEDHPSALTER PAHLAVI LETTER MEM-QOPHPSALTER P" +
	"AHLAVI LETTER NUNPSALTER PAHLAVI LETTER SAMEKHPSALTER PAHLAVI LETTER PEP" +
	"SALTER PAHLAVI LETTER SADHEPSALTER PAHLAVI LETTER SHINPSALTER PAHLAVI LE" +
	"TTER TAWPSALTER PAHLAVI SECTION MARKPSALTER PAHLAVI TURNED SECTION MARKP" +
	"SALTER PAHLAVI FOUR DOTS WITH CROSSPSALTER PAHLAVI FOUR DOTS WITH DOTPSA" +
	"LTER PAHLAVI NUMBER ONEPSALTER PAHLAVI NUMBER TWOPSALTER PAHLAVI NUMBER ") + ("" +
	"THREEPSALTER PAHLAVI NUMBER FOURPSALTER PAHLAVI NUMBER TENPSALTER PAHLAV" +
	"I NUMBER TWENTYPSALTER PAHLAVI NUMBER ONE HUNDREDOLD TURKIC LETTER ORKHO" +
	"N AOLD TURKIC LETTER YENISEI AOLD TURKIC LETTER YENISEI AEOLD TURKIC LET" +
	"TER ORKHON IOLD TURKIC LETTER YENISEI IOLD TURKIC LETTER YENISEI EOLD TU" +
	"RKIC LETTER ORKHON OOLD TURKIC LETTER ORKHON OEOLD TURKIC LETTER YENISEI" +
	" OEOLD TURKIC LETTER ORKHON ABOLD TURKIC LETTER YENISEI ABOLD TURKIC LET" +
	"TER ORKHON AEBOLD TURKIC LETTER YENISEI AEBOLD TURKIC LETTER ORKHON AGOL" +
	"D TURKIC LETTER YENISEI AGOLD TURKIC LETTER ORKHON AEGOLD TURKIC LETTER " +
	"YENISEI AEGOLD TURKIC LETTER ORKHON ADOLD TURKIC LETTER YENISEI ADOLD TU" +
	"RKIC LETTER ORKHON AEDOLD TURKIC LETTER ORKHON EZOLD TURKIC LETTER YENIS" +
	"EI EZOLD TURKIC LETTER ORKHON AYOLD TURKIC LETTER YENISEI AYOLD TURKIC L" +
	"ETTER ORKHON AEYOLD TURKIC LETTER YENISEI AEYOLD TURKIC LETTER ORKHON AE" +
	"KOLD TURKIC LETTER YENISEI AEKOLD TURKIC LETTER ORKHON OEKOLD TURKIC LET" +
	"TER YENISEI OEKOLD TURKIC LETTER ORKHON ALOLD TURKIC LETTER YENISEI ALOL" +
	"D TURKIC LETTER ORKHON AELOLD TURKIC LETTER ORKHON ELTOLD TURKIC LETTER " +
	"ORKHON EMOLD TURKIC LETTER ORKHON ANOLD TURKIC LETTER ORKHON AENOLD TURK" +
	"IC LETTER YENISEI AENOLD TURKIC LETTER ORKHON ENTOLD TURKIC LETTER YENIS" +
	"EI ENTOLD TURKIC LETTER ORKHON ENCOLD TURKIC LETTER YENISEI ENCOLD TURKI" +
	"C LETTER ORKHON ENYOLD TURKIC LETTER YENISEI ENYOLD TURKIC LETTER YENISE" +
	"I ANGOLD TURKIC LETTER ORKHON ENGOLD TURKIC LETTER YENISEI AENGOLD TURKI" +
	"C LETTER ORKHON EPOLD TURKIC LETTER ORKHON OPOLD TURKIC LETTER ORKHON IC" +
	"OLD TURKIC LETTER ORKHON ECOLD TURKIC LETTER YENISEI ECOLD TURKIC LETTER" +
	" ORKHON AQOLD TURKIC LETTER YENISEI AQOLD TURKIC LETTER ORKHON IQOLD TUR" +
	"KIC LETTER YENISEI IQOLD TURKIC LETTER ORKHON OQOLD TURKIC LETTER YENISE" +
	"I OQOLD TURKIC LETTER ORKHON AROLD TURKIC LETTER YENISEI AROLD TURKIC LE" +
	"TTER ORKHON AEROLD TURKIC LETTER ORKHON ASOLD TURKIC LETTER ORKHON AESOL" +
	"D TURKIC LETTER ORKHON ASHOLD TURKIC LETTER YENISEI ASHOLD TURKIC LETTER" +
	" ORKHON ESHOLD TURKIC LETTER YENISEI ESHOLD TURKIC LETTER ORKHON ATOLD T" +
	"URKIC LETTER YENISEI ATOLD TURKIC LETTER ORKHON AETOLD TURKIC LETTER YEN" +
	"ISEI AETOLD TURKIC LETTER ORKHON OTOLD TURKIC LETTER ORKHON BASHOLD HUNG" +
	"ARIAN CAPITAL LETTER AOLD HUNGARIAN CAPITAL LETTER AAOLD HUNGARIAN CAPIT" +
	"AL LETTER EBOLD HUNGARIAN CAPITAL LETTER AMBOLD HUNGARIAN CAPITAL LETTER" +
	" ECOLD HUNGARIAN CAPITAL LETTER ENCOLD HUNGARIAN CAPITAL LETTER ECSOLD H" +
	"UNGARIAN CAPITAL LETTER EDOLD HUNGARIAN CAPITAL LETTER ANDOLD HUNGARIAN " +
	"CAPITAL LETTER EOLD HUNGARIAN CAPITAL LETTER CLOSE EOLD HUNGARIAN CAPITA" +
	"L LETTER EEOLD HUNGARIAN CAPITAL LETTER EFOLD HUNGARIAN CAPITAL LETTER E" +
	"GOLD HUNGARIAN CAPITAL LETTER EGYOLD HUNGARIAN CAPITAL LETTER EHOLD HUNG" +
	"ARIAN CAPITAL LETTER IOLD HUNGARIAN CAPITAL LETTER IIOLD HUNGARIAN CAPIT" +
	"AL LETTER EJOLD HUNGARIAN CAPITAL LETTER EKOLD HUNGARIAN CAPITAL LETTER " +
	"AKOLD HUNGARIAN CAPITAL LETTER UNKOLD HUNGARIAN CAPITAL LETTER ELOLD HUN" +
	"GARIAN CAPITAL LETTER ELYOLD HUNGARIAN CAPITAL LETTER EMOLD HUNGARIAN CA" +
	"PITAL LETTER ENOLD HUNGARIAN CAPITAL LETTER ENYOLD HUNGARIAN CAPITAL LET" +
	"TER OOLD HUNGARIAN CAPITAL LETTER OOOLD HUNGARIAN CAPITAL LETTER NIKOLSB" +
	"URG OEOLD HUNGARIAN CAPITAL LETTER RUDIMENTA OEOLD HUNGARIAN CAPITAL LET" +
	"TER OEEOLD HUNGARIAN CAPITAL LETTER EPOLD HUNGARIAN CAPITAL LETTER EMPOL" +
	"D HUNGARIAN CAPITAL LETTER EROLD HUNGARIAN CAPITAL LETTER SHORT EROLD HU" +
	"NGARIAN CAPITAL LETTER ESOLD HUNGARIAN CAPITAL LETTER ESZOLD HUNGARIAN C" +
	"APITAL LETTER ETOLD HUNGARIAN CAPITAL LETTER ENTOLD HUNGARIAN CAPITAL LE" +
	"TTER ETYOLD HUNGARIAN CAPITAL LETTER ECHOLD HUNGARIAN CAPITAL LETTER UOL" +
	"D HUNGARIAN CAPITAL LETTER UUOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UEO" +
	"LD HUNGARIAN CAPITAL LETTER RUDIMENTA UEOLD HUNGARIAN CAPITAL LETTER EVO" +
	"LD HUNGARIAN CAPITAL LETTER EZOLD HUNGARIAN CAPITAL LETTER EZSOLD HUNGAR" +
	"IAN CAPITAL LETTER ENT-SHAPED SIGNOLD HUNGARIAN CAPITAL LETTER USOLD HUN" +
	"GARIAN SMALL LETTER AOLD HUNGARIAN SMALL LETTER AAOLD HUNGARIAN SMALL LE" +
	"TTER EBOLD HUNGARIAN SMALL LETTER AMBOLD HUNGARIAN SMALL LETTER ECOLD HU" +
	"NGARIAN SMALL LETTER ENCOLD HUNGARIAN SMALL LETTER ECSOLD HUNGARIAN SMAL" +
	"L LETTER EDOLD HUNGARIAN SMALL LETTER ANDOLD HUNGARIAN SMALL LETTER EOLD" +
	" HUNGARIAN SMALL LETTER CLOSE EOLD HUNGARIAN SMALL LETTER EEOLD HUNGARIA" +
	"N SMALL LETTER EFOLD HUNGARIAN SMALL LETTER EGOLD HUNGARIAN SMALL LETTER" +
	" EGYOLD HUNGARIAN SMALL LETTER EHOLD HUNGARIAN SMALL LETTER IOLD HUNGARI" +
	"AN SMALL LETTER IIOLD HUNGARIAN SMALL LETTER EJOLD HUNGARIAN SMALL LETTE" +
	"R EKOLD HUNGARIAN SMALL LETTER AKOLD HUNGARIAN SMALL LETTER UNKOLD HUNGA" +
	"RIAN SMALL LETTER ELOLD HUNGARIAN SMALL LETTER ELYOLD HUNGARIAN SMALL LE" +
	"TTER EMOLD HUNGARIAN SMALL LETTER ENOLD HUNGARIAN SMALL LETTER ENYOLD HU") + ("" +
	"NGARIAN SMALL LETTER OOLD HUNGARIAN SMALL LETTER OOOLD HUNGARIAN SMALL L" +
	"ETTER NIKOLSBURG OEOLD HUNGARIAN SMALL LETTER RUDIMENTA OEOLD HUNGARIAN " +
	"SMALL LETTER OEEOLD HUNGARIAN SMALL LETTER EPOLD HUNGARIAN SMALL LETTER " +
	"EMPOLD HUNGARIAN SMALL LETTER EROLD HUNGARIAN SMALL LETTER SHORT EROLD H" +
	"UNGARIAN SMALL LETTER ESOLD HUNGARIAN SMALL LETTER ESZOLD HUNGARIAN SMAL" +
	"L LETTER ETOLD HUNGARIAN SMALL LETTER ENTOLD HUNGARIAN SMALL LETTER ETYO" +
	"LD HUNGARIAN SMALL LETTER ECHOLD HUNGARIAN SMALL LETTER UOLD HUNGARIAN S" +
	"MALL LETTER UUOLD HUNGARIAN SMALL LETTER NIKOLSBURG UEOLD HUNGARIAN SMAL" +
	"L LETTER RUDIMENTA UEOLD HUNGARIAN SMALL LETTER EVOLD HUNGARIAN SMALL LE" +
	"TTER EZOLD HUNGARIAN SMALL LETTER EZSOLD HUNGARIAN SMALL LETTER ENT-SHAP" +
	"ED SIGNOLD HUNGARIAN SMALL LETTER USOLD HUNGARIAN NUMBER ONEOLD HUNGARIA" +
	"N NUMBER FIVEOLD HUNGARIAN NUMBER TENOLD HUNGARIAN NUMBER FIFTYOLD HUNGA" +
	"RIAN NUMBER ONE HUNDREDOLD HUNGARIAN NUMBER ONE THOUSANDHANIFI ROHINGYA " +
	"LETTER AHANIFI ROHINGYA LETTER BAHANIFI ROHINGYA LETTER PAHANIFI ROHINGY" +
	"A LETTER TAHANIFI ROHINGYA LETTER TTAHANIFI ROHINGYA LETTER JAHANIFI ROH" +
	"INGYA LETTER CAHANIFI ROHINGYA LETTER HAHANIFI ROHINGYA LETTER KHAHANIFI" +
	" ROHINGYA LETTER FAHANIFI ROHINGYA LETTER DAHANIFI ROHINGYA LETTER DDAHA" +
	"NIFI ROHINGYA LETTER RAHANIFI ROHINGYA LETTER RRAHANIFI ROHINGYA LETTER " +
	"ZAHANIFI ROHINGYA LETTER SAHANIFI ROHINGYA LETTER SHAHANIFI ROHINGYA LET" +
	"TER KAHANIFI ROHINGYA LETTER GAHANIFI ROHINGYA LETTER LAHANIFI ROHINGYA " +
	"LETTER MAHANIFI ROHINGYA LETTER NAHANIFI ROHINGYA LETTER WAHANIFI ROHING" +
	"YA LETTER KINNA WAHANIFI ROHINGYA LETTER YAHANIFI ROHINGYA LETTER KINNA " +
	"YAHANIFI ROHINGYA LETTER NGAHANIFI ROHINGYA LETTER NYAHANIFI ROHINGYA LE" +
	"TTER VAHANIFI ROHINGYA VOWEL AHANIFI ROHINGYA VOWEL IHANIFI ROHINGYA VOW" +
	"EL UHANIFI ROHINGYA VOWEL EHANIFI ROHINGYA VOWEL OHANIFI ROHINGYA MARK S" +
	"AKINHANIFI ROHINGYA MARK NA KHONNAHANIFI ROHINGYA SIGN HARBAHAYHANIFI RO" +
	"HINGYA SIGN TAHALAHANIFI ROHINGYA SIGN TANAHANIFI ROHINGYA SIGN TASSIHAN" +
	"IFI ROHINGYA DIGIT ZEROHANIFI ROHINGYA DIGIT ONEHANIFI ROHINGYA DIGIT TW" +
	"OHANIFI ROHINGYA DIGIT THREEHANIFI ROHINGYA DIGIT FOURHANIFI ROHINGYA DI" +
	"GIT FIVEHANIFI ROHINGYA DIGIT SIXHANIFI ROHINGYA DIGIT SEVENHANIFI ROHIN" +
	"GYA DIGIT EIGHTHANIFI ROHINGYA DIGIT NINEGARAY DIGIT ZEROGARAY DIGIT ONE" +
	"GARAY DIGIT TWOGARAY DIGIT THREEGARAY DIGIT FOURGARAY DIGIT FIVEGARAY DI" +
	"GIT SIXGARAY DIGIT SEVENGARAY DIGIT EIGHTGARAY DIGIT NINEGARAY VOWEL SIG" +
	"N AGARAY VOWEL SIGN IGARAY VOWEL SIGN OGARAY VOWEL SIGN EEGARAY VOWEL LE" +
	"NGTH MARKGARAY SUKUNGARAY CAPITAL LETTER AGARAY CAPITAL LETTER CAGARAY C" +
	"APITAL LETTER MAGARAY CAPITAL LETTER KAGARAY CAPITAL LETTER BAGARAY CAPI" +
	"TAL LETTER JAGARAY CAPITAL LETTER SAGARAY CAPITAL LETTER WAGARAY CAPITAL" +
	" LETTER LAGARAY CAPITAL LETTER GAGARAY CAPITAL LETTER DAGARAY CAPITAL LE" +
	"TTER XAGARAY CAPITAL LETTER YAGARAY CAPITAL LETTER TAGARAY CAPITAL LETTE" +
	"R RAGARAY CAPITAL LETTER NYAGARAY CAPITAL LETTER FAGARAY CAPITAL LETTER " +
	"NAGARAY CAPITAL LETTER PAGARAY CAPITAL LETTER HAGARAY CAPITAL LETTER OLD" +
	" KAGARAY CAPITAL LETTER OLD NAGARAY VOWEL SIGN EGARAY CONSONANT GEMINATI" +
	"ON MARKGARAY COMBINING DOT ABOVEGARAY COMBINING DOUBLE DOT ABOVEGARAY CO" +
	"NSONANT NASALIZATION MARKGARAY HYPHENGARAY REDUPLICATION MARKGARAY SMALL" +
	" LETTER AGARAY SMALL LETTER CAGARAY SMALL LETTER MAGARAY SMALL LETTER KA" +
	"GARAY SMALL LETTER BAGARAY SMALL LETTER JAGARAY SMALL LETTER SAGARAY SMA" +
	"LL LETTER WAGARAY SMALL LETTER LAGARAY SMALL LETTER GAGARAY SMALL LETTER" +
	" DAGARAY SMALL LETTER XAGARAY SMALL LETTER YAGARAY SMALL LETTER TAGARAY " +
	"SMALL LETTER RAGARAY SMALL LETTER NYAGARAY SMALL LETTER FAGARAY SMALL LE" +
	"TTER NAGARAY SMALL LETTER PAGARAY SMALL LETTER HAGARAY SMALL LETTER OLD " +
	"KAGARAY SMALL LETTER OLD NAGARAY PLUS SIGNGARAY MINUS SIGNRUMI DIGIT ONE" +
	"RUMI DIGIT TWORUMI DIGIT THREERUMI DIGIT FOURRUMI DIGIT FIVERUMI DIGIT S" +
	"IXRUMI DIGIT SEVENRUMI DIGIT EIGHTRUMI DIGIT NINERUMI NUMBER TENRUMI NUM" +
	"BER TWENTYRUMI NUMBER THIRTYRUMI NUMBER FORTYRUMI NUMBER FIFTYRUMI NUMBE" +
	"R SIXTYRUMI NUMBER SEVENTYRUMI NUMBER EIGHTYRUMI NUMBER NINETYRUMI NUMBE" +
	"R ONE HUNDREDRUMI NUMBER TWO HUNDREDRUMI NUMBER THREE HUNDREDRUMI NUMBER" +
	" FOUR HUNDREDRUMI NUMBER FIVE HUNDREDRUMI NUMBER SIX HUNDREDRUMI NUMBER " +
	"SEVEN HUNDREDRUMI NUMBER EIGHT HUNDREDRUMI NUMBER NINE HUNDREDRUMI FRACT" +
	"ION ONE HALFRUMI FRACTION ONE QUARTERRUMI FRACTION ONE THIRDRUMI FRACTIO" +
	"N TWO THIRDSYEZIDI LETTER ELIFYEZIDI LETTER BEYEZIDI LETTER PEYEZIDI LET" +
	"TER PHEYEZIDI LETTER THEYEZIDI LETTER SEYEZIDI LETTER CIMYEZIDI LETTER C" +
	"HIMYEZIDI LETTER CHHIMYEZIDI LETTER HHAYEZIDI LETTER XAYEZIDI LETTER DAL" +
	"YEZIDI LETTER ZALYEZIDI LETTER RAYEZIDI LETTER RHAYEZIDI LETTER ZAYEZIDI" +
	" LETTER JAYEZIDI LETTER SINYEZIDI LETTER SHINYEZIDI LETTER SADYEZIDI LET") + ("" +
	"TER DADYEZIDI LETTER TAYEZIDI LETTER ZEYEZIDI LETTER EYNYEZIDI LETTER XH" +
	"EYNYEZIDI LETTER FAYEZIDI LETTER VAYEZIDI LETTER VA ALTERNATE FORMYEZIDI" +
	" LETTER QAFYEZIDI LETTER KAFYEZIDI LETTER KHAFYEZIDI LETTER GAFYEZIDI LE" +
	"TTER LAMYEZIDI LETTER MIMYEZIDI LETTER NUNYEZIDI LETTER UMYEZIDI LETTER " +
	"WAWYEZIDI LETTER OWYEZIDI LETTER EWYEZIDI LETTER HAYYEZIDI LETTER YOTYEZ" +
	"IDI LETTER ETYEZIDI COMBINING HAMZA MARKYEZIDI COMBINING MADDA MARKYEZID" +
	"I HYPHENATION MARKYEZIDI LETTER LAM WITH DOT ABOVEYEZIDI LETTER YOT WITH" +
	" CIRCUMFLEX ABOVEARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOWARABIC " +
	"LETTER TAH WITH TWO DOTS VERTICALLY BELOWARABIC LETTER KAF WITH TWO DOTS" +
	" VERTICALLY BELOWARABIC SMALL YEH BARREE WITH TWO DOTS BELOWARABIC LETTE" +
	"R THIN NOONARABIC LETTER YEH WITH FOUR DOTS BELOWARABIC BIBLICAL END OF " +
	"VERSEARABIC LIGATURE ALAYHAA AS-SALAATU WAS-SALAAMARABIC LIGATURE ALAYHI" +
	"M AS-SALAATU WAS-SALAAMARABIC LIGATURE ALAYHIMAA AS-SALAATU WAS-SALAAMAR" +
	"ABIC LIGATURE QADDASA ALLAAHU SIRRAHARABIC LIGATURE QUDDISA SIRRUHUMARAB" +
	"IC LIGATURE QUDDISA SIRRUHUMAAARABIC LIGATURE QUDDISAT ASRAARUHUMARABIC " +
	"LIGATURE NAWWARA ALLAAHU MARQADAHARABIC DOUBLE VERTICAL BAR BELOWARABIC " +
	"SMALL LOW NOONARABIC COMBINING ALEF OVERLAYARABIC SMALL LOW WORD SAKTAAR" +
	"ABIC SMALL LOW WORD QASRARABIC SMALL LOW WORD MADDAOLD SOGDIAN LETTER AL" +
	"EPHOLD SOGDIAN LETTER FINAL ALEPHOLD SOGDIAN LETTER BETHOLD SOGDIAN LETT" +
	"ER FINAL BETHOLD SOGDIAN LETTER GIMELOLD SOGDIAN LETTER HEOLD SOGDIAN LE" +
	"TTER FINAL HEOLD SOGDIAN LETTER WAWOLD SOGDIAN LETTER ZAYINOLD SOGDIAN L" +
	"ETTER HETHOLD SOGDIAN LETTER YODHOLD SOGDIAN LETTER KAPHOLD SOGDIAN LETT" +
	"ER LAMEDHOLD SOGDIAN LETTER MEMOLD SOGDIAN LETTER NUNOLD SOGDIAN LETTER " +
	"FINAL NUNOLD SOGDIAN LETTER FINAL NUN WITH VERTICAL TAILOLD SOGDIAN LETT" +
	"ER SAMEKHOLD SOGDIAN LETTER AYINOLD SOGDIAN LETTER ALTERNATE AYINOLD SOG" +
	"DIAN LETTER PEOLD SOGDIAN LETTER SADHEOLD SOGDIAN LETTER FINAL SADHEOLD " +
	"SOGDIAN LETTER FINAL SADHE WITH VERTICAL TAILOLD SOGDIAN LETTER RESH-AYI" +
	"N-DALETHOLD SOGDIAN LETTER SHINOLD SOGDIAN LETTER TAWOLD SOGDIAN LETTER " +
	"FINAL TAWOLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAILOLD SOGDIAN NUMB" +
	"ER ONEOLD SOGDIAN NUMBER TWOOLD SOGDIAN NUMBER THREEOLD SOGDIAN NUMBER F" +
	"OUROLD SOGDIAN NUMBER FIVEOLD SOGDIAN NUMBER TENOLD SOGDIAN NUMBER TWENT" +
	"YOLD SOGDIAN NUMBER THIRTYOLD SOGDIAN NUMBER ONE HUNDREDOLD SOGDIAN FRAC" +
	"TION ONE HALFOLD SOGDIAN LIGATURE AYIN-DALETHSOGDIAN LETTER ALEPHSOGDIAN" +
	" LETTER BETHSOGDIAN LETTER GIMELSOGDIAN LETTER HESOGDIAN LETTER WAWSOGDI" +
	"AN LETTER ZAYINSOGDIAN LETTER HETHSOGDIAN LETTER YODHSOGDIAN LETTER KAPH" +
	"SOGDIAN LETTER LAMEDHSOGDIAN LETTER MEMSOGDIAN LETTER NUNSOGDIAN LETTER " +
	"SAMEKHSOGDIAN LETTER AYINSOGDIAN LETTER PESOGDIAN LETTER SADHESOGDIAN LE" +
	"TTER RESH-AYINSOGDIAN LETTER SHINSOGDIAN LETTER TAWSOGDIAN LETTER FETHSO" +
	"GDIAN LETTER LESHSOGDIAN INDEPENDENT SHINSOGDIAN COMBINING DOT BELOWSOGD" +
	"IAN COMBINING TWO DOTS BELOWSOGDIAN COMBINING DOT ABOVESOGDIAN COMBINING" +
	" TWO DOTS ABOVESOGDIAN COMBINING CURVE ABOVESOGDIAN COMBINING CURVE BELO" +
	"WSOGDIAN COMBINING HOOK ABOVESOGDIAN COMBINING HOOK BELOWSOGDIAN COMBINI" +
	"NG LONG HOOK BELOWSOGDIAN COMBINING RESH BELOWSOGDIAN COMBINING STROKE B" +
	"ELOWSOGDIAN NUMBER ONESOGDIAN NUMBER TENSOGDIAN NUMBER TWENTYSOGDIAN NUM" +
	"BER ONE HUNDREDSOGDIAN PUNCTUATION TWO VERTICAL BARSSOGDIAN PUNCTUATION " +
	"TWO VERTICAL BARS WITH DOTSSOGDIAN PUNCTUATION CIRCLE WITH DOTSOGDIAN PU" +
	"NCTUATION TWO CIRCLES WITH DOTSSOGDIAN PUNCTUATION HALF CIRCLE WITH DOTO" +
	"LD UYGHUR LETTER ALEPHOLD UYGHUR LETTER BETHOLD UYGHUR LETTER GIMEL-HETH" +
	"OLD UYGHUR LETTER WAWOLD UYGHUR LETTER ZAYINOLD UYGHUR LETTER FINAL HETH" +
	"OLD UYGHUR LETTER YODHOLD UYGHUR LETTER KAPHOLD UYGHUR LETTER LAMEDHOLD " +
	"UYGHUR LETTER MEMOLD UYGHUR LETTER NUNOLD UYGHUR LETTER SAMEKHOLD UYGHUR" +
	" LETTER PEOLD UYGHUR LETTER SADHEOLD UYGHUR LETTER RESHOLD UYGHUR LETTER" +
	" SHINOLD UYGHUR LETTER TAWOLD UYGHUR LETTER LESHOLD UYGHUR COMBINING DOT" +
	" ABOVEOLD UYGHUR COMBINING DOT BELOWOLD UYGHUR COMBINING TWO DOTS ABOVEO" +
	"LD UYGHUR COMBINING TWO DOTS BELOWOLD UYGHUR PUNCTUATION BAROLD UYGHUR P" +
	"UNCTUATION TWO BARSOLD UYGHUR PUNCTUATION TWO DOTSOLD UYGHUR PUNCTUATION" +
	" FOUR DOTSCHORASMIAN LETTER ALEPHCHORASMIAN LETTER SMALL ALEPHCHORASMIAN" +
	" LETTER BETHCHORASMIAN LETTER GIMELCHORASMIAN LETTER DALETHCHORASMIAN LE" +
	"TTER HECHORASMIAN LETTER WAWCHORASMIAN LETTER CURLED WAWCHORASMIAN LETTE" +
	"R ZAYINCHORASMIAN LETTER HETHCHORASMIAN LETTER YODHCHORASMIAN LETTER KAP" +
	"HCHORASMIAN LETTER LAMEDHCHORASMIAN LETTER MEMCHORASMIAN LETTER NUNCHORA" +
	"SMIAN LETTER SAMEKHCHORASMIAN LETTER AYINCHORASMIAN LETTER PECHORASMIAN " +
	"LETTER RESHCHORASMIAN LETTER SHINCHORASMIAN LETTER TAWCHORASMIAN NUMBER " +
	"ONECHORASMIAN NUMBER TWOCHORASMIAN NUMBER THREECHORASMIAN NUMBER FOURCHO") + ("" +
	"RASMIAN NUMBER TENCHORASMIAN NUMBER TWENTYCHORASMIAN NUMBER ONE HUNDREDE" +
	"LYMAIC LETTER ALEPHELYMAIC LETTER BETHELYMAIC LETTER GIMELELYMAIC LETTER" +
	" DALETHELYMAIC LETTER HEELYMAIC LETTER WAWELYMAIC LETTER ZAYINELYMAIC LE" +
	"TTER HETHELYMAIC LETTER TETHELYMAIC LETTER YODHELYMAIC LETTER KAPHELYMAI" +
	"C LETTER LAMEDHELYMAIC LETTER MEMELYMAIC LETTER NUNELYMAIC LETTER SAMEKH" +
	"ELYMAIC LETTER AYINELYMAIC LETTER PEELYMAIC LETTER SADHEELYMAIC LETTER Q" +
	"OPHELYMAIC LETTER RESHELYMAIC LETTER SHINELYMAIC LETTER TAWELYMAIC LIGAT" +
	"URE ZAYIN-YODHBRAHMI SIGN CANDRABINDUBRAHMI SIGN ANUSVARABRAHMI SIGN VIS" +
	"ARGABRAHMI SIGN JIHVAMULIYABRAHMI SIGN UPADHMANIYABRAHMI LETTER ABRAHMI " +
	"LETTER AABRAHMI LETTER IBRAHMI LETTER IIBRAHMI LETTER UBRAHMI LETTER UUB" +
	"RAHMI LETTER VOCALIC RBRAHMI LETTER VOCALIC RRBRAHMI LETTER VOCALIC LBRA" +
	"HMI LETTER VOCALIC LLBRAHMI LETTER EBRAHMI LETTER AIBRAHMI LETTER OBRAHM" +
	"I LETTER AUBRAHMI LETTER KABRAHMI LETTER KHABRAHMI LETTER GABRAHMI LETTE" +
	"R GHABRAHMI LETTER NGABRAHMI LETTER CABRAHMI LETTER CHABRAHMI LETTER JAB" +
	"RAHMI LETTER JHABRAHMI LETTER NYABRAHMI LETTER TTABRAHMI LETTER TTHABRAH" +
	"MI LETTER DDABRAHMI LETTER DDHABRAHMI LETTER NNABRAHMI LETTER TABRAHMI L" +
	"ETTER THABRAHMI LETTER DABRAHMI LETTER DHABRAHMI LETTER NABRAHMI LETTER " +
	"PABRAHMI LETTER PHABRAHMI LETTER BABRAHMI LETTER BHABRAHMI LETTER MABRAH" +
	"MI LETTER YABRAHMI LETTER RABRAHMI LETTER LABRAHMI LETTER VABRAHMI LETTE" +
	"R SHABRAHMI LETTER SSABRAHMI LETTER SABRAHMI LETTER HABRAHMI LETTER LLAB" +
	"RAHMI LETTER OLD TAMIL LLLABRAHMI LETTER OLD TAMIL RRABRAHMI LETTER OLD " +
	"TAMIL NNNABRAHMI VOWEL SIGN AABRAHMI VOWEL SIGN BHATTIPROLU AABRAHMI VOW" +
	"EL SIGN IBRAHMI VOWEL SIGN IIBRAHMI VOWEL SIGN UBRAHMI VOWEL SIGN UUBRAH" +
	"MI VOWEL SIGN VOCALIC RBRAHMI VOWEL SIGN VOCALIC RRBRAHMI VOWEL SIGN VOC" +
	"ALIC LBRAHMI VOWEL SIGN VOCALIC LLBRAHMI VOWEL SIGN EBRAHMI VOWEL SIGN A" +
	"IBRAHMI VOWEL SIGN OBRAHMI VOWEL SIGN AUBRAHMI VIRAMABRAHMI DANDABRAHMI " +
	"DOUBLE DANDABRAHMI PUNCTUATION DOTBRAHMI PUNCTUATION DOUBLE DOTBRAHMI PU" +
	"NCTUATION LINEBRAHMI PUNCTUATION CRESCENT BARBRAHMI PUNCTUATION LOTUSBRA" +
	"HMI NUMBER ONEBRAHMI NUMBER TWOBRAHMI NUMBER THREEBRAHMI NUMBER FOURBRAH" +
	"MI NUMBER FIVEBRAHMI NUMBER SIXBRAHMI NUMBER SEVENBRAHMI NUMBER EIGHTBRA" +
	"HMI NUMBER NINEBRAHMI NUMBER TENBRAHMI NUMBER TWENTYBRAHMI NUMBER THIRTY" +
	"BRAHMI NUMBER FORTYBRAHMI NUMBER FIFTYBRAHMI NUMBER SIXTYBRAHMI NUMBER S" +
	"EVENTYBRAHMI NUMBER EIGHTYBRAHMI NUMBER NINETYBRAHMI NUMBER ONE HUNDREDB" +
	"RAHMI NUMBER ONE THOUSANDBRAHMI DIGIT ZEROBRAHMI DIGIT ONEBRAHMI DIGIT T" +
	"WOBRAHMI DIGIT THREEBRAHMI DIGIT FOURBRAHMI DIGIT FIVEBRAHMI DIGIT SIXBR" +
	"AHMI DIGIT SEVENBRAHMI DIGIT EIGHTBRAHMI DIGIT NINEBRAHMI SIGN OLD TAMIL" +
	" VIRAMABRAHMI LETTER OLD TAMIL SHORT EBRAHMI LETTER OLD TAMIL SHORT OBRA" +
	"HMI VOWEL SIGN OLD TAMIL SHORT EBRAHMI VOWEL SIGN OLD TAMIL SHORT OBRAHM" +
	"I LETTER OLD TAMIL LLABRAHMI NUMBER JOINERKAITHI SIGN CANDRABINDUKAITHI " +
	"SIGN ANUSVARAKAITHI SIGN VISARGAKAITHI LETTER AKAITHI LETTER AAKAITHI LE" +
	"TTER IKAITHI LETTER IIKAITHI LETTER UKAITHI LETTER UUKAITHI LETTER EKAIT" +
	"HI LETTER AIKAITHI LETTER OKAITHI LETTER AUKAITHI LETTER KAKAITHI LETTER" +
	" KHAKAITHI LETTER GAKAITHI LETTER GHAKAITHI LETTER NGAKAITHI LETTER CAKA" +
	"ITHI LETTER CHAKAITHI LETTER JAKAITHI LETTER JHAKAITHI LETTER NYAKAITHI " +
	"LETTER TTAKAITHI LETTER TTHAKAITHI LETTER DDAKAITHI LETTER DDDHAKAITHI L" +
	"ETTER DDHAKAITHI LETTER RHAKAITHI LETTER NNAKAITHI LETTER TAKAITHI LETTE" +
	"R THAKAITHI LETTER DAKAITHI LETTER DHAKAITHI LETTER NAKAITHI LETTER PAKA" +
	"ITHI LETTER PHAKAITHI LETTER BAKAITHI LETTER BHAKAITHI LETTER MAKAITHI L" +
	"ETTER YAKAITHI LETTER RAKAITHI LETTER LAKAITHI LETTER VAKAITHI LETTER SH" +
	"AKAITHI LETTER SSAKAITHI LETTER SAKAITHI LETTER HAKAITHI VOWEL SIGN AAKA" +
	"ITHI VOWEL SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL SIGN UKAITHI VOWEL SIG" +
	"N UUKAITHI VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI VOWEL SIGN OKAITHI VOW" +
	"EL SIGN AUKAITHI SIGN VIRAMAKAITHI SIGN NUKTAKAITHI ABBREVIATION SIGNKAI" +
	"THI ENUMERATION SIGNKAITHI NUMBER SIGNKAITHI SECTION MARKKAITHI DOUBLE S" +
	"ECTION MARKKAITHI DANDAKAITHI DOUBLE DANDAKAITHI VOWEL SIGN VOCALIC RKAI" +
	"THI NUMBER SIGN ABOVESORA SOMPENG LETTER SAHSORA SOMPENG LETTER TAHSORA " +
	"SOMPENG LETTER BAHSORA SOMPENG LETTER CAHSORA SOMPENG LETTER DAHSORA SOM" +
	"PENG LETTER GAHSORA SOMPENG LETTER MAHSORA SOMPENG LETTER NGAHSORA SOMPE" +
	"NG LETTER LAHSORA SOMPENG LETTER NAHSORA SOMPENG LETTER VAHSORA SOMPENG " +
	"LETTER PAHSORA SOMPENG LETTER YAHSORA SOMPENG LETTER RAHSORA SOMPENG LET" +
	"TER HAHSORA SOMPENG LETTER KAHSORA SOMPENG LETTER JAHSORA SOMPENG LETTER" +
	" NYAHSORA SOMPENG LETTER AHSORA SOMPENG LETTER EEHSORA SOMPENG LETTER IH" +
	"SORA SOMPENG LETTER UHSORA SOMPENG LETTER OHSORA SOMPENG LETTER EHSORA S" +
	"OMPENG LETTER MAESORA SOMPENG DIGIT ZEROSORA SOMPENG DIGIT ONESORA SOMPE") + ("" +
	"NG DIGIT TWOSORA SOMPENG DIGIT THREESORA SOMPENG DIGIT FOURSORA SOMPENG " +
	"DIGIT FIVESORA SOMPENG DIGIT SIXSORA SOMPENG DIGIT SEVENSORA SOMPENG DIG" +
	"IT EIGHTSORA SOMPENG DIGIT NINECHAKMA SIGN CANDRABINDUCHAKMA SIGN ANUSVA" +
	"RACHAKMA SIGN VISARGACHAKMA LETTER AACHAKMA LETTER ICHAKMA LETTER UCHAKM" +
	"A LETTER ECHAKMA LETTER KAACHAKMA LETTER KHAACHAKMA LETTER GAACHAKMA LET" +
	"TER GHAACHAKMA LETTER NGAACHAKMA LETTER CAACHAKMA LETTER CHAACHAKMA LETT" +
	"ER JAACHAKMA LETTER JHAACHAKMA LETTER NYAACHAKMA LETTER TTAACHAKMA LETTE" +
	"R TTHAACHAKMA LETTER DDAACHAKMA LETTER DDHAACHAKMA LETTER NNAACHAKMA LET" +
	"TER TAACHAKMA LETTER THAACHAKMA LETTER DAACHAKMA LETTER DHAACHAKMA LETTE" +
	"R NAACHAKMA LETTER PAACHAKMA LETTER PHAACHAKMA LETTER BAACHAKMA LETTER B" +
	"HAACHAKMA LETTER MAACHAKMA LETTER YYAACHAKMA LETTER YAACHAKMA LETTER RAA" +
	"CHAKMA LETTER LAACHAKMA LETTER WAACHAKMA LETTER SAACHAKMA LETTER HAACHAK" +
	"MA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAKMA VOWEL SIGN IICHAKMA VOWEL SIGN " +
	"UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN ECHAKMA VOWEL SIGN AICHAKMA VOWEL" +
	" SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWEL SIGN OICHAKMA O MARKCHAKMA AU MA" +
	"RKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DIGIT ZEROCHAKMA DIGIT ONECHAKMA DIG" +
	"IT TWOCHAKMA DIGIT THREECHAKMA DIGIT FOURCHAKMA DIGIT FIVECHAKMA DIGIT S" +
	"IXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHTCHAKMA DIGIT NINECHAKMA SECTION MA" +
	"RKCHAKMA DANDACHAKMA DOUBLE DANDACHAKMA QUESTION MARKCHAKMA LETTER LHAAC" +
	"HAKMA VOWEL SIGN AACHAKMA VOWEL SIGN EICHAKMA LETTER VAAMAHAJANI LETTER " +
	"AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTER EMAHAJANI LETTER OMAH" +
	"AJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER GAMAHAJANI LETTER GHAM" +
	"AHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETTER JAMAHAJANI LETTER JH" +
	"AMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI LETTER TTHAMAHAJANI LETT" +
	"ER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHAJANI LETTER TAMAHAJANI " +
	"LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMAHAJANI LETTER NAMAHAJAN" +
	"I LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAMAHAJANI LETTER BHAMAHAJ" +
	"ANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LAMAHAJANI LETTER VAMAHAJ" +
	"ANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RRAMAHAJANI SIGN NUKTAMAH" +
	"AJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJANI LIGATURE SHRISHARAD" +
	"A SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SIGN VISARGASHARADA LETTE" +
	"R ASHARADA LETTER AASHARADA LETTER ISHARADA LETTER IISHARADA LETTER USHA" +
	"RADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LETTER VOCALIC RRSHARADA L" +
	"ETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA LETTER ESHARADA LETTER A" +
	"ISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER KASHARADA LETTER KHASHA" +
	"RADA LETTER GASHARADA LETTER GHASHARADA LETTER NGASHARADA LETTER CASHARA" +
	"DA LETTER CHASHARADA LETTER JASHARADA LETTER JHASHARADA LETTER NYASHARAD" +
	"A LETTER TTASHARADA LETTER TTHASHARADA LETTER DDASHARADA LETTER DDHASHAR" +
	"ADA LETTER NNASHARADA LETTER TASHARADA LETTER THASHARADA LETTER DASHARAD" +
	"A LETTER DHASHARADA LETTER NASHARADA LETTER PASHARADA LETTER PHASHARADA " +
	"LETTER BASHARADA LETTER BHASHARADA LETTER MASHARADA LETTER YASHARADA LET" +
	"TER RASHARADA LETTER LASHARADA LETTER LLASHARADA LETTER VASHARADA LETTER" +
	" SHASHARADA LETTER SSASHARADA LETTER SASHARADA LETTER HASHARADA VOWEL SI" +
	"GN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHARADA VOWEL SIGN USHARAD" +
	"A VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARADA VOWEL SIGN VOCALIC RR" +
	"SHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VOCALIC LLSHARADA VOWEL S" +
	"IGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHARADA VOWEL SIGN AUSHARA" +
	"DA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN JIHVAMULIYASHARADA SIGN " +
	"UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE DANDASHARADA ABBREVIATI" +
	"ON SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARADA SIGN NUKTASHARADA VOW" +
	"EL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHARADA SUTRA MARKSHARADA " +
	"VOWEL SIGN PRISHTHAMATRA ESHARADA SIGN INVERTED CANDRABINDUSHARADA DIGIT" +
	" ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DIGIT THREESHARADA DIGIT " +
	"FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DIGIT SEVENSHARADA DIGIT " +
	"EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN SIDDHAMSHARADA HEADSTROK" +
	"ESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1SHARADA SECTION MARK-2SI" +
	"NHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOSINHALA ARCHAIC DIGIT TH" +
	"REESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGIT FIVESINHALA ARCHAIC D" +
	"IGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAIC DIGIT EIGHTSINHALA AR" +
	"CHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA ARCHAIC NUMBER TWENTYS" +
	"INHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBER FORTYSINHALA ARCHAIC " +
	"NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA ARCHAIC NUMBER SEVENTYSI" +
	"NHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER NINETYSINHALA ARCHAIC " +
	"NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOUSANDKHOJKI LETTER AKHOJ") + ("" +
	"KI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI LETTER EKHOJKI LETTER A" +
	"IKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAKHOJKI LETTER KHAKHOJKI " +
	"LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI LETTER NGAKHOJKI LETTE" +
	"R CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTER JJAKHOJKI LETTER NYAK" +
	"HOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER DDAKHOJKI LETTER DDHAKHO" +
	"JKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKHOJKI LETTER DAKHOJKI LE" +
	"TTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI LETTER PAKHOJKI LETTER " +
	"PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER BHAKHOJKI LETTER MAKHO" +
	"JKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJKI LETTER VAKHOJKI LETT" +
	"ER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWEL SIGN AAKHOJKI VOWEL S" +
	"IGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJKI VOWEL SIGN EKHOJKI VO" +
	"WEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN AUKHOJKI SIGN ANUSVARAKH" +
	"OJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHADDAKHOJKI DANDAKHOJKI DO" +
	"UBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MARKKHOJKI DOUBLE SECTION " +
	"MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNKHOJKI LETTER QAKHOJKI LETT" +
	"ER SHORT IKHOJKI VOWEL SIGN VOCALIC RMULTANI LETTER AMULTANI LETTER IMUL" +
	"TANI LETTER UMULTANI LETTER EMULTANI LETTER KAMULTANI LETTER KHAMULTANI " +
	"LETTER GAMULTANI LETTER GHAMULTANI LETTER CAMULTANI LETTER CHAMULTANI LE" +
	"TTER JAMULTANI LETTER JJAMULTANI LETTER NYAMULTANI LETTER TTAMULTANI LET" +
	"TER TTHAMULTANI LETTER DDAMULTANI LETTER DDDAMULTANI LETTER DDHAMULTANI " +
	"LETTER NNAMULTANI LETTER TAMULTANI LETTER THAMULTANI LETTER DAMULTANI LE" +
	"TTER DHAMULTANI LETTER NAMULTANI LETTER PAMULTANI LETTER PHAMULTANI LETT" +
	"ER BAMULTANI LETTER BHAMULTANI LETTER MAMULTANI LETTER YAMULTANI LETTER " +
	"RAMULTANI LETTER LAMULTANI LETTER VAMULTANI LETTER SAMULTANI LETTER HAMU" +
	"LTANI LETTER RRAMULTANI LETTER RHAMULTANI SECTION MARKKHUDAWADI LETTER A" +
	"KHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDAWADI LETTER IIKHUDAWADI LETTER" +
	" UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHUDAWADI LETTER AIKHUDAWADI LETT" +
	"ER OKHUDAWADI LETTER AUKHUDAWADI LETTER KAKHUDAWADI LETTER KHAKHUDAWADI " +
	"LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LETTER GHAKHUDAWADI LETTER NGAKHU" +
	"DAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAWADI LETTER JAKHUDAWADI LETTER " +
	"JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NYAKHUDAWADI LETTER TTAKHUDAWADI" +
	" LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI LETTER DDDAKHUDAWADI LETTER RR" +
	"AKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNAKHUDAWADI LETTER TAKHUDAWADI L" +
	"ETTER THAKHUDAWADI LETTER DAKHUDAWADI LETTER DHAKHUDAWADI LETTER NAKHUDA" +
	"WADI LETTER PAKHUDAWADI LETTER PHAKHUDAWADI LETTER BAKHUDAWADI LETTER BB" +
	"AKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKHUDAWADI LETTER YAKHUDAWADI LET" +
	"TER RAKHUDAWADI LETTER LAKHUDAWADI LETTER VAKHUDAWADI LETTER SHAKHUDAWAD" +
	"I LETTER SAKHUDAWADI LETTER HAKHUDAWADI SIGN ANUSVARAKHUDAWADI VOWEL SIG" +
	"N AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL SIGN IIKHUDAWADI VOWEL SIGN UK" +
	"HUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN EKHUDAWADI VOWEL SIGN AIKHUDA" +
	"WADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKHUDAWADI SIGN NUKTAKHUDAWADI SI" +
	"GN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIGIT ONEKHUDAWADI DIGIT TWOKHUDA" +
	"WADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAWADI DIGIT FIVEKHUDAWADI DIGIT " +
	"SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EIGHTKHUDAWADI DIGIT NINEGRANTHA" +
	" SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN CANDRABINDUGRANTHA SIGN ANUSV" +
	"ARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRANTHA LETTER AAGRANTHA LETTER I" +
	"GRANTHA LETTER IIGRANTHA LETTER UGRANTHA LETTER UUGRANTHA LETTER VOCALIC" +
	" RGRANTHA LETTER VOCALIC LGRANTHA LETTER EEGRANTHA LETTER AIGRANTHA LETT" +
	"ER OOGRANTHA LETTER AUGRANTHA LETTER KAGRANTHA LETTER KHAGRANTHA LETTER " +
	"GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRANTHA LETTER CAGRANTHA LETTER CH" +
	"AGRANTHA LETTER JAGRANTHA LETTER JHAGRANTHA LETTER NYAGRANTHA LETTER TTA" +
	"GRANTHA LETTER TTHAGRANTHA LETTER DDAGRANTHA LETTER DDHAGRANTHA LETTER N" +
	"NAGRANTHA LETTER TAGRANTHA LETTER THAGRANTHA LETTER DAGRANTHA LETTER DHA" +
	"GRANTHA LETTER NAGRANTHA LETTER PAGRANTHA LETTER PHAGRANTHA LETTER BAGRA" +
	"NTHA LETTER BHAGRANTHA LETTER MAGRANTHA LETTER YAGRANTHA LETTER RAGRANTH" +
	"A LETTER LAGRANTHA LETTER LLAGRANTHA LETTER VAGRANTHA LETTER SHAGRANTHA " +
	"LETTER SSAGRANTHA LETTER SAGRANTHA LETTER HACOMBINING BINDU BELOWGRANTHA" +
	" SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VOWEL SIGN AAGRANTHA VOWEL SIGN " +
	"IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN UGRANTHA VOWEL SIGN UUGRANTHA V" +
	"OWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCALIC RRGRANTHA VOWEL SIGN EEGRA" +
	"NTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRANTHA VOWEL SIGN AUGRANTHA SIGN" +
	" VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRANTHA SIGN PLUTAGRANTHA LETTER " +
	"VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE ANUSVARAGRANTHA LETTER VOCALIC" +
	" RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL SIGN VOCALIC LGRANTHA VOWEL SI") + ("" +
	"GN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROCOMBINING GRANTHA DIGIT ONECOMB" +
	"INING GRANTHA DIGIT TWOCOMBINING GRANTHA DIGIT THREECOMBINING GRANTHA DI" +
	"GIT FOURCOMBINING GRANTHA DIGIT FIVECOMBINING GRANTHA DIGIT SIXCOMBINING" +
	" GRANTHA LETTER ACOMBINING GRANTHA LETTER KACOMBINING GRANTHA LETTER NAC" +
	"OMBINING GRANTHA LETTER VICOMBINING GRANTHA LETTER PATULU-TIGALARI LETTE" +
	"R ATULU-TIGALARI LETTER AATULU-TIGALARI LETTER ITULU-TIGALARI LETTER IIT" +
	"ULU-TIGALARI LETTER UTULU-TIGALARI LETTER UUTULU-TIGALARI LETTER VOCALIC" +
	" RTULU-TIGALARI LETTER VOCALIC RRTULU-TIGALARI LETTER VOCALIC LTULU-TIGA" +
	"LARI LETTER VOCALIC LLTULU-TIGALARI LETTER EETULU-TIGALARI LETTER AITULU" +
	"-TIGALARI LETTER OOTULU-TIGALARI LETTER AUTULU-TIGALARI LETTER KATULU-TI" +
	"GALARI LETTER KHATULU-TIGALARI LETTER GATULU-TIGALARI LETTER GHATULU-TIG" +
	"ALARI LETTER NGATULU-TIGALARI LETTER CATULU-TIGALARI LETTER CHATULU-TIGA" +
	"LARI LETTER JATULU-TIGALARI LETTER JHATULU-TIGALARI LETTER NYATULU-TIGAL" +
	"ARI LETTER TTATULU-TIGALARI LETTER TTHATULU-TIGALARI LETTER DDATULU-TIGA" +
	"LARI LETTER DDHATULU-TIGALARI LETTER NNATULU-TIGALARI LETTER TATULU-TIGA" +
	"LARI LETTER THATULU-TIGALARI LETTER DATULU-TIGALARI LETTER DHATULU-TIGAL" +
	"ARI LETTER NATULU-TIGALARI LETTER PATULU-TIGALARI LETTER PHATULU-TIGALAR" +
	"I LETTER BATULU-TIGALARI LETTER BHATULU-TIGALARI LETTER MATULU-TIGALARI " +
	"LETTER YATULU-TIGALARI LETTER RATULU-TIGALARI LETTER LATULU-TIGALARI LET" +
	"TER VATULU-TIGALARI LETTER SHATULU-TIGALARI LETTER SSATULU-TIGALARI LETT" +
	"ER SATULU-TIGALARI LETTER HATULU-TIGALARI LETTER LLATULU-TIGALARI LETTER" +
	" RRATULU-TIGALARI LETTER LLLATULU-TIGALARI SIGN AVAGRAHATULU-TIGALARI VO" +
	"WEL SIGN AATULU-TIGALARI VOWEL SIGN ITULU-TIGALARI VOWEL SIGN IITULU-TIG" +
	"ALARI VOWEL SIGN UTULU-TIGALARI VOWEL SIGN UUTULU-TIGALARI VOWEL SIGN VO" +
	"CALIC RTULU-TIGALARI VOWEL SIGN VOCALIC RRTULU-TIGALARI VOWEL SIGN VOCAL" +
	"IC LTULU-TIGALARI VOWEL SIGN VOCALIC LLTULU-TIGALARI VOWEL SIGN EETULU-T" +
	"IGALARI VOWEL SIGN AITULU-TIGALARI VOWEL SIGN OOTULU-TIGALARI VOWEL SIGN" +
	" AUTULU-TIGALARI AU LENGTH MARKTULU-TIGALARI SIGN CANDRA ANUNASIKATULU-T" +
	"IGALARI SIGN ANUSVARATULU-TIGALARI SIGN VISARGATULU-TIGALARI SIGN VIRAMA" +
	"TULU-TIGALARI SIGN LOOPED VIRAMATULU-TIGALARI CONJOINERTULU-TIGALARI REP" +
	"HATULU-TIGALARI GEMINATION MARKTULU-TIGALARI SIGN PLUTATULU-TIGALARI DAN" +
	"DATULU-TIGALARI DOUBLE DANDATULU-TIGALARI SIGN OM PUSHPIKATULU-TIGALARI " +
	"SIGN SHRII PUSHPIKATULU-TIGALARI VEDIC TONE SVARITATULU-TIGALARI VEDIC T" +
	"ONE ANUDATTANEWA LETTER ANEWA LETTER AANEWA LETTER INEWA LETTER IINEWA L" +
	"ETTER UNEWA LETTER UUNEWA LETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LET" +
	"TER VOCALIC LNEWA LETTER VOCALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTE" +
	"R ONEWA LETTER AUNEWA LETTER KANEWA LETTER KHANEWA LETTER GANEWA LETTER " +
	"GHANEWA LETTER NGANEWA LETTER NGHANEWA LETTER CANEWA LETTER CHANEWA LETT" +
	"ER JANEWA LETTER JHANEWA LETTER NYANEWA LETTER NYHANEWA LETTER TTANEWA L" +
	"ETTER TTHANEWA LETTER DDANEWA LETTER DDHANEWA LETTER NNANEWA LETTER TANE" +
	"WA LETTER THANEWA LETTER DANEWA LETTER DHANEWA LETTER NANEWA LETTER NHAN" +
	"EWA LETTER PANEWA LETTER PHANEWA LETTER BANEWA LETTER BHANEWA LETTER MAN" +
	"EWA LETTER MHANEWA LETTER YANEWA LETTER RANEWA LETTER RHANEWA LETTER LAN" +
	"EWA LETTER LHANEWA LETTER WANEWA LETTER SHANEWA LETTER SSANEWA LETTER SA" +
	"NEWA LETTER HANEWA VOWEL SIGN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA " +
	"VOWEL SIGN UNEWA VOWEL SIGN UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN V" +
	"OCALIC RRNEWA VOWEL SIGN VOCALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL S" +
	"IGN ENEWA VOWEL SIGN AINEWA VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRA" +
	"MANEWA SIGN CANDRABINDUNEWA SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKT" +
	"ANEWA SIGN AVAGRAHANEWA SIGN FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDAN" +
	"EWA DOUBLE DANDANEWA COMMANEWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGI" +
	"T ZERONEWA DIGIT ONENEWA DIGIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DI" +
	"GIT FIVENEWA DIGIT SIXNEWA DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEW" +
	"A DOUBLE COMMANEWA PLACEHOLDER MARKNEWA INSERTION SIGNNEWA SANDHI MARKNE" +
	"WA LETTER VEDIC ANUSVARANEWA SIGN JIHVAMULIYANEWA SIGN UPADHMANIYATIRHUT" +
	"A ANJITIRHUTA LETTER ATIRHUTA LETTER AATIRHUTA LETTER ITIRHUTA LETTER II" +
	"TIRHUTA LETTER UTIRHUTA LETTER UUTIRHUTA LETTER VOCALIC RTIRHUTA LETTER " +
	"VOCALIC RRTIRHUTA LETTER VOCALIC LTIRHUTA LETTER VOCALIC LLTIRHUTA LETTE" +
	"R ETIRHUTA LETTER AITIRHUTA LETTER OTIRHUTA LETTER AUTIRHUTA LETTER KATI" +
	"RHUTA LETTER KHATIRHUTA LETTER GATIRHUTA LETTER GHATIRHUTA LETTER NGATIR" +
	"HUTA LETTER CATIRHUTA LETTER CHATIRHUTA LETTER JATIRHUTA LETTER JHATIRHU" +
	"TA LETTER NYATIRHUTA LETTER TTATIRHUTA LETTER TTHATIRHUTA LETTER DDATIRH" +
	"UTA LETTER DDHATIRHUTA LETTER NNATIRHUTA LETTER TATIRHUTA LETTER THATIRH" +
	"UTA LETTER DATIRHUTA LETTER DHATIRHUTA LETTER NATIRHUTA LETTER PATIRHUTA") + ("" +
	" LETTER PHATIRHUTA LETTER BATIRHUTA LETTER BHATIRHUTA LETTER MATIRHUTA L" +
	"ETTER YATIRHUTA LETTER RATIRHUTA LETTER LATIRHUTA LETTER VATIRHUTA LETTE" +
	"R SHATIRHUTA LETTER SSATIRHUTA LETTER SATIRHUTA LETTER HATIRHUTA VOWEL S" +
	"IGN AATIRHUTA VOWEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA VOWEL SIGN UTIRHU" +
	"TA VOWEL SIGN UUTIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWEL SIGN VOCALIC R" +
	"RTIRHUTA VOWEL SIGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC LLTIRHUTA VOWEL " +
	"SIGN ETIRHUTA VOWEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIRHUTA VOWEL SIGN " +
	"OTIRHUTA VOWEL SIGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA SIGN CANDRABINDU" +
	"TIRHUTA SIGN ANUSVARATIRHUTA SIGN VISARGATIRHUTA SIGN VIRAMATIRHUTA SIGN" +
	" NUKTATIRHUTA SIGN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIATION SIGNTIRHUTA" +
	" OMTIRHUTA DIGIT ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOTIRHUTA DIGIT THR" +
	"EETIRHUTA DIGIT FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXTIRHUTA DIGIT SEV" +
	"ENTIRHUTA DIGIT EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER ASIDDHAM LETTER AA" +
	"SIDDHAM LETTER ISIDDHAM LETTER IISIDDHAM LETTER USIDDHAM LETTER UUSIDDHA" +
	"M LETTER VOCALIC RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTER VOCALIC LSIDDH" +
	"AM LETTER VOCALIC LLSIDDHAM LETTER ESIDDHAM LETTER AISIDDHAM LETTER OSID" +
	"DHAM LETTER AUSIDDHAM LETTER KASIDDHAM LETTER KHASIDDHAM LETTER GASIDDHA" +
	"M LETTER GHASIDDHAM LETTER NGASIDDHAM LETTER CASIDDHAM LETTER CHASIDDHAM" +
	" LETTER JASIDDHAM LETTER JHASIDDHAM LETTER NYASIDDHAM LETTER TTASIDDHAM " +
	"LETTER TTHASIDDHAM LETTER DDASIDDHAM LETTER DDHASIDDHAM LETTER NNASIDDHA" +
	"M LETTER TASIDDHAM LETTER THASIDDHAM LETTER DASIDDHAM LETTER DHASIDDHAM " +
	"LETTER NASIDDHAM LETTER PASIDDHAM LETTER PHASIDDHAM LETTER BASIDDHAM LET" +
	"TER BHASIDDHAM LETTER MASIDDHAM LETTER YASIDDHAM LETTER RASIDDHAM LETTER" +
	" LASIDDHAM LETTER VASIDDHAM LETTER SHASIDDHAM LETTER SSASIDDHAM LETTER S" +
	"ASIDDHAM LETTER HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIGN ISIDDHAM VOWEL" +
	" SIGN IISIDDHAM VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM VOWEL SIGN VOCA" +
	"LIC RSIDDHAM VOWEL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESIDDHAM VOWEL SIGN" +
	" AISIDDHAM VOWEL SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN CANDRABINDUSIDD" +
	"HAM SIGN ANUSVARASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMASIDDHAM SIGN NUK" +
	"TASIDDHAM SIGN SIDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDASIDDHAM SEPARATOR" +
	" DOTSIDDHAM SEPARATOR BARSIDDHAM REPETITION MARK-1SIDDHAM REPETITION MAR" +
	"K-2SIDDHAM REPETITION MARK-3SIDDHAM END OF TEXT MARKSIDDHAM SECTION MARK" +
	" WITH TRIDENT AND U-SHAPED ORNAMENTSSIDDHAM SECTION MARK WITH TRIDENT AN" +
	"D DOTTED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTSSID" +
	"DHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTSSIDDHAM SECTION M" +
	"ARK WITH RAYS AND DOTTED TRIPLE CRESCENTSSIDDHAM SECTION MARK DOUBLE RIN" +
	"GSIDDHAM SECTION MARK DOUBLE RING WITH RAYSSIDDHAM SECTION MARK WITH DOU" +
	"BLE CRESCENTSSIDDHAM SECTION MARK WITH TRIPLE CRESCENTSSIDDHAM SECTION M" +
	"ARK WITH QUADRUPLE CRESCENTSSIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTS" +
	"SIDDHAM SECTION MARK WITH CIRCLES AND RAYSSIDDHAM SECTION MARK WITH CIRC" +
	"LES AND TWO ENCLOSURESSIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSU" +
	"RESSIDDHAM LETTER THREE-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTE" +
	"RNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE IISIDDHAM LETTER ALTERNATE US" +
	"IDDHAM VOWEL SIGN ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE UUMODI LETTER " +
	"AMODI LETTER AAMODI LETTER IMODI LETTER IIMODI LETTER UMODI LETTER UUMOD" +
	"I LETTER VOCALIC RMODI LETTER VOCALIC RRMODI LETTER VOCALIC LMODI LETTER" +
	" VOCALIC LLMODI LETTER EMODI LETTER AIMODI LETTER OMODI LETTER AUMODI LE" +
	"TTER KAMODI LETTER KHAMODI LETTER GAMODI LETTER GHAMODI LETTER NGAMODI L" +
	"ETTER CAMODI LETTER CHAMODI LETTER JAMODI LETTER JHAMODI LETTER NYAMODI " +
	"LETTER TTAMODI LETTER TTHAMODI LETTER DDAMODI LETTER DDHAMODI LETTER NNA" +
	"MODI LETTER TAMODI LETTER THAMODI LETTER DAMODI LETTER DHAMODI LETTER NA" +
	"MODI LETTER PAMODI LETTER PHAMODI LETTER BAMODI LETTER BHAMODI LETTER MA" +
	"MODI LETTER YAMODI LETTER RAMODI LETTER LAMODI LETTER VAMODI LETTER SHAM" +
	"ODI LETTER SSAMODI LETTER SAMODI LETTER HAMODI LETTER LLAMODI VOWEL SIGN" +
	" AAMODI VOWEL SIGN IMODI VOWEL SIGN IIMODI VOWEL SIGN UMODI VOWEL SIGN U" +
	"UMODI VOWEL SIGN VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI VOWEL SIGN VOCA" +
	"LIC LMODI VOWEL SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOWEL SIGN AIMODI V" +
	"OWEL SIGN OMODI VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN VISARGAMODI SIG" +
	"N VIRAMAMODI SIGN ARDHACANDRAMODI DANDAMODI DOUBLE DANDAMODI ABBREVIATIO" +
	"N SIGNMODI SIGN HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DIGIT TWOMODI DIGI" +
	"T THREEMODI DIGIT FOURMODI DIGIT FIVEMODI DIGIT SIXMODI DIGIT SEVENMODI " +
	"DIGIT EIGHTMODI DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTMONGOLIAN ROTATED" +
	" BIRGAMONGOLIAN DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIPLE BIRGA WITH OR" +
	"NAMENTMONGOLIAN BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTATED BIRGA WITH O") + ("" +
	"RNAMENTMONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN INVERTED BI" +
	"RGAMONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN SWIRL BIRGAMON" +
	"GOLIAN SWIRL BIRGA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAME" +
	"NTMONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI LETTER ATAKRI L" +
	"ETTER AATAKRI LETTER ITAKRI LETTER IITAKRI LETTER UTAKRI LETTER UUTAKRI " +
	"LETTER ETAKRI LETTER AITAKRI LETTER OTAKRI LETTER AUTAKRI LETTER KATAKRI" +
	" LETTER KHATAKRI LETTER GATAKRI LETTER GHATAKRI LETTER NGATAKRI LETTER C" +
	"ATAKRI LETTER CHATAKRI LETTER JATAKRI LETTER JHATAKRI LETTER NYATAKRI LE" +
	"TTER TTATAKRI LETTER TTHATAKRI LETTER DDATAKRI LETTER DDHATAKRI LETTER N" +
	"NATAKRI LETTER TATAKRI LETTER THATAKRI LETTER DATAKRI LETTER DHATAKRI LE" +
	"TTER NATAKRI LETTER PATAKRI LETTER PHATAKRI LETTER BATAKRI LETTER BHATAK" +
	"RI LETTER MATAKRI LETTER YATAKRI LETTER RATAKRI LETTER LATAKRI LETTER VA" +
	"TAKRI LETTER SHATAKRI LETTER SATAKRI LETTER HATAKRI LETTER RRATAKRI SIGN" +
	" ANUSVARATAKRI SIGN VISARGATAKRI VOWEL SIGN AATAKRI VOWEL SIGN ITAKRI VO" +
	"WEL SIGN IITAKRI VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VOWEL SIGN ETAKRI " +
	"VOWEL SIGN AITAKRI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI SIGN VIRAMATAKRI" +
	" SIGN NUKTATAKRI LETTER ARCHAIC KHATAKRI ABBREVIATION SIGNTAKRI DIGIT ZE" +
	"ROTAKRI DIGIT ONETAKRI DIGIT TWOTAKRI DIGIT THREETAKRI DIGIT FOURTAKRI D" +
	"IGIT FIVETAKRI DIGIT SIXTAKRI DIGIT SEVENTAKRI DIGIT EIGHTTAKRI DIGIT NI" +
	"NEMYANMAR PAO DIGIT ZEROMYANMAR PAO DIGIT ONEMYANMAR PAO DIGIT TWOMYANMA" +
	"R PAO DIGIT THREEMYANMAR PAO DIGIT FOURMYANMAR PAO DIGIT FIVEMYANMAR PAO" +
	" DIGIT SIXMYANMAR PAO DIGIT SEVENMYANMAR PAO DIGIT EIGHTMYANMAR PAO DIGI" +
	"T NINEMYANMAR EASTERN PWO KAREN DIGIT ZEROMYANMAR EASTERN PWO KAREN DIGI" +
	"T ONEMYANMAR EASTERN PWO KAREN DIGIT TWOMYANMAR EASTERN PWO KAREN DIGIT " +
	"THREEMYANMAR EASTERN PWO KAREN DIGIT FOURMYANMAR EASTERN PWO KAREN DIGIT" +
	" FIVEMYANMAR EASTERN PWO KAREN DIGIT SIXMYANMAR EASTERN PWO KAREN DIGIT " +
	"SEVENMYANMAR EASTERN PWO KAREN DIGIT EIGHTMYANMAR EASTERN PWO KAREN DIGI" +
	"T NINEAHOM LETTER KAAHOM LETTER KHAAHOM LETTER NGAAHOM LETTER NAAHOM LET" +
	"TER TAAHOM LETTER ALTERNATE TAAHOM LETTER PAAHOM LETTER PHAAHOM LETTER B" +
	"AAHOM LETTER MAAHOM LETTER JAAHOM LETTER CHAAHOM LETTER THAAHOM LETTER R" +
	"AAHOM LETTER LAAHOM LETTER SAAHOM LETTER NYAAHOM LETTER HAAHOM LETTER AA" +
	"HOM LETTER DAAHOM LETTER DHAAHOM LETTER GAAHOM LETTER ALTERNATE GAAHOM L" +
	"ETTER GHAAHOM LETTER BHAAHOM LETTER JHAAHOM LETTER ALTERNATE BAAHOM CONS" +
	"ONANT SIGN MEDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSONANT SIGN MED" +
	"IAL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWEL SIGN IAHOM " +
	"VOWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL SIGN EAHOM VO" +
	"WEL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SIGN AMAHOM SIG" +
	"N KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIGIT THREEAHOM " +
	"DIGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM DIGIT EIGHTA" +
	"HOM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SMALL SECTIONAH" +
	"OM SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL VIAHOM LETTER CAAHOM LETTER TT" +
	"AAHOM LETTER TTHAAHOM LETTER DDAAHOM LETTER DDHAAHOM LETTER NNAAHOM LETT" +
	"ER LLADOGRA LETTER ADOGRA LETTER AADOGRA LETTER IDOGRA LETTER IIDOGRA LE" +
	"TTER UDOGRA LETTER UUDOGRA LETTER EDOGRA LETTER AIDOGRA LETTER ODOGRA LE" +
	"TTER AUDOGRA LETTER KADOGRA LETTER KHADOGRA LETTER GADOGRA LETTER GHADOG" +
	"RA LETTER NGADOGRA LETTER CADOGRA LETTER CHADOGRA LETTER JADOGRA LETTER " +
	"JHADOGRA LETTER NYADOGRA LETTER TTADOGRA LETTER TTHADOGRA LETTER DDADOGR" +
	"A LETTER DDHADOGRA LETTER NNADOGRA LETTER TADOGRA LETTER THADOGRA LETTER" +
	" DADOGRA LETTER DHADOGRA LETTER NADOGRA LETTER PADOGRA LETTER PHADOGRA L" +
	"ETTER BADOGRA LETTER BHADOGRA LETTER MADOGRA LETTER YADOGRA LETTER RADOG" +
	"RA LETTER LADOGRA LETTER VADOGRA LETTER SHADOGRA LETTER SSADOGRA LETTER " +
	"SADOGRA LETTER HADOGRA LETTER RRADOGRA VOWEL SIGN AADOGRA VOWEL SIGN IDO" +
	"GRA VOWEL SIGN IIDOGRA VOWEL SIGN UDOGRA VOWEL SIGN UUDOGRA VOWEL SIGN V" +
	"OCALIC RDOGRA VOWEL SIGN VOCALIC RRDOGRA VOWEL SIGN EDOGRA VOWEL SIGN AI" +
	"DOGRA VOWEL SIGN ODOGRA VOWEL SIGN AUDOGRA SIGN ANUSVARADOGRA SIGN VISAR" +
	"GADOGRA SIGN VIRAMADOGRA SIGN NUKTADOGRA ABBREVIATION SIGNWARANG CITI CA" +
	"PITAL LETTER NGAAWARANG CITI CAPITAL LETTER AWARANG CITI CAPITAL LETTER " +
	"WIWARANG CITI CAPITAL LETTER YUWARANG CITI CAPITAL LETTER YAWARANG CITI " +
	"CAPITAL LETTER YOWARANG CITI CAPITAL LETTER IIWARANG CITI CAPITAL LETTER" +
	" UUWARANG CITI CAPITAL LETTER EWARANG CITI CAPITAL LETTER OWARANG CITI C" +
	"APITAL LETTER ANGWARANG CITI CAPITAL LETTER GAWARANG CITI CAPITAL LETTER" +
	" KOWARANG CITI CAPITAL LETTER ENYWARANG CITI CAPITAL LETTER YUJWARANG CI" +
	"TI CAPITAL LETTER UCWARANG CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LE" +
	"TTER ODDWARANG CITI CAPITAL LETTER TTEWARANG CITI CAPITAL LETTER NUNGWAR") + ("" +
	"ANG CITI CAPITAL LETTER DAWARANG CITI CAPITAL LETTER ATWARANG CITI CAPIT" +
	"AL LETTER AMWARANG CITI CAPITAL LETTER BUWARANG CITI CAPITAL LETTER PUWA" +
	"RANG CITI CAPITAL LETTER HIYOWARANG CITI CAPITAL LETTER HOLOWARANG CITI " +
	"CAPITAL LETTER HORRWARANG CITI CAPITAL LETTER HARWARANG CITI CAPITAL LET" +
	"TER SSUUWARANG CITI CAPITAL LETTER SIIWARANG CITI CAPITAL LETTER VIYOWAR" +
	"ANG CITI SMALL LETTER NGAAWARANG CITI SMALL LETTER AWARANG CITI SMALL LE" +
	"TTER WIWARANG CITI SMALL LETTER YUWARANG CITI SMALL LETTER YAWARANG CITI" +
	" SMALL LETTER YOWARANG CITI SMALL LETTER IIWARANG CITI SMALL LETTER UUWA" +
	"RANG CITI SMALL LETTER EWARANG CITI SMALL LETTER OWARANG CITI SMALL LETT" +
	"ER ANGWARANG CITI SMALL LETTER GAWARANG CITI SMALL LETTER KOWARANG CITI " +
	"SMALL LETTER ENYWARANG CITI SMALL LETTER YUJWARANG CITI SMALL LETTER UCW" +
	"ARANG CITI SMALL LETTER ENNWARANG CITI SMALL LETTER ODDWARANG CITI SMALL" +
	" LETTER TTEWARANG CITI SMALL LETTER NUNGWARANG CITI SMALL LETTER DAWARAN" +
	"G CITI SMALL LETTER ATWARANG CITI SMALL LETTER AMWARANG CITI SMALL LETTE" +
	"R BUWARANG CITI SMALL LETTER PUWARANG CITI SMALL LETTER HIYOWARANG CITI " +
	"SMALL LETTER HOLOWARANG CITI SMALL LETTER HORRWARANG CITI SMALL LETTER H" +
	"ARWARANG CITI SMALL LETTER SSUUWARANG CITI SMALL LETTER SIIWARANG CITI S" +
	"MALL LETTER VIYOWARANG CITI DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI D" +
	"IGIT TWOWARANG CITI DIGIT THREEWARANG CITI DIGIT FOURWARANG CITI DIGIT F" +
	"IVEWARANG CITI DIGIT SIXWARANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWA" +
	"RANG CITI DIGIT NINEWARANG CITI NUMBER TENWARANG CITI NUMBER TWENTYWARAN" +
	"G CITI NUMBER THIRTYWARANG CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARA" +
	"NG CITI NUMBER SIXTYWARANG CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYW" +
	"ARANG CITI NUMBER NINETYWARANG CITI OMDIVES AKURU LETTER ADIVES AKURU LE" +
	"TTER AADIVES AKURU LETTER IDIVES AKURU LETTER IIDIVES AKURU LETTER UDIVE" +
	"S AKURU LETTER UUDIVES AKURU LETTER EDIVES AKURU LETTER ODIVES AKURU LET" +
	"TER KADIVES AKURU LETTER KHADIVES AKURU LETTER GADIVES AKURU LETTER GHAD" +
	"IVES AKURU LETTER NGADIVES AKURU LETTER CADIVES AKURU LETTER CHADIVES AK" +
	"URU LETTER JADIVES AKURU LETTER NYADIVES AKURU LETTER TTADIVES AKURU LET" +
	"TER DDADIVES AKURU LETTER DDHADIVES AKURU LETTER NNADIVES AKURU LETTER T" +
	"ADIVES AKURU LETTER THADIVES AKURU LETTER DADIVES AKURU LETTER DHADIVES " +
	"AKURU LETTER NADIVES AKURU LETTER PADIVES AKURU LETTER PHADIVES AKURU LE" +
	"TTER BADIVES AKURU LETTER BHADIVES AKURU LETTER MADIVES AKURU LETTER YAD" +
	"IVES AKURU LETTER YYADIVES AKURU LETTER RADIVES AKURU LETTER LADIVES AKU" +
	"RU LETTER VADIVES AKURU LETTER SHADIVES AKURU LETTER SSADIVES AKURU LETT" +
	"ER SADIVES AKURU LETTER HADIVES AKURU LETTER LLADIVES AKURU LETTER ZADIV" +
	"ES AKURU VOWEL SIGN AADIVES AKURU VOWEL SIGN IDIVES AKURU VOWEL SIGN IID" +
	"IVES AKURU VOWEL SIGN UDIVES AKURU VOWEL SIGN UUDIVES AKURU VOWEL SIGN E" +
	"DIVES AKURU VOWEL SIGN AIDIVES AKURU VOWEL SIGN ODIVES AKURU SIGN ANUSVA" +
	"RADIVES AKURU SIGN CANDRABINDUDIVES AKURU SIGN HALANTADIVES AKURU VIRAMA" +
	"DIVES AKURU PREFIXED NASAL SIGNDIVES AKURU MEDIAL YADIVES AKURU INITIAL " +
	"RADIVES AKURU MEDIAL RADIVES AKURU SIGN NUKTADIVES AKURU DOUBLE DANDADIV" +
	"ES AKURU GAP FILLERDIVES AKURU END OF TEXT MARKDIVES AKURU DIGIT ZERODIV" +
	"ES AKURU DIGIT ONEDIVES AKURU DIGIT TWODIVES AKURU DIGIT THREEDIVES AKUR" +
	"U DIGIT FOURDIVES AKURU DIGIT FIVEDIVES AKURU DIGIT SIXDIVES AKURU DIGIT" +
	" SEVENDIVES AKURU DIGIT EIGHTDIVES AKURU DIGIT NINENANDINAGARI LETTER AN" +
	"ANDINAGARI LETTER AANANDINAGARI LETTER INANDINAGARI LETTER IINANDINAGARI" +
	" LETTER UNANDINAGARI LETTER UUNANDINAGARI LETTER VOCALIC RNANDINAGARI LE" +
	"TTER VOCALIC RRNANDINAGARI LETTER ENANDINAGARI LETTER AINANDINAGARI LETT" +
	"ER ONANDINAGARI LETTER AUNANDINAGARI LETTER KANANDINAGARI LETTER KHANAND" +
	"INAGARI LETTER GANANDINAGARI LETTER GHANANDINAGARI LETTER NGANANDINAGARI" +
	" LETTER CANANDINAGARI LETTER CHANANDINAGARI LETTER JANANDINAGARI LETTER " +
	"JHANANDINAGARI LETTER NYANANDINAGARI LETTER TTANANDINAGARI LETTER TTHANA" +
	"NDINAGARI LETTER DDANANDINAGARI LETTER DDHANANDINAGARI LETTER NNANANDINA" +
	"GARI LETTER TANANDINAGARI LETTER THANANDINAGARI LETTER DANANDINAGARI LET" +
	"TER DHANANDINAGARI LETTER NANANDINAGARI LETTER PANANDINAGARI LETTER PHAN" +
	"ANDINAGARI LETTER BANANDINAGARI LETTER BHANANDINAGARI LETTER MANANDINAGA" +
	"RI LETTER YANANDINAGARI LETTER RANANDINAGARI LETTER LANANDINAGARI LETTER" +
	" VANANDINAGARI LETTER SHANANDINAGARI LETTER SSANANDINAGARI LETTER SANAND" +
	"INAGARI LETTER HANANDINAGARI LETTER LLANANDINAGARI LETTER RRANANDINAGARI" +
	" VOWEL SIGN AANANDINAGARI VOWEL SIGN INANDINAGARI VOWEL SIGN IINANDINAGA" +
	"RI VOWEL SIGN UNANDINAGARI VOWEL SIGN UUNANDINAGARI VOWEL SIGN VOCALIC R" +
	"NANDINAGARI VOWEL SIGN VOCALIC RRNANDINAGARI VOWEL SIGN ENANDINAGARI VOW" +
	"EL SIGN AINANDINAGARI VOWEL SIGN ONANDINAGARI VOWEL SIGN AUNANDINAGARI S") + ("" +
	"IGN ANUSVARANANDINAGARI SIGN VISARGANANDINAGARI SIGN VIRAMANANDINAGARI S" +
	"IGN AVAGRAHANANDINAGARI SIGN SIDDHAMNANDINAGARI HEADSTROKENANDINAGARI VO" +
	"WEL SIGN PRISHTHAMATRA EZANABAZAR SQUARE LETTER AZANABAZAR SQUARE VOWEL " +
	"SIGN IZANABAZAR SQUARE VOWEL SIGN UEZANABAZAR SQUARE VOWEL SIGN UZANABAZ" +
	"AR SQUARE VOWEL SIGN EZANABAZAR SQUARE VOWEL SIGN OEZANABAZAR SQUARE VOW" +
	"EL SIGN OZANABAZAR SQUARE VOWEL SIGN AIZANABAZAR SQUARE VOWEL SIGN AUZAN" +
	"ABAZAR SQUARE VOWEL SIGN REVERSED IZANABAZAR SQUARE VOWEL LENGTH MARKZAN" +
	"ABAZAR SQUARE LETTER KAZANABAZAR SQUARE LETTER KHAZANABAZAR SQUARE LETTE" +
	"R GAZANABAZAR SQUARE LETTER GHAZANABAZAR SQUARE LETTER NGAZANABAZAR SQUA" +
	"RE LETTER CAZANABAZAR SQUARE LETTER CHAZANABAZAR SQUARE LETTER JAZANABAZ" +
	"AR SQUARE LETTER NYAZANABAZAR SQUARE LETTER TTAZANABAZAR SQUARE LETTER T" +
	"THAZANABAZAR SQUARE LETTER DDAZANABAZAR SQUARE LETTER DDHAZANABAZAR SQUA" +
	"RE LETTER NNAZANABAZAR SQUARE LETTER TAZANABAZAR SQUARE LETTER THAZANABA" +
	"ZAR SQUARE LETTER DAZANABAZAR SQUARE LETTER DHAZANABAZAR SQUARE LETTER N" +
	"AZANABAZAR SQUARE LETTER PAZANABAZAR SQUARE LETTER PHAZANABAZAR SQUARE L" +
	"ETTER BAZANABAZAR SQUARE LETTER BHAZANABAZAR SQUARE LETTER MAZANABAZAR S" +
	"QUARE LETTER TSAZANABAZAR SQUARE LETTER TSHAZANABAZAR SQUARE LETTER DZAZ" +
	"ANABAZAR SQUARE LETTER DZHAZANABAZAR SQUARE LETTER ZHAZANABAZAR SQUARE L" +
	"ETTER ZAZANABAZAR SQUARE LETTER -AZANABAZAR SQUARE LETTER YAZANABAZAR SQ" +
	"UARE LETTER RAZANABAZAR SQUARE LETTER LAZANABAZAR SQUARE LETTER VAZANABA" +
	"ZAR SQUARE LETTER SHAZANABAZAR SQUARE LETTER SSAZANABAZAR SQUARE LETTER " +
	"SAZANABAZAR SQUARE LETTER HAZANABAZAR SQUARE LETTER KSSAZANABAZAR SQUARE" +
	" FINAL CONSONANT MARKZANABAZAR SQUARE SIGN VIRAMAZANABAZAR SQUARE SIGN C" +
	"ANDRABINDUZANABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENTZANABAZAR SQUAR" +
	"E SIGN CANDRA WITH ORNAMENTZANABAZAR SQUARE SIGN ANUSVARAZANABAZAR SQUAR" +
	"E SIGN VISARGAZANABAZAR SQUARE CLUSTER-INITIAL LETTER RAZANABAZAR SQUARE" +
	" CLUSTER-FINAL LETTER YAZANABAZAR SQUARE CLUSTER-FINAL LETTER RAZANABAZA" +
	"R SQUARE CLUSTER-FINAL LETTER LAZANABAZAR SQUARE CLUSTER-FINAL LETTER VA" +
	"ZANABAZAR SQUARE INITIAL HEAD MARKZANABAZAR SQUARE CLOSING HEAD MARKZANA" +
	"BAZAR SQUARE MARK TSHEGZANABAZAR SQUARE MARK SHADZANABAZAR SQUARE MARK D" +
	"OUBLE SHADZANABAZAR SQUARE MARK LONG TSHEGZANABAZAR SQUARE INITIAL DOUBL" +
	"E-LINED HEAD MARKZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARKZANABAZA" +
	"R SQUARE SUBJOINERSOYOMBO LETTER ASOYOMBO VOWEL SIGN ISOYOMBO VOWEL SIGN" +
	" UESOYOMBO VOWEL SIGN USOYOMBO VOWEL SIGN ESOYOMBO VOWEL SIGN OSOYOMBO V" +
	"OWEL SIGN OESOYOMBO VOWEL SIGN AISOYOMBO VOWEL SIGN AUSOYOMBO VOWEL SIGN" +
	" VOCALIC RSOYOMBO VOWEL SIGN VOCALIC LSOYOMBO VOWEL LENGTH MARKSOYOMBO L" +
	"ETTER KASOYOMBO LETTER KHASOYOMBO LETTER GASOYOMBO LETTER GHASOYOMBO LET" +
	"TER NGASOYOMBO LETTER CASOYOMBO LETTER CHASOYOMBO LETTER JASOYOMBO LETTE" +
	"R JHASOYOMBO LETTER NYASOYOMBO LETTER TTASOYOMBO LETTER TTHASOYOMBO LETT" +
	"ER DDASOYOMBO LETTER DDHASOYOMBO LETTER NNASOYOMBO LETTER TASOYOMBO LETT" +
	"ER THASOYOMBO LETTER DASOYOMBO LETTER DHASOYOMBO LETTER NASOYOMBO LETTER" +
	" PASOYOMBO LETTER PHASOYOMBO LETTER BASOYOMBO LETTER BHASOYOMBO LETTER M" +
	"ASOYOMBO LETTER TSASOYOMBO LETTER TSHASOYOMBO LETTER DZASOYOMBO LETTER Z" +
	"HASOYOMBO LETTER ZASOYOMBO LETTER -ASOYOMBO LETTER YASOYOMBO LETTER RASO" +
	"YOMBO LETTER LASOYOMBO LETTER VASOYOMBO LETTER SHASOYOMBO LETTER SSASOYO" +
	"MBO LETTER SASOYOMBO LETTER HASOYOMBO LETTER KSSASOYOMBO SIGN JIHVAMULIY" +
	"ASOYOMBO SIGN UPADHMANIYASOYOMBO CLUSTER-INITIAL LETTER RASOYOMBO CLUSTE" +
	"R-INITIAL LETTER LASOYOMBO CLUSTER-INITIAL LETTER SHASOYOMBO CLUSTER-INI" +
	"TIAL LETTER SASOYOMBO FINAL CONSONANT SIGN GSOYOMBO FINAL CONSONANT SIGN" +
	" KSOYOMBO FINAL CONSONANT SIGN NGSOYOMBO FINAL CONSONANT SIGN DSOYOMBO F" +
	"INAL CONSONANT SIGN NSOYOMBO FINAL CONSONANT SIGN BSOYOMBO FINAL CONSONA" +
	"NT SIGN MSOYOMBO FINAL CONSONANT SIGN RSOYOMBO FINAL CONSONANT SIGN LSOY" +
	"OMBO FINAL CONSONANT SIGN SHSOYOMBO FINAL CONSONANT SIGN SSOYOMBO FINAL " +
	"CONSONANT SIGN -ASOYOMBO SIGN ANUSVARASOYOMBO SIGN VISARGASOYOMBO GEMINA" +
	"TION MARKSOYOMBO SUBJOINERSOYOMBO MARK TSHEGSOYOMBO MARK SHADSOYOMBO MAR" +
	"K DOUBLE SHADSOYOMBO MARK PLUTASOYOMBO HEAD MARK WITH MOON AND SUN AND T" +
	"RIPLE FLAMESOYOMBO HEAD MARK WITH MOON AND SUN AND FLAMESOYOMBO HEAD MAR" +
	"K WITH MOON AND SUNSOYOMBO TERMINAL MARK-1SOYOMBO TERMINAL MARK-2CANADIA" +
	"N SYLLABICS NATTILIK HICANADIAN SYLLABICS NATTILIK HIICANADIAN SYLLABICS" +
	" NATTILIK HOCANADIAN SYLLABICS NATTILIK HOOCANADIAN SYLLABICS NATTILIK H" +
	"ACANADIAN SYLLABICS NATTILIK HAACANADIAN SYLLABICS NATTILIK SHRICANADIAN" +
	" SYLLABICS NATTILIK SHRIICANADIAN SYLLABICS NATTILIK SHROCANADIAN SYLLAB" +
	"ICS NATTILIK SHROOCANADIAN SYLLABICS NATTILIK SHRACANADIAN SYLLABICS NAT" +
	"TILIK SHRAACANADIAN SYLLABICS SPECANADIAN SYLLABICS SPICANADIAN SYLLABIC") + ("" +
	"S SPOCANADIAN SYLLABICS SPAPAU CIN HAU LETTER PAPAU CIN HAU LETTER KAPAU" +
	" CIN HAU LETTER LAPAU CIN HAU LETTER MAPAU CIN HAU LETTER DAPAU CIN HAU " +
	"LETTER ZAPAU CIN HAU LETTER VAPAU CIN HAU LETTER NGAPAU CIN HAU LETTER H" +
	"APAU CIN HAU LETTER GAPAU CIN HAU LETTER KHAPAU CIN HAU LETTER SAPAU CIN" +
	" HAU LETTER BAPAU CIN HAU LETTER CAPAU CIN HAU LETTER TAPAU CIN HAU LETT" +
	"ER THAPAU CIN HAU LETTER NAPAU CIN HAU LETTER PHAPAU CIN HAU LETTER RAPA" +
	"U CIN HAU LETTER FAPAU CIN HAU LETTER CHAPAU CIN HAU LETTER APAU CIN HAU" +
	" LETTER EPAU CIN HAU LETTER IPAU CIN HAU LETTER OPAU CIN HAU LETTER UPAU" +
	" CIN HAU LETTER UAPAU CIN HAU LETTER IAPAU CIN HAU LETTER FINAL PPAU CIN" +
	" HAU LETTER FINAL KPAU CIN HAU LETTER FINAL TPAU CIN HAU LETTER FINAL MP" +
	"AU CIN HAU LETTER FINAL NPAU CIN HAU LETTER FINAL LPAU CIN HAU LETTER FI" +
	"NAL WPAU CIN HAU LETTER FINAL NGPAU CIN HAU LETTER FINAL YPAU CIN HAU RI" +
	"SING TONE LONGPAU CIN HAU RISING TONEPAU CIN HAU SANDHI GLOTTAL STOPPAU " +
	"CIN HAU RISING TONE LONG FINALPAU CIN HAU RISING TONE FINALPAU CIN HAU S" +
	"ANDHI GLOTTAL STOP FINALPAU CIN HAU SANDHI TONE LONGPAU CIN HAU SANDHI T" +
	"ONEPAU CIN HAU SANDHI TONE LONG FINALPAU CIN HAU SANDHI TONE FINALPAU CI" +
	"N HAU MID-LEVEL TONEPAU CIN HAU GLOTTAL STOP VARIANTPAU CIN HAU MID-LEVE" +
	"L TONE LONG FINALPAU CIN HAU MID-LEVEL TONE FINALPAU CIN HAU LOW-FALLING" +
	" TONE LONGPAU CIN HAU LOW-FALLING TONEPAU CIN HAU GLOTTAL STOPPAU CIN HA" +
	"U LOW-FALLING TONE LONG FINALPAU CIN HAU LOW-FALLING TONE FINALPAU CIN H" +
	"AU GLOTTAL STOP FINALDEVANAGARI HEAD MARKDEVANAGARI HEAD MARK WITH HEADS" +
	"TROKEDEVANAGARI SIGN BHALEDEVANAGARI SIGN BHALE WITH HOOKDEVANAGARI SIGN" +
	" EXTENDED BHALEDEVANAGARI SIGN EXTENDED BHALE WITH HOOKDEVANAGARI SIGN W" +
	"ESTERN FIVE-LIKE BHALEDEVANAGARI SIGN WESTERN NINE-LIKE BHALEDEVANAGARI " +
	"SIGN REVERSED NINE-LIKE BHALEDEVANAGARI SIGN MINDUSHARADA VOWEL SIGN OES" +
	"HARADA VOWEL SIGN OOESHARADA VOWEL SIGN UESHARADA VOWEL SIGN UUESHARADA " +
	"VOWEL SIGN SHORT ESHARADA VOWEL SIGN SHORT OSHARADA VOWEL SIGN CANDRA ES" +
	"HARADA VOWEL SIGN CANDRA OSUNUWAR LETTER DEVISUNUWAR LETTER TASLASUNUWAR" +
	" LETTER EKOSUNUWAR LETTER IMARSUNUWAR LETTER REUSUNUWAR LETTER UTTHISUNU" +
	"WAR LETTER KIKSUNUWAR LETTER MASUNUWAR LETTER APPHOSUNUWAR LETTER PIPSUN" +
	"UWAR LETTER GILSUNUWAR LETTER HAMSOSUNUWAR LETTER CARMISUNUWAR LETTER NA" +
	"HSUNUWAR LETTER BURSUNUWAR LETTER JYAHSUNUWAR LETTER LOACHASUNUWAR LETTE" +
	"R OTTHISUNUWAR LETTER SHYELESUNUWAR LETTER VARCASUNUWAR LETTER YATSUNUWA" +
	"R LETTER AVASUNUWAR LETTER AALSUNUWAR LETTER DONGASUNUWAR LETTER THARISU" +
	"NUWAR LETTER PHARSUNUWAR LETTER NGARSUNUWAR LETTER KHASUNUWAR LETTER SHY" +
	"ERSUNUWAR LETTER CHELAPSUNUWAR LETTER TENTUSUNUWAR LETTER THELESUNUWAR L" +
	"ETTER KLOKOSUNUWAR SIGN PVOSUNUWAR DIGIT ZEROSUNUWAR DIGIT ONESUNUWAR DI" +
	"GIT TWOSUNUWAR DIGIT THREESUNUWAR DIGIT FOURSUNUWAR DIGIT FIVESUNUWAR DI" +
	"GIT SIXSUNUWAR DIGIT SEVENSUNUWAR DIGIT EIGHTSUNUWAR DIGIT NINEBHAIKSUKI" +
	" LETTER ABHAIKSUKI LETTER AABHAIKSUKI LETTER IBHAIKSUKI LETTER IIBHAIKSU" +
	"KI LETTER UBHAIKSUKI LETTER UUBHAIKSUKI LETTER VOCALIC RBHAIKSUKI LETTER" +
	" VOCALIC RRBHAIKSUKI LETTER VOCALIC LBHAIKSUKI LETTER EBHAIKSUKI LETTER " +
	"AIBHAIKSUKI LETTER OBHAIKSUKI LETTER AUBHAIKSUKI LETTER KABHAIKSUKI LETT" +
	"ER KHABHAIKSUKI LETTER GABHAIKSUKI LETTER GHABHAIKSUKI LETTER NGABHAIKSU" +
	"KI LETTER CABHAIKSUKI LETTER CHABHAIKSUKI LETTER JABHAIKSUKI LETTER JHAB" +
	"HAIKSUKI LETTER NYABHAIKSUKI LETTER TTABHAIKSUKI LETTER TTHABHAIKSUKI LE" +
	"TTER DDABHAIKSUKI LETTER DDHABHAIKSUKI LETTER NNABHAIKSUKI LETTER TABHAI" +
	"KSUKI LETTER THABHAIKSUKI LETTER DABHAIKSUKI LETTER DHABHAIKSUKI LETTER " +
	"NABHAIKSUKI LETTER PABHAIKSUKI LETTER PHABHAIKSUKI LETTER BABHAIKSUKI LE" +
	"TTER BHABHAIKSUKI LETTER MABHAIKSUKI LETTER YABHAIKSUKI LETTER RABHAIKSU" +
	"KI LETTER LABHAIKSUKI LETTER VABHAIKSUKI LETTER SHABHAIKSUKI LETTER SSAB" +
	"HAIKSUKI LETTER SABHAIKSUKI LETTER HABHAIKSUKI VOWEL SIGN AABHAIKSUKI VO" +
	"WEL SIGN IBHAIKSUKI VOWEL SIGN IIBHAIKSUKI VOWEL SIGN UBHAIKSUKI VOWEL S" +
	"IGN UUBHAIKSUKI VOWEL SIGN VOCALIC RBHAIKSUKI VOWEL SIGN VOCALIC RRBHAIK" +
	"SUKI VOWEL SIGN VOCALIC LBHAIKSUKI VOWEL SIGN EBHAIKSUKI VOWEL SIGN AIBH" +
	"AIKSUKI VOWEL SIGN OBHAIKSUKI VOWEL SIGN AUBHAIKSUKI SIGN CANDRABINDUBHA" +
	"IKSUKI SIGN ANUSVARABHAIKSUKI SIGN VISARGABHAIKSUKI SIGN VIRAMABHAIKSUKI" +
	" SIGN AVAGRAHABHAIKSUKI DANDABHAIKSUKI DOUBLE DANDABHAIKSUKI WORD SEPARA" +
	"TORBHAIKSUKI GAP FILLER-1BHAIKSUKI GAP FILLER-2BHAIKSUKI DIGIT ZEROBHAIK" +
	"SUKI DIGIT ONEBHAIKSUKI DIGIT TWOBHAIKSUKI DIGIT THREEBHAIKSUKI DIGIT FO" +
	"URBHAIKSUKI DIGIT FIVEBHAIKSUKI DIGIT SIXBHAIKSUKI DIGIT SEVENBHAIKSUKI " +
	"DIGIT EIGHTBHAIKSUKI DIGIT NINEBHAIKSUKI NUMBER ONEBHAIKSUKI NUMBER TWOB" +
	"HAIKSUKI NUMBER THREEBHAIKSUKI NUMBER FOURBHAIKSUKI NUMBER FIVEBHAIKSUKI" +
	" NUMBER SIXBHAIKSUKI NUMBER SEVENBHAIKSUKI NUMBER EIGHTBHAIKSUKI NUMBER ") + ("" +
	"NINEBHAIKSUKI NUMBER TENBHAIKSUKI NUMBER TWENTYBHAIKSUKI NUMBER THIRTYBH" +
	"AIKSUKI NUMBER FORTYBHAIKSUKI NUMBER FIFTYBHAIKSUKI NUMBER SIXTYBHAIKSUK" +
	"I NUMBER SEVENTYBHAIKSUKI NUMBER EIGHTYBHAIKSUKI NUMBER NINETYBHAIKSUKI " +
	"HUNDREDS UNIT MARKMARCHEN HEAD MARKMARCHEN MARK SHADMARCHEN LETTER KAMAR" +
	"CHEN LETTER KHAMARCHEN LETTER GAMARCHEN LETTER NGAMARCHEN LETTER CAMARCH" +
	"EN LETTER CHAMARCHEN LETTER JAMARCHEN LETTER NYAMARCHEN LETTER TAMARCHEN" +
	" LETTER THAMARCHEN LETTER DAMARCHEN LETTER NAMARCHEN LETTER PAMARCHEN LE" +
	"TTER PHAMARCHEN LETTER BAMARCHEN LETTER MAMARCHEN LETTER TSAMARCHEN LETT" +
	"ER TSHAMARCHEN LETTER DZAMARCHEN LETTER WAMARCHEN LETTER ZHAMARCHEN LETT" +
	"ER ZAMARCHEN LETTER -AMARCHEN LETTER YAMARCHEN LETTER RAMARCHEN LETTER L" +
	"AMARCHEN LETTER SHAMARCHEN LETTER SAMARCHEN LETTER HAMARCHEN LETTER AMAR" +
	"CHEN SUBJOINED LETTER KAMARCHEN SUBJOINED LETTER KHAMARCHEN SUBJOINED LE" +
	"TTER GAMARCHEN SUBJOINED LETTER NGAMARCHEN SUBJOINED LETTER CAMARCHEN SU" +
	"BJOINED LETTER CHAMARCHEN SUBJOINED LETTER JAMARCHEN SUBJOINED LETTER NY" +
	"AMARCHEN SUBJOINED LETTER TAMARCHEN SUBJOINED LETTER THAMARCHEN SUBJOINE" +
	"D LETTER DAMARCHEN SUBJOINED LETTER NAMARCHEN SUBJOINED LETTER PAMARCHEN" +
	" SUBJOINED LETTER PHAMARCHEN SUBJOINED LETTER BAMARCHEN SUBJOINED LETTER" +
	" MAMARCHEN SUBJOINED LETTER TSAMARCHEN SUBJOINED LETTER TSHAMARCHEN SUBJ" +
	"OINED LETTER DZAMARCHEN SUBJOINED LETTER WAMARCHEN SUBJOINED LETTER ZHAM" +
	"ARCHEN SUBJOINED LETTER ZAMARCHEN SUBJOINED LETTER YAMARCHEN SUBJOINED L" +
	"ETTER RAMARCHEN SUBJOINED LETTER LAMARCHEN SUBJOINED LETTER SHAMARCHEN S" +
	"UBJOINED LETTER SAMARCHEN SUBJOINED LETTER HAMARCHEN SUBJOINED LETTER AM" +
	"ARCHEN VOWEL SIGN AAMARCHEN VOWEL SIGN IMARCHEN VOWEL SIGN UMARCHEN VOWE" +
	"L SIGN EMARCHEN VOWEL SIGN OMARCHEN SIGN ANUSVARAMARCHEN SIGN CANDRABIND" +
	"UMASARAM GONDI LETTER AMASARAM GONDI LETTER AAMASARAM GONDI LETTER IMASA" +
	"RAM GONDI LETTER IIMASARAM GONDI LETTER UMASARAM GONDI LETTER UUMASARAM " +
	"GONDI LETTER EMASARAM GONDI LETTER AIMASARAM GONDI LETTER OMASARAM GONDI" +
	" LETTER AUMASARAM GONDI LETTER KAMASARAM GONDI LETTER KHAMASARAM GONDI L" +
	"ETTER GAMASARAM GONDI LETTER GHAMASARAM GONDI LETTER NGAMASARAM GONDI LE" +
	"TTER CAMASARAM GONDI LETTER CHAMASARAM GONDI LETTER JAMASARAM GONDI LETT" +
	"ER JHAMASARAM GONDI LETTER NYAMASARAM GONDI LETTER TTAMASARAM GONDI LETT" +
	"ER TTHAMASARAM GONDI LETTER DDAMASARAM GONDI LETTER DDHAMASARAM GONDI LE" +
	"TTER NNAMASARAM GONDI LETTER TAMASARAM GONDI LETTER THAMASARAM GONDI LET" +
	"TER DAMASARAM GONDI LETTER DHAMASARAM GONDI LETTER NAMASARAM GONDI LETTE" +
	"R PAMASARAM GONDI LETTER PHAMASARAM GONDI LETTER BAMASARAM GONDI LETTER " +
	"BHAMASARAM GONDI LETTER MAMASARAM GONDI LETTER YAMASARAM GONDI LETTER RA" +
	"MASARAM GONDI LETTER LAMASARAM GONDI LETTER VAMASARAM GONDI LETTER SHAMA" +
	"SARAM GONDI LETTER SSAMASARAM GONDI LETTER SAMASARAM GONDI LETTER HAMASA" +
	"RAM GONDI LETTER LLAMASARAM GONDI LETTER KSSAMASARAM GONDI LETTER JNYAMA" +
	"SARAM GONDI LETTER TRAMASARAM GONDI VOWEL SIGN AAMASARAM GONDI VOWEL SIG" +
	"N IMASARAM GONDI VOWEL SIGN IIMASARAM GONDI VOWEL SIGN UMASARAM GONDI VO" +
	"WEL SIGN UUMASARAM GONDI VOWEL SIGN VOCALIC RMASARAM GONDI VOWEL SIGN EM" +
	"ASARAM GONDI VOWEL SIGN AIMASARAM GONDI VOWEL SIGN OMASARAM GONDI VOWEL " +
	"SIGN AUMASARAM GONDI SIGN ANUSVARAMASARAM GONDI SIGN VISARGAMASARAM GOND" +
	"I SIGN NUKTAMASARAM GONDI SIGN CANDRAMASARAM GONDI SIGN HALANTAMASARAM G" +
	"ONDI VIRAMAMASARAM GONDI REPHAMASARAM GONDI RA-KARAMASARAM GONDI DIGIT Z" +
	"EROMASARAM GONDI DIGIT ONEMASARAM GONDI DIGIT TWOMASARAM GONDI DIGIT THR" +
	"EEMASARAM GONDI DIGIT FOURMASARAM GONDI DIGIT FIVEMASARAM GONDI DIGIT SI" +
	"XMASARAM GONDI DIGIT SEVENMASARAM GONDI DIGIT EIGHTMASARAM GONDI DIGIT N" +
	"INEGUNJALA GONDI LETTER AGUNJALA GONDI LETTER AAGUNJALA GONDI LETTER IGU" +
	"NJALA GONDI LETTER IIGUNJALA GONDI LETTER UGUNJALA GONDI LETTER UUGUNJAL" +
	"A GONDI LETTER EEGUNJALA GONDI LETTER AIGUNJALA GONDI LETTER OOGUNJALA G" +
	"ONDI LETTER AUGUNJALA GONDI LETTER YAGUNJALA GONDI LETTER VAGUNJALA GOND" +
	"I LETTER BAGUNJALA GONDI LETTER BHAGUNJALA GONDI LETTER MAGUNJALA GONDI " +
	"LETTER KAGUNJALA GONDI LETTER KHAGUNJALA GONDI LETTER TAGUNJALA GONDI LE" +
	"TTER THAGUNJALA GONDI LETTER LAGUNJALA GONDI LETTER GAGUNJALA GONDI LETT" +
	"ER GHAGUNJALA GONDI LETTER DAGUNJALA GONDI LETTER DHAGUNJALA GONDI LETTE" +
	"R NAGUNJALA GONDI LETTER CAGUNJALA GONDI LETTER CHAGUNJALA GONDI LETTER " +
	"TTAGUNJALA GONDI LETTER TTHAGUNJALA GONDI LETTER LLAGUNJALA GONDI LETTER" +
	" JAGUNJALA GONDI LETTER JHAGUNJALA GONDI LETTER DDAGUNJALA GONDI LETTER " +
	"DDHAGUNJALA GONDI LETTER NGAGUNJALA GONDI LETTER PAGUNJALA GONDI LETTER " +
	"PHAGUNJALA GONDI LETTER HAGUNJALA GONDI LETTER RAGUNJALA GONDI LETTER SA" +
	"GUNJALA GONDI VOWEL SIGN AAGUNJALA GONDI VOWEL SIGN IGUNJALA GONDI VOWEL" +
	" SIGN IIGUNJALA GONDI VOWEL SIGN UGUNJALA GONDI VOWEL SIGN UUGUNJALA GON") + ("" +
	"DI VOWEL SIGN EEGUNJALA GONDI VOWEL SIGN AIGUNJALA GONDI VOWEL SIGN OOGU" +
	"NJALA GONDI VOWEL SIGN AUGUNJALA GONDI SIGN ANUSVARAGUNJALA GONDI SIGN V" +
	"ISARGAGUNJALA GONDI VIRAMAGUNJALA GONDI OMGUNJALA GONDI DIGIT ZEROGUNJAL" +
	"A GONDI DIGIT ONEGUNJALA GONDI DIGIT TWOGUNJALA GONDI DIGIT THREEGUNJALA" +
	" GONDI DIGIT FOURGUNJALA GONDI DIGIT FIVEGUNJALA GONDI DIGIT SIXGUNJALA " +
	"GONDI DIGIT SEVENGUNJALA GONDI DIGIT EIGHTGUNJALA GONDI DIGIT NINETOLONG" +
	" SIKI LETTER ITOLONG SIKI LETTER ETOLONG SIKI LETTER UTOLONG SIKI LETTER" +
	" OTOLONG SIKI LETTER ATOLONG SIKI LETTER AATOLONG SIKI LETTER PTOLONG SI" +
	"KI LETTER PHTOLONG SIKI LETTER BTOLONG SIKI LETTER BHTOLONG SIKI LETTER " +
	"MTOLONG SIKI LETTER TTOLONG SIKI LETTER THTOLONG SIKI LETTER DTOLONG SIK" +
	"I LETTER DHTOLONG SIKI LETTER NTOLONG SIKI LETTER TTTOLONG SIKI LETTER T" +
	"THTOLONG SIKI LETTER DDTOLONG SIKI LETTER DDHTOLONG SIKI LETTER NNTOLONG" +
	" SIKI LETTER CTOLONG SIKI LETTER CHTOLONG SIKI LETTER JTOLONG SIKI LETTE" +
	"R JHTOLONG SIKI LETTER NYTOLONG SIKI LETTER KTOLONG SIKI LETTER KHTOLONG" +
	" SIKI LETTER GTOLONG SIKI LETTER GHTOLONG SIKI LETTER NGTOLONG SIKI LETT" +
	"ER YTOLONG SIKI LETTER RTOLONG SIKI LETTER LTOLONG SIKI LETTER VTOLONG S" +
	"IKI LETTER NNYTOLONG SIKI LETTER STOLONG SIKI LETTER HTOLONG SIKI LETTER" +
	" XTOLONG SIKI LETTER RRTOLONG SIKI LETTER RRHTOLONG SIKI SIGN SELATOLONG" +
	" SIKI SIGN HECAKATOLONG SIKI UNGGATOLONG SIKI DIGIT ZEROTOLONG SIKI DIGI" +
	"T ONETOLONG SIKI DIGIT TWOTOLONG SIKI DIGIT THREETOLONG SIKI DIGIT FOURT" +
	"OLONG SIKI DIGIT FIVETOLONG SIKI DIGIT SIXTOLONG SIKI DIGIT SEVENTOLONG " +
	"SIKI DIGIT EIGHTTOLONG SIKI DIGIT NINEMAKASAR LETTER KAMAKASAR LETTER GA" +
	"MAKASAR LETTER NGAMAKASAR LETTER PAMAKASAR LETTER BAMAKASAR LETTER MAMAK" +
	"ASAR LETTER TAMAKASAR LETTER DAMAKASAR LETTER NAMAKASAR LETTER CAMAKASAR" +
	" LETTER JAMAKASAR LETTER NYAMAKASAR LETTER YAMAKASAR LETTER RAMAKASAR LE" +
	"TTER LAMAKASAR LETTER VAMAKASAR LETTER SAMAKASAR LETTER AMAKASAR ANGKAMA" +
	"KASAR VOWEL SIGN IMAKASAR VOWEL SIGN UMAKASAR VOWEL SIGN EMAKASAR VOWEL " +
	"SIGN OMAKASAR PASSIMBANGMAKASAR END OF SECTIONKAWI SIGN CANDRABINDUKAWI " +
	"SIGN ANUSVARAKAWI SIGN REPHAKAWI SIGN VISARGAKAWI LETTER AKAWI LETTER AA" +
	"KAWI LETTER IKAWI LETTER IIKAWI LETTER UKAWI LETTER UUKAWI LETTER VOCALI" +
	"C RKAWI LETTER VOCALIC RRKAWI LETTER VOCALIC LKAWI LETTER VOCALIC LLKAWI" +
	" LETTER EKAWI LETTER AIKAWI LETTER OKAWI LETTER KAKAWI LETTER KHAKAWI LE" +
	"TTER GAKAWI LETTER GHAKAWI LETTER NGAKAWI LETTER CAKAWI LETTER CHAKAWI L" +
	"ETTER JAKAWI LETTER JHAKAWI LETTER NYAKAWI LETTER TTAKAWI LETTER TTHAKAW" +
	"I LETTER DDAKAWI LETTER DDHAKAWI LETTER NNAKAWI LETTER TAKAWI LETTER THA" +
	"KAWI LETTER DAKAWI LETTER DHAKAWI LETTER NAKAWI LETTER PAKAWI LETTER PHA" +
	"KAWI LETTER BAKAWI LETTER BHAKAWI LETTER MAKAWI LETTER YAKAWI LETTER RAK" +
	"AWI LETTER LAKAWI LETTER WAKAWI LETTER SHAKAWI LETTER SSAKAWI LETTER SAK" +
	"AWI LETTER HAKAWI LETTER JNYAKAWI VOWEL SIGN AAKAWI VOWEL SIGN ALTERNATE" +
	" AAKAWI VOWEL SIGN IKAWI VOWEL SIGN IIKAWI VOWEL SIGN UKAWI VOWEL SIGN U" +
	"UKAWI VOWEL SIGN VOCALIC RKAWI VOWEL SIGN EKAWI VOWEL SIGN AIKAWI VOWEL " +
	"SIGN EUKAWI SIGN KILLERKAWI CONJOINERKAWI DANDAKAWI DOUBLE DANDAKAWI PUN" +
	"CTUATION SECTION MARKERKAWI PUNCTUATION ALTERNATE SECTION MARKERKAWI PUN" +
	"CTUATION FLOWERKAWI PUNCTUATION SPACE FILLERKAWI PUNCTUATION DOTKAWI PUN" +
	"CTUATION DOUBLE DOTKAWI PUNCTUATION TRIPLE DOTKAWI PUNCTUATION CIRCLEKAW" +
	"I PUNCTUATION FILLED CIRCLEKAWI PUNCTUATION SPIRALKAWI PUNCTUATION CLOSI" +
	"NG SPIRALKAWI DIGIT ZEROKAWI DIGIT ONEKAWI DIGIT TWOKAWI DIGIT THREEKAWI" +
	" DIGIT FOURKAWI DIGIT FIVEKAWI DIGIT SIXKAWI DIGIT SEVENKAWI DIGIT EIGHT" +
	"KAWI DIGIT NINEKAWI SIGN NUKTALISU LETTER YHATAMIL FRACTION ONE THREE-HU" +
	"NDRED-AND-TWENTIETHTAMIL FRACTION ONE ONE-HUNDRED-AND-SIXTIETHTAMIL FRAC" +
	"TION ONE EIGHTIETHTAMIL FRACTION ONE SIXTY-FOURTHTAMIL FRACTION ONE FORT" +
	"IETHTAMIL FRACTION ONE THIRTY-SECONDTAMIL FRACTION THREE EIGHTIETHSTAMIL" +
	" FRACTION THREE SIXTY-FOURTHSTAMIL FRACTION ONE TWENTIETHTAMIL FRACTION " +
	"ONE SIXTEENTH-1TAMIL FRACTION ONE SIXTEENTH-2TAMIL FRACTION ONE TENTHTAM" +
	"IL FRACTION ONE EIGHTHTAMIL FRACTION THREE TWENTIETHSTAMIL FRACTION THRE" +
	"E SIXTEENTHSTAMIL FRACTION ONE FIFTHTAMIL FRACTION ONE QUARTERTAMIL FRAC" +
	"TION ONE HALF-1TAMIL FRACTION ONE HALF-2TAMIL FRACTION THREE QUARTERSTAM" +
	"IL FRACTION DOWNSCALING FACTOR KIIZHTAMIL SIGN NELTAMIL SIGN CEVITUTAMIL" +
	" SIGN AAZHAAKKUTAMIL SIGN UZHAKKUTAMIL SIGN MUUVUZHAKKUTAMIL SIGN KURUNI" +
	"TAMIL SIGN PATHAKKUTAMIL SIGN MUKKURUNITAMIL SIGN KAACUTAMIL SIGN PANAMT" +
	"AMIL SIGN PONTAMIL SIGN VARAAKANTAMIL SIGN PAARAMTAMIL SIGN KUZHITAMIL S" +
	"IGN VELITAMIL WET CULTIVATION SIGNTAMIL DRY CULTIVATION SIGNTAMIL LAND S" +
	"IGNTAMIL SALT PAN SIGNTAMIL TRADITIONAL CREDIT SIGNTAMIL TRADITIONAL NUM" +
	"BER SIGNTAMIL CURRENT SIGNTAMIL AND ODD SIGNTAMIL SPENT SIGNTAMIL TOTAL ") + ("" +
	"SIGNTAMIL IN POSSESSION SIGNTAMIL STARTING FROM SIGNTAMIL SIGN MUTHALIYA" +
	"TAMIL SIGN VAKAIYARAATAMIL PUNCTUATION END OF TEXTCUNEIFORM SIGN ACUNEIF" +
	"ORM SIGN A TIMES ACUNEIFORM SIGN A TIMES BADCUNEIFORM SIGN A TIMES GAN2 " +
	"TENUCUNEIFORM SIGN A TIMES HACUNEIFORM SIGN A TIMES IGICUNEIFORM SIGN A " +
	"TIMES LAGAR GUNUCUNEIFORM SIGN A TIMES MUSHCUNEIFORM SIGN A TIMES SAGCUN" +
	"EIFORM SIGN A2CUNEIFORM SIGN ABCUNEIFORM SIGN AB TIMES ASH2CUNEIFORM SIG" +
	"N AB TIMES DUN3 GUNUCUNEIFORM SIGN AB TIMES GALCUNEIFORM SIGN AB TIMES G" +
	"AN2 TENUCUNEIFORM SIGN AB TIMES HACUNEIFORM SIGN AB TIMES IGI GUNUCUNEIF" +
	"ORM SIGN AB TIMES IMINCUNEIFORM SIGN AB TIMES LAGABCUNEIFORM SIGN AB TIM" +
	"ES SHESHCUNEIFORM SIGN AB TIMES U PLUS U PLUS UCUNEIFORM SIGN AB GUNUCUN" +
	"EIFORM SIGN AB2CUNEIFORM SIGN AB2 TIMES BALAGCUNEIFORM SIGN AB2 TIMES GA" +
	"N2 TENUCUNEIFORM SIGN AB2 TIMES ME PLUS ENCUNEIFORM SIGN AB2 TIMES SHA3C" +
	"UNEIFORM SIGN AB2 TIMES TAK4CUNEIFORM SIGN ADCUNEIFORM SIGN AKCUNEIFORM " +
	"SIGN AK TIMES ERIN2CUNEIFORM SIGN AK TIMES SHITA PLUS GISHCUNEIFORM SIGN" +
	" ALCUNEIFORM SIGN AL TIMES ALCUNEIFORM SIGN AL TIMES DIM2CUNEIFORM SIGN " +
	"AL TIMES GISHCUNEIFORM SIGN AL TIMES HACUNEIFORM SIGN AL TIMES KAD3CUNEI" +
	"FORM SIGN AL TIMES KICUNEIFORM SIGN AL TIMES SHECUNEIFORM SIGN AL TIMES " +
	"USHCUNEIFORM SIGN ALANCUNEIFORM SIGN ALEPHCUNEIFORM SIGN AMARCUNEIFORM S" +
	"IGN AMAR TIMES SHECUNEIFORM SIGN ANCUNEIFORM SIGN AN OVER ANCUNEIFORM SI" +
	"GN AN THREE TIMESCUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGACUNEIF" +
	"ORM SIGN AN PLUS NAGA SQUAREDCUNEIFORM SIGN ANSHECUNEIFORM SIGN APINCUNE" +
	"IFORM SIGN ARADCUNEIFORM SIGN ARAD TIMES KURCUNEIFORM SIGN ARKABCUNEIFOR" +
	"M SIGN ASAL2CUNEIFORM SIGN ASHCUNEIFORM SIGN ASH ZIDA TENUCUNEIFORM SIGN" +
	" ASH KABA TENUCUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 " +
	"PAPCUNEIFORM SIGN ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH OVER ASH OVER " +
	"ASH CROSSING ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH2CUNEIFORM SIGN ASHG" +
	"ABCUNEIFORM SIGN BACUNEIFORM SIGN BADCUNEIFORM SIGN BAG3CUNEIFORM SIGN B" +
	"AHAR2CUNEIFORM SIGN BALCUNEIFORM SIGN BAL OVER BALCUNEIFORM SIGN BALAGCU" +
	"NEIFORM SIGN BARCUNEIFORM SIGN BARA2CUNEIFORM SIGN BICUNEIFORM SIGN BI T" +
	"IMES ACUNEIFORM SIGN BI TIMES GARCUNEIFORM SIGN BI TIMES IGI GUNUCUNEIFO" +
	"RM SIGN BUCUNEIFORM SIGN BU OVER BU ABCUNEIFORM SIGN BU OVER BU UNCUNEIF" +
	"ORM SIGN BU CROSSING BUCUNEIFORM SIGN BULUGCUNEIFORM SIGN BULUG OVER BUL" +
	"UGCUNEIFORM SIGN BURCUNEIFORM SIGN BUR2CUNEIFORM SIGN DACUNEIFORM SIGN D" +
	"AGCUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASHCUNEIFORM SIGN DAG KISIM5 T" +
	"IMES AMARCUNEIFORM SIGN DAG KISIM5 TIMES BALAGCUNEIFORM SIGN DAG KISIM5 " +
	"TIMES BICUNEIFORM SIGN DAG KISIM5 TIMES GACUNEIFORM SIGN DAG KISIM5 TIME" +
	"S GA PLUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES GICUNEIFORM SIGN DAG KISIM" +
	"5 TIMES GIR2CUNEIFORM SIGN DAG KISIM5 TIMES GUDCUNEIFORM SIGN DAG KISIM5" +
	" TIMES HACUNEIFORM SIGN DAG KISIM5 TIMES IRCUNEIFORM SIGN DAG KISIM5 TIM" +
	"ES IR PLUS LUCUNEIFORM SIGN DAG KISIM5 TIMES KAKCUNEIFORM SIGN DAG KISIM" +
	"5 TIMES LACUNEIFORM SIGN DAG KISIM5 TIMES LUCUNEIFORM SIGN DAG KISIM5 TI" +
	"MES LU PLUS MASH2CUNEIFORM SIGN DAG KISIM5 TIMES LUMCUNEIFORM SIGN DAG K" +
	"ISIM5 TIMES NECUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAPCUNEIFORM SIGN" +
	" DAG KISIM5 TIMES SICUNEIFORM SIGN DAG KISIM5 TIMES TAK4CUNEIFORM SIGN D" +
	"AG KISIM5 TIMES U2 PLUS GIR2CUNEIFORM SIGN DAG KISIM5 TIMES USHCUNEIFORM" +
	" SIGN DAMCUNEIFORM SIGN DARCUNEIFORM SIGN DARA3CUNEIFORM SIGN DARA4CUNEI" +
	"FORM SIGN DICUNEIFORM SIGN DIBCUNEIFORM SIGN DIMCUNEIFORM SIGN DIM TIMES" +
	" SHECUNEIFORM SIGN DIM2CUNEIFORM SIGN DINCUNEIFORM SIGN DIN KASKAL U GUN" +
	"U DISHCUNEIFORM SIGN DISHCUNEIFORM SIGN DUCUNEIFORM SIGN DU OVER DUCUNEI" +
	"FORM SIGN DU GUNUCUNEIFORM SIGN DU SHESHIGCUNEIFORM SIGN DUBCUNEIFORM SI" +
	"GN DUB TIMES ESH2CUNEIFORM SIGN DUB2CUNEIFORM SIGN DUGCUNEIFORM SIGN DUG" +
	"UDCUNEIFORM SIGN DUHCUNEIFORM SIGN DUNCUNEIFORM SIGN DUN3CUNEIFORM SIGN " +
	"DUN3 GUNUCUNEIFORM SIGN DUN3 GUNU GUNUCUNEIFORM SIGN DUN4CUNEIFORM SIGN " +
	"DUR2CUNEIFORM SIGN ECUNEIFORM SIGN E TIMES PAPCUNEIFORM SIGN E OVER E NU" +
	"N OVER NUNCUNEIFORM SIGN E2CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DACUNE" +
	"IFORM SIGN E2 TIMES GARCUNEIFORM SIGN E2 TIMES MICUNEIFORM SIGN E2 TIMES" +
	" SALCUNEIFORM SIGN E2 TIMES SHECUNEIFORM SIGN E2 TIMES UCUNEIFORM SIGN E" +
	"DINCUNEIFORM SIGN EGIRCUNEIFORM SIGN ELCUNEIFORM SIGN ENCUNEIFORM SIGN E" +
	"N TIMES GAN2CUNEIFORM SIGN EN TIMES GAN2 TENUCUNEIFORM SIGN EN TIMES MEC" +
	"UNEIFORM SIGN EN CROSSING ENCUNEIFORM SIGN EN OPPOSING ENCUNEIFORM SIGN " +
	"EN SQUAREDCUNEIFORM SIGN ERENCUNEIFORM SIGN ERIN2CUNEIFORM SIGN ESH2CUNE" +
	"IFORM SIGN EZENCUNEIFORM SIGN EZEN TIMES ACUNEIFORM SIGN EZEN TIMES A PL" +
	"US LALCUNEIFORM SIGN EZEN TIMES A PLUS LAL TIMES LALCUNEIFORM SIGN EZEN " +
	"TIMES ANCUNEIFORM SIGN EZEN TIMES BADCUNEIFORM SIGN EZEN TIMES DUN3 GUNU") + ("" +
	"CUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNUCUNEIFORM SIGN EZEN TIMES HACUNE" +
	"IFORM SIGN EZEN TIMES HA GUNUCUNEIFORM SIGN EZEN TIMES IGI GUNUCUNEIFORM" +
	" SIGN EZEN TIMES KASKALCUNEIFORM SIGN EZEN TIMES KASKAL SQUAREDCUNEIFORM" +
	" SIGN EZEN TIMES KU3CUNEIFORM SIGN EZEN TIMES LACUNEIFORM SIGN EZEN TIME" +
	"S LAL TIMES LALCUNEIFORM SIGN EZEN TIMES LICUNEIFORM SIGN EZEN TIMES LUC" +
	"UNEIFORM SIGN EZEN TIMES U2CUNEIFORM SIGN EZEN TIMES UDCUNEIFORM SIGN GA" +
	"CUNEIFORM SIGN GA GUNUCUNEIFORM SIGN GA2CUNEIFORM SIGN GA2 TIMES A PLUS " +
	"DA PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS HACUNEIFORM SIGN GA2 TIMES A P" +
	"LUS IGICUNEIFORM SIGN GA2 TIMES AB2 TENU PLUS TABCUNEIFORM SIGN GA2 TIME" +
	"S ANCUNEIFORM SIGN GA2 TIMES ASHCUNEIFORM SIGN GA2 TIMES ASH2 PLUS GALCU" +
	"NEIFORM SIGN GA2 TIMES BADCUNEIFORM SIGN GA2 TIMES BAR PLUS RACUNEIFORM " +
	"SIGN GA2 TIMES BURCUNEIFORM SIGN GA2 TIMES BUR PLUS RACUNEIFORM SIGN GA2" +
	" TIMES DACUNEIFORM SIGN GA2 TIMES DICUNEIFORM SIGN GA2 TIMES DIM TIMES S" +
	"HECUNEIFORM SIGN GA2 TIMES DUBCUNEIFORM SIGN GA2 TIMES ELCUNEIFORM SIGN " +
	"GA2 TIMES EL PLUS LACUNEIFORM SIGN GA2 TIMES ENCUNEIFORM SIGN GA2 TIMES " +
	"EN TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GAN2 TENUCUNEIFORM SIGN GA2 T" +
	"IMES GARCUNEIFORM SIGN GA2 TIMES GICUNEIFORM SIGN GA2 TIMES GI4CUNEIFORM" +
	" SIGN GA2 TIMES GI4 PLUS ACUNEIFORM SIGN GA2 TIMES GIR2 PLUS SUCUNEIFORM" +
	" SIGN GA2 TIMES HA PLUS LU PLUS ESH2CUNEIFORM SIGN GA2 TIMES HALCUNEIFOR" +
	"M SIGN GA2 TIMES HAL PLUS LACUNEIFORM SIGN GA2 TIMES HI PLUS LICUNEIFORM" +
	" SIGN GA2 TIMES HUB2CUNEIFORM SIGN GA2 TIMES IGI GUNUCUNEIFORM SIGN GA2 " +
	"TIMES ISH PLUS HU PLUS ASHCUNEIFORM SIGN GA2 TIMES KAKCUNEIFORM SIGN GA2" +
	" TIMES KASKALCUNEIFORM SIGN GA2 TIMES KIDCUNEIFORM SIGN GA2 TIMES KID PL" +
	"US LALCUNEIFORM SIGN GA2 TIMES KU3 PLUS ANCUNEIFORM SIGN GA2 TIMES LACUN" +
	"EIFORM SIGN GA2 TIMES ME PLUS ENCUNEIFORM SIGN GA2 TIMES MICUNEIFORM SIG" +
	"N GA2 TIMES NUNCUNEIFORM SIGN GA2 TIMES NUN OVER NUNCUNEIFORM SIGN GA2 T" +
	"IMES PACUNEIFORM SIGN GA2 TIMES SALCUNEIFORM SIGN GA2 TIMES SARCUNEIFORM" +
	" SIGN GA2 TIMES SHECUNEIFORM SIGN GA2 TIMES SHE PLUS TURCUNEIFORM SIGN G" +
	"A2 TIMES SHIDCUNEIFORM SIGN GA2 TIMES SUMCUNEIFORM SIGN GA2 TIMES TAK4CU" +
	"NEIFORM SIGN GA2 TIMES UCUNEIFORM SIGN GA2 TIMES UDCUNEIFORM SIGN GA2 TI" +
	"MES UD PLUS DUCUNEIFORM SIGN GA2 OVER GA2CUNEIFORM SIGN GABACUNEIFORM SI" +
	"GN GABA CROSSING GABACUNEIFORM SIGN GADCUNEIFORM SIGN GAD OVER GAD GAR O" +
	"VER GARCUNEIFORM SIGN GALCUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GARCUN" +
	"EIFORM SIGN GALAMCUNEIFORM SIGN GAMCUNEIFORM SIGN GANCUNEIFORM SIGN GAN2" +
	"CUNEIFORM SIGN GAN2 TENUCUNEIFORM SIGN GAN2 OVER GAN2CUNEIFORM SIGN GAN2" +
	" CROSSING GAN2CUNEIFORM SIGN GARCUNEIFORM SIGN GAR3CUNEIFORM SIGN GASHAN" +
	"CUNEIFORM SIGN GESHTINCUNEIFORM SIGN GESHTIN TIMES KURCUNEIFORM SIGN GIC" +
	"UNEIFORM SIGN GI TIMES ECUNEIFORM SIGN GI TIMES UCUNEIFORM SIGN GI CROSS" +
	"ING GICUNEIFORM SIGN GI4CUNEIFORM SIGN GI4 OVER GI4CUNEIFORM SIGN GI4 CR" +
	"OSSING GI4CUNEIFORM SIGN GIDIMCUNEIFORM SIGN GIR2CUNEIFORM SIGN GIR2 GUN" +
	"UCUNEIFORM SIGN GIR3CUNEIFORM SIGN GIR3 TIMES A PLUS IGICUNEIFORM SIGN G" +
	"IR3 TIMES GAN2 TENUCUNEIFORM SIGN GIR3 TIMES IGICUNEIFORM SIGN GIR3 TIME" +
	"S LU PLUS IGICUNEIFORM SIGN GIR3 TIMES PACUNEIFORM SIGN GISALCUNEIFORM S" +
	"IGN GISHCUNEIFORM SIGN GISH CROSSING GISHCUNEIFORM SIGN GISH TIMES BADCU" +
	"NEIFORM SIGN GISH TIMES TAK4CUNEIFORM SIGN GISH TENUCUNEIFORM SIGN GUCUN" +
	"EIFORM SIGN GU CROSSING GUCUNEIFORM SIGN GU2CUNEIFORM SIGN GU2 TIMES KAK" +
	"CUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GUNUCUNEIFORM SIGN GU2 TIMES NUNC" +
	"UNEIFORM SIGN GU2 TIMES SAL PLUS TUG2CUNEIFORM SIGN GU2 GUNUCUNEIFORM SI" +
	"GN GUDCUNEIFORM SIGN GUD TIMES A PLUS KURCUNEIFORM SIGN GUD TIMES KURCUN" +
	"EIFORM SIGN GUD OVER GUD LUGALCUNEIFORM SIGN GULCUNEIFORM SIGN GUMCUNEIF" +
	"ORM SIGN GUM TIMES SHECUNEIFORM SIGN GURCUNEIFORM SIGN GUR7CUNEIFORM SIG" +
	"N GURUNCUNEIFORM SIGN GURUSHCUNEIFORM SIGN HACUNEIFORM SIGN HA TENUCUNEI" +
	"FORM SIGN HA GUNUCUNEIFORM SIGN HALCUNEIFORM SIGN HICUNEIFORM SIGN HI TI" +
	"MES ASHCUNEIFORM SIGN HI TIMES ASH2CUNEIFORM SIGN HI TIMES BADCUNEIFORM " +
	"SIGN HI TIMES DISHCUNEIFORM SIGN HI TIMES GADCUNEIFORM SIGN HI TIMES KIN" +
	"CUNEIFORM SIGN HI TIMES NUNCUNEIFORM SIGN HI TIMES SHECUNEIFORM SIGN HI " +
	"TIMES UCUNEIFORM SIGN HUCUNEIFORM SIGN HUB2CUNEIFORM SIGN HUB2 TIMES ANC" +
	"UNEIFORM SIGN HUB2 TIMES HALCUNEIFORM SIGN HUB2 TIMES KASKALCUNEIFORM SI" +
	"GN HUB2 TIMES LISHCUNEIFORM SIGN HUB2 TIMES UDCUNEIFORM SIGN HUL2CUNEIFO" +
	"RM SIGN ICUNEIFORM SIGN I ACUNEIFORM SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM" +
	" SIGN IDIM OVER IDIM BURCUNEIFORM SIGN IDIM OVER IDIM SQUAREDCUNEIFORM S" +
	"IGN IGCUNEIFORM SIGN IGICUNEIFORM SIGN IGI DIBCUNEIFORM SIGN IGI RICUNEI" +
	"FORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UDCUNEIFORM SIGN IGI GUNUC" +
	"UNEIFORM SIGN ILCUNEIFORM SIGN IL TIMES GAN2 TENUCUNEIFORM SIGN IL2CUNEI") + ("" +
	"FORM SIGN IMCUNEIFORM SIGN IM TIMES TAK4CUNEIFORM SIGN IM CROSSING IMCUN" +
	"EIFORM SIGN IM OPPOSING IMCUNEIFORM SIGN IM SQUAREDCUNEIFORM SIGN IMINCU" +
	"NEIFORM SIGN INCUNEIFORM SIGN IRCUNEIFORM SIGN ISHCUNEIFORM SIGN KACUNEI" +
	"FORM SIGN KA TIMES ACUNEIFORM SIGN KA TIMES ADCUNEIFORM SIGN KA TIMES AD" +
	" PLUS KU3CUNEIFORM SIGN KA TIMES ASH2CUNEIFORM SIGN KA TIMES BADCUNEIFOR" +
	"M SIGN KA TIMES BALAGCUNEIFORM SIGN KA TIMES BARCUNEIFORM SIGN KA TIMES " +
	"BICUNEIFORM SIGN KA TIMES ERIN2CUNEIFORM SIGN KA TIMES ESH2CUNEIFORM SIG" +
	"N KA TIMES GACUNEIFORM SIGN KA TIMES GALCUNEIFORM SIGN KA TIMES GAN2 TEN" +
	"UCUNEIFORM SIGN KA TIMES GARCUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A" +
	"CUNEIFORM SIGN KA TIMES GICUNEIFORM SIGN KA TIMES GIR2CUNEIFORM SIGN KA " +
	"TIMES GISH PLUS SARCUNEIFORM SIGN KA TIMES GISH CROSSING GISHCUNEIFORM S" +
	"IGN KA TIMES GUCUNEIFORM SIGN KA TIMES GUR7CUNEIFORM SIGN KA TIMES IGICU" +
	"NEIFORM SIGN KA TIMES IMCUNEIFORM SIGN KA TIMES KAKCUNEIFORM SIGN KA TIM" +
	"ES KICUNEIFORM SIGN KA TIMES KIDCUNEIFORM SIGN KA TIMES LICUNEIFORM SIGN" +
	" KA TIMES LUCUNEIFORM SIGN KA TIMES MECUNEIFORM SIGN KA TIMES ME PLUS DU" +
	"CUNEIFORM SIGN KA TIMES ME PLUS GICUNEIFORM SIGN KA TIMES ME PLUS TECUNE" +
	"IFORM SIGN KA TIMES MICUNEIFORM SIGN KA TIMES MI PLUS NUNUZCUNEIFORM SIG" +
	"N KA TIMES NECUNEIFORM SIGN KA TIMES NUNCUNEIFORM SIGN KA TIMES PICUNEIF" +
	"ORM SIGN KA TIMES RUCUNEIFORM SIGN KA TIMES SACUNEIFORM SIGN KA TIMES SA" +
	"RCUNEIFORM SIGN KA TIMES SHACUNEIFORM SIGN KA TIMES SHECUNEIFORM SIGN KA" +
	" TIMES SHIDCUNEIFORM SIGN KA TIMES SHUCUNEIFORM SIGN KA TIMES SIGCUNEIFO" +
	"RM SIGN KA TIMES SUHURCUNEIFORM SIGN KA TIMES TARCUNEIFORM SIGN KA TIMES" +
	" UCUNEIFORM SIGN KA TIMES U2CUNEIFORM SIGN KA TIMES UDCUNEIFORM SIGN KA " +
	"TIMES UMUM TIMES PACUNEIFORM SIGN KA TIMES USHCUNEIFORM SIGN KA TIMES ZI" +
	"CUNEIFORM SIGN KA2CUNEIFORM SIGN KA2 CROSSING KA2CUNEIFORM SIGN KABCUNEI" +
	"FORM SIGN KAD2CUNEIFORM SIGN KAD3CUNEIFORM SIGN KAD4CUNEIFORM SIGN KAD5C" +
	"UNEIFORM SIGN KAD5 OVER KAD5CUNEIFORM SIGN KAKCUNEIFORM SIGN KAK TIMES I" +
	"GI GUNUCUNEIFORM SIGN KALCUNEIFORM SIGN KAL TIMES BADCUNEIFORM SIGN KAL " +
	"CROSSING KALCUNEIFORM SIGN KAM2CUNEIFORM SIGN KAM4CUNEIFORM SIGN KASKALC" +
	"UNEIFORM SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KASK" +
	"AL OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KESH2CUNEI" +
	"FORM SIGN KICUNEIFORM SIGN KI TIMES BADCUNEIFORM SIGN KI TIMES UCUNEIFOR" +
	"M SIGN KI TIMES UDCUNEIFORM SIGN KIDCUNEIFORM SIGN KINCUNEIFORM SIGN KIS" +
	"ALCUNEIFORM SIGN KISHCUNEIFORM SIGN KISIM5CUNEIFORM SIGN KISIM5 OVER KIS" +
	"IM5CUNEIFORM SIGN KUCUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIME" +
	"S ASH2CUNEIFORM SIGN KU3CUNEIFORM SIGN KU4CUNEIFORM SIGN KU4 VARIANT FOR" +
	"MCUNEIFORM SIGN KU7CUNEIFORM SIGN KULCUNEIFORM SIGN KUL GUNUCUNEIFORM SI" +
	"GN KUNCUNEIFORM SIGN KURCUNEIFORM SIGN KUR OPPOSING KURCUNEIFORM SIGN KU" +
	"SHU2CUNEIFORM SIGN KWU318CUNEIFORM SIGN LACUNEIFORM SIGN LAGABCUNEIFORM " +
	"SIGN LAGAB TIMES ACUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HACUNEIFORM " +
	"SIGN LAGAB TIMES A PLUS GARCUNEIFORM SIGN LAGAB TIMES A PLUS LALCUNEIFOR" +
	"M SIGN LAGAB TIMES ALCUNEIFORM SIGN LAGAB TIMES ANCUNEIFORM SIGN LAGAB T" +
	"IMES ASH ZIDA TENUCUNEIFORM SIGN LAGAB TIMES BADCUNEIFORM SIGN LAGAB TIM" +
	"ES BICUNEIFORM SIGN LAGAB TIMES DARCUNEIFORM SIGN LAGAB TIMES ENCUNEIFOR" +
	"M SIGN LAGAB TIMES GACUNEIFORM SIGN LAGAB TIMES GARCUNEIFORM SIGN LAGAB " +
	"TIMES GUDCUNEIFORM SIGN LAGAB TIMES GUD PLUS GUDCUNEIFORM SIGN LAGAB TIM" +
	"ES HACUNEIFORM SIGN LAGAB TIMES HALCUNEIFORM SIGN LAGAB TIMES HI TIMES N" +
	"UNCUNEIFORM SIGN LAGAB TIMES IGI GUNUCUNEIFORM SIGN LAGAB TIMES IMCUNEIF" +
	"ORM SIGN LAGAB TIMES IM PLUS HACUNEIFORM SIGN LAGAB TIMES IM PLUS LUCUNE" +
	"IFORM SIGN LAGAB TIMES KICUNEIFORM SIGN LAGAB TIMES KINCUNEIFORM SIGN LA" +
	"GAB TIMES KU3CUNEIFORM SIGN LAGAB TIMES KULCUNEIFORM SIGN LAGAB TIMES KU" +
	"L PLUS HI PLUS ACUNEIFORM SIGN LAGAB TIMES LAGABCUNEIFORM SIGN LAGAB TIM" +
	"ES LISHCUNEIFORM SIGN LAGAB TIMES LUCUNEIFORM SIGN LAGAB TIMES LULCUNEIF" +
	"ORM SIGN LAGAB TIMES MECUNEIFORM SIGN LAGAB TIMES ME PLUS ENCUNEIFORM SI" +
	"GN LAGAB TIMES MUSHCUNEIFORM SIGN LAGAB TIMES NECUNEIFORM SIGN LAGAB TIM" +
	"ES SHE PLUS SUMCUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2CUNE" +
	"IFORM SIGN LAGAB TIMES SHITA PLUS GISH TENUCUNEIFORM SIGN LAGAB TIMES SH" +
	"U2CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SHU2CUNEIFORM SIGN LAGAB TIMES SU" +
	"MCUNEIFORM SIGN LAGAB TIMES TAGCUNEIFORM SIGN LAGAB TIMES TAK4CUNEIFORM " +
	"SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS NACUNEIFORM SIGN LAGAB TIMES UCU" +
	"NEIFORM SIGN LAGAB TIMES U PLUS ACUNEIFORM SIGN LAGAB TIMES U PLUS U PLU" +
	"S UCUNEIFORM SIGN LAGAB TIMES U2 PLUS ASHCUNEIFORM SIGN LAGAB TIMES UDCU" +
	"NEIFORM SIGN LAGAB TIMES USHCUNEIFORM SIGN LAGAB SQUAREDCUNEIFORM SIGN L" +
	"AGARCUNEIFORM SIGN LAGAR TIMES SHECUNEIFORM SIGN LAGAR TIMES SHE PLUS SU") + ("" +
	"MCUNEIFORM SIGN LAGAR GUNUCUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHEC" +
	"UNEIFORM SIGN LAHSHUCUNEIFORM SIGN LALCUNEIFORM SIGN LAL TIMES LALCUNEIF" +
	"ORM SIGN LAMCUNEIFORM SIGN LAM TIMES KURCUNEIFORM SIGN LAM TIMES KUR PLU" +
	"S RUCUNEIFORM SIGN LICUNEIFORM SIGN LILCUNEIFORM SIGN LIMMU2CUNEIFORM SI" +
	"GN LISHCUNEIFORM SIGN LUCUNEIFORM SIGN LU TIMES BADCUNEIFORM SIGN LU2CUN" +
	"EIFORM SIGN LU2 TIMES ALCUNEIFORM SIGN LU2 TIMES BADCUNEIFORM SIGN LU2 T" +
	"IMES ESH2CUNEIFORM SIGN LU2 TIMES ESH2 TENUCUNEIFORM SIGN LU2 TIMES GAN2" +
	" TENUCUNEIFORM SIGN LU2 TIMES HI TIMES BADCUNEIFORM SIGN LU2 TIMES IMCUN" +
	"EIFORM SIGN LU2 TIMES KAD2CUNEIFORM SIGN LU2 TIMES KAD3CUNEIFORM SIGN LU" +
	"2 TIMES KAD3 PLUS ASHCUNEIFORM SIGN LU2 TIMES KICUNEIFORM SIGN LU2 TIMES" +
	" LA PLUS ASHCUNEIFORM SIGN LU2 TIMES LAGABCUNEIFORM SIGN LU2 TIMES ME PL" +
	"US ENCUNEIFORM SIGN LU2 TIMES NECUNEIFORM SIGN LU2 TIMES NUCUNEIFORM SIG" +
	"N LU2 TIMES SI PLUS ASHCUNEIFORM SIGN LU2 TIMES SIK2 PLUS BUCUNEIFORM SI" +
	"GN LU2 TIMES TUG2CUNEIFORM SIGN LU2 TENUCUNEIFORM SIGN LU2 CROSSING LU2C" +
	"UNEIFORM SIGN LU2 OPPOSING LU2CUNEIFORM SIGN LU2 SQUAREDCUNEIFORM SIGN L" +
	"U2 SHESHIGCUNEIFORM SIGN LU3CUNEIFORM SIGN LUGALCUNEIFORM SIGN LUGAL OVE" +
	"R LUGALCUNEIFORM SIGN LUGAL OPPOSING LUGALCUNEIFORM SIGN LUGAL SHESHIGCU" +
	"NEIFORM SIGN LUHCUNEIFORM SIGN LULCUNEIFORM SIGN LUMCUNEIFORM SIGN LUM O" +
	"VER LUMCUNEIFORM SIGN LUM OVER LUM GAR OVER GARCUNEIFORM SIGN MACUNEIFOR" +
	"M SIGN MA TIMES TAK4CUNEIFORM SIGN MA GUNUCUNEIFORM SIGN MA2CUNEIFORM SI" +
	"GN MAHCUNEIFORM SIGN MARCUNEIFORM SIGN MASHCUNEIFORM SIGN MASH2CUNEIFORM" +
	" SIGN MECUNEIFORM SIGN MESCUNEIFORM SIGN MICUNEIFORM SIGN MINCUNEIFORM S" +
	"IGN MUCUNEIFORM SIGN MU OVER MUCUNEIFORM SIGN MUGCUNEIFORM SIGN MUG GUNU" +
	"CUNEIFORM SIGN MUNSUBCUNEIFORM SIGN MURGU2CUNEIFORM SIGN MUSHCUNEIFORM S" +
	"IGN MUSH TIMES ACUNEIFORM SIGN MUSH TIMES KURCUNEIFORM SIGN MUSH TIMES Z" +
	"ACUNEIFORM SIGN MUSH OVER MUSHCUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS" +
	" NACUNEIFORM SIGN MUSH CROSSING MUSHCUNEIFORM SIGN MUSH3CUNEIFORM SIGN M" +
	"USH3 TIMES ACUNEIFORM SIGN MUSH3 TIMES A PLUS DICUNEIFORM SIGN MUSH3 TIM" +
	"ES DICUNEIFORM SIGN MUSH3 GUNUCUNEIFORM SIGN NACUNEIFORM SIGN NA2CUNEIFO" +
	"RM SIGN NAGACUNEIFORM SIGN NAGA INVERTEDCUNEIFORM SIGN NAGA TIMES SHU TE" +
	"NUCUNEIFORM SIGN NAGA OPPOSING NAGACUNEIFORM SIGN NAGARCUNEIFORM SIGN NA" +
	"M NUTILLUCUNEIFORM SIGN NAMCUNEIFORM SIGN NAM2CUNEIFORM SIGN NECUNEIFORM" +
	" SIGN NE TIMES ACUNEIFORM SIGN NE TIMES UDCUNEIFORM SIGN NE SHESHIGCUNEI" +
	"FORM SIGN NICUNEIFORM SIGN NI TIMES ECUNEIFORM SIGN NI2CUNEIFORM SIGN NI" +
	"MCUNEIFORM SIGN NIM TIMES GAN2 TENUCUNEIFORM SIGN NIM TIMES GAR PLUS GAN" +
	"2 TENUCUNEIFORM SIGN NINDA2CUNEIFORM SIGN NINDA2 TIMES ANCUNEIFORM SIGN " +
	"NINDA2 TIMES ASHCUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASHCUNEIFORM SIGN N" +
	"INDA2 TIMES GUDCUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENUCUNEIFORM SI" +
	"GN NINDA2 TIMES NECUNEIFORM SIGN NINDA2 TIMES NUNCUNEIFORM SIGN NINDA2 T" +
	"IMES SHECUNEIFORM SIGN NINDA2 TIMES SHE PLUS A ANCUNEIFORM SIGN NINDA2 T" +
	"IMES SHE PLUS ASHCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASHCUNEIF" +
	"ORM SIGN NINDA2 TIMES U2 PLUS ASHCUNEIFORM SIGN NINDA2 TIMES USHCUNEIFOR" +
	"M SIGN NISAGCUNEIFORM SIGN NUCUNEIFORM SIGN NU11CUNEIFORM SIGN NUNCUNEIF" +
	"ORM SIGN NUN LAGAR TIMES GARCUNEIFORM SIGN NUN LAGAR TIMES MASHCUNEIFORM" +
	" SIGN NUN LAGAR TIMES SALCUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAG" +
	"AR TIMES SALCUNEIFORM SIGN NUN LAGAR TIMES USHCUNEIFORM SIGN NUN TENUCUN" +
	"EIFORM SIGN NUN OVER NUNCUNEIFORM SIGN NUN CROSSING NUNCUNEIFORM SIGN NU" +
	"N CROSSING NUN LAGAR OVER LAGARCUNEIFORM SIGN NUNUZCUNEIFORM SIGN NUNUZ " +
	"AB2 TIMES ASHGABCUNEIFORM SIGN NUNUZ AB2 TIMES BICUNEIFORM SIGN NUNUZ AB" +
	"2 TIMES DUGCUNEIFORM SIGN NUNUZ AB2 TIMES GUDCUNEIFORM SIGN NUNUZ AB2 TI" +
	"MES IGI GUNUCUNEIFORM SIGN NUNUZ AB2 TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 " +
	"TIMES LACUNEIFORM SIGN NUNUZ AB2 TIMES NECUNEIFORM SIGN NUNUZ AB2 TIMES " +
	"SILA3CUNEIFORM SIGN NUNUZ AB2 TIMES U2CUNEIFORM SIGN NUNUZ KISIM5 TIMES " +
	"BICUNEIFORM SIGN NUNUZ KISIM5 TIMES BI UCUNEIFORM SIGN PACUNEIFORM SIGN " +
	"PADCUNEIFORM SIGN PANCUNEIFORM SIGN PAPCUNEIFORM SIGN PESH2CUNEIFORM SIG" +
	"N PICUNEIFORM SIGN PI TIMES ACUNEIFORM SIGN PI TIMES ABCUNEIFORM SIGN PI" +
	" TIMES BICUNEIFORM SIGN PI TIMES BUCUNEIFORM SIGN PI TIMES ECUNEIFORM SI" +
	"GN PI TIMES ICUNEIFORM SIGN PI TIMES IBCUNEIFORM SIGN PI TIMES UCUNEIFOR" +
	"M SIGN PI TIMES U2CUNEIFORM SIGN PI CROSSING PICUNEIFORM SIGN PIRIGCUNEI" +
	"FORM SIGN PIRIG TIMES KALCUNEIFORM SIGN PIRIG TIMES UDCUNEIFORM SIGN PIR" +
	"IG TIMES ZACUNEIFORM SIGN PIRIG OPPOSING PIRIGCUNEIFORM SIGN RACUNEIFORM" +
	" SIGN RABCUNEIFORM SIGN RICUNEIFORM SIGN RUCUNEIFORM SIGN SACUNEIFORM SI" +
	"GN SAG NUTILLUCUNEIFORM SIGN SAGCUNEIFORM SIGN SAG TIMES ACUNEIFORM SIGN" +
	" SAG TIMES DUCUNEIFORM SIGN SAG TIMES DUBCUNEIFORM SIGN SAG TIMES HACUNE") + ("" +
	"IFORM SIGN SAG TIMES KAKCUNEIFORM SIGN SAG TIMES KURCUNEIFORM SIGN SAG T" +
	"IMES LUMCUNEIFORM SIGN SAG TIMES MICUNEIFORM SIGN SAG TIMES NUNCUNEIFORM" +
	" SIGN SAG TIMES SALCUNEIFORM SIGN SAG TIMES SHIDCUNEIFORM SIGN SAG TIMES" +
	" TABCUNEIFORM SIGN SAG TIMES U2CUNEIFORM SIGN SAG TIMES UBCUNEIFORM SIGN" +
	" SAG TIMES UMCUNEIFORM SIGN SAG TIMES URCUNEIFORM SIGN SAG TIMES USHCUNE" +
	"IFORM SIGN SAG OVER SAGCUNEIFORM SIGN SAG GUNUCUNEIFORM SIGN SALCUNEIFOR" +
	"M SIGN SAL LAGAB TIMES ASH2CUNEIFORM SIGN SANGA2CUNEIFORM SIGN SARCUNEIF" +
	"ORM SIGN SHACUNEIFORM SIGN SHA3CUNEIFORM SIGN SHA3 TIMES ACUNEIFORM SIGN" +
	" SHA3 TIMES BADCUNEIFORM SIGN SHA3 TIMES GISHCUNEIFORM SIGN SHA3 TIMES N" +
	"ECUNEIFORM SIGN SHA3 TIMES SHU2CUNEIFORM SIGN SHA3 TIMES TURCUNEIFORM SI" +
	"GN SHA3 TIMES UCUNEIFORM SIGN SHA3 TIMES U PLUS ACUNEIFORM SIGN SHA6CUNE" +
	"IFORM SIGN SHAB6CUNEIFORM SIGN SHAR2CUNEIFORM SIGN SHECUNEIFORM SIGN SHE" +
	" HUCUNEIFORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GARCUNEIFORM SIGN S" +
	"HE OVER SHE TAB OVER TAB GAR OVER GARCUNEIFORM SIGN SHEG9CUNEIFORM SIGN " +
	"SHENCUNEIFORM SIGN SHESHCUNEIFORM SIGN SHESH2CUNEIFORM SIGN SHESHLAMCUNE" +
	"IFORM SIGN SHIDCUNEIFORM SIGN SHID TIMES ACUNEIFORM SIGN SHID TIMES IMCU" +
	"NEIFORM SIGN SHIMCUNEIFORM SIGN SHIM TIMES ACUNEIFORM SIGN SHIM TIMES BA" +
	"LCUNEIFORM SIGN SHIM TIMES BULUGCUNEIFORM SIGN SHIM TIMES DINCUNEIFORM S" +
	"IGN SHIM TIMES GARCUNEIFORM SIGN SHIM TIMES IGICUNEIFORM SIGN SHIM TIMES" +
	" IGI GUNUCUNEIFORM SIGN SHIM TIMES KUSHU2CUNEIFORM SIGN SHIM TIMES LULCU" +
	"NEIFORM SIGN SHIM TIMES MUGCUNEIFORM SIGN SHIM TIMES SALCUNEIFORM SIGN S" +
	"HINIGCUNEIFORM SIGN SHIRCUNEIFORM SIGN SHIR TENUCUNEIFORM SIGN SHIR OVER" +
	" SHIR BUR OVER BURCUNEIFORM SIGN SHITACUNEIFORM SIGN SHUCUNEIFORM SIGN S" +
	"HU OVER INVERTED SHUCUNEIFORM SIGN SHU2CUNEIFORM SIGN SHUBURCUNEIFORM SI" +
	"GN SICUNEIFORM SIGN SI GUNUCUNEIFORM SIGN SIGCUNEIFORM SIGN SIG4CUNEIFOR" +
	"M SIGN SIG4 OVER SIG4 SHU2CUNEIFORM SIGN SIK2CUNEIFORM SIGN SILA3CUNEIFO" +
	"RM SIGN SUCUNEIFORM SIGN SU OVER SUCUNEIFORM SIGN SUDCUNEIFORM SIGN SUD2" +
	"CUNEIFORM SIGN SUHURCUNEIFORM SIGN SUMCUNEIFORM SIGN SUMASHCUNEIFORM SIG" +
	"N SURCUNEIFORM SIGN SUR9CUNEIFORM SIGN TACUNEIFORM SIGN TA ASTERISKCUNEI" +
	"FORM SIGN TA TIMES HICUNEIFORM SIGN TA TIMES MICUNEIFORM SIGN TA GUNUCUN" +
	"EIFORM SIGN TABCUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISHCUNE" +
	"IFORM SIGN TAB SQUAREDCUNEIFORM SIGN TAGCUNEIFORM SIGN TAG TIMES BICUNEI" +
	"FORM SIGN TAG TIMES GUDCUNEIFORM SIGN TAG TIMES SHECUNEIFORM SIGN TAG TI" +
	"MES SHUCUNEIFORM SIGN TAG TIMES TUG2CUNEIFORM SIGN TAG TIMES UDCUNEIFORM" +
	" SIGN TAK4CUNEIFORM SIGN TARCUNEIFORM SIGN TECUNEIFORM SIGN TE GUNUCUNEI" +
	"FORM SIGN TICUNEIFORM SIGN TI TENUCUNEIFORM SIGN TILCUNEIFORM SIGN TIRCU" +
	"NEIFORM SIGN TIR TIMES TAK4CUNEIFORM SIGN TIR OVER TIRCUNEIFORM SIGN TIR" +
	" OVER TIR GAD OVER GAD GAR OVER GARCUNEIFORM SIGN TUCUNEIFORM SIGN TUG2C" +
	"UNEIFORM SIGN TUKCUNEIFORM SIGN TUMCUNEIFORM SIGN TURCUNEIFORM SIGN TUR " +
	"OVER TUR ZA OVER ZACUNEIFORM SIGN UCUNEIFORM SIGN U GUDCUNEIFORM SIGN U " +
	"U UCUNEIFORM SIGN U OVER U PA OVER PA GAR OVER GARCUNEIFORM SIGN U OVER " +
	"U SUR OVER SURCUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSEDCUNEIFOR" +
	"M SIGN U2CUNEIFORM SIGN UBCUNEIFORM SIGN UDCUNEIFORM SIGN UD KUSHU2CUNEI" +
	"FORM SIGN UD TIMES BADCUNEIFORM SIGN UD TIMES MICUNEIFORM SIGN UD TIMES " +
	"U PLUS U PLUS UCUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNUCUNEIFORM SIG" +
	"N UD GUNUCUNEIFORM SIGN UD SHESHIGCUNEIFORM SIGN UD SHESHIG TIMES BADCUN" +
	"EIFORM SIGN UDUGCUNEIFORM SIGN UMCUNEIFORM SIGN UM TIMES LAGABCUNEIFORM " +
	"SIGN UM TIMES ME PLUS DACUNEIFORM SIGN UM TIMES SHA3CUNEIFORM SIGN UM TI" +
	"MES UCUNEIFORM SIGN UMBINCUNEIFORM SIGN UMUMCUNEIFORM SIGN UMUM TIMES KA" +
	"SKALCUNEIFORM SIGN UMUM TIMES PACUNEIFORM SIGN UNCUNEIFORM SIGN UN GUNUC" +
	"UNEIFORM SIGN URCUNEIFORM SIGN UR CROSSING URCUNEIFORM SIGN UR SHESHIGCU" +
	"NEIFORM SIGN UR2CUNEIFORM SIGN UR2 TIMES A PLUS HACUNEIFORM SIGN UR2 TIM" +
	"ES A PLUS NACUNEIFORM SIGN UR2 TIMES ALCUNEIFORM SIGN UR2 TIMES HACUNEIF" +
	"ORM SIGN UR2 TIMES NUNCUNEIFORM SIGN UR2 TIMES U2CUNEIFORM SIGN UR2 TIME" +
	"S U2 PLUS ASHCUNEIFORM SIGN UR2 TIMES U2 PLUS BICUNEIFORM SIGN UR4CUNEIF" +
	"ORM SIGN URICUNEIFORM SIGN URI3CUNEIFORM SIGN URUCUNEIFORM SIGN URU TIME" +
	"S ACUNEIFORM SIGN URU TIMES ASHGABCUNEIFORM SIGN URU TIMES BARCUNEIFORM " +
	"SIGN URU TIMES DUNCUNEIFORM SIGN URU TIMES GACUNEIFORM SIGN URU TIMES GA" +
	"LCUNEIFORM SIGN URU TIMES GAN2 TENUCUNEIFORM SIGN URU TIMES GARCUNEIFORM" +
	" SIGN URU TIMES GUCUNEIFORM SIGN URU TIMES HACUNEIFORM SIGN URU TIMES IG" +
	"ICUNEIFORM SIGN URU TIMES IMCUNEIFORM SIGN URU TIMES ISHCUNEIFORM SIGN U" +
	"RU TIMES KICUNEIFORM SIGN URU TIMES LUMCUNEIFORM SIGN URU TIMES MINCUNEI" +
	"FORM SIGN URU TIMES PACUNEIFORM SIGN URU TIMES SHECUNEIFORM SIGN URU TIM" +
	"ES SIG4CUNEIFORM SIGN URU TIMES TUCUNEIFORM SIGN URU TIMES U PLUS GUDCUN") + ("" +
	"EIFORM SIGN URU TIMES UDCUNEIFORM SIGN URU TIMES URUDACUNEIFORM SIGN URU" +
	"DACUNEIFORM SIGN URUDA TIMES UCUNEIFORM SIGN USHCUNEIFORM SIGN USH TIMES" +
	" ACUNEIFORM SIGN USH TIMES KUCUNEIFORM SIGN USH TIMES KURCUNEIFORM SIGN " +
	"USH TIMES TAK4CUNEIFORM SIGN USHXCUNEIFORM SIGN USH2CUNEIFORM SIGN USHUM" +
	"XCUNEIFORM SIGN UTUKICUNEIFORM SIGN UZ3CUNEIFORM SIGN UZ3 TIMES KASKALCU" +
	"NEIFORM SIGN UZUCUNEIFORM SIGN ZACUNEIFORM SIGN ZA TENUCUNEIFORM SIGN ZA" +
	" SQUARED TIMES KURCUNEIFORM SIGN ZAGCUNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE" +
	"2CUNEIFORM SIGN ZICUNEIFORM SIGN ZI OVER ZICUNEIFORM SIGN ZI3CUNEIFORM S" +
	"IGN ZIBCUNEIFORM SIGN ZIB KABA TENUCUNEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2" +
	"CUNEIFORM SIGN ZUCUNEIFORM SIGN ZU5CUNEIFORM SIGN ZU5 TIMES ACUNEIFORM S" +
	"IGN ZUBURCUNEIFORM SIGN ZUMCUNEIFORM SIGN KAP ELAMITECUNEIFORM SIGN AB T" +
	"IMES NUNCUNEIFORM SIGN AB2 TIMES ACUNEIFORM SIGN AMAR TIMES KUGCUNEIFORM" +
	" SIGN DAG KISIM5 TIMES U2 PLUS MASHCUNEIFORM SIGN DAG3CUNEIFORM SIGN DIS" +
	"H PLUS SHUCUNEIFORM SIGN DUB TIMES SHECUNEIFORM SIGN EZEN TIMES GUDCUNEI" +
	"FORM SIGN EZEN TIMES SHECUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS ACUNEI" +
	"FORM SIGN GA2 TIMES ASH2CUNEIFORM SIGN GE22CUNEIFORM SIGN GIGCUNEIFORM S" +
	"IGN HUSHCUNEIFORM SIGN KA TIMES ANSHECUNEIFORM SIGN KA TIMES ASH3CUNEIFO" +
	"RM SIGN KA TIMES GISHCUNEIFORM SIGN KA TIMES GUDCUNEIFORM SIGN KA TIMES " +
	"HI TIMES ASH2CUNEIFORM SIGN KA TIMES LUMCUNEIFORM SIGN KA TIMES PACUNEIF" +
	"ORM SIGN KA TIMES SHULCUNEIFORM SIGN KA TIMES TUCUNEIFORM SIGN KA TIMES " +
	"UR2CUNEIFORM SIGN LAGAB TIMES GICUNEIFORM SIGN LU2 SHESHIG TIMES BADCUNE" +
	"IFORM SIGN LU2 TIMES ESH2 PLUS LALCUNEIFORM SIGN LU2 TIMES SHUCUNEIFORM " +
	"SIGN MESHCUNEIFORM SIGN MUSH3 TIMES ZACUNEIFORM SIGN NA4CUNEIFORM SIGN N" +
	"INCUNEIFORM SIGN NIN9CUNEIFORM SIGN NINDA2 TIMES BALCUNEIFORM SIGN NINDA" +
	"2 TIMES GICUNEIFORM SIGN NU11 ROTATED NINETY DEGREESCUNEIFORM SIGN PESH2" +
	" ASTERISKCUNEIFORM SIGN PIR2CUNEIFORM SIGN SAG TIMES IGI GUNUCUNEIFORM S" +
	"IGN TI2CUNEIFORM SIGN UM TIMES MECUNEIFORM SIGN U UCUNEIFORM NUMERIC SIG" +
	"N TWO ASHCUNEIFORM NUMERIC SIGN THREE ASHCUNEIFORM NUMERIC SIGN FOUR ASH" +
	"CUNEIFORM NUMERIC SIGN FIVE ASHCUNEIFORM NUMERIC SIGN SIX ASHCUNEIFORM N" +
	"UMERIC SIGN SEVEN ASHCUNEIFORM NUMERIC SIGN EIGHT ASHCUNEIFORM NUMERIC S" +
	"IGN NINE ASHCUNEIFORM NUMERIC SIGN THREE DISHCUNEIFORM NUMERIC SIGN FOUR" +
	" DISHCUNEIFORM NUMERIC SIGN FIVE DISHCUNEIFORM NUMERIC SIGN SIX DISHCUNE" +
	"IFORM NUMERIC SIGN SEVEN DISHCUNEIFORM NUMERIC SIGN EIGHT DISHCUNEIFORM " +
	"NUMERIC SIGN NINE DISHCUNEIFORM NUMERIC SIGN FOUR UCUNEIFORM NUMERIC SIG" +
	"N FIVE UCUNEIFORM NUMERIC SIGN SIX UCUNEIFORM NUMERIC SIGN SEVEN UCUNEIF" +
	"ORM NUMERIC SIGN EIGHT UCUNEIFORM NUMERIC SIGN NINE UCUNEIFORM NUMERIC S" +
	"IGN ONE GESH2CUNEIFORM NUMERIC SIGN TWO GESH2CUNEIFORM NUMERIC SIGN THRE" +
	"E GESH2CUNEIFORM NUMERIC SIGN FOUR GESH2CUNEIFORM NUMERIC SIGN FIVE GESH" +
	"2CUNEIFORM NUMERIC SIGN SIX GESH2CUNEIFORM NUMERIC SIGN SEVEN GESH2CUNEI" +
	"FORM NUMERIC SIGN EIGHT GESH2CUNEIFORM NUMERIC SIGN NINE GESH2CUNEIFORM " +
	"NUMERIC SIGN ONE GESHUCUNEIFORM NUMERIC SIGN TWO GESHUCUNEIFORM NUMERIC " +
	"SIGN THREE GESHUCUNEIFORM NUMERIC SIGN FOUR GESHUCUNEIFORM NUMERIC SIGN " +
	"FIVE GESHUCUNEIFORM NUMERIC SIGN TWO SHAR2CUNEIFORM NUMERIC SIGN THREE S" +
	"HAR2CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORMCUNEIFORM NUMERIC SIG" +
	"N FOUR SHAR2CUNEIFORM NUMERIC SIGN FIVE SHAR2CUNEIFORM NUMERIC SIGN SIX " +
	"SHAR2CUNEIFORM NUMERIC SIGN SEVEN SHAR2CUNEIFORM NUMERIC SIGN EIGHT SHAR" +
	"2CUNEIFORM NUMERIC SIGN NINE SHAR2CUNEIFORM NUMERIC SIGN ONE SHARUCUNEIF" +
	"ORM NUMERIC SIGN TWO SHARUCUNEIFORM NUMERIC SIGN THREE SHARUCUNEIFORM NU" +
	"MERIC SIGN THREE SHARU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHARUCUNE" +
	"IFORM NUMERIC SIGN FIVE SHARUCUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS" +
	" DISHCUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MINCUNEIFORM NUMERIC SI" +
	"GN ONE BURUCUNEIFORM NUMERIC SIGN TWO BURUCUNEIFORM NUMERIC SIGN THREE B" +
	"URUCUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORMCUNEIFORM NUMERIC SIGN " +
	"FOUR BURUCUNEIFORM NUMERIC SIGN FIVE BURUCUNEIFORM NUMERIC SIGN THREE VA" +
	"RIANT FORM ESH16CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21CUNEIFORM" +
	" NUMERIC SIGN FOUR VARIANT FORM LIMMUCUNEIFORM NUMERIC SIGN FOUR VARIANT" +
	" FORM LIMMU4CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU ACUNEIFORM NU" +
	"MERIC SIGN FOUR VARIANT FORM LIMMU BCUNEIFORM NUMERIC SIGN SIX VARIANT F" +
	"ORM ASH9CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3CUNEIFORM NUMERIC" +
	" SIGN SEVEN VARIANT FORM IMIN ACUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM" +
	" IMIN BCUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSUCUNEIFORM NUMERIC S" +
	"IGN EIGHT VARIANT FORM USSU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILI" +
	"MMUCUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3CUNEIFORM NUMERIC SIG" +
	"N NINE VARIANT FORM ILIMMU4CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIM") + ("" +
	"MU ACUNEIFORM NUMERIC SIGN TWO ASH TENUCUNEIFORM NUMERIC SIGN THREE ASH " +
	"TENUCUNEIFORM NUMERIC SIGN FOUR ASH TENUCUNEIFORM NUMERIC SIGN FIVE ASH " +
	"TENUCUNEIFORM NUMERIC SIGN SIX ASH TENUCUNEIFORM NUMERIC SIGN ONE BAN2CU" +
	"NEIFORM NUMERIC SIGN TWO BAN2CUNEIFORM NUMERIC SIGN THREE BAN2CUNEIFORM " +
	"NUMERIC SIGN FOUR BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORMCUNEI" +
	"FORM NUMERIC SIGN FIVE BAN2CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM" +
	"CUNEIFORM NUMERIC SIGN NIGIDAMINCUNEIFORM NUMERIC SIGN NIGIDAESHCUNEIFOR" +
	"M NUMERIC SIGN ONE ESHE3CUNEIFORM NUMERIC SIGN TWO ESHE3CUNEIFORM NUMERI" +
	"C SIGN ONE THIRD DISHCUNEIFORM NUMERIC SIGN TWO THIRDS DISHCUNEIFORM NUM" +
	"ERIC SIGN FIVE SIXTHS DISHCUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM " +
	"ACUNEIFORM NUMERIC SIGN TWO THIRDS VARIANT FORM ACUNEIFORM NUMERIC SIGN " +
	"ONE EIGHTH ASHCUNEIFORM NUMERIC SIGN ONE QUARTER ASHCUNEIFORM NUMERIC SI" +
	"GN OLD ASSYRIAN ONE SIXTHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER" +
	"CUNEIFORM NUMERIC SIGN ONE QUARTER GURCUNEIFORM NUMERIC SIGN ONE HALF GU" +
	"RCUNEIFORM NUMERIC SIGN ELAMITE ONE THIRDCUNEIFORM NUMERIC SIGN ELAMITE " +
	"TWO THIRDSCUNEIFORM NUMERIC SIGN ELAMITE FORTYCUNEIFORM NUMERIC SIGN ELA" +
	"MITE FIFTYCUNEIFORM NUMERIC SIGN FOUR U VARIANT FORMCUNEIFORM NUMERIC SI" +
	"GN FIVE U VARIANT FORMCUNEIFORM NUMERIC SIGN SIX U VARIANT FORMCUNEIFORM" +
	" NUMERIC SIGN SEVEN U VARIANT FORMCUNEIFORM NUMERIC SIGN EIGHT U VARIANT" +
	" FORMCUNEIFORM NUMERIC SIGN NINE U VARIANT FORMCUNEIFORM PUNCTUATION SIG" +
	"N OLD ASSYRIAN WORD DIVIDERCUNEIFORM PUNCTUATION SIGN VERTICAL COLONCUNE" +
	"IFORM PUNCTUATION SIGN DIAGONAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL" +
	" TRICOLONCUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLONCUNEIFORM SIGN AB " +
	"TIMES NUN TENUCUNEIFORM SIGN AB TIMES SHU2CUNEIFORM SIGN AD TIMES ESH2CU" +
	"NEIFORM SIGN BAD TIMES DISH TENUCUNEIFORM SIGN BAHAR2 TIMES AB2CUNEIFORM" +
	" SIGN BAHAR2 TIMES NICUNEIFORM SIGN BAHAR2 TIMES ZACUNEIFORM SIGN BU OVE" +
	"R BU TIMES NA2CUNEIFORM SIGN DA TIMES TAK4CUNEIFORM SIGN DAG TIMES KURCU" +
	"NEIFORM SIGN DIM TIMES IGICUNEIFORM SIGN DIM TIMES U U UCUNEIFORM SIGN D" +
	"IM2 TIMES UDCUNEIFORM SIGN DUG TIMES ANSHECUNEIFORM SIGN DUG TIMES ASHCU" +
	"NEIFORM SIGN DUG TIMES ASH AT LEFTCUNEIFORM SIGN DUG TIMES DINCUNEIFORM " +
	"SIGN DUG TIMES DUNCUNEIFORM SIGN DUG TIMES ERIN2CUNEIFORM SIGN DUG TIMES" +
	" GACUNEIFORM SIGN DUG TIMES GICUNEIFORM SIGN DUG TIMES GIR2 GUNUCUNEIFOR" +
	"M SIGN DUG TIMES GISHCUNEIFORM SIGN DUG TIMES HACUNEIFORM SIGN DUG TIMES" +
	" HICUNEIFORM SIGN DUG TIMES IGI GUNUCUNEIFORM SIGN DUG TIMES KASKALCUNEI" +
	"FORM SIGN DUG TIMES KURCUNEIFORM SIGN DUG TIMES KUSHU2CUNEIFORM SIGN DUG" +
	" TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN DUG TIMES LAK-020CUNEIFORM SIGN " +
	"DUG TIMES LAMCUNEIFORM SIGN DUG TIMES LAM TIMES KURCUNEIFORM SIGN DUG TI" +
	"MES LUH PLUS GISHCUNEIFORM SIGN DUG TIMES MASHCUNEIFORM SIGN DUG TIMES M" +
	"ESCUNEIFORM SIGN DUG TIMES MICUNEIFORM SIGN DUG TIMES NICUNEIFORM SIGN D" +
	"UG TIMES PICUNEIFORM SIGN DUG TIMES SHECUNEIFORM SIGN DUG TIMES SI GUNUC" +
	"UNEIFORM SIGN E2 TIMES KURCUNEIFORM SIGN E2 TIMES PAPCUNEIFORM SIGN ERIN" +
	"2 XCUNEIFORM SIGN ESH2 CROSSING ESH2CUNEIFORM SIGN EZEN SHESHIG TIMES AS" +
	"HCUNEIFORM SIGN EZEN SHESHIG TIMES HICUNEIFORM SIGN EZEN SHESHIG TIMES I" +
	"GI GUNUCUNEIFORM SIGN EZEN SHESHIG TIMES LACUNEIFORM SIGN EZEN SHESHIG T" +
	"IMES LALCUNEIFORM SIGN EZEN SHESHIG TIMES MECUNEIFORM SIGN EZEN SHESHIG " +
	"TIMES MESCUNEIFORM SIGN EZEN SHESHIG TIMES SUCUNEIFORM SIGN EZEN TIMES S" +
	"UCUNEIFORM SIGN GA2 TIMES BAHAR2CUNEIFORM SIGN GA2 TIMES DIM GUNUCUNEIFO" +
	"RM SIGN GA2 TIMES DUG TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES K" +
	"ASKALCUNEIFORM SIGN GA2 TIMES ERENCUNEIFORM SIGN GA2 TIMES GACUNEIFORM S" +
	"IGN GA2 TIMES GAR PLUS DICUNEIFORM SIGN GA2 TIMES GAR PLUS NECUNEIFORM S" +
	"IGN GA2 TIMES HA PLUS ACUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKALCUNEIF" +
	"ORM SIGN GA2 TIMES LAMCUNEIFORM SIGN GA2 TIMES LAM TIMES KURCUNEIFORM SI" +
	"GN GA2 TIMES LUHCUNEIFORM SIGN GA2 TIMES MUSHCUNEIFORM SIGN GA2 TIMES NE" +
	"CUNEIFORM SIGN GA2 TIMES NE PLUS E2CUNEIFORM SIGN GA2 TIMES NE PLUS GICU" +
	"NEIFORM SIGN GA2 TIMES SHIMCUNEIFORM SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN G" +
	"ABA ROTATED NINETY DEGREESCUNEIFORM SIGN GESHTIN TIMES UCUNEIFORM SIGN G" +
	"ISH TIMES GISH CROSSING GISHCUNEIFORM SIGN GU2 TIMES IGI GUNUCUNEIFORM S" +
	"IGN GUD PLUS GISH TIMES TAK4CUNEIFORM SIGN HA TENU GUNUCUNEIFORM SIGN HI" +
	" TIMES ASH OVER HI TIMES ASHCUNEIFORM SIGN KA TIMES BUCUNEIFORM SIGN KA " +
	"TIMES KACUNEIFORM SIGN KA TIMES U U UCUNEIFORM SIGN KA TIMES URCUNEIFORM" +
	" SIGN LAGAB TIMES ZU OVER ZUCUNEIFORM SIGN LAK-003CUNEIFORM SIGN LAK-021" +
	"CUNEIFORM SIGN LAK-025CUNEIFORM SIGN LAK-030CUNEIFORM SIGN LAK-050CUNEIF" +
	"ORM SIGN LAK-051CUNEIFORM SIGN LAK-062CUNEIFORM SIGN LAK-079 OVER LAK-07" +
	"9 GUNUCUNEIFORM SIGN LAK-080CUNEIFORM SIGN LAK-081 OVER LAK-081CUNEIFORM") + ("" +
	" SIGN LAK-092CUNEIFORM SIGN LAK-130CUNEIFORM SIGN LAK-142CUNEIFORM SIGN " +
	"LAK-210CUNEIFORM SIGN LAK-219CUNEIFORM SIGN LAK-220CUNEIFORM SIGN LAK-22" +
	"5CUNEIFORM SIGN LAK-228CUNEIFORM SIGN LAK-238CUNEIFORM SIGN LAK-265CUNEI" +
	"FORM SIGN LAK-266CUNEIFORM SIGN LAK-343CUNEIFORM SIGN LAK-347CUNEIFORM S" +
	"IGN LAK-348CUNEIFORM SIGN LAK-383CUNEIFORM SIGN LAK-384CUNEIFORM SIGN LA" +
	"K-390CUNEIFORM SIGN LAK-441CUNEIFORM SIGN LAK-449CUNEIFORM SIGN LAK-449 " +
	"TIMES GUCUNEIFORM SIGN LAK-449 TIMES IGICUNEIFORM SIGN LAK-449 TIMES PAP" +
	" PLUS LU3CUNEIFORM SIGN LAK-449 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIG" +
	"N LAK-449 TIMES U2 PLUS BACUNEIFORM SIGN LAK-450CUNEIFORM SIGN LAK-457CU" +
	"NEIFORM SIGN LAK-470CUNEIFORM SIGN LAK-483CUNEIFORM SIGN LAK-490CUNEIFOR" +
	"M SIGN LAK-492CUNEIFORM SIGN LAK-493CUNEIFORM SIGN LAK-495CUNEIFORM SIGN" +
	" LAK-550CUNEIFORM SIGN LAK-608CUNEIFORM SIGN LAK-617CUNEIFORM SIGN LAK-6" +
	"17 TIMES ASHCUNEIFORM SIGN LAK-617 TIMES BADCUNEIFORM SIGN LAK-617 TIMES" +
	" DUN3 GUNU GUNUCUNEIFORM SIGN LAK-617 TIMES KU3CUNEIFORM SIGN LAK-617 TI" +
	"MES LACUNEIFORM SIGN LAK-617 TIMES TARCUNEIFORM SIGN LAK-617 TIMES TECUN" +
	"EIFORM SIGN LAK-617 TIMES U2CUNEIFORM SIGN LAK-617 TIMES UDCUNEIFORM SIG" +
	"N LAK-617 TIMES URUDACUNEIFORM SIGN LAK-636CUNEIFORM SIGN LAK-648CUNEIFO" +
	"RM SIGN LAK-648 TIMES DUBCUNEIFORM SIGN LAK-648 TIMES GACUNEIFORM SIGN L" +
	"AK-648 TIMES IGICUNEIFORM SIGN LAK-648 TIMES IGI GUNUCUNEIFORM SIGN LAK-" +
	"648 TIMES NICUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM " +
	"SIGN LAK-648 TIMES SHESH PLUS KICUNEIFORM SIGN LAK-648 TIMES UDCUNEIFORM" +
	" SIGN LAK-648 TIMES URUDACUNEIFORM SIGN LAK-724CUNEIFORM SIGN LAK-749CUN" +
	"EIFORM SIGN LU2 GUNU TIMES ASHCUNEIFORM SIGN LU2 TIMES DISHCUNEIFORM SIG" +
	"N LU2 TIMES HALCUNEIFORM SIGN LU2 TIMES PAPCUNEIFORM SIGN LU2 TIMES PAP " +
	"PLUS PAP PLUS LU3CUNEIFORM SIGN LU2 TIMES TAK4CUNEIFORM SIGN MI PLUS ZA7" +
	"CUNEIFORM SIGN MUSH OVER MUSH TIMES GACUNEIFORM SIGN MUSH OVER MUSH TIME" +
	"S KAKCUNEIFORM SIGN NINDA2 TIMES DIM GUNUCUNEIFORM SIGN NINDA2 TIMES GIS" +
	"HCUNEIFORM SIGN NINDA2 TIMES GULCUNEIFORM SIGN NINDA2 TIMES HICUNEIFORM " +
	"SIGN NINDA2 TIMES KESH2CUNEIFORM SIGN NINDA2 TIMES LAK-050CUNEIFORM SIGN" +
	" NINDA2 TIMES MASHCUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAPCUNEIFORM SIGN" +
	" NINDA2 TIMES UCUNEIFORM SIGN NINDA2 TIMES U PLUS UCUNEIFORM SIGN NINDA2" +
	" TIMES URUDACUNEIFORM SIGN SAG GUNU TIMES HACUNEIFORM SIGN SAG TIMES ENC" +
	"UNEIFORM SIGN SAG TIMES SHE AT LEFTCUNEIFORM SIGN SAG TIMES TAK4CUNEIFOR" +
	"M SIGN SHA6 TENUCUNEIFORM SIGN SHE OVER SHECUNEIFORM SIGN SHE PLUS HUB2C" +
	"UNEIFORM SIGN SHE PLUS NAM2CUNEIFORM SIGN SHE PLUS SARCUNEIFORM SIGN SHU" +
	"2 PLUS DUG TIMES NICUNEIFORM SIGN SHU2 PLUS E2 TIMES ANCUNEIFORM SIGN SI" +
	" TIMES TAK4CUNEIFORM SIGN TAK4 PLUS SAGCUNEIFORM SIGN TUM TIMES GAN2 TEN" +
	"UCUNEIFORM SIGN TUM TIMES THREE DISHCUNEIFORM SIGN UR2 INVERTEDCUNEIFORM" +
	" SIGN UR2 TIMES UDCUNEIFORM SIGN URU TIMES DARA3CUNEIFORM SIGN URU TIMES" +
	" LAK-668CUNEIFORM SIGN URU TIMES LU3CUNEIFORM SIGN ZA7CUNEIFORM SIGN ZU " +
	"OVER ZU PLUS SARCUNEIFORM SIGN ZU5 TIMES THREE DISH TENUCYPRO-MINOAN SIG" +
	"N CM001CYPRO-MINOAN SIGN CM002CYPRO-MINOAN SIGN CM004CYPRO-MINOAN SIGN C" +
	"M005CYPRO-MINOAN SIGN CM006CYPRO-MINOAN SIGN CM007CYPRO-MINOAN SIGN CM00" +
	"8CYPRO-MINOAN SIGN CM009CYPRO-MINOAN SIGN CM010CYPRO-MINOAN SIGN CM011CY" +
	"PRO-MINOAN SIGN CM012CYPRO-MINOAN SIGN CM012BCYPRO-MINOAN SIGN CM013CYPR" +
	"O-MINOAN SIGN CM015CYPRO-MINOAN SIGN CM017CYPRO-MINOAN SIGN CM019CYPRO-M" +
	"INOAN SIGN CM021CYPRO-MINOAN SIGN CM023CYPRO-MINOAN SIGN CM024CYPRO-MINO" +
	"AN SIGN CM025CYPRO-MINOAN SIGN CM026CYPRO-MINOAN SIGN CM027CYPRO-MINOAN " +
	"SIGN CM028CYPRO-MINOAN SIGN CM029CYPRO-MINOAN SIGN CM030CYPRO-MINOAN SIG" +
	"N CM033CYPRO-MINOAN SIGN CM034CYPRO-MINOAN SIGN CM035CYPRO-MINOAN SIGN C" +
	"M036CYPRO-MINOAN SIGN CM037CYPRO-MINOAN SIGN CM038CYPRO-MINOAN SIGN CM03" +
	"9CYPRO-MINOAN SIGN CM040CYPRO-MINOAN SIGN CM041CYPRO-MINOAN SIGN CM044CY" +
	"PRO-MINOAN SIGN CM046CYPRO-MINOAN SIGN CM047CYPRO-MINOAN SIGN CM049CYPRO" +
	"-MINOAN SIGN CM050CYPRO-MINOAN SIGN CM051CYPRO-MINOAN SIGN CM052CYPRO-MI" +
	"NOAN SIGN CM053CYPRO-MINOAN SIGN CM054CYPRO-MINOAN SIGN CM055CYPRO-MINOA" +
	"N SIGN CM056CYPRO-MINOAN SIGN CM058CYPRO-MINOAN SIGN CM059CYPRO-MINOAN S" +
	"IGN CM060CYPRO-MINOAN SIGN CM061CYPRO-MINOAN SIGN CM062CYPRO-MINOAN SIGN" +
	" CM063CYPRO-MINOAN SIGN CM064CYPRO-MINOAN SIGN CM066CYPRO-MINOAN SIGN CM" +
	"067CYPRO-MINOAN SIGN CM068CYPRO-MINOAN SIGN CM069CYPRO-MINOAN SIGN CM070" +
	"CYPRO-MINOAN SIGN CM071CYPRO-MINOAN SIGN CM072CYPRO-MINOAN SIGN CM073CYP" +
	"RO-MINOAN SIGN CM074CYPRO-MINOAN SIGN CM075CYPRO-MINOAN SIGN CM075BCYPRO" +
	"-MINOAN SIGN CM076CYPRO-MINOAN SIGN CM078CYPRO-MINOAN SIGN CM079CYPRO-MI" +
	"NOAN SIGN CM080CYPRO-MINOAN SIGN CM081CYPRO-MINOAN SIGN CM082CYPRO-MINOA" +
	"N SIGN CM083CYPRO-MINOAN SIGN CM084CYPRO-MINOAN SIGN CM085CYPRO-MINOAN S") + ("" +
	"IGN CM086CYPRO-MINOAN SIGN CM087CYPRO-MINOAN SIGN CM088CYPRO-MINOAN SIGN" +
	" CM089CYPRO-MINOAN SIGN CM090CYPRO-MINOAN SIGN CM091CYPRO-MINOAN SIGN CM" +
	"092CYPRO-MINOAN SIGN CM094CYPRO-MINOAN SIGN