/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WindowsTreeUI
extends BasicTreeUI {
    protected static final int HALF_SIZE = 4;
    protected static final int SIZE = 9;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    @Override
    protected void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount(this.tree)) {
            Rectangle rectangle = this.tree.getVisibleRect();
            if (n == n2) {
                Rectangle rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle2 != null) {
                    rectangle2.x = rectangle.x;
                    rectangle2.width = rectangle.width;
                    this.tree.scrollRectToVisible(rectangle2);
                }
            } else {
                Rectangle rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle3 != null) {
                    Rectangle rectangle4 = rectangle3;
                    int n3 = rectangle3.y;
                    int n4 = n3 + rectangle.height;
                    for (int i = n + 1; i <= n2; ++i) {
                        rectangle4 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i));
                        if (rectangle4 == null || rectangle4.y + rectangle4.height <= n4) continue;
                        i = n2;
                    }
                    if (rectangle4 == null) {
                        return;
                    }
                    this.tree.scrollRectToVisible(new Rectangle(rectangle.x, n3, 1, rectangle4.y + rectangle4.height - n3));
                }
            }
        }
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WindowsTreeCellRenderer();
    }

    public class WindowsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!jTree.isEnabled()) {
                this.setEnabled(false);
                if (bl3) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (bl) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
            } else {
                this.setEnabled(true);
                if (bl3) {
                    this.setIcon(this.getLeafIcon());
                } else if (bl) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return this;
        }
    }

    public static class CollapsedIcon
    extends ExpandedIcon {
        public static Icon createCollapsedIcon() {
            return new CollapsedIcon();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            XPStyle.Skin skin = this.getSkin(component);
            if (skin != null) {
                skin.paintSkin(graphics, n, n2, TMSchema.State.CLOSED);
            } else {
                super.paintIcon(component, graphics, n, n2);
                graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 6);
            }
        }
    }

    public static class ExpandedIcon
    implements Icon,
    Serializable {
        public static Icon createExpandedIcon() {
            return new ExpandedIcon();
        }

        XPStyle.Skin getSkin(Component component) {
            XPStyle xPStyle = XPStyle.getXP();
            return xPStyle != null ? xPStyle.getSkin(component, TMSchema.Part.TVP_GLYPH) : null;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            XPStyle.Skin skin = this.getSkin(component);
            if (skin != null) {
                skin.paintSkin(graphics, n, n2, TMSchema.State.OPENED);
                return;
            }
            Color color = component.getBackground();
            if (color != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(Color.gray);
            graphics.drawRect(n, n2, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawLine(n + 2, n2 + 4, n + 6, n2 + 4);
        }

        @Override
        public int getIconWidth() {
            XPStyle.Skin skin = this.getSkin(null);
            return skin != null ? skin.getWidth() : 9;
        }

        @Override
        public int getIconHeight() {
            XPStyle.Skin skin = this.getSkin(null);
            return skin != null ? skin.getHeight() : 9;
        }
    }
}

