# Generated by vinca http://github.com/RoboStack/vinca.
# DO NOT EDIT!
set -eo pipefail

CATKIN_BUILD_BINARY_PACKAGE="ON"

# Rattler-build will not set the SRC_DIR anymore so we set it through templating
export SRC_DIR="@SRC_DIR@"

if [ "${PKG_NAME}" == "ros-noetic-catkin" ]; then
    # create catkin cookie to make it is a catkin workspace
    touch $PREFIX/.catkin
    # keep the workspace activation scripts (e.g., local_setup.bat)
    CATKIN_BUILD_BINARY_PACKAGE="OFF"
fi

mkdir -p build
cd build

# necessary for correctly linking SIP files (from python_qt_bindings)
export LINK=$CXX

if [[ $CONDA_BUILD_CROSS_COMPILATION != "1" ]]; then
    PYTHON_EXECUTABLE=$PREFIX/bin/python
    PKG_CONFIG_EXECUTABLE=$PREFIX/bin/pkg-config
    OSX_DEPLOYMENT_TARGET="10.15"
else
    PYTHON_EXECUTABLE=$BUILD_PREFIX/bin/python
    PKG_CONFIG_EXECUTABLE=$BUILD_PREFIX/bin/pkg-config
    OSX_DEPLOYMENT_TARGET="11.0"
fi

if [[ ${CONDA_BUILD_CROSS_COMPILATION:-} == "1" ]]; then
    export QT_HOST_PATH="$BUILD_PREFIX"
else
    export QT_HOST_PATH="$PREFIX"
fi

echo "USING PYTHON_EXECUTABLE=${PYTHON_EXECUTABLE}"
echo "USING PKG_CONFIG_EXECUTABLE=${PKG_CONFIG_EXECUTABLE}"

export ROS_PYTHON_VERSION=$($PYTHON_EXECUTABLE -c "import sys; print('%i.%i' % (sys.version_info[0:2]))")
echo "Using Python $ROS_PYTHON_VERSION"
# Fix up SP_DIR which for some reason might contain a path to a wrong Python version
FIXED_SP_DIR=$(echo $SP_DIR | sed -E "s/python[0-9]+\.[0-9]+/python$ROS_PYTHON_VERSION/")
echo "Using site-package dir ${FIXED_SP_DIR}"

# see https://github.com/conda-forge/cross-python-feedstock/issues/24
if [[ $CONDA_BUILD_CROSS_COMPILATION == "1" ]]; then
    find $PREFIX/lib/cmake -type f -exec sed -i "s~\${_IMPORT_PREFIX}/lib/python$ROS_PYTHON_VERSION/site-packages~$BUILD_PREFIX/lib/python$ROS_PYTHON_VERSION/site-packages~g" {} + || true
    find $PREFIX/share/rosidl* -type f -exec sed -i "s~$PREFIX/lib/python$ROS_PYTHON_VERSION/site-packages~$BUILD_PREFIX/lib/python$ROS_PYTHON_VERSION/site-packages~g" {} + || true
    find $PREFIX/share/rosidl* -type f -exec sed -i "s~\${_IMPORT_PREFIX}/lib/python$ROS_PYTHON_VERSION/site-packages~$BUILD_PREFIX/lib/python$ROS_PYTHON_VERSION/site-packages~g" {} + || true
    find $PREFIX/lib/cmake -type f -exec sed -i 's~message(FATAL_ERROR "The imported target~message(WARNING "The imported target~g' {} + || true
    # way around bad CPU type issues
    # rm $PREFIX/bin/doxygen || echo "doxygen not found"
    # rm $PREFIX/bin/dia || echo "dia not found"
    # rm $PREFIX/bin/dot || echo "dot not found"
fi

# NOTE: there might be undefined references occurring
# in the Boost.system library, depending on the C++ versions
# used to compile Boost. We can avoid them by forcing the use of
# the header-only version of the library.
export CXXFLAGS="$CXXFLAGS -DBOOST_ERROR_CODE_HEADER_ONLY"

if [[ $target_platform =~ linux.* ]]; then
    export CFLAGS="$CFLAGS -D__STDC_FORMAT_MACROS=1"
    export CXXFLAGS="$CXXFLAGS -D__STDC_FORMAT_MACROS=1"
    # I am too scared to turn this on for now ...
    # export LDFLAGS="$LDFLAGS -lrt";
    # Some qt stuff uses g++ directly - fix these use cases
    ln --symbolic --force $GXX $BUILD_PREFIX/bin/g++
fi

if [[ $target_platform =~ emscripten.* ]]; then
    export CONDA_BUILD_CROSS_COMPILATION="1"
    echo "set_property(GLOBAL PROPERTY TARGET_SUPPORTS_SHARED_LIBS TRUE)" >$SRC_DIR/__vinca_shared_lib_patch.cmake
    echo "set(CMAKE_STRIP FALSE)  # used by default in pybind11 on .so modules" >>$SRC_DIR/__vinca_shared_lib_patch.cmake
    echo "set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE BOTH)  # fixes an error where numpy header files are not found correctly" >>$SRC_DIR/__vinca_shared_lib_patch.cmake
    export EXTRA_CMAKE_ARGS=" \
      -DCMAKE_FIND_ROOT_PATH=$PREFIX    \
      -DCMAKE_POSITION_INDEPENDENT_CODE=TRUE \
      -DCMAKE_PROJECT_INCLUDE=$SRC_DIR/__vinca_shared_lib_patch.cmake \
  "
fi

export SKIP_TESTING=true

if [ "${PKG_NAME}" == "ros-noetic-euslisp" ] || [ "${PKG_NAME}" = "ros-noetic-jskeus" ] || [ "${PKG_NAME}" = "ros-noetic-roseus" ]; then
    GENERATOR="Unix Makefiles"
else
    GENERATOR="Ninja"
fi

cmake ${CMAKE_ARGS} --compile-no-warning-as-error \
    -DCMAKE_INSTALL_PREFIX=$PREFIX \
    -DCMAKE_PREFIX_PATH=$PREFIX \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_INSTALL_LIBDIR=lib \
    -DCMAKE_NO_SYSTEM_FROM_IMPORTED=ON \
    -DCMAKE_FIND_FRAMEWORK=LAST \
    -DCMAKE_AUTOMOC_EXECUTABLE=$CMAKE_AUTOMOC_EXECUTABLE \
    -DBUILD_SHARED_LIBS=ON \
    -DPYTHON_EXECUTABLE=$PYTHON_EXECUTABLE \
    -DPython_EXECUTABLE=$PYTHON_EXECUTABLE \
    -DPython3_EXECUTABLE=$PYTHON_EXECUTABLE \
    -DPython3_FIND_STRATEGY=LOCATION \
    -DPYTHON_INSTALL_DIR=$FIXED_SP_DIR \
    -DPKG_CONFIG_EXECUTABLE=$PKG_CONFIG_EXECUTABLE \
    -DSETUPTOOLS_DEB_LAYOUT=OFF \
    -DCATKIN_SKIP_TESTING=$SKIP_TESTING \
    -DCATKIN_BUILD_BINARY_PACKAGE=$CATKIN_BUILD_BINARY_PACKAGE \
    -DCMAKE_OSX_DEPLOYMENT_TARGET=$OSX_DEPLOYMENT_TARGET \
    -DCMAKE_POLICY_VERSION_MINIMUM=3.5 \
    $EXTRA_CMAKE_ARGS \
    -G "$GENERATOR" \
    $SRC_DIR

cmake --build . --config Release --target all

if [[ $SKIP_TESTING == "OFF" ]]; then
    cmake --build . --config Release --target run_tests
fi

cmake --build . --config Release --target install

if [ "${PKG_NAME}" == "ros-noetic-catkin" ]; then
    # Copy the [de]activate scripts to $PREFIX/etc/conda/[de]activate.d.
    # This will allow them to be run on environment activation.
    for CHANGE in "activate" "deactivate"; do
        mkdir -p "${PREFIX}/etc/conda/${CHANGE}.d"
        cp "${RECIPE_DIR}/${CHANGE}.sh" "${PREFIX}/etc/conda/${CHANGE}.d/${PKG_NAME}_${CHANGE}.sh"
    done
fi

if [ "${PKG_NAME}" == "ros-noetic-environment" ]; then
    for SCRIPT in "1.ros_distro.sh" "1.ros_etc_dir.sh" "1.ros_package_path.sh" "1.ros_python_version.sh" "1.ros_version.sh"; do
        mkdir -p "${PREFIX}/etc/conda/activate.d"
        cp "${PREFIX}/etc/catkin/profile.d/${SCRIPT}" "${PREFIX}/etc/conda/activate.d/${SCRIPT}"
    done
fi

if [ "${PKG_NAME}" == "ros-noetic-ros-workspace" ]; then
    # Copy the [de]activate scripts to $PREFIX/etc/conda/[de]activate.d.
    # This will allow them to be run on environment activation.
    for CHANGE in "activate" "deactivate"; do
        mkdir -p "${PREFIX}/etc/conda/${CHANGE}.d"
        cp "${RECIPE_DIR}/${CHANGE}.sh" "${PREFIX}/etc/conda/${CHANGE}.d/${PKG_NAME}_${CHANGE}.sh"
    done
fi
