#include <stdio.h>
#include <math.h>
#include <gd.h>
#include <gdfonts.h>
#include "measure.h"

#define CHART_X1 50
#define CHART_X2 840

#define CHART_Y1 20
#define CHART_Y2 599

//#define PIXEL_PER_MS 90
#define GRID_MS 5

static int PIXEL_PER_MS;

void draw_chart(char *output_file,
		struct latency_stat *st,
		struct latency_info *rt)
{
        /* Declare the image */
        gdImagePtr im;
        /* Declare an output file */
        FILE *out;
        /* Declare color indexes */
        int black;
        int red;
        int gray;
        int gray2;
        int yellow;
        int green;
        int white;
        int white2;

	int oldx,oldy;
	int x,y;
	int index,i;
	double i2;
	double time_division;
	double total_time;
	int tmp_ms;
	int over_flag=0;
	int old_x1;
	char str1[80];

	PIXEL_PER_MS = 450 / (st->deadline * 1000.0);

        /* Allocate the image: 64 pixels across by 64 pixels tall */
        im = gdImageCreate(CHART_X2 + 20, 680);

        /* Allocate the color black (red, green and blue all minimum).
	   Since this is the first color in a new image, it will
	   be the background color. */
        black = gdImageColorAllocate(im,0 , 0, 0);
        gray = gdImageColorAllocate(im,64 , 64, 64);
        gray2 = gdImageColorAllocate(im,110 , 110, 110);
        white2 = gdImageColorAllocate(im,200 , 200, 200);
        yellow = gdImageColorAllocate(im,230 , 230, 0);

        red = gdImageColorAllocate(im,255 , 0, 0);
        green = gdImageColorAllocate(im,0 , 255, 0);

        /* Allocate the color white (red, green and blue all maximum). */
        white = gdImageColorAllocate(im, 255, 255, 255);

	oldx = CHART_X1 + 1;
	oldy = CHART_Y2 - rt[0].sched_diff * 1000 * PIXEL_PER_MS;

	old_x1 = CHART_X1;

	for (i = CHART_Y2; i >= CHART_Y1; i -= PIXEL_PER_MS)
		gdImageLine(im, CHART_X1, i, CHART_X2, i, gray);

	tmp_ms = 0;
	for (i = CHART_Y2; i >= CHART_Y1; i -= PIXEL_PER_MS * GRID_MS) {
		gdImageLine(im, CHART_X1, i, CHART_X2, i, gray2);
		sprintf(str1, "%3.1d ms", tmp_ms);
		tmp_ms += GRID_MS;
		gdImageString(im, gdFontSmall,7, i-8, str1, white); 
	}

	gdImageLine(im, CHART_X1,CHART_Y2, CHART_X2, CHART_Y2, white2);
	gdImageLine(im, CHART_X1,CHART_Y2, CHART_X1, CHART_Y1, white2);


	total_time = rt[st->num_runs - 1].elapsed - rt[0].elapsed;
	// fprintf(stderr, "total time = %g\n", total_time);

	time_division = 1.0;
	if (total_time > 200.0)
		time_division = 10.0;

	for (i2=0; i2 < total_time; i2 += time_division) {
		x = CHART_X1 + (CHART_X2 - CHART_X1) * i2 / total_time;
		gdImageLine(im, x,CHART_Y2+3, x, CHART_Y2-3, white2);
	}

	for (i2=0; i2 < total_time; i2 += time_division * 10.0) {
		x = CHART_X1 + (CHART_X2-CHART_X1) * i2 / total_time;
		gdImageLine(im, x,CHART_Y2+5, x, CHART_Y2-5, white2);
		sprintf(str1,"%.0f",i2);
		gdImageString(im, gdFontSmall,x+2,CHART_Y2+8, str1, white); 
	}

	gdImageString(im, gdFontSmall,CHART_X2-70,CHART_Y2+16, "time (sec)", white); 

	for (index=0; index < st->num_runs; index++) {
		x = CHART_X1 + (rt[index].elapsed - rt[0].elapsed) / total_time *
			(CHART_X2-CHART_X1);

		y = CHART_Y2 - rt[index].sched_diff * 1000 * PIXEL_PER_MS;
		if (y < CHART_Y1) {
			y = CHART_Y1;
			if ((x - old_x1) > 30) {
				sprintf(str1,"%.1fms", rt[index].sched_diff*1000.0);
				gdImageString(im, gdFontSmall,x+2,y-4+10*over_flag, str1, white); 
				over_flag=1-over_flag;
				old_x1=x;
			}
		}

		gdImageLine(im, oldx, oldy, x, y, white);
		oldx = x;
		oldy = y;
	}

	oldx = CHART_X1 + 1;
	oldy = CHART_Y2 - rt[0].cpu_diff * 1000 * PIXEL_PER_MS;

	for (index=0; index < st->num_runs; index++) {
		x = CHART_X1 + (rt[index].elapsed - rt[0].elapsed) / total_time
			* (CHART_X2-CHART_X1);

		y = CHART_Y2 - rt[index].cpu_diff * 1000 * PIXEL_PER_MS;
		if (y < CHART_Y1)
			y = CHART_Y1;

		gdImageLine(im, oldx, oldy, x, y, green);
		oldx = x;
		oldy = y;
	}

	sprintf(str1, "max latency: %g ms", st->max_diff * 1000.0);
	gdImageString(im, gdFontSmall, CHART_X1, CHART_Y2+25, str1, white);
	sprintf(str1, "overruns: %d", st->overruns);
	gdImageString(im, gdFontSmall,CHART_X1+160, CHART_Y2+25, str1, white);

	sprintf(str1, "between +/-1ms: %g%%", (double)st->sched_in_1ms * 100.0 / st->num_runs);
	gdImageString(im, gdFontSmall, CHART_X1+300, CHART_Y2+25, str1, white);

	sprintf(str1, "between +/-2ms: %g%%", (double)st->sched_in_2ms * 100.0 / st->num_runs);
	gdImageString(im, gdFontSmall, CHART_X1+480, CHART_Y2+25, str1, white);

	sprintf(str1, "between +/-0.1ms: %g%%", (double)st->cpu_in_01ms * 100.0 / st->num_runs);
	gdImageString(im, gdFontSmall,CHART_X1+300, CHART_Y2+40, str1, green);

	sprintf(str1, "between +/-0.2ms: %g%%", (double)st->cpu_in_02ms * 100.0 / st->num_runs);
	gdImageString(im, gdFontSmall,CHART_X1+480, CHART_Y2+40, str1, green);

	y = CHART_Y2 - st->deadline * 1000.0 * PIXEL_PER_MS;
	gdImageLine(im, CHART_X1, y, CHART_X2, y, red);
	sprintf(str1,"%4.2f ms", st->deadline * 1000.0);
	gdImageString(im, gdFontSmall,CHART_X1+2, y-12, str1, red);

	y = CHART_Y2 - st->cpu_latency * 1000.0 * PIXEL_PER_MS;
	sprintf(str1, "cpu latency:   %4.2f ms (max = %4.2f ms)",
		st->cpu_latency * 1000.0,
		st->max_cpu_diff * 1000.0);
	gdImageString(im, gdFontSmall, CHART_X1, CHART_Y2+40, str1, green); 

	y = CHART_Y2 - st->sched_latency * 1000.0 * PIXEL_PER_MS;
	gdImageLine(im, CHART_X1, y, CHART_X2, y, yellow);
	sprintf(str1, "total latency: %4.2f ms", st->sched_latency * 1000.0);
	gdImageString(im, gdFontSmall, CHART_X1, CHART_Y2+56, str1, yellow);
	sprintf(str1, "std.deviation: %g", st->deviation);
	gdImageString(im, gdFontSmall, CHART_X1+200, CHART_Y2+56, str1, yellow);

        out = fopen(output_file, "w");
        gdImagePng(im, out);
        fclose(out);

        /* Destroy the image in memory. */
        gdImageDestroy(im);
}
