/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.ui;

import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class RatingImageUtil {
    private static final String resPath = "com/aelitis/azureus/plugins/rating/ui/icons/";
    public static Image imgUnrated;
    private static Image imgRated;
    public static int starWidth;

    public static void init(Display display) {
        imgUnrated = RatingImageUtil.loadImage(display, "com/aelitis/azureus/plugins/rating/ui/icons/unrated.png");
        imgRated = RatingImageUtil.loadImage(display, "com/aelitis/azureus/plugins/rating/ui/icons/rated.png");
        starWidth = imgUnrated == null ? 1 : RatingImageUtil.imgUnrated.getBounds().width / 5;
    }

    public static Image createRatingImage(float rating, Display display) {
        if (imgRated == null || imgUnrated == null) {
            return null;
        }
        if (rating < 0.0f) {
            rating = 0.0f;
        } else if (rating > 5.0f) {
            rating = 5.0f;
        }
        Image img = null;
        try {
            Rectangle bounds = imgRated.getBounds();
            int width = (int)((double)rating / 5.0 * (double)bounds.width);
            if (width > 0) {
                ImageData imageData = imgUnrated.getImageData();
                ImageData ratedData = imgRated.getImageData();
                for (int y = 0; y < bounds.height; ++y) {
                    byte[] alphas = new byte[width];
                    ratedData.getAlphas(0, y, width, alphas, 0);
                    int[] pixels = new int[width];
                    ratedData.getPixels(0, y, width, pixels, 0);
                    imageData.setPixels(0, y, width, pixels, 0);
                    imageData.setAlphas(0, y, width, alphas, 0);
                }
                img = new Image((Device)display, imageData);
            } else {
                img = new Image((Device)display, imgUnrated, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static Image createStarLineImage(float ratingStar, float ratingLine, Display display) {
        if (imgRated == null || imgUnrated == null) {
            return null;
        }
        if (ratingStar < 0.0f) {
            ratingStar = 0.0f;
        } else if (ratingStar > 5.0f) {
            ratingStar = 5.0f;
        }
        if (ratingLine < 0.0f) {
            ratingLine = 0.0f;
        } else if (ratingLine > 5.0f) {
            ratingLine = 5.0f;
        }
        Image img = null;
        try {
            Rectangle bounds = imgRated.getBounds();
            int widthStar = (int)((double)ratingStar / 5.0 * (double)bounds.width);
            int widthLine = (int)((double)ratingLine / 5.0 * (double)bounds.width);
            ImageData imageData = imgUnrated.getImageData();
            if (widthStar > 0 || widthLine > 0) {
                ImageData ratedData = imgRated.getImageData();
                if (widthStar > 0) {
                    for (int y = 0; y < bounds.height; ++y) {
                        byte[] alphas = new byte[widthStar];
                        ratedData.getAlphas(0, y, widthStar, alphas, 0);
                        int[] pixels = new int[widthStar];
                        ratedData.getPixels(0, y, widthStar, pixels, 0);
                        imageData.setPixels(0, y, widthStar, pixels, 0);
                        imageData.setAlphas(0, y, widthStar, alphas, 0);
                    }
                }
                if (widthLine > 0) {
                    byte[] alphas = new byte[widthLine];
                    Arrays.fill(alphas, (byte)-112);
                    int[] pixels = new int[widthLine];
                    Arrays.fill(pixels, 8447);
                    imageData.setAlphas(0, bounds.height - 2, widthLine, alphas, 0);
                    imageData.setPixels(0, bounds.height - 2, widthLine, pixels, 0);
                    Arrays.fill(alphas, (byte)64);
                    Arrays.fill(pixels, 4223);
                    imageData.setAlphas(0, bounds.height - 1, widthLine, alphas, 0);
                    imageData.setPixels(0, bounds.height - 1, widthLine, pixels, 0);
                }
            }
            img = new Image((Device)display, imageData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static Image createSplitStarImage(float ratingTop, float ratingBottom, Display display) {
        if (imgRated == null || imgUnrated == null) {
            return null;
        }
        if (ratingTop < 0.0f) {
            ratingTop = 0.0f;
        } else if (ratingTop > 5.0f) {
            ratingTop = 5.0f;
        }
        if (ratingBottom < 0.0f) {
            ratingBottom = 0.0f;
        } else if (ratingBottom > 5.0f) {
            ratingBottom = 5.0f;
        }
        Image img = null;
        try {
            Rectangle bounds = imgRated.getBounds();
            int widthTop = (int)((double)ratingTop / 5.0 * (double)bounds.width);
            int widthBottom = (int)((double)ratingBottom / 5.0 * (double)bounds.width);
            ImageData imageData = imgUnrated.getImageData();
            if (widthTop > 0 || widthBottom > 0) {
                int[] pixels;
                byte[] alphas;
                int y;
                ImageData ratedData = imgRated.getImageData();
                if (widthTop > 0) {
                    for (y = 0; y < bounds.height / 2; ++y) {
                        alphas = new byte[widthTop];
                        ratedData.getAlphas(0, y, widthTop, alphas, 0);
                        pixels = new int[widthTop];
                        ratedData.getPixels(0, y, widthTop, pixels, 0);
                        imageData.setPixels(0, y, widthTop, pixels, 0);
                        imageData.setAlphas(0, y, widthTop, alphas, 0);
                    }
                }
                if (widthBottom > 0) {
                    for (y = bounds.height / 2 + 1; y < bounds.height; ++y) {
                        alphas = new byte[widthBottom];
                        ratedData.getAlphas(0, y, widthBottom, alphas, 0);
                        pixels = new int[widthBottom];
                        ratedData.getPixels(0, y, widthBottom, pixels, 0);
                        imageData.setPixels(0, y, widthBottom, pixels, 0);
                        imageData.setAlphas(0, y, widthBottom, alphas, 0);
                    }
                }
            }
            img = new Image((Device)display, imageData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    private static Image loadImage(Display display, String res) {
        try {
            InputStream is = RatingImageUtil.class.getClassLoader().getResourceAsStream(res);
            if (is != null) {
                ImageData imageData = new ImageData(is);
                return new Image((Device)display, imageData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

