/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytracker;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class CategoryItem
extends CoreTableColumn
implements TableCellRefreshListener {
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    protected static final AzureusCore azureus_core = AzureusCoreFactory.getSingleton();

    public CategoryItem() {
        super("category", -1, 400, "MyTracker");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        TRHostTorrent tr_torrent = (TRHostTorrent)cell.getDataSource();
        if (tr_torrent == null) {
            cell.setText("");
        } else {
            TOTorrent torrent = tr_torrent.getTorrent();
            DownloadManager dm = azureus_core.getGlobalManager().getDownloadManager(torrent);
            String cat_str = null;
            if (dm != null) {
                Category cat = dm.getDownloadState().getCategory();
                if (cat != null) {
                    cat_str = cat.getName();
                }
            } else {
                cat_str = TorrentUtils.getPluginStringProperty(torrent, "azcoreplugins.category");
            }
            cell.setText(cat_str == null ? "" : cat_str);
        }
    }
}

