/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class MessageSlideShell {
    private static boolean USE_SWT32_BG_SET = true;
    private static final boolean DEBUG = false;
    private static final String REGEX_URLHTML = "<A HREF=\"(.+?)\">(.+?)</A>";
    private static final int EDGE_GAP = 0;
    private static final int SHELL_DEF_WIDTH = 280;
    private static final int SHELL_MIN_HEIGHT = 150;
    private static final int SHELL_MAX_HEIGHT = 330;
    private static final int DETAILS_WIDTH = 550;
    private static final int DETAILS_HEIGHT = 180;
    private static final AEMonitor monitor = new AEMonitor("slidey_mon");
    private static ArrayList historyList = new ArrayList();
    private static int currentPopupIndex = -1;
    private Shell shell;
    private Composite cShell;
    private Label lblCloseIn;
    private Button btnHideAll;
    private Button btnNext;
    private boolean bDelayPaused = false;
    private ArrayList disposeList = new ArrayList();
    private String sDetails;
    private int idxHistory;

    public MessageSlideShell(Display display, int iconID, String keyPrefix, String details, String[] textParams) {
        this(display, iconID, MessageText.getString(keyPrefix + ".title"), MessageText.getString(keyPrefix + ".text", textParams), details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageSlideShell(Display display, int iconID, String title, String text, String details) {
        try {
            monitor.enter();
            PopupParams popupParams = new PopupParams(iconID, title, text, details);
            historyList.add(popupParams);
            if (currentPopupIndex < 0) {
                this.create(display, popupParams, true);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LogIDs.GUI, "Mr. Slidey Init", e));
            this.disposeShell(this.shell);
            Utils.disposeSWTObjects(this.disposeList);
        }
        finally {
            monitor.exit();
        }
    }

    private MessageSlideShell(Display display, PopupParams popupParams, boolean bSlide) {
        this.create(display, popupParams, bSlide);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(final Display display, final PopupParams popupParams, boolean bSlide) {
        Rectangle endBounds;
        Shell mainShell;
        UIFunctionsSWT uiFunctions;
        MouseTrackAdapter mouseAdapter;
        Rectangle imgPopupBounds;
        int shellWidth;
        Image imgPopup;
        int style = 16384;
        boolean bDisableSliding = COConfigurationManager.getBooleanParameter("GUI_SWT_DisableAlertSliding");
        if (bDisableSliding) {
            bSlide = false;
            style = 0;
        }
        this.idxHistory = historyList.indexOf(popupParams);
        if (this.idxHistory < 0) {
            System.err.println("Not in popup history list");
            return;
        }
        if (currentPopupIndex == this.idxHistory) {
            System.err.println("Trying to open already opened!! " + this.idxHistory);
            return;
        }
        try {
            monitor.enter();
            currentPopupIndex = this.idxHistory;
        }
        finally {
            monitor.exit();
        }
        this.sDetails = popupParams.details;
        if (Constants.isOSX && (SWT.getVersion() < 3221 || !USE_SWT32_BG_SET)) {
            USE_SWT32_BG_SET = false;
            imgPopup = null;
        } else {
            imgPopup = ImageRepository.getImage("popup");
        }
        if (imgPopup != null) {
            shellWidth = imgPopup.getBounds().width;
            imgPopupBounds = imgPopup.getBounds();
        } else {
            shellWidth = 280;
            imgPopupBounds = null;
        }
        Image imgIcon = null;
        switch (popupParams.iconID) {
            case 1: {
                imgIcon = ImageRepository.getImage("error");
                break;
            }
            case 8: {
                imgIcon = ImageRepository.getImage("warning");
                break;
            }
            case 2: {
                imgIcon = ImageRepository.getImage("info");
                break;
            }
            default: {
                imgIcon = null;
            }
        }
        this.bDelayPaused = UrlUtils.parseHTMLforURL(popupParams.text) != null || popupParams.iconID != 2 || !bSlide;
        MouseTrackAdapter mouseTrackAdapter = mouseAdapter = this.bDelayPaused ? null : new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                MessageSlideShell.this.bDelayPaused = true;
            }

            public void mouseExit(MouseEvent e) {
                MessageSlideShell.this.bDelayPaused = false;
            }
        };
        if (bDisableSliding && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (mainShell = uiFunctions.getMainShell()) != null) {
            this.shell = new Shell(mainShell, style);
        }
        if (this.shell == null) {
            this.shell = new Shell(display, style);
        }
        if (USE_SWT32_BG_SET) {
            try {
                this.shell.setBackgroundMode(1);
            }
            catch (NoSuchMethodError e) {
            }
            catch (NoSuchFieldError e2) {
                // empty catch block
            }
        }
        Utils.setShellIcon(this.shell);
        this.shell.setText(popupParams.title);
        FormLayout shellLayout = new FormLayout();
        this.shell.setLayout((Layout)shellLayout);
        this.cShell = new Composite((Composite)this.shell, 0);
        GridLayout layout = new GridLayout(3, false);
        this.cShell.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.cShell.setLayoutData((Object)formData);
        Label lblIcon = new Label(this.cShell, 0);
        lblIcon.setImage(imgIcon);
        lblIcon.setLayoutData((Object)new GridData());
        Label lblTitle = new Label(this.cShell, SWT.getVersion() < 3100 ? 0 : 64);
        GridData gridData = new GridData(768);
        if (SWT.getVersion() < 3100) {
            gridData.widthHint = 140;
        }
        lblTitle.setLayoutData((Object)gridData);
        lblTitle.setForeground(display.getSystemColor(2));
        lblTitle.setText(popupParams.title);
        FontData[] fontData = lblTitle.getFont().getFontData();
        fontData[0].setStyle(1);
        fontData[0].setHeight((int)((double)fontData[0].getHeight() * 1.5));
        Font boldFont = new Font((Device)display, fontData);
        this.disposeList.add(boldFont);
        lblTitle.setFont(boldFont);
        final Button btnDetails = new Button(this.cShell, 2);
        btnDetails.setForeground(display.getSystemColor(2));
        Messages.setLanguageText((Widget)btnDetails, "popup.error.details");
        gridData = new GridData();
        btnDetails.setLayoutData((Object)gridData);
        btnDetails.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    boolean bShow = btnDetails.getSelection();
                    if (bShow) {
                        Shell detailsShell = new Shell(display, 18432);
                        Utils.setShellIcon(detailsShell);
                        detailsShell.setLayout((Layout)new FillLayout());
                        StyledText textDetails = new StyledText((Composite)detailsShell, 2824);
                        textDetails.setBackground(display.getSystemColor(1));
                        textDetails.setWordWrap(true);
                        textDetails.setText(MessageSlideShell.this.sDetails);
                        detailsShell.layout();
                        Rectangle shellBounds = MessageSlideShell.this.shell.getBounds();
                        detailsShell.setBounds(shellBounds.x + shellBounds.width - 550, shellBounds.y - 180, 550, 180);
                        detailsShell.open();
                        MessageSlideShell.this.shell.setData("detailsShell", (Object)detailsShell);
                        MessageSlideShell.this.shell.addDisposeListener(new DisposeListener(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void widgetDisposed(DisposeEvent e) {
                                Shell detailsShell = (Shell)MessageSlideShell.access$200(2.access$300(this.this$1)).getData("detailsShell");
                                if (detailsShell != null && !detailsShell.isDisposed()) {
                                    detailsShell.dispose();
                                }
                            }
                        });
                        MessageSlideShell.this.bDelayPaused = true;
                        MessageSlideShell.this.removeMouseTrackListener((Composite)MessageSlideShell.this.shell, (MouseTrackListener)mouseAdapter);
                    } else {
                        Shell detailsShell = (Shell)MessageSlideShell.this.shell.getData("detailsShell");
                        if (detailsShell != null && !detailsShell.isDisposed()) {
                            detailsShell.dispose();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "Mr. Slidey DetailsButton", e));
                }
            }

            static /* synthetic */ MessageSlideShell access$300(2 x0) {
                return x0.MessageSlideShell.this;
            }
        });
        try {
            Link linkLabel = new Link(this.cShell, 64);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(popupParams.text);
            linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.text.endsWith(".torrent")) {
                        TorrentOpener.openTorrent(e.text);
                    } else {
                        Program.launch((String)e.text);
                    }
                }
            });
            Matcher matcher = Pattern.compile(REGEX_URLHTML, 2).matcher(popupParams.text);
            String tooltip = null;
            while (matcher.find()) {
                tooltip = tooltip == null ? "" : tooltip + "\n";
                tooltip = tooltip + matcher.group(2) + ": " + matcher.group(1);
            }
            linkLabel.setToolTipText(tooltip);
        }
        catch (Throwable t) {
            Label linkLabel = new Label(this.cShell, 64);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            linkLabel.setLayoutData((Object)gridData);
            popupParams.text = Pattern.compile(REGEX_URLHTML, 2).matcher(popupParams.text).replaceAll("$2 ($1)");
            this.sDetails = this.sDetails == null ? popupParams.text : popupParams.text + "\n---------\n" + this.sDetails;
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(popupParams.text);
        }
        this.lblCloseIn = new Label(this.cShell, 131072);
        this.lblCloseIn.setForeground(display.getSystemColor(2));
        this.lblCloseIn.setText("\n");
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 3;
        this.lblCloseIn.setLayoutData((Object)gridData);
        final Composite cButtons = new Composite(this.cShell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        if (Constants.isOSX) {
            gridLayout.horizontalSpacing = 0;
        }
        gridLayout.numColumns = this.idxHistory > 0 ? 3 : 2;
        cButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(132);
        gridData.horizontalSpan = 3;
        cButtons.setLayoutData((Object)gridData);
        this.btnHideAll = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)this.btnHideAll, "popup.error.hideall");
        this.btnHideAll.setVisible(false);
        this.btnHideAll.setForeground(display.getSystemColor(2));
        this.btnHideAll.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                cButtons.setEnabled(false);
                MessageSlideShell.this.shell.dispose();
            }
        });
        if (this.idxHistory > 0) {
            Button btnPrev = new Button(cButtons, 8);
            btnPrev.setForeground(display.getSystemColor(2));
            btnPrev.setText(MessageText.getString("popup.previous", new String[]{"" + this.idxHistory}));
            btnPrev.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    int idx = historyList.indexOf(popupParams) - 1;
                    if (idx >= 0) {
                        PopupParams item = (PopupParams)historyList.get(idx);
                        MessageSlideShell.this.showPopup(display, item, false);
                        MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    }
                }
            });
        }
        this.btnNext = new Button(cButtons, 8);
        this.btnNext.setForeground(display.getSystemColor(2));
        int numAfter = historyList.size() - this.idxHistory - 1;
        this.setButtonNextText(numAfter);
        this.btnNext.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                if (MessageSlideShell.this.idxHistory + 1 < historyList.size()) {
                    MessageSlideShell.this.showPopup(display, (PopupParams)historyList.get(MessageSlideShell.this.idxHistory + 1), false);
                }
                MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
            }
        });
        Point bestSize = this.cShell.computeSize(shellWidth, -1);
        if (bestSize.y < 150) {
            bestSize.y = 150;
        } else if (bestSize.y > 330) {
            bestSize.y = 330;
            this.sDetails = this.sDetails == null ? popupParams.text : popupParams.text + "\n===============\n" + this.sDetails;
        }
        if (imgPopup != null) {
            int bottomHeight = cButtons.computeSize((int)-1, (int)-1).y + this.lblCloseIn.computeSize((int)-1, (int)-1).y;
            if (bottomHeight < 50) {
                bestSize.y += 50 - bottomHeight;
            }
            final Image imgBackground = new Image((Device)display, bestSize.x, bestSize.y);
            this.disposeList.add(imgBackground);
            GC gc = new GC((Drawable)imgBackground);
            int dstY = imgPopupBounds.height - bestSize.y;
            if (dstY < 0) {
                dstY = 0;
            }
            gc.drawImage(imgPopup, 0, dstY, imgPopupBounds.width, imgPopupBounds.height - dstY, 0, 0, bestSize.x, bestSize.y);
            gc.dispose();
            boolean bAlternateDrawing = true;
            if (USE_SWT32_BG_SET) {
                try {
                    this.shell.setBackgroundImage(imgBackground);
                    bAlternateDrawing = false;
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            if (bAlternateDrawing) {
                this.cShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.drawImage(imgBackground, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                });
                Color colorBG = display.getSystemColor(22);
                final RGB bgRGB = colorBG.getRGB();
                PaintListener paintListener = new PaintListener(){
                    boolean alreadyPainting = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void paintControl(PaintEvent e) {
                        if (this.alreadyPainting || e.width <= 0 || e.height <= 0) {
                            return;
                        }
                        this.alreadyPainting = true;
                        try {
                            Rectangle bounds = ((Control)e.widget).getBounds();
                            Image img = new Image((Device)display, e.width, e.height);
                            e.gc.copyArea(img, e.x, e.y);
                            e.gc.drawImage(imgBackground, -bounds.x, -bounds.y);
                            ImageData data = img.getImageData();
                            data.transparentPixel = data.palette.getPixel(bgRGB);
                            Image imgTransparent = new Image((Device)display, data);
                            e.gc.drawImage(imgTransparent, 0, 0, e.width, e.height, e.x, e.y, e.width, e.height);
                        }
                        finally {
                            this.alreadyPainting = false;
                        }
                    }
                };
                this.shell.setBackground(colorBG);
                this.cShell.setBackground(colorBG);
                this.addPaintListener(this.cShell, paintListener, colorBG, true);
            }
        }
        Rectangle bounds = null;
        try {
            Shell mainShell2;
            UIFunctionsSWT uiFunctions2 = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions2 != null && (mainShell2 = uiFunctions2.getMainShell()) != null) {
                bounds = mainShell2.getMonitor().getClientArea();
            }
            if (bounds == null) {
                bounds = this.shell.getMonitor().getClientArea();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bounds == null) {
            bounds = display.getClientArea();
        }
        if (bDisableSliding) {
            endBounds = new Rectangle((bounds.x + bounds.width) / 2 - bestSize.x / 2, (bounds.y + bounds.height) / 2 - bestSize.y / 2, bestSize.x, bestSize.y);
        } else {
            int boundsX2 = bounds.x + bounds.width;
            int boundsY2 = bounds.y + bounds.height;
            endBounds = this.shell.computeTrim(boundsX2 - bestSize.x, boundsY2 - bestSize.y, bestSize.x, bestSize.y);
            int diff = endBounds.x + endBounds.width - boundsX2;
            if (diff >= 0) {
                endBounds.x -= diff + 0;
            }
            if ((diff = endBounds.y + endBounds.height - boundsY2) >= 0) {
                endBounds.y -= diff + 0;
            }
        }
        FormData data = new FormData(bestSize.x, bestSize.y);
        this.cShell.setLayoutData((Object)data);
        btnDetails.setVisible(this.sDetails != null);
        if (this.sDetails == null) {
            gridData = new GridData();
            gridData.widthHint = 0;
            btnDetails.setLayoutData((Object)gridData);
        }
        this.shell.layout();
        this.btnNext.setFocus();
        this.shell.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(MessageSlideShell.this.disposeList);
                if (currentPopupIndex == MessageSlideShell.this.idxHistory) {
                    try {
                        monitor.enter();
                        currentPopupIndex = -1;
                    }
                    finally {
                        monitor.exit();
                    }
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.detail == 2) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    event2.doit = false;
                }
            }
        });
        if (mouseAdapter != null) {
            this.addMouseTrackListener((Composite)this.shell, (MouseTrackListener)mouseAdapter);
        }
        this.runPopup(endBounds, this.idxHistory, bSlide);
    }

    private void setButtonNextText(int numAfter) {
        if (numAfter <= 0) {
            Messages.setLanguageText((Widget)this.btnNext, "popup.error.hide");
        } else {
            Messages.setLanguageText((Widget)this.btnNext, "popup.next", new String[]{"" + numAfter});
        }
        this.cShell.layout(true);
    }

    private void showPopup(final Display display, final PopupParams item, final boolean bSlide) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                new MessageSlideShell(display, item, bSlide);
            }
        });
    }

    private void addMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        parent.addMouseTrackListener(listener);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                this.addMouseTrackListener((Composite)control, listener);
                continue;
            }
            control.addMouseTrackListener(listener);
        }
    }

    private void addPaintListener(Composite parent, PaintListener listener, Color colorBG, boolean childrenOnly) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        if (!childrenOnly) {
            parent.addPaintListener(listener);
            parent.setBackground(colorBG);
        }
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.addPaintListener(listener);
            control.setBackground(colorBG);
            if (!(control instanceof Composite)) continue;
            this.addPaintListener((Composite)control, listener, colorBG, true);
        }
    }

    private void removeMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.removeMouseTrackListener(listener);
            if (!(control instanceof Composite)) continue;
            this.removeMouseTrackListener((Composite)control, listener);
        }
    }

    private void runPopup(final Rectangle endBounds, final int idx, final boolean bSlide) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        final Display display = this.shell.getDisplay();
        AEThread thread = new AEThread("Slidey", true){
            private static final int PAUSE = 500;

            public void runSupport() {
                if (MessageSlideShell.this.shell == null || MessageSlideShell.this.shell.isDisposed()) {
                    return;
                }
                if (bSlide) {
                    new SlideShell(MessageSlideShell.this.shell, 128, endBounds).run();
                } else {
                    Utils.execSWTThread(new AERunnable(this){
                        private final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void runSupport() {
                            MessageSlideShell.access$200(13.access$1400(this.this$1)).setBounds(13.access$1300(this.this$1));
                            MessageSlideShell.access$200(13.access$1400(this.this$1)).open();
                        }
                    });
                }
                int delayLeft = COConfigurationManager.getIntParameter("Message Popup Autoclose in Seconds") * 1000;
                boolean autohide = delayLeft != 0;
                long lastDelaySecs = 0L;
                int lastNumPopups = -1;
                while (!(autohide && !MessageSlideShell.this.bDelayPaused && delayLeft <= 0 || MessageSlideShell.this.shell.isDisposed())) {
                    int delayPausedOfs = MessageSlideShell.this.bDelayPaused ? 1 : 0;
                    long delaySecs = Math.round((double)delayLeft / 1000.0) + (long)delayPausedOfs;
                    int numPopups = historyList.size();
                    if (lastDelaySecs != delaySecs || lastNumPopups != numPopups) {
                        lastDelaySecs = delaySecs;
                        lastNumPopups = numPopups;
                        MessageSlideShell.this.shell.getDisplay().asyncExec((Runnable)new AERunnable(this, autohide, delaySecs, numPopups){
                            private final /* synthetic */ boolean val$autohide;
                            private final /* synthetic */ long val$delaySecs;
                            private final /* synthetic */ int val$numPopups;
                            private final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$autohide = val$autohide;
                                this.val$delaySecs = val$delaySecs;
                                this.val$numPopups = val$numPopups;
                            }

                            public void runSupport() {
                                int numPopupsAfterUs;
                                boolean bHasMany;
                                String sText = "";
                                if (MessageSlideShell.access$1500(13.access$1400(this.this$1)) == null || MessageSlideShell.access$1500(13.access$1400(this.this$1)).isDisposed()) {
                                    return;
                                }
                                MessageSlideShell.access$1500(13.access$1400(this.this$1)).setRedraw(false);
                                if (!MessageSlideShell.access$000(13.access$1400(this.this$1)) && this.val$autohide) {
                                    sText = sText + MessageText.getString("popup.closing.in", new String[]{String.valueOf(this.val$delaySecs)});
                                }
                                boolean bl = bHasMany = (numPopupsAfterUs = this.val$numPopups - 13.access$1600(this.this$1) - 1) > 0;
                                if (bHasMany) {
                                    sText = sText + "\n";
                                    sText = sText + MessageText.getString("popup.more.waiting", new String[]{String.valueOf(numPopupsAfterUs)});
                                }
                                MessageSlideShell.access$1500(13.access$1400(this.this$1)).setText(sText);
                                if (MessageSlideShell.access$1700(13.access$1400(this.this$1)).getVisible() != bHasMany) {
                                    MessageSlideShell.access$1800(13.access$1400(this.this$1)).setRedraw(false);
                                    MessageSlideShell.access$1700(13.access$1400(this.this$1)).setVisible(bHasMany);
                                    MessageSlideShell.access$1500(13.access$1400(this.this$1)).getParent().layout(true);
                                    MessageSlideShell.access$1800(13.access$1400(this.this$1)).setRedraw(true);
                                }
                                MessageSlideShell.access$1900(13.access$1400(this.this$1), numPopupsAfterUs);
                                MessageSlideShell.access$1500(13.access$1400(this.this$1)).setRedraw(true);
                            }
                        });
                    }
                    if (!MessageSlideShell.this.bDelayPaused) {
                        delayLeft -= 500;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        delayLeft = 0;
                    }
                }
                if (this.isInterrupted()) {
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                    return;
                }
                if (MessageSlideShell.this.shell != null && !MessageSlideShell.this.shell.isDisposed()) {
                    if (idx + 1 < historyList.size()) {
                        MessageSlideShell.this.showPopup(display, (PopupParams)historyList.get(idx + 1), true);
                    }
                    if (bSlide) {
                        new SlideShell(MessageSlideShell.this.shell, 131072).run();
                    }
                    MessageSlideShell.this.disposeShell(MessageSlideShell.this.shell);
                }
            }

            static /* synthetic */ Rectangle access$1300(13 x0) {
                return x0.endBounds;
            }

            static /* synthetic */ MessageSlideShell access$1400(13 x0) {
                return x0.MessageSlideShell.this;
            }

            static /* synthetic */ int access$1600(13 x0) {
                return x0.idx;
            }
        };
        thread.start();
    }

    private void disposeShell(final Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                shell.dispose();
            }
        });
    }

    public static void waitUntilClosed() {
        if (currentPopupIndex < 0) {
            return;
        }
        Display display = Display.getCurrent();
        while (currentPopupIndex >= 0) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        ImageRepository.loadImages(display);
        String title = "This is the title that never ends, never ends!";
        String text = "This is a very long message with lots of information and stuff you really should read.  Are you still reading? Good, because reading <a href=\"http://moo.com\">stimulates</a> the mind and grows hair on your chest.\n\n  Unless you are a girl, then it makes you want to read more.  It's an endless cycle of reading that will never end.  Cursed is the long text that is in this test and may it fillevery last line of the shell until there is no more.";
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new MessageSlideShell(display, 2, "Simple. . . . . . . . . . . . . . . . . . .", "Simple", (String)null);
        new MessageSlideShell(display, 2, title + "1", text, "Details: " + text);
        new MessageSlideShell(display, 2, "ShortTitle2", "ShortText", "Details");
        MessageSlideShell.waitUntilClosed();
        new MessageSlideShell(display, 2, "ShortTitle3", "ShortText", (String)null);
        for (int x = 0; x < 10; ++x) {
            text = text + "\n\n\n\n\n\n\n\nWow";
        }
        new MessageSlideShell(display, 2, title + "4", text, "Details");
        new MessageSlideShell(display, 1, title + "5", text, (String)null);
        MessageSlideShell.waitUntilClosed();
    }

    static /* synthetic */ Label access$1500(MessageSlideShell x0) {
        return x0.lblCloseIn;
    }

    static /* synthetic */ Button access$1700(MessageSlideShell x0) {
        return x0.btnHideAll;
    }

    static /* synthetic */ Composite access$1800(MessageSlideShell x0) {
        return x0.cShell;
    }

    static /* synthetic */ void access$1900(MessageSlideShell x0, int x1) {
        x0.setButtonNextText(x1);
    }

    private class PopupParams {
        int iconID;
        String title;
        String text;
        String details;
        long addedOn;

        public PopupParams(int iconID, String title, String text, String details) {
            this.iconID = iconID;
            this.title = title;
            this.text = text;
            this.details = details;
            this.addedOn = System.currentTimeMillis();
        }
    }

    private class SlideShell {
        private int STEP = 8;
        private int PAUSE = 30;
        private Shell shell;
        private Rectangle shellBounds = null;
        private Rectangle endBounds;
        private final int direction;
        private final boolean slideIn;

        public SlideShell(Shell shell, int direction, Rectangle endBounds) {
            this.shell = shell;
            this.endBounds = endBounds;
            this.slideIn = true;
            this.direction = direction;
            if (shell == null || shell.isDisposed()) {
                return;
            }
            Display display = shell.getDisplay();
            display.syncExec(new Runnable(this, shell, MessageSlideShell.this, endBounds){
                private final /* synthetic */ Shell val$shell;
                private final /* synthetic */ MessageSlideShell val$this$0;
                private final /* synthetic */ Rectangle val$endBounds;
                private final /* synthetic */ SlideShell this$1;
                {
                    this.this$1 = this$1;
                    this.val$shell = val$shell;
                    this.val$this$0 = val$this$0;
                    this.val$endBounds = val$endBounds;
                }

                public void run() {
                    Rectangle displayBounds;
                    if (this.val$shell == null || this.val$shell.isDisposed()) {
                        return;
                    }
                    switch (SlideShell.access$2000(this.this$1)) {
                        default: 
                    }
                    try {
                        displayBounds = this.val$shell.getMonitor().getBounds();
                    }
                    catch (Throwable t) {
                        displayBounds = this.val$shell.getDisplay().getBounds();
                    }
                    SlideShell.access$2102(this.this$1, new Rectangle(this.val$endBounds.x, displayBounds.y + displayBounds.height, this.val$endBounds.width, 0));
                    this.val$shell.setBounds(SlideShell.access$2100(this.this$1));
                    this.val$shell.setVisible(true);
                }
            });
        }

        public SlideShell(Shell shell, int direction) {
            this.shell = shell;
            this.slideIn = false;
            this.direction = direction;
        }

        private boolean canContinue() {
            if (this.shell == null || this.shell.isDisposed()) {
                return false;
            }
            if (this.shellBounds == null) {
                return true;
            }
            if (this.slideIn) {
                if (this.direction == 128) {
                    return this.shellBounds.y > this.endBounds.y;
                }
            } else if (this.direction == 131072) {
                return this.shellBounds.width > 10;
            }
            return false;
        }

        public void run() {
            while (this.canContinue()) {
                long lStartedAt = System.currentTimeMillis();
                this.shell.getDisplay().syncExec((Runnable)new AERunnable(this){
                    private final /* synthetic */ SlideShell this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (SlideShell.access$2200(this.this$1) == null || SlideShell.access$2200(this.this$1).isDisposed()) {
                            return;
                        }
                        if (SlideShell.access$2100(this.this$1) == null) {
                            SlideShell.access$2102(this.this$1, SlideShell.access$2200(this.this$1).getBounds());
                        }
                        if (SlideShell.access$2300(this.this$1)) {
                            switch (SlideShell.access$2000(this.this$1)) {
                                case 128: {
                                    int delta = Math.min(SlideShell.access$2400((SlideShell)this.this$1).height - SlideShell.access$2100((SlideShell)this.this$1).height, SlideShell.access$2500(this.this$1));
                                    SlideShell.access$2100((SlideShell)this.this$1).height += delta;
                                    delta = Math.min(SlideShell.access$2100((SlideShell)this.this$1).y - SlideShell.access$2400((SlideShell)this.this$1).y, SlideShell.access$2500(this.this$1));
                                    SlideShell.access$2100((SlideShell)this.this$1).y -= delta;
                                    break;
                                }
                            }
                        } else {
                            switch (SlideShell.access$2000(this.this$1)) {
                                case 131072: {
                                    int delta = Math.min(SlideShell.access$2100((SlideShell)this.this$1).width, SlideShell.access$2500(this.this$1));
                                    SlideShell.access$2100((SlideShell)this.this$1).width -= delta;
                                    SlideShell.access$2100((SlideShell)this.this$1).x += delta;
                                    if (SlideShell.access$2100((SlideShell)this.this$1).width != 0) break;
                                    SlideShell.access$2200(this.this$1).dispose();
                                    return;
                                }
                            }
                        }
                        SlideShell.access$2200(this.this$1).setBounds(SlideShell.access$2100(this.this$1));
                        SlideShell.access$2200(this.this$1).update();
                    }
                });
                try {
                    long lDrawTime = System.currentTimeMillis() - lStartedAt;
                    long lSleepTime = (long)this.PAUSE - lDrawTime;
                    if (lSleepTime < 15L) {
                        double d = ((double)lDrawTime + 15.0) / (double)this.PAUSE;
                        this.PAUSE = (int)((double)this.PAUSE * d);
                        this.STEP = (int)((double)this.STEP * d);
                        lSleepTime = 15L;
                    }
                    Thread.sleep(lSleepTime);
                }
                catch (Exception exception) {}
            }
        }

        static /* synthetic */ int access$2000(SlideShell x0) {
            return x0.direction;
        }

        static /* synthetic */ Rectangle access$2102(SlideShell x0, Rectangle x1) {
            x0.shellBounds = x1;
            return x0.shellBounds;
        }

        static /* synthetic */ Rectangle access$2100(SlideShell x0) {
            return x0.shellBounds;
        }

        static /* synthetic */ Shell access$2200(SlideShell x0) {
            return x0.shell;
        }

        static /* synthetic */ boolean access$2300(SlideShell x0) {
            return x0.slideIn;
        }

        static /* synthetic */ Rectangle access$2400(SlideShell x0) {
            return x0.endBounds;
        }

        static /* synthetic */ int access$2500(SlideShell x0) {
            return x0.STEP;
        }
    }
}

