/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.UISWTAWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginConfigImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.impl.TableColumnImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;

public class UISWTInstanceImpl
implements UIInstanceFactory,
UISWTInstance,
UIManagerEventListener {
    private AzureusCore core;
    private Map awt_view_map = new WeakHashMap();
    private Map config_view_map = new WeakHashMap();
    private Map views = new HashMap();
    private Map plugin_map = new WeakHashMap();
    private boolean bUIAttaching;
    private final UIFunctionsSWT uiFunctions;

    public UISWTInstanceImpl(AzureusCore _core) {
        this.core = _core;
        this.uiFunctions = (UIFunctionsSWT)UIFunctionsManager.getUIFunctions();
        try {
            UIManager ui_manager = this.core.getPluginManager().getDefaultPluginInterface().getUIManager();
            ui_manager.addUIEventListener(this);
            this.bUIAttaching = true;
            ui_manager.attachUI(this);
            this.bUIAttaching = false;
        }
        catch (UIException e) {
            Debug.printStackTrace(e);
        }
    }

    public UIInstance getInstance(PluginInterface plugin_interface) {
        UIInstance instance = (UIInstance)this.plugin_map.get(plugin_interface);
        if (instance == null) {
            instance = new instanceWrapper(plugin_interface, this);
            this.plugin_map.put(plugin_interface, instance);
        }
        return instance;
    }

    public boolean eventOccurred(UIManagerEvent event2) {
        boolean done = true;
        final Object data = event2.getData();
        switch (event2.getType()) {
            case 1: {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        String[] params = (String[])data;
                        new TextViewerWindow(params[0], params[1], params[2]);
                    }
                });
                break;
            }
            case 2: {
                TorrentOpener.openTorrent(((File)data).toString());
                break;
            }
            case 3: {
                Display display = SWTThread.getInstance().getDisplay();
                display.syncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        Object[] params = (Object[])data;
                        URL target = (URL)params[0];
                        URL referrer = (URL)params[1];
                        boolean auto_download = (Boolean)params[2];
                        if (!COConfigurationManager.getBooleanParameter("add_torrents_silently")) {
                            UISWTInstanceImpl.this.uiFunctions.bringToFront();
                        }
                        if (auto_download) {
                            Shell shell = UISWTInstanceImpl.this.uiFunctions.getMainShell();
                            if (shell != null) {
                                new FileDownloadWindow(UISWTInstanceImpl.this.core, shell, target.toString(), referrer == null ? null : referrer.toString());
                            }
                        } else {
                            TorrentOpener.openTorrent(target.toString());
                        }
                    }
                });
                break;
            }
            case 4: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                BasicPluginViewImpl view = new BasicPluginViewImpl(model);
                this.addView("Main", sViewID, view);
                break;
            }
            case 7: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                this.removeViews("Main", sViewID);
                break;
            }
            case 5: {
                if (!(data instanceof BasicPluginConfigModel)) break;
                BasicPluginConfigModel model = (BasicPluginConfigModel)data;
                BasicPluginConfigImpl view = new BasicPluginConfigImpl(model);
                this.config_view_map.put(model, view);
                model.getPluginInterface().addConfigSection(view);
                break;
            }
            case 8: {
                BasicPluginConfigModel model;
                BasicPluginConfigImpl view;
                if (!(data instanceof BasicPluginConfigModel) || (view = (BasicPluginConfigImpl)this.config_view_map.get(model = (BasicPluginConfigModel)data)) == null) break;
                model.getPluginInterface().removeConfigSection(view);
                break;
            }
            case 6: {
                ClipboardCopy.copyToClipBoard((String)data);
                break;
            }
            case 9: {
                Program.launch((String)((URL)data).toExternalForm());
                break;
            }
            case 10: {
                String[] args = (String[])data;
                event2.setResult(new TableColumnImpl(args[0], args[1]));
                break;
            }
            case 11: {
                TableColumn _col = (TableColumn)data;
                if (_col instanceof TableColumnImpl) {
                    TableColumnManager.getInstance().addColumn((TableColumnImpl)_col);
                    break;
                }
                throw new UIRuntimeException("TableManager.addColumn(..) can only add columns created by createColumn(..)");
            }
            case 12: {
                TableContextMenuItem item = (TableContextMenuItem)data;
                TableContextMenuManager.getInstance().addContextMenuItem(item);
                break;
            }
            case 13: {
                event2.setResult(new Boolean(false));
                if (!(data instanceof String)) break;
                event2.setResult(new Boolean(this.uiFunctions.showConfig((String)data)));
                break;
            }
            default: {
                done = false;
            }
        }
        return done;
    }

    public Display getDisplay() {
        return SWTThread.getInstance().getDisplay();
    }

    public Image loadImage(String resource) {
        throw new RuntimeException("plugin specific instance required");
    }

    protected Image loadImage(PluginInterface pi, String res) {
        InputStream is = pi.getPluginClassLoader().getResourceAsStream(res);
        if (is != null) {
            ImageData imageData = new ImageData(is);
            return new Image((Device)this.getDisplay(), imageData);
        }
        return null;
    }

    public UISWTGraphic createGraphic(Image img) {
        return new UISWTGraphicImpl(img);
    }

    public void addView(UISWTPluginView view, boolean bAutoOpen) {
        try {
            this.uiFunctions.addPluginView(view);
            if (bAutoOpen) {
                this.uiFunctions.openPluginView(view);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeView(UISWTPluginView view) {
        try {
            this.uiFunctions.removePluginView(view);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addView(final UISWTAWTPluginView view, boolean auto_open) {
        UISWTPluginView v = new UISWTPluginView(){
            Composite composite;
            Component component;
            boolean first_paint = true;

            public String getPluginViewName() {
                return view.getPluginViewName();
            }

            public String getFullTitle() {
                return view.getPluginViewName();
            }

            public void initialize(Composite _composite) {
                this.first_paint = true;
                this.composite = _composite;
                Composite frame_composite = new Composite(this.composite, 0x1000000);
                GridData data = new GridData(1808);
                frame_composite.setLayoutData((Object)data);
                Frame f = SWT_AWT.new_Frame((Composite)frame_composite);
                BorderLayout layout = new BorderLayout(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void layoutContainer(Container parent) {
                        try {
                            super.layoutContainer(parent);
                            Object var3_2 = null;
                            if (this.this$1.first_paint) {
                                this.this$1.first_paint = false;
                                3.access$200(this.this$1).open(this.this$1.component);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (this.this$1.first_paint) {
                                this.this$1.first_paint = false;
                                3.access$200(this.this$1).open(this.this$1.component);
                            }
                            throw throwable;
                        }
                    }
                };
                Panel pan = new Panel(layout);
                f.add(pan);
                this.component = view.create();
                pan.add(this.component, "Center");
            }

            public Composite getComposite() {
                return this.composite;
            }

            public void delete() {
                super.delete();
                view.delete(this.component);
            }

            static /* synthetic */ UISWTAWTPluginView access$200(3 x0) {
                return x0.view;
            }
        };
        this.awt_view_map.put(view, v);
        this.addView(v, auto_open);
    }

    public void removeView(UISWTAWTPluginView view) {
        UISWTPluginView v = (UISWTPluginView)this.awt_view_map.remove(view);
        if (v != null) {
            this.removeView(v);
        }
    }

    public void detach() throws UIException {
        throw new UIException("not supported");
    }

    public void addView(String sParentID, final String sViewID, final UISWTViewEventListener l) {
        HashMap<String, UISWTViewEventListener> subViews = (HashMap<String, UISWTViewEventListener>)this.views.get(sParentID);
        if (subViews == null) {
            subViews = new HashMap<String, UISWTViewEventListener>();
            this.views.put(sParentID, subViews);
        }
        subViews.put(sViewID, l);
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        UISWTInstanceImpl.this.uiFunctions.addPluginView(sViewID, l);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void removeViews(String sParentID, final String sViewID) {
        Map subViews = (Map)this.views.get(sParentID);
        if (subViews == null) {
            return;
        }
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            uiFunctions.removePluginView(sViewID);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        subViews.remove(sViewID);
    }

    public void openMainView(final String sViewID, final UISWTViewEventListener l, final Object dataSource) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.openPluginView("Main", sViewID, l, dataSource, !UISWTInstanceImpl.this.bUIAttaching);
                }
            }
        });
    }

    public UISWTView[] getOpenViews(String sParentID) {
        if (sParentID.equals("Main")) {
            try {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    return uiFunctions.getPluginViews();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new UISWTView[0];
    }

    public int promptUser(String title, String text, String[] options, int defaultOption) {
        return MessageBoxShell.open(this.uiFunctions.getMainShell(), title, text, options, defaultOption);
    }

    public Map getViewListeners(String sParentID) {
        return (Map)this.views.get(sParentID);
    }

    protected static class instanceWrapper
    implements UISWTInstance {
        private PluginInterface pi;
        private UISWTInstanceImpl delegate;

        protected instanceWrapper(PluginInterface _pi, UISWTInstanceImpl _delegate) {
            this.pi = _pi;
            this.delegate = _delegate;
        }

        public void detach() throws UIException {
            this.delegate.detach();
        }

        public Display getDisplay() {
            return this.delegate.getDisplay();
        }

        public Image loadImage(String resource) {
            return this.delegate.loadImage(this.pi, resource);
        }

        public UISWTGraphic createGraphic(Image img) {
            return this.delegate.createGraphic(img);
        }

        public void addView(String sParentID, String sViewID, UISWTViewEventListener l) {
            this.delegate.addView(sParentID, sViewID, l);
        }

        public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource) {
            this.delegate.openMainView(sViewID, l, dataSource);
        }

        public void removeViews(String sParentID, String sViewID) {
            this.delegate.removeViews(sParentID, sViewID);
        }

        public UISWTView[] getOpenViews(String sParentID) {
            return this.delegate.getOpenViews(sParentID);
        }

        public void addView(UISWTPluginView view, boolean autoOpen) {
            this.delegate.addView(view, autoOpen);
        }

        public void removeView(UISWTPluginView view) {
            this.delegate.removeView(view);
        }

        public void addView(UISWTAWTPluginView view, boolean auto_open) {
            this.delegate.addView(view, auto_open);
        }

        public void removeView(UISWTAWTPluginView view) {
            this.delegate.removeView(view);
        }

        public int promptUser(String title, String text, String[] options, int defaultOption) {
            return this.delegate.promptUser(title, text, options, defaultOption);
        }
    }
}

