/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.update.UpdateProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;

public class MainStatusBar {
    private static final String STATUS_ICON_WARN = "sb_warning";
    private AEMonitor this_mon = new AEMonitor("MainStatusBar");
    private ArrayList update_stack = new ArrayList();
    private UpdateWindow updateWindow;
    private Composite statusBar;
    private Composite statusArea;
    private StackLayout layoutStatusArea;
    private CLabel statusText;
    private String statusTextKey = "";
    private String statusImageKey = null;
    private Composite statusUpdate;
    private Label statusUpdateLabel;
    private ProgressBar statusUpdateProgressBar;
    private CLabel ipBlocked;
    private CLabel srStatus;
    private CLabel natStatus;
    private CLabel dhtStatus;
    private CLabel statusDown;
    private CLabel statusUp;
    private Display display;
    private long last_sr_ratio = -1L;
    private int last_sr_status = -1;
    private int lastNATstatus = -1;
    private int lastDHTstatus = -1;
    private long lastDHTcount = -1L;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private OverallStats overall_stats = StatsFactory.getStats();
    private ConnectionManager connection_manager;
    private DHTPlugin dhtPlugin;
    private GlobalManager globalManager;
    private AzureusCore azureusCore;
    private UIFunctions uiFunctions;

    public MainStatusBar() {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        this.connection_manager = pm.getDefaultPluginInterface().getConnectionManager();
        PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi != null) {
            this.dhtPlugin = (DHTPlugin)dht_pi.getPlugin();
        }
    }

    public Composite initStatusBar(final AzureusCore core, final GlobalManager globalManager, Display display, final Composite parent) {
        this.display = display;
        this.globalManager = globalManager;
        this.azureusCore = core;
        this.uiFunctions = UIFunctionsManager.getUIFunctions();
        int borderFlag = 32;
        this.statusBar = new Composite(parent, 0);
        GridLayout layout_status = new GridLayout();
        layout_status.numColumns = 7;
        layout_status.horizontalSpacing = 0;
        layout_status.verticalSpacing = 0;
        layout_status.marginHeight = 0;
        if (Constants.isOSX) {
            try {
                layout_status.marginRight = 15;
            }
            catch (NoSuchFieldError e) {
                layout_status.marginWidth = 15;
            }
        } else {
            layout_status.marginWidth = 0;
        }
        this.statusBar.setLayout((Layout)layout_status);
        this.statusArea = new Composite(this.statusBar, 0);
        GridData gridData = new GridData(1808);
        this.statusArea.setLayoutData((Object)gridData);
        this.layoutStatusArea = new StackLayout();
        this.statusArea.setLayout((Layout)this.layoutStatusArea);
        this.statusText = new CLabel(this.statusArea, 32);
        gridData = new GridData(784);
        this.statusText.setLayoutData((Object)gridData);
        Image image = ImageRepository.getImage(STATUS_ICON_WARN);
        int imageHeight = image == null ? 20 : image.getBounds().height;
        GC gc = new GC((Drawable)this.statusText);
        int height = Math.max(imageHeight, gc.getFontMetrics().getHeight()) + 6;
        gc.dispose();
        FormData formData = new FormData();
        formData.height = height;
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.statusBar.setLayoutData((Object)formData);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (MainStatusBar.this.updateWindow != null) {
                    MainStatusBar.this.updateWindow.show();
                }
            }
        };
        this.statusText.addListener(4, listener);
        this.statusText.addListener(8, listener);
        this.statusUpdate = new Composite(this.statusArea, 0);
        gridData = new GridData(784);
        this.statusUpdate.setLayoutData((Object)gridData);
        GridLayout layoutStatusUpdate = new GridLayout(2, false);
        layoutStatusUpdate.marginHeight = 0;
        layoutStatusUpdate.marginWidth = 0;
        this.statusUpdate.setLayout((Layout)layoutStatusUpdate);
        this.statusUpdateLabel = new Label(this.statusUpdate, 0);
        gridData = new GridData(256);
        this.statusUpdateLabel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.statusText.checking");
        Messages.setLanguageText((Widget)this.statusUpdateLabel, "MainWindow.status.update.tooltip");
        this.statusUpdateLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MainStatusBar.this.showUpdateProgressWindow();
            }
        });
        int progressFlag = Constants.isOSX ? 2 : 256;
        this.statusUpdateProgressBar = new ProgressBar(this.statusUpdate, progressFlag);
        gridData = new GridData(1808);
        this.statusUpdateProgressBar.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.statusUpdateProgressBar, "MainWindow.status.update.tooltip");
        this.statusUpdateProgressBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MainStatusBar.this.showUpdateProgressWindow();
            }
        });
        this.layoutStatusArea.topControl = this.statusText;
        this.statusBar.layout();
        this.srStatus = new CLabelPadding(this.statusBar, 32);
        this.srStatus.setText(MessageText.getString("SpeedView.stats.ratio"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show SR", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.srStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.natStatus = new CLabelPadding(this.statusBar, 32);
        this.natStatus.setText("");
        COConfigurationManager.addAndFireParameterListener("Status Area Show NAT", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.natStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.dhtStatus = new CLabelPadding(this.statusBar, 32);
        this.dhtStatus.setText("");
        this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show DDB", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.dhtStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName, true));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.ipBlocked = new CLabelPadding(this.statusBar, 32);
        this.ipBlocked.setText("{} IPs:");
        Messages.setLanguageText((Widget)this.ipBlocked, "MainWindow.IPs.tooltip");
        this.ipBlocked.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                BlockedIpsWindow.showBlockedIps(MainStatusBar.this.azureusCore, parent.getShell());
            }
        });
        this.statusDown = new CLabelPadding(this.statusBar, 32);
        this.statusDown.setImage(ImageRepository.getImage("down"));
        this.statusDown.setText("n/a");
        Messages.setLanguageText((Widget)this.statusDown, "MainWindow.status.updowndetails.tooltip");
        Listener lStats = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.showStats();
            }
        };
        this.statusUp = new CLabelPadding(this.statusBar, 32);
        this.statusUp.setImage(ImageRepository.getImage("up"));
        this.statusUp.setText("n/a");
        Messages.setLanguageText((Widget)this.statusUp, "MainWindow.status.updowndetails.tooltip");
        this.statusDown.addListener(8, lStats);
        this.statusUp.addListener(8, lStats);
        Listener lDHT = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.showStatsDHT();
            }
        };
        this.dhtStatus.addListener(8, lDHT);
        Listener lSR = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.showStatsTransfers();
                OverallStats stats = StatsFactory.getStats();
                long ratio = 1000L * stats.getUploadedBytes() / (stats.getDownloadedBytes() + 1L);
                if (ratio < 900L) {
                    Utils.openURL("http://azureus.aelitis.com/wiki/index.php/Share_Ratio");
                }
            }
        };
        this.srStatus.addListener(8, lSR);
        Listener lNAT = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.showConfig("server");
                if (MainStatusBar.this.azureusCore.getPluginManager().getDefaultPluginInterface().getConnectionManager().getNATStatus() != 1) {
                    Utils.openURL("http://azureus.aelitis.com/wiki/index.php/NAT_problem");
                }
            }
        };
        this.natStatus.addListener(8, lNAT);
        final Menu menuUpSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
        menuUpSpeed.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                SelectableSpeedMenu.generateMenuItems(menuUpSpeed, core, globalManager, true);
            }
        });
        this.statusUp.setMenu(menuUpSpeed);
        final Menu menuDownSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
        menuDownSpeed.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                SelectableSpeedMenu.generateMenuItems(menuDownSpeed, core, globalManager, false);
            }
        });
        this.statusDown.setMenu(menuDownSpeed);
        this.addUpdateListener();
        return this.statusBar;
    }

    public void setStatusText(String keyedSentence) {
        this.statusTextKey = keyedSentence == null ? "" : keyedSentence;
        this.statusImageKey = null;
        if (this.statusTextKey.length() == 0) {
            if (Constants.isCVSVersion()) {
                this.statusTextKey = "MainWindow.status.unofficialversion (2.5.0.0)";
                this.statusImageKey = STATUS_ICON_WARN;
            } else if (!Constants.isOSX) {
                this.statusTextKey = "Azureus 2.5.0.0";
            }
        }
        this.updateStatusText();
    }

    public void updateStatusText() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final String text = this.updateWindow != null ? "MainWindow.updateavail" : this.statusTextKey;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainStatusBar.this.statusText != null && !MainStatusBar.this.statusText.isDisposed()) {
                    MainStatusBar.this.statusText.setText(MessageText.getStringForSentence(text));
                    MainStatusBar.this.statusText.setImage(MainStatusBar.this.statusImageKey == null ? null : ImageRepository.getImage(MainStatusBar.this.statusImageKey));
                }
            }
        });
    }

    public void refreshStatusText() {
        if (this.statusText != null && !this.statusText.isDisposed()) {
            this.statusText.update();
        }
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        this.updateWindow = updateWindow;
        if (updateWindow != null) {
            this.statusText.setCursor(Cursors.handCursor);
            this.statusText.setForeground(Colors.colorWarning);
            this.updateStatusText();
        } else {
            this.statusText.setCursor(null);
            this.statusText.setForeground(null);
            this.updateStatusText();
        }
    }

    private void addUpdateListener() {
        this.azureusCore.getPluginManager().getDefaultPluginInterface().getUpdateManager().addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                new updateStatusChanger(instance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showUpdateProgressWindow() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] instances = new UpdateCheckInstance[this.update_stack.size()];
            for (int i = 0; i < instances.length; ++i) {
                instances[i] = ((updateStatusChanger)this.update_stack.get(i)).getInstance();
            }
            UpdateProgressWindow.show(instances, this.statusBar.getShell());
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void refreshStatusBar() {
        String seeding_only;
        DHT[] dhts;
        int nat_status;
        if (this.ipBlocked.isDisposed()) {
            return;
        }
        IpFilter ip_filter = this.azureusCore.getIpFilterManager().getIPFilter();
        this.ipBlocked.setText("IPs: " + this.numberFormat.format(ip_filter.getNbRanges()) + " - " + this.numberFormat.format(ip_filter.getNbIpsBlockedAndLoggable()) + "/" + this.numberFormat.format(ip_filter.getNbBannedIps()) + "/" + this.numberFormat.format(this.azureusCore.getIpFilterManager().getBadIps().getNbBadIps()));
        this.ipBlocked.setToolTipText(DisplayFormatters.formatDateShort(ip_filter.getLastUpdateTime()));
        long ratio = 1000L * this.overall_stats.getUploadedBytes() / (this.overall_stats.getDownloadedBytes() + 1L);
        int sr_status = ratio < 500L ? 0 : (ratio < 900L ? 1 : 2);
        if (sr_status != this.last_sr_status) {
            String imgID;
            switch (sr_status) {
                case 2: {
                    imgID = "greenled";
                    break;
                }
                case 1: {
                    imgID = "yellowled";
                    break;
                }
                default: {
                    imgID = "redled";
                }
            }
            this.srStatus.setImage(ImageRepository.getImage(imgID));
            this.last_sr_status = sr_status;
        }
        if (ratio != this.last_sr_ratio) {
            String tooltipID;
            switch (sr_status) {
                case 2: {
                    tooltipID = "MainWindow.sr.status.tooltip.ok";
                    break;
                }
                case 1: {
                    tooltipID = "MainWindow.sr.status.tooltip.poor";
                    break;
                }
                default: {
                    tooltipID = "MainWindow.sr.status.tooltip.bad";
                }
            }
            String ratio_str = "";
            String partial = "" + ratio % 1000L;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            ratio_str = ratio / 1000L + "." + partial;
            this.srStatus.setToolTipText(MessageText.getString(tooltipID, new String[]{ratio_str}));
            this.last_sr_ratio = ratio;
        }
        if (this.lastNATstatus != (nat_status = this.connection_manager.getNATStatus())) {
            String statusID;
            String tooltipID;
            String imgID;
            switch (nat_status) {
                case 0: {
                    imgID = "grayled";
                    tooltipID = "MainWindow.nat.status.tooltip.unknown";
                    statusID = "MainWindow.nat.status.unknown";
                    break;
                }
                case 1: {
                    imgID = "greenled";
                    tooltipID = "MainWindow.nat.status.tooltip.ok";
                    statusID = "MainWindow.nat.status.ok";
                    break;
                }
                case 2: {
                    imgID = "yellowled";
                    tooltipID = "MainWindow.nat.status.tooltip.probok";
                    statusID = "MainWindow.nat.status.probok";
                    break;
                }
                default: {
                    imgID = "redled";
                    tooltipID = "MainWindow.nat.status.tooltip.bad";
                    statusID = "MainWindow.nat.status.bad";
                }
            }
            this.natStatus.setImage(ImageRepository.getImage(imgID));
            this.natStatus.setToolTipText(MessageText.getString(tooltipID));
            this.natStatus.setText(MessageText.getString(statusID));
            this.lastNATstatus = nat_status;
        }
        int dht_status = this.dhtPlugin == null ? 1 : this.dhtPlugin.getStatus();
        long dht_count = -1L;
        if (dht_status == 3 && (dhts = this.dhtPlugin.getDHTs()).length > 0 && dhts[0].getTransport().isReachable()) {
            dht_count = dhts[0].getControl().getStats().getEstimatedDHTSize();
        }
        if (this.lastDHTstatus != dht_status || this.lastDHTcount != dht_count) {
            switch (dht_status) {
                case 3: {
                    if (dht_count > 100000L) {
                        this.dhtStatus.setImage(ImageRepository.getImage("greenled"));
                        this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
                        this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.users").replaceAll("%1", this.numberFormat.format(dht_count)));
                        break;
                    }
                    this.dhtStatus.setImage(ImageRepository.getImage("yellowled"));
                    this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.unreachabletooltip"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.unreachable"));
                    break;
                }
                case 1: {
                    this.dhtStatus.setImage(ImageRepository.getImage("grayled"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.disabled"));
                    break;
                }
                case 2: {
                    this.dhtStatus.setImage(ImageRepository.getImage("yellowled"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.initializing"));
                    break;
                }
                case 4: {
                    this.dhtStatus.setImage(ImageRepository.getImage("redled"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.failed"));
                    break;
                }
                default: {
                    this.dhtStatus.setImage(null);
                }
            }
            this.lastDHTstatus = dht_status;
            this.lastDHTcount = dht_count;
        }
        int dl_limit = NetworkManager.getMaxDownloadRateBPS() / 1024;
        GlobalManagerStats stats = this.globalManager.getStats();
        this.statusDown.setText((dl_limit == 0 ? "" : "[" + dl_limit + "K] ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataReceiveRate(), stats.getProtocolReceiveRate()));
        boolean auto_up = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.getActiveAutoUploadParameter(this.globalManager)) && TransferSpeedValidator.isAutoUploadAvailable(this.azureusCore);
        int ul_limit_norm = NetworkManager.getMaxUploadRateBPSNormal() / 1024;
        if (NetworkManager.isSeedingOnlyUploadRate()) {
            int ul_limit_seed = NetworkManager.getMaxUploadRateBPSSeedingOnly() / 1024;
            if (ul_limit_seed == 0) {
                seeding_only = "+\u221eK";
            } else {
                int diff = ul_limit_seed - ul_limit_norm;
                seeding_only = (diff >= 0 ? "+" : "") + diff + "K";
            }
        } else {
            seeding_only = "";
        }
        this.statusUp.setText((ul_limit_norm == 0 ? "" : "[" + ul_limit_norm + "K" + seeding_only + "]") + (auto_up ? "* " : " ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataSendRate(), stats.getProtocolSendRate()));
        this.statusBar.layout();
    }

    public void setDebugInfo(String string) {
        if (!this.statusText.isDisposed()) {
            this.statusText.setToolTipText(string);
        }
    }

    static /* synthetic */ ProgressBar access$1500(MainStatusBar x0) {
        return x0.statusUpdateProgressBar;
    }

    static /* synthetic */ Composite access$1600(MainStatusBar x0) {
        return x0.statusArea;
    }

    static /* synthetic */ Label access$1700(MainStatusBar x0) {
        return x0.statusUpdateLabel;
    }

    static /* synthetic */ StackLayout access$1800(MainStatusBar x0) {
        return x0.layoutStatusArea;
    }

    static /* synthetic */ Composite access$1900(MainStatusBar x0) {
        return x0.statusUpdate;
    }

    private class CLabelPadding
    extends CLabel {
        private int lastWidth;
        private long widthSetOn;
        private static final int KEEPWIDTHFOR_MS = 30000;

        public CLabelPadding(Composite parent, int style) {
            super(parent, style | 0x1000000);
            this.lastWidth = 0;
            this.widthSetOn = 0L;
            GridData gridData = new GridData(80);
            this.setLayoutData(gridData);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (!this.isVisible()) {
                return new Point(0, 0);
            }
            Point pt = super.computeSize(wHint, hHint, changed);
            pt.x += 4;
            long now = System.currentTimeMillis();
            if (this.lastWidth > pt.x && now - this.widthSetOn < 30000L) {
                pt.x = this.lastWidth;
            } else {
                if (this.lastWidth != pt.x) {
                    this.lastWidth = pt.x;
                }
                this.widthSetOn = now;
            }
            return pt;
        }
    }

    protected class updateStatusChanger {
        UpdateCheckInstance instance;
        int check_num = 0;
        boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected updateStatusChanger(UpdateCheckInstance _instance) {
            this.instance = _instance;
            try {
                MainStatusBar.this.this_mon.enter();
                MainStatusBar.this.update_stack.add(this);
                this.instance.addListener(new UpdateCheckInstanceListener(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancelled(UpdateCheckInstance instance) {
                        updateStatusChanger.access$1100(this.this$1);
                    }

                    public void complete(UpdateCheckInstance instance) {
                        updateStatusChanger.access$1100(this.this$1);
                    }
                });
                UpdateChecker[] checkers = this.instance.getCheckers();
                UpdateCheckerListener listener = new UpdateCheckerListener(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void cancelled(UpdateChecker checker) {
                    }

                    public void completed(UpdateChecker checker) {
                        updateStatusChanger.access$1200(this.this$1);
                    }

                    public void failed(UpdateChecker checker) {
                        updateStatusChanger.access$1200(this.this$1);
                    }
                };
                for (int i = 0; i < checkers.length; ++i) {
                    checkers[i].addListener(listener);
                }
                this.activate();
            }
            finally {
                MainStatusBar.this.this_mon.exit();
            }
        }

        protected UpdateCheckInstance getInstance() {
            return this.instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            try {
                MainStatusBar.this.this_mon.enter();
                this.active = true;
                this.switchStatusToUpdate();
                this.setNbChecks(this.instance.getCheckers().length);
            }
            finally {
                MainStatusBar.this.this_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivate() {
            try {
                MainStatusBar.this.this_mon.enter();
                this.active = false;
                for (int i = 0; i < MainStatusBar.this.update_stack.size(); ++i) {
                    if (MainStatusBar.this.update_stack.get(i) != this) continue;
                    MainStatusBar.this.update_stack.remove(i);
                    break;
                }
                if (MainStatusBar.this.update_stack.size() == 0) {
                    this.switchStatusToText();
                } else {
                    ((updateStatusChanger)MainStatusBar.this.update_stack.get(MainStatusBar.this.update_stack.size() - 1)).activate();
                }
            }
            finally {
                MainStatusBar.this.this_mon.exit();
            }
        }

        private void setNbChecks(int nbChecks) {
            if (MainStatusBar.this.display != null && !MainStatusBar.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this, nbChecks){
                    private final /* synthetic */ int val$nbChecks;
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                        this.val$nbChecks = val$nbChecks;
                    }

                    public void runSupport() {
                        if (MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)) == null || MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).isDisposed()) {
                            return;
                        }
                        MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).setMinimum(0);
                        MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).setMaximum(this.val$nbChecks);
                        MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).setSelection(this.this$1.check_num);
                    }
                });
            }
        }

        private void setNextCheck() {
            if (MainStatusBar.this.display != null && !MainStatusBar.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)) == null || MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).isDisposed()) {
                            return;
                        }
                        ++this.this$1.check_num;
                        if (this.this$1.active) {
                            MainStatusBar.access$1500(updateStatusChanger.access$1400(this.this$1)).setSelection(this.this$1.check_num);
                        }
                    }
                });
            }
        }

        private void switchStatusToUpdate() {
            if (MainStatusBar.this.display != null && !MainStatusBar.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)) == null || MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)).isDisposed()) {
                            return;
                        }
                        String name = this.this$1.instance.getName();
                        if (MessageText.keyExists(name)) {
                            name = MessageText.getString(name);
                        }
                        MainStatusBar.access$1700(updateStatusChanger.access$1400(this.this$1)).setText(name);
                        MainStatusBar.access$1800((MainStatusBar)updateStatusChanger.access$1400((updateStatusChanger)this.this$1)).topControl = MainStatusBar.access$1900(updateStatusChanger.access$1400(this.this$1));
                        MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)).layout();
                    }
                });
            }
        }

        private void switchStatusToText() {
            if (MainStatusBar.this.display != null && !MainStatusBar.this.display.isDisposed()) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ updateStatusChanger this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        if (MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)) == null || MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)).isDisposed()) {
                            return;
                        }
                        MainStatusBar.access$1800((MainStatusBar)updateStatusChanger.access$1400((updateStatusChanger)this.this$1)).topControl = MainStatusBar.access$700(updateStatusChanger.access$1400(this.this$1));
                        MainStatusBar.access$1600(updateStatusChanger.access$1400(this.this$1)).layout();
                    }
                });
            }
        }

        static /* synthetic */ void access$1100(updateStatusChanger x0) {
            x0.deactivate();
        }

        static /* synthetic */ void access$1200(updateStatusChanger x0) {
            x0.setNextCheck();
        }

        static /* synthetic */ MainStatusBar access$1400(updateStatusChanger x0) {
            return x0.MainStatusBar.this;
        }
    }
}

