/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;

public class Legend {
    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys) {
        Layout layout = panel.getLayout();
        GridData layoutData = null;
        if (layout instanceof GridLayout) {
            layoutData = new GridData(768);
        }
        return Legend.createLegendComposite(panel, blockColors, keys, layoutData);
    }

    public static Composite createLegendComposite(final Composite panel, final Color[] blockColors, final String[] keys, Object layoutData) {
        final ConfigurationManager config = ConfigurationManager.getInstance();
        if (blockColors.length != keys.length) {
            return null;
        }
        final ArrayList<Color> disposeList = new ArrayList<Color>();
        final Color[] defaultColors = new Color[blockColors.length];
        System.arraycopy(blockColors, 0, defaultColors, 0, blockColors.length);
        Composite legend = new Composite(panel, 0);
        if (layoutData != null) {
            legend.setLayoutData(layoutData);
        }
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.spacing = 0;
        legend.setLayout((Layout)layout);
        for (int i = 0; i < blockColors.length; ++i) {
            int r = config.getIntParameter(keys[i] + ".red", -1);
            if (r >= 0) {
                int g = config.getIntParameter(keys[i] + ".green");
                int b = config.getIntParameter(keys[i] + ".blue");
                Color color = new Color((Device)panel.getDisplay(), r, g, b);
                disposeList.add(color);
                blockColors[i] = color;
            }
            Composite colorSet = new Composite(legend, 0);
            colorSet.setLayout((Layout)new RowLayout(256));
            final Canvas cColor = new Canvas(colorSet, 2048);
            cColor.setData("Index", (Object)new Integer(i));
            cColor.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    int i = (Integer)cColor.getData("Index");
                    e.gc.setBackground(blockColors[i]);
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                }
            });
            cColor.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Integer iIndex = (Integer)cColor.getData("Index");
                    if (iIndex == null) {
                        return;
                    }
                    int index = iIndex;
                    if (e.button == 1) {
                        ColorDialog cd = new ColorDialog(panel.getShell());
                        cd.setRGB(blockColors[index].getRGB());
                        RGB rgb = cd.open();
                        if (rgb != null) {
                            config.setRGBParameter(keys[index], rgb.red, rgb.green, rgb.blue);
                        }
                    } else {
                        config.removeRGBParameter(keys[index]);
                    }
                }
            });
            Label lblDesc = new Label(colorSet, 0);
            Messages.setLanguageText((Widget)lblDesc, keys[i]);
            RowData data = new RowData();
            data.width = 20;
            data.height = lblDesc.computeSize((int)-1, (int)-1).y - 3;
            cColor.setLayoutData((Object)data);
            config.addParameterListener(keys[i], new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    for (int j = 0; j < keys.length; ++j) {
                        if (!keys[j].equals(parameterName)) continue;
                        int index = j;
                        int r = config.getIntParameter(keys[j] + ".red", -1);
                        if (r >= 0) {
                            int g = config.getIntParameter(keys[j] + ".green");
                            int b = config.getIntParameter(keys[j] + ".blue");
                            RGB rgb = new RGB(r, g, b);
                            if (!blockColors[j].isDisposed() && rgb.equals((Object)blockColors[j].getRGB())) continue;
                            Utils.execSWTThread(new AERunnable(this, rgb, index){
                                private final /* synthetic */ RGB val$rgb;
                                private final /* synthetic */ int val$index;
                                private final /* synthetic */ 3 this$0;
                                {
                                    this.this$0 = this$0;
                                    this.val$rgb = val$rgb;
                                    this.val$index = val$index;
                                }

                                public void runSupport() {
                                    if (3.access$000(this.this$0) == null || 3.access$000(this.this$0).isDisposed()) {
                                        return;
                                    }
                                    Color color = new Color((Device)3.access$000(this.this$0).getDisplay(), this.val$rgb);
                                    3.access$100(this.this$0).add(color);
                                    3.access$200(this.this$0)[this.val$index] = color;
                                    3.access$300(this.this$0).redraw();
                                }
                            });
                            continue;
                        }
                        if (!blockColors[j].isDisposed() && blockColors[j].equals((Object)defaultColors[j])) continue;
                        Utils.execSWTThread(new AERunnable(this, index){
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ 3 this$0;
                            {
                                this.this$0 = this$0;
                                this.val$index = val$index;
                            }

                            public void runSupport() {
                                if (3.access$000(this.this$0) == null || 3.access$000(this.this$0).isDisposed()) {
                                    return;
                                }
                                3.access$200(this.this$0)[this.val$index] = 3.access$400(this.this$0)[this.val$index];
                                3.access$300(this.this$0).redraw();
                            }
                        });
                    }
                }

                static /* synthetic */ Composite access$000(3 x0) {
                    return x0.panel;
                }

                static /* synthetic */ ArrayList access$100(3 x0) {
                    return x0.disposeList;
                }

                static /* synthetic */ Color[] access$200(3 x0) {
                    return x0.blockColors;
                }

                static /* synthetic */ Canvas access$300(3 x0) {
                    return x0.cColor;
                }

                static /* synthetic */ Color[] access$400(3 x0) {
                    return x0.defaultColors;
                }
            });
        }
        legend.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (int i = 0; i < blockColors.length; ++i) {
                    blockColors[i] = defaultColors[i];
                }
                Utils.disposeSWTObjects(disposeList);
            }
        });
        return legend;
    }
}

