/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPChecker;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerFactory;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleUtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.MonitorImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.SemaphoreImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESecurityManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSFeedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentFactoryImpl;

public class UtilitiesImpl
implements Utilities {
    private static InetAddress last_public_ip_address;
    private static long last_public_ip_address_time;
    private AzureusCore core;
    private PluginInterface pi;
    private static ThreadLocal tls;

    public UtilitiesImpl(AzureusCore _core, PluginInterface _pi) {
        this.core = _core;
        this.pi = _pi;
    }

    public String getAzureusUserDir() {
        String res = SystemProperties.getUserPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public String getAzureusProgramDir() {
        String res = SystemProperties.getApplicationPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public boolean isWindows() {
        return Constants.isWindows;
    }

    public boolean isLinux() {
        return Constants.isLinux;
    }

    public boolean isUnix() {
        return Constants.isUnix;
    }

    public boolean isFreeBSD() {
        return Constants.isFreeBSD;
    }

    public boolean isSolaris() {
        return Constants.isSolaris;
    }

    public boolean isOSX() {
        return Constants.isOSX;
    }

    public boolean isCVSVersion() {
        return Constants.isCVSVersion();
    }

    public InputStream getImageAsStream(String image_name) {
        return UtilitiesImpl.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/" + image_name);
    }

    public Semaphore getSemaphore() {
        return new SemaphoreImpl(this.pi);
    }

    public Monitor getMonitor() {
        return new MonitorImpl(this.pi);
    }

    public ByteBuffer allocateDirectByteBuffer(int size) {
        return DirectByteBufferPool.getBuffer((byte)1, size).getBuffer((byte)1);
    }

    public void freeDirectByteBuffer(ByteBuffer buffer) {
    }

    public PooledByteBuffer allocatePooledByteBuffer(int length) {
        return new PooledByteBufferImpl(length);
    }

    public PooledByteBuffer allocatePooledByteBuffer(byte[] data) {
        return new PooledByteBufferImpl(data);
    }

    public PooledByteBuffer allocatePooledByteBuffer(Map map) throws IOException {
        return new PooledByteBufferImpl(BEncoder.encode(map));
    }

    public Formatters getFormatters() {
        return new FormattersImpl();
    }

    public LocaleUtilities getLocaleUtilities() {
        return new LocaleUtilitiesImpl(this.pi);
    }

    public UTTimer createTimer(String name) {
        return new UTTimerImpl(this.pi, name, false);
    }

    public UTTimer createTimer(String name, boolean lightweight) {
        return new UTTimerImpl(this.pi, name, true);
    }

    public void createThread(String name, final Runnable target) {
        AEThread t = new AEThread(this.pi.getPluginName() + "::" + name){

            public void runSupport() {
                UtilitiesImpl.setPluginThreadContext(UtilitiesImpl.this.pi);
                target.run();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void createProcess(String command_line) throws PluginException {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(command_line, false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            try {
                Runtime.getRuntime().exec(command_line);
            }
            catch (Throwable f) {
                throw new PluginException("Failed to create process", f);
            }
        }
    }

    public ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    public ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    public SESecurityManager getSecurityManager() {
        return new SESecurityManagerImpl(this.core);
    }

    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory() {
        return new SimpleXMLParserDocumentFactoryImpl();
    }

    public RSSFeed getRSSFeed(URL feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return this.getRSSFeed(this.getResourceDownloaderFactory().create(feed_location));
    }

    public RSSFeed getRSSFeed(ResourceDownloader feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return new RSSFeedImpl(this, feed_location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getPublicAddress() {
        InetAddress res;
        long now;
        block13: {
            now = SystemTime.getCurrentTime();
            if (now < last_public_ip_address_time) {
                last_public_ip_address_time = now;
            } else if (last_public_ip_address != null && now - last_public_ip_address_time < 900000L) {
                return last_public_ip_address;
            }
            res = null;
            try {
                String vc_ip = VersionCheckClient.getSingleton().getExternalIpAddress(false);
                if (vc_ip != null && vc_ip.length() > 0) {
                    res = InetAddress.getByName(vc_ip);
                    break block13;
                }
                ExternalIPChecker checker = ExternalIPCheckerFactory.create();
                ExternalIPCheckerService[] services = checker.getServices();
                final String[] ip = new String[]{null};
                for (int i = 0; i < services.length && ip[0] == null; ++i) {
                    ExternalIPCheckerService service = services[i];
                    if (service.supportsCheck()) {
                        final AESemaphore sem = new AESemaphore("Utilities:getExtIP");
                        ExternalIPCheckerServiceListener listener = new ExternalIPCheckerServiceListener(){

                            public void checkComplete(ExternalIPCheckerService _service, String _ip) {
                                ip[0] = _ip;
                                sem.release();
                            }

                            public void checkFailed(ExternalIPCheckerService _service, String _reason) {
                                sem.release();
                            }

                            public void reportProgress(ExternalIPCheckerService _service, String _message) {
                            }
                        };
                        services[i].addListener(listener);
                        try {
                            services[i].initiateCheck(60000L);
                            sem.reserve(60000L);
                        }
                        finally {
                            services[i].removeListener(listener);
                        }
                    }
                    if (ip[0] == null) continue;
                    res = InetAddress.getByName(ip[0]);
                    break;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (res == null) {
            res = last_public_ip_address;
        } else {
            last_public_ip_address = res;
            last_public_ip_address_time = now;
        }
        return res;
    }

    public String reverseDNSLookup(InetAddress address) {
        final AESemaphore sem = new AESemaphore("Utilities:reverseDNS");
        final String[] res = new String[]{null};
        IPToHostNameResolver.addResolverRequest(address.getHostAddress(), new IPToHostNameResolverListener(){

            public void IPResolutionComplete(String result, boolean succeeded) {
                if (succeeded) {
                    res[0] = result;
                }
                sem.release();
            }
        });
        sem.reserve(60000L);
        return res[0];
    }

    public long getCurrentSystemTime() {
        return SystemTime.getCurrentTime();
    }

    public ByteArrayWrapper createWrapper(byte[] data) {
        return new HashWrapper(data);
    }

    public AggregatedDispatcher createAggregatedDispatcher(final long idle_dispatch_time, final long max_queue_size) {
        return new AggregatedDispatcher(){
            private AggregatedList list;
            {
                this.list = UtilitiesImpl.this.createAggregatedList(new AggregatedListAcceptor(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void accept(List l) {
                        for (int i = 0; i < l.size(); ++i) {
                            try {
                                ((Runnable)l.get(i)).run();
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }, idle_dispatch_time, max_queue_size);
            }

            public void add(Runnable runnable) {
                this.list.add(runnable);
            }

            public Runnable remove(Runnable runnable) {
                return (Runnable)this.list.remove(runnable);
            }

            public void destroy() {
                this.list.destroy();
            }
        };
    }

    public AggregatedList createAggregatedList(final AggregatedListAcceptor acceptor, final long idle_dispatch_time, final long max_queue_size) {
        return new AggregatedList(){
            AEMonitor timer_mon = new AEMonitor("aggregatedList");
            Timer timer = new Timer("AggregatedList");
            TimerEvent event;
            List list = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(Object obj) {
                List dispatch_now = null;
                try {
                    this.timer_mon.enter();
                    if (max_queue_size > 0L && max_queue_size == (long)this.list.size()) {
                        dispatch_now = this.list;
                        this.list = new ArrayList();
                    }
                    this.list.add(obj);
                    long now = SystemTime.getCurrentTime();
                    if (this.event != null) {
                        this.event.cancel();
                    }
                    this.event = this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void perform(TimerEvent event2) {
                            this.this$1.dispatch();
                        }
                    });
                }
                finally {
                    this.timer_mon.exit();
                }
                if (dispatch_now != null) {
                    this.dispatch(dispatch_now);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object remove(Object obj) {
                Object res = null;
                try {
                    this.timer_mon.enter();
                    Object object = res = this.list.remove(obj) ? obj : null;
                    if (res != null) {
                        long now = SystemTime.getCurrentTime();
                        if (this.event != null) {
                            this.event.cancel();
                        }
                        this.event = this.list.size() == 0 ? null : this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(this){
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void perform(TimerEvent event2) {
                                this.this$1.dispatch();
                            }
                        });
                    }
                }
                finally {
                    this.timer_mon.exit();
                }
                return res;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void dispatch() {
                List dispatch_list;
                try {
                    this.timer_mon.enter();
                    dispatch_list = this.list;
                    this.list = new ArrayList();
                }
                finally {
                    this.timer_mon.exit();
                }
                this.dispatch(dispatch_list);
            }

            protected void dispatch(List l) {
                if (l.size() > 0) {
                    try {
                        acceptor.accept(l);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }

            public void destroy() {
                this.dispatch();
                this.timer.destroy();
            }
        };
    }

    public static final void setPluginThreadContext(PluginInterface pi) {
        tls.set(pi);
    }

    public static PluginInterface getPluginThreadContext() {
        return (PluginInterface)tls.get();
    }

    public Map readResilientBEncodedFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup);
    }

    public void writeResilientBEncodedFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup);
    }

    public int compareVersions(String v1, String v2) {
        return Constants.compareVersions(v1, v2);
    }

    static {
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }
}

