/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class FilePluginInstallerImpl
implements FilePluginInstaller,
InstallablePluginImpl {
    protected PluginInstallerImpl installer;
    protected File file;
    protected String id;
    protected String version;
    protected boolean is_jar;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FilePluginInstallerImpl(PluginInstallerImpl _installer, File _file) throws PluginException {
        block26: {
            block24: {
                super();
                this.installer = _installer;
                this.file = _file;
                name = this.file.getName();
                pos = name.lastIndexOf(".");
                ok = false;
                if (pos == -1) break block26;
                prefix = name.substring(0, pos);
                suffix = name.substring(pos + 1);
                if (!suffix.toLowerCase().equals("jar") && !suffix.toLowerCase().equals("zip")) break block26;
                this.is_jar = suffix.toLowerCase().equals("jar");
                properties = null;
                zis = null;
                try {
                    zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                    while (properties == null && (entry = zis.getNextEntry()) != null) {
                        zip_name = entry.getName().toLowerCase();
                        if (zip_name.equals("plugin.properties") || zip_name.endsWith("/plugin.properties")) {
                            properties = new Properties();
                            properties.load(zis);
                            continue;
                        }
                        if (!zip_name.endsWith(".jar")) continue;
                        zis2 = new ZipInputStream(zis);
                        while (properties == null && (entry2 = zis2.getNextEntry()) != null) {
                            zip_name2 = entry2.getName().toLowerCase();
                            if (!zip_name2.equals("plugin.properties")) continue;
                            properties = new Properties();
                            properties.load(zis2);
                        }
                    }
                    var16_20 = null;
                    if (zis == null) break block24;
                    ** GOTO lbl47
                }
                catch (Throwable e) {
                    throw new PluginException("Failed to read plugin file", e);
                }
                {
                    catch (Throwable var15_24) {
                        var16_21 = null;
                        if (zis == null) throw var15_24;
                        try {
                            zis.close();
                            throw var15_24;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        throw var15_24;
                    }
lbl47:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [3 : 318->326)] { 
lbl48:
                    // 1 sources

                    zis.close();
lbl50:
                    // 1 sources

                    catch (Throwable e) {}
                    Debug.printStackTrace(e);
                }
            }
            if (properties == null) {
                pos = prefix.lastIndexOf("_");
                if (pos != -1) {
                    this.id = prefix.substring(0, pos);
                    this.version = prefix.substring(pos + 1);
                    pi = this.installer.getPluginManager().getPluginInterfaceByID(this.id);
                    v0 = ok = pi != null && (pi.getPluginDirectoryName() == null || pi.getPluginDirectoryName().length() == 0);
                }
                if (!ok) {
                    throw new PluginException("Mandatory file 'plugin.properties' not found in plugin file");
                }
            } else {
                this.id = properties.getProperty("plugin.id");
                this.version = properties.getProperty("plugin.version");
            }
            if (this.id == null) {
                plugin_class = properties.getProperty("plugin.class");
                if (plugin_class == null && (plugin_classes = properties.getProperty("plugin.classes")) != null) {
                    semi_pos = plugin_classes.indexOf(";");
                    plugin_class = semi_pos == -1 ? plugin_classes : plugin_classes.substring(0, semi_pos);
                }
                if (plugin_class != null) {
                    try {
                        pi = this.installer.getPluginManager().getPluginInterfaceByClass(plugin_class);
                        if (pi != null) {
                            this.id = pi.getPluginID();
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
            }
            if ((pos = prefix.lastIndexOf("_")) != -1) {
                this.id = this.id == null ? prefix.substring(0, pos) : this.id;
                try {
                    loader = SFPluginDetailsLoaderFactory.getSingleton();
                    ids = loader.getPluginIDs();
                    for (i = 0; i < ids.length; ++i) {
                        if (!ids[i].equalsIgnoreCase(this.id)) continue;
                        this.id = ids[i];
                        break;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                this.version = this.version == null ? prefix.substring(pos + 1) : this.version;
            }
            ok = this.id != null && this.version != null;
        }
        if (ok != false) return;
        throw new PluginException("Invalid plugin file name: must be of form <pluginid>_<version>.[jar|zip]");
    }

    public File getFile() {
        return this.file;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return "";
    }

    public String getDescription() {
        return this.file.toString();
    }

    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public void addUpdate(UpdateCheckInstance inst, final PluginUpdatePlugin plugin_update_plugin, Plugin plugin, final PluginInterface plugin_interface) {
        inst.addUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return FilePluginInstallerImpl.this.file.getName();
            }

            public int getMaximumCheckTime() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void checkForUpdate(UpdateChecker checker) {
                try {
                    ResourceDownloader rd = plugin_interface.getUtilities().getResourceDownloaderFactory().create(FilePluginInstallerImpl.this.file);
                    plugin_update_plugin.addUpdate(plugin_interface, checker, this.getName(), new String[]{"Installation from file: " + FilePluginInstallerImpl.this.file.toString()}, FilePluginInstallerImpl.this.version, rd, FilePluginInstallerImpl.this.is_jar, plugin_interface.isUnloadable() ? 1 : 2, false);
                }
                finally {
                    checker.completed();
                }
            }
        }, false);
    }
}

