/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginLauncherImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.update.UpdaterUpdateChecker;
import org.gudy.azureus2.update.UpdaterUtils;

public class PluginInitializer
implements GlobalManagerListener,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String INTERNAL_PLUGIN_ID = "<internal>";
    private String[][] builtin_plugins = new String[][]{{"Start/Stop Rules", "com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin", "azbpstartstoprules", "", "true"}, {"Torrent Removal Rules", "com.aelitis.azureus.plugins.removerules.DownloadRemoveRulesPlugin", "azbpremovalrules", "", "true"}, {"Share Hoster", "com.aelitis.azureus.plugins.sharing.hoster.ShareHosterPlugin", "azbpsharehoster", "ShareHoster", "true"}, {"Plugin Update Checker", "org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin", "azbppluginupdate", "PluginUpdate", "true"}, {"Client ID", "com.aelitis.azureus.plugins.clientid.ClientIDPlugin", "azbpclientid", "Client ID", "true"}, {"UPnP", "com.aelitis.azureus.plugins.upnp.UPnPPlugin", "azbpupnp", "UPnP", "true"}, {"DHT", "com.aelitis.azureus.plugins.dht.DHTPlugin", "azbpdht", "DHT", "true"}, {"DHT Tracker", "com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin", "azbpdhdtracker", "DHT Tracker", "true"}, {"Magnet URI Handler", "com.aelitis.azureus.plugins.magnet.MagnetPlugin", "azbpmagnet", "Magnet URI Handler", "true"}, {"Core Update Checker", "org.gudy.azureus2.update.CoreUpdateChecker", "azbpcoreupdater", "CoreUpdater", "true"}, {"Core Patch Checker", "org.gudy.azureus2.update.CorePatchChecker", "azbpcorepatcher", "CorePatcher", "true"}, {"Platform Checker", "org.gudy.azureus2.platform.win32.PlatformManagerUpdateChecker", "azplatform2", "azplatform2", "true"}, {"External Seed", "com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin", "azextseed", "azextseed", "true"}, {"External Seed", "com.aelitis.azureus.plugins.tracker.local.LocalTrackerPlugin", "azlocaltracker", "azlocaltracker", "true"}};
    private static String[][] default_version_details = new String[][]{{"org.gudy.azureus2.ui.webplugin.remoteui.servlet.RemoteUIServlet", "webui", "Swing Web Interface", "1.2.3"}, {"org.ludo.plugins.azureus.AzureusIpFilterExporter", "safepeer", "SafePeer", "1.2.4"}, {"org.gudy.azureus2.countrylocator.Plugin", "CountryLocator", "Country Locator", "1.0"}, {"org.gudy.azureus2.ui.webplugin.remoteui.xml.server.XMLHTTPServerPlugin", "xml_http_if", "XML over HTTP", "1.0"}, {"org.cneclipse.bdcc.BDCCPlugin", "bdcc", "BitTorrent IRC Bot", "2.1"}, {"org.cneclipse.multiport.MultiPortPlugin", "multi-ports", "Mutli-Port Trackers", "1.0"}, {"i18nPlugin.i18nPlugin", "i18nAZ", "i18nAZ", "1.0"}, {"info.baeker.markus.plugins.azureus.RSSImport", "RSSImport", "RSS Importer", "1.0"}};
    private static PluginInitializer singleton;
    private static AEMonitor class_mon;
    private static List registration_queue;
    private AzureusCoreOperation core_operation;
    private AzureusCore azureus_core;
    private PluginInterfaceImpl default_plugin;
    private PluginManager plugin_manager;
    private ClassLoader root_class_loader = this.getClass().getClassLoader();
    private List loaded_pi_list = new ArrayList();
    private List plugins = new ArrayList();
    private List plugin_interfaces = new ArrayList();
    private boolean initialisation_complete;
    static /* synthetic */ Class class$org$gudy$azureus2$pluginsimpl$local$PluginInitializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInitializer getSingleton(AzureusCore azureus_core, AzureusCoreOperation core_operation) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginInitializer(azureus_core, core_operation);
            }
            PluginInitializer pluginInitializer = singleton;
            return pluginInitializer;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Class _class) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(_class);
            } else {
                try {
                    singleton.initializePluginFromClass(_class, INTERNAL_PLUGIN_ID, _class.getName());
                }
                catch (PluginException pluginException) {
                    // empty catch block
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Plugin plugin, String id) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(new Object[]{plugin, id});
            } else {
                try {
                    singleton.initializePluginFromInstance(plugin, id, plugin.getClass().getName());
                }
                catch (PluginException pluginException) {
                    // empty catch block
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected PluginInitializer(AzureusCore _azureus_core, AzureusCoreOperation _core_operation) {
        this.azureus_core = _azureus_core;
        AEDiagnostics.addEvidenceGenerator(this);
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent comp) {
                if (comp instanceof GlobalManager) {
                    GlobalManager gm = (GlobalManager)comp;
                    gm.addListener(PluginInitializer.this);
                }
            }
        });
        this.core_operation = _core_operation;
        UpdateManagerImpl.getSingleton(this.azureus_core);
        this.plugin_manager = PluginManagerImpl.getSingleton(this);
        UpdaterUtils.checkPlugin();
    }

    public List loadPlugins(AzureusCore core, boolean bSkipAlreadyLoaded) {
        int i;
        ArrayList pluginLoaded = new ArrayList();
        PluginManagerImpl.setStartDetails(core);
        this.getRootClassLoader();
        File user_dir = FileUtil.getUserFile("plugins");
        File app_dir = FileUtil.getApplicationFile("plugins");
        int user_plugins = 0;
        int app_plugins = 0;
        if (user_dir.exists() && user_dir.isDirectory()) {
            user_plugins = user_dir.listFiles().length;
        }
        if (app_dir.exists() && app_dir.isDirectory()) {
            app_plugins = app_dir.listFiles().length;
        }
        pluginLoaded.addAll(this.loadPluginsFromDir(user_dir, 0, user_plugins + app_plugins, bSkipAlreadyLoaded));
        if (!user_dir.equals(app_dir)) {
            pluginLoaded.addAll(this.loadPluginsFromDir(app_dir, user_plugins, user_plugins + app_plugins, bSkipAlreadyLoaded));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading built-in plugins"));
        }
        if (this.core_operation != null) {
            this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + MessageText.getString("ConfigView.pluginlist.column.type.builtIn"));
        }
        PluginManagerDefaults def = PluginManager.getDefaults();
        for (i = 0; i < this.builtin_plugins.length; ++i) {
            if (def.isDefaultPluginEnabled(this.builtin_plugins[i][0])) {
                try {
                    Class<?> cla = this.root_class_loader.loadClass(this.builtin_plugins[i][1]);
                    Method load_method = cla.getMethod("load", class$org$gudy$azureus2$plugins$PluginInterface == null ? PluginInitializer.class$("org.gudy.azureus2.plugins.PluginInterface") : class$org$gudy$azureus2$plugins$PluginInterface);
                    load_method.invoke(null, this.getDefaultInterfaceSupport());
                    Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[i][0] + "' ok"));
                }
                catch (NoSuchMethodException e) {
                }
                catch (Throwable e) {
                    if (!this.builtin_plugins[i][4].equalsIgnoreCase("true")) continue;
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(false, "Load of built in plugin '" + this.builtin_plugins[i][2] + "' fails", e));
                }
                continue;
            }
            if (!Logger.isEnabled()) continue;
            Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[i][2] + "' is disabled"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading dynamically registered plugins"));
        }
        for (i = 0; i < registration_queue.size(); ++i) {
            String id;
            Class<?> cla;
            Object entry = registration_queue.get(i);
            if (entry instanceof Class) {
                cla = (Class<?>)entry;
                id = cla.getName();
            } else {
                Object[] x = (Object[])entry;
                Plugin plugin = (Plugin)x[0];
                cla = plugin.getClass();
                id = (String)x[1];
            }
            try {
                Method load_method = cla.getMethod("load", class$org$gudy$azureus2$plugins$PluginInterface == null ? PluginInitializer.class$("org.gudy.azureus2.plugins.PluginInterface") : class$org$gudy$azureus2$plugins$PluginInterface);
                load_method.invoke(null, this.getDefaultInterfaceSupport());
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(false, "Load of dynamic plugin '" + id + "' fails", e));
            }
        }
        return pluginLoaded;
    }

    private void getRootClassLoader() {
        File user_dir = FileUtil.getUserFile("shared");
        this.getRootClassLoader(user_dir);
        File app_dir = FileUtil.getApplicationFile("shared");
        if (!user_dir.equals(app_dir)) {
            this.getRootClassLoader(app_dir);
        }
    }

    private void getRootClassLoader(File dir) {
        File[] files;
        if ((dir = new File(dir, "lib")).exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            files = PluginLauncherImpl.getHighestJarVersions(files, new String[]{null}, new String[]{null}, false);
            for (int i = 0; i < files.length; ++i) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Share class loader extended by " + files[i].toString()));
                }
                this.root_class_loader = PluginLauncherImpl.addFileToClassPath((class$org$gudy$azureus2$pluginsimpl$local$PluginInitializer == null ? PluginInitializer.class$("org.gudy.azureus2.pluginsimpl.local.PluginInitializer") : class$org$gudy$azureus2$pluginsimpl$local$PluginInitializer).getClassLoader(), this.root_class_loader, files[i]);
            }
        }
    }

    private List loadPluginsFromDir(File pluginDirectory, int plugin_offset, int plugin_total, boolean bSkipAlreadyLoaded) {
        ArrayList dirLoadedPIs = new ArrayList();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Plugin Directory is " + pluginDirectory));
        }
        if (!pluginDirectory.exists()) {
            pluginDirectory.mkdirs();
        }
        if (pluginDirectory.isDirectory()) {
            File[] pluginsDirectory = pluginDirectory.listFiles();
            for (int i = 0; i < pluginsDirectory.length; ++i) {
                if (pluginsDirectory[i].getName().equals("CVS")) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "Skipping plugin " + pluginsDirectory[i].getName()));
                    continue;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading plugin " + pluginsDirectory[i].getName()));
                }
                if (this.core_operation != null) {
                    this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + pluginsDirectory[i].getName());
                }
                try {
                    List loaded_pis = this.loadPluginFromDir(pluginsDirectory[i], bSkipAlreadyLoaded);
                    this.loaded_pi_list.add(loaded_pis);
                    dirLoadedPIs.addAll(loaded_pis);
                }
                catch (PluginException e) {
                    // empty catch block
                }
                if (this.core_operation == null) continue;
                this.core_operation.reportPercent(100 * (i + plugin_offset) / plugin_total);
            }
        }
        return dirLoadedPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadPluginFromDir(File directory, boolean bSkipAlreadyLoaded) throws PluginException {
        ArrayList<PluginInterfaceImpl> loaded_pis = new ArrayList<PluginInterfaceImpl>();
        ClassLoader plugin_class_loader = this.root_class_loader;
        if (!directory.isDirectory()) {
            return loaded_pis;
        }
        String pluginName = directory.getName();
        File[] pluginContents = directory.listFiles();
        if (pluginContents == null || pluginContents.length == 0) {
            return loaded_pis;
        }
        boolean looks_like_plugin = false;
        for (int i = 0; i < pluginContents.length; ++i) {
            String name = pluginContents[i].getName().toLowerCase();
            if (!name.endsWith(".jar") && !name.equals("plugin.properties")) continue;
            looks_like_plugin = true;
            break;
        }
        if (!looks_like_plugin) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Plugin directory '" + directory + "' has no plugin.properties " + "or .jar files, skipping"));
            }
            return loaded_pis;
        }
        String[] plugin_version = new String[]{null};
        String[] plugin_id = new String[]{null};
        pluginContents = PluginLauncherImpl.getHighestJarVersions(pluginContents, plugin_version, plugin_id, true);
        for (int i = 0; i < pluginContents.length; ++i) {
            String name;
            File jar_file = pluginContents[i];
            if (pluginContents.length > 1 && (name = jar_file.getName()).startsWith("i18nPlugin_")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "renaming '" + name + "' to conform with versioning system"));
                }
                jar_file.renameTo(new File(jar_file.getParent(), "i18nAZ_0.1.jar  "));
                continue;
            }
            plugin_class_loader = PluginLauncherImpl.addFileToClassPath(this.root_class_loader, plugin_class_loader, jar_file);
        }
        String plugin_class_string = null;
        try {
            int p1;
            String plugin_name_string;
            Properties props;
            block45: {
                props = new Properties();
                File properties_file = new File(directory.toString() + File.separator + "plugin.properties");
                try {
                    if (properties_file.exists()) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(properties_file);
                            props.load(fis);
                            break block45;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    if (plugin_class_loader instanceof URLClassLoader) {
                        URLClassLoader current = (URLClassLoader)plugin_class_loader;
                        URL url = current.findResource("plugin.properties");
                        if (url != null) {
                            URLConnection connection = url.openConnection();
                            InputStream is = connection.getInputStream();
                            props.load(is);
                            break block45;
                        }
                        throw new Exception("failed to load plugin.properties from jars");
                    }
                    throw new Exception("failed to load plugin.properties from dir or jars");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    String msg = "Can't read 'plugin.properties' for plugin '" + pluginName + "': file may be missing";
                    Logger.log(new LogAlert(false, 3, msg));
                    System.out.println(msg);
                    throw new PluginException(msg, e);
                }
            }
            plugin_class_string = (String)props.get("plugin.class");
            if (plugin_class_string == null) {
                plugin_class_string = (String)props.get("plugin.classes");
            }
            if ((plugin_name_string = (String)props.get("plugin.name")) == null) {
                plugin_name_string = (String)props.get("plugin.names");
            }
            int pos1 = 0;
            int pos2 = 0;
            do {
                String plugin_class;
                if ((p1 = plugin_class_string.indexOf(";", pos1)) == -1) {
                    plugin_class = plugin_class_string.substring(pos1).trim();
                } else {
                    plugin_class = plugin_class_string.substring(pos1, p1).trim();
                    pos1 = p1 + 1;
                }
                PluginInterfaceImpl existing_pi = this.getPluginFromClass(plugin_class);
                if (existing_pi != null) {
                    if (!bSkipAlreadyLoaded) {
                        File this_parent = directory.getParentFile();
                        File existing_parent = null;
                        if (existing_pi.getInitializerKey() instanceof File) {
                            existing_parent = ((File)existing_pi.getInitializerKey()).getParentFile();
                        }
                        if (this_parent.equals(FileUtil.getApplicationFile("plugins")) && existing_parent != null && existing_parent.equals(FileUtil.getUserFile("plugins"))) {
                            Logger.log(new LogEvent(LOGID, "Plugin '" + plugin_name_string + "/" + plugin_class + ": shared version overridden by user-specific one"));
                            return new ArrayList();
                        }
                        Logger.log(new LogAlert(false, 1, "Error loading '" + plugin_name_string + "', plugin class '" + plugin_class + "' is already loaded"));
                        continue;
                    }
                    break;
                }
                String plugin_name = null;
                if (plugin_name_string != null) {
                    int p2 = plugin_name_string.indexOf(";", pos2);
                    if (p2 == -1) {
                        plugin_name = plugin_name_string.substring(pos2).trim();
                    } else {
                        plugin_name = plugin_name_string.substring(pos2, p2).trim();
                        pos2 = p2 + 1;
                    }
                }
                Properties new_props = (Properties)props.clone();
                for (int j = 0; j < default_version_details.length; ++j) {
                    if (!plugin_class.equals(default_version_details[j][0])) continue;
                    if (new_props.get("plugin.id") == null) {
                        new_props.put("plugin.id", default_version_details[j][1]);
                    }
                    if (plugin_name == null) {
                        plugin_name = default_version_details[j][2];
                    }
                    if (new_props.get("plugin.version") != null) continue;
                    if (plugin_version[0] != null) {
                        new_props.put("plugin.version", plugin_version[0]);
                        continue;
                    }
                    new_props.put("plugin.version", default_version_details[j][3]);
                }
                new_props.put("plugin.class", plugin_class);
                if (plugin_name != null) {
                    new_props.put("plugin.name", plugin_name);
                }
                Throwable load_failure = null;
                String pid = plugin_id[0] == null ? directory.getName() : plugin_id[0];
                Plugin plugin = PluginLauncherImpl.getPreloadedPlugin(plugin_class);
                if (plugin == null) {
                    try {
                        Class<?> c = plugin_class_loader.loadClass(plugin_class);
                        plugin = (Plugin)c.newInstance();
                    }
                    catch (UnsupportedClassVersionError e) {
                        plugin = new FailedPlugin(plugin_name, directory.getAbsolutePath());
                        load_failure = new UnsupportedClassVersionError(e.getMessage());
                    }
                    catch (Throwable e) {
                        load_failure = e;
                        plugin = new FailedPlugin(plugin_name, directory.getAbsolutePath());
                    }
                } else {
                    plugin_class_loader = plugin.getClass().getClassLoader();
                }
                MessageText.integratePluginMessages((String)props.get("plugin.langfile"), plugin_class_loader);
                PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, directory, plugin_class_loader, directory.getName(), new_props, directory.getAbsolutePath(), pid, plugin_version[0]);
                boolean bEnabled = COConfigurationManager.getBooleanParameter("PluginInfo." + plugin_interface.getPluginID() + ".enabled", true);
                plugin_interface.setDisabled(!bEnabled);
                try {
                    Method load_method = plugin.getClass().getMethod("load", class$org$gudy$azureus2$plugins$PluginInterface == null ? PluginInitializer.class$("org.gudy.azureus2.plugins.PluginInterface") : class$org$gudy$azureus2$plugins$PluginInterface);
                    load_method.invoke((Object)plugin, plugin_interface);
                }
                catch (NoSuchMethodException e) {
                }
                catch (Throwable e) {
                    load_failure = e;
                }
                loaded_pis.add(plugin_interface);
                if (load_failure == null || pid.equals(UpdaterUpdateChecker.getPluginID())) continue;
                String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
                Logger.log(new LogAlert(false, msg, load_failure));
                System.out.println(msg + " : " + load_failure);
            } while (p1 != -1);
            return loaded_pis;
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            Debug.printStackTrace(e);
            String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialisePlugins() {
        int i;
        for (int i2 = 0; i2 < this.loaded_pi_list.size(); ++i2) {
            Object var5_8;
            try {
                block21: {
                    try {
                        List l = (List)this.loaded_pi_list.get(i2);
                        if (l.size() <= 0) break block21;
                        PluginInterfaceImpl plugin_interface = (PluginInterfaceImpl)l.get(0);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Initializing plugin '" + plugin_interface.getPluginName() + "'"));
                        }
                        if (this.core_operation != null) {
                            this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + plugin_interface.getPluginName());
                        }
                        this.initialisePlugin(l);
                        if (!Logger.isEnabled()) break block21;
                        Logger.log(new LogEvent(LOGID, "Initialization of plugin '" + plugin_interface.getPluginName() + "' complete"));
                    }
                    catch (PluginException e) {
                        var5_8 = null;
                        if (this.core_operation == null) continue;
                        this.core_operation.reportPercent(100 * (i2 + 1) / this.loaded_pi_list.size());
                        continue;
                    }
                }
                var5_8 = null;
                if (this.core_operation == null) continue;
                this.core_operation.reportPercent(100 * (i2 + 1) / this.loaded_pi_list.size());
                continue;
            }
            catch (Throwable throwable) {
                var5_8 = null;
                if (this.core_operation != null) {
                    this.core_operation.reportPercent(100 * (i2 + 1) / this.loaded_pi_list.size());
                }
                throw throwable;
            }
        }
        Logger.doRedirects();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing built-in plugins"));
        }
        PluginManagerDefaults def = PluginManager.getDefaults();
        for (i = 0; i < this.builtin_plugins.length; ++i) {
            if (def.isDefaultPluginEnabled(this.builtin_plugins[i][0])) {
                String id = this.builtin_plugins[i][2];
                String key = this.builtin_plugins[i][3];
                try {
                    Class<?> cla = this.root_class_loader.loadClass(this.builtin_plugins[i][1]);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Initializing built-in plugin '" + this.builtin_plugins[i][2] + "'"));
                    }
                    this.initializePluginFromClass(cla, id, key);
                    Logger.log(new LogEvent(LOGID, 1, "Initialization of built in plugin '" + this.builtin_plugins[i][2] + "' complete"));
                }
                catch (Throwable e) {
                    try {
                        this.initializePluginFromClass(class$org$gudy$azureus2$pluginsimpl$local$FailedPlugin == null ? PluginInitializer.class$("org.gudy.azureus2.pluginsimpl.local.FailedPlugin") : class$org$gudy$azureus2$pluginsimpl$local$FailedPlugin, id, key);
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                    if (!this.builtin_plugins[i][4].equalsIgnoreCase("true")) continue;
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(false, "Initialization of built in plugin '" + this.builtin_plugins[i][2] + "' fails", e));
                }
                continue;
            }
            if (!Logger.isEnabled()) continue;
            Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[i][2] + "' is disabled"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing dynamically registered plugins"));
        }
        for (i = 0; i < registration_queue.size(); ++i) {
            try {
                Object entry = registration_queue.get(i);
                if (entry instanceof Class) {
                    Class cla = (Class)entry;
                    singleton.initializePluginFromClass(cla, INTERNAL_PLUGIN_ID, cla.getName());
                    continue;
                }
                Object[] x = (Object[])entry;
                Plugin plugin = (Plugin)x[0];
                singleton.initializePluginFromInstance(plugin, (String)x[1], plugin.getClass().getName());
                continue;
            }
            catch (PluginException pluginException) {
                // empty catch block
            }
        }
        registration_queue.clear();
    }

    private void initialisePlugin(List l) throws PluginException {
        PluginException last_load_failure = null;
        for (int i = 0; i < l.size(); ++i) {
            PluginInterfaceImpl plugin_interface = (PluginInterfaceImpl)l.get(i);
            if (plugin_interface.isDisabled()) {
                this.plugin_interfaces.add(plugin_interface);
                continue;
            }
            Plugin plugin = plugin_interface.getPlugin();
            if (plugin_interface.isOperational()) continue;
            Throwable load_failure = null;
            try {
                UtilitiesImpl.setPluginThreadContext(plugin_interface);
                plugin.initialize(plugin_interface);
                if (!(plugin instanceof FailedPlugin)) {
                    plugin_interface.setOperational(true);
                }
            }
            catch (Throwable e) {
                load_failure = e;
            }
            this.plugins.add(plugin);
            this.plugin_interfaces.add(plugin_interface);
            if (load_failure == null) continue;
            Debug.printStackTrace(load_failure);
            String msg = "Error initializing plugin '" + plugin_interface.getPluginName() + "'";
            Logger.log(new LogAlert(false, msg, load_failure));
            System.out.println(msg + " : " + load_failure);
            last_load_failure = new PluginException(msg, load_failure);
        }
        if (last_load_failure != null) {
            throw last_load_failure;
        }
    }

    protected void initializePluginFromClass(Class plugin_class, String plugin_id, String plugin_config_key) throws PluginException {
        if (plugin_class != FailedPlugin.class && this.getPluginFromClass(plugin_class) != null) {
            Logger.log(new LogAlert(false, 1, "Error loading '" + plugin_id + "', plugin class '" + plugin_class.getName() + "' is already loaded"));
            return;
        }
        if (this.core_operation != null) {
            String plugin_name;
            if (plugin_config_key.length() == 0) {
                plugin_name = plugin_class.getName();
                int pos = plugin_name.lastIndexOf(".");
                if (pos != -1) {
                    plugin_name = plugin_name.substring(pos + 1);
                }
            } else {
                plugin_name = plugin_config_key;
            }
            this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + plugin_name);
        }
        try {
            Plugin plugin = (Plugin)plugin_class.newInstance();
            PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin_class, plugin_class.getClassLoader(), plugin_config_key, new Properties(), "", plugin_id, null);
            UtilitiesImpl.setPluginThreadContext(plugin_interface);
            try {
                Method load_method = plugin_class.getMethod("load", PluginInterface.class);
                load_method.invoke((Object)plugin, plugin_interface);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(false, "Load of built in plugin '" + plugin_id + "' fails", e));
            }
            plugin.initialize(plugin_interface);
            if (!(plugin instanceof FailedPlugin)) {
                plugin_interface.setOperational(true);
            }
            this.plugins.add(plugin);
            this.plugin_interfaces.add(plugin_interface);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin_class.getName() + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    protected void initializePluginFromInstance(Plugin plugin, String plugin_id, String plugin_config_key) throws PluginException {
        try {
            PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin.getClass(), plugin.getClass().getClassLoader(), plugin_config_key, new Properties(), "", plugin_id, null);
            UtilitiesImpl.setPluginThreadContext(plugin_interface);
            plugin.initialize(plugin_interface);
            if (!(plugin instanceof FailedPlugin)) {
                plugin_interface.setOperational(true);
            }
            this.plugins.add(plugin);
            this.plugin_interfaces.add(plugin_interface);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin.getClass().getName() + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    protected void unloadPlugin(PluginInterfaceImpl pi) {
        this.plugins.remove(pi.getPlugin());
        this.plugin_interfaces.remove(pi);
        for (int i = 0; i < this.loaded_pi_list.size(); ++i) {
            List l = (List)this.loaded_pi_list.get(i);
            if (!l.remove(pi)) continue;
            if (l.size() == 0) {
                this.loaded_pi_list.remove(i);
            }
            return;
        }
    }

    protected void reloadPlugin(PluginInterfaceImpl pi) throws PluginException {
        this.unloadPlugin(pi);
        Object key = pi.getInitializerKey();
        String config_key = pi.getPluginConfigKey();
        if (key instanceof File) {
            List pis = this.loadPluginFromDir((File)key, false);
            this.initialisePlugin(pis);
        } else {
            this.initializePluginFromClass((Class)key, pi.getPluginID(), config_key);
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected GlobalManager getGlobalManager() {
        return this.azureus_core.getGlobalManager();
    }

    public static PluginInterface getDefaultInterface() {
        return singleton.getDefaultInterfaceSupport();
    }

    protected PluginInterface getDefaultInterfaceSupport() {
        if (this.default_plugin == null) {
            this.default_plugin = new PluginInterfaceImpl(new Plugin(){

                public void initialize(PluginInterface pi) {
                }
            }, this, this.getClass(), this.getClass().getClassLoader(), "default", new Properties(), null, INTERNAL_PLUGIN_ID, null);
        }
        return this.default_plugin;
    }

    public void downloadManagerAdded(DownloadManager dm) {
    }

    public void downloadManagerRemoved(DownloadManager dm) {
    }

    public void destroyInitiated() {
        for (int i = 0; i < this.plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).closedownInitiated();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownInitiated();
        }
    }

    public void destroyed() {
        for (int i = 0; i < this.plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).closedownComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownComplete();
        }
    }

    public void seedingStatusChanged(boolean seeding_only_mode) {
    }

    protected void fireEventSupport(final int type, final Object value) {
        PluginEvent ev = new PluginEvent(){

            public int getType() {
                return type;
            }

            public Object getValue() {
                return value;
            }
        };
        for (int i = 0; i < this.plugin_interfaces.size(); ++i) {
            try {
                ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).firePluginEvent(ev);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (this.default_plugin != null) {
            this.default_plugin.firePluginEvent(ev);
        }
    }

    public static void fireEvent(int type) {
        singleton.fireEventSupport(type, null);
    }

    public static void fireEvent(int type, Object value) {
        singleton.fireEventSupport(type, value);
    }

    public void initialisationComplete() {
        this.initialisation_complete = true;
        UIManagerImpl.initialisationComplete();
        for (int i = 0; i < this.plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)this.plugin_interfaces.get(i)).initialisationComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.initialisationComplete();
        }
    }

    protected boolean isInitialisationComplete() {
        return this.initialisation_complete;
    }

    public static List getPluginInterfaces() {
        return singleton.getPluginInterfacesSupport();
    }

    protected List getPluginInterfacesSupport() {
        return this.plugin_interfaces;
    }

    protected PluginInterface[] getPlugins() {
        List pis = this.getPluginInterfacesSupport();
        PluginInterface[] res = new PluginInterface[pis.size()];
        pis.toArray(res);
        return res;
    }

    protected PluginManager getPluginManager() {
        return this.plugin_manager;
    }

    protected PluginInterfaceImpl getPluginFromClass(Class cla) {
        return this.getPluginFromClass(cla.getName());
    }

    protected PluginInterfaceImpl getPluginFromClass(String class_name) {
        int i;
        for (i = 0; i < this.plugin_interfaces.size(); ++i) {
            PluginInterfaceImpl pi = (PluginInterfaceImpl)this.plugin_interfaces.get(i);
            if (!pi.getPlugin().getClass().getName().equals(class_name)) continue;
            return pi;
        }
        for (i = 0; i < this.loaded_pi_list.size(); ++i) {
            List l = (List)this.loaded_pi_list.get(i);
            for (int j = 0; j < l.size(); ++j) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)l.get(j);
                if (!pi.getPlugin().getClass().getName().equals(class_name)) continue;
                return pi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Plugins");
        try {
            writer.indent();
            for (int i = 0; i < this.plugin_interfaces.size(); ++i) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)this.plugin_interfaces.get(i);
                pi.generateEvidence(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    static {
        class_mon = new AEMonitor("PluginInitializer");
        registration_queue = new ArrayList();
    }
}

