/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ThreadPool {
    private static final int IDLE_LINGER_TIME = 10000;
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    private static List busy_pools = new ArrayList();
    private static boolean busy_pool_timer_set = false;
    private static boolean debug_thread_pool;
    private static boolean debug_thread_pool_log_on;
    private static ThreadLocal tls;
    private String name;
    private int max_size;
    private int thread_name_index = 1;
    private long execution_limit;
    private Stack thread_pool;
    private List busy;
    private boolean queue_when_full;
    private List task_queue = new ArrayList();
    private AESemaphore thread_sem;
    private int thread_priority = 5;
    private boolean warn_when_full;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        for (int i = 0; i < pools.size(); ++i) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
        }
    }

    public ThreadPool(String _name, int _max_size) {
        this(_name, _max_size, false);
    }

    public ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        this.max_size = _max_size;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, _max_size);
        this.thread_pool = new Stack();
        this.busy = new ArrayList(_max_size);
    }

    public void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public int getMaxThreads() {
        return this.max_size;
    }

    public void setThreadPriority(int _priority) {
        this.thread_priority = _priority;
    }

    public void setExecutionLimit(long millis) {
        this.execution_limit = millis;
    }

    public threadPoolWorker run(AERunnable runnable) {
        return this.run(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable runnable, boolean high_priority) {
        threadPoolWorker allocated_worker;
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (runnable instanceof ThreadPoolTask) {
                    ThreadPoolTask task2 = (ThreadPoolTask)runnable;
                    task2.worker = recursive_worker;
                    try {
                        task2.taskStarted();
                        task2.run();
                    }
                    finally {
                        task2.taskCompleted();
                    }
                } else {
                    runnable.runSupport();
                }
                return recursive_worker;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                allocated_worker = null;
                this.checkWarning();
                if (high_priority) {
                    this.task_queue.add(0, runnable);
                } else {
                    this.task_queue.add(runnable);
                }
            } else {
                allocated_worker = this.thread_pool.isEmpty() ? new threadPoolWorker() : (threadPoolWorker)this.thread_pool.pop();
                if (runnable instanceof ThreadPoolTask) {
                    ((ThreadPoolTask)runnable).worker = allocated_worker;
                }
                allocated_worker.run(runnable);
            }
        }
        return this.queue_when_full ? null : allocated_worker;
    }

    protected void checkWarning() {
        if (this.warn_when_full) {
            Debug.out("Thread pool '" + this.getName() + "' is full");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] res = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable task2) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getRunningTasks() {
        ArrayList<AERunnable> runnables = new ArrayList<AERunnable>();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            Iterator it = this.busy.iterator();
            while (it.hasNext()) {
                threadPoolWorker worker = (threadPoolWorker)it.next();
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        AERunnable[] res = new AERunnable[runnables.size()];
        runnables.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (debug_thread_pool_log_on) {
                System.out.println("ThreadPool '" + this.getName() + "'/" + this.thread_name_index + ": max=" + this.max_size + ",sem=[" + this.thread_sem.getString() + "],pool=" + this.thread_pool.size() + ",busy=" + this.busy.size() + ",queue=" + this.task_queue.size());
            }
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < this.busy.size(); ++i) {
                threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed <= (long)(10000 * (x.warn_count + 1))) continue;
                x.warn_count++;
                if (this.execution_limit <= 0L || elapsed <= this.execution_limit) continue;
                AERunnable r = x.runnable;
                try {
                    if (r instanceof ThreadPoolTask) {
                        ((ThreadPoolTask)r).interruptTask();
                        continue;
                    }
                    x.worker_thread.interrupt();
                    continue;
                }
                catch (Throwable e) {
                    DebugLight.printStackTrace(e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ int access$900(ThreadPool x0) {
        return x0.thread_priority;
    }

    static /* synthetic */ ThreadLocal access$1000() {
        return tls;
    }

    static /* synthetic */ Stack access$1200(ThreadPool x0) {
        return x0.thread_pool;
    }

    static /* synthetic */ List access$1300(ThreadPool x0) {
        return x0.busy;
    }

    static /* synthetic */ List access$1400() {
        return busy_pools;
    }

    static /* synthetic */ boolean access$1500() {
        return busy_pool_timer_set;
    }

    static /* synthetic */ boolean access$1502(boolean x0) {
        busy_pool_timer_set = x0;
        return busy_pool_timer_set;
    }

    static /* synthetic */ boolean access$000() {
        return debug_thread_pool;
    }

    static /* synthetic */ List access$1800(ThreadPool x0) {
        return x0.task_queue;
    }

    static /* synthetic */ AESemaphore access$1900(ThreadPool x0) {
        return x0.thread_sem;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"debug.threadpool.log.enable", "debug.threadpool.debug.trace"}, new ParameterListener(){

            public void parameterChanged(String name) {
                debug_thread_pool = COConfigurationManager.getBooleanParameter("debug.threadpool.log.enable", false);
                debug_thread_pool_log_on = COConfigurationManager.getBooleanParameter("debug.threadpool.debug.trace", false);
            }
        });
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    public class threadPoolWorker {
        private final String worker_name;
        private final Thread worker_thread;
        private AESemaphore my_sem = new AESemaphore("TPWorker");
        private volatile AERunnable runnable;
        private long run_start_time;
        private int warn_count;
        private String state = "<none>";

        protected threadPoolWorker() {
            this.worker_name = ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]";
            this.worker_thread = new AEThread(this, this.worker_name, ThreadPool.this){
                private final /* synthetic */ ThreadPool val$this$0;
                private final /* synthetic */ threadPoolWorker this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void runSupport() {
                    if (ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)) != 5) {
                        this.setPriority(ThreadPool.access$900(threadPoolWorker.access$800(this.this$1)));
                    }
                    ThreadPool.access$1000().set(this.this$1);
                    time_to_die = false;
                    try {
                        while (true) {
                            try {
                                while (true) {
                                    if (!threadPoolWorker.access$1100(this.this$1).reserve(10000L)) {
                                        var2_4 = threadPoolWorker.access$800(this.this$1);
                                        synchronized (var2_4) {
                                            if (threadPoolWorker.access$400(this.this$1) == null) {
                                                time_to_die = true;
                                                ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 54, 55, 12, 30, 31] lbl16 : MonitorExitStatement: MONITOREXIT : var2_4
                                                var17_2 = null;
                                                if (time_to_die != false) return;
                                                var18_7 = threadPoolWorker.access$800(this.this$1);
                                                synchronized (var18_7) {
                                                    if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).contains(this.this$1)) {
                                                        Debug.out("Thread pool already contains worker!");
                                                    }
                                                    ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                                                }
                                                ThreadPool.access$1900(threadPoolWorker.access$800(this.this$1)).release();
                                                return;
                                            }
                                            continue;
                                        }
                                    }
                                    while (threadPoolWorker.access$400(this.this$1) != null) {
                                        try {
                                            block59: {
                                                try {
                                                    var2_4 = threadPoolWorker.access$800(this.this$1);
                                                    synchronized (var2_4) {
                                                        threadPoolWorker.access$202(this.this$1, SystemTime.getCurrentTime());
                                                        threadPoolWorker.access$302(this.this$1, 0);
                                                        ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).add(this.this$1);
                                                        if (ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).size() == 1) {
                                                            var3_9 = ThreadPool.access$1400();
                                                            synchronized (var3_9) {
                                                                if (!ThreadPool.access$1400().contains(threadPoolWorker.access$800(this.this$1))) {
                                                                    ThreadPool.access$1400().add(threadPoolWorker.access$800(this.this$1));
                                                                    if (!ThreadPool.access$1500()) {
                                                                        ThreadPool.access$1502(true);
                                                                        SimpleTimer.addPeriodicEvent("ThreadPool:timeout", 10000L, new TimerEventPerformer(this){
                                                                            private final /* synthetic */ 3 this$2;
                                                                            {
                                                                                this.this$2 = this$2;
                                                                            }

                                                                            public void perform(TimerEvent event2) {
                                                                                ThreadPool.checkAllTimeouts();
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        ** if (!(threadPoolWorker.access$400((threadPoolWorker)this.this$1) instanceof ThreadPoolTask)) goto lbl74
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        block58: {
                                                            tpt = (ThreadPoolTask)threadPoolWorker.access$400(this.this$1);
                                                            task_name = tpt.getName();
                                                            try {
                                                                if (task_name != null) {
                                                                    this.setName(threadPoolWorker.access$1600(this.this$1) + "{" + task_name + "}");
                                                                }
                                                                tpt.taskStarted();
                                                                threadPoolWorker.access$400(this.this$1).run();
                                                                var7_10 = null;
                                                                if (task_name == null) break block58;
                                                            }
                                                            catch (Throwable var6_15) {
                                                                var7_10 = null;
                                                                if (task_name != null) {
                                                                    this.setName(threadPoolWorker.access$1600(this.this$1));
                                                                }
                                                                tpt.taskCompleted();
                                                                throw var6_15;
                                                            }
                                                            this.setName(threadPoolWorker.access$1600(this.this$1));
                                                        }
                                                        tpt.taskCompleted();
                                                        break block59;
                                                    }
lbl74:
                                                    // 1 sources

                                                    threadPoolWorker.access$400(this.this$1).run();
                                                }
                                                catch (Throwable e) {
                                                    DebugLight.printStackTrace(e);
                                                    var9_11 = null;
                                                    var10_12 = threadPoolWorker.access$800(this.this$1);
                                                    synchronized (var10_12) {
                                                        elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$200(this.this$1);
                                                        if (elapsed > 10000L) {
                                                            // empty if block
                                                        }
                                                        ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                        if (ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).size() == 0 && !ThreadPool.access$000()) {
                                                            var13_14 = ThreadPool.access$1400();
                                                            synchronized (var13_14) {
                                                                ThreadPool.access$1400().remove(threadPoolWorker.access$800(this.this$1));
                                                            }
                                                        }
                                                        if (ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                            threadPoolWorker.access$402(this.this$1, (AERunnable)ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).remove(0));
                                                        } else {
                                                            threadPoolWorker.access$402(this.this$1, null);
                                                        }
                                                        continue;
                                                    }
                                                }
                                            }
                                            var9_11 = null;
                                        }
                                        catch (Throwable var8_16) {
                                            var9_11 = null;
                                            var10_12 = threadPoolWorker.access$800(this.this$1);
                                            synchronized (var10_12) {
                                                elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$200(this.this$1);
                                                if (elapsed > 10000L) {
                                                    // empty if block
                                                }
                                                ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                                if (ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).size() == 0 && !ThreadPool.access$000()) {
                                                    var13_14 = ThreadPool.access$1400();
                                                    synchronized (var13_14) {
                                                        ThreadPool.access$1400().remove(threadPoolWorker.access$800(this.this$1));
                                                    }
                                                }
                                                if (ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                    threadPoolWorker.access$402(this.this$1, (AERunnable)ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).remove(0));
                                                } else {
                                                    threadPoolWorker.access$402(this.this$1, null);
                                                }
                                                throw var8_16;
                                            }
                                        }
                                        var10_12 = threadPoolWorker.access$800(this.this$1);
                                        synchronized (var10_12) {
                                            elapsed = SystemTime.getCurrentTime() - threadPoolWorker.access$200(this.this$1);
                                            if (elapsed > 10000L) {
                                                // empty if block
                                            }
                                            ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).remove(this.this$1);
                                            if (ThreadPool.access$1300(threadPoolWorker.access$800(this.this$1)).size() == 0 && !ThreadPool.access$000()) {
                                                var13_14 = ThreadPool.access$1400();
                                                synchronized (var13_14) {
                                                    ThreadPool.access$1400().remove(threadPoolWorker.access$800(this.this$1));
                                                }
                                            }
                                            if (ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).size() > 0) {
                                                threadPoolWorker.access$402(this.this$1, (AERunnable)ThreadPool.access$1800(threadPoolWorker.access$800(this.this$1)).remove(0));
                                            } else {
                                                threadPoolWorker.access$402(this.this$1, null);
                                            }
                                        }
                                    }
                                    var17_2 = null;
                                    if (!time_to_die) ** break;
                                }
                            }
                            catch (Throwable e) {
                                DebugLight.printStackTrace(e);
                                var17_2 = null;
                                if (time_to_die) continue;
                                var18_7 = threadPoolWorker.access$800(this.this$1);
                                synchronized (var18_7) {
                                    if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).contains(this.this$1)) {
                                        Debug.out("Thread pool already contains worker!");
                                    }
                                    ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                                }
                                ThreadPool.access$1900(threadPoolWorker.access$800(this.this$1)).release();
                                continue;
                            }
                            var18_7 = threadPoolWorker.access$800(this.this$1);
                            synchronized (var18_7) {
                                if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).contains(this.this$1)) {
                                    Debug.out("Thread pool already contains worker!");
                                }
                                ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                            }
                            ThreadPool.access$1900(threadPoolWorker.access$800(this.this$1)).release();
                            continue;
                            break;
                        }
                    }
                    catch (Throwable var16_17) {
                        var17_3 = null;
                        if (time_to_die != false) throw var16_17;
                        var18_8 = threadPoolWorker.access$800(this.this$1);
                        synchronized (var18_8) {
                            if (ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).contains(this.this$1)) {
                                Debug.out("Thread pool already contains worker!");
                            }
                            ThreadPool.access$1200(threadPoolWorker.access$800(this.this$1)).push(this.this$1);
                        }
                        ThreadPool.access$1900(threadPoolWorker.access$800(this.this$1)).release();
                        throw var16_17;
                    }
                }
            };
            this.worker_thread.setDaemon(true);
            this.worker_thread.start();
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool getOwner() {
            return ThreadPool.this;
        }

        protected void run(AERunnable _runnable) {
            if (this.runnable != null) {
                Debug.out("Runnable already set");
            }
            this.runnable = _runnable;
            this.my_sem.release();
        }

        protected AERunnable getRunnable() {
            return this.runnable;
        }

        static /* synthetic */ ThreadPool access$800(threadPoolWorker x0) {
            return x0.ThreadPool.this;
        }

        static /* synthetic */ AESemaphore access$1100(threadPoolWorker x0) {
            return x0.my_sem;
        }

        static /* synthetic */ long access$202(threadPoolWorker x0, long x1) {
            x0.run_start_time = x1;
            return x0.run_start_time;
        }

        static /* synthetic */ int access$302(threadPoolWorker x0, int x1) {
            x0.warn_count = x1;
            return x0.warn_count;
        }

        static /* synthetic */ String access$1600(threadPoolWorker x0) {
            return x0.worker_name;
        }

        static /* synthetic */ String access$1700(threadPoolWorker x0) {
            return x0.state;
        }

        static /* synthetic */ AERunnable access$402(threadPoolWorker x0, AERunnable x1) {
            x0.runnable = x1;
            return x0.runnable;
        }
    }
}

