/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ConfigurationManager
implements AEDiagnosticsEvidenceGenerator {
    private static ConfigurationManager config_temp = null;
    private static ConfigurationManager config = null;
    private static AEMonitor class_mon = new AEMonitor("ConfigMan:class");
    private Map propertiesMap;
    private List listeners = new ArrayList();
    private Hashtable parameterListeners = new Hashtable();
    private AEMonitor this_mon = new AEMonitor("ConfigMan");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance() {
        try {
            class_mon.enter();
            if (config == null) {
                if (config_temp == null) {
                    config_temp = new ConfigurationManager();
                    config_temp.load();
                    config_temp.initialise();
                    config = config_temp;
                } else {
                    if (ConfigurationManager.config_temp.propertiesMap == null) {
                        config_temp.load();
                    }
                    ConfigurationManager configurationManager = config_temp;
                    return configurationManager;
                }
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance(Map data) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(data);
            }
            ConfigurationManager configurationManager = config;
            return configurationManager;
        }
        finally {
            class_mon.exit();
        }
    }

    private ConfigurationManager() {
    }

    private ConfigurationManager(Map data) {
        if (data.get("Logger.DebugFiles.Enabled") == null) {
            data.put("Logger.DebugFiles.Enabled", new Long(0L));
        }
        this.propertiesMap = data;
    }

    protected void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public void load(String filename) {
        Map data = FileUtil.readResilientConfigFile(filename, false);
        if (this.propertiesMap == null) {
            this.propertiesMap = data;
        }
    }

    public void load() {
        this.load("azureus.config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) {
        ArrayList listeners_copy;
        if (this.propertiesMap == null) {
            return;
        }
        FileUtil.writeResilientConfigFile(filename, this.propertiesMap);
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.listeners);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < listeners_copy.size(); ++i) {
            COConfigurationListener l = (COConfigurationListener)listeners_copy.get(i);
            if (l != null) {
                try {
                    l.configurationSaved();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue;
            }
            Debug.out("COConfigurationListener is null");
        }
    }

    public void save() {
        this.save("azureus.config");
    }

    public boolean getBooleanParameter(String parameter, boolean defaultValue) {
        int defaultInt = defaultValue ? 1 : 0;
        int result = this.getIntParameter(parameter, defaultInt);
        return result != 0;
    }

    public boolean getBooleanParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, def.def_boolean);
        }
        return result != 0;
    }

    public boolean setParameter(String parameter, boolean value) {
        return this.setParameter(parameter, value ? 1 : 0);
    }

    private Long getIntParameterRaw(String parameter) {
        try {
            return (Long)this.propertiesMap.get(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public int getIntParameter(String parameter, int defaultValue) {
        Long tempValue = this.getIntParameterRaw(parameter);
        return tempValue != null ? tempValue.intValue() : defaultValue;
    }

    public int getIntParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, def.def_int);
        }
        return result;
    }

    private byte[] getByteParameterRaw(String parameter) {
        return (byte[])this.propertiesMap.get(parameter);
    }

    public byte[] getByteParameter(String parameter, byte[] defaultValue) {
        byte[] tempValue = this.getByteParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    private String getStringParameter(String parameter, byte[] defaultValue) {
        byte[] bp = this.getByteParameter(parameter, defaultValue);
        if (bp == null) {
            bp = this.getByteParameter(parameter, null);
        }
        if (bp == null) {
            return null;
        }
        return ConfigurationManager.bytesToString(bp);
    }

    public String getStringParameter(String parameter, String defaultValue) {
        String tempValue = this.getStringParameter(parameter, (byte[])null);
        return tempValue != null ? tempValue : defaultValue;
    }

    public String getStringParameter(String parameter) {
        String result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getStringParameter(parameter, def.getStringParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getStringParameter(parameter, def.def_String);
        }
        return result;
    }

    public StringList getStringListParameter(String parameter) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return new StringListImpl();
            }
            return new StringListImpl(rawList);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return new StringListImpl();
        }
    }

    public boolean setParameter(String parameter, StringList value) {
        try {
            ArrayList<byte[]> encoded = new ArrayList<byte[]>();
            List l = ((StringListImpl)value).getList();
            for (int i = 0; i < l.size(); ++i) {
                encoded.add(ConfigurationManager.stringToBytes((String)l.get(i)));
            }
            this.propertiesMap.put(parameter, encoded);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public List getListParameter(String parameter, List def) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return def;
            }
            return rawList;
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return def;
        }
    }

    public boolean setParameter(String parameter, List value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public Map getMapParameter(String parameter, Map def) {
        try {
            Map map = (Map)this.propertiesMap.get(parameter);
            if (map == null) {
                return def;
            }
            return map;
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return def;
        }
    }

    public boolean setParameter(String parameter, Map value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String parameter) throws IOException {
        String dir = this.getStringParameter(parameter);
        if (dir.length() > 0) {
            File temp = new File(dir);
            if (!temp.exists()) {
                temp.mkdirs();
            } else if (!temp.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + dir);
            }
        }
        return dir;
    }

    public float getFloatParameter(String parameter) {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            Object o = this.propertiesMap.get(parameter);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String s = this.getStringParameter(parameter);
            if (!s.equals(def.def_String)) {
                return Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        try {
            return def.getFloatParameter(parameter);
        }
        catch (Exception e2) {
            return def.def_float;
        }
    }

    public boolean setParameter(String parameter, float defaultValue) {
        String newValue = String.valueOf(defaultValue);
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(newValue));
    }

    public boolean setParameter(String parameter, int defaultValue) {
        Long newValue = new Long(defaultValue);
        Long oldValue = this.propertiesMap.put(parameter, newValue);
        return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
    }

    public boolean setParameter(String parameter, byte[] defaultValue) {
        byte[] oldValue = this.propertiesMap.put(parameter, defaultValue);
        return this.notifyParameterListenersIfChanged(parameter, defaultValue, oldValue);
    }

    public boolean setParameter(String parameter, String defaultValue) {
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(defaultValue));
    }

    public boolean setRGBParameter(String parameter, int red, int green, int blue) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.setParameter(parameter + ".red", red);
        bAnyChanged |= this.setParameter(parameter + ".green", green);
        if (bAnyChanged |= this.setParameter(parameter + ".blue", blue)) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean setParameter(String parameter) throws ConfigurationParameterNotFoundException {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            return this.setParameter(parameter, def.getIntParameter(parameter));
        }
        catch (Exception e) {
            return this.setParameter(parameter, def.getStringParameter(parameter));
        }
    }

    public boolean removeParameter(String parameter) {
        boolean removed;
        boolean bl = removed = this.propertiesMap.remove(parameter) != null;
        if (removed) {
            this.notifyParameterListeners(parameter);
        }
        return removed;
    }

    public boolean removeRGBParameter(String parameter) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.removeParameter(parameter + ".red");
        bAnyChanged |= this.removeParameter(parameter + ".green");
        if (bAnyChanged |= this.removeParameter(parameter + ".blue")) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean doesParameterNonDefaultExist(String parameter) {
        return this.propertiesMap.containsKey(parameter);
    }

    private boolean notifyParameterListenersIfChanged(String parameter, Long newValue, Long oldValue) {
        if (oldValue == null || 0 != newValue.compareTo(oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String parameter, byte[] newValue, byte[] oldValue) {
        if (oldValue == null || !Arrays.equals(newValue, oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private void notifyParameterListeners(String parameter) {
        Vector parameterListener = (Vector)this.parameterListeners.get(parameter);
        if (parameterListener != null) {
            try {
                for (int i = 0; i < parameterListener.size(); ++i) {
                    ParameterListener listener = (ParameterListener)parameterListener.get(i);
                    if (listener == null) continue;
                    listener.parameterChanged(parameter);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                return;
            }
            Vector<ParameterListener> parameterListener = (Vector<ParameterListener>)this.parameterListeners.get(parameter);
            if (parameterListener == null) {
                parameterListener = new Vector<ParameterListener>();
                this.parameterListeners.put(parameter, parameterListener);
            }
            if (!parameterListener.contains(listener)) {
                parameterListener.add(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(String parameter, ParameterListener listener) {
        try {
            this.this_mon.enter();
            if (parameter == null || listener == null) {
                return;
            }
            Vector parameterListener = (Vector)this.parameterListeners.get(parameter);
            if (parameterListener != null) {
                parameterListener.remove(listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(COConfigurationListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Configuration Details");
        try {
            writer.indent();
            writer.println("System Properties");
            try {
                writer.indent();
                Properties props = System.getProperties();
                Iterator<Object> it = new TreeSet<Object>(props.keySet()).iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    writer.println(key + "=" + props.get(key));
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("Azureus Config");
            try {
                writer.indent();
                Iterator it = new TreeSet(this.propertiesMap.keySet()).iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = this.propertiesMap.get(key);
                    boolean bParamExists = ConfigurationDefaults.getInstance().doesParameterDefaultExist(key.toString());
                    if (!bParamExists) {
                        key = "[NoDef] " + key;
                    }
                    if (value instanceof Long) {
                        writer.println(key + "=" + value);
                        continue;
                    }
                    if (value instanceof List) {
                        writer.println(key + "=" + value + "[list]");
                        continue;
                    }
                    if (value instanceof Map) {
                        writer.println(key + "=" + value + "[map]");
                        continue;
                    }
                    if (value instanceof byte[]) {
                        byte[] b = (byte[])value;
                        boolean hex = false;
                        for (int i = 0; i < b.length; ++i) {
                            char c = (char)b[i];
                            if (Character.isLetterOrDigit(c) || "`\u00ac\"\u00a3$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) != -1) continue;
                            hex = true;
                            break;
                        }
                        writer.println(key + "=" + (hex ? ByteFormatter.nicePrint(b) : ConfigurationManager.bytesToString((byte[])value)));
                        continue;
                    }
                    writer.println(key + "=" + value + "[unknown]");
                }
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (Throwable e) {
            return new String(bytes);
        }
    }

    protected static byte[] stringToBytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (Throwable e) {
            return str.getBytes();
        }
    }
}

