/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Vec;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Coordinate {
    public static final byte VERSION_02 = 2;
    public static final byte CURRENT_VERSION = 2;
    protected static final int CLASS_HASH = Coordinate.class.hashCode();
    protected final double[] coords;

    protected static Coordinate add(Coordinate lhs, Vec rhs) {
        Coordinate sum = new Coordinate(lhs);
        sum.add(rhs);
        return sum;
    }

    protected static Coordinate subtract(Coordinate lhs, Vec rhs) {
        Coordinate diff = new Coordinate(lhs);
        diff.subtract(rhs);
        return diff;
    }

    public Coordinate makeCopy() {
        return new Coordinate(this.coords, true);
    }

    public Coordinate(int num_dimensions) {
        this.coords = new double[num_dimensions];
    }

    public Coordinate(int num_dimensions, ByteBuffer bb) {
        this.coords = new double[num_dimensions];
        if (bb.get() == 2) {
            for (int i = 0; i < num_dimensions; ++i) {
                this.coords[i] = bb.getDouble();
            }
        }
    }

    public Coordinate(int num_dimensions, DataInputStream dis) throws IOException {
        this.coords = new double[num_dimensions];
        byte version = dis.readByte();
        for (int i = 0; i < num_dimensions; ++i) {
            this.coords[i] = dis.readFloat();
        }
        if (version == 2) {
            // empty if block
        }
    }

    protected Coordinate(Coordinate c) {
        this(c.coords, true);
    }

    protected Coordinate(double[] init_pos, boolean make_copy) {
        if (make_copy) {
            int num_dims = init_pos.length;
            this.coords = new double[num_dims];
            System.arraycopy(init_pos, 0, this.coords, 0, num_dims);
        } else {
            this.coords = init_pos;
        }
    }

    public Coordinate(float[] init_pos) {
        int num_dims = init_pos.length;
        this.coords = new double[num_dims];
        for (int i = 0; i < num_dims; ++i) {
            this.coords[i] = init_pos[i];
        }
    }

    public void bumpFromAxes() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (!(Math.abs(this.coords[i]) < 0.1)) continue;
            double length = VivaldiClient.random.nextDouble();
            if (VivaldiClient.random.nextBoolean()) {
                length *= -1.0;
            }
            this.coords[i] = length;
        }
    }

    public int getNumDimensions() {
        return this.coords.length;
    }

    public void toSerialized(ByteBuffer bb) {
        int num_dims = this.coords.length;
        bb.put((byte)2);
        for (int i = 0; i < num_dims; ++i) {
            bb.putDouble(this.coords[i]);
        }
    }

    public void toSerialized(DataOutputStream dos) throws IOException {
        int num_dims = this.coords.length;
        dos.writeByte(2);
        for (int i = 0; i < num_dims; ++i) {
            dos.writeFloat((float)this.coords[i]);
        }
    }

    public double distanceTo(Coordinate c) {
        if (c == null) {
            return -1.0;
        }
        double sum = 0.0;
        int num_dims = this.coords.length;
        for (int i = 0; i < num_dims; ++i) {
            double abs_dist = this.coords[i] - c.coords[i];
            sum += abs_dist * abs_dist;
        }
        return Math.sqrt(sum);
    }

    public void add(Vec v) {
        int num_dims = this.coords.length;
        for (int i = 0; i < num_dims; ++i) {
            int n = i;
            this.coords[n] = this.coords[n] + v.direction[i];
        }
    }

    public void subtract(Vec v) {
        int num_dims = this.coords.length;
        for (int i = 0; i < num_dims; ++i) {
            int n = i;
            this.coords[n] = this.coords[n] - v.direction[i];
        }
    }

    protected Vec subtract(Coordinate c) {
        int num_dims = this.coords.length;
        Vec new_vec = new Vec(num_dims);
        for (int i = 0; i < num_dims; ++i) {
            new_vec.direction[i] = this.coords[i] - c.coords[i];
        }
        return new_vec;
    }

    protected boolean assign(Coordinate c) {
        if (this.coords.length != c.coords.length) {
            return false;
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = c.coords[i];
        }
        return true;
    }

    public boolean atOrigin() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public Vec asVectorFromZero(boolean make_copy) {
        return new Vec(this.coords, make_copy);
    }

    public boolean isValid() {
        double NEG_MAX_DIST_FROM_ORIGIN = -1.0 * VivaldiClient.MAX_DIST_FROM_ORIGIN;
        for (int i = 0; i < this.coords.length; ++i) {
            if (Double.isNaN(this.coords[i])) {
                return false;
            }
            if (!(this.coords[i] > VivaldiClient.MAX_DIST_FROM_ORIGIN) && !(this.coords[i] < NEG_MAX_DIST_FROM_ORIGIN)) continue;
            return false;
        }
        return true;
    }

    protected void reset() {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = 0.0;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            Coordinate c = (Coordinate)obj;
            int num_dims = this.coords.length;
            for (int i = 0; i < num_dims; ++i) {
                if (this.coords[i] == c.coords[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int num_dims = this.coords.length;
        int hc = CLASS_HASH;
        for (int i = 0; i < num_dims; ++i) {
            hc ^= new Double(this.coords[i]).hashCode();
        }
        return hc;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(1024);
        sbuf.append("[");
        int num_dims = this.coords.length;
        int i = 0;
        while (true) {
            sbuf.append(VivaldiClient.nf.format(this.coords[i]));
            if (++i >= num_dims) break;
            sbuf.append(",");
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public String toStringAsVector() {
        StringBuffer sbuf = new StringBuffer(1024);
        for (int i = 0; i < this.coords.length; ++i) {
            sbuf.append(VivaldiClient.nf.format(this.coords[i]));
            if (i == this.coords.length - 1) continue;
            sbuf.append(" ");
        }
        return sbuf.toString();
    }
}

