/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import com.aelitis.azureus.vivaldi.ver2.SyrahPosition;
import com.aelitis.azureus.vivaldi.ver2.VivaldiV2PositionProvider;
import edu.harvard.syrah.nc.Coordinate;

class LocalPosition
extends SyrahPosition {
    private final VivaldiV2PositionProvider v2_provider;

    protected LocalPosition(VivaldiV2PositionProvider _v2_provider) {
        this.v2_provider = _v2_provider;
    }

    public Coordinate getCoords() {
        return this.v2_provider.getCoords();
    }

    public Coordinate getStableCoords() {
        return this.v2_provider.getStableCoords();
    }

    public float getError() {
        return this.v2_provider.getError();
    }

    public long getAge() {
        return this.v2_provider.getAge();
    }

    public float estimateRTT(DHTNetworkPosition other) {
        SyrahPosition sp = (SyrahPosition)other;
        return (float)this.v2_provider.getCoords().distanceTo(sp.getCoords());
    }

    public void update(byte[] other_id, DHTNetworkPosition other, float rtt) {
        this.v2_provider.update(this, new IDWrapper(other_id), (SyrahPosition)other, rtt);
    }
}

