/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZSessionHave
implements AZMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int session_id;
    private final int[] piece_numbers;

    public AZSessionHave(int session_id, int[] piece_numbers) {
        this.session_id = session_id;
        this.piece_numbers = piece_numbers;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public int[] getPieceNumbers() {
        return this.piece_numbers;
    }

    public String getID() {
        return "AZ_SESSION_HAVE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_SESSION_HAVE_BYTES;
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            String numbers = "";
            for (int i = 0; i < this.piece_numbers.length; ++i) {
                numbers = numbers + " #" + this.piece_numbers[i];
            }
            this.description = this.getID() + " session #" + this.session_id + " pieces" + numbers;
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.buffer = DirectByteBufferPool.getBuffer((byte)12, 4 + this.piece_numbers.length * 4);
            this.buffer.putInt((byte)11, this.session_id);
            for (int i = 0; i < this.piece_numbers.length; ++i) {
                this.buffer.putInt((byte)11, this.piece_numbers[i]);
            }
            this.buffer.flip((byte)11);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) < 8) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] < 8");
        }
        int id = data.getInt((byte)11);
        if (data.remaining((byte)11) % 4 != 0) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] % 4 != 0");
        }
        int[] numbers = new int[data.remaining((byte)11) / 4];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = data.getInt((byte)11);
            if (numbers[i] >= 0) continue;
            throw new MessageException("[" + this.getID() + "] decode error: number < 0");
        }
        data.returnToPool();
        return new AZSessionHave(id, numbers);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

