/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TransportStats {
    private static final int PRINT_INTERVAL = 60000;
    private static final int GRANULARITY = 10;
    private final TreeMap read_sizes = new TreeMap();
    private final TreeMap write_sizes = new TreeMap();
    private long total_reads = 0L;
    private long total_writes = 0L;

    public TransportStats() {
        Timer printer = new Timer("TransportStats:Printer");
        printer.addPeriodicEvent(60000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                TransportStats.this.printStats();
            }
        });
    }

    public void bytesRead(int num_bytes_read) {
        ++this.total_reads;
        this.updateSizes(this.read_sizes, num_bytes_read);
    }

    public void bytesWritten(int num_bytes_written) {
        ++this.total_writes;
        this.updateSizes(this.write_sizes, num_bytes_written);
    }

    private void updateSizes(TreeMap io_sizes, int num_bytes) {
        Integer size_key = num_bytes == 0 ? new Integer(0) : new Integer(num_bytes / 10 + 1);
        Long count = (Long)io_sizes.get(size_key);
        if (count == null) {
            io_sizes.put(size_key, new Long(1L));
        } else {
            io_sizes.put(size_key, new Long(count + 1L));
        }
    }

    private void printStats() {
        System.out.println("\n------------------------------");
        System.out.println("***** TCP SOCKET READ SIZE STATS *****");
        this.printSizes(this.read_sizes, this.total_reads);
        System.out.println("\n***** TCP SOCKET WRITE SIZE STATS *****");
        this.printSizes(this.write_sizes, this.total_writes);
        System.out.println("------------------------------");
    }

    private void printSizes(TreeMap size_map, long num_total) {
        int prev_high = 1;
        Iterator it = size_map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int key = (Integer)entry.getKey();
            long count = (Long)entry.getValue();
            long percentage = count * 100L / num_total;
            if (key == 0) {
                if (percentage <= 3L) continue;
                System.out.println("[0 bytes]= x" + percentage + "%");
                continue;
            }
            int high = key * 10;
            if (percentage > 3L) {
                System.out.println("[" + prev_high + "-" + (high - 1) + " bytes]= x" + percentage + "%");
            }
            prev_high = high;
        }
    }
}

